// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package emr

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/defaults"
	"github.com/aws/aws-sdk-go/aws/service"
	"github.com/aws/aws-sdk-go/internal/protocol/jsonrpc"
	"github.com/aws/aws-sdk-go/internal/signer/v4"
)

// Amazon Elastic MapReduce (Amazon EMR) is a web service that makes it easy
// to process large amounts of data efficiently. Amazon EMR uses Hadoop processing
// combined with several AWS products to do tasks such as web indexing, data
// mining, log file analysis, machine learning, scientific simulation, and data
// warehousing.
type EMR struct {
	*service.Service
}

// Used for custom service initialization logic
var initService func(*service.Service)

// Used for custom request initialization logic
var initRequest func(*service.Request)

// New returns a new EMR client.
func New(config *aws.Config) *EMR {
	service := &service.Service{
		Config:       defaults.DefaultConfig.Merge(config),
		ServiceName:  "elasticmapreduce",
		APIVersion:   "2009-03-31",
		JSONVersion:  "1.1",
		TargetPrefix: "ElasticMapReduce",
	}
	service.Initialize()

	// Handlers
	service.Handlers.Sign.PushBack(v4.Sign)
	service.Handlers.Build.PushBack(jsonrpc.Build)
	service.Handlers.Unmarshal.PushBack(jsonrpc.Unmarshal)
	service.Handlers.UnmarshalMeta.PushBack(jsonrpc.UnmarshalMeta)
	service.Handlers.UnmarshalError.PushBack(jsonrpc.UnmarshalError)

	// Run custom service initialization if present
	if initService != nil {
		initService(service)
	}

	return &EMR{service}
}

// newRequest creates a new request for a EMR operation and runs any
// custom request initialization.
func (c *EMR) newRequest(op *service.Operation, params, data interface{}) *service.Request {
	req := service.NewRequest(c.Service, op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
