// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package machinelearning provides a client for Amazon Machine Learning.
package machinelearning

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/service"
)

const opCreateBatchPrediction = "CreateBatchPrediction"

// CreateBatchPredictionRequest generates a request for the CreateBatchPrediction operation.
func (c *MachineLearning) CreateBatchPredictionRequest(input *CreateBatchPredictionInput) (req *service.Request, output *CreateBatchPredictionOutput) {
	op := &service.Operation{
		Name:       opCreateBatchPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBatchPredictionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateBatchPredictionOutput{}
	req.Data = output
	return
}

// Generates predictions for a group of observations. The observations to process
// exist in one or more data files referenced by a DataSource. This operation
// creates a new BatchPrediction, and uses an MLModel and the data files referenced
// by the DataSource as information sources.
//
// CreateBatchPrediction is an asynchronous operation. In response to CreateBatchPrediction,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the BatchPrediction
// status to PENDING. After the BatchPrediction completes, Amazon ML sets the
// status to COMPLETED.
//
// You can poll for status updates by using the GetBatchPrediction operation
// and checking the Status parameter of the result. After the COMPLETED status
// appears, the results are available in the location specified by the OutputUri
// parameter.
func (c *MachineLearning) CreateBatchPrediction(input *CreateBatchPredictionInput) (*CreateBatchPredictionOutput, error) {
	req, out := c.CreateBatchPredictionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDataSourceFromRDS = "CreateDataSourceFromRDS"

// CreateDataSourceFromRDSRequest generates a request for the CreateDataSourceFromRDS operation.
func (c *MachineLearning) CreateDataSourceFromRDSRequest(input *CreateDataSourceFromRDSInput) (req *service.Request, output *CreateDataSourceFromRDSOutput) {
	op := &service.Operation{
		Name:       opCreateDataSourceFromRDS,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataSourceFromRDSInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDataSourceFromRDSOutput{}
	req.Data = output
	return
}

// Creates a DataSource object from an  Amazon Relational Database Service (http://aws.amazon.com/rds/)
// (Amazon RDS). A DataSource references data that can be used to perform CreateMLModel,
// CreateEvaluation, or CreateBatchPrediction operations.
//
// CreateDataSourceFromRDS is an asynchronous operation. In response to CreateDataSourceFromRDS,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the DataSource
// status to PENDING. After the DataSource is created and ready for use, Amazon
// ML sets the Status parameter to COMPLETED. DataSource in COMPLETED or PENDING
// status can only be used to perform CreateMLModel, CreateEvaluation, or CreateBatchPrediction
// operations.
//
//  If Amazon ML cannot accept the input source, it sets the Status parameter
// to FAILED and includes an error message in the Message attribute of the GetDataSource
// operation response.
func (c *MachineLearning) CreateDataSourceFromRDS(input *CreateDataSourceFromRDSInput) (*CreateDataSourceFromRDSOutput, error) {
	req, out := c.CreateDataSourceFromRDSRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDataSourceFromRedshift = "CreateDataSourceFromRedshift"

// CreateDataSourceFromRedshiftRequest generates a request for the CreateDataSourceFromRedshift operation.
func (c *MachineLearning) CreateDataSourceFromRedshiftRequest(input *CreateDataSourceFromRedshiftInput) (req *service.Request, output *CreateDataSourceFromRedshiftOutput) {
	op := &service.Operation{
		Name:       opCreateDataSourceFromRedshift,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataSourceFromRedshiftInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDataSourceFromRedshiftOutput{}
	req.Data = output
	return
}

// Creates a DataSource from Amazon Redshift (http://aws.amazon.com/redshift/).
// A DataSource references data that can be used to perform either CreateMLModel,
// CreateEvaluation or CreateBatchPrediction operations.
//
// CreateDataSourceFromRedshift is an asynchronous operation. In response to
// CreateDataSourceFromRedshift, Amazon Machine Learning (Amazon ML) immediately
// returns and sets the DataSource status to PENDING. After the DataSource is
// created and ready for use, Amazon ML sets the Status parameter to COMPLETED.
// DataSource in COMPLETED or PENDING status can only be used to perform CreateMLModel,
// CreateEvaluation, or CreateBatchPrediction operations.
//
//  If Amazon ML cannot accept the input source, it sets the Status parameter
// to FAILED and includes an error message in the Message attribute of the GetDataSource
// operation response.
//
// The observations should exist in the database hosted on an Amazon Redshift
// cluster and should be specified by a SelectSqlQuery. Amazon ML executes
// Unload (http://docs.aws.amazon.com/redshift/latest/dg/t_Unloading_tables.html)
// command in Amazon Redshift to transfer the result set of SelectSqlQuery to
// S3StagingLocation.
//
// After the DataSource is created, it's ready for use in evaluations and batch
// predictions. If you plan to use the DataSource to train an MLModel, the DataSource
// requires another item -- a recipe. A recipe describes the observation variables
// that participate in training an MLModel. A recipe describes how each input
// variable will be used in training. Will the variable be included or excluded
// from training? Will the variable be manipulated, for example, combined with
// another variable or split apart into word combinations? The recipe provides
// answers to these questions. For more information, see the Amazon Machine
// Learning Developer Guide.
func (c *MachineLearning) CreateDataSourceFromRedshift(input *CreateDataSourceFromRedshiftInput) (*CreateDataSourceFromRedshiftOutput, error) {
	req, out := c.CreateDataSourceFromRedshiftRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDataSourceFromS3 = "CreateDataSourceFromS3"

// CreateDataSourceFromS3Request generates a request for the CreateDataSourceFromS3 operation.
func (c *MachineLearning) CreateDataSourceFromS3Request(input *CreateDataSourceFromS3Input) (req *service.Request, output *CreateDataSourceFromS3Output) {
	op := &service.Operation{
		Name:       opCreateDataSourceFromS3,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDataSourceFromS3Input{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDataSourceFromS3Output{}
	req.Data = output
	return
}

// Creates a DataSource object. A DataSource references data that can be used
// to perform CreateMLModel, CreateEvaluation, or CreateBatchPrediction operations.
//
// CreateDataSourceFromS3 is an asynchronous operation. In response to CreateDataSourceFromS3,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the DataSource
// status to PENDING. After the DataSource is created and ready for use, Amazon
// ML sets the Status parameter to COMPLETED. DataSource in COMPLETED or PENDING
// status can only be used to perform CreateMLModel, CreateEvaluation or CreateBatchPrediction
// operations.
//
//  If Amazon ML cannot accept the input source, it sets the Status parameter
// to FAILED and includes an error message in the Message attribute of the GetDataSource
// operation response.
//
// The observation data used in a DataSource should be ready to use; that is,
// it should have a consistent structure, and missing data values should be
// kept to a minimum. The observation data must reside in one or more CSV files
// in an Amazon Simple Storage Service (Amazon S3) bucket, along with a schema
// that describes the data items by name and type. The same schema must be used
// for all of the data files referenced by the DataSource.
//
// After the DataSource has been created, it's ready to use in evaluations
// and batch predictions. If you plan to use the DataSource to train an MLModel,
// the DataSource requires another item: a recipe. A recipe describes the observation
// variables that participate in training an MLModel. A recipe describes how
// each input variable will be used in training. Will the variable be included
// or excluded from training? Will the variable be manipulated, for example,
// combined with another variable, or split apart into word combinations? The
// recipe provides answers to these questions. For more information, see the
// Amazon Machine Learning Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
func (c *MachineLearning) CreateDataSourceFromS3(input *CreateDataSourceFromS3Input) (*CreateDataSourceFromS3Output, error) {
	req, out := c.CreateDataSourceFromS3Request(input)
	err := req.Send()
	return out, err
}

const opCreateEvaluation = "CreateEvaluation"

// CreateEvaluationRequest generates a request for the CreateEvaluation operation.
func (c *MachineLearning) CreateEvaluationRequest(input *CreateEvaluationInput) (req *service.Request, output *CreateEvaluationOutput) {
	op := &service.Operation{
		Name:       opCreateEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEvaluationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateEvaluationOutput{}
	req.Data = output
	return
}

// Creates a new Evaluation of an MLModel. An MLModel is evaluated on a set
// of observations associated to a DataSource. Like a DataSource for an MLModel,
// the DataSource for an Evaluation contains values for the Target Variable.
// The Evaluation compares the predicted result for each observation to the
// actual outcome and provides a summary so that you know how effective the
// MLModel functions on the test data. Evaluation generates a relevant performance
// metric such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on
// the corresponding MLModelType: BINARY, REGRESSION or MULTICLASS.
//
// CreateEvaluation is an asynchronous operation. In response to CreateEvaluation,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation
// status to PENDING. After the Evaluation is created and ready for use, Amazon
// ML sets the status to COMPLETED.
//
// You can use the GetEvaluation operation to check progress of the evaluation
// during the creation operation.
func (c *MachineLearning) CreateEvaluation(input *CreateEvaluationInput) (*CreateEvaluationOutput, error) {
	req, out := c.CreateEvaluationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateMLModel = "CreateMLModel"

// CreateMLModelRequest generates a request for the CreateMLModel operation.
func (c *MachineLearning) CreateMLModelRequest(input *CreateMLModelInput) (req *service.Request, output *CreateMLModelOutput) {
	op := &service.Operation{
		Name:       opCreateMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMLModelInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateMLModelOutput{}
	req.Data = output
	return
}

// Creates a new MLModel using the data files and the recipe as information
// sources.
//
// An MLModel is nearly immutable. Users can only update the MLModelName and
// the ScoreThreshold in an MLModel without creating a new MLModel.
//
// CreateMLModel is an asynchronous operation. In response to CreateMLModel,
// Amazon Machine Learning (Amazon ML) immediately returns and sets the MLModel
// status to PENDING. After the MLModel is created and ready for use, Amazon
// ML sets the status to COMPLETED.
//
// You can use the GetMLModel operation to check progress of the MLModel during
// the creation operation.
//
//  CreateMLModel requires a DataSource with computed statistics, which can
// be created by setting ComputeStatistics to true in CreateDataSourceFromRDS,
// CreateDataSourceFromS3, or CreateDataSourceFromRedshift operations.
func (c *MachineLearning) CreateMLModel(input *CreateMLModelInput) (*CreateMLModelOutput, error) {
	req, out := c.CreateMLModelRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRealtimeEndpoint = "CreateRealtimeEndpoint"

// CreateRealtimeEndpointRequest generates a request for the CreateRealtimeEndpoint operation.
func (c *MachineLearning) CreateRealtimeEndpointRequest(input *CreateRealtimeEndpointInput) (req *service.Request, output *CreateRealtimeEndpointOutput) {
	op := &service.Operation{
		Name:       opCreateRealtimeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRealtimeEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateRealtimeEndpointOutput{}
	req.Data = output
	return
}

// Creates a real-time endpoint for the MLModel. The endpoint contains the URI
// of the MLModel; that is, the location to send real-time prediction requests
// for the specified MLModel.
func (c *MachineLearning) CreateRealtimeEndpoint(input *CreateRealtimeEndpointInput) (*CreateRealtimeEndpointOutput, error) {
	req, out := c.CreateRealtimeEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBatchPrediction = "DeleteBatchPrediction"

// DeleteBatchPredictionRequest generates a request for the DeleteBatchPrediction operation.
func (c *MachineLearning) DeleteBatchPredictionRequest(input *DeleteBatchPredictionInput) (req *service.Request, output *DeleteBatchPredictionOutput) {
	op := &service.Operation{
		Name:       opDeleteBatchPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBatchPredictionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBatchPredictionOutput{}
	req.Data = output
	return
}

// Assigns the DELETED status to a BatchPrediction, rendering it unusable.
//
// After using the DeleteBatchPrediction operation, you can use the GetBatchPrediction
// operation to verify that the status of the BatchPrediction changed to DELETED.
//
// Caution The result of the DeleteBatchPrediction operation is irreversible.
func (c *MachineLearning) DeleteBatchPrediction(input *DeleteBatchPredictionInput) (*DeleteBatchPredictionOutput, error) {
	req, out := c.DeleteBatchPredictionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDataSource = "DeleteDataSource"

// DeleteDataSourceRequest generates a request for the DeleteDataSource operation.
func (c *MachineLearning) DeleteDataSourceRequest(input *DeleteDataSourceInput) (req *service.Request, output *DeleteDataSourceOutput) {
	op := &service.Operation{
		Name:       opDeleteDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDataSourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDataSourceOutput{}
	req.Data = output
	return
}

// Assigns the DELETED status to a DataSource, rendering it unusable.
//
// After using the DeleteDataSource operation, you can use the GetDataSource
// operation to verify that the status of the DataSource changed to DELETED.
//
// Caution The results of the DeleteDataSource operation are irreversible.
func (c *MachineLearning) DeleteDataSource(input *DeleteDataSourceInput) (*DeleteDataSourceOutput, error) {
	req, out := c.DeleteDataSourceRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEvaluation = "DeleteEvaluation"

// DeleteEvaluationRequest generates a request for the DeleteEvaluation operation.
func (c *MachineLearning) DeleteEvaluationRequest(input *DeleteEvaluationInput) (req *service.Request, output *DeleteEvaluationOutput) {
	op := &service.Operation{
		Name:       opDeleteEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEvaluationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteEvaluationOutput{}
	req.Data = output
	return
}

// Assigns the DELETED status to an Evaluation, rendering it unusable.
//
// After invoking the DeleteEvaluation operation, you can use the GetEvaluation
// operation to verify that the status of the Evaluation changed to DELETED.
//
// Caution The results of the DeleteEvaluation operation are irreversible.
func (c *MachineLearning) DeleteEvaluation(input *DeleteEvaluationInput) (*DeleteEvaluationOutput, error) {
	req, out := c.DeleteEvaluationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteMLModel = "DeleteMLModel"

// DeleteMLModelRequest generates a request for the DeleteMLModel operation.
func (c *MachineLearning) DeleteMLModelRequest(input *DeleteMLModelInput) (req *service.Request, output *DeleteMLModelOutput) {
	op := &service.Operation{
		Name:       opDeleteMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMLModelInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteMLModelOutput{}
	req.Data = output
	return
}

// Assigns the DELETED status to an MLModel, rendering it unusable.
//
// After using the DeleteMLModel operation, you can use the GetMLModel operation
// to verify that the status of the MLModel changed to DELETED.
//
// Caution The result of the DeleteMLModel operation is irreversible.
func (c *MachineLearning) DeleteMLModel(input *DeleteMLModelInput) (*DeleteMLModelOutput, error) {
	req, out := c.DeleteMLModelRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRealtimeEndpoint = "DeleteRealtimeEndpoint"

// DeleteRealtimeEndpointRequest generates a request for the DeleteRealtimeEndpoint operation.
func (c *MachineLearning) DeleteRealtimeEndpointRequest(input *DeleteRealtimeEndpointInput) (req *service.Request, output *DeleteRealtimeEndpointOutput) {
	op := &service.Operation{
		Name:       opDeleteRealtimeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRealtimeEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRealtimeEndpointOutput{}
	req.Data = output
	return
}

// Deletes a real time endpoint of an MLModel.
func (c *MachineLearning) DeleteRealtimeEndpoint(input *DeleteRealtimeEndpointInput) (*DeleteRealtimeEndpointOutput, error) {
	req, out := c.DeleteRealtimeEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeBatchPredictions = "DescribeBatchPredictions"

// DescribeBatchPredictionsRequest generates a request for the DescribeBatchPredictions operation.
func (c *MachineLearning) DescribeBatchPredictionsRequest(input *DescribeBatchPredictionsInput) (req *service.Request, output *DescribeBatchPredictionsOutput) {
	op := &service.Operation{
		Name:       opDescribeBatchPredictions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeBatchPredictionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeBatchPredictionsOutput{}
	req.Data = output
	return
}

// Returns a list of BatchPrediction operations that match the search criteria
// in the request.
func (c *MachineLearning) DescribeBatchPredictions(input *DescribeBatchPredictionsInput) (*DescribeBatchPredictionsOutput, error) {
	req, out := c.DescribeBatchPredictionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *MachineLearning) DescribeBatchPredictionsPages(input *DescribeBatchPredictionsInput, fn func(p *DescribeBatchPredictionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeBatchPredictionsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeBatchPredictionsOutput), lastPage)
	})
}

const opDescribeDataSources = "DescribeDataSources"

// DescribeDataSourcesRequest generates a request for the DescribeDataSources operation.
func (c *MachineLearning) DescribeDataSourcesRequest(input *DescribeDataSourcesInput) (req *service.Request, output *DescribeDataSourcesOutput) {
	op := &service.Operation{
		Name:       opDescribeDataSources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDataSourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDataSourcesOutput{}
	req.Data = output
	return
}

// Returns a list of DataSource that match the search criteria in the request.
func (c *MachineLearning) DescribeDataSources(input *DescribeDataSourcesInput) (*DescribeDataSourcesOutput, error) {
	req, out := c.DescribeDataSourcesRequest(input)
	err := req.Send()
	return out, err
}

func (c *MachineLearning) DescribeDataSourcesPages(input *DescribeDataSourcesInput, fn func(p *DescribeDataSourcesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeDataSourcesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeDataSourcesOutput), lastPage)
	})
}

const opDescribeEvaluations = "DescribeEvaluations"

// DescribeEvaluationsRequest generates a request for the DescribeEvaluations operation.
func (c *MachineLearning) DescribeEvaluationsRequest(input *DescribeEvaluationsInput) (req *service.Request, output *DescribeEvaluationsOutput) {
	op := &service.Operation{
		Name:       opDescribeEvaluations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEvaluationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEvaluationsOutput{}
	req.Data = output
	return
}

// Returns a list of DescribeEvaluations that match the search criteria in the
// request.
func (c *MachineLearning) DescribeEvaluations(input *DescribeEvaluationsInput) (*DescribeEvaluationsOutput, error) {
	req, out := c.DescribeEvaluationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *MachineLearning) DescribeEvaluationsPages(input *DescribeEvaluationsInput, fn func(p *DescribeEvaluationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEvaluationsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEvaluationsOutput), lastPage)
	})
}

const opDescribeMLModels = "DescribeMLModels"

// DescribeMLModelsRequest generates a request for the DescribeMLModels operation.
func (c *MachineLearning) DescribeMLModelsRequest(input *DescribeMLModelsInput) (req *service.Request, output *DescribeMLModelsOutput) {
	op := &service.Operation{
		Name:       opDescribeMLModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeMLModelsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeMLModelsOutput{}
	req.Data = output
	return
}

// Returns a list of MLModel that match the search criteria in the request.
func (c *MachineLearning) DescribeMLModels(input *DescribeMLModelsInput) (*DescribeMLModelsOutput, error) {
	req, out := c.DescribeMLModelsRequest(input)
	err := req.Send()
	return out, err
}

func (c *MachineLearning) DescribeMLModelsPages(input *DescribeMLModelsInput, fn func(p *DescribeMLModelsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeMLModelsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeMLModelsOutput), lastPage)
	})
}

const opGetBatchPrediction = "GetBatchPrediction"

// GetBatchPredictionRequest generates a request for the GetBatchPrediction operation.
func (c *MachineLearning) GetBatchPredictionRequest(input *GetBatchPredictionInput) (req *service.Request, output *GetBatchPredictionOutput) {
	op := &service.Operation{
		Name:       opGetBatchPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetBatchPredictionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetBatchPredictionOutput{}
	req.Data = output
	return
}

// Returns a BatchPrediction that includes detailed metadata, status, and data
// file information for a Batch Prediction request.
func (c *MachineLearning) GetBatchPrediction(input *GetBatchPredictionInput) (*GetBatchPredictionOutput, error) {
	req, out := c.GetBatchPredictionRequest(input)
	err := req.Send()
	return out, err
}

const opGetDataSource = "GetDataSource"

// GetDataSourceRequest generates a request for the GetDataSource operation.
func (c *MachineLearning) GetDataSourceRequest(input *GetDataSourceInput) (req *service.Request, output *GetDataSourceOutput) {
	op := &service.Operation{
		Name:       opGetDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDataSourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDataSourceOutput{}
	req.Data = output
	return
}

// Returns a DataSource that includes metadata and data file information, as
// well as the current status of the DataSource.
//
// GetDataSource provides results in normal or verbose format. The verbose
// format adds the schema description and the list of files pointed to by the
// DataSource to the normal format.
func (c *MachineLearning) GetDataSource(input *GetDataSourceInput) (*GetDataSourceOutput, error) {
	req, out := c.GetDataSourceRequest(input)
	err := req.Send()
	return out, err
}

const opGetEvaluation = "GetEvaluation"

// GetEvaluationRequest generates a request for the GetEvaluation operation.
func (c *MachineLearning) GetEvaluationRequest(input *GetEvaluationInput) (req *service.Request, output *GetEvaluationOutput) {
	op := &service.Operation{
		Name:       opGetEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEvaluationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetEvaluationOutput{}
	req.Data = output
	return
}

// Returns an Evaluation that includes metadata as well as the current status
// of the Evaluation.
func (c *MachineLearning) GetEvaluation(input *GetEvaluationInput) (*GetEvaluationOutput, error) {
	req, out := c.GetEvaluationRequest(input)
	err := req.Send()
	return out, err
}

const opGetMLModel = "GetMLModel"

// GetMLModelRequest generates a request for the GetMLModel operation.
func (c *MachineLearning) GetMLModelRequest(input *GetMLModelInput) (req *service.Request, output *GetMLModelOutput) {
	op := &service.Operation{
		Name:       opGetMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMLModelInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetMLModelOutput{}
	req.Data = output
	return
}

// Returns an MLModel that includes detailed metadata, and data source information
// as well as the current status of the MLModel.
//
// GetMLModel provides results in normal or verbose format.
func (c *MachineLearning) GetMLModel(input *GetMLModelInput) (*GetMLModelOutput, error) {
	req, out := c.GetMLModelRequest(input)
	err := req.Send()
	return out, err
}

const opPredict = "Predict"

// PredictRequest generates a request for the Predict operation.
func (c *MachineLearning) PredictRequest(input *PredictInput) (req *service.Request, output *PredictOutput) {
	op := &service.Operation{
		Name:       opPredict,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PredictInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PredictOutput{}
	req.Data = output
	return
}

// Generates a prediction for the observation using the specified MLModel.
//
// Note Not all response parameters will be populated because this is dependent
// on the type of requested model.
func (c *MachineLearning) Predict(input *PredictInput) (*PredictOutput, error) {
	req, out := c.PredictRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateBatchPrediction = "UpdateBatchPrediction"

// UpdateBatchPredictionRequest generates a request for the UpdateBatchPrediction operation.
func (c *MachineLearning) UpdateBatchPredictionRequest(input *UpdateBatchPredictionInput) (req *service.Request, output *UpdateBatchPredictionOutput) {
	op := &service.Operation{
		Name:       opUpdateBatchPrediction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBatchPredictionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateBatchPredictionOutput{}
	req.Data = output
	return
}

// Updates the BatchPredictionName of a BatchPrediction.
//
// You can use the GetBatchPrediction operation to view the contents of the
// updated data element.
func (c *MachineLearning) UpdateBatchPrediction(input *UpdateBatchPredictionInput) (*UpdateBatchPredictionOutput, error) {
	req, out := c.UpdateBatchPredictionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest generates a request for the UpdateDataSource operation.
func (c *MachineLearning) UpdateDataSourceRequest(input *UpdateDataSourceInput) (req *service.Request, output *UpdateDataSourceOutput) {
	op := &service.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDataSourceOutput{}
	req.Data = output
	return
}

// Updates the DataSourceName of a DataSource.
//
// You can use the GetDataSource operation to view the contents of the updated
// data element.
func (c *MachineLearning) UpdateDataSource(input *UpdateDataSourceInput) (*UpdateDataSourceOutput, error) {
	req, out := c.UpdateDataSourceRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateEvaluation = "UpdateEvaluation"

// UpdateEvaluationRequest generates a request for the UpdateEvaluation operation.
func (c *MachineLearning) UpdateEvaluationRequest(input *UpdateEvaluationInput) (req *service.Request, output *UpdateEvaluationOutput) {
	op := &service.Operation{
		Name:       opUpdateEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEvaluationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateEvaluationOutput{}
	req.Data = output
	return
}

// Updates the EvaluationName of an Evaluation.
//
// You can use the GetEvaluation operation to view the contents of the updated
// data element.
func (c *MachineLearning) UpdateEvaluation(input *UpdateEvaluationInput) (*UpdateEvaluationOutput, error) {
	req, out := c.UpdateEvaluationRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateMLModel = "UpdateMLModel"

// UpdateMLModelRequest generates a request for the UpdateMLModel operation.
func (c *MachineLearning) UpdateMLModelRequest(input *UpdateMLModelInput) (req *service.Request, output *UpdateMLModelOutput) {
	op := &service.Operation{
		Name:       opUpdateMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMLModelInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateMLModelOutput{}
	req.Data = output
	return
}

// Updates the MLModelName and the ScoreThreshold of an MLModel.
//
// You can use the GetMLModel operation to view the contents of the updated
// data element.
func (c *MachineLearning) UpdateMLModel(input *UpdateMLModelInput) (*UpdateMLModelOutput, error) {
	req, out := c.UpdateMLModelRequest(input)
	err := req.Send()
	return out, err
}

// Represents the output of GetBatchPrediction operation.
//
//  The content consists of the detailed metadata, the status, and the data
// file information of a Batch Prediction.
type BatchPrediction struct {
	// The ID of the DataSource that points to the group of observations to predict.
	BatchPredictionDataSourceID *string `locationName:"BatchPredictionDataSourceId" type:"string"`

	// The ID assigned to the BatchPrediction at creation. This value should be
	// identical to the value of the BatchPredictionID in the request.
	BatchPredictionID *string `locationName:"BatchPredictionId" type:"string"`

	// The time that the BatchPrediction was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The AWS user account that invoked the BatchPrediction. The account type can
	// be either an AWS root account or an AWS Identity and Access Management (IAM)
	// user account.
	CreatedByIAMUser *string `locationName:"CreatedByIamUser" type:"string"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the BatchPrediction. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ID of the MLModel that generated predictions for the BatchPrediction
	// request.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	// A description of the most recent details about processing the batch prediction
	// request.
	Message *string `type:"string"`

	// A user-supplied name or description of the BatchPrediction.
	Name *string `type:"string"`

	// The location of an Amazon S3 bucket or directory to receive the operation
	// results. The following substrings are not allowed in the s3 key portion of
	// the "outputURI" field: ':', '//', '/./', '/../'.
	OutputURI *string `locationName:"OutputUri" type:"string"`

	// The status of the BatchPrediction. This element can have one of the following
	// values:
	//
	//   PENDING - Amazon Machine Learning (Amazon ML) submitted a request to generate
	// predictions for a batch of observations.  INPROGRESS - The process is underway.
	//  FAILED - The request to peform a batch prediction did not run to completion.
	// It is not usable.  COMPLETED - The batch prediction process completed successfully.
	//  DELETED - The BatchPrediction is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	metadataBatchPrediction `json:"-" xml:"-"`
}

type metadataBatchPrediction struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BatchPrediction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPrediction) GoString() string {
	return s.String()
}

type CreateBatchPredictionInput struct {
	// The ID of the DataSource that points to the group of observations to predict.
	BatchPredictionDataSourceID *string `locationName:"BatchPredictionDataSourceId" type:"string" required:"true"`

	// A user-supplied ID that uniquely identifies the BatchPrediction.
	BatchPredictionID *string `locationName:"BatchPredictionId" type:"string" required:"true"`

	// A user-supplied name or description of the BatchPrediction. BatchPredictionName
	// can only use the UTF-8 character set.
	BatchPredictionName *string `type:"string"`

	// The ID of the MLModel that will generate predictions for the group of observations.
	MLModelID *string `locationName:"MLModelId" type:"string" required:"true"`

	// The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory
	// to store the batch prediction results. The following substrings are not allowed
	// in the s3 key portion of the "outputURI" field: ':', '//', '/./', '/../'.
	//
	// Amazon ML needs permissions to store and retrieve the logs on your behalf.
	// For information about how to set permissions, see the Amazon Machine Learning
	// Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
	OutputURI *string `locationName:"OutputUri" type:"string" required:"true"`

	metadataCreateBatchPredictionInput `json:"-" xml:"-"`
}

type metadataCreateBatchPredictionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateBatchPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBatchPredictionInput) GoString() string {
	return s.String()
}

// Represents the output of a CreateBatchPrediction operation, and is an acknowledgement
// that Amazon ML received the request.
//
// The CreateBatchPrediction operation is asynchronous. You can poll for status
// updates by using the GetBatchPrediction operation and checking the Status
// parameter of the result.
type CreateBatchPredictionOutput struct {
	// A user-supplied ID that uniquely identifies the BatchPrediction. This value
	// is identical to the value of the BatchPredictionId in the request.
	BatchPredictionID *string `locationName:"BatchPredictionId" type:"string"`

	metadataCreateBatchPredictionOutput `json:"-" xml:"-"`
}

type metadataCreateBatchPredictionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateBatchPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBatchPredictionOutput) GoString() string {
	return s.String()
}

type CreateDataSourceFromRDSInput struct {
	// The compute statistics for a DataSource. The statistics are generated from
	// the observation data referenced by a DataSource. Amazon ML uses the statistics
	// internally during an MLModel training. This parameter must be set to true
	// if the DataSource needs to be used for MLModel training.
	ComputeStatistics *bool `type:"boolean"`

	// A user-supplied ID that uniquely identifies the DataSource. Typically, an
	// Amazon Resource Number (ARN) becomes the ID for a DataSource.
	DataSourceID *string `locationName:"DataSourceId" type:"string" required:"true"`

	// A user-supplied name or description of the DataSource.
	DataSourceName *string `type:"string"`

	// The data specification of an Amazon RDS DataSource:
	//
	//  DatabaseInformation -   DatabaseName  - Name of the Amazon RDS database.
	//   InstanceIdentifier  - Unique identifier for the Amazon RDS database instance.
	//
	//
	// DatabaseCredentials - AWS Identity and Access Management (IAM) credentials
	// that are used to connect to the Amazon RDS database.
	//
	// ResourceRole - Role (DataPipelineDefaultResourceRole) assumed by an Amazon
	// Elastic Compute Cloud (EC2) instance to carry out the copy task from Amazon
	// RDS to Amazon S3. For more information, see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	//
	// ServiceRole - Role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline
	// service to monitor the progress of the copy task from Amazon RDS to Amazon
	// Simple Storage Service (S3). For more information, see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	//
	// SecurityInfo - Security information to use to access an Amazon RDS instance.
	// You need to set up appropriate ingress rules for the security entity IDs
	// provided to allow access to the Amazon RDS instance. Specify a [SubnetId,
	// SecurityGroupIds] pair for a VPC-based Amazon RDS instance.
	//
	// SelectSqlQuery - Query that is used to retrieve the observation data for
	// the Datasource.
	//
	// S3StagingLocation - Amazon S3 location for staging RDS data. The data retrieved
	// from Amazon RDS using SelectSqlQuery is stored in this location.
	//
	// DataSchemaUri - Amazon S3 location of the DataSchema.
	//
	// DataSchema - A JSON string representing the schema. This is not required
	// if DataSchemaUri is specified.
	//
	//  DataRearrangement - A JSON string representing the splitting requirement
	// of a Datasource.
	//
	//   Sample -  "{\"randomSeed\":\"some-random-seed\", \"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
	RDSData *RDSDataSpec `type:"structure" required:"true"`

	// The role that Amazon ML assumes on behalf of the user to create and activate
	// a data pipeline in the user’s account and copy data (using the SelectSqlQuery)
	// query from Amazon RDS to Amazon S3.
	RoleARN *string `type:"string" required:"true"`

	metadataCreateDataSourceFromRDSInput `json:"-" xml:"-"`
}

type metadataCreateDataSourceFromRDSInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDataSourceFromRDSInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromRDSInput) GoString() string {
	return s.String()
}

// Represents the output of a CreateDataSourceFromRDS operation, and is an acknowledgement
// that Amazon ML received the request.
//
// The CreateDataSourceFromRDS operation is asynchronous. You can poll for
// updates by using the GetBatchPrediction operation and checking the Status
// parameter. You can inspect the Message when Status shows up as FAILED. You
// can also check the progress of the copy operation by going to the DataPipeline
// console and looking up the pipeline using the pipelineId from the describe
// call.
type CreateDataSourceFromRDSOutput struct {
	// A user-supplied ID that uniquely identifies the datasource. This value should
	// be identical to the value of the DataSourceID in the request.
	DataSourceID *string `locationName:"DataSourceId" type:"string"`

	metadataCreateDataSourceFromRDSOutput `json:"-" xml:"-"`
}

type metadataCreateDataSourceFromRDSOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDataSourceFromRDSOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromRDSOutput) GoString() string {
	return s.String()
}

type CreateDataSourceFromRedshiftInput struct {
	// The compute statistics for a DataSource. The statistics are generated from
	// the observation data referenced by a DataSource. Amazon ML uses the statistics
	// internally during MLModel training. This parameter must be set to true if
	// the DataSource needs to be used for MLModel training
	ComputeStatistics *bool `type:"boolean"`

	// A user-supplied ID that uniquely identifies the DataSource.
	DataSourceID *string `locationName:"DataSourceId" type:"string" required:"true"`

	// A user-supplied name or description of the DataSource.
	DataSourceName *string `type:"string"`

	// The data specification of an Amazon Redshift DataSource:
	//
	//  DatabaseInformation -   DatabaseName  - Name of the Amazon Redshift database.
	//    ClusterIdentifier  - Unique ID for the Amazon Redshift cluster.
	//
	// DatabaseCredentials - AWS Identity abd Access Management (IAM) credentials
	// that are used to connect to the Amazon Redshift database.
	//
	// SelectSqlQuery - Query that is used to retrieve the observation data for
	// the Datasource.
	//
	// S3StagingLocation - Amazon Simple Storage Service (Amazon S3) location for
	// staging Amazon Redshift data. The data retrieved from Amazon Relational Database
	// Service (Amazon RDS) using SelectSqlQuery is stored in this location.
	//
	// DataSchemaUri - Amazon S3 location of the DataSchema.
	//
	// DataSchema - A JSON string representing the schema. This is not required
	// if DataSchemaUri is specified.
	//
	//  DataRearrangement - A JSON string representing the splitting requirement
	// of a Datasource.
	//
	//   Sample -  "{\"randomSeed\":\"some-random-seed\", \"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
	DataSpec *RedshiftDataSpec `type:"structure" required:"true"`

	// A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the
	// role on behalf of the user to create the following:
	//
	//   A security group to allow Amazon ML to execute the SelectSqlQuery query
	// on an Amazon Redshift cluster
	//
	// An Amazon S3 bucket policy to grant Amazon ML read/write permissions on
	// the S3StagingLocation
	RoleARN *string `type:"string" required:"true"`

	metadataCreateDataSourceFromRedshiftInput `json:"-" xml:"-"`
}

type metadataCreateDataSourceFromRedshiftInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDataSourceFromRedshiftInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromRedshiftInput) GoString() string {
	return s.String()
}

// Represents the output of a CreateDataSourceFromRedshift operation, and is
// an acknowledgement that Amazon ML received the request.
//
// The CreateDataSourceFromRedshift operation is asynchronous. You can poll
// for updates by using the GetBatchPrediction operation and checking the Status
// parameter.
type CreateDataSourceFromRedshiftOutput struct {
	// A user-supplied ID that uniquely identifies the datasource. This value should
	// be identical to the value of the DataSourceID in the request.
	DataSourceID *string `locationName:"DataSourceId" type:"string"`

	metadataCreateDataSourceFromRedshiftOutput `json:"-" xml:"-"`
}

type metadataCreateDataSourceFromRedshiftOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDataSourceFromRedshiftOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromRedshiftOutput) GoString() string {
	return s.String()
}

type CreateDataSourceFromS3Input struct {
	// The compute statistics for a DataSource. The statistics are generated from
	// the observation data referenced by a DataSource. Amazon ML uses the statistics
	// internally during an MLModel training. This parameter must be set to true
	// if the DataSource needs to be used for MLModel training
	ComputeStatistics *bool `type:"boolean"`

	// A user-supplied identifier that uniquely identifies the DataSource.
	DataSourceID *string `locationName:"DataSourceId" type:"string" required:"true"`

	// A user-supplied name or description of the DataSource.
	DataSourceName *string `type:"string"`

	// The data specification of a DataSource:
	//
	//  DataLocationS3 - Amazon Simple Storage Service (Amazon S3) location of
	// the observation data.
	//
	// DataSchemaLocationS3 - Amazon S3 location of the DataSchema.
	//
	// DataSchema - A JSON string representing the schema. This is not required
	// if DataSchemaUri is specified.
	//
	//  DataRearrangement - A JSON string representing the splitting requirement
	// of a Datasource.
	//
	//   Sample -  "{\"randomSeed\":\"some-random-seed\", \"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
	DataSpec *S3DataSpec `type:"structure" required:"true"`

	metadataCreateDataSourceFromS3Input `json:"-" xml:"-"`
}

type metadataCreateDataSourceFromS3Input struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDataSourceFromS3Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromS3Input) GoString() string {
	return s.String()
}

// Represents the output of a CreateDataSourceFromS3 operation, and is an acknowledgement
// that Amazon ML received the request.
//
// The CreateDataSourceFromS3 operation is asynchronous. You can poll for updates
// by using the GetBatchPrediction operation and checking the Status parameter.
type CreateDataSourceFromS3Output struct {
	// A user-supplied ID that uniquely identifies the datasource. This value should
	// be identical to the value of the DataSourceID in the request.
	DataSourceID *string `locationName:"DataSourceId" type:"string"`

	metadataCreateDataSourceFromS3Output `json:"-" xml:"-"`
}

type metadataCreateDataSourceFromS3Output struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDataSourceFromS3Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDataSourceFromS3Output) GoString() string {
	return s.String()
}

type CreateEvaluationInput struct {
	// The ID of the DataSource for the evaluation. The schema of the DataSource
	// must match the schema used to create the MLModel.
	EvaluationDataSourceID *string `locationName:"EvaluationDataSourceId" type:"string" required:"true"`

	// A user-supplied ID that uniquely identifies the Evaluation.
	EvaluationID *string `locationName:"EvaluationId" type:"string" required:"true"`

	// A user-supplied name or description of the Evaluation.
	EvaluationName *string `type:"string"`

	// The ID of the MLModel to evaluate.
	//
	// The schema used in creating the MLModel must match the schema of the DataSource
	// used in the Evaluation.
	MLModelID *string `locationName:"MLModelId" type:"string" required:"true"`

	metadataCreateEvaluationInput `json:"-" xml:"-"`
}

type metadataCreateEvaluationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEvaluationInput) GoString() string {
	return s.String()
}

// Represents the output of a CreateEvaluation operation, and is an acknowledgement
// that Amazon ML received the request.
//
// CreateEvaluation operation is asynchronous. You can poll for status updates
// by using the GetEvaluation operation and checking the Status parameter.
type CreateEvaluationOutput struct {
	// The user-supplied ID that uniquely identifies the Evaluation. This value
	// should be identical to the value of the EvaluationId in the request.
	EvaluationID *string `locationName:"EvaluationId" type:"string"`

	metadataCreateEvaluationOutput `json:"-" xml:"-"`
}

type metadataCreateEvaluationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEvaluationOutput) GoString() string {
	return s.String()
}

type CreateMLModelInput struct {
	// A user-supplied ID that uniquely identifies the MLModel.
	MLModelID *string `locationName:"MLModelId" type:"string" required:"true"`

	// A user-supplied name or description of the MLModel.
	MLModelName *string `type:"string"`

	// The category of supervised learning that this MLModel will address. Choose
	// from the following types:
	//
	//  Choose REGRESSION if the MLModel will be used to predict a numeric value.
	// Choose BINARY if the MLModel result has two possible values. Choose MULTICLASS
	// if the MLModel result has a limited number of values.    For more information,
	// see the Amazon Machine Learning Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
	MLModelType *string `type:"string" required:"true" enum:"MLModelType"`

	// A list of the training parameters in the MLModel. The list is implemented
	// as a map of key/value pairs.
	//
	// The following is the current set of training parameters:
	//
	//   sgd.l1RegularizationAmount - Coefficient regularization L1 norm. It controls
	// overfitting the data by penalizing large coefficients. This tends to drive
	// coefficients to zero, resulting in sparse feature set. If you use this parameter,
	// start by specifying a small value such as 1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is not
	// to use L1 normalization. The parameter cannot be used when L2 is specified.
	// Use this parameter sparingly.
	//
	//   sgd.l2RegularizationAmount - Coefficient regularization L2 norm. It controls
	// overfitting the data by penalizing large coefficients. This tends to drive
	// coefficients to small, nonzero values. If you use this parameter, start by
	// specifying a small value such as 1.0E-08.
	//
	// The valuseis a double that ranges from 0 to MAX_DOUBLE. The default is not
	// to use L2 normalization. This cannot be used when L1 is specified. Use this
	// parameter sparingly.
	//
	//  sgd.maxPasses - Number of times that the training process traverses the
	// observations to build the MLModel. The value is an integer that ranges from
	// 1 to 10000. The default value is 10.
	//
	//  sgd.maxMLModelSizeInBytes - Maximum allowed size of the model. Depending
	// on the input data, the size of the model might affect its performance.
	//
	//  The value is an integer that ranges from 100000 to 2147483648. The default
	// value is 33554432.
	Parameters map[string]*string `type:"map"`

	// The data recipe for creating MLModel. You must specify either the recipe
	// or its URI. If you don’t specify a recipe or its URI, Amazon ML creates a
	// default.
	Recipe *string `type:"string"`

	// The Amazon Simple Storage Service (Amazon S3) location and file name that
	// contains the MLModel recipe. You must specify either the recipe or its URI.
	// If you don’t specify a recipe or its URI, Amazon ML creates a default.
	RecipeURI *string `locationName:"RecipeUri" type:"string"`

	// The DataSource that points to the training data.
	TrainingDataSourceID *string `locationName:"TrainingDataSourceId" type:"string" required:"true"`

	metadataCreateMLModelInput `json:"-" xml:"-"`
}

type metadataCreateMLModelInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMLModelInput) GoString() string {
	return s.String()
}

// Represents the output of a CreateMLModel operation, and is an acknowledgement
// that Amazon ML received the request.
//
// The CreateMLModel operation is asynchronous. You can poll for status updates
// by using the GetMLModel operation and checking the Status parameter.
type CreateMLModelOutput struct {
	// A user-supplied ID that uniquely identifies the MLModel. This value should
	// be identical to the value of the MLModelId in the request.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	metadataCreateMLModelOutput `json:"-" xml:"-"`
}

type metadataCreateMLModelOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateMLModelOutput) GoString() string {
	return s.String()
}

type CreateRealtimeEndpointInput struct {
	// The ID assigned to the MLModel during creation.
	MLModelID *string `locationName:"MLModelId" type:"string" required:"true"`

	metadataCreateRealtimeEndpointInput `json:"-" xml:"-"`
}

type metadataCreateRealtimeEndpointInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateRealtimeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRealtimeEndpointInput) GoString() string {
	return s.String()
}

// Represents the output of an CreateRealtimeEndpoint operation.
//
// The result contains the MLModelId and the endpoint information for the MLModel.
//
//  The endpoint information includes the URI of the MLModel; that is, the
// location to send online prediction requests for the specified MLModel.
type CreateRealtimeEndpointOutput struct {
	// A user-supplied ID that uniquely identifies the MLModel. This value should
	// be identical to the value of the MLModelId in the request.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	// The endpoint information of the MLModel
	RealtimeEndpointInfo *RealtimeEndpointInfo `type:"structure"`

	metadataCreateRealtimeEndpointOutput `json:"-" xml:"-"`
}

type metadataCreateRealtimeEndpointOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateRealtimeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRealtimeEndpointOutput) GoString() string {
	return s.String()
}

// Represents the output of the GetDataSource operation.
//
//  The content consists of the detailed metadata and data file information
// and the current status of the DataSource.
type DataSource struct {
	// The parameter is true if statistics need to be generated from the observation
	// data.
	ComputeStatistics *bool `type:"boolean"`

	// The time that the DataSource was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The AWS user account from which the DataSource was created. The account type
	// can be either an AWS root account or an AWS Identity and Access Management
	// (IAM) user account.
	CreatedByIAMUser *string `locationName:"CreatedByIamUser" type:"string"`

	// The location and name of the data in Amazon Simple Storage Service (Amazon
	// S3) that is used by a DataSource.
	DataLocationS3 *string `type:"string"`

	// A JSON string that represents the splitting requirement of a Datasource.
	DataRearrangement *string `type:"string"`

	// The total number of observations contained in the data files that the DataSource
	// references.
	DataSizeInBytes *int64 `type:"long"`

	// The ID that is assigned to the DataSource during creation.
	DataSourceID *string `locationName:"DataSourceId" type:"string"`

	// The time of the most recent edit to the BatchPrediction. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A description of the most recent details about creating the DataSource.
	Message *string `type:"string"`

	// A user-supplied name or description of the DataSource.
	Name *string `type:"string"`

	// The number of data files referenced by the DataSource.
	NumberOfFiles *int64 `type:"long"`

	// The datasource details that are specific to Amazon RDS.
	RDSMetadata *RDSMetadata `type:"structure"`

	// Describes the DataSource details specific to Amazon Redshift.
	RedshiftMetadata *RedshiftMetadata `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS IAM Role (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts)
	// such as the following: arn:aws:iam::account:role/rolename.
	RoleARN *string `type:"string"`

	// The current status of the DataSource. This element can have one of the following
	// values:
	//
	//  PENDING - Amazon Machine Learning (Amazon ML) submitted a request to create
	// a DataSource. INPROGRESS - The creation process is underway. FAILED - The
	// request to create a DataSource did not run to completion. It is not usable.
	// COMPLETED - The creation process completed successfully. DELETED - The DataSource
	// is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	metadataDataSource `json:"-" xml:"-"`
}

type metadataDataSource struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

type DeleteBatchPredictionInput struct {
	// A user-supplied ID that uniquely identifies the BatchPrediction.
	BatchPredictionID *string `locationName:"BatchPredictionId" type:"string" required:"true"`

	metadataDeleteBatchPredictionInput `json:"-" xml:"-"`
}

type metadataDeleteBatchPredictionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteBatchPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBatchPredictionInput) GoString() string {
	return s.String()
}

// Represents the output of a DeleteBatchPrediction operation.
//
// You can use the GetBatchPrediction operation and check the value of the
// Status parameter to see whether a BatchPrediction is marked as DELETED.
type DeleteBatchPredictionOutput struct {
	// A user-supplied ID that uniquely identifies the BatchPrediction. This value
	// should be identical to the value of the BatchPredictionID in the request.
	BatchPredictionID *string `locationName:"BatchPredictionId" type:"string"`

	metadataDeleteBatchPredictionOutput `json:"-" xml:"-"`
}

type metadataDeleteBatchPredictionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteBatchPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBatchPredictionOutput) GoString() string {
	return s.String()
}

type DeleteDataSourceInput struct {
	// A user-supplied ID that uniquely identifies the DataSource.
	DataSourceID *string `locationName:"DataSourceId" type:"string" required:"true"`

	metadataDeleteDataSourceInput `json:"-" xml:"-"`
}

type metadataDeleteDataSourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSourceInput) GoString() string {
	return s.String()
}

// Represents the output of a DeleteDataSource operation.
type DeleteDataSourceOutput struct {
	// A user-supplied ID that uniquely identifies the DataSource. This value should
	// be identical to the value of the DataSourceID in the request.
	DataSourceID *string `locationName:"DataSourceId" type:"string"`

	metadataDeleteDataSourceOutput `json:"-" xml:"-"`
}

type metadataDeleteDataSourceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDataSourceOutput) GoString() string {
	return s.String()
}

type DeleteEvaluationInput struct {
	// A user-supplied ID that uniquely identifies the Evaluation to delete.
	EvaluationID *string `locationName:"EvaluationId" type:"string" required:"true"`

	metadataDeleteEvaluationInput `json:"-" xml:"-"`
}

type metadataDeleteEvaluationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEvaluationInput) GoString() string {
	return s.String()
}

// Represents the output of a DeleteEvaluation operation. The output indicates
// that Amazon Machine Learning (Amazon ML) received the request.
//
// You can use the GetEvaluation operation and check the value of the Status
// parameter to see whether an Evaluation is marked as DELETED.
type DeleteEvaluationOutput struct {
	// A user-supplied ID that uniquely identifies the Evaluation. This value should
	// be identical to the value of the EvaluationId in the request.
	EvaluationID *string `locationName:"EvaluationId" type:"string"`

	metadataDeleteEvaluationOutput `json:"-" xml:"-"`
}

type metadataDeleteEvaluationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEvaluationOutput) GoString() string {
	return s.String()
}

type DeleteMLModelInput struct {
	// A user-supplied ID that uniquely identifies the MLModel.
	MLModelID *string `locationName:"MLModelId" type:"string" required:"true"`

	metadataDeleteMLModelInput `json:"-" xml:"-"`
}

type metadataDeleteMLModelInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMLModelInput) GoString() string {
	return s.String()
}

// Represents the output of a DeleteMLModel operation.
//
// You can use the GetMLModel operation and check the value of the Status parameter
// to see whether an MLModel is marked as DELETED.
type DeleteMLModelOutput struct {
	// A user-supplied ID that uniquely identifies the MLModel. This value should
	// be identical to the value of the MLModelID in the request.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	metadataDeleteMLModelOutput `json:"-" xml:"-"`
}

type metadataDeleteMLModelOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMLModelOutput) GoString() string {
	return s.String()
}

type DeleteRealtimeEndpointInput struct {
	// The ID assigned to the MLModel during creation.
	MLModelID *string `locationName:"MLModelId" type:"string" required:"true"`

	metadataDeleteRealtimeEndpointInput `json:"-" xml:"-"`
}

type metadataDeleteRealtimeEndpointInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteRealtimeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRealtimeEndpointInput) GoString() string {
	return s.String()
}

// Represents the output of an DeleteRealtimeEndpoint operation.
//
// The result contains the MLModelId and the endpoint information for the MLModel.
type DeleteRealtimeEndpointOutput struct {
	// A user-supplied ID that uniquely identifies the MLModel. This value should
	// be identical to the value of the MLModelId in the request.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	// The endpoint information of the MLModel
	RealtimeEndpointInfo *RealtimeEndpointInfo `type:"structure"`

	metadataDeleteRealtimeEndpointOutput `json:"-" xml:"-"`
}

type metadataDeleteRealtimeEndpointOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteRealtimeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRealtimeEndpointOutput) GoString() string {
	return s.String()
}

type DescribeBatchPredictionsInput struct {
	// The equal to operator. The BatchPrediction results will have FilterVariable
	// values that exactly match the value specified with EQ.
	EQ *string `type:"string"`

	// Use one of the following variables to filter a list of BatchPrediction:
	//
	//   CreatedAt - Sets the search criteria to the BatchPrediction creation date.
	//  Status - Sets the search criteria to the BatchPrediction status.  Name -
	// Sets the search criteria to the contents of the BatchPrediction  Name.  IAMUser
	// - Sets the search criteria to the user account that invoked the BatchPrediction
	// creation.  MLModelId - Sets the search criteria to the MLModel used in the
	// BatchPrediction.  DataSourceId - Sets the search criteria to the DataSource
	// used in the BatchPrediction.  DataURI - Sets the search criteria to the data
	// file(s) used in the BatchPrediction. The URL can identify either a file or
	// an Amazon Simple Storage Solution (Amazon S3) bucket or directory.
	FilterVariable *string `type:"string" enum:"BatchPredictionFilterVariable"`

	// The greater than or equal to operator. The BatchPrediction results will have
	// FilterVariable values that are greater than or equal to the value specified
	// with GE.
	GE *string `type:"string"`

	// The greater than operator. The BatchPrediction results will have FilterVariable
	// values that are greater than the value specified with GT.
	GT *string `type:"string"`

	// The less than or equal to operator. The BatchPrediction results will have
	// FilterVariable values that are less than or equal to the value specified
	// with LE.
	LE *string `type:"string"`

	// The less than operator. The BatchPrediction results will have FilterVariable
	// values that are less than the value specified with LT.
	LT *string `type:"string"`

	// The number of pages of information to include in the result. The range of
	// acceptable values is 1 through 100. The default value is 100.
	Limit *int64 `type:"integer"`

	// The not equal to operator. The BatchPrediction results will have FilterVariable
	// values not equal to the value specified with NE.
	NE *string `type:"string"`

	// An ID of the page in the paginated results.
	NextToken *string `type:"string"`

	// A string that is found at the beginning of a variable, such as Name or Id.
	//
	// For example, a Batch Prediction operation could have the Name 2014-09-09-HolidayGiftMailer.
	// To search for this BatchPrediction, select Name for the FilterVariable and
	// any of the following strings for the Prefix:
	//
	//  2014-09
	//
	// 2014-09-09
	//
	// 2014-09-09-Holiday
	Prefix *string `type:"string"`

	// A two-value parameter that determines the sequence of the resulting list
	// of MLModels.
	//
	//   asc - Arranges the list in ascending order (A-Z, 0-9).  dsc - Arranges
	// the list in descending order (Z-A, 9-0).  Results are sorted by FilterVariable.
	SortOrder *string `type:"string" enum:"SortOrder"`

	metadataDescribeBatchPredictionsInput `json:"-" xml:"-"`
}

type metadataDescribeBatchPredictionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeBatchPredictionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBatchPredictionsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeBatchPredictions operation. The content
// is essentially a list of BatchPredictions.
type DescribeBatchPredictionsOutput struct {
	// The ID of the next page in the paginated results that indicates at least
	// one more page follows.
	NextToken *string `type:"string"`

	// A list of BatchPrediction objects that meet the search criteria.
	Results []*BatchPrediction `type:"list"`

	metadataDescribeBatchPredictionsOutput `json:"-" xml:"-"`
}

type metadataDescribeBatchPredictionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeBatchPredictionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBatchPredictionsOutput) GoString() string {
	return s.String()
}

type DescribeDataSourcesInput struct {
	// The equal to operator. The DataSource results will have FilterVariable values
	// that exactly match the value specified with EQ.
	EQ *string `type:"string"`

	// Use one of the following variables to filter a list of DataSource:
	//
	//   CreatedAt - Sets the search criteria to DataSource creation dates.  Status
	// - Sets the search criteria to DataSource statuses.  Name - Sets the search
	// criteria to the contents of DataSource   Name.  DataUri - Sets the search
	// criteria to the URI of data files used to create the DataSource. The URI
	// can identify either a file or an Amazon Simple Storage Service (Amazon S3)
	// bucket or directory.  IAMUser - Sets the search criteria to the user account
	// that invoked the DataSource creation.
	FilterVariable *string `type:"string" enum:"DataSourceFilterVariable"`

	// The greater than or equal to operator. The DataSource results will have FilterVariable
	// values that are greater than or equal to the value specified with GE.
	GE *string `type:"string"`

	// The greater than operator. The DataSource results will have FilterVariable
	// values that are greater than the value specified with GT.
	GT *string `type:"string"`

	// The less than or equal to operator. The DataSource results will have FilterVariable
	// values that are less than or equal to the value specified with LE.
	LE *string `type:"string"`

	// The less than operator. The DataSource results will have FilterVariable values
	// that are less than the value specified with LT.
	LT *string `type:"string"`

	// The maximum number of DataSource to include in the result.
	Limit *int64 `type:"integer"`

	// The not equal to operator. The DataSource results will have FilterVariable
	// values not equal to the value specified with NE.
	NE *string `type:"string"`

	// The ID of the page in the paginated results.
	NextToken *string `type:"string"`

	// A string that is found at the beginning of a variable, such as Name or Id.
	//
	// For example, a DataSource could have the Name 2014-09-09-HolidayGiftMailer.
	// To search for this DataSource, select Name for the FilterVariable and any
	// of the following strings for the Prefix:
	//
	//  2014-09
	//
	// 2014-09-09
	//
	// 2014-09-09-Holiday
	Prefix *string `type:"string"`

	// A two-value parameter that determines the sequence of the resulting list
	// of DataSource.
	//
	//   asc - Arranges the list in ascending order (A-Z, 0-9).  dsc - Arranges
	// the list in descending order (Z-A, 9-0).  Results are sorted by FilterVariable.
	SortOrder *string `type:"string" enum:"SortOrder"`

	metadataDescribeDataSourcesInput `json:"-" xml:"-"`
}

type metadataDescribeDataSourcesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDataSourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourcesInput) GoString() string {
	return s.String()
}

// Represents the query results from a DescribeDataSources operation. The content
// is essentially a list of DataSource.
type DescribeDataSourcesOutput struct {
	// An ID of the next page in the paginated results that indicates at least one
	// more page follows.
	NextToken *string `type:"string"`

	// A list of DataSource that meet the search criteria.
	Results []*DataSource `type:"list"`

	metadataDescribeDataSourcesOutput `json:"-" xml:"-"`
}

type metadataDescribeDataSourcesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDataSourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDataSourcesOutput) GoString() string {
	return s.String()
}

type DescribeEvaluationsInput struct {
	// The equal to operator. The Evaluation results will have FilterVariable values
	// that exactly match the value specified with EQ.
	EQ *string `type:"string"`

	// Use one of the following variable to filter a list of Evaluation objects:
	//
	//   CreatedAt - Sets the search criteria to the Evaluation creation date.
	//  Status - Sets the search criteria to the Evaluation status.  Name - Sets
	// the search criteria to the contents of Evaluation   Name.  IAMUser - Sets
	// the search criteria to the user account that invoked an Evaluation.  MLModelId
	// - Sets the search criteria to the MLModel that was evaluated.  DataSourceId
	// - Sets the search criteria to the DataSource used in Evaluation.  DataUri
	// - Sets the search criteria to the data file(s) used in Evaluation. The URL
	// can identify either a file or an Amazon Simple Storage Solution (Amazon S3)
	// bucket or directory.
	FilterVariable *string `type:"string" enum:"EvaluationFilterVariable"`

	// The greater than or equal to operator. The Evaluation results will have FilterVariable
	// values that are greater than or equal to the value specified with GE.
	GE *string `type:"string"`

	// The greater than operator. The Evaluation results will have FilterVariable
	// values that are greater than the value specified with GT.
	GT *string `type:"string"`

	// The less than or equal to operator. The Evaluation results will have FilterVariable
	// values that are less than or equal to the value specified with LE.
	LE *string `type:"string"`

	// The less than operator. The Evaluation results will have FilterVariable values
	// that are less than the value specified with LT.
	LT *string `type:"string"`

	// The maximum number of Evaluation to include in the result.
	Limit *int64 `type:"integer"`

	// The not equal to operator. The Evaluation results will have FilterVariable
	// values not equal to the value specified with NE.
	NE *string `type:"string"`

	// The ID of the page in the paginated results.
	NextToken *string `type:"string"`

	// A string that is found at the beginning of a variable, such as Name or Id.
	//
	// For example, an Evaluation could have the Name 2014-09-09-HolidayGiftMailer.
	// To search for this Evaluation, select Name for the FilterVariable and any
	// of the following strings for the Prefix:
	//
	//  2014-09
	//
	// 2014-09-09
	//
	// 2014-09-09-Holiday
	Prefix *string `type:"string"`

	// A two-value parameter that determines the sequence of the resulting list
	// of Evaluation.
	//
	//   asc - Arranges the list in ascending order (A-Z, 0-9).  dsc - Arranges
	// the list in descending order (Z-A, 9-0).  Results are sorted by FilterVariable.
	SortOrder *string `type:"string" enum:"SortOrder"`

	metadataDescribeEvaluationsInput `json:"-" xml:"-"`
}

type metadataDescribeEvaluationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEvaluationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEvaluationsInput) GoString() string {
	return s.String()
}

// Represents the query results from a DescribeEvaluations operation. The content
// is essentially a list of Evaluation.
type DescribeEvaluationsOutput struct {
	// The ID of the next page in the paginated results that indicates at least
	// one more page follows.
	NextToken *string `type:"string"`

	// A list of Evaluation that meet the search criteria.
	Results []*Evaluation `type:"list"`

	metadataDescribeEvaluationsOutput `json:"-" xml:"-"`
}

type metadataDescribeEvaluationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEvaluationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEvaluationsOutput) GoString() string {
	return s.String()
}

type DescribeMLModelsInput struct {
	// The equal to operator. The MLModel results will have FilterVariable values
	// that exactly match the value specified with EQ.
	EQ *string `type:"string"`

	// Use one of the following variables to filter a list of MLModel:
	//
	//   CreatedAt - Sets the search criteria to MLModel creation date.  Status
	// - Sets the search criteria to MLModel status.  Name - Sets the search criteria
	// to the contents of MLModel  Name.  IAMUser - Sets the search criteria to
	// the user account that invoked the MLModel creation.  TrainingDataSourceId
	// - Sets the search criteria to the DataSource used to train one or more MLModel.
	//  RealtimeEndpointStatus - Sets the search criteria to the MLModel real-time
	// endpoint status.  MLModelType - Sets the search criteria to MLModel type:
	// binary, regression, or multi-class.  Algorithm - Sets the search criteria
	// to the algorithm that the MLModel uses.  TrainingDataURI - Sets the search
	// criteria to the data file(s) used in training a MLModel. The URL can identify
	// either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.
	FilterVariable *string `type:"string" enum:"MLModelFilterVariable"`

	// The greater than or equal to operator. The MLModel results will have FilterVariable
	// values that are greater than or equal to the value specified with GE.
	GE *string `type:"string"`

	// The greater than operator. The MLModel results will have FilterVariable values
	// that are greater than the value specified with GT.
	GT *string `type:"string"`

	// The less than or equal to operator. The MLModel results will have FilterVariable
	// values that are less than or equal to the value specified with LE.
	LE *string `type:"string"`

	// The less than operator. The MLModel results will have FilterVariable values
	// that are less than the value specified with LT.
	LT *string `type:"string"`

	// The number of pages of information to include in the result. The range of
	// acceptable values is 1 through 100. The default value is 100.
	Limit *int64 `type:"integer"`

	// The not equal to operator. The MLModel results will have FilterVariable values
	// not equal to the value specified with NE.
	NE *string `type:"string"`

	// The ID of the page in the paginated results.
	NextToken *string `type:"string"`

	// A string that is found at the beginning of a variable, such as Name or Id.
	//
	// For example, an MLModel could have the Name 2014-09-09-HolidayGiftMailer.
	// To search for this MLModel, select Name for the FilterVariable and any of
	// the following strings for the Prefix:
	//
	//  2014-09
	//
	// 2014-09-09
	//
	// 2014-09-09-Holiday
	Prefix *string `type:"string"`

	// A two-value parameter that determines the sequence of the resulting list
	// of MLModel.
	//
	//   asc - Arranges the list in ascending order (A-Z, 0-9).  dsc - Arranges
	// the list in descending order (Z-A, 9-0).  Results are sorted by FilterVariable.
	SortOrder *string `type:"string" enum:"SortOrder"`

	metadataDescribeMLModelsInput `json:"-" xml:"-"`
}

type metadataDescribeMLModelsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeMLModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMLModelsInput) GoString() string {
	return s.String()
}

// Represents the output of a DescribeMLModels operation. The content is essentially
// a list of MLModel.
type DescribeMLModelsOutput struct {
	// The ID of the next page in the paginated results that indicates at least
	// one more page follows.
	NextToken *string `type:"string"`

	// A list of MLModel that meet the search criteria.
	Results []*MLModel `type:"list"`

	metadataDescribeMLModelsOutput `json:"-" xml:"-"`
}

type metadataDescribeMLModelsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeMLModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMLModelsOutput) GoString() string {
	return s.String()
}

// Represents the output of GetEvaluation operation.
//
// The content consists of the detailed metadata and data file information
// and the current status of the Evaluation.
type Evaluation struct {
	// The time that the Evaluation was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The AWS user account that invoked the evaluation. The account type can be
	// either an AWS root account or an AWS Identity and Access Management (IAM)
	// user account.
	CreatedByIAMUser *string `locationName:"CreatedByIamUser" type:"string"`

	// The ID of the DataSource that is used to evaluate the MLModel.
	EvaluationDataSourceID *string `locationName:"EvaluationDataSourceId" type:"string"`

	// The ID that is assigned to the Evaluation at creation.
	EvaluationID *string `locationName:"EvaluationId" type:"string"`

	// The location and name of the data in Amazon Simple Storage Server (Amazon
	// S3) that is used in the evaluation.
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the Evaluation. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ID of the MLModel that is the focus of the evaluation.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	// A description of the most recent details about evaluating the MLModel.
	Message *string `type:"string"`

	// A user-supplied name or description of the Evaluation.
	Name *string `type:"string"`

	// Measurements of how well the MLModel performed, using observations referenced
	// by the DataSource. One of the following metrics is returned, based on the
	// type of the MLModel:
	//
	//   BinaryAUC: A binary MLModel uses the Area Under the Curve (AUC) technique
	// to measure performance.
	//
	//   RegressionRMSE: A regression MLModel uses the Root Mean Square Error (RMSE)
	// technique to measure performance. RMSE measures the difference between predicted
	// and actual values for a single variable.
	//
	//   MulticlassAvgFScore: A multiclass MLModel uses the F1 score technique
	// to measure performance.
	//
	//    For more information about performance metrics, please see the Amazon
	// Machine Learning Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
	PerformanceMetrics *PerformanceMetrics `type:"structure"`

	// The status of the evaluation. This element can have one of the following
	// values:
	//
	//   PENDING - Amazon Machine Learning (Amazon ML) submitted a request to evaluate
	// an MLModel.  INPROGRESS - The evaluation is underway.  FAILED - The request
	// to evaluate an MLModel did not run to completion. It is not usable.  COMPLETED
	// - The evaluation process completed successfully.  DELETED - The Evaluation
	// is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	metadataEvaluation `json:"-" xml:"-"`
}

type metadataEvaluation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Evaluation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Evaluation) GoString() string {
	return s.String()
}

type GetBatchPredictionInput struct {
	// An ID assigned to the BatchPrediction at creation.
	BatchPredictionID *string `locationName:"BatchPredictionId" type:"string" required:"true"`

	metadataGetBatchPredictionInput `json:"-" xml:"-"`
}

type metadataGetBatchPredictionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetBatchPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBatchPredictionInput) GoString() string {
	return s.String()
}

// Represents the output of a GetBatchPrediction operation and describes a BatchPrediction.
type GetBatchPredictionOutput struct {
	// The ID of the DataSource that was used to create the BatchPrediction.
	BatchPredictionDataSourceID *string `locationName:"BatchPredictionDataSourceId" type:"string"`

	// An ID assigned to the BatchPrediction at creation. This value should be identical
	// to the value of the BatchPredictionID in the request.
	BatchPredictionID *string `locationName:"BatchPredictionId" type:"string"`

	// The time when the BatchPrediction was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The AWS user account that invoked the BatchPrediction. The account type can
	// be either an AWS root account or an AWS Identity and Access Management (IAM)
	// user account.
	CreatedByIAMUser *string `locationName:"CreatedByIamUser" type:"string"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to BatchPrediction. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A link to the file that contains logs of the CreateBatchPrediction operation.
	LogURI *string `locationName:"LogUri" type:"string"`

	// The ID of the MLModel that generated predictions for the BatchPrediction
	// request.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	// A description of the most recent details about processing the batch prediction
	// request.
	Message *string `type:"string"`

	// A user-supplied name or description of the BatchPrediction.
	Name *string `type:"string"`

	// The location of an Amazon S3 bucket or directory to receive the operation
	// results.
	OutputURI *string `locationName:"OutputUri" type:"string"`

	// The status of the BatchPrediction, which can be one of the following values:
	//
	//   PENDING - Amazon Machine Learning (Amazon ML) submitted a request to generate
	// batch predictions.  INPROGRESS - The batch predictions are in progress.
	// FAILED - The request to perform a batch prediction did not run to completion.
	// It is not usable.  COMPLETED - The batch prediction process completed successfully.
	//  DELETED - The BatchPrediction is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	metadataGetBatchPredictionOutput `json:"-" xml:"-"`
}

type metadataGetBatchPredictionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetBatchPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetBatchPredictionOutput) GoString() string {
	return s.String()
}

type GetDataSourceInput struct {
	// The ID assigned to the DataSource at creation.
	DataSourceID *string `locationName:"DataSourceId" type:"string" required:"true"`

	// Specifies whether the GetDataSource operation should return DataSourceSchema.
	//
	// If true, DataSourceSchema is returned.
	//
	// If false, DataSourceSchema is not returned.
	Verbose *bool `type:"boolean"`

	metadataGetDataSourceInput `json:"-" xml:"-"`
}

type metadataGetDataSourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataSourceInput) GoString() string {
	return s.String()
}

// Represents the output of a GetDataSource operation and describes a DataSource.
type GetDataSourceOutput struct {
	// The parameter is true if statistics need to be generated from the observation
	// data.
	ComputeStatistics *bool `type:"boolean"`

	// The time that the DataSource was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The AWS user account from which the DataSource was created. The account type
	// can be either an AWS root account or an AWS Identity and Access Management
	// (IAM) user account.
	CreatedByIAMUser *string `locationName:"CreatedByIamUser" type:"string"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	DataLocationS3 *string `type:"string"`

	// A JSON string that captures the splitting rearrangement requirement of the
	// DataSource.
	DataRearrangement *string `type:"string"`

	// The total size of observations in the data files.
	DataSizeInBytes *int64 `type:"long"`

	// The ID assigned to the DataSource at creation. This value should be identical
	// to the value of the DataSourceId in the request.
	DataSourceID *string `locationName:"DataSourceId" type:"string"`

	// The schema used by all of the data files of this DataSource.
	//
	// Note This parameter is provided as part of the verbose format.
	DataSourceSchema *string `type:"string"`

	// The time of the most recent edit to the DataSource. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A link to the file containining logs of either create DataSource operation.
	LogURI *string `locationName:"LogUri" type:"string"`

	// The description of the most recent details about creating the DataSource.
	Message *string `type:"string"`

	// A user-supplied name or description of the DataSource.
	Name *string `type:"string"`

	// The number of data files referenced by the DataSource.
	NumberOfFiles *int64 `type:"long"`

	// The datasource details that are specific to Amazon RDS.
	RDSMetadata *RDSMetadata `type:"structure"`

	// Describes the DataSource details specific to Amazon Redshift.
	RedshiftMetadata *RedshiftMetadata `type:"structure"`

	// The Amazon Resource Name (ARN) of an AWS IAM Role (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts)
	// such as the following: arn:aws:iam::account:role/rolename.
	RoleARN *string `type:"string"`

	// The current status of the DataSource. This element can have one of the following
	// values:
	//
	//   PENDING - Amazon Machine Language (Amazon ML) submitted a request to create
	// a DataSource.  INPROGRESS - The creation process is underway.  FAILED - The
	// request to create a DataSource did not run to completion. It is not usable.
	//  COMPLETED - The creation process completed successfully.  DELETED - The
	// DataSource is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	metadataGetDataSourceOutput `json:"-" xml:"-"`
}

type metadataGetDataSourceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataSourceOutput) GoString() string {
	return s.String()
}

type GetEvaluationInput struct {
	// The ID of the Evaluation to retrieve. The evaluation of each MLModel is recorded
	// and cataloged. The ID provides the means to access the information.
	EvaluationID *string `locationName:"EvaluationId" type:"string" required:"true"`

	metadataGetEvaluationInput `json:"-" xml:"-"`
}

type metadataGetEvaluationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvaluationInput) GoString() string {
	return s.String()
}

// Represents the output of a GetEvaluation operation and describes an Evaluation.
type GetEvaluationOutput struct {
	// The time that the Evaluation was created. The time is expressed in epoch
	// time.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The AWS user account that invoked the evaluation. The account type can be
	// either an AWS root account or an AWS Identity and Access Management (IAM)
	// user account.
	CreatedByIAMUser *string `locationName:"CreatedByIamUser" type:"string"`

	// The DataSource used for this evaluation.
	EvaluationDataSourceID *string `locationName:"EvaluationDataSourceId" type:"string"`

	// The evaluation ID which is same as the EvaluationId in the request.
	EvaluationID *string `locationName:"EvaluationId" type:"string"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the BatchPrediction. The time is expressed
	// in epoch time.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A link to the file that contains logs of the CreateEvaluation operation.
	LogURI *string `locationName:"LogUri" type:"string"`

	// The ID of the MLModel that was the focus of the evaluation.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	// A description of the most recent details about evaluating the MLModel.
	Message *string `type:"string"`

	// A user-supplied name or description of the Evaluation.
	Name *string `type:"string"`

	// Measurements of how well the MLModel performed using observations referenced
	// by the DataSource. One of the following metric is returned based on the type
	// of the MLModel:
	//
	//   BinaryAUC: A binary MLModel uses the Area Under the Curve (AUC) technique
	// to measure performance.
	//
	//   RegressionRMSE: A regression MLModel uses the Root Mean Square Error (RMSE)
	// technique to measure performance. RMSE measures the difference between predicted
	// and actual values for a single variable.
	//
	//   MulticlassAvgFScore: A multiclass MLModel uses the F1 score technique
	// to measure performance.
	//
	//    For more information about performance metrics, please see the Amazon
	// Machine Learning Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
	PerformanceMetrics *PerformanceMetrics `type:"structure"`

	// The status of the evaluation. This element can have one of the following
	// values:
	//
	//   PENDING - Amazon Machine Language (Amazon ML) submitted a request to evaluate
	// an MLModel.  INPROGRESS - The evaluation is underway.  FAILED - The request
	// to evaluate an MLModel did not run to completion. It is not usable.  COMPLETED
	// - The evaluation process completed successfully.  DELETED - The Evaluation
	// is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	metadataGetEvaluationOutput `json:"-" xml:"-"`
}

type metadataGetEvaluationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEvaluationOutput) GoString() string {
	return s.String()
}

type GetMLModelInput struct {
	// The ID assigned to the MLModel at creation.
	MLModelID *string `locationName:"MLModelId" type:"string" required:"true"`

	// Specifies whether the GetMLModel operation should return Recipe.
	//
	// If true, Recipe is returned.
	//
	// If false, Recipe is not returned.
	Verbose *bool `type:"boolean"`

	metadataGetMLModelInput `json:"-" xml:"-"`
}

type metadataGetMLModelInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMLModelInput) GoString() string {
	return s.String()
}

// Represents the output of a GetMLModel operation, and provides detailed information
// about a MLModel.
type GetMLModelOutput struct {
	// The time that the MLModel was created. The time is expressed in epoch time.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The AWS user account from which the MLModel was created. The account type
	// can be either an AWS root account or an AWS Identity and Access Management
	// (IAM) user account.
	CreatedByIAMUser *string `locationName:"CreatedByIamUser" type:"string"`

	// The current endpoint of the MLModel
	EndpointInfo *RealtimeEndpointInfo `type:"structure"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the MLModel. The time is expressed in
	// epoch time.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A link to the file that contains logs of the CreateMLModel operation.
	LogURI *string `locationName:"LogUri" type:"string"`

	// The MLModel ID which is same as the MLModelId in the request.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	// Identifies the MLModel category. The following are the available types:
	//
	//  REGRESSION -- Produces a numeric result. For example, "What listing price
	// should a house have?" BINARY -- Produces one of two possible results. For
	// example, "Is this an e-commerce website?" MULTICLASS -- Produces more than
	// two possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"
	MLModelType *string `type:"string" enum:"MLModelType"`

	// Description of the most recent details about accessing the MLModel.
	Message *string `type:"string"`

	// A user-supplied name or description of the MLModel.
	Name *string `type:"string"`

	// The recipe to use when training the MLModel. The Recipe provides detailed
	// information about the observation data to use during training, as well as
	// manipulations to perform on the observation data during training.
	//
	// Note This parameter is provided as part of the verbose format.
	Recipe *string `type:"string"`

	// The schema used by all of the data files referenced by the DataSource.
	//
	// Note This parameter is provided as part of the verbose format.
	Schema *string `type:"string"`

	// The scoring threshold is used in binary classification MLModels, and marks
	// the boundary between a positive prediction and a negative prediction.
	//
	// Output values greater than or equal to the threshold receive a positive
	// result from the MLModel, such as true. Output values less than the threshold
	// receive a negative response from the MLModel, such as false.
	ScoreThreshold *float64 `type:"float"`

	// The time of the most recent edit to the ScoreThreshold. The time is expressed
	// in epoch time.
	ScoreThresholdLastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Long integer type that is a 64-bit signed number.
	SizeInBytes *int64 `type:"long"`

	// The current status of the MLModel. This element can have one of the following
	// values:
	//
	//   PENDING - Amazon Machine Learning (Amazon ML) submitted a request to describe
	// a MLModel.  INPROGRESS - The request is processing.  FAILED - The request
	// did not run to completion. It is not usable.  COMPLETED - The request completed
	// successfully.  DELETED - The MLModel is marked as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	// The ID of the training DataSource.
	TrainingDataSourceID *string `locationName:"TrainingDataSourceId" type:"string"`

	// A list of the training parameters in the MLModel. The list is implemented
	// as a map of key/value pairs.
	//
	// The following is the current set of training parameters:
	//
	//   sgd.l1RegularizationAmount - Coefficient regularization L1 norm. It controls
	// overfitting the data by penalizing large coefficients. This tends to drive
	// coefficients to zero, resulting in a sparse feature set. If you use this
	// parameter, specify a small value, such as 1.0E-04 or 1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is not
	// to use L1 normalization. The parameter cannot be used when L2 is specified.
	// Use this parameter sparingly.
	//
	//   sgd.l2RegularizationAmount - Coefficient regularization L2 norm. It controls
	// overfitting the data by penalizing large coefficients. This tends to drive
	// coefficients to small, nonzero values. If you use this parameter, specify
	// a small value, such as 1.0E-04 or 1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is not
	// to use L2 normalization. This parameter cannot be used when L1 is specified.
	// Use this parameter sparingly.
	//
	//  sgd.maxPasses - The number of times that the training process traverses
	// the observations to build the MLModel. The value is an integer that ranges
	// from 1 to 10000. The default value is 10.
	//
	//  sgd.maxMLModelSizeInBytes - The maximum allowed size of the model. Depending
	// on the input data, the model size might affect performance.
	//
	//  The value is an integer that ranges from 100000 to 2147483648. The default
	// value is 33554432.
	TrainingParameters map[string]*string `type:"map"`

	metadataGetMLModelOutput `json:"-" xml:"-"`
}

type metadataGetMLModelOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMLModelOutput) GoString() string {
	return s.String()
}

// Represents the output of a GetMLModel operation.
//
// The content consists of the detailed metadata and the current status of
// the MLModel.
type MLModel struct {
	// The algorithm used to train the MLModel. The following algorithm is supported:
	//
	//  SGD -- Stochastic gradient descent. The goal of SGD is to minimize the
	// gradient of the loss function.
	Algorithm *string `type:"string" enum:"Algorithm"`

	// The time that the MLModel was created. The time is expressed in epoch time.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The AWS user account from which the MLModel was created. The account type
	// can be either an AWS root account or an AWS Identity and Access Management
	// (IAM) user account.
	CreatedByIAMUser *string `locationName:"CreatedByIamUser" type:"string"`

	// The current endpoint of the MLModel.
	EndpointInfo *RealtimeEndpointInfo `type:"structure"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the MLModel. The time is expressed in
	// epoch time.
	LastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ID assigned to the MLModel at creation.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	// Identifies the MLModel category. The following are the available types:
	//
	//  REGRESSION - Produces a numeric result. For example, "What listing price
	// should a house have?". BINARY - Produces one of two possible results. For
	// example, "Is this a child-friendly web site?". MULTICLASS - Produces more
	// than two possible results. For example, "Is this a HIGH, LOW or MEDIUM risk
	// trade?".
	MLModelType *string `type:"string" enum:"MLModelType"`

	// A description of the most recent details about accessing the MLModel.
	Message *string `type:"string"`

	// A user-supplied name or description of the MLModel.
	Name *string `type:"string"`

	ScoreThreshold *float64 `type:"float"`

	// The time of the most recent edit to the ScoreThreshold. The time is expressed
	// in epoch time.
	ScoreThresholdLastUpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Long integer type that is a 64-bit signed number.
	SizeInBytes *int64 `type:"long"`

	// The current status of an MLModel. This element can have one of the following
	// values:
	//
	//  PENDING - Amazon Machine Learning (Amazon ML) submitted a request to create
	// an MLModel. INPROGRESS - The creation process is underway. FAILED - The request
	// to create an MLModel did not run to completion. It is not usable. COMPLETED
	// - The creation process completed successfully. DELETED - The MLModel is marked
	// as deleted. It is not usable.
	Status *string `type:"string" enum:"EntityStatus"`

	// The ID of the training DataSource. The CreateMLModel operation uses the TrainingDataSourceId.
	TrainingDataSourceID *string `locationName:"TrainingDataSourceId" type:"string"`

	// A list of the training parameters in the MLModel. The list is implemented
	// as a map of key/value pairs.
	//
	// The following is the current set of training parameters:
	//
	//   sgd.l1RegularizationAmount - Coefficient regularization L1 norm. It controls
	// overfitting the data by penalizing large coefficients. This tends to drive
	// coefficients to zero, resulting in a sparse feature set. If you use this
	// parameter, specify a small value, such as 1.0E-04 or 1.0E-08.
	//
	// The value is a double that ranges from 0 to MAX_DOUBLE. The default is not
	// to use L1 normalization. The parameter cannot be used when L2 is specified.
	// Use this parameter sparingly.
	//
	//   sgd.l2RegularizationAmount - Coefficient regularization L2 norm. It controls
	// overfitting the data by penalizing large coefficients. This tends to drive
	// coefficients to small, nonzero values. If you use this parameter, specify
	// a small value, such as 1.0E-04 or 1.0E-08.
	//
	// The valus is a double that ranges from 0 to MAX_DOUBLE. The default is not
	// to use L2 normalization. This cannot be used when L1 is specified. Use this
	// parameter sparingly.
	//
	//  sgd.maxPasses - Number of times that the training process traverses the
	// observations to build the MLModel. The value is an integer that ranges from
	// 1 to 10000. The default value is 10.
	//
	//  sgd.maxMLModelSizeInBytes - Maximum allowed size of the model. Depending
	// on the input data, the model size might affect performance.
	//
	//  The value is an integer that ranges from 100000 to 2147483648. The default
	// value is 33554432.
	TrainingParameters map[string]*string `type:"map"`

	metadataMLModel `json:"-" xml:"-"`
}

type metadataMLModel struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s MLModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MLModel) GoString() string {
	return s.String()
}

// Measurements of how well the MLModel performed on known observations. One
// of the following metrics is returned, based on the type of the MLModel:
//
//   BinaryAUC: The binary MLModel uses the Area Under the Curve (AUC) technique
// to measure performance.
//
//   RegressionRMSE: The regression MLModel uses the Root Mean Square Error
// (RMSE) technique to measure performance. RMSE measures the difference between
// predicted and actual values for a single variable.
//
//   MulticlassAvgFScore: The multiclass MLModel uses the F1 score technique
// to measure performance.
//
//    For more information about performance metrics, please see the Amazon
// Machine Learning Developer Guide (http://docs.aws.amazon.com/machine-learning/latest/dg).
type PerformanceMetrics struct {
	Properties map[string]*string `type:"map"`

	metadataPerformanceMetrics `json:"-" xml:"-"`
}

type metadataPerformanceMetrics struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PerformanceMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PerformanceMetrics) GoString() string {
	return s.String()
}

type PredictInput struct {
	// A unique identifier of the MLModel.
	MLModelID *string `locationName:"MLModelId" type:"string" required:"true"`

	PredictEndpoint *string `type:"string" required:"true"`

	// A map of variable name-value pairs that represent an observation.
	Record map[string]*string `type:"map" required:"true"`

	metadataPredictInput `json:"-" xml:"-"`
}

type metadataPredictInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PredictInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredictInput) GoString() string {
	return s.String()
}

type PredictOutput struct {
	// The output from a Predict operation:
	//
	//    Details - Contains the following attributes: DetailsAttributes.PREDICTIVE_MODEL_TYPE
	// - REGRESSION | BINARY | MULTICLASS DetailsAttributes.ALGORITHM - SGD
	//
	//    PredictedLabel - Present for either a BINARY or MULTICLASS MLModel request.
	//
	//    PredictedScores - Contains the raw classification score corresponding
	// to each label.
	//
	//    PredictedValue - Present for a REGRESSION MLModel request.
	Prediction *Prediction `type:"structure"`

	metadataPredictOutput `json:"-" xml:"-"`
}

type metadataPredictOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PredictOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PredictOutput) GoString() string {
	return s.String()
}

// The output from a Predict operation:
//
//    Details - Contains the following attributes: DetailsAttributes.PREDICTIVE_MODEL_TYPE
// - REGRESSION | BINARY | MULTICLASS DetailsAttributes.ALGORITHM - SGD
//
//    PredictedLabel - Present for either a BINARY or MULTICLASS MLModel request.
//
//    PredictedScores - Contains the raw classification score corresponding
// to each label.
//
//    PredictedValue - Present for a REGRESSION MLModel request.
type Prediction struct {
	// Provides any additional details regarding the prediction.
	Details map[string]*string `locationName:"details" type:"map"`

	// The prediction label for either a BINARY or MULTICLASS MLModel.
	PredictedLabel *string `locationName:"predictedLabel" type:"string"`

	// Provides the raw classification score corresponding to each label.
	PredictedScores map[string]*float64 `locationName:"predictedScores" type:"map"`

	// The prediction value for REGRESSION MLModel.
	PredictedValue *float64 `locationName:"predictedValue" type:"float"`

	metadataPrediction `json:"-" xml:"-"`
}

type metadataPrediction struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Prediction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Prediction) GoString() string {
	return s.String()
}

// The data specification of an Amazon Relational Database Service (Amazon RDS)
// DataSource.
type RDSDataSpec struct {
	// DataRearrangement - A JSON string that represents the splitting requirement
	// of a DataSource.
	//
	//   Sample -  "{\"randomSeed\":\"some-random-seed\", \"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
	DataRearrangement *string `type:"string"`

	// A JSON string that represents the schema. This is not required if DataSchemaUri
	// is specified.
	DataSchema *string `type:"string"`

	// The Amazon S3 location of the DataSchema.
	DataSchemaURI *string `locationName:"DataSchemaUri" type:"string"`

	// The AWS Identity and Access Management (IAM) credentials that are used connect
	// to the Amazon RDS database.
	DatabaseCredentials *RDSDatabaseCredentials `type:"structure" required:"true"`

	// Describes the DatabaseName and InstanceIdentifier of an an Amazon RDS database.
	DatabaseInformation *RDSDatabase `type:"structure" required:"true"`

	// The role (DataPipelineDefaultResourceRole) assumed by an Amazon Elastic Compute
	// Cloud (Amazon EC2) instance to carry out the copy operation from Amazon RDS
	// to an Amazon S3 task. For more information, see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	ResourceRole *string `type:"string" required:"true"`

	// The Amazon S3 location for staging Amazon RDS data. The data retrieved from
	// Amazon RDS using SelectSqlQuery is stored in this location.
	S3StagingLocation *string `type:"string" required:"true"`

	// The security group IDs to be used to access a VPC-based RDS DB instance.
	// Ensure that there are appropriate ingress rules set up to allow access to
	// the RDS DB instance. This attribute is used by Data Pipeline to carry out
	// the copy operation from Amazon RDS to an Amazon S3 task.
	SecurityGroupIDs []*string `locationName:"SecurityGroupIds" type:"list" required:"true"`

	// The query that is used to retrieve the observation data for the DataSource.
	SelectSQLQuery *string `locationName:"SelectSqlQuery" type:"string" required:"true"`

	// The role (DataPipelineDefaultRole) assumed by AWS Data Pipeline service to
	// monitor the progress of the copy task from Amazon RDS to Amazon S3. For more
	// information, see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	ServiceRole *string `type:"string" required:"true"`

	// The subnet ID to be used to access a VPC-based RDS DB instance. This attribute
	// is used by Data Pipeline to carry out the copy task from Amazon RDS to Amazon
	// S3.
	SubnetID *string `locationName:"SubnetId" type:"string" required:"true"`

	metadataRDSDataSpec `json:"-" xml:"-"`
}

type metadataRDSDataSpec struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RDSDataSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RDSDataSpec) GoString() string {
	return s.String()
}

// The database details of an Amazon RDS database.
type RDSDatabase struct {
	// The name of a database hosted on an RDS DB instance.
	DatabaseName *string `type:"string" required:"true"`

	// The ID of an RDS DB instance.
	InstanceIdentifier *string `type:"string" required:"true"`

	metadataRDSDatabase `json:"-" xml:"-"`
}

type metadataRDSDatabase struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RDSDatabase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RDSDatabase) GoString() string {
	return s.String()
}

// The database credentials to connect to a database on an RDS DB instance.
type RDSDatabaseCredentials struct {
	// The password to be used by Amazon ML to connect to a database on an RDS DB
	// instance. The password should have sufficient permissions to execute the
	// RDSSelectQuery query.
	Password *string `type:"string" required:"true"`

	// The username to be used by Amazon ML to connect to database on an Amazon
	// RDS instance. The username should have sufficient permissions to execute
	// an RDSSelectSqlQuery query.
	Username *string `type:"string" required:"true"`

	metadataRDSDatabaseCredentials `json:"-" xml:"-"`
}

type metadataRDSDatabaseCredentials struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RDSDatabaseCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RDSDatabaseCredentials) GoString() string {
	return s.String()
}

// The datasource details that are specific to Amazon RDS.
type RDSMetadata struct {
	// The ID of the Data Pipeline instance that is used to carry to copy data from
	// Amazon RDS to Amazon S3. You can use the ID to find details about the instance
	// in the Data Pipeline console.
	DataPipelineID *string `locationName:"DataPipelineId" type:"string"`

	// The database details required to connect to an Amazon RDS.
	Database *RDSDatabase `type:"structure"`

	// The username to be used by Amazon ML to connect to database on an Amazon
	// RDS instance. The username should have sufficient permissions to execute
	// an RDSSelectSqlQuery query.
	DatabaseUserName *string `type:"string"`

	// The role (DataPipelineDefaultResourceRole) assumed by an Amazon EC2 instance
	// to carry out the copy task from Amazon RDS to Amazon S3. For more information,
	// see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	ResourceRole *string `type:"string"`

	// The SQL query that is supplied during CreateDataSourceFromRDS. Returns only
	// if Verbose is true in GetDataSourceInput.
	SelectSQLQuery *string `locationName:"SelectSqlQuery" type:"string"`

	// The role (DataPipelineDefaultRole) assumed by the Data Pipeline service to
	// monitor the progress of the copy task from Amazon RDS to Amazon S3. For more
	// information, see Role templates (http://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html)
	// for data pipelines.
	ServiceRole *string `type:"string"`

	metadataRDSMetadata `json:"-" xml:"-"`
}

type metadataRDSMetadata struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RDSMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RDSMetadata) GoString() string {
	return s.String()
}

// Describes the real-time endpoint information for an MLModel.
type RealtimeEndpointInfo struct {
	// The time that the request to create the real-time endpoint for the MLModel
	// was received. The time is expressed in epoch time.
	CreatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The current status of the real-time endpoint for the MLModel. This element
	// can have one of the following values:
	//
	//  NONE - Endpoint does not exist or was previously deleted. READY - Endpoint
	// is ready to be used for real-time predictions. UPDATING - Updating/creating
	// the endpoint.
	EndpointStatus *string `type:"string" enum:"RealtimeEndpointStatus"`

	// The URI that specifies where to send real-time prediction requests for the
	// MLModel.
	//
	// Note The application must wait until the real-time endpoint is ready before
	// using this URI.
	EndpointURL *string `locationName:"EndpointUrl" type:"string"`

	// The maximum processing rate for the real-time endpoint for MLModel, measured
	// in incoming requests per second.
	PeakRequestsPerSecond *int64 `type:"integer"`

	metadataRealtimeEndpointInfo `json:"-" xml:"-"`
}

type metadataRealtimeEndpointInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RealtimeEndpointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RealtimeEndpointInfo) GoString() string {
	return s.String()
}

// Describes the data specification of an Amazon Redshift DataSource.
type RedshiftDataSpec struct {
	// Describes the splitting specifications for a DataSource.
	DataRearrangement *string `type:"string"`

	// Describes the schema for an Amazon Redshift DataSource.
	DataSchema *string `type:"string"`

	// Describes the schema location for an Amazon Redshift DataSource.
	DataSchemaURI *string `locationName:"DataSchemaUri" type:"string"`

	// Describes AWS Identity and Access Management (IAM) credentials that are used
	// connect to the Amazon Redshift database.
	DatabaseCredentials *RedshiftDatabaseCredentials `type:"structure" required:"true"`

	// Describes the DatabaseName and ClusterIdentifier for an Amazon Redshift DataSource.
	DatabaseInformation *RedshiftDatabase `type:"structure" required:"true"`

	// Describes an Amazon S3 location to store the result set of the SelectSqlQuery
	// query.
	S3StagingLocation *string `type:"string" required:"true"`

	// Describes the SQL Query to execute on an Amazon Redshift database for an
	// Amazon Redshift DataSource.
	SelectSQLQuery *string `locationName:"SelectSqlQuery" type:"string" required:"true"`

	metadataRedshiftDataSpec `json:"-" xml:"-"`
}

type metadataRedshiftDataSpec struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RedshiftDataSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDataSpec) GoString() string {
	return s.String()
}

// Describes the database details required to connect to an Amazon Redshift
// database.
type RedshiftDatabase struct {
	// The ID of an Amazon Redshift cluster.
	ClusterIdentifier *string `type:"string" required:"true"`

	// The name of a database hosted on an Amazon Redshift cluster.
	DatabaseName *string `type:"string" required:"true"`

	metadataRedshiftDatabase `json:"-" xml:"-"`
}

type metadataRedshiftDatabase struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RedshiftDatabase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDatabase) GoString() string {
	return s.String()
}

// Describes the database credentials for connecting to a database on an Amazon
// Redshift cluster.
type RedshiftDatabaseCredentials struct {
	// A password to be used by Amazon ML to connect to a database on an Amazon
	// Redshift cluster. The password should have sufficient permissions to execute
	// a RedshiftSelectSqlQuery query. The password should be valid for an Amazon
	// Redshift USER (http://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
	Password *string `type:"string" required:"true"`

	// A username to be used by Amazon Machine Learning (Amazon ML)to connect to
	// a database on an Amazon Redshift cluster. The username should have sufficient
	// permissions to execute the RedshiftSelectSqlQuery query. The username should
	// be valid for an Amazon Redshift USER (http://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
	Username *string `type:"string" required:"true"`

	metadataRedshiftDatabaseCredentials `json:"-" xml:"-"`
}

type metadataRedshiftDatabaseCredentials struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RedshiftDatabaseCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftDatabaseCredentials) GoString() string {
	return s.String()
}

// Describes the DataSource details specific to Amazon Redshift.
type RedshiftMetadata struct {
	// A username to be used by Amazon Machine Learning (Amazon ML)to connect to
	// a database on an Amazon Redshift cluster. The username should have sufficient
	// permissions to execute the RedshiftSelectSqlQuery query. The username should
	// be valid for an Amazon Redshift USER (http://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html).
	DatabaseUserName *string `type:"string"`

	// Describes the database details required to connect to an Amazon Redshift
	// database.
	RedshiftDatabase *RedshiftDatabase `type:"structure"`

	// The SQL query that is specified during CreateDataSourceFromRedshift. Returns
	// only if Verbose is true in GetDataSourceInput.
	SelectSQLQuery *string `locationName:"SelectSqlQuery" type:"string"`

	metadataRedshiftMetadata `json:"-" xml:"-"`
}

type metadataRedshiftMetadata struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RedshiftMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftMetadata) GoString() string {
	return s.String()
}

// Describes the data specification of a DataSource.
type S3DataSpec struct {
	// The location of the data file(s) used by a DataSource. The URI specifies
	// a data file or an Amazon Simple Storage Service (Amazon S3) directory or
	// bucket containing data files.
	DataLocationS3 *string `type:"string" required:"true"`

	// Describes the splitting requirement of a Datasource.
	DataRearrangement *string `type:"string"`

	// Describes the schema for an Amazon S3 DataSource.
	DataSchema *string `type:"string"`

	// Describes the schema Location in Amazon S3.
	DataSchemaLocationS3 *string `type:"string"`

	metadataS3DataSpec `json:"-" xml:"-"`
}

type metadataS3DataSpec struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s S3DataSpec) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3DataSpec) GoString() string {
	return s.String()
}

type UpdateBatchPredictionInput struct {
	// The ID assigned to the BatchPrediction during creation.
	BatchPredictionID *string `locationName:"BatchPredictionId" type:"string" required:"true"`

	// A new user-supplied name or description of the BatchPrediction.
	BatchPredictionName *string `type:"string" required:"true"`

	metadataUpdateBatchPredictionInput `json:"-" xml:"-"`
}

type metadataUpdateBatchPredictionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateBatchPredictionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBatchPredictionInput) GoString() string {
	return s.String()
}

// Represents the output of an UpdateBatchPrediction operation.
//
// You can see the updated content by using the GetBatchPrediction operation.
type UpdateBatchPredictionOutput struct {
	// The ID assigned to the BatchPrediction during creation. This value should
	// be identical to the value of the BatchPredictionId in the request.
	BatchPredictionID *string `locationName:"BatchPredictionId" type:"string"`

	metadataUpdateBatchPredictionOutput `json:"-" xml:"-"`
}

type metadataUpdateBatchPredictionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateBatchPredictionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBatchPredictionOutput) GoString() string {
	return s.String()
}

type UpdateDataSourceInput struct {
	// The ID assigned to the DataSource during creation.
	DataSourceID *string `locationName:"DataSourceId" type:"string" required:"true"`

	// A new user-supplied name or description of the DataSource that will replace
	// the current description.
	DataSourceName *string `type:"string" required:"true"`

	metadataUpdateDataSourceInput `json:"-" xml:"-"`
}

type metadataUpdateDataSourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceInput) GoString() string {
	return s.String()
}

// Represents the output of an UpdateDataSource operation.
//
// You can see the updated content by using the GetBatchPrediction operation.
type UpdateDataSourceOutput struct {
	// The ID assigned to the DataSource during creation. This value should be identical
	// to the value of the DataSourceID in the request.
	DataSourceID *string `locationName:"DataSourceId" type:"string"`

	metadataUpdateDataSourceOutput `json:"-" xml:"-"`
}

type metadataUpdateDataSourceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDataSourceOutput) GoString() string {
	return s.String()
}

type UpdateEvaluationInput struct {
	// The ID assigned to the Evaluation during creation.
	EvaluationID *string `locationName:"EvaluationId" type:"string" required:"true"`

	// A new user-supplied name or description of the Evaluation that will replace
	// the current content.
	EvaluationName *string `type:"string" required:"true"`

	metadataUpdateEvaluationInput `json:"-" xml:"-"`
}

type metadataUpdateEvaluationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateEvaluationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEvaluationInput) GoString() string {
	return s.String()
}

// Represents the output of an UpdateEvaluation operation.
//
// You can see the updated content by using the GetEvaluation operation.
type UpdateEvaluationOutput struct {
	// The ID assigned to the Evaluation during creation. This value should be identical
	// to the value of the Evaluation in the request.
	EvaluationID *string `locationName:"EvaluationId" type:"string"`

	metadataUpdateEvaluationOutput `json:"-" xml:"-"`
}

type metadataUpdateEvaluationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateEvaluationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEvaluationOutput) GoString() string {
	return s.String()
}

type UpdateMLModelInput struct {
	// The ID assigned to the MLModel during creation.
	MLModelID *string `locationName:"MLModelId" type:"string" required:"true"`

	// A user-supplied name or description of the MLModel.
	MLModelName *string `type:"string"`

	// The ScoreThreshold used in binary classification MLModel that marks the boundary
	// between a positive prediction and a negative prediction.
	//
	// Output values greater than or equal to the ScoreThreshold receive a positive
	// result from the MLModel, such as true. Output values less than the ScoreThreshold
	// receive a negative response from the MLModel, such as false.
	ScoreThreshold *float64 `type:"float"`

	metadataUpdateMLModelInput `json:"-" xml:"-"`
}

type metadataUpdateMLModelInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMLModelInput) GoString() string {
	return s.String()
}

// Represents the output of an UpdateMLModel operation.
//
// You can see the updated content by using the GetMLModel operation.
type UpdateMLModelOutput struct {
	// The ID assigned to the MLModel during creation. This value should be identical
	// to the value of the MLModelID in the request.
	MLModelID *string `locationName:"MLModelId" type:"string"`

	metadataUpdateMLModelOutput `json:"-" xml:"-"`
}

type metadataUpdateMLModelOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMLModelOutput) GoString() string {
	return s.String()
}

// The function used to train a MLModel. Training choices supported by Amazon
// ML include the following:
//
//  SGD - Stochastic Gradient Descent. RandomForest - Random forest of decision
// trees.
const (
	// @enum Algorithm
	AlgorithmSgd = "sgd"
)

// A list of the variables to use in searching or filtering BatchPrediction.
//
//   CreatedAt - Sets the search criteria to BatchPrediction creation date.
//  Status - Sets the search criteria to BatchPrediction status.  Name - Sets
// the search criteria to the contents of BatchPrediction  Name.  IAMUser -
// Sets the search criteria to the user account that invoked the BatchPrediction
// creation.  MLModelId - Sets the search criteria to the MLModel used in the
// BatchPrediction.  DataSourceId - Sets the search criteria to the DataSource
// used in the BatchPrediction.  DataURI - Sets the search criteria to the data
// file(s) used in the BatchPrediction. The URL can identify either a file or
// an Amazon Simple Storage Service (Amazon S3) bucket or directory.
const (
	// @enum BatchPredictionFilterVariable
	BatchPredictionFilterVariableCreatedAt = "CreatedAt"
	// @enum BatchPredictionFilterVariable
	BatchPredictionFilterVariableLastUpdatedAt = "LastUpdatedAt"
	// @enum BatchPredictionFilterVariable
	BatchPredictionFilterVariableStatus = "Status"
	// @enum BatchPredictionFilterVariable
	BatchPredictionFilterVariableName = "Name"
	// @enum BatchPredictionFilterVariable
	BatchPredictionFilterVariableIamuser = "IAMUser"
	// @enum BatchPredictionFilterVariable
	BatchPredictionFilterVariableMlmodelId = "MLModelId"
	// @enum BatchPredictionFilterVariable
	BatchPredictionFilterVariableDataSourceId = "DataSourceId"
	// @enum BatchPredictionFilterVariable
	BatchPredictionFilterVariableDataUri = "DataURI"
)

// A list of the variables to use in searching or filtering DataSource.
//
//   CreatedAt - Sets the search criteria to DataSource creation date.  Status
// - Sets the search criteria to DataSource status.  Name - Sets the search
// criteria to the contents of DataSource   Name.  DataUri - Sets the search
// criteria to the URI of data files used to create the DataSource. The URI
// can identify either a file or an Amazon Simple Storage Service (Amazon S3)
// bucket or directory.  IAMUser - Sets the search criteria to the user account
// that invoked the DataSource creation.  Note The variable names should match
// the variable names in the DataSource.
const (
	// @enum DataSourceFilterVariable
	DataSourceFilterVariableCreatedAt = "CreatedAt"
	// @enum DataSourceFilterVariable
	DataSourceFilterVariableLastUpdatedAt = "LastUpdatedAt"
	// @enum DataSourceFilterVariable
	DataSourceFilterVariableStatus = "Status"
	// @enum DataSourceFilterVariable
	DataSourceFilterVariableName = "Name"
	// @enum DataSourceFilterVariable
	DataSourceFilterVariableDataLocationS3 = "DataLocationS3"
	// @enum DataSourceFilterVariable
	DataSourceFilterVariableIamuser = "IAMUser"
)

// Contains the key values of DetailsMap: PredictiveModelType - Indicates the
// type of the MLModel. Algorithm - Indicates the algorithm was used for the
// MLModel.
const (
	// @enum DetailsAttributes
	DetailsAttributesPredictiveModelType = "PredictiveModelType"
	// @enum DetailsAttributes
	DetailsAttributesAlgorithm = "Algorithm"
)

// Entity status with the following possible values:
//
//  PENDING INPROGRESS FAILED COMPLETED DELETED
const (
	// @enum EntityStatus
	EntityStatusPending = "PENDING"
	// @enum EntityStatus
	EntityStatusInprogress = "INPROGRESS"
	// @enum EntityStatus
	EntityStatusFailed = "FAILED"
	// @enum EntityStatus
	EntityStatusCompleted = "COMPLETED"
	// @enum EntityStatus
	EntityStatusDeleted = "DELETED"
)

// A list of the variables to use in searching or filtering Evaluation.
//
//   CreatedAt - Sets the search criteria to Evaluation creation date.  Status
// - Sets the search criteria to Evaluation status.  Name - Sets the search
// criteria to the contents of Evaluation   Name.  IAMUser - Sets the search
// criteria to the user account that invoked an evaluation.  MLModelId - Sets
// the search criteria to the Predictor that was evaluated.  DataSourceId -
// Sets the search criteria to the DataSource used in evaluation.  DataUri -
// Sets the search criteria to the data file(s) used in evaluation. The URL
// can identify either a file or an Amazon Simple Storage Service (Amazon S3)
// bucket or directory.
const (
	// @enum EvaluationFilterVariable
	EvaluationFilterVariableCreatedAt = "CreatedAt"
	// @enum EvaluationFilterVariable
	EvaluationFilterVariableLastUpdatedAt = "LastUpdatedAt"
	// @enum EvaluationFilterVariable
	EvaluationFilterVariableStatus = "Status"
	// @enum EvaluationFilterVariable
	EvaluationFilterVariableName = "Name"
	// @enum EvaluationFilterVariable
	EvaluationFilterVariableIamuser = "IAMUser"
	// @enum EvaluationFilterVariable
	EvaluationFilterVariableMlmodelId = "MLModelId"
	// @enum EvaluationFilterVariable
	EvaluationFilterVariableDataSourceId = "DataSourceId"
	// @enum EvaluationFilterVariable
	EvaluationFilterVariableDataUri = "DataURI"
)

const (
	// @enum MLModelFilterVariable
	MLModelFilterVariableCreatedAt = "CreatedAt"
	// @enum MLModelFilterVariable
	MLModelFilterVariableLastUpdatedAt = "LastUpdatedAt"
	// @enum MLModelFilterVariable
	MLModelFilterVariableStatus = "Status"
	// @enum MLModelFilterVariable
	MLModelFilterVariableName = "Name"
	// @enum MLModelFilterVariable
	MLModelFilterVariableIamuser = "IAMUser"
	// @enum MLModelFilterVariable
	MLModelFilterVariableTrainingDataSourceId = "TrainingDataSourceId"
	// @enum MLModelFilterVariable
	MLModelFilterVariableRealtimeEndpointStatus = "RealtimeEndpointStatus"
	// @enum MLModelFilterVariable
	MLModelFilterVariableMlmodelType = "MLModelType"
	// @enum MLModelFilterVariable
	MLModelFilterVariableAlgorithm = "Algorithm"
	// @enum MLModelFilterVariable
	MLModelFilterVariableTrainingDataUri = "TrainingDataURI"
)

const (
	// @enum MLModelType
	MLModelTypeRegression = "REGRESSION"
	// @enum MLModelType
	MLModelTypeBinary = "BINARY"
	// @enum MLModelType
	MLModelTypeMulticlass = "MULTICLASS"
)

const (
	// @enum RealtimeEndpointStatus
	RealtimeEndpointStatusNone = "NONE"
	// @enum RealtimeEndpointStatus
	RealtimeEndpointStatusReady = "READY"
	// @enum RealtimeEndpointStatus
	RealtimeEndpointStatusUpdating = "UPDATING"
	// @enum RealtimeEndpointStatus
	RealtimeEndpointStatusFailed = "FAILED"
)

// The sort order specified in a listing condition. Possible values include
// the following:
//
//   asc - Present the information in ascending order (from A-Z).  dsc - Present
// the information in descending order (from Z-A).
const (
	// @enum SortOrder
	SortOrderAsc = "asc"
	// @enum SortOrder
	SortOrderDsc = "dsc"
)
