// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ses provides a client for Amazon Simple Email Service.
package ses

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/service"
)

const opDeleteIdentity = "DeleteIdentity"

// DeleteIdentityRequest generates a request for the DeleteIdentity operation.
func (c *SES) DeleteIdentityRequest(input *DeleteIdentityInput) (req *service.Request, output *DeleteIdentityOutput) {
	op := &service.Operation{
		Name:       opDeleteIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIdentityOutput{}
	req.Data = output
	return
}

// Deletes the specified identity (email address or domain) from the list of
// verified identities.
//
// This action is throttled at one request per second.
func (c *SES) DeleteIdentity(input *DeleteIdentityInput) (*DeleteIdentityOutput, error) {
	req, out := c.DeleteIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIdentityPolicy = "DeleteIdentityPolicy"

// DeleteIdentityPolicyRequest generates a request for the DeleteIdentityPolicy operation.
func (c *SES) DeleteIdentityPolicyRequest(input *DeleteIdentityPolicyInput) (req *service.Request, output *DeleteIdentityPolicyOutput) {
	op := &service.Operation{
		Name:       opDeleteIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIdentityPolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified sending authorization policy for the given identity
// (email address or domain). This API returns successfully even if a policy
// with the specified name does not exist.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error. Sending authorization is a feature that enables
// an identity owner to authorize other senders to use its identities. For information
// about using sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
func (c *SES) DeleteIdentityPolicy(input *DeleteIdentityPolicyInput) (*DeleteIdentityPolicyOutput, error) {
	req, out := c.DeleteIdentityPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVerifiedEmailAddress = "DeleteVerifiedEmailAddress"

// DeleteVerifiedEmailAddressRequest generates a request for the DeleteVerifiedEmailAddress operation.
func (c *SES) DeleteVerifiedEmailAddressRequest(input *DeleteVerifiedEmailAddressInput) (req *service.Request, output *DeleteVerifiedEmailAddressOutput) {
	op := &service.Operation{
		Name:       opDeleteVerifiedEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVerifiedEmailAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVerifiedEmailAddressOutput{}
	req.Data = output
	return
}

// Deletes the specified email address from the list of verified addresses.
//
// The DeleteVerifiedEmailAddress action is deprecated as of the May 15, 2012
// release of Domain Verification. The DeleteIdentity action is now preferred.
// This action is throttled at one request per second.
func (c *SES) DeleteVerifiedEmailAddress(input *DeleteVerifiedEmailAddressInput) (*DeleteVerifiedEmailAddressOutput, error) {
	req, out := c.DeleteVerifiedEmailAddressRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityDKIMAttributes = "GetIdentityDkimAttributes"

// GetIdentityDKIMAttributesRequest generates a request for the GetIdentityDKIMAttributes operation.
func (c *SES) GetIdentityDKIMAttributesRequest(input *GetIdentityDKIMAttributesInput) (req *service.Request, output *GetIdentityDKIMAttributesOutput) {
	op := &service.Operation{
		Name:       opGetIdentityDKIMAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityDKIMAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityDKIMAttributesOutput{}
	req.Data = output
	return
}

// Returns the current status of Easy DKIM signing for an entity. For domain
// name identities, this action also returns the DKIM tokens that are required
// for Easy DKIM signing, and whether Amazon SES has successfully verified that
// these tokens have been published.
//
// This action takes a list of identities as input and returns the following
// information for each:
//
//  Whether Easy DKIM signing is enabled or disabled. A set of DKIM tokens
// that represent the identity. If the identity is an email address, the tokens
// represent the domain of that address. Whether Amazon SES has successfully
// verified the DKIM tokens published in the domain's DNS. This information
// is only returned for domain name identities, not for email addresses.  This
// action is throttled at one request per second and can only get DKIM attributes
// for up to 100 identities at a time.
//
// For more information about creating DNS records using DKIM tokens, go to
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
func (c *SES) GetIdentityDKIMAttributes(input *GetIdentityDKIMAttributesInput) (*GetIdentityDKIMAttributesOutput, error) {
	req, out := c.GetIdentityDKIMAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityNotificationAttributes = "GetIdentityNotificationAttributes"

// GetIdentityNotificationAttributesRequest generates a request for the GetIdentityNotificationAttributes operation.
func (c *SES) GetIdentityNotificationAttributesRequest(input *GetIdentityNotificationAttributesInput) (req *service.Request, output *GetIdentityNotificationAttributesOutput) {
	op := &service.Operation{
		Name:       opGetIdentityNotificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityNotificationAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityNotificationAttributesOutput{}
	req.Data = output
	return
}

// Given a list of verified identities (email addresses and/or domains), returns
// a structure describing identity notification attributes.
//
// This action is throttled at one request per second and can only get notification
// attributes for up to 100 identities at a time.
//
// For more information about using notifications with Amazon SES, see the
// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
func (c *SES) GetIdentityNotificationAttributes(input *GetIdentityNotificationAttributesInput) (*GetIdentityNotificationAttributesOutput, error) {
	req, out := c.GetIdentityNotificationAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityPolicies = "GetIdentityPolicies"

// GetIdentityPoliciesRequest generates a request for the GetIdentityPolicies operation.
func (c *SES) GetIdentityPoliciesRequest(input *GetIdentityPoliciesInput) (req *service.Request, output *GetIdentityPoliciesOutput) {
	op := &service.Operation{
		Name:       opGetIdentityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityPoliciesOutput{}
	req.Data = output
	return
}

// Returns the requested sending authorization policies for the given identity
// (email address or domain). The policies are returned as a map of policy names
// to policy contents. You can retrieve a maximum of 20 policies at a time.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error. Sending authorization is a feature that enables
// an identity owner to authorize other senders to use its identities. For information
// about using sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
func (c *SES) GetIdentityPolicies(input *GetIdentityPoliciesInput) (*GetIdentityPoliciesOutput, error) {
	req, out := c.GetIdentityPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityVerificationAttributes = "GetIdentityVerificationAttributes"

// GetIdentityVerificationAttributesRequest generates a request for the GetIdentityVerificationAttributes operation.
func (c *SES) GetIdentityVerificationAttributesRequest(input *GetIdentityVerificationAttributesInput) (req *service.Request, output *GetIdentityVerificationAttributesOutput) {
	op := &service.Operation{
		Name:       opGetIdentityVerificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityVerificationAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityVerificationAttributesOutput{}
	req.Data = output
	return
}

// Given a list of identities (email addresses and/or domains), returns the
// verification status and (for domain identities) the verification token for
// each identity.
//
// This action is throttled at one request per second and can only get verification
// attributes for up to 100 identities at a time.
func (c *SES) GetIdentityVerificationAttributes(input *GetIdentityVerificationAttributesInput) (*GetIdentityVerificationAttributesOutput, error) {
	req, out := c.GetIdentityVerificationAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetSendQuota = "GetSendQuota"

// GetSendQuotaRequest generates a request for the GetSendQuota operation.
func (c *SES) GetSendQuotaRequest(input *GetSendQuotaInput) (req *service.Request, output *GetSendQuotaOutput) {
	op := &service.Operation{
		Name:       opGetSendQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSendQuotaInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSendQuotaOutput{}
	req.Data = output
	return
}

// Returns the user's current sending limits.
//
// This action is throttled at one request per second.
func (c *SES) GetSendQuota(input *GetSendQuotaInput) (*GetSendQuotaOutput, error) {
	req, out := c.GetSendQuotaRequest(input)
	err := req.Send()
	return out, err
}

const opGetSendStatistics = "GetSendStatistics"

// GetSendStatisticsRequest generates a request for the GetSendStatistics operation.
func (c *SES) GetSendStatisticsRequest(input *GetSendStatisticsInput) (req *service.Request, output *GetSendStatisticsOutput) {
	op := &service.Operation{
		Name:       opGetSendStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSendStatisticsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSendStatisticsOutput{}
	req.Data = output
	return
}

// Returns the user's sending statistics. The result is a list of data points,
// representing the last two weeks of sending activity.
//
// Each data point in the list contains statistics for a 15-minute interval.
//
// This action is throttled at one request per second.
func (c *SES) GetSendStatistics(input *GetSendStatisticsInput) (*GetSendStatisticsOutput, error) {
	req, out := c.GetSendStatisticsRequest(input)
	err := req.Send()
	return out, err
}

const opListIdentities = "ListIdentities"

// ListIdentitiesRequest generates a request for the ListIdentities operation.
func (c *SES) ListIdentitiesRequest(input *ListIdentitiesInput) (req *service.Request, output *ListIdentitiesOutput) {
	op := &service.Operation{
		Name:       opListIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentitiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListIdentitiesOutput{}
	req.Data = output
	return
}

// Returns a list containing all of the identities (email addresses and domains)
// for a specific AWS Account, regardless of verification status.
//
// This action is throttled at one request per second.
func (c *SES) ListIdentities(input *ListIdentitiesInput) (*ListIdentitiesOutput, error) {
	req, out := c.ListIdentitiesRequest(input)
	err := req.Send()
	return out, err
}

func (c *SES) ListIdentitiesPages(input *ListIdentitiesInput, fn func(p *ListIdentitiesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListIdentitiesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListIdentitiesOutput), lastPage)
	})
}

const opListIdentityPolicies = "ListIdentityPolicies"

// ListIdentityPoliciesRequest generates a request for the ListIdentityPolicies operation.
func (c *SES) ListIdentityPoliciesRequest(input *ListIdentityPoliciesInput) (req *service.Request, output *ListIdentityPoliciesOutput) {
	op := &service.Operation{
		Name:       opListIdentityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentityPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListIdentityPoliciesOutput{}
	req.Data = output
	return
}

// Returns a list of sending authorization policies that are attached to the
// given identity (email address or domain). This API returns only a list. If
// you want the actual policy content, you can use GetIdentityPolicies.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error. Sending authorization is a feature that enables
// an identity owner to authorize other senders to use its identities. For information
// about using sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
func (c *SES) ListIdentityPolicies(input *ListIdentityPoliciesInput) (*ListIdentityPoliciesOutput, error) {
	req, out := c.ListIdentityPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opListVerifiedEmailAddresses = "ListVerifiedEmailAddresses"

// ListVerifiedEmailAddressesRequest generates a request for the ListVerifiedEmailAddresses operation.
func (c *SES) ListVerifiedEmailAddressesRequest(input *ListVerifiedEmailAddressesInput) (req *service.Request, output *ListVerifiedEmailAddressesOutput) {
	op := &service.Operation{
		Name:       opListVerifiedEmailAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVerifiedEmailAddressesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVerifiedEmailAddressesOutput{}
	req.Data = output
	return
}

// Returns a list containing all of the email addresses that have been verified.
//
// The ListVerifiedEmailAddresses action is deprecated as of the May 15, 2012
// release of Domain Verification. The ListIdentities action is now preferred.
// This action is throttled at one request per second.
func (c *SES) ListVerifiedEmailAddresses(input *ListVerifiedEmailAddressesInput) (*ListVerifiedEmailAddressesOutput, error) {
	req, out := c.ListVerifiedEmailAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opPutIdentityPolicy = "PutIdentityPolicy"

// PutIdentityPolicyRequest generates a request for the PutIdentityPolicy operation.
func (c *SES) PutIdentityPolicyRequest(input *PutIdentityPolicyInput) (req *service.Request, output *PutIdentityPolicyOutput) {
	op := &service.Operation{
		Name:       opPutIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutIdentityPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutIdentityPolicyOutput{}
	req.Data = output
	return
}

// Adds or updates a sending authorization policy for the specified identity
// (email address or domain).
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error. Sending authorization is a feature that enables
// an identity owner to authorize other senders to use its identities. For information
// about using sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
func (c *SES) PutIdentityPolicy(input *PutIdentityPolicyInput) (*PutIdentityPolicyOutput, error) {
	req, out := c.PutIdentityPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opSendEmail = "SendEmail"

// SendEmailRequest generates a request for the SendEmail operation.
func (c *SES) SendEmailRequest(input *SendEmailInput) (req *service.Request, output *SendEmailOutput) {
	op := &service.Operation{
		Name:       opSendEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendEmailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SendEmailOutput{}
	req.Data = output
	return
}

// Composes an email message based on input data, and then immediately queues
// the message for sending.
//
// There are several important points to know about SendEmail:
//
//  You can only send email from verified email addresses and domains; otherwise,
// you will get an "Email address not verified" error. If your account is still
// in the Amazon SES sandbox, you must also verify every recipient email address
// except for the recipients provided by the Amazon SES mailbox simulator. For
// more information, go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
// The total size of the message cannot exceed 10 MB. This includes any attachments
// that are part of the message. Amazon SES has a limit on the total number
// of recipients per message. The combined number of To:, CC: and BCC: email
// addresses cannot exceed 50. If you need to send an email message to a larger
// audience, you can divide your recipient list into groups of 50 or fewer,
// and then call Amazon SES repeatedly to send the message to each group. For
// every message that you send, the total number of recipients (To:, CC: and
// BCC:) is counted against your sending quota - the maximum number of emails
// you can send in a 24-hour period. For information about your sending quota,
// go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html).
func (c *SES) SendEmail(input *SendEmailInput) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	err := req.Send()
	return out, err
}

const opSendRawEmail = "SendRawEmail"

// SendRawEmailRequest generates a request for the SendRawEmail operation.
func (c *SES) SendRawEmailRequest(input *SendRawEmailInput) (req *service.Request, output *SendRawEmailOutput) {
	op := &service.Operation{
		Name:       opSendRawEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendRawEmailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SendRawEmailOutput{}
	req.Data = output
	return
}

// Sends an email message, with header and content specified by the client.
// The SendRawEmail action is useful for sending multipart MIME emails. The
// raw text of the message must comply with Internet email standards; otherwise,
// the message cannot be sent.
//
// There are several important points to know about SendRawEmail:
//
//  You can only send email from verified email addresses and domains; otherwise,
// you will get an "Email address not verified" error. If your account is still
// in the Amazon SES sandbox, you must also verify every recipient email address
// except for the recipients provided by the Amazon SES mailbox simulator. For
// more information, go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
// The total size of the message cannot exceed 10 MB. This includes any attachments
// that are part of the message. Amazon SES has a limit on the total number
// of recipients per message. The combined number of To:, CC: and BCC: email
// addresses cannot exceed 50. If you need to send an email message to a larger
// audience, you can divide your recipient list into groups of 50 or fewer,
// and then call Amazon SES repeatedly to send the message to each group. The
// To:, CC:, and BCC: headers in the raw message can contain a group list. Note
// that each recipient in a group list counts towards the 50-recipient limit.
// For every message that you send, the total number of recipients (To:, CC:
// and BCC:) is counted against your sending quota - the maximum number of emails
// you can send in a 24-hour period. For information about your sending quota,
// go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html).
// If you are using sending authorization to send on behalf of another user,
// SendRawEmail enables you to specify the cross-account identity for the email's
// "Source," "From," and "Return-Path" parameters in one of two ways: you can
// pass optional parameters SourceArn, FromArn, and/or ReturnPathArn to the
// API, or you can include the following X-headers in the header of your raw
// email:  X-SES-SOURCE-ARN X-SES-FROM-ARN X-SES-RETURN-PATH-ARN  Do not include
// these X-headers in the DKIM signature, because they are removed by Amazon
// SES before sending the email. For the most common sending authorization use
// case, we recommend that you specify the SourceIdentityArn and do not specify
// either the FromIdentityArn or ReturnPathIdentityArn. (The same note applies
// to the corresponding X-headers.) If you only specify the SourceIdentityArn,
// Amazon SES will simply set the "From" address and the "Return Path" address
// to the identity specified in SourceIdentityArn. For more information about
// sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
func (c *SES) SendRawEmail(input *SendRawEmailInput) (*SendRawEmailOutput, error) {
	req, out := c.SendRawEmailRequest(input)
	err := req.Send()
	return out, err
}

const opSetIdentityDKIMEnabled = "SetIdentityDkimEnabled"

// SetIdentityDKIMEnabledRequest generates a request for the SetIdentityDKIMEnabled operation.
func (c *SES) SetIdentityDKIMEnabledRequest(input *SetIdentityDKIMEnabledInput) (req *service.Request, output *SetIdentityDKIMEnabledOutput) {
	op := &service.Operation{
		Name:       opSetIdentityDKIMEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityDKIMEnabledInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetIdentityDKIMEnabledOutput{}
	req.Data = output
	return
}

// Enables or disables Easy DKIM signing of email sent from an identity:
//
//  If Easy DKIM signing is enabled for a domain name identity (e.g., example.com),
// then Amazon SES will DKIM-sign all email sent by addresses under that domain
// name (e.g., user@example.com). If Easy DKIM signing is enabled for an email
// address, then Amazon SES will DKIM-sign all email sent by that email address.
//  For email addresses (e.g., user@example.com), you can only enable Easy DKIM
// signing if the corresponding domain (e.g., example.com) has been set up for
// Easy DKIM using the AWS Console or the VerifyDomainDkim action.
//
// This action is throttled at one request per second.
//
// For more information about Easy DKIM signing, go to the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
func (c *SES) SetIdentityDKIMEnabled(input *SetIdentityDKIMEnabledInput) (*SetIdentityDKIMEnabledOutput, error) {
	req, out := c.SetIdentityDKIMEnabledRequest(input)
	err := req.Send()
	return out, err
}

const opSetIdentityFeedbackForwardingEnabled = "SetIdentityFeedbackForwardingEnabled"

// SetIdentityFeedbackForwardingEnabledRequest generates a request for the SetIdentityFeedbackForwardingEnabled operation.
func (c *SES) SetIdentityFeedbackForwardingEnabledRequest(input *SetIdentityFeedbackForwardingEnabledInput) (req *service.Request, output *SetIdentityFeedbackForwardingEnabledOutput) {
	op := &service.Operation{
		Name:       opSetIdentityFeedbackForwardingEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityFeedbackForwardingEnabledInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetIdentityFeedbackForwardingEnabledOutput{}
	req.Data = output
	return
}

// Given an identity (email address or domain), enables or disables whether
// Amazon SES forwards bounce and complaint notifications as email. Feedback
// forwarding can only be disabled when Amazon Simple Notification Service (Amazon
// SNS) topics are specified for both bounces and complaints.
//
// Feedback forwarding does not apply to delivery notifications. Delivery notifications
// are only available through Amazon SNS. This action is throttled at one request
// per second.
//
// For more information about using notifications with Amazon SES, see the
// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
func (c *SES) SetIdentityFeedbackForwardingEnabled(input *SetIdentityFeedbackForwardingEnabledInput) (*SetIdentityFeedbackForwardingEnabledOutput, error) {
	req, out := c.SetIdentityFeedbackForwardingEnabledRequest(input)
	err := req.Send()
	return out, err
}

const opSetIdentityNotificationTopic = "SetIdentityNotificationTopic"

// SetIdentityNotificationTopicRequest generates a request for the SetIdentityNotificationTopic operation.
func (c *SES) SetIdentityNotificationTopicRequest(input *SetIdentityNotificationTopicInput) (req *service.Request, output *SetIdentityNotificationTopicOutput) {
	op := &service.Operation{
		Name:       opSetIdentityNotificationTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityNotificationTopicInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetIdentityNotificationTopicOutput{}
	req.Data = output
	return
}

// Given an identity (email address or domain), sets the Amazon Simple Notification
// Service (Amazon SNS) topic to which Amazon SES will publish bounce, complaint,
// and/or delivery notifications for emails sent with that identity as the Source.
//
// Unless feedback forwarding is enabled, you must specify Amazon SNS topics
// for bounce and complaint notifications. For more information, see SetIdentityFeedbackForwardingEnabled.
//  This action is throttled at one request per second.
//
// For more information about feedback notification, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
func (c *SES) SetIdentityNotificationTopic(input *SetIdentityNotificationTopicInput) (*SetIdentityNotificationTopicOutput, error) {
	req, out := c.SetIdentityNotificationTopicRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyDomainDKIM = "VerifyDomainDkim"

// VerifyDomainDKIMRequest generates a request for the VerifyDomainDKIM operation.
func (c *SES) VerifyDomainDKIMRequest(input *VerifyDomainDKIMInput) (req *service.Request, output *VerifyDomainDKIMOutput) {
	op := &service.Operation{
		Name:       opVerifyDomainDKIM,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyDomainDKIMInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VerifyDomainDKIMOutput{}
	req.Data = output
	return
}

// Returns a set of DKIM tokens for a domain. DKIM tokens are character strings
// that represent your domain's identity. Using these tokens, you will need
// to create DNS CNAME records that point to DKIM public keys hosted by Amazon
// SES. Amazon Web Services will eventually detect that you have updated your
// DNS records; this detection process may take up to 72 hours. Upon successful
// detection, Amazon SES will be able to DKIM-sign email originating from that
// domain.
//
// This action is throttled at one request per second.
//
// To enable or disable Easy DKIM signing for a domain, use the SetIdentityDkimEnabled
// action.
//
// For more information about creating DNS records using DKIM tokens, go to
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
func (c *SES) VerifyDomainDKIM(input *VerifyDomainDKIMInput) (*VerifyDomainDKIMOutput, error) {
	req, out := c.VerifyDomainDKIMRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyDomainIdentity = "VerifyDomainIdentity"

// VerifyDomainIdentityRequest generates a request for the VerifyDomainIdentity operation.
func (c *SES) VerifyDomainIdentityRequest(input *VerifyDomainIdentityInput) (req *service.Request, output *VerifyDomainIdentityOutput) {
	op := &service.Operation{
		Name:       opVerifyDomainIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyDomainIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VerifyDomainIdentityOutput{}
	req.Data = output
	return
}

// Verifies a domain.
//
// This action is throttled at one request per second.
func (c *SES) VerifyDomainIdentity(input *VerifyDomainIdentityInput) (*VerifyDomainIdentityOutput, error) {
	req, out := c.VerifyDomainIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyEmailAddress = "VerifyEmailAddress"

// VerifyEmailAddressRequest generates a request for the VerifyEmailAddress operation.
func (c *SES) VerifyEmailAddressRequest(input *VerifyEmailAddressInput) (req *service.Request, output *VerifyEmailAddressOutput) {
	op := &service.Operation{
		Name:       opVerifyEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyEmailAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VerifyEmailAddressOutput{}
	req.Data = output
	return
}

// Verifies an email address. This action causes a confirmation email message
// to be sent to the specified address.
//
// The VerifyEmailAddress action is deprecated as of the May 15, 2012 release
// of Domain Verification. The VerifyEmailIdentity action is now preferred.
// This action is throttled at one request per second.
func (c *SES) VerifyEmailAddress(input *VerifyEmailAddressInput) (*VerifyEmailAddressOutput, error) {
	req, out := c.VerifyEmailAddressRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyEmailIdentity = "VerifyEmailIdentity"

// VerifyEmailIdentityRequest generates a request for the VerifyEmailIdentity operation.
func (c *SES) VerifyEmailIdentityRequest(input *VerifyEmailIdentityInput) (req *service.Request, output *VerifyEmailIdentityOutput) {
	op := &service.Operation{
		Name:       opVerifyEmailIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyEmailIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VerifyEmailIdentityOutput{}
	req.Data = output
	return
}

// Verifies an email address. This action causes a confirmation email message
// to be sent to the specified address.
//
// This action is throttled at one request per second.
func (c *SES) VerifyEmailIdentity(input *VerifyEmailIdentityInput) (*VerifyEmailIdentityOutput, error) {
	req, out := c.VerifyEmailIdentityRequest(input)
	err := req.Send()
	return out, err
}

// Represents the body of the message. You can specify text, HTML, or both.
// If you use both, then the message should display correctly in the widest
// variety of email clients.
type Body struct {
	// The content of the message, in HTML format. Use this for email clients that
	// can process HTML. You can include clickable links, formatted text, and much
	// more in an HTML message.
	HTML *Content `locationName:"Html" type:"structure"`

	// The content of the message, in text format. Use this for text-based email
	// clients, or clients on high-latency networks (such as mobile devices).
	Text *Content `type:"structure"`

	metadataBody `json:"-" xml:"-"`
}

type metadataBody struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Body) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Body) GoString() string {
	return s.String()
}

// Represents textual data, plus an optional character set specification.
//
// By default, the text must be 7-bit ASCII, due to the constraints of the
// SMTP protocol. If the text must contain any other characters, then you must
// also specify a character set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.
type Content struct {
	// The character set of the content.
	Charset *string `type:"string"`

	// The textual data of the content.
	Data *string `type:"string" required:"true"`

	metadataContent `json:"-" xml:"-"`
}

type metadataContent struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Content) GoString() string {
	return s.String()
}

// Represents a request instructing the service to delete an identity from the
// list of identities for the AWS Account.
type DeleteIdentityInput struct {
	// The identity to be removed from the list of identities for the AWS Account.
	Identity *string `type:"string" required:"true"`

	metadataDeleteIdentityInput `json:"-" xml:"-"`
}

type metadataDeleteIdentityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type DeleteIdentityOutput struct {
	metadataDeleteIdentityOutput `json:"-" xml:"-"`
}

type metadataDeleteIdentityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to delete an authorization policy
// applying to an identity.
//
// This request succeeds regardless of whether the specified policy exists.
type DeleteIdentityPolicyInput struct {
	// The identity that is associated with the policy that you want to delete.
	// You can specify the identity by using its name or by using its Amazon Resource
	// Name (ARN). Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	Identity *string `type:"string" required:"true"`

	// The name of the policy to be deleted.
	PolicyName *string `type:"string" required:"true"`

	metadataDeleteIdentityPolicyInput `json:"-" xml:"-"`
}

type metadataDeleteIdentityPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPolicyInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type DeleteIdentityPolicyOutput struct {
	metadataDeleteIdentityPolicyOutput `json:"-" xml:"-"`
}

type metadataDeleteIdentityPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to delete an address from the
// list of verified email addresses.
type DeleteVerifiedEmailAddressInput struct {
	// An email address to be removed from the list of verified addresses.
	EmailAddress *string `type:"string" required:"true"`

	metadataDeleteVerifiedEmailAddressInput `json:"-" xml:"-"`
}

type metadataDeleteVerifiedEmailAddressInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVerifiedEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVerifiedEmailAddressInput) GoString() string {
	return s.String()
}

type DeleteVerifiedEmailAddressOutput struct {
	metadataDeleteVerifiedEmailAddressOutput `json:"-" xml:"-"`
}

type metadataDeleteVerifiedEmailAddressOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVerifiedEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVerifiedEmailAddressOutput) GoString() string {
	return s.String()
}

// Represents the destination of the message, consisting of To:, CC:, and BCC:
// fields.
//
//  By default, the string must be 7-bit ASCII. If the text must contain any
// other characters, then you must use MIME encoded-word syntax (RFC 2047) instead
// of a literal string. MIME encoded-word syntax uses the following form: =?charset?encoding?encoded-text?=.
// For more information, see RFC 2047 (http://tools.ietf.org/html/rfc2047).
type Destination struct {
	// The BCC: field(s) of the message.
	BCCAddresses []*string `locationName:"BccAddresses" type:"list"`

	// The CC: field(s) of the message.
	CCAddresses []*string `locationName:"CcAddresses" type:"list"`

	// The To: field(s) of the message.
	ToAddresses []*string `type:"list"`

	metadataDestination `json:"-" xml:"-"`
}

type metadataDestination struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// Given a list of verified identities, describes their DKIM attributes. The
// DKIM attributes of an email address identity includes whether DKIM signing
// is individually enabled or disabled for that address. The DKIM attributes
// of a domain name identity includes whether DKIM signing is enabled, as well
// as the DNS records (tokens) that must remain published in the domain name's
// DNS.
type GetIdentityDKIMAttributesInput struct {
	// A list of one or more verified identities - email addresses, domains, or
	// both.
	Identities []*string `type:"list" required:"true"`

	metadataGetIdentityDKIMAttributesInput `json:"-" xml:"-"`
}

type metadataGetIdentityDKIMAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityDKIMAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityDKIMAttributesInput) GoString() string {
	return s.String()
}

// Represents a list of all the DKIM attributes for the specified identity.
type GetIdentityDKIMAttributesOutput struct {
	// The DKIM attributes for an email address or a domain.
	DKIMAttributes map[string]*IdentityDKIMAttributes `locationName:"DkimAttributes" type:"map" required:"true"`

	metadataGetIdentityDKIMAttributesOutput `json:"-" xml:"-"`
}

type metadataGetIdentityDKIMAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityDKIMAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityDKIMAttributesOutput) GoString() string {
	return s.String()
}

type GetIdentityNotificationAttributesInput struct {
	// A list of one or more identities. You can specify an identity by using its
	// name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	Identities []*string `type:"list" required:"true"`

	metadataGetIdentityNotificationAttributesInput `json:"-" xml:"-"`
}

type metadataGetIdentityNotificationAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityNotificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityNotificationAttributesInput) GoString() string {
	return s.String()
}

// Describes whether an identity has Amazon Simple Notification Service (Amazon
// SNS) topics set for bounce, complaint, and/or delivery notifications, and
// specifies whether feedback forwarding is enabled for bounce and complaint
// notifications.
type GetIdentityNotificationAttributesOutput struct {
	// A map of Identity to IdentityNotificationAttributes.
	NotificationAttributes map[string]*IdentityNotificationAttributes `type:"map" required:"true"`

	metadataGetIdentityNotificationAttributesOutput `json:"-" xml:"-"`
}

type metadataGetIdentityNotificationAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityNotificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityNotificationAttributesOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to retrieve the text of a list
// of authorization policies applying to an identity.
type GetIdentityPoliciesInput struct {
	// The identity for which the policies will be retrieved. You can specify an
	// identity by using its name or by using its Amazon Resource Name (ARN). Examples:
	// user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	Identity *string `type:"string" required:"true"`

	// A list of the names of policies to be retrieved. You can retrieve a maximum
	// of 20 policies at a time. If you do not know the names of the policies that
	// are attached to the identity, you can use ListIdentityPolicies.
	PolicyNames []*string `type:"list" required:"true"`

	metadataGetIdentityPoliciesInput `json:"-" xml:"-"`
}

type metadataGetIdentityPoliciesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoliciesInput) GoString() string {
	return s.String()
}

// Represents a map of policy names to policies returned from a successful GetIdentityPolicies
// request.
type GetIdentityPoliciesOutput struct {
	// A map of policy names to policies.
	Policies map[string]*string `type:"map" required:"true"`

	metadataGetIdentityPoliciesOutput `json:"-" xml:"-"`
}

type metadataGetIdentityPoliciesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoliciesOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to provide the verification
// attributes for a list of identities.
type GetIdentityVerificationAttributesInput struct {
	// A list of identities.
	Identities []*string `type:"list" required:"true"`

	metadataGetIdentityVerificationAttributesInput `json:"-" xml:"-"`
}

type metadataGetIdentityVerificationAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityVerificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityVerificationAttributesInput) GoString() string {
	return s.String()
}

// Represents the verification attributes for a list of identities.
type GetIdentityVerificationAttributesOutput struct {
	// A map of Identities to IdentityVerificationAttributes objects.
	VerificationAttributes map[string]*IdentityVerificationAttributes `type:"map" required:"true"`

	metadataGetIdentityVerificationAttributesOutput `json:"-" xml:"-"`
}

type metadataGetIdentityVerificationAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityVerificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityVerificationAttributesOutput) GoString() string {
	return s.String()
}

type GetSendQuotaInput struct {
	metadataGetSendQuotaInput `json:"-" xml:"-"`
}

type metadataGetSendQuotaInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSendQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendQuotaInput) GoString() string {
	return s.String()
}

// Represents the user's current activity limits returned from a successful
// GetSendQuota request.
type GetSendQuotaOutput struct {
	// The maximum number of emails the user is allowed to send in a 24-hour interval.
	// A value of -1 signifies an unlimited quota.
	Max24HourSend *float64 `type:"double"`

	// The maximum number of emails that Amazon SES can accept from the user's account
	// per second.
	//
	// The rate at which Amazon SES accepts the user's messages might be less than
	// the maximum send rate.
	MaxSendRate *float64 `type:"double"`

	// The number of emails sent during the previous 24 hours.
	SentLast24Hours *float64 `type:"double"`

	metadataGetSendQuotaOutput `json:"-" xml:"-"`
}

type metadataGetSendQuotaOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSendQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendQuotaOutput) GoString() string {
	return s.String()
}

type GetSendStatisticsInput struct {
	metadataGetSendStatisticsInput `json:"-" xml:"-"`
}

type metadataGetSendStatisticsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSendStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendStatisticsInput) GoString() string {
	return s.String()
}

// Represents a list of SendDataPoint items returned from a successful GetSendStatistics
// request. This list contains aggregated data from the previous two weeks of
// sending activity.
type GetSendStatisticsOutput struct {
	// A list of data points, each of which represents 15 minutes of activity.
	SendDataPoints []*SendDataPoint `type:"list"`

	metadataGetSendStatisticsOutput `json:"-" xml:"-"`
}

type metadataGetSendStatisticsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSendStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendStatisticsOutput) GoString() string {
	return s.String()
}

// Represents the DKIM attributes of a verified email address or a domain.
type IdentityDKIMAttributes struct {
	// True if DKIM signing is enabled for email sent from the identity; false otherwise.
	DKIMEnabled *bool `locationName:"DkimEnabled" type:"boolean" required:"true"`

	// A set of character strings that represent the domain's identity. Using these
	// tokens, you will need to create DNS CNAME records that point to DKIM public
	// keys hosted by Amazon SES. Amazon Web Services will eventually detect that
	// you have updated your DNS records; this detection process may take up to
	// 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign
	// email originating from that domain. (This only applies to domain identities,
	// not email address identities.)
	//
	// For more information about creating DNS records using DKIM tokens, go to
	// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
	DKIMTokens []*string `locationName:"DkimTokens" type:"list"`

	// Describes whether Amazon SES has successfully verified the DKIM DNS records
	// (tokens) published in the domain name's DNS. (This only applies to domain
	// identities, not email address identities.)
	DKIMVerificationStatus *string `locationName:"DkimVerificationStatus" type:"string" required:"true" enum:"VerificationStatus"`

	metadataIdentityDKIMAttributes `json:"-" xml:"-"`
}

type metadataIdentityDKIMAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IdentityDKIMAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityDKIMAttributes) GoString() string {
	return s.String()
}

// Represents the notification attributes of an identity, including whether
// an identity has Amazon Simple Notification Service (Amazon SNS) topics set
// for bounce, complaint, and/or delivery notifications, and whether feedback
// forwarding is enabled for bounce and complaint notifications.
type IdentityNotificationAttributes struct {
	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish bounce notifications.
	BounceTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish complaint notifications.
	ComplaintTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish delivery notifications.
	DeliveryTopic *string `type:"string" required:"true"`

	// Describes whether Amazon SES will forward bounce and complaint notifications
	// as email. true indicates that Amazon SES will forward bounce and complaint
	// notifications as email, while false indicates that bounce and complaint notifications
	// will be published only to the specified bounce and complaint Amazon SNS topics.
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	metadataIdentityNotificationAttributes `json:"-" xml:"-"`
}

type metadataIdentityNotificationAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IdentityNotificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityNotificationAttributes) GoString() string {
	return s.String()
}

// Represents the verification attributes of a single identity.
type IdentityVerificationAttributes struct {
	// The verification status of the identity: "Pending", "Success", "Failed",
	// or "TemporaryFailure".
	VerificationStatus *string `type:"string" required:"true" enum:"VerificationStatus"`

	// The verification token for a domain identity. Null for email address identities.
	VerificationToken *string `type:"string"`

	metadataIdentityVerificationAttributes `json:"-" xml:"-"`
}

type metadataIdentityVerificationAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IdentityVerificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityVerificationAttributes) GoString() string {
	return s.String()
}

// Represents a request instructing the service to list all identities for the
// AWS Account.
type ListIdentitiesInput struct {
	// The type of the identities to list. Possible values are "EmailAddress" and
	// "Domain". If this parameter is omitted, then all identities will be listed.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// The maximum number of identities per page. Possible values are 1-1000 inclusive.
	MaxItems *int64 `type:"integer"`

	// The token to use for pagination.
	NextToken *string `type:"string"`

	metadataListIdentitiesInput `json:"-" xml:"-"`
}

type metadataListIdentitiesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesInput) GoString() string {
	return s.String()
}

// Represents a list of all verified identities for the AWS Account.
type ListIdentitiesOutput struct {
	// A list of identities.
	Identities []*string `type:"list" required:"true"`

	// The token used for pagination.
	NextToken *string `type:"string"`

	metadataListIdentitiesOutput `json:"-" xml:"-"`
}

type metadataListIdentitiesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to list all authorization policies,
// by name, applying to an identity.
type ListIdentityPoliciesInput struct {
	// The identity that is associated with the policy for which the policies will
	// be listed. You can specify an identity by using its name or by using its
	// Amazon Resource Name (ARN). Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	Identity *string `type:"string" required:"true"`

	metadataListIdentityPoliciesInput `json:"-" xml:"-"`
}

type metadataListIdentityPoliciesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListIdentityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoliciesInput) GoString() string {
	return s.String()
}

// Represents a list of policy names returned from a successful ListIdentityPolicies
// request.
type ListIdentityPoliciesOutput struct {
	// A list of names of policies that apply to the specified identity.
	PolicyNames []*string `type:"list" required:"true"`

	metadataListIdentityPoliciesOutput `json:"-" xml:"-"`
}

type metadataListIdentityPoliciesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListIdentityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoliciesOutput) GoString() string {
	return s.String()
}

type ListVerifiedEmailAddressesInput struct {
	metadataListVerifiedEmailAddressesInput `json:"-" xml:"-"`
}

type metadataListVerifiedEmailAddressesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVerifiedEmailAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVerifiedEmailAddressesInput) GoString() string {
	return s.String()
}

// Represents a list of all the email addresses verified for the current user.
type ListVerifiedEmailAddressesOutput struct {
	// A list of email addresses that have been verified.
	VerifiedEmailAddresses []*string `type:"list"`

	metadataListVerifiedEmailAddressesOutput `json:"-" xml:"-"`
}

type metadataListVerifiedEmailAddressesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVerifiedEmailAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVerifiedEmailAddressesOutput) GoString() string {
	return s.String()
}

// Represents the message to be sent, composed of a subject and a body.
type Message struct {
	// The message body.
	Body *Body `type:"structure" required:"true"`

	// The subject of the message: A short summary of the content, which will appear
	// in the recipient's inbox.
	Subject *Content `type:"structure" required:"true"`

	metadataMessage `json:"-" xml:"-"`
}

type metadataMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// Represents a request instructing the service to apply an authorization policy
// to an identity.
type PutIdentityPolicyInput struct {
	// The identity to which the policy will apply. You can specify an identity
	// by using its name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	Identity *string `type:"string" required:"true"`

	// The text of the policy in JSON format. The policy cannot exceed 4 KB.
	//
	// For information about the syntax of sending authorization policies, see
	// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
	Policy *string `type:"string" required:"true"`

	// The name of the policy.
	//
	// The policy name cannot exceed 64 characters and can only include alphanumeric
	// characters, dashes, and underscores.
	PolicyName *string `type:"string" required:"true"`

	metadataPutIdentityPolicyInput `json:"-" xml:"-"`
}

type metadataPutIdentityPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIdentityPolicyInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type PutIdentityPolicyOutput struct {
	metadataPutIdentityPolicyOutput `json:"-" xml:"-"`
}

type metadataPutIdentityPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents the raw data of the message.
type RawMessage struct {
	// The raw data of the message. The client must ensure that the message format
	// complies with Internet email standards regarding email header fields, MIME
	// types, MIME encoding, and base64 encoding (if necessary).
	//
	// The To:, CC:, and BCC: headers in the raw message can contain a group list.
	//
	// If you are using SendRawEmail with sending authorization, you can include
	// X-headers in the raw message to specify the "Source," "From," and "Return-Path"
	// addresses. For more information, see the documentation for SendRawEmail.
	//
	// Do not include these X-headers in the DKIM signature, because they are removed
	// by Amazon SES before sending the email. For more information, go to the Amazon
	// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html).
	Data []byte `type:"blob" required:"true"`

	metadataRawMessage `json:"-" xml:"-"`
}

type metadataRawMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RawMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RawMessage) GoString() string {
	return s.String()
}

// Represents sending statistics data. Each SendDataPoint contains statistics
// for a 15-minute period of sending activity.
type SendDataPoint struct {
	// Number of emails that have bounced.
	Bounces *int64 `type:"long"`

	// Number of unwanted emails that were rejected by recipients.
	Complaints *int64 `type:"long"`

	// Number of emails that have been enqueued for sending.
	DeliveryAttempts *int64 `type:"long"`

	// Number of emails rejected by Amazon SES.
	Rejects *int64 `type:"long"`

	// Time of the data point.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	metadataSendDataPoint `json:"-" xml:"-"`
}

type metadataSendDataPoint struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendDataPoint) GoString() string {
	return s.String()
}

// Represents a request instructing the service to send a single email message.
//
// This datatype can be used in application code to compose a message consisting
// of source, destination, message, reply-to, and return-path parts. This object
// can then be sent using the SendEmail action.
type SendEmailInput struct {
	// The destination for this email, composed of To:, CC:, and BCC: fields.
	Destination *Destination `type:"structure" required:"true"`

	// The message to be sent.
	Message *Message `type:"structure" required:"true"`

	// The reply-to email address(es) for the message. If the recipient replies
	// to the message, each reply-to address will receive the reply.
	ReplyToAddresses []*string `type:"list"`

	// The email address to which bounces and complaints are to be forwarded when
	// feedback forwarding is enabled. If the message cannot be delivered to the
	// recipient, then an error message will be returned from the recipient's ISP;
	// this message will then be forwarded to the email address specified by the
	// ReturnPath parameter. The ReturnPath parameter is never overwritten. This
	// email address must be either individually verified with Amazon SES, or from
	// a domain that has been verified with Amazon SES.
	ReturnPath *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	ReturnPathARN *string `locationName:"ReturnPathArn" type:"string"`

	// The email address that is sending the email. This email address must be either
	// individually verified with Amazon SES, or from a domain that has been verified
	// with Amazon SES. For information about verifying identities, see the Amazon
	// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
	//
	// If you are sending on behalf of another user and have been permitted to
	// do so by a sending authorization policy, then you must also specify the SourceArn
	// parameter. For more information about sending authorization, see the Amazon
	// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	//
	//  In all cases, the email address must be 7-bit ASCII. If the text must contain
	// any other characters, then you must use MIME encoded-word syntax (RFC 2047)
	// instead of a literal string. MIME encoded-word syntax uses the following
	// form: =?charset?encoding?encoded-text?=. For more information, see RFC 2047
	// (http://tools.ietf.org/html/rfc2047).
	Source *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	SourceARN *string `locationName:"SourceArn" type:"string"`

	metadataSendEmailInput `json:"-" xml:"-"`
}

type metadataSendEmailInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailInput) GoString() string {
	return s.String()
}

// Represents a unique message ID returned from a successful SendEmail request.
type SendEmailOutput struct {
	// The unique message identifier returned from the SendEmail action.
	MessageID *string `locationName:"MessageId" type:"string" required:"true"`

	metadataSendEmailOutput `json:"-" xml:"-"`
}

type metadataSendEmailOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to send a raw email message.
//
// This datatype can be used in application code to compose a message consisting
// of source, destination, and raw message text. This object can then be sent
// using the SendRawEmail action.
type SendRawEmailInput struct {
	// A list of destinations for the message, consisting of To:, CC:, and BCC:
	// addresses.
	Destinations []*string `type:"list"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to specify a particular "From" address in the header of the raw email.
	//
	// Instead of using this parameter, you can use the X-header X-SES-FROM-ARN
	// in the raw message of the email. If you use both the FromArn parameter and
	// the corresponding X-header, Amazon SES uses the value of the FromArn parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
	FromARN *string `locationName:"FromArn" type:"string"`

	// The raw text of the message. The client is responsible for ensuring the following:
	//
	//   Message must contain a header and a body, separated by a blank line. All
	// required header fields must be present. Each part of a multipart MIME message
	// must be formatted properly. MIME content types must be among those supported
	// by Amazon SES. For more information, go to the Amazon SES Developer Guide
	// (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html).
	// Content must be base64-encoded, if MIME requires it.
	RawMessage *RawMessage `type:"structure" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// Instead of using this parameter, you can use the X-header X-SES-RETURN-PATH-ARN
	// in the raw message of the email. If you use both the ReturnPathArn parameter
	// and the corresponding X-header, Amazon SES uses the value of the ReturnPathArn
	// parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
	ReturnPathARN *string `locationName:"ReturnPathArn" type:"string"`

	// The identity's email address. If you do not provide a value for this parameter,
	// you must specify a "From" address in the raw text of the message. (You can
	// also specify both.)
	//
	//  By default, the string must be 7-bit ASCII. If the text must contain any
	// other characters, then you must use MIME encoded-word syntax (RFC 2047) instead
	// of a literal string. MIME encoded-word syntax uses the following form: =?charset?encoding?encoded-text?=.
	// For more information, see RFC 2047 (http://tools.ietf.org/html/rfc2047).
	//
	// If you specify the Source parameter and have feedback forwarding enabled,
	// then bounces and complaints will be sent to this email address. This takes
	// precedence over any Return-Path header that you might include in the raw
	// text of the message.
	Source *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// Instead of using this parameter, you can use the X-header X-SES-SOURCE-ARN
	// in the raw message of the email. If you use both the SourceArn parameter
	// and the corresponding X-header, Amazon SES uses the value of the SourceArn
	// parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
	SourceARN *string `locationName:"SourceArn" type:"string"`

	metadataSendRawEmailInput `json:"-" xml:"-"`
}

type metadataSendRawEmailInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendRawEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendRawEmailInput) GoString() string {
	return s.String()
}

// Represents a unique message ID returned from a successful SendRawEmail request.
type SendRawEmailOutput struct {
	// The unique message identifier returned from the SendRawEmail action.
	MessageID *string `locationName:"MessageId" type:"string" required:"true"`

	metadataSendRawEmailOutput `json:"-" xml:"-"`
}

type metadataSendRawEmailOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendRawEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendRawEmailOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to enable or disable DKIM signing
// for an identity.
type SetIdentityDKIMEnabledInput struct {
	// Sets whether DKIM signing is enabled for an identity. Set to true to enable
	// DKIM signing for this identity; false to disable it.
	DKIMEnabled *bool `locationName:"DkimEnabled" type:"boolean" required:"true"`

	// The identity for which DKIM signing should be enabled or disabled.
	Identity *string `type:"string" required:"true"`

	metadataSetIdentityDKIMEnabledInput `json:"-" xml:"-"`
}

type metadataSetIdentityDKIMEnabledInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityDKIMEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityDKIMEnabledInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type SetIdentityDKIMEnabledOutput struct {
	metadataSetIdentityDKIMEnabledOutput `json:"-" xml:"-"`
}

type metadataSetIdentityDKIMEnabledOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityDKIMEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityDKIMEnabledOutput) GoString() string {
	return s.String()
}

type SetIdentityFeedbackForwardingEnabledInput struct {
	// Sets whether Amazon SES will forward bounce and complaint notifications as
	// email. true specifies that Amazon SES will forward bounce and complaint notifications
	// as email, in addition to any Amazon SNS topic publishing otherwise specified.
	// false specifies that Amazon SES will publish bounce and complaint notifications
	// only through Amazon SNS. This value can only be set to false when Amazon
	// SNS topics are set for both Bounce and Complaint notification types.
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	// The identity for which to set bounce and complaint notification forwarding.
	// Examples: user@example.com, example.com.
	Identity *string `type:"string" required:"true"`

	metadataSetIdentityFeedbackForwardingEnabledInput `json:"-" xml:"-"`
}

type metadataSetIdentityFeedbackForwardingEnabledInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityFeedbackForwardingEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityFeedbackForwardingEnabledInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type SetIdentityFeedbackForwardingEnabledOutput struct {
	metadataSetIdentityFeedbackForwardingEnabledOutput `json:"-" xml:"-"`
}

type metadataSetIdentityFeedbackForwardingEnabledOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityFeedbackForwardingEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityFeedbackForwardingEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to set or clear an identity's notification topic.
type SetIdentityNotificationTopicInput struct {
	// The identity for which the Amazon SNS topic will be set. You can specify
	// an identity by using its name or by using its Amazon Resource Name (ARN).
	// Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	Identity *string `type:"string" required:"true"`

	// The type of notifications that will be published to the specified Amazon
	// SNS topic.
	NotificationType *string `type:"string" required:"true" enum:"NotificationType"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter
	// is omitted from the request or a null value is passed, SnsTopic is cleared
	// and publishing is disabled.
	SNSTopic *string `locationName:"SnsTopic" type:"string"`

	metadataSetIdentityNotificationTopicInput `json:"-" xml:"-"`
}

type metadataSetIdentityNotificationTopicInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityNotificationTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityNotificationTopicInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type SetIdentityNotificationTopicOutput struct {
	metadataSetIdentityNotificationTopicOutput `json:"-" xml:"-"`
}

type metadataSetIdentityNotificationTopicOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityNotificationTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityNotificationTopicOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to begin DKIM verification for
// a domain.
type VerifyDomainDKIMInput struct {
	// The name of the domain to be verified for Easy DKIM signing.
	Domain *string `type:"string" required:"true"`

	metadataVerifyDomainDKIMInput `json:"-" xml:"-"`
}

type metadataVerifyDomainDKIMInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyDomainDKIMInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainDKIMInput) GoString() string {
	return s.String()
}

// Represents the DNS records that must be published in the domain name's DNS
// to complete DKIM setup.
type VerifyDomainDKIMOutput struct {
	// A set of character strings that represent the domain's identity. If the identity
	// is an email address, the tokens represent the domain of that address.
	//
	// Using these tokens, you will need to create DNS CNAME records that point
	// to DKIM public keys hosted by Amazon SES. Amazon Web Services will eventually
	// detect that you have updated your DNS records; this detection process may
	// take up to 72 hours. Upon successful detection, Amazon SES will be able to
	// DKIM-sign emails originating from that domain.
	//
	// For more information about creating DNS records using DKIM tokens, go to
	// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
	DKIMTokens []*string `locationName:"DkimTokens" type:"list" required:"true"`

	metadataVerifyDomainDKIMOutput `json:"-" xml:"-"`
}

type metadataVerifyDomainDKIMOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyDomainDKIMOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainDKIMOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to begin domain verification.
type VerifyDomainIdentityInput struct {
	// The domain to be verified.
	Domain *string `type:"string" required:"true"`

	metadataVerifyDomainIdentityInput `json:"-" xml:"-"`
}

type metadataVerifyDomainIdentityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyDomainIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainIdentityInput) GoString() string {
	return s.String()
}

// Represents a token used for domain ownership verification.
type VerifyDomainIdentityOutput struct {
	// A TXT record that must be placed in the DNS settings for the domain, in order
	// to complete domain verification.
	VerificationToken *string `type:"string" required:"true"`

	metadataVerifyDomainIdentityOutput `json:"-" xml:"-"`
}

type metadataVerifyDomainIdentityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyDomainIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainIdentityOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to begin email address verification.
type VerifyEmailAddressInput struct {
	// The email address to be verified.
	EmailAddress *string `type:"string" required:"true"`

	metadataVerifyEmailAddressInput `json:"-" xml:"-"`
}

type metadataVerifyEmailAddressInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailAddressInput) GoString() string {
	return s.String()
}

type VerifyEmailAddressOutput struct {
	metadataVerifyEmailAddressOutput `json:"-" xml:"-"`
}

type metadataVerifyEmailAddressOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailAddressOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to begin email address verification.
type VerifyEmailIdentityInput struct {
	// The email address to be verified.
	EmailAddress *string `type:"string" required:"true"`

	metadataVerifyEmailIdentityInput `json:"-" xml:"-"`
}

type metadataVerifyEmailIdentityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailIdentityInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type VerifyEmailIdentityOutput struct {
	metadataVerifyEmailIdentityOutput `json:"-" xml:"-"`
}

type metadataVerifyEmailIdentityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailIdentityOutput) GoString() string {
	return s.String()
}

const (
	// @enum IdentityType
	IdentityTypeEmailAddress = "EmailAddress"
	// @enum IdentityType
	IdentityTypeDomain = "Domain"
)

const (
	// @enum NotificationType
	NotificationTypeBounce = "Bounce"
	// @enum NotificationType
	NotificationTypeComplaint = "Complaint"
	// @enum NotificationType
	NotificationTypeDelivery = "Delivery"
)

const (
	// @enum VerificationStatus
	VerificationStatusPending = "Pending"
	// @enum VerificationStatus
	VerificationStatusSuccess = "Success"
	// @enum VerificationStatus
	VerificationStatusFailed = "Failed"
	// @enum VerificationStatus
	VerificationStatusTemporaryFailure = "TemporaryFailure"
	// @enum VerificationStatus
	VerificationStatusNotStarted = "NotStarted"
)
