// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package ses

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/defaults"
	"github.com/aws/aws-sdk-go/aws/service"
	"github.com/aws/aws-sdk-go/internal/protocol/query"
	"github.com/aws/aws-sdk-go/internal/signer/v4"
)

// This is the API Reference for Amazon Simple Email Service (Amazon SES). This
// documentation is intended to be used in conjunction with the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/Welcome.html).
//
// For a list of Amazon SES endpoints to use in service requests, see Regions
// and Amazon SES (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/regions.html)
// in the Amazon SES Developer Guide.
type SES struct {
	*service.Service
}

// Used for custom service initialization logic
var initService func(*service.Service)

// Used for custom request initialization logic
var initRequest func(*service.Request)

// New returns a new SES client.
func New(config *aws.Config) *SES {
	service := &service.Service{
		Config:      defaults.DefaultConfig.Merge(config),
		ServiceName: "email",
		SigningName: "ses",
		APIVersion:  "2010-12-01",
	}
	service.Initialize()

	// Handlers
	service.Handlers.Sign.PushBack(v4.Sign)
	service.Handlers.Build.PushBack(query.Build)
	service.Handlers.Unmarshal.PushBack(query.Unmarshal)
	service.Handlers.UnmarshalMeta.PushBack(query.UnmarshalMeta)
	service.Handlers.UnmarshalError.PushBack(query.UnmarshalError)

	// Run custom service initialization if present
	if initService != nil {
		initService(service)
	}

	return &SES{service}
}

// newRequest creates a new request for a SES operation and runs any
// custom request initialization.
func (c *SES) newRequest(op *service.Operation, params, data interface{}) *service.Request {
	req := service.NewRequest(c.Service, op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
