// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ssm provides a client for Amazon Simple Systems Management Service.
package ssm

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/service"
)

const opCreateAssociation = "CreateAssociation"

// CreateAssociationRequest generates a request for the CreateAssociation operation.
func (c *SSM) CreateAssociationRequest(input *CreateAssociationInput) (req *service.Request, output *CreateAssociationOutput) {
	op := &service.Operation{
		Name:       opCreateAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAssociationOutput{}
	req.Data = output
	return
}

// Associates the specified configuration document with the specified instance.
//
// When you associate a configuration document with an instance, the configuration
// agent on the instance processes the configuration document and configures
// the instance as specified.
//
// If you associate a configuration document with an instance that already
// has an associated configuration document, we replace the current configuration
// document with the new configuration document.
func (c *SSM) CreateAssociation(input *CreateAssociationInput) (*CreateAssociationOutput, error) {
	req, out := c.CreateAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAssociationBatch = "CreateAssociationBatch"

// CreateAssociationBatchRequest generates a request for the CreateAssociationBatch operation.
func (c *SSM) CreateAssociationBatchRequest(input *CreateAssociationBatchInput) (req *service.Request, output *CreateAssociationBatchOutput) {
	op := &service.Operation{
		Name:       opCreateAssociationBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssociationBatchInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAssociationBatchOutput{}
	req.Data = output
	return
}

// Associates the specified configuration documents with the specified instances.
//
// When you associate a configuration document with an instance, the configuration
// agent on the instance processes the configuration document and configures
// the instance as specified.
//
// If you associate a configuration document with an instance that already
// has an associated configuration document, we replace the current configuration
// document with the new configuration document.
func (c *SSM) CreateAssociationBatch(input *CreateAssociationBatchInput) (*CreateAssociationBatchOutput, error) {
	req, out := c.CreateAssociationBatchRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDocument = "CreateDocument"

// CreateDocumentRequest generates a request for the CreateDocument operation.
func (c *SSM) CreateDocumentRequest(input *CreateDocumentInput) (req *service.Request, output *CreateDocumentOutput) {
	op := &service.Operation{
		Name:       opCreateDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDocumentOutput{}
	req.Data = output
	return
}

// Creates a configuration document.
//
// After you create a configuration document, you can use CreateAssociation
// to associate it with one or more running instances.
func (c *SSM) CreateDocument(input *CreateDocumentInput) (*CreateDocumentOutput, error) {
	req, out := c.CreateDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAssociation = "DeleteAssociation"

// DeleteAssociationRequest generates a request for the DeleteAssociation operation.
func (c *SSM) DeleteAssociationRequest(input *DeleteAssociationInput) (req *service.Request, output *DeleteAssociationOutput) {
	op := &service.Operation{
		Name:       opDeleteAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteAssociationOutput{}
	req.Data = output
	return
}

// Disassociates the specified configuration document from the specified instance.
//
// When you disassociate a configuration document from an instance, it does
// not change the configuration of the instance. To change the configuration
// state of an instance after you disassociate a configuration document, you
// must create a new configuration document with the desired configuration and
// associate it with the instance.
func (c *SSM) DeleteAssociation(input *DeleteAssociationInput) (*DeleteAssociationOutput, error) {
	req, out := c.DeleteAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDocument = "DeleteDocument"

// DeleteDocumentRequest generates a request for the DeleteDocument operation.
func (c *SSM) DeleteDocumentRequest(input *DeleteDocumentInput) (req *service.Request, output *DeleteDocumentOutput) {
	op := &service.Operation{
		Name:       opDeleteDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDocumentOutput{}
	req.Data = output
	return
}

// Deletes the specified configuration document.
//
// You must use DeleteAssociation to disassociate all instances that are associated
// with the configuration document before you can delete it.
func (c *SSM) DeleteDocument(input *DeleteDocumentInput) (*DeleteDocumentOutput, error) {
	req, out := c.DeleteDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAssociation = "DescribeAssociation"

// DescribeAssociationRequest generates a request for the DescribeAssociation operation.
func (c *SSM) DescribeAssociationRequest(input *DescribeAssociationInput) (req *service.Request, output *DescribeAssociationOutput) {
	op := &service.Operation{
		Name:       opDescribeAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssociationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAssociationOutput{}
	req.Data = output
	return
}

// Describes the associations for the specified configuration document or instance.
func (c *SSM) DescribeAssociation(input *DescribeAssociationInput) (*DescribeAssociationOutput, error) {
	req, out := c.DescribeAssociationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDocument = "DescribeDocument"

// DescribeDocumentRequest generates a request for the DescribeDocument operation.
func (c *SSM) DescribeDocumentRequest(input *DescribeDocumentInput) (req *service.Request, output *DescribeDocumentOutput) {
	op := &service.Operation{
		Name:       opDescribeDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDocumentOutput{}
	req.Data = output
	return
}

// Describes the specified configuration document.
func (c *SSM) DescribeDocument(input *DescribeDocumentInput) (*DescribeDocumentOutput, error) {
	req, out := c.DescribeDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opGetDocument = "GetDocument"

// GetDocumentRequest generates a request for the GetDocument operation.
func (c *SSM) GetDocumentRequest(input *GetDocumentInput) (req *service.Request, output *GetDocumentOutput) {
	op := &service.Operation{
		Name:       opGetDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDocumentOutput{}
	req.Data = output
	return
}

// Gets the contents of the specified configuration document.
func (c *SSM) GetDocument(input *GetDocumentInput) (*GetDocumentOutput, error) {
	req, out := c.GetDocumentRequest(input)
	err := req.Send()
	return out, err
}

const opListAssociations = "ListAssociations"

// ListAssociationsRequest generates a request for the ListAssociations operation.
func (c *SSM) ListAssociationsRequest(input *ListAssociationsInput) (req *service.Request, output *ListAssociationsOutput) {
	op := &service.Operation{
		Name:       opListAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAssociationsOutput{}
	req.Data = output
	return
}

// Lists the associations for the specified configuration document or instance.
func (c *SSM) ListAssociations(input *ListAssociationsInput) (*ListAssociationsOutput, error) {
	req, out := c.ListAssociationsRequest(input)
	err := req.Send()
	return out, err
}

const opListDocuments = "ListDocuments"

// ListDocumentsRequest generates a request for the ListDocuments operation.
func (c *SSM) ListDocumentsRequest(input *ListDocumentsInput) (req *service.Request, output *ListDocumentsOutput) {
	op := &service.Operation{
		Name:       opListDocuments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDocumentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDocumentsOutput{}
	req.Data = output
	return
}

// Describes one or more of your configuration documents.
func (c *SSM) ListDocuments(input *ListDocumentsInput) (*ListDocumentsOutput, error) {
	req, out := c.ListDocumentsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAssociationStatus = "UpdateAssociationStatus"

// UpdateAssociationStatusRequest generates a request for the UpdateAssociationStatus operation.
func (c *SSM) UpdateAssociationStatusRequest(input *UpdateAssociationStatusInput) (req *service.Request, output *UpdateAssociationStatusOutput) {
	op := &service.Operation{
		Name:       opUpdateAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssociationStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAssociationStatusOutput{}
	req.Data = output
	return
}

// Updates the status of the configuration document associated with the specified
// instance.
func (c *SSM) UpdateAssociationStatus(input *UpdateAssociationStatusInput) (*UpdateAssociationStatusOutput, error) {
	req, out := c.UpdateAssociationStatusRequest(input)
	err := req.Send()
	return out, err
}

// Describes an association of a configuration document and an instance.
type Association struct {
	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string"`

	// The name of the configuration document.
	Name *string `type:"string"`

	metadataAssociation `json:"-" xml:"-"`
}

type metadataAssociation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Association) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Association) GoString() string {
	return s.String()
}

// Describes an association.
type AssociationDescription struct {
	// The date when the association was made.
	Date *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string"`

	// The name of the configuration document.
	Name *string `type:"string"`

	// The association status.
	Status *AssociationStatus `type:"structure"`

	metadataAssociationDescription `json:"-" xml:"-"`
}

type metadataAssociationDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssociationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationDescription) GoString() string {
	return s.String()
}

// Describes a filter.
type AssociationFilter struct {
	// The name of the filter.
	Key *string `locationName:"key" type:"string" required:"true" enum:"AssociationFilterKey"`

	// The filter value.
	Value *string `locationName:"value" type:"string" required:"true"`

	metadataAssociationFilter `json:"-" xml:"-"`
}

type metadataAssociationFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssociationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationFilter) GoString() string {
	return s.String()
}

// Describes an association status.
type AssociationStatus struct {
	// A user-defined string.
	AdditionalInfo *string `type:"string"`

	// The date when the status changed.
	Date *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The reason for the status.
	Message *string `type:"string" required:"true"`

	// The status.
	Name *string `type:"string" required:"true" enum:"AssociationStatusName"`

	metadataAssociationStatus `json:"-" xml:"-"`
}

type metadataAssociationStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssociationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociationStatus) GoString() string {
	return s.String()
}

type CreateAssociationBatchInput struct {
	// One or more associations.
	Entries []*CreateAssociationBatchRequestEntry `locationNameList:"entries" type:"list" required:"true"`

	metadataCreateAssociationBatchInput `json:"-" xml:"-"`
}

type metadataCreateAssociationBatchInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAssociationBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchInput) GoString() string {
	return s.String()
}

type CreateAssociationBatchOutput struct {
	// Information about the associations that failed.
	Failed []*FailedCreateAssociation `locationNameList:"FailedCreateAssociationEntry" type:"list"`

	// Information about the associations that succeeded.
	Successful []*AssociationDescription `locationNameList:"AssociationDescription" type:"list"`

	metadataCreateAssociationBatchOutput `json:"-" xml:"-"`
}

type metadataCreateAssociationBatchOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAssociationBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchOutput) GoString() string {
	return s.String()
}

// Describes the association of a configuration document and an instance.
type CreateAssociationBatchRequestEntry struct {
	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string"`

	// The name of the configuration document.
	Name *string `type:"string"`

	metadataCreateAssociationBatchRequestEntry `json:"-" xml:"-"`
}

type metadataCreateAssociationBatchRequestEntry struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAssociationBatchRequestEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationBatchRequestEntry) GoString() string {
	return s.String()
}

type CreateAssociationInput struct {
	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string" required:"true"`

	// The name of the configuration document.
	Name *string `type:"string" required:"true"`

	metadataCreateAssociationInput `json:"-" xml:"-"`
}

type metadataCreateAssociationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationInput) GoString() string {
	return s.String()
}

type CreateAssociationOutput struct {
	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`

	metadataCreateAssociationOutput `json:"-" xml:"-"`
}

type metadataCreateAssociationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssociationOutput) GoString() string {
	return s.String()
}

type CreateDocumentInput struct {
	// A valid JSON file. For more information about the contents of this file,
	// see Configuration Document (http://docs.aws.amazon.com/ssm/latest/APIReference/aws-ssm-document.html).
	Content *string `type:"string" required:"true"`

	// A name for the configuration document.
	Name *string `type:"string" required:"true"`

	metadataCreateDocumentInput `json:"-" xml:"-"`
}

type metadataCreateDocumentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentInput) GoString() string {
	return s.String()
}

type CreateDocumentOutput struct {
	// Information about the configuration document.
	DocumentDescription *DocumentDescription `type:"structure"`

	metadataCreateDocumentOutput `json:"-" xml:"-"`
}

type metadataCreateDocumentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentOutput) GoString() string {
	return s.String()
}

type DeleteAssociationInput struct {
	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string" required:"true"`

	// The name of the configuration document.
	Name *string `type:"string" required:"true"`

	metadataDeleteAssociationInput `json:"-" xml:"-"`
}

type metadataDeleteAssociationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssociationInput) GoString() string {
	return s.String()
}

type DeleteAssociationOutput struct {
	metadataDeleteAssociationOutput `json:"-" xml:"-"`
}

type metadataDeleteAssociationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssociationOutput) GoString() string {
	return s.String()
}

type DeleteDocumentInput struct {
	// The name of the configuration document.
	Name *string `type:"string" required:"true"`

	metadataDeleteDocumentInput `json:"-" xml:"-"`
}

type metadataDeleteDocumentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentInput) GoString() string {
	return s.String()
}

type DeleteDocumentOutput struct {
	metadataDeleteDocumentOutput `json:"-" xml:"-"`
}

type metadataDeleteDocumentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentOutput) GoString() string {
	return s.String()
}

type DescribeAssociationInput struct {
	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string" required:"true"`

	// The name of the configuration document.
	Name *string `type:"string" required:"true"`

	metadataDescribeAssociationInput `json:"-" xml:"-"`
}

type metadataDescribeAssociationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationInput) GoString() string {
	return s.String()
}

type DescribeAssociationOutput struct {
	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`

	metadataDescribeAssociationOutput `json:"-" xml:"-"`
}

type metadataDescribeAssociationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssociationOutput) GoString() string {
	return s.String()
}

type DescribeDocumentInput struct {
	// The name of the configuration document.
	Name *string `type:"string" required:"true"`

	metadataDescribeDocumentInput `json:"-" xml:"-"`
}

type metadataDescribeDocumentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentInput) GoString() string {
	return s.String()
}

type DescribeDocumentOutput struct {
	// Information about the configuration document.
	Document *DocumentDescription `type:"structure"`

	metadataDescribeDocumentOutput `json:"-" xml:"-"`
}

type metadataDescribeDocumentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentOutput) GoString() string {
	return s.String()
}

// Describes a configuration document.
type DocumentDescription struct {
	// The date when the configuration document was created.
	CreatedDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The name of the configuration document.
	Name *string `type:"string"`

	// The SHA1 hash of the document, which you can use for verification purposes.
	SHA1 *string `locationName:"Sha1" type:"string"`

	// The status of the configuration document.
	Status *string `type:"string" enum:"DocumentStatus"`

	metadataDocumentDescription `json:"-" xml:"-"`
}

type metadataDocumentDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DocumentDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentDescription) GoString() string {
	return s.String()
}

// Describes a filter.
type DocumentFilter struct {
	// The name of the filter.
	Key *string `locationName:"key" type:"string" required:"true" enum:"DocumentFilterKey"`

	// The value of the filter.
	Value *string `locationName:"value" type:"string" required:"true"`

	metadataDocumentFilter `json:"-" xml:"-"`
}

type metadataDocumentFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DocumentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentFilter) GoString() string {
	return s.String()
}

// Describes the name of a configuration document.
type DocumentIdentifier struct {
	// The name of the configuration document.
	Name *string `type:"string"`

	metadataDocumentIdentifier `json:"-" xml:"-"`
}

type metadataDocumentIdentifier struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DocumentIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentIdentifier) GoString() string {
	return s.String()
}

// Describes a failed association.
type FailedCreateAssociation struct {
	// The association.
	Entry *CreateAssociationBatchRequestEntry `type:"structure"`

	// The source of the failure.
	Fault *string `type:"string" enum:"Fault"`

	// A description of the failure.
	Message *string `type:"string"`

	metadataFailedCreateAssociation `json:"-" xml:"-"`
}

type metadataFailedCreateAssociation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s FailedCreateAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedCreateAssociation) GoString() string {
	return s.String()
}

type GetDocumentInput struct {
	// The name of the configuration document.
	Name *string `type:"string" required:"true"`

	metadataGetDocumentInput `json:"-" xml:"-"`
}

type metadataGetDocumentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentInput) GoString() string {
	return s.String()
}

type GetDocumentOutput struct {
	// The contents of the configuration document.
	Content *string `type:"string"`

	// The name of the configuration document.
	Name *string `type:"string"`

	metadataGetDocumentOutput `json:"-" xml:"-"`
}

type metadataGetDocumentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentOutput) GoString() string {
	return s.String()
}

type ListAssociationsInput struct {
	// One or more filters. Use a filter to return a more specific list of results.
	AssociationFilterList []*AssociationFilter `locationNameList:"AssociationFilter" type:"list" required:"true"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	metadataListAssociationsInput `json:"-" xml:"-"`
}

type metadataListAssociationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsInput) GoString() string {
	return s.String()
}

type ListAssociationsOutput struct {
	// The associations.
	Associations []*Association `locationNameList:"Association" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	metadataListAssociationsOutput `json:"-" xml:"-"`
}

type metadataListAssociationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssociationsOutput) GoString() string {
	return s.String()
}

type ListDocumentsInput struct {
	// One or more filters. Use a filter to return a more specific list of results.
	DocumentFilterList []*DocumentFilter `locationNameList:"DocumentFilter" type:"list"`

	// The maximum number of items to return for this call. The call also returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	metadataListDocumentsInput `json:"-" xml:"-"`
}

type metadataListDocumentsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDocumentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentsInput) GoString() string {
	return s.String()
}

type ListDocumentsOutput struct {
	// The names of the configuration documents.
	DocumentIdentifiers []*DocumentIdentifier `locationNameList:"DocumentIdentifier" type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	metadataListDocumentsOutput `json:"-" xml:"-"`
}

type metadataListDocumentsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDocumentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentsOutput) GoString() string {
	return s.String()
}

type UpdateAssociationStatusInput struct {
	// The association status.
	AssociationStatus *AssociationStatus `type:"structure" required:"true"`

	// The ID of the instance.
	InstanceID *string `locationName:"InstanceId" type:"string" required:"true"`

	// The name of the configuration document.
	Name *string `type:"string" required:"true"`

	metadataUpdateAssociationStatusInput `json:"-" xml:"-"`
}

type metadataUpdateAssociationStatusInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAssociationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssociationStatusInput) GoString() string {
	return s.String()
}

type UpdateAssociationStatusOutput struct {
	// Information about the association.
	AssociationDescription *AssociationDescription `type:"structure"`

	metadataUpdateAssociationStatusOutput `json:"-" xml:"-"`
}

type metadataUpdateAssociationStatusOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAssociationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssociationStatusOutput) GoString() string {
	return s.String()
}

const (
	// @enum AssociationFilterKey
	AssociationFilterKeyInstanceId = "InstanceId"
	// @enum AssociationFilterKey
	AssociationFilterKeyName = "Name"
)

const (
	// @enum AssociationStatusName
	AssociationStatusNamePending = "Pending"
	// @enum AssociationStatusName
	AssociationStatusNameSuccess = "Success"
	// @enum AssociationStatusName
	AssociationStatusNameFailed = "Failed"
)

const (
	// @enum DocumentFilterKey
	DocumentFilterKeyName = "Name"
)

const (
	// @enum DocumentStatus
	DocumentStatusCreating = "Creating"
	// @enum DocumentStatus
	DocumentStatusActive = "Active"
	// @enum DocumentStatus
	DocumentStatusDeleting = "Deleting"
)

const (
	// @enum Fault
	FaultClient = "Client"
	// @enum Fault
	FaultServer = "Server"
	// @enum Fault
	FaultUnknown = "Unknown"
)
