// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package storagegateway provides a client for AWS Storage Gateway.
package storagegateway

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/service"
)

const opActivateGateway = "ActivateGateway"

// ActivateGatewayRequest generates a request for the ActivateGateway operation.
func (c *StorageGateway) ActivateGatewayRequest(input *ActivateGatewayInput) (req *service.Request, output *ActivateGatewayOutput) {
	op := &service.Operation{
		Name:       opActivateGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ActivateGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ActivateGatewayOutput{}
	req.Data = output
	return
}

// This operation activates the gateway you previously deployed on your host.
// For more information, see  Activate the AWS Storage Gateway (http://docs.aws.amazon.com/storagegateway/latest/userguide/GettingStartedActivateGateway-common.html).
// In the activation process, you specify information such as the region you
// want to use for storing snapshots, the time zone for scheduled snapshots
// the gateway snapshot schedule window, an activation key, and a name for your
// gateway. The activation process also associates your gateway with your account;
// for more information, see UpdateGatewayInformation.
//
// You must turn on the gateway VM before you can activate your gateway.
func (c *StorageGateway) ActivateGateway(input *ActivateGatewayInput) (*ActivateGatewayOutput, error) {
	req, out := c.ActivateGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opAddCache = "AddCache"

// AddCacheRequest generates a request for the AddCache operation.
func (c *StorageGateway) AddCacheRequest(input *AddCacheInput) (req *service.Request, output *AddCacheOutput) {
	op := &service.Operation{
		Name:       opAddCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCacheInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddCacheOutput{}
	req.Data = output
	return
}

// This operation configures one or more gateway local disks as cache for a
// cached-volume gateway. This operation is supported only for the gateway-cached
// volume architecture (see Storage Gateway Concepts (http://docs.aws.amazon.com/storagegateway/latest/userguide/StorageGatewayConcepts.html)).
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add cache, and one or more disk IDs that you want to configure
// as cache.
func (c *StorageGateway) AddCache(input *AddCacheInput) (*AddCacheOutput, error) {
	req, out := c.AddCacheRequest(input)
	err := req.Send()
	return out, err
}

const opAddUploadBuffer = "AddUploadBuffer"

// AddUploadBufferRequest generates a request for the AddUploadBuffer operation.
func (c *StorageGateway) AddUploadBufferRequest(input *AddUploadBufferInput) (req *service.Request, output *AddUploadBufferOutput) {
	op := &service.Operation{
		Name:       opAddUploadBuffer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddUploadBufferInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddUploadBufferOutput{}
	req.Data = output
	return
}

// This operation configures one or more gateway local disks as upload buffer
// for a specified gateway. This operation is supported for both the gateway-stored
// and gateway-cached volume architectures.
//
//  In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add upload buffer, and one or more disk IDs that you want to
// configure as upload buffer.
func (c *StorageGateway) AddUploadBuffer(input *AddUploadBufferInput) (*AddUploadBufferOutput, error) {
	req, out := c.AddUploadBufferRequest(input)
	err := req.Send()
	return out, err
}

const opAddWorkingStorage = "AddWorkingStorage"

// AddWorkingStorageRequest generates a request for the AddWorkingStorage operation.
func (c *StorageGateway) AddWorkingStorageRequest(input *AddWorkingStorageInput) (req *service.Request, output *AddWorkingStorageOutput) {
	op := &service.Operation{
		Name:       opAddWorkingStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddWorkingStorageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddWorkingStorageOutput{}
	req.Data = output
	return
}

// This operation configures one or more gateway local disks as working storage
// for a gateway. This operation is supported only for the gateway-stored volume
// architecture. This operation is deprecated method in cached-volumes API version
// (20120630). Use AddUploadBuffer instead.
//
// Working storage is also referred to as upload buffer. You can also use the
// AddUploadBuffer operation to add upload buffer to a stored-volume gateway.
//
// In the request, you specify the gateway Amazon Resource Name (ARN) to which
// you want to add working storage, and one or more disk IDs that you want to
// configure as working storage.
func (c *StorageGateway) AddWorkingStorage(input *AddWorkingStorageInput) (*AddWorkingStorageOutput, error) {
	req, out := c.AddWorkingStorageRequest(input)
	err := req.Send()
	return out, err
}

const opCancelArchival = "CancelArchival"

// CancelArchivalRequest generates a request for the CancelArchival operation.
func (c *StorageGateway) CancelArchivalRequest(input *CancelArchivalInput) (req *service.Request, output *CancelArchivalOutput) {
	op := &service.Operation{
		Name:       opCancelArchival,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelArchivalInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelArchivalOutput{}
	req.Data = output
	return
}

// Cancels archiving of a virtual tape to the virtual tape shelf (VTS) after
// the archiving process is initiated.
func (c *StorageGateway) CancelArchival(input *CancelArchivalInput) (*CancelArchivalOutput, error) {
	req, out := c.CancelArchivalRequest(input)
	err := req.Send()
	return out, err
}

const opCancelRetrieval = "CancelRetrieval"

// CancelRetrievalRequest generates a request for the CancelRetrieval operation.
func (c *StorageGateway) CancelRetrievalRequest(input *CancelRetrievalInput) (req *service.Request, output *CancelRetrievalOutput) {
	op := &service.Operation{
		Name:       opCancelRetrieval,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelRetrievalInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelRetrievalOutput{}
	req.Data = output
	return
}

// Cancels retrieval of a virtual tape from the virtual tape shelf (VTS) to
// a gateway after the retrieval process is initiated. The virtual tape is returned
// to the VTS.
func (c *StorageGateway) CancelRetrieval(input *CancelRetrievalInput) (*CancelRetrievalOutput, error) {
	req, out := c.CancelRetrievalRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCachediSCSIVolume = "CreateCachediSCSIVolume"

// CreateCachediSCSIVolumeRequest generates a request for the CreateCachediSCSIVolume operation.
func (c *StorageGateway) CreateCachediSCSIVolumeRequest(input *CreateCachediSCSIVolumeInput) (req *service.Request, output *CreateCachediSCSIVolumeOutput) {
	op := &service.Operation{
		Name:       opCreateCachediSCSIVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCachediSCSIVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCachediSCSIVolumeOutput{}
	req.Data = output
	return
}

// This operation creates a cached volume on a specified cached gateway. This
// operation is supported only for the gateway-cached volume architecture.
//
// Cache storage must be allocated to the gateway before you can create a cached
// volume. Use the AddCache operation to add cache storage to a gateway.  In
// the request, you must specify the gateway, size of the volume in bytes, the
// iSCSI target name, an IP address on which to expose the target, and a unique
// client token. In response, AWS Storage Gateway creates the volume and returns
// information about it such as the volume Amazon Resource Name (ARN), its size,
// and the iSCSI target ARN that initiators can use to connect to the volume
// target.
func (c *StorageGateway) CreateCachediSCSIVolume(input *CreateCachediSCSIVolumeInput) (*CreateCachediSCSIVolumeOutput, error) {
	req, out := c.CreateCachediSCSIVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a request for the CreateSnapshot operation.
func (c *StorageGateway) CreateSnapshotRequest(input *CreateSnapshotInput) (req *service.Request, output *CreateSnapshotOutput) {
	op := &service.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSnapshotOutput{}
	req.Data = output
	return
}

// This operation initiates a snapshot of a volume.
//
// AWS Storage Gateway provides the ability to back up point-in-time snapshots
// of your data to Amazon Simple Storage (S3) for durable off-site recovery,
// as well as import the data to an Amazon Elastic Block Store (EBS) volume
// in Amazon Elastic Compute Cloud (EC2). You can take snapshots of your gateway
// volume on a scheduled or ad-hoc basis. This API enables you to take ad-hoc
// snapshot. For more information, see Working With Snapshots in the AWS Storage
// Gateway Console (http://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html).
//
// In the CreateSnapshot request you identify the volume by providing its Amazon
// Resource Name (ARN). You must also provide description for the snapshot.
// When AWS Storage Gateway takes the snapshot of specified volume, the snapshot
// and description appears in the AWS Storage Gateway Console. In response,
// AWS Storage Gateway returns you a snapshot ID. You can use this snapshot
// ID to check the snapshot progress or later use it when you want to create
// a volume from a snapshot.
//
// To list or delete a snapshot, you must use the Amazon EC2 API. For more
// information, see DescribeSnapshots or DeleteSnapshot in the EC2 API reference
// (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Operations.html).
func (c *StorageGateway) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshotFromVolumeRecoveryPoint = "CreateSnapshotFromVolumeRecoveryPoint"

// CreateSnapshotFromVolumeRecoveryPointRequest generates a request for the CreateSnapshotFromVolumeRecoveryPoint operation.
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPointRequest(input *CreateSnapshotFromVolumeRecoveryPointInput) (req *service.Request, output *CreateSnapshotFromVolumeRecoveryPointOutput) {
	op := &service.Operation{
		Name:       opCreateSnapshotFromVolumeRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotFromVolumeRecoveryPointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSnapshotFromVolumeRecoveryPointOutput{}
	req.Data = output
	return
}

// This operation initiates a snapshot of a gateway from a volume recovery point.
// This operation is supported only for the gateway-cached volume architecture
// (see ).
//
// A volume recovery point is a point in time at which all data of the volume
// is consistent and from which you can create a snapshot. To get a list of
// volume recovery point for gateway-cached volumes, use ListVolumeRecoveryPoints.
//
// In the CreateSnapshotFromVolumeRecoveryPoint request, you identify the volume
// by providing its Amazon Resource Name (ARN). You must also provide a description
// for the snapshot. When AWS Storage Gateway takes a snapshot of the specified
// volume, the snapshot and its description appear in the AWS Storage Gateway
// console. In response, AWS Storage Gateway returns you a snapshot ID. You
// can use this snapshot ID to check the snapshot progress or later use it when
// you want to create a volume from a snapshot.
//
//  To list or delete a snapshot, you must use the Amazon EC2 API. For more
// information, in Amazon Elastic Compute Cloud API Reference.
func (c *StorageGateway) CreateSnapshotFromVolumeRecoveryPoint(input *CreateSnapshotFromVolumeRecoveryPointInput) (*CreateSnapshotFromVolumeRecoveryPointOutput, error) {
	req, out := c.CreateSnapshotFromVolumeRecoveryPointRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStorediSCSIVolume = "CreateStorediSCSIVolume"

// CreateStorediSCSIVolumeRequest generates a request for the CreateStorediSCSIVolume operation.
func (c *StorageGateway) CreateStorediSCSIVolumeRequest(input *CreateStorediSCSIVolumeInput) (req *service.Request, output *CreateStorediSCSIVolumeOutput) {
	op := &service.Operation{
		Name:       opCreateStorediSCSIVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStorediSCSIVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateStorediSCSIVolumeOutput{}
	req.Data = output
	return
}

// This operation creates a volume on a specified gateway. This operation is
// supported only for the gateway-stored volume architecture.
//
// The size of the volume to create is inferred from the disk size. You can
// choose to preserve existing data on the disk, create volume from an existing
// snapshot, or create an empty volume. If you choose to create an empty gateway
// volume, then any existing data on the disk is erased.
//
// In the request you must specify the gateway and the disk information on
// which you are creating the volume. In response, AWS Storage Gateway creates
// the volume and returns volume information such as the volume Amazon Resource
// Name (ARN), its size, and the iSCSI target ARN that initiators can use to
// connect to the volume target.
func (c *StorageGateway) CreateStorediSCSIVolume(input *CreateStorediSCSIVolumeInput) (*CreateStorediSCSIVolumeOutput, error) {
	req, out := c.CreateStorediSCSIVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTapes = "CreateTapes"

// CreateTapesRequest generates a request for the CreateTapes operation.
func (c *StorageGateway) CreateTapesRequest(input *CreateTapesInput) (req *service.Request, output *CreateTapesOutput) {
	op := &service.Operation{
		Name:       opCreateTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTapesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTapesOutput{}
	req.Data = output
	return
}

// Creates one or more virtual tapes. You write data to the virtual tapes and
// then archive the tapes.
//
// Cache storage must be allocated to the gateway before you can create virtual
// tapes. Use the AddCache operation to add cache storage to a gateway.
func (c *StorageGateway) CreateTapes(input *CreateTapesInput) (*CreateTapesOutput, error) {
	req, out := c.CreateTapesRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteBandwidthRateLimit = "DeleteBandwidthRateLimit"

// DeleteBandwidthRateLimitRequest generates a request for the DeleteBandwidthRateLimit operation.
func (c *StorageGateway) DeleteBandwidthRateLimitRequest(input *DeleteBandwidthRateLimitInput) (req *service.Request, output *DeleteBandwidthRateLimitOutput) {
	op := &service.Operation{
		Name:       opDeleteBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBandwidthRateLimitInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteBandwidthRateLimitOutput{}
	req.Data = output
	return
}

// This operation deletes the bandwidth rate limits of a gateway. You can delete
// either the upload and download bandwidth rate limit, or you can delete both.
// If you delete only one of the limits, the other limit remains unchanged.
// To specify which gateway to work with, use the Amazon Resource Name (ARN)
// of the gateway in your request.
func (c *StorageGateway) DeleteBandwidthRateLimit(input *DeleteBandwidthRateLimitInput) (*DeleteBandwidthRateLimitOutput, error) {
	req, out := c.DeleteBandwidthRateLimitRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteChapCredentials = "DeleteChapCredentials"

// DeleteChapCredentialsRequest generates a request for the DeleteChapCredentials operation.
func (c *StorageGateway) DeleteChapCredentialsRequest(input *DeleteChapCredentialsInput) (req *service.Request, output *DeleteChapCredentialsOutput) {
	op := &service.Operation{
		Name:       opDeleteChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteChapCredentialsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteChapCredentialsOutput{}
	req.Data = output
	return
}

// This operation deletes Challenge-Handshake Authentication Protocol (CHAP)
// credentials for a specified iSCSI target and initiator pair.
func (c *StorageGateway) DeleteChapCredentials(input *DeleteChapCredentialsInput) (*DeleteChapCredentialsOutput, error) {
	req, out := c.DeleteChapCredentialsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteGateway = "DeleteGateway"

// DeleteGatewayRequest generates a request for the DeleteGateway operation.
func (c *StorageGateway) DeleteGatewayRequest(input *DeleteGatewayInput) (req *service.Request, output *DeleteGatewayOutput) {
	op := &service.Operation{
		Name:       opDeleteGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteGatewayOutput{}
	req.Data = output
	return
}

// This operation deletes a gateway. To specify which gateway to delete, use
// the Amazon Resource Name (ARN) of the gateway in your request. The operation
// deletes the gateway; however, it does not delete the gateway virtual machine
// (VM) from your host computer.
//
// After you delete a gateway, you cannot reactivate it. Completed snapshots
// of the gateway volumes are not deleted upon deleting the gateway, however,
// pending snapshots will not complete. After you delete a gateway, your next
// step is to remove it from your environment.
//
//  You no longer pay software charges after the gateway is deleted; however,
// your existing Amazon EBS snapshots persist and you will continue to be billed
// for these snapshots. You can choose to remove all remaining Amazon EBS snapshots
// by canceling your Amazon EC2 subscription.  If you prefer not to cancel your
// Amazon EC2 subscription, you can delete your snapshots using the Amazon EC2
// console. For more information, see the  AWS Storage Gateway Detail Page (http://aws.amazon.com/storagegateway).
func (c *StorageGateway) DeleteGateway(input *DeleteGatewayInput) (*DeleteGatewayOutput, error) {
	req, out := c.DeleteGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSnapshotSchedule = "DeleteSnapshotSchedule"

// DeleteSnapshotScheduleRequest generates a request for the DeleteSnapshotSchedule operation.
func (c *StorageGateway) DeleteSnapshotScheduleRequest(input *DeleteSnapshotScheduleInput) (req *service.Request, output *DeleteSnapshotScheduleOutput) {
	op := &service.Operation{
		Name:       opDeleteSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotScheduleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSnapshotScheduleOutput{}
	req.Data = output
	return
}

// This operation deletes a snapshot of a volume.
//
//  You can take snapshots of your gateway volumes on a scheduled or ad-hoc
// basis. This API enables you to delete a snapshot schedule for a volume. For
// more information, see Working with Snapshots (http://docs.aws.amazon.com/storagegateway/latest/userguide/WorkingWithSnapshots.html).
// In the DeleteSnapshotSchedule request, you identify the volume by providing
// its Amazon Resource Name (ARN).
//
//  To list or delete a snapshot, you must use the Amazon EC2 API. in Amazon
// Elastic Compute Cloud API Reference.
func (c *StorageGateway) DeleteSnapshotSchedule(input *DeleteSnapshotScheduleInput) (*DeleteSnapshotScheduleOutput, error) {
	req, out := c.DeleteSnapshotScheduleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTape = "DeleteTape"

// DeleteTapeRequest generates a request for the DeleteTape operation.
func (c *StorageGateway) DeleteTapeRequest(input *DeleteTapeInput) (req *service.Request, output *DeleteTapeOutput) {
	op := &service.Operation{
		Name:       opDeleteTape,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTapeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTapeOutput{}
	req.Data = output
	return
}

// Deletes the specified virtual tape.
func (c *StorageGateway) DeleteTape(input *DeleteTapeInput) (*DeleteTapeOutput, error) {
	req, out := c.DeleteTapeRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTapeArchive = "DeleteTapeArchive"

// DeleteTapeArchiveRequest generates a request for the DeleteTapeArchive operation.
func (c *StorageGateway) DeleteTapeArchiveRequest(input *DeleteTapeArchiveInput) (req *service.Request, output *DeleteTapeArchiveOutput) {
	op := &service.Operation{
		Name:       opDeleteTapeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTapeArchiveInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTapeArchiveOutput{}
	req.Data = output
	return
}

// Deletes the specified virtual tape from the virtual tape shelf (VTS).
func (c *StorageGateway) DeleteTapeArchive(input *DeleteTapeArchiveInput) (*DeleteTapeArchiveOutput, error) {
	req, out := c.DeleteTapeArchiveRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVolume = "DeleteVolume"

// DeleteVolumeRequest generates a request for the DeleteVolume operation.
func (c *StorageGateway) DeleteVolumeRequest(input *DeleteVolumeInput) (req *service.Request, output *DeleteVolumeOutput) {
	op := &service.Operation{
		Name:       opDeleteVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVolumeOutput{}
	req.Data = output
	return
}

// This operation delete the specified gateway volume that you previously created
// using the CreateStorediSCSIVolume API. For gateway-stored volumes, the local
// disk that was configured as the storage volume is not deleted. You can reuse
// the local disk to create another storage volume.
//
// Before you delete a gateway volume, make sure there are no iSCSI connections
// to the volume you are deleting. You should also make sure there is no snapshot
// in progress. You can use the Amazon Elastic Compute Cloud (Amazon EC2) API
// to query snapshots on the volume you are deleting and check the snapshot
// status. For more information, go to DescribeSnapshots (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
// in the Amazon Elastic Compute Cloud API Reference.
//
// In the request, you must provide the Amazon Resource Name (ARN) of the storage
// volume you want to delete.
func (c *StorageGateway) DeleteVolume(input *DeleteVolumeInput) (*DeleteVolumeOutput, error) {
	req, out := c.DeleteVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeBandwidthRateLimit = "DescribeBandwidthRateLimit"

// DescribeBandwidthRateLimitRequest generates a request for the DescribeBandwidthRateLimit operation.
func (c *StorageGateway) DescribeBandwidthRateLimitRequest(input *DescribeBandwidthRateLimitInput) (req *service.Request, output *DescribeBandwidthRateLimitOutput) {
	op := &service.Operation{
		Name:       opDescribeBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBandwidthRateLimitInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeBandwidthRateLimitOutput{}
	req.Data = output
	return
}

// This operation returns the bandwidth rate limits of a gateway. By default,
// these limits are not set, which means no bandwidth rate limiting is in effect.
//
// This operation only returns a value for a bandwidth rate limit only if the
// limit is set. If no limits are set for the gateway, then this operation returns
// only the gateway ARN in the response body. To specify which gateway to describe,
// use the Amazon Resource Name (ARN) of the gateway in your request.
func (c *StorageGateway) DescribeBandwidthRateLimit(input *DescribeBandwidthRateLimitInput) (*DescribeBandwidthRateLimitOutput, error) {
	req, out := c.DescribeBandwidthRateLimitRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCache = "DescribeCache"

// DescribeCacheRequest generates a request for the DescribeCache operation.
func (c *StorageGateway) DescribeCacheRequest(input *DescribeCacheInput) (req *service.Request, output *DescribeCacheOutput) {
	op := &service.Operation{
		Name:       opDescribeCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCacheInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCacheOutput{}
	req.Data = output
	return
}

// This operation returns information about the cache of a gateway. This operation
// is supported only for the gateway-cached volume architecture.
//
//  The response includes disk IDs that are configured as cache, and it includes
// the amount of cache allocated and used.
func (c *StorageGateway) DescribeCache(input *DescribeCacheInput) (*DescribeCacheOutput, error) {
	req, out := c.DescribeCacheRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCachediSCSIVolumes = "DescribeCachediSCSIVolumes"

// DescribeCachediSCSIVolumesRequest generates a request for the DescribeCachediSCSIVolumes operation.
func (c *StorageGateway) DescribeCachediSCSIVolumesRequest(input *DescribeCachediSCSIVolumesInput) (req *service.Request, output *DescribeCachediSCSIVolumesOutput) {
	op := &service.Operation{
		Name:       opDescribeCachediSCSIVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCachediSCSIVolumesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCachediSCSIVolumesOutput{}
	req.Data = output
	return
}

// This operation returns a description of the gateway volumes specified in
// the request. This operation is supported only for the gateway-cached volume
// architecture.
//
//  The list of gateway volumes in the request must be from one gateway. In
// the response Amazon Storage Gateway returns volume information sorted by
// volume Amazon Resource Name (ARN).
func (c *StorageGateway) DescribeCachediSCSIVolumes(input *DescribeCachediSCSIVolumesInput) (*DescribeCachediSCSIVolumesOutput, error) {
	req, out := c.DescribeCachediSCSIVolumesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeChapCredentials = "DescribeChapCredentials"

// DescribeChapCredentialsRequest generates a request for the DescribeChapCredentials operation.
func (c *StorageGateway) DescribeChapCredentialsRequest(input *DescribeChapCredentialsInput) (req *service.Request, output *DescribeChapCredentialsOutput) {
	op := &service.Operation{
		Name:       opDescribeChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeChapCredentialsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeChapCredentialsOutput{}
	req.Data = output
	return
}

// This operation returns an array of Challenge-Handshake Authentication Protocol
// (CHAP) credentials information for a specified iSCSI target, one for each
// target-initiator pair.
func (c *StorageGateway) DescribeChapCredentials(input *DescribeChapCredentialsInput) (*DescribeChapCredentialsOutput, error) {
	req, out := c.DescribeChapCredentialsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeGatewayInformation = "DescribeGatewayInformation"

// DescribeGatewayInformationRequest generates a request for the DescribeGatewayInformation operation.
func (c *StorageGateway) DescribeGatewayInformationRequest(input *DescribeGatewayInformationInput) (req *service.Request, output *DescribeGatewayInformationOutput) {
	op := &service.Operation{
		Name:       opDescribeGatewayInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeGatewayInformationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeGatewayInformationOutput{}
	req.Data = output
	return
}

// This operation returns metadata about a gateway such as its name, network
// interfaces, configured time zone, and the state (whether the gateway is running
// or not). To specify which gateway to describe, use the Amazon Resource Name
// (ARN) of the gateway in your request.
func (c *StorageGateway) DescribeGatewayInformation(input *DescribeGatewayInformationInput) (*DescribeGatewayInformationOutput, error) {
	req, out := c.DescribeGatewayInformationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeMaintenanceStartTime = "DescribeMaintenanceStartTime"

// DescribeMaintenanceStartTimeRequest generates a request for the DescribeMaintenanceStartTime operation.
func (c *StorageGateway) DescribeMaintenanceStartTimeRequest(input *DescribeMaintenanceStartTimeInput) (req *service.Request, output *DescribeMaintenanceStartTimeOutput) {
	op := &service.Operation{
		Name:       opDescribeMaintenanceStartTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMaintenanceStartTimeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeMaintenanceStartTimeOutput{}
	req.Data = output
	return
}

// This operation returns your gateway's weekly maintenance start time including
// the day and time of the week. Note that values are in terms of the gateway's
// time zone.
func (c *StorageGateway) DescribeMaintenanceStartTime(input *DescribeMaintenanceStartTimeInput) (*DescribeMaintenanceStartTimeOutput, error) {
	req, out := c.DescribeMaintenanceStartTimeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshotSchedule = "DescribeSnapshotSchedule"

// DescribeSnapshotScheduleRequest generates a request for the DescribeSnapshotSchedule operation.
func (c *StorageGateway) DescribeSnapshotScheduleRequest(input *DescribeSnapshotScheduleInput) (req *service.Request, output *DescribeSnapshotScheduleOutput) {
	op := &service.Operation{
		Name:       opDescribeSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotScheduleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSnapshotScheduleOutput{}
	req.Data = output
	return
}

// This operation describes the snapshot schedule for the specified gateway
// volume. The snapshot schedule information includes intervals at which snapshots
// are automatically initiated on the volume.
func (c *StorageGateway) DescribeSnapshotSchedule(input *DescribeSnapshotScheduleInput) (*DescribeSnapshotScheduleOutput, error) {
	req, out := c.DescribeSnapshotScheduleRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStorediSCSIVolumes = "DescribeStorediSCSIVolumes"

// DescribeStorediSCSIVolumesRequest generates a request for the DescribeStorediSCSIVolumes operation.
func (c *StorageGateway) DescribeStorediSCSIVolumesRequest(input *DescribeStorediSCSIVolumesInput) (req *service.Request, output *DescribeStorediSCSIVolumesOutput) {
	op := &service.Operation{
		Name:       opDescribeStorediSCSIVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStorediSCSIVolumesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStorediSCSIVolumesOutput{}
	req.Data = output
	return
}

// This operation returns the description of the gateway volumes specified in
// the request. The list of gateway volumes in the request must be from one
// gateway. In the response Amazon Storage Gateway returns volume information
// sorted by volume ARNs.
func (c *StorageGateway) DescribeStorediSCSIVolumes(input *DescribeStorediSCSIVolumesInput) (*DescribeStorediSCSIVolumesOutput, error) {
	req, out := c.DescribeStorediSCSIVolumesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTapeArchives = "DescribeTapeArchives"

// DescribeTapeArchivesRequest generates a request for the DescribeTapeArchives operation.
func (c *StorageGateway) DescribeTapeArchivesRequest(input *DescribeTapeArchivesInput) (req *service.Request, output *DescribeTapeArchivesOutput) {
	op := &service.Operation{
		Name:       opDescribeTapeArchives,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapeArchivesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTapeArchivesOutput{}
	req.Data = output
	return
}

// Returns a description of specified virtual tapes in the virtual tape shelf
// (VTS).
//
// If a specific TapeARN is not specified, AWS Storage Gateway returns a description
// of all virtual tapes found in the VTS associated with your account.
func (c *StorageGateway) DescribeTapeArchives(input *DescribeTapeArchivesInput) (*DescribeTapeArchivesOutput, error) {
	req, out := c.DescribeTapeArchivesRequest(input)
	err := req.Send()
	return out, err
}

func (c *StorageGateway) DescribeTapeArchivesPages(input *DescribeTapeArchivesInput, fn func(p *DescribeTapeArchivesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTapeArchivesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTapeArchivesOutput), lastPage)
	})
}

const opDescribeTapeRecoveryPoints = "DescribeTapeRecoveryPoints"

// DescribeTapeRecoveryPointsRequest generates a request for the DescribeTapeRecoveryPoints operation.
func (c *StorageGateway) DescribeTapeRecoveryPointsRequest(input *DescribeTapeRecoveryPointsInput) (req *service.Request, output *DescribeTapeRecoveryPointsOutput) {
	op := &service.Operation{
		Name:       opDescribeTapeRecoveryPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapeRecoveryPointsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTapeRecoveryPointsOutput{}
	req.Data = output
	return
}

// Returns a list of virtual tape recovery points that are available for the
// specified gateway-VTL.
//
// A recovery point is a point in time view of a virtual tape at which all
// the data on the virtual tape is consistent. If your gateway crashes, virtual
// tapes that have recovery points can be recovered to a new gateway.
func (c *StorageGateway) DescribeTapeRecoveryPoints(input *DescribeTapeRecoveryPointsInput) (*DescribeTapeRecoveryPointsOutput, error) {
	req, out := c.DescribeTapeRecoveryPointsRequest(input)
	err := req.Send()
	return out, err
}

func (c *StorageGateway) DescribeTapeRecoveryPointsPages(input *DescribeTapeRecoveryPointsInput, fn func(p *DescribeTapeRecoveryPointsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTapeRecoveryPointsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTapeRecoveryPointsOutput), lastPage)
	})
}

const opDescribeTapes = "DescribeTapes"

// DescribeTapesRequest generates a request for the DescribeTapes operation.
func (c *StorageGateway) DescribeTapesRequest(input *DescribeTapesInput) (req *service.Request, output *DescribeTapesOutput) {
	op := &service.Operation{
		Name:       opDescribeTapes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTapesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTapesOutput{}
	req.Data = output
	return
}

// Returns a description of the specified Amazon Resource Name (ARN) of virtual
// tapes. If a TapeARN is not specified, returns a description of all virtual
// tapes associated with the specified gateway.
func (c *StorageGateway) DescribeTapes(input *DescribeTapesInput) (*DescribeTapesOutput, error) {
	req, out := c.DescribeTapesRequest(input)
	err := req.Send()
	return out, err
}

func (c *StorageGateway) DescribeTapesPages(input *DescribeTapesInput, fn func(p *DescribeTapesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTapesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTapesOutput), lastPage)
	})
}

const opDescribeUploadBuffer = "DescribeUploadBuffer"

// DescribeUploadBufferRequest generates a request for the DescribeUploadBuffer operation.
func (c *StorageGateway) DescribeUploadBufferRequest(input *DescribeUploadBufferInput) (req *service.Request, output *DescribeUploadBufferOutput) {
	op := &service.Operation{
		Name:       opDescribeUploadBuffer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUploadBufferInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeUploadBufferOutput{}
	req.Data = output
	return
}

// This operation returns information about the upload buffer of a gateway.
// This operation is supported for both the gateway-stored and gateway-cached
// volume architectures.
//
//  The response includes disk IDs that are configured as upload buffer space,
// and it includes the amount of upload buffer space allocated and used.
func (c *StorageGateway) DescribeUploadBuffer(input *DescribeUploadBufferInput) (*DescribeUploadBufferOutput, error) {
	req, out := c.DescribeUploadBufferRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVTLDevices = "DescribeVTLDevices"

// DescribeVTLDevicesRequest generates a request for the DescribeVTLDevices operation.
func (c *StorageGateway) DescribeVTLDevicesRequest(input *DescribeVTLDevicesInput) (req *service.Request, output *DescribeVTLDevicesOutput) {
	op := &service.Operation{
		Name:       opDescribeVTLDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeVTLDevicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVTLDevicesOutput{}
	req.Data = output
	return
}

// Returns a description of virtual tape library (VTL) devices for the specified
// gateway. In the response, AWS Storage Gateway returns VTL device information.
//
// The list of VTL devices must be from one gateway.
func (c *StorageGateway) DescribeVTLDevices(input *DescribeVTLDevicesInput) (*DescribeVTLDevicesOutput, error) {
	req, out := c.DescribeVTLDevicesRequest(input)
	err := req.Send()
	return out, err
}

func (c *StorageGateway) DescribeVTLDevicesPages(input *DescribeVTLDevicesInput, fn func(p *DescribeVTLDevicesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeVTLDevicesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeVTLDevicesOutput), lastPage)
	})
}

const opDescribeWorkingStorage = "DescribeWorkingStorage"

// DescribeWorkingStorageRequest generates a request for the DescribeWorkingStorage operation.
func (c *StorageGateway) DescribeWorkingStorageRequest(input *DescribeWorkingStorageInput) (req *service.Request, output *DescribeWorkingStorageOutput) {
	op := &service.Operation{
		Name:       opDescribeWorkingStorage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkingStorageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeWorkingStorageOutput{}
	req.Data = output
	return
}

// This operation returns information about the working storage of a gateway.
// This operation is supported only for the gateway-stored volume architecture.
// This operation is deprecated in cached-volumes API version (20120630). Use
// DescribeUploadBuffer instead.
//
// Working storage is also referred to as upload buffer. You can also use the
// DescribeUploadBuffer operation to add upload buffer to a stored-volume gateway.
//
// The response includes disk IDs that are configured as working storage, and
// it includes the amount of working storage allocated and used.
func (c *StorageGateway) DescribeWorkingStorage(input *DescribeWorkingStorageInput) (*DescribeWorkingStorageOutput, error) {
	req, out := c.DescribeWorkingStorageRequest(input)
	err := req.Send()
	return out, err
}

const opDisableGateway = "DisableGateway"

// DisableGatewayRequest generates a request for the DisableGateway operation.
func (c *StorageGateway) DisableGatewayRequest(input *DisableGatewayInput) (req *service.Request, output *DisableGatewayOutput) {
	op := &service.Operation{
		Name:       opDisableGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableGatewayOutput{}
	req.Data = output
	return
}

// Disables a gateway when the gateway is no longer functioning. For example,
// if your gateway VM is damaged, you can disable the gateway so you can recover
// virtual tapes.
//
// Use this operation for a gateway-VTL that is not reachable or not functioning.
//
// Once a gateway is disabled it cannot be enabled.
func (c *StorageGateway) DisableGateway(input *DisableGatewayInput) (*DisableGatewayOutput, error) {
	req, out := c.DisableGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opListGateways = "ListGateways"

// ListGatewaysRequest generates a request for the ListGateways operation.
func (c *StorageGateway) ListGatewaysRequest(input *ListGatewaysInput) (req *service.Request, output *ListGatewaysOutput) {
	op := &service.Operation{
		Name:       opListGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListGatewaysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGatewaysOutput{}
	req.Data = output
	return
}

// This operation lists gateways owned by an AWS account in a region specified
// in the request. The returned list is ordered by gateway Amazon Resource Name
// (ARN).
//
// By default, the operation returns a maximum of 100 gateways. This operation
// supports pagination that allows you to optionally reduce the number of gateways
// returned in a response.
//
// If you have more gateways than are returned in a response-that is, the response
// returns only a truncated list of your gateways-the response contains a marker
// that you can specify in your next request to fetch the next page of gateways.
func (c *StorageGateway) ListGateways(input *ListGatewaysInput) (*ListGatewaysOutput, error) {
	req, out := c.ListGatewaysRequest(input)
	err := req.Send()
	return out, err
}

func (c *StorageGateway) ListGatewaysPages(input *ListGatewaysInput, fn func(p *ListGatewaysOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGatewaysRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGatewaysOutput), lastPage)
	})
}

const opListLocalDisks = "ListLocalDisks"

// ListLocalDisksRequest generates a request for the ListLocalDisks operation.
func (c *StorageGateway) ListLocalDisksRequest(input *ListLocalDisksInput) (req *service.Request, output *ListLocalDisksOutput) {
	op := &service.Operation{
		Name:       opListLocalDisks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLocalDisksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListLocalDisksOutput{}
	req.Data = output
	return
}

// This operation returns a list of the gateway's local disks. To specify which
// gateway to describe, you use the Amazon Resource Name (ARN) of the gateway
// in the body of the request.
//
// The request returns a list of all disks, specifying which are configured
// as working storage, cache storage, or stored volume or not configured at
// all. The response includes a DiskStatus field. This field can have a value
// of present (the disk is available to use), missing (the disk is no longer
// connected to the gateway), or mismatch (the disk node is occupied by a disk
// that has incorrect metadata or the disk content is corrupted).
func (c *StorageGateway) ListLocalDisks(input *ListLocalDisksInput) (*ListLocalDisksOutput, error) {
	req, out := c.ListLocalDisksRequest(input)
	err := req.Send()
	return out, err
}

const opListVolumeInitiators = "ListVolumeInitiators"

// ListVolumeInitiatorsRequest generates a request for the ListVolumeInitiators operation.
func (c *StorageGateway) ListVolumeInitiatorsRequest(input *ListVolumeInitiatorsInput) (req *service.Request, output *ListVolumeInitiatorsOutput) {
	op := &service.Operation{
		Name:       opListVolumeInitiators,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVolumeInitiatorsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVolumeInitiatorsOutput{}
	req.Data = output
	return
}

// This operation lists iSCSI initiators that are connected to a volume. You
// can use this operation to determine whether a volume is being used or not.
func (c *StorageGateway) ListVolumeInitiators(input *ListVolumeInitiatorsInput) (*ListVolumeInitiatorsOutput, error) {
	req, out := c.ListVolumeInitiatorsRequest(input)
	err := req.Send()
	return out, err
}

const opListVolumeRecoveryPoints = "ListVolumeRecoveryPoints"

// ListVolumeRecoveryPointsRequest generates a request for the ListVolumeRecoveryPoints operation.
func (c *StorageGateway) ListVolumeRecoveryPointsRequest(input *ListVolumeRecoveryPointsInput) (req *service.Request, output *ListVolumeRecoveryPointsOutput) {
	op := &service.Operation{
		Name:       opListVolumeRecoveryPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVolumeRecoveryPointsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVolumeRecoveryPointsOutput{}
	req.Data = output
	return
}

// This operation lists the recovery points for a specified gateway. This operation
// is supported only for the gateway-cached volume architecture.
//
// Each gateway-cached volume has one recovery point. A volume recovery point
// is a point in time at which all data of the volume is consistent and from
// which you can create a snapshot. To create a snapshot from a volume recovery
// point use the CreateSnapshotFromVolumeRecoveryPoint operation.
func (c *StorageGateway) ListVolumeRecoveryPoints(input *ListVolumeRecoveryPointsInput) (*ListVolumeRecoveryPointsOutput, error) {
	req, out := c.ListVolumeRecoveryPointsRequest(input)
	err := req.Send()
	return out, err
}

const opListVolumes = "ListVolumes"

// ListVolumesRequest generates a request for the ListVolumes operation.
func (c *StorageGateway) ListVolumesRequest(input *ListVolumesInput) (req *service.Request, output *ListVolumesOutput) {
	op := &service.Operation{
		Name:       opListVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &service.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVolumesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVolumesOutput{}
	req.Data = output
	return
}

// This operation lists the iSCSI stored volumes of a gateway. Results are sorted
// by volume ARN. The response includes only the volume ARNs. If you want additional
// volume information, use the DescribeStorediSCSIVolumes API.
//
// The operation supports pagination. By default, the operation returns a maximum
// of up to 100 volumes. You can optionally specify the Limit field in the body
// to limit the number of volumes in the response. If the number of volumes
// returned in the response is truncated, the response includes a Marker field.
// You can use this Marker value in your subsequent request to retrieve the
// next set of volumes.
func (c *StorageGateway) ListVolumes(input *ListVolumesInput) (*ListVolumesOutput, error) {
	req, out := c.ListVolumesRequest(input)
	err := req.Send()
	return out, err
}

func (c *StorageGateway) ListVolumesPages(input *ListVolumesInput, fn func(p *ListVolumesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListVolumesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListVolumesOutput), lastPage)
	})
}

const opResetCache = "ResetCache"

// ResetCacheRequest generates a request for the ResetCache operation.
func (c *StorageGateway) ResetCacheRequest(input *ResetCacheInput) (req *service.Request, output *ResetCacheOutput) {
	op := &service.Operation{
		Name:       opResetCache,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetCacheInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResetCacheOutput{}
	req.Data = output
	return
}

// This operation resets all cache disks that have encountered a error and makes
// the disks available for reconfiguration as cache storage. If your cache disk
// encounters a error, the gateway prevents read and write operations on virtual
// tapes in the gateway. For example, an error can occur when a disk is corrupted
// or removed from the gateway. When a cache is reset, the gateway loses its
// cache storage. At this point you can reconfigure the disks as cache disks.
//
//  If the cache disk you are resetting contains data that has not been uploaded
// to Amazon S3 yet, that data can be lost. After you reset cache disks, there
// will be no configured cache disks left in the gateway, so you must configure
// at least one new cache disk for your gateway to function properly.
func (c *StorageGateway) ResetCache(input *ResetCacheInput) (*ResetCacheOutput, error) {
	req, out := c.ResetCacheRequest(input)
	err := req.Send()
	return out, err
}

const opRetrieveTapeArchive = "RetrieveTapeArchive"

// RetrieveTapeArchiveRequest generates a request for the RetrieveTapeArchive operation.
func (c *StorageGateway) RetrieveTapeArchiveRequest(input *RetrieveTapeArchiveInput) (req *service.Request, output *RetrieveTapeArchiveOutput) {
	op := &service.Operation{
		Name:       opRetrieveTapeArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeArchiveInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RetrieveTapeArchiveOutput{}
	req.Data = output
	return
}

// Retrieves an archived virtual tape from the virtual tape shelf (VTS) to a
// gateway-VTL. Virtual tapes archived in the VTS are not associated with any
// gateway. However after a tape is retrieved, it is associated with a gateway,
// even though it is also listed in the VTS.
//
// Once a tape is successfully retrieved to a gateway, it cannot be retrieved
// again to another gateway. You must archive the tape again before you can
// retrieve it to another gateway.
func (c *StorageGateway) RetrieveTapeArchive(input *RetrieveTapeArchiveInput) (*RetrieveTapeArchiveOutput, error) {
	req, out := c.RetrieveTapeArchiveRequest(input)
	err := req.Send()
	return out, err
}

const opRetrieveTapeRecoveryPoint = "RetrieveTapeRecoveryPoint"

// RetrieveTapeRecoveryPointRequest generates a request for the RetrieveTapeRecoveryPoint operation.
func (c *StorageGateway) RetrieveTapeRecoveryPointRequest(input *RetrieveTapeRecoveryPointInput) (req *service.Request, output *RetrieveTapeRecoveryPointOutput) {
	op := &service.Operation{
		Name:       opRetrieveTapeRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveTapeRecoveryPointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RetrieveTapeRecoveryPointOutput{}
	req.Data = output
	return
}

// Retrieves the recovery point for the specified virtual tape.
//
// A recovery point is a point in time view of a virtual tape at which all
// the data on the tape is consistent. If your gateway crashes, virtual tapes
// that have recovery points can be recovered to a new gateway.
//
// The virtual tape can be retrieved to only one gateway. The retrieved tape
// is read-only. The virtual tape can be retrieved to only a gateway-VTL. There
// is no charge for retrieving recovery points.
func (c *StorageGateway) RetrieveTapeRecoveryPoint(input *RetrieveTapeRecoveryPointInput) (*RetrieveTapeRecoveryPointOutput, error) {
	req, out := c.RetrieveTapeRecoveryPointRequest(input)
	err := req.Send()
	return out, err
}

const opShutdownGateway = "ShutdownGateway"

// ShutdownGatewayRequest generates a request for the ShutdownGateway operation.
func (c *StorageGateway) ShutdownGatewayRequest(input *ShutdownGatewayInput) (req *service.Request, output *ShutdownGatewayOutput) {
	op := &service.Operation{
		Name:       opShutdownGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ShutdownGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ShutdownGatewayOutput{}
	req.Data = output
	return
}

// This operation shuts down a gateway. To specify which gateway to shut down,
// use the Amazon Resource Name (ARN) of the gateway in the body of your request.
//
// The operation shuts down the gateway service component running in the storage
// gateway's virtual machine (VM) and not the VM.
//
// If you want to shut down the VM, it is recommended that you first shut down
// the gateway component in the VM to avoid unpredictable conditions. After
// the gateway is shutdown, you cannot call any other API except StartGateway,
// DescribeGatewayInformation, and ListGateways. For more information, see ActivateGateway.
// Your applications cannot read from or write to the gateway's storage volumes,
// and there are no snapshots taken.
//
// When you make a shutdown request, you will get a 200 OK success response
// immediately. However, it might take some time for the gateway to shut down.
// You can call the DescribeGatewayInformation API to check the status. For
// more information, see ActivateGateway. If do not intend to use the gateway
// again, you must delete the gateway (using DeleteGateway) to no longer pay
// software charges associated with the gateway.
func (c *StorageGateway) ShutdownGateway(input *ShutdownGatewayInput) (*ShutdownGatewayOutput, error) {
	req, out := c.ShutdownGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opStartGateway = "StartGateway"

// StartGatewayRequest generates a request for the StartGateway operation.
func (c *StorageGateway) StartGatewayRequest(input *StartGatewayInput) (req *service.Request, output *StartGatewayOutput) {
	op := &service.Operation{
		Name:       opStartGateway,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartGatewayInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartGatewayOutput{}
	req.Data = output
	return
}

// This operation starts a gateway that you previously shut down (see ShutdownGateway).
// After the gateway starts, you can then make other API calls, your applications
// can read from or write to the gateway's storage volumes and you will be able
// to take snapshot backups.
//
// When you make a request, you will get a 200 OK success response immediately.
// However, it might take some time for the gateway to be ready. You should
// call DescribeGatewayInformation and check the status before making any additional
// API calls. For more information, see ActivateGateway. To specify which gateway
// to start, use the Amazon Resource Name (ARN) of the gateway in your request.
func (c *StorageGateway) StartGateway(input *StartGatewayInput) (*StartGatewayOutput, error) {
	req, out := c.StartGatewayRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateBandwidthRateLimit = "UpdateBandwidthRateLimit"

// UpdateBandwidthRateLimitRequest generates a request for the UpdateBandwidthRateLimit operation.
func (c *StorageGateway) UpdateBandwidthRateLimitRequest(input *UpdateBandwidthRateLimitInput) (req *service.Request, output *UpdateBandwidthRateLimitOutput) {
	op := &service.Operation{
		Name:       opUpdateBandwidthRateLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateBandwidthRateLimitInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateBandwidthRateLimitOutput{}
	req.Data = output
	return
}

// This operation updates the bandwidth rate limits of a gateway. You can update
// both the upload and download bandwidth rate limit or specify only one of
// the two. If you don't set a bandwidth rate limit, the existing rate limit
// remains.
//
// By default, a gateway's bandwidth rate limits are not set. If you don't
// set any limit, the gateway does not have any limitations on its bandwidth
// usage and could potentially use the maximum available bandwidth.
//
// To specify which gateway to update, use the Amazon Resource Name (ARN) of
// the gateway in your request.
func (c *StorageGateway) UpdateBandwidthRateLimit(input *UpdateBandwidthRateLimitInput) (*UpdateBandwidthRateLimitOutput, error) {
	req, out := c.UpdateBandwidthRateLimitRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateChapCredentials = "UpdateChapCredentials"

// UpdateChapCredentialsRequest generates a request for the UpdateChapCredentials operation.
func (c *StorageGateway) UpdateChapCredentialsRequest(input *UpdateChapCredentialsInput) (req *service.Request, output *UpdateChapCredentialsOutput) {
	op := &service.Operation{
		Name:       opUpdateChapCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateChapCredentialsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateChapCredentialsOutput{}
	req.Data = output
	return
}

// This operation updates the Challenge-Handshake Authentication Protocol (CHAP)
// credentials for a specified iSCSI target. By default, a gateway does not
// have CHAP enabled; however, for added security, you might use it.
//
//  When you update CHAP credentials, all existing connections on the target
// are closed and initiators must reconnect with the new credentials.
func (c *StorageGateway) UpdateChapCredentials(input *UpdateChapCredentialsInput) (*UpdateChapCredentialsOutput, error) {
	req, out := c.UpdateChapCredentialsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateGatewayInformation = "UpdateGatewayInformation"

// UpdateGatewayInformationRequest generates a request for the UpdateGatewayInformation operation.
func (c *StorageGateway) UpdateGatewayInformationRequest(input *UpdateGatewayInformationInput) (req *service.Request, output *UpdateGatewayInformationOutput) {
	op := &service.Operation{
		Name:       opUpdateGatewayInformation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewayInformationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateGatewayInformationOutput{}
	req.Data = output
	return
}

// This operation updates a gateway's metadata, which includes the gateway's
// name and time zone. To specify which gateway to update, use the Amazon Resource
// Name (ARN) of the gateway in your request.
func (c *StorageGateway) UpdateGatewayInformation(input *UpdateGatewayInformationInput) (*UpdateGatewayInformationOutput, error) {
	req, out := c.UpdateGatewayInformationRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateGatewaySoftwareNow = "UpdateGatewaySoftwareNow"

// UpdateGatewaySoftwareNowRequest generates a request for the UpdateGatewaySoftwareNow operation.
func (c *StorageGateway) UpdateGatewaySoftwareNowRequest(input *UpdateGatewaySoftwareNowInput) (req *service.Request, output *UpdateGatewaySoftwareNowOutput) {
	op := &service.Operation{
		Name:       opUpdateGatewaySoftwareNow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGatewaySoftwareNowInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateGatewaySoftwareNowOutput{}
	req.Data = output
	return
}

// This operation updates the gateway virtual machine (VM) software. The request
// immediately triggers the software update.
//
// When you make this request, you get a 200 OK success response immediately.
// However, it might take some time for the update to complete. You can call
// DescribeGatewayInformation to verify the gateway is in the STATE_RUNNING
// state. A software update forces a system restart of your gateway. You can
// minimize the chance of any disruption to your applications by increasing
// your iSCSI Initiators' timeouts. For more information about increasing iSCSI
// Initiator timeouts for Windows and Linux, see Customizing Your Windows iSCSI
// Settings (http://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorWindowsClient.html#CustomizeWindowsiSCSISettings)
// and Customizing Your Linux iSCSI Settings (http://docs.aws.amazon.com/storagegateway/latest/userguide/ConfiguringiSCSIClientInitiatorRedHatClient.html#CustomizeLinuxiSCSISettings),
// respectively.
func (c *StorageGateway) UpdateGatewaySoftwareNow(input *UpdateGatewaySoftwareNowInput) (*UpdateGatewaySoftwareNowOutput, error) {
	req, out := c.UpdateGatewaySoftwareNowRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateMaintenanceStartTime = "UpdateMaintenanceStartTime"

// UpdateMaintenanceStartTimeRequest generates a request for the UpdateMaintenanceStartTime operation.
func (c *StorageGateway) UpdateMaintenanceStartTimeRequest(input *UpdateMaintenanceStartTimeInput) (req *service.Request, output *UpdateMaintenanceStartTimeOutput) {
	op := &service.Operation{
		Name:       opUpdateMaintenanceStartTime,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMaintenanceStartTimeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateMaintenanceStartTimeOutput{}
	req.Data = output
	return
}

// This operation updates a gateway's weekly maintenance start time information,
// including day and time of the week. The maintenance time is the time in your
// gateway's time zone.
func (c *StorageGateway) UpdateMaintenanceStartTime(input *UpdateMaintenanceStartTimeInput) (*UpdateMaintenanceStartTimeOutput, error) {
	req, out := c.UpdateMaintenanceStartTimeRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSnapshotSchedule = "UpdateSnapshotSchedule"

// UpdateSnapshotScheduleRequest generates a request for the UpdateSnapshotSchedule operation.
func (c *StorageGateway) UpdateSnapshotScheduleRequest(input *UpdateSnapshotScheduleInput) (req *service.Request, output *UpdateSnapshotScheduleOutput) {
	op := &service.Operation{
		Name:       opUpdateSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSnapshotScheduleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateSnapshotScheduleOutput{}
	req.Data = output
	return
}

// This operation updates a snapshot schedule configured for a gateway volume.
//
// The default snapshot schedule for volume is once every 24 hours, starting
// at the creation time of the volume. You can use this API to change the snapshot
// schedule configured for the volume.
//
// In the request you must identify the gateway volume whose snapshot schedule
// you want to update, and the schedule information, including when you want
// the snapshot to begin on a day and the frequency (in hours) of snapshots.
func (c *StorageGateway) UpdateSnapshotSchedule(input *UpdateSnapshotScheduleInput) (*UpdateSnapshotScheduleOutput, error) {
	req, out := c.UpdateSnapshotScheduleRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateVTLDeviceType = "UpdateVTLDeviceType"

// UpdateVTLDeviceTypeRequest generates a request for the UpdateVTLDeviceType operation.
func (c *StorageGateway) UpdateVTLDeviceTypeRequest(input *UpdateVTLDeviceTypeInput) (req *service.Request, output *UpdateVTLDeviceTypeOutput) {
	op := &service.Operation{
		Name:       opUpdateVTLDeviceType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVTLDeviceTypeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateVTLDeviceTypeOutput{}
	req.Data = output
	return
}

// This operation updates the type of medium changer in a gateway-VTL. When
// you activate a gateway-VTL, you select a medium changer type for the gateway-VTL.
// This operation enables you to select a different type of medium changer after
// a gateway-VTL is activated.
func (c *StorageGateway) UpdateVTLDeviceType(input *UpdateVTLDeviceTypeInput) (*UpdateVTLDeviceTypeOutput, error) {
	req, out := c.UpdateVTLDeviceTypeRequest(input)
	err := req.Send()
	return out, err
}

// A JSON object containing one or more of the following fields:
//
//   ActivateGatewayInput$ActivationKey   GatewayName   ActivateGatewayInput$GatewayRegion
//   ActivateGatewayInput$GatewayTimezone   ActivateGatewayInput$GatewayType
//   ActivateGatewayInput$TapeDriveType   ActivateGatewayInput$MediumChangerType
type ActivateGatewayInput struct {
	// Your gateway activation key. You can obtain the activation key by sending
	// an HTTP GET request with redirects enabled to the gateway IP address (port
	// 80). The redirect URL returned in the response provides you the activation
	// key for your gateway in the query string parameter activationKey. It may
	// also include other activation-related parameters, however, these are merely
	// defaults -- the arguments you pass to the ActivateGateway API call determine
	// the actual configuration of your gateway.
	ActivationKey *string `type:"string" required:"true"`

	// A unique identifier for your gateway. This name becomes part of the gateway
	// Amazon Resources Name (ARN) which is what you use as an input to other operations.
	GatewayName *string `type:"string" required:"true"`

	// One of the values that indicates the region where you want to store the snapshot
	// backups. The gateway region specified must be the same region as the region
	// in your Host header in the request. For more information about available
	// regions and endpoints for AWS Storage Gateway, see Regions and Endpoints
	// (http://docs.aws.amazon.com/general/latest/gr/rande.html#sg_region) in the
	// Amazon Web Services Glossary.
	//
	// Valid Values: "us-east-1", "us-west-1", "us-west-2", "eu-west-1", "eu-central-1",
	// "ap-northeast-1", "ap-southeast-1", "ap-southeast-2", "sa-east-1"
	GatewayRegion *string `type:"string" required:"true"`

	// One of the values that indicates the time zone you want to set for the gateway.
	// The time zone is used, for example, for scheduling snapshots and your gateway's
	// maintenance schedule.
	GatewayTimezone *string `type:"string" required:"true"`

	// One of the values that defines the type of gateway to activate. The type
	// specified is critical to all later functions of the gateway and cannot be
	// changed after activation. The default value is STORED.
	GatewayType *string `type:"string"`

	// The value that indicates the type of medium changer to use for gateway-VTL.
	// This field is optional.
	//
	// Valid Values: "STK-L700", "AWS-Gateway-VTL"
	MediumChangerType *string `type:"string"`

	// The value that indicates the type of tape drive to use for gateway-VTL. This
	// field is optional.
	//
	// Valid Values: "IBM-ULT3580-TD5"
	TapeDriveType *string `type:"string"`

	metadataActivateGatewayInput `json:"-" xml:"-"`
}

type metadataActivateGatewayInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActivateGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateGatewayInput) GoString() string {
	return s.String()
}

// AWS Storage Gateway returns the Amazon Resource Name (ARN) of the activated
// gateway. It is a string made of information such as your account, gateway
// name, and region. This ARN is used to reference the gateway in other API
// operations as well as resource-based authorization.
type ActivateGatewayOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataActivateGatewayOutput `json:"-" xml:"-"`
}

type metadataActivateGatewayOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActivateGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivateGatewayOutput) GoString() string {
	return s.String()
}

type AddCacheInput struct {
	DiskIDs []*string `locationName:"DiskIds" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataAddCacheInput `json:"-" xml:"-"`
}

type metadataAddCacheInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCacheInput) GoString() string {
	return s.String()
}

type AddCacheOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataAddCacheOutput `json:"-" xml:"-"`
}

type metadataAddCacheOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCacheOutput) GoString() string {
	return s.String()
}

type AddUploadBufferInput struct {
	DiskIDs []*string `locationName:"DiskIds" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataAddUploadBufferInput `json:"-" xml:"-"`
}

type metadataAddUploadBufferInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddUploadBufferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUploadBufferInput) GoString() string {
	return s.String()
}

type AddUploadBufferOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataAddUploadBufferOutput `json:"-" xml:"-"`
}

type metadataAddUploadBufferOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddUploadBufferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUploadBufferOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//   AddWorkingStorageInput$DiskIds
type AddWorkingStorageInput struct {
	// An array of strings that identify disks that are to be configured as working
	// storage. Each string have a minimum length of 1 and maximum length of 300.
	// You can get the disk IDs from the ListLocalDisks API.
	DiskIDs []*string `locationName:"DiskIds" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataAddWorkingStorageInput `json:"-" xml:"-"`
}

type metadataAddWorkingStorageInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddWorkingStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddWorkingStorageInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway for which working storage was
// configured.
type AddWorkingStorageOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataAddWorkingStorageOutput `json:"-" xml:"-"`
}

type metadataAddWorkingStorageOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddWorkingStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddWorkingStorageOutput) GoString() string {
	return s.String()
}

type CachediSCSIVolume struct {
	SourceSnapshotID *string `locationName:"SourceSnapshotId" type:"string"`

	VolumeARN *string `type:"string"`

	VolumeID *string `locationName:"VolumeId" type:"string"`

	VolumeProgress *float64 `type:"double"`

	VolumeSizeInBytes *int64 `type:"long"`

	VolumeStatus *string `type:"string"`

	VolumeType *string `type:"string"`

	// Lists iSCSI information about a volume.
	VolumeiSCSIAttributes *VolumeiSCSIAttributes `type:"structure"`

	metadataCachediSCSIVolume `json:"-" xml:"-"`
}

type metadataCachediSCSIVolume struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CachediSCSIVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CachediSCSIVolume) GoString() string {
	return s.String()
}

// CancelArchivalInput
type CancelArchivalInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to cancel archiving
	// for.
	TapeARN *string `type:"string" required:"true"`

	metadataCancelArchivalInput `json:"-" xml:"-"`
}

type metadataCancelArchivalInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CancelArchivalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelArchivalInput) GoString() string {
	return s.String()
}

// CancelArchivalOutput
type CancelArchivalOutput struct {
	// The Amazon Resource Name (ARN) of the virtual tape for which archiving was
	// canceled.
	TapeARN *string `type:"string"`

	metadataCancelArchivalOutput `json:"-" xml:"-"`
}

type metadataCancelArchivalOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CancelArchivalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelArchivalOutput) GoString() string {
	return s.String()
}

// CancelRetrievalInput
type CancelRetrievalInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to cancel retrieval
	// for.
	TapeARN *string `type:"string" required:"true"`

	metadataCancelRetrievalInput `json:"-" xml:"-"`
}

type metadataCancelRetrievalInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CancelRetrievalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRetrievalInput) GoString() string {
	return s.String()
}

// CancelRetrievalOutput
type CancelRetrievalOutput struct {
	// The Amazon Resource Name (ARN) of the virtual tape for which retrieval was
	// canceled.
	TapeARN *string `type:"string"`

	metadataCancelRetrievalOutput `json:"-" xml:"-"`
}

type metadataCancelRetrievalOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CancelRetrievalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelRetrievalOutput) GoString() string {
	return s.String()
}

// Describes Challenge-Handshake Authentication Protocol (CHAP) information
// that supports authentication between your gateway and iSCSI initiators.
type ChapInfo struct {
	// The iSCSI initiator that connects to the target.
	InitiatorName *string `type:"string"`

	// The secret key that the initiator (for example, the Windows client) must
	// provide to participate in mutual CHAP with the target.
	SecretToAuthenticateInitiator *string `type:"string"`

	// The secret key that the target must provide to participate in mutual CHAP
	// with the initiator (e.g. Windows client).
	SecretToAuthenticateTarget *string `type:"string"`

	// The Amazon Resource Name (ARN) of the volume.
	//
	// Valid Values: 50 to 500 lowercase letters, numbers, periods (.), and hyphens
	// (-).
	TargetARN *string `type:"string"`

	metadataChapInfo `json:"-" xml:"-"`
}

type metadataChapInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ChapInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChapInfo) GoString() string {
	return s.String()
}

type CreateCachediSCSIVolumeInput struct {
	ClientToken *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	NetworkInterfaceID *string `locationName:"NetworkInterfaceId" type:"string" required:"true"`

	SnapshotID *string `locationName:"SnapshotId" type:"string"`

	TargetName *string `type:"string" required:"true"`

	VolumeSizeInBytes *int64 `type:"long" required:"true"`

	metadataCreateCachediSCSIVolumeInput `json:"-" xml:"-"`
}

type metadataCreateCachediSCSIVolumeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCachediSCSIVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachediSCSIVolumeInput) GoString() string {
	return s.String()
}

type CreateCachediSCSIVolumeOutput struct {
	TargetARN *string `type:"string"`

	VolumeARN *string `type:"string"`

	metadataCreateCachediSCSIVolumeOutput `json:"-" xml:"-"`
}

type metadataCreateCachediSCSIVolumeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCachediSCSIVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCachediSCSIVolumeOutput) GoString() string {
	return s.String()
}

type CreateSnapshotFromVolumeRecoveryPointInput struct {
	SnapshotDescription *string `type:"string" required:"true"`

	VolumeARN *string `type:"string" required:"true"`

	metadataCreateSnapshotFromVolumeRecoveryPointInput `json:"-" xml:"-"`
}

type metadataCreateSnapshotFromVolumeRecoveryPointInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointInput) GoString() string {
	return s.String()
}

type CreateSnapshotFromVolumeRecoveryPointOutput struct {
	SnapshotID *string `locationName:"SnapshotId" type:"string"`

	VolumeARN *string `type:"string"`

	VolumeRecoveryPointTime *string `type:"string"`

	metadataCreateSnapshotFromVolumeRecoveryPointOutput `json:"-" xml:"-"`
}

type metadataCreateSnapshotFromVolumeRecoveryPointOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotFromVolumeRecoveryPointOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//   CreateSnapshotInput$SnapshotDescription   CreateSnapshotInput$VolumeARN
type CreateSnapshotInput struct {
	// Textual description of the snapshot that appears in the Amazon EC2 console,
	// Elastic Block Store snapshots panel in the Description field, and in the
	// AWS Storage Gateway snapshot Details pane, Description field
	SnapshotDescription *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	VolumeARN *string `type:"string" required:"true"`

	metadataCreateSnapshotInput `json:"-" xml:"-"`
}

type metadataCreateSnapshotInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
type CreateSnapshotOutput struct {
	// The snapshot ID that is used to refer to the snapshot in future operations
	// such as describing snapshots (Amazon Elastic Compute Cloud API DescribeSnapshots)
	// or creating a volume from a snapshot (CreateStorediSCSIVolume).
	SnapshotID *string `locationName:"SnapshotId" type:"string"`

	// The Amazon Resource Name (ARN) of the volume of which the snapshot was taken.
	VolumeARN *string `type:"string"`

	metadataCreateSnapshotOutput `json:"-" xml:"-"`
}

type metadataCreateSnapshotOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//   CreateStorediSCSIVolumeInput$DiskId   CreateStorediSCSIVolumeInput$NetworkInterfaceId
//   CreateStorediSCSIVolumeInput$PreserveExistingData   CreateStorediSCSIVolumeInput$SnapshotId
//   CreateStorediSCSIVolumeInput$TargetName
type CreateStorediSCSIVolumeInput struct {
	// The unique identifier for the gateway local disk that is configured as a
	// stored volume. Use ListLocalDisks (http://docs.aws.amazon.com/storagegateway/latest/userguide/API_ListLocalDisks.html)
	// to list disk IDs for a gateway.
	DiskID *string `locationName:"DiskId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// The network interface of the gateway on which to expose the iSCSI target.
	// Only IPv4 addresses are accepted. Use DescribeGatewayInformation to get a
	// list of the network interfaces available on a gateway.
	//
	// Valid Values: A valid IP address.
	NetworkInterfaceID *string `locationName:"NetworkInterfaceId" type:"string" required:"true"`

	// Specify this field as true if you want to preserve the data on the local
	// disk. Otherwise, specifying this field as false creates an empty volume.
	//
	// Valid Values: true, false
	PreserveExistingData *bool `type:"boolean" required:"true"`

	// The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the
	// new stored volume. Specify this field if you want to create the iSCSI storage
	// volume from a snapshot otherwise do not include this field. To list snapshots
	// for your account use DescribeSnapshots (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html)
	// in the Amazon Elastic Compute Cloud API Reference.
	SnapshotID *string `locationName:"SnapshotId" type:"string"`

	// The name of the iSCSI target used by initiators to connect to the target
	// and as a suffix for the target ARN. For example, specifying TargetName as
	// myvolume results in the target ARN of arn:aws:storagegateway:us-east-1:111122223333:gateway/mygateway/target/iqn.1997-05.com.amazon:myvolume.
	// The target name must be unique across all volumes of a gateway.
	TargetName *string `type:"string" required:"true"`

	metadataCreateStorediSCSIVolumeInput `json:"-" xml:"-"`
}

type metadataCreateStorediSCSIVolumeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateStorediSCSIVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorediSCSIVolumeInput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
type CreateStorediSCSIVolumeOutput struct {
	// he Amazon Resource Name (ARN) of the volume target that includes the iSCSI
	// name that initiators can use to connect to the target.
	TargetARN *string `type:"string"`

	// The Amazon Resource Name (ARN) of the configured volume.
	VolumeARN *string `type:"string"`

	// The size of the volume in bytes.
	VolumeSizeInBytes *int64 `type:"long"`

	metadataCreateStorediSCSIVolumeOutput `json:"-" xml:"-"`
}

type metadataCreateStorediSCSIVolumeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateStorediSCSIVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorediSCSIVolumeOutput) GoString() string {
	return s.String()
}

// CreateTapesInput
type CreateTapesInput struct {
	// A unique identifier that you use to retry a request. If you retry a request,
	// use the same ClientToken you specified in the initial request.
	//
	// Using the same ClientToken prevents creating the tape multiple times.
	ClientToken *string `type:"string" required:"true"`

	// The unique Amazon Resource Name(ARN) that represents the gateway to associate
	// the virtual tapes with. Use the ListGateways operation to return a list of
	// gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// The number of virtual tapes you want to create.
	NumTapesToCreate *int64 `type:"integer" required:"true"`

	// A prefix you append to the barcode of the virtual tape you are creating.
	// This makes a barcode unique.
	//
	// The prefix must be 1 to 4 characters in length and must be upper-case letters
	// A-Z.
	TapeBarcodePrefix *string `type:"string" required:"true"`

	// The size, in bytes, of the virtual tapes you want to create.
	//
	// The size must be gigabyte (1024*1024*1024 byte) aligned.
	TapeSizeInBytes *int64 `type:"long" required:"true"`

	metadataCreateTapesInput `json:"-" xml:"-"`
}

type metadataCreateTapesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapesInput) GoString() string {
	return s.String()
}

// CreateTapeOutput
type CreateTapesOutput struct {
	// A list of unique Amazon Resource Named (ARN) the represents the virtual tapes
	// that were created.
	TapeARNs []*string `type:"list"`

	metadataCreateTapesOutput `json:"-" xml:"-"`
}

type metadataCreateTapesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTapesOutput) GoString() string {
	return s.String()
}

type DeleteBandwidthRateLimitInput struct {
	BandwidthType *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataDeleteBandwidthRateLimitInput `json:"-" xml:"-"`
}

type metadataDeleteBandwidthRateLimitInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway whose bandwidth rate information
// was deleted.
type DeleteBandwidthRateLimitOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataDeleteBandwidthRateLimitOutput `json:"-" xml:"-"`
}

type metadataDeleteBandwidthRateLimitOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//   DeleteChapCredentialsInput$InitiatorName   DeleteChapCredentialsInput$TargetARN
type DeleteChapCredentialsInput struct {
	// The iSCSI initiator that connects to the target.
	InitiatorName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	TargetARN *string `type:"string" required:"true"`

	metadataDeleteChapCredentialsInput `json:"-" xml:"-"`
}

type metadataDeleteChapCredentialsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChapCredentialsInput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
type DeleteChapCredentialsOutput struct {
	// The iSCSI initiator that connects to the target.
	InitiatorName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the target.
	TargetARN *string `type:"string"`

	metadataDeleteChapCredentialsOutput `json:"-" xml:"-"`
}

type metadataDeleteChapCredentialsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteChapCredentialsOutput) GoString() string {
	return s.String()
}

// A JSON object containing the id of the gateway to delete.
type DeleteGatewayInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataDeleteGatewayInput `json:"-" xml:"-"`
}

type metadataDeleteGatewayInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayInput) GoString() string {
	return s.String()
}

// A JSON object containing the id of the deleted gateway.
type DeleteGatewayOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataDeleteGatewayOutput `json:"-" xml:"-"`
}

type metadataDeleteGatewayOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGatewayOutput) GoString() string {
	return s.String()
}

type DeleteSnapshotScheduleInput struct {
	VolumeARN *string `type:"string" required:"true"`

	metadataDeleteSnapshotScheduleInput `json:"-" xml:"-"`
}

type metadataDeleteSnapshotScheduleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleInput) GoString() string {
	return s.String()
}

type DeleteSnapshotScheduleOutput struct {
	VolumeARN *string `type:"string"`

	metadataDeleteSnapshotScheduleOutput `json:"-" xml:"-"`
}

type metadataDeleteSnapshotScheduleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// DeleteTapeArchiveInput
type DeleteTapeArchiveInput struct {
	// The Amazon Resource Name (ARN) of the virtual tape to delete from the virtual
	// tape shelf (VTS).
	TapeARN *string `type:"string" required:"true"`

	metadataDeleteTapeArchiveInput `json:"-" xml:"-"`
}

type metadataDeleteTapeArchiveInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteTapeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeArchiveInput) GoString() string {
	return s.String()
}

// DeleteTapeArchiveOutput
type DeleteTapeArchiveOutput struct {
	// The Amazon Resource Name (ARN) of the virtual tape that was deleted from
	// the virtual tape shelf (VTS).
	TapeARN *string `type:"string"`

	metadataDeleteTapeArchiveOutput `json:"-" xml:"-"`
}

type metadataDeleteTapeArchiveOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteTapeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeArchiveOutput) GoString() string {
	return s.String()
}

// DeleteTapeInput
type DeleteTapeInput struct {
	// The unique Amazon Resource Name (ARN) of the gateway that the virtual tape
	// to delete is associated with. Use the ListGateways operation to return a
	// list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape to delete.
	TapeARN *string `type:"string" required:"true"`

	metadataDeleteTapeInput `json:"-" xml:"-"`
}

type metadataDeleteTapeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteTapeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeInput) GoString() string {
	return s.String()
}

// DeleteTapeOutput
type DeleteTapeOutput struct {
	// The Amazon Resource Name (ARN) of the deleted virtual tape.
	TapeARN *string `type:"string"`

	metadataDeleteTapeOutput `json:"-" xml:"-"`
}

type metadataDeleteTapeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteTapeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTapeOutput) GoString() string {
	return s.String()
}

// A JSON object containing the DeleteVolumeInput$VolumeARN to delete.
type DeleteVolumeInput struct {
	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	VolumeARN *string `type:"string" required:"true"`

	metadataDeleteVolumeInput `json:"-" xml:"-"`
}

type metadataDeleteVolumeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the storage volume that was deleted
type DeleteVolumeOutput struct {
	// The Amazon Resource Name (ARN) of the storage volume that was deleted. It
	// is the same ARN you provided in the request.
	VolumeARN *string `type:"string"`

	metadataDeleteVolumeOutput `json:"-" xml:"-"`
}

type metadataDeleteVolumeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVolumeOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway.
type DescribeBandwidthRateLimitInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataDescribeBandwidthRateLimitInput `json:"-" xml:"-"`
}

type metadataDescribeBandwidthRateLimitInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
type DescribeBandwidthRateLimitOutput struct {
	// The average download bandwidth rate limit in bits per second. This field
	// does not appear in the response if the download rate limit is not set.
	AverageDownloadRateLimitInBitsPerSec *int64 `type:"long"`

	// The average upload bandwidth rate limit in bits per second. This field does
	// not appear in the response if the upload rate limit is not set.
	AverageUploadRateLimitInBitsPerSec *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataDescribeBandwidthRateLimitOutput `json:"-" xml:"-"`
}

type metadataDescribeBandwidthRateLimitOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

type DescribeCacheInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataDescribeCacheInput `json:"-" xml:"-"`
}

type metadataDescribeCacheInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheInput) GoString() string {
	return s.String()
}

type DescribeCacheOutput struct {
	CacheAllocatedInBytes *int64 `type:"long"`

	CacheDirtyPercentage *float64 `type:"double"`

	CacheHitPercentage *float64 `type:"double"`

	CacheMissPercentage *float64 `type:"double"`

	CacheUsedPercentage *float64 `type:"double"`

	DiskIDs []*string `locationName:"DiskIds" type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataDescribeCacheOutput `json:"-" xml:"-"`
}

type metadataDescribeCacheOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCacheOutput) GoString() string {
	return s.String()
}

type DescribeCachediSCSIVolumesInput struct {
	VolumeARNs []*string `type:"list" required:"true"`

	metadataDescribeCachediSCSIVolumesInput `json:"-" xml:"-"`
}

type metadataDescribeCachediSCSIVolumesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCachediSCSIVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCachediSCSIVolumesInput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
type DescribeCachediSCSIVolumesOutput struct {
	// An array of objects where each object contains metadata about one cached
	// volume.
	CachediSCSIVolumes []*CachediSCSIVolume `type:"list"`

	metadataDescribeCachediSCSIVolumesOutput `json:"-" xml:"-"`
}

type metadataDescribeCachediSCSIVolumesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCachediSCSIVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCachediSCSIVolumesOutput) GoString() string {
	return s.String()
}

// A JSON object containing the Amazon Resource Name (ARN) of the iSCSI volume
// target.
type DescribeChapCredentialsInput struct {
	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return to retrieve the TargetARN for specified VolumeARN.
	TargetARN *string `type:"string" required:"true"`

	metadataDescribeChapCredentialsInput `json:"-" xml:"-"`
}

type metadataDescribeChapCredentialsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChapCredentialsInput) GoString() string {
	return s.String()
}

// A JSON object containing a .
type DescribeChapCredentialsOutput struct {
	// An array of ChapInfo objects that represent CHAP credentials. Each object
	// in the array contains CHAP credential information for one target-initiator
	// pair. If no CHAP credentials are set, an empty array is returned. CHAP credential
	// information is provided in a JSON object with the following fields:
	//
	//   InitiatorName: The iSCSI initiator that connects to the target.
	//
	//   SecretToAuthenticateInitiator: The secret key that the initiator (for
	// example, the Windows client) must provide to participate in mutual CHAP with
	// the target.
	//
	//   SecretToAuthenticateTarget: The secret key that the target must provide
	// to participate in mutual CHAP with the initiator (e.g. Windows client).
	//
	//   TargetARN: The Amazon Resource Name (ARN) of the storage volume.
	ChapCredentials []*ChapInfo `type:"list"`

	metadataDescribeChapCredentialsOutput `json:"-" xml:"-"`
}

type metadataDescribeChapCredentialsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeChapCredentialsOutput) GoString() string {
	return s.String()
}

// A JSON object containing the id of the gateway.
type DescribeGatewayInformationInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataDescribeGatewayInformationInput `json:"-" xml:"-"`
}

type metadataDescribeGatewayInformationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeGatewayInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayInformationInput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
type DescribeGatewayInformationOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	// The gateway ID.
	GatewayID *string `locationName:"GatewayId" type:"string"`

	// A NetworkInterface array that contains descriptions of the gateway network
	// interfaces.
	GatewayNetworkInterfaces []*NetworkInterface `type:"list"`

	// One of the values that indicates the operating state of the gateway.
	GatewayState *string `type:"string"`

	// One of the values that indicates the time zone configured for the gateway.
	GatewayTimezone *string `type:"string"`

	// The type of the gateway.
	GatewayType *string `type:"string"`

	// The date on which the last software update was applied to the gateway. If
	// the gateway has never been updated, this field does not return a value in
	// the response.
	LastSoftwareUpdate *string `type:"string"`

	// The date on which an update to the gateway is available. This date is in
	// the time zone of the gateway. If the gateway is not available for an update
	// this field is not returned in the response.
	NextUpdateAvailabilityDate *string `type:"string"`

	metadataDescribeGatewayInformationOutput `json:"-" xml:"-"`
}

type metadataDescribeGatewayInformationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeGatewayInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeGatewayInformationOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway.
type DescribeMaintenanceStartTimeInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataDescribeMaintenanceStartTimeInput `json:"-" xml:"-"`
}

type metadataDescribeMaintenanceStartTimeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeMaintenanceStartTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceStartTimeInput) GoString() string {
	return s.String()
}

type DescribeMaintenanceStartTimeOutput struct {
	DayOfWeek *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	HourOfDay *int64 `type:"integer"`

	MinuteOfHour *int64 `type:"integer"`

	Timezone *string `type:"string"`

	metadataDescribeMaintenanceStartTimeOutput `json:"-" xml:"-"`
}

type metadataDescribeMaintenanceStartTimeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeMaintenanceStartTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMaintenanceStartTimeOutput) GoString() string {
	return s.String()
}

// A JSON object containing the DescribeSnapshotScheduleInput$VolumeARN of the
// volume.
type DescribeSnapshotScheduleInput struct {
	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	VolumeARN *string `type:"string" required:"true"`

	metadataDescribeSnapshotScheduleInput `json:"-" xml:"-"`
}

type metadataDescribeSnapshotScheduleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotScheduleInput) GoString() string {
	return s.String()
}

type DescribeSnapshotScheduleOutput struct {
	Description *string `type:"string"`

	RecurrenceInHours *int64 `type:"integer"`

	StartAt *int64 `type:"integer"`

	Timezone *string `type:"string"`

	VolumeARN *string `type:"string"`

	metadataDescribeSnapshotScheduleOutput `json:"-" xml:"-"`
}

type metadataDescribeSnapshotScheduleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// A JSON Object containing a list of DescribeStorediSCSIVolumesInput$VolumeARNs.
type DescribeStorediSCSIVolumesInput struct {
	// An array of strings where each string represents the Amazon Resource Name
	// (ARN) of a stored volume. All of the specified stored volumes must from the
	// same gateway. Use ListVolumes to get volume ARNs for a gateway.
	VolumeARNs []*string `type:"list" required:"true"`

	metadataDescribeStorediSCSIVolumesInput `json:"-" xml:"-"`
}

type metadataDescribeStorediSCSIVolumesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStorediSCSIVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorediSCSIVolumesInput) GoString() string {
	return s.String()
}

type DescribeStorediSCSIVolumesOutput struct {
	StorediSCSIVolumes []*StorediSCSIVolume `type:"list"`

	metadataDescribeStorediSCSIVolumesOutput `json:"-" xml:"-"`
}

type metadataDescribeStorediSCSIVolumesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStorediSCSIVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStorediSCSIVolumesOutput) GoString() string {
	return s.String()
}

// DescribeTapeArchivesInput
type DescribeTapeArchivesInput struct {
	// Specifies that the number of virtual tapes descried be limited to the specified
	// number.
	Limit *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// virtual tapes.
	Marker *string `type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe.
	TapeARNs []*string `type:"list"`

	metadataDescribeTapeArchivesInput `json:"-" xml:"-"`
}

type metadataDescribeTapeArchivesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTapeArchivesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeArchivesInput) GoString() string {
	return s.String()
}

// DescribeTapeArchivesOutput
type DescribeTapeArchivesOutput struct {
	// An opaque string that indicates the position at which the virtual tapes that
	// were fetched for description ended. Use this marker in your next request
	// to fetch the next set of virtual tapes in the virtual tape shelf (VTS). If
	// there are no more virtual tapes to describe, this field does not appear in
	// the response.
	Marker *string `type:"string"`

	// An array of virtual tape objects in the virtual tape shelf (VTS). The description
	// includes of the Amazon Resource Name(ARN) of the virtual tapes. The information
	// returned includes the Amazon Resource Names (ARNs) of the tapes, size of
	// the tapes, status of the tapes, progress of the description and tape barcode.
	TapeArchives []*TapeArchive `type:"list"`

	metadataDescribeTapeArchivesOutput `json:"-" xml:"-"`
}

type metadataDescribeTapeArchivesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTapeArchivesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeArchivesOutput) GoString() string {
	return s.String()
}

// DescribeTapeRecoveryPointsInput
type DescribeTapeRecoveryPointsInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// Specifies that the number of virtual tape recovery points that are described
	// be limited to the specified number.
	Limit *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// the virtual tape recovery points.
	Marker *string `type:"string"`

	metadataDescribeTapeRecoveryPointsInput `json:"-" xml:"-"`
}

type metadataDescribeTapeRecoveryPointsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTapeRecoveryPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeRecoveryPointsInput) GoString() string {
	return s.String()
}

// DescribeTapeRecoveryPointsOutput
type DescribeTapeRecoveryPointsOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	// An opaque string that indicates the position at which the virtual tape recovery
	// points that were listed for description ended.
	//
	// Use this marker in your next request to list the next set of virtual tape
	// recovery points in the list. If there are no more recovery points to describe,
	// this field does not appear in the response.
	Marker *string `type:"string"`

	// An array of TapeRecoveryPointInfos that are available for the specified gateway.
	TapeRecoveryPointInfos []*TapeRecoveryPointInfo `type:"list"`

	metadataDescribeTapeRecoveryPointsOutput `json:"-" xml:"-"`
}

type metadataDescribeTapeRecoveryPointsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTapeRecoveryPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapeRecoveryPointsOutput) GoString() string {
	return s.String()
}

// DescribeTapesInput
type DescribeTapesInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// Specifies that the number of virtual tapes described be limited to the specified
	// number.
	//
	// Amazon Web Services may impose its own limit, if this field is not set.
	Limit *int64 `type:"integer"`

	// A marker value, obtained in a previous call to DescribeTapes. This marker
	// indicates which page of results to retrieve.
	//
	// If not specified, the first page of results is retrieved.
	Marker *string `type:"string"`

	// Specifies one or more unique Amazon Resource Names (ARNs) that represent
	// the virtual tapes you want to describe. If this parameter is not specified,
	// AWS Storage Gateway returns a description of all virtual tapes associated
	// with the specified gateway.
	TapeARNs []*string `type:"list"`

	metadataDescribeTapesInput `json:"-" xml:"-"`
}

type metadataDescribeTapesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTapesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapesInput) GoString() string {
	return s.String()
}

// DescribeTapesOutput
type DescribeTapesOutput struct {
	// An opaque string which can be used as part of a subsequent DescribeTapes
	// call to retrieve the next page of results.
	//
	// If a response does not contain a marker, then there are no more results
	// to be retrieved.
	Marker *string `type:"string"`

	// An array of virtual tape descriptions.
	Tapes []*Tape `type:"list"`

	metadataDescribeTapesOutput `json:"-" xml:"-"`
}

type metadataDescribeTapesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTapesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTapesOutput) GoString() string {
	return s.String()
}

type DescribeUploadBufferInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataDescribeUploadBufferInput `json:"-" xml:"-"`
}

type metadataDescribeUploadBufferInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeUploadBufferInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUploadBufferInput) GoString() string {
	return s.String()
}

type DescribeUploadBufferOutput struct {
	DiskIDs []*string `locationName:"DiskIds" type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	UploadBufferAllocatedInBytes *int64 `type:"long"`

	UploadBufferUsedInBytes *int64 `type:"long"`

	metadataDescribeUploadBufferOutput `json:"-" xml:"-"`
}

type metadataDescribeUploadBufferOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeUploadBufferOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUploadBufferOutput) GoString() string {
	return s.String()
}

// DescribeVTLDevicesInput
type DescribeVTLDevicesInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// Specifies that the number of VTL devices described be limited to the specified
	// number.
	Limit *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin describing
	// the VTL devices.
	Marker *string `type:"string"`

	// An array of strings, where each string represents the Amazon Resource Name
	// (ARN) of a VTL device.
	//
	// All of the specified VTL devices must be from the same gateway. If no VTL
	// devices are specified, the result will contain all devices on the specified
	// gateway.
	VTLDeviceARNs []*string `type:"list"`

	metadataDescribeVTLDevicesInput `json:"-" xml:"-"`
}

type metadataDescribeVTLDevicesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVTLDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVTLDevicesInput) GoString() string {
	return s.String()
}

// DescribeVTLDevicesOutput
type DescribeVTLDevicesOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	// An opaque string that indicates the position at which the VTL devices that
	// were fetched for description ended. Use the marker in your next request to
	// fetch the next set of VTL devices in the list. If there are no more VTL devices
	// to describe, this field does not appear in the response.
	Marker *string `type:"string"`

	// An array of VTL device objects composed of the Amazon Resource Name(ARN)
	// of the VTL devices.
	VTLDevices []*VTLDevice `type:"list"`

	metadataDescribeVTLDevicesOutput `json:"-" xml:"-"`
}

type metadataDescribeVTLDevicesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVTLDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVTLDevicesOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway.
type DescribeWorkingStorageInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataDescribeWorkingStorageInput `json:"-" xml:"-"`
}

type metadataDescribeWorkingStorageInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeWorkingStorageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkingStorageInput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
type DescribeWorkingStorageOutput struct {
	// An array of the gateway's local disk IDs that are configured as working storage.
	// Each local disk ID is specified as a string (minimum length of 1 and maximum
	// length of 300). If no local disks are configured as working storage, then
	// the DiskIds array is empty.
	DiskIDs []*string `locationName:"DiskIds" type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	// The total working storage in bytes allocated for the gateway. If no working
	// storage is configured for the gateway, this field returns 0.
	WorkingStorageAllocatedInBytes *int64 `type:"long"`

	// The total working storage in bytes in use by the gateway. If no working storage
	// is configured for the gateway, this field returns 0.
	WorkingStorageUsedInBytes *int64 `type:"long"`

	metadataDescribeWorkingStorageOutput `json:"-" xml:"-"`
}

type metadataDescribeWorkingStorageOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeWorkingStorageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkingStorageOutput) GoString() string {
	return s.String()
}

// Lists iSCSI information about a VTL device.
type DeviceiSCSIAttributes struct {
	// Indicates whether mutual CHAP is enabled for the iSCSI target.
	ChapEnabled *bool `type:"boolean"`

	// The network interface identifier of the VTL device.
	NetworkInterfaceID *string `locationName:"NetworkInterfaceId" type:"string"`

	// The port used to communicate with iSCSI VTL device targets.
	NetworkInterfacePort *int64 `type:"integer"`

	// Specifies the unique Amazon Resource Name(ARN) that encodes the iSCSI qualified
	// name(iqn) of a tape drive or media changer target.
	TargetARN *string `type:"string"`

	metadataDeviceiSCSIAttributes `json:"-" xml:"-"`
}

type metadataDeviceiSCSIAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeviceiSCSIAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeviceiSCSIAttributes) GoString() string {
	return s.String()
}

// DisableGatewayInput
type DisableGatewayInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataDisableGatewayInput `json:"-" xml:"-"`
}

type metadataDisableGatewayInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableGatewayInput) GoString() string {
	return s.String()
}

// DisableGatewayOutput
type DisableGatewayOutput struct {
	// The unique Amazon Resource Name of the disabled gateway.
	GatewayARN *string `type:"string"`

	metadataDisableGatewayOutput `json:"-" xml:"-"`
}

type metadataDisableGatewayOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableGatewayOutput) GoString() string {
	return s.String()
}

type Disk struct {
	DiskAllocationResource *string `type:"string"`

	DiskAllocationType *string `type:"string"`

	DiskID *string `locationName:"DiskId" type:"string"`

	DiskNode *string `type:"string"`

	DiskPath *string `type:"string"`

	DiskSizeInBytes *int64 `type:"long"`

	DiskStatus *string `type:"string"`

	metadataDisk `json:"-" xml:"-"`
}

type metadataDisk struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Disk) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Disk) GoString() string {
	return s.String()
}

// Provides additional information about an error that was returned by the service
// as an or. See the errorCode and errorDetails members for more information
// about the error.
type Error struct {
	// Additional information about the error.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// Human-readable text that provides detail about the error that occurred.
	ErrorDetails map[string]*string `locationName:"errorDetails" type:"map"`

	metadataError `json:"-" xml:"-"`
}

type metadataError struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Error) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Error) GoString() string {
	return s.String()
}

type GatewayInfo struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	GatewayOperationalState *string `type:"string"`

	GatewayType *string `type:"string"`

	metadataGatewayInfo `json:"-" xml:"-"`
}

type metadataGatewayInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GatewayInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GatewayInfo) GoString() string {
	return s.String()
}

// A JSON object containing zero or more of the following fields:
//
//   ListGatewaysInput$Limit   ListGatewaysInput$Marker
type ListGatewaysInput struct {
	// Specifies that the list of gateways returned be limited to the specified
	// number of items.
	Limit *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the returned
	// list of gateways.
	Marker *string `type:"string"`

	metadataListGatewaysInput `json:"-" xml:"-"`
}

type metadataListGatewaysInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysInput) GoString() string {
	return s.String()
}

type ListGatewaysOutput struct {
	Gateways []*GatewayInfo `type:"list"`

	Marker *string `type:"string"`

	metadataListGatewaysOutput `json:"-" xml:"-"`
}

type metadataListGatewaysOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGatewaysOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway.
type ListLocalDisksInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataListLocalDisksInput `json:"-" xml:"-"`
}

type metadataListLocalDisksInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListLocalDisksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocalDisksInput) GoString() string {
	return s.String()
}

type ListLocalDisksOutput struct {
	Disks []*Disk `type:"list"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataListLocalDisksOutput `json:"-" xml:"-"`
}

type metadataListLocalDisksOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListLocalDisksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLocalDisksOutput) GoString() string {
	return s.String()
}

// ListVolumeInitiatorsInput
type ListVolumeInitiatorsInput struct {
	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes for the gateway.
	VolumeARN *string `type:"string" required:"true"`

	metadataListVolumeInitiatorsInput `json:"-" xml:"-"`
}

type metadataListVolumeInitiatorsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVolumeInitiatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeInitiatorsInput) GoString() string {
	return s.String()
}

// ListVolumeInitiatorsOutput
type ListVolumeInitiatorsOutput struct {
	// The host names and port numbers of all iSCSI initiators that are connected
	// to the gateway.
	Initiators []*string `type:"list"`

	metadataListVolumeInitiatorsOutput `json:"-" xml:"-"`
}

type metadataListVolumeInitiatorsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVolumeInitiatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeInitiatorsOutput) GoString() string {
	return s.String()
}

type ListVolumeRecoveryPointsInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataListVolumeRecoveryPointsInput `json:"-" xml:"-"`
}

type metadataListVolumeRecoveryPointsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVolumeRecoveryPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeRecoveryPointsInput) GoString() string {
	return s.String()
}

type ListVolumeRecoveryPointsOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	VolumeRecoveryPointInfos []*VolumeRecoveryPointInfo `type:"list"`

	metadataListVolumeRecoveryPointsOutput `json:"-" xml:"-"`
}

type metadataListVolumeRecoveryPointsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVolumeRecoveryPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumeRecoveryPointsOutput) GoString() string {
	return s.String()
}

// A JSON object that contains one or more of the following fields:
//
//   ListVolumesInput$Limit   ListVolumesInput$Marker
type ListVolumesInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// Specifies that the list of volumes returned be limited to the specified number
	// of items.
	Limit *int64 `type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of volumes. Obtain the marker from the response of a previous List iSCSI
	// Volumes request.
	Marker *string `type:"string"`

	metadataListVolumesInput `json:"-" xml:"-"`
}

type metadataListVolumesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumesInput) GoString() string {
	return s.String()
}

type ListVolumesOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	Marker *string `type:"string"`

	VolumeInfos []*VolumeInfo `type:"list"`

	metadataListVolumesOutput `json:"-" xml:"-"`
}

type metadataListVolumesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVolumesOutput) GoString() string {
	return s.String()
}

// Describes a gateway's network interface.
type NetworkInterface struct {
	// The Internet Protocol version 4 (IPv4) address of the interface.
	IPV4Address *string `locationName:"Ipv4Address" type:"string"`

	// The Internet Protocol version 6 (IPv6) address of the interface. Currently
	// not supported.
	IPV6Address *string `locationName:"Ipv6Address" type:"string"`

	// The Media Access Control (MAC) address of the interface.
	//
	// This is currently unsupported and will not be returned in output.
	MACAddress *string `locationName:"MacAddress" type:"string"`

	metadataNetworkInterface `json:"-" xml:"-"`
}

type metadataNetworkInterface struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterface) GoString() string {
	return s.String()
}

type ResetCacheInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataResetCacheInput `json:"-" xml:"-"`
}

type metadataResetCacheInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ResetCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheInput) GoString() string {
	return s.String()
}

type ResetCacheOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataResetCacheOutput `json:"-" xml:"-"`
}

type metadataResetCacheOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ResetCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetCacheOutput) GoString() string {
	return s.String()
}

// RetrieveTapeArchiveInput
type RetrieveTapeArchiveInput struct {
	// The Amazon Resource Name (ARN) of the gateway you want to retrieve the virtual
	// tape to. Use the ListGateways operation to return a list of gateways for
	// your account and region.
	//
	// You retrieve archived virtual tapes to only one gateway and the gateway
	// must be a gateway-VTL.
	GatewayARN *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape you want to retrieve from
	// the virtual tape shelf (VTS).
	TapeARN *string `type:"string" required:"true"`

	metadataRetrieveTapeArchiveInput `json:"-" xml:"-"`
}

type metadataRetrieveTapeArchiveInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RetrieveTapeArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeArchiveInput) GoString() string {
	return s.String()
}

// RetrieveTapeArchiveOutput
type RetrieveTapeArchiveOutput struct {
	// The Amazon Resource Name (ARN) of the retrieved virtual tape.
	TapeARN *string `type:"string"`

	metadataRetrieveTapeArchiveOutput `json:"-" xml:"-"`
}

type metadataRetrieveTapeArchiveOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RetrieveTapeArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeArchiveOutput) GoString() string {
	return s.String()
}

// RetrieveTapeRecoveryPointInput
type RetrieveTapeRecoveryPointInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the virtual tape for which you want to
	// retrieve the recovery point.
	TapeARN *string `type:"string" required:"true"`

	metadataRetrieveTapeRecoveryPointInput `json:"-" xml:"-"`
}

type metadataRetrieveTapeRecoveryPointInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeRecoveryPointInput) GoString() string {
	return s.String()
}

// RetrieveTapeRecoveryPointOutput
type RetrieveTapeRecoveryPointOutput struct {
	// The Amazon Resource Name (ARN) of the virtual tape for which the recovery
	// point was retrieved.
	TapeARN *string `type:"string"`

	metadataRetrieveTapeRecoveryPointOutput `json:"-" xml:"-"`
}

type metadataRetrieveTapeRecoveryPointOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RetrieveTapeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveTapeRecoveryPointOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway to shut down.
type ShutdownGatewayInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataShutdownGatewayInput `json:"-" xml:"-"`
}

type metadataShutdownGatewayInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ShutdownGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownGatewayInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway that was shut down.
type ShutdownGatewayOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataShutdownGatewayOutput `json:"-" xml:"-"`
}

type metadataShutdownGatewayOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ShutdownGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownGatewayOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway to start.
type StartGatewayInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataStartGatewayInput `json:"-" xml:"-"`
}

type metadataStartGatewayInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartGatewayInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGatewayInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway that was restarted.
type StartGatewayOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataStartGatewayOutput `json:"-" xml:"-"`
}

type metadataStartGatewayOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartGatewayOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartGatewayOutput) GoString() string {
	return s.String()
}

type StorediSCSIVolume struct {
	PreservedExistingData *bool `type:"boolean"`

	SourceSnapshotID *string `locationName:"SourceSnapshotId" type:"string"`

	VolumeARN *string `type:"string"`

	VolumeDiskID *string `locationName:"VolumeDiskId" type:"string"`

	VolumeID *string `locationName:"VolumeId" type:"string"`

	VolumeProgress *float64 `type:"double"`

	VolumeSizeInBytes *int64 `type:"long"`

	VolumeStatus *string `type:"string"`

	VolumeType *string `type:"string"`

	// Lists iSCSI information about a volume.
	VolumeiSCSIAttributes *VolumeiSCSIAttributes `type:"structure"`

	metadataStorediSCSIVolume `json:"-" xml:"-"`
}

type metadataStorediSCSIVolume struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StorediSCSIVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorediSCSIVolume) GoString() string {
	return s.String()
}

// Describes a virtual tape object.
type Tape struct {
	// For archiving virtual tapes, indicates how much data remains to be uploaded
	// before archiving is complete.
	//
	// Range: 0 (not started) to 100 (complete).
	Progress *float64 `type:"double"`

	// The Amazon Resource Name (ARN) of the virtual tape.
	TapeARN *string `type:"string"`

	// The barcode that identifies a specific virtual tape.
	TapeBarcode *string `type:"string"`

	// The size, in bytes, of the virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The current state of the virtual tape.
	TapeStatus *string `type:"string"`

	// The virtual tape library (VTL) device that the virtual tape is associated
	// with.
	VTLDevice *string `type:"string"`

	metadataTape `json:"-" xml:"-"`
}

type metadataTape struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Tape) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tape) GoString() string {
	return s.String()
}

// Represents a virtual tape that is archived in the virtual tape shelf (VTS).
type TapeArchive struct {
	// The time that the archiving of the virtual tape was completed.
	//
	// The string format of the completion time is in the ISO8601 extended YYYY-MM-DD'T'HH:MM:SS'Z'
	// format.
	CompletionTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The Amazon Resource Name (ARN) of the gateway-VTL that the virtual tape is
	// being retrieved to.
	//
	// The virtual tape is retrieved from the virtual tape shelf (VTS).
	RetrievedTo *string `type:"string"`

	// The Amazon Resource Name (ARN) of an archived virtual tape.
	TapeARN *string `type:"string"`

	// The barcode that identifies the archived virtual tape.
	TapeBarcode *string `type:"string"`

	// The size, in bytes, of the archived virtual tape.
	TapeSizeInBytes *int64 `type:"long"`

	// The current state of the archived virtual tape.
	TapeStatus *string `type:"string"`

	metadataTapeArchive `json:"-" xml:"-"`
}

type metadataTapeArchive struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TapeArchive) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeArchive) GoString() string {
	return s.String()
}

// Describes a recovery point.
type TapeRecoveryPointInfo struct {
	// The Amazon Resource Name (ARN) of the virtual tape.
	TapeARN *string `type:"string"`

	// The time when the point-in-time view of the virtual tape was replicated for
	// later recovery.
	//
	// The string format of the tape recovery point time is in the ISO8601 extended
	// YYYY-MM-DD'T'HH:MM:SS'Z' format.
	TapeRecoveryPointTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The size, in bytes, of the virtual tapes to recover.
	TapeSizeInBytes *int64 `type:"long"`

	TapeStatus *string `type:"string"`

	metadataTapeRecoveryPointInfo `json:"-" xml:"-"`
}

type metadataTapeRecoveryPointInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TapeRecoveryPointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TapeRecoveryPointInfo) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//   UpdateBandwidthRateLimitInput$AverageDownloadRateLimitInBitsPerSec   UpdateBandwidthRateLimitInput$AverageUploadRateLimitInBitsPerSec
type UpdateBandwidthRateLimitInput struct {
	// The average download bandwidth rate limit in bits per second.
	AverageDownloadRateLimitInBitsPerSec *int64 `type:"long"`

	// The average upload bandwidth rate limit in bits per second.
	AverageUploadRateLimitInBitsPerSec *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataUpdateBandwidthRateLimitInput `json:"-" xml:"-"`
}

type metadataUpdateBandwidthRateLimitInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway whose throttle information was
// updated.
type UpdateBandwidthRateLimitOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataUpdateBandwidthRateLimitOutput `json:"-" xml:"-"`
}

type metadataUpdateBandwidthRateLimitOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateBandwidthRateLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateBandwidthRateLimitOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//   UpdateChapCredentialsInput$InitiatorName   UpdateChapCredentialsInput$SecretToAuthenticateInitiator
//   UpdateChapCredentialsInput$SecretToAuthenticateTarget   UpdateChapCredentialsInput$TargetARN
type UpdateChapCredentialsInput struct {
	// The iSCSI initiator that connects to the target.
	InitiatorName *string `type:"string" required:"true"`

	// The secret key that the initiator (for example, the Windows client) must
	// provide to participate in mutual CHAP with the target.
	//
	// The secret key must be between 12 and 16 bytes when encoded in UTF-8.
	SecretToAuthenticateInitiator *string `type:"string" required:"true"`

	// The secret key that the target must provide to participate in mutual CHAP
	// with the initiator (e.g. Windows client).
	//
	// Byte constraints: Minimum bytes of 12. Maximum bytes of 16.
	//
	// The secret key must be between 12 and 16 bytes when encoded in UTF-8.
	SecretToAuthenticateTarget *string `type:"string"`

	// The Amazon Resource Name (ARN) of the iSCSI volume target. Use the DescribeStorediSCSIVolumes
	// operation to return the TargetARN for specified VolumeARN.
	TargetARN *string `type:"string" required:"true"`

	metadataUpdateChapCredentialsInput `json:"-" xml:"-"`
}

type metadataUpdateChapCredentialsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateChapCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChapCredentialsInput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
type UpdateChapCredentialsOutput struct {
	// The iSCSI initiator that connects to the target. This is the same initiator
	// name specified in the request.
	InitiatorName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the target. This is the same target specified
	// in the request.
	TargetARN *string `type:"string"`

	metadataUpdateChapCredentialsOutput `json:"-" xml:"-"`
}

type metadataUpdateChapCredentialsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateChapCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateChapCredentialsOutput) GoString() string {
	return s.String()
}

type UpdateGatewayInformationInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// A unique identifier for your gateway. This name becomes part of the gateway
	// Amazon Resources Name (ARN) which is what you use as an input to other operations.
	GatewayName *string `type:"string"`

	GatewayTimezone *string `type:"string"`

	metadataUpdateGatewayInformationInput `json:"-" xml:"-"`
}

type metadataUpdateGatewayInformationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateGatewayInformationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayInformationInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway that was updated.
type UpdateGatewayInformationOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataUpdateGatewayInformationOutput `json:"-" xml:"-"`
}

type metadataUpdateGatewayInformationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateGatewayInformationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewayInformationOutput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway to update.
type UpdateGatewaySoftwareNowInput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	metadataUpdateGatewaySoftwareNowInput `json:"-" xml:"-"`
}

type metadataUpdateGatewaySoftwareNowInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateGatewaySoftwareNowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewaySoftwareNowInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway that was updated.
type UpdateGatewaySoftwareNowOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataUpdateGatewaySoftwareNowOutput `json:"-" xml:"-"`
}

type metadataUpdateGatewaySoftwareNowOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateGatewaySoftwareNowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGatewaySoftwareNowOutput) GoString() string {
	return s.String()
}

// A JSON object containing the following fields:
//
//   UpdateMaintenanceStartTimeInput$DayOfWeek   UpdateMaintenanceStartTimeInput$HourOfDay
//   UpdateMaintenanceStartTimeInput$MinuteOfHour
type UpdateMaintenanceStartTimeInput struct {
	// The maintenance start time day of the week.
	DayOfWeek *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string" required:"true"`

	// The hour component of the maintenance start time represented as hh, where
	// hh is the hour (00 to 23). The hour of the day is in the time zone of the
	// gateway.
	HourOfDay *int64 `type:"integer" required:"true"`

	// The minute component of the maintenance start time represented as mm, where
	// mm is the minute (00 to 59). The minute of the hour is in the time zone of
	// the gateway.
	MinuteOfHour *int64 `type:"integer" required:"true"`

	metadataUpdateMaintenanceStartTimeInput `json:"-" xml:"-"`
}

type metadataUpdateMaintenanceStartTimeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateMaintenanceStartTimeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMaintenanceStartTimeInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the gateway whose maintenance start time
// is updated.
type UpdateMaintenanceStartTimeOutput struct {
	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `type:"string"`

	metadataUpdateMaintenanceStartTimeOutput `json:"-" xml:"-"`
}

type metadataUpdateMaintenanceStartTimeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateMaintenanceStartTimeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMaintenanceStartTimeOutput) GoString() string {
	return s.String()
}

// A JSON object containing one or more of the following fields:
//
//   UpdateSnapshotScheduleInput$Description   UpdateSnapshotScheduleInput$RecurrenceInHours
//   UpdateSnapshotScheduleInput$StartAt   UpdateSnapshotScheduleInput$VolumeARN
type UpdateSnapshotScheduleInput struct {
	// Optional description of the snapshot that overwrites the existing description.
	Description *string `type:"string"`

	// Frequency of snapshots. Specify the number of hours between snapshots.
	RecurrenceInHours *int64 `type:"integer" required:"true"`

	// The hour of the day at which the snapshot schedule begins represented as
	// hh, where hh is the hour (0 to 23). The hour of the day is in the time zone
	// of the gateway.
	StartAt *int64 `type:"integer" required:"true"`

	// The Amazon Resource Name (ARN) of the volume. Use the ListVolumes operation
	// to return a list of gateway volumes.
	VolumeARN *string `type:"string" required:"true"`

	metadataUpdateSnapshotScheduleInput `json:"-" xml:"-"`
}

type metadataUpdateSnapshotScheduleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSnapshotScheduleInput) GoString() string {
	return s.String()
}

// A JSON object containing the of the updated storage volume.
type UpdateSnapshotScheduleOutput struct {
	VolumeARN *string `type:"string"`

	metadataUpdateSnapshotScheduleOutput `json:"-" xml:"-"`
}

type metadataUpdateSnapshotScheduleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSnapshotScheduleOutput) GoString() string {
	return s.String()
}

// UpdateVTLDeviceTypeInput
type UpdateVTLDeviceTypeInput struct {
	// The type of medium changer you want to select.
	//
	// Valid Values: "STK-L700", "AWS-Gateway-VTL"
	DeviceType *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the medium changer you want to select.
	VTLDeviceARN *string `type:"string" required:"true"`

	metadataUpdateVTLDeviceTypeInput `json:"-" xml:"-"`
}

type metadataUpdateVTLDeviceTypeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateVTLDeviceTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVTLDeviceTypeInput) GoString() string {
	return s.String()
}

// UpdateVTLDeviceTypeOutput
type UpdateVTLDeviceTypeOutput struct {
	// The Amazon Resource Name (ARN) of the medium changer you have selected.
	VTLDeviceARN *string `type:"string"`

	metadataUpdateVTLDeviceTypeOutput `json:"-" xml:"-"`
}

type metadataUpdateVTLDeviceTypeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateVTLDeviceTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVTLDeviceTypeOutput) GoString() string {
	return s.String()
}

// Represents a device object associated with a gateway-VTL.
type VTLDevice struct {
	// A list of iSCSI information about a VTL device.
	DeviceiSCSIAttributes *DeviceiSCSIAttributes `type:"structure"`

	// Specifies the unique Amazon Resource Name (ARN) of the device (tape drive
	// or media changer).
	VTLDeviceARN *string `type:"string"`

	VTLDeviceProductIdentifier *string `type:"string"`

	VTLDeviceType *string `type:"string"`

	VTLDeviceVendor *string `type:"string"`

	metadataVTLDevice `json:"-" xml:"-"`
}

type metadataVTLDevice struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VTLDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VTLDevice) GoString() string {
	return s.String()
}

type VolumeInfo struct {
	VolumeARN *string `type:"string"`

	VolumeType *string `type:"string"`

	metadataVolumeInfo `json:"-" xml:"-"`
}

type metadataVolumeInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VolumeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeInfo) GoString() string {
	return s.String()
}

type VolumeRecoveryPointInfo struct {
	VolumeARN *string `type:"string"`

	VolumeRecoveryPointTime *string `type:"string"`

	VolumeSizeInBytes *int64 `type:"long"`

	VolumeUsageInBytes *int64 `type:"long"`

	metadataVolumeRecoveryPointInfo `json:"-" xml:"-"`
}

type metadataVolumeRecoveryPointInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VolumeRecoveryPointInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeRecoveryPointInfo) GoString() string {
	return s.String()
}

// Lists iSCSI information about a volume.
type VolumeiSCSIAttributes struct {
	// Indicates whether mutual CHAP is enabled for the iSCSI target.
	ChapEnabled *bool `type:"boolean"`

	// The logical disk number.
	LunNumber *int64 `type:"integer"`

	// The network interface identifier.
	NetworkInterfaceID *string `locationName:"NetworkInterfaceId" type:"string"`

	// The port used to communicate with iSCSI targets.
	NetworkInterfacePort *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the volume target.
	TargetARN *string `type:"string"`

	metadataVolumeiSCSIAttributes `json:"-" xml:"-"`
}

type metadataVolumeiSCSIAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VolumeiSCSIAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeiSCSIAttributes) GoString() string {
	return s.String()
}

const (
	// @enum ErrorCode
	ErrorCodeActivationKeyExpired = "ActivationKeyExpired"
	// @enum ErrorCode
	ErrorCodeActivationKeyInvalid = "ActivationKeyInvalid"
	// @enum ErrorCode
	ErrorCodeActivationKeyNotFound = "ActivationKeyNotFound"
	// @enum ErrorCode
	ErrorCodeGatewayInternalError = "GatewayInternalError"
	// @enum ErrorCode
	ErrorCodeGatewayNotConnected = "GatewayNotConnected"
	// @enum ErrorCode
	ErrorCodeGatewayNotFound = "GatewayNotFound"
	// @enum ErrorCode
	ErrorCodeGatewayProxyNetworkConnectionBusy = "GatewayProxyNetworkConnectionBusy"
	// @enum ErrorCode
	ErrorCodeAuthenticationFailure = "AuthenticationFailure"
	// @enum ErrorCode
	ErrorCodeBandwidthThrottleScheduleNotFound = "BandwidthThrottleScheduleNotFound"
	// @enum ErrorCode
	ErrorCodeBlocked = "Blocked"
	// @enum ErrorCode
	ErrorCodeCannotExportSnapshot = "CannotExportSnapshot"
	// @enum ErrorCode
	ErrorCodeChapCredentialNotFound = "ChapCredentialNotFound"
	// @enum ErrorCode
	ErrorCodeDiskAlreadyAllocated = "DiskAlreadyAllocated"
	// @enum ErrorCode
	ErrorCodeDiskDoesNotExist = "DiskDoesNotExist"
	// @enum ErrorCode
	ErrorCodeDiskSizeGreaterThanVolumeMaxSize = "DiskSizeGreaterThanVolumeMaxSize"
	// @enum ErrorCode
	ErrorCodeDiskSizeLessThanVolumeSize = "DiskSizeLessThanVolumeSize"
	// @enum ErrorCode
	ErrorCodeDiskSizeNotGigAligned = "DiskSizeNotGigAligned"
	// @enum ErrorCode
	ErrorCodeDuplicateCertificateInfo = "DuplicateCertificateInfo"
	// @enum ErrorCode
	ErrorCodeDuplicateSchedule = "DuplicateSchedule"
	// @enum ErrorCode
	ErrorCodeEndpointNotFound = "EndpointNotFound"
	// @enum ErrorCode
	ErrorCodeIamnotSupported = "IAMNotSupported"
	// @enum ErrorCode
	ErrorCodeInitiatorInvalid = "InitiatorInvalid"
	// @enum ErrorCode
	ErrorCodeInitiatorNotFound = "InitiatorNotFound"
	// @enum ErrorCode
	ErrorCodeInternalError = "InternalError"
	// @enum ErrorCode
	ErrorCodeInvalidGateway = "InvalidGateway"
	// @enum ErrorCode
	ErrorCodeInvalidEndpoint = "InvalidEndpoint"
	// @enum ErrorCode
	ErrorCodeInvalidParameters = "InvalidParameters"
	// @enum ErrorCode
	ErrorCodeInvalidSchedule = "InvalidSchedule"
	// @enum ErrorCode
	ErrorCodeLocalStorageLimitExceeded = "LocalStorageLimitExceeded"
	// @enum ErrorCode
	ErrorCodeLunAlreadyAllocated = "LunAlreadyAllocated "
	// @enum ErrorCode
	ErrorCodeLunInvalid = "LunInvalid"
	// @enum ErrorCode
	ErrorCodeMaximumContentLengthExceeded = "MaximumContentLengthExceeded"
	// @enum ErrorCode
	ErrorCodeMaximumTapeCartridgeCountExceeded = "MaximumTapeCartridgeCountExceeded"
	// @enum ErrorCode
	ErrorCodeMaximumVolumeCountExceeded = "MaximumVolumeCountExceeded"
	// @enum ErrorCode
	ErrorCodeNetworkConfigurationChanged = "NetworkConfigurationChanged"
	// @enum ErrorCode
	ErrorCodeNoDisksAvailable = "NoDisksAvailable"
	// @enum ErrorCode
	ErrorCodeNotImplemented = "NotImplemented"
	// @enum ErrorCode
	ErrorCodeNotSupported = "NotSupported"
	// @enum ErrorCode
	ErrorCodeOperationAborted = "OperationAborted"
	// @enum ErrorCode
	ErrorCodeOutdatedGateway = "OutdatedGateway"
	// @enum ErrorCode
	ErrorCodeParametersNotImplemented = "ParametersNotImplemented"
	// @enum ErrorCode
	ErrorCodeRegionInvalid = "RegionInvalid"
	// @enum ErrorCode
	ErrorCodeRequestTimeout = "RequestTimeout"
	// @enum ErrorCode
	ErrorCodeServiceUnavailable = "ServiceUnavailable"
	// @enum ErrorCode
	ErrorCodeSnapshotDeleted = "SnapshotDeleted"
	// @enum ErrorCode
	ErrorCodeSnapshotIdInvalid = "SnapshotIdInvalid"
	// @enum ErrorCode
	ErrorCodeSnapshotInProgress = "SnapshotInProgress"
	// @enum ErrorCode
	ErrorCodeSnapshotNotFound = "SnapshotNotFound"
	// @enum ErrorCode
	ErrorCodeSnapshotScheduleNotFound = "SnapshotScheduleNotFound"
	// @enum ErrorCode
	ErrorCodeStagingAreaFull = "StagingAreaFull"
	// @enum ErrorCode
	ErrorCodeStorageFailure = "StorageFailure"
	// @enum ErrorCode
	ErrorCodeTapeCartridgeNotFound = "TapeCartridgeNotFound"
	// @enum ErrorCode
	ErrorCodeTargetAlreadyExists = "TargetAlreadyExists"
	// @enum ErrorCode
	ErrorCodeTargetInvalid = "TargetInvalid"
	// @enum ErrorCode
	ErrorCodeTargetNotFound = "TargetNotFound"
	// @enum ErrorCode
	ErrorCodeUnauthorizedOperation = "UnauthorizedOperation"
	// @enum ErrorCode
	ErrorCodeVolumeAlreadyExists = "VolumeAlreadyExists"
	// @enum ErrorCode
	ErrorCodeVolumeIdInvalid = "VolumeIdInvalid"
	// @enum ErrorCode
	ErrorCodeVolumeInUse = "VolumeInUse"
	// @enum ErrorCode
	ErrorCodeVolumeNotFound = "VolumeNotFound"
	// @enum ErrorCode
	ErrorCodeVolumeNotReady = "VolumeNotReady"
)
