// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package support

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/defaults"
	"github.com/aws/aws-sdk-go/aws/service"
	"github.com/aws/aws-sdk-go/internal/protocol/jsonrpc"
	"github.com/aws/aws-sdk-go/internal/signer/v4"
)

// The AWS Support API reference is intended for programmers who need detailed
// information about the AWS Support operations and data types. This service
// enables you to manage your AWS Support cases programmatically. It uses HTTP
// methods that return results in JSON format.
//
// The AWS Support service also exposes a set of Trusted Advisor (https://aws.amazon.com/premiumsupport/trustedadvisor/)
// features. You can retrieve a list of checks and their descriptions, get check
// results, specify checks to refresh, and get the refresh status of checks.
//
// The following list describes the AWS Support case management operations:
//
//   Service names, issue categories, and available severity levels. The DescribeServices
// and DescribeSeverityLevels operations return AWS service names, service codes,
// service categories, and problem severity levels. You use these values when
// you call the CreateCase operation.   Case creation, case details, and case
// resolution. The CreateCase, DescribeCases, DescribeAttachment, and ResolveCase
// operations create AWS Support cases, retrieve information about cases, and
// resolve cases.  Case communication. The DescribeCommunications, AddCommunicationToCase,
// and AddAttachmentsToSet operations retrieve and add communications and attachments
// to AWS Support cases.   The following list describes the operations available
// from the AWS Support service for Trusted Advisor:
//
//   DescribeTrustedAdvisorChecks returns the list of checks that run against
// your AWS resources. Using the CheckId for a specific check returned by DescribeTrustedAdvisorChecks,
// you can call DescribeTrustedAdvisorCheckResult to obtain the results for
// the check you specified.  DescribeTrustedAdvisorCheckSummaries returns summarized
// results for one or more Trusted Advisor checks.  RefreshTrustedAdvisorCheck
// requests that Trusted Advisor rerun a specified check.   DescribeTrustedAdvisorCheckRefreshStatuses
// reports the refresh status of one or more checks.   For authentication of
// requests, AWS Support uses Signature Version 4 Signing Process (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// See About the AWS Support API (http://docs.aws.amazon.com/awssupport/latest/user/Welcome.html)
// in the AWS Support User Guide for information about how to use this service
// to create and manage your support cases, and how to call Trusted Advisor
// for results of checks on your resources.
type Support struct {
	*service.Service
}

// Used for custom service initialization logic
var initService func(*service.Service)

// Used for custom request initialization logic
var initRequest func(*service.Request)

// New returns a new Support client.
func New(config *aws.Config) *Support {
	service := &service.Service{
		Config:       defaults.DefaultConfig.Merge(config),
		ServiceName:  "support",
		APIVersion:   "2013-04-15",
		JSONVersion:  "1.1",
		TargetPrefix: "AWSSupport_20130415",
	}
	service.Initialize()

	// Handlers
	service.Handlers.Sign.PushBack(v4.Sign)
	service.Handlers.Build.PushBack(jsonrpc.Build)
	service.Handlers.Unmarshal.PushBack(jsonrpc.Unmarshal)
	service.Handlers.UnmarshalMeta.PushBack(jsonrpc.UnmarshalMeta)
	service.Handlers.UnmarshalError.PushBack(jsonrpc.UnmarshalError)

	// Run custom service initialization if present
	if initService != nil {
		initService(service)
	}

	return &Support{service}
}

// newRequest creates a new request for a Support operation and runs any
// custom request initialization.
func (c *Support) newRequest(op *service.Operation, params, data interface{}) *service.Request {
	req := service.NewRequest(c.Service, op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
