// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package cloudtrail

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/defaults"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/service"
	"github.com/aws/aws-sdk-go/aws/service/serviceinfo"
	"github.com/aws/aws-sdk-go/internal/protocol/jsonrpc"
	"github.com/aws/aws-sdk-go/internal/signer/v4"
)

// This is the CloudTrail API Reference. It provides descriptions of actions,
// data types, common parameters, and common errors for CloudTrail.
//
// CloudTrail is a web service that records AWS API calls for your AWS account
// and delivers log files to an Amazon S3 bucket. The recorded information includes
// the identity of the user, the start time of the AWS API call, the source
// IP address, the request parameters, and the response elements returned by
// the service.
//
//  As an alternative to using the API, you can use one of the AWS SDKs, which
// consist of libraries and sample code for various programming languages and
// platforms (Java, Ruby, .NET, iOS, Android, etc.). The SDKs provide a convenient
// way to create programmatic access to AWSCloudTrail. For example, the SDKs
// take care of cryptographically signing requests, managing errors, and retrying
// requests automatically. For information about the AWS SDKs, including how
// to download and install them, see the Tools for Amazon Web Services page
// (http://aws.amazon.com/tools/).  See the CloudTrail User Guide for information
// about the data that is included with each AWS API call listed in the log
// files.
type CloudTrail struct {
	*service.Service
}

// Used for custom service initialization logic
var initService func(*service.Service)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// New returns a new CloudTrail client.
func New(config *aws.Config) *CloudTrail {
	service := &service.Service{
		ServiceInfo: serviceinfo.ServiceInfo{
			Config:       defaults.DefaultConfig.Merge(config),
			ServiceName:  "cloudtrail",
			APIVersion:   "2013-11-01",
			JSONVersion:  "1.1",
			TargetPrefix: "com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101",
		},
	}
	service.Initialize()

	// Handlers
	service.Handlers.Sign.PushBack(v4.Sign)
	service.Handlers.Build.PushBack(jsonrpc.Build)
	service.Handlers.Unmarshal.PushBack(jsonrpc.Unmarshal)
	service.Handlers.UnmarshalMeta.PushBack(jsonrpc.UnmarshalMeta)
	service.Handlers.UnmarshalError.PushBack(jsonrpc.UnmarshalError)

	// Run custom service initialization if present
	if initService != nil {
		initService(service)
	}

	return &CloudTrail{service}
}

// newRequest creates a new request for a CloudTrail operation and runs any
// custom request initialization.
func (c *CloudTrail) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
