// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package codedeploy provides a client for AWS CodeDeploy.
package codedeploy

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddTagsToOnPremisesInstances = "AddTagsToOnPremisesInstances"

// AddTagsToOnPremisesInstancesRequest generates a request for the AddTagsToOnPremisesInstances operation.
func (c *CodeDeploy) AddTagsToOnPremisesInstancesRequest(input *AddTagsToOnPremisesInstancesInput) (req *request.Request, output *AddTagsToOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opAddTagsToOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToOnPremisesInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsToOnPremisesInstancesOutput{}
	req.Data = output
	return
}

// Adds tags to on-premises instances.
func (c *CodeDeploy) AddTagsToOnPremisesInstances(input *AddTagsToOnPremisesInstancesInput) (*AddTagsToOnPremisesInstancesOutput, error) {
	req, out := c.AddTagsToOnPremisesInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetApplications = "BatchGetApplications"

// BatchGetApplicationsRequest generates a request for the BatchGetApplications operation.
func (c *CodeDeploy) BatchGetApplicationsRequest(input *BatchGetApplicationsInput) (req *request.Request, output *BatchGetApplicationsOutput) {
	op := &request.Operation{
		Name:       opBatchGetApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetApplicationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetApplicationsOutput{}
	req.Data = output
	return
}

// Gets information about one or more applications.
func (c *CodeDeploy) BatchGetApplications(input *BatchGetApplicationsInput) (*BatchGetApplicationsOutput, error) {
	req, out := c.BatchGetApplicationsRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetDeployments = "BatchGetDeployments"

// BatchGetDeploymentsRequest generates a request for the BatchGetDeployments operation.
func (c *CodeDeploy) BatchGetDeploymentsRequest(input *BatchGetDeploymentsInput) (req *request.Request, output *BatchGetDeploymentsOutput) {
	op := &request.Operation{
		Name:       opBatchGetDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetDeploymentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetDeploymentsOutput{}
	req.Data = output
	return
}

// Gets information about one or more deployments.
func (c *CodeDeploy) BatchGetDeployments(input *BatchGetDeploymentsInput) (*BatchGetDeploymentsOutput, error) {
	req, out := c.BatchGetDeploymentsRequest(input)
	err := req.Send()
	return out, err
}

const opBatchGetOnPremisesInstances = "BatchGetOnPremisesInstances"

// BatchGetOnPremisesInstancesRequest generates a request for the BatchGetOnPremisesInstances operation.
func (c *CodeDeploy) BatchGetOnPremisesInstancesRequest(input *BatchGetOnPremisesInstancesInput) (req *request.Request, output *BatchGetOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opBatchGetOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchGetOnPremisesInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &BatchGetOnPremisesInstancesOutput{}
	req.Data = output
	return
}

// Gets information about one or more on-premises instances.
func (c *CodeDeploy) BatchGetOnPremisesInstances(input *BatchGetOnPremisesInstancesInput) (*BatchGetOnPremisesInstancesOutput, error) {
	req, out := c.BatchGetOnPremisesInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a request for the CreateApplication operation.
func (c *CodeDeploy) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateApplicationOutput{}
	req.Data = output
	return
}

// Creates a new application.
func (c *CodeDeploy) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a request for the CreateDeployment operation.
func (c *CodeDeploy) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDeploymentOutput{}
	req.Data = output
	return
}

// Deploys an application revision through the specified deployment group.
func (c *CodeDeploy) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDeploymentConfig = "CreateDeploymentConfig"

// CreateDeploymentConfigRequest generates a request for the CreateDeploymentConfig operation.
func (c *CodeDeploy) CreateDeploymentConfigRequest(input *CreateDeploymentConfigInput) (req *request.Request, output *CreateDeploymentConfigOutput) {
	op := &request.Operation{
		Name:       opCreateDeploymentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDeploymentConfigOutput{}
	req.Data = output
	return
}

// Creates a new deployment configuration.
func (c *CodeDeploy) CreateDeploymentConfig(input *CreateDeploymentConfigInput) (*CreateDeploymentConfigOutput, error) {
	req, out := c.CreateDeploymentConfigRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDeploymentGroup = "CreateDeploymentGroup"

// CreateDeploymentGroupRequest generates a request for the CreateDeploymentGroup operation.
func (c *CodeDeploy) CreateDeploymentGroupRequest(input *CreateDeploymentGroupInput) (req *request.Request, output *CreateDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opCreateDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDeploymentGroupOutput{}
	req.Data = output
	return
}

// Creates a new deployment group for application revisions to be deployed to.
func (c *CodeDeploy) CreateDeploymentGroup(input *CreateDeploymentGroupInput) (*CreateDeploymentGroupOutput, error) {
	req, out := c.CreateDeploymentGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a request for the DeleteApplication operation.
func (c *CodeDeploy) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteApplicationOutput{}
	req.Data = output
	return
}

// Deletes an application.
func (c *CodeDeploy) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDeploymentConfig = "DeleteDeploymentConfig"

// DeleteDeploymentConfigRequest generates a request for the DeleteDeploymentConfig operation.
func (c *CodeDeploy) DeleteDeploymentConfigRequest(input *DeleteDeploymentConfigInput) (req *request.Request, output *DeleteDeploymentConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteDeploymentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeploymentConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDeploymentConfigOutput{}
	req.Data = output
	return
}

// Deletes a deployment configuration.
//
// A deployment configuration cannot be deleted if it is currently in use.
// Also, predefined configurations cannot be deleted.
func (c *CodeDeploy) DeleteDeploymentConfig(input *DeleteDeploymentConfigInput) (*DeleteDeploymentConfigOutput, error) {
	req, out := c.DeleteDeploymentConfigRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDeploymentGroup = "DeleteDeploymentGroup"

// DeleteDeploymentGroupRequest generates a request for the DeleteDeploymentGroup operation.
func (c *CodeDeploy) DeleteDeploymentGroupRequest(input *DeleteDeploymentGroupInput) (req *request.Request, output *DeleteDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeploymentGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDeploymentGroupOutput{}
	req.Data = output
	return
}

// Deletes a deployment group.
func (c *CodeDeploy) DeleteDeploymentGroup(input *DeleteDeploymentGroupInput) (*DeleteDeploymentGroupOutput, error) {
	req, out := c.DeleteDeploymentGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterOnPremisesInstance = "DeregisterOnPremisesInstance"

// DeregisterOnPremisesInstanceRequest generates a request for the DeregisterOnPremisesInstance operation.
func (c *CodeDeploy) DeregisterOnPremisesInstanceRequest(input *DeregisterOnPremisesInstanceInput) (req *request.Request, output *DeregisterOnPremisesInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterOnPremisesInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterOnPremisesInstanceOutput{}
	req.Data = output
	return
}

// Deregisters an on-premises instance.
func (c *CodeDeploy) DeregisterOnPremisesInstance(input *DeregisterOnPremisesInstanceInput) (*DeregisterOnPremisesInstanceOutput, error) {
	req, out := c.DeregisterOnPremisesInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a request for the GetApplication operation.
func (c *CodeDeploy) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetApplicationOutput{}
	req.Data = output
	return
}

// Gets information about an application.
func (c *CodeDeploy) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opGetApplicationRevision = "GetApplicationRevision"

// GetApplicationRevisionRequest generates a request for the GetApplicationRevision operation.
func (c *CodeDeploy) GetApplicationRevisionRequest(input *GetApplicationRevisionInput) (req *request.Request, output *GetApplicationRevisionOutput) {
	op := &request.Operation{
		Name:       opGetApplicationRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationRevisionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetApplicationRevisionOutput{}
	req.Data = output
	return
}

// Gets information about an application revision.
func (c *CodeDeploy) GetApplicationRevision(input *GetApplicationRevisionInput) (*GetApplicationRevisionOutput, error) {
	req, out := c.GetApplicationRevisionRequest(input)
	err := req.Send()
	return out, err
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a request for the GetDeployment operation.
func (c *CodeDeploy) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeploymentOutput{}
	req.Data = output
	return
}

// Gets information about a deployment.
func (c *CodeDeploy) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opGetDeploymentConfig = "GetDeploymentConfig"

// GetDeploymentConfigRequest generates a request for the GetDeploymentConfig operation.
func (c *CodeDeploy) GetDeploymentConfigRequest(input *GetDeploymentConfigInput) (req *request.Request, output *GetDeploymentConfigOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentConfigInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeploymentConfigOutput{}
	req.Data = output
	return
}

// Gets information about a deployment configuration.
func (c *CodeDeploy) GetDeploymentConfig(input *GetDeploymentConfigInput) (*GetDeploymentConfigOutput, error) {
	req, out := c.GetDeploymentConfigRequest(input)
	err := req.Send()
	return out, err
}

const opGetDeploymentGroup = "GetDeploymentGroup"

// GetDeploymentGroupRequest generates a request for the GetDeploymentGroup operation.
func (c *CodeDeploy) GetDeploymentGroupRequest(input *GetDeploymentGroupInput) (req *request.Request, output *GetDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeploymentGroupOutput{}
	req.Data = output
	return
}

// Gets information about a deployment group.
func (c *CodeDeploy) GetDeploymentGroup(input *GetDeploymentGroupInput) (*GetDeploymentGroupOutput, error) {
	req, out := c.GetDeploymentGroupRequest(input)
	err := req.Send()
	return out, err
}

const opGetDeploymentInstance = "GetDeploymentInstance"

// GetDeploymentInstanceRequest generates a request for the GetDeploymentInstance operation.
func (c *CodeDeploy) GetDeploymentInstanceRequest(input *GetDeploymentInstanceInput) (req *request.Request, output *GetDeploymentInstanceOutput) {
	op := &request.Operation{
		Name:       opGetDeploymentInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeploymentInstanceOutput{}
	req.Data = output
	return
}

// Gets information about an instance as part of a deployment.
func (c *CodeDeploy) GetDeploymentInstance(input *GetDeploymentInstanceInput) (*GetDeploymentInstanceOutput, error) {
	req, out := c.GetDeploymentInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opGetOnPremisesInstance = "GetOnPremisesInstance"

// GetOnPremisesInstanceRequest generates a request for the GetOnPremisesInstance operation.
func (c *CodeDeploy) GetOnPremisesInstanceRequest(input *GetOnPremisesInstanceInput) (req *request.Request, output *GetOnPremisesInstanceOutput) {
	op := &request.Operation{
		Name:       opGetOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOnPremisesInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetOnPremisesInstanceOutput{}
	req.Data = output
	return
}

// Gets information about an on-premises instance.
func (c *CodeDeploy) GetOnPremisesInstance(input *GetOnPremisesInstanceInput) (*GetOnPremisesInstanceOutput, error) {
	req, out := c.GetOnPremisesInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opListApplicationRevisions = "ListApplicationRevisions"

// ListApplicationRevisionsRequest generates a request for the ListApplicationRevisions operation.
func (c *CodeDeploy) ListApplicationRevisionsRequest(input *ListApplicationRevisionsInput) (req *request.Request, output *ListApplicationRevisionsOutput) {
	op := &request.Operation{
		Name:       opListApplicationRevisions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationRevisionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListApplicationRevisionsOutput{}
	req.Data = output
	return
}

// Lists information about revisions for an application.
func (c *CodeDeploy) ListApplicationRevisions(input *ListApplicationRevisionsInput) (*ListApplicationRevisionsOutput, error) {
	req, out := c.ListApplicationRevisionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CodeDeploy) ListApplicationRevisionsPages(input *ListApplicationRevisionsInput, fn func(p *ListApplicationRevisionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListApplicationRevisionsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListApplicationRevisionsOutput), lastPage)
	})
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a request for the ListApplications operation.
func (c *CodeDeploy) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListApplicationsOutput{}
	req.Data = output
	return
}

// Lists the applications registered with the applicable IAM user or AWS account.
func (c *CodeDeploy) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CodeDeploy) ListApplicationsPages(input *ListApplicationsInput, fn func(p *ListApplicationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListApplicationsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListApplicationsOutput), lastPage)
	})
}

const opListDeploymentConfigs = "ListDeploymentConfigs"

// ListDeploymentConfigsRequest generates a request for the ListDeploymentConfigs operation.
func (c *CodeDeploy) ListDeploymentConfigsRequest(input *ListDeploymentConfigsInput) (req *request.Request, output *ListDeploymentConfigsOutput) {
	op := &request.Operation{
		Name:       opListDeploymentConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentConfigsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeploymentConfigsOutput{}
	req.Data = output
	return
}

// Lists the deployment configurations with the applicable IAM user or AWS account.
func (c *CodeDeploy) ListDeploymentConfigs(input *ListDeploymentConfigsInput) (*ListDeploymentConfigsOutput, error) {
	req, out := c.ListDeploymentConfigsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CodeDeploy) ListDeploymentConfigsPages(input *ListDeploymentConfigsInput, fn func(p *ListDeploymentConfigsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDeploymentConfigsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDeploymentConfigsOutput), lastPage)
	})
}

const opListDeploymentGroups = "ListDeploymentGroups"

// ListDeploymentGroupsRequest generates a request for the ListDeploymentGroups operation.
func (c *CodeDeploy) ListDeploymentGroupsRequest(input *ListDeploymentGroupsInput) (req *request.Request, output *ListDeploymentGroupsOutput) {
	op := &request.Operation{
		Name:       opListDeploymentGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeploymentGroupsOutput{}
	req.Data = output
	return
}

// Lists the deployment groups for an application registered with the applicable
// IAM user or AWS account.
func (c *CodeDeploy) ListDeploymentGroups(input *ListDeploymentGroupsInput) (*ListDeploymentGroupsOutput, error) {
	req, out := c.ListDeploymentGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CodeDeploy) ListDeploymentGroupsPages(input *ListDeploymentGroupsInput, fn func(p *ListDeploymentGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDeploymentGroupsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDeploymentGroupsOutput), lastPage)
	})
}

const opListDeploymentInstances = "ListDeploymentInstances"

// ListDeploymentInstancesRequest generates a request for the ListDeploymentInstances operation.
func (c *CodeDeploy) ListDeploymentInstancesRequest(input *ListDeploymentInstancesInput) (req *request.Request, output *ListDeploymentInstancesOutput) {
	op := &request.Operation{
		Name:       opListDeploymentInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeploymentInstancesOutput{}
	req.Data = output
	return
}

// Lists the instances for a deployment associated with the applicable IAM user
// or AWS account.
func (c *CodeDeploy) ListDeploymentInstances(input *ListDeploymentInstancesInput) (*ListDeploymentInstancesOutput, error) {
	req, out := c.ListDeploymentInstancesRequest(input)
	err := req.Send()
	return out, err
}

func (c *CodeDeploy) ListDeploymentInstancesPages(input *ListDeploymentInstancesInput, fn func(p *ListDeploymentInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDeploymentInstancesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDeploymentInstancesOutput), lastPage)
	})
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a request for the ListDeployments operation.
func (c *CodeDeploy) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDeploymentsOutput{}
	req.Data = output
	return
}

// Lists the deployments within a deployment group for an application registered
// with the applicable IAM user or AWS account.
func (c *CodeDeploy) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CodeDeploy) ListDeploymentsPages(input *ListDeploymentsInput, fn func(p *ListDeploymentsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDeploymentsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDeploymentsOutput), lastPage)
	})
}

const opListOnPremisesInstances = "ListOnPremisesInstances"

// ListOnPremisesInstancesRequest generates a request for the ListOnPremisesInstances operation.
func (c *CodeDeploy) ListOnPremisesInstancesRequest(input *ListOnPremisesInstancesInput) (req *request.Request, output *ListOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opListOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListOnPremisesInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListOnPremisesInstancesOutput{}
	req.Data = output
	return
}

// Gets a list of one or more on-premises instance names.
//
// Unless otherwise specified, both registered and deregistered on-premises
// instance names will be listed. To list only registered or deregistered on-premises
// instance names, use the registration status parameter.
func (c *CodeDeploy) ListOnPremisesInstances(input *ListOnPremisesInstancesInput) (*ListOnPremisesInstancesOutput, error) {
	req, out := c.ListOnPremisesInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterApplicationRevision = "RegisterApplicationRevision"

// RegisterApplicationRevisionRequest generates a request for the RegisterApplicationRevision operation.
func (c *CodeDeploy) RegisterApplicationRevisionRequest(input *RegisterApplicationRevisionInput) (req *request.Request, output *RegisterApplicationRevisionOutput) {
	op := &request.Operation{
		Name:       opRegisterApplicationRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterApplicationRevisionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterApplicationRevisionOutput{}
	req.Data = output
	return
}

// Registers with AWS CodeDeploy a revision for the specified application.
func (c *CodeDeploy) RegisterApplicationRevision(input *RegisterApplicationRevisionInput) (*RegisterApplicationRevisionOutput, error) {
	req, out := c.RegisterApplicationRevisionRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterOnPremisesInstance = "RegisterOnPremisesInstance"

// RegisterOnPremisesInstanceRequest generates a request for the RegisterOnPremisesInstance operation.
func (c *CodeDeploy) RegisterOnPremisesInstanceRequest(input *RegisterOnPremisesInstanceInput) (req *request.Request, output *RegisterOnPremisesInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterOnPremisesInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterOnPremisesInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterOnPremisesInstanceOutput{}
	req.Data = output
	return
}

// Registers an on-premises instance.
func (c *CodeDeploy) RegisterOnPremisesInstance(input *RegisterOnPremisesInstanceInput) (*RegisterOnPremisesInstanceOutput, error) {
	req, out := c.RegisterOnPremisesInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTagsFromOnPremisesInstances = "RemoveTagsFromOnPremisesInstances"

// RemoveTagsFromOnPremisesInstancesRequest generates a request for the RemoveTagsFromOnPremisesInstances operation.
func (c *CodeDeploy) RemoveTagsFromOnPremisesInstancesRequest(input *RemoveTagsFromOnPremisesInstancesInput) (req *request.Request, output *RemoveTagsFromOnPremisesInstancesOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromOnPremisesInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromOnPremisesInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsFromOnPremisesInstancesOutput{}
	req.Data = output
	return
}

// Removes one or more tags from one or more on-premises instances.
func (c *CodeDeploy) RemoveTagsFromOnPremisesInstances(input *RemoveTagsFromOnPremisesInstancesInput) (*RemoveTagsFromOnPremisesInstancesOutput, error) {
	req, out := c.RemoveTagsFromOnPremisesInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opStopDeployment = "StopDeployment"

// StopDeploymentRequest generates a request for the StopDeployment operation.
func (c *CodeDeploy) StopDeploymentRequest(input *StopDeploymentInput) (req *request.Request, output *StopDeploymentOutput) {
	op := &request.Operation{
		Name:       opStopDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopDeploymentOutput{}
	req.Data = output
	return
}

// Attempts to stop an ongoing deployment.
func (c *CodeDeploy) StopDeployment(input *StopDeploymentInput) (*StopDeploymentOutput, error) {
	req, out := c.StopDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a request for the UpdateApplication operation.
func (c *CodeDeploy) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateApplicationOutput{}
	req.Data = output
	return
}

// Changes an existing application's name.
func (c *CodeDeploy) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateDeploymentGroup = "UpdateDeploymentGroup"

// UpdateDeploymentGroupRequest generates a request for the UpdateDeploymentGroup operation.
func (c *CodeDeploy) UpdateDeploymentGroupRequest(input *UpdateDeploymentGroupInput) (req *request.Request, output *UpdateDeploymentGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeploymentGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateDeploymentGroupOutput{}
	req.Data = output
	return
}

// Changes information about an existing deployment group.
func (c *CodeDeploy) UpdateDeploymentGroup(input *UpdateDeploymentGroupInput) (*UpdateDeploymentGroupOutput, error) {
	req, out := c.UpdateDeploymentGroupRequest(input)
	err := req.Send()
	return out, err
}

// Represents the input of an adds tags to on-premises instance operation.
type AddTagsToOnPremisesInstancesInput struct {
	// The names of the on-premises instances to add tags to.
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The tag key-value pairs to add to the on-premises instances.
	//
	// Keys and values are both required. Keys cannot be nulls or empty strings.
	// Value-only tags are not allowed.
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`

	metadataAddTagsToOnPremisesInstancesInput `json:"-" xml:"-"`
}

type metadataAddTagsToOnPremisesInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddTagsToOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToOnPremisesInstancesInput) GoString() string {
	return s.String()
}

type AddTagsToOnPremisesInstancesOutput struct {
	metadataAddTagsToOnPremisesInstancesOutput `json:"-" xml:"-"`
}

type metadataAddTagsToOnPremisesInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddTagsToOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Information about an application.
type ApplicationInfo struct {
	// The application ID.
	ApplicationId *string `locationName:"applicationId" type:"string"`

	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// The time that the application was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// True if the user has authenticated with GitHub for the specified application;
	// otherwise, false.
	LinkedToGitHub *bool `locationName:"linkedToGitHub" type:"boolean"`

	metadataApplicationInfo `json:"-" xml:"-"`
}

type metadataApplicationInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ApplicationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationInfo) GoString() string {
	return s.String()
}

// Information about an Auto Scaling group.
type AutoScalingGroup struct {
	// An Auto Scaling lifecycle event hook name.
	Hook *string `locationName:"hook" type:"string"`

	// The Auto Scaling group name.
	Name *string `locationName:"name" type:"string"`

	metadataAutoScalingGroup `json:"-" xml:"-"`
}

type metadataAutoScalingGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingGroup) GoString() string {
	return s.String()
}

// Represents the input of a batch get applications operation.
type BatchGetApplicationsInput struct {
	// A list of application names, with multiple application names separated by
	// spaces.
	ApplicationNames []*string `locationName:"applicationNames" type:"list"`

	metadataBatchGetApplicationsInput `json:"-" xml:"-"`
}

type metadataBatchGetApplicationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BatchGetApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationsInput) GoString() string {
	return s.String()
}

// Represents the output of a batch get applications operation.
type BatchGetApplicationsOutput struct {
	// Information about the applications.
	ApplicationsInfo []*ApplicationInfo `locationName:"applicationsInfo" type:"list"`

	metadataBatchGetApplicationsOutput `json:"-" xml:"-"`
}

type metadataBatchGetApplicationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BatchGetApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetApplicationsOutput) GoString() string {
	return s.String()
}

// Represents the input of a batch get deployments operation.
type BatchGetDeploymentsInput struct {
	// A list of deployment IDs, with multiple deployment IDs separated by spaces.
	DeploymentIds []*string `locationName:"deploymentIds" type:"list"`

	metadataBatchGetDeploymentsInput `json:"-" xml:"-"`
}

type metadataBatchGetDeploymentsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BatchGetDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentsInput) GoString() string {
	return s.String()
}

// Represents the output of a batch get deployments operation.
type BatchGetDeploymentsOutput struct {
	// Information about the deployments.
	DeploymentsInfo []*DeploymentInfo `locationName:"deploymentsInfo" type:"list"`

	metadataBatchGetDeploymentsOutput `json:"-" xml:"-"`
}

type metadataBatchGetDeploymentsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BatchGetDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetDeploymentsOutput) GoString() string {
	return s.String()
}

// Represents the input of a batch get on-premises instances operation.
type BatchGetOnPremisesInstancesInput struct {
	// The names of the on-premises instances to get information about.
	InstanceNames []*string `locationName:"instanceNames" type:"list"`

	metadataBatchGetOnPremisesInstancesInput `json:"-" xml:"-"`
}

type metadataBatchGetOnPremisesInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BatchGetOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// Represents the output of a batch get on-premises instances operation.
type BatchGetOnPremisesInstancesOutput struct {
	// Information about the on-premises instances.
	InstanceInfos []*InstanceInfo `locationName:"instanceInfos" type:"list"`

	metadataBatchGetOnPremisesInstancesOutput `json:"-" xml:"-"`
}

type metadataBatchGetOnPremisesInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BatchGetOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchGetOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Represents the input of a create application operation.
type CreateApplicationInput struct {
	// The name of the application. This name must be unique with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	metadataCreateApplicationInput `json:"-" xml:"-"`
}

type metadataCreateApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Represents the output of a create application operation.
type CreateApplicationOutput struct {
	// A unique application ID.
	ApplicationId *string `locationName:"applicationId" type:"string"`

	metadataCreateApplicationOutput `json:"-" xml:"-"`
}

type metadataCreateApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of a create deployment configuration operation.
type CreateDeploymentConfigInput struct {
	// The name of the deployment configuration to create.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string" required:"true"`

	// The minimum number of healthy instances that should be available at any time
	// during the deployment. There are two parameters expected in the input: type
	// and value.
	//
	// The type parameter takes either of the following values:
	//
	//  HOST_COUNT: The value parameter represents the minimum number of healthy
	// instances, as an absolute value. FLEET_PERCENT: The value parameter represents
	// the minimum number of healthy instances, as a percentage of the total number
	// of instances in the deployment. If you specify FLEET_PERCENT, then at the
	// start of the deployment AWS CodeDeploy converts the percentage to the equivalent
	// number of instances and rounds fractional instances up.  The value parameter
	// takes an integer.
	//
	// For example, to set a minimum of 95% healthy instances, specify a type of
	// FLEET_PERCENT and a value of 95.
	MinimumHealthyHosts *MinimumHealthyHosts `locationName:"minimumHealthyHosts" type:"structure"`

	metadataCreateDeploymentConfigInput `json:"-" xml:"-"`
}

type metadataCreateDeploymentConfigInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentConfigInput) GoString() string {
	return s.String()
}

// Represents the output of a create deployment configuration operation.
type CreateDeploymentConfigOutput struct {
	// A unique deployment configuration ID.
	DeploymentConfigId *string `locationName:"deploymentConfigId" type:"string"`

	metadataCreateDeploymentConfigOutput `json:"-" xml:"-"`
}

type metadataCreateDeploymentConfigOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentConfigOutput) GoString() string {
	return s.String()
}

// Represents the input of a create deployment group operation.
type CreateDeploymentGroupInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// A list of associated Auto Scaling groups.
	AutoScalingGroups []*string `locationName:"autoScalingGroups" type:"list"`

	// If specified, the deployment configuration name must be one of the predefined
	// values, or it can be a custom deployment configuration:
	//
	//  CodeDeployDefault.AllAtOnce deploys an application revision to up to all
	// of the instances at once. The overall deployment succeeds if the application
	// revision deploys to at least one of the instances. The overall deployment
	// fails after the application revision fails to deploy to all of the instances.
	// For example, for 9 instances, deploy to up to all 9 instances at once. The
	// overall deployment succeeds if any of the 9 instances is successfully deployed
	// to, and it fails if all 9 instances fail to be deployed to. CodeDeployDefault.HalfAtATime
	// deploys to up to half of the instances at a time (with fractions rounded
	// down). The overall deployment succeeds if the application revision deploys
	// to at least half of the instances (with fractions rounded up); otherwise,
	// the deployment fails. For example, for 9 instances, deploy to up to 4 instances
	// at a time. The overall deployment succeeds if 5 or more instances are successfully
	// deployed to; otherwise, the deployment fails. Note that the deployment may
	// successfully deploy to some instances, even if the overall deployment fails.
	// CodeDeployDefault.OneAtATime deploys the application revision to only one
	// of the instances at a time. The overall deployment succeeds if the application
	// revision deploys to all of the instances. The overall deployment fails after
	// the application revision first fails to deploy to any one instances. For
	// example, for 9 instances, deploy to one instance at a time. The overall deployment
	// succeeds if all 9 instances are successfully deployed to, and it fails if
	// any of one of the 9 instances fail to be deployed to. Note that the deployment
	// may successfully deploy to some instances, even if the overall deployment
	// fails. This is the default deployment configuration if a configuration isn't
	// specified for either the deployment or the deployment group.  To create a
	// custom deployment configuration, call the create deployment configuration
	// operation.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The name of an existing deployment group for the specified application.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string" required:"true"`

	// The Amazon EC2 tags to filter on.
	Ec2TagFilters []*EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// The on-premises instance tags to filter on.
	OnPremisesInstanceTagFilters []*TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// A service role ARN that allows AWS CodeDeploy to act on the user's behalf
	// when interacting with AWS services.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string" required:"true"`

	metadataCreateDeploymentGroupInput `json:"-" xml:"-"`
}

type metadataCreateDeploymentGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentGroupInput) GoString() string {
	return s.String()
}

// Represents the output of a create deployment group operation.
type CreateDeploymentGroupOutput struct {
	// A unique deployment group ID.
	DeploymentGroupId *string `locationName:"deploymentGroupId" type:"string"`

	metadataCreateDeploymentGroupOutput `json:"-" xml:"-"`
}

type metadataCreateDeploymentGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a create deployment operation.
type CreateDeploymentInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The name of an existing deployment configuration associated with the applicable
	// IAM user or AWS account.
	//
	// If not specified, the value configured in the deployment group will be used
	// as the default. If the deployment group does not have a deployment configuration
	// associated with it, then CodeDeployDefault.OneAtATime will be used by default.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The deployment group's name.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// A comment about the deployment.
	Description *string `locationName:"description" type:"string"`

	// If set to true, then if the deployment causes the ApplicationStop deployment
	// lifecycle event to fail to a specific instance, the deployment will not be
	// considered to have failed to that instance at that point and will continue
	// on to the BeforeInstall deployment lifecycle event.
	//
	// If set to false or not specified, then if the deployment causes the ApplicationStop
	// deployment lifecycle event to fail to a specific instance, the deployment
	// will stop to that instance, and the deployment to that instance will be considered
	// to have failed.
	IgnoreApplicationStopFailures *bool `locationName:"ignoreApplicationStopFailures" type:"boolean"`

	// The type of revision to deploy, along with information about the revision's
	// location.
	Revision *RevisionLocation `locationName:"revision" type:"structure"`

	metadataCreateDeploymentInput `json:"-" xml:"-"`
}

type metadataCreateDeploymentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Represents the output of a create deployment operation.
type CreateDeploymentOutput struct {
	// A unique deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	metadataCreateDeploymentOutput `json:"-" xml:"-"`
}

type metadataCreateDeploymentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// Represents the input of a delete application operation.
type DeleteApplicationInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	metadataDeleteApplicationInput `json:"-" xml:"-"`
}

type metadataDeleteApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

type DeleteApplicationOutput struct {
	metadataDeleteApplicationOutput `json:"-" xml:"-"`
}

type metadataDeleteApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of a delete deployment configuration operation.
type DeleteDeploymentConfigInput struct {
	// The name of an existing deployment configuration associated with the applicable
	// IAM user or AWS account.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string" required:"true"`

	metadataDeleteDeploymentConfigInput `json:"-" xml:"-"`
}

type metadataDeleteDeploymentConfigInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentConfigInput) GoString() string {
	return s.String()
}

type DeleteDeploymentConfigOutput struct {
	metadataDeleteDeploymentConfigOutput `json:"-" xml:"-"`
}

type metadataDeleteDeploymentConfigOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentConfigOutput) GoString() string {
	return s.String()
}

// Represents the input of a delete deployment group operation.
type DeleteDeploymentGroupInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The name of an existing deployment group for the specified application.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string" required:"true"`

	metadataDeleteDeploymentGroupInput `json:"-" xml:"-"`
}

type metadataDeleteDeploymentGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentGroupInput) GoString() string {
	return s.String()
}

// Represents the output of a delete deployment group operation.
type DeleteDeploymentGroupOutput struct {
	// If the output contains no data, and the corresponding deployment group contained
	// at least one Auto Scaling group, AWS CodeDeploy successfully removed all
	// corresponding Auto Scaling lifecycle event hooks from the Amazon EC2 instances
	// in the Auto Scaling. If the output does contain data, AWS CodeDeploy could
	// not remove some Auto Scaling lifecycle event hooks from the Amazon EC2 instances
	// in the Auto Scaling group.
	HooksNotCleanedUp []*AutoScalingGroup `locationName:"hooksNotCleanedUp" type:"list"`

	metadataDeleteDeploymentGroupOutput `json:"-" xml:"-"`
}

type metadataDeleteDeploymentGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDeploymentGroupOutput) GoString() string {
	return s.String()
}

// Information about a deployment configuration.
type DeploymentConfigInfo struct {
	// The time that the deployment configuration was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment configuration ID.
	DeploymentConfigId *string `locationName:"deploymentConfigId" type:"string"`

	// The deployment configuration name.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// Information about the number or percentage of minimum healthy instances.
	MinimumHealthyHosts *MinimumHealthyHosts `locationName:"minimumHealthyHosts" type:"structure"`

	metadataDeploymentConfigInfo `json:"-" xml:"-"`
}

type metadataDeploymentConfigInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeploymentConfigInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentConfigInfo) GoString() string {
	return s.String()
}

// Information about a deployment group.
type DeploymentGroupInfo struct {
	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A list of associated Auto Scaling groups.
	AutoScalingGroups []*AutoScalingGroup `locationName:"autoScalingGroups" type:"list"`

	// The deployment configuration name.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The deployment group ID.
	DeploymentGroupId *string `locationName:"deploymentGroupId" type:"string"`

	// The deployment group name.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// The Amazon EC2 tags to filter on.
	Ec2TagFilters []*EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// The on-premises instance tags to filter on.
	OnPremisesInstanceTagFilters []*TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// A service role ARN.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// Information about the deployment group's target revision, including the revision's
	// type and its location.
	TargetRevision *RevisionLocation `locationName:"targetRevision" type:"structure"`

	metadataDeploymentGroupInfo `json:"-" xml:"-"`
}

type metadataDeploymentGroupInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeploymentGroupInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentGroupInfo) GoString() string {
	return s.String()
}

// Information about a deployment.
type DeploymentInfo struct {
	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A timestamp indicating when the deployment was completed.
	CompleteTime *time.Time `locationName:"completeTime" type:"timestamp" timestampFormat:"unix"`

	// A timestamp indicating when the deployment was created.
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"unix"`

	// How the deployment was created:
	//
	//  user: A user created the deployment. autoscaling: Auto Scaling created
	// the deployment.
	Creator *string `locationName:"creator" type:"string" enum:"DeploymentCreator"`

	// The deployment configuration name.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The deployment group name.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// The deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A summary of the deployment status of the instances in the deployment.
	DeploymentOverview *DeploymentOverview `locationName:"deploymentOverview" type:"structure"`

	// A comment about the deployment.
	Description *string `locationName:"description" type:"string"`

	// Information about any error associated with this deployment.
	ErrorInformation *ErrorInformation `locationName:"errorInformation" type:"structure"`

	// If true, then if the deployment causes the ApplicationStop deployment lifecycle
	// event to fail to a specific instance, the deployment will not be considered
	// to have failed to that instance at that point and will continue on to the
	// BeforeInstall deployment lifecycle event.
	//
	// If false or not specified, then if the deployment causes the ApplicationStop
	// deployment lifecycle event to fail to a specific instance, the deployment
	// will stop to that instance, and the deployment to that instance will be considered
	// to have failed.
	IgnoreApplicationStopFailures *bool `locationName:"ignoreApplicationStopFailures" type:"boolean"`

	// Information about the location of application artifacts that are stored and
	// the service to retrieve them from.
	Revision *RevisionLocation `locationName:"revision" type:"structure"`

	// A timestamp indicating when the deployment began deploying to the deployment
	// group.
	//
	// Note that in some cases, the reported value of the start time may be later
	// than the complete time. This is due to differences in the clock settings
	// of various back-end servers that participate in the overall deployment process.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// The current state of the deployment as a whole.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`

	metadataDeploymentInfo `json:"-" xml:"-"`
}

type metadataDeploymentInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeploymentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentInfo) GoString() string {
	return s.String()
}

// Information about the deployment status of the instances in the deployment.
type DeploymentOverview struct {
	// The number of instances that have failed in the deployment.
	Failed *int64 `type:"long"`

	// The number of instances that are in progress in the deployment.
	InProgress *int64 `type:"long"`

	// The number of instances that are pending in the deployment.
	Pending *int64 `type:"long"`

	// The number of instances that have been skipped in the deployment.
	Skipped *int64 `type:"long"`

	// The number of instances that have succeeded in the deployment.
	Succeeded *int64 `type:"long"`

	metadataDeploymentOverview `json:"-" xml:"-"`
}

type metadataDeploymentOverview struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeploymentOverview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentOverview) GoString() string {
	return s.String()
}

// Represents the input of a deregister on-premises instance operation.
type DeregisterOnPremisesInstanceInput struct {
	// The name of the on-premises instance to deregister.
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	metadataDeregisterOnPremisesInstanceInput `json:"-" xml:"-"`
}

type metadataDeregisterOnPremisesInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterOnPremisesInstanceInput) GoString() string {
	return s.String()
}

type DeregisterOnPremisesInstanceOutput struct {
	metadataDeregisterOnPremisesInstanceOutput `json:"-" xml:"-"`
}

type metadataDeregisterOnPremisesInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterOnPremisesInstanceOutput) GoString() string {
	return s.String()
}

// Diagnostic information about executable scripts that are part of a deployment.
type Diagnostics struct {
	// The associated error code:
	//
	//  Success: The specified script ran. ScriptMissing: The specified script
	// was not found in the specified location. ScriptNotExecutable: The specified
	// script is not a recognized executable file type. ScriptTimedOut: The specified
	// script did not finish running in the specified time period. ScriptFailed:
	// The specified script failed to run as expected. UnknownError: The specified
	// script did not run for an unknown reason.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"LifecycleErrorCode"`

	// The last portion of the associated diagnostic log.
	LogTail *string `locationName:"logTail" type:"string"`

	// The message associated with the error.
	Message *string `locationName:"message" type:"string"`

	// The name of the script.
	ScriptName *string `locationName:"scriptName" type:"string"`

	metadataDiagnostics `json:"-" xml:"-"`
}

type metadataDiagnostics struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Diagnostics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Diagnostics) GoString() string {
	return s.String()
}

// Information about a tag filter.
type EC2TagFilter struct {
	// The tag filter key.
	Key *string `type:"string"`

	// The tag filter type:
	//
	//  KEY_ONLY: Key only. VALUE_ONLY: Value only. KEY_AND_VALUE: Key and value.
	Type *string `type:"string" enum:"EC2TagFilterType"`

	// The tag filter value.
	Value *string `type:"string"`

	metadataEC2TagFilter `json:"-" xml:"-"`
}

type metadataEC2TagFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EC2TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EC2TagFilter) GoString() string {
	return s.String()
}

// Information about a deployment error.
type ErrorInformation struct {
	// The error code:
	//
	//  APPLICATION_MISSING: The application was missing. Note that this error
	// code will most likely be raised if the application is deleted after the deployment
	// is created but before it starts. DEPLOYMENT_GROUP_MISSING: The deployment
	// group was missing. Note that this error code will most likely be raised if
	// the deployment group is deleted after the deployment is created but before
	// it starts. HEALTH_CONSTRAINTS: The deployment failed on too many instances
	// to be able to successfully deploy within the specified instance health constraints.
	// HEALTH_CONSTRAINTS_INVALID: The revision can never successfully deploy within
	// the instance health constraints as specified. IAM_ROLE_MISSING: The service
	// role cannot be accessed. IAM_ROLE_PERMISSIONS: The service role does not
	// have the correct permissions. INTERNAL_ERROR: There was an internal error.
	// NO_EC2_SUBSCRIPTION: The calling account is not subscribed to the Amazon
	// EC2 service. NO_INSTANCES: No instances were specified, or no instances can
	// be found. OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
	// THROTTLED: The operation was throttled because the calling account exceeded
	// the throttling limits of one or more AWS services. TIMEOUT: The deployment
	// has timed out. REVISION_MISSING: The revision ID was missing. Note that this
	// error code will most likely be raised if the revision is deleted after the
	// deployment is created but before it starts.
	Code *string `locationName:"code" type:"string" enum:"ErrorCode"`

	// An accompanying error message.
	Message *string `locationName:"message" type:"string"`

	metadataErrorInformation `json:"-" xml:"-"`
}

type metadataErrorInformation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ErrorInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorInformation) GoString() string {
	return s.String()
}

// Information about an application revision.
type GenericRevisionInfo struct {
	// A list of deployment groups that use this revision.
	DeploymentGroups []*string `locationName:"deploymentGroups" type:"list"`

	// A comment about the revision.
	Description *string `locationName:"description" type:"string"`

	// When the revision was first used by AWS CodeDeploy.
	FirstUsedTime *time.Time `locationName:"firstUsedTime" type:"timestamp" timestampFormat:"unix"`

	// When the revision was last used by AWS CodeDeploy.
	LastUsedTime *time.Time `locationName:"lastUsedTime" type:"timestamp" timestampFormat:"unix"`

	// When the revision was registered with AWS CodeDeploy.
	RegisterTime *time.Time `locationName:"registerTime" type:"timestamp" timestampFormat:"unix"`

	metadataGenericRevisionInfo `json:"-" xml:"-"`
}

type metadataGenericRevisionInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GenericRevisionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenericRevisionInfo) GoString() string {
	return s.String()
}

// Represents the input of a get application operation.
type GetApplicationInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	metadataGetApplicationInput `json:"-" xml:"-"`
}

type metadataGetApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Represents the output of a get application operation.
type GetApplicationOutput struct {
	// Information about the application.
	Application *ApplicationInfo `locationName:"application" type:"structure"`

	metadataGetApplicationOutput `json:"-" xml:"-"`
}

type metadataGetApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of a get application revision operation.
type GetApplicationRevisionInput struct {
	// The name of the application that corresponds to the revision.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Information about the application revision to get, including the revision's
	// type and its location.
	Revision *RevisionLocation `locationName:"revision" type:"structure" required:"true"`

	metadataGetApplicationRevisionInput `json:"-" xml:"-"`
}

type metadataGetApplicationRevisionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetApplicationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationRevisionInput) GoString() string {
	return s.String()
}

// Represents the output of a get application revision operation.
type GetApplicationRevisionOutput struct {
	// The name of the application that corresponds to the revision.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// Additional information about the revision, including the revision's type
	// and its location.
	Revision *RevisionLocation `locationName:"revision" type:"structure"`

	// General information about the revision.
	RevisionInfo *GenericRevisionInfo `locationName:"revisionInfo" type:"structure"`

	metadataGetApplicationRevisionOutput `json:"-" xml:"-"`
}

type metadataGetApplicationRevisionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetApplicationRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetApplicationRevisionOutput) GoString() string {
	return s.String()
}

// Represents the input of a get deployment configuration operation.
type GetDeploymentConfigInput struct {
	// The name of an existing deployment configuration associated with the applicable
	// IAM user or AWS account.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string" required:"true"`

	metadataGetDeploymentConfigInput `json:"-" xml:"-"`
}

type metadataGetDeploymentConfigInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeploymentConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentConfigInput) GoString() string {
	return s.String()
}

// Represents the output of a get deployment configuration operation.
type GetDeploymentConfigOutput struct {
	// Information about the deployment configuration.
	DeploymentConfigInfo *DeploymentConfigInfo `locationName:"deploymentConfigInfo" type:"structure"`

	metadataGetDeploymentConfigOutput `json:"-" xml:"-"`
}

type metadataGetDeploymentConfigOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeploymentConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentConfigOutput) GoString() string {
	return s.String()
}

// Represents the input of a get deployment group operation.
type GetDeploymentGroupInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The name of an existing deployment group for the specified application.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string" required:"true"`

	metadataGetDeploymentGroupInput `json:"-" xml:"-"`
}

type metadataGetDeploymentGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentGroupInput) GoString() string {
	return s.String()
}

// Represents the output of a get deployment group operation.
type GetDeploymentGroupOutput struct {
	// Information about the deployment group.
	DeploymentGroupInfo *DeploymentGroupInfo `locationName:"deploymentGroupInfo" type:"structure"`

	metadataGetDeploymentGroupOutput `json:"-" xml:"-"`
}

type metadataGetDeploymentGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentGroupOutput) GoString() string {
	return s.String()
}

// Represents the input of a get deployment operation.
type GetDeploymentInput struct {
	// An existing deployment ID associated with the applicable IAM user or AWS
	// account.
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	metadataGetDeploymentInput `json:"-" xml:"-"`
}

type metadataGetDeploymentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Represents the input of a get deployment instance operation.
type GetDeploymentInstanceInput struct {
	// The unique ID of a deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The unique ID of an instance in the deployment's deployment group.
	InstanceId *string `locationName:"instanceId" type:"string" required:"true"`

	metadataGetDeploymentInstanceInput `json:"-" xml:"-"`
}

type metadataGetDeploymentInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeploymentInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInstanceInput) GoString() string {
	return s.String()
}

// Represents the output of a get deployment instance operation.
type GetDeploymentInstanceOutput struct {
	// Information about the instance.
	InstanceSummary *InstanceSummary `locationName:"instanceSummary" type:"structure"`

	metadataGetDeploymentInstanceOutput `json:"-" xml:"-"`
}

type metadataGetDeploymentInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeploymentInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentInstanceOutput) GoString() string {
	return s.String()
}

// Represents the output of a get deployment operation.
type GetDeploymentOutput struct {
	// Information about the deployment.
	DeploymentInfo *DeploymentInfo `locationName:"deploymentInfo" type:"structure"`

	metadataGetDeploymentOutput `json:"-" xml:"-"`
}

type metadataGetDeploymentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// Represents the input of a get on-premises instance operation.
type GetOnPremisesInstanceInput struct {
	// The name of the on-premises instance to get information about
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	metadataGetOnPremisesInstanceInput `json:"-" xml:"-"`
}

type metadataGetOnPremisesInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOnPremisesInstanceInput) GoString() string {
	return s.String()
}

// Represents the output of a get on-premises instance operation.
type GetOnPremisesInstanceOutput struct {
	// Information about the on-premises instance.
	InstanceInfo *InstanceInfo `locationName:"instanceInfo" type:"structure"`

	metadataGetOnPremisesInstanceOutput `json:"-" xml:"-"`
}

type metadataGetOnPremisesInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOnPremisesInstanceOutput) GoString() string {
	return s.String()
}

// Information about the location of application artifacts that are stored in
// GitHub.
type GitHubLocation struct {
	// The SHA1 commit ID of the GitHub commit that references the that represents
	// the bundled artifacts for the application revision.
	CommitId *string `locationName:"commitId" type:"string"`

	// The GitHub account and repository pair that stores a reference to the commit
	// that represents the bundled artifacts for the application revision.
	//
	// Specified as account/repository.
	Repository *string `locationName:"repository" type:"string"`

	metadataGitHubLocation `json:"-" xml:"-"`
}

type metadataGitHubLocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GitHubLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GitHubLocation) GoString() string {
	return s.String()
}

// Information about an on-premises instance.
type InstanceInfo struct {
	// If the on-premises instance was deregistered, the time that the on-premises
	// instance was deregistered.
	DeregisterTime *time.Time `locationName:"deregisterTime" type:"timestamp" timestampFormat:"unix"`

	// The IAM user ARN associated with the on-premises instance.
	IamUserArn *string `locationName:"iamUserArn" type:"string"`

	// The ARN of the on-premises instance.
	InstanceArn *string `locationName:"instanceArn" type:"string"`

	// The name of the on-premises instance.
	InstanceName *string `locationName:"instanceName" type:"string"`

	// The time that the on-premises instance was registered.
	RegisterTime *time.Time `locationName:"registerTime" type:"timestamp" timestampFormat:"unix"`

	// The tags that are currently associated with the on-premises instance.
	Tags []*Tag `locationName:"tags" type:"list"`

	metadataInstanceInfo `json:"-" xml:"-"`
}

type metadataInstanceInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInfo) GoString() string {
	return s.String()
}

// Information about an instance in a deployment.
type InstanceSummary struct {
	// The deployment ID.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The instance ID.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// A timestamp indicating when the instance information was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp" timestampFormat:"unix"`

	// A list of lifecycle events for this instance.
	LifecycleEvents []*LifecycleEvent `locationName:"lifecycleEvents" type:"list"`

	// The deployment status for this instance:
	//
	//  Pending: The deployment is pending for this instance. In Progress: The
	// deployment is in progress for this instance. Succeeded: The deployment has
	// succeeded for this instance. Failed: The deployment has failed for this instance.
	// Skipped: The deployment has been skipped for this instance. Unknown: The
	// deployment status is unknown for this instance.
	Status *string `locationName:"status" type:"string" enum:"InstanceStatus"`

	metadataInstanceSummary `json:"-" xml:"-"`
}

type metadataInstanceSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceSummary) GoString() string {
	return s.String()
}

// Information about a deployment lifecycle event.
type LifecycleEvent struct {
	// Diagnostic information about the deployment lifecycle event.
	Diagnostics *Diagnostics `locationName:"diagnostics" type:"structure"`

	// A timestamp indicating when the deployment lifecycle event ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment lifecycle event name, such as ApplicationStop, BeforeInstall,
	// AfterInstall, ApplicationStart, or ValidateService.
	LifecycleEventName *string `locationName:"lifecycleEventName" type:"string"`

	// A timestamp indicating when the deployment lifecycle event started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// The deployment lifecycle event status:
	//
	//  Pending: The deployment lifecycle event is pending. InProgress: The deployment
	// lifecycle event is in progress. Succeeded: The deployment lifecycle event
	// has succeeded. Failed: The deployment lifecycle event has failed. Skipped:
	// The deployment lifecycle event has been skipped. Unknown: The deployment
	// lifecycle event is unknown.
	Status *string `locationName:"status" type:"string" enum:"LifecycleEventStatus"`

	metadataLifecycleEvent `json:"-" xml:"-"`
}

type metadataLifecycleEvent struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LifecycleEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleEvent) GoString() string {
	return s.String()
}

// Represents the input of a list application revisions operation.
type ListApplicationRevisionsInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Whether to list revisions based on whether the revision is the target revision
	// of an deployment group:
	//
	//  include: List revisions that are target revisions of a deployment group.
	// exclude: Do not list revisions that are target revisions of a deployment
	// group. ignore: List all revisions, regardless of whether they are target
	// revisions of a deployment group.
	Deployed *string `locationName:"deployed" type:"string" enum:"ListStateFilterAction"`

	// An identifier that was returned from the previous list application revisions
	// call, which can be used to return the next set of applications in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A specific Amazon S3 bucket name to limit the search for revisions.
	//
	// If set to null, then all of the user's buckets will be searched.
	S3Bucket *string `locationName:"s3Bucket" type:"string"`

	// A specific key prefix for the set of Amazon S3 objects to limit the search
	// for revisions.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" type:"string"`

	// The column name to sort the list results by:
	//
	//  registerTime: Sort the list results by when the revisions were registered
	// with AWS CodeDeploy. firstUsedTime: Sort the list results by when the revisions
	// were first used by in a deployment. lastUsedTime: Sort the list results by
	// when the revisions were last used in a deployment.  If not specified or set
	// to null, the results will be returned in an arbitrary order.
	SortBy *string `locationName:"sortBy" type:"string" enum:"ApplicationRevisionSortBy"`

	// The order to sort the list results by:
	//
	//  ascending: Sort the list of results in ascending order. descending: Sort
	// the list of results in descending order.  If not specified, the results will
	// be sorted in ascending order.
	//
	// If set to null, the results will be sorted in an arbitrary order.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`

	metadataListApplicationRevisionsInput `json:"-" xml:"-"`
}

type metadataListApplicationRevisionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListApplicationRevisionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationRevisionsInput) GoString() string {
	return s.String()
}

// Represents the output of a list application revisions operation.
type ListApplicationRevisionsOutput struct {
	// If the amount of information that is returned is significantly large, an
	// identifier will also be returned, which can be used in a subsequent list
	// application revisions call to return the next set of application revisions
	// in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of revision locations that contain the matching revisions.
	Revisions []*RevisionLocation `locationName:"revisions" type:"list"`

	metadataListApplicationRevisionsOutput `json:"-" xml:"-"`
}

type metadataListApplicationRevisionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListApplicationRevisionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationRevisionsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list applications operation.
type ListApplicationsInput struct {
	// An identifier that was returned from the previous list applications call,
	// which can be used to return the next set of applications in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListApplicationsInput `json:"-" xml:"-"`
}

type metadataListApplicationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Represents the output of a list applications operation.
type ListApplicationsOutput struct {
	// A list of application names.
	Applications []*string `locationName:"applications" type:"list"`

	// If the amount of information that is returned is significantly large, an
	// identifier will also be returned, which can be used in a subsequent list
	// applications call to return the next set of applications in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListApplicationsOutput `json:"-" xml:"-"`
}

type metadataListApplicationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list deployment configurations operation.
type ListDeploymentConfigsInput struct {
	// An identifier that was returned from the previous list deployment configurations
	// call, which can be used to return the next set of deployment configurations
	// in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListDeploymentConfigsInput `json:"-" xml:"-"`
}

type metadataListDeploymentConfigsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDeploymentConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentConfigsInput) GoString() string {
	return s.String()
}

// Represents the output of a list deployment configurations operation.
type ListDeploymentConfigsOutput struct {
	// A list of deployment configurations, including the built-in configurations
	// such as CodeDeployDefault.OneAtATime.
	DeploymentConfigsList []*string `locationName:"deploymentConfigsList" type:"list"`

	// If the amount of information that is returned is significantly large, an
	// identifier will also be returned, which can be used in a subsequent list
	// deployment configurations call to return the next set of deployment configurations
	// in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListDeploymentConfigsOutput `json:"-" xml:"-"`
}

type metadataListDeploymentConfigsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDeploymentConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentConfigsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list deployment groups operation.
type ListDeploymentGroupsInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// An identifier that was returned from the previous list deployment groups
	// call, which can be used to return the next set of deployment groups in the
	// list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListDeploymentGroupsInput `json:"-" xml:"-"`
}

type metadataListDeploymentGroupsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDeploymentGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentGroupsInput) GoString() string {
	return s.String()
}

// Represents the output of a list deployment groups operation.
type ListDeploymentGroupsOutput struct {
	// The application name.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A list of corresponding deployment group names.
	DeploymentGroups []*string `locationName:"deploymentGroups" type:"list"`

	// If the amount of information that is returned is significantly large, an
	// identifier will also be returned, which can be used in a subsequent list
	// deployment groups call to return the next set of deployment groups in the
	// list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListDeploymentGroupsOutput `json:"-" xml:"-"`
}

type metadataListDeploymentGroupsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDeploymentGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentGroupsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list deployment instances operation.
type ListDeploymentInstancesInput struct {
	// The unique ID of a deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// A subset of instances to list, by status:
	//
	//  Pending: Include in the resulting list those instances with pending deployments.
	// InProgress: Include in the resulting list those instances with in-progress
	// deployments. Succeeded: Include in the resulting list those instances with
	// succeeded deployments. Failed: Include in the resulting list those instances
	// with failed deployments. Skipped: Include in the resulting list those instances
	// with skipped deployments. Unknown: Include in the resulting list those instances
	// with deployments in an unknown state.
	InstanceStatusFilter []*string `locationName:"instanceStatusFilter" type:"list"`

	// An identifier that was returned from the previous list deployment instances
	// call, which can be used to return the next set of deployment instances in
	// the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListDeploymentInstancesInput `json:"-" xml:"-"`
}

type metadataListDeploymentInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDeploymentInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentInstancesInput) GoString() string {
	return s.String()
}

// Represents the output of a list deployment instances operation.
type ListDeploymentInstancesOutput struct {
	// A list of instances IDs.
	InstancesList []*string `locationName:"instancesList" type:"list"`

	// If the amount of information that is returned is significantly large, an
	// identifier will also be returned, which can be used in a subsequent list
	// deployment instances call to return the next set of deployment instances
	// in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListDeploymentInstancesOutput `json:"-" xml:"-"`
}

type metadataListDeploymentInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDeploymentInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentInstancesOutput) GoString() string {
	return s.String()
}

// Represents the input of a list deployments operation.
type ListDeploymentsInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// A deployment creation start- and end-time range for returning a subset of
	// the list of deployments.
	CreateTimeRange *TimeRange `locationName:"createTimeRange" type:"structure"`

	// The name of an existing deployment group for the specified application.
	DeploymentGroupName *string `locationName:"deploymentGroupName" min:"1" type:"string"`

	// A subset of deployments to list, by status:
	//
	//  Created: Include in the resulting list created deployments. Queued: Include
	// in the resulting list queued deployments. In Progress: Include in the resulting
	// list in-progress deployments. Succeeded: Include in the resulting list succeeded
	// deployments. Failed: Include in the resulting list failed deployments. Aborted:
	// Include in the resulting list aborted deployments.
	IncludeOnlyStatuses []*string `locationName:"includeOnlyStatuses" type:"list"`

	// An identifier that was returned from the previous list deployments call,
	// which can be used to return the next set of deployments in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListDeploymentsInput `json:"-" xml:"-"`
}

type metadataListDeploymentsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Represents the output of a list deployments operation.
type ListDeploymentsOutput struct {
	// A list of deployment IDs.
	Deployments []*string `locationName:"deployments" type:"list"`

	// If the amount of information that is returned is significantly large, an
	// identifier will also be returned, which can be used in a subsequent list
	// deployments call to return the next set of deployments in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListDeploymentsOutput `json:"-" xml:"-"`
}

type metadataListDeploymentsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// Represents the input of a list on-premises instances operation.
//
// .
type ListOnPremisesInstancesInput struct {
	// An identifier that was returned from the previous list on-premises instances
	// call, which can be used to return the next set of on-premises instances in
	// the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The on-premises instances registration status:
	//
	//  Deregistered: Include in the resulting list deregistered on-premises instances.
	// Registered: Include in the resulting list registered on-premises instances.
	RegistrationStatus *string `locationName:"registrationStatus" type:"string" enum:"RegistrationStatus"`

	// The on-premises instance tags that will be used to restrict the corresponding
	// on-premises instance names that are returned.
	TagFilters []*TagFilter `locationName:"tagFilters" type:"list"`

	metadataListOnPremisesInstancesInput `json:"-" xml:"-"`
}

type metadataListOnPremisesInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOnPremisesInstancesInput) GoString() string {
	return s.String()
}

// Represents the output of list on-premises instances operation.
type ListOnPremisesInstancesOutput struct {
	// The list of matching on-premises instance names.
	InstanceNames []*string `locationName:"instanceNames" type:"list"`

	// If the amount of information that is returned is significantly large, an
	// identifier will also be returned, which can be used in a subsequent list
	// on-premises instances call to return the next set of on-premises instances
	// in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListOnPremisesInstancesOutput `json:"-" xml:"-"`
}

type metadataListOnPremisesInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Information about minimum healthy instances.
type MinimumHealthyHosts struct {
	// The minimum healthy instances type:
	//
	//  HOST_COUNT: The minimum number of healthy instances, as an absolute value.
	// FLEET_PERCENT: The minimum number of healthy instances, as a percentage of
	// the total number of instances in the deployment.  For example, for 9 instances,
	// if a HOST_COUNT of 6 is specified, deploy to up to 3 instances at a time.
	// The deployment succeeds if 6 or more instances are successfully deployed
	// to; otherwise, the deployment fails. If a FLEET_PERCENT of 40 is specified,
	// deploy to up to 5 instances at a time. The deployment succeeds if 4 or more
	// instances are successfully deployed to; otherwise, the deployment fails.
	//
	// In a call to the get deployment configuration operation, CodeDeployDefault.OneAtATime
	// will return a minimum healthy instances type of MOST_CONCURRENCY and a value
	// of 1. This means a deployment to only one instances at a time. (You cannot
	// set the type to MOST_CONCURRENCY, only to HOST_COUNT or FLEET_PERCENT.)
	Type *string `locationName:"type" type:"string" enum:"MinimumHealthyHostsType"`

	// The minimum healthy instances value.
	Value *int64 `locationName:"value" type:"integer"`

	metadataMinimumHealthyHosts `json:"-" xml:"-"`
}

type metadataMinimumHealthyHosts struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s MinimumHealthyHosts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MinimumHealthyHosts) GoString() string {
	return s.String()
}

// Represents the input of a register application revision operation.
type RegisterApplicationRevisionInput struct {
	// The name of an existing AWS CodeDeploy application associated with the applicable
	// IAM user or AWS account.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// A comment about the revision.
	Description *string `locationName:"description" type:"string"`

	// Information about the application revision to register, including the revision's
	// type and its location.
	Revision *RevisionLocation `locationName:"revision" type:"structure" required:"true"`

	metadataRegisterApplicationRevisionInput `json:"-" xml:"-"`
}

type metadataRegisterApplicationRevisionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterApplicationRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterApplicationRevisionInput) GoString() string {
	return s.String()
}

type RegisterApplicationRevisionOutput struct {
	metadataRegisterApplicationRevisionOutput `json:"-" xml:"-"`
}

type metadataRegisterApplicationRevisionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterApplicationRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterApplicationRevisionOutput) GoString() string {
	return s.String()
}

// Represents the input of register on-premises instance operation.
type RegisterOnPremisesInstanceInput struct {
	// The ARN of the IAM user to associate with the on-premises instance.
	IamUserArn *string `locationName:"iamUserArn" type:"string" required:"true"`

	// The name of the on-premises instance to register.
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	metadataRegisterOnPremisesInstanceInput `json:"-" xml:"-"`
}

type metadataRegisterOnPremisesInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterOnPremisesInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterOnPremisesInstanceInput) GoString() string {
	return s.String()
}

type RegisterOnPremisesInstanceOutput struct {
	metadataRegisterOnPremisesInstanceOutput `json:"-" xml:"-"`
}

type metadataRegisterOnPremisesInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterOnPremisesInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterOnPremisesInstanceOutput) GoString() string {
	return s.String()
}

// Represents the input of a remove tags from on-premises instances operation.
type RemoveTagsFromOnPremisesInstancesInput struct {
	// The names of the on-premises instances to remove tags from.
	InstanceNames []*string `locationName:"instanceNames" type:"list" required:"true"`

	// The tag key-value pairs to remove from the on-premises instances.
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`

	metadataRemoveTagsFromOnPremisesInstancesInput `json:"-" xml:"-"`
}

type metadataRemoveTagsFromOnPremisesInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromOnPremisesInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromOnPremisesInstancesInput) GoString() string {
	return s.String()
}

type RemoveTagsFromOnPremisesInstancesOutput struct {
	metadataRemoveTagsFromOnPremisesInstancesOutput `json:"-" xml:"-"`
}

type metadataRemoveTagsFromOnPremisesInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromOnPremisesInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromOnPremisesInstancesOutput) GoString() string {
	return s.String()
}

// Information about an application revision's location.
type RevisionLocation struct {
	// Information about the location of application artifacts that are stored in
	// GitHub.
	GitHubLocation *GitHubLocation `locationName:"gitHubLocation" type:"structure"`

	// The application revision's type:
	//
	//  S3: An application revision stored in Amazon S3. GitHub: An application
	// revision stored in GitHub.
	RevisionType *string `locationName:"revisionType" type:"string" enum:"RevisionLocationType"`

	// Information about the location of application artifacts that are stored in
	// Amazon S3.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`

	metadataRevisionLocation `json:"-" xml:"-"`
}

type metadataRevisionLocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RevisionLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevisionLocation) GoString() string {
	return s.String()
}

// Information about the location of application artifacts that are stored in
// Amazon S3.
type S3Location struct {
	// The name of the Amazon S3 bucket where the application revision is stored.
	Bucket *string `locationName:"bucket" type:"string"`

	// The file type of the application revision. Must be one of the following:
	//
	//  tar: A tar archive file. tgz: A compressed tar archive file. zip: A zip
	// archive file.
	BundleType *string `locationName:"bundleType" type:"string" enum:"BundleType"`

	// The ETag of the Amazon S3 object that represents the bundled artifacts for
	// the application revision.
	//
	// If the ETag is not specified as an input parameter, ETag validation of the
	// object will be skipped.
	ETag *string `locationName:"eTag" type:"string"`

	// The name of the Amazon S3 object that represents the bundled artifacts for
	// the application revision.
	Key *string `locationName:"key" type:"string"`

	// A specific version of the Amazon S3 object that represents the bundled artifacts
	// for the application revision.
	//
	// If the version is not specified, the system will use the most recent version
	// by default.
	Version *string `locationName:"version" type:"string"`

	metadataS3Location `json:"-" xml:"-"`
}

type metadataS3Location struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Represents the input of a stop deployment operation.
type StopDeploymentInput struct {
	// The unique ID of a deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	metadataStopDeploymentInput `json:"-" xml:"-"`
}

type metadataStopDeploymentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StopDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDeploymentInput) GoString() string {
	return s.String()
}

// Represents the output of a stop deployment operation.
type StopDeploymentOutput struct {
	// The status of the stop deployment operation:
	//
	//  Pending: The stop operation is pending. Succeeded: The stop operation succeeded.
	Status *string `locationName:"status" type:"string" enum:"StopStatus"`

	// An accompanying status message.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	metadataStopDeploymentOutput `json:"-" xml:"-"`
}

type metadataStopDeploymentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StopDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDeploymentOutput) GoString() string {
	return s.String()
}

// Information about a tag.
type Tag struct {
	// The tag's key.
	Key *string `type:"string"`

	// The tag's value.
	Value *string `type:"string"`

	metadataTag `json:"-" xml:"-"`
}

type metadataTag struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Information about an on-premises instance tag filter.
type TagFilter struct {
	// The on-premises instance tag filter key.
	Key *string `type:"string"`

	// The on-premises instance tag filter type:
	//
	//  KEY_ONLY: Key only. VALUE_ONLY: Value only. KEY_AND_VALUE: Key and value.
	Type *string `type:"string" enum:"TagFilterType"`

	// The on-premises instance tag filter value.
	Value *string `type:"string"`

	metadataTagFilter `json:"-" xml:"-"`
}

type metadataTagFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilter) GoString() string {
	return s.String()
}

// Information about a time range.
type TimeRange struct {
	// The time range's end time.
	//
	// Specify null to leave the time range's end time open-ended.
	End *time.Time `locationName:"end" type:"timestamp" timestampFormat:"unix"`

	// The time range's start time.
	//
	// Specify null to leave the time range's start time open-ended.
	Start *time.Time `locationName:"start" type:"timestamp" timestampFormat:"unix"`

	metadataTimeRange `json:"-" xml:"-"`
}

type metadataTimeRange struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeRange) GoString() string {
	return s.String()
}

// Represents the input of an update application operation.
type UpdateApplicationInput struct {
	// The current name of the application that you want to change.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string"`

	// The new name that you want to change the application to.
	NewApplicationName *string `locationName:"newApplicationName" min:"1" type:"string"`

	metadataUpdateApplicationInput `json:"-" xml:"-"`
}

type metadataUpdateApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

type UpdateApplicationOutput struct {
	metadataUpdateApplicationOutput `json:"-" xml:"-"`
}

type metadataUpdateApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// Represents the input of an update deployment group operation.
type UpdateDeploymentGroupInput struct {
	// The application name corresponding to the deployment group to update.
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// The replacement list of Auto Scaling groups to be included in the deployment
	// group, if you want to change them.
	AutoScalingGroups []*string `locationName:"autoScalingGroups" type:"list"`

	// The current name of the existing deployment group.
	CurrentDeploymentGroupName *string `locationName:"currentDeploymentGroupName" min:"1" type:"string" required:"true"`

	// The replacement deployment configuration name to use, if you want to change
	// it.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// The replacement set of Amazon EC2 tags to filter on, if you want to change
	// them.
	Ec2TagFilters []*EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// The new name of the deployment group, if you want to change it.
	NewDeploymentGroupName *string `locationName:"newDeploymentGroupName" min:"1" type:"string"`

	// The replacement set of on-premises instance tags for filter on, if you want
	// to change them.
	OnPremisesInstanceTagFilters []*TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// A replacement service role's ARN, if you want to change it.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	metadataUpdateDeploymentGroupInput `json:"-" xml:"-"`
}

type metadataUpdateDeploymentGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentGroupInput) GoString() string {
	return s.String()
}

// Represents the output of an update deployment group operation.
type UpdateDeploymentGroupOutput struct {
	// If the output contains no data, and the corresponding deployment group contained
	// at least one Auto Scaling group, AWS CodeDeploy successfully removed all
	// corresponding Auto Scaling lifecycle event hooks from the AWS account. If
	// the output does contain data, AWS CodeDeploy could not remove some Auto Scaling
	// lifecycle event hooks from the AWS account.
	HooksNotCleanedUp []*AutoScalingGroup `locationName:"hooksNotCleanedUp" type:"list"`

	metadataUpdateDeploymentGroupOutput `json:"-" xml:"-"`
}

type metadataUpdateDeploymentGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDeploymentGroupOutput) GoString() string {
	return s.String()
}

const (
	// @enum ApplicationRevisionSortBy
	ApplicationRevisionSortByRegisterTime = "registerTime"
	// @enum ApplicationRevisionSortBy
	ApplicationRevisionSortByFirstUsedTime = "firstUsedTime"
	// @enum ApplicationRevisionSortBy
	ApplicationRevisionSortByLastUsedTime = "lastUsedTime"
)

const (
	// @enum BundleType
	BundleTypeTar = "tar"
	// @enum BundleType
	BundleTypeTgz = "tgz"
	// @enum BundleType
	BundleTypeZip = "zip"
)

const (
	// @enum DeploymentCreator
	DeploymentCreatorUser = "user"
	// @enum DeploymentCreator
	DeploymentCreatorAutoscaling = "autoscaling"
)

const (
	// @enum DeploymentStatus
	DeploymentStatusCreated = "Created"
	// @enum DeploymentStatus
	DeploymentStatusQueued = "Queued"
	// @enum DeploymentStatus
	DeploymentStatusInProgress = "InProgress"
	// @enum DeploymentStatus
	DeploymentStatusSucceeded = "Succeeded"
	// @enum DeploymentStatus
	DeploymentStatusFailed = "Failed"
	// @enum DeploymentStatus
	DeploymentStatusStopped = "Stopped"
)

const (
	// @enum EC2TagFilterType
	EC2TagFilterTypeKeyOnly = "KEY_ONLY"
	// @enum EC2TagFilterType
	EC2TagFilterTypeValueOnly = "VALUE_ONLY"
	// @enum EC2TagFilterType
	EC2TagFilterTypeKeyAndValue = "KEY_AND_VALUE"
)

const (
	// @enum ErrorCode
	ErrorCodeDeploymentGroupMissing = "DEPLOYMENT_GROUP_MISSING"
	// @enum ErrorCode
	ErrorCodeApplicationMissing = "APPLICATION_MISSING"
	// @enum ErrorCode
	ErrorCodeRevisionMissing = "REVISION_MISSING"
	// @enum ErrorCode
	ErrorCodeIamRoleMissing = "IAM_ROLE_MISSING"
	// @enum ErrorCode
	ErrorCodeIamRolePermissions = "IAM_ROLE_PERMISSIONS"
	// @enum ErrorCode
	ErrorCodeNoEc2Subscription = "NO_EC2_SUBSCRIPTION"
	// @enum ErrorCode
	ErrorCodeOverMaxInstances = "OVER_MAX_INSTANCES"
	// @enum ErrorCode
	ErrorCodeNoInstances = "NO_INSTANCES"
	// @enum ErrorCode
	ErrorCodeTimeout = "TIMEOUT"
	// @enum ErrorCode
	ErrorCodeHealthConstraintsInvalid = "HEALTH_CONSTRAINTS_INVALID"
	// @enum ErrorCode
	ErrorCodeHealthConstraints = "HEALTH_CONSTRAINTS"
	// @enum ErrorCode
	ErrorCodeInternalError = "INTERNAL_ERROR"
	// @enum ErrorCode
	ErrorCodeThrottled = "THROTTLED"
)

const (
	// @enum InstanceStatus
	InstanceStatusPending = "Pending"
	// @enum InstanceStatus
	InstanceStatusInProgress = "InProgress"
	// @enum InstanceStatus
	InstanceStatusSucceeded = "Succeeded"
	// @enum InstanceStatus
	InstanceStatusFailed = "Failed"
	// @enum InstanceStatus
	InstanceStatusSkipped = "Skipped"
	// @enum InstanceStatus
	InstanceStatusUnknown = "Unknown"
)

const (
	// @enum LifecycleErrorCode
	LifecycleErrorCodeSuccess = "Success"
	// @enum LifecycleErrorCode
	LifecycleErrorCodeScriptMissing = "ScriptMissing"
	// @enum LifecycleErrorCode
	LifecycleErrorCodeScriptNotExecutable = "ScriptNotExecutable"
	// @enum LifecycleErrorCode
	LifecycleErrorCodeScriptTimedOut = "ScriptTimedOut"
	// @enum LifecycleErrorCode
	LifecycleErrorCodeScriptFailed = "ScriptFailed"
	// @enum LifecycleErrorCode
	LifecycleErrorCodeUnknownError = "UnknownError"
)

const (
	// @enum LifecycleEventStatus
	LifecycleEventStatusPending = "Pending"
	// @enum LifecycleEventStatus
	LifecycleEventStatusInProgress = "InProgress"
	// @enum LifecycleEventStatus
	LifecycleEventStatusSucceeded = "Succeeded"
	// @enum LifecycleEventStatus
	LifecycleEventStatusFailed = "Failed"
	// @enum LifecycleEventStatus
	LifecycleEventStatusSkipped = "Skipped"
	// @enum LifecycleEventStatus
	LifecycleEventStatusUnknown = "Unknown"
)

const (
	// @enum ListStateFilterAction
	ListStateFilterActionInclude = "include"
	// @enum ListStateFilterAction
	ListStateFilterActionExclude = "exclude"
	// @enum ListStateFilterAction
	ListStateFilterActionIgnore = "ignore"
)

const (
	// @enum MinimumHealthyHostsType
	MinimumHealthyHostsTypeHostCount = "HOST_COUNT"
	// @enum MinimumHealthyHostsType
	MinimumHealthyHostsTypeFleetPercent = "FLEET_PERCENT"
)

const (
	// @enum RegistrationStatus
	RegistrationStatusRegistered = "Registered"
	// @enum RegistrationStatus
	RegistrationStatusDeregistered = "Deregistered"
)

const (
	// @enum RevisionLocationType
	RevisionLocationTypeS3 = "S3"
	// @enum RevisionLocationType
	RevisionLocationTypeGitHub = "GitHub"
)

const (
	// @enum SortOrder
	SortOrderAscending = "ascending"
	// @enum SortOrder
	SortOrderDescending = "descending"
)

const (
	// @enum StopStatus
	StopStatusPending = "Pending"
	// @enum StopStatus
	StopStatusSucceeded = "Succeeded"
)

const (
	// @enum TagFilterType
	TagFilterTypeKeyOnly = "KEY_ONLY"
	// @enum TagFilterType
	TagFilterTypeValueOnly = "VALUE_ONLY"
	// @enum TagFilterType
	TagFilterTypeKeyAndValue = "KEY_AND_VALUE"
)
