// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package configservice_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/configservice"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleConfigService_DeleteConfigRule() {
	svc := configservice.New(nil)

	params := &configservice.DeleteConfigRuleInput{
		ConfigRuleName: aws.String("StringWithCharLimit64"), // Required
	}
	resp, err := svc.DeleteConfigRule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DeleteDeliveryChannel() {
	svc := configservice.New(nil)

	params := &configservice.DeleteDeliveryChannelInput{
		DeliveryChannelName: aws.String("ChannelName"), // Required
	}
	resp, err := svc.DeleteDeliveryChannel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DeliverConfigSnapshot() {
	svc := configservice.New(nil)

	params := &configservice.DeliverConfigSnapshotInput{
		DeliveryChannelName: aws.String("ChannelName"), // Required
	}
	resp, err := svc.DeliverConfigSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DescribeComplianceByConfigRule() {
	svc := configservice.New(nil)

	params := &configservice.DescribeComplianceByConfigRuleInput{
		ComplianceTypes: []*string{
			aws.String("ComplianceType"), // Required
			// More values...
		},
		ConfigRuleNames: []*string{
			aws.String("StringWithCharLimit64"), // Required
			// More values...
		},
		NextToken: aws.String("String"),
	}
	resp, err := svc.DescribeComplianceByConfigRule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DescribeComplianceByResource() {
	svc := configservice.New(nil)

	params := &configservice.DescribeComplianceByResourceInput{
		ComplianceTypes: []*string{
			aws.String("ComplianceType"), // Required
			// More values...
		},
		Limit:        aws.Int64(1),
		NextToken:    aws.String("NextToken"),
		ResourceId:   aws.String("StringWithCharLimit256"),
		ResourceType: aws.String("StringWithCharLimit256"),
	}
	resp, err := svc.DescribeComplianceByResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DescribeConfigRuleEvaluationStatus() {
	svc := configservice.New(nil)

	params := &configservice.DescribeConfigRuleEvaluationStatusInput{
		ConfigRuleNames: []*string{
			aws.String("StringWithCharLimit64"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeConfigRuleEvaluationStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DescribeConfigRules() {
	svc := configservice.New(nil)

	params := &configservice.DescribeConfigRulesInput{
		ConfigRuleNames: []*string{
			aws.String("StringWithCharLimit64"), // Required
			// More values...
		},
		NextToken: aws.String("String"),
	}
	resp, err := svc.DescribeConfigRules(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DescribeConfigurationRecorderStatus() {
	svc := configservice.New(nil)

	params := &configservice.DescribeConfigurationRecorderStatusInput{
		ConfigurationRecorderNames: []*string{
			aws.String("RecorderName"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeConfigurationRecorderStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DescribeConfigurationRecorders() {
	svc := configservice.New(nil)

	params := &configservice.DescribeConfigurationRecordersInput{
		ConfigurationRecorderNames: []*string{
			aws.String("RecorderName"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeConfigurationRecorders(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DescribeDeliveryChannelStatus() {
	svc := configservice.New(nil)

	params := &configservice.DescribeDeliveryChannelStatusInput{
		DeliveryChannelNames: []*string{
			aws.String("ChannelName"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeDeliveryChannelStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_DescribeDeliveryChannels() {
	svc := configservice.New(nil)

	params := &configservice.DescribeDeliveryChannelsInput{
		DeliveryChannelNames: []*string{
			aws.String("ChannelName"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeDeliveryChannels(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_GetComplianceDetailsByConfigRule() {
	svc := configservice.New(nil)

	params := &configservice.GetComplianceDetailsByConfigRuleInput{
		ConfigRuleName: aws.String("StringWithCharLimit64"), // Required
		ComplianceTypes: []*string{
			aws.String("ComplianceType"), // Required
			// More values...
		},
		Limit:     aws.Int64(1),
		NextToken: aws.String("NextToken"),
	}
	resp, err := svc.GetComplianceDetailsByConfigRule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_GetComplianceDetailsByResource() {
	svc := configservice.New(nil)

	params := &configservice.GetComplianceDetailsByResourceInput{
		ResourceId:   aws.String("StringWithCharLimit256"), // Required
		ResourceType: aws.String("StringWithCharLimit256"), // Required
		ComplianceTypes: []*string{
			aws.String("ComplianceType"), // Required
			// More values...
		},
		NextToken: aws.String("String"),
	}
	resp, err := svc.GetComplianceDetailsByResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_GetComplianceSummaryByConfigRule() {
	svc := configservice.New(nil)

	var params *configservice.GetComplianceSummaryByConfigRuleInput
	resp, err := svc.GetComplianceSummaryByConfigRule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_GetComplianceSummaryByResourceType() {
	svc := configservice.New(nil)

	params := &configservice.GetComplianceSummaryByResourceTypeInput{
		ResourceTypes: []*string{
			aws.String("StringWithCharLimit256"), // Required
			// More values...
		},
	}
	resp, err := svc.GetComplianceSummaryByResourceType(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_GetResourceConfigHistory() {
	svc := configservice.New(nil)

	params := &configservice.GetResourceConfigHistoryInput{
		ResourceId:         aws.String("ResourceId"),   // Required
		ResourceType:       aws.String("ResourceType"), // Required
		ChronologicalOrder: aws.String("ChronologicalOrder"),
		EarlierTime:        aws.Time(time.Now()),
		LaterTime:          aws.Time(time.Now()),
		Limit:              aws.Int64(1),
		NextToken:          aws.String("NextToken"),
	}
	resp, err := svc.GetResourceConfigHistory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_ListDiscoveredResources() {
	svc := configservice.New(nil)

	params := &configservice.ListDiscoveredResourcesInput{
		ResourceType:            aws.String("ResourceType"), // Required
		IncludeDeletedResources: aws.Bool(true),
		Limit:     aws.Int64(1),
		NextToken: aws.String("NextToken"),
		ResourceIds: []*string{
			aws.String("ResourceId"), // Required
			// More values...
		},
		ResourceName: aws.String("ResourceName"),
	}
	resp, err := svc.ListDiscoveredResources(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_PutConfigRule() {
	svc := configservice.New(nil)

	params := &configservice.PutConfigRuleInput{
		ConfigRule: &configservice.ConfigRule{ // Required
			Source: &configservice.Source{ // Required
				Owner: aws.String("Owner"),
				SourceDetails: []*configservice.SourceDetail{
					{ // Required
						EventSource: aws.String("EventSource"),
						MessageType: aws.String("MessageType"),
					},
					// More values...
				},
				SourceIdentifier: aws.String("StringWithCharLimit256"),
			},
			ConfigRuleArn:             aws.String("String"),
			ConfigRuleId:              aws.String("String"),
			ConfigRuleName:            aws.String("StringWithCharLimit64"),
			ConfigRuleState:           aws.String("ConfigRuleState"),
			Description:               aws.String("EmptiableStringWithCharLimit256"),
			InputParameters:           aws.String("StringWithCharLimit256"),
			MaximumExecutionFrequency: aws.String("MaximumExecutionFrequency"),
			Scope: &configservice.Scope{
				ComplianceResourceId: aws.String("StringWithCharLimit256"),
				ComplianceResourceTypes: []*string{
					aws.String("StringWithCharLimit256"), // Required
					// More values...
				},
				TagKey:   aws.String("StringWithCharLimit128"),
				TagValue: aws.String("StringWithCharLimit256"),
			},
		},
	}
	resp, err := svc.PutConfigRule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_PutConfigurationRecorder() {
	svc := configservice.New(nil)

	params := &configservice.PutConfigurationRecorderInput{
		ConfigurationRecorder: &configservice.ConfigurationRecorder{ // Required
			Name: aws.String("RecorderName"),
			RecordingGroup: &configservice.RecordingGroup{
				AllSupported: aws.Bool(true),
				ResourceTypes: []*string{
					aws.String("ResourceType"), // Required
					// More values...
				},
			},
			RoleARN: aws.String("String"),
		},
	}
	resp, err := svc.PutConfigurationRecorder(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_PutDeliveryChannel() {
	svc := configservice.New(nil)

	params := &configservice.PutDeliveryChannelInput{
		DeliveryChannel: &configservice.DeliveryChannel{ // Required
			ConfigSnapshotDeliveryProperties: &configservice.ConfigSnapshotDeliveryProperties{
				DeliveryFrequency: aws.String("MaximumExecutionFrequency"),
			},
			Name:         aws.String("ChannelName"),
			S3BucketName: aws.String("String"),
			S3KeyPrefix:  aws.String("String"),
			SnsTopicARN:  aws.String("String"),
		},
	}
	resp, err := svc.PutDeliveryChannel(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_PutEvaluations() {
	svc := configservice.New(nil)

	params := &configservice.PutEvaluationsInput{
		ResultToken: aws.String("String"), // Required
		Evaluations: []*configservice.Evaluation{
			{ // Required
				ComplianceResourceId:   aws.String("StringWithCharLimit256"), // Required
				ComplianceResourceType: aws.String("StringWithCharLimit256"), // Required
				ComplianceType:         aws.String("ComplianceType"),         // Required
				OrderingTimestamp:      aws.Time(time.Now()),                 // Required
				Annotation:             aws.String("StringWithCharLimit256"),
			},
			// More values...
		},
	}
	resp, err := svc.PutEvaluations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_StartConfigurationRecorder() {
	svc := configservice.New(nil)

	params := &configservice.StartConfigurationRecorderInput{
		ConfigurationRecorderName: aws.String("RecorderName"), // Required
	}
	resp, err := svc.StartConfigurationRecorder(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleConfigService_StopConfigurationRecorder() {
	svc := configservice.New(nil)

	params := &configservice.StopConfigurationRecorderInput{
		ConfigurationRecorderName: aws.String("RecorderName"), // Required
	}
	resp, err := svc.StopConfigurationRecorder(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
