// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package directconnect

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/defaults"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/service"
	"github.com/aws/aws-sdk-go/aws/service/serviceinfo"
	"github.com/aws/aws-sdk-go/internal/protocol/jsonrpc"
	"github.com/aws/aws-sdk-go/internal/signer/v4"
)

// AWS Direct Connect makes it easy to establish a dedicated network connection
// from your premises to Amazon Web Services (AWS). Using AWS Direct Connect,
// you can establish private connectivity between AWS and your data center,
// office, or colocation environment, which in many cases can reduce your network
// costs, increase bandwidth throughput, and provide a more consistent network
// experience than Internet-based connections.
//
// The AWS Direct Connect API Reference provides descriptions, syntax, and
// usage examples for each of the actions and data types for AWS Direct Connect.
// Use the following links to get started using the AWS Direct Connect API Reference:
//
//   Actions (http://docs.aws.amazon.com/directconnect/latest/APIReference/API_Operations.html):
// An alphabetical list of all AWS Direct Connect actions.  Data Types (http://docs.aws.amazon.com/directconnect/latest/APIReference/API_Types.html):
// An alphabetical list of all AWS Direct Connect data types.  Common Query
// Parameters (http://docs.aws.amazon.com/directconnect/latest/APIReference/CommonParameters.html):
// Parameters that all Query actions can use.  Common Errors (http://docs.aws.amazon.com/directconnect/latest/APIReference/CommonErrors.html):
// Client and server errors that all actions can return.
type DirectConnect struct {
	*service.Service
}

// Used for custom service initialization logic
var initService func(*service.Service)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// New returns a new DirectConnect client.
func New(config *aws.Config) *DirectConnect {
	service := &service.Service{
		ServiceInfo: serviceinfo.ServiceInfo{
			Config:       defaults.DefaultConfig.Merge(config),
			ServiceName:  "directconnect",
			APIVersion:   "2012-10-25",
			JSONVersion:  "1.1",
			TargetPrefix: "OvertureService",
		},
	}
	service.Initialize()

	// Handlers
	service.Handlers.Sign.PushBack(v4.Sign)
	service.Handlers.Build.PushBack(jsonrpc.Build)
	service.Handlers.Unmarshal.PushBack(jsonrpc.Unmarshal)
	service.Handlers.UnmarshalMeta.PushBack(jsonrpc.UnmarshalMeta)
	service.Handlers.UnmarshalError.PushBack(jsonrpc.UnmarshalError)

	// Run custom service initialization if present
	if initService != nil {
		initService(service)
	}

	return &DirectConnect{service}
}

// newRequest creates a new request for a DirectConnect operation and runs any
// custom request initialization.
func (c *DirectConnect) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
