// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package directoryservice provides a client for AWS Directory Service.
package directoryservice

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opConnectDirectory = "ConnectDirectory"

// ConnectDirectoryRequest generates a request for the ConnectDirectory operation.
func (c *DirectoryService) ConnectDirectoryRequest(input *ConnectDirectoryInput) (req *request.Request, output *ConnectDirectoryOutput) {
	op := &request.Operation{
		Name:       opConnectDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConnectDirectoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConnectDirectoryOutput{}
	req.Data = output
	return
}

// Creates an AD Connector to connect an on-premises directory.
func (c *DirectoryService) ConnectDirectory(input *ConnectDirectoryInput) (*ConnectDirectoryOutput, error) {
	req, out := c.ConnectDirectoryRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a request for the CreateAlias operation.
func (c *DirectoryService) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAliasOutput{}
	req.Data = output
	return
}

// Creates an alias for a directory and assigns the alias to the directory.
// The alias is used to construct the access URL for the directory, such as
// http://<alias>.awsapps.com.
//
//  After an alias has been created, it cannot be deleted or reused, so this
// operation should only be used when absolutely necessary.
func (c *DirectoryService) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateComputer = "CreateComputer"

// CreateComputerRequest generates a request for the CreateComputer operation.
func (c *DirectoryService) CreateComputerRequest(input *CreateComputerInput) (req *request.Request, output *CreateComputerOutput) {
	op := &request.Operation{
		Name:       opCreateComputer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateComputerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateComputerOutput{}
	req.Data = output
	return
}

// Creates a computer account in the specified directory, and joins the computer
// to the directory.
func (c *DirectoryService) CreateComputer(input *CreateComputerInput) (*CreateComputerOutput, error) {
	req, out := c.CreateComputerRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDirectory = "CreateDirectory"

// CreateDirectoryRequest generates a request for the CreateDirectory operation.
func (c *DirectoryService) CreateDirectoryRequest(input *CreateDirectoryInput) (req *request.Request, output *CreateDirectoryOutput) {
	op := &request.Operation{
		Name:       opCreateDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDirectoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDirectoryOutput{}
	req.Data = output
	return
}

// Creates a Simple AD directory.
func (c *DirectoryService) CreateDirectory(input *CreateDirectoryInput) (*CreateDirectoryOutput, error) {
	req, out := c.CreateDirectoryRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a request for the CreateSnapshot operation.
func (c *DirectoryService) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateSnapshotOutput{}
	req.Data = output
	return
}

// Creates a snapshot of an existing directory.
//
// You cannot take snapshots of extended or connected directories.
func (c *DirectoryService) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteDirectory = "DeleteDirectory"

// DeleteDirectoryRequest generates a request for the DeleteDirectory operation.
func (c *DirectoryService) DeleteDirectoryRequest(input *DeleteDirectoryInput) (req *request.Request, output *DeleteDirectoryOutput) {
	op := &request.Operation{
		Name:       opDeleteDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDirectoryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteDirectoryOutput{}
	req.Data = output
	return
}

// Deletes an AWS Directory Service directory.
func (c *DirectoryService) DeleteDirectory(input *DeleteDirectoryInput) (*DeleteDirectoryOutput, error) {
	req, out := c.DeleteDirectoryRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a request for the DeleteSnapshot operation.
func (c *DirectoryService) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteSnapshotOutput{}
	req.Data = output
	return
}

// Deletes a directory snapshot.
func (c *DirectoryService) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDirectories = "DescribeDirectories"

// DescribeDirectoriesRequest generates a request for the DescribeDirectories operation.
func (c *DirectoryService) DescribeDirectoriesRequest(input *DescribeDirectoriesInput) (req *request.Request, output *DescribeDirectoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDirectoriesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDirectoriesOutput{}
	req.Data = output
	return
}

// Obtains information about the directories that belong to this account.
//
// You can retrieve information about specific directories by passing the directory
// identifiers in the DirectoryIds parameter. Otherwise, all directories that
// belong to the current account are returned.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the DescribeDirectoriesResult.NextToken
// member contains a token that you pass in the next call to DescribeDirectories
// to retrieve the next set of items.
//
// You can also specify a maximum number of return results with the Limit parameter.
func (c *DirectoryService) DescribeDirectories(input *DescribeDirectoriesInput) (*DescribeDirectoriesOutput, error) {
	req, out := c.DescribeDirectoriesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSnapshots = "DescribeSnapshots"

// DescribeSnapshotsRequest generates a request for the DescribeSnapshots operation.
func (c *DirectoryService) DescribeSnapshotsRequest(input *DescribeSnapshotsInput) (req *request.Request, output *DescribeSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSnapshotsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSnapshotsOutput{}
	req.Data = output
	return
}

// Obtains information about the directory snapshots that belong to this account.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the DescribeSnapshots.NextToken
// member contains a token that you pass in the next call to DescribeSnapshots
// to retrieve the next set of items.
//
// You can also specify a maximum number of return results with the Limit parameter.
func (c *DirectoryService) DescribeSnapshots(input *DescribeSnapshotsInput) (*DescribeSnapshotsOutput, error) {
	req, out := c.DescribeSnapshotsRequest(input)
	err := req.Send()
	return out, err
}

const opDisableRadius = "DisableRadius"

// DisableRadiusRequest generates a request for the DisableRadius operation.
func (c *DirectoryService) DisableRadiusRequest(input *DisableRadiusInput) (req *request.Request, output *DisableRadiusOutput) {
	op := &request.Operation{
		Name:       opDisableRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableRadiusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableRadiusOutput{}
	req.Data = output
	return
}

// Disables multi-factor authentication (MFA) with Remote Authentication Dial
// In User Service (RADIUS) for an AD Connector directory.
func (c *DirectoryService) DisableRadius(input *DisableRadiusInput) (*DisableRadiusOutput, error) {
	req, out := c.DisableRadiusRequest(input)
	err := req.Send()
	return out, err
}

const opDisableSso = "DisableSso"

// DisableSsoRequest generates a request for the DisableSso operation.
func (c *DirectoryService) DisableSsoRequest(input *DisableSsoInput) (req *request.Request, output *DisableSsoOutput) {
	op := &request.Operation{
		Name:       opDisableSso,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableSsoInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableSsoOutput{}
	req.Data = output
	return
}

// Disables single-sign on for a directory.
func (c *DirectoryService) DisableSso(input *DisableSsoInput) (*DisableSsoOutput, error) {
	req, out := c.DisableSsoRequest(input)
	err := req.Send()
	return out, err
}

const opEnableRadius = "EnableRadius"

// EnableRadiusRequest generates a request for the EnableRadius operation.
func (c *DirectoryService) EnableRadiusRequest(input *EnableRadiusInput) (req *request.Request, output *EnableRadiusOutput) {
	op := &request.Operation{
		Name:       opEnableRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableRadiusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableRadiusOutput{}
	req.Data = output
	return
}

// Enables multi-factor authentication (MFA) with Remote Authentication Dial
// In User Service (RADIUS) for an AD Connector directory.
func (c *DirectoryService) EnableRadius(input *EnableRadiusInput) (*EnableRadiusOutput, error) {
	req, out := c.EnableRadiusRequest(input)
	err := req.Send()
	return out, err
}

const opEnableSso = "EnableSso"

// EnableSsoRequest generates a request for the EnableSso operation.
func (c *DirectoryService) EnableSsoRequest(input *EnableSsoInput) (req *request.Request, output *EnableSsoOutput) {
	op := &request.Operation{
		Name:       opEnableSso,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableSsoInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableSsoOutput{}
	req.Data = output
	return
}

// Enables single-sign on for a directory.
func (c *DirectoryService) EnableSso(input *EnableSsoInput) (*EnableSsoOutput, error) {
	req, out := c.EnableSsoRequest(input)
	err := req.Send()
	return out, err
}

const opGetDirectoryLimits = "GetDirectoryLimits"

// GetDirectoryLimitsRequest generates a request for the GetDirectoryLimits operation.
func (c *DirectoryService) GetDirectoryLimitsRequest(input *GetDirectoryLimitsInput) (req *request.Request, output *GetDirectoryLimitsOutput) {
	op := &request.Operation{
		Name:       opGetDirectoryLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDirectoryLimitsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDirectoryLimitsOutput{}
	req.Data = output
	return
}

// Obtains directory limit information for the current region.
func (c *DirectoryService) GetDirectoryLimits(input *GetDirectoryLimitsInput) (*GetDirectoryLimitsOutput, error) {
	req, out := c.GetDirectoryLimitsRequest(input)
	err := req.Send()
	return out, err
}

const opGetSnapshotLimits = "GetSnapshotLimits"

// GetSnapshotLimitsRequest generates a request for the GetSnapshotLimits operation.
func (c *DirectoryService) GetSnapshotLimitsRequest(input *GetSnapshotLimitsInput) (req *request.Request, output *GetSnapshotLimitsOutput) {
	op := &request.Operation{
		Name:       opGetSnapshotLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSnapshotLimitsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSnapshotLimitsOutput{}
	req.Data = output
	return
}

// Obtains the manual snapshot limits for a directory.
func (c *DirectoryService) GetSnapshotLimits(input *GetSnapshotLimitsInput) (*GetSnapshotLimitsOutput, error) {
	req, out := c.GetSnapshotLimitsRequest(input)
	err := req.Send()
	return out, err
}

const opRestoreFromSnapshot = "RestoreFromSnapshot"

// RestoreFromSnapshotRequest generates a request for the RestoreFromSnapshot operation.
func (c *DirectoryService) RestoreFromSnapshotRequest(input *RestoreFromSnapshotInput) (req *request.Request, output *RestoreFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreFromSnapshotInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestoreFromSnapshotOutput{}
	req.Data = output
	return
}

// Restores a directory using an existing directory snapshot.
//
// When you restore a directory from a snapshot, any changes made to the directory
// after the snapshot date are overwritten.
//
// This action returns as soon as the restore operation is initiated. You can
// monitor the progress of the restore operation by calling the DescribeDirectories
// operation with the directory identifier. When the DirectoryDescription.Stage
// value changes to Active, the restore operation is complete.
func (c *DirectoryService) RestoreFromSnapshot(input *RestoreFromSnapshotInput) (*RestoreFromSnapshotOutput, error) {
	req, out := c.RestoreFromSnapshotRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateRadius = "UpdateRadius"

// UpdateRadiusRequest generates a request for the UpdateRadius operation.
func (c *DirectoryService) UpdateRadiusRequest(input *UpdateRadiusInput) (req *request.Request, output *UpdateRadiusOutput) {
	op := &request.Operation{
		Name:       opUpdateRadius,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRadiusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateRadiusOutput{}
	req.Data = output
	return
}

// Updates the Remote Authentication Dial In User Service (RADIUS) server information
// for an AD Connector directory.
func (c *DirectoryService) UpdateRadius(input *UpdateRadiusInput) (*UpdateRadiusOutput, error) {
	req, out := c.UpdateRadiusRequest(input)
	err := req.Send()
	return out, err
}

// Represents a named directory attribute.
type Attribute struct {
	// The name of the attribute.
	Name *string `min:"1" type:"string"`

	// The value of the attribute.
	Value *string `type:"string"`

	metadataAttribute `json:"-" xml:"-"`
}

type metadataAttribute struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attribute) GoString() string {
	return s.String()
}

// Contains information about a computer account in a directory.
type Computer struct {
	// An array of Attribute objects that contain the LDAP attributes that belong
	// to the computer account.
	ComputerAttributes []*Attribute `type:"list"`

	// The identifier of the computer.
	ComputerId *string `min:"1" type:"string"`

	// The computer name.
	ComputerName *string `min:"1" type:"string"`

	metadataComputer `json:"-" xml:"-"`
}

type metadataComputer struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Computer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Computer) GoString() string {
	return s.String()
}

// Contains the inputs for the ConnectDirectory operation.
type ConnectDirectoryInput struct {
	// A DirectoryConnectSettings object that contains additional information for
	// the operation.
	ConnectSettings *DirectoryConnectSettings `type:"structure" required:"true"`

	// A textual description for the directory.
	Description *string `type:"string"`

	// The fully-qualified name of the on-premises directory, such as corp.example.com.
	Name *string `type:"string" required:"true"`

	// The password for the on-premises user account.
	Password *string `min:"1" type:"string" required:"true"`

	// The NetBIOS name of the on-premises directory, such as CORP.
	ShortName *string `type:"string"`

	// The size of the directory.
	Size *string `type:"string" required:"true" enum:"DirectorySize"`

	metadataConnectDirectoryInput `json:"-" xml:"-"`
}

type metadataConnectDirectoryInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConnectDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectDirectoryInput) GoString() string {
	return s.String()
}

// Contains the results of the ConnectDirectory operation.
type ConnectDirectoryOutput struct {
	// The identifier of the new directory.
	DirectoryId *string `type:"string"`

	metadataConnectDirectoryOutput `json:"-" xml:"-"`
}

type metadataConnectDirectoryOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConnectDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectDirectoryOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateAlias operation.
type CreateAliasInput struct {
	// The requested alias.
	//
	// The alias must be unique amongst all aliases in AWS. This operation will
	// throw an EntityAlreadyExistsException if this alias already exists.
	Alias *string `min:"1" type:"string" required:"true"`

	// The identifier of the directory to create the alias for.
	DirectoryId *string `type:"string" required:"true"`

	metadataCreateAliasInput `json:"-" xml:"-"`
}

type metadataCreateAliasInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Contains the results of the CreateAlias operation.
type CreateAliasOutput struct {
	// The alias for the directory.
	Alias *string `min:"1" type:"string"`

	// The identifier of the directory.
	DirectoryId *string `type:"string"`

	metadataCreateAliasOutput `json:"-" xml:"-"`
}

type metadataCreateAliasOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateComputer operation.
type CreateComputerInput struct {
	// An array of Attribute objects that contain any LDAP attributes to apply to
	// the computer account.
	ComputerAttributes []*Attribute `type:"list"`

	// The name of the computer account.
	ComputerName *string `min:"1" type:"string" required:"true"`

	// The identifier of the directory to create the computer account in.
	DirectoryId *string `type:"string" required:"true"`

	// The fully-qualified distinguished name of the organizational unit to place
	// the computer account in.
	OrganizationalUnitDistinguishedName *string `min:"1" type:"string"`

	// A one-time password that is used to join the computer to the directory. You
	// should generate a random, strong password to use for this parameter.
	Password *string `min:"8" type:"string" required:"true"`

	metadataCreateComputerInput `json:"-" xml:"-"`
}

type metadataCreateComputerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateComputerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComputerInput) GoString() string {
	return s.String()
}

// Contains the results for the CreateComputer operation.
type CreateComputerOutput struct {
	// A Computer object the represents the computer account.
	Computer *Computer `type:"structure"`

	metadataCreateComputerOutput `json:"-" xml:"-"`
}

type metadataCreateComputerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateComputerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateComputerOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateDirectory operation.
type CreateDirectoryInput struct {
	// A textual description for the directory.
	Description *string `type:"string"`

	// The fully qualified name for the directory, such as corp.example.com.
	Name *string `type:"string" required:"true"`

	// The password for the directory administrator. The directory creation process
	// creates a directory administrator account with the username Administrator
	// and this password.
	Password *string `type:"string" required:"true"`

	// The short name of the directory, such as CORP.
	ShortName *string `type:"string"`

	// The size of the directory.
	Size *string `type:"string" required:"true" enum:"DirectorySize"`

	// A DirectoryVpcSettings object that contains additional information for the
	// operation.
	VpcSettings *DirectoryVpcSettings `type:"structure"`

	metadataCreateDirectoryInput `json:"-" xml:"-"`
}

type metadataCreateDirectoryInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryInput) GoString() string {
	return s.String()
}

// Contains the results of the CreateDirectory operation.
type CreateDirectoryOutput struct {
	// The identifier of the directory that was created.
	DirectoryId *string `type:"string"`

	metadataCreateDirectoryOutput `json:"-" xml:"-"`
}

type metadataCreateDirectoryOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDirectoryOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateSnapshot operation.
type CreateSnapshotInput struct {
	// The identifier of the directory to take a snapshot of.
	DirectoryId *string `type:"string" required:"true"`

	// The descriptive name to apply to the snapshot.
	Name *string `type:"string"`

	metadataCreateSnapshotInput `json:"-" xml:"-"`
}

type metadataCreateSnapshotInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Contains the results of the CreateSnapshot operation.
type CreateSnapshotOutput struct {
	// The identifier of the snapshot that was created.
	SnapshotId *string `type:"string"`

	metadataCreateSnapshotOutput `json:"-" xml:"-"`
}

type metadataCreateSnapshotOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteDirectory operation.
type DeleteDirectoryInput struct {
	// The identifier of the directory to delete.
	DirectoryId *string `type:"string" required:"true"`

	metadataDeleteDirectoryInput `json:"-" xml:"-"`
}

type metadataDeleteDirectoryInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryInput) GoString() string {
	return s.String()
}

// Contains the results of the DeleteDirectory operation.
type DeleteDirectoryOutput struct {
	// The directory identifier.
	DirectoryId *string `type:"string"`

	metadataDeleteDirectoryOutput `json:"-" xml:"-"`
}

type metadataDeleteDirectoryOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDirectoryOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DeleteSnapshot operation.
type DeleteSnapshotInput struct {
	// The identifier of the directory snapshot to be deleted.
	SnapshotId *string `type:"string" required:"true"`

	metadataDeleteSnapshotInput `json:"-" xml:"-"`
}

type metadataDeleteSnapshotInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotInput) GoString() string {
	return s.String()
}

// Contains the results of the DeleteSnapshot operation.
type DeleteSnapshotOutput struct {
	// The identifier of the directory snapshot that was deleted.
	SnapshotId *string `type:"string"`

	metadataDeleteSnapshotOutput `json:"-" xml:"-"`
}

type metadataDeleteSnapshotOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSnapshotOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DescribeDirectories operation.
type DescribeDirectoriesInput struct {
	// A list of identifiers of the directories to obtain the information for. If
	// this member is null, all directories that belong to the current account are
	// returned.
	//
	// An empty list results in an InvalidParameterException being thrown.
	DirectoryIds []*string `type:"list"`

	// The maximum number of items to return. If this value is zero, the maximum
	// number of items is specified by the limitations of the operation.
	Limit *int64 `type:"integer"`

	// The DescribeDirectoriesResult.NextToken value from a previous call to DescribeDirectories.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`

	metadataDescribeDirectoriesInput `json:"-" xml:"-"`
}

type metadataDescribeDirectoriesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoriesInput) GoString() string {
	return s.String()
}

// Contains the results of the DescribeDirectories operation.
type DescribeDirectoriesOutput struct {
	// The list of DirectoryDescription objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	DirectoryDescriptions []*DirectoryDescription `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to DescribeDirectories to retrieve the next
	// set of items.
	NextToken *string `type:"string"`

	metadataDescribeDirectoriesOutput `json:"-" xml:"-"`
}

type metadataDescribeDirectoriesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDirectoriesOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DescribeSnapshots operation.
type DescribeSnapshotsInput struct {
	// The identifier of the directory to retrieve snapshot information for.
	DirectoryId *string `type:"string"`

	// The maximum number of objects to return.
	Limit *int64 `type:"integer"`

	// The DescribeSnapshotsResult.NextToken value from a previous call to DescribeSnapshots.
	// Pass null if this is the first call.
	NextToken *string `type:"string"`

	// A list of identifiers of the snapshots to obtain the information for. If
	// this member is null or empty, all snapshots are returned using the Limit
	// and NextToken members.
	SnapshotIds []*string `type:"list"`

	metadataDescribeSnapshotsInput `json:"-" xml:"-"`
}

type metadataDescribeSnapshotsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsInput) GoString() string {
	return s.String()
}

// Contains the results of the DescribeSnapshots operation.
type DescribeSnapshotsOutput struct {
	// If not null, more results are available. Pass this value in the NextToken
	// member of a subsequent call to DescribeSnapshots.
	NextToken *string `type:"string"`

	// The list of Snapshot objects that were retrieved.
	//
	// It is possible that this list contains less than the number of items specified
	// in the Limit member of the request. This occurs if there are less than the
	// requested number of items left to retrieve, or if the limitations of the
	// operation have been exceeded.
	Snapshots []*Snapshot `type:"list"`

	metadataDescribeSnapshotsOutput `json:"-" xml:"-"`
}

type metadataDescribeSnapshotsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSnapshotsOutput) GoString() string {
	return s.String()
}

// Contains information for the ConnectDirectory operation when an AD Connector
// directory is being created.
type DirectoryConnectSettings struct {
	// A list of one or more IP addresses of DNS servers or domain controllers in
	// the on-premises directory.
	CustomerDnsIps []*string `type:"list" required:"true"`

	// The username of an account in the on-premises directory that is used to connect
	// to the directory. This account must have the following privileges:
	//
	//  Read users and groups Create computer objects Join computers to the domain
	CustomerUserName *string `min:"1" type:"string" required:"true"`

	// A list of subnet identifiers in the VPC that the AD Connector is created
	// in.
	SubnetIds []*string `type:"list" required:"true"`

	// The identifier of the VPC that the AD Connector is created in.
	VpcId *string `type:"string" required:"true"`

	metadataDirectoryConnectSettings `json:"-" xml:"-"`
}

type metadataDirectoryConnectSettings struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DirectoryConnectSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryConnectSettings) GoString() string {
	return s.String()
}

// Contains information about an AD Connector directory.
type DirectoryConnectSettingsDescription struct {
	// A list of the Availability Zones that the directory is in.
	AvailabilityZones []*string `type:"list"`

	// The IP addresses of the AD Connector servers.
	ConnectIps []*string `type:"list"`

	// The username of the service account in the on-premises directory.
	CustomerUserName *string `min:"1" type:"string"`

	// The security group identifier for the AD Connector directory.
	SecurityGroupId *string `type:"string"`

	// A list of subnet identifiers in the VPC that the AD connector is in.
	SubnetIds []*string `type:"list"`

	// The identifier of the VPC that the AD Connector is in.
	VpcId *string `type:"string"`

	metadataDirectoryConnectSettingsDescription `json:"-" xml:"-"`
}

type metadataDirectoryConnectSettingsDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DirectoryConnectSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryConnectSettingsDescription) GoString() string {
	return s.String()
}

// Contains information about an AWS Directory Service directory.
type DirectoryDescription struct {
	// The access URL for the directory, such as http://<alias>.awsapps.com.
	AccessUrl *string `min:"1" type:"string"`

	// The alias for the directory.
	Alias *string `min:"1" type:"string"`

	// A DirectoryConnectSettingsDescription object that contains additional information
	// about an AD Connector directory. This member is only present if the directory
	// is an AD Connector directory.
	ConnectSettings *DirectoryConnectSettingsDescription `type:"structure"`

	// The textual description for the directory.
	Description *string `type:"string"`

	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The IP addresses of the DNS servers for the directory. For a Simple AD directory,
	// these are the IP addresses of the Simple AD directory servers. For an AD
	// Connector directory, these are the IP addresses of the DNS servers or domain
	// controllers in the on-premises directory that the AD Connector is connected
	// to.
	DnsIpAddrs []*string `type:"list"`

	// Specifies when the directory was created.
	LaunchTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The fully-qualified name of the directory.
	Name *string `type:"string"`

	// A RadiusSettings object that contains information about the RADIUS server
	// configured for this directory.
	RadiusSettings *RadiusSettings `type:"structure"`

	// The status of the RADIUS MFA server connection.
	RadiusStatus *string `type:"string" enum:"RadiusStatus"`

	// The short name of the directory.
	ShortName *string `type:"string"`

	// The directory size.
	Size *string `type:"string" enum:"DirectorySize"`

	// Indicates if single-sign on is enabled for the directory. For more information,
	// see EnableSso and DisableSso.
	SsoEnabled *bool `type:"boolean"`

	// The current stage of the directory.
	Stage *string `type:"string" enum:"DirectoryStage"`

	// The date and time that the stage was last updated.
	StageLastUpdatedDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Additional information about the directory stage.
	StageReason *string `type:"string"`

	// The directory size.
	Type *string `type:"string" enum:"DirectoryType"`

	// A DirectoryVpcSettingsDescription object that contains additional information
	// about a Simple AD directory. This member is only present if the directory
	// is a Simple AD directory.
	VpcSettings *DirectoryVpcSettingsDescription `type:"structure"`

	metadataDirectoryDescription `json:"-" xml:"-"`
}

type metadataDirectoryDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DirectoryDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryDescription) GoString() string {
	return s.String()
}

// Contains directory limit information for a region.
type DirectoryLimits struct {
	// The current number of cloud directories in the region.
	CloudOnlyDirectoriesCurrentCount *int64 `type:"integer"`

	// The maximum number of cloud directories allowed in the region.
	CloudOnlyDirectoriesLimit *int64 `type:"integer"`

	// Indicates if the cloud directory limit has been reached.
	CloudOnlyDirectoriesLimitReached *bool `type:"boolean"`

	// The current number of connected directories in the region.
	ConnectedDirectoriesCurrentCount *int64 `type:"integer"`

	// The maximum number of connected directories allowed in the region.
	ConnectedDirectoriesLimit *int64 `type:"integer"`

	// Indicates if the connected directory limit has been reached.
	ConnectedDirectoriesLimitReached *bool `type:"boolean"`

	metadataDirectoryLimits `json:"-" xml:"-"`
}

type metadataDirectoryLimits struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DirectoryLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryLimits) GoString() string {
	return s.String()
}

// Contains information for the CreateDirectory operation when a Simple AD directory
// is being created.
type DirectoryVpcSettings struct {
	// The identifiers of the subnets for the directory servers. The two subnets
	// must be in different Availability Zones. AWS Directory Service creates a
	// directory server and a DNS server in each of these subnets.
	SubnetIds []*string `type:"list" required:"true"`

	// The identifier of the VPC to create the Simple AD directory in.
	VpcId *string `type:"string" required:"true"`

	metadataDirectoryVpcSettings `json:"-" xml:"-"`
}

type metadataDirectoryVpcSettings struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DirectoryVpcSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryVpcSettings) GoString() string {
	return s.String()
}

// Contains information about a Simple AD directory.
type DirectoryVpcSettingsDescription struct {
	// The list of Availability Zones that the directory is in.
	AvailabilityZones []*string `type:"list"`

	// The security group identifier for the directory.
	SecurityGroupId *string `type:"string"`

	// The identifiers of the subnets for the directory servers.
	SubnetIds []*string `type:"list"`

	// The identifier of the VPC that the directory is in.
	VpcId *string `type:"string"`

	metadataDirectoryVpcSettingsDescription `json:"-" xml:"-"`
}

type metadataDirectoryVpcSettingsDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DirectoryVpcSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DirectoryVpcSettingsDescription) GoString() string {
	return s.String()
}

// Contains the inputs for the DisableRadius operation.
type DisableRadiusInput struct {
	// The identifier of the directory to disable MFA for.
	DirectoryId *string `type:"string" required:"true"`

	metadataDisableRadiusInput `json:"-" xml:"-"`
}

type metadataDisableRadiusInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRadiusInput) GoString() string {
	return s.String()
}

// Contains the results of the DisableRadius operation.
type DisableRadiusOutput struct {
	metadataDisableRadiusOutput `json:"-" xml:"-"`
}

type metadataDisableRadiusOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableRadiusOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the DisableSso operation.
type DisableSsoInput struct {
	// The identifier of the directory to disable single-sign on for.
	DirectoryId *string `type:"string" required:"true"`

	// The password of an alternate account to use to disable single-sign on. This
	// is only used for AD Connector directories. See the UserName parameter for
	// more information.
	Password *string `min:"1" type:"string"`

	// The username of an alternate account to use to disable single-sign on. This
	// is only used for AD Connector directories. This account must have privileges
	// to remove a service principle name.
	//
	// If the AD Connector service account does not have privileges to remove a
	// service principle name, you can specify an alternate account with the UserName
	// and Password parameters. These credentials are only used to disable single
	// sign-on and are not stored by the service. The AD Connector service account
	// is not changed.
	UserName *string `min:"1" type:"string"`

	metadataDisableSsoInput `json:"-" xml:"-"`
}

type metadataDisableSsoInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableSsoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSsoInput) GoString() string {
	return s.String()
}

// Contains the results of the DisableSso operation.
type DisableSsoOutput struct {
	metadataDisableSsoOutput `json:"-" xml:"-"`
}

type metadataDisableSsoOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableSsoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableSsoOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the EnableRadius operation.
type EnableRadiusInput struct {
	// The identifier of the directory to enable MFA for.
	DirectoryId *string `type:"string" required:"true"`

	// A RadiusSettings object that contains information about the RADIUS server.
	RadiusSettings *RadiusSettings `type:"structure" required:"true"`

	metadataEnableRadiusInput `json:"-" xml:"-"`
}

type metadataEnableRadiusInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRadiusInput) GoString() string {
	return s.String()
}

// Contains the results of the EnableRadius operation.
type EnableRadiusOutput struct {
	metadataEnableRadiusOutput `json:"-" xml:"-"`
}

type metadataEnableRadiusOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableRadiusOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the EnableSso operation.
type EnableSsoInput struct {
	// The identifier of the directory to enable single-sign on for.
	DirectoryId *string `type:"string" required:"true"`

	// The password of an alternate account to use to enable single-sign on. This
	// is only used for AD Connector directories. See the UserName parameter for
	// more information.
	Password *string `min:"1" type:"string"`

	// The username of an alternate account to use to enable single-sign on. This
	// is only used for AD Connector directories. This account must have privileges
	// to add a service principle name.
	//
	// If the AD Connector service account does not have privileges to add a service
	// principle name, you can specify an alternate account with the UserName and
	// Password parameters. These credentials are only used to enable single sign-on
	// and are not stored by the service. The AD Connector service account is not
	// changed.
	UserName *string `min:"1" type:"string"`

	metadataEnableSsoInput `json:"-" xml:"-"`
}

type metadataEnableSsoInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableSsoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSsoInput) GoString() string {
	return s.String()
}

// Contains the results of the EnableSso operation.
type EnableSsoOutput struct {
	metadataEnableSsoOutput `json:"-" xml:"-"`
}

type metadataEnableSsoOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableSsoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableSsoOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the GetDirectoryLimits operation.
type GetDirectoryLimitsInput struct {
	metadataGetDirectoryLimitsInput `json:"-" xml:"-"`
}

type metadataGetDirectoryLimitsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDirectoryLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDirectoryLimitsInput) GoString() string {
	return s.String()
}

// Contains the results of the GetDirectoryLimits operation.
type GetDirectoryLimitsOutput struct {
	// A DirectoryLimits object that contains the directory limits for the current
	// region.
	DirectoryLimits *DirectoryLimits `type:"structure"`

	metadataGetDirectoryLimitsOutput `json:"-" xml:"-"`
}

type metadataGetDirectoryLimitsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDirectoryLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDirectoryLimitsOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the GetSnapshotLimits operation.
type GetSnapshotLimitsInput struct {
	// Contains the identifier of the directory to obtain the limits for.
	DirectoryId *string `type:"string" required:"true"`

	metadataGetSnapshotLimitsInput `json:"-" xml:"-"`
}

type metadataGetSnapshotLimitsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSnapshotLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnapshotLimitsInput) GoString() string {
	return s.String()
}

// Contains the results of the GetSnapshotLimits operation.
type GetSnapshotLimitsOutput struct {
	// A SnapshotLimits object that contains the manual snapshot limits for the
	// specified directory.
	SnapshotLimits *SnapshotLimits `type:"structure"`

	metadataGetSnapshotLimitsOutput `json:"-" xml:"-"`
}

type metadataGetSnapshotLimitsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSnapshotLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSnapshotLimitsOutput) GoString() string {
	return s.String()
}

// Contains information about a Remote Authentication Dial In User Service (RADIUS)
// server.
type RadiusSettings struct {
	// The protocol specified for your RADIUS endpoints.
	AuthenticationProtocol *string `type:"string" enum:"RadiusAuthenticationProtocol"`

	// Not currently used.
	DisplayLabel *string `min:"1" type:"string"`

	// The port that your RADIUS server is using for communications. Your on-premises
	// network must allow inbound traffic over this port from the AWS Directory
	// Service servers.
	RadiusPort *int64 `min:"1025" type:"integer"`

	// The maximum number of times that communication with the RADIUS server is
	// attempted.
	RadiusRetries *int64 `type:"integer"`

	// An array of strings that contains the IP addresses of the RADIUS server endpoints,
	// or the IP addresses of your RADIUS server load balancer.
	RadiusServers []*string `type:"list"`

	// The amount of time, in seconds, to wait for the RADIUS server to respond.
	RadiusTimeout *int64 `min:"1" type:"integer"`

	// The shared secret code that was specified when your RADIUS endpoints were
	// created.
	SharedSecret *string `min:"8" type:"string"`

	// Not currently used.
	UseSameUsername *bool `type:"boolean"`

	metadataRadiusSettings `json:"-" xml:"-"`
}

type metadataRadiusSettings struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RadiusSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RadiusSettings) GoString() string {
	return s.String()
}

// An object representing the inputs for the RestoreFromSnapshot operation.
type RestoreFromSnapshotInput struct {
	// The identifier of the snapshot to restore from.
	SnapshotId *string `type:"string" required:"true"`

	metadataRestoreFromSnapshotInput `json:"-" xml:"-"`
}

type metadataRestoreFromSnapshotInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RestoreFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromSnapshotInput) GoString() string {
	return s.String()
}

// Contains the results of the RestoreFromSnapshot operation.
type RestoreFromSnapshotOutput struct {
	metadataRestoreFromSnapshotOutput `json:"-" xml:"-"`
}

type metadataRestoreFromSnapshotOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RestoreFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreFromSnapshotOutput) GoString() string {
	return s.String()
}

// Describes a directory snapshot.
type Snapshot struct {
	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The descriptive name of the snapshot.
	Name *string `type:"string"`

	// The snapshot identifier.
	SnapshotId *string `type:"string"`

	// The date and time that the snapshot was taken.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The snapshot status.
	Status *string `type:"string" enum:"SnapshotStatus"`

	// The snapshot type.
	Type *string `type:"string" enum:"SnapshotType"`

	metadataSnapshot `json:"-" xml:"-"`
}

type metadataSnapshot struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Snapshot) GoString() string {
	return s.String()
}

// Contains manual snapshot limit information for a directory.
type SnapshotLimits struct {
	// The current number of manual snapshots of the directory.
	ManualSnapshotsCurrentCount *int64 `type:"integer"`

	// The maximum number of manual snapshots allowed.
	ManualSnapshotsLimit *int64 `type:"integer"`

	// Indicates if the manual snapshot limit has been reached.
	ManualSnapshotsLimitReached *bool `type:"boolean"`

	metadataSnapshotLimits `json:"-" xml:"-"`
}

type metadataSnapshotLimits struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SnapshotLimits) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotLimits) GoString() string {
	return s.String()
}

// Contains the inputs for the UpdateRadius operation.
type UpdateRadiusInput struct {
	// The identifier of the directory to update the RADIUS server information for.
	DirectoryId *string `type:"string" required:"true"`

	// A RadiusSettings object that contains information about the RADIUS server.
	RadiusSettings *RadiusSettings `type:"structure" required:"true"`

	metadataUpdateRadiusInput `json:"-" xml:"-"`
}

type metadataUpdateRadiusInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateRadiusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRadiusInput) GoString() string {
	return s.String()
}

// Contains the results of the UpdateRadius operation.
type UpdateRadiusOutput struct {
	metadataUpdateRadiusOutput `json:"-" xml:"-"`
}

type metadataUpdateRadiusOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateRadiusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRadiusOutput) GoString() string {
	return s.String()
}

const (
	// @enum DirectorySize
	DirectorySizeSmall = "Small"
	// @enum DirectorySize
	DirectorySizeLarge = "Large"
)

const (
	// @enum DirectoryStage
	DirectoryStageRequested = "Requested"
	// @enum DirectoryStage
	DirectoryStageCreating = "Creating"
	// @enum DirectoryStage
	DirectoryStageCreated = "Created"
	// @enum DirectoryStage
	DirectoryStageActive = "Active"
	// @enum DirectoryStage
	DirectoryStageInoperable = "Inoperable"
	// @enum DirectoryStage
	DirectoryStageImpaired = "Impaired"
	// @enum DirectoryStage
	DirectoryStageRestoring = "Restoring"
	// @enum DirectoryStage
	DirectoryStageRestoreFailed = "RestoreFailed"
	// @enum DirectoryStage
	DirectoryStageDeleting = "Deleting"
	// @enum DirectoryStage
	DirectoryStageDeleted = "Deleted"
	// @enum DirectoryStage
	DirectoryStageFailed = "Failed"
)

const (
	// @enum DirectoryType
	DirectoryTypeSimpleAd = "SimpleAD"
	// @enum DirectoryType
	DirectoryTypeAdconnector = "ADConnector"
)

const (
	// @enum RadiusAuthenticationProtocol
	RadiusAuthenticationProtocolPap = "PAP"
	// @enum RadiusAuthenticationProtocol
	RadiusAuthenticationProtocolChap = "CHAP"
	// @enum RadiusAuthenticationProtocol
	RadiusAuthenticationProtocolMsChapv1 = "MS-CHAPv1"
	// @enum RadiusAuthenticationProtocol
	RadiusAuthenticationProtocolMsChapv2 = "MS-CHAPv2"
)

const (
	// @enum RadiusStatus
	RadiusStatusCreating = "Creating"
	// @enum RadiusStatus
	RadiusStatusCompleted = "Completed"
	// @enum RadiusStatus
	RadiusStatusFailed = "Failed"
)

const (
	// @enum SnapshotStatus
	SnapshotStatusCreating = "Creating"
	// @enum SnapshotStatus
	SnapshotStatusCompleted = "Completed"
	// @enum SnapshotStatus
	SnapshotStatusFailed = "Failed"
)

const (
	// @enum SnapshotType
	SnapshotTypeAuto = "Auto"
	// @enum SnapshotType
	SnapshotTypeManual = "Manual"
)
