// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package elasticbeanstalk provides a client for AWS Elastic Beanstalk.
package elasticbeanstalk

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAbortEnvironmentUpdate = "AbortEnvironmentUpdate"

// AbortEnvironmentUpdateRequest generates a request for the AbortEnvironmentUpdate operation.
func (c *ElasticBeanstalk) AbortEnvironmentUpdateRequest(input *AbortEnvironmentUpdateInput) (req *request.Request, output *AbortEnvironmentUpdateOutput) {
	op := &request.Operation{
		Name:       opAbortEnvironmentUpdate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AbortEnvironmentUpdateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AbortEnvironmentUpdateOutput{}
	req.Data = output
	return
}

// Cancels in-progress environment configuration update or application version
// deployment.
func (c *ElasticBeanstalk) AbortEnvironmentUpdate(input *AbortEnvironmentUpdateInput) (*AbortEnvironmentUpdateOutput, error) {
	req, out := c.AbortEnvironmentUpdateRequest(input)
	err := req.Send()
	return out, err
}

const opCheckDNSAvailability = "CheckDNSAvailability"

// CheckDNSAvailabilityRequest generates a request for the CheckDNSAvailability operation.
func (c *ElasticBeanstalk) CheckDNSAvailabilityRequest(input *CheckDNSAvailabilityInput) (req *request.Request, output *CheckDNSAvailabilityOutput) {
	op := &request.Operation{
		Name:       opCheckDNSAvailability,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CheckDNSAvailabilityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CheckDNSAvailabilityOutput{}
	req.Data = output
	return
}

// Checks if the specified CNAME is available.
func (c *ElasticBeanstalk) CheckDNSAvailability(input *CheckDNSAvailabilityInput) (*CheckDNSAvailabilityOutput, error) {
	req, out := c.CheckDNSAvailabilityRequest(input)
	err := req.Send()
	return out, err
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a request for the CreateApplication operation.
func (c *ElasticBeanstalk) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *ApplicationDescriptionMessage) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ApplicationDescriptionMessage{}
	req.Data = output
	return
}

// Creates an application that has one configuration template named default
// and no application versions.
func (c *ElasticBeanstalk) CreateApplication(input *CreateApplicationInput) (*ApplicationDescriptionMessage, error) {
	req, out := c.CreateApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateApplicationVersion = "CreateApplicationVersion"

// CreateApplicationVersionRequest generates a request for the CreateApplicationVersion operation.
func (c *ElasticBeanstalk) CreateApplicationVersionRequest(input *CreateApplicationVersionInput) (req *request.Request, output *ApplicationVersionDescriptionMessage) {
	op := &request.Operation{
		Name:       opCreateApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ApplicationVersionDescriptionMessage{}
	req.Data = output
	return
}

// Creates an application version for the specified application.
//
// Once you create an application version with a specified Amazon S3 bucket
// and key location, you cannot change that Amazon S3 location. If you change
// the Amazon S3 location, you receive an exception when you attempt to launch
// an environment from the application version.
func (c *ElasticBeanstalk) CreateApplicationVersion(input *CreateApplicationVersionInput) (*ApplicationVersionDescriptionMessage, error) {
	req, out := c.CreateApplicationVersionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateConfigurationTemplate = "CreateConfigurationTemplate"

// CreateConfigurationTemplateRequest generates a request for the CreateConfigurationTemplate operation.
func (c *ElasticBeanstalk) CreateConfigurationTemplateRequest(input *CreateConfigurationTemplateInput) (req *request.Request, output *ConfigurationSettingsDescription) {
	op := &request.Operation{
		Name:       opCreateConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationTemplateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConfigurationSettingsDescription{}
	req.Data = output
	return
}

// Creates a configuration template. Templates are associated with a specific
// application and are used to deploy different versions of the application
// with the same configuration settings.
//
// Related Topics
//
//   DescribeConfigurationOptions   DescribeConfigurationSettings   ListAvailableSolutionStacks
func (c *ElasticBeanstalk) CreateConfigurationTemplate(input *CreateConfigurationTemplateInput) (*ConfigurationSettingsDescription, error) {
	req, out := c.CreateConfigurationTemplateRequest(input)
	err := req.Send()
	return out, err
}

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a request for the CreateEnvironment operation.
func (c *ElasticBeanstalk) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *EnvironmentDescription) {
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnvironmentDescription{}
	req.Data = output
	return
}

// Launches an environment for the specified application using the specified
// configuration.
func (c *ElasticBeanstalk) CreateEnvironment(input *CreateEnvironmentInput) (*EnvironmentDescription, error) {
	req, out := c.CreateEnvironmentRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStorageLocation = "CreateStorageLocation"

// CreateStorageLocationRequest generates a request for the CreateStorageLocation operation.
func (c *ElasticBeanstalk) CreateStorageLocationRequest(input *CreateStorageLocationInput) (req *request.Request, output *CreateStorageLocationOutput) {
	op := &request.Operation{
		Name:       opCreateStorageLocation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStorageLocationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateStorageLocationOutput{}
	req.Data = output
	return
}

// Creates the Amazon S3 storage location for the account.
//
//  This location is used to store user log files.
func (c *ElasticBeanstalk) CreateStorageLocation(input *CreateStorageLocationInput) (*CreateStorageLocationOutput, error) {
	req, out := c.CreateStorageLocationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a request for the DeleteApplication operation.
func (c *ElasticBeanstalk) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteApplicationOutput{}
	req.Data = output
	return
}

// Deletes the specified application along with all associated versions and
// configurations. The application versions will not be deleted from your Amazon
// S3 bucket.
//
// You cannot delete an application that has a running environment.
func (c *ElasticBeanstalk) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteApplicationVersion = "DeleteApplicationVersion"

// DeleteApplicationVersionRequest generates a request for the DeleteApplicationVersion operation.
func (c *ElasticBeanstalk) DeleteApplicationVersionRequest(input *DeleteApplicationVersionInput) (req *request.Request, output *DeleteApplicationVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteApplicationVersionOutput{}
	req.Data = output
	return
}

// Deletes the specified version from the specified application.
//
// You cannot delete an application version that is associated with a running
// environment.
func (c *ElasticBeanstalk) DeleteApplicationVersion(input *DeleteApplicationVersionInput) (*DeleteApplicationVersionOutput, error) {
	req, out := c.DeleteApplicationVersionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteConfigurationTemplate = "DeleteConfigurationTemplate"

// DeleteConfigurationTemplateRequest generates a request for the DeleteConfigurationTemplate operation.
func (c *ElasticBeanstalk) DeleteConfigurationTemplateRequest(input *DeleteConfigurationTemplateInput) (req *request.Request, output *DeleteConfigurationTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConfigurationTemplateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteConfigurationTemplateOutput{}
	req.Data = output
	return
}

// Deletes the specified configuration template.
//
// When you launch an environment using a configuration template, the environment
// gets a copy of the template. You can delete or modify the environment's copy
// of the template without affecting the running environment.
func (c *ElasticBeanstalk) DeleteConfigurationTemplate(input *DeleteConfigurationTemplateInput) (*DeleteConfigurationTemplateOutput, error) {
	req, out := c.DeleteConfigurationTemplateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEnvironmentConfiguration = "DeleteEnvironmentConfiguration"

// DeleteEnvironmentConfigurationRequest generates a request for the DeleteEnvironmentConfiguration operation.
func (c *ElasticBeanstalk) DeleteEnvironmentConfigurationRequest(input *DeleteEnvironmentConfigurationInput) (req *request.Request, output *DeleteEnvironmentConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironmentConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteEnvironmentConfigurationOutput{}
	req.Data = output
	return
}

// Deletes the draft configuration associated with the running environment.
//
//  Updating a running environment with any configuration changes creates a
// draft configuration set. You can get the draft configuration using DescribeConfigurationSettings
// while the update is in progress or if the update fails. The DeploymentStatus
// for the draft configuration indicates whether the deployment is in process
// or has failed. The draft configuration remains in existence until it is deleted
// with this action.
func (c *ElasticBeanstalk) DeleteEnvironmentConfiguration(input *DeleteEnvironmentConfigurationInput) (*DeleteEnvironmentConfigurationOutput, error) {
	req, out := c.DeleteEnvironmentConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeApplicationVersions = "DescribeApplicationVersions"

// DescribeApplicationVersionsRequest generates a request for the DescribeApplicationVersions operation.
func (c *ElasticBeanstalk) DescribeApplicationVersionsRequest(input *DescribeApplicationVersionsInput) (req *request.Request, output *DescribeApplicationVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeApplicationVersionsOutput{}
	req.Data = output
	return
}

// Returns descriptions for existing application versions.
func (c *ElasticBeanstalk) DescribeApplicationVersions(input *DescribeApplicationVersionsInput) (*DescribeApplicationVersionsOutput, error) {
	req, out := c.DescribeApplicationVersionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeApplications = "DescribeApplications"

// DescribeApplicationsRequest generates a request for the DescribeApplications operation.
func (c *ElasticBeanstalk) DescribeApplicationsRequest(input *DescribeApplicationsInput) (req *request.Request, output *DescribeApplicationsOutput) {
	op := &request.Operation{
		Name:       opDescribeApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeApplicationsOutput{}
	req.Data = output
	return
}

// Returns the descriptions of existing applications.
func (c *ElasticBeanstalk) DescribeApplications(input *DescribeApplicationsInput) (*DescribeApplicationsOutput, error) {
	req, out := c.DescribeApplicationsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConfigurationOptions = "DescribeConfigurationOptions"

// DescribeConfigurationOptionsRequest generates a request for the DescribeConfigurationOptions operation.
func (c *ElasticBeanstalk) DescribeConfigurationOptionsRequest(input *DescribeConfigurationOptionsInput) (req *request.Request, output *DescribeConfigurationOptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationOptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationOptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeConfigurationOptionsOutput{}
	req.Data = output
	return
}

// Describes the configuration options that are used in a particular configuration
// template or environment, or that a specified solution stack defines. The
// description includes the values the options, their default values, and an
// indication of the required action on a running environment if an option value
// is changed.
func (c *ElasticBeanstalk) DescribeConfigurationOptions(input *DescribeConfigurationOptionsInput) (*DescribeConfigurationOptionsOutput, error) {
	req, out := c.DescribeConfigurationOptionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConfigurationSettings = "DescribeConfigurationSettings"

// DescribeConfigurationSettingsRequest generates a request for the DescribeConfigurationSettings operation.
func (c *ElasticBeanstalk) DescribeConfigurationSettingsRequest(input *DescribeConfigurationSettingsInput) (req *request.Request, output *DescribeConfigurationSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeConfigurationSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConfigurationSettingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeConfigurationSettingsOutput{}
	req.Data = output
	return
}

// Returns a description of the settings for the specified configuration set,
// that is, either a configuration template or the configuration set associated
// with a running environment.
//
//  When describing the settings for the configuration set associated with
// a running environment, it is possible to receive two sets of setting descriptions.
// One is the deployed configuration set, and the other is a draft configuration
// of an environment that is either in the process of deployment or that failed
// to deploy.
//
// Related Topics
//
//   DeleteEnvironmentConfiguration
func (c *ElasticBeanstalk) DescribeConfigurationSettings(input *DescribeConfigurationSettingsInput) (*DescribeConfigurationSettingsOutput, error) {
	req, out := c.DescribeConfigurationSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEnvironmentHealth = "DescribeEnvironmentHealth"

// DescribeEnvironmentHealthRequest generates a request for the DescribeEnvironmentHealth operation.
func (c *ElasticBeanstalk) DescribeEnvironmentHealthRequest(input *DescribeEnvironmentHealthInput) (req *request.Request, output *DescribeEnvironmentHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironmentHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentHealthInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEnvironmentHealthOutput{}
	req.Data = output
	return
}

// Returns information about the overall health of the specified environment.
// The DescribeEnvironmentHealth operation is only available with AWS Elastic
// Beanstalk Enhanced Health.
func (c *ElasticBeanstalk) DescribeEnvironmentHealth(input *DescribeEnvironmentHealthInput) (*DescribeEnvironmentHealthOutput, error) {
	req, out := c.DescribeEnvironmentHealthRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEnvironmentResources = "DescribeEnvironmentResources"

// DescribeEnvironmentResourcesRequest generates a request for the DescribeEnvironmentResources operation.
func (c *ElasticBeanstalk) DescribeEnvironmentResourcesRequest(input *DescribeEnvironmentResourcesInput) (req *request.Request, output *DescribeEnvironmentResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironmentResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentResourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEnvironmentResourcesOutput{}
	req.Data = output
	return
}

// Returns AWS resources for this environment.
func (c *ElasticBeanstalk) DescribeEnvironmentResources(input *DescribeEnvironmentResourcesInput) (*DescribeEnvironmentResourcesOutput, error) {
	req, out := c.DescribeEnvironmentResourcesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEnvironments = "DescribeEnvironments"

// DescribeEnvironmentsRequest generates a request for the DescribeEnvironments operation.
func (c *ElasticBeanstalk) DescribeEnvironmentsRequest(input *DescribeEnvironmentsInput) (req *request.Request, output *DescribeEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEnvironmentsOutput{}
	req.Data = output
	return
}

// Returns descriptions for existing environments.
func (c *ElasticBeanstalk) DescribeEnvironments(input *DescribeEnvironmentsInput) (*DescribeEnvironmentsOutput, error) {
	req, out := c.DescribeEnvironmentsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a request for the DescribeEvents operation.
func (c *ElasticBeanstalk) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEventsOutput{}
	req.Data = output
	return
}

// Returns list of event descriptions matching criteria up to the last 6 weeks.
//
//  This action returns the most recent 1,000 events from the specified NextToken.
func (c *ElasticBeanstalk) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	err := req.Send()
	return out, err
}

func (c *ElasticBeanstalk) DescribeEventsPages(input *DescribeEventsInput, fn func(p *DescribeEventsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEventsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEventsOutput), lastPage)
	})
}

const opDescribeInstancesHealth = "DescribeInstancesHealth"

// DescribeInstancesHealthRequest generates a request for the DescribeInstancesHealth operation.
func (c *ElasticBeanstalk) DescribeInstancesHealthRequest(input *DescribeInstancesHealthInput) (req *request.Request, output *DescribeInstancesHealthOutput) {
	op := &request.Operation{
		Name:       opDescribeInstancesHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancesHealthInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInstancesHealthOutput{}
	req.Data = output
	return
}

// Returns more detailed information about the health of the specified instances
// (for example, CPU utilization, load average, and causes). The DescribeInstancesHealth
// operation is only available with AWS Elastic Beanstalk Enhanced Health.
func (c *ElasticBeanstalk) DescribeInstancesHealth(input *DescribeInstancesHealthInput) (*DescribeInstancesHealthOutput, error) {
	req, out := c.DescribeInstancesHealthRequest(input)
	err := req.Send()
	return out, err
}

const opListAvailableSolutionStacks = "ListAvailableSolutionStacks"

// ListAvailableSolutionStacksRequest generates a request for the ListAvailableSolutionStacks operation.
func (c *ElasticBeanstalk) ListAvailableSolutionStacksRequest(input *ListAvailableSolutionStacksInput) (req *request.Request, output *ListAvailableSolutionStacksOutput) {
	op := &request.Operation{
		Name:       opListAvailableSolutionStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableSolutionStacksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAvailableSolutionStacksOutput{}
	req.Data = output
	return
}

// Returns a list of the available solution stack names.
func (c *ElasticBeanstalk) ListAvailableSolutionStacks(input *ListAvailableSolutionStacksInput) (*ListAvailableSolutionStacksOutput, error) {
	req, out := c.ListAvailableSolutionStacksRequest(input)
	err := req.Send()
	return out, err
}

const opRebuildEnvironment = "RebuildEnvironment"

// RebuildEnvironmentRequest generates a request for the RebuildEnvironment operation.
func (c *ElasticBeanstalk) RebuildEnvironmentRequest(input *RebuildEnvironmentInput) (req *request.Request, output *RebuildEnvironmentOutput) {
	op := &request.Operation{
		Name:       opRebuildEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebuildEnvironmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RebuildEnvironmentOutput{}
	req.Data = output
	return
}

// Deletes and recreates all of the AWS resources (for example: the Auto Scaling
// group, load balancer, etc.) for a specified environment and forces a restart.
func (c *ElasticBeanstalk) RebuildEnvironment(input *RebuildEnvironmentInput) (*RebuildEnvironmentOutput, error) {
	req, out := c.RebuildEnvironmentRequest(input)
	err := req.Send()
	return out, err
}

const opRequestEnvironmentInfo = "RequestEnvironmentInfo"

// RequestEnvironmentInfoRequest generates a request for the RequestEnvironmentInfo operation.
func (c *ElasticBeanstalk) RequestEnvironmentInfoRequest(input *RequestEnvironmentInfoInput) (req *request.Request, output *RequestEnvironmentInfoOutput) {
	op := &request.Operation{
		Name:       opRequestEnvironmentInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RequestEnvironmentInfoInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RequestEnvironmentInfoOutput{}
	req.Data = output
	return
}

// Initiates a request to compile the specified type of information of the deployed
// environment.
//
//  Setting the InfoType to tail compiles the last lines from the application
// server log files of every Amazon EC2 instance in your environment.
//
//  Setting the InfoType to bundle compresses the application server log files
// for every Amazon EC2 instance into a .zip file. Legacy and .NET containers
// do not support bundle logs.
//
//  Use RetrieveEnvironmentInfo to obtain the set of logs.
//
// Related Topics
//
//   RetrieveEnvironmentInfo
func (c *ElasticBeanstalk) RequestEnvironmentInfo(input *RequestEnvironmentInfoInput) (*RequestEnvironmentInfoOutput, error) {
	req, out := c.RequestEnvironmentInfoRequest(input)
	err := req.Send()
	return out, err
}

const opRestartAppServer = "RestartAppServer"

// RestartAppServerRequest generates a request for the RestartAppServer operation.
func (c *ElasticBeanstalk) RestartAppServerRequest(input *RestartAppServerInput) (req *request.Request, output *RestartAppServerOutput) {
	op := &request.Operation{
		Name:       opRestartAppServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestartAppServerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RestartAppServerOutput{}
	req.Data = output
	return
}

// Causes the environment to restart the application container server running
// on each Amazon EC2 instance.
func (c *ElasticBeanstalk) RestartAppServer(input *RestartAppServerInput) (*RestartAppServerOutput, error) {
	req, out := c.RestartAppServerRequest(input)
	err := req.Send()
	return out, err
}

const opRetrieveEnvironmentInfo = "RetrieveEnvironmentInfo"

// RetrieveEnvironmentInfoRequest generates a request for the RetrieveEnvironmentInfo operation.
func (c *ElasticBeanstalk) RetrieveEnvironmentInfoRequest(input *RetrieveEnvironmentInfoInput) (req *request.Request, output *RetrieveEnvironmentInfoOutput) {
	op := &request.Operation{
		Name:       opRetrieveEnvironmentInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetrieveEnvironmentInfoInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RetrieveEnvironmentInfoOutput{}
	req.Data = output
	return
}

// Retrieves the compiled information from a RequestEnvironmentInfo request.
//
// Related Topics
//
//   RequestEnvironmentInfo
func (c *ElasticBeanstalk) RetrieveEnvironmentInfo(input *RetrieveEnvironmentInfoInput) (*RetrieveEnvironmentInfoOutput, error) {
	req, out := c.RetrieveEnvironmentInfoRequest(input)
	err := req.Send()
	return out, err
}

const opSwapEnvironmentCNAMEs = "SwapEnvironmentCNAMEs"

// SwapEnvironmentCNAMEsRequest generates a request for the SwapEnvironmentCNAMEs operation.
func (c *ElasticBeanstalk) SwapEnvironmentCNAMEsRequest(input *SwapEnvironmentCNAMEsInput) (req *request.Request, output *SwapEnvironmentCNAMEsOutput) {
	op := &request.Operation{
		Name:       opSwapEnvironmentCNAMEs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SwapEnvironmentCNAMEsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SwapEnvironmentCNAMEsOutput{}
	req.Data = output
	return
}

// Swaps the CNAMEs of two environments.
func (c *ElasticBeanstalk) SwapEnvironmentCNAMEs(input *SwapEnvironmentCNAMEsInput) (*SwapEnvironmentCNAMEsOutput, error) {
	req, out := c.SwapEnvironmentCNAMEsRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateEnvironment = "TerminateEnvironment"

// TerminateEnvironmentRequest generates a request for the TerminateEnvironment operation.
func (c *ElasticBeanstalk) TerminateEnvironmentRequest(input *TerminateEnvironmentInput) (req *request.Request, output *EnvironmentDescription) {
	op := &request.Operation{
		Name:       opTerminateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateEnvironmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnvironmentDescription{}
	req.Data = output
	return
}

// Terminates the specified environment.
func (c *ElasticBeanstalk) TerminateEnvironment(input *TerminateEnvironmentInput) (*EnvironmentDescription, error) {
	req, out := c.TerminateEnvironmentRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a request for the UpdateApplication operation.
func (c *ElasticBeanstalk) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *ApplicationDescriptionMessage) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ApplicationDescriptionMessage{}
	req.Data = output
	return
}

// Updates the specified application to have the specified properties.
//
//  If a property (for example, description) is not provided, the value remains
// unchanged. To clear these properties, specify an empty string.
func (c *ElasticBeanstalk) UpdateApplication(input *UpdateApplicationInput) (*ApplicationDescriptionMessage, error) {
	req, out := c.UpdateApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateApplicationVersion = "UpdateApplicationVersion"

// UpdateApplicationVersionRequest generates a request for the UpdateApplicationVersion operation.
func (c *ElasticBeanstalk) UpdateApplicationVersionRequest(input *UpdateApplicationVersionInput) (req *request.Request, output *ApplicationVersionDescriptionMessage) {
	op := &request.Operation{
		Name:       opUpdateApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationVersionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ApplicationVersionDescriptionMessage{}
	req.Data = output
	return
}

// Updates the specified application version to have the specified properties.
//
//  If a property (for example, description) is not provided, the value remains
// unchanged. To clear properties, specify an empty string.
func (c *ElasticBeanstalk) UpdateApplicationVersion(input *UpdateApplicationVersionInput) (*ApplicationVersionDescriptionMessage, error) {
	req, out := c.UpdateApplicationVersionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateConfigurationTemplate = "UpdateConfigurationTemplate"

// UpdateConfigurationTemplateRequest generates a request for the UpdateConfigurationTemplate operation.
func (c *ElasticBeanstalk) UpdateConfigurationTemplateRequest(input *UpdateConfigurationTemplateInput) (req *request.Request, output *ConfigurationSettingsDescription) {
	op := &request.Operation{
		Name:       opUpdateConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConfigurationTemplateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConfigurationSettingsDescription{}
	req.Data = output
	return
}

// Updates the specified configuration template to have the specified properties
// or configuration option values.
//
//  If a property (for example, ApplicationName) is not provided, its value
// remains unchanged. To clear such properties, specify an empty string.  Related
// Topics
//
//   DescribeConfigurationOptions
func (c *ElasticBeanstalk) UpdateConfigurationTemplate(input *UpdateConfigurationTemplateInput) (*ConfigurationSettingsDescription, error) {
	req, out := c.UpdateConfigurationTemplateRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a request for the UpdateEnvironment operation.
func (c *ElasticBeanstalk) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *EnvironmentDescription) {
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnvironmentDescription{}
	req.Data = output
	return
}

// Updates the environment description, deploys a new application version, updates
// the configuration settings to an entirely new configuration template, or
// updates select configuration option values in the running environment.
//
//  Attempting to update both the release and configuration is not allowed
// and AWS Elastic Beanstalk returns an InvalidParameterCombination error.
//
//  When updating the configuration settings to a new template or individual
// settings, a draft configuration is created and DescribeConfigurationSettings
// for this environment returns two setting descriptions with different DeploymentStatus
// values.
func (c *ElasticBeanstalk) UpdateEnvironment(input *UpdateEnvironmentInput) (*EnvironmentDescription, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	err := req.Send()
	return out, err
}

const opValidateConfigurationSettings = "ValidateConfigurationSettings"

// ValidateConfigurationSettingsRequest generates a request for the ValidateConfigurationSettings operation.
func (c *ElasticBeanstalk) ValidateConfigurationSettingsRequest(input *ValidateConfigurationSettingsInput) (req *request.Request, output *ValidateConfigurationSettingsOutput) {
	op := &request.Operation{
		Name:       opValidateConfigurationSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateConfigurationSettingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ValidateConfigurationSettingsOutput{}
	req.Data = output
	return
}

// Takes a set of configuration settings and either a configuration template
// or environment, and determines whether those values are valid.
//
//  This action returns a list of messages indicating any errors or warnings
// associated with the selection of option values.
func (c *ElasticBeanstalk) ValidateConfigurationSettings(input *ValidateConfigurationSettingsInput) (*ValidateConfigurationSettingsOutput, error) {
	req, out := c.ValidateConfigurationSettingsRequest(input)
	err := req.Send()
	return out, err
}

type AbortEnvironmentUpdateInput struct {
	// This specifies the ID of the environment with the in-progress update that
	// you want to cancel.
	EnvironmentId *string `type:"string"`

	// This specifies the name of the environment with the in-progress update that
	// you want to cancel.
	EnvironmentName *string `min:"4" type:"string"`

	metadataAbortEnvironmentUpdateInput `json:"-" xml:"-"`
}

type metadataAbortEnvironmentUpdateInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AbortEnvironmentUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortEnvironmentUpdateInput) GoString() string {
	return s.String()
}

type AbortEnvironmentUpdateOutput struct {
	metadataAbortEnvironmentUpdateOutput `json:"-" xml:"-"`
}

type metadataAbortEnvironmentUpdateOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AbortEnvironmentUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortEnvironmentUpdateOutput) GoString() string {
	return s.String()
}

// Describes the properties of an application.
type ApplicationDescription struct {
	// The name of the application.
	ApplicationName *string `min:"1" type:"string"`

	// The names of the configuration templates associated with this application.
	ConfigurationTemplates []*string `type:"list"`

	// The date when the application was created.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date when the application was last modified.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// User-defined description of the application.
	Description *string `type:"string"`

	// The names of the versions for this application.
	Versions []*string `type:"list"`

	metadataApplicationDescription `json:"-" xml:"-"`
}

type metadataApplicationDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ApplicationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationDescription) GoString() string {
	return s.String()
}

// Result message containing a single description of an application.
type ApplicationDescriptionMessage struct {
	// The ApplicationDescription of the application.
	Application *ApplicationDescription `type:"structure"`

	metadataApplicationDescriptionMessage `json:"-" xml:"-"`
}

type metadataApplicationDescriptionMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ApplicationDescriptionMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationDescriptionMessage) GoString() string {
	return s.String()
}

// Represents the application metrics for a specified environment.
type ApplicationMetrics struct {
	// The amount of time that the metrics cover (usually 10 seconds). For example,
	// you might have 5 requests (request_count) within the most recent time slice
	// of 10 seconds (duration).
	Duration *int64 `type:"integer"`

	// Represents the average latency for the slowest X percent of requests over
	// the last 10 seconds. Latencies are in seconds with one milisecond resolution.
	Latency *Latency `type:"structure"`

	// Average number of requests handled by the web server per second over the
	// last 10 seconds.
	RequestCount *int64 `type:"integer"`

	// Represents the percentage of requests over the last 10 seconds that resulted
	// in each type of status code response.
	StatusCodes *StatusCodes `type:"structure"`

	metadataApplicationMetrics `json:"-" xml:"-"`
}

type metadataApplicationMetrics struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ApplicationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationMetrics) GoString() string {
	return s.String()
}

// Describes the properties of an application version.
type ApplicationVersionDescription struct {
	// The name of the application associated with this release.
	ApplicationName *string `min:"1" type:"string"`

	// The creation date of the application version.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The last modified date of the application version.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The description of this application version.
	Description *string `type:"string"`

	// The location where the source bundle is located for this version.
	SourceBundle *S3Location `type:"structure"`

	// A label uniquely identifying the version for the associated application.
	VersionLabel *string `min:"1" type:"string"`

	metadataApplicationVersionDescription `json:"-" xml:"-"`
}

type metadataApplicationVersionDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ApplicationVersionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationVersionDescription) GoString() string {
	return s.String()
}

// Result message wrapping a single description of an application version.
type ApplicationVersionDescriptionMessage struct {
	// The ApplicationVersionDescription of the application version.
	ApplicationVersion *ApplicationVersionDescription `type:"structure"`

	metadataApplicationVersionDescriptionMessage `json:"-" xml:"-"`
}

type metadataApplicationVersionDescriptionMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ApplicationVersionDescriptionMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationVersionDescriptionMessage) GoString() string {
	return s.String()
}

// Describes an Auto Scaling launch configuration.
type AutoScalingGroup struct {
	// The name of the AutoScalingGroup .
	Name *string `type:"string"`

	metadataAutoScalingGroup `json:"-" xml:"-"`
}

type metadataAutoScalingGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingGroup) GoString() string {
	return s.String()
}

// Represents CPU utilization information from the specified instance that belongs
// to the AWS Elastic Beanstalk environment. Use the instanceId property to
// specify the application instance for which you'd like to return data.
type CPUUtilization struct {
	// Percentage of time that the CPU has spent in the I/O Wait state over the
	// last 10 seconds.
	IOWait *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the IRQ state over the last
	// 10 seconds.
	IRQ *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the Idle state over the last
	// 10 seconds.
	Idle *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the Nice state over the last
	// 10 seconds.
	Nice *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the SoftIRQ state over the last
	// 10 seconds.
	SoftIRQ *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the System state over the last
	// 10 seconds.
	System *float64 `type:"double"`

	// Percentage of time that the CPU has spent in the User state over the last
	// 10 seconds.
	User *float64 `type:"double"`

	metadataCPUUtilization `json:"-" xml:"-"`
}

type metadataCPUUtilization struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CPUUtilization) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CPUUtilization) GoString() string {
	return s.String()
}

// Results message indicating whether a CNAME is available.
type CheckDNSAvailabilityInput struct {
	// The prefix used when this CNAME is reserved.
	CNAMEPrefix *string `min:"4" type:"string" required:"true"`

	metadataCheckDNSAvailabilityInput `json:"-" xml:"-"`
}

type metadataCheckDNSAvailabilityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CheckDNSAvailabilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckDNSAvailabilityInput) GoString() string {
	return s.String()
}

// Indicates if the specified CNAME is available.
type CheckDNSAvailabilityOutput struct {
	// Indicates if the specified CNAME is available:
	//
	//    true : The CNAME is available.
	//
	//    true : The CNAME is not available.
	//
	//      true : The CNAME is available.   false : The CNAME is not available.
	Available *bool `type:"boolean"`

	// The fully qualified CNAME to reserve when CreateEnvironment is called with
	// the provided prefix.
	FullyQualifiedCNAME *string `min:"1" type:"string"`

	metadataCheckDNSAvailabilityOutput `json:"-" xml:"-"`
}

type metadataCheckDNSAvailabilityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CheckDNSAvailabilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CheckDNSAvailabilityOutput) GoString() string {
	return s.String()
}

// Describes the possible values for a configuration option.
type ConfigurationOptionDescription struct {
	// An indication of which action is required if the value for this configuration
	// option changes:
	//
	//    NoInterruption - There is no interruption to the environment or application
	// availability.
	//
	//    RestartEnvironment - The environment is restarted, all AWS resources
	// are deleted and recreated, and the environment is unavailable during the
	// process.
	//
	//    RestartApplicationServer - The environment is available the entire time.
	// However, a short application outage occurs when the application servers on
	// the running Amazon EC2 instances are restarted.
	//
	//     NoInterruption : There is no interruption to the environment or application
	// availability.   RestartEnvironment : The environment is entirely restarted,
	// all AWS resources are deleted and recreated, and the environment is unavailable
	// during the process.   RestartApplicationServer : The environment is available
	// the entire time. However, a short application outage occurs when the application
	// servers on the running Amazon EC2 instances are restarted.
	ChangeSeverity *string `type:"string"`

	// The default value for this configuration option.
	DefaultValue *string `type:"string"`

	// If specified, the configuration option must be a string value no longer than
	// this value.
	MaxLength *int64 `type:"integer"`

	// If specified, the configuration option must be a numeric value less than
	// this value.
	MaxValue *int64 `type:"integer"`

	// If specified, the configuration option must be a numeric value greater than
	// this value.
	MinValue *int64 `type:"integer"`

	// The name of the configuration option.
	Name *string `type:"string"`

	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string `type:"string"`

	// If specified, the configuration option must be a string value that satisfies
	// this regular expression.
	Regex *OptionRestrictionRegex `type:"structure"`

	// An indication of whether the user defined this configuration option:
	//
	//    true : This configuration option was defined by the user. It is a valid
	// choice for specifying this as an Option to Remove when updating configuration
	// settings.
	//
	//    false : This configuration was not defined by the user.
	//
	//      true : This configuration option was defined by the user. It is a valid
	// choice for specifying if this as an Option to Remove when updating configuration
	// settings.
	//
	//   false : This configuration was not defined by the user.    Constraint:
	// You can remove only UserDefined options from a configuration.
	//
	//  Valid Values: true | false
	UserDefined *bool `type:"boolean"`

	// If specified, values for the configuration option are selected from this
	// list.
	ValueOptions []*string `type:"list"`

	// An indication of which type of values this option has and whether it is allowable
	// to select one or more than one of the possible values:
	//
	//    Scalar : Values for this option are a single selection from the possible
	// values, or a unformatted string or numeric value governed by the MIN/MAX/Regex
	// constraints:
	//
	//    List : Values for this option are multiple selections of the possible
	// values.
	//
	//    Boolean : Values for this option are either true or false .
	//
	//    Json : Values for this option are a JSON representation of a ConfigDocument.
	//
	//      Scalar : Values for this option are a single selection from the possible
	// values, or an unformatted string, or numeric value governed by the MIN/MAX/Regex
	// constraints.   List : Values for this option are multiple selections from
	// the possible values.   Boolean : Values for this option are either true or
	// false .   Json : Values for this option are a JSON representation of a ConfigDocument.
	ValueType *string `type:"string" enum:"ConfigurationOptionValueType"`

	metadataConfigurationOptionDescription `json:"-" xml:"-"`
}

type metadataConfigurationOptionDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfigurationOptionDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationOptionDescription) GoString() string {
	return s.String()
}

// A specification identifying an individual configuration option along with
// its current value. For a list of possible option values, go to Option Values
// (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html)
// in the AWS Elastic Beanstalk Developer Guide.
type ConfigurationOptionSetting struct {
	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string `type:"string"`

	// The name of the configuration option.
	OptionName *string `type:"string"`

	// A unique resource name for a time-based scaling configuration option.
	ResourceName *string `min:"1" type:"string"`

	// The current value for the configuration option.
	Value *string `type:"string"`

	metadataConfigurationOptionSetting `json:"-" xml:"-"`
}

type metadataConfigurationOptionSetting struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfigurationOptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationOptionSetting) GoString() string {
	return s.String()
}

// Describes the settings for a configuration set.
type ConfigurationSettingsDescription struct {
	// The name of the application associated with this configuration set.
	ApplicationName *string `min:"1" type:"string"`

	// The date (in UTC time) when this configuration set was created.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date (in UTC time) when this configuration set was last modified.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// If this configuration set is associated with an environment, the DeploymentStatus
	// parameter indicates the deployment status of this configuration set:
	//
	//    null: This configuration is not associated with a running environment.
	//
	//    pending: This is a draft configuration that is not deployed to the associated
	// environment but is in the process of deploying.
	//
	//    deployed: This is the configuration that is currently deployed to the
	// associated running environment.
	//
	//    failed: This is a draft configuration, that failed to successfully deploy.
	//
	//     null: This configuration is not associated with a running environment.
	//   pending: This is a draft configuration that is not deployed to the associated
	// environment but is in the process of deploying.   deployed: This is the configuration
	// that is currently deployed to the associated running environment.   failed:
	// This is a draft configuration that failed to successfully deploy.
	DeploymentStatus *string `type:"string" enum:"ConfigurationDeploymentStatus"`

	// Describes this configuration set.
	Description *string `type:"string"`

	// If not null, the name of the environment for this configuration set.
	EnvironmentName *string `min:"4" type:"string"`

	// A list of the configuration options and their values in this configuration
	// set.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// The name of the solution stack this configuration set uses.
	SolutionStackName *string `type:"string"`

	// If not null, the name of the configuration template for this configuration
	// set.
	TemplateName *string `min:"1" type:"string"`

	metadataConfigurationSettingsDescription `json:"-" xml:"-"`
}

type metadataConfigurationSettingsDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfigurationSettingsDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigurationSettingsDescription) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type CreateApplicationInput struct {
	// The name of the application.
	//
	//  Constraint: This name must be unique within your account. If the specified
	// name already exists, the action returns an InvalidParameterValue error.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Describes the application.
	Description *string `type:"string"`

	metadataCreateApplicationInput `json:"-" xml:"-"`
}

type metadataCreateApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

type CreateApplicationVersionInput struct {
	// The name of the application. If no application is found with this name, and
	// AutoCreateApplication is false, returns an InvalidParameterValue error.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Determines how the system behaves if the specified application for this version
	// does not already exist:
	//
	//    true: Automatically creates the specified application for this version
	// if it does not already exist.
	//
	//    false: Returns an InvalidParameterValue if the specified application
	// for this version does not already exist.
	//
	//     true : Automatically creates the specified application for this release
	// if it does not already exist.   false : Throws an InvalidParameterValue if
	// the specified application for this release does not already exist.    Default:
	// false
	//
	//  Valid Values: true | false
	AutoCreateApplication *bool `type:"boolean"`

	// Describes this version.
	Description *string `type:"string"`

	// The Amazon S3 bucket and key that identify the location of the source bundle
	// for this version.
	//
	//  If data found at the Amazon S3 location exceeds the maximum allowed source
	// bundle size, AWS Elastic Beanstalk returns an InvalidParameterValue error.
	// The maximum size allowed is 512 MB.
	//
	// Default: If not specified, AWS Elastic Beanstalk uses a sample application.
	// If only partially specified (for example, a bucket is provided but not the
	// key) or if no data is found at the Amazon S3 location, AWS Elastic Beanstalk
	// returns an InvalidParameterCombination error.
	SourceBundle *S3Location `type:"structure"`

	// A label identifying this version.
	//
	// Constraint: Must be unique per application. If an application version already
	// exists with this label for the specified application, AWS Elastic Beanstalk
	// returns an InvalidParameterValue error.
	VersionLabel *string `min:"1" type:"string" required:"true"`

	metadataCreateApplicationVersionInput `json:"-" xml:"-"`
}

type metadataCreateApplicationVersionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationVersionInput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type CreateConfigurationTemplateInput struct {
	// The name of the application to associate with this configuration template.
	// If no application is found with this name, AWS Elastic Beanstalk returns
	// an InvalidParameterValue error.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Describes this configuration.
	Description *string `type:"string"`

	// The ID of the environment used with this configuration template.
	EnvironmentId *string `type:"string"`

	// If specified, AWS Elastic Beanstalk sets the specified configuration option
	// to the requested value. The new value overrides the value obtained from the
	// solution stack or the source configuration template.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// The name of the solution stack used by this configuration. The solution stack
	// specifies the operating system, architecture, and application server for
	// a configuration template. It determines the set of configuration options
	// as well as the possible and default values.
	//
	//  Use ListAvailableSolutionStacks to obtain a list of available solution
	// stacks.
	//
	//  A solution stack name or a source configuration parameter must be specified,
	// otherwise AWS Elastic Beanstalk returns an InvalidParameterValue error.
	//
	//  If a solution stack name is not specified and the source configuration
	// parameter is specified, AWS Elastic Beanstalk uses the same solution stack
	// as the source configuration template.
	SolutionStackName *string `type:"string"`

	// If specified, AWS Elastic Beanstalk uses the configuration values from the
	// specified configuration template to create a new configuration.
	//
	//  Values specified in the OptionSettings parameter of this call overrides
	// any values obtained from the SourceConfiguration.
	//
	//  If no configuration template is found, returns an InvalidParameterValue
	// error.
	//
	//  Constraint: If both the solution stack name parameter and the source configuration
	// parameters are specified, the solution stack of the source configuration
	// template must match the specified solution stack name or else AWS Elastic
	// Beanstalk returns an InvalidParameterCombination error.
	SourceConfiguration *SourceConfiguration `type:"structure"`

	// The name of the configuration template.
	//
	// Constraint: This name must be unique per application.
	//
	// Default: If a configuration template already exists with this name, AWS
	// Elastic Beanstalk returns an InvalidParameterValue error.
	TemplateName *string `min:"1" type:"string" required:"true"`

	metadataCreateConfigurationTemplateInput `json:"-" xml:"-"`
}

type metadataCreateConfigurationTemplateInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConfigurationTemplateInput) GoString() string {
	return s.String()
}

type CreateEnvironmentInput struct {
	// The name of the application that contains the version to be deployed.
	//
	//  If no application is found with this name, CreateEnvironment returns an
	// InvalidParameterValue error.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// If specified, the environment attempts to use this value as the prefix for
	// the CNAME. If not specified, the CNAME is generated automatically by appending
	// a random alphanumeric string to the environment name.
	CNAMEPrefix *string `min:"4" type:"string"`

	// Describes this environment.
	Description *string `type:"string"`

	// A unique name for the deployment environment. Used in the application URL.
	//
	// Constraint: Must be from 4 to 23 characters in length. The name can contain
	// only letters, numbers, and hyphens. It cannot start or end with a hyphen.
	// This name must be unique in your account. If the specified name already exists,
	// AWS Elastic Beanstalk returns an InvalidParameterValue error.
	//
	// Default: If the CNAME parameter is not specified, the environment name becomes
	// part of the CNAME, and therefore part of the visible URL for your application.
	EnvironmentName *string `min:"4" type:"string" required:"true"`

	// If specified, AWS Elastic Beanstalk sets the specified configuration options
	// to the requested value in the configuration set for the new environment.
	// These override the values obtained from the solution stack or the configuration
	// template.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// A list of custom user-defined configuration options to remove from the configuration
	// set for this new environment.
	OptionsToRemove []*OptionSpecification `type:"list"`

	// This is an alternative to specifying a template name. If specified, AWS Elastic
	// Beanstalk sets the configuration values to the default values associated
	// with the specified solution stack.
	//
	//  Condition: You must specify either this or a TemplateName, but not both.
	// If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination
	// error. If you do not specify either, AWS Elastic Beanstalk returns a MissingRequiredParameter
	// error.
	SolutionStackName *string `type:"string"`

	// This specifies the tags applied to resources in the environment.
	Tags []*Tag `type:"list"`

	// The name of the configuration template to use in deployment. If no configuration
	// template is found with this name, AWS Elastic Beanstalk returns an InvalidParameterValue
	// error.
	//
	//  Condition: You must specify either this parameter or a SolutionStackName,
	// but not both. If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination
	// error. If you do not specify either, AWS Elastic Beanstalk returns a MissingRequiredParameter
	// error.
	TemplateName *string `min:"1" type:"string"`

	// This specifies the tier to use for creating this environment.
	Tier *EnvironmentTier `type:"structure"`

	// The name of the application version to deploy.
	//
	//  If the specified application has no associated application versions, AWS
	// Elastic Beanstalk UpdateEnvironment returns an InvalidParameterValue error.
	//
	//  Default: If not specified, AWS Elastic Beanstalk attempts to launch the
	// sample application in the container.
	VersionLabel *string `min:"1" type:"string"`

	metadataCreateEnvironmentInput `json:"-" xml:"-"`
}

type metadataCreateEnvironmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

type CreateStorageLocationInput struct {
	metadataCreateStorageLocationInput `json:"-" xml:"-"`
}

type metadataCreateStorageLocationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateStorageLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorageLocationInput) GoString() string {
	return s.String()
}

// Results of a CreateStorageLocationResult call.
type CreateStorageLocationOutput struct {
	// The name of the Amazon S3 bucket created.
	S3Bucket *string `type:"string"`

	metadataCreateStorageLocationOutput `json:"-" xml:"-"`
}

type metadataCreateStorageLocationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateStorageLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStorageLocationOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type DeleteApplicationInput struct {
	// The name of the application to delete.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// When set to true, running environments will be terminated before deleting
	// the application.
	TerminateEnvByForce *bool `type:"boolean"`

	metadataDeleteApplicationInput `json:"-" xml:"-"`
}

type metadataDeleteApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

type DeleteApplicationOutput struct {
	metadataDeleteApplicationOutput `json:"-" xml:"-"`
}

type metadataDeleteApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type DeleteApplicationVersionInput struct {
	// The name of the application to delete releases from.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Indicates whether to delete the associated source bundle from Amazon S3:
	//
	//   true: An attempt is made to delete the associated Amazon S3 source bundle
	// specified at time of creation.   false: No action is taken on the Amazon
	// S3 source bundle specified at time of creation.    Valid Values: true | false
	DeleteSourceBundle *bool `type:"boolean"`

	// The label of the version to delete.
	VersionLabel *string `min:"1" type:"string" required:"true"`

	metadataDeleteApplicationVersionInput `json:"-" xml:"-"`
}

type metadataDeleteApplicationVersionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationVersionInput) GoString() string {
	return s.String()
}

type DeleteApplicationVersionOutput struct {
	metadataDeleteApplicationVersionOutput `json:"-" xml:"-"`
}

type metadataDeleteApplicationVersionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationVersionOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type DeleteConfigurationTemplateInput struct {
	// The name of the application to delete the configuration template from.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the configuration template to delete.
	TemplateName *string `min:"1" type:"string" required:"true"`

	metadataDeleteConfigurationTemplateInput `json:"-" xml:"-"`
}

type metadataDeleteConfigurationTemplateInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationTemplateInput) GoString() string {
	return s.String()
}

type DeleteConfigurationTemplateOutput struct {
	metadataDeleteConfigurationTemplateOutput `json:"-" xml:"-"`
}

type metadataDeleteConfigurationTemplateOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConfigurationTemplateOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type DeleteEnvironmentConfigurationInput struct {
	// The name of the application the environment is associated with.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the environment to delete the draft configuration from.
	EnvironmentName *string `min:"4" type:"string" required:"true"`

	metadataDeleteEnvironmentConfigurationInput `json:"-" xml:"-"`
}

type metadataDeleteEnvironmentConfigurationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteEnvironmentConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentConfigurationInput) GoString() string {
	return s.String()
}

type DeleteEnvironmentConfigurationOutput struct {
	metadataDeleteEnvironmentConfigurationOutput `json:"-" xml:"-"`
}

type metadataDeleteEnvironmentConfigurationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteEnvironmentConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentConfigurationOutput) GoString() string {
	return s.String()
}

// Result message containing a list of configuration descriptions.
type DescribeApplicationVersionsInput struct {
	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// only include ones that are associated with the specified application.
	ApplicationName *string `min:"1" type:"string"`

	// If specified, restricts the returned descriptions to only include ones that
	// have the specified version labels.
	VersionLabels []*string `type:"list"`

	metadataDescribeApplicationVersionsInput `json:"-" xml:"-"`
}

type metadataDescribeApplicationVersionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeApplicationVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationVersionsInput) GoString() string {
	return s.String()
}

// Result message wrapping a list of application version descriptions.
type DescribeApplicationVersionsOutput struct {
	// A list of ApplicationVersionDescription .
	ApplicationVersions []*ApplicationVersionDescription `type:"list"`

	metadataDescribeApplicationVersionsOutput `json:"-" xml:"-"`
}

type metadataDescribeApplicationVersionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeApplicationVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationVersionsOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type DescribeApplicationsInput struct {
	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// only include those with the specified names.
	ApplicationNames []*string `type:"list"`

	metadataDescribeApplicationsInput `json:"-" xml:"-"`
}

type metadataDescribeApplicationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationsInput) GoString() string {
	return s.String()
}

// Result message containing a list of application descriptions.
type DescribeApplicationsOutput struct {
	// This parameter contains a list of ApplicationDescription.
	Applications []*ApplicationDescription `type:"list"`

	metadataDescribeApplicationsOutput `json:"-" xml:"-"`
}

type metadataDescribeApplicationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationsOutput) GoString() string {
	return s.String()
}

// Result message containig a list of application version descriptions.
type DescribeConfigurationOptionsInput struct {
	// The name of the application associated with the configuration template or
	// environment. Only needed if you want to describe the configuration options
	// associated with either the configuration template or environment.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the environment whose configuration options you want to describe.
	EnvironmentName *string `min:"4" type:"string"`

	// If specified, restricts the descriptions to only the specified options.
	Options []*OptionSpecification `type:"list"`

	// The name of the solution stack whose configuration options you want to describe.
	SolutionStackName *string `type:"string"`

	// The name of the configuration template whose configuration options you want
	// to describe.
	TemplateName *string `min:"1" type:"string"`

	metadataDescribeConfigurationOptionsInput `json:"-" xml:"-"`
}

type metadataDescribeConfigurationOptionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeConfigurationOptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationOptionsInput) GoString() string {
	return s.String()
}

// Describes the settings for a specified configuration set.
type DescribeConfigurationOptionsOutput struct {
	// A list of ConfigurationOptionDescription.
	Options []*ConfigurationOptionDescription `type:"list"`

	// The name of the solution stack these configuration options belong to.
	SolutionStackName *string `type:"string"`

	metadataDescribeConfigurationOptionsOutput `json:"-" xml:"-"`
}

type metadataDescribeConfigurationOptionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeConfigurationOptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationOptionsOutput) GoString() string {
	return s.String()
}

// Result message containing all of the configuration settings for a specified
// solution stack or configuration template.
type DescribeConfigurationSettingsInput struct {
	// The application for the environment or configuration template.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the environment to describe.
	//
	//  Condition: You must specify either this or a TemplateName, but not both.
	// If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination
	// error. If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// The name of the configuration template to describe.
	//
	//  Conditional: You must specify either this parameter or an EnvironmentName,
	// but not both. If you specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination
	// error. If you do not specify either, AWS Elastic Beanstalk returns a MissingRequiredParameter
	// error.
	TemplateName *string `min:"1" type:"string"`

	metadataDescribeConfigurationSettingsInput `json:"-" xml:"-"`
}

type metadataDescribeConfigurationSettingsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeConfigurationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationSettingsInput) GoString() string {
	return s.String()
}

// The results from a request to change the configuration settings of an environment.
type DescribeConfigurationSettingsOutput struct {
	// A list of ConfigurationSettingsDescription.
	ConfigurationSettings []*ConfigurationSettingsDescription `type:"list"`

	metadataDescribeConfigurationSettingsOutput `json:"-" xml:"-"`
}

type metadataDescribeConfigurationSettingsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeConfigurationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConfigurationSettingsOutput) GoString() string {
	return s.String()
}

// See the example below to learn how to create a request body.
type DescribeEnvironmentHealthInput struct {
	// Specifies the response elements you wish to receive. If no attribute names
	// are specified, AWS Elastic Beanstalk returns all response elements.
	AttributeNames []*string `type:"list"`

	// Specifies the AWS Elastic Beanstalk environment ID.
	EnvironmentId *string `type:"string"`

	// Specifies the AWS Elastic Beanstalk environment name.
	EnvironmentName *string `min:"4" type:"string"`

	metadataDescribeEnvironmentHealthInput `json:"-" xml:"-"`
}

type metadataDescribeEnvironmentHealthInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEnvironmentHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentHealthInput) GoString() string {
	return s.String()
}

// See the example below for a sample response.
type DescribeEnvironmentHealthOutput struct {
	// Represents the application metrics for a specified environment.
	ApplicationMetrics *ApplicationMetrics `type:"structure"`

	// Returns potential causes for the reported status.
	Causes []*string `type:"list"`

	// Returns the color indicator that tells you information about the health of
	// the environment. For more information, see Health Colors and Statuses (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	Color *string `type:"string"`

	// The AWS Elastic Beanstalk environment name.
	EnvironmentName *string `min:"4" type:"string"`

	// Contains the response body with information about the health of the environment.
	HealthStatus *string `type:"string"`

	// Represents summary information about the health of an instance. For more
	// information, see Health Colors and Statuses (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	InstancesHealth *InstanceHealthSummary `type:"structure"`

	// The date and time the information was last refreshed.
	RefreshedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Returns the health status value of the environment. For more information,
	// see Health Colors and Statuses (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	Status *string `type:"string" enum:"EnvironmentHealth"`

	metadataDescribeEnvironmentHealthOutput `json:"-" xml:"-"`
}

type metadataDescribeEnvironmentHealthOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEnvironmentHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentHealthOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type DescribeEnvironmentResourcesInput struct {
	// The ID of the environment to retrieve AWS resource usage data.
	//
	//  Condition: You must specify either this or an EnvironmentName, or both.
	// If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to retrieve AWS resource usage data.
	//
	//  Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	metadataDescribeEnvironmentResourcesInput `json:"-" xml:"-"`
}

type metadataDescribeEnvironmentResourcesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEnvironmentResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentResourcesInput) GoString() string {
	return s.String()
}

// Result message containing a list of environment resource descriptions.
type DescribeEnvironmentResourcesOutput struct {
	// A list of EnvironmentResourceDescription.
	EnvironmentResources *EnvironmentResourceDescription `type:"structure"`

	metadataDescribeEnvironmentResourcesOutput `json:"-" xml:"-"`
}

type metadataDescribeEnvironmentResourcesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEnvironmentResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentResourcesOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type DescribeEnvironmentsInput struct {
	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those that are associated with this application.
	ApplicationName *string `min:"1" type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those that have the specified IDs.
	EnvironmentIds []*string `type:"list"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those that have the specified names.
	EnvironmentNames []*string `type:"list"`

	// Indicates whether to include deleted environments:
	//
	//  true: Environments that have been deleted after IncludedDeletedBackTo are
	// displayed.
	//
	//  false: Do not include deleted environments.
	IncludeDeleted *bool `type:"boolean"`

	// If specified when IncludeDeleted is set to true, then environments deleted
	// after this date are displayed.
	IncludedDeletedBackTo *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those that are associated with this application version.
	VersionLabel *string `min:"1" type:"string"`

	metadataDescribeEnvironmentsInput `json:"-" xml:"-"`
}

type metadataDescribeEnvironmentsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentsInput) GoString() string {
	return s.String()
}

// Result message containing a list of environment descriptions.
type DescribeEnvironmentsOutput struct {
	// Returns an EnvironmentDescription list.
	Environments []*EnvironmentDescription `type:"list"`

	metadataDescribeEnvironmentsOutput `json:"-" xml:"-"`
}

type metadataDescribeEnvironmentsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentsOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type DescribeEventsInput struct {
	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// include only those associated with this application.
	ApplicationName *string `min:"1" type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those that occur up to, but not including, the EndTime.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those associated with this environment.
	EnvironmentId *string `type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those associated with this environment.
	EnvironmentName *string `min:"4" type:"string"`

	// Specifies the maximum number of events that can be returned, beginning with
	// the most recent event.
	MaxRecords *int64 `min:"1" type:"integer"`

	// Pagination token. If specified, the events return the next batch of results.
	NextToken *string `type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the described events to include
	// only those associated with this request ID.
	RequestId *string `type:"string"`

	// If specified, limits the events returned from this call to include only those
	// with the specified severity or higher.
	Severity *string `type:"string" enum:"EventSeverity"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those that occur on or after this time.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those that are associated with this environment configuration.
	TemplateName *string `min:"1" type:"string"`

	// If specified, AWS Elastic Beanstalk restricts the returned descriptions to
	// those associated with this application version.
	VersionLabel *string `min:"1" type:"string"`

	metadataDescribeEventsInput `json:"-" xml:"-"`
}

type metadataDescribeEventsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Result message wrapping a list of event descriptions.
type DescribeEventsOutput struct {
	// A list of EventDescription.
	Events []*EventDescription `type:"list"`

	// If returned, this indicates that there are more results to obtain. Use this
	// token in the next DescribeEvents call to get the next batch of events.
	NextToken *string `type:"string"`

	metadataDescribeEventsOutput `json:"-" xml:"-"`
}

type metadataDescribeEventsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// See the example below to learn how to create a request body.
type DescribeInstancesHealthInput struct {
	// Specifies the response elements you wish to receive. If no attribute names
	// are specified, AWS Elastic Beanstalk returns all response elements.
	AttributeNames []*string `type:"list"`

	// Specifies the AWS Elastic Beanstalk environment ID.
	EnvironmentId *string `type:"string"`

	// Specifies the AWS Elastic Beanstalk environment name.
	EnvironmentName *string `min:"4" type:"string"`

	// Specifies the next token of the request.
	NextToken *string `min:"1" type:"string"`

	metadataDescribeInstancesHealthInput `json:"-" xml:"-"`
}

type metadataDescribeInstancesHealthInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeInstancesHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesHealthInput) GoString() string {
	return s.String()
}

// See the example below for a sample response.
type DescribeInstancesHealthOutput struct {
	// Contains the response body with information about the health of the instance.
	InstanceHealthList []*SingleInstanceHealth `type:"list"`

	// The next token.
	NextToken *string `min:"1" type:"string"`

	// The date and time the information was last refreshed.
	RefreshedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	metadataDescribeInstancesHealthOutput `json:"-" xml:"-"`
}

type metadataDescribeInstancesHealthOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeInstancesHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesHealthOutput) GoString() string {
	return s.String()
}

// Describes the properties of an environment.
type EnvironmentDescription struct {
	// Indicates if there is an in-progress environment configuration update or
	// application version deployment that you can cancel.
	//
	//  true: There is an update in progress.
	//
	//  false: There are no updates currently in progress.
	AbortableOperationInProgress *bool `type:"boolean"`

	// The name of the application associated with this environment.
	ApplicationName *string `min:"1" type:"string"`

	// The URL to the CNAME for this environment.
	CNAME *string `min:"1" type:"string"`

	// The creation date for this environment.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The last modified date for this environment.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Describes this environment.
	Description *string `type:"string"`

	// For load-balanced, autoscaling environments, the URL to the LoadBalancer.
	// For single-instance environments, the IP address of the instance.
	EndpointURL *string `type:"string"`

	// The ID of this environment.
	EnvironmentId *string `type:"string"`

	// The name of this environment.
	EnvironmentName *string `min:"4" type:"string"`

	// Describes the health status of the environment. AWS Elastic Beanstalk indicates
	// the failure levels for a running environment:
	//
	//    Red : Indicates the environment is not working.
	//
	//    Yellow: Indicates that something is wrong, the application might not
	// be available, but the instances appear running.
	//
	//    Green: Indicates the environment is healthy and fully functional.
	//
	//     Red: Indicates the environment is not responsive. Occurs when three
	// or more consecutive failures occur for an environment.   Yellow: Indicates
	// that something is wrong. Occurs when two consecutive failures occur for an
	// environment.   Green: Indicates the environment is healthy and fully functional.
	//   Grey: Default health for a new environment. The environment is not fully
	// launched and health checks have not started or health checks are suspended
	// during an UpdateEnvironment or RestartEnvironement request.    Default: Grey
	Health *string `type:"string" enum:"EnvironmentHealth"`

	// Returns the health status of the application running in your environment.
	// For more information, see Health Colors and Statuses (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	HealthStatus *string `type:"string" enum:"EnvironmentHealthStatus"`

	// The description of the AWS resources used by this environment.
	Resources *EnvironmentResourcesDescription `type:"structure"`

	// The name of the SolutionStack deployed with this environment.
	SolutionStackName *string `type:"string"`

	// The current operational status of the environment:
	//
	//   Launching: Environment is in the process of initial deployment.   Updating:
	// Environment is in the process of updating its configuration settings or application
	// version.   Ready: Environment is available to have an action performed on
	// it, such as update or terminate.   Terminating: Environment is in the shut-down
	// process.   Terminated: Environment is not running.
	Status *string `type:"string" enum:"EnvironmentStatus"`

	// The name of the configuration template used to originally launch this environment.
	TemplateName *string `min:"1" type:"string"`

	// Describes the current tier of this environment.
	Tier *EnvironmentTier `type:"structure"`

	// The application version deployed in this environment.
	VersionLabel *string `min:"1" type:"string"`

	metadataEnvironmentDescription `json:"-" xml:"-"`
}

type metadataEnvironmentDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnvironmentDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentDescription) GoString() string {
	return s.String()
}

// The information retrieved from the Amazon EC2 instances.
type EnvironmentInfoDescription struct {
	// The Amazon EC2 Instance ID for this information.
	Ec2InstanceId *string `type:"string"`

	// The type of information retrieved.
	InfoType *string `type:"string" enum:"EnvironmentInfoType"`

	// The retrieved information.
	Message *string `type:"string"`

	// The time stamp when this information was retrieved.
	SampleTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	metadataEnvironmentInfoDescription `json:"-" xml:"-"`
}

type metadataEnvironmentInfoDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnvironmentInfoDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentInfoDescription) GoString() string {
	return s.String()
}

// Describes the AWS resources in use by this environment. This data is live.
type EnvironmentResourceDescription struct {
	// The AutoScalingGroups used by this environment.
	AutoScalingGroups []*AutoScalingGroup `type:"list"`

	// The name of the environment.
	EnvironmentName *string `min:"4" type:"string"`

	// The Amazon EC2 instances used by this environment.
	Instances []*Instance `type:"list"`

	// The Auto Scaling launch configurations in use by this environment.
	LaunchConfigurations []*LaunchConfiguration `type:"list"`

	// The LoadBalancers in use by this environment.
	LoadBalancers []*LoadBalancer `type:"list"`

	// The queues used by this environment.
	Queues []*Queue `type:"list"`

	// The AutoScaling triggers in use by this environment.
	Triggers []*Trigger `type:"list"`

	metadataEnvironmentResourceDescription `json:"-" xml:"-"`
}

type metadataEnvironmentResourceDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnvironmentResourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentResourceDescription) GoString() string {
	return s.String()
}

// Describes the AWS resources in use by this environment. This data is not
// live data.
type EnvironmentResourcesDescription struct {
	// Describes the LoadBalancer.
	LoadBalancer *LoadBalancerDescription `type:"structure"`

	metadataEnvironmentResourcesDescription `json:"-" xml:"-"`
}

type metadataEnvironmentResourcesDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnvironmentResourcesDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentResourcesDescription) GoString() string {
	return s.String()
}

// Describes the properties of an environment tier
type EnvironmentTier struct {
	// The name of this environment tier.
	Name *string `type:"string"`

	// The type of this environment tier.
	Type *string `type:"string"`

	// The version of this environment tier.
	Version *string `type:"string"`

	metadataEnvironmentTier `json:"-" xml:"-"`
}

type metadataEnvironmentTier struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnvironmentTier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentTier) GoString() string {
	return s.String()
}

// Describes an event.
type EventDescription struct {
	// The application associated with the event.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the environment associated with this event.
	EnvironmentName *string `min:"4" type:"string"`

	// The date when the event occurred.
	EventDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The event message.
	Message *string `type:"string"`

	// The web service request ID for the activity of this event.
	RequestId *string `type:"string"`

	// The severity level of this event.
	Severity *string `type:"string" enum:"EventSeverity"`

	// The name of the configuration associated with this event.
	TemplateName *string `min:"1" type:"string"`

	// The release label for the application version associated with this event.
	VersionLabel *string `min:"1" type:"string"`

	metadataEventDescription `json:"-" xml:"-"`
}

type metadataEventDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EventDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventDescription) GoString() string {
	return s.String()
}

// The description of an Amazon EC2 instance.
type Instance struct {
	// The ID of the Amazon EC2 instance.
	Id *string `type:"string"`

	metadataInstance `json:"-" xml:"-"`
}

type metadataInstance struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// Represents summary information about the health of an instance. For more
// information, see Health Colors and Statuses (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
type InstanceHealthSummary struct {
	// Red. The health agent is reporting a high number of request failures or other
	// issues for an instance or environment.
	Degraded *int64 `type:"integer"`

	// Green. An operation is in progress on an instance.
	Info *int64 `type:"integer"`

	// Grey. AWS Elastic Beanstalk and the health agent are reporting no data on
	// an instance.
	NoData *int64 `type:"integer"`

	// Green. An instance is passing health checks and the health agent is not reporting
	// any problems.
	Ok *int64 `type:"integer"`

	// Grey. An operation is in progress on an instance within the command timeout.
	Pending *int64 `type:"integer"`

	// Red. The health agent is reporting a very high number of request failures
	// or other issues for an instance or environment.
	Severe *int64 `type:"integer"`

	// Grey. AWS Elastic Beanstalk and the health agent are reporting an insufficient
	// amount of data on an instance.
	Unknown *int64 `type:"integer"`

	// Yellow. The health agent is reporting a moderate number of request failures
	// or other issues for an instance or environment.
	Warning *int64 `type:"integer"`

	metadataInstanceHealthSummary `json:"-" xml:"-"`
}

type metadataInstanceHealthSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceHealthSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceHealthSummary) GoString() string {
	return s.String()
}

// Represents the average latency for the slowest X percent of requests over
// the last 10 seconds.
type Latency struct {
	// The average latency for the slowest 90 percent of requests over the last
	// 10 seconds.
	P10 *float64 `type:"double"`

	// The average latency for the slowest 50 percent of requests over the last
	// 10 seconds.
	P50 *float64 `type:"double"`

	// The average latency for the slowest 25 percent of requests over the last
	// 10 seconds.
	P75 *float64 `type:"double"`

	// The average latency for the slowest 15 percent of requests over the last
	// 10 seconds.
	P85 *float64 `type:"double"`

	// The average latency for the slowest 10 percent of requests over the last
	// 10 seconds.
	P90 *float64 `type:"double"`

	// The average latency for the slowest 5 percent of requests over the last 10
	// seconds.
	P95 *float64 `type:"double"`

	// The average latency for the slowest 1 percent of requests over the last 10
	// seconds.
	P99 *float64 `type:"double"`

	// The average latency for the slowest 0.1 percent of requests over the last
	// 10 seconds.
	P999 *float64 `type:"double"`

	metadataLatency `json:"-" xml:"-"`
}

type metadataLatency struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Latency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Latency) GoString() string {
	return s.String()
}

// Describes an Auto Scaling launch configuration.
type LaunchConfiguration struct {
	// The name of the launch configuration.
	Name *string `type:"string"`

	metadataLaunchConfiguration `json:"-" xml:"-"`
}

type metadataLaunchConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchConfiguration) GoString() string {
	return s.String()
}

type ListAvailableSolutionStacksInput struct {
	metadataListAvailableSolutionStacksInput `json:"-" xml:"-"`
}

type metadataListAvailableSolutionStacksInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAvailableSolutionStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableSolutionStacksInput) GoString() string {
	return s.String()
}

// A list of available AWS Elastic Beanstalk solution stacks.
type ListAvailableSolutionStacksOutput struct {
	// A list of available solution stacks and their SolutionStackDescription.
	SolutionStackDetails []*SolutionStackDescription `type:"list"`

	// A list of available solution stacks.
	SolutionStacks []*string `type:"list"`

	metadataListAvailableSolutionStacksOutput `json:"-" xml:"-"`
}

type metadataListAvailableSolutionStacksOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAvailableSolutionStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAvailableSolutionStacksOutput) GoString() string {
	return s.String()
}

// Describes the properties of a Listener for the LoadBalancer.
type Listener struct {
	// The port that is used by the Listener.
	Port *int64 `type:"integer"`

	// The protocol that is used by the Listener.
	Protocol *string `type:"string"`

	metadataListener `json:"-" xml:"-"`
}

type metadataListener struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Listener) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Listener) GoString() string {
	return s.String()
}

// Describes a LoadBalancer.
type LoadBalancer struct {
	// The name of the LoadBalancer.
	Name *string `type:"string"`

	metadataLoadBalancer `json:"-" xml:"-"`
}

type metadataLoadBalancer struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancer) GoString() string {
	return s.String()
}

// Describes the details of a LoadBalancer.
type LoadBalancerDescription struct {
	// The domain name of the LoadBalancer.
	Domain *string `type:"string"`

	// A list of Listeners used by the LoadBalancer.
	Listeners []*Listener `type:"list"`

	// The name of the LoadBalancer.
	LoadBalancerName *string `type:"string"`

	metadataLoadBalancerDescription `json:"-" xml:"-"`
}

type metadataLoadBalancerDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LoadBalancerDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerDescription) GoString() string {
	return s.String()
}

// A regular expression representing a restriction on a string configuration
// option value.
type OptionRestrictionRegex struct {
	// A unique name representing this regular expression.
	Label *string `type:"string"`

	// The regular expression pattern that a string configuration option value with
	// this restriction must match.
	Pattern *string `type:"string"`

	metadataOptionRestrictionRegex `json:"-" xml:"-"`
}

type metadataOptionRestrictionRegex struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s OptionRestrictionRegex) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionRestrictionRegex) GoString() string {
	return s.String()
}

// A specification identifying an individual configuration option.
type OptionSpecification struct {
	// A unique namespace identifying the option's associated AWS resource.
	Namespace *string `type:"string"`

	// The name of the configuration option.
	OptionName *string `type:"string"`

	// A unique resource name for a time-based scaling configuration option.
	ResourceName *string `min:"1" type:"string"`

	metadataOptionSpecification `json:"-" xml:"-"`
}

type metadataOptionSpecification struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s OptionSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionSpecification) GoString() string {
	return s.String()
}

// Describes a queue.
type Queue struct {
	// The name of the queue.
	Name *string `type:"string"`

	// The URL of the queue.
	URL *string `type:"string"`

	metadataQueue `json:"-" xml:"-"`
}

type metadataQueue struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Queue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Queue) GoString() string {
	return s.String()
}

type RebuildEnvironmentInput struct {
	// The ID of the environment to rebuild.
	//
	//  Condition: You must specify either this or an EnvironmentName, or both.
	// If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to rebuild.
	//
	//  Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	metadataRebuildEnvironmentInput `json:"-" xml:"-"`
}

type metadataRebuildEnvironmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RebuildEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildEnvironmentInput) GoString() string {
	return s.String()
}

type RebuildEnvironmentOutput struct {
	metadataRebuildEnvironmentOutput `json:"-" xml:"-"`
}

type metadataRebuildEnvironmentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RebuildEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildEnvironmentOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type RequestEnvironmentInfoInput struct {
	// The ID of the environment of the requested data.
	//
	//  If no such environment is found, RequestEnvironmentInfo returns an InvalidParameterValue
	// error.
	//
	//  Condition: You must specify either this or an EnvironmentName, or both.
	// If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment of the requested data.
	//
	//  If no such environment is found, RequestEnvironmentInfo returns an InvalidParameterValue
	// error.
	//
	//  Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// The type of information to request.
	InfoType *string `type:"string" required:"true" enum:"EnvironmentInfoType"`

	metadataRequestEnvironmentInfoInput `json:"-" xml:"-"`
}

type metadataRequestEnvironmentInfoInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RequestEnvironmentInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestEnvironmentInfoInput) GoString() string {
	return s.String()
}

type RequestEnvironmentInfoOutput struct {
	metadataRequestEnvironmentInfoOutput `json:"-" xml:"-"`
}

type metadataRequestEnvironmentInfoOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RequestEnvironmentInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestEnvironmentInfoOutput) GoString() string {
	return s.String()
}

type RestartAppServerInput struct {
	// The ID of the environment to restart the server for.
	//
	//  Condition: You must specify either this or an EnvironmentName, or both.
	// If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to restart the server for.
	//
	//  Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	metadataRestartAppServerInput `json:"-" xml:"-"`
}

type metadataRestartAppServerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RestartAppServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestartAppServerInput) GoString() string {
	return s.String()
}

type RestartAppServerOutput struct {
	metadataRestartAppServerOutput `json:"-" xml:"-"`
}

type metadataRestartAppServerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RestartAppServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestartAppServerOutput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type RetrieveEnvironmentInfoInput struct {
	// The ID of the data's environment.
	//
	//  If no such environment is found, returns an InvalidParameterValue error.
	//
	//  Condition: You must specify either this or an EnvironmentName, or both.
	// If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the data's environment.
	//
	//  If no such environment is found, returns an InvalidParameterValue error.
	//
	//  Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// The type of information to retrieve.
	InfoType *string `type:"string" required:"true" enum:"EnvironmentInfoType"`

	metadataRetrieveEnvironmentInfoInput `json:"-" xml:"-"`
}

type metadataRetrieveEnvironmentInfoInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RetrieveEnvironmentInfoInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveEnvironmentInfoInput) GoString() string {
	return s.String()
}

// Result message containing a description of the requested environment info.
type RetrieveEnvironmentInfoOutput struct {
	// The EnvironmentInfoDescription of the environment.
	EnvironmentInfo []*EnvironmentInfoDescription `type:"list"`

	metadataRetrieveEnvironmentInfoOutput `json:"-" xml:"-"`
}

type metadataRetrieveEnvironmentInfoOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RetrieveEnvironmentInfoOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetrieveEnvironmentInfoOutput) GoString() string {
	return s.String()
}

// A specification of a location in Amazon S3.
type S3Location struct {
	// The Amazon S3 bucket where the data is located.
	S3Bucket *string `type:"string"`

	// The Amazon S3 key where the data is located.
	S3Key *string `type:"string"`

	metadataS3Location `json:"-" xml:"-"`
}

type metadataS3Location struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Location) GoString() string {
	return s.String()
}

// Represents health information from the specified instance that belongs to
// the AWS Elastic Beanstalk environment. Use the InstanceId property to specify
// the application instance for which you'd like to return data.
type SingleInstanceHealth struct {
	// Represents the application metrics for a specified environment.
	ApplicationMetrics *ApplicationMetrics `type:"structure"`

	// Represents the causes, which provide more information about the current health
	// status.
	Causes []*string `type:"list"`

	// Represents the color indicator that gives you information about the health
	// of the EC2 instance. For more information, see Health Colors and Statuses
	// (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	Color *string `type:"string"`

	// Returns the health status of the specified instance. For more information,
	// see Health Colors and Statuses (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html).
	HealthStatus *string `type:"string"`

	// The ID of the Amazon EC2 instance.
	InstanceId *string `min:"1" type:"string"`

	// The time at which the EC2 instance was launched.
	LaunchedAt *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Represents CPU utilization and load average information for applications
	// running in the specified environment.
	System *SystemStatus `type:"structure"`

	metadataSingleInstanceHealth `json:"-" xml:"-"`
}

type metadataSingleInstanceHealth struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SingleInstanceHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SingleInstanceHealth) GoString() string {
	return s.String()
}

// Describes the solution stack.
type SolutionStackDescription struct {
	// The permitted file types allowed for a solution stack.
	PermittedFileTypes []*string `type:"list"`

	// The name of the solution stack.
	SolutionStackName *string `type:"string"`

	metadataSolutionStackDescription `json:"-" xml:"-"`
}

type metadataSolutionStackDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SolutionStackDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SolutionStackDescription) GoString() string {
	return s.String()
}

// A specification for an environment configuration
type SourceConfiguration struct {
	// The name of the application associated with the configuration.
	ApplicationName *string `min:"1" type:"string"`

	// The name of the configuration template.
	TemplateName *string `min:"1" type:"string"`

	metadataSourceConfiguration `json:"-" xml:"-"`
}

type metadataSourceConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceConfiguration) GoString() string {
	return s.String()
}

// Represents the percentage of requests over the last 10 seconds that resulted
// in each type of status code response. For more information, see Status Code
// Definitions (http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html).
type StatusCodes struct {
	// The percentage of requests over the last 10 seconds that resulted in a 2xx
	// (200, 201, etc.) status code.
	Status2xx *int64 `type:"integer"`

	// The percentage of requests over the last 10 seconds that resulted in a 3xx
	// (300, 301, etc.) status code.
	Status3xx *int64 `type:"integer"`

	// The percentage of requests over the last 10 seconds that resulted in a 4xx
	// (400, 401, etc.) status code.
	Status4xx *int64 `type:"integer"`

	// The percentage of requests over the last 10 seconds that resulted in a 5xx
	// (500, 501, etc.) status code.
	Status5xx *int64 `type:"integer"`

	metadataStatusCodes `json:"-" xml:"-"`
}

type metadataStatusCodes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StatusCodes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodes) GoString() string {
	return s.String()
}

// Swaps the CNAMEs of two environments.
type SwapEnvironmentCNAMEsInput struct {
	// The ID of the destination environment.
	//
	//  Condition: You must specify at least the DestinationEnvironmentID or the
	// DestinationEnvironmentName. You may also specify both. You must specify the
	// SourceEnvironmentId with the DestinationEnvironmentId.
	DestinationEnvironmentId *string `type:"string"`

	// The name of the destination environment.
	//
	//  Condition: You must specify at least the DestinationEnvironmentID or the
	// DestinationEnvironmentName. You may also specify both. You must specify the
	// SourceEnvironmentName with the DestinationEnvironmentName.
	DestinationEnvironmentName *string `min:"4" type:"string"`

	// The ID of the source environment.
	//
	//  Condition: You must specify at least the SourceEnvironmentID or the SourceEnvironmentName.
	// You may also specify both. If you specify the SourceEnvironmentId, you must
	// specify the DestinationEnvironmentId.
	SourceEnvironmentId *string `type:"string"`

	// The name of the source environment.
	//
	//  Condition: You must specify at least the SourceEnvironmentID or the SourceEnvironmentName.
	// You may also specify both. If you specify the SourceEnvironmentName, you
	// must specify the DestinationEnvironmentName.
	SourceEnvironmentName *string `min:"4" type:"string"`

	metadataSwapEnvironmentCNAMEsInput `json:"-" xml:"-"`
}

type metadataSwapEnvironmentCNAMEsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SwapEnvironmentCNAMEsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SwapEnvironmentCNAMEsInput) GoString() string {
	return s.String()
}

type SwapEnvironmentCNAMEsOutput struct {
	metadataSwapEnvironmentCNAMEsOutput `json:"-" xml:"-"`
}

type metadataSwapEnvironmentCNAMEsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SwapEnvironmentCNAMEsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SwapEnvironmentCNAMEsOutput) GoString() string {
	return s.String()
}

// Represents CPU utilization and load average information for applications
// running in the specified environment.
type SystemStatus struct {
	// Represents CPU utilization information from the specified instance that belongs
	// to the AWS Elastic Beanstalk environment. Use the instanceId property to
	// specify the application instance for which you'd like to return data.
	CPUUtilization *CPUUtilization `type:"structure"`

	// Load average in the last 1-minute and 5-minute periods. For more information,
	// see Operating System Metrics (http://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-metrics.html#health-enhanced-metrics-os).
	LoadAverage []*float64 `type:"list"`

	metadataSystemStatus `json:"-" xml:"-"`
}

type metadataSystemStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SystemStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemStatus) GoString() string {
	return s.String()
}

// Describes a tag applied to a resource in an environment.
type Tag struct {
	// The key of the tag.
	Key *string `min:"1" type:"string"`

	// The value of the tag.
	Value *string `min:"1" type:"string"`

	metadataTag `json:"-" xml:"-"`
}

type metadataTag struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type TerminateEnvironmentInput struct {
	// The ID of the environment to terminate.
	//
	//  Condition: You must specify either this or an EnvironmentName, or both.
	// If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to terminate.
	//
	//  Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// Indicates whether the associated AWS resources should shut down when the
	// environment is terminated:
	//
	//    true: (default) The user AWS resources (for example, the Auto Scaling
	// group, LoadBalancer, etc.) are terminated along with the environment.
	//
	//    false: The environment is removed from the AWS Elastic Beanstalk but
	// the AWS resources continue to operate.
	//
	//     true: The specified environment as well as the associated AWS resources,
	// such as Auto Scaling group and LoadBalancer, are terminated.   false: AWS
	// Elastic Beanstalk resource management is removed from the environment, but
	// the AWS resources continue to operate.    For more information, see the
	// AWS Elastic Beanstalk User Guide.  (http://docs.aws.amazon.com/elasticbeanstalk/latest/ug/)
	//
	//  Default: true
	//
	//  Valid Values: true | false
	TerminateResources *bool `type:"boolean"`

	metadataTerminateEnvironmentInput `json:"-" xml:"-"`
}

type metadataTerminateEnvironmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TerminateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateEnvironmentInput) GoString() string {
	return s.String()
}

// Describes a trigger.
type Trigger struct {
	// The name of the trigger.
	Name *string `type:"string"`

	metadataTrigger `json:"-" xml:"-"`
}

type metadataTrigger struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Trigger) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Trigger) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type UpdateApplicationInput struct {
	// The name of the application to update. If no such application is found, UpdateApplication
	// returns an InvalidParameterValue error.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// A new description for the application.
	//
	// Default: If not specified, AWS Elastic Beanstalk does not update the description.
	Description *string `type:"string"`

	metadataUpdateApplicationInput `json:"-" xml:"-"`
}

type metadataUpdateApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

type UpdateApplicationVersionInput struct {
	// The name of the application associated with this version.
	//
	//  If no application is found with this name, UpdateApplication returns an
	// InvalidParameterValue error.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// A new description for this release.
	Description *string `type:"string"`

	// The name of the version to update.
	//
	//  If no application version is found with this label, UpdateApplication returns
	// an InvalidParameterValue error.
	VersionLabel *string `min:"1" type:"string" required:"true"`

	metadataUpdateApplicationVersionInput `json:"-" xml:"-"`
}

type metadataUpdateApplicationVersionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationVersionInput) GoString() string {
	return s.String()
}

// The result message containing the options for the specified solution stack.
type UpdateConfigurationTemplateInput struct {
	// The name of the application associated with the configuration template to
	// update.
	//
	//  If no application is found with this name, UpdateConfigurationTemplate
	// returns an InvalidParameterValue error.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// A new description for the configuration.
	Description *string `type:"string"`

	// A list of configuration option settings to update with the new specified
	// option value.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// A list of configuration options to remove from the configuration set.
	//
	//  Constraint: You can remove only UserDefined configuration options.
	OptionsToRemove []*OptionSpecification `type:"list"`

	// The name of the configuration template to update.
	//
	//  If no configuration template is found with this name, UpdateConfigurationTemplate
	// returns an InvalidParameterValue error.
	TemplateName *string `min:"1" type:"string" required:"true"`

	metadataUpdateConfigurationTemplateInput `json:"-" xml:"-"`
}

type metadataUpdateConfigurationTemplateInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateConfigurationTemplateInput) GoString() string {
	return s.String()
}

// This documentation target is not reported in the API reference.
type UpdateEnvironmentInput struct {
	// If this parameter is specified, AWS Elastic Beanstalk updates the description
	// of this environment.
	Description *string `type:"string"`

	// The ID of the environment to update.
	//
	//  If no environment with this ID exists, AWS Elastic Beanstalk returns an
	// InvalidParameterValue error.
	//
	//  Condition: You must specify either this or an EnvironmentName, or both.
	// If you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentId *string `type:"string"`

	// The name of the environment to update. If no environment with this name exists,
	// AWS Elastic Beanstalk returns an InvalidParameterValue error.
	//
	//  Condition: You must specify either this or an EnvironmentId, or both. If
	// you do not specify either, AWS Elastic Beanstalk returns MissingRequiredParameter
	// error.
	EnvironmentName *string `min:"4" type:"string"`

	// If specified, AWS Elastic Beanstalk updates the configuration set associated
	// with the running environment and sets the specified configuration options
	// to the requested value.
	OptionSettings []*ConfigurationOptionSetting `type:"list"`

	// A list of custom user-defined configuration options to remove from the configuration
	// set for this environment.
	OptionsToRemove []*OptionSpecification `type:"list"`

	// This specifies the platform version that the environment will run after the
	// environment is updated.
	SolutionStackName *string `type:"string"`

	// If this parameter is specified, AWS Elastic Beanstalk deploys this configuration
	// template to the environment. If no such configuration template is found,
	// AWS Elastic Beanstalk returns an InvalidParameterValue error.
	TemplateName *string `min:"1" type:"string"`

	// This specifies the tier to use to update the environment.
	//
	//  Condition: At this time, if you change the tier version, name, or type,
	// AWS Elastic Beanstalk returns InvalidParameterValue error.
	Tier *EnvironmentTier `type:"structure"`

	// If this parameter is specified, AWS Elastic Beanstalk deploys the named application
	// version to the environment. If no such application version is found, returns
	// an InvalidParameterValue error.
	VersionLabel *string `min:"1" type:"string"`

	metadataUpdateEnvironmentInput `json:"-" xml:"-"`
}

type metadataUpdateEnvironmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnvironmentInput) GoString() string {
	return s.String()
}

// A list of validation messages for a specified configuration template.
type ValidateConfigurationSettingsInput struct {
	// The name of the application that the configuration template or environment
	// belongs to.
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The name of the environment to validate the settings against.
	//
	//  Condition: You cannot specify both this and a configuration template name.
	EnvironmentName *string `min:"4" type:"string"`

	// A list of the options and desired values to evaluate.
	OptionSettings []*ConfigurationOptionSetting `type:"list" required:"true"`

	// The name of the configuration template to validate the settings against.
	//
	//  Condition: You cannot specify both this and an environment name.
	TemplateName *string `min:"1" type:"string"`

	metadataValidateConfigurationSettingsInput `json:"-" xml:"-"`
}

type metadataValidateConfigurationSettingsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ValidateConfigurationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateConfigurationSettingsInput) GoString() string {
	return s.String()
}

// Provides a list of validation messages.
type ValidateConfigurationSettingsOutput struct {
	// A list of ValidationMessage.
	Messages []*ValidationMessage `type:"list"`

	metadataValidateConfigurationSettingsOutput `json:"-" xml:"-"`
}

type metadataValidateConfigurationSettingsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ValidateConfigurationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateConfigurationSettingsOutput) GoString() string {
	return s.String()
}

// An error or warning for a desired configuration option value.
type ValidationMessage struct {
	// A message describing the error or warning.
	Message *string `type:"string"`

	Namespace *string `type:"string"`

	OptionName *string `type:"string"`

	// An indication of the severity of this message:
	//
	//    error: This message indicates that this is not a valid setting for an
	// option.
	//
	//    warning: This message is providing information you should take into account.
	//
	//     error: This message indicates that this is not a valid setting for an
	// option.   warning: This message is providing information you should take
	// into account.
	Severity *string `type:"string" enum:"ValidationSeverity"`

	metadataValidationMessage `json:"-" xml:"-"`
}

type metadataValidationMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ValidationMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationMessage) GoString() string {
	return s.String()
}

const (
	// @enum ConfigurationDeploymentStatus
	ConfigurationDeploymentStatusDeployed = "deployed"
	// @enum ConfigurationDeploymentStatus
	ConfigurationDeploymentStatusPending = "pending"
	// @enum ConfigurationDeploymentStatus
	ConfigurationDeploymentStatusFailed = "failed"
)

const (
	// @enum ConfigurationOptionValueType
	ConfigurationOptionValueTypeScalar = "Scalar"
	// @enum ConfigurationOptionValueType
	ConfigurationOptionValueTypeList = "List"
)

const (
	// @enum EnvironmentHealth
	EnvironmentHealthGreen = "Green"
	// @enum EnvironmentHealth
	EnvironmentHealthYellow = "Yellow"
	// @enum EnvironmentHealth
	EnvironmentHealthRed = "Red"
	// @enum EnvironmentHealth
	EnvironmentHealthGrey = "Grey"
)

const (
	// @enum EnvironmentHealthAttribute
	EnvironmentHealthAttributeStatus = "Status"
	// @enum EnvironmentHealthAttribute
	EnvironmentHealthAttributeColor = "Color"
	// @enum EnvironmentHealthAttribute
	EnvironmentHealthAttributeCauses = "Causes"
	// @enum EnvironmentHealthAttribute
	EnvironmentHealthAttributeApplicationMetrics = "ApplicationMetrics"
	// @enum EnvironmentHealthAttribute
	EnvironmentHealthAttributeInstancesHealth = "InstancesHealth"
	// @enum EnvironmentHealthAttribute
	EnvironmentHealthAttributeAll = "All"
	// @enum EnvironmentHealthAttribute
	EnvironmentHealthAttributeHealthStatus = "HealthStatus"
	// @enum EnvironmentHealthAttribute
	EnvironmentHealthAttributeRefreshedAt = "RefreshedAt"
)

const (
	// @enum EnvironmentHealthStatus
	EnvironmentHealthStatusNoData = "NoData"
	// @enum EnvironmentHealthStatus
	EnvironmentHealthStatusUnknown = "Unknown"
	// @enum EnvironmentHealthStatus
	EnvironmentHealthStatusPending = "Pending"
	// @enum EnvironmentHealthStatus
	EnvironmentHealthStatusOk = "Ok"
	// @enum EnvironmentHealthStatus
	EnvironmentHealthStatusInfo = "Info"
	// @enum EnvironmentHealthStatus
	EnvironmentHealthStatusWarning = "Warning"
	// @enum EnvironmentHealthStatus
	EnvironmentHealthStatusDegraded = "Degraded"
	// @enum EnvironmentHealthStatus
	EnvironmentHealthStatusSevere = "Severe"
)

const (
	// @enum EnvironmentInfoType
	EnvironmentInfoTypeTail = "tail"
	// @enum EnvironmentInfoType
	EnvironmentInfoTypeBundle = "bundle"
)

const (
	// @enum EnvironmentStatus
	EnvironmentStatusLaunching = "Launching"
	// @enum EnvironmentStatus
	EnvironmentStatusUpdating = "Updating"
	// @enum EnvironmentStatus
	EnvironmentStatusReady = "Ready"
	// @enum EnvironmentStatus
	EnvironmentStatusTerminating = "Terminating"
	// @enum EnvironmentStatus
	EnvironmentStatusTerminated = "Terminated"
)

const (
	// @enum EventSeverity
	EventSeverityTrace = "TRACE"
	// @enum EventSeverity
	EventSeverityDebug = "DEBUG"
	// @enum EventSeverity
	EventSeverityInfo = "INFO"
	// @enum EventSeverity
	EventSeverityWarn = "WARN"
	// @enum EventSeverity
	EventSeverityError = "ERROR"
	// @enum EventSeverity
	EventSeverityFatal = "FATAL"
)

const (
	// @enum InstancesHealthAttribute
	InstancesHealthAttributeHealthStatus = "HealthStatus"
	// @enum InstancesHealthAttribute
	InstancesHealthAttributeColor = "Color"
	// @enum InstancesHealthAttribute
	InstancesHealthAttributeCauses = "Causes"
	// @enum InstancesHealthAttribute
	InstancesHealthAttributeApplicationMetrics = "ApplicationMetrics"
	// @enum InstancesHealthAttribute
	InstancesHealthAttributeRefreshedAt = "RefreshedAt"
	// @enum InstancesHealthAttribute
	InstancesHealthAttributeLaunchedAt = "LaunchedAt"
	// @enum InstancesHealthAttribute
	InstancesHealthAttributeSystem = "System"
	// @enum InstancesHealthAttribute
	InstancesHealthAttributeAll = "All"
)

const (
	// @enum ValidationSeverity
	ValidationSeverityError = "error"
	// @enum ValidationSeverity
	ValidationSeverityWarning = "warning"
)
