// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package inspector provides a client for Amazon Inspector.
package inspector

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddAttributesToFindings = "AddAttributesToFindings"

// AddAttributesToFindingsRequest generates a request for the AddAttributesToFindings operation.
func (c *Inspector) AddAttributesToFindingsRequest(input *AddAttributesToFindingsInput) (req *request.Request, output *AddAttributesToFindingsOutput) {
	op := &request.Operation{
		Name:       opAddAttributesToFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddAttributesToFindingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddAttributesToFindingsOutput{}
	req.Data = output
	return
}

// Assigns attributes (key and value pair) to the findings specified by the
// findings' ARNs.
func (c *Inspector) AddAttributesToFindings(input *AddAttributesToFindingsInput) (*AddAttributesToFindingsOutput, error) {
	req, out := c.AddAttributesToFindingsRequest(input)
	err := req.Send()
	return out, err
}

const opAttachAssessmentAndRulesPackage = "AttachAssessmentAndRulesPackage"

// AttachAssessmentAndRulesPackageRequest generates a request for the AttachAssessmentAndRulesPackage operation.
func (c *Inspector) AttachAssessmentAndRulesPackageRequest(input *AttachAssessmentAndRulesPackageInput) (req *request.Request, output *AttachAssessmentAndRulesPackageOutput) {
	op := &request.Operation{
		Name:       opAttachAssessmentAndRulesPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachAssessmentAndRulesPackageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachAssessmentAndRulesPackageOutput{}
	req.Data = output
	return
}

// Attaches the rules package specified by the rules package ARN to the assessment
// specified by the assessment ARN.
func (c *Inspector) AttachAssessmentAndRulesPackage(input *AttachAssessmentAndRulesPackageInput) (*AttachAssessmentAndRulesPackageOutput, error) {
	req, out := c.AttachAssessmentAndRulesPackageRequest(input)
	err := req.Send()
	return out, err
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a request for the CreateApplication operation.
func (c *Inspector) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateApplicationOutput{}
	req.Data = output
	return
}

// Creates a new application using the resource group ARN generated by CreateResourceGroup.
// You can create up to 50 applications per AWS account. You can run up to 500
// concurrent agents per AWS account. For more information, see  Inspector Applications.
// (https://docs.aws.amazon.com/inspector/latest/userguide//inspector_applications.html)
func (c *Inspector) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAssessment = "CreateAssessment"

// CreateAssessmentRequest generates a request for the CreateAssessment operation.
func (c *Inspector) CreateAssessmentRequest(input *CreateAssessmentInput) (req *request.Request, output *CreateAssessmentOutput) {
	op := &request.Operation{
		Name:       opCreateAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAssessmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAssessmentOutput{}
	req.Data = output
	return
}

// Creates an assessment for the application specified by the application ARN.
// You can create up to 500 assessments per AWS account.
func (c *Inspector) CreateAssessment(input *CreateAssessmentInput) (*CreateAssessmentOutput, error) {
	req, out := c.CreateAssessmentRequest(input)
	err := req.Send()
	return out, err
}

const opCreateResourceGroup = "CreateResourceGroup"

// CreateResourceGroupRequest generates a request for the CreateResourceGroup operation.
func (c *Inspector) CreateResourceGroupRequest(input *CreateResourceGroupInput) (req *request.Request, output *CreateResourceGroupOutput) {
	op := &request.Operation{
		Name:       opCreateResourceGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateResourceGroupOutput{}
	req.Data = output
	return
}

// Creates a resource group using the specified set of tags (key and value pairs)
// that are used to select the EC2 instances to be included in an Inspector
// application. The created resource group is then used to create an Inspector
// application.
func (c *Inspector) CreateResourceGroup(input *CreateResourceGroupInput) (*CreateResourceGroupOutput, error) {
	req, out := c.CreateResourceGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a request for the DeleteApplication operation.
func (c *Inspector) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteApplicationOutput{}
	req.Data = output
	return
}

// Deletes the application specified by the application ARN.
func (c *Inspector) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAssessment = "DeleteAssessment"

// DeleteAssessmentRequest generates a request for the DeleteAssessment operation.
func (c *Inspector) DeleteAssessmentRequest(input *DeleteAssessmentInput) (req *request.Request, output *DeleteAssessmentOutput) {
	op := &request.Operation{
		Name:       opDeleteAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssessmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteAssessmentOutput{}
	req.Data = output
	return
}

// Deletes the assessment specified by the assessment ARN.
func (c *Inspector) DeleteAssessment(input *DeleteAssessmentInput) (*DeleteAssessmentOutput, error) {
	req, out := c.DeleteAssessmentRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRun = "DeleteRun"

// DeleteRunRequest generates a request for the DeleteRun operation.
func (c *Inspector) DeleteRunRequest(input *DeleteRunInput) (req *request.Request, output *DeleteRunOutput) {
	op := &request.Operation{
		Name:       opDeleteRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRunInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteRunOutput{}
	req.Data = output
	return
}

// Deletes the assessment run specified by the run ARN.
func (c *Inspector) DeleteRun(input *DeleteRunInput) (*DeleteRunOutput, error) {
	req, out := c.DeleteRunRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeApplication = "DescribeApplication"

// DescribeApplicationRequest generates a request for the DescribeApplication operation.
func (c *Inspector) DescribeApplicationRequest(input *DescribeApplicationInput) (req *request.Request, output *DescribeApplicationOutput) {
	op := &request.Operation{
		Name:       opDescribeApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeApplicationOutput{}
	req.Data = output
	return
}

// Describes the application specified by the application ARN.
func (c *Inspector) DescribeApplication(input *DescribeApplicationInput) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAssessment = "DescribeAssessment"

// DescribeAssessmentRequest generates a request for the DescribeAssessment operation.
func (c *Inspector) DescribeAssessmentRequest(input *DescribeAssessmentInput) (req *request.Request, output *DescribeAssessmentOutput) {
	op := &request.Operation{
		Name:       opDescribeAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAssessmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAssessmentOutput{}
	req.Data = output
	return
}

// Describes the assessment specified by the assessment ARN.
func (c *Inspector) DescribeAssessment(input *DescribeAssessmentInput) (*DescribeAssessmentOutput, error) {
	req, out := c.DescribeAssessmentRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCrossAccountAccessRole = "DescribeCrossAccountAccessRole"

// DescribeCrossAccountAccessRoleRequest generates a request for the DescribeCrossAccountAccessRole operation.
func (c *Inspector) DescribeCrossAccountAccessRoleRequest(input *DescribeCrossAccountAccessRoleInput) (req *request.Request, output *DescribeCrossAccountAccessRoleOutput) {
	op := &request.Operation{
		Name:       opDescribeCrossAccountAccessRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCrossAccountAccessRoleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCrossAccountAccessRoleOutput{}
	req.Data = output
	return
}

// Describes the IAM role that enables Inspector to access your AWS account.
func (c *Inspector) DescribeCrossAccountAccessRole(input *DescribeCrossAccountAccessRoleInput) (*DescribeCrossAccountAccessRoleOutput, error) {
	req, out := c.DescribeCrossAccountAccessRoleRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeFinding = "DescribeFinding"

// DescribeFindingRequest generates a request for the DescribeFinding operation.
func (c *Inspector) DescribeFindingRequest(input *DescribeFindingInput) (req *request.Request, output *DescribeFindingOutput) {
	op := &request.Operation{
		Name:       opDescribeFinding,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFindingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeFindingOutput{}
	req.Data = output
	return
}

// Describes the finding specified by the finding ARN.
func (c *Inspector) DescribeFinding(input *DescribeFindingInput) (*DescribeFindingOutput, error) {
	req, out := c.DescribeFindingRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeResourceGroup = "DescribeResourceGroup"

// DescribeResourceGroupRequest generates a request for the DescribeResourceGroup operation.
func (c *Inspector) DescribeResourceGroupRequest(input *DescribeResourceGroupInput) (req *request.Request, output *DescribeResourceGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeResourceGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeResourceGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeResourceGroupOutput{}
	req.Data = output
	return
}

// Describes the resource group specified by the resource group ARN.
func (c *Inspector) DescribeResourceGroup(input *DescribeResourceGroupInput) (*DescribeResourceGroupOutput, error) {
	req, out := c.DescribeResourceGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRulesPackage = "DescribeRulesPackage"

// DescribeRulesPackageRequest generates a request for the DescribeRulesPackage operation.
func (c *Inspector) DescribeRulesPackageRequest(input *DescribeRulesPackageInput) (req *request.Request, output *DescribeRulesPackageOutput) {
	op := &request.Operation{
		Name:       opDescribeRulesPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRulesPackageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRulesPackageOutput{}
	req.Data = output
	return
}

// Describes the rules package specified by the rules package ARN.
func (c *Inspector) DescribeRulesPackage(input *DescribeRulesPackageInput) (*DescribeRulesPackageOutput, error) {
	req, out := c.DescribeRulesPackageRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRun = "DescribeRun"

// DescribeRunRequest generates a request for the DescribeRun operation.
func (c *Inspector) DescribeRunRequest(input *DescribeRunInput) (req *request.Request, output *DescribeRunOutput) {
	op := &request.Operation{
		Name:       opDescribeRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRunInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRunOutput{}
	req.Data = output
	return
}

// Describes the assessment run specified by the run ARN.
func (c *Inspector) DescribeRun(input *DescribeRunInput) (*DescribeRunOutput, error) {
	req, out := c.DescribeRunRequest(input)
	err := req.Send()
	return out, err
}

const opDetachAssessmentAndRulesPackage = "DetachAssessmentAndRulesPackage"

// DetachAssessmentAndRulesPackageRequest generates a request for the DetachAssessmentAndRulesPackage operation.
func (c *Inspector) DetachAssessmentAndRulesPackageRequest(input *DetachAssessmentAndRulesPackageInput) (req *request.Request, output *DetachAssessmentAndRulesPackageOutput) {
	op := &request.Operation{
		Name:       opDetachAssessmentAndRulesPackage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachAssessmentAndRulesPackageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachAssessmentAndRulesPackageOutput{}
	req.Data = output
	return
}

// Detaches the rules package specified by the rules package ARN from the assessment
// specified by the assessment ARN.
func (c *Inspector) DetachAssessmentAndRulesPackage(input *DetachAssessmentAndRulesPackageInput) (*DetachAssessmentAndRulesPackageOutput, error) {
	req, out := c.DetachAssessmentAndRulesPackageRequest(input)
	err := req.Send()
	return out, err
}

const opGetAssessmentTelemetry = "GetAssessmentTelemetry"

// GetAssessmentTelemetryRequest generates a request for the GetAssessmentTelemetry operation.
func (c *Inspector) GetAssessmentTelemetryRequest(input *GetAssessmentTelemetryInput) (req *request.Request, output *GetAssessmentTelemetryOutput) {
	op := &request.Operation{
		Name:       opGetAssessmentTelemetry,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAssessmentTelemetryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetAssessmentTelemetryOutput{}
	req.Data = output
	return
}

// Returns the metadata about the telemetry (application behavioral data) for
// the assessment specified by the assessment ARN.
func (c *Inspector) GetAssessmentTelemetry(input *GetAssessmentTelemetryInput) (*GetAssessmentTelemetryOutput, error) {
	req, out := c.GetAssessmentTelemetryRequest(input)
	err := req.Send()
	return out, err
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a request for the ListApplications operation.
func (c *Inspector) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListApplicationsOutput{}
	req.Data = output
	return
}

// Lists the ARNs of the applications within this AWS account. For more information
// about applications, see Inspector Applications (https://docs.aws.amazon.com/inspector/latest/userguide//inspector_applications.html).
func (c *Inspector) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	err := req.Send()
	return out, err
}

const opListAssessmentAgents = "ListAssessmentAgents"

// ListAssessmentAgentsRequest generates a request for the ListAssessmentAgents operation.
func (c *Inspector) ListAssessmentAgentsRequest(input *ListAssessmentAgentsInput) (req *request.Request, output *ListAssessmentAgentsOutput) {
	op := &request.Operation{
		Name:       opListAssessmentAgents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssessmentAgentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAssessmentAgentsOutput{}
	req.Data = output
	return
}

// Lists the agents of the assessment specified by the assessment ARN.
func (c *Inspector) ListAssessmentAgents(input *ListAssessmentAgentsInput) (*ListAssessmentAgentsOutput, error) {
	req, out := c.ListAssessmentAgentsRequest(input)
	err := req.Send()
	return out, err
}

const opListAssessments = "ListAssessments"

// ListAssessmentsRequest generates a request for the ListAssessments operation.
func (c *Inspector) ListAssessmentsRequest(input *ListAssessmentsInput) (req *request.Request, output *ListAssessmentsOutput) {
	op := &request.Operation{
		Name:       opListAssessments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssessmentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAssessmentsOutput{}
	req.Data = output
	return
}

// Lists the assessments corresponding to applications specified by the applications'
// ARNs.
func (c *Inspector) ListAssessments(input *ListAssessmentsInput) (*ListAssessmentsOutput, error) {
	req, out := c.ListAssessmentsRequest(input)
	err := req.Send()
	return out, err
}

const opListAttachedAssessments = "ListAttachedAssessments"

// ListAttachedAssessmentsRequest generates a request for the ListAttachedAssessments operation.
func (c *Inspector) ListAttachedAssessmentsRequest(input *ListAttachedAssessmentsInput) (req *request.Request, output *ListAttachedAssessmentsOutput) {
	op := &request.Operation{
		Name:       opListAttachedAssessments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAttachedAssessmentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAttachedAssessmentsOutput{}
	req.Data = output
	return
}

// Lists the assessments attached to the rules package specified by the rules
// package ARN.
func (c *Inspector) ListAttachedAssessments(input *ListAttachedAssessmentsInput) (*ListAttachedAssessmentsOutput, error) {
	req, out := c.ListAttachedAssessmentsRequest(input)
	err := req.Send()
	return out, err
}

const opListAttachedRulesPackages = "ListAttachedRulesPackages"

// ListAttachedRulesPackagesRequest generates a request for the ListAttachedRulesPackages operation.
func (c *Inspector) ListAttachedRulesPackagesRequest(input *ListAttachedRulesPackagesInput) (req *request.Request, output *ListAttachedRulesPackagesOutput) {
	op := &request.Operation{
		Name:       opListAttachedRulesPackages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAttachedRulesPackagesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAttachedRulesPackagesOutput{}
	req.Data = output
	return
}

// Lists the rules packages attached to the assessment specified by the assessment
// ARN.
func (c *Inspector) ListAttachedRulesPackages(input *ListAttachedRulesPackagesInput) (*ListAttachedRulesPackagesOutput, error) {
	req, out := c.ListAttachedRulesPackagesRequest(input)
	err := req.Send()
	return out, err
}

const opListFindings = "ListFindings"

// ListFindingsRequest generates a request for the ListFindings operation.
func (c *Inspector) ListFindingsRequest(input *ListFindingsInput) (req *request.Request, output *ListFindingsOutput) {
	op := &request.Operation{
		Name:       opListFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListFindingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListFindingsOutput{}
	req.Data = output
	return
}

// Lists findings generated by the assessment run specified by the run ARNs.
func (c *Inspector) ListFindings(input *ListFindingsInput) (*ListFindingsOutput, error) {
	req, out := c.ListFindingsRequest(input)
	err := req.Send()
	return out, err
}

const opListRulesPackages = "ListRulesPackages"

// ListRulesPackagesRequest generates a request for the ListRulesPackages operation.
func (c *Inspector) ListRulesPackagesRequest(input *ListRulesPackagesInput) (req *request.Request, output *ListRulesPackagesOutput) {
	op := &request.Operation{
		Name:       opListRulesPackages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRulesPackagesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListRulesPackagesOutput{}
	req.Data = output
	return
}

// Lists all available Inspector rules packages.
func (c *Inspector) ListRulesPackages(input *ListRulesPackagesInput) (*ListRulesPackagesOutput, error) {
	req, out := c.ListRulesPackagesRequest(input)
	err := req.Send()
	return out, err
}

const opListRuns = "ListRuns"

// ListRunsRequest generates a request for the ListRuns operation.
func (c *Inspector) ListRunsRequest(input *ListRunsInput) (req *request.Request, output *ListRunsOutput) {
	op := &request.Operation{
		Name:       opListRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRunsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListRunsOutput{}
	req.Data = output
	return
}

// Lists the assessment runs associated with the assessments specified by the
// assessment ARNs.
func (c *Inspector) ListRuns(input *ListRunsInput) (*ListRunsOutput, error) {
	req, out := c.ListRunsRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a request for the ListTagsForResource operation.
func (c *Inspector) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

// Lists all tags associated with a resource.
func (c *Inspector) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opLocalizeText = "LocalizeText"

// LocalizeTextRequest generates a request for the LocalizeText operation.
func (c *Inspector) LocalizeTextRequest(input *LocalizeTextInput) (req *request.Request, output *LocalizeTextOutput) {
	op := &request.Operation{
		Name:       opLocalizeText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &LocalizeTextInput{}
	}

	req = c.newRequest(op, input, output)
	output = &LocalizeTextOutput{}
	req.Data = output
	return
}

// Translates a textual identifier into a user-readable text in a specified
// locale.
func (c *Inspector) LocalizeText(input *LocalizeTextInput) (*LocalizeTextOutput, error) {
	req, out := c.LocalizeTextRequest(input)
	err := req.Send()
	return out, err
}

const opPreviewAgentsForResourceGroup = "PreviewAgentsForResourceGroup"

// PreviewAgentsForResourceGroupRequest generates a request for the PreviewAgentsForResourceGroup operation.
func (c *Inspector) PreviewAgentsForResourceGroupRequest(input *PreviewAgentsForResourceGroupInput) (req *request.Request, output *PreviewAgentsForResourceGroupOutput) {
	op := &request.Operation{
		Name:       opPreviewAgentsForResourceGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PreviewAgentsForResourceGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PreviewAgentsForResourceGroupOutput{}
	req.Data = output
	return
}

// Previews the agents installed on the EC2 instances that are included in the
// application created with the specified resource group.
func (c *Inspector) PreviewAgentsForResourceGroup(input *PreviewAgentsForResourceGroupInput) (*PreviewAgentsForResourceGroupOutput, error) {
	req, out := c.PreviewAgentsForResourceGroupRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterCrossAccountAccessRole = "RegisterCrossAccountAccessRole"

// RegisterCrossAccountAccessRoleRequest generates a request for the RegisterCrossAccountAccessRole operation.
func (c *Inspector) RegisterCrossAccountAccessRoleRequest(input *RegisterCrossAccountAccessRoleInput) (req *request.Request, output *RegisterCrossAccountAccessRoleOutput) {
	op := &request.Operation{
		Name:       opRegisterCrossAccountAccessRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterCrossAccountAccessRoleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterCrossAccountAccessRoleOutput{}
	req.Data = output
	return
}

// Register the role that Inspector uses to list your EC2 instances during the
// assessment.
func (c *Inspector) RegisterCrossAccountAccessRole(input *RegisterCrossAccountAccessRoleInput) (*RegisterCrossAccountAccessRoleOutput, error) {
	req, out := c.RegisterCrossAccountAccessRoleRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveAttributesFromFindings = "RemoveAttributesFromFindings"

// RemoveAttributesFromFindingsRequest generates a request for the RemoveAttributesFromFindings operation.
func (c *Inspector) RemoveAttributesFromFindingsRequest(input *RemoveAttributesFromFindingsInput) (req *request.Request, output *RemoveAttributesFromFindingsOutput) {
	op := &request.Operation{
		Name:       opRemoveAttributesFromFindings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveAttributesFromFindingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveAttributesFromFindingsOutput{}
	req.Data = output
	return
}

// Removes the entire attribute (key and value pair) from the findings specified
// by the finding ARNs where an attribute with the specified key exists.
func (c *Inspector) RemoveAttributesFromFindings(input *RemoveAttributesFromFindingsInput) (*RemoveAttributesFromFindingsOutput, error) {
	req, out := c.RemoveAttributesFromFindingsRequest(input)
	err := req.Send()
	return out, err
}

const opRunAssessment = "RunAssessment"

// RunAssessmentRequest generates a request for the RunAssessment operation.
func (c *Inspector) RunAssessmentRequest(input *RunAssessmentInput) (req *request.Request, output *RunAssessmentOutput) {
	op := &request.Operation{
		Name:       opRunAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunAssessmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RunAssessmentOutput{}
	req.Data = output
	return
}

// Starts the analysis of the application’s behavior against selected rule packages
// for the assessment specified by the assessment ARN.
func (c *Inspector) RunAssessment(input *RunAssessmentInput) (*RunAssessmentOutput, error) {
	req, out := c.RunAssessmentRequest(input)
	err := req.Send()
	return out, err
}

const opSetTagsForResource = "SetTagsForResource"

// SetTagsForResourceRequest generates a request for the SetTagsForResource operation.
func (c *Inspector) SetTagsForResourceRequest(input *SetTagsForResourceInput) (req *request.Request, output *SetTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opSetTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetTagsForResourceOutput{}
	req.Data = output
	return
}

// Sets tags (key and value pairs) to the assessment specified by the assessment
// ARN.
func (c *Inspector) SetTagsForResource(input *SetTagsForResourceInput) (*SetTagsForResourceOutput, error) {
	req, out := c.SetTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opStartDataCollection = "StartDataCollection"

// StartDataCollectionRequest generates a request for the StartDataCollection operation.
func (c *Inspector) StartDataCollectionRequest(input *StartDataCollectionInput) (req *request.Request, output *StartDataCollectionOutput) {
	op := &request.Operation{
		Name:       opStartDataCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDataCollectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartDataCollectionOutput{}
	req.Data = output
	return
}

// Starts data collection for the assessment specified by the assessment ARN.
// For this API to function properly, you must not exceed the limit of running
// up to 500 concurrent agents per AWS account.
func (c *Inspector) StartDataCollection(input *StartDataCollectionInput) (*StartDataCollectionOutput, error) {
	req, out := c.StartDataCollectionRequest(input)
	err := req.Send()
	return out, err
}

const opStopDataCollection = "StopDataCollection"

// StopDataCollectionRequest generates a request for the StopDataCollection operation.
func (c *Inspector) StopDataCollectionRequest(input *StopDataCollectionInput) (req *request.Request, output *StopDataCollectionOutput) {
	op := &request.Operation{
		Name:       opStopDataCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDataCollectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopDataCollectionOutput{}
	req.Data = output
	return
}

// Stop data collection for the assessment specified by the assessment ARN.
func (c *Inspector) StopDataCollection(input *StopDataCollectionInput) (*StopDataCollectionOutput, error) {
	req, out := c.StopDataCollectionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a request for the UpdateApplication operation.
func (c *Inspector) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateApplicationOutput{}
	req.Data = output
	return
}

// Updates application specified by the application ARN.
func (c *Inspector) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAssessment = "UpdateAssessment"

// UpdateAssessmentRequest generates a request for the UpdateAssessment operation.
func (c *Inspector) UpdateAssessmentRequest(input *UpdateAssessmentInput) (req *request.Request, output *UpdateAssessmentOutput) {
	op := &request.Operation{
		Name:       opUpdateAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssessmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAssessmentOutput{}
	req.Data = output
	return
}

// Updates the assessment specified by the assessment ARN.
func (c *Inspector) UpdateAssessment(input *UpdateAssessmentInput) (*UpdateAssessmentOutput, error) {
	req, out := c.UpdateAssessmentRequest(input)
	err := req.Send()
	return out, err
}

type AddAttributesToFindingsInput struct {
	// The array of attributes that you want to assign to specified findings.
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// The ARNs specifying the findings that you want to assign attributes to.
	FindingArns []*string `locationName:"findingArns" type:"list"`

	metadataAddAttributesToFindingsInput `json:"-" xml:"-"`
}

type metadataAddAttributesToFindingsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddAttributesToFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttributesToFindingsInput) GoString() string {
	return s.String()
}

type AddAttributesToFindingsOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataAddAttributesToFindingsOutput `json:"-" xml:"-"`
}

type metadataAddAttributesToFindingsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddAttributesToFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttributesToFindingsOutput) GoString() string {
	return s.String()
}

// Contains information about an Inspector agent. This data type is used as
// a response element in the ListAssessmentAgents action.
type Agent struct {
	// AWS account of the EC2 instance where the agent is installed.
	AccountId *string `locationName:"accountId" type:"string"`

	// The current health state of the agent. Values can be set to HEALTHY or UNHEALTHY.
	AgentHealth *string `locationName:"agentHealth" type:"string"`

	// The detailed health state of the agent. Values can be set to RUNNING, HEALTHY,
	// UNHEALTHY, UNKNOWN, BLACKLISTED, SHUTDOWN, THROTTLED.
	AgentHealthCode *string `locationName:"agentHealthCode" type:"string"`

	// The description for the agent health code.
	AgentHealthDetails *string `locationName:"agentHealthDetails" type:"string"`

	// The EC2 instance ID where the agent is installed.
	AgentId *string `locationName:"agentId" type:"string"`

	// The ARN of the assessment that is associated with the agent.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	// This data type property is currently not used.
	AutoScalingGroup *string `locationName:"autoScalingGroup" type:"string"`

	// The Inspector application data metrics collected by the agent.
	Telemetry []*Telemetry `locationName:"telemetry" type:"list"`

	metadataAgent `json:"-" xml:"-"`
}

type metadataAgent struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Agent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Agent) GoString() string {
	return s.String()
}

// This data type is used as a response element in the PreviewAgentsForResourceGroup
// action.
type AgentPreview struct {
	// The id of the EC2 instance where the agent is intalled.
	AgentId *string `locationName:"agentId" type:"string"`

	// The autoscaling group for the EC2 instance where the agent is installed.
	AutoScalingGroup *string `locationName:"autoScalingGroup" type:"string"`

	metadataAgentPreview `json:"-" xml:"-"`
}

type metadataAgentPreview struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AgentPreview) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentPreview) GoString() string {
	return s.String()
}

// This data type is used as a response element in the ListAssessmentAgents
// action.
type AgentsFilter struct {
	// For a record to match a filter, the value specified for this data type property
	// must be the exact match of the value of the agentHealth property of the Agent
	// data type.
	AgentHealthList []*string `locationName:"agentHealthList" type:"list"`

	metadataAgentsFilter `json:"-" xml:"-"`
}

type metadataAgentsFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AgentsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentsFilter) GoString() string {
	return s.String()
}

// Contains information about an Inspector application.
//
// This data type is used as the response element in the DescribeApplication
// action.
type Application struct {
	// The ARN specifying the Inspector application.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The name of the Inspector application.
	ApplicationName *string `locationName:"applicationName" type:"string"`

	// The ARN specifying the resource group that is associated with the application.
	ResourceGroupArn *string `locationName:"resourceGroupArn" type:"string"`

	metadataApplication `json:"-" xml:"-"`
}

type metadataApplication struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Application) GoString() string {
	return s.String()
}

// This data type is used as the request parameter in the ListApplications action.
type ApplicationsFilter struct {
	// For a record to match a filter, an explicit value or a string containing
	// a wildcard specified for this data type property must match the value of
	// the applicationName property of the Application data type.
	ApplicationNamePatterns []*string `locationName:"applicationNamePatterns" type:"list"`

	metadataApplicationsFilter `json:"-" xml:"-"`
}

type metadataApplicationsFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ApplicationsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplicationsFilter) GoString() string {
	return s.String()
}

// Contains information about an Inspector assessment.
//
// This data type is used as the response element in the DescribeAssessment
// action.
type Assessment struct {
	// The ARN of the application that corresponds to this assessment.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The ARN of the assessment.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	// The name of the assessment.
	AssessmentName *string `locationName:"assessmentName" type:"string"`

	// The state of the assessment. Values can be set to Created, Collecting Data,
	// Stopping, and Completed.
	AssessmentState *string `locationName:"assessmentState" type:"string"`

	// Boolean value (true or false) specifying whether the data collection process
	// is completed.
	DataCollected *bool `locationName:"dataCollected" type:"boolean"`

	// The assessment duration in seconds. The default value is 3600 seconds (one
	// hour). The maximum value is 86400 seconds (one day).
	DurationInSeconds *int64 `locationName:"durationInSeconds" type:"integer"`

	// The assessment end time.
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"unix"`

	// This data type property is not currently used.
	FailureMessage *string `locationName:"failureMessage" type:"string"`

	// The assessment start time.
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"unix"`

	// The user-defined attributes that are assigned to every generated finding.
	UserAttributesForFindings []*Attribute `locationName:"userAttributesForFindings" type:"list"`

	metadataAssessment `json:"-" xml:"-"`
}

type metadataAssessment struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Assessment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Assessment) GoString() string {
	return s.String()
}

// This data type is used as the request parameter in the ListAssessments and
// ListAttachedAssessments actions.
type AssessmentsFilter struct {
	// For a record to match a filter, an explicit value or a string containing
	// a wildcard specified for this data type property must match the value of
	// the assessmentName property of the Assessment data type.
	AssessmentNamePatterns []*string `locationName:"assessmentNamePatterns" type:"list"`

	// For a record to match a filter, the value specified for this data type property
	// must be the exact match of the value of the assessmentState property of the
	// Assessment data type.
	AssessmentStates []*string `locationName:"assessmentStates" type:"list"`

	// For a record to match a filter, the value specified for this data type property
	// must be the exact match of the value of the dataCollected property of the
	// Assessment data type.
	DataCollected *bool `locationName:"dataCollected" type:"boolean"`

	// For a record to match a filter, the value specified for this data type property
	// must inclusively match any value between the specified minimum and maximum
	// values of the durationInSeconds property of the Assessment data type.
	DurationRange *DurationRange `locationName:"durationRange" type:"structure"`

	// For a record to match a filter, the value specified for this data type property
	// must inclusively match any value between the specified minimum and maximum
	// values of the endTime property of the Assessment data type.
	EndTimeRange *TimestampRange `locationName:"endTimeRange" type:"structure"`

	// For a record to match a filter, the value specified for this data type property
	// must inclusively match any value between the specified minimum and maximum
	// values of the startTime property of the Assessment data type.
	StartTimeRange *TimestampRange `locationName:"startTimeRange" type:"structure"`

	metadataAssessmentsFilter `json:"-" xml:"-"`
}

type metadataAssessmentsFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssessmentsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssessmentsFilter) GoString() string {
	return s.String()
}

type AttachAssessmentAndRulesPackageInput struct {
	// The ARN specifying the assessment to which you want to attach a rules package.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	// The ARN specifying the rules package that you want to attach to the assessment.
	RulesPackageArn *string `locationName:"rulesPackageArn" type:"string"`

	metadataAttachAssessmentAndRulesPackageInput `json:"-" xml:"-"`
}

type metadataAttachAssessmentAndRulesPackageInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AttachAssessmentAndRulesPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachAssessmentAndRulesPackageInput) GoString() string {
	return s.String()
}

type AttachAssessmentAndRulesPackageOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataAttachAssessmentAndRulesPackageOutput `json:"-" xml:"-"`
}

type metadataAttachAssessmentAndRulesPackageOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AttachAssessmentAndRulesPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachAssessmentAndRulesPackageOutput) GoString() string {
	return s.String()
}

// This data type is used as a response element in the AddAttributesToFindings
// action and a request parameter in the CreateAssessment action.
type Attribute struct {
	// The attribute key.
	Key *string `locationName:"key" type:"string"`

	// The value assigned to the attribute key.
	Value *string `locationName:"value" type:"string"`

	metadataAttribute `json:"-" xml:"-"`
}

type metadataAttribute struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attribute) GoString() string {
	return s.String()
}

type CreateApplicationInput struct {
	// The user-defined name identifying the application that you want to create.
	// The name must be unique within the AWS account.
	ApplicationName *string `locationName:"applicationName" type:"string"`

	// The ARN specifying the resource group that is used to create the application.
	ResourceGroupArn *string `locationName:"resourceGroupArn" type:"string"`

	metadataCreateApplicationInput `json:"-" xml:"-"`
}

type metadataCreateApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

type CreateApplicationOutput struct {
	// The ARN specifying the application that is created.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	metadataCreateApplicationOutput `json:"-" xml:"-"`
}

type metadataCreateApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

type CreateAssessmentInput struct {
	// The ARN specifying the application for which you want to create an assessment.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The user-defined name identifying the assessment that you want to create.
	// You can create several assessments for an application. The names of the assessments
	// corresponding to a particular application must be unique.
	AssessmentName *string `locationName:"assessmentName" type:"string"`

	// The duration of the assessment in seconds. The default value is 3600 seconds
	// (one hour). The maximum value is 86400 seconds (one day).
	DurationInSeconds *int64 `locationName:"durationInSeconds" type:"integer"`

	// The user-defined attributes that are assigned to every finding generated
	// by running this assessment.
	UserAttributesForFindings []*Attribute `locationName:"userAttributesForFindings" type:"list"`

	metadataCreateAssessmentInput `json:"-" xml:"-"`
}

type metadataCreateAssessmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentInput) GoString() string {
	return s.String()
}

type CreateAssessmentOutput struct {
	// The ARN specifying the assessment that is created.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	metadataCreateAssessmentOutput `json:"-" xml:"-"`
}

type metadataCreateAssessmentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAssessmentOutput) GoString() string {
	return s.String()
}

type CreateResourceGroupInput struct {
	// A collection of keys and an array of possible values in JSON format.
	//
	// For example, [{ "key1" : ["Value1","Value2"]},{"Key2": ["Value3"]}]
	ResourceGroupTags *string `locationName:"resourceGroupTags" type:"string"`

	metadataCreateResourceGroupInput `json:"-" xml:"-"`
}

type metadataCreateResourceGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateResourceGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceGroupInput) GoString() string {
	return s.String()
}

type CreateResourceGroupOutput struct {
	// The ARN specifying the resource group that is created.
	ResourceGroupArn *string `locationName:"resourceGroupArn" type:"string"`

	metadataCreateResourceGroupOutput `json:"-" xml:"-"`
}

type metadataCreateResourceGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateResourceGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceGroupOutput) GoString() string {
	return s.String()
}

type DeleteApplicationInput struct {
	// The ARN specifying the application that you want to delete.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	metadataDeleteApplicationInput `json:"-" xml:"-"`
}

type metadataDeleteApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

type DeleteApplicationOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataDeleteApplicationOutput `json:"-" xml:"-"`
}

type metadataDeleteApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DeleteAssessmentInput struct {
	// The ARN specifying the assessment that you want to delete.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	metadataDeleteAssessmentInput `json:"-" xml:"-"`
}

type metadataDeleteAssessmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentInput) GoString() string {
	return s.String()
}

type DeleteAssessmentOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataDeleteAssessmentOutput `json:"-" xml:"-"`
}

type metadataDeleteAssessmentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAssessmentOutput) GoString() string {
	return s.String()
}

type DeleteRunInput struct {
	// The ARN specifying the assessment run that you want to delete.
	RunArn *string `locationName:"runArn" type:"string"`

	metadataDeleteRunInput `json:"-" xml:"-"`
}

type metadataDeleteRunInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRunInput) GoString() string {
	return s.String()
}

type DeleteRunOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataDeleteRunOutput `json:"-" xml:"-"`
}

type metadataDeleteRunOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRunOutput) GoString() string {
	return s.String()
}

type DescribeApplicationInput struct {
	// The ARN specifying the application that you want to describe.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	metadataDescribeApplicationInput `json:"-" xml:"-"`
}

type metadataDescribeApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationInput) GoString() string {
	return s.String()
}

type DescribeApplicationOutput struct {
	// Information about the application.
	Application *Application `locationName:"application" type:"structure"`

	metadataDescribeApplicationOutput `json:"-" xml:"-"`
}

type metadataDescribeApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicationOutput) GoString() string {
	return s.String()
}

type DescribeAssessmentInput struct {
	// The ARN specifying the assessment that you want to describe.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	metadataDescribeAssessmentInput `json:"-" xml:"-"`
}

type metadataDescribeAssessmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssessmentInput) GoString() string {
	return s.String()
}

type DescribeAssessmentOutput struct {
	// Information about the assessment.
	Assessment *Assessment `locationName:"assessment" type:"structure"`

	metadataDescribeAssessmentOutput `json:"-" xml:"-"`
}

type metadataDescribeAssessmentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAssessmentOutput) GoString() string {
	return s.String()
}

type DescribeCrossAccountAccessRoleInput struct {
	metadataDescribeCrossAccountAccessRoleInput `json:"-" xml:"-"`
}

type metadataDescribeCrossAccountAccessRoleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCrossAccountAccessRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCrossAccountAccessRoleInput) GoString() string {
	return s.String()
}

type DescribeCrossAccountAccessRoleOutput struct {
	// The ARN specifying the IAM role that Inspector uses to access your AWS account.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// A Boolean value that specifies whether the IAM role has the necessary policies
	// attached to enable Inspector to access your AWS account.
	Valid *bool `locationName:"valid" type:"boolean"`

	metadataDescribeCrossAccountAccessRoleOutput `json:"-" xml:"-"`
}

type metadataDescribeCrossAccountAccessRoleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCrossAccountAccessRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCrossAccountAccessRoleOutput) GoString() string {
	return s.String()
}

type DescribeFindingInput struct {
	// The ARN specifying the finding that you want to describe.
	FindingArn *string `locationName:"findingArn" type:"string"`

	metadataDescribeFindingInput `json:"-" xml:"-"`
}

type metadataDescribeFindingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeFindingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFindingInput) GoString() string {
	return s.String()
}

type DescribeFindingOutput struct {
	// Information about the finding.
	Finding *Finding `locationName:"finding" type:"structure"`

	metadataDescribeFindingOutput `json:"-" xml:"-"`
}

type metadataDescribeFindingOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeFindingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFindingOutput) GoString() string {
	return s.String()
}

type DescribeResourceGroupInput struct {
	// The ARN specifying the resource group that you want to describe.
	ResourceGroupArn *string `locationName:"resourceGroupArn" type:"string"`

	metadataDescribeResourceGroupInput `json:"-" xml:"-"`
}

type metadataDescribeResourceGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeResourceGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceGroupInput) GoString() string {
	return s.String()
}

type DescribeResourceGroupOutput struct {
	// Information about the resource group.
	ResourceGroup *ResourceGroup `locationName:"resourceGroup" type:"structure"`

	metadataDescribeResourceGroupOutput `json:"-" xml:"-"`
}

type metadataDescribeResourceGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeResourceGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeResourceGroupOutput) GoString() string {
	return s.String()
}

type DescribeRulesPackageInput struct {
	// The ARN specifying the rules package that you want to describe.
	RulesPackageArn *string `locationName:"rulesPackageArn" type:"string"`

	metadataDescribeRulesPackageInput `json:"-" xml:"-"`
}

type metadataDescribeRulesPackageInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeRulesPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRulesPackageInput) GoString() string {
	return s.String()
}

type DescribeRulesPackageOutput struct {
	// Information about the rules package.
	RulesPackage *RulesPackage `locationName:"rulesPackage" type:"structure"`

	metadataDescribeRulesPackageOutput `json:"-" xml:"-"`
}

type metadataDescribeRulesPackageOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeRulesPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRulesPackageOutput) GoString() string {
	return s.String()
}

type DescribeRunInput struct {
	// The ARN specifying the assessment run that you want to describe.
	RunArn *string `locationName:"runArn" type:"string"`

	metadataDescribeRunInput `json:"-" xml:"-"`
}

type metadataDescribeRunInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRunInput) GoString() string {
	return s.String()
}

type DescribeRunOutput struct {
	// Information about the assessment run.
	Run *Run `locationName:"run" type:"structure"`

	metadataDescribeRunOutput `json:"-" xml:"-"`
}

type metadataDescribeRunOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRunOutput) GoString() string {
	return s.String()
}

type DetachAssessmentAndRulesPackageInput struct {
	// The ARN specifying the assessment from which you want to detach a rules package.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	// The ARN specifying the rules package that you want to detach from the assessment.
	RulesPackageArn *string `locationName:"rulesPackageArn" type:"string"`

	metadataDetachAssessmentAndRulesPackageInput `json:"-" xml:"-"`
}

type metadataDetachAssessmentAndRulesPackageInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DetachAssessmentAndRulesPackageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachAssessmentAndRulesPackageInput) GoString() string {
	return s.String()
}

type DetachAssessmentAndRulesPackageOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataDetachAssessmentAndRulesPackageOutput `json:"-" xml:"-"`
}

type metadataDetachAssessmentAndRulesPackageOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DetachAssessmentAndRulesPackageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachAssessmentAndRulesPackageOutput) GoString() string {
	return s.String()
}

// This data type is used in the AssessmentsFilter data type.
type DurationRange struct {
	// The maximum value of the duration range. Must be less than or equal to 604800
	// seconds (1 week).
	Maximum *int64 `locationName:"maximum" type:"integer"`

	// The minimum value of the duration range. Must be greater than zero.
	Minimum *int64 `locationName:"minimum" type:"integer"`

	metadataDurationRange `json:"-" xml:"-"`
}

type metadataDurationRange struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DurationRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DurationRange) GoString() string {
	return s.String()
}

// Contains information about an Inspector finding.
//
// This data type is used as the response element in the DescribeFinding action.
type Finding struct {
	// The EC2 instance ID where the agent is installed that is used during the
	// assessment that generates the finding.
	AgentId *string `locationName:"agentId" type:"string"`

	// The system-defined attributes for the finding.
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// The autoscaling group of the EC2 instance where the agent is installed that
	// is used during the assessment that generates the finding.
	AutoScalingGroup *string `locationName:"autoScalingGroup" type:"string"`

	// The description of the finding.
	Description *LocalizedText `locationName:"description" type:"structure"`

	// A short description that identifies the finding.
	Finding *LocalizedText `locationName:"finding" type:"structure"`

	// The ARN specifying the finding.
	FindingArn *string `locationName:"findingArn" type:"string"`

	// The recommendation for the finding.
	Recommendation *LocalizedText `locationName:"recommendation" type:"structure"`

	// The rule name that is used to generate the finding.
	RuleName *string `locationName:"ruleName" type:"string"`

	// The ARN of the rules package that is used to generate the finding.
	RulesPackageArn *string `locationName:"rulesPackageArn" type:"string"`

	// The ARN of the assessment run that generated the finding.
	RunArn *string `locationName:"runArn" type:"string"`

	// The finding severity. Values can be set to High, Medium, Low, and Informational.
	Severity *string `locationName:"severity" type:"string"`

	// The user-defined attributes that are assigned to the finding.
	UserAttributes []*Attribute `locationName:"userAttributes" type:"list"`

	metadataFinding `json:"-" xml:"-"`
}

type metadataFinding struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Finding) GoString() string {
	return s.String()
}

// This data type is used as a request parameter in the ListFindings action.
type FindingsFilter struct {
	// For a record to match a filter, the value specified for this data type property
	// must be the exact match of the value of the attributes property of the Finding
	// data type.
	Attributes []*Attribute `locationName:"attributes" type:"list"`

	// For a record to match a filter, the value specified for this data type property
	// must be the exact match of the value of the ruleName property of the Finding
	// data type.
	RuleNames []*string `locationName:"ruleNames" type:"list"`

	// For a record to match a filter, the value specified for this data type property
	// must be the exact match of the value of the rulesPackageArn property of the
	// Finding data type.
	RulesPackageArns []*string `locationName:"rulesPackageArns" type:"list"`

	// For a record to match a filter, the value specified for this data type property
	// must be the exact match of the value of the severity property of the Finding
	// data type.
	Severities []*string `locationName:"severities" type:"list"`

	// For a record to match a filter, the value specified for this data type property
	// must be the exact match of the value of the userAttributes property of the
	// Finding data type.
	UserAttributes []*Attribute `locationName:"userAttributes" type:"list"`

	metadataFindingsFilter `json:"-" xml:"-"`
}

type metadataFindingsFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s FindingsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FindingsFilter) GoString() string {
	return s.String()
}

type GetAssessmentTelemetryInput struct {
	// The ARN specifying the assessment the telemetry of which you want to obtain.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	metadataGetAssessmentTelemetryInput `json:"-" xml:"-"`
}

type metadataGetAssessmentTelemetryInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetAssessmentTelemetryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentTelemetryInput) GoString() string {
	return s.String()
}

type GetAssessmentTelemetryOutput struct {
	// Telemetry details.
	Telemetry []*Telemetry `locationName:"telemetry" type:"list"`

	metadataGetAssessmentTelemetryOutput `json:"-" xml:"-"`
}

type metadataGetAssessmentTelemetryOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetAssessmentTelemetryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAssessmentTelemetryOutput) GoString() string {
	return s.String()
}

type ListApplicationsInput struct {
	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *ApplicationsFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to 'null' on your first call to the ListApplications action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListApplicationsInput `json:"-" xml:"-"`
}

type metadataListApplicationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

type ListApplicationsOutput struct {
	// A list of ARNs specifying the applications returned by the action.
	ApplicationArnList []*string `locationName:"applicationArnList" type:"list"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to 'null'.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListApplicationsOutput `json:"-" xml:"-"`
}

type metadataListApplicationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

type ListAssessmentAgentsInput struct {
	// The ARN specifying the assessment whose agents you want to list.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AgentsFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to 'null' on your first call to the ListAssessmentAgents action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListAssessmentAgentsInput `json:"-" xml:"-"`
}

type metadataListAssessmentAgentsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAssessmentAgentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentAgentsInput) GoString() string {
	return s.String()
}

type ListAssessmentAgentsOutput struct {
	// A list of ARNs specifying the agents returned by the action.
	AgentList []*Agent `locationName:"agentList" type:"list"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to 'null'.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListAssessmentAgentsOutput `json:"-" xml:"-"`
}

type metadataListAssessmentAgentsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAssessmentAgentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentAgentsOutput) GoString() string {
	return s.String()
}

type ListAssessmentsInput struct {
	// A list of ARNs specifying the applications the assessments of which you want
	// to list.
	ApplicationArns []*string `locationName:"applicationArns" type:"list"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AssessmentsFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to 'null' on your first call to the ListAssessments action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListAssessmentsInput `json:"-" xml:"-"`
}

type metadataListAssessmentsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAssessmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentsInput) GoString() string {
	return s.String()
}

type ListAssessmentsOutput struct {
	// A list of ARNs specifying the assessments returned by the action.
	AssessmentArnList []*string `locationName:"assessmentArnList" type:"list"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to 'null'.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListAssessmentsOutput `json:"-" xml:"-"`
}

type metadataListAssessmentsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAssessmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAssessmentsOutput) GoString() string {
	return s.String()
}

type ListAttachedAssessmentsInput struct {
	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *AssessmentsFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to 'null' on your first call to the ListAttachedAssessments action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN specifying the rules package whose assessments you want to list.
	RulesPackageArn *string `locationName:"rulesPackageArn" type:"string"`

	metadataListAttachedAssessmentsInput `json:"-" xml:"-"`
}

type metadataListAttachedAssessmentsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAttachedAssessmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedAssessmentsInput) GoString() string {
	return s.String()
}

type ListAttachedAssessmentsOutput struct {
	// A list of ARNs specifying the assessments returned by the action.
	AssessmentArnList []*string `locationName:"assessmentArnList" type:"list"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to 'null'.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListAttachedAssessmentsOutput `json:"-" xml:"-"`
}

type metadataListAttachedAssessmentsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAttachedAssessmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedAssessmentsOutput) GoString() string {
	return s.String()
}

type ListAttachedRulesPackagesInput struct {
	// The ARN specifying the assessment whose rules packages you want to list.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to 'null' on your first call to the ListAttachedRulesPackages action.
	// Subsequent calls to the action fill nextToken in the request with the value
	// of NextToken from previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListAttachedRulesPackagesInput `json:"-" xml:"-"`
}

type metadataListAttachedRulesPackagesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAttachedRulesPackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedRulesPackagesInput) GoString() string {
	return s.String()
}

type ListAttachedRulesPackagesOutput struct {
	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to 'null'.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of ARNs specifying the rules packages returned by the action.
	RulesPackageArnList []*string `locationName:"rulesPackageArnList" type:"list"`

	metadataListAttachedRulesPackagesOutput `json:"-" xml:"-"`
}

type metadataListAttachedRulesPackagesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAttachedRulesPackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedRulesPackagesOutput) GoString() string {
	return s.String()
}

type ListFindingsInput struct {
	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *FindingsFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to 'null' on your first call to the ListFindings action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARNs of the assessment runs that generate the findings that you want
	// to list.
	RunArns []*string `locationName:"runArns" type:"list"`

	metadataListFindingsInput `json:"-" xml:"-"`
}

type metadataListFindingsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsInput) GoString() string {
	return s.String()
}

type ListFindingsOutput struct {
	// A list of ARNs specifying the findings returned by the action.
	FindingArnList []*string `locationName:"findingArnList" type:"list"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to 'null'.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListFindingsOutput `json:"-" xml:"-"`
}

type metadataListFindingsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFindingsOutput) GoString() string {
	return s.String()
}

type ListRulesPackagesInput struct {
	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to 'null' on your first call to the ListRulesPackages action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListRulesPackagesInput `json:"-" xml:"-"`
}

type metadataListRulesPackagesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListRulesPackagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesPackagesInput) GoString() string {
	return s.String()
}

type ListRulesPackagesOutput struct {
	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to 'null'.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of ARNs specifying the rules packages returned by the action.
	RulesPackageArnList []*string `locationName:"rulesPackageArnList" type:"list"`

	metadataListRulesPackagesOutput `json:"-" xml:"-"`
}

type metadataListRulesPackagesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListRulesPackagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesPackagesOutput) GoString() string {
	return s.String()
}

type ListRunsInput struct {
	// The ARNs specifying the assessments whose runs you want to list.
	AssessmentArns []*string `locationName:"assessmentArns" type:"list"`

	// You can use this parameter to specify a subset of data to be included in
	// the action's response.
	//
	// For a record to match a filter, all specified filter attributes must match.
	// When multiple values are specified for a filter attribute, any of the values
	// can match.
	Filter *RunsFilter `locationName:"filter" type:"structure"`

	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to 'null' on your first call to the ListRuns action. Subsequent
	// calls to the action fill nextToken in the request with the value of NextToken
	// from previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListRunsInput `json:"-" xml:"-"`
}

type metadataListRunsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRunsInput) GoString() string {
	return s.String()
}

type ListRunsOutput struct {
	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to 'null'.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of ARNs specifying the assessment runs returned by the action.
	RunArnList []*string `locationName:"runArnList" type:"list"`

	metadataListRunsOutput `json:"-" xml:"-"`
}

type metadataListRunsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRunsOutput) GoString() string {
	return s.String()
}

type ListTagsForResourceInput struct {
	// The ARN specifying the resource whose tags you want to list.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	metadataListTagsForResourceInput `json:"-" xml:"-"`
}

type metadataListTagsForResourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

type ListTagsForResourceOutput struct {
	// A collection of key and value pairs.
	TagList []*Tag `locationName:"tagList" type:"list"`

	metadataListTagsForResourceOutput `json:"-" xml:"-"`
}

type metadataListTagsForResourceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

type LocalizeTextInput struct {
	// The locale that you want to translate a textual identifier into.
	Locale *string `locationName:"locale" type:"string"`

	// A list of textual identifiers.
	LocalizedTexts []*LocalizedText `locationName:"localizedTexts" type:"list"`

	metadataLocalizeTextInput `json:"-" xml:"-"`
}

type metadataLocalizeTextInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LocalizeTextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalizeTextInput) GoString() string {
	return s.String()
}

type LocalizeTextOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	// The resulting list of user-readable texts.
	Results []*string `locationName:"results" type:"list"`

	metadataLocalizeTextOutput `json:"-" xml:"-"`
}

type metadataLocalizeTextOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LocalizeTextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalizeTextOutput) GoString() string {
	return s.String()
}

// The textual identifier. This data type is used as the request parameter in
// the LocalizeText action.
type LocalizedText struct {
	// The facility and id properties of the LocalizedTextKey data type.
	Key *LocalizedTextKey `locationName:"key" type:"structure"`

	// Values for the dynamic elements of the string specified by the textual identifier.
	Parameters []*Parameter `locationName:"parameters" type:"list"`

	metadataLocalizedText `json:"-" xml:"-"`
}

type metadataLocalizedText struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LocalizedText) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalizedText) GoString() string {
	return s.String()
}

// This data type is used in the LocalizedText data type.
type LocalizedTextKey struct {
	// The module response source of the text.
	Facility *string `locationName:"facility" type:"string"`

	// Part of the module response source of the text.
	Id *string `locationName:"id" type:"string"`

	metadataLocalizedTextKey `json:"-" xml:"-"`
}

type metadataLocalizedTextKey struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LocalizedTextKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LocalizedTextKey) GoString() string {
	return s.String()
}

// This data type is used in the Telemetry data type.
//
// This is metadata about the behavioral data collected by the Inspector agent
// on your EC2 instances during an assessment and passed to the Inspector service
// for analysis.
type MessageTypeTelemetry struct {
	// The number of times that the behavioral data is collected by the agent during
	// an assessment.
	Count *int64 `locationName:"count" type:"long"`

	// The total size of the behavioral data that is collected by the agent during
	// an assessment.
	DataSize *int64 `locationName:"dataSize" type:"long"`

	// A specific type of behavioral data that is collected by the agent.
	MessageType *string `locationName:"messageType" type:"string"`

	metadataMessageTypeTelemetry `json:"-" xml:"-"`
}

type metadataMessageTypeTelemetry struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s MessageTypeTelemetry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageTypeTelemetry) GoString() string {
	return s.String()
}

// This data type is used in the LocalizedText data type.
type Parameter struct {
	// The name of the variable that is being replaced.
	Name *string `locationName:"name" type:"string"`

	// The value assigned to the variable that is being replaced.
	Value *string `locationName:"value" type:"string"`

	metadataParameter `json:"-" xml:"-"`
}

type metadataParameter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

type PreviewAgentsForResourceGroupInput struct {
	// You can use this parameter to indicate the maximum number of items you want
	// in the response. The default value is 10. The maximum value is 500.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// You can use this parameter when paginating results. Set the value of this
	// parameter to 'null' on your first call to the PreviewAgentsForResourceGroup
	// action. Subsequent calls to the action fill nextToken in the request with
	// the value of NextToken from previous response to continue listing data.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN of the resource group that is used to create an application.
	ResourceGroupArn *string `locationName:"resourceGroupArn" type:"string"`

	metadataPreviewAgentsForResourceGroupInput `json:"-" xml:"-"`
}

type metadataPreviewAgentsForResourceGroupInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PreviewAgentsForResourceGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PreviewAgentsForResourceGroupInput) GoString() string {
	return s.String()
}

type PreviewAgentsForResourceGroupOutput struct {
	// The resulting list of agents.
	AgentPreviewList []*AgentPreview `locationName:"agentPreviewList" type:"list"`

	// When a response is generated, if there is more data to be listed, this parameter
	// is present in the response and contains the value to use for the nextToken
	// parameter in a subsequent pagination request. If there is no more data to
	// be listed, this parameter is set to 'null'.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataPreviewAgentsForResourceGroupOutput `json:"-" xml:"-"`
}

type metadataPreviewAgentsForResourceGroupOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PreviewAgentsForResourceGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PreviewAgentsForResourceGroupOutput) GoString() string {
	return s.String()
}

type RegisterCrossAccountAccessRoleInput struct {
	// The ARN of the IAM role that Inspector uses to list your EC2 instances during
	// the assessment.
	RoleArn *string `locationName:"roleArn" type:"string"`

	metadataRegisterCrossAccountAccessRoleInput `json:"-" xml:"-"`
}

type metadataRegisterCrossAccountAccessRoleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterCrossAccountAccessRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCrossAccountAccessRoleInput) GoString() string {
	return s.String()
}

type RegisterCrossAccountAccessRoleOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataRegisterCrossAccountAccessRoleOutput `json:"-" xml:"-"`
}

type metadataRegisterCrossAccountAccessRoleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterCrossAccountAccessRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterCrossAccountAccessRoleOutput) GoString() string {
	return s.String()
}

type RemoveAttributesFromFindingsInput struct {
	// The array of attribute keys that you want to remove from specified findings.
	AttributeKeys []*string `locationName:"attributeKeys" type:"list"`

	// The ARNs specifying the findings that you want to remove attributes from.
	FindingArns []*string `locationName:"findingArns" type:"list"`

	metadataRemoveAttributesFromFindingsInput `json:"-" xml:"-"`
}

type metadataRemoveAttributesFromFindingsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemoveAttributesFromFindingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAttributesFromFindingsInput) GoString() string {
	return s.String()
}

type RemoveAttributesFromFindingsOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataRemoveAttributesFromFindingsOutput `json:"-" xml:"-"`
}

type metadataRemoveAttributesFromFindingsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemoveAttributesFromFindingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveAttributesFromFindingsOutput) GoString() string {
	return s.String()
}

// Contains information about a resource group. The resource group defines a
// set of tags that, when queried, identify the AWS resources that comprise
// the application.
//
// This data type is used as the response element in the DescribeResourceGroup
// action.
type ResourceGroup struct {
	// The ARN of the resource group.
	ResourceGroupArn *string `locationName:"resourceGroupArn" type:"string"`

	// The tags (key and value pairs) of the resource group.
	//
	// This data type property is used in the CreateResourceGroup action.
	//
	// A collection of keys and an array of possible values in JSON format.
	//
	// For example, [{ "key1" : ["Value1","Value2"]},{"Key2": ["Value3"]}]
	ResourceGroupTags *string `locationName:"resourceGroupTags" type:"string"`

	metadataResourceGroup `json:"-" xml:"-"`
}

type metadataResourceGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ResourceGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceGroup) GoString() string {
	return s.String()
}

// Contains information about an Inspector rules package.
//
// This data type is used as the response element in the DescribeRulesPackage
// action.
type RulesPackage struct {
	// The description of the rules package.
	Description *LocalizedText `locationName:"description" type:"structure"`

	// The provider of the rules package.
	Provider *string `locationName:"provider" type:"string"`

	// The ARN of the rules package.
	RulesPackageArn *string `locationName:"rulesPackageArn" type:"string"`

	// The name of the rules package.
	RulesPackageName *string `locationName:"rulesPackageName" type:"string"`

	// The version id of the rules package.
	Version *string `locationName:"version" type:"string"`

	metadataRulesPackage `json:"-" xml:"-"`
}

type metadataRulesPackage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RulesPackage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RulesPackage) GoString() string {
	return s.String()
}

// A snapshot of an Inspector assessment that contains the assessment's findings.
//
// This data type is used as the response element in the DescribeRun action.
type Run struct {
	// The ARN of the assessment that is associated with the run.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	// Run completion time that corresponds to the rules packages evaluation completion
	// time or failure.
	CompletionTime *time.Time `locationName:"completionTime" type:"timestamp" timestampFormat:"unix"`

	// Run creation time that corresponds to the data collection completion time
	// or failure.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"unix"`

	// Rules packages selected for the run of the assessment.
	RulesPackages []*string `locationName:"rulesPackages" type:"list"`

	// The ARN of the run.
	RunArn *string `locationName:"runArn" type:"string"`

	// The auto-generated name for the run.
	RunName *string `locationName:"runName" type:"string"`

	// The state of the run. Values can be set to DataCollectionComplete, EvaluatingPolicies,
	// EvaluatingPoliciesErrorCanRetry, Completed, Failed, TombStoned.
	RunState *string `locationName:"runState" type:"string"`

	metadataRun `json:"-" xml:"-"`
}

type metadataRun struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Run) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Run) GoString() string {
	return s.String()
}

type RunAssessmentInput struct {
	// The ARN of the assessment that you want to run.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	// A name specifying the run of the assessment.
	RunName *string `locationName:"runName" type:"string"`

	metadataRunAssessmentInput `json:"-" xml:"-"`
}

type metadataRunAssessmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RunAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunAssessmentInput) GoString() string {
	return s.String()
}

type RunAssessmentOutput struct {
	// The ARN specifying the run of the assessment.
	RunArn *string `locationName:"runArn" type:"string"`

	metadataRunAssessmentOutput `json:"-" xml:"-"`
}

type metadataRunAssessmentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RunAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunAssessmentOutput) GoString() string {
	return s.String()
}

// This data type is used as the request parameter in the ListRuns action.
type RunsFilter struct {
	// For a record to match a filter, the value specified for this data type property
	// must inclusively match any value between the specified minimum and maximum
	// values of the completionTime property of the Run data type.
	CompletionTime *TimestampRange `locationName:"completionTime" type:"structure"`

	// For a record to match a filter, the value specified for this data type property
	// must inclusively match any value between the specified minimum and maximum
	// values of the creationTime property of the Run data type.
	CreationTime *TimestampRange `locationName:"creationTime" type:"structure"`

	// For a record to match a filter, the value specified for this data type property
	// must match a list of values of the rulesPackages property of the Run data
	// type.
	RulesPackages []*string `locationName:"rulesPackages" type:"list"`

	// For a record to match a filter, an explicit value or a string containing
	// a wildcard specified for this data type property must match the value of
	// the runName property of the Run data type.
	RunNamePatterns []*string `locationName:"runNamePatterns" type:"list"`

	// For a record to match a filter, the value specified for this data type property
	// must be the exact match of the value of the runState property of the Run
	// data type.
	RunStates []*string `locationName:"runStates" type:"list"`

	metadataRunsFilter `json:"-" xml:"-"`
}

type metadataRunsFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RunsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunsFilter) GoString() string {
	return s.String()
}

type SetTagsForResourceInput struct {
	// The ARN of the assessment that you want to set tags to.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// A collection of key and value pairs that you want to set to an assessment.
	Tags []*Tag `locationName:"tags" type:"list"`

	metadataSetTagsForResourceInput `json:"-" xml:"-"`
}

type metadataSetTagsForResourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTagsForResourceInput) GoString() string {
	return s.String()
}

type SetTagsForResourceOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataSetTagsForResourceOutput `json:"-" xml:"-"`
}

type metadataSetTagsForResourceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTagsForResourceOutput) GoString() string {
	return s.String()
}

type StartDataCollectionInput struct {
	// The ARN of the assessment for which you want to start the data collection
	// process.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	metadataStartDataCollectionInput `json:"-" xml:"-"`
}

type metadataStartDataCollectionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartDataCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataCollectionInput) GoString() string {
	return s.String()
}

type StartDataCollectionOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataStartDataCollectionOutput `json:"-" xml:"-"`
}

type metadataStartDataCollectionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartDataCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDataCollectionOutput) GoString() string {
	return s.String()
}

type StopDataCollectionInput struct {
	// The ARN of the assessment for which you want to stop the data collection
	// process.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	metadataStopDataCollectionInput `json:"-" xml:"-"`
}

type metadataStopDataCollectionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StopDataCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataCollectionInput) GoString() string {
	return s.String()
}

type StopDataCollectionOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataStopDataCollectionOutput `json:"-" xml:"-"`
}

type metadataStopDataCollectionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StopDataCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDataCollectionOutput) GoString() string {
	return s.String()
}

// A key and value pair.
//
// This data type is used as a request parameter in the SetTagsForResource
// action and a response element in the ListTagsForResource action.
type Tag struct {
	// The tag key.
	Key *string `type:"string"`

	// The value assigned to a tag key.
	Value *string `type:"string"`

	metadataTag `json:"-" xml:"-"`
}

type metadataTag struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// The metadata about the Inspector application data metrics collected by the
// agent.
//
// This data type is used as the response element in the GetAssessmentTelemetry
// action.
type Telemetry struct {
	// Counts of individual metrics received by Inspector from the agent.
	MessageTypeTelemetries []*MessageTypeTelemetry `locationName:"messageTypeTelemetries" type:"list"`

	// The category of the individual metrics that together constitute the telemetry
	// that Inspector received from the agent.
	Status *string `locationName:"status" type:"string"`

	metadataTelemetry `json:"-" xml:"-"`
}

type metadataTelemetry struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Telemetry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Telemetry) GoString() string {
	return s.String()
}

// This data type is used in the AssessmentsFilter and RunsFilter data types.
type TimestampRange struct {
	// The maximum value of the timestamp range.
	Maximum *time.Time `locationName:"maximum" type:"timestamp" timestampFormat:"unix"`

	// The minimum value of the timestamp range.
	Minimum *time.Time `locationName:"minimum" type:"timestamp" timestampFormat:"unix"`

	metadataTimestampRange `json:"-" xml:"-"`
}

type metadataTimestampRange struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TimestampRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimestampRange) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	// Application ARN that you want to update.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// Application name that you want to update.
	ApplicationName *string `locationName:"applicationName" type:"string"`

	// The resource group ARN that you want to update.
	ResourceGroupArn *string `locationName:"resourceGroupArn" type:"string"`

	metadataUpdateApplicationInput `json:"-" xml:"-"`
}

type metadataUpdateApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

type UpdateApplicationOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataUpdateApplicationOutput `json:"-" xml:"-"`
}

type metadataUpdateApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

type UpdateAssessmentInput struct {
	// Asessment ARN that you want to update.
	AssessmentArn *string `locationName:"assessmentArn" type:"string"`

	// Assessment name that you want to update.
	AssessmentName *string `locationName:"assessmentName" type:"string"`

	// Assessment duration in seconds that you want to update. The default value
	// is 3600 seconds (one hour). The maximum value is 86400 seconds (one day).
	DurationInSeconds *int64 `locationName:"durationInSeconds" type:"integer"`

	metadataUpdateAssessmentInput `json:"-" xml:"-"`
}

type metadataUpdateAssessmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentInput) GoString() string {
	return s.String()
}

type UpdateAssessmentOutput struct {
	// Confirmation details of the action performed.
	Message *string `locationName:"message" type:"string"`

	metadataUpdateAssessmentOutput `json:"-" xml:"-"`
}

type metadataUpdateAssessmentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssessmentOutput) GoString() string {
	return s.String()
}
