// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package inspector_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/inspector"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleInspector_AddAttributesToFindings() {
	svc := inspector.New(nil)

	params := &inspector.AddAttributesToFindingsInput{
		Attributes: []*inspector.Attribute{
			{ // Required
				Key:   aws.String("AttributeKey"),
				Value: aws.String("AttributeValue"),
			},
			// More values...
		},
		FindingArns: []*string{
			aws.String("Arn"), // Required
			// More values...
		},
	}
	resp, err := svc.AddAttributesToFindings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_AttachAssessmentAndRulesPackage() {
	svc := inspector.New(nil)

	params := &inspector.AttachAssessmentAndRulesPackageInput{
		AssessmentArn:   aws.String("Arn"),
		RulesPackageArn: aws.String("Arn"),
	}
	resp, err := svc.AttachAssessmentAndRulesPackage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_CreateApplication() {
	svc := inspector.New(nil)

	params := &inspector.CreateApplicationInput{
		ApplicationName:  aws.String("Name"),
		ResourceGroupArn: aws.String("Arn"),
	}
	resp, err := svc.CreateApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_CreateAssessment() {
	svc := inspector.New(nil)

	params := &inspector.CreateAssessmentInput{
		ApplicationArn:    aws.String("Arn"),
		AssessmentName:    aws.String("Name"),
		DurationInSeconds: aws.Int64(1),
		UserAttributesForFindings: []*inspector.Attribute{
			{ // Required
				Key:   aws.String("AttributeKey"),
				Value: aws.String("AttributeValue"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateAssessment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_CreateResourceGroup() {
	svc := inspector.New(nil)

	params := &inspector.CreateResourceGroupInput{
		ResourceGroupTags: aws.String("ResourceGroupTags"),
	}
	resp, err := svc.CreateResourceGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DeleteApplication() {
	svc := inspector.New(nil)

	params := &inspector.DeleteApplicationInput{
		ApplicationArn: aws.String("Arn"),
	}
	resp, err := svc.DeleteApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DeleteAssessment() {
	svc := inspector.New(nil)

	params := &inspector.DeleteAssessmentInput{
		AssessmentArn: aws.String("Arn"),
	}
	resp, err := svc.DeleteAssessment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DeleteRun() {
	svc := inspector.New(nil)

	params := &inspector.DeleteRunInput{
		RunArn: aws.String("Arn"),
	}
	resp, err := svc.DeleteRun(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DescribeApplication() {
	svc := inspector.New(nil)

	params := &inspector.DescribeApplicationInput{
		ApplicationArn: aws.String("Arn"),
	}
	resp, err := svc.DescribeApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DescribeAssessment() {
	svc := inspector.New(nil)

	params := &inspector.DescribeAssessmentInput{
		AssessmentArn: aws.String("Arn"),
	}
	resp, err := svc.DescribeAssessment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DescribeCrossAccountAccessRole() {
	svc := inspector.New(nil)

	var params *inspector.DescribeCrossAccountAccessRoleInput
	resp, err := svc.DescribeCrossAccountAccessRole(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DescribeFinding() {
	svc := inspector.New(nil)

	params := &inspector.DescribeFindingInput{
		FindingArn: aws.String("Arn"),
	}
	resp, err := svc.DescribeFinding(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DescribeResourceGroup() {
	svc := inspector.New(nil)

	params := &inspector.DescribeResourceGroupInput{
		ResourceGroupArn: aws.String("Arn"),
	}
	resp, err := svc.DescribeResourceGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DescribeRulesPackage() {
	svc := inspector.New(nil)

	params := &inspector.DescribeRulesPackageInput{
		RulesPackageArn: aws.String("Arn"),
	}
	resp, err := svc.DescribeRulesPackage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DescribeRun() {
	svc := inspector.New(nil)

	params := &inspector.DescribeRunInput{
		RunArn: aws.String("Arn"),
	}
	resp, err := svc.DescribeRun(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_DetachAssessmentAndRulesPackage() {
	svc := inspector.New(nil)

	params := &inspector.DetachAssessmentAndRulesPackageInput{
		AssessmentArn:   aws.String("Arn"),
		RulesPackageArn: aws.String("Arn"),
	}
	resp, err := svc.DetachAssessmentAndRulesPackage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_GetAssessmentTelemetry() {
	svc := inspector.New(nil)

	params := &inspector.GetAssessmentTelemetryInput{
		AssessmentArn: aws.String("Arn"),
	}
	resp, err := svc.GetAssessmentTelemetry(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_ListApplications() {
	svc := inspector.New(nil)

	params := &inspector.ListApplicationsInput{
		Filter: &inspector.ApplicationsFilter{
			ApplicationNamePatterns: []*string{
				aws.String("NamePattern"), // Required
				// More values...
			},
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
	}
	resp, err := svc.ListApplications(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_ListAssessmentAgents() {
	svc := inspector.New(nil)

	params := &inspector.ListAssessmentAgentsInput{
		AssessmentArn: aws.String("Arn"),
		Filter: &inspector.AgentsFilter{
			AgentHealthList: []*string{
				aws.String("AgentHealth"), // Required
				// More values...
			},
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
	}
	resp, err := svc.ListAssessmentAgents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_ListAssessments() {
	svc := inspector.New(nil)

	params := &inspector.ListAssessmentsInput{
		ApplicationArns: []*string{
			aws.String("Arn"), // Required
			// More values...
		},
		Filter: &inspector.AssessmentsFilter{
			AssessmentNamePatterns: []*string{
				aws.String("NamePattern"), // Required
				// More values...
			},
			AssessmentStates: []*string{
				aws.String("AssessmentState"), // Required
				// More values...
			},
			DataCollected: aws.Bool(true),
			DurationRange: &inspector.DurationRange{
				Maximum: aws.Int64(1),
				Minimum: aws.Int64(1),
			},
			EndTimeRange: &inspector.TimestampRange{
				Maximum: aws.Time(time.Now()),
				Minimum: aws.Time(time.Now()),
			},
			StartTimeRange: &inspector.TimestampRange{
				Maximum: aws.Time(time.Now()),
				Minimum: aws.Time(time.Now()),
			},
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
	}
	resp, err := svc.ListAssessments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_ListAttachedAssessments() {
	svc := inspector.New(nil)

	params := &inspector.ListAttachedAssessmentsInput{
		Filter: &inspector.AssessmentsFilter{
			AssessmentNamePatterns: []*string{
				aws.String("NamePattern"), // Required
				// More values...
			},
			AssessmentStates: []*string{
				aws.String("AssessmentState"), // Required
				// More values...
			},
			DataCollected: aws.Bool(true),
			DurationRange: &inspector.DurationRange{
				Maximum: aws.Int64(1),
				Minimum: aws.Int64(1),
			},
			EndTimeRange: &inspector.TimestampRange{
				Maximum: aws.Time(time.Now()),
				Minimum: aws.Time(time.Now()),
			},
			StartTimeRange: &inspector.TimestampRange{
				Maximum: aws.Time(time.Now()),
				Minimum: aws.Time(time.Now()),
			},
		},
		MaxResults:      aws.Int64(1),
		NextToken:       aws.String("PaginationToken"),
		RulesPackageArn: aws.String("Arn"),
	}
	resp, err := svc.ListAttachedAssessments(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_ListAttachedRulesPackages() {
	svc := inspector.New(nil)

	params := &inspector.ListAttachedRulesPackagesInput{
		AssessmentArn: aws.String("Arn"),
		MaxResults:    aws.Int64(1),
		NextToken:     aws.String("PaginationToken"),
	}
	resp, err := svc.ListAttachedRulesPackages(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_ListFindings() {
	svc := inspector.New(nil)

	params := &inspector.ListFindingsInput{
		Filter: &inspector.FindingsFilter{
			Attributes: []*inspector.Attribute{
				{ // Required
					Key:   aws.String("AttributeKey"),
					Value: aws.String("AttributeValue"),
				},
				// More values...
			},
			RuleNames: []*string{
				aws.String("Name"), // Required
				// More values...
			},
			RulesPackageArns: []*string{
				aws.String("Arn"), // Required
				// More values...
			},
			Severities: []*string{
				aws.String("Severity"), // Required
				// More values...
			},
			UserAttributes: []*inspector.Attribute{
				{ // Required
					Key:   aws.String("AttributeKey"),
					Value: aws.String("AttributeValue"),
				},
				// More values...
			},
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
		RunArns: []*string{
			aws.String("Arn"), // Required
			// More values...
		},
	}
	resp, err := svc.ListFindings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_ListRulesPackages() {
	svc := inspector.New(nil)

	params := &inspector.ListRulesPackagesInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
	}
	resp, err := svc.ListRulesPackages(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_ListRuns() {
	svc := inspector.New(nil)

	params := &inspector.ListRunsInput{
		AssessmentArns: []*string{
			aws.String("Arn"), // Required
			// More values...
		},
		Filter: &inspector.RunsFilter{
			CompletionTime: &inspector.TimestampRange{
				Maximum: aws.Time(time.Now()),
				Minimum: aws.Time(time.Now()),
			},
			CreationTime: &inspector.TimestampRange{
				Maximum: aws.Time(time.Now()),
				Minimum: aws.Time(time.Now()),
			},
			RulesPackages: []*string{
				aws.String("Arn"), // Required
				// More values...
			},
			RunNamePatterns: []*string{
				aws.String("NamePattern"), // Required
				// More values...
			},
			RunStates: []*string{
				aws.String("RunState"), // Required
				// More values...
			},
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("PaginationToken"),
	}
	resp, err := svc.ListRuns(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_ListTagsForResource() {
	svc := inspector.New(nil)

	params := &inspector.ListTagsForResourceInput{
		ResourceArn: aws.String("Arn"),
	}
	resp, err := svc.ListTagsForResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_LocalizeText() {
	svc := inspector.New(nil)

	params := &inspector.LocalizeTextInput{
		Locale: aws.String("Locale"),
		LocalizedTexts: []*inspector.LocalizedText{
			{ // Required
				Key: &inspector.LocalizedTextKey{
					Facility: aws.String("LocalizedFacility"),
					Id:       aws.String("LocalizedTextId"),
				},
				Parameters: []*inspector.Parameter{
					{ // Required
						Name:  aws.String("ParameterName"),
						Value: aws.String("ParameterValue"),
					},
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.LocalizeText(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_PreviewAgentsForResourceGroup() {
	svc := inspector.New(nil)

	params := &inspector.PreviewAgentsForResourceGroupInput{
		MaxResults:       aws.Int64(1),
		NextToken:        aws.String("PaginationToken"),
		ResourceGroupArn: aws.String("Arn"),
	}
	resp, err := svc.PreviewAgentsForResourceGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_RegisterCrossAccountAccessRole() {
	svc := inspector.New(nil)

	params := &inspector.RegisterCrossAccountAccessRoleInput{
		RoleArn: aws.String("Arn"),
	}
	resp, err := svc.RegisterCrossAccountAccessRole(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_RemoveAttributesFromFindings() {
	svc := inspector.New(nil)

	params := &inspector.RemoveAttributesFromFindingsInput{
		AttributeKeys: []*string{
			aws.String("AttributeKey"), // Required
			// More values...
		},
		FindingArns: []*string{
			aws.String("Arn"), // Required
			// More values...
		},
	}
	resp, err := svc.RemoveAttributesFromFindings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_RunAssessment() {
	svc := inspector.New(nil)

	params := &inspector.RunAssessmentInput{
		AssessmentArn: aws.String("Arn"),
		RunName:       aws.String("Name"),
	}
	resp, err := svc.RunAssessment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_SetTagsForResource() {
	svc := inspector.New(nil)

	params := &inspector.SetTagsForResourceInput{
		ResourceArn: aws.String("Arn"),
		Tags: []*inspector.Tag{
			{ // Required
				Key:   aws.String("TagKey"),
				Value: aws.String("TagValue"),
			},
			// More values...
		},
	}
	resp, err := svc.SetTagsForResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_StartDataCollection() {
	svc := inspector.New(nil)

	params := &inspector.StartDataCollectionInput{
		AssessmentArn: aws.String("Arn"),
	}
	resp, err := svc.StartDataCollection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_StopDataCollection() {
	svc := inspector.New(nil)

	params := &inspector.StopDataCollectionInput{
		AssessmentArn: aws.String("Arn"),
	}
	resp, err := svc.StopDataCollection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_UpdateApplication() {
	svc := inspector.New(nil)

	params := &inspector.UpdateApplicationInput{
		ApplicationArn:   aws.String("Arn"),
		ApplicationName:  aws.String("Name"),
		ResourceGroupArn: aws.String("Arn"),
	}
	resp, err := svc.UpdateApplication(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleInspector_UpdateAssessment() {
	svc := inspector.New(nil)

	params := &inspector.UpdateAssessmentInput{
		AssessmentArn:     aws.String("Arn"),
		AssessmentName:    aws.String("Name"),
		DurationInSeconds: aws.Int64(1),
	}
	resp, err := svc.UpdateAssessment(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
