// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package iotdataplane

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/defaults"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/service"
	"github.com/aws/aws-sdk-go/aws/service/serviceinfo"
	"github.com/aws/aws-sdk-go/internal/protocol/restjson"
	"github.com/aws/aws-sdk-go/internal/signer/v4"
)

// AWS IoT is considered a beta service as defined in the Service Terms
//
// AWS IoT-Data enables secure, bi-directional communication between Internet-connected
// things (such as sensors, actuators, embedded devices, or smart appliances)
// and the AWS cloud. It implements a broker for applications and things to
// publish messages over HTTP (Publish) and retrieve, update, and delete thing
// shadows. A thing shadow is a persistent representation of your things and
// their state in the AWS cloud.
type IoTDataPlane struct {
	*service.Service
}

// Used for custom service initialization logic
var initService func(*service.Service)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// New returns a new IoTDataPlane client.
func New(config *aws.Config) *IoTDataPlane {
	service := &service.Service{
		ServiceInfo: serviceinfo.ServiceInfo{
			Config:      defaults.DefaultConfig.Merge(config),
			ServiceName: "data.iot",
			SigningName: "iotdata",
			APIVersion:  "2015-05-28",
		},
	}
	service.Initialize()

	// Handlers
	service.Handlers.Sign.PushBack(v4.Sign)
	service.Handlers.Build.PushBack(restjson.Build)
	service.Handlers.Unmarshal.PushBack(restjson.Unmarshal)
	service.Handlers.UnmarshalMeta.PushBack(restjson.UnmarshalMeta)
	service.Handlers.UnmarshalError.PushBack(restjson.UnmarshalError)

	// Run custom service initialization if present
	if initService != nil {
		initService(service)
	}

	return &IoTDataPlane{service}
}

// newRequest creates a new request for a IoTDataPlane operation and runs any
// custom request initialization.
func (c *IoTDataPlane) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
