// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package kms provides a client for AWS Key Management Service.
package kms

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a request for the CreateAlias operation.
func (c *KMS) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAliasOutput{}
	req.Data = output
	return
}

// Creates a display name for a customer master key. An alias can be used to
// identify a key and should be unique. The console enforces a one-to-one mapping
// between the alias and a key. An alias name can contain only alphanumeric
// characters, forward slashes (/), underscores (_), and dashes (-). An alias
// must start with the word "alias" followed by a forward slash (alias/). An
// alias that begins with "aws" after the forward slash (alias/aws...) is reserved
// by Amazon Web Services (AWS).
//
// To associate an alias with a different key, call UpdateAlias.
//
// Note that you cannot create or update an alias that represents a key in
// another account.
func (c *KMS) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateGrant = "CreateGrant"

// CreateGrantRequest generates a request for the CreateGrant operation.
func (c *KMS) CreateGrantRequest(input *CreateGrantInput) (req *request.Request, output *CreateGrantOutput) {
	op := &request.Operation{
		Name:       opCreateGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGrantInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateGrantOutput{}
	req.Data = output
	return
}

// Adds a grant to a key to specify who can access the key and under what conditions.
// Grants are alternate permission mechanisms to key policies. For more information
// about grants, see Grants (http://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
// in the developer guide. If a grant is absent, access to the key is evaluated
// based on IAM policies attached to the user.  ListGrants RetireGrant RevokeGrant
func (c *KMS) CreateGrant(input *CreateGrantInput) (*CreateGrantOutput, error) {
	req, out := c.CreateGrantRequest(input)
	err := req.Send()
	return out, err
}

const opCreateKey = "CreateKey"

// CreateKeyRequest generates a request for the CreateKey operation.
func (c *KMS) CreateKeyRequest(input *CreateKeyInput) (req *request.Request, output *CreateKeyOutput) {
	op := &request.Operation{
		Name:       opCreateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateKeyOutput{}
	req.Data = output
	return
}

// Creates a customer master key. Customer master keys can be used to encrypt
// small amounts of data (less than 4K) directly, but they are most commonly
// used to encrypt or envelope data keys that are then used to encrypt customer
// data. For more information about data keys, see GenerateDataKey and GenerateDataKeyWithoutPlaintext.
func (c *KMS) CreateKey(input *CreateKeyInput) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDecrypt = "Decrypt"

// DecryptRequest generates a request for the Decrypt operation.
func (c *KMS) DecryptRequest(input *DecryptInput) (req *request.Request, output *DecryptOutput) {
	op := &request.Operation{
		Name:       opDecrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecryptInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DecryptOutput{}
	req.Data = output
	return
}

// Decrypts ciphertext. Ciphertext is plaintext that has been previously encrypted
// by using any of the following functions:  GenerateDataKey GenerateDataKeyWithoutPlaintext
// Encrypt
//
// Note that if a caller has been granted access permissions to all keys (through,
// for example, IAM user policies that grant Decrypt permission on all resources),
// then ciphertext encrypted by using keys in other accounts where the key grants
// access to the caller can be decrypted. To remedy this, we recommend that
// you do not grant Decrypt access in an IAM user policy. Instead grant Decrypt
// access only in key policies. If you must grant Decrypt access in an IAM user
// policy, you should scope the resource to specific keys or to specific trusted
// accounts.
func (c *KMS) Decrypt(input *DecryptInput) (*DecryptOutput, error) {
	req, out := c.DecryptRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a request for the DeleteAlias operation.
func (c *KMS) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteAliasOutput{}
	req.Data = output
	return
}

// Deletes the specified alias. To associate an alias with a different key,
// call UpdateAlias.
func (c *KMS) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeKey = "DescribeKey"

// DescribeKeyRequest generates a request for the DescribeKey operation.
func (c *KMS) DescribeKeyRequest(input *DescribeKeyInput) (req *request.Request, output *DescribeKeyOutput) {
	op := &request.Operation{
		Name:       opDescribeKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeKeyOutput{}
	req.Data = output
	return
}

// Provides detailed information about the specified customer master key.
func (c *KMS) DescribeKey(input *DescribeKeyInput) (*DescribeKeyOutput, error) {
	req, out := c.DescribeKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDisableKey = "DisableKey"

// DisableKeyRequest generates a request for the DisableKey operation.
func (c *KMS) DisableKeyRequest(input *DisableKeyInput) (req *request.Request, output *DisableKeyOutput) {
	op := &request.Operation{
		Name:       opDisableKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableKeyOutput{}
	req.Data = output
	return
}

// Marks a key as disabled, thereby preventing its use.
func (c *KMS) DisableKey(input *DisableKeyInput) (*DisableKeyOutput, error) {
	req, out := c.DisableKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDisableKeyRotation = "DisableKeyRotation"

// DisableKeyRotationRequest generates a request for the DisableKeyRotation operation.
func (c *KMS) DisableKeyRotationRequest(input *DisableKeyRotationInput) (req *request.Request, output *DisableKeyRotationOutput) {
	op := &request.Operation{
		Name:       opDisableKeyRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyRotationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableKeyRotationOutput{}
	req.Data = output
	return
}

// Disables rotation of the specified key.
func (c *KMS) DisableKeyRotation(input *DisableKeyRotationInput) (*DisableKeyRotationOutput, error) {
	req, out := c.DisableKeyRotationRequest(input)
	err := req.Send()
	return out, err
}

const opEnableKey = "EnableKey"

// EnableKeyRequest generates a request for the EnableKey operation.
func (c *KMS) EnableKeyRequest(input *EnableKeyInput) (req *request.Request, output *EnableKeyOutput) {
	op := &request.Operation{
		Name:       opEnableKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableKeyOutput{}
	req.Data = output
	return
}

// Marks a key as enabled, thereby permitting its use. You can have up to 25
// enabled keys at one time.
func (c *KMS) EnableKey(input *EnableKeyInput) (*EnableKeyOutput, error) {
	req, out := c.EnableKeyRequest(input)
	err := req.Send()
	return out, err
}

const opEnableKeyRotation = "EnableKeyRotation"

// EnableKeyRotationRequest generates a request for the EnableKeyRotation operation.
func (c *KMS) EnableKeyRotationRequest(input *EnableKeyRotationInput) (req *request.Request, output *EnableKeyRotationOutput) {
	op := &request.Operation{
		Name:       opEnableKeyRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableKeyRotationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableKeyRotationOutput{}
	req.Data = output
	return
}

// Enables rotation of the specified customer master key.
func (c *KMS) EnableKeyRotation(input *EnableKeyRotationInput) (*EnableKeyRotationOutput, error) {
	req, out := c.EnableKeyRotationRequest(input)
	err := req.Send()
	return out, err
}

const opEncrypt = "Encrypt"

// EncryptRequest generates a request for the Encrypt operation.
func (c *KMS) EncryptRequest(input *EncryptInput) (req *request.Request, output *EncryptOutput) {
	op := &request.Operation{
		Name:       opEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EncryptInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EncryptOutput{}
	req.Data = output
	return
}

// Encrypts plaintext into ciphertext by using a customer master key. The Encrypt
// function has two primary use cases:  You can encrypt up to 4 KB of arbitrary
// data such as an RSA key, a database password, or other sensitive customer
// information. If you are moving encrypted data from one region to another,
// you can use this API to encrypt in the new region the plaintext data key
// that was used to encrypt the data in the original region. This provides you
// with an encrypted copy of the data key that can be decrypted in the new region
// and used there to decrypt the encrypted data.
//
// Unless you are moving encrypted data from one region to another, you don't
// use this function to encrypt a generated data key within a region. You retrieve
// data keys already encrypted by calling the GenerateDataKey or GenerateDataKeyWithoutPlaintext
// function. Data keys don't need to be encrypted again by calling Encrypt.
//
// If you want to encrypt data locally in your application, you can use the
// GenerateDataKey function to return a plaintext data encryption key and a
// copy of the key encrypted under the customer master key (CMK) of your choosing.
func (c *KMS) Encrypt(input *EncryptInput) (*EncryptOutput, error) {
	req, out := c.EncryptRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateDataKey = "GenerateDataKey"

// GenerateDataKeyRequest generates a request for the GenerateDataKey operation.
func (c *KMS) GenerateDataKeyRequest(input *GenerateDataKeyInput) (req *request.Request, output *GenerateDataKeyOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateDataKeyOutput{}
	req.Data = output
	return
}

// Generates a data key that you can use in your application to locally encrypt
// data. This call returns a plaintext version of the key in the Plaintext field
// of the response object and an encrypted copy of the key in the CiphertextBlob
// field. The key is encrypted by using the master key specified by the KeyId
// field. To decrypt the encrypted key, pass it to the Decrypt API.
//
// We recommend that you use the following pattern to locally encrypt data:
// call the GenerateDataKey API, use the key returned in the Plaintext response
// field to locally encrypt data, and then erase the plaintext data key from
// memory. Store the encrypted data key (contained in the CiphertextBlob field)
// alongside of the locally encrypted data.
//
// You should not call the Encrypt function to re-encrypt your data keys within
// a region. GenerateDataKey always returns the data key encrypted and tied
// to the customer master key that will be used to decrypt it. There is no need
// to decrypt it twice.  If you decide to use the optional EncryptionContext
// parameter, you must also store the context in full or at least store enough
// information along with the encrypted data to be able to reconstruct the context
// when submitting the ciphertext to the Decrypt API. It is a good practice
// to choose a context that you can reconstruct on the fly to better secure
// the ciphertext. For more information about how this parameter is used, see
// Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encrypt-context.html).
//
// To decrypt data, pass the encrypted data key to the Decrypt API. Decrypt
// uses the associated master key to decrypt the encrypted data key and returns
// it as plaintext. Use the plaintext data key to locally decrypt your data
// and then erase the key from memory. You must specify the encryption context,
// if any, that you specified when you generated the key. The encryption context
// is logged by CloudTrail, and you can use this log to help track the use of
// particular data.
func (c *KMS) GenerateDataKey(input *GenerateDataKeyInput) (*GenerateDataKeyOutput, error) {
	req, out := c.GenerateDataKeyRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateDataKeyWithoutPlaintext = "GenerateDataKeyWithoutPlaintext"

// GenerateDataKeyWithoutPlaintextRequest generates a request for the GenerateDataKeyWithoutPlaintext operation.
func (c *KMS) GenerateDataKeyWithoutPlaintextRequest(input *GenerateDataKeyWithoutPlaintextInput) (req *request.Request, output *GenerateDataKeyWithoutPlaintextOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKeyWithoutPlaintext,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyWithoutPlaintextInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateDataKeyWithoutPlaintextOutput{}
	req.Data = output
	return
}

// Returns a data key encrypted by a customer master key without the plaintext
// copy of that key. Otherwise, this API functions exactly like GenerateDataKey.
// You can use this API to, for example, satisfy an audit requirement that an
// encrypted key be made available without exposing the plaintext copy of that
// key.
func (c *KMS) GenerateDataKeyWithoutPlaintext(input *GenerateDataKeyWithoutPlaintextInput) (*GenerateDataKeyWithoutPlaintextOutput, error) {
	req, out := c.GenerateDataKeyWithoutPlaintextRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateRandom = "GenerateRandom"

// GenerateRandomRequest generates a request for the GenerateRandom operation.
func (c *KMS) GenerateRandomRequest(input *GenerateRandomInput) (req *request.Request, output *GenerateRandomOutput) {
	op := &request.Operation{
		Name:       opGenerateRandom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateRandomInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateRandomOutput{}
	req.Data = output
	return
}

// Generates an unpredictable byte string.
func (c *KMS) GenerateRandom(input *GenerateRandomInput) (*GenerateRandomOutput, error) {
	req, out := c.GenerateRandomRequest(input)
	err := req.Send()
	return out, err
}

const opGetKeyPolicy = "GetKeyPolicy"

// GetKeyPolicyRequest generates a request for the GetKeyPolicy operation.
func (c *KMS) GetKeyPolicyRequest(input *GetKeyPolicyInput) (req *request.Request, output *GetKeyPolicyOutput) {
	op := &request.Operation{
		Name:       opGetKeyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetKeyPolicyOutput{}
	req.Data = output
	return
}

// Retrieves a policy attached to the specified key.
func (c *KMS) GetKeyPolicy(input *GetKeyPolicyInput) (*GetKeyPolicyOutput, error) {
	req, out := c.GetKeyPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetKeyRotationStatus = "GetKeyRotationStatus"

// GetKeyRotationStatusRequest generates a request for the GetKeyRotationStatus operation.
func (c *KMS) GetKeyRotationStatusRequest(input *GetKeyRotationStatusInput) (req *request.Request, output *GetKeyRotationStatusOutput) {
	op := &request.Operation{
		Name:       opGetKeyRotationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyRotationStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetKeyRotationStatusOutput{}
	req.Data = output
	return
}

// Retrieves a Boolean value that indicates whether key rotation is enabled
// for the specified key.
func (c *KMS) GetKeyRotationStatus(input *GetKeyRotationStatusInput) (*GetKeyRotationStatusOutput, error) {
	req, out := c.GetKeyRotationStatusRequest(input)
	err := req.Send()
	return out, err
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a request for the ListAliases operation.
func (c *KMS) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAliasesOutput{}
	req.Data = output
	return
}

// Lists all of the key aliases in the account.
func (c *KMS) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	err := req.Send()
	return out, err
}

func (c *KMS) ListAliasesPages(input *ListAliasesInput, fn func(p *ListAliasesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAliasesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAliasesOutput), lastPage)
	})
}

const opListGrants = "ListGrants"

// ListGrantsRequest generates a request for the ListGrants operation.
func (c *KMS) ListGrantsRequest(input *ListGrantsInput) (req *request.Request, output *ListGrantsOutput) {
	op := &request.Operation{
		Name:       opListGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListGrantsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGrantsOutput{}
	req.Data = output
	return
}

// List the grants for a specified key.
func (c *KMS) ListGrants(input *ListGrantsInput) (*ListGrantsOutput, error) {
	req, out := c.ListGrantsRequest(input)
	err := req.Send()
	return out, err
}

func (c *KMS) ListGrantsPages(input *ListGrantsInput, fn func(p *ListGrantsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGrantsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGrantsOutput), lastPage)
	})
}

const opListKeyPolicies = "ListKeyPolicies"

// ListKeyPoliciesRequest generates a request for the ListKeyPolicies operation.
func (c *KMS) ListKeyPoliciesRequest(input *ListKeyPoliciesInput) (req *request.Request, output *ListKeyPoliciesOutput) {
	op := &request.Operation{
		Name:       opListKeyPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListKeyPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListKeyPoliciesOutput{}
	req.Data = output
	return
}

// Retrieves a list of policies attached to a key.
func (c *KMS) ListKeyPolicies(input *ListKeyPoliciesInput) (*ListKeyPoliciesOutput, error) {
	req, out := c.ListKeyPoliciesRequest(input)
	err := req.Send()
	return out, err
}

func (c *KMS) ListKeyPoliciesPages(input *ListKeyPoliciesInput, fn func(p *ListKeyPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListKeyPoliciesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListKeyPoliciesOutput), lastPage)
	})
}

const opListKeys = "ListKeys"

// ListKeysRequest generates a request for the ListKeys operation.
func (c *KMS) ListKeysRequest(input *ListKeysInput) (req *request.Request, output *ListKeysOutput) {
	op := &request.Operation{
		Name:       opListKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListKeysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListKeysOutput{}
	req.Data = output
	return
}

// Lists the customer master keys.
func (c *KMS) ListKeys(input *ListKeysInput) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	err := req.Send()
	return out, err
}

func (c *KMS) ListKeysPages(input *ListKeysInput, fn func(p *ListKeysOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListKeysRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListKeysOutput), lastPage)
	})
}

const opPutKeyPolicy = "PutKeyPolicy"

// PutKeyPolicyRequest generates a request for the PutKeyPolicy operation.
func (c *KMS) PutKeyPolicyRequest(input *PutKeyPolicyInput) (req *request.Request, output *PutKeyPolicyOutput) {
	op := &request.Operation{
		Name:       opPutKeyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutKeyPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutKeyPolicyOutput{}
	req.Data = output
	return
}

// Attaches a policy to the specified key.
func (c *KMS) PutKeyPolicy(input *PutKeyPolicyInput) (*PutKeyPolicyOutput, error) {
	req, out := c.PutKeyPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opReEncrypt = "ReEncrypt"

// ReEncryptRequest generates a request for the ReEncrypt operation.
func (c *KMS) ReEncryptRequest(input *ReEncryptInput) (req *request.Request, output *ReEncryptOutput) {
	op := &request.Operation{
		Name:       opReEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReEncryptInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReEncryptOutput{}
	req.Data = output
	return
}

// Encrypts data on the server side with a new customer master key without exposing
// the plaintext of the data on the client side. The data is first decrypted
// and then encrypted. This operation can also be used to change the encryption
// context of a ciphertext.
//
// Unlike other actions, ReEncrypt is authorized twice - once as ReEncryptFrom
// on the source key and once as ReEncryptTo on the destination key. We therefore
// recommend that you include the "action":"kms:ReEncrypt*" statement in your
// key policies to permit re-encryption from or to the key. The statement is
// included automatically when you authorize use of the key through the console
// but must be included manually when you set a policy by using the PutKeyPolicy
// function.
func (c *KMS) ReEncrypt(input *ReEncryptInput) (*ReEncryptOutput, error) {
	req, out := c.ReEncryptRequest(input)
	err := req.Send()
	return out, err
}

const opRetireGrant = "RetireGrant"

// RetireGrantRequest generates a request for the RetireGrant operation.
func (c *KMS) RetireGrantRequest(input *RetireGrantInput) (req *request.Request, output *RetireGrantOutput) {
	op := &request.Operation{
		Name:       opRetireGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetireGrantInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RetireGrantOutput{}
	req.Data = output
	return
}

// Retires a grant. You can retire a grant when you're done using it to clean
// up. You should revoke a grant when you intend to actively deny operations
// that depend on it. The following are permitted to call this API:  The account
// that created the grant The RetiringPrincipal, if present The GranteePrincipal,
// if RetireGrant is a grantee operation  The grant to retire must be identified
// by its grant token or by a combination of the key ARN and the grant ID. A
// grant token is a unique variable-length base64-encoded string. A grant ID
// is a 64 character unique identifier of a grant. Both are returned by the
// CreateGrant function.
func (c *KMS) RetireGrant(input *RetireGrantInput) (*RetireGrantOutput, error) {
	req, out := c.RetireGrantRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeGrant = "RevokeGrant"

// RevokeGrantRequest generates a request for the RevokeGrant operation.
func (c *KMS) RevokeGrantRequest(input *RevokeGrantInput) (req *request.Request, output *RevokeGrantOutput) {
	op := &request.Operation{
		Name:       opRevokeGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeGrantInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RevokeGrantOutput{}
	req.Data = output
	return
}

// Revokes a grant. You can revoke a grant to actively deny operations that
// depend on it.
func (c *KMS) RevokeGrant(input *RevokeGrantInput) (*RevokeGrantOutput, error) {
	req, out := c.RevokeGrantRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a request for the UpdateAlias operation.
func (c *KMS) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *UpdateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAliasOutput{}
	req.Data = output
	return
}

// Updates an alias to associate it with a different key.
//
// An alias name can contain only alphanumeric characters, forward slashes
// (/), underscores (_), and dashes (-). An alias must start with the word "alias"
// followed by a forward slash (alias/). An alias that begins with "aws" after
// the forward slash (alias/aws...) is reserved by Amazon Web Services (AWS).
//
// An alias is not a property of a key. Therefore, an alias can be associated
// with and disassociated from an existing key without changing the properties
// of the key.
//
// Note that you cannot create or update an alias that represents a key in
// another account.
func (c *KMS) UpdateAlias(input *UpdateAliasInput) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateKeyDescription = "UpdateKeyDescription"

// UpdateKeyDescriptionRequest generates a request for the UpdateKeyDescription operation.
func (c *KMS) UpdateKeyDescriptionRequest(input *UpdateKeyDescriptionInput) (req *request.Request, output *UpdateKeyDescriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateKeyDescription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateKeyDescriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateKeyDescriptionOutput{}
	req.Data = output
	return
}

// Updates the description of a key.
func (c *KMS) UpdateKeyDescription(input *UpdateKeyDescriptionInput) (*UpdateKeyDescriptionOutput, error) {
	req, out := c.UpdateKeyDescriptionRequest(input)
	err := req.Send()
	return out, err
}

// Contains information about an alias.
type AliasListEntry struct {
	// String that contains the key ARN.
	AliasArn *string `min:"20" type:"string"`

	// String that contains the alias.
	AliasName *string `min:"1" type:"string"`

	// String that contains the key identifier pointed to by the alias.
	TargetKeyId *string `min:"1" type:"string"`

	metadataAliasListEntry `json:"-" xml:"-"`
}

type metadataAliasListEntry struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AliasListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasListEntry) GoString() string {
	return s.String()
}

type CreateAliasInput struct {
	// String that contains the display name. The name must start with the word
	// "alias" followed by a forward slash (alias/). Aliases that begin with "alias/AWS"
	// are reserved.
	AliasName *string `min:"1" type:"string" required:"true"`

	// An identifier of the key for which you are creating the alias. This value
	// cannot be another alias but can be a globally unique identifier or a fully
	// specified ARN to a key.  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	TargetKeyId *string `min:"1" type:"string" required:"true"`

	metadataCreateAliasInput `json:"-" xml:"-"`
}

type metadataCreateAliasInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

type CreateAliasOutput struct {
	metadataCreateAliasOutput `json:"-" xml:"-"`
}

type metadataCreateAliasOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

type CreateGrantInput struct {
	// Specifies the conditions under which the actions specified by the Operations
	// parameter are allowed.
	Constraints *GrantConstraints `type:"structure"`

	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token).
	GrantTokens []*string `type:"list"`

	// Principal given permission by the grant to use the key identified by the
	// keyId parameter.
	GranteePrincipal *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	// List of operations permitted by the grant. This can be any combination of
	// one or more of the following values:  Decrypt Encrypt GenerateDataKey GenerateDataKeyWithoutPlaintext
	// ReEncryptFrom ReEncryptTo CreateGrant RetireGrant
	Operations []*string `type:"list"`

	// Principal given permission to retire the grant. For more information, see
	// RetireGrant.
	RetiringPrincipal *string `min:"1" type:"string"`

	metadataCreateGrantInput `json:"-" xml:"-"`
}

type metadataCreateGrantInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGrantInput) GoString() string {
	return s.String()
}

type CreateGrantOutput struct {
	// Unique grant identifier. You can use the GrantId value to revoke a grant.
	GrantId *string `min:"1" type:"string"`

	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token).
	GrantToken *string `min:"1" type:"string"`

	metadataCreateGrantOutput `json:"-" xml:"-"`
}

type metadataCreateGrantOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGrantOutput) GoString() string {
	return s.String()
}

type CreateKeyInput struct {
	// Description of the key. We recommend that you choose a description that helps
	// your customer decide whether the key is appropriate for a task.
	Description *string `type:"string"`

	// Specifies the intended use of the key. Currently this defaults to ENCRYPT/DECRYPT,
	// and only symmetric encryption and decryption are supported.
	KeyUsage *string `type:"string" enum:"KeyUsageType"`

	// Policy to be attached to the key. This is required and delegates back to
	// the account. The key is the root of trust.
	Policy *string `min:"1" type:"string"`

	metadataCreateKeyInput `json:"-" xml:"-"`
}

type metadataCreateKeyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyInput) GoString() string {
	return s.String()
}

type CreateKeyOutput struct {
	// Metadata associated with the key.
	KeyMetadata *KeyMetadata `type:"structure"`

	metadataCreateKeyOutput `json:"-" xml:"-"`
}

type metadataCreateKeyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyOutput) GoString() string {
	return s.String()
}

type DecryptInput struct {
	// Ciphertext to be decrypted. The blob includes metadata.
	CiphertextBlob []byte `min:"1" type:"blob" required:"true"`

	// The encryption context. If this was specified in the Encrypt function, it
	// must be specified here or the decryption operation will fail. For more information,
	// see Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encrypt-context.html).
	EncryptionContext map[string]*string `type:"map"`

	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token).
	GrantTokens []*string `type:"list"`

	metadataDecryptInput `json:"-" xml:"-"`
}

type metadataDecryptInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DecryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecryptInput) GoString() string {
	return s.String()
}

type DecryptOutput struct {
	// ARN of the key used to perform the decryption. This value is returned if
	// no errors are encountered during the operation.
	KeyId *string `min:"1" type:"string"`

	// Decrypted plaintext data. This value may not be returned if the customer
	// master key is not available or if you didn't have permission to use it.
	Plaintext []byte `min:"1" type:"blob"`

	metadataDecryptOutput `json:"-" xml:"-"`
}

type metadataDecryptOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DecryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecryptOutput) GoString() string {
	return s.String()
}

type DeleteAliasInput struct {
	// The alias to be deleted. The name must start with the word "alias" followed
	// by a forward slash (alias/). Aliases that begin with "alias/AWS" are reserved.
	AliasName *string `min:"1" type:"string" required:"true"`

	metadataDeleteAliasInput `json:"-" xml:"-"`
}

type metadataDeleteAliasInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

type DeleteAliasOutput struct {
	metadataDeleteAliasOutput `json:"-" xml:"-"`
}

type metadataDeleteAliasOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DescribeKeyInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`

	metadataDescribeKeyInput `json:"-" xml:"-"`
}

type metadataDescribeKeyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyInput) GoString() string {
	return s.String()
}

type DescribeKeyOutput struct {
	// Metadata associated with the key.
	KeyMetadata *KeyMetadata `type:"structure"`

	metadataDescribeKeyOutput `json:"-" xml:"-"`
}

type metadataDescribeKeyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyOutput) GoString() string {
	return s.String()
}

type DisableKeyInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	metadataDisableKeyInput `json:"-" xml:"-"`
}

type metadataDisableKeyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyInput) GoString() string {
	return s.String()
}

type DisableKeyOutput struct {
	metadataDisableKeyOutput `json:"-" xml:"-"`
}

type metadataDisableKeyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyOutput) GoString() string {
	return s.String()
}

type DisableKeyRotationInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	metadataDisableKeyRotationInput `json:"-" xml:"-"`
}

type metadataDisableKeyRotationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableKeyRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyRotationInput) GoString() string {
	return s.String()
}

type DisableKeyRotationOutput struct {
	metadataDisableKeyRotationOutput `json:"-" xml:"-"`
}

type metadataDisableKeyRotationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableKeyRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyRotationOutput) GoString() string {
	return s.String()
}

type EnableKeyInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	metadataEnableKeyInput `json:"-" xml:"-"`
}

type metadataEnableKeyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyInput) GoString() string {
	return s.String()
}

type EnableKeyOutput struct {
	metadataEnableKeyOutput `json:"-" xml:"-"`
}

type metadataEnableKeyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyOutput) GoString() string {
	return s.String()
}

type EnableKeyRotationInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	metadataEnableKeyRotationInput `json:"-" xml:"-"`
}

type metadataEnableKeyRotationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableKeyRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyRotationInput) GoString() string {
	return s.String()
}

type EnableKeyRotationOutput struct {
	metadataEnableKeyRotationOutput `json:"-" xml:"-"`
}

type metadataEnableKeyRotationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableKeyRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyRotationOutput) GoString() string {
	return s.String()
}

type EncryptInput struct {
	// Name/value pair that specifies the encryption context to be used for authenticated
	// encryption. If used here, the same value must be supplied to the Decrypt
	// API or decryption will fail. For more information, see Encryption Context
	// (http://docs.aws.amazon.com/kms/latest/developerguide/encrypt-context.html).
	EncryptionContext map[string]*string `type:"map"`

	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token).
	GrantTokens []*string `type:"list"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`

	// Data to be encrypted.
	Plaintext []byte `min:"1" type:"blob" required:"true"`

	metadataEncryptInput `json:"-" xml:"-"`
}

type metadataEncryptInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EncryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptInput) GoString() string {
	return s.String()
}

type EncryptOutput struct {
	// The encrypted plaintext. If you are using the CLI, the value is Base64 encoded.
	// Otherwise, it is not encoded.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The ID of the key used during encryption.
	KeyId *string `min:"1" type:"string"`

	metadataEncryptOutput `json:"-" xml:"-"`
}

type metadataEncryptOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EncryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptOutput) GoString() string {
	return s.String()
}

type GenerateDataKeyInput struct {
	// Name/value pair that contains additional data to be authenticated during
	// the encryption and decryption processes that use the key. This value is logged
	// by AWS CloudTrail to provide context around the data encrypted by the key.
	EncryptionContext map[string]*string `type:"map"`

	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token).
	GrantTokens []*string `type:"list"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`

	// Value that identifies the encryption algorithm and key size to generate a
	// data key for. Currently this can be AES_128 or AES_256.
	KeySpec *string `type:"string" enum:"DataKeySpec"`

	// Integer that contains the number of bytes to generate. Common values are
	// 128, 256, 512, and 1024. 1024 is the current limit. We recommend that you
	// use the KeySpec parameter instead.
	NumberOfBytes *int64 `min:"1" type:"integer"`

	metadataGenerateDataKeyInput `json:"-" xml:"-"`
}

type metadataGenerateDataKeyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GenerateDataKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyInput) GoString() string {
	return s.String()
}

type GenerateDataKeyOutput struct {
	// Ciphertext that contains the encrypted data key. You must store the blob
	// and enough information to reconstruct the encryption context so that the
	// data encrypted by using the key can later be decrypted. You must provide
	// both the ciphertext blob and the encryption context to the Decrypt API to
	// recover the plaintext data key and decrypt the object.
	//
	// If you are using the CLI, the value is Base64 encoded. Otherwise, it is
	// not encoded.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// System generated unique identifier of the key to be used to decrypt the encrypted
	// copy of the data key.
	KeyId *string `min:"1" type:"string"`

	// Plaintext that contains the data key. Use this for encryption and decryption
	// and then remove it from memory as soon as possible.
	Plaintext []byte `min:"1" type:"blob"`

	metadataGenerateDataKeyOutput `json:"-" xml:"-"`
}

type metadataGenerateDataKeyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GenerateDataKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyOutput) GoString() string {
	return s.String()
}

type GenerateDataKeyWithoutPlaintextInput struct {
	// Name:value pair that contains additional data to be authenticated during
	// the encryption and decryption processes.
	EncryptionContext map[string]*string `type:"map"`

	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token).
	GrantTokens []*string `type:"list"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`

	// Value that identifies the encryption algorithm and key size. Currently this
	// can be AES_128 or AES_256.
	KeySpec *string `type:"string" enum:"DataKeySpec"`

	// Integer that contains the number of bytes to generate. Common values are
	// 128, 256, 512, 1024 and so on. We recommend that you use the KeySpec parameter
	// instead.
	NumberOfBytes *int64 `min:"1" type:"integer"`

	metadataGenerateDataKeyWithoutPlaintextInput `json:"-" xml:"-"`
}

type metadataGenerateDataKeyWithoutPlaintextInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GenerateDataKeyWithoutPlaintextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyWithoutPlaintextInput) GoString() string {
	return s.String()
}

type GenerateDataKeyWithoutPlaintextOutput struct {
	// Ciphertext that contains the wrapped data key. You must store the blob and
	// encryption context so that the key can be used in a future decrypt operation.
	//
	// If you are using the CLI, the value is Base64 encoded. Otherwise, it is
	// not encoded.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// System generated unique identifier of the key to be used to decrypt the encrypted
	// copy of the data key.
	KeyId *string `min:"1" type:"string"`

	metadataGenerateDataKeyWithoutPlaintextOutput `json:"-" xml:"-"`
}

type metadataGenerateDataKeyWithoutPlaintextOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GenerateDataKeyWithoutPlaintextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyWithoutPlaintextOutput) GoString() string {
	return s.String()
}

type GenerateRandomInput struct {
	// Integer that contains the number of bytes to generate. Common values are
	// 128, 256, 512, 1024 and so on. The current limit is 1024 bytes.
	NumberOfBytes *int64 `min:"1" type:"integer"`

	metadataGenerateRandomInput `json:"-" xml:"-"`
}

type metadataGenerateRandomInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GenerateRandomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateRandomInput) GoString() string {
	return s.String()
}

type GenerateRandomOutput struct {
	// Plaintext that contains the unpredictable byte string.
	Plaintext []byte `min:"1" type:"blob"`

	metadataGenerateRandomOutput `json:"-" xml:"-"`
}

type metadataGenerateRandomOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GenerateRandomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateRandomOutput) GoString() string {
	return s.String()
}

type GetKeyPolicyInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	// String that contains the name of the policy. Currently, this must be "default".
	// Policy names can be discovered by calling ListKeyPolicies.
	PolicyName *string `min:"1" type:"string" required:"true"`

	metadataGetKeyPolicyInput `json:"-" xml:"-"`
}

type metadataGetKeyPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetKeyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPolicyInput) GoString() string {
	return s.String()
}

type GetKeyPolicyOutput struct {
	// A policy document in JSON format.
	Policy *string `min:"1" type:"string"`

	metadataGetKeyPolicyOutput `json:"-" xml:"-"`
}

type metadataGetKeyPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetKeyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPolicyOutput) GoString() string {
	return s.String()
}

type GetKeyRotationStatusInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	metadataGetKeyRotationStatusInput `json:"-" xml:"-"`
}

type metadataGetKeyRotationStatusInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetKeyRotationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyRotationStatusInput) GoString() string {
	return s.String()
}

type GetKeyRotationStatusOutput struct {
	// A Boolean value that specifies whether key rotation is enabled.
	KeyRotationEnabled *bool `type:"boolean"`

	metadataGetKeyRotationStatusOutput `json:"-" xml:"-"`
}

type metadataGetKeyRotationStatusOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetKeyRotationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyRotationStatusOutput) GoString() string {
	return s.String()
}

// Contains constraints on the grant.
type GrantConstraints struct {
	// The constraint contains additional key/value pairs that serve to further
	// limit the grant.
	EncryptionContextEquals map[string]*string `type:"map"`

	// The constraint equals the full encryption context.
	EncryptionContextSubset map[string]*string `type:"map"`

	metadataGrantConstraints `json:"-" xml:"-"`
}

type metadataGrantConstraints struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GrantConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantConstraints) GoString() string {
	return s.String()
}

// Contains information about each entry in the grant list.
type GrantListEntry struct {
	// Specifies the conditions under which the actions specified by the Operations
	// parameter are allowed.
	Constraints *GrantConstraints `type:"structure"`

	// Unique grant identifier.
	GrantId *string `min:"1" type:"string"`

	// The principal that receives the grant permission.
	GranteePrincipal *string `min:"1" type:"string"`

	// The account under which the grant was issued.
	IssuingAccount *string `min:"1" type:"string"`

	// List of operations permitted by the grant. This can be any combination of
	// one or more of the following values:  Decrypt Encrypt GenerateDataKey GenerateDataKeyWithoutPlaintext
	// ReEncryptFrom ReEncryptTo CreateGrant
	Operations []*string `type:"list"`

	// The principal that can retire the account.
	RetiringPrincipal *string `min:"1" type:"string"`

	metadataGrantListEntry `json:"-" xml:"-"`
}

type metadataGrantListEntry struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GrantListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantListEntry) GoString() string {
	return s.String()
}

// Contains information about each entry in the key list.
type KeyListEntry struct {
	// ARN of the key.
	KeyArn *string `min:"20" type:"string"`

	// Unique identifier of the key.
	KeyId *string `min:"1" type:"string"`

	metadataKeyListEntry `json:"-" xml:"-"`
}

type metadataKeyListEntry struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s KeyListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyListEntry) GoString() string {
	return s.String()
}

// Contains metadata associated with a specific key.
type KeyMetadata struct {
	// Account ID number.
	AWSAccountId *string `type:"string"`

	// Key ARN (Amazon Resource Name).
	Arn *string `min:"20" type:"string"`

	// Date the key was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description of the key.
	Description *string `type:"string"`

	// Value that specifies whether the key is enabled.
	Enabled *bool `type:"boolean"`

	// Unique identifier for the key.
	KeyId *string `min:"1" type:"string" required:"true"`

	// A value that specifies what operation(s) the key can perform.
	KeyUsage *string `type:"string" enum:"KeyUsageType"`

	metadataKeyMetadata `json:"-" xml:"-"`
}

type metadataKeyMetadata struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s KeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyMetadata) GoString() string {
	return s.String()
}

type ListAliasesInput struct {
	// Specify this parameter when paginating results to indicate the maximum number
	// of aliases you want in each response. If there are additional aliases beyond
	// the maximum you specify, the Truncated response element will be set to true.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter when paginating results, and only in a subsequent request
	// after you've received a response where the results are truncated. Set it
	// to the value of the NextMarker element in the response you just received.
	Marker *string `min:"1" type:"string"`

	metadataListAliasesInput `json:"-" xml:"-"`
}

type metadataListAliasesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

type ListAliasesOutput struct {
	// A list of key aliases in the user's account.
	Aliases []*AliasListEntry `type:"list"`

	// If Truncated is true, this value is present and contains the value to use
	// for the Marker request parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more aliases in the list.
	Truncated *bool `type:"boolean"`

	metadataListAliasesOutput `json:"-" xml:"-"`
}

type metadataListAliasesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

type ListGrantsInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	// Specify this parameter only when paginating results to indicate the maximum
	// number of grants you want listed in the response. If there are additional
	// grants beyond the maximum you specify, the Truncated response element will
	// be set to true.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results, and only in a subsequent
	// request after you've received a response where the results are truncated.
	// Set it to the value of the NextMarker in the response you just received.
	Marker *string `min:"1" type:"string"`

	metadataListGrantsInput `json:"-" xml:"-"`
}

type metadataListGrantsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGrantsInput) GoString() string {
	return s.String()
}

type ListGrantsOutput struct {
	// A list of grants.
	Grants []*GrantListEntry `type:"list"`

	// If Truncated is true, this value is present and contains the value to use
	// for the Marker request parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more grants in the list.
	Truncated *bool `type:"boolean"`

	metadataListGrantsOutput `json:"-" xml:"-"`
}

type metadataListGrantsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListGrantsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGrantsOutput) GoString() string {
	return s.String()
}

type ListKeyPoliciesInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	KeyId *string `min:"1" type:"string" required:"true"`

	// Specify this parameter only when paginating results to indicate the maximum
	// number of policies you want listed in the response. If there are additional
	// policies beyond the maximum you specify, the Truncated response element will
	// be set to true.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results, and only in a subsequent
	// request after you've received a response where the results are truncated.
	// Set it to the value of the NextMarker in the response you just received.
	Marker *string `min:"1" type:"string"`

	metadataListKeyPoliciesInput `json:"-" xml:"-"`
}

type metadataListKeyPoliciesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListKeyPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPoliciesInput) GoString() string {
	return s.String()
}

type ListKeyPoliciesOutput struct {
	// If Truncated is true, this value is present and contains the value to use
	// for the Marker request parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A list of policy names. Currently, there is only one policy and it is named
	// "Default".
	PolicyNames []*string `type:"list"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more policies in the list.
	Truncated *bool `type:"boolean"`

	metadataListKeyPoliciesOutput `json:"-" xml:"-"`
}

type metadataListKeyPoliciesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListKeyPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPoliciesOutput) GoString() string {
	return s.String()
}

type ListKeysInput struct {
	// Specify this parameter only when paginating results to indicate the maximum
	// number of keys you want listed in the response. If there are additional keys
	// beyond the maximum you specify, the Truncated response element will be set
	// to true.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results, and only in a subsequent
	// request after you've received a response where the results are truncated.
	// Set it to the value of the NextMarker in the response you just received.
	Marker *string `min:"1" type:"string"`

	metadataListKeysInput `json:"-" xml:"-"`
}

type metadataListKeysInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeysInput) GoString() string {
	return s.String()
}

type ListKeysOutput struct {
	// A list of keys.
	Keys []*KeyListEntry `type:"list"`

	// If Truncated is true, this value is present and contains the value to use
	// for the Marker request parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more keys in the list.
	Truncated *bool `type:"boolean"`

	metadataListKeysOutput `json:"-" xml:"-"`
}

type metadataListKeysOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeysOutput) GoString() string {
	return s.String()
}

type PutKeyPolicyInput struct {
	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	// The policy, in JSON format, to be attached to the key.
	Policy *string `min:"1" type:"string" required:"true"`

	// Name of the policy to be attached. Currently, the only supported name is
	// "default".
	PolicyName *string `min:"1" type:"string" required:"true"`

	metadataPutKeyPolicyInput `json:"-" xml:"-"`
}

type metadataPutKeyPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutKeyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutKeyPolicyInput) GoString() string {
	return s.String()
}

type PutKeyPolicyOutput struct {
	metadataPutKeyPolicyOutput `json:"-" xml:"-"`
}

type metadataPutKeyPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutKeyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutKeyPolicyOutput) GoString() string {
	return s.String()
}

type ReEncryptInput struct {
	// Ciphertext of the data to re-encrypt.
	CiphertextBlob []byte `min:"1" type:"blob" required:"true"`

	// Encryption context to be used when the data is re-encrypted.
	DestinationEncryptionContext map[string]*string `type:"map"`

	// A unique identifier for the customer master key used to re-encrypt the data.
	// This value can be a globally unique identifier, a fully specified ARN to
	// either an alias or a key, or an alias name prefixed by "alias/".  Key ARN
	// Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012 Alias
	// Name Example - alias/MyAliasName
	DestinationKeyId *string `min:"1" type:"string" required:"true"`

	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token).
	GrantTokens []*string `type:"list"`

	// Encryption context used to encrypt and decrypt the data specified in the
	// CiphertextBlob parameter.
	SourceEncryptionContext map[string]*string `type:"map"`

	metadataReEncryptInput `json:"-" xml:"-"`
}

type metadataReEncryptInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReEncryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReEncryptInput) GoString() string {
	return s.String()
}

type ReEncryptOutput struct {
	// The re-encrypted data. If you are using the CLI, the value is Base64 encoded.
	// Otherwise, it is not encoded.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// Unique identifier of the key used to re-encrypt the data.
	KeyId *string `min:"1" type:"string"`

	// Unique identifier of the key used to originally encrypt the data.
	SourceKeyId *string `min:"1" type:"string"`

	metadataReEncryptOutput `json:"-" xml:"-"`
}

type metadataReEncryptOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReEncryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReEncryptOutput) GoString() string {
	return s.String()
}

type RetireGrantInput struct {
	// Unique identifier of the grant to be retired. The grant ID is returned by
	// the CreateGrant function.  Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
	GrantId *string `min:"1" type:"string"`

	// Token that identifies the grant to be retired.
	GrantToken *string `min:"1" type:"string"`

	// A unique identifier for the customer master key associated with the grant.
	// This value can be a globally unique identifier or a fully specified ARN of
	// the key.  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string"`

	metadataRetireGrantInput `json:"-" xml:"-"`
}

type metadataRetireGrantInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RetireGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetireGrantInput) GoString() string {
	return s.String()
}

type RetireGrantOutput struct {
	metadataRetireGrantOutput `json:"-" xml:"-"`
}

type metadataRetireGrantOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RetireGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetireGrantOutput) GoString() string {
	return s.String()
}

type RevokeGrantInput struct {
	// Identifier of the grant to be revoked.
	GrantId *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the customer master key associated with the grant.
	// This value can be a globally unique identifier or the fully specified ARN
	// to a key.  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	metadataRevokeGrantInput `json:"-" xml:"-"`
}

type metadataRevokeGrantInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RevokeGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeGrantInput) GoString() string {
	return s.String()
}

type RevokeGrantOutput struct {
	metadataRevokeGrantOutput `json:"-" xml:"-"`
}

type metadataRevokeGrantOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RevokeGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeGrantOutput) GoString() string {
	return s.String()
}

type UpdateAliasInput struct {
	// String that contains the name of the alias to be modifed. The name must start
	// with the word "alias" followed by a forward slash (alias/). Aliases that
	// begin with "alias/AWS" are reserved.
	AliasName *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the customer master key to be associated with the alias.
	// This value can be a globally unique identifier or the fully specified ARN
	// of a key.  Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	TargetKeyId *string `min:"1" type:"string" required:"true"`

	metadataUpdateAliasInput `json:"-" xml:"-"`
}

type metadataUpdateAliasInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

type UpdateAliasOutput struct {
	metadataUpdateAliasOutput `json:"-" xml:"-"`
}

type metadataUpdateAliasOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasOutput) GoString() string {
	return s.String()
}

type UpdateKeyDescriptionInput struct {
	// New description for the key.
	Description *string `type:"string" required:"true"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.  Key ARN Example -
	// arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	// Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string" required:"true"`

	metadataUpdateKeyDescriptionInput `json:"-" xml:"-"`
}

type metadataUpdateKeyDescriptionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateKeyDescriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyDescriptionInput) GoString() string {
	return s.String()
}

type UpdateKeyDescriptionOutput struct {
	metadataUpdateKeyDescriptionOutput `json:"-" xml:"-"`
}

type metadataUpdateKeyDescriptionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateKeyDescriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyDescriptionOutput) GoString() string {
	return s.String()
}

const (
	// @enum DataKeySpec
	DataKeySpecAes256 = "AES_256"
	// @enum DataKeySpec
	DataKeySpecAes128 = "AES_128"
)

const (
	// @enum GrantOperation
	GrantOperationDecrypt = "Decrypt"
	// @enum GrantOperation
	GrantOperationEncrypt = "Encrypt"
	// @enum GrantOperation
	GrantOperationGenerateDataKey = "GenerateDataKey"
	// @enum GrantOperation
	GrantOperationGenerateDataKeyWithoutPlaintext = "GenerateDataKeyWithoutPlaintext"
	// @enum GrantOperation
	GrantOperationReEncryptFrom = "ReEncryptFrom"
	// @enum GrantOperation
	GrantOperationReEncryptTo = "ReEncryptTo"
	// @enum GrantOperation
	GrantOperationCreateGrant = "CreateGrant"
	// @enum GrantOperation
	GrantOperationRetireGrant = "RetireGrant"
)

const (
	// @enum KeyUsageType
	KeyUsageTypeEncryptDecrypt = "ENCRYPT_DECRYPT"
)
