// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package opsworks provides a client for AWS OpsWorks.
package opsworks

import (
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssignInstance = "AssignInstance"

// AssignInstanceRequest generates a request for the AssignInstance operation.
func (c *OpsWorks) AssignInstanceRequest(input *AssignInstanceInput) (req *request.Request, output *AssignInstanceOutput) {
	op := &request.Operation{
		Name:       opAssignInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssignInstanceOutput{}
	req.Data = output
	return
}

// Assign a registered instance to a layer.
//
//  You can assign registered on-premises instances to any layer type. You
// can assign registered Amazon EC2 instances only to custom layers. You cannot
// use this action with instances that were created with AWS OpsWorks.  Required
// Permissions: To use this action, an AWS Identity and Access Management (IAM)
// user must have a Manage permissions level for the stack or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) AssignInstance(input *AssignInstanceInput) (*AssignInstanceOutput, error) {
	req, out := c.AssignInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opAssignVolume = "AssignVolume"

// AssignVolumeRequest generates a request for the AssignVolume operation.
func (c *OpsWorks) AssignVolumeRequest(input *AssignVolumeInput) (req *request.Request, output *AssignVolumeOutput) {
	op := &request.Operation{
		Name:       opAssignVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssignVolumeOutput{}
	req.Data = output
	return
}

// Assigns one of the stack's registered Amazon EBS volumes to a specified instance.
// The volume must first be registered with the stack by calling RegisterVolume.
// After you register the volume, you must call UpdateVolume to specify a mount
// point before calling AssignVolume. For more information, see Resource Management
// (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) AssignVolume(input *AssignVolumeInput) (*AssignVolumeOutput, error) {
	req, out := c.AssignVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opAssociateElasticIp = "AssociateElasticIp"

// AssociateElasticIpRequest generates a request for the AssociateElasticIp operation.
func (c *OpsWorks) AssociateElasticIpRequest(input *AssociateElasticIpInput) (req *request.Request, output *AssociateElasticIpOutput) {
	op := &request.Operation{
		Name:       opAssociateElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateElasticIpInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssociateElasticIpOutput{}
	req.Data = output
	return
}

// Associates one of the stack's registered Elastic IP addresses with a specified
// instance. The address must first be registered with the stack by calling
// RegisterElasticIp. For more information, see Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) AssociateElasticIp(input *AssociateElasticIpInput) (*AssociateElasticIpOutput, error) {
	req, out := c.AssociateElasticIpRequest(input)
	err := req.Send()
	return out, err
}

const opAttachElasticLoadBalancer = "AttachElasticLoadBalancer"

// AttachElasticLoadBalancerRequest generates a request for the AttachElasticLoadBalancer operation.
func (c *OpsWorks) AttachElasticLoadBalancerRequest(input *AttachElasticLoadBalancerInput) (req *request.Request, output *AttachElasticLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opAttachElasticLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachElasticLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachElasticLoadBalancerOutput{}
	req.Data = output
	return
}

// Attaches an Elastic Load Balancing load balancer to a specified layer. For
// more information, see Elastic Load Balancing (http://docs.aws.amazon.com/opsworks/latest/userguide/load-balancer-elb.html).
//
//  You must create the Elastic Load Balancing instance separately, by using
// the Elastic Load Balancing console, API, or CLI. For more information, see
//  Elastic Load Balancing Developer Guide (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/Welcome.html).
//
//  Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) AttachElasticLoadBalancer(input *AttachElasticLoadBalancerInput) (*AttachElasticLoadBalancerOutput, error) {
	req, out := c.AttachElasticLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opCloneStack = "CloneStack"

// CloneStackRequest generates a request for the CloneStack operation.
func (c *OpsWorks) CloneStackRequest(input *CloneStackInput) (req *request.Request, output *CloneStackOutput) {
	op := &request.Operation{
		Name:       opCloneStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloneStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CloneStackOutput{}
	req.Data = output
	return
}

// Creates a clone of a specified stack. For more information, see Clone a Stack
// (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-cloning.html).
// By default, all parameters are set to the values used by the parent stack.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) CloneStack(input *CloneStackInput) (*CloneStackOutput, error) {
	req, out := c.CloneStackRequest(input)
	err := req.Send()
	return out, err
}

const opCreateApp = "CreateApp"

// CreateAppRequest generates a request for the CreateApp operation.
func (c *OpsWorks) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateAppOutput{}
	req.Data = output
	return
}

// Creates an app for a specified stack. For more information, see Creating
// Apps (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	err := req.Send()
	return out, err
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a request for the CreateDeployment operation.
func (c *OpsWorks) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDeploymentOutput{}
	req.Data = output
	return
}

// Runs deployment or stack commands. For more information, see Deploying Apps
// (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html)
// and Run Stack Commands (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html).
//
// Required Permissions: To use this action, an IAM user must have a Deploy
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information on user permissions, see Managing
// User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInstance = "CreateInstance"

// CreateInstanceRequest generates a request for the CreateInstance operation.
func (c *OpsWorks) CreateInstanceRequest(input *CreateInstanceInput) (req *request.Request, output *CreateInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateInstanceOutput{}
	req.Data = output
	return
}

// Creates an instance in a specified stack. For more information, see Adding
// an Instance to a Layer (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) CreateInstance(input *CreateInstanceInput) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLayer = "CreateLayer"

// CreateLayerRequest generates a request for the CreateLayer operation.
func (c *OpsWorks) CreateLayerRequest(input *CreateLayerInput) (req *request.Request, output *CreateLayerOutput) {
	op := &request.Operation{
		Name:       opCreateLayer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLayerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateLayerOutput{}
	req.Data = output
	return
}

// Creates a layer. For more information, see How to Create a Layer (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-create.html).
//
//  You should use CreateLayer for noncustom layer types such as PHP App Server
// only if the stack does not have an existing layer of that type. A stack can
// have at most one instance of each noncustom layer; if you attempt to create
// a second instance, CreateLayer fails. A stack can have an arbitrary number
// of custom layers, so you can call CreateLayer as many times as you like for
// that layer type.
//
//  Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) CreateLayer(input *CreateLayerInput) (*CreateLayerOutput, error) {
	req, out := c.CreateLayerRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a request for the CreateStack operation.
func (c *OpsWorks) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateStackOutput{}
	req.Data = output
	return
}

// Creates a new stack. For more information, see Create a New Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-edit.html).
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	err := req.Send()
	return out, err
}

const opCreateUserProfile = "CreateUserProfile"

// CreateUserProfileRequest generates a request for the CreateUserProfile operation.
func (c *OpsWorks) CreateUserProfileRequest(input *CreateUserProfileInput) (req *request.Request, output *CreateUserProfileOutput) {
	op := &request.Operation{
		Name:       opCreateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserProfileInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateUserProfileOutput{}
	req.Data = output
	return
}

// Creates a new user profile.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) CreateUserProfile(input *CreateUserProfileInput) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a request for the DeleteApp operation.
func (c *OpsWorks) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteAppOutput{}
	req.Data = output
	return
}

// Deletes a specified app.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteInstance = "DeleteInstance"

// DeleteInstanceRequest generates a request for the DeleteInstance operation.
func (c *OpsWorks) DeleteInstanceRequest(input *DeleteInstanceInput) (req *request.Request, output *DeleteInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteInstanceOutput{}
	req.Data = output
	return
}

// Deletes a specified instance, which terminates the associated Amazon EC2
// instance. You must stop an instance before you can delete it.
//
// For more information, see Deleting Instances (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-delete.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DeleteInstance(input *DeleteInstanceInput) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLayer = "DeleteLayer"

// DeleteLayerRequest generates a request for the DeleteLayer operation.
func (c *OpsWorks) DeleteLayerRequest(input *DeleteLayerInput) (req *request.Request, output *DeleteLayerOutput) {
	op := &request.Operation{
		Name:       opDeleteLayer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLayerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteLayerOutput{}
	req.Data = output
	return
}

// Deletes a specified layer. You must first stop and then delete all associated
// instances or unassign registered instances. For more information, see How
// to Delete a Layer (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-delete.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DeleteLayer(input *DeleteLayerInput) (*DeleteLayerOutput, error) {
	req, out := c.DeleteLayerRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a request for the DeleteStack operation.
func (c *OpsWorks) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteStackOutput{}
	req.Data = output
	return
}

// Deletes a specified stack. You must first delete all instances, layers, and
// apps or deregister registered instances. For more information, see Shut Down
// a Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUserProfile = "DeleteUserProfile"

// DeleteUserProfileRequest generates a request for the DeleteUserProfile operation.
func (c *OpsWorks) DeleteUserProfileRequest(input *DeleteUserProfileInput) (req *request.Request, output *DeleteUserProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserProfileInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteUserProfileOutput{}
	req.Data = output
	return
}

// Deletes a user profile.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DeleteUserProfile(input *DeleteUserProfileInput) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterEcsCluster = "DeregisterEcsCluster"

// DeregisterEcsClusterRequest generates a request for the DeregisterEcsCluster operation.
func (c *OpsWorks) DeregisterEcsClusterRequest(input *DeregisterEcsClusterInput) (req *request.Request, output *DeregisterEcsClusterOutput) {
	op := &request.Operation{
		Name:       opDeregisterEcsCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterEcsClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterEcsClusterOutput{}
	req.Data = output
	return
}

// Deregisters a specified Amazon ECS cluster from a stack. For more information,
// see  Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see .
func (c *OpsWorks) DeregisterEcsCluster(input *DeregisterEcsClusterInput) (*DeregisterEcsClusterOutput, error) {
	req, out := c.DeregisterEcsClusterRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterElasticIp = "DeregisterElasticIp"

// DeregisterElasticIpRequest generates a request for the DeregisterElasticIp operation.
func (c *OpsWorks) DeregisterElasticIpRequest(input *DeregisterElasticIpInput) (req *request.Request, output *DeregisterElasticIpOutput) {
	op := &request.Operation{
		Name:       opDeregisterElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterElasticIpInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterElasticIpOutput{}
	req.Data = output
	return
}

// Deregisters a specified Elastic IP address. The address can then be registered
// by another stack. For more information, see Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DeregisterElasticIp(input *DeregisterElasticIpInput) (*DeregisterElasticIpOutput, error) {
	req, out := c.DeregisterElasticIpRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterInstance = "DeregisterInstance"

// DeregisterInstanceRequest generates a request for the DeregisterInstance operation.
func (c *OpsWorks) DeregisterInstanceRequest(input *DeregisterInstanceInput) (req *request.Request, output *DeregisterInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterInstanceOutput{}
	req.Data = output
	return
}

// Deregister a registered Amazon EC2 or on-premises instance. This action removes
// the instance from the stack and returns it to your control. This action can
// not be used with instances that were created with AWS OpsWorks.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DeregisterInstance(input *DeregisterInstanceInput) (*DeregisterInstanceOutput, error) {
	req, out := c.DeregisterInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterRdsDbInstance = "DeregisterRdsDbInstance"

// DeregisterRdsDbInstanceRequest generates a request for the DeregisterRdsDbInstance operation.
func (c *OpsWorks) DeregisterRdsDbInstanceRequest(input *DeregisterRdsDbInstanceInput) (req *request.Request, output *DeregisterRdsDbInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterRdsDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterRdsDbInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterRdsDbInstanceOutput{}
	req.Data = output
	return
}

// Deregisters an Amazon RDS instance.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DeregisterRdsDbInstance(input *DeregisterRdsDbInstanceInput) (*DeregisterRdsDbInstanceOutput, error) {
	req, out := c.DeregisterRdsDbInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opDeregisterVolume = "DeregisterVolume"

// DeregisterVolumeRequest generates a request for the DeregisterVolume operation.
func (c *OpsWorks) DeregisterVolumeRequest(input *DeregisterVolumeInput) (req *request.Request, output *DeregisterVolumeOutput) {
	op := &request.Operation{
		Name:       opDeregisterVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeregisterVolumeOutput{}
	req.Data = output
	return
}

// Deregisters an Amazon EBS volume. The volume can then be registered by another
// stack. For more information, see Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DeregisterVolume(input *DeregisterVolumeInput) (*DeregisterVolumeOutput, error) {
	req, out := c.DeregisterVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAgentVersions = "DescribeAgentVersions"

// DescribeAgentVersionsRequest generates a request for the DescribeAgentVersions operation.
func (c *OpsWorks) DescribeAgentVersionsRequest(input *DescribeAgentVersionsInput) (req *request.Request, output *DescribeAgentVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAgentVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgentVersionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAgentVersionsOutput{}
	req.Data = output
	return
}

// Describes the available AWS OpsWorks agent versions. You must specify a stack
// ID or a configuration manager. DescribeAgentVersions returns a list of available
// agent versions for the specified stack or configuration manager.
func (c *OpsWorks) DescribeAgentVersions(input *DescribeAgentVersionsInput) (*DescribeAgentVersionsOutput, error) {
	req, out := c.DescribeAgentVersionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeApps = "DescribeApps"

// DescribeAppsRequest generates a request for the DescribeApps operation.
func (c *OpsWorks) DescribeAppsRequest(input *DescribeAppsInput) (req *request.Request, output *DescribeAppsOutput) {
	op := &request.Operation{
		Name:       opDescribeApps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAppsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAppsOutput{}
	req.Data = output
	return
}

// Requests a description of a specified set of apps.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeApps(input *DescribeAppsInput) (*DescribeAppsOutput, error) {
	req, out := c.DescribeAppsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCommands = "DescribeCommands"

// DescribeCommandsRequest generates a request for the DescribeCommands operation.
func (c *OpsWorks) DescribeCommandsRequest(input *DescribeCommandsInput) (req *request.Request, output *DescribeCommandsOutput) {
	op := &request.Operation{
		Name:       opDescribeCommands,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCommandsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCommandsOutput{}
	req.Data = output
	return
}

// Describes the results of specified commands.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeCommands(input *DescribeCommandsInput) (*DescribeCommandsOutput, error) {
	req, out := c.DescribeCommandsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeDeployments = "DescribeDeployments"

// DescribeDeploymentsRequest generates a request for the DescribeDeployments operation.
func (c *OpsWorks) DescribeDeploymentsRequest(input *DescribeDeploymentsInput) (req *request.Request, output *DescribeDeploymentsOutput) {
	op := &request.Operation{
		Name:       opDescribeDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeploymentsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeDeploymentsOutput{}
	req.Data = output
	return
}

// Requests a description of a specified set of deployments.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeDeployments(input *DescribeDeploymentsInput) (*DescribeDeploymentsOutput, error) {
	req, out := c.DescribeDeploymentsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeEcsClusters = "DescribeEcsClusters"

// DescribeEcsClustersRequest generates a request for the DescribeEcsClusters operation.
func (c *OpsWorks) DescribeEcsClustersRequest(input *DescribeEcsClustersInput) (req *request.Request, output *DescribeEcsClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeEcsClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEcsClustersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeEcsClustersOutput{}
	req.Data = output
	return
}

// Describes Amazon ECS clusters that are registered with a stack. If you specify
// only a stack ID, you can use the MaxResults and NextToken parameters to paginate
// the response. However, AWS OpsWorks currently supports only one cluster per
// layer, so the result set has a maximum of one element.
//
// Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack or an attached policy that
// explicitly grants permission. For more information on user permissions, see
// Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeEcsClusters(input *DescribeEcsClustersInput) (*DescribeEcsClustersOutput, error) {
	req, out := c.DescribeEcsClustersRequest(input)
	err := req.Send()
	return out, err
}

func (c *OpsWorks) DescribeEcsClustersPages(input *DescribeEcsClustersInput, fn func(p *DescribeEcsClustersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeEcsClustersRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeEcsClustersOutput), lastPage)
	})
}

const opDescribeElasticIps = "DescribeElasticIps"

// DescribeElasticIpsRequest generates a request for the DescribeElasticIps operation.
func (c *OpsWorks) DescribeElasticIpsRequest(input *DescribeElasticIpsInput) (req *request.Request, output *DescribeElasticIpsOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticIps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeElasticIpsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeElasticIpsOutput{}
	req.Data = output
	return
}

// Describes Elastic IP addresses (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeElasticIps(input *DescribeElasticIpsInput) (*DescribeElasticIpsOutput, error) {
	req, out := c.DescribeElasticIpsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeElasticLoadBalancers = "DescribeElasticLoadBalancers"

// DescribeElasticLoadBalancersRequest generates a request for the DescribeElasticLoadBalancers operation.
func (c *OpsWorks) DescribeElasticLoadBalancersRequest(input *DescribeElasticLoadBalancersInput) (req *request.Request, output *DescribeElasticLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeElasticLoadBalancersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeElasticLoadBalancersOutput{}
	req.Data = output
	return
}

// Describes a stack's Elastic Load Balancing instances.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeElasticLoadBalancers(input *DescribeElasticLoadBalancersInput) (*DescribeElasticLoadBalancersOutput, error) {
	req, out := c.DescribeElasticLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest generates a request for the DescribeInstances operation.
func (c *OpsWorks) DescribeInstancesRequest(input *DescribeInstancesInput) (req *request.Request, output *DescribeInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInstancesOutput{}
	req.Data = output
	return
}

// Requests a description of a set of instances.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeInstances(input *DescribeInstancesInput) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLayers = "DescribeLayers"

// DescribeLayersRequest generates a request for the DescribeLayers operation.
func (c *OpsWorks) DescribeLayersRequest(input *DescribeLayersInput) (req *request.Request, output *DescribeLayersOutput) {
	op := &request.Operation{
		Name:       opDescribeLayers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLayersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLayersOutput{}
	req.Data = output
	return
}

// Requests a description of one or more layers in a specified stack.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeLayers(input *DescribeLayersInput) (*DescribeLayersOutput, error) {
	req, out := c.DescribeLayersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLoadBasedAutoScaling = "DescribeLoadBasedAutoScaling"

// DescribeLoadBasedAutoScalingRequest generates a request for the DescribeLoadBasedAutoScaling operation.
func (c *OpsWorks) DescribeLoadBasedAutoScalingRequest(input *DescribeLoadBasedAutoScalingInput) (req *request.Request, output *DescribeLoadBasedAutoScalingOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBasedAutoScalingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBasedAutoScalingOutput{}
	req.Data = output
	return
}

// Describes load-based auto scaling configurations for specified layers.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeLoadBasedAutoScaling(input *DescribeLoadBasedAutoScalingInput) (*DescribeLoadBasedAutoScalingOutput, error) {
	req, out := c.DescribeLoadBasedAutoScalingRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeMyUserProfile = "DescribeMyUserProfile"

// DescribeMyUserProfileRequest generates a request for the DescribeMyUserProfile operation.
func (c *OpsWorks) DescribeMyUserProfileRequest(input *DescribeMyUserProfileInput) (req *request.Request, output *DescribeMyUserProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeMyUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMyUserProfileInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeMyUserProfileOutput{}
	req.Data = output
	return
}

// Describes a user's SSH information.
//
// Required Permissions: To use this action, an IAM user must have self-management
// enabled or an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeMyUserProfile(input *DescribeMyUserProfileInput) (*DescribeMyUserProfileOutput, error) {
	req, out := c.DescribeMyUserProfileRequest(input)
	err := req.Send()
	return out, err
}

const opDescribePermissions = "DescribePermissions"

// DescribePermissionsRequest generates a request for the DescribePermissions operation.
func (c *OpsWorks) DescribePermissionsRequest(input *DescribePermissionsInput) (req *request.Request, output *DescribePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePermissionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribePermissionsOutput{}
	req.Data = output
	return
}

// Describes the permissions for a specified stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribePermissions(input *DescribePermissionsInput) (*DescribePermissionsOutput, error) {
	req, out := c.DescribePermissionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRaidArrays = "DescribeRaidArrays"

// DescribeRaidArraysRequest generates a request for the DescribeRaidArrays operation.
func (c *OpsWorks) DescribeRaidArraysRequest(input *DescribeRaidArraysInput) (req *request.Request, output *DescribeRaidArraysOutput) {
	op := &request.Operation{
		Name:       opDescribeRaidArrays,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRaidArraysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRaidArraysOutput{}
	req.Data = output
	return
}

// Describe an instance's RAID arrays.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeRaidArrays(input *DescribeRaidArraysInput) (*DescribeRaidArraysOutput, error) {
	req, out := c.DescribeRaidArraysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeRdsDbInstances = "DescribeRdsDbInstances"

// DescribeRdsDbInstancesRequest generates a request for the DescribeRdsDbInstances operation.
func (c *OpsWorks) DescribeRdsDbInstancesRequest(input *DescribeRdsDbInstancesInput) (req *request.Request, output *DescribeRdsDbInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeRdsDbInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRdsDbInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeRdsDbInstancesOutput{}
	req.Data = output
	return
}

// Describes Amazon RDS instances.
//
// Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeRdsDbInstances(input *DescribeRdsDbInstancesInput) (*DescribeRdsDbInstancesOutput, error) {
	req, out := c.DescribeRdsDbInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeServiceErrors = "DescribeServiceErrors"

// DescribeServiceErrorsRequest generates a request for the DescribeServiceErrors operation.
func (c *OpsWorks) DescribeServiceErrorsRequest(input *DescribeServiceErrorsInput) (req *request.Request, output *DescribeServiceErrorsOutput) {
	op := &request.Operation{
		Name:       opDescribeServiceErrors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServiceErrorsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeServiceErrorsOutput{}
	req.Data = output
	return
}

// Describes AWS OpsWorks service errors.
//
// Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeServiceErrors(input *DescribeServiceErrorsInput) (*DescribeServiceErrorsOutput, error) {
	req, out := c.DescribeServiceErrorsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStackProvisioningParameters = "DescribeStackProvisioningParameters"

// DescribeStackProvisioningParametersRequest generates a request for the DescribeStackProvisioningParameters operation.
func (c *OpsWorks) DescribeStackProvisioningParametersRequest(input *DescribeStackProvisioningParametersInput) (req *request.Request, output *DescribeStackProvisioningParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeStackProvisioningParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackProvisioningParametersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStackProvisioningParametersOutput{}
	req.Data = output
	return
}

// Requests a description of a stack's provisioning parameters.
//
// Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack or an attached policy that
// explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeStackProvisioningParameters(input *DescribeStackProvisioningParametersInput) (*DescribeStackProvisioningParametersOutput, error) {
	req, out := c.DescribeStackProvisioningParametersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStackSummary = "DescribeStackSummary"

// DescribeStackSummaryRequest generates a request for the DescribeStackSummary operation.
func (c *OpsWorks) DescribeStackSummaryRequest(input *DescribeStackSummaryInput) (req *request.Request, output *DescribeStackSummaryOutput) {
	op := &request.Operation{
		Name:       opDescribeStackSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackSummaryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStackSummaryOutput{}
	req.Data = output
	return
}

// Describes the number of layers and apps in a specified stack, and the number
// of instances in each state, such as running_setup or online.
//
// Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeStackSummary(input *DescribeStackSummaryInput) (*DescribeStackSummaryOutput, error) {
	req, out := c.DescribeStackSummaryRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a request for the DescribeStacks operation.
func (c *OpsWorks) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStacksOutput{}
	req.Data = output
	return
}

// Requests a description of one or more stacks.
//
// Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTimeBasedAutoScaling = "DescribeTimeBasedAutoScaling"

// DescribeTimeBasedAutoScalingRequest generates a request for the DescribeTimeBasedAutoScaling operation.
func (c *OpsWorks) DescribeTimeBasedAutoScalingRequest(input *DescribeTimeBasedAutoScalingInput) (req *request.Request, output *DescribeTimeBasedAutoScalingOutput) {
	op := &request.Operation{
		Name:       opDescribeTimeBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTimeBasedAutoScalingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTimeBasedAutoScalingOutput{}
	req.Data = output
	return
}

// Describes time-based auto scaling configurations for specified instances.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeTimeBasedAutoScaling(input *DescribeTimeBasedAutoScalingInput) (*DescribeTimeBasedAutoScalingOutput, error) {
	req, out := c.DescribeTimeBasedAutoScalingRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeUserProfiles = "DescribeUserProfiles"

// DescribeUserProfilesRequest generates a request for the DescribeUserProfiles operation.
func (c *OpsWorks) DescribeUserProfilesRequest(input *DescribeUserProfilesInput) (req *request.Request, output *DescribeUserProfilesOutput) {
	op := &request.Operation{
		Name:       opDescribeUserProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserProfilesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeUserProfilesOutput{}
	req.Data = output
	return
}

// Describe specified users.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeUserProfiles(input *DescribeUserProfilesInput) (*DescribeUserProfilesOutput, error) {
	req, out := c.DescribeUserProfilesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVolumes = "DescribeVolumes"

// DescribeVolumesRequest generates a request for the DescribeVolumes operation.
func (c *OpsWorks) DescribeVolumesRequest(input *DescribeVolumesInput) (req *request.Request, output *DescribeVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVolumesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVolumesOutput{}
	req.Data = output
	return
}

// Describes an instance's Amazon EBS volumes.
//
//  You must specify at least one of the parameters.
//
//  Required Permissions: To use this action, an IAM user must have a Show,
// Deploy, or Manage permissions level for the stack, or an attached policy
// that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DescribeVolumes(input *DescribeVolumesInput) (*DescribeVolumesOutput, error) {
	req, out := c.DescribeVolumesRequest(input)
	err := req.Send()
	return out, err
}

const opDetachElasticLoadBalancer = "DetachElasticLoadBalancer"

// DetachElasticLoadBalancerRequest generates a request for the DetachElasticLoadBalancer operation.
func (c *OpsWorks) DetachElasticLoadBalancerRequest(input *DetachElasticLoadBalancerInput) (req *request.Request, output *DetachElasticLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDetachElasticLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachElasticLoadBalancerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachElasticLoadBalancerOutput{}
	req.Data = output
	return
}

// Detaches a specified Elastic Load Balancing instance from its layer.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DetachElasticLoadBalancer(input *DetachElasticLoadBalancerInput) (*DetachElasticLoadBalancerOutput, error) {
	req, out := c.DetachElasticLoadBalancerRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateElasticIp = "DisassociateElasticIp"

// DisassociateElasticIpRequest generates a request for the DisassociateElasticIp operation.
func (c *OpsWorks) DisassociateElasticIpRequest(input *DisassociateElasticIpInput) (req *request.Request, output *DisassociateElasticIpOutput) {
	op := &request.Operation{
		Name:       opDisassociateElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateElasticIpInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisassociateElasticIpOutput{}
	req.Data = output
	return
}

// Disassociates an Elastic IP address from its instance. The address remains
// registered with the stack. For more information, see Resource Management
// (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) DisassociateElasticIp(input *DisassociateElasticIpInput) (*DisassociateElasticIpOutput, error) {
	req, out := c.DisassociateElasticIpRequest(input)
	err := req.Send()
	return out, err
}

const opGetHostnameSuggestion = "GetHostnameSuggestion"

// GetHostnameSuggestionRequest generates a request for the GetHostnameSuggestion operation.
func (c *OpsWorks) GetHostnameSuggestionRequest(input *GetHostnameSuggestionInput) (req *request.Request, output *GetHostnameSuggestionOutput) {
	op := &request.Operation{
		Name:       opGetHostnameSuggestion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetHostnameSuggestionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHostnameSuggestionOutput{}
	req.Data = output
	return
}

// Gets a generated host name for the specified layer, based on the current
// host name theme.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) GetHostnameSuggestion(input *GetHostnameSuggestionInput) (*GetHostnameSuggestionOutput, error) {
	req, out := c.GetHostnameSuggestionRequest(input)
	err := req.Send()
	return out, err
}

const opGrantAccess = "GrantAccess"

// GrantAccessRequest generates a request for the GrantAccess operation.
func (c *OpsWorks) GrantAccessRequest(input *GrantAccessInput) (req *request.Request, output *GrantAccessOutput) {
	op := &request.Operation{
		Name:       opGrantAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GrantAccessInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GrantAccessOutput{}
	req.Data = output
	return
}

// This action can be used only with Windows stacks. Grants RDP access to a
// Windows instance for a specified time period.
func (c *OpsWorks) GrantAccess(input *GrantAccessInput) (*GrantAccessOutput, error) {
	req, out := c.GrantAccessRequest(input)
	err := req.Send()
	return out, err
}

const opRebootInstance = "RebootInstance"

// RebootInstanceRequest generates a request for the RebootInstance operation.
func (c *OpsWorks) RebootInstanceRequest(input *RebootInstanceInput) (req *request.Request, output *RebootInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RebootInstanceOutput{}
	req.Data = output
	return
}

// Reboots a specified instance. For more information, see Starting, Stopping,
// and Rebooting Instances (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) RebootInstance(input *RebootInstanceInput) (*RebootInstanceOutput, error) {
	req, out := c.RebootInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterEcsCluster = "RegisterEcsCluster"

// RegisterEcsClusterRequest generates a request for the RegisterEcsCluster operation.
func (c *OpsWorks) RegisterEcsClusterRequest(input *RegisterEcsClusterInput) (req *request.Request, output *RegisterEcsClusterOutput) {
	op := &request.Operation{
		Name:       opRegisterEcsCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterEcsClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterEcsClusterOutput{}
	req.Data = output
	return
}

// Registers a specified Amazon ECS cluster with a stack. You can register only
// one cluster with a stack. A cluster can be registered with only one stack.
// For more information, see  Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see  Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) RegisterEcsCluster(input *RegisterEcsClusterInput) (*RegisterEcsClusterOutput, error) {
	req, out := c.RegisterEcsClusterRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterElasticIp = "RegisterElasticIp"

// RegisterElasticIpRequest generates a request for the RegisterElasticIp operation.
func (c *OpsWorks) RegisterElasticIpRequest(input *RegisterElasticIpInput) (req *request.Request, output *RegisterElasticIpOutput) {
	op := &request.Operation{
		Name:       opRegisterElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterElasticIpInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterElasticIpOutput{}
	req.Data = output
	return
}

// Registers an Elastic IP address with a specified stack. An address can be
// registered with only one stack at a time. If the address is already registered,
// you must first deregister it by calling DeregisterElasticIp. For more information,
// see Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) RegisterElasticIp(input *RegisterElasticIpInput) (*RegisterElasticIpOutput, error) {
	req, out := c.RegisterElasticIpRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterInstance = "RegisterInstance"

// RegisterInstanceRequest generates a request for the RegisterInstance operation.
func (c *OpsWorks) RegisterInstanceRequest(input *RegisterInstanceInput) (req *request.Request, output *RegisterInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterInstanceOutput{}
	req.Data = output
	return
}

// Registers instances with a specified stack that were created outside of AWS
// OpsWorks.
//
// We do not recommend using this action to register instances. The complete
// registration operation has two primary steps, installing the AWS OpsWorks
// agent on the instance and registering the instance with the stack. RegisterInstance
// handles only the second step. You should instead use the AWS CLI register
// command, which performs the entire registration operation. For more information,
// see  Registering an Instance with an AWS OpsWorks Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register.html).
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) RegisterInstance(input *RegisterInstanceInput) (*RegisterInstanceOutput, error) {
	req, out := c.RegisterInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterRdsDbInstance = "RegisterRdsDbInstance"

// RegisterRdsDbInstanceRequest generates a request for the RegisterRdsDbInstance operation.
func (c *OpsWorks) RegisterRdsDbInstanceRequest(input *RegisterRdsDbInstanceInput) (req *request.Request, output *RegisterRdsDbInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterRdsDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterRdsDbInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterRdsDbInstanceOutput{}
	req.Data = output
	return
}

// Registers an Amazon RDS instance with a stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) RegisterRdsDbInstance(input *RegisterRdsDbInstanceInput) (*RegisterRdsDbInstanceOutput, error) {
	req, out := c.RegisterRdsDbInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opRegisterVolume = "RegisterVolume"

// RegisterVolumeRequest generates a request for the RegisterVolume operation.
func (c *OpsWorks) RegisterVolumeRequest(input *RegisterVolumeInput) (req *request.Request, output *RegisterVolumeOutput) {
	op := &request.Operation{
		Name:       opRegisterVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RegisterVolumeOutput{}
	req.Data = output
	return
}

// Registers an Amazon EBS volume with a specified stack. A volume can be registered
// with only one stack at a time. If the volume is already registered, you must
// first deregister it by calling DeregisterVolume. For more information, see
// Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) RegisterVolume(input *RegisterVolumeInput) (*RegisterVolumeOutput, error) {
	req, out := c.RegisterVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opSetLoadBasedAutoScaling = "SetLoadBasedAutoScaling"

// SetLoadBasedAutoScalingRequest generates a request for the SetLoadBasedAutoScaling operation.
func (c *OpsWorks) SetLoadBasedAutoScalingRequest(input *SetLoadBasedAutoScalingInput) (req *request.Request, output *SetLoadBasedAutoScalingOutput) {
	op := &request.Operation{
		Name:       opSetLoadBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLoadBasedAutoScalingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetLoadBasedAutoScalingOutput{}
	req.Data = output
	return
}

// Specify the load-based auto scaling configuration for a specified layer.
// For more information, see Managing Load with Time-based and Load-based Instances
// (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
//
//  To use load-based auto scaling, you must create a set of load-based auto
// scaling instances. Load-based auto scaling operates only on the instances
// from that set, so you must ensure that you have created enough instances
// to handle the maximum anticipated load.
//
//  Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) SetLoadBasedAutoScaling(input *SetLoadBasedAutoScalingInput) (*SetLoadBasedAutoScalingOutput, error) {
	req, out := c.SetLoadBasedAutoScalingRequest(input)
	err := req.Send()
	return out, err
}

const opSetPermission = "SetPermission"

// SetPermissionRequest generates a request for the SetPermission operation.
func (c *OpsWorks) SetPermissionRequest(input *SetPermissionInput) (req *request.Request, output *SetPermissionOutput) {
	op := &request.Operation{
		Name:       opSetPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetPermissionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetPermissionOutput{}
	req.Data = output
	return
}

// Specifies a user's permissions. For more information, see Security and Permissions
// (http://docs.aws.amazon.com/opsworks/latest/userguide/workingsecurity.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) SetPermission(input *SetPermissionInput) (*SetPermissionOutput, error) {
	req, out := c.SetPermissionRequest(input)
	err := req.Send()
	return out, err
}

const opSetTimeBasedAutoScaling = "SetTimeBasedAutoScaling"

// SetTimeBasedAutoScalingRequest generates a request for the SetTimeBasedAutoScaling operation.
func (c *OpsWorks) SetTimeBasedAutoScalingRequest(input *SetTimeBasedAutoScalingInput) (req *request.Request, output *SetTimeBasedAutoScalingOutput) {
	op := &request.Operation{
		Name:       opSetTimeBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTimeBasedAutoScalingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetTimeBasedAutoScalingOutput{}
	req.Data = output
	return
}

// Specify the time-based auto scaling configuration for a specified instance.
// For more information, see Managing Load with Time-based and Load-based Instances
// (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) SetTimeBasedAutoScaling(input *SetTimeBasedAutoScalingInput) (*SetTimeBasedAutoScalingOutput, error) {
	req, out := c.SetTimeBasedAutoScalingRequest(input)
	err := req.Send()
	return out, err
}

const opStartInstance = "StartInstance"

// StartInstanceRequest generates a request for the StartInstance operation.
func (c *OpsWorks) StartInstanceRequest(input *StartInstanceInput) (req *request.Request, output *StartInstanceOutput) {
	op := &request.Operation{
		Name:       opStartInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartInstanceOutput{}
	req.Data = output
	return
}

// Starts a specified instance. For more information, see Starting, Stopping,
// and Rebooting Instances (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) StartInstance(input *StartInstanceInput) (*StartInstanceOutput, error) {
	req, out := c.StartInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opStartStack = "StartStack"

// StartStackRequest generates a request for the StartStack operation.
func (c *OpsWorks) StartStackRequest(input *StartStackInput) (req *request.Request, output *StartStackOutput) {
	op := &request.Operation{
		Name:       opStartStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartStackOutput{}
	req.Data = output
	return
}

// Starts a stack's instances.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) StartStack(input *StartStackInput) (*StartStackOutput, error) {
	req, out := c.StartStackRequest(input)
	err := req.Send()
	return out, err
}

const opStopInstance = "StopInstance"

// StopInstanceRequest generates a request for the StopInstance operation.
func (c *OpsWorks) StopInstanceRequest(input *StopInstanceInput) (req *request.Request, output *StopInstanceOutput) {
	op := &request.Operation{
		Name:       opStopInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopInstanceOutput{}
	req.Data = output
	return
}

// Stops a specified instance. When you stop a standard instance, the data disappears
// and must be reinstalled when you restart the instance. You can stop an Amazon
// EBS-backed instance without losing data. For more information, see Starting,
// Stopping, and Rebooting Instances (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) StopInstance(input *StopInstanceInput) (*StopInstanceOutput, error) {
	req, out := c.StopInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opStopStack = "StopStack"

// StopStackRequest generates a request for the StopStack operation.
func (c *OpsWorks) StopStackRequest(input *StopStackInput) (req *request.Request, output *StopStackOutput) {
	op := &request.Operation{
		Name:       opStopStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StopStackOutput{}
	req.Data = output
	return
}

// Stops a specified stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) StopStack(input *StopStackInput) (*StopStackOutput, error) {
	req, out := c.StopStackRequest(input)
	err := req.Send()
	return out, err
}

const opUnassignInstance = "UnassignInstance"

// UnassignInstanceRequest generates a request for the UnassignInstance operation.
func (c *OpsWorks) UnassignInstanceRequest(input *UnassignInstanceInput) (req *request.Request, output *UnassignInstanceOutput) {
	op := &request.Operation{
		Name:       opUnassignInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnassignInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UnassignInstanceOutput{}
	req.Data = output
	return
}

// Unassigns a registered instance from all of it's layers. The instance remains
// in the stack as an unassigned instance and can be assigned to another layer,
// as needed. You cannot use this action with instances that were created with
// AWS OpsWorks.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UnassignInstance(input *UnassignInstanceInput) (*UnassignInstanceOutput, error) {
	req, out := c.UnassignInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opUnassignVolume = "UnassignVolume"

// UnassignVolumeRequest generates a request for the UnassignVolume operation.
func (c *OpsWorks) UnassignVolumeRequest(input *UnassignVolumeInput) (req *request.Request, output *UnassignVolumeOutput) {
	op := &request.Operation{
		Name:       opUnassignVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnassignVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UnassignVolumeOutput{}
	req.Data = output
	return
}

// Unassigns an assigned Amazon EBS volume. The volume remains registered with
// the stack. For more information, see Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UnassignVolume(input *UnassignVolumeInput) (*UnassignVolumeOutput, error) {
	req, out := c.UnassignVolumeRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateApp = "UpdateApp"

// UpdateAppRequest generates a request for the UpdateApp operation.
func (c *OpsWorks) UpdateAppRequest(input *UpdateAppInput) (req *request.Request, output *UpdateAppOutput) {
	op := &request.Operation{
		Name:       opUpdateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAppInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateAppOutput{}
	req.Data = output
	return
}

// Updates a specified app.
//
// Required Permissions: To use this action, an IAM user must have a Deploy
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information on user permissions, see Managing
// User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UpdateApp(input *UpdateAppInput) (*UpdateAppOutput, error) {
	req, out := c.UpdateAppRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateElasticIp = "UpdateElasticIp"

// UpdateElasticIpRequest generates a request for the UpdateElasticIp operation.
func (c *OpsWorks) UpdateElasticIpRequest(input *UpdateElasticIpInput) (req *request.Request, output *UpdateElasticIpOutput) {
	op := &request.Operation{
		Name:       opUpdateElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateElasticIpInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateElasticIpOutput{}
	req.Data = output
	return
}

// Updates a registered Elastic IP address's name. For more information, see
// Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UpdateElasticIp(input *UpdateElasticIpInput) (*UpdateElasticIpOutput, error) {
	req, out := c.UpdateElasticIpRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateInstance = "UpdateInstance"

// UpdateInstanceRequest generates a request for the UpdateInstance operation.
func (c *OpsWorks) UpdateInstanceRequest(input *UpdateInstanceInput) (req *request.Request, output *UpdateInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateInstanceOutput{}
	req.Data = output
	return
}

// Updates a specified instance.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UpdateInstance(input *UpdateInstanceInput) (*UpdateInstanceOutput, error) {
	req, out := c.UpdateInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateLayer = "UpdateLayer"

// UpdateLayerRequest generates a request for the UpdateLayer operation.
func (c *OpsWorks) UpdateLayerRequest(input *UpdateLayerInput) (req *request.Request, output *UpdateLayerOutput) {
	op := &request.Operation{
		Name:       opUpdateLayer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLayerInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateLayerOutput{}
	req.Data = output
	return
}

// Updates a specified layer.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UpdateLayer(input *UpdateLayerInput) (*UpdateLayerOutput, error) {
	req, out := c.UpdateLayerRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateMyUserProfile = "UpdateMyUserProfile"

// UpdateMyUserProfileRequest generates a request for the UpdateMyUserProfile operation.
func (c *OpsWorks) UpdateMyUserProfileRequest(input *UpdateMyUserProfileInput) (req *request.Request, output *UpdateMyUserProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateMyUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMyUserProfileInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateMyUserProfileOutput{}
	req.Data = output
	return
}

// Updates a user's SSH public key.
//
// Required Permissions: To use this action, an IAM user must have self-management
// enabled or an attached policy that explicitly grants permissions. For more
// information on user permissions, see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UpdateMyUserProfile(input *UpdateMyUserProfileInput) (*UpdateMyUserProfileOutput, error) {
	req, out := c.UpdateMyUserProfileRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateRdsDbInstance = "UpdateRdsDbInstance"

// UpdateRdsDbInstanceRequest generates a request for the UpdateRdsDbInstance operation.
func (c *OpsWorks) UpdateRdsDbInstanceRequest(input *UpdateRdsDbInstanceInput) (req *request.Request, output *UpdateRdsDbInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateRdsDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRdsDbInstanceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateRdsDbInstanceOutput{}
	req.Data = output
	return
}

// Updates an Amazon RDS instance.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UpdateRdsDbInstance(input *UpdateRdsDbInstanceInput) (*UpdateRdsDbInstanceOutput, error) {
	req, out := c.UpdateRdsDbInstanceRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a request for the UpdateStack operation.
func (c *OpsWorks) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateStackOutput{}
	req.Data = output
	return
}

// Updates a specified stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateUserProfile = "UpdateUserProfile"

// UpdateUserProfileRequest generates a request for the UpdateUserProfile operation.
func (c *OpsWorks) UpdateUserProfileRequest(input *UpdateUserProfileInput) (req *request.Request, output *UpdateUserProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserProfileInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateUserProfileOutput{}
	req.Data = output
	return
}

// Updates a specified user profile.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UpdateUserProfile(input *UpdateUserProfileInput) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateVolume = "UpdateVolume"

// UpdateVolumeRequest generates a request for the UpdateVolume operation.
func (c *OpsWorks) UpdateVolumeRequest(input *UpdateVolumeInput) (req *request.Request, output *UpdateVolumeOutput) {
	op := &request.Operation{
		Name:       opUpdateVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVolumeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateVolumeOutput{}
	req.Data = output
	return
}

// Updates an Amazon EBS volume's name or mount point. For more information,
// see Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
func (c *OpsWorks) UpdateVolume(input *UpdateVolumeInput) (*UpdateVolumeOutput, error) {
	req, out := c.UpdateVolumeRequest(input)
	err := req.Send()
	return out, err
}

// Describes an agent version.
type AgentVersion struct {
	// The configuration manager.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// The agent version.
	Version *string `type:"string"`

	metadataAgentVersion `json:"-" xml:"-"`
}

type metadataAgentVersion struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AgentVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentVersion) GoString() string {
	return s.String()
}

// A description of the app.
type App struct {
	// The app ID.
	AppId *string `type:"string"`

	// A Source object that describes the app repository.
	AppSource *Source `type:"structure"`

	// The stack attributes.
	Attributes map[string]*string `type:"map"`

	// When the app was created.
	CreatedAt *string `type:"string"`

	// The app's data sources.
	DataSources []*DataSource `type:"list"`

	// A description of the app.
	Description *string `type:"string"`

	// The app vhost settings with multiple domains separated by commas. For example:
	// 'www.example.com, example.com'
	Domains []*string `type:"list"`

	// Whether to enable SSL for the app.
	EnableSsl *bool `type:"boolean"`

	// An array of EnvironmentVariable objects that specify environment variables
	// to be associated with the app. After you deploy the app, these variables
	// are defined on the associated app server instances. For more information,
	// see  Environment Variables (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
	//
	//  There is no specific limit on the number of environment variables. However,
	// the size of the associated data structure - which includes the variables'
	// names, values, and protected flag values - cannot exceed 10 KB (10240 Bytes).
	// This limit should accommodate most if not all use cases, but if you do exceed
	// it, you will cause an exception (API) with an "Environment: is too large
	// (maximum is 10KB)" message.
	Environment []*EnvironmentVariable `type:"list"`

	// The app name.
	Name *string `type:"string"`

	// The app's short name.
	Shortname *string `type:"string"`

	// An SslConfiguration object with the SSL configuration.
	SslConfiguration *SslConfiguration `type:"structure"`

	// The app stack ID.
	StackId *string `type:"string"`

	// The app type.
	Type *string `type:"string" enum:"AppType"`

	metadataApp `json:"-" xml:"-"`
}

type metadataApp struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s App) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s App) GoString() string {
	return s.String()
}

type AssignInstanceInput struct {
	// The instance ID.
	InstanceId *string `type:"string" required:"true"`

	// The layer ID, which must correspond to a custom layer. You cannot assign
	// a registered instance to a built-in layer.
	LayerIds []*string `type:"list" required:"true"`

	metadataAssignInstanceInput `json:"-" xml:"-"`
}

type metadataAssignInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssignInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignInstanceInput) GoString() string {
	return s.String()
}

type AssignInstanceOutput struct {
	metadataAssignInstanceOutput `json:"-" xml:"-"`
}

type metadataAssignInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssignInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignInstanceOutput) GoString() string {
	return s.String()
}

type AssignVolumeInput struct {
	// The instance ID.
	InstanceId *string `type:"string"`

	// The volume ID.
	VolumeId *string `type:"string" required:"true"`

	metadataAssignVolumeInput `json:"-" xml:"-"`
}

type metadataAssignVolumeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssignVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignVolumeInput) GoString() string {
	return s.String()
}

type AssignVolumeOutput struct {
	metadataAssignVolumeOutput `json:"-" xml:"-"`
}

type metadataAssignVolumeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssignVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignVolumeOutput) GoString() string {
	return s.String()
}

type AssociateElasticIpInput struct {
	// The Elastic IP address.
	ElasticIp *string `type:"string" required:"true"`

	// The instance ID.
	InstanceId *string `type:"string"`

	metadataAssociateElasticIpInput `json:"-" xml:"-"`
}

type metadataAssociateElasticIpInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssociateElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateElasticIpInput) GoString() string {
	return s.String()
}

type AssociateElasticIpOutput struct {
	metadataAssociateElasticIpOutput `json:"-" xml:"-"`
}

type metadataAssociateElasticIpOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssociateElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateElasticIpOutput) GoString() string {
	return s.String()
}

type AttachElasticLoadBalancerInput struct {
	// The Elastic Load Balancing instance's name.
	ElasticLoadBalancerName *string `type:"string" required:"true"`

	// The ID of the layer that the Elastic Load Balancing instance is to be attached
	// to.
	LayerId *string `type:"string" required:"true"`

	metadataAttachElasticLoadBalancerInput `json:"-" xml:"-"`
}

type metadataAttachElasticLoadBalancerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AttachElasticLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachElasticLoadBalancerInput) GoString() string {
	return s.String()
}

type AttachElasticLoadBalancerOutput struct {
	metadataAttachElasticLoadBalancerOutput `json:"-" xml:"-"`
}

type metadataAttachElasticLoadBalancerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AttachElasticLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachElasticLoadBalancerOutput) GoString() string {
	return s.String()
}

// Describes a load-based auto scaling upscaling or downscaling threshold configuration,
// which specifies when AWS OpsWorks starts or stops load-based instances.
type AutoScalingThresholds struct {
	// Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter
	// takes a list of up to five alarm names, which are case sensitive and must
	// be in the same region as the stack.
	//
	// To use custom alarms, you must update your service role to allow cloudwatch:DescribeAlarms.
	// You can either have AWS OpsWorks update the role for you when you first use
	// this feature or you can edit the role manually. For more information, see
	// Allowing AWS OpsWorks to Act on Your Behalf (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html).
	Alarms []*string `type:"list"`

	// The CPU utilization threshold, as a percent of the available CPU.
	CpuThreshold *float64 `type:"double"`

	// The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks
	// should ignore metrics and suppress additional scaling events. For example,
	// AWS OpsWorks adds new instances following an upscaling event but the instances
	// won't start reducing the load until they have been booted and configured.
	// There is no point in raising additional scaling events during that operation,
	// which typically takes several minutes. IgnoreMetricsTime allows you to direct
	// AWS OpsWorks to suppress scaling events long enough to get the new instances
	// online.
	IgnoreMetricsTime *int64 `min:"1" type:"integer"`

	// The number of instances to add or remove when the load exceeds a threshold.
	InstanceCount *int64 `type:"integer"`

	// The load threshold. For more information about how load is computed, see
	// Load (computing) (http://en.wikipedia.org/wiki/Load_%28computing%29).
	LoadThreshold *float64 `type:"double"`

	// The memory utilization threshold, as a percent of the available memory.
	MemoryThreshold *float64 `type:"double"`

	// The amount of time, in minutes, that the load must exceed a threshold before
	// more instances are added or removed.
	ThresholdsWaitTime *int64 `min:"1" type:"integer"`

	metadataAutoScalingThresholds `json:"-" xml:"-"`
}

type metadataAutoScalingThresholds struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AutoScalingThresholds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingThresholds) GoString() string {
	return s.String()
}

// Describes a block device mapping. This data type maps directly to the Amazon
// EC2 BlockDeviceMapping (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html)
// data type.
type BlockDeviceMapping struct {
	// The device name that is exposed to the instance, such as /dev/sdh. For the
	// root device, you can use the explicit device name or you can set this parameter
	// to ROOT_DEVICE and AWS OpsWorks will provide the correct device name.
	DeviceName *string `type:"string"`

	// An EBSBlockDevice that defines how to configure an Amazon EBS volume when
	// the instance is launched.
	Ebs *EbsBlockDevice `type:"structure"`

	// Suppresses the specified device included in the AMI's block device mapping.
	NoDevice *string `type:"string"`

	// The virtual device name. For more information, see BlockDeviceMapping (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html).
	VirtualName *string `type:"string"`

	metadataBlockDeviceMapping `json:"-" xml:"-"`
}

type metadataBlockDeviceMapping struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockDeviceMapping) GoString() string {
	return s.String()
}

// Describes the Chef configuration.
type ChefConfiguration struct {
	// The Berkshelf version.
	BerkshelfVersion *string `type:"string"`

	// Whether to enable Berkshelf.
	ManageBerkshelf *bool `type:"boolean"`

	metadataChefConfiguration `json:"-" xml:"-"`
}

type metadataChefConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ChefConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChefConfiguration) GoString() string {
	return s.String()
}

type CloneStackInput struct {
	// The default AWS OpsWorks agent version. You have the following options:
	//
	//  Auto-update - Set this parameter to LATEST. AWS OpsWorks automatically
	// installs new agent versions on the stack's instances as soon as they are
	// available. Fixed version - Set this parameter to your preferred agent version.
	// To update the agent version, you must edit the stack configuration and specify
	// a new version. AWS OpsWorks then automatically installs that version on the
	// stack's instances.  The default setting is LATEST. To specify an agent version,
	// you must use the complete version number, not the abbreviated number shown
	// on the console. For a list of available agent version numbers, call DescribeAgentVersions.
	//
	// You can also specify an agent version when you create or update an instance,
	// which overrides the stack's default setting.
	AgentVersion *string `type:"string"`

	// A list of stack attributes and values as key/value pairs to be added to the
	// cloned stack.
	Attributes map[string]*string `type:"map"`

	// A ChefConfiguration object that specifies whether to enable Berkshelf and
	// the Berkshelf version on Chef 11.10 stacks. For more information, see Create
	// a New Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	ChefConfiguration *ChefConfiguration `type:"structure"`

	// A list of source stack app IDs to be included in the cloned stack.
	CloneAppIds []*string `type:"list"`

	// Whether to clone the source stack's permissions.
	ClonePermissions *bool `type:"boolean"`

	// The configuration manager. When you clone a Linux stack we recommend that
	// you use the configuration manager to specify the Chef version: 0.9, 11.4,
	// or 11.10. The default value is currently 11.10.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// Contains the information required to retrieve an app or cookbook from a repository.
	// For more information, see Creating Apps (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
	// or Custom Recipes and Cookbooks (http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
	CustomCookbooksSource *Source `type:"structure"`

	// A string that contains user-defined, custom JSON. It is used to override
	// the corresponding default stack configuration JSON values. The string should
	// be in the following format and must escape characters such as '"':
	//
	//  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html)
	CustomJson *string `type:"string"`

	// The cloned stack's default Availability Zone, which must be in the specified
	// region. For more information, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	// If you also specify a value for DefaultSubnetId, the subnet must be in the
	// same zone. For more information, see the VpcId parameter description.
	DefaultAvailabilityZone *string `type:"string"`

	// The Amazon Resource Name (ARN) of an IAM profile that is the default profile
	// for all of the stack's EC2 instances. For more information about IAM ARNs,
	// see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	DefaultInstanceProfileArn *string `type:"string"`

	// The stack's operating system, which must be set to one of the following.
	//
	//  A supported Linux operating system: An Amazon Linux version, such as Amazon
	// Linux 2015.03, Red Hat Enterprise Linux 7, Ubuntu 12.04 LTS, or Ubuntu 14.04
	// LTS.  Microsoft Windows Server 2012 R2 Base. A custom AMI: Custom. You specify
	// the custom AMI you want to use when you create instances. For more information
	// on how to use custom AMIs with OpsWorks, see Using Custom AMIs (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//  The default option is the parent stack's operating system. For more information
	// on the supported operating systems, see AWS OpsWorks Operating Systems (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	//
	// You can specify a different Linux operating system for the cloned stack,
	// but you cannot change from Linux to Windows or Windows to Linux.
	DefaultOs *string `type:"string"`

	// The default root device type. This value is used by default for all instances
	// in the cloned stack, but you can override it when you create an instance.
	// For more information, see Storage for the Root Device (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	DefaultRootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// A default Amazon EC2 key pair name. The default value is none. If you specify
	// a key pair name, AWS OpsWorks installs the public key on the instance and
	// you can use the private key with an SSH client to log in to the instance.
	// For more information, see  Using SSH to Communicate with an Instance (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html)
	// and  Managing SSH Access (http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html).
	// You can override this setting by specifying a different key pair, or no key
	// pair, when you  create an instance (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
	DefaultSshKeyName *string `type:"string"`

	// The stack's default VPC subnet ID. This parameter is required if you specify
	// a value for the VpcId parameter. All instances are launched into this subnet
	// unless you specify otherwise when you create the instance. If you also specify
	// a value for DefaultAvailabilityZone, the subnet must be in that zone. For
	// information on default values and when this parameter is required, see the
	// VpcId parameter description.
	DefaultSubnetId *string `type:"string"`

	// The stack's host name theme, with spaces are replaced by underscores. The
	// theme is used to generate host names for the stack's instances. By default,
	// HostnameTheme is set to Layer_Dependent, which creates host names by appending
	// integers to the layer's short name. The other themes are:
	//
	//   Baked_Goods   Clouds   Europe_Cities   Fruits   Greek_Deities   Legendary_creatures_from_Japan
	//   Planets_and_Moons   Roman_Deities   Scottish_Islands   US_Cities   Wild_Cats
	//   To obtain a generated host name, call GetHostNameSuggestion, which returns
	// a host name based on the current theme.
	HostnameTheme *string `type:"string"`

	// The cloned stack name.
	Name *string `type:"string"`

	// The cloned stack AWS region, such as "us-east-1". For more information about
	// AWS regions, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`

	// The stack AWS Identity and Access Management (IAM) role, which allows AWS
	// OpsWorks to work with AWS resources on your behalf. You must set this parameter
	// to the Amazon Resource Name (ARN) for an existing IAM role. If you create
	// a stack by using the AWS OpsWorks console, it creates the role for you. You
	// can obtain an existing stack's IAM ARN programmatically by calling DescribePermissions.
	// For more information about IAM ARNs, see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	//
	//  You must set this parameter to a valid service role ARN or the action will
	// fail; there is no default value. You can specify the source stack's service
	// role ARN, if you prefer, but you must do so explicitly.
	ServiceRoleArn *string `type:"string" required:"true"`

	// The source stack ID.
	SourceStackId *string `type:"string" required:"true"`

	// Whether to use custom cookbooks.
	UseCustomCookbooks *bool `type:"boolean"`

	// Whether to associate the AWS OpsWorks built-in security groups with the stack's
	// layers.
	//
	// AWS OpsWorks provides a standard set of built-in security groups, one for
	// each layer, which are associated with layers by default. With UseOpsworksSecurityGroups
	// you can instead provide your own custom security groups. UseOpsworksSecurityGroups
	// has the following settings:
	//
	//  True - AWS OpsWorks automatically associates the appropriate built-in security
	// group with each layer (default setting). You can associate additional security
	// groups with a layer after you create it but you cannot delete the built-in
	// security group.  False - AWS OpsWorks does not associate built-in security
	// groups with layers. You must create appropriate Amazon Elastic Compute Cloud
	// (Amazon EC2) security groups and associate a security group with each layer
	// that you create. However, you can still manually associate a built-in security
	// group with a layer on creation; custom security groups are required only
	// for those layers that need custom settings.   For more information, see Create
	// a New Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	UseOpsworksSecurityGroups *bool `type:"boolean"`

	// The ID of the VPC that the cloned stack is to be launched into. It must be
	// in the specified region. All instances are launched into this VPC, and you
	// cannot change the ID later.
	//
	//  If your account supports EC2 Classic, the default value is no VPC. If your
	// account does not support EC2 Classic, the default value is the default VPC
	// for the specified region.  If the VPC ID corresponds to a default VPC and
	// you have specified either the DefaultAvailabilityZone or the DefaultSubnetId
	// parameter only, AWS OpsWorks infers the value of the other parameter. If
	// you specify neither parameter, AWS OpsWorks sets these parameters to the
	// first valid Availability Zone for the specified region and the corresponding
	// default VPC subnet ID, respectively.
	//
	// If you specify a nondefault VPC ID, note the following:
	//
	//  It must belong to a VPC in your account that is in the specified region.
	// You must specify a value for DefaultSubnetId.  For more information on how
	// to use AWS OpsWorks with a VPC, see Running a Stack in a VPC (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html).
	// For more information on default VPC and EC2 Classic, see Supported Platforms
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html).
	VpcId *string `type:"string"`

	metadataCloneStackInput `json:"-" xml:"-"`
}

type metadataCloneStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CloneStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneStackInput) GoString() string {
	return s.String()
}

// Contains the response to a CloneStack request.
type CloneStackOutput struct {
	// The cloned stack ID.
	StackId *string `type:"string"`

	metadataCloneStackOutput `json:"-" xml:"-"`
}

type metadataCloneStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CloneStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneStackOutput) GoString() string {
	return s.String()
}

// Describes a command.
type Command struct {
	// Date and time when the command was acknowledged.
	AcknowledgedAt *string `type:"string"`

	// The command ID.
	CommandId *string `type:"string"`

	// Date when the command completed.
	CompletedAt *string `type:"string"`

	// Date and time when the command was run.
	CreatedAt *string `type:"string"`

	// The command deployment ID.
	DeploymentId *string `type:"string"`

	// The command exit code.
	ExitCode *int64 `type:"integer"`

	// The ID of the instance where the command was executed.
	InstanceId *string `type:"string"`

	// The URL of the command log.
	LogUrl *string `type:"string"`

	// The command status:
	//
	//  failed successful skipped pending
	Status *string `type:"string"`

	// The command type:
	//
	//   deploy   rollback   start   stop   restart   undeploy   update_dependencies
	//   install_dependencies   update_custom_cookbooks   execute_recipes
	Type *string `type:"string"`

	metadataCommand `json:"-" xml:"-"`
}

type metadataCommand struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Command) GoString() string {
	return s.String()
}

type CreateAppInput struct {
	// A Source object that specifies the app repository.
	AppSource *Source `type:"structure"`

	// One or more user-defined key/value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// The app's data source.
	DataSources []*DataSource `type:"list"`

	// A description of the app.
	Description *string `type:"string"`

	// The app virtual host settings, with multiple domains separated by commas.
	// For example: 'www.example.com, example.com'
	Domains []*string `type:"list"`

	// Whether to enable SSL for the app.
	EnableSsl *bool `type:"boolean"`

	// An array of EnvironmentVariable objects that specify environment variables
	// to be associated with the app. After you deploy the app, these variables
	// are defined on the associated app server instance. For more information,
	// see  Environment Variables (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
	//
	//  There is no specific limit on the number of environment variables. However,
	// the size of the associated data structure - which includes the variables'
	// names, values, and protected flag values - cannot exceed 10 KB (10240 Bytes).
	// This limit should accommodate most if not all use cases. Exceeding it will
	// cause an exception with the message, "Environment: is too large (maximum
	// is 10KB)."
	//
	// This parameter is supported only by Chef 11.10 stacks. If you have specified
	// one or more environment variables, you cannot modify the stack's Chef version.
	Environment []*EnvironmentVariable `type:"list"`

	// The app name.
	Name *string `type:"string" required:"true"`

	// The app's short name.
	Shortname *string `type:"string"`

	// An SslConfiguration object with the SSL configuration.
	SslConfiguration *SslConfiguration `type:"structure"`

	// The stack ID.
	StackId *string `type:"string" required:"true"`

	// The app type. Each supported type is associated with a particular layer.
	// For example, PHP applications are associated with a PHP layer. AWS OpsWorks
	// deploys an application to those instances that are members of the corresponding
	// layer. If your app isn't one of the standard types, or you prefer to implement
	// your own Deploy recipes, specify other.
	Type *string `type:"string" required:"true" enum:"AppType"`

	metadataCreateAppInput `json:"-" xml:"-"`
}

type metadataCreateAppInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppInput) GoString() string {
	return s.String()
}

// Contains the response to a CreateApp request.
type CreateAppOutput struct {
	// The app ID.
	AppId *string `type:"string"`

	metadataCreateAppOutput `json:"-" xml:"-"`
}

type metadataCreateAppOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppOutput) GoString() string {
	return s.String()
}

type CreateDeploymentInput struct {
	// The app ID. This parameter is required for app deployments, but not for other
	// deployment commands.
	AppId *string `type:"string"`

	// A DeploymentCommand object that specifies the deployment command and any
	// associated arguments.
	Command *DeploymentCommand `type:"structure" required:"true"`

	// A user-defined comment.
	Comment *string `type:"string"`

	// A string that contains user-defined, custom JSON. It is used to override
	// the corresponding default stack configuration JSON values. The string should
	// be in the following format and must escape characters such as '"':
	//
	//  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The instance IDs for the deployment targets.
	InstanceIds []*string `type:"list"`

	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataCreateDeploymentInput `json:"-" xml:"-"`
}

type metadataCreateDeploymentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Contains the response to a CreateDeployment request.
type CreateDeploymentOutput struct {
	// The deployment ID, which can be used with other requests to identify the
	// deployment.
	DeploymentId *string `type:"string"`

	metadataCreateDeploymentOutput `json:"-" xml:"-"`
}

type metadataCreateDeploymentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

type CreateInstanceInput struct {
	// The default AWS OpsWorks agent version. You have the following options:
	//
	//   INHERIT - Use the stack's default agent version setting.  version_number
	// - Use the specified agent version. This value overrides the stack's default
	// setting. To update the agent version, edit the instance configuration and
	// specify a new version. AWS OpsWorks then automatically installs that version
	// on the instance.  The default setting is INHERIT. To specify an agent version,
	// you must use the complete version number, not the abbreviated number shown
	// on the console. For a list of available agent version numbers, call DescribeAgentVersions.
	AgentVersion *string `type:"string"`

	// A custom AMI ID to be used to create the instance. The AMI should be based
	// on one of the supported operating systems. For more information, see Using
	// Custom AMIs (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//
	// If you specify a custom AMI, you must set Os to Custom.
	AmiId *string `type:"string"`

	// The instance architecture. The default option is x86_64. Instance types do
	// not necessarily support both architectures. For a list of the architectures
	// that are supported by the different instance types, see Instance Families
	// and Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
	Architecture *string `type:"string" enum:"Architecture"`

	// For load-based or time-based instances, the type. Windows stacks can use
	// only time-based instances.
	AutoScalingType *string `type:"string" enum:"AutoScalingType"`

	// The instance Availability Zone. For more information, see Regions and Endpoints
	// (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// An array of BlockDeviceMapping objects that specify the instance's block
	// devices. For more information, see Block Device Mapping (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html).
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// Whether to create an Amazon EBS-optimized instance.
	EbsOptimized *bool `type:"boolean"`

	// The instance host name.
	Hostname *string `type:"string"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. To control when updates are installed,
	// set this value to false. You must then update your instances manually by
	// using CreateDeployment to run the update_dependencies stack command or by
	// manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.
	//
	//  We strongly recommend using the default value of true to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The instance type, such as t2.micro. For a list of supported instance types,
	// open the stack in the console, choose Instances, and choose + Instance. The
	// Size list contains the currently supported types. For more information, see
	// Instance Families and Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
	// The parameter values that you use to specify the various types are in the
	// API Name column of the Available Instance Types table.
	InstanceType *string `type:"string" required:"true"`

	// An array that contains the instance's layer IDs.
	LayerIds []*string `type:"list" required:"true"`

	// The instance's operating system, which must be set to one of the following.
	//
	//  A supported Linux operating system: An Amazon Linux version, such as Amazon
	// Linux 2015.03, Red Hat Enterprise Linux 7, Ubuntu 12.04 LTS, or Ubuntu 14.04
	// LTS.  Microsoft Windows Server 2012 R2 Base. A custom AMI: Custom.  For more
	// information on the supported operating systems, see AWS OpsWorks Operating
	// Systems (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	//
	// The default option is the current Amazon Linux version. If you set this
	// parameter to Custom, you must use the CreateInstance action's AmiId parameter
	// to specify the custom AMI that you want to use. For more information on the
	// supported operating systems, see Operating Systems (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html)For
	// more information on how to use custom AMIs with AWS OpsWorks, see Using Custom
	// AMIs (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	Os *string `type:"string"`

	// The instance root device type. For more information, see Storage for the
	// Root Device (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	RootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// The instance's Amazon EC2 key-pair name.
	SshKeyName *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string" required:"true"`

	// The ID of the instance's subnet. If the stack is running in a VPC, you can
	// use this parameter to override the stack's default subnet ID value and direct
	// AWS OpsWorks to launch the instance in a different subnet.
	SubnetId *string `type:"string"`

	// The instance's virtualization type, paravirtual or hvm.
	VirtualizationType *string `type:"string"`

	metadataCreateInstanceInput `json:"-" xml:"-"`
}

type metadataCreateInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceInput) GoString() string {
	return s.String()
}

// Contains the response to a CreateInstance request.
type CreateInstanceOutput struct {
	// The instance ID.
	InstanceId *string `type:"string"`

	metadataCreateInstanceOutput `json:"-" xml:"-"`
}

type metadataCreateInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceOutput) GoString() string {
	return s.String()
}

type CreateLayerInput struct {
	// One or more user-defined key-value pairs to be added to the stack attributes.
	//
	// To create a cluster layer, set the EcsClusterArn attribute to the cluster's
	// ARN.
	Attributes map[string]*string `type:"map"`

	// Whether to automatically assign an Elastic IP address (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
	// to the layer's instances. For more information, see How to Edit a Layer (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignElasticIps *bool `type:"boolean"`

	// For stacks that are running in a VPC, whether to automatically assign a public
	// IP address to the layer's instances. For more information, see How to Edit
	// a Layer (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignPublicIps *bool `type:"boolean"`

	// The ARN of an IAM profile to be used for the layer's EC2 instances. For more
	// information about IAM ARNs, see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	CustomInstanceProfileArn *string `type:"string"`

	// A JSON-formatted string containing custom stack configuration and deployment
	// attributes to be installed on the layer's instances. For more information,
	// see  Using Custom JSON (http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
	CustomJson *string `type:"string"`

	// A LayerCustomRecipes object that specifies the layer custom recipes.
	CustomRecipes *Recipes `type:"structure"`

	// An array containing the layer custom security group IDs.
	CustomSecurityGroupIds []*string `type:"list"`

	// Whether to disable auto healing for the layer.
	EnableAutoHealing *bool `type:"boolean"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. To control when updates are installed,
	// set this value to false. You must then update your instances manually by
	// using CreateDeployment to run the update_dependencies stack command or by
	// manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.
	//
	//  To ensure that your instances have the latest security updates, we strongly
	// recommend using the default value of true.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// A LifeCycleEventConfiguration object that you can use to configure the Shutdown
	// event to specify an execution timeout and enable or disable Elastic Load
	// Balancer connection draining.
	LifecycleEventConfiguration *LifecycleEventConfiguration `type:"structure"`

	// The layer name, which is used by the console.
	Name *string `type:"string" required:"true"`

	// An array of Package objects that describes the layer packages.
	Packages []*string `type:"list"`

	// For custom layers only, use this parameter to specify the layer's short name,
	// which is used internally by AWS OpsWorks and by Chef recipes. The short name
	// is also used as the name for the directory where your app files are installed.
	// It can have a maximum of 200 characters, which are limited to the alphanumeric
	// characters, '-', '_', and '.'.
	//
	// The built-in layers' short names are defined by AWS OpsWorks. For more information,
	// see the Layer Reference (http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html).
	Shortname *string `type:"string" required:"true"`

	// The layer stack ID.
	StackId *string `type:"string" required:"true"`

	// The layer type. A stack cannot have more than one built-in layer of the same
	// type. It can have any number of custom layers.
	Type *string `type:"string" required:"true" enum:"LayerType"`

	// Whether to use Amazon EBS-optimized instances.
	UseEbsOptimizedInstances *bool `type:"boolean"`

	// A VolumeConfigurations object that describes the layer's Amazon EBS volumes.
	VolumeConfigurations []*VolumeConfiguration `type:"list"`

	metadataCreateLayerInput `json:"-" xml:"-"`
}

type metadataCreateLayerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateLayerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLayerInput) GoString() string {
	return s.String()
}

// Contains the response to a CreateLayer request.
type CreateLayerOutput struct {
	// The layer ID.
	LayerId *string `type:"string"`

	metadataCreateLayerOutput `json:"-" xml:"-"`
}

type metadataCreateLayerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateLayerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLayerOutput) GoString() string {
	return s.String()
}

type CreateStackInput struct {
	// The default AWS OpsWorks agent version. You have the following options:
	//
	//  Auto-update - Set this parameter to LATEST. AWS OpsWorks automatically
	// installs new agent versions on the stack's instances as soon as they are
	// available. Fixed version - Set this parameter to your preferred agent version.
	// To update the agent version, you must edit the stack configuration and specify
	// a new version. AWS OpsWorks then automatically installs that version on the
	// stack's instances.  The default setting is LATEST. To specify an agent version,
	// you must use the complete version number, not the abbreviated number shown
	// on the console. For a list of available agent version numbers, call DescribeAgentVersions.
	//
	// You can also specify an agent version when you create or update an instance,
	// which overrides the stack's default setting.
	AgentVersion *string `type:"string"`

	// One or more user-defined key-value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// A ChefConfiguration object that specifies whether to enable Berkshelf and
	// the Berkshelf version on Chef 11.10 stacks. For more information, see Create
	// a New Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	ChefConfiguration *ChefConfiguration `type:"structure"`

	// The configuration manager. When you clone a stack we recommend that you use
	// the configuration manager to specify the Chef version: 0.9, 11.4, or 11.10.
	// The default value is currently 11.4.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// Contains the information required to retrieve an app or cookbook from a repository.
	// For more information, see Creating Apps (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
	// or Custom Recipes and Cookbooks (http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
	CustomCookbooksSource *Source `type:"structure"`

	// A string that contains user-defined, custom JSON. It can be used to override
	// the corresponding default stack configuration attribute values or to pass
	// data to recipes. The string should be in the following escape characters
	// such as '"':
	//
	//  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The stack's default Availability Zone, which must be in the specified region.
	// For more information, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	// If you also specify a value for DefaultSubnetId, the subnet must be in the
	// same zone. For more information, see the VpcId parameter description.
	DefaultAvailabilityZone *string `type:"string"`

	// The Amazon Resource Name (ARN) of an IAM profile that is the default profile
	// for all of the stack's EC2 instances. For more information about IAM ARNs,
	// see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	DefaultInstanceProfileArn *string `type:"string" required:"true"`

	// The stack's default operating system, which is installed on every instance
	// unless you specify a different operating system when you create the instance.
	// You can specify one of the following.
	//
	//  A supported Linux operating system: An Amazon Linux version, such as Amazon
	// Linux 2015.03, Red Hat Enterprise Linux 7, Ubuntu 12.04 LTS, or Ubuntu 14.04
	// LTS.  Microsoft Windows Server 2012 R2 Base. A custom AMI: Custom. You specify
	// the custom AMI you want to use when you create instances. For more information,
	// see  Using Custom AMIs (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//  The default option is the current Amazon Linux version. For more information
	// on the supported operating systems, see AWS OpsWorks Operating Systems (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	DefaultOs *string `type:"string"`

	// The default root device type. This value is the default for all instances
	// in the stack, but you can override it when you create an instance. The default
	// option is instance-store. For more information, see Storage for the Root
	// Device (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	DefaultRootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// A default Amazon EC2 key pair name. The default value is none. If you specify
	// a key pair name, AWS OpsWorks installs the public key on the instance and
	// you can use the private key with an SSH client to log in to the instance.
	// For more information, see  Using SSH to Communicate with an Instance (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html)
	// and  Managing SSH Access (http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html).
	// You can override this setting by specifying a different key pair, or no key
	// pair, when you  create an instance (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
	DefaultSshKeyName *string `type:"string"`

	// The stack's default VPC subnet ID. This parameter is required if you specify
	// a value for the VpcId parameter. All instances are launched into this subnet
	// unless you specify otherwise when you create the instance. If you also specify
	// a value for DefaultAvailabilityZone, the subnet must be in that zone. For
	// information on default values and when this parameter is required, see the
	// VpcId parameter description.
	DefaultSubnetId *string `type:"string"`

	// The stack's host name theme, with spaces replaced by underscores. The theme
	// is used to generate host names for the stack's instances. By default, HostnameTheme
	// is set to Layer_Dependent, which creates host names by appending integers
	// to the layer's short name. The other themes are:
	//
	//   Baked_Goods   Clouds   Europe_Cities   Fruits   Greek_Deities   Legendary_creatures_from_Japan
	//   Planets_and_Moons   Roman_Deities   Scottish_Islands   US_Cities   Wild_Cats
	//   To obtain a generated host name, call GetHostNameSuggestion, which returns
	// a host name based on the current theme.
	HostnameTheme *string `type:"string"`

	// The stack name.
	Name *string `type:"string" required:"true"`

	// The stack's AWS region, such as "us-east-1". For more information about Amazon
	// regions, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string" required:"true"`

	// The stack's AWS Identity and Access Management (IAM) role, which allows AWS
	// OpsWorks to work with AWS resources on your behalf. You must set this parameter
	// to the Amazon Resource Name (ARN) for an existing IAM role. For more information
	// about IAM ARNs, see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	ServiceRoleArn *string `type:"string" required:"true"`

	// Whether the stack uses custom cookbooks.
	UseCustomCookbooks *bool `type:"boolean"`

	// Whether to associate the AWS OpsWorks built-in security groups with the stack's
	// layers.
	//
	// AWS OpsWorks provides a standard set of built-in security groups, one for
	// each layer, which are associated with layers by default. With UseOpsworksSecurityGroups
	// you can instead provide your own custom security groups. UseOpsworksSecurityGroups
	// has the following settings:
	//
	//  True - AWS OpsWorks automatically associates the appropriate built-in security
	// group with each layer (default setting). You can associate additional security
	// groups with a layer after you create it, but you cannot delete the built-in
	// security group.  False - AWS OpsWorks does not associate built-in security
	// groups with layers. You must create appropriate EC2 security groups and associate
	// a security group with each layer that you create. However, you can still
	// manually associate a built-in security group with a layer on creation; custom
	// security groups are required only for those layers that need custom settings.
	//   For more information, see Create a New Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	UseOpsworksSecurityGroups *bool `type:"boolean"`

	// The ID of the VPC that the stack is to be launched into. The VPC must be
	// in the stack's region. All instances are launched into this VPC. You cannot
	// change the ID later.
	//
	//  If your account supports EC2-Classic, the default value is no VPC. If your
	// account does not support EC2-Classic, the default value is the default VPC
	// for the specified region.  If the VPC ID corresponds to a default VPC and
	// you have specified either the DefaultAvailabilityZone or the DefaultSubnetId
	// parameter only, AWS OpsWorks infers the value of the other parameter. If
	// you specify neither parameter, AWS OpsWorks sets these parameters to the
	// first valid Availability Zone for the specified region and the corresponding
	// default VPC subnet ID, respectively.
	//
	// If you specify a nondefault VPC ID, note the following:
	//
	//  It must belong to a VPC in your account that is in the specified region.
	// You must specify a value for DefaultSubnetId.  For more information on how
	// to use AWS OpsWorks with a VPC, see Running a Stack in a VPC (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html).
	// For more information on default VPC and EC2-Classic, see Supported Platforms
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html).
	VpcId *string `type:"string"`

	metadataCreateStackInput `json:"-" xml:"-"`
}

type metadataCreateStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// Contains the response to a CreateStack request.
type CreateStackOutput struct {
	// The stack ID, which is an opaque string that you use to identify the stack
	// when performing actions such as DescribeStacks.
	StackId *string `type:"string"`

	metadataCreateStackOutput `json:"-" xml:"-"`
}

type metadataCreateStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

type CreateUserProfileInput struct {
	// Whether users can specify their own SSH public key through the My Settings
	// page. For more information, see Setting an IAM User's Public SSH Key (http://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
	AllowSelfManagement *bool `type:"boolean"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string" required:"true"`

	// The user's public SSH key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9],
	// '-', and '_'. If the specified name includes other punctuation marks, AWS
	// OpsWorks removes them. For example, my.name will be changed to myname. If
	// you do not specify an SSH user name, AWS OpsWorks generates one from the
	// IAM user name.
	SshUsername *string `type:"string"`

	metadataCreateUserProfileInput `json:"-" xml:"-"`
}

type metadataCreateUserProfileInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileInput) GoString() string {
	return s.String()
}

// Contains the response to a CreateUserProfile request.
type CreateUserProfileOutput struct {
	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	metadataCreateUserProfileOutput `json:"-" xml:"-"`
}

type metadataCreateUserProfileOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileOutput) GoString() string {
	return s.String()
}

// Describes an app's data source.
type DataSource struct {
	// The data source's ARN.
	Arn *string `type:"string"`

	// The database name.
	DatabaseName *string `type:"string"`

	// The data source's type, AutoSelectOpsworksMysqlInstance, OpsworksMysqlInstance,
	// or RdsDbInstance.
	Type *string `type:"string"`

	metadataDataSource `json:"-" xml:"-"`
}

type metadataDataSource struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

type DeleteAppInput struct {
	// The app ID.
	AppId *string `type:"string" required:"true"`

	metadataDeleteAppInput `json:"-" xml:"-"`
}

type metadataDeleteAppInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppInput) GoString() string {
	return s.String()
}

type DeleteAppOutput struct {
	metadataDeleteAppOutput `json:"-" xml:"-"`
}

type metadataDeleteAppOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

type DeleteInstanceInput struct {
	// Whether to delete the instance Elastic IP address.
	DeleteElasticIp *bool `type:"boolean"`

	// Whether to delete the instance's Amazon EBS volumes.
	DeleteVolumes *bool `type:"boolean"`

	// The instance ID.
	InstanceId *string `type:"string" required:"true"`

	metadataDeleteInstanceInput `json:"-" xml:"-"`
}

type metadataDeleteInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceInput) GoString() string {
	return s.String()
}

type DeleteInstanceOutput struct {
	metadataDeleteInstanceOutput `json:"-" xml:"-"`
}

type metadataDeleteInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceOutput) GoString() string {
	return s.String()
}

type DeleteLayerInput struct {
	// The layer ID.
	LayerId *string `type:"string" required:"true"`

	metadataDeleteLayerInput `json:"-" xml:"-"`
}

type metadataDeleteLayerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteLayerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLayerInput) GoString() string {
	return s.String()
}

type DeleteLayerOutput struct {
	metadataDeleteLayerOutput `json:"-" xml:"-"`
}

type metadataDeleteLayerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteLayerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLayerOutput) GoString() string {
	return s.String()
}

type DeleteStackInput struct {
	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataDeleteStackInput `json:"-" xml:"-"`
}

type metadataDeleteStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

type DeleteStackOutput struct {
	metadataDeleteStackOutput `json:"-" xml:"-"`
}

type metadataDeleteStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

type DeleteUserProfileInput struct {
	// The user's IAM ARN.
	IamUserArn *string `type:"string" required:"true"`

	metadataDeleteUserProfileInput `json:"-" xml:"-"`
}

type metadataDeleteUserProfileInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileInput) GoString() string {
	return s.String()
}

type DeleteUserProfileOutput struct {
	metadataDeleteUserProfileOutput `json:"-" xml:"-"`
}

type metadataDeleteUserProfileOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileOutput) GoString() string {
	return s.String()
}

// Describes a deployment of a stack or app.
type Deployment struct {
	// The app ID.
	AppId *string `type:"string"`

	// Used to specify a stack or deployment command.
	Command *DeploymentCommand `type:"structure"`

	// A user-defined comment.
	Comment *string `type:"string"`

	// Date when the deployment completed.
	CompletedAt *string `type:"string"`

	// Date when the deployment was created.
	CreatedAt *string `type:"string"`

	// A string that contains user-defined custom JSON. It can be used to override
	// the corresponding default stack configuration attribute values for stack
	// or to pass data to recipes. The string should be in the following format
	// and must escape characters such as '"':
	//
	//  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The deployment ID.
	DeploymentId *string `type:"string"`

	// The deployment duration.
	Duration *int64 `type:"integer"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	// The IDs of the target instances.
	InstanceIds []*string `type:"list"`

	// The stack ID.
	StackId *string `type:"string"`

	// The deployment status:
	//
	//  running successful failed
	Status *string `type:"string"`

	metadataDeployment `json:"-" xml:"-"`
}

type metadataDeployment struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Deployment) GoString() string {
	return s.String()
}

// Used to specify a stack or deployment command.
type DeploymentCommand struct {
	// The arguments of those commands that take arguments. It should be set to
	// a JSON object with the following format:
	//
	//  {"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2",
	// ...], ...}
	//
	// The update_dependencies command takes two arguments:
	//
	//   upgrade_os_to - Specifies the desired Amazon Linux version for instances
	// whose OS you want to upgrade, such as Amazon Linux 2014.09. You must also
	// set the allow_reboot argument to true.  allow_reboot - Specifies whether
	// to allow AWS OpsWorks to reboot the instances if necessary, after installing
	// the updates. This argument can be set to either true or false. The default
	// value is false.  For example, to upgrade an instance to Amazon Linux 2014.09,
	// set Args to the following.
	//
	//  { "upgrade_os_to":["Amazon Linux 2014.09"], "allow_reboot":["true"] }
	Args map[string][]*string `type:"map"`

	// Specifies the operation. You can specify only one command.
	//
	// For stacks, the following commands are available:
	//
	//   execute_recipes: Execute one or more recipes. To specify the recipes,
	// set an Args parameter named recipes to the list of recipes to be executed.
	// For example, to execute phpapp::appsetup, set Args to {"recipes":["phpapp::appsetup"]}.
	//  install_dependencies: Install the stack's dependencies.  update_custom_cookbooks:
	// Update the stack's custom cookbooks.  update_dependencies: Update the stack's
	// dependencies.  The update_dependencies and install_dependencies commands
	// are supported only for Linux instances. You can run the commands successfully
	// on Windows instances, but they do nothing. For apps, the following commands
	// are available:
	//
	//   deploy: Deploy an app. Ruby on Rails apps have an optional Args parameter
	// named migrate. Set Args to {"migrate":["true"]} to migrate the database.
	// The default setting is {"migrate":["false"]}.  rollback Roll the app back
	// to the previous version. When you update an app, AWS OpsWorks stores the
	// previous version, up to a maximum of five versions. You can use this command
	// to roll an app back as many as four versions.  start: Start the app's web
	// or application server.  stop: Stop the app's web or application server.
	// restart: Restart the app's web or application server.  undeploy: Undeploy
	// the app.
	Name *string `type:"string" required:"true" enum:"DeploymentCommandName"`

	metadataDeploymentCommand `json:"-" xml:"-"`
}

type metadataDeploymentCommand struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeploymentCommand) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentCommand) GoString() string {
	return s.String()
}

type DeregisterEcsClusterInput struct {
	// The cluster's ARN.
	EcsClusterArn *string `type:"string" required:"true"`

	metadataDeregisterEcsClusterInput `json:"-" xml:"-"`
}

type metadataDeregisterEcsClusterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterEcsClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterEcsClusterInput) GoString() string {
	return s.String()
}

type DeregisterEcsClusterOutput struct {
	metadataDeregisterEcsClusterOutput `json:"-" xml:"-"`
}

type metadataDeregisterEcsClusterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterEcsClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterEcsClusterOutput) GoString() string {
	return s.String()
}

type DeregisterElasticIpInput struct {
	// The Elastic IP address.
	ElasticIp *string `type:"string" required:"true"`

	metadataDeregisterElasticIpInput `json:"-" xml:"-"`
}

type metadataDeregisterElasticIpInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterElasticIpInput) GoString() string {
	return s.String()
}

type DeregisterElasticIpOutput struct {
	metadataDeregisterElasticIpOutput `json:"-" xml:"-"`
}

type metadataDeregisterElasticIpOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterElasticIpOutput) GoString() string {
	return s.String()
}

type DeregisterInstanceInput struct {
	// The instance ID.
	InstanceId *string `type:"string" required:"true"`

	metadataDeregisterInstanceInput `json:"-" xml:"-"`
}

type metadataDeregisterInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstanceInput) GoString() string {
	return s.String()
}

type DeregisterInstanceOutput struct {
	metadataDeregisterInstanceOutput `json:"-" xml:"-"`
}

type metadataDeregisterInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstanceOutput) GoString() string {
	return s.String()
}

type DeregisterRdsDbInstanceInput struct {
	// The Amazon RDS instance's ARN.
	RdsDbInstanceArn *string `type:"string" required:"true"`

	metadataDeregisterRdsDbInstanceInput `json:"-" xml:"-"`
}

type metadataDeregisterRdsDbInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterRdsDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterRdsDbInstanceInput) GoString() string {
	return s.String()
}

type DeregisterRdsDbInstanceOutput struct {
	metadataDeregisterRdsDbInstanceOutput `json:"-" xml:"-"`
}

type metadataDeregisterRdsDbInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterRdsDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterRdsDbInstanceOutput) GoString() string {
	return s.String()
}

type DeregisterVolumeInput struct {
	// The AWS OpsWorks volume ID, which is the GUID that AWS OpsWorks assigned
	// to the instance when you registered the volume with the stack, not the Amazon
	// EC2 volume ID.
	VolumeId *string `type:"string" required:"true"`

	metadataDeregisterVolumeInput `json:"-" xml:"-"`
}

type metadataDeregisterVolumeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterVolumeInput) GoString() string {
	return s.String()
}

type DeregisterVolumeOutput struct {
	metadataDeregisterVolumeOutput `json:"-" xml:"-"`
}

type metadataDeregisterVolumeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeregisterVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterVolumeOutput) GoString() string {
	return s.String()
}

type DescribeAgentVersionsInput struct {
	// The configuration manager.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// The stack ID.
	StackId *string `type:"string"`

	metadataDescribeAgentVersionsInput `json:"-" xml:"-"`
}

type metadataDescribeAgentVersionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAgentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentVersionsInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeAgentVersions request.
type DescribeAgentVersionsOutput struct {
	// The agent versions for the specified stack or configuration manager. Note
	// that this value is the complete version number, not the abbreviated number
	// used by the console.
	AgentVersions []*AgentVersion `type:"list"`

	metadataDescribeAgentVersionsOutput `json:"-" xml:"-"`
}

type metadataDescribeAgentVersionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAgentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentVersionsOutput) GoString() string {
	return s.String()
}

type DescribeAppsInput struct {
	// An array of app IDs for the apps to be described. If you use this parameter,
	// DescribeApps returns a description of the specified apps. Otherwise, it returns
	// a description of every app.
	AppIds []*string `type:"list"`

	// The app stack ID. If you use this parameter, DescribeApps returns a description
	// of the apps in the specified stack.
	StackId *string `type:"string"`

	metadataDescribeAppsInput `json:"-" xml:"-"`
}

type metadataDescribeAppsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAppsInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeApps request.
type DescribeAppsOutput struct {
	// An array of App objects that describe the specified apps.
	Apps []*App `type:"list"`

	metadataDescribeAppsOutput `json:"-" xml:"-"`
}

type metadataDescribeAppsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAppsOutput) GoString() string {
	return s.String()
}

type DescribeCommandsInput struct {
	// An array of command IDs. If you include this parameter, DescribeCommands
	// returns a description of the specified commands. Otherwise, it returns a
	// description of every command.
	CommandIds []*string `type:"list"`

	// The deployment ID. If you include this parameter, DescribeCommands returns
	// a description of the commands associated with the specified deployment.
	DeploymentId *string `type:"string"`

	// The instance ID. If you include this parameter, DescribeCommands returns
	// a description of the commands associated with the specified instance.
	InstanceId *string `type:"string"`

	metadataDescribeCommandsInput `json:"-" xml:"-"`
}

type metadataDescribeCommandsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCommandsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommandsInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeCommands request.
type DescribeCommandsOutput struct {
	// An array of Command objects that describe each of the specified commands.
	Commands []*Command `type:"list"`

	metadataDescribeCommandsOutput `json:"-" xml:"-"`
}

type metadataDescribeCommandsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCommandsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommandsOutput) GoString() string {
	return s.String()
}

type DescribeDeploymentsInput struct {
	// The app ID. If you include this parameter, DescribeDeployments returns a
	// description of the commands associated with the specified app.
	AppId *string `type:"string"`

	// An array of deployment IDs to be described. If you include this parameter,
	// DescribeDeployments returns a description of the specified deployments. Otherwise,
	// it returns a description of every deployment.
	DeploymentIds []*string `type:"list"`

	// The stack ID. If you include this parameter, DescribeDeployments returns
	// a description of the commands associated with the specified stack.
	StackId *string `type:"string"`

	metadataDescribeDeploymentsInput `json:"-" xml:"-"`
}

type metadataDescribeDeploymentsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeploymentsInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeDeployments request.
type DescribeDeploymentsOutput struct {
	// An array of Deployment objects that describe the deployments.
	Deployments []*Deployment `type:"list"`

	metadataDescribeDeploymentsOutput `json:"-" xml:"-"`
}

type metadataDescribeDeploymentsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeploymentsOutput) GoString() string {
	return s.String()
}

type DescribeEcsClustersInput struct {
	// A list of ARNs, one for each cluster to be described.
	EcsClusterArns []*string `type:"list"`

	// To receive a paginated response, use this parameter to specify the maximum
	// number of results to be returned with a single call. If the number of available
	// results exceeds this maximum, the response includes a NextToken value that
	// you can assign to the NextToken request parameter to get the next set of
	// results.
	MaxResults *int64 `type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object'sNextToken parameter value is set to a token. To retrieve
	// the next set of results, call DescribeEcsClusters again and assign that token
	// to the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `type:"string"`

	// A stack ID. DescribeEcsClusters returns a description of the cluster that
	// is registered with the stack.
	StackId *string `type:"string"`

	metadataDescribeEcsClustersInput `json:"-" xml:"-"`
}

type metadataDescribeEcsClustersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEcsClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEcsClustersInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeEcsClusters request.
type DescribeEcsClustersOutput struct {
	// A list of EcsCluster objects containing the cluster descriptions.
	EcsClusters []*EcsCluster `type:"list"`

	// If a paginated request does not return all of the remaining results, this
	// parameter is set to a token that you can assign to the request object's NextToken
	// parameter to retrieve the next set of results. If the previous paginated
	// request returned all of the remaining results, this parameter is set to null.
	NextToken *string `type:"string"`

	metadataDescribeEcsClustersOutput `json:"-" xml:"-"`
}

type metadataDescribeEcsClustersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeEcsClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEcsClustersOutput) GoString() string {
	return s.String()
}

type DescribeElasticIpsInput struct {
	// The instance ID. If you include this parameter, DescribeElasticIps returns
	// a description of the Elastic IP addresses associated with the specified instance.
	InstanceId *string `type:"string"`

	// An array of Elastic IP addresses to be described. If you include this parameter,
	// DescribeElasticIps returns a description of the specified Elastic IP addresses.
	// Otherwise, it returns a description of every Elastic IP address.
	Ips []*string `type:"list"`

	// A stack ID. If you include this parameter, DescribeElasticIps returns a description
	// of the Elastic IP addresses that are registered with the specified stack.
	StackId *string `type:"string"`

	metadataDescribeElasticIpsInput `json:"-" xml:"-"`
}

type metadataDescribeElasticIpsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeElasticIpsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticIpsInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeElasticIps request.
type DescribeElasticIpsOutput struct {
	// An ElasticIps object that describes the specified Elastic IP addresses.
	ElasticIps []*ElasticIp `type:"list"`

	metadataDescribeElasticIpsOutput `json:"-" xml:"-"`
}

type metadataDescribeElasticIpsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeElasticIpsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticIpsOutput) GoString() string {
	return s.String()
}

type DescribeElasticLoadBalancersInput struct {
	// A list of layer IDs. The action describes the Elastic Load Balancing instances
	// for the specified layers.
	LayerIds []*string `type:"list"`

	// A stack ID. The action describes the stack's Elastic Load Balancing instances.
	StackId *string `type:"string"`

	metadataDescribeElasticLoadBalancersInput `json:"-" xml:"-"`
}

type metadataDescribeElasticLoadBalancersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeElasticLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticLoadBalancersInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeElasticLoadBalancers request.
type DescribeElasticLoadBalancersOutput struct {
	// A list of ElasticLoadBalancer objects that describe the specified Elastic
	// Load Balancing instances.
	ElasticLoadBalancers []*ElasticLoadBalancer `type:"list"`

	metadataDescribeElasticLoadBalancersOutput `json:"-" xml:"-"`
}

type metadataDescribeElasticLoadBalancersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeElasticLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticLoadBalancersOutput) GoString() string {
	return s.String()
}

type DescribeInstancesInput struct {
	// An array of instance IDs to be described. If you use this parameter, DescribeInstances
	// returns a description of the specified instances. Otherwise, it returns a
	// description of every instance.
	InstanceIds []*string `type:"list"`

	// A layer ID. If you use this parameter, DescribeInstances returns descriptions
	// of the instances associated with the specified layer.
	LayerId *string `type:"string"`

	// A stack ID. If you use this parameter, DescribeInstances returns descriptions
	// of the instances associated with the specified stack.
	StackId *string `type:"string"`

	metadataDescribeInstancesInput `json:"-" xml:"-"`
}

type metadataDescribeInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeInstances request.
type DescribeInstancesOutput struct {
	// An array of Instance objects that describe the instances.
	Instances []*Instance `type:"list"`

	metadataDescribeInstancesOutput `json:"-" xml:"-"`
}

type metadataDescribeInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesOutput) GoString() string {
	return s.String()
}

type DescribeLayersInput struct {
	// An array of layer IDs that specify the layers to be described. If you omit
	// this parameter, DescribeLayers returns a description of every layer in the
	// specified stack.
	LayerIds []*string `type:"list"`

	// The stack ID.
	StackId *string `type:"string"`

	metadataDescribeLayersInput `json:"-" xml:"-"`
}

type metadataDescribeLayersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeLayersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLayersInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeLayers request.
type DescribeLayersOutput struct {
	// An array of Layer objects that describe the layers.
	Layers []*Layer `type:"list"`

	metadataDescribeLayersOutput `json:"-" xml:"-"`
}

type metadataDescribeLayersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeLayersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLayersOutput) GoString() string {
	return s.String()
}

type DescribeLoadBasedAutoScalingInput struct {
	// An array of layer IDs.
	LayerIds []*string `type:"list" required:"true"`

	metadataDescribeLoadBasedAutoScalingInput `json:"-" xml:"-"`
}

type metadataDescribeLoadBasedAutoScalingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeLoadBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBasedAutoScalingInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeLoadBasedAutoScaling request.
type DescribeLoadBasedAutoScalingOutput struct {
	// An array of LoadBasedAutoScalingConfiguration objects that describe each
	// layer's configuration.
	LoadBasedAutoScalingConfigurations []*LoadBasedAutoScalingConfiguration `type:"list"`

	metadataDescribeLoadBasedAutoScalingOutput `json:"-" xml:"-"`
}

type metadataDescribeLoadBasedAutoScalingOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeLoadBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBasedAutoScalingOutput) GoString() string {
	return s.String()
}

type DescribeMyUserProfileInput struct {
	metadataDescribeMyUserProfileInput `json:"-" xml:"-"`
}

type metadataDescribeMyUserProfileInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeMyUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMyUserProfileInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeMyUserProfile request.
type DescribeMyUserProfileOutput struct {
	// A UserProfile object that describes the user's SSH information.
	UserProfile *SelfUserProfile `type:"structure"`

	metadataDescribeMyUserProfileOutput `json:"-" xml:"-"`
}

type metadataDescribeMyUserProfileOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeMyUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMyUserProfileOutput) GoString() string {
	return s.String()
}

type DescribePermissionsInput struct {
	// The user's IAM ARN. For more information about IAM ARNs, see Using Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	IamUserArn *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	metadataDescribePermissionsInput `json:"-" xml:"-"`
}

type metadataDescribePermissionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePermissionsInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribePermissions request.
type DescribePermissionsOutput struct {
	// An array of Permission objects that describe the stack permissions.
	//
	//  If the request object contains only a stack ID, the array contains a Permission
	// object with permissions for each of the stack IAM ARNs. If the request object
	// contains only an IAM ARN, the array contains a Permission object with permissions
	// for each of the user's stack IDs. If the request contains a stack ID and
	// an IAM ARN, the array contains a single Permission object with permissions
	// for the specified stack and IAM ARN.
	Permissions []*Permission `type:"list"`

	metadataDescribePermissionsOutput `json:"-" xml:"-"`
}

type metadataDescribePermissionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePermissionsOutput) GoString() string {
	return s.String()
}

type DescribeRaidArraysInput struct {
	// The instance ID. If you use this parameter, DescribeRaidArrays returns descriptions
	// of the RAID arrays associated with the specified instance.
	InstanceId *string `type:"string"`

	// An array of RAID array IDs. If you use this parameter, DescribeRaidArrays
	// returns descriptions of the specified arrays. Otherwise, it returns a description
	// of every array.
	RaidArrayIds []*string `type:"list"`

	// The stack ID.
	StackId *string `type:"string"`

	metadataDescribeRaidArraysInput `json:"-" xml:"-"`
}

type metadataDescribeRaidArraysInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeRaidArraysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRaidArraysInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeRaidArrays request.
type DescribeRaidArraysOutput struct {
	// A RaidArrays object that describes the specified RAID arrays.
	RaidArrays []*RaidArray `type:"list"`

	metadataDescribeRaidArraysOutput `json:"-" xml:"-"`
}

type metadataDescribeRaidArraysOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeRaidArraysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRaidArraysOutput) GoString() string {
	return s.String()
}

type DescribeRdsDbInstancesInput struct {
	// An array containing the ARNs of the instances to be described.
	RdsDbInstanceArns []*string `type:"list"`

	// The stack ID that the instances are registered with. The operation returns
	// descriptions of all registered Amazon RDS instances.
	StackId *string `type:"string" required:"true"`

	metadataDescribeRdsDbInstancesInput `json:"-" xml:"-"`
}

type metadataDescribeRdsDbInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeRdsDbInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRdsDbInstancesInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeRdsDbInstances request.
type DescribeRdsDbInstancesOutput struct {
	// An a array of RdsDbInstance objects that describe the instances.
	RdsDbInstances []*RdsDbInstance `type:"list"`

	metadataDescribeRdsDbInstancesOutput `json:"-" xml:"-"`
}

type metadataDescribeRdsDbInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeRdsDbInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRdsDbInstancesOutput) GoString() string {
	return s.String()
}

type DescribeServiceErrorsInput struct {
	// The instance ID. If you use this parameter, DescribeServiceErrors returns
	// descriptions of the errors associated with the specified instance.
	InstanceId *string `type:"string"`

	// An array of service error IDs. If you use this parameter, DescribeServiceErrors
	// returns descriptions of the specified errors. Otherwise, it returns a description
	// of every error.
	ServiceErrorIds []*string `type:"list"`

	// The stack ID. If you use this parameter, DescribeServiceErrors returns descriptions
	// of the errors associated with the specified stack.
	StackId *string `type:"string"`

	metadataDescribeServiceErrorsInput `json:"-" xml:"-"`
}

type metadataDescribeServiceErrorsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeServiceErrorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceErrorsInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeServiceErrors request.
type DescribeServiceErrorsOutput struct {
	// An array of ServiceError objects that describe the specified service errors.
	ServiceErrors []*ServiceError `type:"list"`

	metadataDescribeServiceErrorsOutput `json:"-" xml:"-"`
}

type metadataDescribeServiceErrorsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeServiceErrorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceErrorsOutput) GoString() string {
	return s.String()
}

type DescribeStackProvisioningParametersInput struct {
	// The stack ID
	StackId *string `type:"string" required:"true"`

	metadataDescribeStackProvisioningParametersInput `json:"-" xml:"-"`
}

type metadataDescribeStackProvisioningParametersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackProvisioningParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackProvisioningParametersInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeStackProvisioningParameters request.
type DescribeStackProvisioningParametersOutput struct {
	// The AWS OpsWorks agent installer's URL.
	AgentInstallerUrl *string `type:"string"`

	// An embedded object that contains the provisioning parameters.
	Parameters map[string]*string `type:"map"`

	metadataDescribeStackProvisioningParametersOutput `json:"-" xml:"-"`
}

type metadataDescribeStackProvisioningParametersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackProvisioningParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackProvisioningParametersOutput) GoString() string {
	return s.String()
}

type DescribeStackSummaryInput struct {
	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataDescribeStackSummaryInput `json:"-" xml:"-"`
}

type metadataDescribeStackSummaryInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSummaryInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeStackSummary request.
type DescribeStackSummaryOutput struct {
	// A StackSummary object that contains the results.
	StackSummary *StackSummary `type:"structure"`

	metadataDescribeStackSummaryOutput `json:"-" xml:"-"`
}

type metadataDescribeStackSummaryOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSummaryOutput) GoString() string {
	return s.String()
}

type DescribeStacksInput struct {
	// An array of stack IDs that specify the stacks to be described. If you omit
	// this parameter, DescribeStacks returns a description of every stack.
	StackIds []*string `type:"list"`

	metadataDescribeStacksInput `json:"-" xml:"-"`
}

type metadataDescribeStacksInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeStacks request.
type DescribeStacksOutput struct {
	// An array of Stack objects that describe the stacks.
	Stacks []*Stack `type:"list"`

	metadataDescribeStacksOutput `json:"-" xml:"-"`
}

type metadataDescribeStacksOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

type DescribeTimeBasedAutoScalingInput struct {
	// An array of instance IDs.
	InstanceIds []*string `type:"list" required:"true"`

	metadataDescribeTimeBasedAutoScalingInput `json:"-" xml:"-"`
}

type metadataDescribeTimeBasedAutoScalingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTimeBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTimeBasedAutoScalingInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeTimeBasedAutoScaling request.
type DescribeTimeBasedAutoScalingOutput struct {
	// An array of TimeBasedAutoScalingConfiguration objects that describe the configuration
	// for the specified instances.
	TimeBasedAutoScalingConfigurations []*TimeBasedAutoScalingConfiguration `type:"list"`

	metadataDescribeTimeBasedAutoScalingOutput `json:"-" xml:"-"`
}

type metadataDescribeTimeBasedAutoScalingOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTimeBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTimeBasedAutoScalingOutput) GoString() string {
	return s.String()
}

type DescribeUserProfilesInput struct {
	// An array of IAM user ARNs that identify the users to be described.
	IamUserArns []*string `type:"list"`

	metadataDescribeUserProfilesInput `json:"-" xml:"-"`
}

type metadataDescribeUserProfilesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeUserProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfilesInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeUserProfiles request.
type DescribeUserProfilesOutput struct {
	// A Users object that describes the specified users.
	UserProfiles []*UserProfile `type:"list"`

	metadataDescribeUserProfilesOutput `json:"-" xml:"-"`
}

type metadataDescribeUserProfilesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeUserProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfilesOutput) GoString() string {
	return s.String()
}

type DescribeVolumesInput struct {
	// The instance ID. If you use this parameter, DescribeVolumes returns descriptions
	// of the volumes associated with the specified instance.
	InstanceId *string `type:"string"`

	// The RAID array ID. If you use this parameter, DescribeVolumes returns descriptions
	// of the volumes associated with the specified RAID array.
	RaidArrayId *string `type:"string"`

	// A stack ID. The action describes the stack's registered Amazon EBS volumes.
	StackId *string `type:"string"`

	// Am array of volume IDs. If you use this parameter, DescribeVolumes returns
	// descriptions of the specified volumes. Otherwise, it returns a description
	// of every volume.
	VolumeIds []*string `type:"list"`

	metadataDescribeVolumesInput `json:"-" xml:"-"`
}

type metadataDescribeVolumesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumesInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeVolumes request.
type DescribeVolumesOutput struct {
	// An array of volume IDs.
	Volumes []*Volume `type:"list"`

	metadataDescribeVolumesOutput `json:"-" xml:"-"`
}

type metadataDescribeVolumesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumesOutput) GoString() string {
	return s.String()
}

type DetachElasticLoadBalancerInput struct {
	// The Elastic Load Balancing instance's name.
	ElasticLoadBalancerName *string `type:"string" required:"true"`

	// The ID of the layer that the Elastic Load Balancing instance is attached
	// to.
	LayerId *string `type:"string" required:"true"`

	metadataDetachElasticLoadBalancerInput `json:"-" xml:"-"`
}

type metadataDetachElasticLoadBalancerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DetachElasticLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachElasticLoadBalancerInput) GoString() string {
	return s.String()
}

type DetachElasticLoadBalancerOutput struct {
	metadataDetachElasticLoadBalancerOutput `json:"-" xml:"-"`
}

type metadataDetachElasticLoadBalancerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DetachElasticLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachElasticLoadBalancerOutput) GoString() string {
	return s.String()
}

type DisassociateElasticIpInput struct {
	// The Elastic IP address.
	ElasticIp *string `type:"string" required:"true"`

	metadataDisassociateElasticIpInput `json:"-" xml:"-"`
}

type metadataDisassociateElasticIpInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisassociateElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateElasticIpInput) GoString() string {
	return s.String()
}

type DisassociateElasticIpOutput struct {
	metadataDisassociateElasticIpOutput `json:"-" xml:"-"`
}

type metadataDisassociateElasticIpOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisassociateElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateElasticIpOutput) GoString() string {
	return s.String()
}

// Describes an Amazon EBS volume. This data type maps directly to the Amazon
// EC2 EbsBlockDevice (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html)
// data type.
type EbsBlockDevice struct {
	// Whether the volume is deleted on instance termination.
	DeleteOnTermination *bool `type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	// For more information, see EbsBlockDevice (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
	Iops *int64 `type:"integer"`

	// The snapshot ID.
	SnapshotId *string `type:"string"`

	// The volume size, in GiB. For more information, see EbsBlockDevice (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
	VolumeSize *int64 `type:"integer"`

	// The volume type. gp2 for General Purpose (SSD) volumes, io1 for Provisioned
	// IOPS (SSD) volumes, and standard for Magnetic volumes.
	VolumeType *string `type:"string" enum:"VolumeType"`

	metadataEbsBlockDevice `json:"-" xml:"-"`
}

type metadataEbsBlockDevice struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EbsBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsBlockDevice) GoString() string {
	return s.String()
}

// Describes a registered Amazon ECS cluster.
type EcsCluster struct {
	// The cluster's ARN.
	EcsClusterArn *string `type:"string"`

	// The cluster name.
	EcsClusterName *string `type:"string"`

	// The time and date that the cluster was registered with the stack.
	RegisteredAt *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	metadataEcsCluster `json:"-" xml:"-"`
}

type metadataEcsCluster struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EcsCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EcsCluster) GoString() string {
	return s.String()
}

// Describes an Elastic IP address.
type ElasticIp struct {
	// The domain.
	Domain *string `type:"string"`

	// The ID of the instance that the address is attached to.
	InstanceId *string `type:"string"`

	// The IP address.
	Ip *string `type:"string"`

	// The name.
	Name *string `type:"string"`

	// The AWS region. For more information, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`

	metadataElasticIp `json:"-" xml:"-"`
}

type metadataElasticIp struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ElasticIp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticIp) GoString() string {
	return s.String()
}

// Describes an Elastic Load Balancing instance.
type ElasticLoadBalancer struct {
	// A list of Availability Zones.
	AvailabilityZones []*string `type:"list"`

	// The instance's public DNS name.
	DnsName *string `type:"string"`

	// A list of the EC2 instances that the Elastic Load Balancing instance is managing
	// traffic for.
	Ec2InstanceIds []*string `type:"list"`

	// The Elastic Load Balancing instance's name.
	ElasticLoadBalancerName *string `type:"string"`

	// The ID of the layer that the instance is attached to.
	LayerId *string `type:"string"`

	// The instance's AWS region.
	Region *string `type:"string"`

	// The ID of the stack that the instance is associated with.
	StackId *string `type:"string"`

	// A list of subnet IDs, if the stack is running in a VPC.
	SubnetIds []*string `type:"list"`

	// The VPC ID.
	VpcId *string `type:"string"`

	metadataElasticLoadBalancer `json:"-" xml:"-"`
}

type metadataElasticLoadBalancer struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ElasticLoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticLoadBalancer) GoString() string {
	return s.String()
}

// Represents an app's environment variable.
type EnvironmentVariable struct {
	// (Required) The environment variable's name, which can consist of up to 64
	// characters and must be specified. The name can contain upper- and lowercase
	// letters, numbers, and underscores (_), but it must start with a letter or
	// underscore.
	Key *string `type:"string" required:"true"`

	// (Optional) Whether the variable's value will be returned by the DescribeApps
	// action. To conceal an environment variable's value, set Secure to true. DescribeApps
	// then returns *****FILTERED***** instead of the actual value. The default
	// value for Secure is false.
	Secure *bool `type:"boolean"`

	// (Optional) The environment variable's value, which can be left empty. If
	// you specify a value, it can contain up to 256 characters, which must all
	// be printable.
	Value *string `type:"string" required:"true"`

	metadataEnvironmentVariable `json:"-" xml:"-"`
}

type metadataEnvironmentVariable struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentVariable) GoString() string {
	return s.String()
}

type GetHostnameSuggestionInput struct {
	// The layer ID.
	LayerId *string `type:"string" required:"true"`

	metadataGetHostnameSuggestionInput `json:"-" xml:"-"`
}

type metadataGetHostnameSuggestionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHostnameSuggestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostnameSuggestionInput) GoString() string {
	return s.String()
}

// Contains the response to a GetHostnameSuggestion request.
type GetHostnameSuggestionOutput struct {
	// The generated host name.
	Hostname *string `type:"string"`

	// The layer ID.
	LayerId *string `type:"string"`

	metadataGetHostnameSuggestionOutput `json:"-" xml:"-"`
}

type metadataGetHostnameSuggestionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHostnameSuggestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostnameSuggestionOutput) GoString() string {
	return s.String()
}

type GrantAccessInput struct {
	// The instance's AWS OpsWorks ID.
	InstanceId *string `type:"string" required:"true"`

	// The length of time (in minutes) that the grant is valid. When the grant expires
	// at the end of this period, the user will no longer be able to use the credentials
	// to log in. If the user is logged in at the time, he or she automatically
	// will be logged out.
	ValidForInMinutes *int64 `min:"60" type:"integer"`

	metadataGrantAccessInput `json:"-" xml:"-"`
}

type metadataGrantAccessInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GrantAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantAccessInput) GoString() string {
	return s.String()
}

// Contains the response to a GrantAccess request.
type GrantAccessOutput struct {
	// A TemporaryCredential object that contains the data needed to log in to the
	// instance by RDP clients, such as the Microsoft Remote Desktop Connection.
	TemporaryCredential *TemporaryCredential `type:"structure"`

	metadataGrantAccessOutput `json:"-" xml:"-"`
}

type metadataGrantAccessOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GrantAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantAccessOutput) GoString() string {
	return s.String()
}

// Describes an instance.
type Instance struct {
	// The agent version. This parameter is set to INHERIT if the instance inherits
	// the default stack setting or to a a version number for a fixed agent version.
	AgentVersion *string `type:"string"`

	// A custom AMI ID to be used to create the instance. For more information,
	// see Instances (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html)
	AmiId *string `type:"string"`

	// The instance architecture: "i386" or "x86_64".
	Architecture *string `type:"string" enum:"Architecture"`

	// For load-based or time-based instances, the type.
	AutoScalingType *string `type:"string" enum:"AutoScalingType"`

	// The instance Availability Zone. For more information, see Regions and Endpoints
	// (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// An array of BlockDeviceMapping objects that specify the instance's block
	// device mappings.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The time that the instance was created.
	CreatedAt *string `type:"string"`

	// Whether this is an Amazon EBS-optimized instance.
	EbsOptimized *bool `type:"boolean"`

	// The ID of the associated Amazon EC2 instance.
	Ec2InstanceId *string `type:"string"`

	// For container instances, the Amazon ECS cluster's ARN.
	EcsClusterArn *string `type:"string"`

	// For container instances, the instance's ARN.
	EcsContainerInstanceArn *string `type:"string"`

	// The instance Elastic IP address  (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
	ElasticIp *string `type:"string"`

	// The instance host name.
	Hostname *string `type:"string"`

	// For registered instances, the infrastructure class: ec2 or on-premises.
	InfrastructureClass *string `type:"string"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. If this value is set to false, you must
	// then update your instances manually by using CreateDeployment to run the
	// update_dependencies stack command or by manually running yum (Amazon Linux)
	// or apt-get (Ubuntu) on the instances.
	//
	//  We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// The ARN of the instance's IAM profile. For more information about IAM ARNs,
	// see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	InstanceProfileArn *string `type:"string"`

	// The instance type, such as t2.micro.
	InstanceType *string `type:"string"`

	// The ID of the last service error. For more information, call DescribeServiceErrors.
	LastServiceErrorId *string `type:"string"`

	// An array containing the instance layer IDs.
	LayerIds []*string `type:"list"`

	// The instance's operating system.
	Os *string `type:"string"`

	// The instance's platform.
	Platform *string `type:"string"`

	// The The instance's private DNS name.
	PrivateDns *string `type:"string"`

	// The instance's private IP address.
	PrivateIp *string `type:"string"`

	// The instance public DNS name.
	PublicDns *string `type:"string"`

	// The instance public IP address.
	PublicIp *string `type:"string"`

	// For registered instances, who performed the registration.
	RegisteredBy *string `type:"string"`

	// The instance's reported AWS OpsWorks agent version.
	ReportedAgentVersion *string `type:"string"`

	// For registered instances, the reported operating system.
	ReportedOs *ReportedOs `type:"structure"`

	// The instance's root device type. For more information, see Storage for the
	// Root Device (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	RootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// The root device volume ID.
	RootDeviceVolumeId *string `type:"string"`

	// An array containing the instance security group IDs.
	SecurityGroupIds []*string `type:"list"`

	// The SSH key's Deep Security Agent (DSA) fingerprint.
	SshHostDsaKeyFingerprint *string `type:"string"`

	// The SSH key's RSA fingerprint.
	SshHostRsaKeyFingerprint *string `type:"string"`

	// The instance's Amazon EC2 key-pair name.
	SshKeyName *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	// The instance status:
	//
	//   booting   connection_lost   online   pending   rebooting   requested
	//  running_setup   setup_failed   shutting_down   start_failed   stopped
	// stopping   terminated   terminating
	Status *string `type:"string"`

	// The instance's subnet ID; applicable only if the stack is running in a VPC.
	SubnetId *string `type:"string"`

	// The instance's virtualization type: paravirtual or hvm.
	VirtualizationType *string `type:"string" enum:"VirtualizationType"`

	metadataInstance `json:"-" xml:"-"`
}

type metadataInstance struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// Contains a description of an Amazon EC2 instance from the Amazon EC2 metadata
// service. For more information, see Instance Metadata and User Data (http://docs.aws.amazon.com/sdkfornet/latest/apidocs/Index.html).
type InstanceIdentity struct {
	// A JSON document that contains the metadata.
	Document *string `type:"string"`

	// A signature that can be used to verify the document's accuracy and authenticity.
	Signature *string `type:"string"`

	metadataInstanceIdentity `json:"-" xml:"-"`
}

type metadataInstanceIdentity struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceIdentity) GoString() string {
	return s.String()
}

// Describes how many instances a stack has for each status.
type InstancesCount struct {
	// The number of instances in the Assigning state.
	Assigning *int64 `type:"integer"`

	// The number of instances with booting status.
	Booting *int64 `type:"integer"`

	// The number of instances with connection_lost status.
	ConnectionLost *int64 `type:"integer"`

	// The number of instances in the Deregistering state.
	Deregistering *int64 `type:"integer"`

	// The number of instances with online status.
	Online *int64 `type:"integer"`

	// The number of instances with pending status.
	Pending *int64 `type:"integer"`

	// The number of instances with rebooting status.
	Rebooting *int64 `type:"integer"`

	// The number of instances in the Registered state.
	Registered *int64 `type:"integer"`

	// The number of instances in the Registering state.
	Registering *int64 `type:"integer"`

	// The number of instances with requested status.
	Requested *int64 `type:"integer"`

	// The number of instances with running_setup status.
	RunningSetup *int64 `type:"integer"`

	// The number of instances with setup_failed status.
	SetupFailed *int64 `type:"integer"`

	// The number of instances with shutting_down status.
	ShuttingDown *int64 `type:"integer"`

	// The number of instances with start_failed status.
	StartFailed *int64 `type:"integer"`

	// The number of instances with stopped status.
	Stopped *int64 `type:"integer"`

	// The number of instances with stopping status.
	Stopping *int64 `type:"integer"`

	// The number of instances with terminated status.
	Terminated *int64 `type:"integer"`

	// The number of instances with terminating status.
	Terminating *int64 `type:"integer"`

	// The number of instances in the Unassigning state.
	Unassigning *int64 `type:"integer"`

	metadataInstancesCount `json:"-" xml:"-"`
}

type metadataInstancesCount struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstancesCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstancesCount) GoString() string {
	return s.String()
}

// Describes a layer.
type Layer struct {
	// The layer attributes.
	//
	// For the HaproxyStatsPassword, MysqlRootPassword, and GangliaPassword attributes,
	// AWS OpsWorks returns *****FILTERED***** instead of the actual value
	//
	// For an ECS Cluster layer, AWS OpsWorks the EcsClusterArn attribute is set
	// to the cluster's ARN.
	Attributes map[string]*string `type:"map"`

	// Whether to automatically assign an Elastic IP address (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
	// to the layer's instances. For more information, see How to Edit a Layer (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignElasticIps *bool `type:"boolean"`

	// For stacks that are running in a VPC, whether to automatically assign a public
	// IP address to the layer's instances. For more information, see How to Edit
	// a Layer (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignPublicIps *bool `type:"boolean"`

	// Date when the layer was created.
	CreatedAt *string `type:"string"`

	// The ARN of the default IAM profile to be used for the layer's EC2 instances.
	// For more information about IAM ARNs, see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	CustomInstanceProfileArn *string `type:"string"`

	// A JSON formatted string containing the layer's custom stack configuration
	// and deployment attributes.
	CustomJson *string `type:"string"`

	// A LayerCustomRecipes object that specifies the layer's custom recipes.
	CustomRecipes *Recipes `type:"structure"`

	// An array containing the layer's custom security group IDs.
	CustomSecurityGroupIds []*string `type:"list"`

	// AWS OpsWorks supports five lifecycle events: setup, configuration, deploy,
	// undeploy, and shutdown. For each layer, AWS OpsWorks runs a set of standard
	// recipes for each event. In addition, you can provide custom recipes for any
	// or all layers and events. AWS OpsWorks runs custom event recipes after the
	// standard recipes. LayerCustomRecipes specifies the custom recipes for a particular
	// layer to be run in response to each of the five events.
	//
	// To specify a recipe, use the cookbook's directory name in the repository
	// followed by two colons and the recipe name, which is the recipe's file name
	// without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb
	// recipe in the repository's phpapp2 folder.
	DefaultRecipes *Recipes `type:"structure"`

	// An array containing the layer's security group names.
	DefaultSecurityGroupNames []*string `type:"list"`

	// Whether auto healing is disabled for the layer.
	EnableAutoHealing *bool `type:"boolean"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. If this value is set to false, you must
	// then update your instances manually by using CreateDeployment to run the
	// update_dependencies stack command or manually running yum (Amazon Linux)
	// or apt-get (Ubuntu) on the instances.
	//
	//  We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The layer ID.
	LayerId *string `type:"string"`

	// A LifeCycleEventConfiguration object that specifies the Shutdown event configuration.
	LifecycleEventConfiguration *LifecycleEventConfiguration `type:"structure"`

	// The layer name.
	Name *string `type:"string"`

	// An array of Package objects that describe the layer's packages.
	Packages []*string `type:"list"`

	// The layer short name.
	Shortname *string `type:"string"`

	// The layer stack ID.
	StackId *string `type:"string"`

	// The layer type.
	Type *string `type:"string" enum:"LayerType"`

	// Whether the layer uses Amazon EBS-optimized instances.
	UseEbsOptimizedInstances *bool `type:"boolean"`

	// A VolumeConfigurations object that describes the layer's Amazon EBS volumes.
	VolumeConfigurations []*VolumeConfiguration `type:"list"`

	metadataLayer `json:"-" xml:"-"`
}

type metadataLayer struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Layer) GoString() string {
	return s.String()
}

// Specifies the lifecycle event configuration
type LifecycleEventConfiguration struct {
	// A ShutdownEventConfiguration object that specifies the Shutdown event configuration.
	Shutdown *ShutdownEventConfiguration `type:"structure"`

	metadataLifecycleEventConfiguration `json:"-" xml:"-"`
}

type metadataLifecycleEventConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LifecycleEventConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleEventConfiguration) GoString() string {
	return s.String()
}

// Describes a layer's load-based auto scaling configuration.
type LoadBasedAutoScalingConfiguration struct {
	// An AutoScalingThresholds object that describes the downscaling configuration,
	// which defines how and when AWS OpsWorks reduces the number of instances.
	DownScaling *AutoScalingThresholds `type:"structure"`

	// Whether load-based auto scaling is enabled for the layer.
	Enable *bool `type:"boolean"`

	// The layer ID.
	LayerId *string `type:"string"`

	// An AutoScalingThresholds object that describes the upscaling configuration,
	// which defines how and when AWS OpsWorks increases the number of instances.
	UpScaling *AutoScalingThresholds `type:"structure"`

	metadataLoadBasedAutoScalingConfiguration `json:"-" xml:"-"`
}

type metadataLoadBasedAutoScalingConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LoadBasedAutoScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBasedAutoScalingConfiguration) GoString() string {
	return s.String()
}

// Describes stack or user permissions.
type Permission struct {
	// Whether the user can use SSH.
	AllowSsh *bool `type:"boolean"`

	// Whether the user can use sudo.
	AllowSudo *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for an AWS Identity and Access Management
	// (IAM) role. For more information about IAM ARNs, see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	IamUserArn *string `type:"string"`

	// The user's permission level, which must be the following:
	//
	//   deny   show   deploy   manage   iam_only   For more information on the
	// permissions associated with these levels, see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html)
	Level *string `type:"string"`

	// A stack ID.
	StackId *string `type:"string"`

	metadataPermission `json:"-" xml:"-"`
}

type metadataPermission struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Permission) GoString() string {
	return s.String()
}

// Describes an instance's RAID array.
type RaidArray struct {
	// The array's Availability Zone. For more information, see Regions and Endpoints
	// (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// When the RAID array was created.
	CreatedAt *string `type:"string"`

	// The array's Linux device. For example /dev/mdadm0.
	Device *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// For PIOPS volumes, the IOPS per disk.
	Iops *int64 `type:"integer"`

	// The array's mount point.
	MountPoint *string `type:"string"`

	// The array name.
	Name *string `type:"string"`

	// The number of disks in the array.
	NumberOfDisks *int64 `type:"integer"`

	// The array ID.
	RaidArrayId *string `type:"string"`

	// The RAID level (http://en.wikipedia.org/wiki/Standard_RAID_levels).
	RaidLevel *int64 `type:"integer"`

	// The array's size.
	Size *int64 `type:"integer"`

	// The stack ID.
	StackId *string `type:"string"`

	// The volume type, standard or PIOPS.
	VolumeType *string `type:"string"`

	metadataRaidArray `json:"-" xml:"-"`
}

type metadataRaidArray struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RaidArray) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RaidArray) GoString() string {
	return s.String()
}

// Describes an Amazon RDS instance.
type RdsDbInstance struct {
	// The instance's address.
	Address *string `type:"string"`

	// The DB instance identifier.
	DbInstanceIdentifier *string `type:"string"`

	// AWS OpsWorks returns *****FILTERED***** instead of the actual value.
	DbPassword *string `type:"string"`

	// The master user name.
	DbUser *string `type:"string"`

	// The instance's database engine.
	Engine *string `type:"string"`

	// Set to true if AWS OpsWorks was unable to discover the Amazon RDS instance.
	// AWS OpsWorks attempts to discover the instance only once. If this value is
	// set to true, you must deregister the instance and then register it again.
	MissingOnRds *bool `type:"boolean"`

	// The instance's ARN.
	RdsDbInstanceArn *string `type:"string"`

	// The instance's AWS region.
	Region *string `type:"string"`

	// The ID of the stack that the instance is registered with.
	StackId *string `type:"string"`

	metadataRdsDbInstance `json:"-" xml:"-"`
}

type metadataRdsDbInstance struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RdsDbInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RdsDbInstance) GoString() string {
	return s.String()
}

type RebootInstanceInput struct {
	// The instance ID.
	InstanceId *string `type:"string" required:"true"`

	metadataRebootInstanceInput `json:"-" xml:"-"`
}

type metadataRebootInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RebootInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstanceInput) GoString() string {
	return s.String()
}

type RebootInstanceOutput struct {
	metadataRebootInstanceOutput `json:"-" xml:"-"`
}

type metadataRebootInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RebootInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstanceOutput) GoString() string {
	return s.String()
}

// AWS OpsWorks supports five lifecycle events: setup, configuration, deploy,
// undeploy, and shutdown. For each layer, AWS OpsWorks runs a set of standard
// recipes for each event. In addition, you can provide custom recipes for any
// or all layers and events. AWS OpsWorks runs custom event recipes after the
// standard recipes. LayerCustomRecipes specifies the custom recipes for a particular
// layer to be run in response to each of the five events.
//
// To specify a recipe, use the cookbook's directory name in the repository
// followed by two colons and the recipe name, which is the recipe's file name
// without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb
// recipe in the repository's phpapp2 folder.
type Recipes struct {
	// An array of custom recipe names to be run following a configure event.
	Configure []*string `type:"list"`

	// An array of custom recipe names to be run following a deploy event.
	Deploy []*string `type:"list"`

	// An array of custom recipe names to be run following a setup event.
	Setup []*string `type:"list"`

	// An array of custom recipe names to be run following a shutdown event.
	Shutdown []*string `type:"list"`

	// An array of custom recipe names to be run following a undeploy event.
	Undeploy []*string `type:"list"`

	metadataRecipes `json:"-" xml:"-"`
}

type metadataRecipes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Recipes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Recipes) GoString() string {
	return s.String()
}

type RegisterEcsClusterInput struct {
	// The cluster's ARN.
	EcsClusterArn *string `type:"string" required:"true"`

	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataRegisterEcsClusterInput `json:"-" xml:"-"`
}

type metadataRegisterEcsClusterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterEcsClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterEcsClusterInput) GoString() string {
	return s.String()
}

// Contains the response to a RegisterEcsCluster request.
type RegisterEcsClusterOutput struct {
	// The cluster's ARN.
	EcsClusterArn *string `type:"string"`

	metadataRegisterEcsClusterOutput `json:"-" xml:"-"`
}

type metadataRegisterEcsClusterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterEcsClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterEcsClusterOutput) GoString() string {
	return s.String()
}

type RegisterElasticIpInput struct {
	// The Elastic IP address.
	ElasticIp *string `type:"string" required:"true"`

	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataRegisterElasticIpInput `json:"-" xml:"-"`
}

type metadataRegisterElasticIpInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterElasticIpInput) GoString() string {
	return s.String()
}

// Contains the response to a RegisterElasticIp request.
type RegisterElasticIpOutput struct {
	// The Elastic IP address.
	ElasticIp *string `type:"string"`

	metadataRegisterElasticIpOutput `json:"-" xml:"-"`
}

type metadataRegisterElasticIpOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterElasticIpOutput) GoString() string {
	return s.String()
}

type RegisterInstanceInput struct {
	// The instance's hostname.
	Hostname *string `type:"string"`

	// An InstanceIdentity object that contains the instance's identity.
	InstanceIdentity *InstanceIdentity `type:"structure"`

	// The instance's private IP address.
	PrivateIp *string `type:"string"`

	// The instance's public IP address.
	PublicIp *string `type:"string"`

	// The instances public RSA key. This key is used to encrypt communication between
	// the instance and the service.
	RsaPublicKey *string `type:"string"`

	// The instances public RSA key fingerprint.
	RsaPublicKeyFingerprint *string `type:"string"`

	// The ID of the stack that the instance is to be registered with.
	StackId *string `type:"string" required:"true"`

	metadataRegisterInstanceInput `json:"-" xml:"-"`
}

type metadataRegisterInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstanceInput) GoString() string {
	return s.String()
}

// Contains the response to a RegisterInstanceResult request.
type RegisterInstanceOutput struct {
	// The registered instance's AWS OpsWorks ID.
	InstanceId *string `type:"string"`

	metadataRegisterInstanceOutput `json:"-" xml:"-"`
}

type metadataRegisterInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstanceOutput) GoString() string {
	return s.String()
}

type RegisterRdsDbInstanceInput struct {
	// The database password.
	DbPassword *string `type:"string" required:"true"`

	// The database's master user name.
	DbUser *string `type:"string" required:"true"`

	// The Amazon RDS instance's ARN.
	RdsDbInstanceArn *string `type:"string" required:"true"`

	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataRegisterRdsDbInstanceInput `json:"-" xml:"-"`
}

type metadataRegisterRdsDbInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterRdsDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterRdsDbInstanceInput) GoString() string {
	return s.String()
}

type RegisterRdsDbInstanceOutput struct {
	metadataRegisterRdsDbInstanceOutput `json:"-" xml:"-"`
}

type metadataRegisterRdsDbInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterRdsDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterRdsDbInstanceOutput) GoString() string {
	return s.String()
}

type RegisterVolumeInput struct {
	// The Amazon EBS volume ID.
	Ec2VolumeId *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataRegisterVolumeInput `json:"-" xml:"-"`
}

type metadataRegisterVolumeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterVolumeInput) GoString() string {
	return s.String()
}

// Contains the response to a RegisterVolume request.
type RegisterVolumeOutput struct {
	// The volume ID.
	VolumeId *string `type:"string"`

	metadataRegisterVolumeOutput `json:"-" xml:"-"`
}

type metadataRegisterVolumeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RegisterVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterVolumeOutput) GoString() string {
	return s.String()
}

// A registered instance's reported operating system.
type ReportedOs struct {
	// The operating system family.
	Family *string `type:"string"`

	// The operating system name.
	Name *string `type:"string"`

	// The operating system version.
	Version *string `type:"string"`

	metadataReportedOs `json:"-" xml:"-"`
}

type metadataReportedOs struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReportedOs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportedOs) GoString() string {
	return s.String()
}

// Describes a user's SSH information.
type SelfUserProfile struct {
	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	// The user's name.
	Name *string `type:"string"`

	// The user's SSH public key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name.
	SshUsername *string `type:"string"`

	metadataSelfUserProfile `json:"-" xml:"-"`
}

type metadataSelfUserProfile struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SelfUserProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelfUserProfile) GoString() string {
	return s.String()
}

// Describes an AWS OpsWorks service error.
type ServiceError struct {
	// When the error occurred.
	CreatedAt *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// A message that describes the error.
	Message *string `type:"string"`

	// The error ID.
	ServiceErrorId *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	// The error type.
	Type *string `type:"string"`

	metadataServiceError `json:"-" xml:"-"`
}

type metadataServiceError struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceError) GoString() string {
	return s.String()
}

type SetLoadBasedAutoScalingInput struct {
	// An AutoScalingThresholds object with the downscaling threshold configuration.
	// If the load falls below these thresholds for a specified amount of time,
	// AWS OpsWorks stops a specified number of instances.
	DownScaling *AutoScalingThresholds `type:"structure"`

	// Enables load-based auto scaling for the layer.
	Enable *bool `type:"boolean"`

	// The layer ID.
	LayerId *string `type:"string" required:"true"`

	// An AutoScalingThresholds object with the upscaling threshold configuration.
	// If the load exceeds these thresholds for a specified amount of time, AWS
	// OpsWorks starts a specified number of instances.
	UpScaling *AutoScalingThresholds `type:"structure"`

	metadataSetLoadBasedAutoScalingInput `json:"-" xml:"-"`
}

type metadataSetLoadBasedAutoScalingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetLoadBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBasedAutoScalingInput) GoString() string {
	return s.String()
}

type SetLoadBasedAutoScalingOutput struct {
	metadataSetLoadBasedAutoScalingOutput `json:"-" xml:"-"`
}

type metadataSetLoadBasedAutoScalingOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetLoadBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBasedAutoScalingOutput) GoString() string {
	return s.String()
}

type SetPermissionInput struct {
	// The user is allowed to use SSH to communicate with the instance.
	AllowSsh *bool `type:"boolean"`

	// The user is allowed to use sudo to elevate privileges.
	AllowSudo *bool `type:"boolean"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string" required:"true"`

	// The user's permission level, which must be set to one of the following strings.
	// You cannot set your own permissions level.
	//
	//   deny   show   deploy   manage   iam_only   For more information on the
	// permissions associated with these levels, see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
	Level *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataSetPermissionInput `json:"-" xml:"-"`
}

type metadataSetPermissionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetPermissionInput) GoString() string {
	return s.String()
}

type SetPermissionOutput struct {
	metadataSetPermissionOutput `json:"-" xml:"-"`
}

type metadataSetPermissionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetPermissionOutput) GoString() string {
	return s.String()
}

type SetTimeBasedAutoScalingInput struct {
	// An AutoScalingSchedule with the instance schedule.
	AutoScalingSchedule *WeeklyAutoScalingSchedule `type:"structure"`

	// The instance ID.
	InstanceId *string `type:"string" required:"true"`

	metadataSetTimeBasedAutoScalingInput `json:"-" xml:"-"`
}

type metadataSetTimeBasedAutoScalingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetTimeBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTimeBasedAutoScalingInput) GoString() string {
	return s.String()
}

type SetTimeBasedAutoScalingOutput struct {
	metadataSetTimeBasedAutoScalingOutput `json:"-" xml:"-"`
}

type metadataSetTimeBasedAutoScalingOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetTimeBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTimeBasedAutoScalingOutput) GoString() string {
	return s.String()
}

// The Shutdown event configuration.
type ShutdownEventConfiguration struct {
	// Whether to enable Elastic Load Balancing connection draining. For more information,
	// see Connection Draining (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain)
	DelayUntilElbConnectionsDrained *bool `type:"boolean"`

	// The time, in seconds, that AWS OpsWorks will wait after triggering a Shutdown
	// event before shutting down an instance.
	ExecutionTimeout *int64 `type:"integer"`

	metadataShutdownEventConfiguration `json:"-" xml:"-"`
}

type metadataShutdownEventConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ShutdownEventConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownEventConfiguration) GoString() string {
	return s.String()
}

// Contains the information required to retrieve an app or cookbook from a repository.
// For more information, see Creating Apps (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
// or Custom Recipes and Cookbooks (http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
type Source struct {
	// When included in a request, the parameter depends on the repository type.
	//
	//  For Amazon S3 bundles, set Password to the appropriate IAM secret access
	// key. For HTTP bundles and Subversion repositories, set Password to the password.
	//  For more information on how to safely handle IAM credentials, see .
	//
	// In responses, AWS OpsWorks returns *****FILTERED***** instead of the actual
	// value.
	Password *string `type:"string"`

	// The application's version. AWS OpsWorks enables you to easily deploy new
	// versions of an application. One of the simplest approaches is to have branches
	// or revisions in your repository that represent different versions that can
	// potentially be deployed.
	Revision *string `type:"string"`

	// In requests, the repository's SSH key.
	//
	// In responses, AWS OpsWorks returns *****FILTERED***** instead of the actual
	// value.
	SshKey *string `type:"string"`

	// The repository type.
	Type *string `type:"string" enum:"SourceType"`

	// The source URL.
	Url *string `type:"string"`

	// This parameter depends on the repository type.
	//
	//  For Amazon S3 bundles, set Username to the appropriate IAM access key ID.
	// For HTTP bundles, Git repositories, and Subversion repositories, set Username
	// to the user name.
	Username *string `type:"string"`

	metadataSource `json:"-" xml:"-"`
}

type metadataSource struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Source) GoString() string {
	return s.String()
}

// Describes an app's SSL configuration.
type SslConfiguration struct {
	// The contents of the certificate's domain.crt file.
	Certificate *string `type:"string" required:"true"`

	// Optional. Can be used to specify an intermediate certificate authority key
	// or client authentication.
	Chain *string `type:"string"`

	// The private key; the contents of the certificate's domain.kex file.
	PrivateKey *string `type:"string" required:"true"`

	metadataSslConfiguration `json:"-" xml:"-"`
}

type metadataSslConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SslConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SslConfiguration) GoString() string {
	return s.String()
}

// Describes a stack.
type Stack struct {
	// The agent version. This parameter is set to LATEST for auto-update. or a
	// version number for a fixed agent version.
	AgentVersion *string `type:"string"`

	// The stack's ARN.
	Arn *string `type:"string"`

	// The stack's attributes.
	Attributes map[string]*string `type:"map"`

	// A ChefConfiguration object that specifies whether to enable Berkshelf and
	// the Berkshelf version. For more information, see Create a New Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	ChefConfiguration *ChefConfiguration `type:"structure"`

	// The configuration manager.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// The date when the stack was created.
	CreatedAt *string `type:"string"`

	// Contains the information required to retrieve an app or cookbook from a repository.
	// For more information, see Creating Apps (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
	// or Custom Recipes and Cookbooks (http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
	CustomCookbooksSource *Source `type:"structure"`

	// A JSON object that contains user-defined attributes to be added to the stack
	// configuration and deployment attributes. You can use custom JSON to override
	// the corresponding default stack configuration attribute values or to pass
	// data to recipes. The string should be in the following format and must escape
	// characters such as '"':
	//
	//  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The stack's default Availability Zone. For more information, see Regions
	// and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	DefaultAvailabilityZone *string `type:"string"`

	// The ARN of an IAM profile that is the default profile for all of the stack's
	// EC2 instances. For more information about IAM ARNs, see Using Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	DefaultInstanceProfileArn *string `type:"string"`

	// The stack's default operating system.
	DefaultOs *string `type:"string"`

	// The default root device type. This value is used by default for all instances
	// in the stack, but you can override it when you create an instance. For more
	// information, see Storage for the Root Device (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	DefaultRootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// A default Amazon EC2 key pair for the stack's instances. You can override
	// this value when you create or update an instance.
	DefaultSshKeyName *string `type:"string"`

	// The default subnet ID; applicable only if the stack is running in a VPC.
	DefaultSubnetId *string `type:"string"`

	// The stack host name theme, with spaces replaced by underscores.
	HostnameTheme *string `type:"string"`

	// The stack name.
	Name *string `type:"string"`

	// The stack AWS region, such as "us-east-1". For more information about AWS
	// regions, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`

	// The stack AWS Identity and Access Management (IAM) role.
	ServiceRoleArn *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	// Whether the stack uses custom cookbooks.
	UseCustomCookbooks *bool `type:"boolean"`

	// Whether the stack automatically associates the AWS OpsWorks built-in security
	// groups with the stack's layers.
	UseOpsworksSecurityGroups *bool `type:"boolean"`

	// The VPC ID; applicable only if the stack is running in a VPC.
	VpcId *string `type:"string"`

	metadataStack `json:"-" xml:"-"`
}

type metadataStack struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// Describes the configuration manager.
type StackConfigurationManager struct {
	// The name. This parameter must be set to "Chef".
	Name *string `type:"string"`

	// The Chef version. This parameter must be set to 0.9, 11.4, or 11.10. The
	// default value is 11.4.
	Version *string `type:"string"`

	metadataStackConfigurationManager `json:"-" xml:"-"`
}

type metadataStackConfigurationManager struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StackConfigurationManager) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackConfigurationManager) GoString() string {
	return s.String()
}

// Summarizes the number of layers, instances, and apps in a stack.
type StackSummary struct {
	// The number of apps.
	AppsCount *int64 `type:"integer"`

	// The stack's ARN.
	Arn *string `type:"string"`

	// An InstancesCount object with the number of instances in each status.
	InstancesCount *InstancesCount `type:"structure"`

	// The number of layers.
	LayersCount *int64 `type:"integer"`

	// The stack name.
	Name *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	metadataStackSummary `json:"-" xml:"-"`
}

type metadataStackSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSummary) GoString() string {
	return s.String()
}

type StartInstanceInput struct {
	// The instance ID.
	InstanceId *string `type:"string" required:"true"`

	metadataStartInstanceInput `json:"-" xml:"-"`
}

type metadataStartInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstanceInput) GoString() string {
	return s.String()
}

type StartInstanceOutput struct {
	metadataStartInstanceOutput `json:"-" xml:"-"`
}

type metadataStartInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstanceOutput) GoString() string {
	return s.String()
}

type StartStackInput struct {
	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataStartStackInput `json:"-" xml:"-"`
}

type metadataStartStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartStackInput) GoString() string {
	return s.String()
}

type StartStackOutput struct {
	metadataStartStackOutput `json:"-" xml:"-"`
}

type metadataStartStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartStackOutput) GoString() string {
	return s.String()
}

type StopInstanceInput struct {
	// The instance ID.
	InstanceId *string `type:"string" required:"true"`

	metadataStopInstanceInput `json:"-" xml:"-"`
}

type metadataStopInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StopInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstanceInput) GoString() string {
	return s.String()
}

type StopInstanceOutput struct {
	metadataStopInstanceOutput `json:"-" xml:"-"`
}

type metadataStopInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StopInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstanceOutput) GoString() string {
	return s.String()
}

type StopStackInput struct {
	// The stack ID.
	StackId *string `type:"string" required:"true"`

	metadataStopStackInput `json:"-" xml:"-"`
}

type metadataStopStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StopStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStackInput) GoString() string {
	return s.String()
}

type StopStackOutput struct {
	metadataStopStackOutput `json:"-" xml:"-"`
}

type metadataStopStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StopStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStackOutput) GoString() string {
	return s.String()
}

// Contains the data needed by RDP clients such as the Microsoft Remote Desktop
// Connection to log in to the instance.
type TemporaryCredential struct {
	// The instance's AWS OpsWorks ID.
	InstanceId *string `type:"string"`

	// The password.
	Password *string `type:"string"`

	// The user name.
	Username *string `type:"string"`

	// The length of time (in minutes) that the grant is valid. When the grant expires,
	// at the end of this period, the user will no longer be able to use the credentials
	// to log in. If they are logged in at the time, they will be automatically
	// logged out.
	ValidForInMinutes *int64 `type:"integer"`

	metadataTemporaryCredential `json:"-" xml:"-"`
}

type metadataTemporaryCredential struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TemporaryCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemporaryCredential) GoString() string {
	return s.String()
}

// Describes an instance's time-based auto scaling configuration.
type TimeBasedAutoScalingConfiguration struct {
	// A WeeklyAutoScalingSchedule object with the instance schedule.
	AutoScalingSchedule *WeeklyAutoScalingSchedule `type:"structure"`

	// The instance ID.
	InstanceId *string `type:"string"`

	metadataTimeBasedAutoScalingConfiguration `json:"-" xml:"-"`
}

type metadataTimeBasedAutoScalingConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TimeBasedAutoScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeBasedAutoScalingConfiguration) GoString() string {
	return s.String()
}

type UnassignInstanceInput struct {
	// The instance ID.
	InstanceId *string `type:"string" required:"true"`

	metadataUnassignInstanceInput `json:"-" xml:"-"`
}

type metadataUnassignInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UnassignInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignInstanceInput) GoString() string {
	return s.String()
}

type UnassignInstanceOutput struct {
	metadataUnassignInstanceOutput `json:"-" xml:"-"`
}

type metadataUnassignInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UnassignInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignInstanceOutput) GoString() string {
	return s.String()
}

type UnassignVolumeInput struct {
	// The volume ID.
	VolumeId *string `type:"string" required:"true"`

	metadataUnassignVolumeInput `json:"-" xml:"-"`
}

type metadataUnassignVolumeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UnassignVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignVolumeInput) GoString() string {
	return s.String()
}

type UnassignVolumeOutput struct {
	metadataUnassignVolumeOutput `json:"-" xml:"-"`
}

type metadataUnassignVolumeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UnassignVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignVolumeOutput) GoString() string {
	return s.String()
}

type UpdateAppInput struct {
	// The app ID.
	AppId *string `type:"string" required:"true"`

	// A Source object that specifies the app repository.
	AppSource *Source `type:"structure"`

	// One or more user-defined key/value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// The app's data sources.
	DataSources []*DataSource `type:"list"`

	// A description of the app.
	Description *string `type:"string"`

	// The app's virtual host settings, with multiple domains separated by commas.
	// For example: 'www.example.com, example.com'
	Domains []*string `type:"list"`

	// Whether SSL is enabled for the app.
	EnableSsl *bool `type:"boolean"`

	// An array of EnvironmentVariable objects that specify environment variables
	// to be associated with the app. After you deploy the app, these variables
	// are defined on the associated app server instances.For more information,
	// see  Environment Variables (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
	//
	//  There is no specific limit on the number of environment variables. However,
	// the size of the associated data structure - which includes the variables'
	// names, values, and protected flag values - cannot exceed 10 KB (10240 Bytes).
	// This limit should accommodate most if not all use cases. Exceeding it will
	// cause an exception with the message, "Environment: is too large (maximum
	// is 10KB)."
	//
	// This parameter is supported only by Chef 11.10 stacks. If you have specified
	// one or more environment variables, you cannot modify the stack's Chef version.
	Environment []*EnvironmentVariable `type:"list"`

	// The app name.
	Name *string `type:"string"`

	// An SslConfiguration object with the SSL configuration.
	SslConfiguration *SslConfiguration `type:"structure"`

	// The app type.
	Type *string `type:"string" enum:"AppType"`

	metadataUpdateAppInput `json:"-" xml:"-"`
}

type metadataUpdateAppInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAppInput) GoString() string {
	return s.String()
}

type UpdateAppOutput struct {
	metadataUpdateAppOutput `json:"-" xml:"-"`
}

type metadataUpdateAppOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAppOutput) GoString() string {
	return s.String()
}

type UpdateElasticIpInput struct {
	// The address.
	ElasticIp *string `type:"string" required:"true"`

	// The new name.
	Name *string `type:"string"`

	metadataUpdateElasticIpInput `json:"-" xml:"-"`
}

type metadataUpdateElasticIpInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticIpInput) GoString() string {
	return s.String()
}

type UpdateElasticIpOutput struct {
	metadataUpdateElasticIpOutput `json:"-" xml:"-"`
}

type metadataUpdateElasticIpOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticIpOutput) GoString() string {
	return s.String()
}

type UpdateInstanceInput struct {
	// The default AWS OpsWorks agent version. You have the following options:
	//
	//   INHERIT - Use the stack's default agent version setting.  version_number
	// - Use the specified agent version. This value overrides the stack's default
	// setting. To update the agent version, you must edit the instance configuration
	// and specify a new version. AWS OpsWorks then automatically installs that
	// version on the instance.  The default setting is INHERIT. To specify an agent
	// version, you must use the complete version number, not the abbreviated number
	// shown on the console. For a list of available agent version numbers, call
	// DescribeAgentVersions.
	AgentVersion *string `type:"string"`

	// A custom AMI ID to be used to create the instance. The AMI must be based
	// on one of the supported operating systems. For more information, see Instances
	// (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html)
	//
	// If you specify a custom AMI, you must set Os to Custom.
	AmiId *string `type:"string"`

	// The instance architecture. Instance types do not necessarily support both
	// architectures. For a list of the architectures that are supported by the
	// different instance types, see Instance Families and Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
	Architecture *string `type:"string" enum:"Architecture"`

	// For load-based or time-based instances, the type. Windows stacks can use
	// only time-based instances.
	AutoScalingType *string `type:"string" enum:"AutoScalingType"`

	// This property cannot be updated.
	EbsOptimized *bool `type:"boolean"`

	// The instance host name.
	Hostname *string `type:"string"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. To control when updates are installed,
	// set this value to false. You must then update your instances manually by
	// using CreateDeployment to run the update_dependencies stack command or by
	// manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.
	//
	//  We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The instance ID.
	InstanceId *string `type:"string" required:"true"`

	// The instance type, such as t2.micro. For a list of supported instance types,
	// open the stack in the console, choose Instances, and choose + Instance. The
	// Size list contains the currently supported types. For more information, see
	// Instance Families and Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
	// The parameter values that you use to specify the various types are in the
	// API Name column of the Available Instance Types table.
	InstanceType *string `type:"string"`

	// The instance's layer IDs.
	LayerIds []*string `type:"list"`

	// The instance's operating system, which must be set to one of the following.
	//
	//  A supported Linux operating system: An Amazon Linux version, such as Amazon
	// Linux 2015.03, Red Hat Enterprise Linux 7, Ubuntu 12.04 LTS, or Ubuntu 14.04
	// LTS.  Microsoft Windows Server 2012 R2 Base. A custom AMI: Custom.  For more
	// information on the supported operating systems, see AWS OpsWorks Operating
	// Systems (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	//
	// The default option is the current Amazon Linux version. If you set this
	// parameter to Custom, you must use the AmiId parameter to specify the custom
	// AMI that you want to use. For more information on the supported operating
	// systems, see Operating Systems (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	// For more information on how to use custom AMIs with OpsWorks, see Using Custom
	// AMIs (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//
	// You can specify a different Linux operating system for the updated stack,
	// but you cannot change from Linux to Windows or Windows to Linux.
	Os *string `type:"string"`

	// The instance's Amazon EC2 key name.
	SshKeyName *string `type:"string"`

	metadataUpdateInstanceInput `json:"-" xml:"-"`
}

type metadataUpdateInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInstanceInput) GoString() string {
	return s.String()
}

type UpdateInstanceOutput struct {
	metadataUpdateInstanceOutput `json:"-" xml:"-"`
}

type metadataUpdateInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInstanceOutput) GoString() string {
	return s.String()
}

type UpdateLayerInput struct {
	// One or more user-defined key/value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// Whether to automatically assign an Elastic IP address (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
	// to the layer's instances. For more information, see How to Edit a Layer (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignElasticIps *bool `type:"boolean"`

	// For stacks that are running in a VPC, whether to automatically assign a public
	// IP address to the layer's instances. For more information, see How to Edit
	// a Layer (http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignPublicIps *bool `type:"boolean"`

	// The ARN of an IAM profile to be used for all of the layer's EC2 instances.
	// For more information about IAM ARNs, see Using Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	CustomInstanceProfileArn *string `type:"string"`

	// A JSON-formatted string containing custom stack configuration and deployment
	// attributes to be installed on the layer's instances. For more information,
	// see  Using Custom JSON (http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
	CustomJson *string `type:"string"`

	// A LayerCustomRecipes object that specifies the layer's custom recipes.
	CustomRecipes *Recipes `type:"structure"`

	// An array containing the layer's custom security group IDs.
	CustomSecurityGroupIds []*string `type:"list"`

	// Whether to disable auto healing for the layer.
	EnableAutoHealing *bool `type:"boolean"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. To control when updates are installed,
	// set this value to false. You must then update your instances manually by
	// using CreateDeployment to run the update_dependencies stack command or manually
	// running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.
	//
	//  We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The layer ID.
	LayerId *string `type:"string" required:"true"`

	LifecycleEventConfiguration *LifecycleEventConfiguration `type:"structure"`

	// The layer name, which is used by the console.
	Name *string `type:"string"`

	// An array of Package objects that describe the layer's packages.
	Packages []*string `type:"list"`

	// For custom layers only, use this parameter to specify the layer's short name,
	// which is used internally by AWS OpsWorksand by Chef. The short name is also
	// used as the name for the directory where your app files are installed. It
	// can have a maximum of 200 characters and must be in the following format:
	// /\A[a-z0-9\-\_\.]+\Z/.
	//
	// The built-in layers' short names are defined by AWS OpsWorks. For more information,
	// see the Layer Reference (http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html)
	Shortname *string `type:"string"`

	// Whether to use Amazon EBS-optimized instances.
	UseEbsOptimizedInstances *bool `type:"boolean"`

	// A VolumeConfigurations object that describes the layer's Amazon EBS volumes.
	VolumeConfigurations []*VolumeConfiguration `type:"list"`

	metadataUpdateLayerInput `json:"-" xml:"-"`
}

type metadataUpdateLayerInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateLayerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLayerInput) GoString() string {
	return s.String()
}

type UpdateLayerOutput struct {
	metadataUpdateLayerOutput `json:"-" xml:"-"`
}

type metadataUpdateLayerOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateLayerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLayerOutput) GoString() string {
	return s.String()
}

type UpdateMyUserProfileInput struct {
	// The user's SSH public key.
	SshPublicKey *string `type:"string"`

	metadataUpdateMyUserProfileInput `json:"-" xml:"-"`
}

type metadataUpdateMyUserProfileInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateMyUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMyUserProfileInput) GoString() string {
	return s.String()
}

type UpdateMyUserProfileOutput struct {
	metadataUpdateMyUserProfileOutput `json:"-" xml:"-"`
}

type metadataUpdateMyUserProfileOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateMyUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMyUserProfileOutput) GoString() string {
	return s.String()
}

type UpdateRdsDbInstanceInput struct {
	// The database password.
	DbPassword *string `type:"string"`

	// The master user name.
	DbUser *string `type:"string"`

	// The Amazon RDS instance's ARN.
	RdsDbInstanceArn *string `type:"string" required:"true"`

	metadataUpdateRdsDbInstanceInput `json:"-" xml:"-"`
}

type metadataUpdateRdsDbInstanceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateRdsDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRdsDbInstanceInput) GoString() string {
	return s.String()
}

type UpdateRdsDbInstanceOutput struct {
	metadataUpdateRdsDbInstanceOutput `json:"-" xml:"-"`
}

type metadataUpdateRdsDbInstanceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateRdsDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRdsDbInstanceOutput) GoString() string {
	return s.String()
}

type UpdateStackInput struct {
	// The default AWS OpsWorks agent version. You have the following options:
	//
	//  Auto-update - Set this parameter to LATEST. AWS OpsWorks automatically
	// installs new agent versions on the stack's instances as soon as they are
	// available. Fixed version - Set this parameter to your preferred agent version.
	// To update the agent version, you must edit the stack configuration and specify
	// a new version. AWS OpsWorks then automatically installs that version on the
	// stack's instances.  The default setting is LATEST. To specify an agent version,
	// you must use the complete version number, not the abbreviated number shown
	// on the console. For a list of available agent version numbers, call DescribeAgentVersions.
	//
	// You can also specify an agent version when you create or update an instance,
	// which overrides the stack's default setting.
	AgentVersion *string `type:"string"`

	// One or more user-defined key-value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// A ChefConfiguration object that specifies whether to enable Berkshelf and
	// the Berkshelf version on Chef 11.10 stacks. For more information, see Create
	// a New Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	ChefConfiguration *ChefConfiguration `type:"structure"`

	// The configuration manager. When you clone a stack, we recommend that you
	// use the configuration manager to specify the Chef version: 0.9, 11.4, or
	// 11.10. The default value is currently 11.4.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// Contains the information required to retrieve an app or cookbook from a repository.
	// For more information, see Creating Apps (http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
	// or Custom Recipes and Cookbooks (http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
	CustomCookbooksSource *Source `type:"structure"`

	// A string that contains user-defined, custom JSON. It can be used to override
	// the corresponding default stack configuration JSON values or to pass data
	// to recipes. The string should be in the following format and escape characters
	// such as '"':
	//
	//  "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The stack's default Availability Zone, which must be in the stack's region.
	// For more information, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	// If you also specify a value for DefaultSubnetId, the subnet must be in the
	// same zone. For more information, see CreateStack.
	DefaultAvailabilityZone *string `type:"string"`

	// The ARN of an IAM profile that is the default profile for all of the stack's
	// EC2 instances. For more information about IAM ARNs, see Using Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	DefaultInstanceProfileArn *string `type:"string"`

	// The stack's operating system, which must be set to one of the following:
	//
	//  A supported Linux operating system: An Amazon Linux version, such as Amazon
	// Linux 2015.03, Red Hat Enterprise Linux 7, Ubuntu 12.04 LTS, or Ubuntu 14.04
	// LTS.  Microsoft Windows Server 2012 R2 Base. A custom AMI: Custom. You specify
	// the custom AMI you want to use when you create instances. For more information
	// on how to use custom AMIs with OpsWorks, see Using Custom AMIs (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//  The default option is the stack's current operating system. For more information
	// on the supported operating systems, see AWS OpsWorks Operating Systems (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	DefaultOs *string `type:"string"`

	// The default root device type. This value is used by default for all instances
	// in the stack, but you can override it when you create an instance. For more
	// information, see Storage for the Root Device (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	DefaultRootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// A default Amazon EC2 key-pair name. The default value is none. If you specify
	// a key-pair name, AWS OpsWorks installs the public key on the instance and
	// you can use the private key with an SSH client to log in to the instance.
	// For more information, see  Using SSH to Communicate with an Instance (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html)
	// and  Managing SSH Access (http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html).
	// You can override this setting by specifying a different key pair, or no key
	// pair, when you  create an instance (http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
	DefaultSshKeyName *string `type:"string"`

	// The stack's default VPC subnet ID. This parameter is required if you specify
	// a value for the VpcId parameter. All instances are launched into this subnet
	// unless you specify otherwise when you create the instance. If you also specify
	// a value for DefaultAvailabilityZone, the subnet must be in that zone. For
	// information on default values and when this parameter is required, see the
	// VpcId parameter description.
	DefaultSubnetId *string `type:"string"`

	// The stack's new host name theme, with spaces replaced by underscores. The
	// theme is used to generate host names for the stack's instances. By default,
	// HostnameTheme is set to Layer_Dependent, which creates host names by appending
	// integers to the layer's short name. The other themes are:
	//
	//   Baked_Goods   Clouds   Europe_Cities   Fruits   Greek_Deities   Legendary_creatures_from_Japan
	//   Planets_and_Moons   Roman_Deities   Scottish_Islands   US_Cities   Wild_Cats
	//   To obtain a generated host name, call GetHostNameSuggestion, which returns
	// a host name based on the current theme.
	HostnameTheme *string `type:"string"`

	// The stack's new name.
	Name *string `type:"string"`

	// Do not use this parameter. You cannot update a stack's service role.
	ServiceRoleArn *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string" required:"true"`

	// Whether the stack uses custom cookbooks.
	UseCustomCookbooks *bool `type:"boolean"`

	// Whether to associate the AWS OpsWorks built-in security groups with the stack's
	// layers.
	//
	// AWS OpsWorks provides a standard set of built-in security groups, one for
	// each layer, which are associated with layers by default. UseOpsworksSecurityGroups
	// allows you to provide your own custom security groups instead of using the
	// built-in groups. UseOpsworksSecurityGroups has the following settings:
	//
	//  True - AWS OpsWorks automatically associates the appropriate built-in security
	// group with each layer (default setting). You can associate additional security
	// groups with a layer after you create it, but you cannot delete the built-in
	// security group.  False - AWS OpsWorks does not associate built-in security
	// groups with layers. You must create appropriate EC2 security groups and associate
	// a security group with each layer that you create. However, you can still
	// manually associate a built-in security group with a layer on. Custom security
	// groups are required only for those layers that need custom settings.   For
	// more information, see Create a New Stack (http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	UseOpsworksSecurityGroups *bool `type:"boolean"`

	metadataUpdateStackInput `json:"-" xml:"-"`
}

type metadataUpdateStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

type UpdateStackOutput struct {
	metadataUpdateStackOutput `json:"-" xml:"-"`
}

type metadataUpdateStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

type UpdateUserProfileInput struct {
	// Whether users can specify their own SSH public key through the My Settings
	// page. For more information, see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
	AllowSelfManagement *bool `type:"boolean"`

	// The user IAM ARN.
	IamUserArn *string `type:"string" required:"true"`

	// The user's new SSH public key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9],
	// '-', and '_'. If the specified name includes other punctuation marks, AWS
	// OpsWorks removes them. For example, my.name will be changed to myname. If
	// you do not specify an SSH user name, AWS OpsWorks generates one from the
	// IAM user name.
	SshUsername *string `type:"string"`

	metadataUpdateUserProfileInput `json:"-" xml:"-"`
}

type metadataUpdateUserProfileInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserProfileInput) GoString() string {
	return s.String()
}

type UpdateUserProfileOutput struct {
	metadataUpdateUserProfileOutput `json:"-" xml:"-"`
}

type metadataUpdateUserProfileOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserProfileOutput) GoString() string {
	return s.String()
}

type UpdateVolumeInput struct {
	// The new mount point.
	MountPoint *string `type:"string"`

	// The new name.
	Name *string `type:"string"`

	// The volume ID.
	VolumeId *string `type:"string" required:"true"`

	metadataUpdateVolumeInput `json:"-" xml:"-"`
}

type metadataUpdateVolumeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVolumeInput) GoString() string {
	return s.String()
}

type UpdateVolumeOutput struct {
	metadataUpdateVolumeOutput `json:"-" xml:"-"`
}

type metadataUpdateVolumeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVolumeOutput) GoString() string {
	return s.String()
}

// Describes a user's SSH information.
type UserProfile struct {
	// Whether users can specify their own SSH public key through the My Settings
	// page. For more information, see Managing User Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
	AllowSelfManagement *bool `type:"boolean"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	// The user's name.
	Name *string `type:"string"`

	// The user's SSH public key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name.
	SshUsername *string `type:"string"`

	metadataUserProfile `json:"-" xml:"-"`
}

type metadataUserProfile struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UserProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserProfile) GoString() string {
	return s.String()
}

// Describes an instance's Amazon EBS volume.
type Volume struct {
	// The volume Availability Zone. For more information, see Regions and Endpoints
	// (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// The device name.
	Device *string `type:"string"`

	// The Amazon EC2 volume ID.
	Ec2VolumeId *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// For PIOPS volumes, the IOPS per disk.
	Iops *int64 `type:"integer"`

	// The volume mount point. For example "/dev/sdh".
	MountPoint *string `type:"string"`

	// The volume name.
	Name *string `type:"string"`

	// The RAID array ID.
	RaidArrayId *string `type:"string"`

	// The AWS region. For more information about AWS regions, see Regions and Endpoints
	// (http://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`

	// The volume size.
	Size *int64 `type:"integer"`

	// The value returned by DescribeVolumes (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html).
	Status *string `type:"string"`

	// The volume ID.
	VolumeId *string `type:"string"`

	// The volume type, standard or PIOPS.
	VolumeType *string `type:"string"`

	metadataVolume `json:"-" xml:"-"`
}

type metadataVolume struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Volume) GoString() string {
	return s.String()
}

// Describes an Amazon EBS volume configuration.
type VolumeConfiguration struct {
	// For PIOPS volumes, the IOPS per disk.
	Iops *int64 `type:"integer"`

	// The volume mount point. For example "/dev/sdh".
	MountPoint *string `type:"string" required:"true"`

	// The number of disks in the volume.
	NumberOfDisks *int64 `type:"integer" required:"true"`

	// The volume RAID level (http://en.wikipedia.org/wiki/Standard_RAID_levels).
	RaidLevel *int64 `type:"integer"`

	// The volume size.
	Size *int64 `type:"integer" required:"true"`

	// The volume type:
	//
	//   standard - Magnetic  io1 - Provisioned IOPS (SSD)  gp2 - General Purpose
	// (SSD)
	VolumeType *string `type:"string"`

	metadataVolumeConfiguration `json:"-" xml:"-"`
}

type metadataVolumeConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VolumeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeConfiguration) GoString() string {
	return s.String()
}

// Describes a time-based instance's auto scaling schedule. The schedule consists
// of a set of key-value pairs.
//
//  The key is the time period (a UTC hour) and must be an integer from 0 -
// 23. The value indicates whether the instance should be online or offline
// for the specified period, and must be set to "on" or "off"  The default setting
// for all time periods is off, so you use the following parameters primarily
// to specify the online periods. You don't have to explicitly specify offline
// periods unless you want to change an online period to an offline period.
//
// The following example specifies that the instance should be online for four
// hours, from UTC 1200 - 1600. It will be off for the remainder of the day.
//
//   { "12":"on", "13":"on", "14":"on", "15":"on" }
type WeeklyAutoScalingSchedule struct {
	// The schedule for Friday.
	Friday map[string]*string `type:"map"`

	// The schedule for Monday.
	Monday map[string]*string `type:"map"`

	// The schedule for Saturday.
	Saturday map[string]*string `type:"map"`

	// The schedule for Sunday.
	Sunday map[string]*string `type:"map"`

	// The schedule for Thursday.
	Thursday map[string]*string `type:"map"`

	// The schedule for Tuesday.
	Tuesday map[string]*string `type:"map"`

	// The schedule for Wednesday.
	Wednesday map[string]*string `type:"map"`

	metadataWeeklyAutoScalingSchedule `json:"-" xml:"-"`
}

type metadataWeeklyAutoScalingSchedule struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s WeeklyAutoScalingSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WeeklyAutoScalingSchedule) GoString() string {
	return s.String()
}

const (
	// @enum AppAttributesKeys
	AppAttributesKeysDocumentRoot = "DocumentRoot"
	// @enum AppAttributesKeys
	AppAttributesKeysRailsEnv = "RailsEnv"
	// @enum AppAttributesKeys
	AppAttributesKeysAutoBundleOnDeploy = "AutoBundleOnDeploy"
	// @enum AppAttributesKeys
	AppAttributesKeysAwsFlowRubySettings = "AwsFlowRubySettings"
)

const (
	// @enum AppType
	AppTypeAwsFlowRuby = "aws-flow-ruby"
	// @enum AppType
	AppTypeJava = "java"
	// @enum AppType
	AppTypeRails = "rails"
	// @enum AppType
	AppTypePhp = "php"
	// @enum AppType
	AppTypeNodejs = "nodejs"
	// @enum AppType
	AppTypeStatic = "static"
	// @enum AppType
	AppTypeOther = "other"
)

const (
	// @enum Architecture
	ArchitectureX8664 = "x86_64"
	// @enum Architecture
	ArchitectureI386 = "i386"
)

const (
	// @enum AutoScalingType
	AutoScalingTypeLoad = "load"
	// @enum AutoScalingType
	AutoScalingTypeTimer = "timer"
)

const (
	// @enum DeploymentCommandName
	DeploymentCommandNameInstallDependencies = "install_dependencies"
	// @enum DeploymentCommandName
	DeploymentCommandNameUpdateDependencies = "update_dependencies"
	// @enum DeploymentCommandName
	DeploymentCommandNameUpdateCustomCookbooks = "update_custom_cookbooks"
	// @enum DeploymentCommandName
	DeploymentCommandNameExecuteRecipes = "execute_recipes"
	// @enum DeploymentCommandName
	DeploymentCommandNameConfigure = "configure"
	// @enum DeploymentCommandName
	DeploymentCommandNameSetup = "setup"
	// @enum DeploymentCommandName
	DeploymentCommandNameDeploy = "deploy"
	// @enum DeploymentCommandName
	DeploymentCommandNameRollback = "rollback"
	// @enum DeploymentCommandName
	DeploymentCommandNameStart = "start"
	// @enum DeploymentCommandName
	DeploymentCommandNameStop = "stop"
	// @enum DeploymentCommandName
	DeploymentCommandNameRestart = "restart"
	// @enum DeploymentCommandName
	DeploymentCommandNameUndeploy = "undeploy"
)

const (
	// @enum LayerAttributesKeys
	LayerAttributesKeysEcsClusterArn = "EcsClusterArn"
	// @enum LayerAttributesKeys
	LayerAttributesKeysEnableHaproxyStats = "EnableHaproxyStats"
	// @enum LayerAttributesKeys
	LayerAttributesKeysHaproxyStatsUrl = "HaproxyStatsUrl"
	// @enum LayerAttributesKeys
	LayerAttributesKeysHaproxyStatsUser = "HaproxyStatsUser"
	// @enum LayerAttributesKeys
	LayerAttributesKeysHaproxyStatsPassword = "HaproxyStatsPassword"
	// @enum LayerAttributesKeys
	LayerAttributesKeysHaproxyHealthCheckUrl = "HaproxyHealthCheckUrl"
	// @enum LayerAttributesKeys
	LayerAttributesKeysHaproxyHealthCheckMethod = "HaproxyHealthCheckMethod"
	// @enum LayerAttributesKeys
	LayerAttributesKeysMysqlRootPassword = "MysqlRootPassword"
	// @enum LayerAttributesKeys
	LayerAttributesKeysMysqlRootPasswordUbiquitous = "MysqlRootPasswordUbiquitous"
	// @enum LayerAttributesKeys
	LayerAttributesKeysGangliaUrl = "GangliaUrl"
	// @enum LayerAttributesKeys
	LayerAttributesKeysGangliaUser = "GangliaUser"
	// @enum LayerAttributesKeys
	LayerAttributesKeysGangliaPassword = "GangliaPassword"
	// @enum LayerAttributesKeys
	LayerAttributesKeysMemcachedMemory = "MemcachedMemory"
	// @enum LayerAttributesKeys
	LayerAttributesKeysNodejsVersion = "NodejsVersion"
	// @enum LayerAttributesKeys
	LayerAttributesKeysRubyVersion = "RubyVersion"
	// @enum LayerAttributesKeys
	LayerAttributesKeysRubygemsVersion = "RubygemsVersion"
	// @enum LayerAttributesKeys
	LayerAttributesKeysManageBundler = "ManageBundler"
	// @enum LayerAttributesKeys
	LayerAttributesKeysBundlerVersion = "BundlerVersion"
	// @enum LayerAttributesKeys
	LayerAttributesKeysRailsStack = "RailsStack"
	// @enum LayerAttributesKeys
	LayerAttributesKeysPassengerVersion = "PassengerVersion"
	// @enum LayerAttributesKeys
	LayerAttributesKeysJvm = "Jvm"
	// @enum LayerAttributesKeys
	LayerAttributesKeysJvmVersion = "JvmVersion"
	// @enum LayerAttributesKeys
	LayerAttributesKeysJvmOptions = "JvmOptions"
	// @enum LayerAttributesKeys
	LayerAttributesKeysJavaAppServer = "JavaAppServer"
	// @enum LayerAttributesKeys
	LayerAttributesKeysJavaAppServerVersion = "JavaAppServerVersion"
)

const (
	// @enum LayerType
	LayerTypeAwsFlowRuby = "aws-flow-ruby"
	// @enum LayerType
	LayerTypeEcsCluster = "ecs-cluster"
	// @enum LayerType
	LayerTypeJavaApp = "java-app"
	// @enum LayerType
	LayerTypeLb = "lb"
	// @enum LayerType
	LayerTypeWeb = "web"
	// @enum LayerType
	LayerTypePhpApp = "php-app"
	// @enum LayerType
	LayerTypeRailsApp = "rails-app"
	// @enum LayerType
	LayerTypeNodejsApp = "nodejs-app"
	// @enum LayerType
	LayerTypeMemcached = "memcached"
	// @enum LayerType
	LayerTypeDbMaster = "db-master"
	// @enum LayerType
	LayerTypeMonitoringMaster = "monitoring-master"
	// @enum LayerType
	LayerTypeCustom = "custom"
)

const (
	// @enum RootDeviceType
	RootDeviceTypeEbs = "ebs"
	// @enum RootDeviceType
	RootDeviceTypeInstanceStore = "instance-store"
)

const (
	// @enum SourceType
	SourceTypeGit = "git"
	// @enum SourceType
	SourceTypeSvn = "svn"
	// @enum SourceType
	SourceTypeArchive = "archive"
	// @enum SourceType
	SourceTypeS3 = "s3"
)

const (
	// @enum StackAttributesKeys
	StackAttributesKeysColor = "Color"
)

const (
	// @enum VirtualizationType
	VirtualizationTypeParavirtual = "paravirtual"
	// @enum VirtualizationType
	VirtualizationTypeHvm = "hvm"
)

const (
	// @enum VolumeType
	VolumeTypeGp2 = "gp2"
	// @enum VolumeType
	VolumeTypeIo1 = "io1"
	// @enum VolumeType
	VolumeTypeStandard = "standard"
)
