// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package ses provides a client for Amazon Simple Email Service.
package ses

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCloneReceiptRuleSet = "CloneReceiptRuleSet"

// CloneReceiptRuleSetRequest generates a request for the CloneReceiptRuleSet operation.
func (c *SES) CloneReceiptRuleSetRequest(input *CloneReceiptRuleSetInput) (req *request.Request, output *CloneReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opCloneReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloneReceiptRuleSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CloneReceiptRuleSetOutput{}
	req.Data = output
	return
}

// Creates a receipt rule set by cloning an existing one. All receipt rules
// and configurations are copied to the new receipt rule set and are completely
// independent of the source rule set.
//
// For information about setting up rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
//
// This action is throttled at one request per second.
func (c *SES) CloneReceiptRuleSet(input *CloneReceiptRuleSetInput) (*CloneReceiptRuleSetOutput, error) {
	req, out := c.CloneReceiptRuleSetRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReceiptFilter = "CreateReceiptFilter"

// CreateReceiptFilterRequest generates a request for the CreateReceiptFilter operation.
func (c *SES) CreateReceiptFilterRequest(input *CreateReceiptFilterInput) (req *request.Request, output *CreateReceiptFilterOutput) {
	op := &request.Operation{
		Name:       opCreateReceiptFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReceiptFilterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReceiptFilterOutput{}
	req.Data = output
	return
}

// Creates a new IP address filter.
//
// For information about setting up IP address filters, see the Amazon SES
// Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html).
//
// This action is throttled at one request per second.
func (c *SES) CreateReceiptFilter(input *CreateReceiptFilterInput) (*CreateReceiptFilterOutput, error) {
	req, out := c.CreateReceiptFilterRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReceiptRule = "CreateReceiptRule"

// CreateReceiptRuleRequest generates a request for the CreateReceiptRule operation.
func (c *SES) CreateReceiptRuleRequest(input *CreateReceiptRuleInput) (req *request.Request, output *CreateReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opCreateReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReceiptRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReceiptRuleOutput{}
	req.Data = output
	return
}

// Creates a receipt rule.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
//
// This action is throttled at one request per second.
func (c *SES) CreateReceiptRule(input *CreateReceiptRuleInput) (*CreateReceiptRuleOutput, error) {
	req, out := c.CreateReceiptRuleRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReceiptRuleSet = "CreateReceiptRuleSet"

// CreateReceiptRuleSetRequest generates a request for the CreateReceiptRuleSet operation.
func (c *SES) CreateReceiptRuleSetRequest(input *CreateReceiptRuleSetInput) (req *request.Request, output *CreateReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opCreateReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReceiptRuleSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReceiptRuleSetOutput{}
	req.Data = output
	return
}

// Creates an empty receipt rule set.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
//
// This action is throttled at one request per second.
func (c *SES) CreateReceiptRuleSet(input *CreateReceiptRuleSetInput) (*CreateReceiptRuleSetOutput, error) {
	req, out := c.CreateReceiptRuleSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIdentity = "DeleteIdentity"

// DeleteIdentityRequest generates a request for the DeleteIdentity operation.
func (c *SES) DeleteIdentityRequest(input *DeleteIdentityInput) (req *request.Request, output *DeleteIdentityOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIdentityOutput{}
	req.Data = output
	return
}

// Deletes the specified identity (email address or domain) from the list of
// verified identities.
//
// This action is throttled at one request per second.
func (c *SES) DeleteIdentity(input *DeleteIdentityInput) (*DeleteIdentityOutput, error) {
	req, out := c.DeleteIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteIdentityPolicy = "DeleteIdentityPolicy"

// DeleteIdentityPolicyRequest generates a request for the DeleteIdentityPolicy operation.
func (c *SES) DeleteIdentityPolicyRequest(input *DeleteIdentityPolicyInput) (req *request.Request, output *DeleteIdentityPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteIdentityPolicyOutput{}
	req.Data = output
	return
}

// Deletes the specified sending authorization policy for the given identity
// (email address or domain). This API returns successfully even if a policy
// with the specified name does not exist.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error. Sending authorization is a feature that enables
// an identity owner to authorize other senders to use its identities. For information
// about using sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
func (c *SES) DeleteIdentityPolicy(input *DeleteIdentityPolicyInput) (*DeleteIdentityPolicyOutput, error) {
	req, out := c.DeleteIdentityPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReceiptFilter = "DeleteReceiptFilter"

// DeleteReceiptFilterRequest generates a request for the DeleteReceiptFilter operation.
func (c *SES) DeleteReceiptFilterRequest(input *DeleteReceiptFilterInput) (req *request.Request, output *DeleteReceiptFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteReceiptFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptFilterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReceiptFilterOutput{}
	req.Data = output
	return
}

// Deletes the specified IP address filter.
//
// For information about managing IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html).
//
// This action is throttled at one request per second.
func (c *SES) DeleteReceiptFilter(input *DeleteReceiptFilterInput) (*DeleteReceiptFilterOutput, error) {
	req, out := c.DeleteReceiptFilterRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReceiptRule = "DeleteReceiptRule"

// DeleteReceiptRuleRequest generates a request for the DeleteReceiptRule operation.
func (c *SES) DeleteReceiptRuleRequest(input *DeleteReceiptRuleInput) (req *request.Request, output *DeleteReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReceiptRuleOutput{}
	req.Data = output
	return
}

// Deletes the specified receipt rule.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
//
// This action is throttled at one request per second.
func (c *SES) DeleteReceiptRule(input *DeleteReceiptRuleInput) (*DeleteReceiptRuleOutput, error) {
	req, out := c.DeleteReceiptRuleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReceiptRuleSet = "DeleteReceiptRuleSet"

// DeleteReceiptRuleSetRequest generates a request for the DeleteReceiptRuleSet operation.
func (c *SES) DeleteReceiptRuleSetRequest(input *DeleteReceiptRuleSetInput) (req *request.Request, output *DeleteReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opDeleteReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReceiptRuleSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReceiptRuleSetOutput{}
	req.Data = output
	return
}

// Deletes the specified receipt rule set and all of the receipt rules it contains.
//
// The currently active rule set cannot be deleted. For information about managing
// receipt rule sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
func (c *SES) DeleteReceiptRuleSet(input *DeleteReceiptRuleSetInput) (*DeleteReceiptRuleSetOutput, error) {
	req, out := c.DeleteReceiptRuleSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVerifiedEmailAddress = "DeleteVerifiedEmailAddress"

// DeleteVerifiedEmailAddressRequest generates a request for the DeleteVerifiedEmailAddress operation.
func (c *SES) DeleteVerifiedEmailAddressRequest(input *DeleteVerifiedEmailAddressInput) (req *request.Request, output *DeleteVerifiedEmailAddressOutput) {
	op := &request.Operation{
		Name:       opDeleteVerifiedEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVerifiedEmailAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVerifiedEmailAddressOutput{}
	req.Data = output
	return
}

// Deletes the specified email address from the list of verified addresses.
//
// The DeleteVerifiedEmailAddress action is deprecated as of the May 15, 2012
// release of Domain Verification. The DeleteIdentity action is now preferred.
// This action is throttled at one request per second.
func (c *SES) DeleteVerifiedEmailAddress(input *DeleteVerifiedEmailAddressInput) (*DeleteVerifiedEmailAddressOutput, error) {
	req, out := c.DeleteVerifiedEmailAddressRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeActiveReceiptRuleSet = "DescribeActiveReceiptRuleSet"

// DescribeActiveReceiptRuleSetRequest generates a request for the DescribeActiveReceiptRuleSet operation.
func (c *SES) DescribeActiveReceiptRuleSetRequest(input *DescribeActiveReceiptRuleSetInput) (req *request.Request, output *DescribeActiveReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opDescribeActiveReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeActiveReceiptRuleSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeActiveReceiptRuleSetOutput{}
	req.Data = output
	return
}

// Returns the metadata and receipt rules for the receipt rule set that is currently
// active.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
//
// This action is throttled at one request per second.
func (c *SES) DescribeActiveReceiptRuleSet(input *DescribeActiveReceiptRuleSetInput) (*DescribeActiveReceiptRuleSetOutput, error) {
	req, out := c.DescribeActiveReceiptRuleSetRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReceiptRule = "DescribeReceiptRule"

// DescribeReceiptRuleRequest generates a request for the DescribeReceiptRule operation.
func (c *SES) DescribeReceiptRuleRequest(input *DescribeReceiptRuleInput) (req *request.Request, output *DescribeReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReceiptRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReceiptRuleOutput{}
	req.Data = output
	return
}

// Returns the details of the specified receipt rule.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
//
// This action is throttled at one request per second.
func (c *SES) DescribeReceiptRule(input *DescribeReceiptRuleInput) (*DescribeReceiptRuleOutput, error) {
	req, out := c.DescribeReceiptRuleRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeReceiptRuleSet = "DescribeReceiptRuleSet"

// DescribeReceiptRuleSetRequest generates a request for the DescribeReceiptRuleSet operation.
func (c *SES) DescribeReceiptRuleSetRequest(input *DescribeReceiptRuleSetInput) (req *request.Request, output *DescribeReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opDescribeReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReceiptRuleSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeReceiptRuleSetOutput{}
	req.Data = output
	return
}

// Returns the details of the specified receipt rule set.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
func (c *SES) DescribeReceiptRuleSet(input *DescribeReceiptRuleSetInput) (*DescribeReceiptRuleSetOutput, error) {
	req, out := c.DescribeReceiptRuleSetRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityDkimAttributes = "GetIdentityDkimAttributes"

// GetIdentityDkimAttributesRequest generates a request for the GetIdentityDkimAttributes operation.
func (c *SES) GetIdentityDkimAttributesRequest(input *GetIdentityDkimAttributesInput) (req *request.Request, output *GetIdentityDkimAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityDkimAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityDkimAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityDkimAttributesOutput{}
	req.Data = output
	return
}

// Returns the current status of Easy DKIM signing for an entity. For domain
// name identities, this action also returns the DKIM tokens that are required
// for Easy DKIM signing, and whether Amazon SES has successfully verified that
// these tokens have been published.
//
// This action takes a list of identities as input and returns the following
// information for each:
//
//  Whether Easy DKIM signing is enabled or disabled. A set of DKIM tokens
// that represent the identity. If the identity is an email address, the tokens
// represent the domain of that address. Whether Amazon SES has successfully
// verified the DKIM tokens published in the domain's DNS. This information
// is only returned for domain name identities, not for email addresses.  This
// action is throttled at one request per second and can only get DKIM attributes
// for up to 100 identities at a time.
//
// For more information about creating DNS records using DKIM tokens, go to
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
func (c *SES) GetIdentityDkimAttributes(input *GetIdentityDkimAttributesInput) (*GetIdentityDkimAttributesOutput, error) {
	req, out := c.GetIdentityDkimAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityNotificationAttributes = "GetIdentityNotificationAttributes"

// GetIdentityNotificationAttributesRequest generates a request for the GetIdentityNotificationAttributes operation.
func (c *SES) GetIdentityNotificationAttributesRequest(input *GetIdentityNotificationAttributesInput) (req *request.Request, output *GetIdentityNotificationAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityNotificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityNotificationAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityNotificationAttributesOutput{}
	req.Data = output
	return
}

// Given a list of verified identities (email addresses and/or domains), returns
// a structure describing identity notification attributes.
//
// This action is throttled at one request per second and can only get notification
// attributes for up to 100 identities at a time.
//
// For more information about using notifications with Amazon SES, see the
// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
func (c *SES) GetIdentityNotificationAttributes(input *GetIdentityNotificationAttributesInput) (*GetIdentityNotificationAttributesOutput, error) {
	req, out := c.GetIdentityNotificationAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityPolicies = "GetIdentityPolicies"

// GetIdentityPoliciesRequest generates a request for the GetIdentityPolicies operation.
func (c *SES) GetIdentityPoliciesRequest(input *GetIdentityPoliciesInput) (req *request.Request, output *GetIdentityPoliciesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityPoliciesOutput{}
	req.Data = output
	return
}

// Returns the requested sending authorization policies for the given identity
// (email address or domain). The policies are returned as a map of policy names
// to policy contents. You can retrieve a maximum of 20 policies at a time.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error. Sending authorization is a feature that enables
// an identity owner to authorize other senders to use its identities. For information
// about using sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
func (c *SES) GetIdentityPolicies(input *GetIdentityPoliciesInput) (*GetIdentityPoliciesOutput, error) {
	req, out := c.GetIdentityPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opGetIdentityVerificationAttributes = "GetIdentityVerificationAttributes"

// GetIdentityVerificationAttributesRequest generates a request for the GetIdentityVerificationAttributes operation.
func (c *SES) GetIdentityVerificationAttributesRequest(input *GetIdentityVerificationAttributesInput) (req *request.Request, output *GetIdentityVerificationAttributesOutput) {
	op := &request.Operation{
		Name:       opGetIdentityVerificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityVerificationAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetIdentityVerificationAttributesOutput{}
	req.Data = output
	return
}

// Given a list of identities (email addresses and/or domains), returns the
// verification status and (for domain identities) the verification token for
// each identity.
//
// This action is throttled at one request per second and can only get verification
// attributes for up to 100 identities at a time.
func (c *SES) GetIdentityVerificationAttributes(input *GetIdentityVerificationAttributesInput) (*GetIdentityVerificationAttributesOutput, error) {
	req, out := c.GetIdentityVerificationAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetSendQuota = "GetSendQuota"

// GetSendQuotaRequest generates a request for the GetSendQuota operation.
func (c *SES) GetSendQuotaRequest(input *GetSendQuotaInput) (req *request.Request, output *GetSendQuotaOutput) {
	op := &request.Operation{
		Name:       opGetSendQuota,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSendQuotaInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSendQuotaOutput{}
	req.Data = output
	return
}

// Returns the user's current sending limits.
//
// This action is throttled at one request per second.
func (c *SES) GetSendQuota(input *GetSendQuotaInput) (*GetSendQuotaOutput, error) {
	req, out := c.GetSendQuotaRequest(input)
	err := req.Send()
	return out, err
}

const opGetSendStatistics = "GetSendStatistics"

// GetSendStatisticsRequest generates a request for the GetSendStatistics operation.
func (c *SES) GetSendStatisticsRequest(input *GetSendStatisticsInput) (req *request.Request, output *GetSendStatisticsOutput) {
	op := &request.Operation{
		Name:       opGetSendStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSendStatisticsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSendStatisticsOutput{}
	req.Data = output
	return
}

// Returns the user's sending statistics. The result is a list of data points,
// representing the last two weeks of sending activity.
//
// Each data point in the list contains statistics for a 15-minute interval.
//
// This action is throttled at one request per second.
func (c *SES) GetSendStatistics(input *GetSendStatisticsInput) (*GetSendStatisticsOutput, error) {
	req, out := c.GetSendStatisticsRequest(input)
	err := req.Send()
	return out, err
}

const opListIdentities = "ListIdentities"

// ListIdentitiesRequest generates a request for the ListIdentities operation.
func (c *SES) ListIdentitiesRequest(input *ListIdentitiesInput) (req *request.Request, output *ListIdentitiesOutput) {
	op := &request.Operation{
		Name:       opListIdentities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentitiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListIdentitiesOutput{}
	req.Data = output
	return
}

// Returns a list containing all of the identities (email addresses and domains)
// for a specific AWS Account, regardless of verification status.
//
// This action is throttled at one request per second.
func (c *SES) ListIdentities(input *ListIdentitiesInput) (*ListIdentitiesOutput, error) {
	req, out := c.ListIdentitiesRequest(input)
	err := req.Send()
	return out, err
}

func (c *SES) ListIdentitiesPages(input *ListIdentitiesInput, fn func(p *ListIdentitiesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListIdentitiesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListIdentitiesOutput), lastPage)
	})
}

const opListIdentityPolicies = "ListIdentityPolicies"

// ListIdentityPoliciesRequest generates a request for the ListIdentityPolicies operation.
func (c *SES) ListIdentityPoliciesRequest(input *ListIdentityPoliciesInput) (req *request.Request, output *ListIdentityPoliciesOutput) {
	op := &request.Operation{
		Name:       opListIdentityPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIdentityPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListIdentityPoliciesOutput{}
	req.Data = output
	return
}

// Returns a list of sending authorization policies that are attached to the
// given identity (email address or domain). This API returns only a list. If
// you want the actual policy content, you can use GetIdentityPolicies.
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error. Sending authorization is a feature that enables
// an identity owner to authorize other senders to use its identities. For information
// about using sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
func (c *SES) ListIdentityPolicies(input *ListIdentityPoliciesInput) (*ListIdentityPoliciesOutput, error) {
	req, out := c.ListIdentityPoliciesRequest(input)
	err := req.Send()
	return out, err
}

const opListReceiptFilters = "ListReceiptFilters"

// ListReceiptFiltersRequest generates a request for the ListReceiptFilters operation.
func (c *SES) ListReceiptFiltersRequest(input *ListReceiptFiltersInput) (req *request.Request, output *ListReceiptFiltersOutput) {
	op := &request.Operation{
		Name:       opListReceiptFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReceiptFiltersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListReceiptFiltersOutput{}
	req.Data = output
	return
}

// Lists the IP address filters associated with your account.
//
// For information about managing IP address filters, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html).
//
// This action is throttled at one request per second.
func (c *SES) ListReceiptFilters(input *ListReceiptFiltersInput) (*ListReceiptFiltersOutput, error) {
	req, out := c.ListReceiptFiltersRequest(input)
	err := req.Send()
	return out, err
}

const opListReceiptRuleSets = "ListReceiptRuleSets"

// ListReceiptRuleSetsRequest generates a request for the ListReceiptRuleSets operation.
func (c *SES) ListReceiptRuleSetsRequest(input *ListReceiptRuleSetsInput) (req *request.Request, output *ListReceiptRuleSetsOutput) {
	op := &request.Operation{
		Name:       opListReceiptRuleSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListReceiptRuleSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListReceiptRuleSetsOutput{}
	req.Data = output
	return
}

// Lists the receipt rule sets that exist under your AWS account. If there are
// additional receipt rule sets to be retrieved, you will receive a NextToken
// that you can provide to the next call to ListReceiptRuleSets to retrieve
// the additional entries.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
func (c *SES) ListReceiptRuleSets(input *ListReceiptRuleSetsInput) (*ListReceiptRuleSetsOutput, error) {
	req, out := c.ListReceiptRuleSetsRequest(input)
	err := req.Send()
	return out, err
}

const opListVerifiedEmailAddresses = "ListVerifiedEmailAddresses"

// ListVerifiedEmailAddressesRequest generates a request for the ListVerifiedEmailAddresses operation.
func (c *SES) ListVerifiedEmailAddressesRequest(input *ListVerifiedEmailAddressesInput) (req *request.Request, output *ListVerifiedEmailAddressesOutput) {
	op := &request.Operation{
		Name:       opListVerifiedEmailAddresses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListVerifiedEmailAddressesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVerifiedEmailAddressesOutput{}
	req.Data = output
	return
}

// Returns a list containing all of the email addresses that have been verified.
//
// The ListVerifiedEmailAddresses action is deprecated as of the May 15, 2012
// release of Domain Verification. The ListIdentities action is now preferred.
// This action is throttled at one request per second.
func (c *SES) ListVerifiedEmailAddresses(input *ListVerifiedEmailAddressesInput) (*ListVerifiedEmailAddressesOutput, error) {
	req, out := c.ListVerifiedEmailAddressesRequest(input)
	err := req.Send()
	return out, err
}

const opPutIdentityPolicy = "PutIdentityPolicy"

// PutIdentityPolicyRequest generates a request for the PutIdentityPolicy operation.
func (c *SES) PutIdentityPolicyRequest(input *PutIdentityPolicyInput) (req *request.Request, output *PutIdentityPolicyOutput) {
	op := &request.Operation{
		Name:       opPutIdentityPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutIdentityPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutIdentityPolicyOutput{}
	req.Data = output
	return
}

// Adds or updates a sending authorization policy for the specified identity
// (email address or domain).
//
// This API is for the identity owner only. If you have not verified the identity,
// this API will return an error. Sending authorization is a feature that enables
// an identity owner to authorize other senders to use its identities. For information
// about using sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
//
// This action is throttled at one request per second.
func (c *SES) PutIdentityPolicy(input *PutIdentityPolicyInput) (*PutIdentityPolicyOutput, error) {
	req, out := c.PutIdentityPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opReorderReceiptRuleSet = "ReorderReceiptRuleSet"

// ReorderReceiptRuleSetRequest generates a request for the ReorderReceiptRuleSet operation.
func (c *SES) ReorderReceiptRuleSetRequest(input *ReorderReceiptRuleSetInput) (req *request.Request, output *ReorderReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opReorderReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReorderReceiptRuleSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReorderReceiptRuleSetOutput{}
	req.Data = output
	return
}

// Reorders the receipt rules within a receipt rule set.
//
// All of the rules in the rule set must be represented in this request. That
// is, this API will return an error if the reorder request doesn’t explicitly
// position all of the rules. For information about managing receipt rule sets,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
func (c *SES) ReorderReceiptRuleSet(input *ReorderReceiptRuleSetInput) (*ReorderReceiptRuleSetOutput, error) {
	req, out := c.ReorderReceiptRuleSetRequest(input)
	err := req.Send()
	return out, err
}

const opSendBounce = "SendBounce"

// SendBounceRequest generates a request for the SendBounce operation.
func (c *SES) SendBounceRequest(input *SendBounceInput) (req *request.Request, output *SendBounceOutput) {
	op := &request.Operation{
		Name:       opSendBounce,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendBounceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SendBounceOutput{}
	req.Data = output
	return
}

// Generates and sends a bounce message to the sender of an email you received
// through Amazon SES. You can only use this API on an email up to 24 hours
// after you receive it.
//
// You cannot use this API to send generic bounces for mail that was not received
// by Amazon SES. For information about receiving email through Amazon SES,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
//
// This action is throttled at one request per second.
func (c *SES) SendBounce(input *SendBounceInput) (*SendBounceOutput, error) {
	req, out := c.SendBounceRequest(input)
	err := req.Send()
	return out, err
}

const opSendEmail = "SendEmail"

// SendEmailRequest generates a request for the SendEmail operation.
func (c *SES) SendEmailRequest(input *SendEmailInput) (req *request.Request, output *SendEmailOutput) {
	op := &request.Operation{
		Name:       opSendEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendEmailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SendEmailOutput{}
	req.Data = output
	return
}

// Composes an email message based on input data, and then immediately queues
// the message for sending.
//
// There are several important points to know about SendEmail:
//
//  You can only send email from verified email addresses and domains; otherwise,
// you will get an "Email address not verified" error. If your account is still
// in the Amazon SES sandbox, you must also verify every recipient email address
// except for the recipients provided by the Amazon SES mailbox simulator. For
// more information, go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
// The total size of the message cannot exceed 10 MB. This includes any attachments
// that are part of the message. Amazon SES has a limit on the total number
// of recipients per message. The combined number of To:, CC: and BCC: email
// addresses cannot exceed 50. If you need to send an email message to a larger
// audience, you can divide your recipient list into groups of 50 or fewer,
// and then call Amazon SES repeatedly to send the message to each group. For
// every message that you send, the total number of recipients (To:, CC: and
// BCC:) is counted against your sending quota - the maximum number of emails
// you can send in a 24-hour period. For information about your sending quota,
// go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html).
func (c *SES) SendEmail(input *SendEmailInput) (*SendEmailOutput, error) {
	req, out := c.SendEmailRequest(input)
	err := req.Send()
	return out, err
}

const opSendRawEmail = "SendRawEmail"

// SendRawEmailRequest generates a request for the SendRawEmail operation.
func (c *SES) SendRawEmailRequest(input *SendRawEmailInput) (req *request.Request, output *SendRawEmailOutput) {
	op := &request.Operation{
		Name:       opSendRawEmail,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendRawEmailInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SendRawEmailOutput{}
	req.Data = output
	return
}

// Sends an email message, with header and content specified by the client.
// The SendRawEmail action is useful for sending multipart MIME emails. The
// raw text of the message must comply with Internet email standards; otherwise,
// the message cannot be sent.
//
// There are several important points to know about SendRawEmail:
//
//  You can only send email from verified email addresses and domains; otherwise,
// you will get an "Email address not verified" error. If your account is still
// in the Amazon SES sandbox, you must also verify every recipient email address
// except for the recipients provided by the Amazon SES mailbox simulator. For
// more information, go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
// The total size of the message cannot exceed 10 MB. This includes any attachments
// that are part of the message. Amazon SES has a limit on the total number
// of recipients per message. The combined number of To:, CC: and BCC: email
// addresses cannot exceed 50. If you need to send an email message to a larger
// audience, you can divide your recipient list into groups of 50 or fewer,
// and then call Amazon SES repeatedly to send the message to each group. The
// To:, CC:, and BCC: headers in the raw message can contain a group list. Note
// that each recipient in a group list counts towards the 50-recipient limit.
// For every message that you send, the total number of recipients (To:, CC:
// and BCC:) is counted against your sending quota - the maximum number of emails
// you can send in a 24-hour period. For information about your sending quota,
// go to the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/manage-sending-limits.html).
// If you are using sending authorization to send on behalf of another user,
// SendRawEmail enables you to specify the cross-account identity for the email's
// "Source," "From," and "Return-Path" parameters in one of two ways: you can
// pass optional parameters SourceArn, FromArn, and/or ReturnPathArn to the
// API, or you can include the following X-headers in the header of your raw
// email:  X-SES-SOURCE-ARN X-SES-FROM-ARN X-SES-RETURN-PATH-ARN  Do not include
// these X-headers in the DKIM signature, because they are removed by Amazon
// SES before sending the email. For the most common sending authorization use
// case, we recommend that you specify the SourceIdentityArn and do not specify
// either the FromIdentityArn or ReturnPathIdentityArn. (The same note applies
// to the corresponding X-headers.) If you only specify the SourceIdentityArn,
// Amazon SES will simply set the "From" address and the "Return Path" address
// to the identity specified in SourceIdentityArn. For more information about
// sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
func (c *SES) SendRawEmail(input *SendRawEmailInput) (*SendRawEmailOutput, error) {
	req, out := c.SendRawEmailRequest(input)
	err := req.Send()
	return out, err
}

const opSetActiveReceiptRuleSet = "SetActiveReceiptRuleSet"

// SetActiveReceiptRuleSetRequest generates a request for the SetActiveReceiptRuleSet operation.
func (c *SES) SetActiveReceiptRuleSetRequest(input *SetActiveReceiptRuleSetInput) (req *request.Request, output *SetActiveReceiptRuleSetOutput) {
	op := &request.Operation{
		Name:       opSetActiveReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetActiveReceiptRuleSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetActiveReceiptRuleSetOutput{}
	req.Data = output
	return
}

// Sets the specified receipt rule set as the active receipt rule set.
//
// To disable your email-receiving through Amazon SES completely, you can call
// this API with RuleSetName set to null. For information about managing receipt
// rule sets, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// This action is throttled at one request per second.
func (c *SES) SetActiveReceiptRuleSet(input *SetActiveReceiptRuleSetInput) (*SetActiveReceiptRuleSetOutput, error) {
	req, out := c.SetActiveReceiptRuleSetRequest(input)
	err := req.Send()
	return out, err
}

const opSetIdentityDkimEnabled = "SetIdentityDkimEnabled"

// SetIdentityDkimEnabledRequest generates a request for the SetIdentityDkimEnabled operation.
func (c *SES) SetIdentityDkimEnabledRequest(input *SetIdentityDkimEnabledInput) (req *request.Request, output *SetIdentityDkimEnabledOutput) {
	op := &request.Operation{
		Name:       opSetIdentityDkimEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityDkimEnabledInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetIdentityDkimEnabledOutput{}
	req.Data = output
	return
}

// Enables or disables Easy DKIM signing of email sent from an identity:
//
//  If Easy DKIM signing is enabled for a domain name identity (e.g., example.com),
// then Amazon SES will DKIM-sign all email sent by addresses under that domain
// name (e.g., user@example.com). If Easy DKIM signing is enabled for an email
// address, then Amazon SES will DKIM-sign all email sent by that email address.
//  For email addresses (e.g., user@example.com), you can only enable Easy DKIM
// signing if the corresponding domain (e.g., example.com) has been set up for
// Easy DKIM using the AWS Console or the VerifyDomainDkim action.
//
// This action is throttled at one request per second.
//
// For more information about Easy DKIM signing, go to the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
func (c *SES) SetIdentityDkimEnabled(input *SetIdentityDkimEnabledInput) (*SetIdentityDkimEnabledOutput, error) {
	req, out := c.SetIdentityDkimEnabledRequest(input)
	err := req.Send()
	return out, err
}

const opSetIdentityFeedbackForwardingEnabled = "SetIdentityFeedbackForwardingEnabled"

// SetIdentityFeedbackForwardingEnabledRequest generates a request for the SetIdentityFeedbackForwardingEnabled operation.
func (c *SES) SetIdentityFeedbackForwardingEnabledRequest(input *SetIdentityFeedbackForwardingEnabledInput) (req *request.Request, output *SetIdentityFeedbackForwardingEnabledOutput) {
	op := &request.Operation{
		Name:       opSetIdentityFeedbackForwardingEnabled,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityFeedbackForwardingEnabledInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetIdentityFeedbackForwardingEnabledOutput{}
	req.Data = output
	return
}

// Given an identity (email address or domain), enables or disables whether
// Amazon SES forwards bounce and complaint notifications as email. Feedback
// forwarding can only be disabled when Amazon Simple Notification Service (Amazon
// SNS) topics are specified for both bounces and complaints.
//
// Feedback forwarding does not apply to delivery notifications. Delivery notifications
// are only available through Amazon SNS. This action is throttled at one request
// per second.
//
// For more information about using notifications with Amazon SES, see the
// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
func (c *SES) SetIdentityFeedbackForwardingEnabled(input *SetIdentityFeedbackForwardingEnabledInput) (*SetIdentityFeedbackForwardingEnabledOutput, error) {
	req, out := c.SetIdentityFeedbackForwardingEnabledRequest(input)
	err := req.Send()
	return out, err
}

const opSetIdentityNotificationTopic = "SetIdentityNotificationTopic"

// SetIdentityNotificationTopicRequest generates a request for the SetIdentityNotificationTopic operation.
func (c *SES) SetIdentityNotificationTopicRequest(input *SetIdentityNotificationTopicInput) (req *request.Request, output *SetIdentityNotificationTopicOutput) {
	op := &request.Operation{
		Name:       opSetIdentityNotificationTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetIdentityNotificationTopicInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetIdentityNotificationTopicOutput{}
	req.Data = output
	return
}

// Given an identity (email address or domain), sets the Amazon Simple Notification
// Service (Amazon SNS) topic to which Amazon SES will publish bounce, complaint,
// and/or delivery notifications for emails sent with that identity as the Source.
//
// Unless feedback forwarding is enabled, you must specify Amazon SNS topics
// for bounce and complaint notifications. For more information, see SetIdentityFeedbackForwardingEnabled.
//  This action is throttled at one request per second.
//
// For more information about feedback notification, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html).
func (c *SES) SetIdentityNotificationTopic(input *SetIdentityNotificationTopicInput) (*SetIdentityNotificationTopicOutput, error) {
	req, out := c.SetIdentityNotificationTopicRequest(input)
	err := req.Send()
	return out, err
}

const opSetReceiptRulePosition = "SetReceiptRulePosition"

// SetReceiptRulePositionRequest generates a request for the SetReceiptRulePosition operation.
func (c *SES) SetReceiptRulePositionRequest(input *SetReceiptRulePositionInput) (req *request.Request, output *SetReceiptRulePositionOutput) {
	op := &request.Operation{
		Name:       opSetReceiptRulePosition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetReceiptRulePositionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetReceiptRulePositionOutput{}
	req.Data = output
	return
}

// Sets the position of the specified receipt rule in the receipt rule set.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
//
// This action is throttled at one request per second.
func (c *SES) SetReceiptRulePosition(input *SetReceiptRulePositionInput) (*SetReceiptRulePositionOutput, error) {
	req, out := c.SetReceiptRulePositionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateReceiptRule = "UpdateReceiptRule"

// UpdateReceiptRuleRequest generates a request for the UpdateReceiptRule operation.
func (c *SES) UpdateReceiptRuleRequest(input *UpdateReceiptRuleInput) (req *request.Request, output *UpdateReceiptRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateReceiptRuleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateReceiptRuleOutput{}
	req.Data = output
	return
}

// Updates a receipt rule.
//
// For information about managing receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rules.html).
//
// This action is throttled at one request per second.
func (c *SES) UpdateReceiptRule(input *UpdateReceiptRuleInput) (*UpdateReceiptRuleOutput, error) {
	req, out := c.UpdateReceiptRuleRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyDomainDkim = "VerifyDomainDkim"

// VerifyDomainDkimRequest generates a request for the VerifyDomainDkim operation.
func (c *SES) VerifyDomainDkimRequest(input *VerifyDomainDkimInput) (req *request.Request, output *VerifyDomainDkimOutput) {
	op := &request.Operation{
		Name:       opVerifyDomainDkim,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyDomainDkimInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VerifyDomainDkimOutput{}
	req.Data = output
	return
}

// Returns a set of DKIM tokens for a domain. DKIM tokens are character strings
// that represent your domain's identity. Using these tokens, you will need
// to create DNS CNAME records that point to DKIM public keys hosted by Amazon
// SES. Amazon Web Services will eventually detect that you have updated your
// DNS records; this detection process may take up to 72 hours. Upon successful
// detection, Amazon SES will be able to DKIM-sign email originating from that
// domain.
//
// This action is throttled at one request per second.
//
// To enable or disable Easy DKIM signing for a domain, use the SetIdentityDkimEnabled
// action.
//
// For more information about creating DNS records using DKIM tokens, go to
// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
func (c *SES) VerifyDomainDkim(input *VerifyDomainDkimInput) (*VerifyDomainDkimOutput, error) {
	req, out := c.VerifyDomainDkimRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyDomainIdentity = "VerifyDomainIdentity"

// VerifyDomainIdentityRequest generates a request for the VerifyDomainIdentity operation.
func (c *SES) VerifyDomainIdentityRequest(input *VerifyDomainIdentityInput) (req *request.Request, output *VerifyDomainIdentityOutput) {
	op := &request.Operation{
		Name:       opVerifyDomainIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyDomainIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VerifyDomainIdentityOutput{}
	req.Data = output
	return
}

// Verifies a domain.
//
// This action is throttled at one request per second.
func (c *SES) VerifyDomainIdentity(input *VerifyDomainIdentityInput) (*VerifyDomainIdentityOutput, error) {
	req, out := c.VerifyDomainIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyEmailAddress = "VerifyEmailAddress"

// VerifyEmailAddressRequest generates a request for the VerifyEmailAddress operation.
func (c *SES) VerifyEmailAddressRequest(input *VerifyEmailAddressInput) (req *request.Request, output *VerifyEmailAddressOutput) {
	op := &request.Operation{
		Name:       opVerifyEmailAddress,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyEmailAddressInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VerifyEmailAddressOutput{}
	req.Data = output
	return
}

// Verifies an email address. This action causes a confirmation email message
// to be sent to the specified address.
//
// The VerifyEmailAddress action is deprecated as of the May 15, 2012 release
// of Domain Verification. The VerifyEmailIdentity action is now preferred.
// This action is throttled at one request per second.
func (c *SES) VerifyEmailAddress(input *VerifyEmailAddressInput) (*VerifyEmailAddressOutput, error) {
	req, out := c.VerifyEmailAddressRequest(input)
	err := req.Send()
	return out, err
}

const opVerifyEmailIdentity = "VerifyEmailIdentity"

// VerifyEmailIdentityRequest generates a request for the VerifyEmailIdentity operation.
func (c *SES) VerifyEmailIdentityRequest(input *VerifyEmailIdentityInput) (req *request.Request, output *VerifyEmailIdentityOutput) {
	op := &request.Operation{
		Name:       opVerifyEmailIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyEmailIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VerifyEmailIdentityOutput{}
	req.Data = output
	return
}

// Verifies an email address. This action causes a confirmation email message
// to be sent to the specified address.
//
// This action is throttled at one request per second.
func (c *SES) VerifyEmailIdentity(input *VerifyEmailIdentityInput) (*VerifyEmailIdentityOutput, error) {
	req, out := c.VerifyEmailIdentityRequest(input)
	err := req.Send()
	return out, err
}

// When included in a receipt rule, this action adds a header to the received
// email.
//
// For information about adding a header using a receipt rule, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-add-header.html).
type AddHeaderAction struct {
	// The name of the header to add. Must be between 1 and 50 characters, inclusive,
	// and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
	HeaderName *string `type:"string" required:"true"`

	// Must be less than 2048 characters, and must not contain newline characters
	// ("\r" or "\n").
	HeaderValue *string `type:"string" required:"true"`

	metadataAddHeaderAction `json:"-" xml:"-"`
}

type metadataAddHeaderAction struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddHeaderAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddHeaderAction) GoString() string {
	return s.String()
}

// Represents the body of the message. You can specify text, HTML, or both.
// If you use both, then the message should display correctly in the widest
// variety of email clients.
type Body struct {
	// The content of the message, in HTML format. Use this for email clients that
	// can process HTML. You can include clickable links, formatted text, and much
	// more in an HTML message.
	Html *Content `type:"structure"`

	// The content of the message, in text format. Use this for text-based email
	// clients, or clients on high-latency networks (such as mobile devices).
	Text *Content `type:"structure"`

	metadataBody `json:"-" xml:"-"`
}

type metadataBody struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Body) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Body) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action rejects the received email by
// returning a bounce response to the sender and, optionally, publishes a notification
// to Amazon Simple Notification Service (Amazon SNS).
//
// For information about sending a bounce message in response to a received
// email, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-bounce.html).
type BounceAction struct {
	// Human-readable text to include in the bounce message.
	Message *string `type:"string" required:"true"`

	// The email address of the sender of the bounced email. This is the address
	// from which the bounce message will be sent.
	Sender *string `type:"string" required:"true"`

	// The SMTP reply code, as defined by RFC 5321 (https://tools.ietf.org/html/rfc5321).
	SmtpReplyCode *string `type:"string" required:"true"`

	// The SMTP enhanced status code, as defined by RFC 3463 (https://tools.ietf.org/html/rfc3463).
	StatusCode *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// bounce action is taken. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`

	metadataBounceAction `json:"-" xml:"-"`
}

type metadataBounceAction struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BounceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BounceAction) GoString() string {
	return s.String()
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
type BouncedRecipientInfo struct {
	// The reason for the bounce. You must provide either this parameter or RecipientDsnFields.
	BounceType *string `type:"string" enum:"BounceType"`

	// The email address of the recipient of the bounced email.
	Recipient *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to receive email for the recipient of the bounced email. For more information
	// about sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	RecipientArn *string `type:"string"`

	// Recipient-related DSN fields, most of which would normally be filled in automatically
	// when provided with a BounceType. You must provide either this parameter or
	// BounceType.
	RecipientDsnFields *RecipientDsnFields `type:"structure"`

	metadataBouncedRecipientInfo `json:"-" xml:"-"`
}

type metadataBouncedRecipientInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BouncedRecipientInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BouncedRecipientInfo) GoString() string {
	return s.String()
}

type CloneReceiptRuleSetInput struct {
	// The name of the rule set to clone.
	OriginalRuleSetName *string `type:"string" required:"true"`

	// The name of the rule set to create. The name must:
	//
	//  Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	// (_), or dashes (-). Start and end with a letter or number. Contain less than
	// 64 characters.
	RuleSetName *string `type:"string" required:"true"`

	metadataCloneReceiptRuleSetInput `json:"-" xml:"-"`
}

type metadataCloneReceiptRuleSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CloneReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneReceiptRuleSetInput) GoString() string {
	return s.String()
}

type CloneReceiptRuleSetOutput struct {
	metadataCloneReceiptRuleSetOutput `json:"-" xml:"-"`
}

type metadataCloneReceiptRuleSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CloneReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents textual data, plus an optional character set specification.
//
// By default, the text must be 7-bit ASCII, due to the constraints of the
// SMTP protocol. If the text must contain any other characters, then you must
// also specify a character set. Examples include UTF-8, ISO-8859-1, and Shift_JIS.
type Content struct {
	// The character set of the content.
	Charset *string `type:"string"`

	// The textual data of the content.
	Data *string `type:"string" required:"true"`

	metadataContent `json:"-" xml:"-"`
}

type metadataContent struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Content) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Content) GoString() string {
	return s.String()
}

type CreateReceiptFilterInput struct {
	// A data structure that describes the IP address filter to create, which consists
	// of a name, an IP address range, and whether to allow or block mail from it.
	Filter *ReceiptFilter `type:"structure" required:"true"`

	metadataCreateReceiptFilterInput `json:"-" xml:"-"`
}

type metadataCreateReceiptFilterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateReceiptFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptFilterInput) GoString() string {
	return s.String()
}

type CreateReceiptFilterOutput struct {
	metadataCreateReceiptFilterOutput `json:"-" xml:"-"`
}

type metadataCreateReceiptFilterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateReceiptFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptFilterOutput) GoString() string {
	return s.String()
}

type CreateReceiptRuleInput struct {
	// The name of an existing rule after which the new rule will be placed. If
	// this parameter is null, the new rule will be inserted at the beginning of
	// the rule list.
	After *string `type:"string"`

	// A data structure that contains the specified rule's name, actions, recipients,
	// domains, enabled status, scan status, and TLS policy.
	Rule *ReceiptRule `type:"structure" required:"true"`

	// The name of the rule set to which to add the rule.
	RuleSetName *string `type:"string" required:"true"`

	metadataCreateReceiptRuleInput `json:"-" xml:"-"`
}

type metadataCreateReceiptRuleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptRuleInput) GoString() string {
	return s.String()
}

type CreateReceiptRuleOutput struct {
	metadataCreateReceiptRuleOutput `json:"-" xml:"-"`
}

type metadataCreateReceiptRuleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptRuleOutput) GoString() string {
	return s.String()
}

type CreateReceiptRuleSetInput struct {
	// The name of the rule set to create. The name must:
	//
	//  Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	// (_), or dashes (-). Start and end with a letter or number. Contain less than
	// 64 characters.
	RuleSetName *string `type:"string" required:"true"`

	metadataCreateReceiptRuleSetInput `json:"-" xml:"-"`
}

type metadataCreateReceiptRuleSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptRuleSetInput) GoString() string {
	return s.String()
}

type CreateReceiptRuleSetOutput struct {
	metadataCreateReceiptRuleSetOutput `json:"-" xml:"-"`
}

type metadataCreateReceiptRuleSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to delete an identity from the
// list of identities for the AWS Account.
type DeleteIdentityInput struct {
	// The identity to be removed from the list of identities for the AWS Account.
	Identity *string `type:"string" required:"true"`

	metadataDeleteIdentityInput `json:"-" xml:"-"`
}

type metadataDeleteIdentityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type DeleteIdentityOutput struct {
	metadataDeleteIdentityOutput `json:"-" xml:"-"`
}

type metadataDeleteIdentityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to delete an authorization policy
// applying to an identity.
//
// This request succeeds regardless of whether the specified policy exists.
type DeleteIdentityPolicyInput struct {
	// The identity that is associated with the policy that you want to delete.
	// You can specify the identity by using its name or by using its Amazon Resource
	// Name (ARN). Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	Identity *string `type:"string" required:"true"`

	// The name of the policy to be deleted.
	PolicyName *string `min:"1" type:"string" required:"true"`

	metadataDeleteIdentityPolicyInput `json:"-" xml:"-"`
}

type metadataDeleteIdentityPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPolicyInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type DeleteIdentityPolicyOutput struct {
	metadataDeleteIdentityPolicyOutput `json:"-" xml:"-"`
}

type metadataDeleteIdentityPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIdentityPolicyOutput) GoString() string {
	return s.String()
}

type DeleteReceiptFilterInput struct {
	// The name of the IP address filter to delete.
	FilterName *string `type:"string" required:"true"`

	metadataDeleteReceiptFilterInput `json:"-" xml:"-"`
}

type metadataDeleteReceiptFilterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptFilterInput) GoString() string {
	return s.String()
}

type DeleteReceiptFilterOutput struct {
	metadataDeleteReceiptFilterOutput `json:"-" xml:"-"`
}

type metadataDeleteReceiptFilterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptFilterOutput) GoString() string {
	return s.String()
}

type DeleteReceiptRuleInput struct {
	// The name of the receipt rule to delete.
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set that contains the receipt rule to delete.
	RuleSetName *string `type:"string" required:"true"`

	metadataDeleteReceiptRuleInput `json:"-" xml:"-"`
}

type metadataDeleteReceiptRuleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptRuleInput) GoString() string {
	return s.String()
}

type DeleteReceiptRuleOutput struct {
	metadataDeleteReceiptRuleOutput `json:"-" xml:"-"`
}

type metadataDeleteReceiptRuleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptRuleOutput) GoString() string {
	return s.String()
}

type DeleteReceiptRuleSetInput struct {
	// The name of the receipt rule set to delete.
	RuleSetName *string `type:"string" required:"true"`

	metadataDeleteReceiptRuleSetInput `json:"-" xml:"-"`
}

type metadataDeleteReceiptRuleSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptRuleSetInput) GoString() string {
	return s.String()
}

type DeleteReceiptRuleSetOutput struct {
	metadataDeleteReceiptRuleSetOutput `json:"-" xml:"-"`
}

type metadataDeleteReceiptRuleSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to delete an address from the
// list of verified email addresses.
type DeleteVerifiedEmailAddressInput struct {
	// An email address to be removed from the list of verified addresses.
	EmailAddress *string `type:"string" required:"true"`

	metadataDeleteVerifiedEmailAddressInput `json:"-" xml:"-"`
}

type metadataDeleteVerifiedEmailAddressInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVerifiedEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVerifiedEmailAddressInput) GoString() string {
	return s.String()
}

type DeleteVerifiedEmailAddressOutput struct {
	metadataDeleteVerifiedEmailAddressOutput `json:"-" xml:"-"`
}

type metadataDeleteVerifiedEmailAddressOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVerifiedEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVerifiedEmailAddressOutput) GoString() string {
	return s.String()
}

type DescribeActiveReceiptRuleSetInput struct {
	metadataDescribeActiveReceiptRuleSetInput `json:"-" xml:"-"`
}

type metadataDescribeActiveReceiptRuleSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeActiveReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActiveReceiptRuleSetInput) GoString() string {
	return s.String()
}

type DescribeActiveReceiptRuleSetOutput struct {
	// The metadata for the currently active receipt rule set. The metadata consists
	// of the rule set name and a timestamp of when the rule set was created.
	Metadata *ReceiptRuleSetMetadata `type:"structure"`

	// The receipt rules that belong to the active rule set.
	Rules []*ReceiptRule `type:"list"`

	metadataDescribeActiveReceiptRuleSetOutput `json:"-" xml:"-"`
}

type metadataDescribeActiveReceiptRuleSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeActiveReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeActiveReceiptRuleSetOutput) GoString() string {
	return s.String()
}

type DescribeReceiptRuleInput struct {
	// The name of the receipt rule.
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set to which the receipt rule belongs.
	RuleSetName *string `type:"string" required:"true"`

	metadataDescribeReceiptRuleInput `json:"-" xml:"-"`
}

type metadataDescribeReceiptRuleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReceiptRuleInput) GoString() string {
	return s.String()
}

type DescribeReceiptRuleOutput struct {
	// A data structure that contains the specified receipt rule's name, actions,
	// recipients, domains, enabled status, scan status, and Transport Layer Security
	// (TLS) policy.
	Rule *ReceiptRule `type:"structure"`

	metadataDescribeReceiptRuleOutput `json:"-" xml:"-"`
}

type metadataDescribeReceiptRuleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReceiptRuleOutput) GoString() string {
	return s.String()
}

type DescribeReceiptRuleSetInput struct {
	// The name of the receipt rule set to describe.
	RuleSetName *string `type:"string" required:"true"`

	metadataDescribeReceiptRuleSetInput `json:"-" xml:"-"`
}

type metadataDescribeReceiptRuleSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReceiptRuleSetInput) GoString() string {
	return s.String()
}

type DescribeReceiptRuleSetOutput struct {
	// The metadata for the receipt rule set, which consists of the rule set name
	// and the timestamp of when the rule set was created.
	Metadata *ReceiptRuleSetMetadata `type:"structure"`

	// A list of the receipt rules that belong to the specified receipt rule set.
	Rules []*ReceiptRule `type:"list"`

	metadataDescribeReceiptRuleSetOutput `json:"-" xml:"-"`
}

type metadataDescribeReceiptRuleSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents the destination of the message, consisting of To:, CC:, and BCC:
// fields.
//
//  By default, the string must be 7-bit ASCII. If the text must contain any
// other characters, then you must use MIME encoded-word syntax (RFC 2047) instead
// of a literal string. MIME encoded-word syntax uses the following form: =?charset?encoding?encoded-text?=.
// For more information, see RFC 2047 (http://tools.ietf.org/html/rfc2047).
type Destination struct {
	// The BCC: field(s) of the message.
	BccAddresses []*string `type:"list"`

	// The CC: field(s) of the message.
	CcAddresses []*string `type:"list"`

	// The To: field(s) of the message.
	ToAddresses []*string `type:"list"`

	metadataDestination `json:"-" xml:"-"`
}

type metadataDestination struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Destination) GoString() string {
	return s.String()
}

// Additional X-headers to include in the Delivery Status Notification (DSN)
// when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
type ExtensionField struct {
	// The name of the header to add. Must be between 1 and 50 characters, inclusive,
	// and consist of alphanumeric (a-z, A-Z, 0-9) characters and dashes only.
	Name *string `type:"string" required:"true"`

	// The value of the header to add. Must be less than 2048 characters, and must
	// not contain newline characters ("\r" or "\n").
	Value *string `type:"string" required:"true"`

	metadataExtensionField `json:"-" xml:"-"`
}

type metadataExtensionField struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ExtensionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExtensionField) GoString() string {
	return s.String()
}

// Given a list of verified identities, describes their DKIM attributes. The
// DKIM attributes of an email address identity includes whether DKIM signing
// is individually enabled or disabled for that address. The DKIM attributes
// of a domain name identity includes whether DKIM signing is enabled, as well
// as the DNS records (tokens) that must remain published in the domain name's
// DNS.
type GetIdentityDkimAttributesInput struct {
	// A list of one or more verified identities - email addresses, domains, or
	// both.
	Identities []*string `type:"list" required:"true"`

	metadataGetIdentityDkimAttributesInput `json:"-" xml:"-"`
}

type metadataGetIdentityDkimAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityDkimAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityDkimAttributesInput) GoString() string {
	return s.String()
}

// Represents a list of all the DKIM attributes for the specified identity.
type GetIdentityDkimAttributesOutput struct {
	// The DKIM attributes for an email address or a domain.
	DkimAttributes map[string]*IdentityDkimAttributes `type:"map" required:"true"`

	metadataGetIdentityDkimAttributesOutput `json:"-" xml:"-"`
}

type metadataGetIdentityDkimAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityDkimAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityDkimAttributesOutput) GoString() string {
	return s.String()
}

type GetIdentityNotificationAttributesInput struct {
	// A list of one or more identities. You can specify an identity by using its
	// name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	Identities []*string `type:"list" required:"true"`

	metadataGetIdentityNotificationAttributesInput `json:"-" xml:"-"`
}

type metadataGetIdentityNotificationAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityNotificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityNotificationAttributesInput) GoString() string {
	return s.String()
}

// Describes whether an identity has Amazon Simple Notification Service (Amazon
// SNS) topics set for bounce, complaint, and/or delivery notifications, and
// specifies whether feedback forwarding is enabled for bounce and complaint
// notifications.
type GetIdentityNotificationAttributesOutput struct {
	// A map of Identity to IdentityNotificationAttributes.
	NotificationAttributes map[string]*IdentityNotificationAttributes `type:"map" required:"true"`

	metadataGetIdentityNotificationAttributesOutput `json:"-" xml:"-"`
}

type metadataGetIdentityNotificationAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityNotificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityNotificationAttributesOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to retrieve the text of a list
// of authorization policies applying to an identity.
type GetIdentityPoliciesInput struct {
	// The identity for which the policies will be retrieved. You can specify an
	// identity by using its name or by using its Amazon Resource Name (ARN). Examples:
	// user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	Identity *string `type:"string" required:"true"`

	// A list of the names of policies to be retrieved. You can retrieve a maximum
	// of 20 policies at a time. If you do not know the names of the policies that
	// are attached to the identity, you can use ListIdentityPolicies.
	PolicyNames []*string `type:"list" required:"true"`

	metadataGetIdentityPoliciesInput `json:"-" xml:"-"`
}

type metadataGetIdentityPoliciesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoliciesInput) GoString() string {
	return s.String()
}

// Represents a map of policy names to policies returned from a successful GetIdentityPolicies
// request.
type GetIdentityPoliciesOutput struct {
	// A map of policy names to policies.
	Policies map[string]*string `type:"map" required:"true"`

	metadataGetIdentityPoliciesOutput `json:"-" xml:"-"`
}

type metadataGetIdentityPoliciesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityPoliciesOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to provide the verification
// attributes for a list of identities.
type GetIdentityVerificationAttributesInput struct {
	// A list of identities.
	Identities []*string `type:"list" required:"true"`

	metadataGetIdentityVerificationAttributesInput `json:"-" xml:"-"`
}

type metadataGetIdentityVerificationAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityVerificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityVerificationAttributesInput) GoString() string {
	return s.String()
}

// Represents the verification attributes for a list of identities.
type GetIdentityVerificationAttributesOutput struct {
	// A map of Identities to IdentityVerificationAttributes objects.
	VerificationAttributes map[string]*IdentityVerificationAttributes `type:"map" required:"true"`

	metadataGetIdentityVerificationAttributesOutput `json:"-" xml:"-"`
}

type metadataGetIdentityVerificationAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetIdentityVerificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIdentityVerificationAttributesOutput) GoString() string {
	return s.String()
}

type GetSendQuotaInput struct {
	metadataGetSendQuotaInput `json:"-" xml:"-"`
}

type metadataGetSendQuotaInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSendQuotaInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendQuotaInput) GoString() string {
	return s.String()
}

// Represents the user's current activity limits returned from a successful
// GetSendQuota request.
type GetSendQuotaOutput struct {
	// The maximum number of emails the user is allowed to send in a 24-hour interval.
	// A value of -1 signifies an unlimited quota.
	Max24HourSend *float64 `type:"double"`

	// The maximum number of emails that Amazon SES can accept from the user's account
	// per second.
	//
	// The rate at which Amazon SES accepts the user's messages might be less than
	// the maximum send rate.
	MaxSendRate *float64 `type:"double"`

	// The number of emails sent during the previous 24 hours.
	SentLast24Hours *float64 `type:"double"`

	metadataGetSendQuotaOutput `json:"-" xml:"-"`
}

type metadataGetSendQuotaOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSendQuotaOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendQuotaOutput) GoString() string {
	return s.String()
}

type GetSendStatisticsInput struct {
	metadataGetSendStatisticsInput `json:"-" xml:"-"`
}

type metadataGetSendStatisticsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSendStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendStatisticsInput) GoString() string {
	return s.String()
}

// Represents a list of SendDataPoint items returned from a successful GetSendStatistics
// request. This list contains aggregated data from the previous two weeks of
// sending activity.
type GetSendStatisticsOutput struct {
	// A list of data points, each of which represents 15 minutes of activity.
	SendDataPoints []*SendDataPoint `type:"list"`

	metadataGetSendStatisticsOutput `json:"-" xml:"-"`
}

type metadataGetSendStatisticsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSendStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSendStatisticsOutput) GoString() string {
	return s.String()
}

// Represents the DKIM attributes of a verified email address or a domain.
type IdentityDkimAttributes struct {
	// True if DKIM signing is enabled for email sent from the identity; false otherwise.
	DkimEnabled *bool `type:"boolean" required:"true"`

	// A set of character strings that represent the domain's identity. Using these
	// tokens, you will need to create DNS CNAME records that point to DKIM public
	// keys hosted by Amazon SES. Amazon Web Services will eventually detect that
	// you have updated your DNS records; this detection process may take up to
	// 72 hours. Upon successful detection, Amazon SES will be able to DKIM-sign
	// email originating from that domain. (This only applies to domain identities,
	// not email address identities.)
	//
	// For more information about creating DNS records using DKIM tokens, go to
	// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
	DkimTokens []*string `type:"list"`

	// Describes whether Amazon SES has successfully verified the DKIM DNS records
	// (tokens) published in the domain name's DNS. (This only applies to domain
	// identities, not email address identities.)
	DkimVerificationStatus *string `type:"string" required:"true" enum:"VerificationStatus"`

	metadataIdentityDkimAttributes `json:"-" xml:"-"`
}

type metadataIdentityDkimAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IdentityDkimAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityDkimAttributes) GoString() string {
	return s.String()
}

// Represents the notification attributes of an identity, including whether
// an identity has Amazon Simple Notification Service (Amazon SNS) topics set
// for bounce, complaint, and/or delivery notifications, and whether feedback
// forwarding is enabled for bounce and complaint notifications.
type IdentityNotificationAttributes struct {
	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish bounce notifications.
	BounceTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish complaint notifications.
	ComplaintTopic *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic where Amazon SES will
	// publish delivery notifications.
	DeliveryTopic *string `type:"string" required:"true"`

	// Describes whether Amazon SES will forward bounce and complaint notifications
	// as email. true indicates that Amazon SES will forward bounce and complaint
	// notifications as email, while false indicates that bounce and complaint notifications
	// will be published only to the specified bounce and complaint Amazon SNS topics.
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	metadataIdentityNotificationAttributes `json:"-" xml:"-"`
}

type metadataIdentityNotificationAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IdentityNotificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityNotificationAttributes) GoString() string {
	return s.String()
}

// Represents the verification attributes of a single identity.
type IdentityVerificationAttributes struct {
	// The verification status of the identity: "Pending", "Success", "Failed",
	// or "TemporaryFailure".
	VerificationStatus *string `type:"string" required:"true" enum:"VerificationStatus"`

	// The verification token for a domain identity. Null for email address identities.
	VerificationToken *string `type:"string"`

	metadataIdentityVerificationAttributes `json:"-" xml:"-"`
}

type metadataIdentityVerificationAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IdentityVerificationAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdentityVerificationAttributes) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action calls an AWS Lambda function
// and, optionally, publishes a notification to Amazon Simple Notification Service
// (Amazon SNS).
//
// To enable Amazon SES to call your AWS Lambda function or to publish to an
// Amazon SNS topic of another account, Amazon SES must have permission to access
// those resources. For information about giving permissions, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
// For information about using AWS Lambda actions in receipt rules, see the
// Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-lambda.html).
type LambdaAction struct {
	// The Amazon Resource Name (ARN) of the AWS Lambda function. An example of
	// an AWS Lambda function ARN is arn:aws:lambda:us-west-2:account-id:function:MyFunction.
	// For more information about AWS Lambda, see the AWS Lambda Developer Guide
	// (http://docs.aws.amazon.com/lambda/latest/dg/welcome.html).
	FunctionArn *string `type:"string" required:"true"`

	// The invocation type of the AWS Lambda function. An invocation type of RequestResponse
	// means that the execution of the function will immediately result in a response,
	// and a value of Event means that the function will be invoked asynchronously.
	// The default value is Event. For information about AWS Lambda invocation types,
	// see the AWS Lambda Developer Guide (http://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html).
	//
	// There is a 30-second timeout on RequestResponse invocations. You should
	// use Event invocation in most cases. Use RequestResponse only when you want
	// to make a mail flow decision, such as whether to stop the receipt rule or
	// the receipt rule set.
	InvocationType *string `type:"string" enum:"InvocationType"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// Lambda action is taken. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`

	metadataLambdaAction `json:"-" xml:"-"`
}

type metadataLambdaAction struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s LambdaAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LambdaAction) GoString() string {
	return s.String()
}

// Represents a request instructing the service to list all identities for the
// AWS Account.
type ListIdentitiesInput struct {
	// The type of the identities to list. Possible values are "EmailAddress" and
	// "Domain". If this parameter is omitted, then all identities will be listed.
	IdentityType *string `type:"string" enum:"IdentityType"`

	// The maximum number of identities per page. Possible values are 1-1000 inclusive.
	MaxItems *int64 `type:"integer"`

	// The token to use for pagination.
	NextToken *string `type:"string"`

	metadataListIdentitiesInput `json:"-" xml:"-"`
}

type metadataListIdentitiesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListIdentitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesInput) GoString() string {
	return s.String()
}

// Represents a list of all verified identities for the AWS Account.
type ListIdentitiesOutput struct {
	// A list of identities.
	Identities []*string `type:"list" required:"true"`

	// The token used for pagination.
	NextToken *string `type:"string"`

	metadataListIdentitiesOutput `json:"-" xml:"-"`
}

type metadataListIdentitiesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListIdentitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentitiesOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to list all authorization policies,
// by name, applying to an identity.
type ListIdentityPoliciesInput struct {
	// The identity that is associated with the policy for which the policies will
	// be listed. You can specify an identity by using its name or by using its
	// Amazon Resource Name (ARN). Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	Identity *string `type:"string" required:"true"`

	metadataListIdentityPoliciesInput `json:"-" xml:"-"`
}

type metadataListIdentityPoliciesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListIdentityPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoliciesInput) GoString() string {
	return s.String()
}

// Represents a list of policy names returned from a successful ListIdentityPolicies
// request.
type ListIdentityPoliciesOutput struct {
	// A list of names of policies that apply to the specified identity.
	PolicyNames []*string `type:"list" required:"true"`

	metadataListIdentityPoliciesOutput `json:"-" xml:"-"`
}

type metadataListIdentityPoliciesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListIdentityPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIdentityPoliciesOutput) GoString() string {
	return s.String()
}

type ListReceiptFiltersInput struct {
	metadataListReceiptFiltersInput `json:"-" xml:"-"`
}

type metadataListReceiptFiltersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListReceiptFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReceiptFiltersInput) GoString() string {
	return s.String()
}

type ListReceiptFiltersOutput struct {
	// A list of IP address filter data structures, which each consist of a name,
	// an IP address range, and whether to allow or block mail from it.
	Filters []*ReceiptFilter `type:"list"`

	metadataListReceiptFiltersOutput `json:"-" xml:"-"`
}

type metadataListReceiptFiltersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListReceiptFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReceiptFiltersOutput) GoString() string {
	return s.String()
}

type ListReceiptRuleSetsInput struct {
	// A token returned from a previous call to ListReceiptRuleSets to indicate
	// the position in the receipt rule set list.
	NextToken *string `type:"string"`

	metadataListReceiptRuleSetsInput `json:"-" xml:"-"`
}

type metadataListReceiptRuleSetsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListReceiptRuleSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReceiptRuleSetsInput) GoString() string {
	return s.String()
}

type ListReceiptRuleSetsOutput struct {
	// A token indicating that there are additional receipt rule sets available
	// to be listed. Pass this token to successive calls of ListReceiptRuleSets
	// to retrieve up to 100 receipt rule sets at a time.
	NextToken *string `type:"string"`

	// The metadata for the currently active receipt rule set. The metadata consists
	// of the rule set name and the timestamp of when the rule set was created.
	RuleSets []*ReceiptRuleSetMetadata `type:"list"`

	metadataListReceiptRuleSetsOutput `json:"-" xml:"-"`
}

type metadataListReceiptRuleSetsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListReceiptRuleSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReceiptRuleSetsOutput) GoString() string {
	return s.String()
}

type ListVerifiedEmailAddressesInput struct {
	metadataListVerifiedEmailAddressesInput `json:"-" xml:"-"`
}

type metadataListVerifiedEmailAddressesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVerifiedEmailAddressesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVerifiedEmailAddressesInput) GoString() string {
	return s.String()
}

// Represents a list of all the email addresses verified for the current user.
type ListVerifiedEmailAddressesOutput struct {
	// A list of email addresses that have been verified.
	VerifiedEmailAddresses []*string `type:"list"`

	metadataListVerifiedEmailAddressesOutput `json:"-" xml:"-"`
}

type metadataListVerifiedEmailAddressesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVerifiedEmailAddressesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVerifiedEmailAddressesOutput) GoString() string {
	return s.String()
}

// Represents the message to be sent, composed of a subject and a body.
type Message struct {
	// The message body.
	Body *Body `type:"structure" required:"true"`

	// The subject of the message: A short summary of the content, which will appear
	// in the recipient's inbox.
	Subject *Content `type:"structure" required:"true"`

	metadataMessage `json:"-" xml:"-"`
}

type metadataMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Message) GoString() string {
	return s.String()
}

// Message-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
type MessageDsn struct {
	// When the message was received by the reporting mail transfer agent (MTA),
	// in RFC 822 (https://www.ietf.org/rfc/rfc0822.txt) date-time format.
	ArrivalDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Additional X-headers to include in the DSN.
	ExtensionFields []*ExtensionField `type:"list"`

	// The reporting MTA that attempted to deliver the message, formatted as specified
	// in RFC 3464 (https://tools.ietf.org/html/rfc3464) (mta-name-type; mta-name).
	// The default value is dns; inbound-smtp.[region].amazonaws.com.
	ReportingMta *string `type:"string" required:"true"`

	metadataMessageDsn `json:"-" xml:"-"`
}

type metadataMessageDsn struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s MessageDsn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageDsn) GoString() string {
	return s.String()
}

// Represents a request instructing the service to apply an authorization policy
// to an identity.
type PutIdentityPolicyInput struct {
	// The identity to which the policy will apply. You can specify an identity
	// by using its name or by using its Amazon Resource Name (ARN). Examples: user@example.com,
	// example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	//
	// To successfully call this API, you must own the identity.
	Identity *string `type:"string" required:"true"`

	// The text of the policy in JSON format. The policy cannot exceed 4 KB.
	//
	// For information about the syntax of sending authorization policies, see
	// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-policies.html).
	Policy *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// The policy name cannot exceed 64 characters and can only include alphanumeric
	// characters, dashes, and underscores.
	PolicyName *string `min:"1" type:"string" required:"true"`

	metadataPutIdentityPolicyInput `json:"-" xml:"-"`
}

type metadataPutIdentityPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutIdentityPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIdentityPolicyInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type PutIdentityPolicyOutput struct {
	metadataPutIdentityPolicyOutput `json:"-" xml:"-"`
}

type metadataPutIdentityPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutIdentityPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIdentityPolicyOutput) GoString() string {
	return s.String()
}

// Represents the raw data of the message.
type RawMessage struct {
	// The raw data of the message. The client must ensure that the message format
	// complies with Internet email standards regarding email header fields, MIME
	// types, MIME encoding, and base64 encoding (if necessary).
	//
	// The To:, CC:, and BCC: headers in the raw message can contain a group list.
	//
	// If you are using SendRawEmail with sending authorization, you can include
	// X-headers in the raw message to specify the "Source," "From," and "Return-Path"
	// addresses. For more information, see the documentation for SendRawEmail.
	//
	// Do not include these X-headers in the DKIM signature, because they are removed
	// by Amazon SES before sending the email. For more information, go to the Amazon
	// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-email-raw.html).
	Data []byte `type:"blob" required:"true"`

	metadataRawMessage `json:"-" xml:"-"`
}

type metadataRawMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RawMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RawMessage) GoString() string {
	return s.String()
}

// An action that Amazon SES can take when it receives an email on behalf of
// one or more email addresses or domains that you own. An instance of this
// data type can represent only one action.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
type ReceiptAction struct {
	// Adds a header to the received email.
	AddHeaderAction *AddHeaderAction `type:"structure"`

	// Rejects the received email by returning a bounce response to the sender and,
	// optionally, publishes a notification to Amazon Simple Notification Service
	// (Amazon SNS).
	BounceAction *BounceAction `type:"structure"`

	// Calls an AWS Lambda function, and optionally, publishes a notification to
	// Amazon SNS.
	LambdaAction *LambdaAction `type:"structure"`

	// Saves the received message to an Amazon Simple Storage Service (Amazon S3)
	// bucket and, optionally, publishes a notification to Amazon SNS.
	S3Action *S3Action `type:"structure"`

	// Publishes the email content within a notification to Amazon SNS.
	SNSAction *SNSAction `type:"structure"`

	// Terminates the evaluation of the receipt rule set and optionally publishes
	// a notification to Amazon SNS.
	StopAction *StopAction `type:"structure"`

	// Calls Amazon WorkMail and, optionally, publishes a notification to Amazon
	// SNS.
	WorkmailAction *WorkmailAction `type:"structure"`

	metadataReceiptAction `json:"-" xml:"-"`
}

type metadataReceiptAction struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReceiptAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptAction) GoString() string {
	return s.String()
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses.
//
// For information about setting up IP address filters, see the Amazon SES
// Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html).
type ReceiptFilter struct {
	// A structure that provides the IP addresses to block or allow, and whether
	// to block or allow incoming mail from them.
	IpFilter *ReceiptIpFilter `type:"structure" required:"true"`

	// The name of the IP address filter. The name must:
	//
	//  Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	// (_), or dashes (-). Start and end with a letter or number. Contain less than
	// 64 characters.
	Name *string `type:"string" required:"true"`

	metadataReceiptFilter `json:"-" xml:"-"`
}

type metadataReceiptFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReceiptFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptFilter) GoString() string {
	return s.String()
}

// A receipt IP address filter enables you to specify whether to accept or reject
// mail originating from an IP address or range of IP addresses.
//
// For information about setting up IP address filters, see the Amazon SES
// Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html).
type ReceiptIpFilter struct {
	// A single IP address or a range of IP addresses that you want to block or
	// allow, specified in Classless Inter-Domain Routing (CIDR) notation. An example
	// of a single email address is 10.0.0.1. An example of a range of IP addresses
	// is 10.0.0.1/24. For more information about CIDR notation, see RFC 2317 (https://tools.ietf.org/html/rfc2317).
	Cidr *string `type:"string" required:"true"`

	// Indicates whether to block or allow incoming mail from the specified IP addresses.
	Policy *string `type:"string" required:"true" enum:"ReceiptFilterPolicy"`

	metadataReceiptIpFilter `json:"-" xml:"-"`
}

type metadataReceiptIpFilter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReceiptIpFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptIpFilter) GoString() string {
	return s.String()
}

// Receipt rules enable you to specify which actions Amazon SES should take
// when it receives mail on behalf of one or more email addresses or domains
// that you own.
//
// Each receipt rule defines a set of email addresses or domains to which it
// applies. If the email addresses or domains match at least one recipient address
// of the message, Amazon SES executes all of the receipt rule's actions on
// the message.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
type ReceiptRule struct {
	// An ordered list of actions to perform on messages that match at least one
	// of the recipient email addresses or domains specified in the receipt rule.
	Actions []*ReceiptAction `type:"list"`

	// If true, the receipt rule is active. The default value is true.
	Enabled *bool `type:"boolean"`

	// The name of the receipt rule. The name must:
	//
	//  Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	// (_), or dashes (-). Start and end with a letter or number. Contain less than
	// 64 characters.
	Name *string `type:"string" required:"true"`

	// The recipient domains and email addresses to which the receipt rule applies.
	// If this field is not specified, this rule will match all recipients under
	// all verified domains.
	Recipients []*string `type:"list"`

	// If true, then messages to which this receipt rule applies are scanned for
	// spam and viruses. The default value is true.
	ScanEnabled *bool `type:"boolean"`

	// Specifies whether Amazon SES should require that incoming email is delivered
	// over a connection encrypted with Transport Layer Security (TLS). If this
	// parameter is set to Require, Amazon SES will bounce emails that are not received
	// over TLS. The default is Optional.
	TlsPolicy *string `type:"string" enum:"TlsPolicy"`

	metadataReceiptRule `json:"-" xml:"-"`
}

type metadataReceiptRule struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReceiptRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptRule) GoString() string {
	return s.String()
}

// Information about a receipt rule set.
//
// A receipt rule set is a collection of rules that specify what Amazon SES
// should do with mail it receives on behalf of your account's verified domains.
//
// For information about setting up receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rule-set.html).
type ReceiptRuleSetMetadata struct {
	// The date and time the receipt rule set was created.
	CreatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the receipt rule set. The name must:
	//
	//  Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores
	// (_), or dashes (-). Start and end with a letter or number. Contain less than
	// 64 characters.
	Name *string `type:"string"`

	metadataReceiptRuleSetMetadata `json:"-" xml:"-"`
}

type metadataReceiptRuleSetMetadata struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReceiptRuleSetMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReceiptRuleSetMetadata) GoString() string {
	return s.String()
}

// Recipient-related information to include in the Delivery Status Notification
// (DSN) when an email that Amazon SES receives on your behalf bounces.
//
// For information about receiving email through Amazon SES, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html).
type RecipientDsnFields struct {
	// The action performed by the reporting mail transfer agent (MTA) as a result
	// of its attempt to deliver the message to the recipient address. This is required
	// by RFC 3464 (https://tools.ietf.org/html/rfc3464).
	Action *string `type:"string" required:"true" enum:"DsnAction"`

	// An extended explanation of what went wrong; this is usually an SMTP response.
	// See RFC 3463 (https://tools.ietf.org/html/rfc3463) for the correct formatting
	// of this parameter.
	DiagnosticCode *string `type:"string"`

	// Additional X-headers to include in the DSN.
	ExtensionFields []*ExtensionField `type:"list"`

	// The email address to which the message was ultimately delivered. This corresponds
	// to the Final-Recipient in the DSN. If not specified, FinalRecipient will
	// be set to the Recipient specified in the BouncedRecipientInfo structure.
	// Either FinalRecipient or the recipient in BouncedRecipientInfo must be a
	// recipient of the original bounced message.
	//
	// Do not prepend the FinalRecipient email address with rfc 822;, as described
	// in RFC 3798 (https://tools.ietf.org/html/rfc3798).
	FinalRecipient *string `type:"string"`

	// The time the final delivery attempt was made, in RFC 822 (https://www.ietf.org/rfc/rfc0822.txt)
	// date-time format.
	LastAttemptDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The MTA to which the remote MTA attempted to deliver the message, formatted
	// as specified in RFC 3464 (https://tools.ietf.org/html/rfc3464) (mta-name-type;
	// mta-name). This parameter typically applies only to propagating synchronous
	// bounces.
	RemoteMta *string `type:"string"`

	// The status code that indicates what went wrong. This is required by RFC 3464
	// (https://tools.ietf.org/html/rfc3464).
	Status *string `type:"string" required:"true"`

	metadataRecipientDsnFields `json:"-" xml:"-"`
}

type metadataRecipientDsnFields struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RecipientDsnFields) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecipientDsnFields) GoString() string {
	return s.String()
}

type ReorderReceiptRuleSetInput struct {
	// A list of the specified receipt rule set's receipt rules in the order that
	// you want to put them.
	RuleNames []*string `type:"list" required:"true"`

	// The name of the receipt rule set to reorder.
	RuleSetName *string `type:"string" required:"true"`

	metadataReorderReceiptRuleSetInput `json:"-" xml:"-"`
}

type metadataReorderReceiptRuleSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReorderReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReorderReceiptRuleSetInput) GoString() string {
	return s.String()
}

type ReorderReceiptRuleSetOutput struct {
	metadataReorderReceiptRuleSetOutput `json:"-" xml:"-"`
}

type metadataReorderReceiptRuleSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ReorderReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReorderReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action saves the received message to
// an Amazon Simple Storage Service (Amazon S3) bucket and, optionally, publishes
// a notification to Amazon Simple Notification Service (Amazon SNS).
//
// To enable Amazon SES to write emails to your Amazon S3 bucket, use an AWS
// KMS key to encrypt your emails, or publish to an Amazon SNS topic of another
// account, Amazon SES must have permission to access those resources. For information
// about giving permissions, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
// When you save your emails to an Amazon S3 bucket, the maximum email size
// (including headers) is 30 MB. Emails larger than that will bounce. For information
// about specifying Amazon S3 actions in receipt rules, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-s3.html).
type S3Action struct {
	// The name of the Amazon S3 bucket to which to save the received email.
	BucketName *string `type:"string" required:"true"`

	// The customer master key that Amazon SES should use to encrypt your emails
	// before saving them to the Amazon S3 bucket. You can use the default master
	// key or a custom master key you created in AWS KMS as follows:
	//
	//  To use the default master key, provide an ARN in the form of arn:aws:kms:REGION:ACCOUNT-ID-WITHOUT-HYPHENS:alias/aws/ses.
	// For example, if your AWS account ID is 123456789012 and you want to use the
	// default master key in the US West (Oregon) region, the ARN of the default
	// master key would be arn:aws:kms:us-west-2:123456789012:alias/aws/ses. If
	// you use the default master key, you don't need to perform any extra steps
	// to give Amazon SES permission to use the key. To use a custom master key
	// you created in AWS KMS, provide the ARN of the master key and ensure that
	// you add a statement to your key's policy to give Amazon SES permission to
	// use it. For more information about giving permissions, see the Amazon SES
	// Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
	//  For more information about key policies, see the AWS KMS Developer Guide
	// (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html). If
	// you do not specify a master key, Amazon SES will not encrypt your emails.
	//
	// Your mail is encrypted by Amazon SES using the Amazon S3 encryption client
	// before the mail is submitted to Amazon S3 for storage. It is not encrypted
	// using Amazon S3 server-side encryption. This means that you must use the
	// Amazon S3 encryption client to decrypt the email after retrieving it from
	// Amazon S3, as the service has no access to use your AWS KMS keys for decryption.
	// This encryption client is currently available with the AWS Java SDK (https://aws.amazon.com/sdk-for-java/)
	// and AWS Ruby SDK (https://aws.amazon.com/sdk-for-ruby/) only. For more information
	// about client-side encryption using AWS KMS master keys, see the Amazon S3
	// Developer Guide (http://alpha-docs-aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html).
	KmsKeyArn *string `type:"string"`

	// The key prefix of the Amazon S3 bucket. The key prefix is similar to a directory
	// name that enables you to store similar data under the same directory in a
	// bucket.
	ObjectKeyPrefix *string `type:"string"`

	// The ARN of the Amazon SNS topic to notify when the message is saved to the
	// Amazon S3 bucket. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`

	metadataS3Action `json:"-" xml:"-"`
}

type metadataS3Action struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s S3Action) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Action) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action publishes a notification to
// Amazon Simple Notification Service (Amazon SNS). This action includes a complete
// copy of the email content in the Amazon SNS notifications. Amazon SNS notifications
// for all other actions simply provide information about the email. They do
// not include the email content itself.
//
// If you own the Amazon SNS topic, you don't need to do anything to give Amazon
// SES permission to publish emails to it. However, if you don't own the Amazon
// SNS topic, you need to attach a policy to the topic to give Amazon SES permissions
// to access it. For information about giving permissions, see the Amazon SES
// Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-permissions.html).
//
// You can only publish emails that are 150 KB or less (including the header)
// to Amazon SNS. Larger emails will bounce. If you anticipate emails larger
// than 150 KB, use the S3 action instead. For information about using a receipt
// rule to publish an Amazon SNS notification, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-sns.html).
type SNSAction struct {
	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify. An example
	// of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string" required:"true"`

	metadataSNSAction `json:"-" xml:"-"`
}

type metadataSNSAction struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SNSAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SNSAction) GoString() string {
	return s.String()
}

// Request object for sending a simple/complex bounce. It contains all of the
// information needed to generate a basic DSN or a fully-customized DSN.
type SendBounceInput struct {
	// The address to use in the "From" header of the bounce message. This must
	// be an identity that you have verified with Amazon SES.
	BounceSender *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the address in the "From" header of the bounce. For more information
	// about sending authorization, see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	BounceSenderArn *string `type:"string"`

	// A list of recipients of the bounced message, including the information required
	// to create the Delivery Status Notifications (DSNs) for the recipients. You
	// must specify at least one BouncedRecipientInfo in the list.
	BouncedRecipientInfoList []*BouncedRecipientInfo `type:"list" required:"true"`

	// Human-readable text for the bounce message to explain the failure. If not
	// specified, the text will be auto-generated based on the bounced recipient
	// information.
	Explanation *string `type:"string"`

	// Message-related DSN fields. If not specified, Amazon SES will choose the
	// values.
	MessageDsn *MessageDsn `type:"structure"`

	// The message ID of the message to be bounced.
	OriginalMessageId *string `type:"string" required:"true"`

	metadataSendBounceInput `json:"-" xml:"-"`
}

type metadataSendBounceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendBounceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendBounceInput) GoString() string {
	return s.String()
}

type SendBounceOutput struct {
	// The message ID of the bounce message.
	MessageId *string `type:"string"`

	metadataSendBounceOutput `json:"-" xml:"-"`
}

type metadataSendBounceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendBounceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendBounceOutput) GoString() string {
	return s.String()
}

// Represents sending statistics data. Each SendDataPoint contains statistics
// for a 15-minute period of sending activity.
type SendDataPoint struct {
	// Number of emails that have bounced.
	Bounces *int64 `type:"long"`

	// Number of unwanted emails that were rejected by recipients.
	Complaints *int64 `type:"long"`

	// Number of emails that have been enqueued for sending.
	DeliveryAttempts *int64 `type:"long"`

	// Number of emails rejected by Amazon SES.
	Rejects *int64 `type:"long"`

	// Time of the data point.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	metadataSendDataPoint `json:"-" xml:"-"`
}

type metadataSendDataPoint struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendDataPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendDataPoint) GoString() string {
	return s.String()
}

// Represents a request instructing the service to send a single email message.
//
// This datatype can be used in application code to compose a message consisting
// of source, destination, message, reply-to, and return-path parts. This object
// can then be sent using the SendEmail action.
type SendEmailInput struct {
	// The destination for this email, composed of To:, CC:, and BCC: fields.
	Destination *Destination `type:"structure" required:"true"`

	// The message to be sent.
	Message *Message `type:"structure" required:"true"`

	// The reply-to email address(es) for the message. If the recipient replies
	// to the message, each reply-to address will receive the reply.
	ReplyToAddresses []*string `type:"list"`

	// The email address to which bounces and complaints are to be forwarded when
	// feedback forwarding is enabled. If the message cannot be delivered to the
	// recipient, then an error message will be returned from the recipient's ISP;
	// this message will then be forwarded to the email address specified by the
	// ReturnPath parameter. The ReturnPath parameter is never overwritten. This
	// email address must be either individually verified with Amazon SES, or from
	// a domain that has been verified with Amazon SES.
	ReturnPath *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	ReturnPathArn *string `type:"string"`

	// The email address that is sending the email. This email address must be either
	// individually verified with Amazon SES, or from a domain that has been verified
	// with Amazon SES. For information about verifying identities, see the Amazon
	// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
	//
	// If you are sending on behalf of another user and have been permitted to
	// do so by a sending authorization policy, then you must also specify the SourceArn
	// parameter. For more information about sending authorization, see the Amazon
	// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	//
	//  In all cases, the email address must be 7-bit ASCII. If the text must contain
	// any other characters, then you must use MIME encoded-word syntax (RFC 2047)
	// instead of a literal string. MIME encoded-word syntax uses the following
	// form: =?charset?encoding?encoded-text?=. For more information, see RFC 2047
	// (http://tools.ietf.org/html/rfc2047).
	Source *string `type:"string" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// For more information about sending authorization, see the Amazon SES Developer
	// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html).
	SourceArn *string `type:"string"`

	metadataSendEmailInput `json:"-" xml:"-"`
}

type metadataSendEmailInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailInput) GoString() string {
	return s.String()
}

// Represents a unique message ID returned from a successful SendEmail request.
type SendEmailOutput struct {
	// The unique message identifier returned from the SendEmail action.
	MessageId *string `type:"string" required:"true"`

	metadataSendEmailOutput `json:"-" xml:"-"`
}

type metadataSendEmailOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendEmailOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to send a raw email message.
//
// This datatype can be used in application code to compose a message consisting
// of source, destination, and raw message text. This object can then be sent
// using the SendRawEmail action.
type SendRawEmailInput struct {
	// A list of destinations for the message, consisting of To:, CC:, and BCC:
	// addresses.
	Destinations []*string `type:"list"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to specify a particular "From" address in the header of the raw email.
	//
	// Instead of using this parameter, you can use the X-header X-SES-FROM-ARN
	// in the raw message of the email. If you use both the FromArn parameter and
	// the corresponding X-header, Amazon SES uses the value of the FromArn parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
	FromArn *string `type:"string"`

	// The raw text of the message. The client is responsible for ensuring the following:
	//
	//   Message must contain a header and a body, separated by a blank line. All
	// required header fields must be present. Each part of a multipart MIME message
	// must be formatted properly. MIME content types must be among those supported
	// by Amazon SES. For more information, go to the Amazon SES Developer Guide
	// (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types.html).
	// Content must be base64-encoded, if MIME requires it.
	RawMessage *RawMessage `type:"structure" required:"true"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to use the email address specified in the ReturnPath parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to use feedback@example.com,
	// then you would specify the ReturnPathArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the ReturnPath to be feedback@example.com.
	//
	// Instead of using this parameter, you can use the X-header X-SES-RETURN-PATH-ARN
	// in the raw message of the email. If you use both the ReturnPathArn parameter
	// and the corresponding X-header, Amazon SES uses the value of the ReturnPathArn
	// parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
	ReturnPathArn *string `type:"string"`

	// The identity's email address. If you do not provide a value for this parameter,
	// you must specify a "From" address in the raw text of the message. (You can
	// also specify both.)
	//
	//  By default, the string must be 7-bit ASCII. If the text must contain any
	// other characters, then you must use MIME encoded-word syntax (RFC 2047) instead
	// of a literal string. MIME encoded-word syntax uses the following form: =?charset?encoding?encoded-text?=.
	// For more information, see RFC 2047 (http://tools.ietf.org/html/rfc2047).
	//
	// If you specify the Source parameter and have feedback forwarding enabled,
	// then bounces and complaints will be sent to this email address. This takes
	// precedence over any Return-Path header that you might include in the raw
	// text of the message.
	Source *string `type:"string"`

	// This parameter is used only for sending authorization. It is the ARN of the
	// identity that is associated with the sending authorization policy that permits
	// you to send for the email address specified in the Source parameter.
	//
	// For example, if the owner of example.com (which has ARN arn:aws:ses:us-east-1:123456789012:identity/example.com)
	// attaches a policy to it that authorizes you to send from user@example.com,
	// then you would specify the SourceArn to be arn:aws:ses:us-east-1:123456789012:identity/example.com,
	// and the Source to be user@example.com.
	//
	// Instead of using this parameter, you can use the X-header X-SES-SOURCE-ARN
	// in the raw message of the email. If you use both the SourceArn parameter
	// and the corresponding X-header, Amazon SES uses the value of the SourceArn
	// parameter.
	//
	// For information about when to use this parameter, see the description of
	// SendRawEmail in this guide, or see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization-delegate-sender-tasks-email.html).
	SourceArn *string `type:"string"`

	metadataSendRawEmailInput `json:"-" xml:"-"`
}

type metadataSendRawEmailInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendRawEmailInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendRawEmailInput) GoString() string {
	return s.String()
}

// Represents a unique message ID returned from a successful SendRawEmail request.
type SendRawEmailOutput struct {
	// The unique message identifier returned from the SendRawEmail action.
	MessageId *string `type:"string" required:"true"`

	metadataSendRawEmailOutput `json:"-" xml:"-"`
}

type metadataSendRawEmailOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SendRawEmailOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SendRawEmailOutput) GoString() string {
	return s.String()
}

type SetActiveReceiptRuleSetInput struct {
	// The name of the receipt rule set to make active. Setting this value to null
	// disables all email receiving.
	RuleSetName *string `type:"string"`

	metadataSetActiveReceiptRuleSetInput `json:"-" xml:"-"`
}

type metadataSetActiveReceiptRuleSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetActiveReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetActiveReceiptRuleSetInput) GoString() string {
	return s.String()
}

type SetActiveReceiptRuleSetOutput struct {
	metadataSetActiveReceiptRuleSetOutput `json:"-" xml:"-"`
}

type metadataSetActiveReceiptRuleSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetActiveReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetActiveReceiptRuleSetOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to enable or disable DKIM signing
// for an identity.
type SetIdentityDkimEnabledInput struct {
	// Sets whether DKIM signing is enabled for an identity. Set to true to enable
	// DKIM signing for this identity; false to disable it.
	DkimEnabled *bool `type:"boolean" required:"true"`

	// The identity for which DKIM signing should be enabled or disabled.
	Identity *string `type:"string" required:"true"`

	metadataSetIdentityDkimEnabledInput `json:"-" xml:"-"`
}

type metadataSetIdentityDkimEnabledInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityDkimEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityDkimEnabledInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type SetIdentityDkimEnabledOutput struct {
	metadataSetIdentityDkimEnabledOutput `json:"-" xml:"-"`
}

type metadataSetIdentityDkimEnabledOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityDkimEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityDkimEnabledOutput) GoString() string {
	return s.String()
}

type SetIdentityFeedbackForwardingEnabledInput struct {
	// Sets whether Amazon SES will forward bounce and complaint notifications as
	// email. true specifies that Amazon SES will forward bounce and complaint notifications
	// as email, in addition to any Amazon SNS topic publishing otherwise specified.
	// false specifies that Amazon SES will publish bounce and complaint notifications
	// only through Amazon SNS. This value can only be set to false when Amazon
	// SNS topics are set for both Bounce and Complaint notification types.
	ForwardingEnabled *bool `type:"boolean" required:"true"`

	// The identity for which to set bounce and complaint notification forwarding.
	// Examples: user@example.com, example.com.
	Identity *string `type:"string" required:"true"`

	metadataSetIdentityFeedbackForwardingEnabledInput `json:"-" xml:"-"`
}

type metadataSetIdentityFeedbackForwardingEnabledInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityFeedbackForwardingEnabledInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityFeedbackForwardingEnabledInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type SetIdentityFeedbackForwardingEnabledOutput struct {
	metadataSetIdentityFeedbackForwardingEnabledOutput `json:"-" xml:"-"`
}

type metadataSetIdentityFeedbackForwardingEnabledOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityFeedbackForwardingEnabledOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityFeedbackForwardingEnabledOutput) GoString() string {
	return s.String()
}

// Represents a request to set or clear an identity's notification topic.
type SetIdentityNotificationTopicInput struct {
	// The identity for which the Amazon SNS topic will be set. You can specify
	// an identity by using its name or by using its Amazon Resource Name (ARN).
	// Examples: user@example.com, example.com, arn:aws:ses:us-east-1:123456789012:identity/example.com.
	Identity *string `type:"string" required:"true"`

	// The type of notifications that will be published to the specified Amazon
	// SNS topic.
	NotificationType *string `type:"string" required:"true" enum:"NotificationType"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic. If the parameter
	// is omitted from the request or a null value is passed, SnsTopic is cleared
	// and publishing is disabled.
	SnsTopic *string `type:"string"`

	metadataSetIdentityNotificationTopicInput `json:"-" xml:"-"`
}

type metadataSetIdentityNotificationTopicInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityNotificationTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityNotificationTopicInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type SetIdentityNotificationTopicOutput struct {
	metadataSetIdentityNotificationTopicOutput `json:"-" xml:"-"`
}

type metadataSetIdentityNotificationTopicOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetIdentityNotificationTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetIdentityNotificationTopicOutput) GoString() string {
	return s.String()
}

type SetReceiptRulePositionInput struct {
	// The name of the receipt rule after which to place the specified receipt rule.
	After *string `type:"string"`

	// The name of the receipt rule to reposition.
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set that contains the receipt rule to reposition.
	RuleSetName *string `type:"string" required:"true"`

	metadataSetReceiptRulePositionInput `json:"-" xml:"-"`
}

type metadataSetReceiptRulePositionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetReceiptRulePositionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetReceiptRulePositionInput) GoString() string {
	return s.String()
}

type SetReceiptRulePositionOutput struct {
	metadataSetReceiptRulePositionOutput `json:"-" xml:"-"`
}

type metadataSetReceiptRulePositionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetReceiptRulePositionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetReceiptRulePositionOutput) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action terminates the evaluation of
// the receipt rule set and, optionally, publishes a notification to Amazon
// Simple Notification Service (Amazon SNS).
//
// For information about setting a stop action in a receipt rule, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-stop.html).
type StopAction struct {
	// The scope to which the Stop action applies. That is, what is being stopped.
	Scope *string `type:"string" required:"true" enum:"StopScope"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// stop action is taken. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`

	metadataStopAction `json:"-" xml:"-"`
}

type metadataStopAction struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StopAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopAction) GoString() string {
	return s.String()
}

type UpdateReceiptRuleInput struct {
	// A data structure that contains the updated receipt rule information.
	Rule *ReceiptRule `type:"structure" required:"true"`

	// The name of the receipt rule set to which the receipt rule belongs.
	RuleSetName *string `type:"string" required:"true"`

	metadataUpdateReceiptRuleInput `json:"-" xml:"-"`
}

type metadataUpdateReceiptRuleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReceiptRuleInput) GoString() string {
	return s.String()
}

type UpdateReceiptRuleOutput struct {
	metadataUpdateReceiptRuleOutput `json:"-" xml:"-"`
}

type metadataUpdateReceiptRuleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateReceiptRuleOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to begin DKIM verification for
// a domain.
type VerifyDomainDkimInput struct {
	// The name of the domain to be verified for Easy DKIM signing.
	Domain *string `type:"string" required:"true"`

	metadataVerifyDomainDkimInput `json:"-" xml:"-"`
}

type metadataVerifyDomainDkimInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyDomainDkimInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainDkimInput) GoString() string {
	return s.String()
}

// Represents the DNS records that must be published in the domain name's DNS
// to complete DKIM setup.
type VerifyDomainDkimOutput struct {
	// A set of character strings that represent the domain's identity. If the identity
	// is an email address, the tokens represent the domain of that address.
	//
	// Using these tokens, you will need to create DNS CNAME records that point
	// to DKIM public keys hosted by Amazon SES. Amazon Web Services will eventually
	// detect that you have updated your DNS records; this detection process may
	// take up to 72 hours. Upon successful detection, Amazon SES will be able to
	// DKIM-sign emails originating from that domain.
	//
	// For more information about creating DNS records using DKIM tokens, go to
	// the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim-dns-records.html).
	DkimTokens []*string `type:"list" required:"true"`

	metadataVerifyDomainDkimOutput `json:"-" xml:"-"`
}

type metadataVerifyDomainDkimOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyDomainDkimOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainDkimOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to begin domain verification.
type VerifyDomainIdentityInput struct {
	// The domain to be verified.
	Domain *string `type:"string" required:"true"`

	metadataVerifyDomainIdentityInput `json:"-" xml:"-"`
}

type metadataVerifyDomainIdentityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyDomainIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainIdentityInput) GoString() string {
	return s.String()
}

// Represents a token used for domain ownership verification.
type VerifyDomainIdentityOutput struct {
	// A TXT record that must be placed in the DNS settings for the domain, in order
	// to complete domain verification.
	VerificationToken *string `type:"string" required:"true"`

	metadataVerifyDomainIdentityOutput `json:"-" xml:"-"`
}

type metadataVerifyDomainIdentityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyDomainIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyDomainIdentityOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to begin email address verification.
type VerifyEmailAddressInput struct {
	// The email address to be verified.
	EmailAddress *string `type:"string" required:"true"`

	metadataVerifyEmailAddressInput `json:"-" xml:"-"`
}

type metadataVerifyEmailAddressInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailAddressInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailAddressInput) GoString() string {
	return s.String()
}

type VerifyEmailAddressOutput struct {
	metadataVerifyEmailAddressOutput `json:"-" xml:"-"`
}

type metadataVerifyEmailAddressOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailAddressOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailAddressOutput) GoString() string {
	return s.String()
}

// Represents a request instructing the service to begin email address verification.
type VerifyEmailIdentityInput struct {
	// The email address to be verified.
	EmailAddress *string `type:"string" required:"true"`

	metadataVerifyEmailIdentityInput `json:"-" xml:"-"`
}

type metadataVerifyEmailIdentityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailIdentityInput) GoString() string {
	return s.String()
}

// An empty element. Receiving this element indicates that the request completed
// successfully.
type VerifyEmailIdentityOutput struct {
	metadataVerifyEmailIdentityOutput `json:"-" xml:"-"`
}

type metadataVerifyEmailIdentityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VerifyEmailIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VerifyEmailIdentityOutput) GoString() string {
	return s.String()
}

// When included in a receipt rule, this action calls Amazon WorkMail and, optionally,
// publishes a notification to Amazon Simple Notification Service (Amazon SNS).
// You will typically not use this action directly because Amazon WorkMail adds
// the rule automatically during its setup procedure.
//
// For information using a receipt rule to call Amazon WorkMail, see the Amazon
// SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-workmail.html).
type WorkmailAction struct {
	// The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail
	// organization ARN is arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7.
	// For information about Amazon WorkMail organizations, see the Amazon WorkMail
	// Administrator Guide (http://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html).
	OrganizationArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the
	// WorkMail action is called. An example of an Amazon SNS topic ARN is arn:aws:sns:us-west-2:123456789012:MyTopic.
	// For more information about Amazon SNS topics, see the Amazon SNS Developer
	// Guide (http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html).
	TopicArn *string `type:"string"`

	metadataWorkmailAction `json:"-" xml:"-"`
}

type metadataWorkmailAction struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s WorkmailAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkmailAction) GoString() string {
	return s.String()
}

const (
	// @enum BounceType
	BounceTypeDoesNotExist = "DoesNotExist"
	// @enum BounceType
	BounceTypeMessageTooLarge = "MessageTooLarge"
	// @enum BounceType
	BounceTypeExceededQuota = "ExceededQuota"
	// @enum BounceType
	BounceTypeContentRejected = "ContentRejected"
	// @enum BounceType
	BounceTypeUndefined = "Undefined"
	// @enum BounceType
	BounceTypeTemporaryFailure = "TemporaryFailure"
)

const (
	// @enum DsnAction
	DsnActionFailed = "failed"
	// @enum DsnAction
	DsnActionDelayed = "delayed"
	// @enum DsnAction
	DsnActionDelivered = "delivered"
	// @enum DsnAction
	DsnActionRelayed = "relayed"
	// @enum DsnAction
	DsnActionExpanded = "expanded"
)

const (
	// @enum IdentityType
	IdentityTypeEmailAddress = "EmailAddress"
	// @enum IdentityType
	IdentityTypeDomain = "Domain"
)

const (
	// @enum InvocationType
	InvocationTypeEvent = "Event"
	// @enum InvocationType
	InvocationTypeRequestResponse = "RequestResponse"
)

const (
	// @enum NotificationType
	NotificationTypeBounce = "Bounce"
	// @enum NotificationType
	NotificationTypeComplaint = "Complaint"
	// @enum NotificationType
	NotificationTypeDelivery = "Delivery"
)

const (
	// @enum ReceiptFilterPolicy
	ReceiptFilterPolicyBlock = "Block"
	// @enum ReceiptFilterPolicy
	ReceiptFilterPolicyAllow = "Allow"
)

const (
	// @enum StopScope
	StopScopeRuleSet = "RuleSet"
)

const (
	// @enum TlsPolicy
	TlsPolicyRequire = "Require"
	// @enum TlsPolicy
	TlsPolicyOptional = "Optional"
)

const (
	// @enum VerificationStatus
	VerificationStatusPending = "Pending"
	// @enum VerificationStatus
	VerificationStatusSuccess = "Success"
	// @enum VerificationStatus
	VerificationStatusFailed = "Failed"
	// @enum VerificationStatus
	VerificationStatusTemporaryFailure = "TemporaryFailure"
	// @enum VerificationStatus
	VerificationStatusNotStarted = "NotStarted"
)
