// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package simpledb

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/corehandlers"
	"github.com/aws/aws-sdk-go/aws/defaults"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/service"
	"github.com/aws/aws-sdk-go/aws/service/serviceinfo"
	"github.com/aws/aws-sdk-go/internal/protocol/query"
	"github.com/aws/aws-sdk-go/internal/signer/v2"
)

// Amazon SimpleDB is a web service providing the core database functions of
// data indexing and querying in the cloud. By offloading the time and effort
// associated with building and operating a web-scale database, SimpleDB provides
// developers the freedom to focus on application development.  A traditional,
// clustered relational database requires a sizable upfront capital outlay,
// is complex to design, and often requires extensive and repetitive database
// administration. Amazon SimpleDB is dramatically simpler, requiring no schema,
// automatically indexing your data and providing a simple API for storage and
// access. This approach eliminates the administrative burden of data modeling,
// index maintenance, and performance tuning. Developers gain access to this
// functionality within Amazon's proven computing environment, are able to scale
// instantly, and pay only for what they use.
//
//  Visit http://aws.amazon.com/simpledb/ (http://aws.amazon.com/simpledb/)
// for more information.
type SimpleDB struct {
	*service.Service
}

// Used for custom service initialization logic
var initService func(*service.Service)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// New returns a new SimpleDB client.
func New(config *aws.Config) *SimpleDB {
	service := &service.Service{
		ServiceInfo: serviceinfo.ServiceInfo{
			Config:      defaults.DefaultConfig.Merge(config),
			ServiceName: "sdb",
			APIVersion:  "2009-04-15",
		},
	}
	service.Initialize()

	// Handlers
	service.Handlers.Sign.PushBack(v2.Sign)
	service.Handlers.Sign.PushBackNamed(corehandlers.BuildContentLengthHandler)
	service.Handlers.Build.PushBack(query.Build)
	service.Handlers.Unmarshal.PushBack(query.Unmarshal)
	service.Handlers.UnmarshalMeta.PushBack(query.UnmarshalMeta)
	service.Handlers.UnmarshalError.PushBack(query.UnmarshalError)

	// Run custom service initialization if present
	if initService != nil {
		initService(service)
	}

	return &SimpleDB{service}
}

// newRequest creates a new request for a SimpleDB operation and runs any
// custom request initialization.
func (c *SimpleDB) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
