// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package support provides a client for AWS Support.
package support

import (
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddAttachmentsToSet = "AddAttachmentsToSet"

// AddAttachmentsToSetRequest generates a request for the AddAttachmentsToSet operation.
func (c *Support) AddAttachmentsToSetRequest(input *AddAttachmentsToSetInput) (req *request.Request, output *AddAttachmentsToSetOutput) {
	op := &request.Operation{
		Name:       opAddAttachmentsToSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddAttachmentsToSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddAttachmentsToSetOutput{}
	req.Data = output
	return
}

// Adds one or more attachments to an attachment set. If an AttachmentSetId
// is not specified, a new attachment set is created, and the ID of the set
// is returned in the response. If an AttachmentSetId is specified, the attachments
// are added to the specified set, if it exists.
//
// An attachment set is a temporary container for attachments that are to be
// added to a case or case communication. The set is available for one hour
// after it is created; the ExpiryTime returned in the response indicates when
// the set expires. The maximum number of attachments in a set is 3, and the
// maximum size of any attachment in the set is 5 MB.
func (c *Support) AddAttachmentsToSet(input *AddAttachmentsToSetInput) (*AddAttachmentsToSetOutput, error) {
	req, out := c.AddAttachmentsToSetRequest(input)
	err := req.Send()
	return out, err
}

const opAddCommunicationToCase = "AddCommunicationToCase"

// AddCommunicationToCaseRequest generates a request for the AddCommunicationToCase operation.
func (c *Support) AddCommunicationToCaseRequest(input *AddCommunicationToCaseInput) (req *request.Request, output *AddCommunicationToCaseOutput) {
	op := &request.Operation{
		Name:       opAddCommunicationToCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddCommunicationToCaseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddCommunicationToCaseOutput{}
	req.Data = output
	return
}

// Adds additional customer communication to an AWS Support case. You use the
// CaseId value to identify the case to add communication to. You can list a
// set of email addresses to copy on the communication using the CcEmailAddresses
// value. The CommunicationBody value contains the text of the communication.
//
// The response indicates the success or failure of the request.
//
// This operation implements a subset of the features of the AWS Support Center.
func (c *Support) AddCommunicationToCase(input *AddCommunicationToCaseInput) (*AddCommunicationToCaseOutput, error) {
	req, out := c.AddCommunicationToCaseRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCase = "CreateCase"

// CreateCaseRequest generates a request for the CreateCase operation.
func (c *Support) CreateCaseRequest(input *CreateCaseInput) (req *request.Request, output *CreateCaseOutput) {
	op := &request.Operation{
		Name:       opCreateCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCaseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCaseOutput{}
	req.Data = output
	return
}

// Creates a new case in the AWS Support Center. This operation is modeled on
// the behavior of the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
// page. Its parameters require you to specify the following information:
//
//   IssueType. The type of issue for the case. You can specify either "customer-service"
// or "technical." If you do not indicate a value, the default is "technical."
//   ServiceCode. The code for an AWS service. You obtain the ServiceCode by
// calling DescribeServices.   CategoryCode. The category for the service defined
// for the ServiceCode value. You also obtain the category code for a service
// by calling DescribeServices. Each AWS service defines its own set of category
// codes.   SeverityCode. A value that indicates the urgency of the case, which
// in turn determines the response time according to your service level agreement
// with AWS Support. You obtain the SeverityCode by calling DescribeSeverityLevels.
//  Subject. The Subject field on the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
// page.  CommunicationBody. The Description field on the AWS Support Center
// Create Case (https://console.aws.amazon.com/support/home#/case/create) page.
//  AttachmentSetId. The ID of a set of attachments that has been created by
// using AddAttachmentsToSet.  Language. The human language in which AWS Support
// handles the case. English and Japanese are currently supported.  CcEmailAddresses.
// The AWS Support Center CC field on the Create Case (https://console.aws.amazon.com/support/home#/case/create)
// page. You can list email addresses to be copied on any correspondence about
// the case. The account that opens the case is already identified by passing
// the AWS Credentials in the HTTP POST method or in a method or function call
// from one of the programming languages supported by an AWS SDK (http://aws.amazon.com/tools/).
//   To add additional communication or attachments to an existing case, use
// AddCommunicationToCase.
//
//  A successful CreateCase request returns an AWS Support case number. Case
// numbers are used by the DescribeCases operation to retrieve existing AWS
// Support cases.
func (c *Support) CreateCase(input *CreateCaseInput) (*CreateCaseOutput, error) {
	req, out := c.CreateCaseRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAttachment = "DescribeAttachment"

// DescribeAttachmentRequest generates a request for the DescribeAttachment operation.
func (c *Support) DescribeAttachmentRequest(input *DescribeAttachmentInput) (req *request.Request, output *DescribeAttachmentOutput) {
	op := &request.Operation{
		Name:       opDescribeAttachment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAttachmentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAttachmentOutput{}
	req.Data = output
	return
}

// Returns the attachment that has the specified ID. Attachment IDs are generated
// by the case management system when you add an attachment to a case or case
// communication. Attachment IDs are returned in the AttachmentDetails objects
// that are returned by the DescribeCommunications operation.
func (c *Support) DescribeAttachment(input *DescribeAttachmentInput) (*DescribeAttachmentOutput, error) {
	req, out := c.DescribeAttachmentRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCases = "DescribeCases"

// DescribeCasesRequest generates a request for the DescribeCases operation.
func (c *Support) DescribeCasesRequest(input *DescribeCasesInput) (req *request.Request, output *DescribeCasesOutput) {
	op := &request.Operation{
		Name:       opDescribeCases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCasesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCasesOutput{}
	req.Data = output
	return
}

// Returns a list of cases that you specify by passing one or more case IDs.
// In addition, you can filter the cases by date by setting values for the AfterTime
// and BeforeTime request parameters. You can set values for the IncludeResolvedCases
// and IncludeCommunications request parameters to control how much information
// is returned.
//
// Case data is available for 12 months after creation. If a case was created
// more than 12 months ago, a request for data might cause an error.
//
// The response returns the following in JSON format:
//
//  One or more CaseDetails data types.  One or more NextToken values, which
// specify where to paginate the returned records represented by the CaseDetails
// objects.
func (c *Support) DescribeCases(input *DescribeCasesInput) (*DescribeCasesOutput, error) {
	req, out := c.DescribeCasesRequest(input)
	err := req.Send()
	return out, err
}

func (c *Support) DescribeCasesPages(input *DescribeCasesInput, fn func(p *DescribeCasesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCasesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCasesOutput), lastPage)
	})
}

const opDescribeCommunications = "DescribeCommunications"

// DescribeCommunicationsRequest generates a request for the DescribeCommunications operation.
func (c *Support) DescribeCommunicationsRequest(input *DescribeCommunicationsInput) (req *request.Request, output *DescribeCommunicationsOutput) {
	op := &request.Operation{
		Name:       opDescribeCommunications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCommunicationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeCommunicationsOutput{}
	req.Data = output
	return
}

// Returns communications (and attachments) for one or more support cases. You
// can use the AfterTime and BeforeTime parameters to filter by date. You can
// use the CaseId parameter to restrict the results to a particular case.
//
// Case data is available for 12 months after creation. If a case was created
// more than 12 months ago, a request for data might cause an error.
//
// You can use the MaxResults and NextToken parameters to control the pagination
// of the result set. Set MaxResults to the number of cases you want displayed
// on each page, and use NextToken to specify the resumption of pagination.
func (c *Support) DescribeCommunications(input *DescribeCommunicationsInput) (*DescribeCommunicationsOutput, error) {
	req, out := c.DescribeCommunicationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Support) DescribeCommunicationsPages(input *DescribeCommunicationsInput, fn func(p *DescribeCommunicationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeCommunicationsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeCommunicationsOutput), lastPage)
	})
}

const opDescribeServices = "DescribeServices"

// DescribeServicesRequest generates a request for the DescribeServices operation.
func (c *Support) DescribeServicesRequest(input *DescribeServicesInput) (req *request.Request, output *DescribeServicesOutput) {
	op := &request.Operation{
		Name:       opDescribeServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeServicesOutput{}
	req.Data = output
	return
}

// Returns the current list of AWS services and a list of service categories
// that applies to each one. You then use service names and categories in your
// CreateCase requests. Each AWS service has its own set of categories.
//
// The service codes and category codes correspond to the values that are displayed
// in the Service and Category drop-down lists on the AWS Support Center Create
// Case (https://console.aws.amazon.com/support/home#/case/create) page. The
// values in those fields, however, do not necessarily match the service codes
// and categories returned by the DescribeServices request. Always use the service
// codes and categories obtained programmatically. This practice ensures that
// you always have the most recent set of service and category codes.
func (c *Support) DescribeServices(input *DescribeServicesInput) (*DescribeServicesOutput, error) {
	req, out := c.DescribeServicesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeSeverityLevels = "DescribeSeverityLevels"

// DescribeSeverityLevelsRequest generates a request for the DescribeSeverityLevels operation.
func (c *Support) DescribeSeverityLevelsRequest(input *DescribeSeverityLevelsInput) (req *request.Request, output *DescribeSeverityLevelsOutput) {
	op := &request.Operation{
		Name:       opDescribeSeverityLevels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSeverityLevelsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeSeverityLevelsOutput{}
	req.Data = output
	return
}

// Returns the list of severity levels that you can assign to an AWS Support
// case. The severity level for a case is also a field in the CaseDetails data
// type included in any CreateCase request.
func (c *Support) DescribeSeverityLevels(input *DescribeSeverityLevelsInput) (*DescribeSeverityLevelsOutput, error) {
	req, out := c.DescribeSeverityLevelsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrustedAdvisorCheckRefreshStatuses = "DescribeTrustedAdvisorCheckRefreshStatuses"

// DescribeTrustedAdvisorCheckRefreshStatusesRequest generates a request for the DescribeTrustedAdvisorCheckRefreshStatuses operation.
func (c *Support) DescribeTrustedAdvisorCheckRefreshStatusesRequest(input *DescribeTrustedAdvisorCheckRefreshStatusesInput) (req *request.Request, output *DescribeTrustedAdvisorCheckRefreshStatusesOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorCheckRefreshStatuses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorCheckRefreshStatusesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrustedAdvisorCheckRefreshStatusesOutput{}
	req.Data = output
	return
}

// Returns the refresh status of the Trusted Advisor checks that have the specified
// check IDs. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
func (c *Support) DescribeTrustedAdvisorCheckRefreshStatuses(input *DescribeTrustedAdvisorCheckRefreshStatusesInput) (*DescribeTrustedAdvisorCheckRefreshStatusesOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckRefreshStatusesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrustedAdvisorCheckResult = "DescribeTrustedAdvisorCheckResult"

// DescribeTrustedAdvisorCheckResultRequest generates a request for the DescribeTrustedAdvisorCheckResult operation.
func (c *Support) DescribeTrustedAdvisorCheckResultRequest(input *DescribeTrustedAdvisorCheckResultInput) (req *request.Request, output *DescribeTrustedAdvisorCheckResultOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorCheckResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorCheckResultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrustedAdvisorCheckResultOutput{}
	req.Data = output
	return
}

// Returns the results of the Trusted Advisor check that has the specified check
// ID. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// The response contains a TrustedAdvisorCheckResult object, which contains
// these three objects:
//
//  TrustedAdvisorCategorySpecificSummary TrustedAdvisorResourceDetail TrustedAdvisorResourcesSummary
//  In addition, the response contains these fields:
//
//   Status. The alert status of the check: "ok" (green), "warning" (yellow),
// "error" (red), or "not_available".  Timestamp. The time of the last refresh
// of the check.  CheckId. The unique identifier for the check.
func (c *Support) DescribeTrustedAdvisorCheckResult(input *DescribeTrustedAdvisorCheckResultInput) (*DescribeTrustedAdvisorCheckResultOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckResultRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrustedAdvisorCheckSummaries = "DescribeTrustedAdvisorCheckSummaries"

// DescribeTrustedAdvisorCheckSummariesRequest generates a request for the DescribeTrustedAdvisorCheckSummaries operation.
func (c *Support) DescribeTrustedAdvisorCheckSummariesRequest(input *DescribeTrustedAdvisorCheckSummariesInput) (req *request.Request, output *DescribeTrustedAdvisorCheckSummariesOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorCheckSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorCheckSummariesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrustedAdvisorCheckSummariesOutput{}
	req.Data = output
	return
}

// Returns the summaries of the results of the Trusted Advisor checks that have
// the specified check IDs. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// The response contains an array of TrustedAdvisorCheckSummary objects.
func (c *Support) DescribeTrustedAdvisorCheckSummaries(input *DescribeTrustedAdvisorCheckSummariesInput) (*DescribeTrustedAdvisorCheckSummariesOutput, error) {
	req, out := c.DescribeTrustedAdvisorCheckSummariesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTrustedAdvisorChecks = "DescribeTrustedAdvisorChecks"

// DescribeTrustedAdvisorChecksRequest generates a request for the DescribeTrustedAdvisorChecks operation.
func (c *Support) DescribeTrustedAdvisorChecksRequest(input *DescribeTrustedAdvisorChecksInput) (req *request.Request, output *DescribeTrustedAdvisorChecksOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedAdvisorChecks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedAdvisorChecksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTrustedAdvisorChecksOutput{}
	req.Data = output
	return
}

// Returns information about all available Trusted Advisor checks, including
// name, ID, category, description, and metadata. You must specify a language
// code; English ("en") and Japanese ("ja") are currently supported. The response
// contains a TrustedAdvisorCheckDescription for each check.
func (c *Support) DescribeTrustedAdvisorChecks(input *DescribeTrustedAdvisorChecksInput) (*DescribeTrustedAdvisorChecksOutput, error) {
	req, out := c.DescribeTrustedAdvisorChecksRequest(input)
	err := req.Send()
	return out, err
}

const opRefreshTrustedAdvisorCheck = "RefreshTrustedAdvisorCheck"

// RefreshTrustedAdvisorCheckRequest generates a request for the RefreshTrustedAdvisorCheck operation.
func (c *Support) RefreshTrustedAdvisorCheckRequest(input *RefreshTrustedAdvisorCheckInput) (req *request.Request, output *RefreshTrustedAdvisorCheckOutput) {
	op := &request.Operation{
		Name:       opRefreshTrustedAdvisorCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RefreshTrustedAdvisorCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RefreshTrustedAdvisorCheckOutput{}
	req.Data = output
	return
}

// Requests a refresh of the Trusted Advisor check that has the specified check
// ID. Check IDs can be obtained by calling DescribeTrustedAdvisorChecks.
//
// The response contains a TrustedAdvisorCheckRefreshStatus object, which contains
// these fields:
//
//   Status. The refresh status of the check: "none", "enqueued", "processing",
// "success", or "abandoned".  MillisUntilNextRefreshable. The amount of time,
// in milliseconds, until the check is eligible for refresh.  CheckId. The unique
// identifier for the check.
func (c *Support) RefreshTrustedAdvisorCheck(input *RefreshTrustedAdvisorCheckInput) (*RefreshTrustedAdvisorCheckOutput, error) {
	req, out := c.RefreshTrustedAdvisorCheckRequest(input)
	err := req.Send()
	return out, err
}

const opResolveCase = "ResolveCase"

// ResolveCaseRequest generates a request for the ResolveCase operation.
func (c *Support) ResolveCaseRequest(input *ResolveCaseInput) (req *request.Request, output *ResolveCaseOutput) {
	op := &request.Operation{
		Name:       opResolveCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResolveCaseInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ResolveCaseOutput{}
	req.Data = output
	return
}

// Takes a CaseId and returns the initial state of the case along with the state
// of the case after the call to ResolveCase completed.
func (c *Support) ResolveCase(input *ResolveCaseInput) (*ResolveCaseOutput, error) {
	req, out := c.ResolveCaseRequest(input)
	err := req.Send()
	return out, err
}

type AddAttachmentsToSetInput struct {
	// The ID of the attachment set. If an AttachmentSetId is not specified, a new
	// attachment set is created, and the ID of the set is returned in the response.
	// If an AttachmentSetId is specified, the attachments are added to the specified
	// set, if it exists.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// One or more attachments to add to the set. The limit is 3 attachments per
	// set, and the size limit is 5 MB per attachment.
	Attachments []*Attachment `locationName:"attachments" type:"list" required:"true"`

	metadataAddAttachmentsToSetInput `json:"-" xml:"-"`
}

type metadataAddAttachmentsToSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddAttachmentsToSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttachmentsToSetInput) GoString() string {
	return s.String()
}

// The ID and expiry time of the attachment set returned by the AddAttachmentsToSet
// operation.
type AddAttachmentsToSetOutput struct {
	// The ID of the attachment set. If an AttachmentSetId was not specified, a
	// new attachment set is created, and the ID of the set is returned in the response.
	// If an AttachmentSetId was specified, the attachments are added to the specified
	// set, if it exists.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The time and date when the attachment set expires.
	ExpiryTime *string `locationName:"expiryTime" type:"string"`

	metadataAddAttachmentsToSetOutput `json:"-" xml:"-"`
}

type metadataAddAttachmentsToSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddAttachmentsToSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddAttachmentsToSetOutput) GoString() string {
	return s.String()
}

// To be written.
type AddCommunicationToCaseInput struct {
	// The ID of a set of one or more attachments for the communication to add to
	// the case. Create the set by calling AddAttachmentsToSet
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	// The email addresses in the CC line of an email to be added to the support
	// case.
	CcEmailAddresses []*string `locationName:"ccEmailAddresses" type:"list"`

	// The body of an email communication to add to the support case.
	CommunicationBody *string `locationName:"communicationBody" type:"string" required:"true"`

	metadataAddCommunicationToCaseInput `json:"-" xml:"-"`
}

type metadataAddCommunicationToCaseInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddCommunicationToCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCommunicationToCaseInput) GoString() string {
	return s.String()
}

// The result of the AddCommunicationToCase operation.
type AddCommunicationToCaseOutput struct {
	// True if AddCommunicationToCase succeeds. Otherwise, returns an error.
	Result *bool `locationName:"result" type:"boolean"`

	metadataAddCommunicationToCaseOutput `json:"-" xml:"-"`
}

type metadataAddCommunicationToCaseOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddCommunicationToCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddCommunicationToCaseOutput) GoString() string {
	return s.String()
}

// An attachment to a case communication. The attachment consists of the file
// name and the content of the file.
type Attachment struct {
	// The content of the attachment file.
	Data []byte `locationName:"data" type:"blob"`

	// The name of the attachment file.
	FileName *string `locationName:"fileName" type:"string"`

	metadataAttachment `json:"-" xml:"-"`
}

type metadataAttachment struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Attachment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attachment) GoString() string {
	return s.String()
}

// The file name and ID of an attachment to a case communication. You can use
// the ID to retrieve the attachment with the DescribeAttachment operation.
type AttachmentDetails struct {
	// The ID of the attachment.
	AttachmentId *string `locationName:"attachmentId" type:"string"`

	// The file name of the attachment.
	FileName *string `locationName:"fileName" type:"string"`

	metadataAttachmentDetails `json:"-" xml:"-"`
}

type metadataAttachmentDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AttachmentDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachmentDetails) GoString() string {
	return s.String()
}

// A JSON-formatted object that contains the metadata for a support case. It
// is contained the response from a DescribeCases request. CaseDetails contains
// the following fields:
//
//   CaseID. The AWS Support case ID requested or returned in the call. The
// case ID is an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47.
//  CategoryCode. The category of problem for the AWS Support case. Corresponds
// to the CategoryCode values returned by a call to DescribeServices.  DisplayId.
// The identifier for the case on pages in the AWS Support Center.  Language.
// The ISO 639-1 code for the language in which AWS provides support. AWS Support
// currently supports English ("en") and Japanese ("ja"). Language parameters
// must be passed explicitly for operations that take them.  RecentCommunications.
// One or more Communication objects. Fields of these objects are Attachments,
// Body, CaseId, SubmittedBy, and TimeCreated.  NextToken. A resumption point
// for pagination.  ServiceCode. The identifier for the AWS service that corresponds
// to the service code defined in the call to DescribeServices.  SeverityCode.
// The severity code assigned to the case. Contains one of the values returned
// by the call to DescribeSeverityLevels.  Status. The status of the case in
// the AWS Support Center.  Subject. The subject line of the case.  SubmittedBy.
// The email address of the account that submitted the case.  TimeCreated. The
// time the case was created, in ISO-8601 format.
type CaseDetails struct {
	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	// The category of problem for the AWS Support case.
	CategoryCode *string `locationName:"categoryCode" type:"string"`

	// The email addresses that receive copies of communication about the case.
	CcEmailAddresses []*string `locationName:"ccEmailAddresses" type:"list"`

	// The ID displayed for the case in the AWS Support Center. This is a numeric
	// string.
	DisplayId *string `locationName:"displayId" type:"string"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The five most recent communications between you and AWS Support Center, including
	// the IDs of any attachments to the communications. Also includes a nextToken
	// that you can use to retrieve earlier communications.
	RecentCommunications *RecentCaseCommunications `locationName:"recentCommunications" type:"structure"`

	// The code for the AWS service returned by the call to DescribeServices.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// The code for the severity level returned by the call to DescribeSeverityLevels.
	SeverityCode *string `locationName:"severityCode" type:"string"`

	// The status of the case.
	Status *string `locationName:"status" type:"string"`

	// The subject line for the case in the AWS Support Center.
	Subject *string `locationName:"subject" type:"string"`

	// The email address of the account that submitted the case.
	SubmittedBy *string `locationName:"submittedBy" type:"string"`

	// The time that the case was case created in the AWS Support Center.
	TimeCreated *string `locationName:"timeCreated" type:"string"`

	metadataCaseDetails `json:"-" xml:"-"`
}

type metadataCaseDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CaseDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CaseDetails) GoString() string {
	return s.String()
}

// A JSON-formatted name/value pair that represents the category name and category
// code of the problem, selected from the DescribeServices response for each
// AWS service.
type Category struct {
	// The category code for the support case.
	Code *string `locationName:"code" type:"string"`

	// The category name for the support case.
	Name *string `locationName:"name" type:"string"`

	metadataCategory `json:"-" xml:"-"`
}

type metadataCategory struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Category) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Category) GoString() string {
	return s.String()
}

// A communication associated with an AWS Support case. The communication consists
// of the case ID, the message body, attachment information, the account email
// address, and the date and time of the communication.
type Communication struct {
	// Information about the attachments to the case communication.
	AttachmentSet []*AttachmentDetails `locationName:"attachmentSet" type:"list"`

	// The text of the communication between the customer and AWS Support.
	Body *string `locationName:"body" type:"string"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	// The email address of the account that submitted the AWS Support case.
	SubmittedBy *string `locationName:"submittedBy" type:"string"`

	// The time the communication was created.
	TimeCreated *string `locationName:"timeCreated" type:"string"`

	metadataCommunication `json:"-" xml:"-"`
}

type metadataCommunication struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Communication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Communication) GoString() string {
	return s.String()
}

type CreateCaseInput struct {
	// The ID of a set of one or more attachments for the case. Create the set by
	// using AddAttachmentsToSet.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The category of problem for the AWS Support case.
	CategoryCode *string `locationName:"categoryCode" type:"string"`

	// A list of email addresses that AWS Support copies on case correspondence.
	CcEmailAddresses []*string `locationName:"ccEmailAddresses" type:"list"`

	// The communication body text when you create an AWS Support case by calling
	// CreateCase.
	CommunicationBody *string `locationName:"communicationBody" type:"string" required:"true"`

	// The type of issue for the case. You can specify either "customer-service"
	// or "technical." If you do not indicate a value, the default is "technical."
	IssueType *string `locationName:"issueType" type:"string"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The code for the AWS service returned by the call to DescribeServices.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// The code for the severity level returned by the call to DescribeSeverityLevels.
	//
	// The availability of severity levels depends on each customer's support subscription.
	// In other words, your subscription may not necessarily require the urgent
	// level of response time.
	SeverityCode *string `locationName:"severityCode" type:"string"`

	// The title of the AWS Support case.
	Subject *string `locationName:"subject" type:"string" required:"true"`

	metadataCreateCaseInput `json:"-" xml:"-"`
}

type metadataCreateCaseInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCaseInput) GoString() string {
	return s.String()
}

// The AWS Support case ID returned by a successful completion of the CreateCase
// operation.
type CreateCaseOutput struct {
	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	metadataCreateCaseOutput `json:"-" xml:"-"`
}

type metadataCreateCaseOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCaseOutput) GoString() string {
	return s.String()
}

type DescribeAttachmentInput struct {
	// The ID of the attachment to return. Attachment IDs are returned by the DescribeCommunications
	// operation.
	AttachmentId *string `locationName:"attachmentId" type:"string" required:"true"`

	metadataDescribeAttachmentInput `json:"-" xml:"-"`
}

type metadataDescribeAttachmentInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAttachmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAttachmentInput) GoString() string {
	return s.String()
}

// The content and file name of the attachment returned by the DescribeAttachment
// operation.
type DescribeAttachmentOutput struct {
	// The attachment content and file name.
	Attachment *Attachment `locationName:"attachment" type:"structure"`

	metadataDescribeAttachmentOutput `json:"-" xml:"-"`
}

type metadataDescribeAttachmentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeAttachmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAttachmentOutput) GoString() string {
	return s.String()
}

type DescribeCasesInput struct {
	// The start date for a filtered date search on support case communications.
	// Case communications are available for 12 months after creation.
	AfterTime *string `locationName:"afterTime" type:"string"`

	// The end date for a filtered date search on support case communications. Case
	// communications are available for 12 months after creation.
	BeforeTime *string `locationName:"beforeTime" type:"string"`

	// A list of ID numbers of the support cases you want returned. The maximum
	// number of cases is 100.
	CaseIdList []*string `locationName:"caseIdList" type:"list"`

	// The ID displayed for a case in the AWS Support Center user interface.
	DisplayId *string `locationName:"displayId" type:"string"`

	// Specifies whether communications should be included in the DescribeCases
	// results. The default is true.
	IncludeCommunications *bool `locationName:"includeCommunications" type:"boolean"`

	// Specifies whether resolved support cases should be included in the DescribeCases
	// results. The default is false.
	IncludeResolvedCases *bool `locationName:"includeResolvedCases" type:"boolean"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The maximum number of results to return before paginating.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataDescribeCasesInput `json:"-" xml:"-"`
}

type metadataDescribeCasesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCasesInput) GoString() string {
	return s.String()
}

// Returns an array of CaseDetails objects and a NextToken that defines a point
// for pagination in the result set.
type DescribeCasesOutput struct {
	// The details for the cases that match the request.
	Cases []*CaseDetails `locationName:"cases" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataDescribeCasesOutput `json:"-" xml:"-"`
}

type metadataDescribeCasesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCasesOutput) GoString() string {
	return s.String()
}

type DescribeCommunicationsInput struct {
	// The start date for a filtered date search on support case communications.
	// Case communications are available for 12 months after creation.
	AfterTime *string `locationName:"afterTime" type:"string"`

	// The end date for a filtered date search on support case communications. Case
	// communications are available for 12 months after creation.
	BeforeTime *string `locationName:"beforeTime" type:"string"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string" required:"true"`

	// The maximum number of results to return before paginating.
	MaxResults *int64 `locationName:"maxResults" min:"10" type:"integer"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataDescribeCommunicationsInput `json:"-" xml:"-"`
}

type metadataDescribeCommunicationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCommunicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommunicationsInput) GoString() string {
	return s.String()
}

// The communications returned by the DescribeCommunications operation.
type DescribeCommunicationsOutput struct {
	// The communications for the case.
	Communications []*Communication `locationName:"communications" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataDescribeCommunicationsOutput `json:"-" xml:"-"`
}

type metadataDescribeCommunicationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeCommunicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommunicationsOutput) GoString() string {
	return s.String()
}

type DescribeServicesInput struct {
	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// A JSON-formatted list of service codes available for AWS services.
	ServiceCodeList []*string `locationName:"serviceCodeList" type:"list"`

	metadataDescribeServicesInput `json:"-" xml:"-"`
}

type metadataDescribeServicesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServicesInput) GoString() string {
	return s.String()
}

// The list of AWS services returned by the DescribeServices operation.
type DescribeServicesOutput struct {
	// A JSON-formatted list of AWS services.
	Services []*Service `locationName:"services" type:"list"`

	metadataDescribeServicesOutput `json:"-" xml:"-"`
}

type metadataDescribeServicesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServicesOutput) GoString() string {
	return s.String()
}

type DescribeSeverityLevelsInput struct {
	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	metadataDescribeSeverityLevelsInput `json:"-" xml:"-"`
}

type metadataDescribeSeverityLevelsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSeverityLevelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSeverityLevelsInput) GoString() string {
	return s.String()
}

// The list of severity levels returned by the DescribeSeverityLevels operation.
type DescribeSeverityLevelsOutput struct {
	// The available severity levels for the support case. Available severity levels
	// are defined by your service level agreement with AWS.
	SeverityLevels []*SeverityLevel `locationName:"severityLevels" type:"list"`

	metadataDescribeSeverityLevelsOutput `json:"-" xml:"-"`
}

type metadataDescribeSeverityLevelsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeSeverityLevelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSeverityLevelsOutput) GoString() string {
	return s.String()
}

type DescribeTrustedAdvisorCheckRefreshStatusesInput struct {
	// The IDs of the Trusted Advisor checks.
	CheckIds []*string `locationName:"checkIds" type:"list" required:"true"`

	metadataDescribeTrustedAdvisorCheckRefreshStatusesInput `json:"-" xml:"-"`
}

type metadataDescribeTrustedAdvisorCheckRefreshStatusesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesInput) GoString() string {
	return s.String()
}

// The statuses of the Trusted Advisor checks returned by the DescribeTrustedAdvisorCheckRefreshStatuses
// operation.
type DescribeTrustedAdvisorCheckRefreshStatusesOutput struct {
	// The refresh status of the specified Trusted Advisor checks.
	Statuses []*TrustedAdvisorCheckRefreshStatus `locationName:"statuses" type:"list" required:"true"`

	metadataDescribeTrustedAdvisorCheckRefreshStatusesOutput `json:"-" xml:"-"`
}

type metadataDescribeTrustedAdvisorCheckRefreshStatusesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckRefreshStatusesOutput) GoString() string {
	return s.String()
}

type DescribeTrustedAdvisorCheckResultInput struct {
	// The unique identifier for the Trusted Advisor check.
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	metadataDescribeTrustedAdvisorCheckResultInput `json:"-" xml:"-"`
}

type metadataDescribeTrustedAdvisorCheckResultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckResultInput) GoString() string {
	return s.String()
}

// The result of the Trusted Advisor check returned by the DescribeTrustedAdvisorCheckResult
// operation.
type DescribeTrustedAdvisorCheckResultOutput struct {
	// The detailed results of the Trusted Advisor check.
	Result *TrustedAdvisorCheckResult `locationName:"result" type:"structure"`

	metadataDescribeTrustedAdvisorCheckResultOutput `json:"-" xml:"-"`
}

type metadataDescribeTrustedAdvisorCheckResultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckResultOutput) GoString() string {
	return s.String()
}

type DescribeTrustedAdvisorCheckSummariesInput struct {
	// The IDs of the Trusted Advisor checks.
	CheckIds []*string `locationName:"checkIds" type:"list" required:"true"`

	metadataDescribeTrustedAdvisorCheckSummariesInput `json:"-" xml:"-"`
}

type metadataDescribeTrustedAdvisorCheckSummariesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesInput) GoString() string {
	return s.String()
}

// The summaries of the Trusted Advisor checks returned by the DescribeTrustedAdvisorCheckSummaries
// operation.
type DescribeTrustedAdvisorCheckSummariesOutput struct {
	// The summary information for the requested Trusted Advisor checks.
	Summaries []*TrustedAdvisorCheckSummary `locationName:"summaries" type:"list" required:"true"`

	metadataDescribeTrustedAdvisorCheckSummariesOutput `json:"-" xml:"-"`
}

type metadataDescribeTrustedAdvisorCheckSummariesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorCheckSummariesOutput) GoString() string {
	return s.String()
}

type DescribeTrustedAdvisorChecksInput struct {
	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string" required:"true"`

	metadataDescribeTrustedAdvisorChecksInput `json:"-" xml:"-"`
}

type metadataDescribeTrustedAdvisorChecksInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorChecksInput) GoString() string {
	return s.String()
}

// Information about the Trusted Advisor checks returned by the DescribeTrustedAdvisorChecks
// operation.
type DescribeTrustedAdvisorChecksOutput struct {
	// Information about all available Trusted Advisor checks.
	Checks []*TrustedAdvisorCheckDescription `locationName:"checks" type:"list" required:"true"`

	metadataDescribeTrustedAdvisorChecksOutput `json:"-" xml:"-"`
}

type metadataDescribeTrustedAdvisorChecksOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeTrustedAdvisorChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTrustedAdvisorChecksOutput) GoString() string {
	return s.String()
}

// The five most recent communications associated with the case.
type RecentCaseCommunications struct {
	// The five most recent communications associated with the case.
	Communications []*Communication `locationName:"communications" type:"list"`

	// A resumption point for pagination.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataRecentCaseCommunications `json:"-" xml:"-"`
}

type metadataRecentCaseCommunications struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RecentCaseCommunications) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecentCaseCommunications) GoString() string {
	return s.String()
}

type RefreshTrustedAdvisorCheckInput struct {
	// The unique identifier for the Trusted Advisor check.
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	metadataRefreshTrustedAdvisorCheckInput `json:"-" xml:"-"`
}

type metadataRefreshTrustedAdvisorCheckInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RefreshTrustedAdvisorCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshTrustedAdvisorCheckInput) GoString() string {
	return s.String()
}

// The current refresh status of a Trusted Advisor check.
type RefreshTrustedAdvisorCheckOutput struct {
	// The current refresh status for a check, including the amount of time until
	// the check is eligible for refresh.
	Status *TrustedAdvisorCheckRefreshStatus `locationName:"status" type:"structure" required:"true"`

	metadataRefreshTrustedAdvisorCheckOutput `json:"-" xml:"-"`
}

type metadataRefreshTrustedAdvisorCheckOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RefreshTrustedAdvisorCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshTrustedAdvisorCheckOutput) GoString() string {
	return s.String()
}

type ResolveCaseInput struct {
	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`

	metadataResolveCaseInput `json:"-" xml:"-"`
}

type metadataResolveCaseInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ResolveCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveCaseInput) GoString() string {
	return s.String()
}

// The status of the case returned by the ResolveCase operation.
type ResolveCaseOutput struct {
	// The status of the case after the ResolveCase request was processed.
	FinalCaseStatus *string `locationName:"finalCaseStatus" type:"string"`

	// The status of the case when the ResolveCase request was sent.
	InitialCaseStatus *string `locationName:"initialCaseStatus" type:"string"`

	metadataResolveCaseOutput `json:"-" xml:"-"`
}

type metadataResolveCaseOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ResolveCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResolveCaseOutput) GoString() string {
	return s.String()
}

// Information about an AWS service returned by the DescribeServices operation.
type Service struct {
	// A list of categories that describe the type of support issue a case describes.
	// Categories consist of a category name and a category code. Category names
	// and codes are passed to AWS Support when you call CreateCase.
	Categories []*Category `locationName:"categories" type:"list"`

	// The code for an AWS service returned by the DescribeServices response. The
	// Name element contains the corresponding friendly name.
	Code *string `locationName:"code" type:"string"`

	// The friendly name for an AWS service. The Code element contains the corresponding
	// code.
	Name *string `locationName:"name" type:"string"`

	metadataService `json:"-" xml:"-"`
}

type metadataService struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Service) GoString() string {
	return s.String()
}

// A code and name pair that represent a severity level that can be applied
// to a support case.
type SeverityLevel struct {
	// One of four values: "low," "medium," "high," and "urgent". These values correspond
	// to response times returned to the caller in SeverityLevel.name.
	Code *string `locationName:"code" type:"string"`

	// The name of the severity level that corresponds to the severity level code.
	Name *string `locationName:"name" type:"string"`

	metadataSeverityLevel `json:"-" xml:"-"`
}

type metadataSeverityLevel struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SeverityLevel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SeverityLevel) GoString() string {
	return s.String()
}

// The container for summary information that relates to the category of the
// Trusted Advisor check.
type TrustedAdvisorCategorySpecificSummary struct {
	// The summary information about cost savings for a Trusted Advisor check that
	// is in the Cost Optimizing category.
	CostOptimizing *TrustedAdvisorCostOptimizingSummary `locationName:"costOptimizing" type:"structure"`

	metadataTrustedAdvisorCategorySpecificSummary `json:"-" xml:"-"`
}

type metadataTrustedAdvisorCategorySpecificSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorCategorySpecificSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCategorySpecificSummary) GoString() string {
	return s.String()
}

// The description and metadata for a Trusted Advisor check.
type TrustedAdvisorCheckDescription struct {
	// The category of the Trusted Advisor check.
	Category *string `locationName:"category" type:"string" required:"true"`

	// The description of the Trusted Advisor check, which includes the alert criteria
	// and recommended actions (contains HTML markup).
	Description *string `locationName:"description" type:"string" required:"true"`

	// The unique identifier for the Trusted Advisor check.
	Id *string `locationName:"id" type:"string" required:"true"`

	// The column headings for the data returned by the Trusted Advisor check. The
	// order of the headings corresponds to the order of the data in the Metadata
	// element of the TrustedAdvisorResourceDetail for the check. Metadata contains
	// all the data that is shown in the Excel download, even in those cases where
	// the UI shows just summary data.
	Metadata []*string `locationName:"metadata" type:"list" required:"true"`

	// The display name for the Trusted Advisor check.
	Name *string `locationName:"name" type:"string" required:"true"`

	metadataTrustedAdvisorCheckDescription `json:"-" xml:"-"`
}

type metadataTrustedAdvisorCheckDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorCheckDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckDescription) GoString() string {
	return s.String()
}

// The refresh status of a Trusted Advisor check.
type TrustedAdvisorCheckRefreshStatus struct {
	// The unique identifier for the Trusted Advisor check.
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// The amount of time, in milliseconds, until the Trusted Advisor check is eligible
	// for refresh.
	MillisUntilNextRefreshable *int64 `locationName:"millisUntilNextRefreshable" type:"long" required:"true"`

	// The status of the Trusted Advisor check for which a refresh has been requested:
	// "none", "enqueued", "processing", "success", or "abandoned".
	Status *string `locationName:"status" type:"string" required:"true"`

	metadataTrustedAdvisorCheckRefreshStatus `json:"-" xml:"-"`
}

type metadataTrustedAdvisorCheckRefreshStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorCheckRefreshStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckRefreshStatus) GoString() string {
	return s.String()
}

// The results of a Trusted Advisor check returned by DescribeTrustedAdvisorCheckResult.
type TrustedAdvisorCheckResult struct {
	// Summary information that relates to the category of the check. Cost Optimizing
	// is the only category that is currently supported.
	CategorySpecificSummary *TrustedAdvisorCategorySpecificSummary `locationName:"categorySpecificSummary" type:"structure" required:"true"`

	// The unique identifier for the Trusted Advisor check.
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// The details about each resource listed in the check result.
	FlaggedResources []*TrustedAdvisorResourceDetail `locationName:"flaggedResources" type:"list" required:"true"`

	// Details about AWS resources that were analyzed in a call to Trusted Advisor
	// DescribeTrustedAdvisorCheckSummaries.
	ResourcesSummary *TrustedAdvisorResourcesSummary `locationName:"resourcesSummary" type:"structure" required:"true"`

	// The alert status of the check: "ok" (green), "warning" (yellow), "error"
	// (red), or "not_available".
	Status *string `locationName:"status" type:"string" required:"true"`

	// The time of the last refresh of the check.
	Timestamp *string `locationName:"timestamp" type:"string" required:"true"`

	metadataTrustedAdvisorCheckResult `json:"-" xml:"-"`
}

type metadataTrustedAdvisorCheckResult struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorCheckResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckResult) GoString() string {
	return s.String()
}

// A summary of a Trusted Advisor check result, including the alert status,
// last refresh, and number of resources examined.
type TrustedAdvisorCheckSummary struct {
	// Summary information that relates to the category of the check. Cost Optimizing
	// is the only category that is currently supported.
	CategorySpecificSummary *TrustedAdvisorCategorySpecificSummary `locationName:"categorySpecificSummary" type:"structure" required:"true"`

	// The unique identifier for the Trusted Advisor check.
	CheckId *string `locationName:"checkId" type:"string" required:"true"`

	// Specifies whether the Trusted Advisor check has flagged resources.
	HasFlaggedResources *bool `locationName:"hasFlaggedResources" type:"boolean"`

	// Details about AWS resources that were analyzed in a call to Trusted Advisor
	// DescribeTrustedAdvisorCheckSummaries.
	ResourcesSummary *TrustedAdvisorResourcesSummary `locationName:"resourcesSummary" type:"structure" required:"true"`

	// The alert status of the check: "ok" (green), "warning" (yellow), "error"
	// (red), or "not_available".
	Status *string `locationName:"status" type:"string" required:"true"`

	// The time of the last refresh of the check.
	Timestamp *string `locationName:"timestamp" type:"string" required:"true"`

	metadataTrustedAdvisorCheckSummary `json:"-" xml:"-"`
}

type metadataTrustedAdvisorCheckSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorCheckSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCheckSummary) GoString() string {
	return s.String()
}

// The estimated cost savings that might be realized if the recommended actions
// are taken.
type TrustedAdvisorCostOptimizingSummary struct {
	// The estimated monthly savings that might be realized if the recommended actions
	// are taken.
	EstimatedMonthlySavings *float64 `locationName:"estimatedMonthlySavings" type:"double" required:"true"`

	// The estimated percentage of savings that might be realized if the recommended
	// actions are taken.
	EstimatedPercentMonthlySavings *float64 `locationName:"estimatedPercentMonthlySavings" type:"double" required:"true"`

	metadataTrustedAdvisorCostOptimizingSummary `json:"-" xml:"-"`
}

type metadataTrustedAdvisorCostOptimizingSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorCostOptimizingSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorCostOptimizingSummary) GoString() string {
	return s.String()
}

// Contains information about a resource identified by a Trusted Advisor check.
type TrustedAdvisorResourceDetail struct {
	// Specifies whether the AWS resource was ignored by Trusted Advisor because
	// it was marked as suppressed by the user.
	IsSuppressed *bool `locationName:"isSuppressed" type:"boolean"`

	// Additional information about the identified resource. The exact metadata
	// and its order can be obtained by inspecting the TrustedAdvisorCheckDescription
	// object returned by the call to DescribeTrustedAdvisorChecks. Metadata contains
	// all the data that is shown in the Excel download, even in those cases where
	// the UI shows just summary data.
	Metadata []*string `locationName:"metadata" type:"list" required:"true"`

	// The AWS region in which the identified resource is located.
	Region *string `locationName:"region" type:"string" required:"true"`

	// The unique identifier for the identified resource.
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The status code for the resource identified in the Trusted Advisor check.
	Status *string `locationName:"status" type:"string" required:"true"`

	metadataTrustedAdvisorResourceDetail `json:"-" xml:"-"`
}

type metadataTrustedAdvisorResourceDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorResourceDetail) GoString() string {
	return s.String()
}

// Details about AWS resources that were analyzed in a call to Trusted Advisor
// DescribeTrustedAdvisorCheckSummaries.
type TrustedAdvisorResourcesSummary struct {
	// The number of AWS resources that were flagged (listed) by the Trusted Advisor
	// check.
	ResourcesFlagged *int64 `locationName:"resourcesFlagged" type:"long" required:"true"`

	// The number of AWS resources ignored by Trusted Advisor because information
	// was unavailable.
	ResourcesIgnored *int64 `locationName:"resourcesIgnored" type:"long" required:"true"`

	// The number of AWS resources that were analyzed by the Trusted Advisor check.
	ResourcesProcessed *int64 `locationName:"resourcesProcessed" type:"long" required:"true"`

	// The number of AWS resources ignored by Trusted Advisor because they were
	// marked as suppressed by the user.
	ResourcesSuppressed *int64 `locationName:"resourcesSuppressed" type:"long" required:"true"`

	metadataTrustedAdvisorResourcesSummary `json:"-" xml:"-"`
}

type metadataTrustedAdvisorResourcesSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TrustedAdvisorResourcesSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TrustedAdvisorResourcesSummary) GoString() string {
	return s.String()
}
