// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package waf_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/waf"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleWAF_CreateByteMatchSet() {
	svc := waf.New(nil)

	params := &waf.CreateByteMatchSetInput{
		ChangeToken: aws.String("ChangeToken"),  // Required
		Name:        aws.String("ResourceName"), // Required
	}
	resp, err := svc.CreateByteMatchSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_CreateIPSet() {
	svc := waf.New(nil)

	params := &waf.CreateIPSetInput{
		ChangeToken: aws.String("ChangeToken"),  // Required
		Name:        aws.String("ResourceName"), // Required
	}
	resp, err := svc.CreateIPSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_CreateRule() {
	svc := waf.New(nil)

	params := &waf.CreateRuleInput{
		ChangeToken: aws.String("ChangeToken"),  // Required
		MetricName:  aws.String("MetricName"),   // Required
		Name:        aws.String("ResourceName"), // Required
	}
	resp, err := svc.CreateRule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_CreateSqlInjectionMatchSet() {
	svc := waf.New(nil)

	params := &waf.CreateSqlInjectionMatchSetInput{
		ChangeToken: aws.String("ChangeToken"),  // Required
		Name:        aws.String("ResourceName"), // Required
	}
	resp, err := svc.CreateSqlInjectionMatchSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_CreateWebACL() {
	svc := waf.New(nil)

	params := &waf.CreateWebACLInput{
		ChangeToken: aws.String("ChangeToken"), // Required
		DefaultAction: &waf.WafAction{ // Required
			Type: aws.String("WafActionType"), // Required
		},
		MetricName: aws.String("MetricName"),   // Required
		Name:       aws.String("ResourceName"), // Required
	}
	resp, err := svc.CreateWebACL(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_DeleteByteMatchSet() {
	svc := waf.New(nil)

	params := &waf.DeleteByteMatchSetInput{
		ByteMatchSetId: aws.String("ResourceId"),  // Required
		ChangeToken:    aws.String("ChangeToken"), // Required
	}
	resp, err := svc.DeleteByteMatchSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_DeleteIPSet() {
	svc := waf.New(nil)

	params := &waf.DeleteIPSetInput{
		ChangeToken: aws.String("ChangeToken"), // Required
		IPSetId:     aws.String("ResourceId"),  // Required
	}
	resp, err := svc.DeleteIPSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_DeleteRule() {
	svc := waf.New(nil)

	params := &waf.DeleteRuleInput{
		ChangeToken: aws.String("ChangeToken"), // Required
		RuleId:      aws.String("ResourceId"),  // Required
	}
	resp, err := svc.DeleteRule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_DeleteSqlInjectionMatchSet() {
	svc := waf.New(nil)

	params := &waf.DeleteSqlInjectionMatchSetInput{
		ChangeToken:            aws.String("ChangeToken"), // Required
		SqlInjectionMatchSetId: aws.String("ResourceId"),  // Required
	}
	resp, err := svc.DeleteSqlInjectionMatchSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_DeleteWebACL() {
	svc := waf.New(nil)

	params := &waf.DeleteWebACLInput{
		ChangeToken: aws.String("ChangeToken"), // Required
		WebACLId:    aws.String("ResourceId"),  // Required
	}
	resp, err := svc.DeleteWebACL(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_GetByteMatchSet() {
	svc := waf.New(nil)

	params := &waf.GetByteMatchSetInput{
		ByteMatchSetId: aws.String("ResourceId"), // Required
	}
	resp, err := svc.GetByteMatchSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_GetChangeToken() {
	svc := waf.New(nil)

	var params *waf.GetChangeTokenInput
	resp, err := svc.GetChangeToken(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_GetChangeTokenStatus() {
	svc := waf.New(nil)

	params := &waf.GetChangeTokenStatusInput{
		ChangeToken: aws.String("ChangeToken"), // Required
	}
	resp, err := svc.GetChangeTokenStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_GetIPSet() {
	svc := waf.New(nil)

	params := &waf.GetIPSetInput{
		IPSetId: aws.String("ResourceId"), // Required
	}
	resp, err := svc.GetIPSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_GetRule() {
	svc := waf.New(nil)

	params := &waf.GetRuleInput{
		RuleId: aws.String("ResourceId"), // Required
	}
	resp, err := svc.GetRule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_GetSampledRequests() {
	svc := waf.New(nil)

	params := &waf.GetSampledRequestsInput{
		MaxItems: aws.Int64(1),             // Required
		RuleId:   aws.String("ResourceId"), // Required
		TimeWindow: &waf.TimeWindow{ // Required
			EndTime:   aws.Time(time.Now()), // Required
			StartTime: aws.Time(time.Now()), // Required
		},
		WebAclId: aws.String("ResourceId"), // Required
	}
	resp, err := svc.GetSampledRequests(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_GetSqlInjectionMatchSet() {
	svc := waf.New(nil)

	params := &waf.GetSqlInjectionMatchSetInput{
		SqlInjectionMatchSetId: aws.String("ResourceId"), // Required
	}
	resp, err := svc.GetSqlInjectionMatchSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_GetWebACL() {
	svc := waf.New(nil)

	params := &waf.GetWebACLInput{
		WebACLId: aws.String("ResourceId"), // Required
	}
	resp, err := svc.GetWebACL(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_ListByteMatchSets() {
	svc := waf.New(nil)

	params := &waf.ListByteMatchSetsInput{
		Limit:      aws.Int64(1), // Required
		NextMarker: aws.String("NextMarker"),
	}
	resp, err := svc.ListByteMatchSets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_ListIPSets() {
	svc := waf.New(nil)

	params := &waf.ListIPSetsInput{
		Limit:      aws.Int64(1), // Required
		NextMarker: aws.String("NextMarker"),
	}
	resp, err := svc.ListIPSets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_ListRules() {
	svc := waf.New(nil)

	params := &waf.ListRulesInput{
		Limit:      aws.Int64(1), // Required
		NextMarker: aws.String("NextMarker"),
	}
	resp, err := svc.ListRules(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_ListSqlInjectionMatchSets() {
	svc := waf.New(nil)

	params := &waf.ListSqlInjectionMatchSetsInput{
		Limit:      aws.Int64(1), // Required
		NextMarker: aws.String("NextMarker"),
	}
	resp, err := svc.ListSqlInjectionMatchSets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_ListWebACLs() {
	svc := waf.New(nil)

	params := &waf.ListWebACLsInput{
		Limit:      aws.Int64(1), // Required
		NextMarker: aws.String("NextMarker"),
	}
	resp, err := svc.ListWebACLs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_UpdateByteMatchSet() {
	svc := waf.New(nil)

	params := &waf.UpdateByteMatchSetInput{
		ByteMatchSetId: aws.String("ResourceId"),  // Required
		ChangeToken:    aws.String("ChangeToken"), // Required
		Updates: []*waf.ByteMatchSetUpdate{ // Required
			{ // Required
				Action: aws.String("ChangeAction"), // Required
				ByteMatchTuple: &waf.ByteMatchTuple{ // Required
					FieldToMatch: &waf.FieldToMatch{ // Required
						Type: aws.String("MatchFieldType"), // Required
						Data: aws.String("MatchFieldData"),
					},
					PositionalConstraint: aws.String("PositionalConstraint"), // Required
					TargetString:         []byte("PAYLOAD"),                  // Required
					TextTransformation:   aws.String("TextTransformation"),   // Required
				},
			},
			// More values...
		},
	}
	resp, err := svc.UpdateByteMatchSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_UpdateIPSet() {
	svc := waf.New(nil)

	params := &waf.UpdateIPSetInput{
		ChangeToken: aws.String("ChangeToken"), // Required
		IPSetId:     aws.String("ResourceId"),  // Required
		Updates: []*waf.IPSetUpdate{ // Required
			{ // Required
				Action: aws.String("ChangeAction"), // Required
				IPSetDescriptor: &waf.IPSetDescriptor{ // Required
					Type:  aws.String("IPSetDescriptorType"),  // Required
					Value: aws.String("IPSetDescriptorValue"), // Required
				},
			},
			// More values...
		},
	}
	resp, err := svc.UpdateIPSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_UpdateRule() {
	svc := waf.New(nil)

	params := &waf.UpdateRuleInput{
		ChangeToken: aws.String("ChangeToken"), // Required
		RuleId:      aws.String("ResourceId"),  // Required
		Updates: []*waf.RuleUpdate{ // Required
			{ // Required
				Action: aws.String("ChangeAction"), // Required
				Predicate: &waf.Predicate{ // Required
					DataId:  aws.String("PredicateDataId"), // Required
					Negated: aws.Bool(true),                // Required
					Type:    aws.String("PredicateType"),   // Required
				},
			},
			// More values...
		},
	}
	resp, err := svc.UpdateRule(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_UpdateSqlInjectionMatchSet() {
	svc := waf.New(nil)

	params := &waf.UpdateSqlInjectionMatchSetInput{
		ChangeToken:            aws.String("ChangeToken"), // Required
		SqlInjectionMatchSetId: aws.String("ResourceId"),  // Required
		Updates: []*waf.SqlInjectionMatchSetUpdate{ // Required
			{ // Required
				Action: aws.String("ChangeAction"), // Required
				SqlInjectionMatchTuple: &waf.SqlInjectionMatchTuple{ // Required
					FieldToMatch: &waf.FieldToMatch{ // Required
						Type: aws.String("MatchFieldType"), // Required
						Data: aws.String("MatchFieldData"),
					},
					TextTransformation: aws.String("TextTransformation"), // Required
				},
			},
			// More values...
		},
	}
	resp, err := svc.UpdateSqlInjectionMatchSet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWAF_UpdateWebACL() {
	svc := waf.New(nil)

	params := &waf.UpdateWebACLInput{
		ChangeToken: aws.String("ChangeToken"), // Required
		WebACLId:    aws.String("ResourceId"),  // Required
		DefaultAction: &waf.WafAction{
			Type: aws.String("WafActionType"), // Required
		},
		Updates: []*waf.WebACLUpdate{
			{ // Required
				Action: aws.String("ChangeAction"), // Required
				ActivatedRule: &waf.ActivatedRule{ // Required
					Action: &waf.WafAction{ // Required
						Type: aws.String("WafActionType"), // Required
					},
					Priority: aws.Int64(1),             // Required
					RuleId:   aws.String("ResourceId"), // Required
				},
			},
			// More values...
		},
	}
	resp, err := svc.UpdateWebACL(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
