// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package clouddirectoryiface provides an interface to enable mocking the Amazon CloudDirectory service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package clouddirectoryiface

import (
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/clouddirectory"
)

// CloudDirectoryAPI provides an interface to enable mocking the
// clouddirectory.CloudDirectory service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon CloudDirectory.
//    func myFunc(svc clouddirectoryiface.CloudDirectoryAPI) bool {
//        // Make svc.AddFacetToObject request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := clouddirectory.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockCloudDirectoryClient struct {
//        clouddirectoryiface.CloudDirectoryAPI
//    }
//    func (m *mockCloudDirectoryClient) AddFacetToObject(input *clouddirectory.AddFacetToObjectInput) (*clouddirectory.AddFacetToObjectOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockCloudDirectoryClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type CloudDirectoryAPI interface {
	AddFacetToObjectRequest(*clouddirectory.AddFacetToObjectInput) (*request.Request, *clouddirectory.AddFacetToObjectOutput)

	AddFacetToObject(*clouddirectory.AddFacetToObjectInput) (*clouddirectory.AddFacetToObjectOutput, error)

	ApplySchemaRequest(*clouddirectory.ApplySchemaInput) (*request.Request, *clouddirectory.ApplySchemaOutput)

	ApplySchema(*clouddirectory.ApplySchemaInput) (*clouddirectory.ApplySchemaOutput, error)

	AttachObjectRequest(*clouddirectory.AttachObjectInput) (*request.Request, *clouddirectory.AttachObjectOutput)

	AttachObject(*clouddirectory.AttachObjectInput) (*clouddirectory.AttachObjectOutput, error)

	AttachPolicyRequest(*clouddirectory.AttachPolicyInput) (*request.Request, *clouddirectory.AttachPolicyOutput)

	AttachPolicy(*clouddirectory.AttachPolicyInput) (*clouddirectory.AttachPolicyOutput, error)

	AttachToIndexRequest(*clouddirectory.AttachToIndexInput) (*request.Request, *clouddirectory.AttachToIndexOutput)

	AttachToIndex(*clouddirectory.AttachToIndexInput) (*clouddirectory.AttachToIndexOutput, error)

	BatchReadRequest(*clouddirectory.BatchReadInput) (*request.Request, *clouddirectory.BatchReadOutput)

	BatchRead(*clouddirectory.BatchReadInput) (*clouddirectory.BatchReadOutput, error)

	BatchWriteRequest(*clouddirectory.BatchWriteInput) (*request.Request, *clouddirectory.BatchWriteOutput)

	BatchWrite(*clouddirectory.BatchWriteInput) (*clouddirectory.BatchWriteOutput, error)

	CreateDirectoryRequest(*clouddirectory.CreateDirectoryInput) (*request.Request, *clouddirectory.CreateDirectoryOutput)

	CreateDirectory(*clouddirectory.CreateDirectoryInput) (*clouddirectory.CreateDirectoryOutput, error)

	CreateFacetRequest(*clouddirectory.CreateFacetInput) (*request.Request, *clouddirectory.CreateFacetOutput)

	CreateFacet(*clouddirectory.CreateFacetInput) (*clouddirectory.CreateFacetOutput, error)

	CreateIndexRequest(*clouddirectory.CreateIndexInput) (*request.Request, *clouddirectory.CreateIndexOutput)

	CreateIndex(*clouddirectory.CreateIndexInput) (*clouddirectory.CreateIndexOutput, error)

	CreateObjectRequest(*clouddirectory.CreateObjectInput) (*request.Request, *clouddirectory.CreateObjectOutput)

	CreateObject(*clouddirectory.CreateObjectInput) (*clouddirectory.CreateObjectOutput, error)

	CreateSchemaRequest(*clouddirectory.CreateSchemaInput) (*request.Request, *clouddirectory.CreateSchemaOutput)

	CreateSchema(*clouddirectory.CreateSchemaInput) (*clouddirectory.CreateSchemaOutput, error)

	DeleteDirectoryRequest(*clouddirectory.DeleteDirectoryInput) (*request.Request, *clouddirectory.DeleteDirectoryOutput)

	DeleteDirectory(*clouddirectory.DeleteDirectoryInput) (*clouddirectory.DeleteDirectoryOutput, error)

	DeleteFacetRequest(*clouddirectory.DeleteFacetInput) (*request.Request, *clouddirectory.DeleteFacetOutput)

	DeleteFacet(*clouddirectory.DeleteFacetInput) (*clouddirectory.DeleteFacetOutput, error)

	DeleteObjectRequest(*clouddirectory.DeleteObjectInput) (*request.Request, *clouddirectory.DeleteObjectOutput)

	DeleteObject(*clouddirectory.DeleteObjectInput) (*clouddirectory.DeleteObjectOutput, error)

	DeleteSchemaRequest(*clouddirectory.DeleteSchemaInput) (*request.Request, *clouddirectory.DeleteSchemaOutput)

	DeleteSchema(*clouddirectory.DeleteSchemaInput) (*clouddirectory.DeleteSchemaOutput, error)

	DetachFromIndexRequest(*clouddirectory.DetachFromIndexInput) (*request.Request, *clouddirectory.DetachFromIndexOutput)

	DetachFromIndex(*clouddirectory.DetachFromIndexInput) (*clouddirectory.DetachFromIndexOutput, error)

	DetachObjectRequest(*clouddirectory.DetachObjectInput) (*request.Request, *clouddirectory.DetachObjectOutput)

	DetachObject(*clouddirectory.DetachObjectInput) (*clouddirectory.DetachObjectOutput, error)

	DetachPolicyRequest(*clouddirectory.DetachPolicyInput) (*request.Request, *clouddirectory.DetachPolicyOutput)

	DetachPolicy(*clouddirectory.DetachPolicyInput) (*clouddirectory.DetachPolicyOutput, error)

	DisableDirectoryRequest(*clouddirectory.DisableDirectoryInput) (*request.Request, *clouddirectory.DisableDirectoryOutput)

	DisableDirectory(*clouddirectory.DisableDirectoryInput) (*clouddirectory.DisableDirectoryOutput, error)

	EnableDirectoryRequest(*clouddirectory.EnableDirectoryInput) (*request.Request, *clouddirectory.EnableDirectoryOutput)

	EnableDirectory(*clouddirectory.EnableDirectoryInput) (*clouddirectory.EnableDirectoryOutput, error)

	GetDirectoryRequest(*clouddirectory.GetDirectoryInput) (*request.Request, *clouddirectory.GetDirectoryOutput)

	GetDirectory(*clouddirectory.GetDirectoryInput) (*clouddirectory.GetDirectoryOutput, error)

	GetFacetRequest(*clouddirectory.GetFacetInput) (*request.Request, *clouddirectory.GetFacetOutput)

	GetFacet(*clouddirectory.GetFacetInput) (*clouddirectory.GetFacetOutput, error)

	GetObjectInformationRequest(*clouddirectory.GetObjectInformationInput) (*request.Request, *clouddirectory.GetObjectInformationOutput)

	GetObjectInformation(*clouddirectory.GetObjectInformationInput) (*clouddirectory.GetObjectInformationOutput, error)

	GetSchemaAsJsonRequest(*clouddirectory.GetSchemaAsJsonInput) (*request.Request, *clouddirectory.GetSchemaAsJsonOutput)

	GetSchemaAsJson(*clouddirectory.GetSchemaAsJsonInput) (*clouddirectory.GetSchemaAsJsonOutput, error)

	ListAppliedSchemaArnsRequest(*clouddirectory.ListAppliedSchemaArnsInput) (*request.Request, *clouddirectory.ListAppliedSchemaArnsOutput)

	ListAppliedSchemaArns(*clouddirectory.ListAppliedSchemaArnsInput) (*clouddirectory.ListAppliedSchemaArnsOutput, error)

	ListAppliedSchemaArnsPages(*clouddirectory.ListAppliedSchemaArnsInput, func(*clouddirectory.ListAppliedSchemaArnsOutput, bool) bool) error

	ListAttachedIndicesRequest(*clouddirectory.ListAttachedIndicesInput) (*request.Request, *clouddirectory.ListAttachedIndicesOutput)

	ListAttachedIndices(*clouddirectory.ListAttachedIndicesInput) (*clouddirectory.ListAttachedIndicesOutput, error)

	ListAttachedIndicesPages(*clouddirectory.ListAttachedIndicesInput, func(*clouddirectory.ListAttachedIndicesOutput, bool) bool) error

	ListDevelopmentSchemaArnsRequest(*clouddirectory.ListDevelopmentSchemaArnsInput) (*request.Request, *clouddirectory.ListDevelopmentSchemaArnsOutput)

	ListDevelopmentSchemaArns(*clouddirectory.ListDevelopmentSchemaArnsInput) (*clouddirectory.ListDevelopmentSchemaArnsOutput, error)

	ListDevelopmentSchemaArnsPages(*clouddirectory.ListDevelopmentSchemaArnsInput, func(*clouddirectory.ListDevelopmentSchemaArnsOutput, bool) bool) error

	ListDirectoriesRequest(*clouddirectory.ListDirectoriesInput) (*request.Request, *clouddirectory.ListDirectoriesOutput)

	ListDirectories(*clouddirectory.ListDirectoriesInput) (*clouddirectory.ListDirectoriesOutput, error)

	ListDirectoriesPages(*clouddirectory.ListDirectoriesInput, func(*clouddirectory.ListDirectoriesOutput, bool) bool) error

	ListFacetAttributesRequest(*clouddirectory.ListFacetAttributesInput) (*request.Request, *clouddirectory.ListFacetAttributesOutput)

	ListFacetAttributes(*clouddirectory.ListFacetAttributesInput) (*clouddirectory.ListFacetAttributesOutput, error)

	ListFacetAttributesPages(*clouddirectory.ListFacetAttributesInput, func(*clouddirectory.ListFacetAttributesOutput, bool) bool) error

	ListFacetNamesRequest(*clouddirectory.ListFacetNamesInput) (*request.Request, *clouddirectory.ListFacetNamesOutput)

	ListFacetNames(*clouddirectory.ListFacetNamesInput) (*clouddirectory.ListFacetNamesOutput, error)

	ListFacetNamesPages(*clouddirectory.ListFacetNamesInput, func(*clouddirectory.ListFacetNamesOutput, bool) bool) error

	ListIndexRequest(*clouddirectory.ListIndexInput) (*request.Request, *clouddirectory.ListIndexOutput)

	ListIndex(*clouddirectory.ListIndexInput) (*clouddirectory.ListIndexOutput, error)

	ListIndexPages(*clouddirectory.ListIndexInput, func(*clouddirectory.ListIndexOutput, bool) bool) error

	ListObjectAttributesRequest(*clouddirectory.ListObjectAttributesInput) (*request.Request, *clouddirectory.ListObjectAttributesOutput)

	ListObjectAttributes(*clouddirectory.ListObjectAttributesInput) (*clouddirectory.ListObjectAttributesOutput, error)

	ListObjectAttributesPages(*clouddirectory.ListObjectAttributesInput, func(*clouddirectory.ListObjectAttributesOutput, bool) bool) error

	ListObjectChildrenRequest(*clouddirectory.ListObjectChildrenInput) (*request.Request, *clouddirectory.ListObjectChildrenOutput)

	ListObjectChildren(*clouddirectory.ListObjectChildrenInput) (*clouddirectory.ListObjectChildrenOutput, error)

	ListObjectChildrenPages(*clouddirectory.ListObjectChildrenInput, func(*clouddirectory.ListObjectChildrenOutput, bool) bool) error

	ListObjectParentsRequest(*clouddirectory.ListObjectParentsInput) (*request.Request, *clouddirectory.ListObjectParentsOutput)

	ListObjectParents(*clouddirectory.ListObjectParentsInput) (*clouddirectory.ListObjectParentsOutput, error)

	ListObjectParentsPages(*clouddirectory.ListObjectParentsInput, func(*clouddirectory.ListObjectParentsOutput, bool) bool) error

	ListObjectPoliciesRequest(*clouddirectory.ListObjectPoliciesInput) (*request.Request, *clouddirectory.ListObjectPoliciesOutput)

	ListObjectPolicies(*clouddirectory.ListObjectPoliciesInput) (*clouddirectory.ListObjectPoliciesOutput, error)

	ListObjectPoliciesPages(*clouddirectory.ListObjectPoliciesInput, func(*clouddirectory.ListObjectPoliciesOutput, bool) bool) error

	ListPolicyAttachmentsRequest(*clouddirectory.ListPolicyAttachmentsInput) (*request.Request, *clouddirectory.ListPolicyAttachmentsOutput)

	ListPolicyAttachments(*clouddirectory.ListPolicyAttachmentsInput) (*clouddirectory.ListPolicyAttachmentsOutput, error)

	ListPolicyAttachmentsPages(*clouddirectory.ListPolicyAttachmentsInput, func(*clouddirectory.ListPolicyAttachmentsOutput, bool) bool) error

	ListPublishedSchemaArnsRequest(*clouddirectory.ListPublishedSchemaArnsInput) (*request.Request, *clouddirectory.ListPublishedSchemaArnsOutput)

	ListPublishedSchemaArns(*clouddirectory.ListPublishedSchemaArnsInput) (*clouddirectory.ListPublishedSchemaArnsOutput, error)

	ListPublishedSchemaArnsPages(*clouddirectory.ListPublishedSchemaArnsInput, func(*clouddirectory.ListPublishedSchemaArnsOutput, bool) bool) error

	ListTagsForResourceRequest(*clouddirectory.ListTagsForResourceInput) (*request.Request, *clouddirectory.ListTagsForResourceOutput)

	ListTagsForResource(*clouddirectory.ListTagsForResourceInput) (*clouddirectory.ListTagsForResourceOutput, error)

	ListTagsForResourcePages(*clouddirectory.ListTagsForResourceInput, func(*clouddirectory.ListTagsForResourceOutput, bool) bool) error

	LookupPolicyRequest(*clouddirectory.LookupPolicyInput) (*request.Request, *clouddirectory.LookupPolicyOutput)

	LookupPolicy(*clouddirectory.LookupPolicyInput) (*clouddirectory.LookupPolicyOutput, error)

	LookupPolicyPages(*clouddirectory.LookupPolicyInput, func(*clouddirectory.LookupPolicyOutput, bool) bool) error

	PublishSchemaRequest(*clouddirectory.PublishSchemaInput) (*request.Request, *clouddirectory.PublishSchemaOutput)

	PublishSchema(*clouddirectory.PublishSchemaInput) (*clouddirectory.PublishSchemaOutput, error)

	PutSchemaFromJsonRequest(*clouddirectory.PutSchemaFromJsonInput) (*request.Request, *clouddirectory.PutSchemaFromJsonOutput)

	PutSchemaFromJson(*clouddirectory.PutSchemaFromJsonInput) (*clouddirectory.PutSchemaFromJsonOutput, error)

	RemoveFacetFromObjectRequest(*clouddirectory.RemoveFacetFromObjectInput) (*request.Request, *clouddirectory.RemoveFacetFromObjectOutput)

	RemoveFacetFromObject(*clouddirectory.RemoveFacetFromObjectInput) (*clouddirectory.RemoveFacetFromObjectOutput, error)

	TagResourceRequest(*clouddirectory.TagResourceInput) (*request.Request, *clouddirectory.TagResourceOutput)

	TagResource(*clouddirectory.TagResourceInput) (*clouddirectory.TagResourceOutput, error)

	UntagResourceRequest(*clouddirectory.UntagResourceInput) (*request.Request, *clouddirectory.UntagResourceOutput)

	UntagResource(*clouddirectory.UntagResourceInput) (*clouddirectory.UntagResourceOutput, error)

	UpdateFacetRequest(*clouddirectory.UpdateFacetInput) (*request.Request, *clouddirectory.UpdateFacetOutput)

	UpdateFacet(*clouddirectory.UpdateFacetInput) (*clouddirectory.UpdateFacetOutput, error)

	UpdateObjectAttributesRequest(*clouddirectory.UpdateObjectAttributesInput) (*request.Request, *clouddirectory.UpdateObjectAttributesOutput)

	UpdateObjectAttributes(*clouddirectory.UpdateObjectAttributesInput) (*clouddirectory.UpdateObjectAttributesOutput, error)

	UpdateSchemaRequest(*clouddirectory.UpdateSchemaInput) (*request.Request, *clouddirectory.UpdateSchemaOutput)

	UpdateSchema(*clouddirectory.UpdateSchemaInput) (*clouddirectory.UpdateSchemaOutput, error)
}

var _ CloudDirectoryAPI = (*clouddirectory.CloudDirectory)(nil)
