// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package iam provides a client for AWS Identity and Access Management.
package iam

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAddClientIDToOpenIDConnectProvider = "AddClientIDToOpenIDConnectProvider"

// AddClientIDToOpenIDConnectProviderRequest generates a "aws/request.Request" representing the
// client's request for the AddClientIDToOpenIDConnectProvider operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddClientIDToOpenIDConnectProvider for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddClientIDToOpenIDConnectProvider method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddClientIDToOpenIDConnectProviderRequest method.
//    req, resp := client.AddClientIDToOpenIDConnectProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProvider
func (c *IAM) AddClientIDToOpenIDConnectProviderRequest(input *AddClientIDToOpenIDConnectProviderInput) (req *request.Request, output *AddClientIDToOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opAddClientIDToOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddClientIDToOpenIDConnectProviderInput{}
	}

	output = &AddClientIDToOpenIDConnectProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddClientIDToOpenIDConnectProvider API operation for AWS Identity and Access Management.
//
// Adds a new client ID (also known as audience) to the list of client IDs already
// registered for the specified IAM OpenID Connect (OIDC) provider resource.
//
// This action is idempotent; it does not fail or return an error if you add
// an existing client ID to the provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation AddClientIDToOpenIDConnectProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProvider
func (c *IAM) AddClientIDToOpenIDConnectProvider(input *AddClientIDToOpenIDConnectProviderInput) (*AddClientIDToOpenIDConnectProviderOutput, error) {
	req, out := c.AddClientIDToOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opAddRoleToInstanceProfile = "AddRoleToInstanceProfile"

// AddRoleToInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the AddRoleToInstanceProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddRoleToInstanceProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddRoleToInstanceProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddRoleToInstanceProfileRequest method.
//    req, resp := client.AddRoleToInstanceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfile
func (c *IAM) AddRoleToInstanceProfileRequest(input *AddRoleToInstanceProfileInput) (req *request.Request, output *AddRoleToInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opAddRoleToInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddRoleToInstanceProfileInput{}
	}

	output = &AddRoleToInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddRoleToInstanceProfile API operation for AWS Identity and Access Management.
//
// Adds the specified IAM role to the specified instance profile.
//
// The caller of this API must be granted the PassRole permission on the IAM
// role by a permission policy.
//
// For more information about roles, go to Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
// For more information about instance profiles, go to About Instance Profiles
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation AddRoleToInstanceProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfile
func (c *IAM) AddRoleToInstanceProfile(input *AddRoleToInstanceProfileInput) (*AddRoleToInstanceProfileOutput, error) {
	req, out := c.AddRoleToInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opAddUserToGroup = "AddUserToGroup"

// AddUserToGroupRequest generates a "aws/request.Request" representing the
// client's request for the AddUserToGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddUserToGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddUserToGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddUserToGroupRequest method.
//    req, resp := client.AddUserToGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroup
func (c *IAM) AddUserToGroupRequest(input *AddUserToGroupInput) (req *request.Request, output *AddUserToGroupOutput) {
	op := &request.Operation{
		Name:       opAddUserToGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddUserToGroupInput{}
	}

	output = &AddUserToGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddUserToGroup API operation for AWS Identity and Access Management.
//
// Adds the specified user to the specified group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation AddUserToGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroup
func (c *IAM) AddUserToGroup(input *AddUserToGroupInput) (*AddUserToGroupOutput, error) {
	req, out := c.AddUserToGroupRequest(input)
	err := req.Send()
	return out, err
}

const opAttachGroupPolicy = "AttachGroupPolicy"

// AttachGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachGroupPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachGroupPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachGroupPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachGroupPolicyRequest method.
//    req, resp := client.AttachGroupPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicy
func (c *IAM) AttachGroupPolicyRequest(input *AttachGroupPolicyInput) (req *request.Request, output *AttachGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachGroupPolicyInput{}
	}

	output = &AttachGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachGroupPolicy API operation for AWS Identity and Access Management.
//
// Attaches the specified managed policy to the specified IAM group.
//
// You use this API to attach a managed policy to a group. To embed an inline
// policy in a group, use PutGroupPolicy.
//
// For more information about policies, see Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation AttachGroupPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicy
func (c *IAM) AttachGroupPolicy(input *AttachGroupPolicyInput) (*AttachGroupPolicyOutput, error) {
	req, out := c.AttachGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opAttachRolePolicy = "AttachRolePolicy"

// AttachRolePolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachRolePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachRolePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachRolePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachRolePolicyRequest method.
//    req, resp := client.AttachRolePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicy
func (c *IAM) AttachRolePolicyRequest(input *AttachRolePolicyInput) (req *request.Request, output *AttachRolePolicyOutput) {
	op := &request.Operation{
		Name:       opAttachRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachRolePolicyInput{}
	}

	output = &AttachRolePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachRolePolicy API operation for AWS Identity and Access Management.
//
// Attaches the specified managed policy to the specified IAM role.
//
// When you attach a managed policy to a role, the managed policy becomes part
// of the role's permission (access) policy. You cannot use a managed policy
// as the role's trust policy. The role's trust policy is created at the same
// time as the role, using CreateRole. You can update a role's trust policy
// using UpdateAssumeRolePolicy.
//
// Use this API to attach a managed policy to a role. To embed an inline policy
// in a role, use PutRolePolicy. For more information about policies, see Managed
// Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation AttachRolePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicy
func (c *IAM) AttachRolePolicy(input *AttachRolePolicyInput) (*AttachRolePolicyOutput, error) {
	req, out := c.AttachRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opAttachUserPolicy = "AttachUserPolicy"

// AttachUserPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AttachUserPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachUserPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachUserPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachUserPolicyRequest method.
//    req, resp := client.AttachUserPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicy
func (c *IAM) AttachUserPolicyRequest(input *AttachUserPolicyInput) (req *request.Request, output *AttachUserPolicyOutput) {
	op := &request.Operation{
		Name:       opAttachUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachUserPolicyInput{}
	}

	output = &AttachUserPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachUserPolicy API operation for AWS Identity and Access Management.
//
// Attaches the specified managed policy to the specified user.
//
// You use this API to attach a managed policy to a user. To embed an inline
// policy in a user, use PutUserPolicy.
//
// For more information about policies, see Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation AttachUserPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicy
func (c *IAM) AttachUserPolicy(input *AttachUserPolicyInput) (*AttachUserPolicyOutput, error) {
	req, out := c.AttachUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opChangePassword = "ChangePassword"

// ChangePasswordRequest generates a "aws/request.Request" representing the
// client's request for the ChangePassword operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ChangePassword for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ChangePassword method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ChangePasswordRequest method.
//    req, resp := client.ChangePasswordRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePassword
func (c *IAM) ChangePasswordRequest(input *ChangePasswordInput) (req *request.Request, output *ChangePasswordOutput) {
	op := &request.Operation{
		Name:       opChangePassword,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ChangePasswordInput{}
	}

	output = &ChangePasswordOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ChangePassword API operation for AWS Identity and Access Management.
//
// Changes the password of the IAM user who is calling this action. The root
// account password is not affected by this action.
//
// To change the password for a different user, see UpdateLoginProfile. For
// more information about modifying passwords, see Managing Passwords (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ChangePassword for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidUserTypeException "InvalidUserType"
//   The request was rejected because the type of user for the transaction was
//   incorrect.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeEntityTemporarilyUnmodifiableException "EntityTemporarilyUnmodifiable"
//   The request was rejected because it referenced an entity that is temporarily
//   unmodifiable, such as a user name that was deleted and then recreated. The
//   error indicates that the request is likely to succeed if you try again after
//   waiting several minutes. The error message describes the entity.
//
//   * ErrCodePasswordPolicyViolationException "PasswordPolicyViolation"
//   The request was rejected because the provided password did not meet the requirements
//   imposed by the account password policy.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePassword
func (c *IAM) ChangePassword(input *ChangePasswordInput) (*ChangePasswordOutput, error) {
	req, out := c.ChangePasswordRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAccessKey = "CreateAccessKey"

// CreateAccessKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAccessKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAccessKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAccessKeyRequest method.
//    req, resp := client.CreateAccessKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey
func (c *IAM) CreateAccessKeyRequest(input *CreateAccessKeyInput) (req *request.Request, output *CreateAccessKeyOutput) {
	op := &request.Operation{
		Name:       opCreateAccessKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccessKeyInput{}
	}

	output = &CreateAccessKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccessKey API operation for AWS Identity and Access Management.
//
// Creates a new AWS secret access key and corresponding AWS access key ID for
// the specified user. The default status for new keys is Active.
//
// If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID signing the request. Because this action works
// for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
// For information about limits on the number of keys you can create, see Limitations
// on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// To ensure the security of your AWS account, the secret access key is accessible
// only during key and user creation. You must save the key (for example, in
// a text file) if you want to be able to access it again. If a secret key is
// lost, you can delete the access keys for the associated user and then create
// new keys.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateAccessKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey
func (c *IAM) CreateAccessKey(input *CreateAccessKeyInput) (*CreateAccessKeyOutput, error) {
	req, out := c.CreateAccessKeyRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAccountAlias = "CreateAccountAlias"

// CreateAccountAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccountAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAccountAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAccountAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAccountAliasRequest method.
//    req, resp := client.CreateAccountAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAlias
func (c *IAM) CreateAccountAliasRequest(input *CreateAccountAliasInput) (req *request.Request, output *CreateAccountAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAccountAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccountAliasInput{}
	}

	output = &CreateAccountAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateAccountAlias API operation for AWS Identity and Access Management.
//
// Creates an alias for your AWS account. For information about using an AWS
// account alias, see Using an Alias for Your AWS Account ID (http://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateAccountAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAlias
func (c *IAM) CreateAccountAlias(input *CreateAccountAliasInput) (*CreateAccountAliasOutput, error) {
	req, out := c.CreateAccountAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateGroup = "CreateGroup"

// CreateGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateGroupRequest method.
//    req, resp := client.CreateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroup
func (c *IAM) CreateGroupRequest(input *CreateGroupInput) (req *request.Request, output *CreateGroupOutput) {
	op := &request.Operation{
		Name:       opCreateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGroupInput{}
	}

	output = &CreateGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGroup API operation for AWS Identity and Access Management.
//
// Creates a new group.
//
// For information about the number of groups you can create, see Limitations
// on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroup
func (c *IAM) CreateGroup(input *CreateGroupInput) (*CreateGroupOutput, error) {
	req, out := c.CreateGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInstanceProfile = "CreateInstanceProfile"

// CreateInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateInstanceProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateInstanceProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateInstanceProfileRequest method.
//    req, resp := client.CreateInstanceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfile
func (c *IAM) CreateInstanceProfileRequest(input *CreateInstanceProfileInput) (req *request.Request, output *CreateInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceProfileInput{}
	}

	output = &CreateInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstanceProfile API operation for AWS Identity and Access Management.
//
// Creates a new instance profile. For information about instance profiles,
// go to About Instance Profiles (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
// For information about the number of instance profiles you can create, see
// Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateInstanceProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfile
func (c *IAM) CreateInstanceProfile(input *CreateInstanceProfileInput) (*CreateInstanceProfileOutput, error) {
	req, out := c.CreateInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLoginProfile = "CreateLoginProfile"

// CreateLoginProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateLoginProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateLoginProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateLoginProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateLoginProfileRequest method.
//    req, resp := client.CreateLoginProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfile
func (c *IAM) CreateLoginProfileRequest(input *CreateLoginProfileInput) (req *request.Request, output *CreateLoginProfileOutput) {
	op := &request.Operation{
		Name:       opCreateLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLoginProfileInput{}
	}

	output = &CreateLoginProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLoginProfile API operation for AWS Identity and Access Management.
//
// Creates a password for the specified user, giving the user the ability to
// access AWS services through the AWS Management Console. For more information
// about managing passwords, see Managing Passwords (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateLoginProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodePasswordPolicyViolationException "PasswordPolicyViolation"
//   The request was rejected because the provided password did not meet the requirements
//   imposed by the account password policy.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfile
func (c *IAM) CreateLoginProfile(input *CreateLoginProfileInput) (*CreateLoginProfileOutput, error) {
	req, out := c.CreateLoginProfileRequest(input)
	err := req.Send()
	return out, err
}

const opCreateOpenIDConnectProvider = "CreateOpenIDConnectProvider"

// CreateOpenIDConnectProviderRequest generates a "aws/request.Request" representing the
// client's request for the CreateOpenIDConnectProvider operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateOpenIDConnectProvider for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateOpenIDConnectProvider method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateOpenIDConnectProviderRequest method.
//    req, resp := client.CreateOpenIDConnectProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProvider
func (c *IAM) CreateOpenIDConnectProviderRequest(input *CreateOpenIDConnectProviderInput) (req *request.Request, output *CreateOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opCreateOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOpenIDConnectProviderInput{}
	}

	output = &CreateOpenIDConnectProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOpenIDConnectProvider API operation for AWS Identity and Access Management.
//
// Creates an IAM entity to describe an identity provider (IdP) that supports
// OpenID Connect (OIDC) (http://openid.net/connect/).
//
// The OIDC provider that you create with this operation can be used as a principal
// in a role's trust policy to establish a trust relationship between AWS and
// the OIDC provider.
//
// When you create the IAM OIDC provider, you specify the URL of the OIDC identity
// provider (IdP) to trust, a list of client IDs (also known as audiences) that
// identify the application or applications that are allowed to authenticate
// using the OIDC provider, and a list of thumbprints of the server certificate(s)
// that the IdP uses. You get all of this information from the OIDC IdP that
// you want to use for access to AWS.
//
// Because trust for the OIDC provider is ultimately derived from the IAM provider
// that this action creates, it is a best practice to limit access to the CreateOpenIDConnectProvider
// action to highly-privileged users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateOpenIDConnectProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProvider
func (c *IAM) CreateOpenIDConnectProvider(input *CreateOpenIDConnectProviderInput) (*CreateOpenIDConnectProviderOutput, error) {
	req, out := c.CreateOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePolicy = "CreatePolicy"

// CreatePolicyRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePolicyRequest method.
//    req, resp := client.CreatePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicy
func (c *IAM) CreatePolicyRequest(input *CreatePolicyInput) (req *request.Request, output *CreatePolicyOutput) {
	op := &request.Operation{
		Name:       opCreatePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePolicyInput{}
	}

	output = &CreatePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicy API operation for AWS Identity and Access Management.
//
// Creates a new managed policy for your AWS account.
//
// This operation creates a policy version with a version identifier of v1 and
// sets v1 as the policy's default version. For more information about policy
// versions, see Versioning for Managed Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
// in the IAM User Guide.
//
// For more information about managed policies in general, see Managed Policies
// and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreatePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocument"
//   The request was rejected because the policy document was malformed. The error
//   message describes the specific error.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicy
func (c *IAM) CreatePolicy(input *CreatePolicyInput) (*CreatePolicyOutput, error) {
	req, out := c.CreatePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePolicyVersion = "CreatePolicyVersion"

// CreatePolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreatePolicyVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreatePolicyVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreatePolicyVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreatePolicyVersionRequest method.
//    req, resp := client.CreatePolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersion
func (c *IAM) CreatePolicyVersionRequest(input *CreatePolicyVersionInput) (req *request.Request, output *CreatePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opCreatePolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePolicyVersionInput{}
	}

	output = &CreatePolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePolicyVersion API operation for AWS Identity and Access Management.
//
// Creates a new version of the specified managed policy. To update a managed
// policy, you create a new policy version. A managed policy can have up to
// five versions. If the policy has five versions, you must delete an existing
// version using DeletePolicyVersion before you create a new version.
//
// Optionally, you can set the new version as the policy's default version.
// The default version is the version that is in effect for the IAM users, groups,
// and roles to which the policy is attached.
//
// For more information about managed policy versions, see Versioning for Managed
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreatePolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocument"
//   The request was rejected because the policy document was malformed. The error
//   message describes the specific error.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersion
func (c *IAM) CreatePolicyVersion(input *CreatePolicyVersionInput) (*CreatePolicyVersionOutput, error) {
	req, out := c.CreatePolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateRole = "CreateRole"

// CreateRoleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRole operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateRole for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateRole method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateRoleRequest method.
//    req, resp := client.CreateRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRole
func (c *IAM) CreateRoleRequest(input *CreateRoleInput) (req *request.Request, output *CreateRoleOutput) {
	op := &request.Operation{
		Name:       opCreateRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRoleInput{}
	}

	output = &CreateRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRole API operation for AWS Identity and Access Management.
//
// Creates a new role for your AWS account. For more information about roles,
// go to Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
// For information about limitations on role names and the number of roles you
// can create, go to Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocument"
//   The request was rejected because the policy document was malformed. The error
//   message describes the specific error.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRole
func (c *IAM) CreateRole(input *CreateRoleInput) (*CreateRoleOutput, error) {
	req, out := c.CreateRoleRequest(input)
	err := req.Send()
	return out, err
}

const opCreateSAMLProvider = "CreateSAMLProvider"

// CreateSAMLProviderRequest generates a "aws/request.Request" representing the
// client's request for the CreateSAMLProvider operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateSAMLProvider for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateSAMLProvider method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateSAMLProviderRequest method.
//    req, resp := client.CreateSAMLProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProvider
func (c *IAM) CreateSAMLProviderRequest(input *CreateSAMLProviderInput) (req *request.Request, output *CreateSAMLProviderOutput) {
	op := &request.Operation{
		Name:       opCreateSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSAMLProviderInput{}
	}

	output = &CreateSAMLProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSAMLProvider API operation for AWS Identity and Access Management.
//
// Creates an IAM resource that describes an identity provider (IdP) that supports
// SAML 2.0.
//
// The SAML provider resource that you create with this operation can be used
// as a principal in an IAM role's trust policy to enable federated users who
// sign-in using the SAML IdP to assume the role. You can create an IAM role
// that supports Web-based single sign-on (SSO) to the AWS Management Console
// or one that supports API access to AWS.
//
// When you create the SAML provider resource, you upload an a SAML metadata
// document that you get from your IdP and that includes the issuer's name,
// expiration information, and keys that can be used to validate the SAML authentication
// response (assertions) that the IdP sends. You must generate the metadata
// document using the identity management software that is used as your organization's
// IdP.
//
// This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// For more information, see Enabling SAML 2.0 Federated Users to Access the
// AWS Management Console (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html)
// and About SAML 2.0-based Federation (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateSAMLProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProvider
func (c *IAM) CreateSAMLProvider(input *CreateSAMLProviderInput) (*CreateSAMLProviderOutput, error) {
	req, out := c.CreateSAMLProviderRequest(input)
	err := req.Send()
	return out, err
}

const opCreateServiceSpecificCredential = "CreateServiceSpecificCredential"

// CreateServiceSpecificCredentialRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceSpecificCredential operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateServiceSpecificCredential for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateServiceSpecificCredential method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateServiceSpecificCredentialRequest method.
//    req, resp := client.CreateServiceSpecificCredentialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredential
func (c *IAM) CreateServiceSpecificCredentialRequest(input *CreateServiceSpecificCredentialInput) (req *request.Request, output *CreateServiceSpecificCredentialOutput) {
	op := &request.Operation{
		Name:       opCreateServiceSpecificCredential,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceSpecificCredentialInput{}
	}

	output = &CreateServiceSpecificCredentialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceSpecificCredential API operation for AWS Identity and Access Management.
//
// Generates a set of credentials consisting of a user name and password that
// can be used to access the service specified in the request. These credentials
// are generated by IAM, and can be used only for the specified service.
//
// You can have a maximum of two sets of service-specific credentials for each
// supported service per user.
//
// The only supported service at this time is AWS CodeCommit.
//
// You can reset the password to a new service-generated value by calling ResetServiceSpecificCredential.
//
// For more information about service-specific credentials, see Using IAM with
// AWS CodeCommit: Git Credentials, SSH Keys, and AWS Access Keys (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateServiceSpecificCredential for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceNotSupportedException "NotSupportedService"
//   The specified service does not support service-specific credentials.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredential
func (c *IAM) CreateServiceSpecificCredential(input *CreateServiceSpecificCredentialInput) (*CreateServiceSpecificCredentialOutput, error) {
	req, out := c.CreateServiceSpecificCredentialRequest(input)
	err := req.Send()
	return out, err
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUser
func (c *IAM) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for AWS Identity and Access Management.
//
// Creates a new IAM user for your AWS account.
//
// For information about limitations on the number of IAM users you can create,
// see Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUser
func (c *IAM) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVirtualMFADevice = "CreateVirtualMFADevice"

// CreateVirtualMFADeviceRequest generates a "aws/request.Request" representing the
// client's request for the CreateVirtualMFADevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateVirtualMFADevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateVirtualMFADevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateVirtualMFADeviceRequest method.
//    req, resp := client.CreateVirtualMFADeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADevice
func (c *IAM) CreateVirtualMFADeviceRequest(input *CreateVirtualMFADeviceInput) (req *request.Request, output *CreateVirtualMFADeviceOutput) {
	op := &request.Operation{
		Name:       opCreateVirtualMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVirtualMFADeviceInput{}
	}

	output = &CreateVirtualMFADeviceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVirtualMFADevice API operation for AWS Identity and Access Management.
//
// Creates a new virtual MFA device for the AWS account. After creating the
// virtual MFA, use EnableMFADevice to attach the MFA device to an IAM user.
// For more information about creating and working with virtual MFA devices,
// go to Using a Virtual MFA Device (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html)
// in the IAM User Guide.
//
// For information about limits on the number of MFA devices you can create,
// see Limitations on Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// The seed information contained in the QR code and the Base32 string should
// be treated like any other secret access information, such as your AWS access
// keys or your passwords. After you provision your virtual device, you should
// ensure that the information is destroyed following secure procedures.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation CreateVirtualMFADevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADevice
func (c *IAM) CreateVirtualMFADevice(input *CreateVirtualMFADeviceInput) (*CreateVirtualMFADeviceOutput, error) {
	req, out := c.CreateVirtualMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opDeactivateMFADevice = "DeactivateMFADevice"

// DeactivateMFADeviceRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateMFADevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeactivateMFADevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeactivateMFADevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeactivateMFADeviceRequest method.
//    req, resp := client.DeactivateMFADeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADevice
func (c *IAM) DeactivateMFADeviceRequest(input *DeactivateMFADeviceInput) (req *request.Request, output *DeactivateMFADeviceOutput) {
	op := &request.Operation{
		Name:       opDeactivateMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeactivateMFADeviceInput{}
	}

	output = &DeactivateMFADeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeactivateMFADevice API operation for AWS Identity and Access Management.
//
// Deactivates the specified MFA device and removes it from association with
// the user name for which it was originally enabled.
//
// For more information about creating and working with virtual MFA devices,
// go to Using a Virtual MFA Device (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeactivateMFADevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityTemporarilyUnmodifiableException "EntityTemporarilyUnmodifiable"
//   The request was rejected because it referenced an entity that is temporarily
//   unmodifiable, such as a user name that was deleted and then recreated. The
//   error indicates that the request is likely to succeed if you try again after
//   waiting several minutes. The error message describes the entity.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADevice
func (c *IAM) DeactivateMFADevice(input *DeactivateMFADeviceInput) (*DeactivateMFADeviceOutput, error) {
	req, out := c.DeactivateMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAccessKey = "DeleteAccessKey"

// DeleteAccessKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAccessKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAccessKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAccessKeyRequest method.
//    req, resp := client.DeleteAccessKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKey
func (c *IAM) DeleteAccessKeyRequest(input *DeleteAccessKeyInput) (req *request.Request, output *DeleteAccessKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccessKeyInput{}
	}

	output = &DeleteAccessKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccessKey API operation for AWS Identity and Access Management.
//
// Deletes the access key pair associated with the specified IAM user.
//
// If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID signing the request. Because this action works
// for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteAccessKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKey
func (c *IAM) DeleteAccessKey(input *DeleteAccessKeyInput) (*DeleteAccessKeyOutput, error) {
	req, out := c.DeleteAccessKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAccountAlias = "DeleteAccountAlias"

// DeleteAccountAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAccountAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAccountAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAccountAliasRequest method.
//    req, resp := client.DeleteAccountAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAlias
func (c *IAM) DeleteAccountAliasRequest(input *DeleteAccountAliasInput) (req *request.Request, output *DeleteAccountAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccountAliasInput{}
	}

	output = &DeleteAccountAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccountAlias API operation for AWS Identity and Access Management.
//
// Deletes the specified AWS account alias. For information about using an AWS
// account alias, see Using an Alias for Your AWS Account ID (http://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteAccountAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAlias
func (c *IAM) DeleteAccountAlias(input *DeleteAccountAliasInput) (*DeleteAccountAliasOutput, error) {
	req, out := c.DeleteAccountAliasRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAccountPasswordPolicy = "DeleteAccountPasswordPolicy"

// DeleteAccountPasswordPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountPasswordPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAccountPasswordPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAccountPasswordPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAccountPasswordPolicyRequest method.
//    req, resp := client.DeleteAccountPasswordPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy
func (c *IAM) DeleteAccountPasswordPolicyRequest(input *DeleteAccountPasswordPolicyInput) (req *request.Request, output *DeleteAccountPasswordPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountPasswordPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccountPasswordPolicyInput{}
	}

	output = &DeleteAccountPasswordPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccountPasswordPolicy API operation for AWS Identity and Access Management.
//
// Deletes the password policy for the AWS account. There are no parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteAccountPasswordPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy
func (c *IAM) DeleteAccountPasswordPolicy(input *DeleteAccountPasswordPolicyInput) (*DeleteAccountPasswordPolicyOutput, error) {
	req, out := c.DeleteAccountPasswordPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteGroup = "DeleteGroup"

// DeleteGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteGroupRequest method.
//    req, resp := client.DeleteGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroup
func (c *IAM) DeleteGroupRequest(input *DeleteGroupInput) (req *request.Request, output *DeleteGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupInput{}
	}

	output = &DeleteGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroup API operation for AWS Identity and Access Management.
//
// Deletes the specified IAM group. The group must not contain any users or
// have any attached policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeDeleteConflictException "DeleteConflict"
//   The request was rejected because it attempted to delete a resource that has
//   attached subordinate entities. The error message describes these entities.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroup
func (c *IAM) DeleteGroup(input *DeleteGroupInput) (*DeleteGroupOutput, error) {
	req, out := c.DeleteGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteGroupPolicy = "DeleteGroupPolicy"

// DeleteGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGroupPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteGroupPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteGroupPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteGroupPolicyRequest method.
//    req, resp := client.DeleteGroupPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicy
func (c *IAM) DeleteGroupPolicyRequest(input *DeleteGroupPolicyInput) (req *request.Request, output *DeleteGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGroupPolicyInput{}
	}

	output = &DeleteGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGroupPolicy API operation for AWS Identity and Access Management.
//
// Deletes the specified inline policy that is embedded in the specified IAM
// group.
//
// A group can also have managed policies attached to it. To detach a managed
// policy from a group, use DetachGroupPolicy. For more information about policies,
// refer to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteGroupPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicy
func (c *IAM) DeleteGroupPolicy(input *DeleteGroupPolicyInput) (*DeleteGroupPolicyOutput, error) {
	req, out := c.DeleteGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteInstanceProfile = "DeleteInstanceProfile"

// DeleteInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteInstanceProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteInstanceProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteInstanceProfileRequest method.
//    req, resp := client.DeleteInstanceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfile
func (c *IAM) DeleteInstanceProfileRequest(input *DeleteInstanceProfileInput) (req *request.Request, output *DeleteInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceProfileInput{}
	}

	output = &DeleteInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInstanceProfile API operation for AWS Identity and Access Management.
//
// Deletes the specified instance profile. The instance profile must not have
// an associated role.
//
// Make sure you do not have any Amazon EC2 instances running with the instance
// profile you are about to delete. Deleting a role or instance profile that
// is associated with a running instance will break any applications running
// on the instance.
//
// For more information about instance profiles, go to About Instance Profiles
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteInstanceProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeDeleteConflictException "DeleteConflict"
//   The request was rejected because it attempted to delete a resource that has
//   attached subordinate entities. The error message describes these entities.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfile
func (c *IAM) DeleteInstanceProfile(input *DeleteInstanceProfileInput) (*DeleteInstanceProfileOutput, error) {
	req, out := c.DeleteInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLoginProfile = "DeleteLoginProfile"

// DeleteLoginProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoginProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteLoginProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteLoginProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteLoginProfileRequest method.
//    req, resp := client.DeleteLoginProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfile
func (c *IAM) DeleteLoginProfileRequest(input *DeleteLoginProfileInput) (req *request.Request, output *DeleteLoginProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoginProfileInput{}
	}

	output = &DeleteLoginProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLoginProfile API operation for AWS Identity and Access Management.
//
// Deletes the password for the specified IAM user, which terminates the user's
// ability to access AWS services through the AWS Management Console.
//
// Deleting a user's password does not prevent a user from accessing AWS through
// the command line interface or the API. To prevent all user access you must
// also either make any access keys inactive or delete them. For more information
// about making keys inactive or deleting them, see UpdateAccessKey and DeleteAccessKey.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteLoginProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityTemporarilyUnmodifiableException "EntityTemporarilyUnmodifiable"
//   The request was rejected because it referenced an entity that is temporarily
//   unmodifiable, such as a user name that was deleted and then recreated. The
//   error indicates that the request is likely to succeed if you try again after
//   waiting several minutes. The error message describes the entity.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfile
func (c *IAM) DeleteLoginProfile(input *DeleteLoginProfileInput) (*DeleteLoginProfileOutput, error) {
	req, out := c.DeleteLoginProfileRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteOpenIDConnectProvider = "DeleteOpenIDConnectProvider"

// DeleteOpenIDConnectProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteOpenIDConnectProvider operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteOpenIDConnectProvider for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteOpenIDConnectProvider method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteOpenIDConnectProviderRequest method.
//    req, resp := client.DeleteOpenIDConnectProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProvider
func (c *IAM) DeleteOpenIDConnectProviderRequest(input *DeleteOpenIDConnectProviderInput) (req *request.Request, output *DeleteOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteOpenIDConnectProviderInput{}
	}

	output = &DeleteOpenIDConnectProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteOpenIDConnectProvider API operation for AWS Identity and Access Management.
//
// Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
//
// Deleting an IAM OIDC provider resource does not update any roles that reference
// the provider as a principal in their trust policies. Any attempt to assume
// a role that references a deleted provider fails.
//
// This action is idempotent; it does not fail or return an error if you call
// the action for a provider that does not exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteOpenIDConnectProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProvider
func (c *IAM) DeleteOpenIDConnectProvider(input *DeleteOpenIDConnectProviderInput) (*DeleteOpenIDConnectProviderOutput, error) {
	req, out := c.DeleteOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicy
func (c *IAM) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	output = &DeletePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicy API operation for AWS Identity and Access Management.
//
// Deletes the specified managed policy.
//
// Before you can delete a managed policy, you must first detach the policy
// from all users, groups, and roles that it is attached to, and you must delete
// all of the policy's versions. The following steps describe the process for
// deleting a managed policy:
//
//    * Detach the policy from all users, groups, and roles that the policy
//    is attached to, using the DetachUserPolicy, DetachGroupPolicy, or DetachRolePolicy
//    APIs. To list all the users, groups, and roles that a policy is attached
//    to, use ListEntitiesForPolicy.
//
//    * Delete all versions of the policy using DeletePolicyVersion. To list
//    the policy's versions, use ListPolicyVersions. You cannot use DeletePolicyVersion
//    to delete the version that is marked as the default version. You delete
//    the policy's default version in the next step of the process.
//
//    * Delete the policy (this automatically deletes the policy's default version)
//    using this API.
//
// For information about managed policies, see Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeDeleteConflictException "DeleteConflict"
//   The request was rejected because it attempted to delete a resource that has
//   attached subordinate entities. The error message describes these entities.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicy
func (c *IAM) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePolicyVersion = "DeletePolicyVersion"

// DeletePolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicyVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePolicyVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePolicyVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePolicyVersionRequest method.
//    req, resp := client.DeletePolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersion
func (c *IAM) DeletePolicyVersionRequest(input *DeletePolicyVersionInput) (req *request.Request, output *DeletePolicyVersionOutput) {
	op := &request.Operation{
		Name:       opDeletePolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyVersionInput{}
	}

	output = &DeletePolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePolicyVersion API operation for AWS Identity and Access Management.
//
// Deletes the specified version from the specified managed policy.
//
// You cannot delete the default version from a policy using this API. To delete
// the default version from a policy, use DeletePolicy. To find out which version
// of a policy is marked as the default version, use ListPolicyVersions.
//
// For information about versions for managed policies, see Versioning for Managed
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeletePolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeDeleteConflictException "DeleteConflict"
//   The request was rejected because it attempted to delete a resource that has
//   attached subordinate entities. The error message describes these entities.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersion
func (c *IAM) DeletePolicyVersion(input *DeletePolicyVersionInput) (*DeletePolicyVersionOutput, error) {
	req, out := c.DeletePolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRole = "DeleteRole"

// DeleteRoleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRole operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRole for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRole method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRoleRequest method.
//    req, resp := client.DeleteRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRole
func (c *IAM) DeleteRoleRequest(input *DeleteRoleInput) (req *request.Request, output *DeleteRoleOutput) {
	op := &request.Operation{
		Name:       opDeleteRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRoleInput{}
	}

	output = &DeleteRoleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRole API operation for AWS Identity and Access Management.
//
// Deletes the specified role. The role must not have any policies attached.
// For more information about roles, go to Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
//
// Make sure you do not have any Amazon EC2 instances running with the role
// you are about to delete. Deleting a role or instance profile that is associated
// with a running instance will break any applications running on the instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeDeleteConflictException "DeleteConflict"
//   The request was rejected because it attempted to delete a resource that has
//   attached subordinate entities. The error message describes these entities.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRole
func (c *IAM) DeleteRole(input *DeleteRoleInput) (*DeleteRoleOutput, error) {
	req, out := c.DeleteRoleRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteRolePolicy = "DeleteRolePolicy"

// DeleteRolePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRolePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteRolePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteRolePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteRolePolicyRequest method.
//    req, resp := client.DeleteRolePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicy
func (c *IAM) DeleteRolePolicyRequest(input *DeleteRolePolicyInput) (req *request.Request, output *DeleteRolePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRolePolicyInput{}
	}

	output = &DeleteRolePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRolePolicy API operation for AWS Identity and Access Management.
//
// Deletes the specified inline policy that is embedded in the specified IAM
// role.
//
// A role can also have managed policies attached to it. To detach a managed
// policy from a role, use DetachRolePolicy. For more information about policies,
// refer to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteRolePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicy
func (c *IAM) DeleteRolePolicy(input *DeleteRolePolicyInput) (*DeleteRolePolicyOutput, error) {
	req, out := c.DeleteRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSAMLProvider = "DeleteSAMLProvider"

// DeleteSAMLProviderRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSAMLProvider operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSAMLProvider for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSAMLProvider method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSAMLProviderRequest method.
//    req, resp := client.DeleteSAMLProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProvider
func (c *IAM) DeleteSAMLProviderRequest(input *DeleteSAMLProviderInput) (req *request.Request, output *DeleteSAMLProviderOutput) {
	op := &request.Operation{
		Name:       opDeleteSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSAMLProviderInput{}
	}

	output = &DeleteSAMLProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSAMLProvider API operation for AWS Identity and Access Management.
//
// Deletes a SAML provider resource in IAM.
//
// Deleting the provider resource from IAM does not update any roles that reference
// the SAML provider resource's ARN as a principal in their trust policies.
// Any attempt to assume a role that references a non-existent provider resource
// ARN fails.
//
// This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteSAMLProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProvider
func (c *IAM) DeleteSAMLProvider(input *DeleteSAMLProviderInput) (*DeleteSAMLProviderOutput, error) {
	req, out := c.DeleteSAMLProviderRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSSHPublicKey = "DeleteSSHPublicKey"

// DeleteSSHPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSSHPublicKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSSHPublicKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSSHPublicKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSSHPublicKeyRequest method.
//    req, resp := client.DeleteSSHPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKey
func (c *IAM) DeleteSSHPublicKeyRequest(input *DeleteSSHPublicKeyInput) (req *request.Request, output *DeleteSSHPublicKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSSHPublicKeyInput{}
	}

	output = &DeleteSSHPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSSHPublicKey API operation for AWS Identity and Access Management.
//
// Deletes the specified SSH public key.
//
// The SSH public key deleted by this action is used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteSSHPublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKey
func (c *IAM) DeleteSSHPublicKey(input *DeleteSSHPublicKeyInput) (*DeleteSSHPublicKeyOutput, error) {
	req, out := c.DeleteSSHPublicKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteServerCertificate = "DeleteServerCertificate"

// DeleteServerCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServerCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteServerCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteServerCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteServerCertificateRequest method.
//    req, resp := client.DeleteServerCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificate
func (c *IAM) DeleteServerCertificateRequest(input *DeleteServerCertificateInput) (req *request.Request, output *DeleteServerCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerCertificateInput{}
	}

	output = &DeleteServerCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServerCertificate API operation for AWS Identity and Access Management.
//
// Deletes the specified server certificate.
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
//
// If you are using a server certificate with Elastic Load Balancing, deleting
// the certificate could have implications for your application. If Elastic
// Load Balancing doesn't detect the deletion of bound certificates, it may
// continue to use the certificates. This could cause Elastic Load Balancing
// to stop accepting traffic. We recommend that you remove the reference to
// the certificate from Elastic Load Balancing before using this command to
// delete the certificate. For more information, go to DeleteLoadBalancerListeners
// (http://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html)
// in the Elastic Load Balancing API Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteServerCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeDeleteConflictException "DeleteConflict"
//   The request was rejected because it attempted to delete a resource that has
//   attached subordinate entities. The error message describes these entities.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificate
func (c *IAM) DeleteServerCertificate(input *DeleteServerCertificateInput) (*DeleteServerCertificateOutput, error) {
	req, out := c.DeleteServerCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteServiceSpecificCredential = "DeleteServiceSpecificCredential"

// DeleteServiceSpecificCredentialRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceSpecificCredential operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteServiceSpecificCredential for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteServiceSpecificCredential method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteServiceSpecificCredentialRequest method.
//    req, resp := client.DeleteServiceSpecificCredentialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredential
func (c *IAM) DeleteServiceSpecificCredentialRequest(input *DeleteServiceSpecificCredentialInput) (req *request.Request, output *DeleteServiceSpecificCredentialOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceSpecificCredential,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceSpecificCredentialInput{}
	}

	output = &DeleteServiceSpecificCredentialOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServiceSpecificCredential API operation for AWS Identity and Access Management.
//
// Deletes the specified service-specific credential.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteServiceSpecificCredential for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredential
func (c *IAM) DeleteServiceSpecificCredential(input *DeleteServiceSpecificCredentialInput) (*DeleteServiceSpecificCredentialOutput, error) {
	req, out := c.DeleteServiceSpecificCredentialRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteSigningCertificate = "DeleteSigningCertificate"

// DeleteSigningCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSigningCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteSigningCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteSigningCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteSigningCertificateRequest method.
//    req, resp := client.DeleteSigningCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificate
func (c *IAM) DeleteSigningCertificateRequest(input *DeleteSigningCertificateInput) (req *request.Request, output *DeleteSigningCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSigningCertificateInput{}
	}

	output = &DeleteSigningCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSigningCertificate API operation for AWS Identity and Access Management.
//
// Deletes a signing certificate associated with the specified IAM user.
//
// If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID signing the request. Because this action works
// for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated IAM users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteSigningCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificate
func (c *IAM) DeleteSigningCertificate(input *DeleteSigningCertificateInput) (*DeleteSigningCertificateOutput, error) {
	req, out := c.DeleteSigningCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteUserRequest method.
//    req, resp := client.DeleteUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUser
func (c *IAM) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for AWS Identity and Access Management.
//
// Deletes the specified IAM user. The user must not belong to any groups or
// have any access keys, signing certificates, or attached policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeDeleteConflictException "DeleteConflict"
//   The request was rejected because it attempted to delete a resource that has
//   attached subordinate entities. The error message describes these entities.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUser
func (c *IAM) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteUserPolicy = "DeleteUserPolicy"

// DeleteUserPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteUserPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteUserPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteUserPolicyRequest method.
//    req, resp := client.DeleteUserPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicy
func (c *IAM) DeleteUserPolicyRequest(input *DeleteUserPolicyInput) (req *request.Request, output *DeleteUserPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserPolicyInput{}
	}

	output = &DeleteUserPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserPolicy API operation for AWS Identity and Access Management.
//
// Deletes the specified inline policy that is embedded in the specified IAM
// user.
//
// A user can also have managed policies attached to it. To detach a managed
// policy from a user, use DetachUserPolicy. For more information about policies,
// refer to Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteUserPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicy
func (c *IAM) DeleteUserPolicy(input *DeleteUserPolicyInput) (*DeleteUserPolicyOutput, error) {
	req, out := c.DeleteUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVirtualMFADevice = "DeleteVirtualMFADevice"

// DeleteVirtualMFADeviceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVirtualMFADevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteVirtualMFADevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteVirtualMFADevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteVirtualMFADeviceRequest method.
//    req, resp := client.DeleteVirtualMFADeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADevice
func (c *IAM) DeleteVirtualMFADeviceRequest(input *DeleteVirtualMFADeviceInput) (req *request.Request, output *DeleteVirtualMFADeviceOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVirtualMFADeviceInput{}
	}

	output = &DeleteVirtualMFADeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVirtualMFADevice API operation for AWS Identity and Access Management.
//
// Deletes a virtual MFA device.
//
// You must deactivate a user's virtual MFA device before you can delete it.
// For information about deactivating MFA devices, see DeactivateMFADevice.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DeleteVirtualMFADevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeDeleteConflictException "DeleteConflict"
//   The request was rejected because it attempted to delete a resource that has
//   attached subordinate entities. The error message describes these entities.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADevice
func (c *IAM) DeleteVirtualMFADevice(input *DeleteVirtualMFADeviceInput) (*DeleteVirtualMFADeviceOutput, error) {
	req, out := c.DeleteVirtualMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opDetachGroupPolicy = "DetachGroupPolicy"

// DetachGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachGroupPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachGroupPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachGroupPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachGroupPolicyRequest method.
//    req, resp := client.DetachGroupPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicy
func (c *IAM) DetachGroupPolicyRequest(input *DetachGroupPolicyInput) (req *request.Request, output *DetachGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachGroupPolicyInput{}
	}

	output = &DetachGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachGroupPolicy API operation for AWS Identity and Access Management.
//
// Removes the specified managed policy from the specified IAM group.
//
// A group can also have inline policies embedded with it. To delete an inline
// policy, use the DeleteGroupPolicy API. For information about policies, see
// Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DetachGroupPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicy
func (c *IAM) DetachGroupPolicy(input *DetachGroupPolicyInput) (*DetachGroupPolicyOutput, error) {
	req, out := c.DetachGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDetachRolePolicy = "DetachRolePolicy"

// DetachRolePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachRolePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachRolePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachRolePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachRolePolicyRequest method.
//    req, resp := client.DetachRolePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicy
func (c *IAM) DetachRolePolicyRequest(input *DetachRolePolicyInput) (req *request.Request, output *DetachRolePolicyOutput) {
	op := &request.Operation{
		Name:       opDetachRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachRolePolicyInput{}
	}

	output = &DetachRolePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachRolePolicy API operation for AWS Identity and Access Management.
//
// Removes the specified managed policy from the specified role.
//
// A role can also have inline policies embedded with it. To delete an inline
// policy, use the DeleteRolePolicy API. For information about policies, see
// Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DetachRolePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicy
func (c *IAM) DetachRolePolicy(input *DetachRolePolicyInput) (*DetachRolePolicyOutput, error) {
	req, out := c.DetachRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDetachUserPolicy = "DetachUserPolicy"

// DetachUserPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DetachUserPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachUserPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachUserPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachUserPolicyRequest method.
//    req, resp := client.DetachUserPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicy
func (c *IAM) DetachUserPolicyRequest(input *DetachUserPolicyInput) (req *request.Request, output *DetachUserPolicyOutput) {
	op := &request.Operation{
		Name:       opDetachUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachUserPolicyInput{}
	}

	output = &DetachUserPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachUserPolicy API operation for AWS Identity and Access Management.
//
// Removes the specified managed policy from the specified user.
//
// A user can also have inline policies embedded with it. To delete an inline
// policy, use the DeleteUserPolicy API. For information about policies, see
// Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation DetachUserPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicy
func (c *IAM) DetachUserPolicy(input *DetachUserPolicyInput) (*DetachUserPolicyOutput, error) {
	req, out := c.DetachUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opEnableMFADevice = "EnableMFADevice"

// EnableMFADeviceRequest generates a "aws/request.Request" representing the
// client's request for the EnableMFADevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableMFADevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableMFADevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableMFADeviceRequest method.
//    req, resp := client.EnableMFADeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADevice
func (c *IAM) EnableMFADeviceRequest(input *EnableMFADeviceInput) (req *request.Request, output *EnableMFADeviceOutput) {
	op := &request.Operation{
		Name:       opEnableMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableMFADeviceInput{}
	}

	output = &EnableMFADeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// EnableMFADevice API operation for AWS Identity and Access Management.
//
// Enables the specified MFA device and associates it with the specified IAM
// user. When enabled, the MFA device is required for every subsequent login
// by the IAM user associated with the device.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation EnableMFADevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeEntityTemporarilyUnmodifiableException "EntityTemporarilyUnmodifiable"
//   The request was rejected because it referenced an entity that is temporarily
//   unmodifiable, such as a user name that was deleted and then recreated. The
//   error indicates that the request is likely to succeed if you try again after
//   waiting several minutes. The error message describes the entity.
//
//   * ErrCodeInvalidAuthenticationCodeException "InvalidAuthenticationCode"
//   The request was rejected because the authentication code was not recognized.
//   The error message describes the specific error.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADevice
func (c *IAM) EnableMFADevice(input *EnableMFADeviceInput) (*EnableMFADeviceOutput, error) {
	req, out := c.EnableMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateCredentialReport = "GenerateCredentialReport"

// GenerateCredentialReportRequest generates a "aws/request.Request" representing the
// client's request for the GenerateCredentialReport operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GenerateCredentialReport for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GenerateCredentialReport method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GenerateCredentialReportRequest method.
//    req, resp := client.GenerateCredentialReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport
func (c *IAM) GenerateCredentialReportRequest(input *GenerateCredentialReportInput) (req *request.Request, output *GenerateCredentialReportOutput) {
	op := &request.Operation{
		Name:       opGenerateCredentialReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateCredentialReportInput{}
	}

	output = &GenerateCredentialReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateCredentialReport API operation for AWS Identity and Access Management.
//
// Generates a credential report for the AWS account. For more information about
// the credential report, see Getting Credential Reports (http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GenerateCredentialReport for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport
func (c *IAM) GenerateCredentialReport(input *GenerateCredentialReportInput) (*GenerateCredentialReportOutput, error) {
	req, out := c.GenerateCredentialReportRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccessKeyLastUsed = "GetAccessKeyLastUsed"

// GetAccessKeyLastUsedRequest generates a "aws/request.Request" representing the
// client's request for the GetAccessKeyLastUsed operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetAccessKeyLastUsed for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAccessKeyLastUsed method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAccessKeyLastUsedRequest method.
//    req, resp := client.GetAccessKeyLastUsedRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsed
func (c *IAM) GetAccessKeyLastUsedRequest(input *GetAccessKeyLastUsedInput) (req *request.Request, output *GetAccessKeyLastUsedOutput) {
	op := &request.Operation{
		Name:       opGetAccessKeyLastUsed,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccessKeyLastUsedInput{}
	}

	output = &GetAccessKeyLastUsedOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccessKeyLastUsed API operation for AWS Identity and Access Management.
//
// Retrieves information about when the specified access key was last used.
// The information includes the date and time of last use, along with the AWS
// service and region that were specified in the last request made with that
// key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetAccessKeyLastUsed for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsed
func (c *IAM) GetAccessKeyLastUsed(input *GetAccessKeyLastUsedInput) (*GetAccessKeyLastUsedOutput, error) {
	req, out := c.GetAccessKeyLastUsedRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccountAuthorizationDetails = "GetAccountAuthorizationDetails"

// GetAccountAuthorizationDetailsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountAuthorizationDetails operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetAccountAuthorizationDetails for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAccountAuthorizationDetails method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAccountAuthorizationDetailsRequest method.
//    req, resp := client.GetAccountAuthorizationDetailsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails
func (c *IAM) GetAccountAuthorizationDetailsRequest(input *GetAccountAuthorizationDetailsInput) (req *request.Request, output *GetAccountAuthorizationDetailsOutput) {
	op := &request.Operation{
		Name:       opGetAccountAuthorizationDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &GetAccountAuthorizationDetailsInput{}
	}

	output = &GetAccountAuthorizationDetailsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountAuthorizationDetails API operation for AWS Identity and Access Management.
//
// Retrieves information about all IAM users, groups, roles, and policies in
// your AWS account, including their relationships to one another. Use this
// API to obtain a snapshot of the configuration of IAM permissions (users,
// groups, roles, and policies) in your account.
//
// You can optionally filter the results using the Filter parameter. You can
// paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetAccountAuthorizationDetails for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails
func (c *IAM) GetAccountAuthorizationDetails(input *GetAccountAuthorizationDetailsInput) (*GetAccountAuthorizationDetailsOutput, error) {
	req, out := c.GetAccountAuthorizationDetailsRequest(input)
	err := req.Send()
	return out, err
}

// GetAccountAuthorizationDetailsPages iterates over the pages of a GetAccountAuthorizationDetails operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetAccountAuthorizationDetails method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetAccountAuthorizationDetails operation.
//    pageNum := 0
//    err := client.GetAccountAuthorizationDetailsPages(params,
//        func(page *GetAccountAuthorizationDetailsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) GetAccountAuthorizationDetailsPages(input *GetAccountAuthorizationDetailsInput, fn func(p *GetAccountAuthorizationDetailsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetAccountAuthorizationDetailsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetAccountAuthorizationDetailsOutput), lastPage)
	})
}

const opGetAccountPasswordPolicy = "GetAccountPasswordPolicy"

// GetAccountPasswordPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountPasswordPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetAccountPasswordPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAccountPasswordPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAccountPasswordPolicyRequest method.
//    req, resp := client.GetAccountPasswordPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy
func (c *IAM) GetAccountPasswordPolicyRequest(input *GetAccountPasswordPolicyInput) (req *request.Request, output *GetAccountPasswordPolicyOutput) {
	op := &request.Operation{
		Name:       opGetAccountPasswordPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountPasswordPolicyInput{}
	}

	output = &GetAccountPasswordPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountPasswordPolicy API operation for AWS Identity and Access Management.
//
// Retrieves the password policy for the AWS account. For more information about
// using a password policy, go to Managing an IAM Password Policy (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetAccountPasswordPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy
func (c *IAM) GetAccountPasswordPolicy(input *GetAccountPasswordPolicyInput) (*GetAccountPasswordPolicyOutput, error) {
	req, out := c.GetAccountPasswordPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccountSummary = "GetAccountSummary"

// GetAccountSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSummary operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetAccountSummary for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAccountSummary method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAccountSummaryRequest method.
//    req, resp := client.GetAccountSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary
func (c *IAM) GetAccountSummaryRequest(input *GetAccountSummaryInput) (req *request.Request, output *GetAccountSummaryOutput) {
	op := &request.Operation{
		Name:       opGetAccountSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountSummaryInput{}
	}

	output = &GetAccountSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSummary API operation for AWS Identity and Access Management.
//
// Retrieves information about IAM entity usage and IAM quotas in the AWS account.
//
// For information about limitations on IAM entities, see Limitations on IAM
// Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetAccountSummary for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary
func (c *IAM) GetAccountSummary(input *GetAccountSummaryInput) (*GetAccountSummaryOutput, error) {
	req, out := c.GetAccountSummaryRequest(input)
	err := req.Send()
	return out, err
}

const opGetContextKeysForCustomPolicy = "GetContextKeysForCustomPolicy"

// GetContextKeysForCustomPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetContextKeysForCustomPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetContextKeysForCustomPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetContextKeysForCustomPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetContextKeysForCustomPolicyRequest method.
//    req, resp := client.GetContextKeysForCustomPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForCustomPolicy
func (c *IAM) GetContextKeysForCustomPolicyRequest(input *GetContextKeysForCustomPolicyInput) (req *request.Request, output *GetContextKeysForPolicyResponse) {
	op := &request.Operation{
		Name:       opGetContextKeysForCustomPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContextKeysForCustomPolicyInput{}
	}

	output = &GetContextKeysForPolicyResponse{}
	req = c.newRequest(op, input, output)
	return
}

// GetContextKeysForCustomPolicy API operation for AWS Identity and Access Management.
//
// Gets a list of all of the context keys referenced in the input policies.
// The policies are supplied as a list of one or more strings. To get the context
// keys from policies associated with an IAM user, group, or role, use GetContextKeysForPrincipalPolicy.
//
// Context keys are variables maintained by AWS and its services that provide
// details about the context of an API query request, and can be evaluated by
// testing against a value specified in an IAM policy. Use GetContextKeysForCustomPolicy
// to understand what key names and values you must supply when you call SimulateCustomPolicy.
// Note that all parameters are shown in unencoded form here for clarity, but
// must be URL encoded to be included as a part of a real HTML request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetContextKeysForCustomPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForCustomPolicy
func (c *IAM) GetContextKeysForCustomPolicy(input *GetContextKeysForCustomPolicyInput) (*GetContextKeysForPolicyResponse, error) {
	req, out := c.GetContextKeysForCustomPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetContextKeysForPrincipalPolicy = "GetContextKeysForPrincipalPolicy"

// GetContextKeysForPrincipalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetContextKeysForPrincipalPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetContextKeysForPrincipalPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetContextKeysForPrincipalPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetContextKeysForPrincipalPolicyRequest method.
//    req, resp := client.GetContextKeysForPrincipalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPrincipalPolicy
func (c *IAM) GetContextKeysForPrincipalPolicyRequest(input *GetContextKeysForPrincipalPolicyInput) (req *request.Request, output *GetContextKeysForPolicyResponse) {
	op := &request.Operation{
		Name:       opGetContextKeysForPrincipalPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContextKeysForPrincipalPolicyInput{}
	}

	output = &GetContextKeysForPolicyResponse{}
	req = c.newRequest(op, input, output)
	return
}

// GetContextKeysForPrincipalPolicy API operation for AWS Identity and Access Management.
//
// Gets a list of all of the context keys referenced in all of the IAM policies
// attached to the specified IAM entity. The entity can be an IAM user, group,
// or role. If you specify a user, then the request also includes all of the
// policies attached to groups that the user is a member of.
//
// You can optionally include a list of one or more additional policies, specified
// as strings. If you want to include only a list of policies by string, use
// GetContextKeysForCustomPolicy instead.
//
// Note: This API discloses information about the permissions granted to other
// users. If you do not want users to see other user's permissions, then consider
// allowing them to use GetContextKeysForCustomPolicy instead.
//
// Context keys are variables maintained by AWS and its services that provide
// details about the context of an API query request, and can be evaluated by
// testing against a value in an IAM policy. Use GetContextKeysForPrincipalPolicy
// to understand what key names and values you must supply when you call SimulatePrincipalPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetContextKeysForPrincipalPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPrincipalPolicy
func (c *IAM) GetContextKeysForPrincipalPolicy(input *GetContextKeysForPrincipalPolicyInput) (*GetContextKeysForPolicyResponse, error) {
	req, out := c.GetContextKeysForPrincipalPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetCredentialReport = "GetCredentialReport"

// GetCredentialReportRequest generates a "aws/request.Request" representing the
// client's request for the GetCredentialReport operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetCredentialReport for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetCredentialReport method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetCredentialReportRequest method.
//    req, resp := client.GetCredentialReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport
func (c *IAM) GetCredentialReportRequest(input *GetCredentialReportInput) (req *request.Request, output *GetCredentialReportOutput) {
	op := &request.Operation{
		Name:       opGetCredentialReport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCredentialReportInput{}
	}

	output = &GetCredentialReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCredentialReport API operation for AWS Identity and Access Management.
//
// Retrieves a credential report for the AWS account. For more information about
// the credential report, see Getting Credential Reports (http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetCredentialReport for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeCredentialReportNotPresentException "ReportNotPresent"
//   The request was rejected because the credential report does not exist. To
//   generate a credential report, use GenerateCredentialReport.
//
//   * ErrCodeCredentialReportExpiredException "ReportExpired"
//   The request was rejected because the most recent credential report has expired.
//   To generate a new credential report, use GenerateCredentialReport. For more
//   information about credential report expiration, see Getting Credential Reports
//   (http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
//   in the IAM User Guide.
//
//   * ErrCodeCredentialReportNotReadyException "ReportInProgress"
//   The request was rejected because the credential report is still being generated.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport
func (c *IAM) GetCredentialReport(input *GetCredentialReportInput) (*GetCredentialReportOutput, error) {
	req, out := c.GetCredentialReportRequest(input)
	err := req.Send()
	return out, err
}

const opGetGroup = "GetGroup"

// GetGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetGroupRequest method.
//    req, resp := client.GetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup
func (c *IAM) GetGroupRequest(input *GetGroupInput) (req *request.Request, output *GetGroupOutput) {
	op := &request.Operation{
		Name:       opGetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &GetGroupInput{}
	}

	output = &GetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroup API operation for AWS Identity and Access Management.
//
// Returns a list of IAM users that are in the specified IAM group. You can
// paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup
func (c *IAM) GetGroup(input *GetGroupInput) (*GetGroupOutput, error) {
	req, out := c.GetGroupRequest(input)
	err := req.Send()
	return out, err
}

// GetGroupPages iterates over the pages of a GetGroup operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetGroup method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetGroup operation.
//    pageNum := 0
//    err := client.GetGroupPages(params,
//        func(page *GetGroupOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) GetGroupPages(input *GetGroupInput, fn func(p *GetGroupOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.GetGroupRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*GetGroupOutput), lastPage)
	})
}

const opGetGroupPolicy = "GetGroupPolicy"

// GetGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetGroupPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetGroupPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetGroupPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetGroupPolicyRequest method.
//    req, resp := client.GetGroupPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicy
func (c *IAM) GetGroupPolicyRequest(input *GetGroupPolicyInput) (req *request.Request, output *GetGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opGetGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGroupPolicyInput{}
	}

	output = &GetGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGroupPolicy API operation for AWS Identity and Access Management.
//
// Retrieves the specified inline policy document that is embedded in the specified
// IAM group.
//
// Policies returned by this API are URL-encoded compliant with RFC 3986 (https://tools.ietf.org/html/rfc3986).
// You can use a URL decoding method to convert the policy back to plain JSON
// text. For example, if you use Java, you can use the decode method of the
// java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs
// provide similar functionality.
//
// An IAM group can also have managed policies attached to it. To retrieve a
// managed policy document that is attached to a group, use GetPolicy to determine
// the policy's default version, then use GetPolicyVersion to retrieve the policy
// document.
//
// For more information about policies, see Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetGroupPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicy
func (c *IAM) GetGroupPolicy(input *GetGroupPolicyInput) (*GetGroupPolicyOutput, error) {
	req, out := c.GetGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetInstanceProfile = "GetInstanceProfile"

// GetInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetInstanceProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetInstanceProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetInstanceProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetInstanceProfileRequest method.
//    req, resp := client.GetInstanceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfile
func (c *IAM) GetInstanceProfileRequest(input *GetInstanceProfileInput) (req *request.Request, output *GetInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opGetInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceProfileInput{}
	}

	output = &GetInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstanceProfile API operation for AWS Identity and Access Management.
//
// Retrieves information about the specified instance profile, including the
// instance profile's path, GUID, ARN, and role. For more information about
// instance profiles, see About Instance Profiles (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetInstanceProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfile
func (c *IAM) GetInstanceProfile(input *GetInstanceProfileInput) (*GetInstanceProfileOutput, error) {
	req, out := c.GetInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opGetLoginProfile = "GetLoginProfile"

// GetLoginProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetLoginProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetLoginProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetLoginProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetLoginProfileRequest method.
//    req, resp := client.GetLoginProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfile
func (c *IAM) GetLoginProfileRequest(input *GetLoginProfileInput) (req *request.Request, output *GetLoginProfileOutput) {
	op := &request.Operation{
		Name:       opGetLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoginProfileInput{}
	}

	output = &GetLoginProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoginProfile API operation for AWS Identity and Access Management.
//
// Retrieves the user name and password-creation date for the specified IAM
// user. If the user has not been assigned a password, the action returns a
// 404 (NoSuchEntity) error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetLoginProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfile
func (c *IAM) GetLoginProfile(input *GetLoginProfileInput) (*GetLoginProfileOutput, error) {
	req, out := c.GetLoginProfileRequest(input)
	err := req.Send()
	return out, err
}

const opGetOpenIDConnectProvider = "GetOpenIDConnectProvider"

// GetOpenIDConnectProviderRequest generates a "aws/request.Request" representing the
// client's request for the GetOpenIDConnectProvider operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetOpenIDConnectProvider for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetOpenIDConnectProvider method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetOpenIDConnectProviderRequest method.
//    req, resp := client.GetOpenIDConnectProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProvider
func (c *IAM) GetOpenIDConnectProviderRequest(input *GetOpenIDConnectProviderInput) (req *request.Request, output *GetOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opGetOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOpenIDConnectProviderInput{}
	}

	output = &GetOpenIDConnectProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOpenIDConnectProvider API operation for AWS Identity and Access Management.
//
// Returns information about the specified OpenID Connect (OIDC) provider resource
// object in IAM.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetOpenIDConnectProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProvider
func (c *IAM) GetOpenIDConnectProvider(input *GetOpenIDConnectProviderInput) (*GetOpenIDConnectProviderOutput, error) {
	req, out := c.GetOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicy
func (c *IAM) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for AWS Identity and Access Management.
//
// Retrieves information about the specified managed policy, including the policy's
// default version and the total number of IAM users, groups, and roles to which
// the policy is attached. To retrieve the list of the specific users, groups,
// and roles that the policy is attached to, use the ListEntitiesForPolicy API.
// This API returns metadata about the policy. To retrieve the actual policy
// document for a specific version of the policy, use GetPolicyVersion.
//
// This API retrieves information about managed policies. To retrieve information
// about an inline policy that is embedded with an IAM user, group, or role,
// use the GetUserPolicy, GetGroupPolicy, or GetRolePolicy API.
//
// For more information about policies, see Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicy
func (c *IAM) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetPolicyVersion = "GetPolicyVersion"

// GetPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicyVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetPolicyVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetPolicyVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetPolicyVersionRequest method.
//    req, resp := client.GetPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersion
func (c *IAM) GetPolicyVersionRequest(input *GetPolicyVersionInput) (req *request.Request, output *GetPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opGetPolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPolicyVersionInput{}
	}

	output = &GetPolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicyVersion API operation for AWS Identity and Access Management.
//
// Retrieves information about the specified version of the specified managed
// policy, including the policy document.
//
// Policies returned by this API are URL-encoded compliant with RFC 3986 (https://tools.ietf.org/html/rfc3986).
// You can use a URL decoding method to convert the policy back to plain JSON
// text. For example, if you use Java, you can use the decode method of the
// java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs
// provide similar functionality.
//
// To list the available versions for a policy, use ListPolicyVersions.
//
// This API retrieves information about managed policies. To retrieve information
// about an inline policy that is embedded in a user, group, or role, use the
// GetUserPolicy, GetGroupPolicy, or GetRolePolicy API.
//
// For more information about the types of policies, see Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For more information about managed policy versions, see Versioning for Managed
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetPolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersion
func (c *IAM) GetPolicyVersion(input *GetPolicyVersionInput) (*GetPolicyVersionOutput, error) {
	req, out := c.GetPolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opGetRole = "GetRole"

// GetRoleRequest generates a "aws/request.Request" representing the
// client's request for the GetRole operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRole for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRole method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRoleRequest method.
//    req, resp := client.GetRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRole
func (c *IAM) GetRoleRequest(input *GetRoleInput) (req *request.Request, output *GetRoleOutput) {
	op := &request.Operation{
		Name:       opGetRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRoleInput{}
	}

	output = &GetRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRole API operation for AWS Identity and Access Management.
//
// Retrieves information about the specified role, including the role's path,
// GUID, ARN, and the role's trust policy that grants permission to assume the
// role. For more information about roles, see Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
//
// Policies returned by this API are URL-encoded compliant with RFC 3986 (https://tools.ietf.org/html/rfc3986).
// You can use a URL decoding method to convert the policy back to plain JSON
// text. For example, if you use Java, you can use the decode method of the
// java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs
// provide similar functionality.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRole
func (c *IAM) GetRole(input *GetRoleInput) (*GetRoleOutput, error) {
	req, out := c.GetRoleRequest(input)
	err := req.Send()
	return out, err
}

const opGetRolePolicy = "GetRolePolicy"

// GetRolePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetRolePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetRolePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetRolePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetRolePolicyRequest method.
//    req, resp := client.GetRolePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicy
func (c *IAM) GetRolePolicyRequest(input *GetRolePolicyInput) (req *request.Request, output *GetRolePolicyOutput) {
	op := &request.Operation{
		Name:       opGetRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRolePolicyInput{}
	}

	output = &GetRolePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRolePolicy API operation for AWS Identity and Access Management.
//
// Retrieves the specified inline policy document that is embedded with the
// specified IAM role.
//
// Policies returned by this API are URL-encoded compliant with RFC 3986 (https://tools.ietf.org/html/rfc3986).
// You can use a URL decoding method to convert the policy back to plain JSON
// text. For example, if you use Java, you can use the decode method of the
// java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs
// provide similar functionality.
//
// An IAM role can also have managed policies attached to it. To retrieve a
// managed policy document that is attached to a role, use GetPolicy to determine
// the policy's default version, then use GetPolicyVersion to retrieve the policy
// document.
//
// For more information about policies, see Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For more information about roles, see Using Roles to Delegate Permissions
// and Federate Identities (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetRolePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicy
func (c *IAM) GetRolePolicy(input *GetRolePolicyInput) (*GetRolePolicyOutput, error) {
	req, out := c.GetRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetSAMLProvider = "GetSAMLProvider"

// GetSAMLProviderRequest generates a "aws/request.Request" representing the
// client's request for the GetSAMLProvider operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSAMLProvider for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSAMLProvider method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSAMLProviderRequest method.
//    req, resp := client.GetSAMLProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProvider
func (c *IAM) GetSAMLProviderRequest(input *GetSAMLProviderInput) (req *request.Request, output *GetSAMLProviderOutput) {
	op := &request.Operation{
		Name:       opGetSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSAMLProviderInput{}
	}

	output = &GetSAMLProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSAMLProvider API operation for AWS Identity and Access Management.
//
// Returns the SAML provider metadocument that was uploaded when the IAM SAML
// provider resource object was created or updated.
//
// This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetSAMLProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProvider
func (c *IAM) GetSAMLProvider(input *GetSAMLProviderInput) (*GetSAMLProviderOutput, error) {
	req, out := c.GetSAMLProviderRequest(input)
	err := req.Send()
	return out, err
}

const opGetSSHPublicKey = "GetSSHPublicKey"

// GetSSHPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetSSHPublicKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetSSHPublicKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetSSHPublicKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetSSHPublicKeyRequest method.
//    req, resp := client.GetSSHPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKey
func (c *IAM) GetSSHPublicKeyRequest(input *GetSSHPublicKeyInput) (req *request.Request, output *GetSSHPublicKeyOutput) {
	op := &request.Operation{
		Name:       opGetSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSSHPublicKeyInput{}
	}

	output = &GetSSHPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSSHPublicKey API operation for AWS Identity and Access Management.
//
// Retrieves the specified SSH public key, including metadata about the key.
//
// The SSH public key retrieved by this action is used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetSSHPublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeUnrecognizedPublicKeyEncodingException "UnrecognizedPublicKeyEncoding"
//   The request was rejected because the public key encoding format is unsupported
//   or unrecognized.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKey
func (c *IAM) GetSSHPublicKey(input *GetSSHPublicKeyInput) (*GetSSHPublicKeyOutput, error) {
	req, out := c.GetSSHPublicKeyRequest(input)
	err := req.Send()
	return out, err
}

const opGetServerCertificate = "GetServerCertificate"

// GetServerCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetServerCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetServerCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetServerCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetServerCertificateRequest method.
//    req, resp := client.GetServerCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificate
func (c *IAM) GetServerCertificateRequest(input *GetServerCertificateInput) (req *request.Request, output *GetServerCertificateOutput) {
	op := &request.Operation{
		Name:       opGetServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServerCertificateInput{}
	}

	output = &GetServerCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServerCertificate API operation for AWS Identity and Access Management.
//
// Retrieves information about the specified server certificate stored in IAM.
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetServerCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificate
func (c *IAM) GetServerCertificate(input *GetServerCertificateInput) (*GetServerCertificateOutput, error) {
	req, out := c.GetServerCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opGetUser = "GetUser"

// GetUserRequest generates a "aws/request.Request" representing the
// client's request for the GetUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetUserRequest method.
//    req, resp := client.GetUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser
func (c *IAM) GetUserRequest(input *GetUserInput) (req *request.Request, output *GetUserOutput) {
	op := &request.Operation{
		Name:       opGetUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserInput{}
	}

	output = &GetUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUser API operation for AWS Identity and Access Management.
//
// Retrieves information about the specified IAM user, including the user's
// creation date, path, unique ID, and ARN.
//
// If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID used to sign the request to this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser
func (c *IAM) GetUser(input *GetUserInput) (*GetUserOutput, error) {
	req, out := c.GetUserRequest(input)
	err := req.Send()
	return out, err
}

const opGetUserPolicy = "GetUserPolicy"

// GetUserPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetUserPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetUserPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetUserPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetUserPolicyRequest method.
//    req, resp := client.GetUserPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicy
func (c *IAM) GetUserPolicyRequest(input *GetUserPolicyInput) (req *request.Request, output *GetUserPolicyOutput) {
	op := &request.Operation{
		Name:       opGetUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserPolicyInput{}
	}

	output = &GetUserPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUserPolicy API operation for AWS Identity and Access Management.
//
// Retrieves the specified inline policy document that is embedded in the specified
// IAM user.
//
// Policies returned by this API are URL-encoded compliant with RFC 3986 (https://tools.ietf.org/html/rfc3986).
// You can use a URL decoding method to convert the policy back to plain JSON
// text. For example, if you use Java, you can use the decode method of the
// java.net.URLDecoder utility class in the Java SDK. Other languages and SDKs
// provide similar functionality.
//
// An IAM user can also have managed policies attached to it. To retrieve a
// managed policy document that is attached to a user, use GetPolicy to determine
// the policy's default version, then use GetPolicyVersion to retrieve the policy
// document.
//
// For more information about policies, see Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation GetUserPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicy
func (c *IAM) GetUserPolicy(input *GetUserPolicyInput) (*GetUserPolicyOutput, error) {
	req, out := c.GetUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opListAccessKeys = "ListAccessKeys"

// ListAccessKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessKeys operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAccessKeys for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAccessKeys method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAccessKeysRequest method.
//    req, resp := client.ListAccessKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys
func (c *IAM) ListAccessKeysRequest(input *ListAccessKeysInput) (req *request.Request, output *ListAccessKeysOutput) {
	op := &request.Operation{
		Name:       opListAccessKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAccessKeysInput{}
	}

	output = &ListAccessKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccessKeys API operation for AWS Identity and Access Management.
//
// Returns information about the access key IDs associated with the specified
// IAM user. If there are none, the action returns an empty list.
//
// Although each user is limited to a small number of keys, you can still paginate
// the results using the MaxItems and Marker parameters.
//
// If the UserName field is not specified, the UserName is determined implicitly
// based on the AWS access key ID used to sign the request. Because this action
// works for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
// To ensure the security of your AWS account, the secret access key is accessible
// only during key and user creation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListAccessKeys for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys
func (c *IAM) ListAccessKeys(input *ListAccessKeysInput) (*ListAccessKeysOutput, error) {
	req, out := c.ListAccessKeysRequest(input)
	err := req.Send()
	return out, err
}

// ListAccessKeysPages iterates over the pages of a ListAccessKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccessKeys operation.
//    pageNum := 0
//    err := client.ListAccessKeysPages(params,
//        func(page *ListAccessKeysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListAccessKeysPages(input *ListAccessKeysInput, fn func(p *ListAccessKeysOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAccessKeysRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAccessKeysOutput), lastPage)
	})
}

const opListAccountAliases = "ListAccountAliases"

// ListAccountAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountAliases operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAccountAliases for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAccountAliases method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAccountAliasesRequest method.
//    req, resp := client.ListAccountAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases
func (c *IAM) ListAccountAliasesRequest(input *ListAccountAliasesInput) (req *request.Request, output *ListAccountAliasesOutput) {
	op := &request.Operation{
		Name:       opListAccountAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAccountAliasesInput{}
	}

	output = &ListAccountAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountAliases API operation for AWS Identity and Access Management.
//
// Lists the account alias associated with the AWS account (Note: you can have
// only one). For information about using an AWS account alias, see Using an
// Alias for Your AWS Account ID (http://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListAccountAliases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases
func (c *IAM) ListAccountAliases(input *ListAccountAliasesInput) (*ListAccountAliasesOutput, error) {
	req, out := c.ListAccountAliasesRequest(input)
	err := req.Send()
	return out, err
}

// ListAccountAliasesPages iterates over the pages of a ListAccountAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAccountAliases operation.
//    pageNum := 0
//    err := client.ListAccountAliasesPages(params,
//        func(page *ListAccountAliasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListAccountAliasesPages(input *ListAccountAliasesInput, fn func(p *ListAccountAliasesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAccountAliasesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAccountAliasesOutput), lastPage)
	})
}

const opListAttachedGroupPolicies = "ListAttachedGroupPolicies"

// ListAttachedGroupPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttachedGroupPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAttachedGroupPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAttachedGroupPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAttachedGroupPoliciesRequest method.
//    req, resp := client.ListAttachedGroupPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies
func (c *IAM) ListAttachedGroupPoliciesRequest(input *ListAttachedGroupPoliciesInput) (req *request.Request, output *ListAttachedGroupPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAttachedGroupPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAttachedGroupPoliciesInput{}
	}

	output = &ListAttachedGroupPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttachedGroupPolicies API operation for AWS Identity and Access Management.
//
// Lists all managed policies that are attached to the specified IAM group.
//
// An IAM group can also have inline policies embedded with it. To list the
// inline policies for a group, use the ListGroupPolicies API. For information
// about policies, see Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. You
// can use the PathPrefix parameter to limit the list of policies to only those
// matching the specified path prefix. If there are no policies attached to
// the specified group (or none that match the specified path prefix), the action
// returns an empty list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListAttachedGroupPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies
func (c *IAM) ListAttachedGroupPolicies(input *ListAttachedGroupPoliciesInput) (*ListAttachedGroupPoliciesOutput, error) {
	req, out := c.ListAttachedGroupPoliciesRequest(input)
	err := req.Send()
	return out, err
}

// ListAttachedGroupPoliciesPages iterates over the pages of a ListAttachedGroupPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttachedGroupPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAttachedGroupPolicies operation.
//    pageNum := 0
//    err := client.ListAttachedGroupPoliciesPages(params,
//        func(page *ListAttachedGroupPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListAttachedGroupPoliciesPages(input *ListAttachedGroupPoliciesInput, fn func(p *ListAttachedGroupPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAttachedGroupPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAttachedGroupPoliciesOutput), lastPage)
	})
}

const opListAttachedRolePolicies = "ListAttachedRolePolicies"

// ListAttachedRolePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttachedRolePolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAttachedRolePolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAttachedRolePolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAttachedRolePoliciesRequest method.
//    req, resp := client.ListAttachedRolePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies
func (c *IAM) ListAttachedRolePoliciesRequest(input *ListAttachedRolePoliciesInput) (req *request.Request, output *ListAttachedRolePoliciesOutput) {
	op := &request.Operation{
		Name:       opListAttachedRolePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAttachedRolePoliciesInput{}
	}

	output = &ListAttachedRolePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttachedRolePolicies API operation for AWS Identity and Access Management.
//
// Lists all managed policies that are attached to the specified IAM role.
//
// An IAM role can also have inline policies embedded with it. To list the inline
// policies for a role, use the ListRolePolicies API. For information about
// policies, see Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. You
// can use the PathPrefix parameter to limit the list of policies to only those
// matching the specified path prefix. If there are no policies attached to
// the specified role (or none that match the specified path prefix), the action
// returns an empty list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListAttachedRolePolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies
func (c *IAM) ListAttachedRolePolicies(input *ListAttachedRolePoliciesInput) (*ListAttachedRolePoliciesOutput, error) {
	req, out := c.ListAttachedRolePoliciesRequest(input)
	err := req.Send()
	return out, err
}

// ListAttachedRolePoliciesPages iterates over the pages of a ListAttachedRolePolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttachedRolePolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAttachedRolePolicies operation.
//    pageNum := 0
//    err := client.ListAttachedRolePoliciesPages(params,
//        func(page *ListAttachedRolePoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListAttachedRolePoliciesPages(input *ListAttachedRolePoliciesInput, fn func(p *ListAttachedRolePoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAttachedRolePoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAttachedRolePoliciesOutput), lastPage)
	})
}

const opListAttachedUserPolicies = "ListAttachedUserPolicies"

// ListAttachedUserPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAttachedUserPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAttachedUserPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAttachedUserPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAttachedUserPoliciesRequest method.
//    req, resp := client.ListAttachedUserPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies
func (c *IAM) ListAttachedUserPoliciesRequest(input *ListAttachedUserPoliciesInput) (req *request.Request, output *ListAttachedUserPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAttachedUserPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAttachedUserPoliciesInput{}
	}

	output = &ListAttachedUserPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttachedUserPolicies API operation for AWS Identity and Access Management.
//
// Lists all managed policies that are attached to the specified IAM user.
//
// An IAM user can also have inline policies embedded with it. To list the inline
// policies for a user, use the ListUserPolicies API. For information about
// policies, see Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. You
// can use the PathPrefix parameter to limit the list of policies to only those
// matching the specified path prefix. If there are no policies attached to
// the specified group (or none that match the specified path prefix), the action
// returns an empty list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListAttachedUserPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies
func (c *IAM) ListAttachedUserPolicies(input *ListAttachedUserPoliciesInput) (*ListAttachedUserPoliciesOutput, error) {
	req, out := c.ListAttachedUserPoliciesRequest(input)
	err := req.Send()
	return out, err
}

// ListAttachedUserPoliciesPages iterates over the pages of a ListAttachedUserPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttachedUserPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAttachedUserPolicies operation.
//    pageNum := 0
//    err := client.ListAttachedUserPoliciesPages(params,
//        func(page *ListAttachedUserPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListAttachedUserPoliciesPages(input *ListAttachedUserPoliciesInput, fn func(p *ListAttachedUserPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAttachedUserPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAttachedUserPoliciesOutput), lastPage)
	})
}

const opListEntitiesForPolicy = "ListEntitiesForPolicy"

// ListEntitiesForPolicyRequest generates a "aws/request.Request" representing the
// client's request for the ListEntitiesForPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListEntitiesForPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListEntitiesForPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListEntitiesForPolicyRequest method.
//    req, resp := client.ListEntitiesForPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy
func (c *IAM) ListEntitiesForPolicyRequest(input *ListEntitiesForPolicyInput) (req *request.Request, output *ListEntitiesForPolicyOutput) {
	op := &request.Operation{
		Name:       opListEntitiesForPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListEntitiesForPolicyInput{}
	}

	output = &ListEntitiesForPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntitiesForPolicy API operation for AWS Identity and Access Management.
//
// Lists all IAM users, groups, and roles that the specified managed policy
// is attached to.
//
// You can use the optional EntityFilter parameter to limit the results to a
// particular type of entity (users, groups, or roles). For example, to list
// only the roles that are attached to the specified policy, set EntityFilter
// to Role.
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListEntitiesForPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy
func (c *IAM) ListEntitiesForPolicy(input *ListEntitiesForPolicyInput) (*ListEntitiesForPolicyOutput, error) {
	req, out := c.ListEntitiesForPolicyRequest(input)
	err := req.Send()
	return out, err
}

// ListEntitiesForPolicyPages iterates over the pages of a ListEntitiesForPolicy operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntitiesForPolicy method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEntitiesForPolicy operation.
//    pageNum := 0
//    err := client.ListEntitiesForPolicyPages(params,
//        func(page *ListEntitiesForPolicyOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListEntitiesForPolicyPages(input *ListEntitiesForPolicyInput, fn func(p *ListEntitiesForPolicyOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListEntitiesForPolicyRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListEntitiesForPolicyOutput), lastPage)
	})
}

const opListGroupPolicies = "ListGroupPolicies"

// ListGroupPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListGroupPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListGroupPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListGroupPoliciesRequest method.
//    req, resp := client.ListGroupPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies
func (c *IAM) ListGroupPoliciesRequest(input *ListGroupPoliciesInput) (req *request.Request, output *ListGroupPoliciesOutput) {
	op := &request.Operation{
		Name:       opListGroupPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListGroupPoliciesInput{}
	}

	output = &ListGroupPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupPolicies API operation for AWS Identity and Access Management.
//
// Lists the names of the inline policies that are embedded in the specified
// IAM group.
//
// An IAM group can also have managed policies attached to it. To list the managed
// policies that are attached to a group, use ListAttachedGroupPolicies. For
// more information about policies, see Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. If
// there are no inline policies embedded with the specified group, the action
// returns an empty list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListGroupPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies
func (c *IAM) ListGroupPolicies(input *ListGroupPoliciesInput) (*ListGroupPoliciesOutput, error) {
	req, out := c.ListGroupPoliciesRequest(input)
	err := req.Send()
	return out, err
}

// ListGroupPoliciesPages iterates over the pages of a ListGroupPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroupPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroupPolicies operation.
//    pageNum := 0
//    err := client.ListGroupPoliciesPages(params,
//        func(page *ListGroupPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListGroupPoliciesPages(input *ListGroupPoliciesInput, fn func(p *ListGroupPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGroupPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGroupPoliciesOutput), lastPage)
	})
}

const opListGroups = "ListGroups"

// ListGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListGroupsRequest method.
//    req, resp := client.ListGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups
func (c *IAM) ListGroupsRequest(input *ListGroupsInput) (req *request.Request, output *ListGroupsOutput) {
	op := &request.Operation{
		Name:       opListGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListGroupsInput{}
	}

	output = &ListGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroups API operation for AWS Identity and Access Management.
//
// Lists the IAM groups that have the specified path prefix.
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups
func (c *IAM) ListGroups(input *ListGroupsInput) (*ListGroupsOutput, error) {
	req, out := c.ListGroupsRequest(input)
	err := req.Send()
	return out, err
}

// ListGroupsPages iterates over the pages of a ListGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroups operation.
//    pageNum := 0
//    err := client.ListGroupsPages(params,
//        func(page *ListGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListGroupsPages(input *ListGroupsInput, fn func(p *ListGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGroupsOutput), lastPage)
	})
}

const opListGroupsForUser = "ListGroupsForUser"

// ListGroupsForUserRequest generates a "aws/request.Request" representing the
// client's request for the ListGroupsForUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListGroupsForUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListGroupsForUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListGroupsForUserRequest method.
//    req, resp := client.ListGroupsForUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser
func (c *IAM) ListGroupsForUserRequest(input *ListGroupsForUserInput) (req *request.Request, output *ListGroupsForUserOutput) {
	op := &request.Operation{
		Name:       opListGroupsForUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListGroupsForUserInput{}
	}

	output = &ListGroupsForUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGroupsForUser API operation for AWS Identity and Access Management.
//
// Lists the IAM groups that the specified IAM user belongs to.
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListGroupsForUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser
func (c *IAM) ListGroupsForUser(input *ListGroupsForUserInput) (*ListGroupsForUserOutput, error) {
	req, out := c.ListGroupsForUserRequest(input)
	err := req.Send()
	return out, err
}

// ListGroupsForUserPages iterates over the pages of a ListGroupsForUser operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGroupsForUser method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGroupsForUser operation.
//    pageNum := 0
//    err := client.ListGroupsForUserPages(params,
//        func(page *ListGroupsForUserOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListGroupsForUserPages(input *ListGroupsForUserInput, fn func(p *ListGroupsForUserOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGroupsForUserRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGroupsForUserOutput), lastPage)
	})
}

const opListInstanceProfiles = "ListInstanceProfiles"

// ListInstanceProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceProfiles operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListInstanceProfiles for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListInstanceProfiles method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListInstanceProfilesRequest method.
//    req, resp := client.ListInstanceProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles
func (c *IAM) ListInstanceProfilesRequest(input *ListInstanceProfilesInput) (req *request.Request, output *ListInstanceProfilesOutput) {
	op := &request.Operation{
		Name:       opListInstanceProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListInstanceProfilesInput{}
	}

	output = &ListInstanceProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceProfiles API operation for AWS Identity and Access Management.
//
// Lists the instance profiles that have the specified path prefix. If there
// are none, the action returns an empty list. For more information about instance
// profiles, go to About Instance Profiles (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListInstanceProfiles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles
func (c *IAM) ListInstanceProfiles(input *ListInstanceProfilesInput) (*ListInstanceProfilesOutput, error) {
	req, out := c.ListInstanceProfilesRequest(input)
	err := req.Send()
	return out, err
}

// ListInstanceProfilesPages iterates over the pages of a ListInstanceProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstanceProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstanceProfiles operation.
//    pageNum := 0
//    err := client.ListInstanceProfilesPages(params,
//        func(page *ListInstanceProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListInstanceProfilesPages(input *ListInstanceProfilesInput, fn func(p *ListInstanceProfilesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListInstanceProfilesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListInstanceProfilesOutput), lastPage)
	})
}

const opListInstanceProfilesForRole = "ListInstanceProfilesForRole"

// ListInstanceProfilesForRoleRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceProfilesForRole operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListInstanceProfilesForRole for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListInstanceProfilesForRole method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListInstanceProfilesForRoleRequest method.
//    req, resp := client.ListInstanceProfilesForRoleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole
func (c *IAM) ListInstanceProfilesForRoleRequest(input *ListInstanceProfilesForRoleInput) (req *request.Request, output *ListInstanceProfilesForRoleOutput) {
	op := &request.Operation{
		Name:       opListInstanceProfilesForRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListInstanceProfilesForRoleInput{}
	}

	output = &ListInstanceProfilesForRoleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceProfilesForRole API operation for AWS Identity and Access Management.
//
// Lists the instance profiles that have the specified associated IAM role.
// If there are none, the action returns an empty list. For more information
// about instance profiles, go to About Instance Profiles (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListInstanceProfilesForRole for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole
func (c *IAM) ListInstanceProfilesForRole(input *ListInstanceProfilesForRoleInput) (*ListInstanceProfilesForRoleOutput, error) {
	req, out := c.ListInstanceProfilesForRoleRequest(input)
	err := req.Send()
	return out, err
}

// ListInstanceProfilesForRolePages iterates over the pages of a ListInstanceProfilesForRole operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstanceProfilesForRole method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstanceProfilesForRole operation.
//    pageNum := 0
//    err := client.ListInstanceProfilesForRolePages(params,
//        func(page *ListInstanceProfilesForRoleOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListInstanceProfilesForRolePages(input *ListInstanceProfilesForRoleInput, fn func(p *ListInstanceProfilesForRoleOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListInstanceProfilesForRoleRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListInstanceProfilesForRoleOutput), lastPage)
	})
}

const opListMFADevices = "ListMFADevices"

// ListMFADevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListMFADevices operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListMFADevices for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListMFADevices method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListMFADevicesRequest method.
//    req, resp := client.ListMFADevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices
func (c *IAM) ListMFADevicesRequest(input *ListMFADevicesInput) (req *request.Request, output *ListMFADevicesOutput) {
	op := &request.Operation{
		Name:       opListMFADevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListMFADevicesInput{}
	}

	output = &ListMFADevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMFADevices API operation for AWS Identity and Access Management.
//
// Lists the MFA devices for an IAM user. If the request includes a IAM user
// name, then this action lists all the MFA devices associated with the specified
// user. If you do not specify a user name, IAM determines the user name implicitly
// based on the AWS access key ID signing the request for this API.
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListMFADevices for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices
func (c *IAM) ListMFADevices(input *ListMFADevicesInput) (*ListMFADevicesOutput, error) {
	req, out := c.ListMFADevicesRequest(input)
	err := req.Send()
	return out, err
}

// ListMFADevicesPages iterates over the pages of a ListMFADevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMFADevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListMFADevices operation.
//    pageNum := 0
//    err := client.ListMFADevicesPages(params,
//        func(page *ListMFADevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListMFADevicesPages(input *ListMFADevicesInput, fn func(p *ListMFADevicesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListMFADevicesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListMFADevicesOutput), lastPage)
	})
}

const opListOpenIDConnectProviders = "ListOpenIDConnectProviders"

// ListOpenIDConnectProvidersRequest generates a "aws/request.Request" representing the
// client's request for the ListOpenIDConnectProviders operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListOpenIDConnectProviders for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListOpenIDConnectProviders method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListOpenIDConnectProvidersRequest method.
//    req, resp := client.ListOpenIDConnectProvidersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders
func (c *IAM) ListOpenIDConnectProvidersRequest(input *ListOpenIDConnectProvidersInput) (req *request.Request, output *ListOpenIDConnectProvidersOutput) {
	op := &request.Operation{
		Name:       opListOpenIDConnectProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListOpenIDConnectProvidersInput{}
	}

	output = &ListOpenIDConnectProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOpenIDConnectProviders API operation for AWS Identity and Access Management.
//
// Lists information about the IAM OpenID Connect (OIDC) provider resource objects
// defined in the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListOpenIDConnectProviders for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders
func (c *IAM) ListOpenIDConnectProviders(input *ListOpenIDConnectProvidersInput) (*ListOpenIDConnectProvidersOutput, error) {
	req, out := c.ListOpenIDConnectProvidersRequest(input)
	err := req.Send()
	return out, err
}

const opListPolicies = "ListPolicies"

// ListPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPoliciesRequest method.
//    req, resp := client.ListPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies
func (c *IAM) ListPoliciesRequest(input *ListPoliciesInput) (req *request.Request, output *ListPoliciesOutput) {
	op := &request.Operation{
		Name:       opListPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPoliciesInput{}
	}

	output = &ListPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicies API operation for AWS Identity and Access Management.
//
// Lists all the managed policies that are available in your AWS account, including
// your own customer-defined managed policies and all AWS managed policies.
//
// You can filter the list of policies that is returned using the optional OnlyAttached,
// Scope, and PathPrefix parameters. For example, to list only the customer
// managed policies in your AWS account, set Scope to Local. To list only AWS
// managed policies, set Scope to AWS.
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// For more information about managed policies, see Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies
func (c *IAM) ListPolicies(input *ListPoliciesInput) (*ListPoliciesOutput, error) {
	req, out := c.ListPoliciesRequest(input)
	err := req.Send()
	return out, err
}

// ListPoliciesPages iterates over the pages of a ListPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPolicies operation.
//    pageNum := 0
//    err := client.ListPoliciesPages(params,
//        func(page *ListPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListPoliciesPages(input *ListPoliciesInput, fn func(p *ListPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPoliciesOutput), lastPage)
	})
}

const opListPolicyVersions = "ListPolicyVersions"

// ListPolicyVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListPolicyVersions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListPolicyVersions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListPolicyVersions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListPolicyVersionsRequest method.
//    req, resp := client.ListPolicyVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions
func (c *IAM) ListPolicyVersionsRequest(input *ListPolicyVersionsInput) (req *request.Request, output *ListPolicyVersionsOutput) {
	op := &request.Operation{
		Name:       opListPolicyVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListPolicyVersionsInput{}
	}

	output = &ListPolicyVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPolicyVersions API operation for AWS Identity and Access Management.
//
// Lists information about the versions of the specified managed policy, including
// the version that is currently set as the policy's default version.
//
// For more information about managed policies, see Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListPolicyVersions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions
func (c *IAM) ListPolicyVersions(input *ListPolicyVersionsInput) (*ListPolicyVersionsOutput, error) {
	req, out := c.ListPolicyVersionsRequest(input)
	err := req.Send()
	return out, err
}

// ListPolicyVersionsPages iterates over the pages of a ListPolicyVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPolicyVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListPolicyVersions operation.
//    pageNum := 0
//    err := client.ListPolicyVersionsPages(params,
//        func(page *ListPolicyVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListPolicyVersionsPages(input *ListPolicyVersionsInput, fn func(p *ListPolicyVersionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPolicyVersionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPolicyVersionsOutput), lastPage)
	})
}

const opListRolePolicies = "ListRolePolicies"

// ListRolePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListRolePolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRolePolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRolePolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRolePoliciesRequest method.
//    req, resp := client.ListRolePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies
func (c *IAM) ListRolePoliciesRequest(input *ListRolePoliciesInput) (req *request.Request, output *ListRolePoliciesOutput) {
	op := &request.Operation{
		Name:       opListRolePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListRolePoliciesInput{}
	}

	output = &ListRolePoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRolePolicies API operation for AWS Identity and Access Management.
//
// Lists the names of the inline policies that are embedded in the specified
// IAM role.
//
// An IAM role can also have managed policies attached to it. To list the managed
// policies that are attached to a role, use ListAttachedRolePolicies. For more
// information about policies, see Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. If
// there are no inline policies embedded with the specified role, the action
// returns an empty list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListRolePolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies
func (c *IAM) ListRolePolicies(input *ListRolePoliciesInput) (*ListRolePoliciesOutput, error) {
	req, out := c.ListRolePoliciesRequest(input)
	err := req.Send()
	return out, err
}

// ListRolePoliciesPages iterates over the pages of a ListRolePolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRolePolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRolePolicies operation.
//    pageNum := 0
//    err := client.ListRolePoliciesPages(params,
//        func(page *ListRolePoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListRolePoliciesPages(input *ListRolePoliciesInput, fn func(p *ListRolePoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListRolePoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListRolePoliciesOutput), lastPage)
	})
}

const opListRoles = "ListRoles"

// ListRolesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoles operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRoles for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRoles method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRolesRequest method.
//    req, resp := client.ListRolesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles
func (c *IAM) ListRolesRequest(input *ListRolesInput) (req *request.Request, output *ListRolesOutput) {
	op := &request.Operation{
		Name:       opListRoles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListRolesInput{}
	}

	output = &ListRolesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoles API operation for AWS Identity and Access Management.
//
// Lists the IAM roles that have the specified path prefix. If there are none,
// the action returns an empty list. For more information about roles, go to
// Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListRoles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles
func (c *IAM) ListRoles(input *ListRolesInput) (*ListRolesOutput, error) {
	req, out := c.ListRolesRequest(input)
	err := req.Send()
	return out, err
}

// ListRolesPages iterates over the pages of a ListRoles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRoles operation.
//    pageNum := 0
//    err := client.ListRolesPages(params,
//        func(page *ListRolesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListRolesPages(input *ListRolesInput, fn func(p *ListRolesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListRolesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListRolesOutput), lastPage)
	})
}

const opListSAMLProviders = "ListSAMLProviders"

// ListSAMLProvidersRequest generates a "aws/request.Request" representing the
// client's request for the ListSAMLProviders operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSAMLProviders for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSAMLProviders method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSAMLProvidersRequest method.
//    req, resp := client.ListSAMLProvidersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviders
func (c *IAM) ListSAMLProvidersRequest(input *ListSAMLProvidersInput) (req *request.Request, output *ListSAMLProvidersOutput) {
	op := &request.Operation{
		Name:       opListSAMLProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSAMLProvidersInput{}
	}

	output = &ListSAMLProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSAMLProviders API operation for AWS Identity and Access Management.
//
// Lists the SAML provider resource objects defined in IAM in the account.
//
// This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListSAMLProviders for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviders
func (c *IAM) ListSAMLProviders(input *ListSAMLProvidersInput) (*ListSAMLProvidersOutput, error) {
	req, out := c.ListSAMLProvidersRequest(input)
	err := req.Send()
	return out, err
}

const opListSSHPublicKeys = "ListSSHPublicKeys"

// ListSSHPublicKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListSSHPublicKeys operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSSHPublicKeys for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSSHPublicKeys method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSSHPublicKeysRequest method.
//    req, resp := client.ListSSHPublicKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys
func (c *IAM) ListSSHPublicKeysRequest(input *ListSSHPublicKeysInput) (req *request.Request, output *ListSSHPublicKeysOutput) {
	op := &request.Operation{
		Name:       opListSSHPublicKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListSSHPublicKeysInput{}
	}

	output = &ListSSHPublicKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSSHPublicKeys API operation for AWS Identity and Access Management.
//
// Returns information about the SSH public keys associated with the specified
// IAM user. If there are none, the action returns an empty list.
//
// The SSH public keys returned by this action are used only for authenticating
// the IAM user to an AWS CodeCommit repository. For more information about
// using SSH keys to authenticate to an AWS CodeCommit repository, see Set up
// AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
//
// Although each user is limited to a small number of keys, you can still paginate
// the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListSSHPublicKeys for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys
func (c *IAM) ListSSHPublicKeys(input *ListSSHPublicKeysInput) (*ListSSHPublicKeysOutput, error) {
	req, out := c.ListSSHPublicKeysRequest(input)
	err := req.Send()
	return out, err
}

// ListSSHPublicKeysPages iterates over the pages of a ListSSHPublicKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSSHPublicKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSSHPublicKeys operation.
//    pageNum := 0
//    err := client.ListSSHPublicKeysPages(params,
//        func(page *ListSSHPublicKeysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListSSHPublicKeysPages(input *ListSSHPublicKeysInput, fn func(p *ListSSHPublicKeysOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSSHPublicKeysRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSSHPublicKeysOutput), lastPage)
	})
}

const opListServerCertificates = "ListServerCertificates"

// ListServerCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListServerCertificates operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListServerCertificates for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListServerCertificates method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListServerCertificatesRequest method.
//    req, resp := client.ListServerCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates
func (c *IAM) ListServerCertificatesRequest(input *ListServerCertificatesInput) (req *request.Request, output *ListServerCertificatesOutput) {
	op := &request.Operation{
		Name:       opListServerCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListServerCertificatesInput{}
	}

	output = &ListServerCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServerCertificates API operation for AWS Identity and Access Management.
//
// Lists the server certificates stored in IAM that have the specified path
// prefix. If none exist, the action returns an empty list.
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListServerCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates
func (c *IAM) ListServerCertificates(input *ListServerCertificatesInput) (*ListServerCertificatesOutput, error) {
	req, out := c.ListServerCertificatesRequest(input)
	err := req.Send()
	return out, err
}

// ListServerCertificatesPages iterates over the pages of a ListServerCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServerCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServerCertificates operation.
//    pageNum := 0
//    err := client.ListServerCertificatesPages(params,
//        func(page *ListServerCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListServerCertificatesPages(input *ListServerCertificatesInput, fn func(p *ListServerCertificatesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListServerCertificatesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListServerCertificatesOutput), lastPage)
	})
}

const opListServiceSpecificCredentials = "ListServiceSpecificCredentials"

// ListServiceSpecificCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceSpecificCredentials operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListServiceSpecificCredentials for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListServiceSpecificCredentials method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListServiceSpecificCredentialsRequest method.
//    req, resp := client.ListServiceSpecificCredentialsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentials
func (c *IAM) ListServiceSpecificCredentialsRequest(input *ListServiceSpecificCredentialsInput) (req *request.Request, output *ListServiceSpecificCredentialsOutput) {
	op := &request.Operation{
		Name:       opListServiceSpecificCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListServiceSpecificCredentialsInput{}
	}

	output = &ListServiceSpecificCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceSpecificCredentials API operation for AWS Identity and Access Management.
//
// Returns information about the service-specific credentials associated with
// the specified IAM user. If there are none, the action returns an empty list.
// The service-specific credentials returned by this action are used only for
// authenticating the IAM user to a specific service. For more information about
// using service-specific credentials to authenticate to an AWS service, see
// Set Up service-specific credentials (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html)
// in the AWS CodeCommit User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListServiceSpecificCredentials for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceNotSupportedException "NotSupportedService"
//   The specified service does not support service-specific credentials.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentials
func (c *IAM) ListServiceSpecificCredentials(input *ListServiceSpecificCredentialsInput) (*ListServiceSpecificCredentialsOutput, error) {
	req, out := c.ListServiceSpecificCredentialsRequest(input)
	err := req.Send()
	return out, err
}

const opListSigningCertificates = "ListSigningCertificates"

// ListSigningCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the ListSigningCertificates operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListSigningCertificates for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListSigningCertificates method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListSigningCertificatesRequest method.
//    req, resp := client.ListSigningCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates
func (c *IAM) ListSigningCertificatesRequest(input *ListSigningCertificatesInput) (req *request.Request, output *ListSigningCertificatesOutput) {
	op := &request.Operation{
		Name:       opListSigningCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListSigningCertificatesInput{}
	}

	output = &ListSigningCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSigningCertificates API operation for AWS Identity and Access Management.
//
// Returns information about the signing certificates associated with the specified
// IAM user. If there are none, the action returns an empty list.
//
// Although each user is limited to a small number of signing certificates,
// you can still paginate the results using the MaxItems and Marker parameters.
//
// If the UserName field is not specified, the user name is determined implicitly
// based on the AWS access key ID used to sign the request for this API. Because
// this action works for access keys under the AWS account, you can use this
// action to manage root credentials even if the AWS account has no associated
// users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListSigningCertificates for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates
func (c *IAM) ListSigningCertificates(input *ListSigningCertificatesInput) (*ListSigningCertificatesOutput, error) {
	req, out := c.ListSigningCertificatesRequest(input)
	err := req.Send()
	return out, err
}

// ListSigningCertificatesPages iterates over the pages of a ListSigningCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSigningCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSigningCertificates operation.
//    pageNum := 0
//    err := client.ListSigningCertificatesPages(params,
//        func(page *ListSigningCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListSigningCertificatesPages(input *ListSigningCertificatesInput, fn func(p *ListSigningCertificatesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSigningCertificatesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSigningCertificatesOutput), lastPage)
	})
}

const opListUserPolicies = "ListUserPolicies"

// ListUserPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListUserPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListUserPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListUserPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListUserPoliciesRequest method.
//    req, resp := client.ListUserPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPolicies
func (c *IAM) ListUserPoliciesRequest(input *ListUserPoliciesInput) (req *request.Request, output *ListUserPoliciesOutput) {
	op := &request.Operation{
		Name:       opListUserPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListUserPoliciesInput{}
	}

	output = &ListUserPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserPolicies API operation for AWS Identity and Access Management.
//
// Lists the names of the inline policies embedded in the specified IAM user.
//
// An IAM user can also have managed policies attached to it. To list the managed
// policies that are attached to a user, use ListAttachedUserPolicies. For more
// information about policies, see Managed Policies and Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// You can paginate the results using the MaxItems and Marker parameters. If
// there are no inline policies embedded with the specified user, the action
// returns an empty list.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListUserPolicies for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPolicies
func (c *IAM) ListUserPolicies(input *ListUserPoliciesInput) (*ListUserPoliciesOutput, error) {
	req, out := c.ListUserPoliciesRequest(input)
	err := req.Send()
	return out, err
}

// ListUserPoliciesPages iterates over the pages of a ListUserPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUserPolicies operation.
//    pageNum := 0
//    err := client.ListUserPoliciesPages(params,
//        func(page *ListUserPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListUserPoliciesPages(input *ListUserPoliciesInput, fn func(p *ListUserPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListUserPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListUserPoliciesOutput), lastPage)
	})
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListUsers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListUsers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListUsersRequest method.
//    req, resp := client.ListUsersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers
func (c *IAM) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for AWS Identity and Access Management.
//
// Lists the IAM users that have the specified path prefix. If no path prefix
// is specified, the action returns all users in the AWS account. If there are
// none, the action returns an empty list.
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListUsers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers
func (c *IAM) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	err := req.Send()
	return out, err
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUsers operation.
//    pageNum := 0
//    err := client.ListUsersPages(params,
//        func(page *ListUsersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListUsersPages(input *ListUsersInput, fn func(p *ListUsersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListUsersRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListUsersOutput), lastPage)
	})
}

const opListVirtualMFADevices = "ListVirtualMFADevices"

// ListVirtualMFADevicesRequest generates a "aws/request.Request" representing the
// client's request for the ListVirtualMFADevices operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListVirtualMFADevices for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListVirtualMFADevices method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListVirtualMFADevicesRequest method.
//    req, resp := client.ListVirtualMFADevicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices
func (c *IAM) ListVirtualMFADevicesRequest(input *ListVirtualMFADevicesInput) (req *request.Request, output *ListVirtualMFADevicesOutput) {
	op := &request.Operation{
		Name:       opListVirtualMFADevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListVirtualMFADevicesInput{}
	}

	output = &ListVirtualMFADevicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVirtualMFADevices API operation for AWS Identity and Access Management.
//
// Lists the virtual MFA devices defined in the AWS account by assignment status.
// If you do not specify an assignment status, the action returns a list of
// all virtual MFA devices. Assignment status can be Assigned, Unassigned, or
// Any.
//
// You can paginate the results using the MaxItems and Marker parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ListVirtualMFADevices for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices
func (c *IAM) ListVirtualMFADevices(input *ListVirtualMFADevicesInput) (*ListVirtualMFADevicesOutput, error) {
	req, out := c.ListVirtualMFADevicesRequest(input)
	err := req.Send()
	return out, err
}

// ListVirtualMFADevicesPages iterates over the pages of a ListVirtualMFADevices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVirtualMFADevices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListVirtualMFADevices operation.
//    pageNum := 0
//    err := client.ListVirtualMFADevicesPages(params,
//        func(page *ListVirtualMFADevicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) ListVirtualMFADevicesPages(input *ListVirtualMFADevicesInput, fn func(p *ListVirtualMFADevicesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListVirtualMFADevicesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListVirtualMFADevicesOutput), lastPage)
	})
}

const opPutGroupPolicy = "PutGroupPolicy"

// PutGroupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutGroupPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutGroupPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutGroupPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutGroupPolicyRequest method.
//    req, resp := client.PutGroupPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutGroupPolicy
func (c *IAM) PutGroupPolicyRequest(input *PutGroupPolicyInput) (req *request.Request, output *PutGroupPolicyOutput) {
	op := &request.Operation{
		Name:       opPutGroupPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutGroupPolicyInput{}
	}

	output = &PutGroupPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutGroupPolicy API operation for AWS Identity and Access Management.
//
// Adds or updates an inline policy document that is embedded in the specified
// IAM group.
//
// A user can also have managed policies attached to it. To attach a managed
// policy to a group, use AttachGroupPolicy. To create a new managed policy,
// use CreatePolicy. For information about policies, see Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For information about limits on the number of inline policies that you can
// embed in a group, see Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Because policy documents can be large, you should use POST rather than GET
// when calling PutGroupPolicy. For general information about using the Query
// API with IAM, go to Making Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation PutGroupPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocument"
//   The request was rejected because the policy document was malformed. The error
//   message describes the specific error.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutGroupPolicy
func (c *IAM) PutGroupPolicy(input *PutGroupPolicyInput) (*PutGroupPolicyOutput, error) {
	req, out := c.PutGroupPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opPutRolePolicy = "PutRolePolicy"

// PutRolePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutRolePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutRolePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutRolePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutRolePolicyRequest method.
//    req, resp := client.PutRolePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePolicy
func (c *IAM) PutRolePolicyRequest(input *PutRolePolicyInput) (req *request.Request, output *PutRolePolicyOutput) {
	op := &request.Operation{
		Name:       opPutRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRolePolicyInput{}
	}

	output = &PutRolePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutRolePolicy API operation for AWS Identity and Access Management.
//
// Adds or updates an inline policy document that is embedded in the specified
// IAM role.
//
// When you embed an inline policy in a role, the inline policy is used as part
// of the role's access (permissions) policy. The role's trust policy is created
// at the same time as the role, using CreateRole. You can update a role's trust
// policy using UpdateAssumeRolePolicy. For more information about IAM roles,
// go to Using Roles to Delegate Permissions and Federate Identities (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
//
// A role can also have a managed policy attached to it. To attach a managed
// policy to a role, use AttachRolePolicy. To create a new managed policy, use
// CreatePolicy. For information about policies, see Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For information about limits on the number of inline policies that you can
// embed with a role, see Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Because policy documents can be large, you should use POST rather than GET
// when calling PutRolePolicy. For general information about using the Query
// API with IAM, go to Making Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation PutRolePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocument"
//   The request was rejected because the policy document was malformed. The error
//   message describes the specific error.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePolicy
func (c *IAM) PutRolePolicy(input *PutRolePolicyInput) (*PutRolePolicyOutput, error) {
	req, out := c.PutRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opPutUserPolicy = "PutUserPolicy"

// PutUserPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutUserPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutUserPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutUserPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutUserPolicyRequest method.
//    req, resp := client.PutUserPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPolicy
func (c *IAM) PutUserPolicyRequest(input *PutUserPolicyInput) (req *request.Request, output *PutUserPolicyOutput) {
	op := &request.Operation{
		Name:       opPutUserPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutUserPolicyInput{}
	}

	output = &PutUserPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutUserPolicy API operation for AWS Identity and Access Management.
//
// Adds or updates an inline policy document that is embedded in the specified
// IAM user.
//
// An IAM user can also have a managed policy attached to it. To attach a managed
// policy to a user, use AttachUserPolicy. To create a new managed policy, use
// CreatePolicy. For information about policies, see Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// For information about limits on the number of inline policies that you can
// embed in a user, see Limitations on IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html)
// in the IAM User Guide.
//
// Because policy documents can be large, you should use POST rather than GET
// when calling PutUserPolicy. For general information about using the Query
// API with IAM, go to Making Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation PutUserPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocument"
//   The request was rejected because the policy document was malformed. The error
//   message describes the specific error.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPolicy
func (c *IAM) PutUserPolicy(input *PutUserPolicyInput) (*PutUserPolicyOutput, error) {
	req, out := c.PutUserPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveClientIDFromOpenIDConnectProvider = "RemoveClientIDFromOpenIDConnectProvider"

// RemoveClientIDFromOpenIDConnectProviderRequest generates a "aws/request.Request" representing the
// client's request for the RemoveClientIDFromOpenIDConnectProvider operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveClientIDFromOpenIDConnectProvider for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveClientIDFromOpenIDConnectProvider method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveClientIDFromOpenIDConnectProviderRequest method.
//    req, resp := client.RemoveClientIDFromOpenIDConnectProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveClientIDFromOpenIDConnectProvider
func (c *IAM) RemoveClientIDFromOpenIDConnectProviderRequest(input *RemoveClientIDFromOpenIDConnectProviderInput) (req *request.Request, output *RemoveClientIDFromOpenIDConnectProviderOutput) {
	op := &request.Operation{
		Name:       opRemoveClientIDFromOpenIDConnectProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveClientIDFromOpenIDConnectProviderInput{}
	}

	output = &RemoveClientIDFromOpenIDConnectProviderOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveClientIDFromOpenIDConnectProvider API operation for AWS Identity and Access Management.
//
// Removes the specified client ID (also known as audience) from the list of
// client IDs registered for the specified IAM OpenID Connect (OIDC) provider
// resource object.
//
// This action is idempotent; it does not fail or return an error if you try
// to remove a client ID that does not exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation RemoveClientIDFromOpenIDConnectProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveClientIDFromOpenIDConnectProvider
func (c *IAM) RemoveClientIDFromOpenIDConnectProvider(input *RemoveClientIDFromOpenIDConnectProviderInput) (*RemoveClientIDFromOpenIDConnectProviderOutput, error) {
	req, out := c.RemoveClientIDFromOpenIDConnectProviderRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveRoleFromInstanceProfile = "RemoveRoleFromInstanceProfile"

// RemoveRoleFromInstanceProfileRequest generates a "aws/request.Request" representing the
// client's request for the RemoveRoleFromInstanceProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveRoleFromInstanceProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveRoleFromInstanceProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveRoleFromInstanceProfileRequest method.
//    req, resp := client.RemoveRoleFromInstanceProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveRoleFromInstanceProfile
func (c *IAM) RemoveRoleFromInstanceProfileRequest(input *RemoveRoleFromInstanceProfileInput) (req *request.Request, output *RemoveRoleFromInstanceProfileOutput) {
	op := &request.Operation{
		Name:       opRemoveRoleFromInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveRoleFromInstanceProfileInput{}
	}

	output = &RemoveRoleFromInstanceProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveRoleFromInstanceProfile API operation for AWS Identity and Access Management.
//
// Removes the specified IAM role from the specified EC2 instance profile.
//
// Make sure you do not have any Amazon EC2 instances running with the role
// you are about to remove from the instance profile. Removing a role from an
// instance profile that is associated with a running instance break any applications
// running on the instance.
//
// For more information about IAM roles, go to Working with Roles (http://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html).
// For more information about instance profiles, go to About Instance Profiles
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation RemoveRoleFromInstanceProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveRoleFromInstanceProfile
func (c *IAM) RemoveRoleFromInstanceProfile(input *RemoveRoleFromInstanceProfileInput) (*RemoveRoleFromInstanceProfileOutput, error) {
	req, out := c.RemoveRoleFromInstanceProfileRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveUserFromGroup = "RemoveUserFromGroup"

// RemoveUserFromGroupRequest generates a "aws/request.Request" representing the
// client's request for the RemoveUserFromGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveUserFromGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveUserFromGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveUserFromGroupRequest method.
//    req, resp := client.RemoveUserFromGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveUserFromGroup
func (c *IAM) RemoveUserFromGroupRequest(input *RemoveUserFromGroupInput) (req *request.Request, output *RemoveUserFromGroupOutput) {
	op := &request.Operation{
		Name:       opRemoveUserFromGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveUserFromGroupInput{}
	}

	output = &RemoveUserFromGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveUserFromGroup API operation for AWS Identity and Access Management.
//
// Removes the specified user from the specified group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation RemoveUserFromGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveUserFromGroup
func (c *IAM) RemoveUserFromGroup(input *RemoveUserFromGroupInput) (*RemoveUserFromGroupOutput, error) {
	req, out := c.RemoveUserFromGroupRequest(input)
	err := req.Send()
	return out, err
}

const opResetServiceSpecificCredential = "ResetServiceSpecificCredential"

// ResetServiceSpecificCredentialRequest generates a "aws/request.Request" representing the
// client's request for the ResetServiceSpecificCredential operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResetServiceSpecificCredential for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResetServiceSpecificCredential method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResetServiceSpecificCredentialRequest method.
//    req, resp := client.ResetServiceSpecificCredentialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResetServiceSpecificCredential
func (c *IAM) ResetServiceSpecificCredentialRequest(input *ResetServiceSpecificCredentialInput) (req *request.Request, output *ResetServiceSpecificCredentialOutput) {
	op := &request.Operation{
		Name:       opResetServiceSpecificCredential,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetServiceSpecificCredentialInput{}
	}

	output = &ResetServiceSpecificCredentialOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ResetServiceSpecificCredential API operation for AWS Identity and Access Management.
//
// Resets the password for a service-specific credential. The new password is
// AWS generated and cryptographically strong. It cannot be configured by the
// user. Resetting the password immediately invalidates the previous password
// associated with this user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ResetServiceSpecificCredential for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResetServiceSpecificCredential
func (c *IAM) ResetServiceSpecificCredential(input *ResetServiceSpecificCredentialInput) (*ResetServiceSpecificCredentialOutput, error) {
	req, out := c.ResetServiceSpecificCredentialRequest(input)
	err := req.Send()
	return out, err
}

const opResyncMFADevice = "ResyncMFADevice"

// ResyncMFADeviceRequest generates a "aws/request.Request" representing the
// client's request for the ResyncMFADevice operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResyncMFADevice for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResyncMFADevice method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResyncMFADeviceRequest method.
//    req, resp := client.ResyncMFADeviceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResyncMFADevice
func (c *IAM) ResyncMFADeviceRequest(input *ResyncMFADeviceInput) (req *request.Request, output *ResyncMFADeviceOutput) {
	op := &request.Operation{
		Name:       opResyncMFADevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResyncMFADeviceInput{}
	}

	output = &ResyncMFADeviceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResyncMFADevice API operation for AWS Identity and Access Management.
//
// Synchronizes the specified MFA device with its IAM resource object on the
// AWS servers.
//
// For more information about creating and working with virtual MFA devices,
// go to Using a Virtual MFA Device (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation ResyncMFADevice for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidAuthenticationCodeException "InvalidAuthenticationCode"
//   The request was rejected because the authentication code was not recognized.
//   The error message describes the specific error.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResyncMFADevice
func (c *IAM) ResyncMFADevice(input *ResyncMFADeviceInput) (*ResyncMFADeviceOutput, error) {
	req, out := c.ResyncMFADeviceRequest(input)
	err := req.Send()
	return out, err
}

const opSetDefaultPolicyVersion = "SetDefaultPolicyVersion"

// SetDefaultPolicyVersionRequest generates a "aws/request.Request" representing the
// client's request for the SetDefaultPolicyVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetDefaultPolicyVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetDefaultPolicyVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetDefaultPolicyVersionRequest method.
//    req, resp := client.SetDefaultPolicyVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetDefaultPolicyVersion
func (c *IAM) SetDefaultPolicyVersionRequest(input *SetDefaultPolicyVersionInput) (req *request.Request, output *SetDefaultPolicyVersionOutput) {
	op := &request.Operation{
		Name:       opSetDefaultPolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetDefaultPolicyVersionInput{}
	}

	output = &SetDefaultPolicyVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetDefaultPolicyVersion API operation for AWS Identity and Access Management.
//
// Sets the specified version of the specified policy as the policy's default
// (operative) version.
//
// This action affects all users, groups, and roles that the policy is attached
// to. To list the users, groups, and roles that the policy is attached to,
// use the ListEntitiesForPolicy API.
//
// For information about managed policies, see Managed Policies and Inline Policies
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation SetDefaultPolicyVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetDefaultPolicyVersion
func (c *IAM) SetDefaultPolicyVersion(input *SetDefaultPolicyVersionInput) (*SetDefaultPolicyVersionOutput, error) {
	req, out := c.SetDefaultPolicyVersionRequest(input)
	err := req.Send()
	return out, err
}

const opSimulateCustomPolicy = "SimulateCustomPolicy"

// SimulateCustomPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SimulateCustomPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SimulateCustomPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SimulateCustomPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SimulateCustomPolicyRequest method.
//    req, resp := client.SimulateCustomPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulateCustomPolicy
func (c *IAM) SimulateCustomPolicyRequest(input *SimulateCustomPolicyInput) (req *request.Request, output *SimulatePolicyResponse) {
	op := &request.Operation{
		Name:       opSimulateCustomPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &SimulateCustomPolicyInput{}
	}

	output = &SimulatePolicyResponse{}
	req = c.newRequest(op, input, output)
	return
}

// SimulateCustomPolicy API operation for AWS Identity and Access Management.
//
// Simulate how a set of IAM policies and optionally a resource-based policy
// works with a list of API actions and AWS resources to determine the policies'
// effective permissions. The policies are provided as strings.
//
// The simulation does not perform the API actions; it only checks the authorization
// to determine if the simulated policies allow or deny the actions.
//
// If you want to simulate existing policies attached to an IAM user, group,
// or role, use SimulatePrincipalPolicy instead.
//
// Context keys are variables maintained by AWS and its services that provide
// details about the context of an API query request. You can use the Condition
// element of an IAM policy to evaluate context keys. To get the list of context
// keys that the policies require for correct simulation, use GetContextKeysForCustomPolicy.
//
// If the output is long, you can use MaxItems and Marker parameters to paginate
// the results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation SimulateCustomPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodePolicyEvaluationException "PolicyEvaluation"
//   The request failed because a provided policy could not be successfully evaluated.
//   An additional detail message indicates the source of the failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulateCustomPolicy
func (c *IAM) SimulateCustomPolicy(input *SimulateCustomPolicyInput) (*SimulatePolicyResponse, error) {
	req, out := c.SimulateCustomPolicyRequest(input)
	err := req.Send()
	return out, err
}

// SimulateCustomPolicyPages iterates over the pages of a SimulateCustomPolicy operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SimulateCustomPolicy method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SimulateCustomPolicy operation.
//    pageNum := 0
//    err := client.SimulateCustomPolicyPages(params,
//        func(page *SimulatePolicyResponse, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) SimulateCustomPolicyPages(input *SimulateCustomPolicyInput, fn func(p *SimulatePolicyResponse, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.SimulateCustomPolicyRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*SimulatePolicyResponse), lastPage)
	})
}

const opSimulatePrincipalPolicy = "SimulatePrincipalPolicy"

// SimulatePrincipalPolicyRequest generates a "aws/request.Request" representing the
// client's request for the SimulatePrincipalPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SimulatePrincipalPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SimulatePrincipalPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SimulatePrincipalPolicyRequest method.
//    req, resp := client.SimulatePrincipalPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulatePrincipalPolicy
func (c *IAM) SimulatePrincipalPolicyRequest(input *SimulatePrincipalPolicyInput) (req *request.Request, output *SimulatePolicyResponse) {
	op := &request.Operation{
		Name:       opSimulatePrincipalPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &SimulatePrincipalPolicyInput{}
	}

	output = &SimulatePolicyResponse{}
	req = c.newRequest(op, input, output)
	return
}

// SimulatePrincipalPolicy API operation for AWS Identity and Access Management.
//
// Simulate how a set of IAM policies attached to an IAM entity works with a
// list of API actions and AWS resources to determine the policies' effective
// permissions. The entity can be an IAM user, group, or role. If you specify
// a user, then the simulation also includes all of the policies that are attached
// to groups that the user belongs to .
//
// You can optionally include a list of one or more additional policies specified
// as strings to include in the simulation. If you want to simulate only policies
// specified as strings, use SimulateCustomPolicy instead.
//
// You can also optionally include one resource-based policy to be evaluated
// with each of the resources included in the simulation.
//
// The simulation does not perform the API actions, it only checks the authorization
// to determine if the simulated policies allow or deny the actions.
//
// Note: This API discloses information about the permissions granted to other
// users. If you do not want users to see other user's permissions, then consider
// allowing them to use SimulateCustomPolicy instead.
//
// Context keys are variables maintained by AWS and its services that provide
// details about the context of an API query request. You can use the Condition
// element of an IAM policy to evaluate context keys. To get the list of context
// keys that the policies require for correct simulation, use GetContextKeysForPrincipalPolicy.
//
// If the output is long, you can use the MaxItems and Marker parameters to
// paginate the results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation SimulatePrincipalPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodePolicyEvaluationException "PolicyEvaluation"
//   The request failed because a provided policy could not be successfully evaluated.
//   An additional detail message indicates the source of the failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulatePrincipalPolicy
func (c *IAM) SimulatePrincipalPolicy(input *SimulatePrincipalPolicyInput) (*SimulatePolicyResponse, error) {
	req, out := c.SimulatePrincipalPolicyRequest(input)
	err := req.Send()
	return out, err
}

// SimulatePrincipalPolicyPages iterates over the pages of a SimulatePrincipalPolicy operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SimulatePrincipalPolicy method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a SimulatePrincipalPolicy operation.
//    pageNum := 0
//    err := client.SimulatePrincipalPolicyPages(params,
//        func(page *SimulatePolicyResponse, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IAM) SimulatePrincipalPolicyPages(input *SimulatePrincipalPolicyInput, fn func(p *SimulatePolicyResponse, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.SimulatePrincipalPolicyRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*SimulatePolicyResponse), lastPage)
	})
}

const opUpdateAccessKey = "UpdateAccessKey"

// UpdateAccessKeyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccessKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateAccessKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateAccessKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateAccessKeyRequest method.
//    req, resp := client.UpdateAccessKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccessKey
func (c *IAM) UpdateAccessKeyRequest(input *UpdateAccessKeyInput) (req *request.Request, output *UpdateAccessKeyOutput) {
	op := &request.Operation{
		Name:       opUpdateAccessKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccessKeyInput{}
	}

	output = &UpdateAccessKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAccessKey API operation for AWS Identity and Access Management.
//
// Changes the status of the specified access key from Active to Inactive, or
// vice versa. This action can be used to disable a user's key as part of a
// key rotation work flow.
//
// If the UserName field is not specified, the UserName is determined implicitly
// based on the AWS access key ID used to sign the request. Because this action
// works for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
// For information about rotating keys, see Managing Keys and Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateAccessKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccessKey
func (c *IAM) UpdateAccessKey(input *UpdateAccessKeyInput) (*UpdateAccessKeyOutput, error) {
	req, out := c.UpdateAccessKeyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAccountPasswordPolicy = "UpdateAccountPasswordPolicy"

// UpdateAccountPasswordPolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountPasswordPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateAccountPasswordPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateAccountPasswordPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateAccountPasswordPolicyRequest method.
//    req, resp := client.UpdateAccountPasswordPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccountPasswordPolicy
func (c *IAM) UpdateAccountPasswordPolicyRequest(input *UpdateAccountPasswordPolicyInput) (req *request.Request, output *UpdateAccountPasswordPolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountPasswordPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccountPasswordPolicyInput{}
	}

	output = &UpdateAccountPasswordPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAccountPasswordPolicy API operation for AWS Identity and Access Management.
//
// Updates the password policy settings for the AWS account.
//
// This action does not support partial updates. No parameters are required,
// but if you do not specify a parameter, that parameter's value reverts to
// its default value. See the Request Parameters section for each parameter's
// default value.
//
// For more information about using a password policy, see Managing an IAM Password
// Policy (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateAccountPasswordPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocument"
//   The request was rejected because the policy document was malformed. The error
//   message describes the specific error.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccountPasswordPolicy
func (c *IAM) UpdateAccountPasswordPolicy(input *UpdateAccountPasswordPolicyInput) (*UpdateAccountPasswordPolicyOutput, error) {
	req, out := c.UpdateAccountPasswordPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAssumeRolePolicy = "UpdateAssumeRolePolicy"

// UpdateAssumeRolePolicyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAssumeRolePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateAssumeRolePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateAssumeRolePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateAssumeRolePolicyRequest method.
//    req, resp := client.UpdateAssumeRolePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAssumeRolePolicy
func (c *IAM) UpdateAssumeRolePolicyRequest(input *UpdateAssumeRolePolicyInput) (req *request.Request, output *UpdateAssumeRolePolicyOutput) {
	op := &request.Operation{
		Name:       opUpdateAssumeRolePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAssumeRolePolicyInput{}
	}

	output = &UpdateAssumeRolePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAssumeRolePolicy API operation for AWS Identity and Access Management.
//
// Updates the policy that grants an IAM entity permission to assume a role.
// This is typically referred to as the "role trust policy". For more information
// about roles, go to Using Roles to Delegate Permissions and Federate Identities
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateAssumeRolePolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeMalformedPolicyDocumentException "MalformedPolicyDocument"
//   The request was rejected because the policy document was malformed. The error
//   message describes the specific error.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAssumeRolePolicy
func (c *IAM) UpdateAssumeRolePolicy(input *UpdateAssumeRolePolicyInput) (*UpdateAssumeRolePolicyOutput, error) {
	req, out := c.UpdateAssumeRolePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateGroup
func (c *IAM) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGroup API operation for AWS Identity and Access Management.
//
// Updates the name and/or the path of the specified IAM group.
//
// You should understand the implications of changing a group's path or name.
// For more information, see Renaming Users and Groups (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html)
// in the IAM User Guide.
//
// To change an IAM group name the requester must have appropriate permissions
// on both the source object and the target object. For example, to change "Managers"
// to "MGRs", the entity making the request must have permission on both "Managers"
// and "MGRs", or must have permission on all (*). For more information about
// permissions, see Permissions and Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateGroup
func (c *IAM) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateLoginProfile = "UpdateLoginProfile"

// UpdateLoginProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLoginProfile operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateLoginProfile for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateLoginProfile method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateLoginProfileRequest method.
//    req, resp := client.UpdateLoginProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateLoginProfile
func (c *IAM) UpdateLoginProfileRequest(input *UpdateLoginProfileInput) (req *request.Request, output *UpdateLoginProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateLoginProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLoginProfileInput{}
	}

	output = &UpdateLoginProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLoginProfile API operation for AWS Identity and Access Management.
//
// Changes the password for the specified IAM user.
//
// IAM users can change their own passwords by calling ChangePassword. For more
// information about modifying passwords, see Managing Passwords (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateLoginProfile for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeEntityTemporarilyUnmodifiableException "EntityTemporarilyUnmodifiable"
//   The request was rejected because it referenced an entity that is temporarily
//   unmodifiable, such as a user name that was deleted and then recreated. The
//   error indicates that the request is likely to succeed if you try again after
//   waiting several minutes. The error message describes the entity.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodePasswordPolicyViolationException "PasswordPolicyViolation"
//   The request was rejected because the provided password did not meet the requirements
//   imposed by the account password policy.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateLoginProfile
func (c *IAM) UpdateLoginProfile(input *UpdateLoginProfileInput) (*UpdateLoginProfileOutput, error) {
	req, out := c.UpdateLoginProfileRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateOpenIDConnectProviderThumbprint = "UpdateOpenIDConnectProviderThumbprint"

// UpdateOpenIDConnectProviderThumbprintRequest generates a "aws/request.Request" representing the
// client's request for the UpdateOpenIDConnectProviderThumbprint operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateOpenIDConnectProviderThumbprint for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateOpenIDConnectProviderThumbprint method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateOpenIDConnectProviderThumbprintRequest method.
//    req, resp := client.UpdateOpenIDConnectProviderThumbprintRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateOpenIDConnectProviderThumbprint
func (c *IAM) UpdateOpenIDConnectProviderThumbprintRequest(input *UpdateOpenIDConnectProviderThumbprintInput) (req *request.Request, output *UpdateOpenIDConnectProviderThumbprintOutput) {
	op := &request.Operation{
		Name:       opUpdateOpenIDConnectProviderThumbprint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateOpenIDConnectProviderThumbprintInput{}
	}

	output = &UpdateOpenIDConnectProviderThumbprintOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateOpenIDConnectProviderThumbprint API operation for AWS Identity and Access Management.
//
// Replaces the existing list of server certificate thumbprints associated with
// an OpenID Connect (OIDC) provider resource object with a new list of thumbprints.
//
// The list that you pass with this action completely replaces the existing
// list of thumbprints. (The lists are not merged.)
//
// Typically, you need to update a thumbprint only when the identity provider's
// certificate changes, which occurs rarely. However, if the provider's certificate
// does change, any attempt to assume an IAM role that specifies the OIDC provider
// as a principal fails until the certificate thumbprint is updated.
//
// Because trust for the OIDC provider is ultimately derived from the provider's
// certificate and is validated by the thumbprint, it is a best practice to
// limit access to the UpdateOpenIDConnectProviderThumbprint action to highly-privileged
// users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateOpenIDConnectProviderThumbprint for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateOpenIDConnectProviderThumbprint
func (c *IAM) UpdateOpenIDConnectProviderThumbprint(input *UpdateOpenIDConnectProviderThumbprintInput) (*UpdateOpenIDConnectProviderThumbprintOutput, error) {
	req, out := c.UpdateOpenIDConnectProviderThumbprintRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSAMLProvider = "UpdateSAMLProvider"

// UpdateSAMLProviderRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSAMLProvider operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateSAMLProvider for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateSAMLProvider method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateSAMLProviderRequest method.
//    req, resp := client.UpdateSAMLProviderRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSAMLProvider
func (c *IAM) UpdateSAMLProviderRequest(input *UpdateSAMLProviderInput) (req *request.Request, output *UpdateSAMLProviderOutput) {
	op := &request.Operation{
		Name:       opUpdateSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSAMLProviderInput{}
	}

	output = &UpdateSAMLProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSAMLProvider API operation for AWS Identity and Access Management.
//
// Updates the metadata document for an existing SAML provider resource object.
//
// This operation requires Signature Version 4 (http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateSAMLProvider for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidInputException "InvalidInput"
//   The request was rejected because an invalid or out-of-range value was supplied
//   for an input parameter.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSAMLProvider
func (c *IAM) UpdateSAMLProvider(input *UpdateSAMLProviderInput) (*UpdateSAMLProviderOutput, error) {
	req, out := c.UpdateSAMLProviderRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSSHPublicKey = "UpdateSSHPublicKey"

// UpdateSSHPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSSHPublicKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateSSHPublicKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateSSHPublicKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateSSHPublicKeyRequest method.
//    req, resp := client.UpdateSSHPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSSHPublicKey
func (c *IAM) UpdateSSHPublicKeyRequest(input *UpdateSSHPublicKeyInput) (req *request.Request, output *UpdateSSHPublicKeyOutput) {
	op := &request.Operation{
		Name:       opUpdateSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSSHPublicKeyInput{}
	}

	output = &UpdateSSHPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSSHPublicKey API operation for AWS Identity and Access Management.
//
// Sets the status of an IAM user's SSH public key to active or inactive. SSH
// public keys that are inactive cannot be used for authentication. This action
// can be used to disable a user's SSH public key as part of a key rotation
// work flow.
//
// The SSH public key affected by this action is used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateSSHPublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSSHPublicKey
func (c *IAM) UpdateSSHPublicKey(input *UpdateSSHPublicKeyInput) (*UpdateSSHPublicKeyOutput, error) {
	req, out := c.UpdateSSHPublicKeyRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateServerCertificate = "UpdateServerCertificate"

// UpdateServerCertificateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServerCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateServerCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateServerCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateServerCertificateRequest method.
//    req, resp := client.UpdateServerCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServerCertificate
func (c *IAM) UpdateServerCertificateRequest(input *UpdateServerCertificateInput) (req *request.Request, output *UpdateServerCertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerCertificateInput{}
	}

	output = &UpdateServerCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateServerCertificate API operation for AWS Identity and Access Management.
//
// Updates the name and/or the path of the specified server certificate stored
// in IAM.
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
//
// You should understand the implications of changing a server certificate's
// path or name. For more information, see Renaming a Server Certificate (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts)
// in the IAM User Guide.
//
// To change a server certificate name the requester must have appropriate permissions
// on both the source object and the target object. For example, to change the
// name from "ProductionCert" to "ProdCert", the entity making the request must
// have permission on "ProductionCert" and "ProdCert", or must have permission
// on all (*). For more information about permissions, see Access Management
// (http://docs.aws.amazon.com/IAM/latest/UserGuide/access.html) in the IAM
// User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateServerCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServerCertificate
func (c *IAM) UpdateServerCertificate(input *UpdateServerCertificateInput) (*UpdateServerCertificateOutput, error) {
	req, out := c.UpdateServerCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateServiceSpecificCredential = "UpdateServiceSpecificCredential"

// UpdateServiceSpecificCredentialRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceSpecificCredential operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateServiceSpecificCredential for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateServiceSpecificCredential method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateServiceSpecificCredentialRequest method.
//    req, resp := client.UpdateServiceSpecificCredentialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServiceSpecificCredential
func (c *IAM) UpdateServiceSpecificCredentialRequest(input *UpdateServiceSpecificCredentialInput) (req *request.Request, output *UpdateServiceSpecificCredentialOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceSpecificCredential,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceSpecificCredentialInput{}
	}

	output = &UpdateServiceSpecificCredentialOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateServiceSpecificCredential API operation for AWS Identity and Access Management.
//
// Sets the status of a service-specific credential to Active or Inactive. Service-specific
// credentials that are inactive cannot be used for authentication to the service.
// This action can be used to disable a user’s service-specific credential as
// part of a credential rotation work flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateServiceSpecificCredential for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServiceSpecificCredential
func (c *IAM) UpdateServiceSpecificCredential(input *UpdateServiceSpecificCredentialInput) (*UpdateServiceSpecificCredentialOutput, error) {
	req, out := c.UpdateServiceSpecificCredentialRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateSigningCertificate = "UpdateSigningCertificate"

// UpdateSigningCertificateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSigningCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateSigningCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateSigningCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateSigningCertificateRequest method.
//    req, resp := client.UpdateSigningCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSigningCertificate
func (c *IAM) UpdateSigningCertificateRequest(input *UpdateSigningCertificateInput) (req *request.Request, output *UpdateSigningCertificateOutput) {
	op := &request.Operation{
		Name:       opUpdateSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSigningCertificateInput{}
	}

	output = &UpdateSigningCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSigningCertificate API operation for AWS Identity and Access Management.
//
// Changes the status of the specified user signing certificate from active
// to disabled, or vice versa. This action can be used to disable an IAM user's
// signing certificate as part of a certificate rotation work flow.
//
// If the UserName field is not specified, the UserName is determined implicitly
// based on the AWS access key ID used to sign the request. Because this action
// works for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateSigningCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSigningCertificate
func (c *IAM) UpdateSigningCertificate(input *UpdateSigningCertificateInput) (*UpdateSigningCertificateOutput, error) {
	req, out := c.UpdateSigningCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateUser = "UpdateUser"

// UpdateUserRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUser operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateUser for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateUser method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateUserRequest method.
//    req, resp := client.UpdateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateUser
func (c *IAM) UpdateUserRequest(input *UpdateUserInput) (req *request.Request, output *UpdateUserOutput) {
	op := &request.Operation{
		Name:       opUpdateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserInput{}
	}

	output = &UpdateUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUser API operation for AWS Identity and Access Management.
//
// Updates the name and/or the path of the specified IAM user.
//
// You should understand the implications of changing an IAM user's path or
// name. For more information, see Renaming an IAM User (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming)
// and Renaming an IAM Group (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html)
// in the IAM User Guide.
//
// To change a user name the requester must have appropriate permissions on
// both the source object and the target object. For example, to change Bob
// to Robert, the entity making the request must have permission on Bob and
// Robert, or must have permission on all (*). For more information about permissions,
// see Permissions and Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UpdateUser for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeEntityTemporarilyUnmodifiableException "EntityTemporarilyUnmodifiable"
//   The request was rejected because it referenced an entity that is temporarily
//   unmodifiable, such as a user name that was deleted and then recreated. The
//   error indicates that the request is likely to succeed if you try again after
//   waiting several minutes. The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateUser
func (c *IAM) UpdateUser(input *UpdateUserInput) (*UpdateUserOutput, error) {
	req, out := c.UpdateUserRequest(input)
	err := req.Send()
	return out, err
}

const opUploadSSHPublicKey = "UploadSSHPublicKey"

// UploadSSHPublicKeyRequest generates a "aws/request.Request" representing the
// client's request for the UploadSSHPublicKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UploadSSHPublicKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UploadSSHPublicKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UploadSSHPublicKeyRequest method.
//    req, resp := client.UploadSSHPublicKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSSHPublicKey
func (c *IAM) UploadSSHPublicKeyRequest(input *UploadSSHPublicKeyInput) (req *request.Request, output *UploadSSHPublicKeyOutput) {
	op := &request.Operation{
		Name:       opUploadSSHPublicKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadSSHPublicKeyInput{}
	}

	output = &UploadSSHPublicKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadSSHPublicKey API operation for AWS Identity and Access Management.
//
// Uploads an SSH public key and associates it with the specified IAM user.
//
// The SSH public key uploaded by this action can be used only for authenticating
// the associated IAM user to an AWS CodeCommit repository. For more information
// about using SSH keys to authenticate to an AWS CodeCommit repository, see
// Set up AWS CodeCommit for SSH Connections (http://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html)
// in the AWS CodeCommit User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UploadSSHPublicKey for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeInvalidPublicKeyException "InvalidPublicKey"
//   The request was rejected because the public key is malformed or otherwise
//   invalid.
//
//   * ErrCodeDuplicateSSHPublicKeyException "DuplicateSSHPublicKey"
//   The request was rejected because the SSH public key is already associated
//   with the specified IAM user.
//
//   * ErrCodeUnrecognizedPublicKeyEncodingException "UnrecognizedPublicKeyEncoding"
//   The request was rejected because the public key encoding format is unsupported
//   or unrecognized.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSSHPublicKey
func (c *IAM) UploadSSHPublicKey(input *UploadSSHPublicKeyInput) (*UploadSSHPublicKeyOutput, error) {
	req, out := c.UploadSSHPublicKeyRequest(input)
	err := req.Send()
	return out, err
}

const opUploadServerCertificate = "UploadServerCertificate"

// UploadServerCertificateRequest generates a "aws/request.Request" representing the
// client's request for the UploadServerCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UploadServerCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UploadServerCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UploadServerCertificateRequest method.
//    req, resp := client.UploadServerCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadServerCertificate
func (c *IAM) UploadServerCertificateRequest(input *UploadServerCertificateInput) (req *request.Request, output *UploadServerCertificateOutput) {
	op := &request.Operation{
		Name:       opUploadServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadServerCertificateInput{}
	}

	output = &UploadServerCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadServerCertificate API operation for AWS Identity and Access Management.
//
// Uploads a server certificate entity for the AWS account. The server certificate
// entity includes a public key certificate, a private key, and an optional
// certificate chain, which should all be PEM-encoded.
//
// We recommend that you use AWS Certificate Manager (https://aws.amazon.com/certificate-manager/)
// to provision, manage, and deploy your server certificates. With ACM you can
// request a certificate, deploy it to AWS resources, and let ACM handle certificate
// renewals for you. Certificates provided by ACM are free. For more information
// about using ACM, see the AWS Certificate Manager User Guide (http://docs.aws.amazon.com/acm/latest/userguide/).
//
// For more information about working with server certificates, including a
// list of AWS services that can use the server certificates that you manage
// with IAM, go to Working with Server Certificates (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide.
//
// For information about the number of server certificates you can upload, see
// Limitations on IAM Entities and Objects (http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-limits.html)
// in the IAM User Guide.
//
// Because the body of the public key certificate, private key, and the certificate
// chain can be large, you should use POST rather than GET when calling UploadServerCertificate.
// For information about setting up signatures and authorization through the
// API, go to Signing AWS API Requests (http://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
// in the AWS General Reference. For general information about using the Query
// API with IAM, go to Calling the API by Making HTTP Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UploadServerCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeMalformedCertificateException "MalformedCertificate"
//   The request was rejected because the certificate was malformed or expired.
//   The error message describes the specific error.
//
//   * ErrCodeKeyPairMismatchException "KeyPairMismatch"
//   The request was rejected because the public key certificate and the private
//   key do not match.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadServerCertificate
func (c *IAM) UploadServerCertificate(input *UploadServerCertificateInput) (*UploadServerCertificateOutput, error) {
	req, out := c.UploadServerCertificateRequest(input)
	err := req.Send()
	return out, err
}

const opUploadSigningCertificate = "UploadSigningCertificate"

// UploadSigningCertificateRequest generates a "aws/request.Request" representing the
// client's request for the UploadSigningCertificate operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UploadSigningCertificate for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UploadSigningCertificate method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UploadSigningCertificateRequest method.
//    req, resp := client.UploadSigningCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSigningCertificate
func (c *IAM) UploadSigningCertificateRequest(input *UploadSigningCertificateInput) (req *request.Request, output *UploadSigningCertificateOutput) {
	op := &request.Operation{
		Name:       opUploadSigningCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UploadSigningCertificateInput{}
	}

	output = &UploadSigningCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UploadSigningCertificate API operation for AWS Identity and Access Management.
//
// Uploads an X.509 signing certificate and associates it with the specified
// IAM user. Some AWS services use X.509 signing certificates to validate requests
// that are signed with a corresponding private key. When you upload the certificate,
// its default status is Active.
//
// If the UserName field is not specified, the IAM user name is determined implicitly
// based on the AWS access key ID used to sign the request. Because this action
// works for access keys under the AWS account, you can use this action to manage
// root credentials even if the AWS account has no associated users.
//
// Because the body of a X.509 certificate can be large, you should use POST
// rather than GET when calling UploadSigningCertificate. For information about
// setting up signatures and authorization through the API, go to Signing AWS
// API Requests (http://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
// in the AWS General Reference. For general information about using the Query
// API with IAM, go to Making Query Requests (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
// in the IAM User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Identity and Access Management's
// API operation UploadSigningCertificate for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceeded"
//   The request was rejected because it attempted to create resources beyond
//   the current AWS account limits. The error message describes the limit exceeded.
//
//   * ErrCodeEntityAlreadyExistsException "EntityAlreadyExists"
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * ErrCodeMalformedCertificateException "MalformedCertificate"
//   The request was rejected because the certificate was malformed or expired.
//   The error message describes the specific error.
//
//   * ErrCodeInvalidCertificateException "InvalidCertificate"
//   The request was rejected because the certificate is invalid.
//
//   * ErrCodeDuplicateCertificateException "DuplicateCertificate"
//   The request was rejected because the same certificate is associated with
//   an IAM user in the account.
//
//   * ErrCodeNoSuchEntityException "NoSuchEntity"
//   The request was rejected because it referenced an entity that does not exist.
//   The error message describes the entity.
//
//   * ErrCodeServiceFailureException "ServiceFailure"
//   The request processing has failed because of an unknown error, exception
//   or failure.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSigningCertificate
func (c *IAM) UploadSigningCertificate(input *UploadSigningCertificateInput) (*UploadSigningCertificateOutput, error) {
	req, out := c.UploadSigningCertificateRequest(input)
	err := req.Send()
	return out, err
}

// Contains information about an AWS access key.
//
// This data type is used as a response element in the CreateAccessKey and ListAccessKeys
// actions.
//
// The SecretAccessKey value is returned only in response to CreateAccessKey.
// You can get a secret access key only when you first create an access key;
// you cannot recover the secret access key later. If you lose a secret access
// key, you must create a new access key.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AccessKey
type AccessKey struct {
	_ struct{} `type:"structure"`

	// The ID for this access key.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `min:"16" type:"string" required:"true"`

	// The date when the access key was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The secret key used to sign requests.
	//
	// SecretAccessKey is a required field
	SecretAccessKey *string `type:"string" required:"true"`

	// The status of the access key. Active means the key is valid for API calls,
	// while Inactive means it is not.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the IAM user that the access key is associated with.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AccessKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKey) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AccessKey) SetAccessKeyId(v string) *AccessKey {
	s.AccessKeyId = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AccessKey) SetCreateDate(v time.Time) *AccessKey {
	s.CreateDate = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *AccessKey) SetSecretAccessKey(v string) *AccessKey {
	s.SecretAccessKey = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessKey) SetStatus(v string) *AccessKey {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AccessKey) SetUserName(v string) *AccessKey {
	s.UserName = &v
	return s
}

// Contains information about the last time an AWS access key was used.
//
// This data type is used as a response element in the GetAccessKeyLastUsed
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AccessKeyLastUsed
type AccessKeyLastUsed struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the access key was most recently used. This field is null when:
	//
	//    * The user does not have an access key.
	//
	//    * An access key exists but has never been used, at least not since IAM
	//    started tracking this information on April 22nd, 2015.
	//
	//    * There is no sign-in data associated with the user
	//
	// LastUsedDate is a required field
	LastUsedDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The AWS region where this access key was most recently used. This field is
	// null when:
	//
	//    * The user does not have an access key.
	//
	//    * An access key exists but has never been used, at least not since IAM
	//    started tracking this information on April 22nd, 2015.
	//
	//    * There is no sign-in data associated with the user
	//
	// For more information about AWS regions, see Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html)
	// in the Amazon Web Services General Reference.
	//
	// Region is a required field
	Region *string `type:"string" required:"true"`

	// The name of the AWS service with which this access key was most recently
	// used. This field is null when:
	//
	//    * The user does not have an access key.
	//
	//    * An access key exists but has never been used, at least not since IAM
	//    started tracking this information on April 22nd, 2015.
	//
	//    * There is no sign-in data associated with the user
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AccessKeyLastUsed) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKeyLastUsed) GoString() string {
	return s.String()
}

// SetLastUsedDate sets the LastUsedDate field's value.
func (s *AccessKeyLastUsed) SetLastUsedDate(v time.Time) *AccessKeyLastUsed {
	s.LastUsedDate = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *AccessKeyLastUsed) SetRegion(v string) *AccessKeyLastUsed {
	s.Region = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *AccessKeyLastUsed) SetServiceName(v string) *AccessKeyLastUsed {
	s.ServiceName = &v
	return s
}

// Contains information about an AWS access key, without its secret key.
//
// This data type is used as a response element in the ListAccessKeys action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AccessKeyMetadata
type AccessKeyMetadata struct {
	_ struct{} `type:"structure"`

	// The ID for this access key.
	AccessKeyId *string `min:"16" type:"string"`

	// The date when the access key was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The status of the access key. Active means the key is valid for API calls;
	// Inactive means it is not.
	Status *string `type:"string" enum:"statusType"`

	// The name of the IAM user that the key is associated with.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AccessKeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessKeyMetadata) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AccessKeyMetadata) SetAccessKeyId(v string) *AccessKeyMetadata {
	s.AccessKeyId = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *AccessKeyMetadata) SetCreateDate(v time.Time) *AccessKeyMetadata {
	s.CreateDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessKeyMetadata) SetStatus(v string) *AccessKeyMetadata {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AccessKeyMetadata) SetUserName(v string) *AccessKeyMetadata {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProviderRequest
type AddClientIDToOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The client ID (also known as audience) to add to the IAM OpenID Connect provider
	// resource.
	//
	// ClientID is a required field
	ClientID *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider
	// resource to add the client ID to. You can get a list of OIDC provider ARNs
	// by using the ListOpenIDConnectProviders action.
	//
	// OpenIDConnectProviderArn is a required field
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AddClientIDToOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddClientIDToOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddClientIDToOpenIDConnectProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddClientIDToOpenIDConnectProviderInput"}
	if s.ClientID == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientID"))
	}
	if s.ClientID != nil && len(*s.ClientID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientID", 1))
	}
	if s.OpenIDConnectProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OpenIDConnectProviderArn"))
	}
	if s.OpenIDConnectProviderArn != nil && len(*s.OpenIDConnectProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OpenIDConnectProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientID sets the ClientID field's value.
func (s *AddClientIDToOpenIDConnectProviderInput) SetClientID(v string) *AddClientIDToOpenIDConnectProviderInput {
	s.ClientID = &v
	return s
}

// SetOpenIDConnectProviderArn sets the OpenIDConnectProviderArn field's value.
func (s *AddClientIDToOpenIDConnectProviderInput) SetOpenIDConnectProviderArn(v string) *AddClientIDToOpenIDConnectProviderInput {
	s.OpenIDConnectProviderArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProviderOutput
type AddClientIDToOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddClientIDToOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddClientIDToOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfileRequest
type AddRoleToInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to update.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The name of the role to add.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddRoleToInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddRoleToInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddRoleToInstanceProfileInput"}
	if s.InstanceProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceProfileName", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *AddRoleToInstanceProfileInput) SetInstanceProfileName(v string) *AddRoleToInstanceProfileInput {
	s.InstanceProfileName = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *AddRoleToInstanceProfileInput) SetRoleName(v string) *AddRoleToInstanceProfileInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfileOutput
type AddRoleToInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddRoleToInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddRoleToInstanceProfileOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroupRequest
type AddUserToGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to update.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name of the user to add.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddUserToGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUserToGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddUserToGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddUserToGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *AddUserToGroupInput) SetGroupName(v string) *AddUserToGroupInput {
	s.GroupName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AddUserToGroupInput) SetUserName(v string) *AddUserToGroupInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroupOutput
type AddUserToGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddUserToGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddUserToGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicyRequest
type AttachGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) of the group to attach the policy to.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM policy you want to attach.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachGroupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachGroupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachGroupPolicyInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *AttachGroupPolicyInput) SetGroupName(v string) *AttachGroupPolicyInput {
	s.GroupName = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *AttachGroupPolicyInput) SetPolicyArn(v string) *AttachGroupPolicyInput {
	s.PolicyArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicyOutput
type AttachGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachGroupPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicyRequest
type AttachRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy you want to attach.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the role to attach the policy to.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachRolePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachRolePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachRolePolicyInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *AttachRolePolicyInput) SetPolicyArn(v string) *AttachRolePolicyInput {
	s.PolicyArn = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *AttachRolePolicyInput) SetRoleName(v string) *AttachRolePolicyInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicyOutput
type AttachRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachRolePolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicyRequest
type AttachUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy you want to attach.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the IAM user to attach the policy to.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachUserPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachUserPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachUserPolicyInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *AttachUserPolicyInput) SetPolicyArn(v string) *AttachUserPolicyInput {
	s.PolicyArn = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *AttachUserPolicyInput) SetUserName(v string) *AttachUserPolicyInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicyOutput
type AttachUserPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachUserPolicyOutput) GoString() string {
	return s.String()
}

// Contains information about an attached policy.
//
// An attached policy is a managed policy that has been attached to a user,
// group, or role. This data type is used as a response element in the ListAttachedGroupPolicies,
// ListAttachedRolePolicies, ListAttachedUserPolicies, and GetAccountAuthorizationDetails
// actions.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachedPolicy
type AttachedPolicy struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	PolicyArn *string `min:"20" type:"string"`

	// The friendly name of the attached policy.
	PolicyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AttachedPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachedPolicy) GoString() string {
	return s.String()
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *AttachedPolicy) SetPolicyArn(v string) *AttachedPolicy {
	s.PolicyArn = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *AttachedPolicy) SetPolicyName(v string) *AttachedPolicy {
	s.PolicyName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePasswordRequest
type ChangePasswordInput struct {
	_ struct{} `type:"structure"`

	// The new password. The new password must conform to the AWS account's password
	// policy, if one exists.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of almost any printable ASCII
	// character from the space (\u0020) through the end of the ASCII character
	// range (\u00FF). You can also include the tab (\u0009), line feed (\u000A),
	// and carriage return (\u000D) characters. Although any of these characters
	// are valid in a password, note that many tools, such as the AWS Management
	// Console, might restrict the ability to enter certain characters because they
	// have special meaning within that tool.
	//
	// NewPassword is a required field
	NewPassword *string `min:"1" type:"string" required:"true"`

	// The IAM user's current password.
	//
	// OldPassword is a required field
	OldPassword *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ChangePasswordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangePasswordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChangePasswordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChangePasswordInput"}
	if s.NewPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("NewPassword"))
	}
	if s.NewPassword != nil && len(*s.NewPassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewPassword", 1))
	}
	if s.OldPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("OldPassword"))
	}
	if s.OldPassword != nil && len(*s.OldPassword) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OldPassword", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNewPassword sets the NewPassword field's value.
func (s *ChangePasswordInput) SetNewPassword(v string) *ChangePasswordInput {
	s.NewPassword = &v
	return s
}

// SetOldPassword sets the OldPassword field's value.
func (s *ChangePasswordInput) SetOldPassword(v string) *ChangePasswordInput {
	s.OldPassword = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePasswordOutput
type ChangePasswordOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ChangePasswordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangePasswordOutput) GoString() string {
	return s.String()
}

// Contains information about a condition context key. It includes the name
// of the key and specifies the value (or values, if the context key supports
// multiple values) to use in the simulation. This information is used when
// evaluating the Condition elements of the input policies.
//
// This data type is used as an input parameter to SimulateCustomPolicy and
// SimulateCustomPolicy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ContextEntry
type ContextEntry struct {
	_ struct{} `type:"structure"`

	// The full name of a condition context key, including the service prefix. For
	// example, aws:SourceIp or s3:VersionId.
	ContextKeyName *string `min:"5" type:"string"`

	// The data type of the value (or values) specified in the ContextKeyValues
	// parameter.
	ContextKeyType *string `type:"string" enum:"ContextKeyTypeEnum"`

	// The value (or values, if the condition context key supports multiple values)
	// to provide to the simulation for use when the key is referenced by a Condition
	// element in an input policy.
	ContextKeyValues []*string `type:"list"`
}

// String returns the string representation
func (s ContextEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ContextEntry) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContextEntry) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContextEntry"}
	if s.ContextKeyName != nil && len(*s.ContextKeyName) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("ContextKeyName", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContextKeyName sets the ContextKeyName field's value.
func (s *ContextEntry) SetContextKeyName(v string) *ContextEntry {
	s.ContextKeyName = &v
	return s
}

// SetContextKeyType sets the ContextKeyType field's value.
func (s *ContextEntry) SetContextKeyType(v string) *ContextEntry {
	s.ContextKeyType = &v
	return s
}

// SetContextKeyValues sets the ContextKeyValues field's value.
func (s *ContextEntry) SetContextKeyValues(v []*string) *ContextEntry {
	s.ContextKeyValues = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKeyRequest
type CreateAccessKeyInput struct {
	_ struct{} `type:"structure"`

	// The name of the IAM user that the new key will belong to.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAccessKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessKeyInput"}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserName sets the UserName field's value.
func (s *CreateAccessKeyInput) SetUserName(v string) *CreateAccessKeyInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful CreateAccessKey request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKeyResponse
type CreateAccessKeyOutput struct {
	_ struct{} `type:"structure"`

	// A structure with details about the access key.
	//
	// AccessKey is a required field
	AccessKey *AccessKey `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateAccessKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccessKeyOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *CreateAccessKeyOutput) SetAccessKey(v *AccessKey) *CreateAccessKeyOutput {
	s.AccessKey = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAliasRequest
type CreateAccountAliasInput struct {
	_ struct{} `type:"structure"`

	// The account alias to create.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of lowercase letters, digits, and dashes.
	// You cannot start or finish with a dash, nor can you have two dashes in a
	// row.
	//
	// AccountAlias is a required field
	AccountAlias *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAccountAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountAliasInput"}
	if s.AccountAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountAlias"))
	}
	if s.AccountAlias != nil && len(*s.AccountAlias) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("AccountAlias", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAlias sets the AccountAlias field's value.
func (s *CreateAccountAliasInput) SetAccountAlias(v string) *CreateAccountAliasInput {
	s.AccountAlias = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAliasOutput
type CreateAccountAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAccountAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAccountAliasOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroupRequest
type CreateGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to create. Do not include the path in this value.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-.
	// The group name must be unique within the account. Group names are not distinguished
	// by case. For example, you cannot create groups named both "ADMINS" and "admins".
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The path to the group. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	Path *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *CreateGroupInput) SetGroupName(v string) *CreateGroupInput {
	s.GroupName = &v
	return s
}

// SetPath sets the Path field's value.
func (s *CreateGroupInput) SetPath(v string) *CreateGroupInput {
	s.Path = &v
	return s
}

// Contains the response to a successful CreateGroup request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroupResponse
type CreateGroupOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the new group.
	//
	// Group is a required field
	Group *Group `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *CreateGroupOutput) SetGroup(v *Group) *CreateGroupOutput {
	s.Group = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfileRequest
type CreateInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to create.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The path to the instance profile. For more information about paths, see IAM
	// Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	Path *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceProfileInput"}
	if s.InstanceProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceProfileName", 1))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *CreateInstanceProfileInput) SetInstanceProfileName(v string) *CreateInstanceProfileInput {
	s.InstanceProfileName = &v
	return s
}

// SetPath sets the Path field's value.
func (s *CreateInstanceProfileInput) SetPath(v string) *CreateInstanceProfileInput {
	s.Path = &v
	return s
}

// Contains the response to a successful CreateInstanceProfile request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfileResponse
type CreateInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the new instance profile.
	//
	// InstanceProfile is a required field
	InstanceProfile *InstanceProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceProfileOutput) GoString() string {
	return s.String()
}

// SetInstanceProfile sets the InstanceProfile field's value.
func (s *CreateInstanceProfileOutput) SetInstanceProfile(v *InstanceProfile) *CreateInstanceProfileOutput {
	s.InstanceProfile = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfileRequest
type CreateLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The new password for the user.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of almost any printable ASCII
	// character from the space (\u0020) through the end of the ASCII character
	// range (\u00FF). You can also include the tab (\u0009), line feed (\u000A),
	// and carriage return (\u000D) characters. Although any of these characters
	// are valid in a password, note that many tools, such as the AWS Management
	// Console, might restrict the ability to enter certain characters because they
	// have special meaning within that tool.
	//
	// Password is a required field
	Password *string `min:"1" type:"string" required:"true"`

	// Specifies whether the user is required to set a new password on next sign-in.
	PasswordResetRequired *bool `type:"boolean"`

	// The name of the IAM user to create a password for. The user must already
	// exist.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoginProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLoginProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLoginProfileInput"}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *CreateLoginProfileInput) SetPassword(v string) *CreateLoginProfileInput {
	s.Password = &v
	return s
}

// SetPasswordResetRequired sets the PasswordResetRequired field's value.
func (s *CreateLoginProfileInput) SetPasswordResetRequired(v bool) *CreateLoginProfileInput {
	s.PasswordResetRequired = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateLoginProfileInput) SetUserName(v string) *CreateLoginProfileInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful CreateLoginProfile request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfileResponse
type CreateLoginProfileOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the user name and password create date.
	//
	// LoginProfile is a required field
	LoginProfile *LoginProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLoginProfileOutput) GoString() string {
	return s.String()
}

// SetLoginProfile sets the LoginProfile field's value.
func (s *CreateLoginProfileOutput) SetLoginProfile(v *LoginProfile) *CreateLoginProfileOutput {
	s.LoginProfile = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProviderRequest
type CreateOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// A list of client IDs (also known as audiences). When a mobile or web app
	// registers with an OpenID Connect provider, they establish a value that identifies
	// the application. (This is the value that's sent as the client_id parameter
	// on OAuth requests.)
	//
	// You can register multiple client IDs with the same provider. For example,
	// you might have multiple applications that use the same OIDC provider. You
	// cannot register more than 100 client IDs with a single IAM OIDC provider.
	//
	// There is no defined format for a client ID. The CreateOpenIDConnectProviderRequest
	// action accepts client IDs up to 255 characters long.
	ClientIDList []*string `type:"list"`

	// A list of server certificate thumbprints for the OpenID Connect (OIDC) identity
	// provider's server certificate(s). Typically this list includes only one entry.
	// However, IAM lets you have up to five thumbprints for an OIDC provider. This
	// lets you maintain multiple thumbprints if the identity provider is rotating
	// certificates.
	//
	// The server certificate thumbprint is the hex-encoded SHA-1 hash value of
	// the X.509 certificate used by the domain where the OpenID Connect provider
	// makes its keys available. It is always a 40-character string.
	//
	// You must provide at least one thumbprint when creating an IAM OIDC provider.
	// For example, if the OIDC provider is server.example.com and the provider
	// stores its keys at "https://keys.server.example.com/openid-connect", the
	// thumbprint string would be the hex-encoded SHA-1 hash value of the certificate
	// used by https://keys.server.example.com.
	//
	// For more information about obtaining the OIDC provider's thumbprint, see
	// Obtaining the Thumbprint for an OpenID Connect Provider (http://docs.aws.amazon.com/IAM/latest/UserGuide/identity-providers-oidc-obtain-thumbprint.html)
	// in the IAM User Guide.
	//
	// ThumbprintList is a required field
	ThumbprintList []*string `type:"list" required:"true"`

	// The URL of the identity provider. The URL must begin with "https://" and
	// should correspond to the iss claim in the provider's OpenID Connect ID tokens.
	// Per the OIDC standard, path components are allowed but query parameters are
	// not. Typically the URL consists of only a host name, like "https://server.example.org"
	// or "https://example.com".
	//
	// You cannot register the same provider multiple times in a single AWS account.
	// If you try to submit a URL that has already been used for an OpenID Connect
	// provider in the AWS account, you will get an error.
	//
	// Url is a required field
	Url *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOpenIDConnectProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOpenIDConnectProviderInput"}
	if s.ThumbprintList == nil {
		invalidParams.Add(request.NewErrParamRequired("ThumbprintList"))
	}
	if s.Url == nil {
		invalidParams.Add(request.NewErrParamRequired("Url"))
	}
	if s.Url != nil && len(*s.Url) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Url", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientIDList sets the ClientIDList field's value.
func (s *CreateOpenIDConnectProviderInput) SetClientIDList(v []*string) *CreateOpenIDConnectProviderInput {
	s.ClientIDList = v
	return s
}

// SetThumbprintList sets the ThumbprintList field's value.
func (s *CreateOpenIDConnectProviderInput) SetThumbprintList(v []*string) *CreateOpenIDConnectProviderInput {
	s.ThumbprintList = v
	return s
}

// SetUrl sets the Url field's value.
func (s *CreateOpenIDConnectProviderInput) SetUrl(v string) *CreateOpenIDConnectProviderInput {
	s.Url = &v
	return s
}

// Contains the response to a successful CreateOpenIDConnectProvider request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProviderResponse
type CreateOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new IAM OpenID Connect provider that
	// is created. For more information, see OpenIDConnectProviderListEntry.
	OpenIDConnectProviderArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreateOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

// SetOpenIDConnectProviderArn sets the OpenIDConnectProviderArn field's value.
func (s *CreateOpenIDConnectProviderOutput) SetOpenIDConnectProviderArn(v string) *CreateOpenIDConnectProviderOutput {
	s.OpenIDConnectProviderArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyRequest
type CreatePolicyInput struct {
	_ struct{} `type:"structure"`

	// A friendly description of the policy.
	//
	// Typically used to store information about the permissions defined in the
	// policy. For example, "Grants access to production DynamoDB tables."
	//
	// The policy description is immutable. After a value is assigned, it cannot
	// be changed.
	Description *string `type:"string"`

	// The path for the policy.
	//
	// For more information about paths, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	Path *string `type:"string"`

	// The JSON policy document that you want to use as the content for the new
	// policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The friendly name of the policy.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyDocument", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreatePolicyInput) SetDescription(v string) *CreatePolicyInput {
	s.Description = &v
	return s
}

// SetPath sets the Path field's value.
func (s *CreatePolicyInput) SetPath(v string) *CreatePolicyInput {
	s.Path = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyInput) SetPolicyDocument(v string) *CreatePolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *CreatePolicyInput) SetPolicyName(v string) *CreatePolicyInput {
	s.PolicyName = &v
	return s
}

// Contains the response to a successful CreatePolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyResponse
type CreatePolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the new policy.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s CreatePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *CreatePolicyOutput) SetPolicy(v *Policy) *CreatePolicyOutput {
	s.Policy = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersionRequest
type CreatePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy to which you want to add
	// a new version.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The JSON policy document that you want to use as the content for this new
	// version of the policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// Specifies whether to set this version as the policy's default version.
	//
	// When this parameter is true, the new policy version becomes the operative
	// version; that is, the version that is in effect for the IAM users, groups,
	// and roles that the policy is attached to.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	SetAsDefault *bool `type:"boolean"`
}

// String returns the string representation
func (s CreatePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePolicyVersionInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyDocument", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *CreatePolicyVersionInput) SetPolicyArn(v string) *CreatePolicyVersionInput {
	s.PolicyArn = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *CreatePolicyVersionInput) SetPolicyDocument(v string) *CreatePolicyVersionInput {
	s.PolicyDocument = &v
	return s
}

// SetSetAsDefault sets the SetAsDefault field's value.
func (s *CreatePolicyVersionInput) SetSetAsDefault(v bool) *CreatePolicyVersionInput {
	s.SetAsDefault = &v
	return s
}

// Contains the response to a successful CreatePolicyVersion request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersionResponse
type CreatePolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the new policy version.
	PolicyVersion *PolicyVersion `type:"structure"`
}

// String returns the string representation
func (s CreatePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePolicyVersionOutput) GoString() string {
	return s.String()
}

// SetPolicyVersion sets the PolicyVersion field's value.
func (s *CreatePolicyVersionOutput) SetPolicyVersion(v *PolicyVersion) *CreatePolicyVersionOutput {
	s.PolicyVersion = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRoleRequest
type CreateRoleInput struct {
	_ struct{} `type:"structure"`

	// The trust relationship policy document that grants an entity permission to
	// assume the role.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// AssumeRolePolicyDocument is a required field
	AssumeRolePolicyDocument *string `min:"1" type:"string" required:"true"`

	// The path to the role. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	Path *string `min:"1" type:"string"`

	// The name of the role to create.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-.
	// Role names are not distinguished by case. For example, you cannot create
	// roles named both "PRODROLE" and "prodrole".
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoleInput"}
	if s.AssumeRolePolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("AssumeRolePolicyDocument"))
	}
	if s.AssumeRolePolicyDocument != nil && len(*s.AssumeRolePolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssumeRolePolicyDocument", 1))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssumeRolePolicyDocument sets the AssumeRolePolicyDocument field's value.
func (s *CreateRoleInput) SetAssumeRolePolicyDocument(v string) *CreateRoleInput {
	s.AssumeRolePolicyDocument = &v
	return s
}

// SetPath sets the Path field's value.
func (s *CreateRoleInput) SetPath(v string) *CreateRoleInput {
	s.Path = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *CreateRoleInput) SetRoleName(v string) *CreateRoleInput {
	s.RoleName = &v
	return s
}

// Contains the response to a successful CreateRole request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRoleResponse
type CreateRoleOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the new role.
	//
	// Role is a required field
	Role *Role `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRoleOutput) GoString() string {
	return s.String()
}

// SetRole sets the Role field's value.
func (s *CreateRoleOutput) SetRole(v *Role) *CreateRoleOutput {
	s.Role = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProviderRequest
type CreateSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// The name of the provider to create.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An XML document generated by an identity provider (IdP) that supports SAML
	// 2.0. The document includes the issuer's name, expiration information, and
	// keys that can be used to validate the SAML authentication response (assertions)
	// that are received from the IdP. You must generate the metadata document using
	// the identity management software that is used as your organization's IdP.
	//
	// For more information, see About SAML 2.0-based Federation (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
	// in the IAM User Guide
	//
	// SAMLMetadataDocument is a required field
	SAMLMetadataDocument *string `min:"1000" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSAMLProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSAMLProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSAMLProviderInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SAMLMetadataDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("SAMLMetadataDocument"))
	}
	if s.SAMLMetadataDocument != nil && len(*s.SAMLMetadataDocument) < 1000 {
		invalidParams.Add(request.NewErrParamMinLen("SAMLMetadataDocument", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateSAMLProviderInput) SetName(v string) *CreateSAMLProviderInput {
	s.Name = &v
	return s
}

// SetSAMLMetadataDocument sets the SAMLMetadataDocument field's value.
func (s *CreateSAMLProviderInput) SetSAMLMetadataDocument(v string) *CreateSAMLProviderInput {
	s.SAMLMetadataDocument = &v
	return s
}

// Contains the response to a successful CreateSAMLProvider request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProviderResponse
type CreateSAMLProviderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new SAML provider resource in IAM.
	SAMLProviderArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreateSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSAMLProviderOutput) GoString() string {
	return s.String()
}

// SetSAMLProviderArn sets the SAMLProviderArn field's value.
func (s *CreateSAMLProviderOutput) SetSAMLProviderArn(v string) *CreateSAMLProviderOutput {
	s.SAMLProviderArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredentialRequest
type CreateServiceSpecificCredentialInput struct {
	_ struct{} `type:"structure"`

	// The name of the AWS service that is to be associated with the credentials.
	// The service you specify here is the only service that can be accessed using
	// these credentials.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`

	// The name of the IAM user that is to be associated with the credentials. The
	// new service-specific credentials have the same permissions as the associated
	// user except that they can be used only to access the specified service.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateServiceSpecificCredentialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceSpecificCredentialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceSpecificCredentialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceSpecificCredentialInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateServiceSpecificCredentialInput) SetServiceName(v string) *CreateServiceSpecificCredentialInput {
	s.ServiceName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateServiceSpecificCredentialInput) SetUserName(v string) *CreateServiceSpecificCredentialInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredentialResponse
type CreateServiceSpecificCredentialOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains information about the newly created service-specific
	// credential.
	//
	// This is the only time that the password for this credential set is available.
	// It cannot be recovered later. Instead, you will have to reset the password
	// with ResetServiceSpecificCredential.
	ServiceSpecificCredential *ServiceSpecificCredential `type:"structure"`
}

// String returns the string representation
func (s CreateServiceSpecificCredentialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceSpecificCredentialOutput) GoString() string {
	return s.String()
}

// SetServiceSpecificCredential sets the ServiceSpecificCredential field's value.
func (s *CreateServiceSpecificCredentialOutput) SetServiceSpecificCredential(v *ServiceSpecificCredential) *CreateServiceSpecificCredentialOutput {
	s.ServiceSpecificCredential = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUserRequest
type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The path for the user name. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	Path *string `min:"1" type:"string"`

	// The name of the user to create.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-.
	// User names are not distinguished by case. For example, you cannot create
	// users named both "TESTUSER" and "testuser".
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPath sets the Path field's value.
func (s *CreateUserInput) SetPath(v string) *CreateUserInput {
	s.Path = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserInput) SetUserName(v string) *CreateUserInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful CreateUser request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUserResponse
type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// A structure with details about the new IAM user.
	User *User `type:"structure"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *CreateUserOutput) SetUser(v *User) *CreateUserOutput {
	s.User = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADeviceRequest
type CreateVirtualMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// The path for the virtual MFA device. For more information about paths, see
	// IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/).
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	Path *string `min:"1" type:"string"`

	// The name of the virtual MFA device. Use with path to uniquely identify a
	// virtual MFA device.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// VirtualMFADeviceName is a required field
	VirtualMFADeviceName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateVirtualMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualMFADeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVirtualMFADeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVirtualMFADeviceInput"}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.VirtualMFADeviceName == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualMFADeviceName"))
	}
	if s.VirtualMFADeviceName != nil && len(*s.VirtualMFADeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualMFADeviceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPath sets the Path field's value.
func (s *CreateVirtualMFADeviceInput) SetPath(v string) *CreateVirtualMFADeviceInput {
	s.Path = &v
	return s
}

// SetVirtualMFADeviceName sets the VirtualMFADeviceName field's value.
func (s *CreateVirtualMFADeviceInput) SetVirtualMFADeviceName(v string) *CreateVirtualMFADeviceInput {
	s.VirtualMFADeviceName = &v
	return s
}

// Contains the response to a successful CreateVirtualMFADevice request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADeviceResponse
type CreateVirtualMFADeviceOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the new virtual MFA device.
	//
	// VirtualMFADevice is a required field
	VirtualMFADevice *VirtualMFADevice `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateVirtualMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVirtualMFADeviceOutput) GoString() string {
	return s.String()
}

// SetVirtualMFADevice sets the VirtualMFADevice field's value.
func (s *CreateVirtualMFADeviceOutput) SetVirtualMFADevice(v *VirtualMFADevice) *CreateVirtualMFADeviceOutput {
	s.VirtualMFADevice = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADeviceRequest
type DeactivateMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// The serial number that uniquely identifies the MFA device. For virtual MFA
	// devices, the serial number is the device ARN.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =/:,.@-
	//
	// SerialNumber is a required field
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The name of the user whose MFA device you want to deactivate.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeactivateMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivateMFADeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeactivateMFADeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeactivateMFADeviceInput"}
	if s.SerialNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("SerialNumber"))
	}
	if s.SerialNumber != nil && len(*s.SerialNumber) < 9 {
		invalidParams.Add(request.NewErrParamMinLen("SerialNumber", 9))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *DeactivateMFADeviceInput) SetSerialNumber(v string) *DeactivateMFADeviceInput {
	s.SerialNumber = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeactivateMFADeviceInput) SetUserName(v string) *DeactivateMFADeviceInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADeviceOutput
type DeactivateMFADeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeactivateMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeactivateMFADeviceOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKeyRequest
type DeleteAccessKeyInput struct {
	_ struct{} `type:"structure"`

	// The access key ID for the access key ID and secret access key you want to
	// delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `min:"16" type:"string" required:"true"`

	// The name of the user whose access key pair you want to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteAccessKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessKeyInput"}
	if s.AccessKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessKeyId"))
	}
	if s.AccessKeyId != nil && len(*s.AccessKeyId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("AccessKeyId", 16))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *DeleteAccessKeyInput) SetAccessKeyId(v string) *DeleteAccessKeyInput {
	s.AccessKeyId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteAccessKeyInput) SetUserName(v string) *DeleteAccessKeyInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKeyOutput
type DeleteAccessKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccessKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccessKeyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAliasRequest
type DeleteAccountAliasInput struct {
	_ struct{} `type:"structure"`

	// The name of the account alias to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of lowercase letters, digits, and dashes.
	// You cannot start or finish with a dash, nor can you have two dashes in a
	// row.
	//
	// AccountAlias is a required field
	AccountAlias *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAccountAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccountAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccountAliasInput"}
	if s.AccountAlias == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountAlias"))
	}
	if s.AccountAlias != nil && len(*s.AccountAlias) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("AccountAlias", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAlias sets the AccountAlias field's value.
func (s *DeleteAccountAliasInput) SetAccountAlias(v string) *DeleteAccountAliasInput {
	s.AccountAlias = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAliasOutput
type DeleteAccountAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountAliasOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicyInput
type DeleteAccountPasswordPolicyInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountPasswordPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountPasswordPolicyInput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicyOutput
type DeleteAccountPasswordPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAccountPasswordPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAccountPasswordPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupRequest
type DeleteGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the IAM group to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupInput) SetGroupName(v string) *DeleteGroupInput {
	s.GroupName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupOutput
type DeleteGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicyRequest
type DeleteGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) identifying the group that the policy is
	// embedded in.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name identifying the policy document to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGroupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGroupPolicyInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *DeleteGroupPolicyInput) SetGroupName(v string) *DeleteGroupPolicyInput {
	s.GroupName = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeleteGroupPolicyInput) SetPolicyName(v string) *DeleteGroupPolicyInput {
	s.PolicyName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicyOutput
type DeleteGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGroupPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfileRequest
type DeleteInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceProfileInput"}
	if s.InstanceProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *DeleteInstanceProfileInput) SetInstanceProfileName(v string) *DeleteInstanceProfileInput {
	s.InstanceProfileName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfileOutput
type DeleteInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceProfileOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfileRequest
type DeleteLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the user whose password you want to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoginProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoginProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoginProfileInput"}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserName sets the UserName field's value.
func (s *DeleteLoginProfileInput) SetUserName(v string) *DeleteLoginProfileInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfileOutput
type DeleteLoginProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoginProfileOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProviderRequest
type DeleteOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM OpenID Connect provider resource
	// object to delete. You can get a list of OpenID Connect provider resource
	// ARNs by using the ListOpenIDConnectProviders action.
	//
	// OpenIDConnectProviderArn is a required field
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteOpenIDConnectProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteOpenIDConnectProviderInput"}
	if s.OpenIDConnectProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OpenIDConnectProviderArn"))
	}
	if s.OpenIDConnectProviderArn != nil && len(*s.OpenIDConnectProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OpenIDConnectProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOpenIDConnectProviderArn sets the OpenIDConnectProviderArn field's value.
func (s *DeleteOpenIDConnectProviderInput) SetOpenIDConnectProviderArn(v string) *DeleteOpenIDConnectProviderInput {
	s.OpenIDConnectProviderArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProviderOutput
type DeleteOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyRequest
type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy you want to delete.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *DeletePolicyInput) SetPolicyArn(v string) *DeletePolicyInput {
	s.PolicyArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyOutput
type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersionRequest
type DeletePolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy from which you want to delete
	// a version.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The policy version to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that consists of the lowercase letter 'v' followed
	// by one or two digits, and optionally followed by a period '.' and a string
	// of letters and digits.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	//
	// VersionId is a required field
	VersionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyVersionInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *DeletePolicyVersionInput) SetPolicyArn(v string) *DeletePolicyVersionInput {
	s.PolicyArn = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeletePolicyVersionInput) SetVersionId(v string) *DeletePolicyVersionInput {
	s.VersionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersionOutput
type DeletePolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyVersionOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRoleRequest
type DeleteRoleInput struct {
	_ struct{} `type:"structure"`

	// The name of the role to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRoleInput"}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleName sets the RoleName field's value.
func (s *DeleteRoleInput) SetRoleName(v string) *DeleteRoleInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRoleOutput
type DeleteRoleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRoleOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicyRequest
type DeleteRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the inline policy to delete from the specified IAM role.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name (friendly name, not ARN) identifying the role that the policy is
	// embedded in.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRolePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRolePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRolePolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeleteRolePolicyInput) SetPolicyName(v string) *DeleteRolePolicyInput {
	s.PolicyName = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *DeleteRolePolicyInput) SetRoleName(v string) *DeleteRolePolicyInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicyOutput
type DeleteRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRolePolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProviderRequest
type DeleteSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider to delete.
	//
	// SAMLProviderArn is a required field
	SAMLProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSAMLProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSAMLProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSAMLProviderInput"}
	if s.SAMLProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SAMLProviderArn"))
	}
	if s.SAMLProviderArn != nil && len(*s.SAMLProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SAMLProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSAMLProviderArn sets the SAMLProviderArn field's value.
func (s *DeleteSAMLProviderInput) SetSAMLProviderArn(v string) *DeleteSAMLProviderInput {
	s.SAMLProviderArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProviderOutput
type DeleteSAMLProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSAMLProviderOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKeyRequest
type DeleteSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the SSH public key.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// SSHPublicKeyId is a required field
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The name of the IAM user associated with the SSH public key.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSSHPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSSHPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSSHPublicKeyInput"}
	if s.SSHPublicKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("SSHPublicKeyId"))
	}
	if s.SSHPublicKeyId != nil && len(*s.SSHPublicKeyId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SSHPublicKeyId", 20))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSSHPublicKeyId sets the SSHPublicKeyId field's value.
func (s *DeleteSSHPublicKeyInput) SetSSHPublicKeyId(v string) *DeleteSSHPublicKeyInput {
	s.SSHPublicKeyId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteSSHPublicKeyInput) SetUserName(v string) *DeleteSSHPublicKeyInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKeyOutput
type DeleteSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSSHPublicKeyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificateRequest
type DeleteServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The name of the server certificate you want to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// ServerCertificateName is a required field
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServerCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServerCertificateInput"}
	if s.ServerCertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerCertificateName"))
	}
	if s.ServerCertificateName != nil && len(*s.ServerCertificateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerCertificateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerCertificateName sets the ServerCertificateName field's value.
func (s *DeleteServerCertificateInput) SetServerCertificateName(v string) *DeleteServerCertificateInput {
	s.ServerCertificateName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificateOutput
type DeleteServerCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerCertificateOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredentialRequest
type DeleteServiceSpecificCredentialInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the service-specific credential. You can get this
	// value by calling ListServiceSpecificCredentials.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// ServiceSpecificCredentialId is a required field
	ServiceSpecificCredentialId *string `min:"20" type:"string" required:"true"`

	// The name of the IAM user associated with the service-specific credential.
	// If this value is not specified, then the operation assumes the user whose
	// credentials are used to call the operation.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteServiceSpecificCredentialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceSpecificCredentialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceSpecificCredentialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceSpecificCredentialInput"}
	if s.ServiceSpecificCredentialId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceSpecificCredentialId"))
	}
	if s.ServiceSpecificCredentialId != nil && len(*s.ServiceSpecificCredentialId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceSpecificCredentialId", 20))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceSpecificCredentialId sets the ServiceSpecificCredentialId field's value.
func (s *DeleteServiceSpecificCredentialInput) SetServiceSpecificCredentialId(v string) *DeleteServiceSpecificCredentialInput {
	s.ServiceSpecificCredentialId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteServiceSpecificCredentialInput) SetUserName(v string) *DeleteServiceSpecificCredentialInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredentialOutput
type DeleteServiceSpecificCredentialOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServiceSpecificCredentialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceSpecificCredentialOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificateRequest
type DeleteSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the signing certificate to delete.
	//
	// The format of this parameter, as described by its regex (http://wikipedia.org/wiki/regex)
	// pattern, is a string of characters that can be upper- or lower-cased letters
	// or digits.
	//
	// CertificateId is a required field
	CertificateId *string `min:"24" type:"string" required:"true"`

	// The name of the user the signing certificate belongs to.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSigningCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSigningCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSigningCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 24))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *DeleteSigningCertificateInput) SetCertificateId(v string) *DeleteSigningCertificateInput {
	s.CertificateId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteSigningCertificateInput) SetUserName(v string) *DeleteSigningCertificateInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificateOutput
type DeleteSigningCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSigningCertificateOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserRequest
type DeleteUserInput struct {
	_ struct{} `type:"structure"`

	// The name of the user to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserInput"}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserInput) SetUserName(v string) *DeleteUserInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserOutput
type DeleteUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicyRequest
type DeleteUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name identifying the policy document to delete.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name (friendly name, not ARN) identifying the user that the policy is
	// embedded in.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *DeleteUserPolicyInput) SetPolicyName(v string) *DeleteUserPolicyInput {
	s.PolicyName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DeleteUserPolicyInput) SetUserName(v string) *DeleteUserPolicyInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicyOutput
type DeleteUserPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADeviceRequest
type DeleteVirtualMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// The serial number that uniquely identifies the MFA device. For virtual MFA
	// devices, the serial number is the same as the ARN.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =/:,.@-
	//
	// SerialNumber is a required field
	SerialNumber *string `min:"9" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteVirtualMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualMFADeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVirtualMFADeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVirtualMFADeviceInput"}
	if s.SerialNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("SerialNumber"))
	}
	if s.SerialNumber != nil && len(*s.SerialNumber) < 9 {
		invalidParams.Add(request.NewErrParamMinLen("SerialNumber", 9))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *DeleteVirtualMFADeviceInput) SetSerialNumber(v string) *DeleteVirtualMFADeviceInput {
	s.SerialNumber = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADeviceOutput
type DeleteVirtualMFADeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteVirtualMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualMFADeviceOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicyRequest
type DetachGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) of the IAM group to detach the policy from.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM policy you want to detach.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachGroupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachGroupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachGroupPolicyInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *DetachGroupPolicyInput) SetGroupName(v string) *DetachGroupPolicyInput {
	s.GroupName = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *DetachGroupPolicyInput) SetPolicyArn(v string) *DetachGroupPolicyInput {
	s.PolicyArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicyOutput
type DetachGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachGroupPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicyRequest
type DetachRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy you want to detach.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the IAM role to detach the policy from.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachRolePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachRolePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachRolePolicyInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *DetachRolePolicyInput) SetPolicyArn(v string) *DetachRolePolicyInput {
	s.PolicyArn = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *DetachRolePolicyInput) SetRoleName(v string) *DetachRolePolicyInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicyOutput
type DetachRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachRolePolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicyRequest
type DetachUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy you want to detach.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The name (friendly name, not ARN) of the IAM user to detach the policy from.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetachUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachUserPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachUserPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachUserPolicyInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *DetachUserPolicyInput) SetPolicyArn(v string) *DetachUserPolicyInput {
	s.PolicyArn = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DetachUserPolicyInput) SetUserName(v string) *DetachUserPolicyInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicyOutput
type DetachUserPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachUserPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADeviceRequest
type EnableMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// An authentication code emitted by the device.
	//
	// The format for this parameter is a string of 6 digits.
	//
	// AuthenticationCode1 is a required field
	AuthenticationCode1 *string `min:"6" type:"string" required:"true"`

	// A subsequent authentication code emitted by the device.
	//
	// The format for this parameter is a string of 6 digits.
	//
	// AuthenticationCode2 is a required field
	AuthenticationCode2 *string `min:"6" type:"string" required:"true"`

	// The serial number that uniquely identifies the MFA device. For virtual MFA
	// devices, the serial number is the device ARN.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =/:,.@-
	//
	// SerialNumber is a required field
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The name of the IAM user for whom you want to enable the MFA device.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMFADeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableMFADeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableMFADeviceInput"}
	if s.AuthenticationCode1 == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationCode1"))
	}
	if s.AuthenticationCode1 != nil && len(*s.AuthenticationCode1) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationCode1", 6))
	}
	if s.AuthenticationCode2 == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationCode2"))
	}
	if s.AuthenticationCode2 != nil && len(*s.AuthenticationCode2) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationCode2", 6))
	}
	if s.SerialNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("SerialNumber"))
	}
	if s.SerialNumber != nil && len(*s.SerialNumber) < 9 {
		invalidParams.Add(request.NewErrParamMinLen("SerialNumber", 9))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationCode1 sets the AuthenticationCode1 field's value.
func (s *EnableMFADeviceInput) SetAuthenticationCode1(v string) *EnableMFADeviceInput {
	s.AuthenticationCode1 = &v
	return s
}

// SetAuthenticationCode2 sets the AuthenticationCode2 field's value.
func (s *EnableMFADeviceInput) SetAuthenticationCode2(v string) *EnableMFADeviceInput {
	s.AuthenticationCode2 = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *EnableMFADeviceInput) SetSerialNumber(v string) *EnableMFADeviceInput {
	s.SerialNumber = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *EnableMFADeviceInput) SetUserName(v string) *EnableMFADeviceInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADeviceOutput
type EnableMFADeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMFADeviceOutput) GoString() string {
	return s.String()
}

// Contains the results of a simulation.
//
// This data type is used by the return parameter of SimulateCustomPolicy and
// SimulatePrincipalPolicy.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EvaluationResult
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// The name of the API action tested on the indicated resource.
	//
	// EvalActionName is a required field
	EvalActionName *string `min:"3" type:"string" required:"true"`

	// The result of the simulation.
	//
	// EvalDecision is a required field
	EvalDecision *string `type:"string" required:"true" enum:"PolicyEvaluationDecisionType"`

	// Additional details about the results of the evaluation decision. When there
	// are both IAM policies and resource policies, this parameter explains how
	// each set of policies contributes to the final evaluation decision. When simulating
	// cross-account access to a resource, both the resource-based policy and the
	// caller's IAM policy must grant access. See How IAM Roles Differ from Resource-based
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_compare-resource-policies.html)
	EvalDecisionDetails map[string]*string `type:"map"`

	// The ARN of the resource that the indicated API action was tested on.
	EvalResourceName *string `min:"1" type:"string"`

	// A list of the statements in the input policies that determine the result
	// for this scenario. Remember that even if multiple statements allow the action
	// on the resource, if only one statement denies that action, then the explicit
	// deny overrides any allow, and the deny statement is the only entry included
	// in the result.
	MatchedStatements []*Statement `type:"list"`

	// A list of context keys that are required by the included input policies but
	// that were not provided by one of the input parameters. This list is used
	// when the resource in a simulation is "*", either explicitly, or when the
	// ResourceArns parameter blank. If you include a list of resources, then any
	// missing context values are instead included under the ResourceSpecificResults
	// section. To discover the context keys used by a set of policies, you can
	// call GetContextKeysForCustomPolicy or GetContextKeysForPrincipalPolicy.
	MissingContextValues []*string `type:"list"`

	// A structure that details how AWS Organizations and its service control policies
	// affect the results of the simulation. Only applies if the simulated user's
	// account is part of an organization.
	OrganizationsDecisionDetail *OrganizationsDecisionDetail `type:"structure"`

	// The individual results of the simulation of the API action specified in EvalActionName
	// on each resource.
	ResourceSpecificResults []*ResourceSpecificResult `type:"list"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EvaluationResult) GoString() string {
	return s.String()
}

// SetEvalActionName sets the EvalActionName field's value.
func (s *EvaluationResult) SetEvalActionName(v string) *EvaluationResult {
	s.EvalActionName = &v
	return s
}

// SetEvalDecision sets the EvalDecision field's value.
func (s *EvaluationResult) SetEvalDecision(v string) *EvaluationResult {
	s.EvalDecision = &v
	return s
}

// SetEvalDecisionDetails sets the EvalDecisionDetails field's value.
func (s *EvaluationResult) SetEvalDecisionDetails(v map[string]*string) *EvaluationResult {
	s.EvalDecisionDetails = v
	return s
}

// SetEvalResourceName sets the EvalResourceName field's value.
func (s *EvaluationResult) SetEvalResourceName(v string) *EvaluationResult {
	s.EvalResourceName = &v
	return s
}

// SetMatchedStatements sets the MatchedStatements field's value.
func (s *EvaluationResult) SetMatchedStatements(v []*Statement) *EvaluationResult {
	s.MatchedStatements = v
	return s
}

// SetMissingContextValues sets the MissingContextValues field's value.
func (s *EvaluationResult) SetMissingContextValues(v []*string) *EvaluationResult {
	s.MissingContextValues = v
	return s
}

// SetOrganizationsDecisionDetail sets the OrganizationsDecisionDetail field's value.
func (s *EvaluationResult) SetOrganizationsDecisionDetail(v *OrganizationsDecisionDetail) *EvaluationResult {
	s.OrganizationsDecisionDetail = v
	return s
}

// SetResourceSpecificResults sets the ResourceSpecificResults field's value.
func (s *EvaluationResult) SetResourceSpecificResults(v []*ResourceSpecificResult) *EvaluationResult {
	s.ResourceSpecificResults = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReportInput
type GenerateCredentialReportInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GenerateCredentialReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateCredentialReportInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GenerateCredentialReport request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReportResponse
type GenerateCredentialReportOutput struct {
	_ struct{} `type:"structure"`

	// Information about the credential report.
	Description *string `type:"string"`

	// Information about the state of the credential report.
	State *string `type:"string" enum:"ReportStateType"`
}

// String returns the string representation
func (s GenerateCredentialReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateCredentialReportOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GenerateCredentialReportOutput) SetDescription(v string) *GenerateCredentialReportOutput {
	s.Description = &v
	return s
}

// SetState sets the State field's value.
func (s *GenerateCredentialReportOutput) SetState(v string) *GenerateCredentialReportOutput {
	s.State = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsedRequest
type GetAccessKeyLastUsedInput struct {
	_ struct{} `type:"structure"`

	// The identifier of an access key.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `min:"16" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessKeyLastUsedInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessKeyLastUsedInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessKeyLastUsedInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccessKeyLastUsedInput"}
	if s.AccessKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessKeyId"))
	}
	if s.AccessKeyId != nil && len(*s.AccessKeyId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("AccessKeyId", 16))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *GetAccessKeyLastUsedInput) SetAccessKeyId(v string) *GetAccessKeyLastUsedInput {
	s.AccessKeyId = &v
	return s
}

// Contains the response to a successful GetAccessKeyLastUsed request. It is
// also returned as a member of the AccessKeyMetaData structure returned by
// the ListAccessKeys action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsedResponse
type GetAccessKeyLastUsedOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the last time the access key was used.
	AccessKeyLastUsed *AccessKeyLastUsed `type:"structure"`

	// The name of the AWS IAM user that owns this access key.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetAccessKeyLastUsedOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccessKeyLastUsedOutput) GoString() string {
	return s.String()
}

// SetAccessKeyLastUsed sets the AccessKeyLastUsed field's value.
func (s *GetAccessKeyLastUsedOutput) SetAccessKeyLastUsed(v *AccessKeyLastUsed) *GetAccessKeyLastUsedOutput {
	s.AccessKeyLastUsed = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *GetAccessKeyLastUsedOutput) SetUserName(v string) *GetAccessKeyLastUsedOutput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetailsRequest
type GetAccountAuthorizationDetailsInput struct {
	_ struct{} `type:"structure"`

	// A list of entity types used to filter the results. Only the entities that
	// match the types you specify are included in the output. Use the value LocalManagedPolicy
	// to include customer managed policies.
	//
	// The format for this parameter is a comma-separated (if more than one) list
	// of strings. Each string value in the list must be one of the valid values
	// listed below.
	Filter []*string `type:"list"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GetAccountAuthorizationDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountAuthorizationDetailsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccountAuthorizationDetailsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAccountAuthorizationDetailsInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *GetAccountAuthorizationDetailsInput) SetFilter(v []*string) *GetAccountAuthorizationDetailsInput {
	s.Filter = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *GetAccountAuthorizationDetailsInput) SetMarker(v string) *GetAccountAuthorizationDetailsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *GetAccountAuthorizationDetailsInput) SetMaxItems(v int64) *GetAccountAuthorizationDetailsInput {
	s.MaxItems = &v
	return s
}

// Contains the response to a successful GetAccountAuthorizationDetails request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetailsResponse
type GetAccountAuthorizationDetailsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing information about IAM groups.
	GroupDetailList []*GroupDetail `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list containing information about managed policies.
	Policies []*ManagedPolicyDetail `type:"list"`

	// A list containing information about IAM roles.
	RoleDetailList []*RoleDetail `type:"list"`

	// A list containing information about IAM users.
	UserDetailList []*UserDetail `type:"list"`
}

// String returns the string representation
func (s GetAccountAuthorizationDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountAuthorizationDetailsOutput) GoString() string {
	return s.String()
}

// SetGroupDetailList sets the GroupDetailList field's value.
func (s *GetAccountAuthorizationDetailsOutput) SetGroupDetailList(v []*GroupDetail) *GetAccountAuthorizationDetailsOutput {
	s.GroupDetailList = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *GetAccountAuthorizationDetailsOutput) SetIsTruncated(v bool) *GetAccountAuthorizationDetailsOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *GetAccountAuthorizationDetailsOutput) SetMarker(v string) *GetAccountAuthorizationDetailsOutput {
	s.Marker = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *GetAccountAuthorizationDetailsOutput) SetPolicies(v []*ManagedPolicyDetail) *GetAccountAuthorizationDetailsOutput {
	s.Policies = v
	return s
}

// SetRoleDetailList sets the RoleDetailList field's value.
func (s *GetAccountAuthorizationDetailsOutput) SetRoleDetailList(v []*RoleDetail) *GetAccountAuthorizationDetailsOutput {
	s.RoleDetailList = v
	return s
}

// SetUserDetailList sets the UserDetailList field's value.
func (s *GetAccountAuthorizationDetailsOutput) SetUserDetailList(v []*UserDetail) *GetAccountAuthorizationDetailsOutput {
	s.UserDetailList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicyInput
type GetAccountPasswordPolicyInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountPasswordPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountPasswordPolicyInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetAccountPasswordPolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicyResponse
type GetAccountPasswordPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the account password policy.
	//
	// PasswordPolicy is a required field
	PasswordPolicy *PasswordPolicy `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAccountPasswordPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountPasswordPolicyOutput) GoString() string {
	return s.String()
}

// SetPasswordPolicy sets the PasswordPolicy field's value.
func (s *GetAccountPasswordPolicyOutput) SetPasswordPolicy(v *PasswordPolicy) *GetAccountPasswordPolicyOutput {
	s.PasswordPolicy = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummaryInput
type GetAccountSummaryInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSummaryInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetAccountSummary request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummaryResponse
type GetAccountSummaryOutput struct {
	_ struct{} `type:"structure"`

	// A set of key value pairs containing information about IAM entity usage and
	// IAM quotas.
	SummaryMap map[string]*int64 `type:"map"`
}

// String returns the string representation
func (s GetAccountSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSummaryOutput) GoString() string {
	return s.String()
}

// SetSummaryMap sets the SummaryMap field's value.
func (s *GetAccountSummaryOutput) SetSummaryMap(v map[string]*int64) *GetAccountSummaryOutput {
	s.SummaryMap = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForCustomPolicyRequest
type GetContextKeysForCustomPolicyInput struct {
	_ struct{} `type:"structure"`

	// A list of policies for which you want the list of context keys referenced
	// in those policies. Each document is specified as a string containing the
	// complete, valid JSON text of an IAM policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// PolicyInputList is a required field
	PolicyInputList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetContextKeysForCustomPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContextKeysForCustomPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContextKeysForCustomPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContextKeysForCustomPolicyInput"}
	if s.PolicyInputList == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyInputList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyInputList sets the PolicyInputList field's value.
func (s *GetContextKeysForCustomPolicyInput) SetPolicyInputList(v []*string) *GetContextKeysForCustomPolicyInput {
	s.PolicyInputList = v
	return s
}

// Contains the response to a successful GetContextKeysForPrincipalPolicy or
// GetContextKeysForCustomPolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPolicyResponse
type GetContextKeysForPolicyResponse struct {
	_ struct{} `type:"structure"`

	// The list of context keys that are referenced in the input policies.
	ContextKeyNames []*string `type:"list"`
}

// String returns the string representation
func (s GetContextKeysForPolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContextKeysForPolicyResponse) GoString() string {
	return s.String()
}

// SetContextKeyNames sets the ContextKeyNames field's value.
func (s *GetContextKeysForPolicyResponse) SetContextKeyNames(v []*string) *GetContextKeysForPolicyResponse {
	s.ContextKeyNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPrincipalPolicyRequest
type GetContextKeysForPrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// An optional list of additional policies for which you want the list of context
	// keys that are referenced.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	PolicyInputList []*string `type:"list"`

	// The ARN of a user, group, or role whose policies contain the context keys
	// that you want listed. If you specify a user, the list includes context keys
	// that are found in all policies attached to the user as well as to all groups
	// that the user is a member of. If you pick a group or a role, then it includes
	// only those context keys that are found in policies attached to that entity.
	// Note that all parameters are shown in unencoded form here for clarity, but
	// must be URL encoded to be included as a part of a real HTML request.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicySourceArn is a required field
	PolicySourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetContextKeysForPrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetContextKeysForPrincipalPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContextKeysForPrincipalPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetContextKeysForPrincipalPolicyInput"}
	if s.PolicySourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicySourceArn"))
	}
	if s.PolicySourceArn != nil && len(*s.PolicySourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicySourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyInputList sets the PolicyInputList field's value.
func (s *GetContextKeysForPrincipalPolicyInput) SetPolicyInputList(v []*string) *GetContextKeysForPrincipalPolicyInput {
	s.PolicyInputList = v
	return s
}

// SetPolicySourceArn sets the PolicySourceArn field's value.
func (s *GetContextKeysForPrincipalPolicyInput) SetPolicySourceArn(v string) *GetContextKeysForPrincipalPolicyInput {
	s.PolicySourceArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReportInput
type GetCredentialReportInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetCredentialReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCredentialReportInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetCredentialReport request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReportResponse
type GetCredentialReportOutput struct {
	_ struct{} `type:"structure"`

	// Contains the credential report. The report is Base64-encoded.
	//
	// Content is automatically base64 encoded/decoded by the SDK.
	Content []byte `type:"blob"`

	// The date and time when the credential report was created, in ISO 8601 date-time
	// format (http://www.iso.org/iso/iso8601).
	GeneratedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The format (MIME type) of the credential report.
	ReportFormat *string `type:"string" enum:"ReportFormatType"`
}

// String returns the string representation
func (s GetCredentialReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCredentialReportOutput) GoString() string {
	return s.String()
}

// SetContent sets the Content field's value.
func (s *GetCredentialReportOutput) SetContent(v []byte) *GetCredentialReportOutput {
	s.Content = v
	return s
}

// SetGeneratedTime sets the GeneratedTime field's value.
func (s *GetCredentialReportOutput) SetGeneratedTime(v time.Time) *GetCredentialReportOutput {
	s.GeneratedTime = &v
	return s
}

// SetReportFormat sets the ReportFormat field's value.
func (s *GetCredentialReportOutput) SetReportFormat(v string) *GetCredentialReportOutput {
	s.ReportFormat = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupRequest
type GetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupInput) SetGroupName(v string) *GetGroupInput {
	s.GroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *GetGroupInput) SetMarker(v string) *GetGroupInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *GetGroupInput) SetMaxItems(v int64) *GetGroupInput {
	s.MaxItems = &v
	return s
}

// Contains the response to a successful GetGroup request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupResponse
type GetGroupOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the group.
	//
	// Group is a required field
	Group *Group `type:"structure" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of users in the group.
	//
	// Users is a required field
	Users []*User `type:"list" required:"true"`
}

// String returns the string representation
func (s GetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupOutput) GoString() string {
	return s.String()
}

// SetGroup sets the Group field's value.
func (s *GetGroupOutput) SetGroup(v *Group) *GetGroupOutput {
	s.Group = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *GetGroupOutput) SetIsTruncated(v bool) *GetGroupOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *GetGroupOutput) SetMarker(v string) *GetGroupOutput {
	s.Marker = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *GetGroupOutput) SetUsers(v []*User) *GetGroupOutput {
	s.Users = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicyRequest
type GetGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the group the policy is associated with.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name of the policy document to get.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGroupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGroupPolicyInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupPolicyInput) SetGroupName(v string) *GetGroupPolicyInput {
	s.GroupName = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetGroupPolicyInput) SetPolicyName(v string) *GetGroupPolicyInput {
	s.PolicyName = &v
	return s
}

// Contains the response to a successful GetGroupPolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicyResponse
type GetGroupPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The group the policy is associated with.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The policy document.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGroupPolicyOutput) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *GetGroupPolicyOutput) SetGroupName(v string) *GetGroupPolicyOutput {
	s.GroupName = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *GetGroupPolicyOutput) SetPolicyDocument(v string) *GetGroupPolicyOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetGroupPolicyOutput) SetPolicyName(v string) *GetGroupPolicyOutput {
	s.PolicyName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfileRequest
type GetInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to get information about.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceProfileInput"}
	if s.InstanceProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *GetInstanceProfileInput) SetInstanceProfileName(v string) *GetInstanceProfileInput {
	s.InstanceProfileName = &v
	return s
}

// Contains the response to a successful GetInstanceProfile request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfileResponse
type GetInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the instance profile.
	//
	// InstanceProfile is a required field
	InstanceProfile *InstanceProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceProfileOutput) GoString() string {
	return s.String()
}

// SetInstanceProfile sets the InstanceProfile field's value.
func (s *GetInstanceProfileOutput) SetInstanceProfile(v *InstanceProfile) *GetInstanceProfileOutput {
	s.InstanceProfile = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfileRequest
type GetLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the user whose login profile you want to retrieve.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoginProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoginProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoginProfileInput"}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserName sets the UserName field's value.
func (s *GetLoginProfileInput) SetUserName(v string) *GetLoginProfileInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful GetLoginProfile request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfileResponse
type GetLoginProfileOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing the user name and password create date for the user.
	//
	// LoginProfile is a required field
	LoginProfile *LoginProfile `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoginProfileOutput) GoString() string {
	return s.String()
}

// SetLoginProfile sets the LoginProfile field's value.
func (s *GetLoginProfileOutput) SetLoginProfile(v *LoginProfile) *GetLoginProfileOutput {
	s.LoginProfile = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProviderRequest
type GetOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the OIDC provider resource object in IAM
	// to get information for. You can get a list of OIDC provider resource ARNs
	// by using the ListOpenIDConnectProviders action.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// OpenIDConnectProviderArn is a required field
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOpenIDConnectProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOpenIDConnectProviderInput"}
	if s.OpenIDConnectProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OpenIDConnectProviderArn"))
	}
	if s.OpenIDConnectProviderArn != nil && len(*s.OpenIDConnectProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OpenIDConnectProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOpenIDConnectProviderArn sets the OpenIDConnectProviderArn field's value.
func (s *GetOpenIDConnectProviderInput) SetOpenIDConnectProviderArn(v string) *GetOpenIDConnectProviderInput {
	s.OpenIDConnectProviderArn = &v
	return s
}

// Contains the response to a successful GetOpenIDConnectProvider request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProviderResponse
type GetOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`

	// A list of client IDs (also known as audiences) that are associated with the
	// specified IAM OIDC provider resource object. For more information, see CreateOpenIDConnectProvider.
	ClientIDList []*string `type:"list"`

	// The date and time when the IAM OIDC provider resource object was created
	// in the AWS account.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of certificate thumbprints that are associated with the specified
	// IAM OIDC provider resource object. For more information, see CreateOpenIDConnectProvider.
	ThumbprintList []*string `type:"list"`

	// The URL that the IAM OIDC provider resource object is associated with. For
	// more information, see CreateOpenIDConnectProvider.
	Url *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

// SetClientIDList sets the ClientIDList field's value.
func (s *GetOpenIDConnectProviderOutput) SetClientIDList(v []*string) *GetOpenIDConnectProviderOutput {
	s.ClientIDList = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *GetOpenIDConnectProviderOutput) SetCreateDate(v time.Time) *GetOpenIDConnectProviderOutput {
	s.CreateDate = &v
	return s
}

// SetThumbprintList sets the ThumbprintList field's value.
func (s *GetOpenIDConnectProviderOutput) SetThumbprintList(v []*string) *GetOpenIDConnectProviderOutput {
	s.ThumbprintList = v
	return s
}

// SetUrl sets the Url field's value.
func (s *GetOpenIDConnectProviderOutput) SetUrl(v string) *GetOpenIDConnectProviderOutput {
	s.Url = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyRequest
type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the managed policy that you want information
	// about.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *GetPolicyInput) SetPolicyArn(v string) *GetPolicyInput {
	s.PolicyArn = &v
	return s
}

// Contains the response to a successful GetPolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyResponse
type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the policy.
	Policy *Policy `type:"structure"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetPolicyOutput) SetPolicy(v *Policy) *GetPolicyOutput {
	s.Policy = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersionRequest
type GetPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the managed policy that you want information
	// about.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// Identifies the policy version to retrieve.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that consists of the lowercase letter 'v' followed
	// by one or two digits, and optionally followed by a period '.' and a string
	// of letters and digits.
	//
	// VersionId is a required field
	VersionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyVersionInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *GetPolicyVersionInput) SetPolicyArn(v string) *GetPolicyVersionInput {
	s.PolicyArn = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetPolicyVersionInput) SetVersionId(v string) *GetPolicyVersionInput {
	s.VersionId = &v
	return s
}

// Contains the response to a successful GetPolicyVersion request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersionResponse
type GetPolicyVersionOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the policy version.
	PolicyVersion *PolicyVersion `type:"structure"`
}

// String returns the string representation
func (s GetPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyVersionOutput) GoString() string {
	return s.String()
}

// SetPolicyVersion sets the PolicyVersion field's value.
func (s *GetPolicyVersionOutput) SetPolicyVersion(v *PolicyVersion) *GetPolicyVersionOutput {
	s.PolicyVersion = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRoleRequest
type GetRoleInput struct {
	_ struct{} `type:"structure"`

	// The name of the IAM role to get information about.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRoleInput"}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleName sets the RoleName field's value.
func (s *GetRoleInput) SetRoleName(v string) *GetRoleInput {
	s.RoleName = &v
	return s
}

// Contains the response to a successful GetRole request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRoleResponse
type GetRoleOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the IAM role.
	//
	// Role is a required field
	Role *Role `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRoleOutput) GoString() string {
	return s.String()
}

// SetRole sets the Role field's value.
func (s *GetRoleOutput) SetRole(v *Role) *GetRoleOutput {
	s.Role = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicyRequest
type GetRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy document to get.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the role associated with the policy.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRolePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRolePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRolePolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetRolePolicyInput) SetPolicyName(v string) *GetRolePolicyInput {
	s.PolicyName = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *GetRolePolicyInput) SetRoleName(v string) *GetRolePolicyInput {
	s.RoleName = &v
	return s
}

// Contains the response to a successful GetRolePolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicyResponse
type GetRolePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The role the policy is associated with.
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRolePolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *GetRolePolicyOutput) SetPolicyDocument(v string) *GetRolePolicyOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetRolePolicyOutput) SetPolicyName(v string) *GetRolePolicyOutput {
	s.PolicyName = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *GetRolePolicyOutput) SetRoleName(v string) *GetRolePolicyOutput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProviderRequest
type GetSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider resource object in IAM
	// to get information about.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// SAMLProviderArn is a required field
	SAMLProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSAMLProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSAMLProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSAMLProviderInput"}
	if s.SAMLProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SAMLProviderArn"))
	}
	if s.SAMLProviderArn != nil && len(*s.SAMLProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SAMLProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSAMLProviderArn sets the SAMLProviderArn field's value.
func (s *GetSAMLProviderInput) SetSAMLProviderArn(v string) *GetSAMLProviderInput {
	s.SAMLProviderArn = &v
	return s
}

// Contains the response to a successful GetSAMLProvider request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProviderResponse
type GetSAMLProviderOutput struct {
	_ struct{} `type:"structure"`

	// The date and time when the SAML provider was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The XML metadata document that includes information about an identity provider.
	SAMLMetadataDocument *string `min:"1000" type:"string"`

	// The expiration date and time for the SAML provider.
	ValidUntil *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s GetSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSAMLProviderOutput) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *GetSAMLProviderOutput) SetCreateDate(v time.Time) *GetSAMLProviderOutput {
	s.CreateDate = &v
	return s
}

// SetSAMLMetadataDocument sets the SAMLMetadataDocument field's value.
func (s *GetSAMLProviderOutput) SetSAMLMetadataDocument(v string) *GetSAMLProviderOutput {
	s.SAMLMetadataDocument = &v
	return s
}

// SetValidUntil sets the ValidUntil field's value.
func (s *GetSAMLProviderOutput) SetValidUntil(v time.Time) *GetSAMLProviderOutput {
	s.ValidUntil = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKeyRequest
type GetSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// Specifies the public key encoding format to use in the response. To retrieve
	// the public key in ssh-rsa format, use SSH. To retrieve the public key in
	// PEM format, use PEM.
	//
	// Encoding is a required field
	Encoding *string `type:"string" required:"true" enum:"encodingType"`

	// The unique identifier for the SSH public key.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// SSHPublicKeyId is a required field
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The name of the IAM user associated with the SSH public key.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSSHPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSSHPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSSHPublicKeyInput"}
	if s.Encoding == nil {
		invalidParams.Add(request.NewErrParamRequired("Encoding"))
	}
	if s.SSHPublicKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("SSHPublicKeyId"))
	}
	if s.SSHPublicKeyId != nil && len(*s.SSHPublicKeyId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SSHPublicKeyId", 20))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncoding sets the Encoding field's value.
func (s *GetSSHPublicKeyInput) SetEncoding(v string) *GetSSHPublicKeyInput {
	s.Encoding = &v
	return s
}

// SetSSHPublicKeyId sets the SSHPublicKeyId field's value.
func (s *GetSSHPublicKeyInput) SetSSHPublicKeyId(v string) *GetSSHPublicKeyInput {
	s.SSHPublicKeyId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *GetSSHPublicKeyInput) SetUserName(v string) *GetSSHPublicKeyInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful GetSSHPublicKey request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKeyResponse
type GetSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the SSH public key.
	SSHPublicKey *SSHPublicKey `type:"structure"`
}

// String returns the string representation
func (s GetSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSSHPublicKeyOutput) GoString() string {
	return s.String()
}

// SetSSHPublicKey sets the SSHPublicKey field's value.
func (s *GetSSHPublicKeyOutput) SetSSHPublicKey(v *SSHPublicKey) *GetSSHPublicKeyOutput {
	s.SSHPublicKey = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificateRequest
type GetServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The name of the server certificate you want to retrieve information about.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// ServerCertificateName is a required field
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServerCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServerCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServerCertificateInput"}
	if s.ServerCertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerCertificateName"))
	}
	if s.ServerCertificateName != nil && len(*s.ServerCertificateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerCertificateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerCertificateName sets the ServerCertificateName field's value.
func (s *GetServerCertificateInput) SetServerCertificateName(v string) *GetServerCertificateInput {
	s.ServerCertificateName = &v
	return s
}

// Contains the response to a successful GetServerCertificate request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificateResponse
type GetServerCertificateOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the server certificate.
	//
	// ServerCertificate is a required field
	ServerCertificate *ServerCertificate `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServerCertificateOutput) GoString() string {
	return s.String()
}

// SetServerCertificate sets the ServerCertificate field's value.
func (s *GetServerCertificateOutput) SetServerCertificate(v *ServerCertificate) *GetServerCertificateOutput {
	s.ServerCertificate = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserRequest
type GetUserInput struct {
	_ struct{} `type:"structure"`

	// The name of the user to get information about.
	//
	// This parameter is optional. If it is not included, it defaults to the user
	// making the request. This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserInput"}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUserName sets the UserName field's value.
func (s *GetUserInput) SetUserName(v string) *GetUserInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful GetUser request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserResponse
type GetUserOutput struct {
	_ struct{} `type:"structure"`

	// A structure containing details about the IAM user.
	//
	// User is a required field
	User *User `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserOutput) GoString() string {
	return s.String()
}

// SetUser sets the User field's value.
func (s *GetUserOutput) SetUser(v *User) *GetUserOutput {
	s.User = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicyRequest
type GetUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the policy document to get.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the user who the policy is associated with.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUserPolicyInput"}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetUserPolicyInput) SetPolicyName(v string) *GetUserPolicyInput {
	s.PolicyName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *GetUserPolicyInput) SetUserName(v string) *GetUserPolicyInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful GetUserPolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicyResponse
type GetUserPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The user the policy is associated with.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUserPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *GetUserPolicyOutput) SetPolicyDocument(v string) *GetUserPolicyOutput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *GetUserPolicyOutput) SetPolicyName(v string) *GetUserPolicyOutput {
	s.PolicyName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *GetUserPolicyOutput) SetUserName(v string) *GetUserPolicyOutput {
	s.UserName = &v
	return s
}

// Contains information about an IAM group entity.
//
// This data type is used as a response element in the following actions:
//
//    * CreateGroup
//
//    * GetGroup
//
//    * ListGroups
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Group
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the group. For more information
	// about ARNs and how to use them in policies, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the group was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The stable and unique string identifying the group. For more information
	// about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// GroupId is a required field
	GroupId *string `min:"16" type:"string" required:"true"`

	// The friendly name that identifies the group.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The path to the group. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Group) SetArn(v string) *Group {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Group) SetCreateDate(v time.Time) *Group {
	s.CreateDate = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *Group) SetGroupId(v string) *Group {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *Group) SetGroupName(v string) *Group {
	s.GroupName = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Group) SetPath(v string) *Group {
	s.Path = &v
	return s
}

// Contains information about an IAM group, including all of the group's policies.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GroupDetail
type GroupDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// A list of the managed policies attached to the group.
	AttachedManagedPolicies []*AttachedPolicy `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the group was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The stable and unique string identifying the group. For more information
	// about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	GroupId *string `min:"16" type:"string"`

	// The friendly name that identifies the group.
	GroupName *string `min:"1" type:"string"`

	// A list of the inline policies embedded in the group.
	GroupPolicyList []*PolicyDetail `type:"list"`

	// The path to the group. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GroupDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GroupDetail) SetArn(v string) *GroupDetail {
	s.Arn = &v
	return s
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *GroupDetail) SetAttachedManagedPolicies(v []*AttachedPolicy) *GroupDetail {
	s.AttachedManagedPolicies = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *GroupDetail) SetCreateDate(v time.Time) *GroupDetail {
	s.CreateDate = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *GroupDetail) SetGroupId(v string) *GroupDetail {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GroupDetail) SetGroupName(v string) *GroupDetail {
	s.GroupName = &v
	return s
}

// SetGroupPolicyList sets the GroupPolicyList field's value.
func (s *GroupDetail) SetGroupPolicyList(v []*PolicyDetail) *GroupDetail {
	s.GroupPolicyList = v
	return s
}

// SetPath sets the Path field's value.
func (s *GroupDetail) SetPath(v string) *GroupDetail {
	s.Path = &v
	return s
}

// Contains information about an instance profile.
//
// This data type is used as a response element in the following actions:
//
//    * CreateInstanceProfile
//
//    * GetInstanceProfile
//
//    * ListInstanceProfiles
//
//    * ListInstanceProfilesForRole
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/InstanceProfile
type InstanceProfile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the instance profile. For more
	// information about ARNs and how to use them in policies, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The date when the instance profile was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The stable and unique string identifying the instance profile. For more information
	// about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// InstanceProfileId is a required field
	InstanceProfileId *string `min:"16" type:"string" required:"true"`

	// The name identifying the instance profile.
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The path to the instance profile. For more information about paths, see IAM
	// Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// The role associated with the instance profile.
	//
	// Roles is a required field
	Roles []*Role `type:"list" required:"true"`
}

// String returns the string representation
func (s InstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceProfile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InstanceProfile) SetArn(v string) *InstanceProfile {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *InstanceProfile) SetCreateDate(v time.Time) *InstanceProfile {
	s.CreateDate = &v
	return s
}

// SetInstanceProfileId sets the InstanceProfileId field's value.
func (s *InstanceProfile) SetInstanceProfileId(v string) *InstanceProfile {
	s.InstanceProfileId = &v
	return s
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *InstanceProfile) SetInstanceProfileName(v string) *InstanceProfile {
	s.InstanceProfileName = &v
	return s
}

// SetPath sets the Path field's value.
func (s *InstanceProfile) SetPath(v string) *InstanceProfile {
	s.Path = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *InstanceProfile) SetRoles(v []*Role) *InstanceProfile {
	s.Roles = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeysRequest
type ListAccessKeysInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessKeysInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListAccessKeysInput) SetMarker(v string) *ListAccessKeysInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListAccessKeysInput) SetMaxItems(v int64) *ListAccessKeysInput {
	s.MaxItems = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListAccessKeysInput) SetUserName(v string) *ListAccessKeysInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful ListAccessKeys request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeysResponse
type ListAccessKeysOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing metadata about the access keys.
	//
	// AccessKeyMetadata is a required field
	AccessKeyMetadata []*AccessKeyMetadata `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccessKeysOutput) GoString() string {
	return s.String()
}

// SetAccessKeyMetadata sets the AccessKeyMetadata field's value.
func (s *ListAccessKeysOutput) SetAccessKeyMetadata(v []*AccessKeyMetadata) *ListAccessKeysOutput {
	s.AccessKeyMetadata = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListAccessKeysOutput) SetIsTruncated(v bool) *ListAccessKeysOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAccessKeysOutput) SetMarker(v string) *ListAccessKeysOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliasesRequest
type ListAccountAliasesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListAccountAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAliasesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListAccountAliasesInput) SetMarker(v string) *ListAccountAliasesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListAccountAliasesInput) SetMaxItems(v int64) *ListAccountAliasesInput {
	s.MaxItems = &v
	return s
}

// Contains the response to a successful ListAccountAliases request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliasesResponse
type ListAccountAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of aliases associated with the account. AWS supports only one alias
	// per account.
	//
	// AccountAliases is a required field
	AccountAliases []*string `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccountAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountAliasesOutput) GoString() string {
	return s.String()
}

// SetAccountAliases sets the AccountAliases field's value.
func (s *ListAccountAliasesOutput) SetAccountAliases(v []*string) *ListAccountAliasesOutput {
	s.AccountAliases = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListAccountAliasesOutput) SetIsTruncated(v bool) *ListAccountAliasesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAccountAliasesOutput) SetMarker(v string) *ListAccountAliasesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPoliciesRequest
type ListAttachedGroupPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name (friendly name, not ARN) of the group to list attached policies
	// for.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all policies.
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	PathPrefix *string `type:"string"`
}

// String returns the string representation
func (s ListAttachedGroupPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedGroupPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttachedGroupPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttachedGroupPoliciesInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *ListAttachedGroupPoliciesInput) SetGroupName(v string) *ListAttachedGroupPoliciesInput {
	s.GroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAttachedGroupPoliciesInput) SetMarker(v string) *ListAttachedGroupPoliciesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListAttachedGroupPoliciesInput) SetMaxItems(v int64) *ListAttachedGroupPoliciesInput {
	s.MaxItems = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListAttachedGroupPoliciesInput) SetPathPrefix(v string) *ListAttachedGroupPoliciesInput {
	s.PathPrefix = &v
	return s
}

// Contains the response to a successful ListAttachedGroupPolicies request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPoliciesResponse
type ListAttachedGroupPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the attached policies.
	AttachedPolicies []*AttachedPolicy `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAttachedGroupPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedGroupPoliciesOutput) GoString() string {
	return s.String()
}

// SetAttachedPolicies sets the AttachedPolicies field's value.
func (s *ListAttachedGroupPoliciesOutput) SetAttachedPolicies(v []*AttachedPolicy) *ListAttachedGroupPoliciesOutput {
	s.AttachedPolicies = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListAttachedGroupPoliciesOutput) SetIsTruncated(v bool) *ListAttachedGroupPoliciesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAttachedGroupPoliciesOutput) SetMarker(v string) *ListAttachedGroupPoliciesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePoliciesRequest
type ListAttachedRolePoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all policies.
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	PathPrefix *string `type:"string"`

	// The name (friendly name, not ARN) of the role to list attached policies for.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAttachedRolePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedRolePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttachedRolePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttachedRolePoliciesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListAttachedRolePoliciesInput) SetMarker(v string) *ListAttachedRolePoliciesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListAttachedRolePoliciesInput) SetMaxItems(v int64) *ListAttachedRolePoliciesInput {
	s.MaxItems = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListAttachedRolePoliciesInput) SetPathPrefix(v string) *ListAttachedRolePoliciesInput {
	s.PathPrefix = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *ListAttachedRolePoliciesInput) SetRoleName(v string) *ListAttachedRolePoliciesInput {
	s.RoleName = &v
	return s
}

// Contains the response to a successful ListAttachedRolePolicies request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePoliciesResponse
type ListAttachedRolePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the attached policies.
	AttachedPolicies []*AttachedPolicy `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAttachedRolePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedRolePoliciesOutput) GoString() string {
	return s.String()
}

// SetAttachedPolicies sets the AttachedPolicies field's value.
func (s *ListAttachedRolePoliciesOutput) SetAttachedPolicies(v []*AttachedPolicy) *ListAttachedRolePoliciesOutput {
	s.AttachedPolicies = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListAttachedRolePoliciesOutput) SetIsTruncated(v bool) *ListAttachedRolePoliciesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAttachedRolePoliciesOutput) SetMarker(v string) *ListAttachedRolePoliciesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPoliciesRequest
type ListAttachedUserPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all policies.
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	PathPrefix *string `type:"string"`

	// The name (friendly name, not ARN) of the user to list attached policies for.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAttachedUserPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedUserPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttachedUserPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttachedUserPoliciesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListAttachedUserPoliciesInput) SetMarker(v string) *ListAttachedUserPoliciesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListAttachedUserPoliciesInput) SetMaxItems(v int64) *ListAttachedUserPoliciesInput {
	s.MaxItems = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListAttachedUserPoliciesInput) SetPathPrefix(v string) *ListAttachedUserPoliciesInput {
	s.PathPrefix = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListAttachedUserPoliciesInput) SetUserName(v string) *ListAttachedUserPoliciesInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful ListAttachedUserPolicies request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPoliciesResponse
type ListAttachedUserPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the attached policies.
	AttachedPolicies []*AttachedPolicy `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAttachedUserPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAttachedUserPoliciesOutput) GoString() string {
	return s.String()
}

// SetAttachedPolicies sets the AttachedPolicies field's value.
func (s *ListAttachedUserPoliciesOutput) SetAttachedPolicies(v []*AttachedPolicy) *ListAttachedUserPoliciesOutput {
	s.AttachedPolicies = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListAttachedUserPoliciesOutput) SetIsTruncated(v bool) *ListAttachedUserPoliciesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAttachedUserPoliciesOutput) SetMarker(v string) *ListAttachedUserPoliciesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicyRequest
type ListEntitiesForPolicyInput struct {
	_ struct{} `type:"structure"`

	// The entity type to use for filtering the results.
	//
	// For example, when EntityFilter is Role, only the roles that are attached
	// to the specified policy are returned. This parameter is optional. If it is
	// not included, all attached entities (users, groups, and roles) are returned.
	// The argument for this parameter must be one of the valid values listed below.
	EntityFilter *string `type:"string" enum:"EntityType"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all entities.
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	PathPrefix *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM policy for which you want the versions.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListEntitiesForPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesForPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesForPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesForPolicyInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.PathPrefix != nil && len(*s.PathPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathPrefix", 1))
	}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityFilter sets the EntityFilter field's value.
func (s *ListEntitiesForPolicyInput) SetEntityFilter(v string) *ListEntitiesForPolicyInput {
	s.EntityFilter = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListEntitiesForPolicyInput) SetMarker(v string) *ListEntitiesForPolicyInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListEntitiesForPolicyInput) SetMaxItems(v int64) *ListEntitiesForPolicyInput {
	s.MaxItems = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListEntitiesForPolicyInput) SetPathPrefix(v string) *ListEntitiesForPolicyInput {
	s.PathPrefix = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *ListEntitiesForPolicyInput) SetPolicyArn(v string) *ListEntitiesForPolicyInput {
	s.PolicyArn = &v
	return s
}

// Contains the response to a successful ListEntitiesForPolicy request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicyResponse
type ListEntitiesForPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of IAM groups that the policy is attached to.
	PolicyGroups []*PolicyGroup `type:"list"`

	// A list of IAM roles that the policy is attached to.
	PolicyRoles []*PolicyRole `type:"list"`

	// A list of IAM users that the policy is attached to.
	PolicyUsers []*PolicyUser `type:"list"`
}

// String returns the string representation
func (s ListEntitiesForPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesForPolicyOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListEntitiesForPolicyOutput) SetIsTruncated(v bool) *ListEntitiesForPolicyOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListEntitiesForPolicyOutput) SetMarker(v string) *ListEntitiesForPolicyOutput {
	s.Marker = &v
	return s
}

// SetPolicyGroups sets the PolicyGroups field's value.
func (s *ListEntitiesForPolicyOutput) SetPolicyGroups(v []*PolicyGroup) *ListEntitiesForPolicyOutput {
	s.PolicyGroups = v
	return s
}

// SetPolicyRoles sets the PolicyRoles field's value.
func (s *ListEntitiesForPolicyOutput) SetPolicyRoles(v []*PolicyRole) *ListEntitiesForPolicyOutput {
	s.PolicyRoles = v
	return s
}

// SetPolicyUsers sets the PolicyUsers field's value.
func (s *ListEntitiesForPolicyOutput) SetPolicyUsers(v []*PolicyUser) *ListEntitiesForPolicyOutput {
	s.PolicyUsers = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPoliciesRequest
type ListGroupPoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to list policies for.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListGroupPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupPoliciesInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *ListGroupPoliciesInput) SetGroupName(v string) *ListGroupPoliciesInput {
	s.GroupName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListGroupPoliciesInput) SetMarker(v string) *ListGroupPoliciesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListGroupPoliciesInput) SetMaxItems(v int64) *ListGroupPoliciesInput {
	s.MaxItems = &v
	return s
}

// Contains the response to a successful ListGroupPolicies request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPoliciesResponse
type ListGroupPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policy names.
	//
	// PolicyNames is a required field
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListGroupPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupPoliciesOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListGroupPoliciesOutput) SetIsTruncated(v bool) *ListGroupPoliciesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListGroupPoliciesOutput) SetMarker(v string) *ListGroupPoliciesOutput {
	s.Marker = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *ListGroupPoliciesOutput) SetPolicyNames(v []*string) *ListGroupPoliciesOutput {
	s.PolicyNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUserRequest
type ListGroupsForUserInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user to list groups for.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListGroupsForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsForUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsForUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsForUserInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListGroupsForUserInput) SetMarker(v string) *ListGroupsForUserInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListGroupsForUserInput) SetMaxItems(v int64) *ListGroupsForUserInput {
	s.MaxItems = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListGroupsForUserInput) SetUserName(v string) *ListGroupsForUserInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful ListGroupsForUser request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUserResponse
type ListGroupsForUserOutput struct {
	_ struct{} `type:"structure"`

	// A list of groups.
	//
	// Groups is a required field
	Groups []*Group `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupsForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsForUserOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsForUserOutput) SetGroups(v []*Group) *ListGroupsForUserOutput {
	s.Groups = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListGroupsForUserOutput) SetIsTruncated(v bool) *ListGroupsForUserOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListGroupsForUserOutput) SetMarker(v string) *ListGroupsForUserOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsRequest
type ListGroupsInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example, the prefix /division_abc/subdivision_xyz/
	// gets all groups whose path starts with /division_abc/subdivision_xyz/.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all groups. This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupsInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.PathPrefix != nil && len(*s.PathPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListGroupsInput) SetMarker(v string) *ListGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListGroupsInput) SetMaxItems(v int64) *ListGroupsInput {
	s.MaxItems = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListGroupsInput) SetPathPrefix(v string) *ListGroupsInput {
	s.PathPrefix = &v
	return s
}

// Contains the response to a successful ListGroups request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsResponse
type ListGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of groups.
	//
	// Groups is a required field
	Groups []*Group `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListGroupsOutput) SetGroups(v []*Group) *ListGroupsOutput {
	s.Groups = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListGroupsOutput) SetIsTruncated(v bool) *ListGroupsOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListGroupsOutput) SetMarker(v string) *ListGroupsOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRoleRequest
type ListInstanceProfilesForRoleInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the role to list instance profiles for.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListInstanceProfilesForRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceProfilesForRoleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceProfilesForRoleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstanceProfilesForRoleInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListInstanceProfilesForRoleInput) SetMarker(v string) *ListInstanceProfilesForRoleInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListInstanceProfilesForRoleInput) SetMaxItems(v int64) *ListInstanceProfilesForRoleInput {
	s.MaxItems = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *ListInstanceProfilesForRoleInput) SetRoleName(v string) *ListInstanceProfilesForRoleInput {
	s.RoleName = &v
	return s
}

// Contains the response to a successful ListInstanceProfilesForRole request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRoleResponse
type ListInstanceProfilesForRoleOutput struct {
	_ struct{} `type:"structure"`

	// A list of instance profiles.
	//
	// InstanceProfiles is a required field
	InstanceProfiles []*InstanceProfile `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListInstanceProfilesForRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceProfilesForRoleOutput) GoString() string {
	return s.String()
}

// SetInstanceProfiles sets the InstanceProfiles field's value.
func (s *ListInstanceProfilesForRoleOutput) SetInstanceProfiles(v []*InstanceProfile) *ListInstanceProfilesForRoleOutput {
	s.InstanceProfiles = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListInstanceProfilesForRoleOutput) SetIsTruncated(v bool) *ListInstanceProfilesForRoleOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInstanceProfilesForRoleOutput) SetMarker(v string) *ListInstanceProfilesForRoleOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesRequest
type ListInstanceProfilesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example, the prefix /application_abc/component_xyz/
	// gets all instance profiles whose path starts with /application_abc/component_xyz/.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all instance profiles. This paramater allows (per its regex
	// pattern (http://wikipedia.org/wiki/regex)) a string of characters consisting
	// of either a forward slash (/) by itself or a string that must begin and end
	// with forward slashes, containing any ASCII character from the ! (\u0021)
	// thru the DEL character (\u007F), including most punctuation characters, digits,
	// and upper and lowercased letters.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListInstanceProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstanceProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstanceProfilesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.PathPrefix != nil && len(*s.PathPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListInstanceProfilesInput) SetMarker(v string) *ListInstanceProfilesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListInstanceProfilesInput) SetMaxItems(v int64) *ListInstanceProfilesInput {
	s.MaxItems = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListInstanceProfilesInput) SetPathPrefix(v string) *ListInstanceProfilesInput {
	s.PathPrefix = &v
	return s
}

// Contains the response to a successful ListInstanceProfiles request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesResponse
type ListInstanceProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A list of instance profiles.
	//
	// InstanceProfiles is a required field
	InstanceProfiles []*InstanceProfile `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListInstanceProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceProfilesOutput) GoString() string {
	return s.String()
}

// SetInstanceProfiles sets the InstanceProfiles field's value.
func (s *ListInstanceProfilesOutput) SetInstanceProfiles(v []*InstanceProfile) *ListInstanceProfilesOutput {
	s.InstanceProfiles = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListInstanceProfilesOutput) SetIsTruncated(v bool) *ListInstanceProfilesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListInstanceProfilesOutput) SetMarker(v string) *ListInstanceProfilesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevicesRequest
type ListMFADevicesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user whose MFA devices you want to list.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMFADevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMFADevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMFADevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMFADevicesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListMFADevicesInput) SetMarker(v string) *ListMFADevicesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListMFADevicesInput) SetMaxItems(v int64) *ListMFADevicesInput {
	s.MaxItems = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListMFADevicesInput) SetUserName(v string) *ListMFADevicesInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful ListMFADevices request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevicesResponse
type ListMFADevicesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// A list of MFA devices.
	//
	// MFADevices is a required field
	MFADevices []*MFADevice `type:"list" required:"true"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListMFADevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMFADevicesOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListMFADevicesOutput) SetIsTruncated(v bool) *ListMFADevicesOutput {
	s.IsTruncated = &v
	return s
}

// SetMFADevices sets the MFADevices field's value.
func (s *ListMFADevicesOutput) SetMFADevices(v []*MFADevice) *ListMFADevicesOutput {
	s.MFADevices = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListMFADevicesOutput) SetMarker(v string) *ListMFADevicesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProvidersRequest
type ListOpenIDConnectProvidersInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListOpenIDConnectProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOpenIDConnectProvidersInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListOpenIDConnectProviders request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProvidersResponse
type ListOpenIDConnectProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The list of IAM OIDC provider resource objects defined in the AWS account.
	OpenIDConnectProviderList []*OpenIDConnectProviderListEntry `type:"list"`
}

// String returns the string representation
func (s ListOpenIDConnectProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOpenIDConnectProvidersOutput) GoString() string {
	return s.String()
}

// SetOpenIDConnectProviderList sets the OpenIDConnectProviderList field's value.
func (s *ListOpenIDConnectProvidersOutput) SetOpenIDConnectProviderList(v []*OpenIDConnectProviderListEntry) *ListOpenIDConnectProvidersOutput {
	s.OpenIDConnectProviderList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesRequest
type ListPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// A flag to filter the results to only the attached policies.
	//
	// When OnlyAttached is true, the returned list contains only the policies that
	// are attached to an IAM user, group, or role. When OnlyAttached is false,
	// or when the parameter is not included, all policies are returned.
	OnlyAttached *bool `type:"boolean"`

	// The path prefix for filtering the results. This parameter is optional. If
	// it is not included, it defaults to a slash (/), listing all policies. This
	// paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	PathPrefix *string `type:"string"`

	// The scope to use for filtering the results.
	//
	// To list only AWS managed policies, set Scope to AWS. To list only the customer
	// managed policies in your AWS account, set Scope to Local.
	//
	// This parameter is optional. If it is not included, or if it is set to All,
	// all policies are returned.
	Scope *string `type:"string" enum:"policyScopeType"`
}

// String returns the string representation
func (s ListPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoliciesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListPoliciesInput) SetMarker(v string) *ListPoliciesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListPoliciesInput) SetMaxItems(v int64) *ListPoliciesInput {
	s.MaxItems = &v
	return s
}

// SetOnlyAttached sets the OnlyAttached field's value.
func (s *ListPoliciesInput) SetOnlyAttached(v bool) *ListPoliciesInput {
	s.OnlyAttached = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListPoliciesInput) SetPathPrefix(v string) *ListPoliciesInput {
	s.PathPrefix = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListPoliciesInput) SetScope(v string) *ListPoliciesInput {
	s.Scope = &v
	return s
}

// Contains the response to a successful ListPolicies request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesResponse
type ListPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policies.
	Policies []*Policy `type:"list"`
}

// String returns the string representation
func (s ListPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoliciesOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListPoliciesOutput) SetIsTruncated(v bool) *ListPoliciesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPoliciesOutput) SetMarker(v string) *ListPoliciesOutput {
	s.Marker = &v
	return s
}

// SetPolicies sets the Policies field's value.
func (s *ListPoliciesOutput) SetPolicies(v []*Policy) *ListPoliciesOutput {
	s.Policies = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersionsRequest
type ListPolicyVersionsInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM policy for which you want the versions.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPolicyVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPolicyVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPolicyVersionsInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListPolicyVersionsInput) SetMarker(v string) *ListPolicyVersionsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListPolicyVersionsInput) SetMaxItems(v int64) *ListPolicyVersionsInput {
	s.MaxItems = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *ListPolicyVersionsInput) SetPolicyArn(v string) *ListPolicyVersionsInput {
	s.PolicyArn = &v
	return s
}

// Contains the response to a successful ListPolicyVersions request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersionsResponse
type ListPolicyVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policy versions.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	Versions []*PolicyVersion `type:"list"`
}

// String returns the string representation
func (s ListPolicyVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPolicyVersionsOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListPolicyVersionsOutput) SetIsTruncated(v bool) *ListPolicyVersionsOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListPolicyVersionsOutput) SetMarker(v string) *ListPolicyVersionsOutput {
	s.Marker = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListPolicyVersionsOutput) SetVersions(v []*PolicyVersion) *ListPolicyVersionsOutput {
	s.Versions = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePoliciesRequest
type ListRolePoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the role to list policies for.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRolePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRolePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRolePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRolePoliciesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListRolePoliciesInput) SetMarker(v string) *ListRolePoliciesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListRolePoliciesInput) SetMaxItems(v int64) *ListRolePoliciesInput {
	s.MaxItems = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *ListRolePoliciesInput) SetRoleName(v string) *ListRolePoliciesInput {
	s.RoleName = &v
	return s
}

// Contains the response to a successful ListRolePolicies request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePoliciesResponse
type ListRolePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policy names.
	//
	// PolicyNames is a required field
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListRolePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRolePoliciesOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListRolePoliciesOutput) SetIsTruncated(v bool) *ListRolePoliciesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListRolePoliciesOutput) SetMarker(v string) *ListRolePoliciesOutput {
	s.Marker = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *ListRolePoliciesOutput) SetPolicyNames(v []*string) *ListRolePoliciesOutput {
	s.PolicyNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolesRequest
type ListRolesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example, the prefix /application_abc/component_xyz/
	// gets all roles whose path starts with /application_abc/component_xyz/.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all roles. This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRolesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRolesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRolesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRolesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.PathPrefix != nil && len(*s.PathPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListRolesInput) SetMarker(v string) *ListRolesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListRolesInput) SetMaxItems(v int64) *ListRolesInput {
	s.MaxItems = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListRolesInput) SetPathPrefix(v string) *ListRolesInput {
	s.PathPrefix = &v
	return s
}

// Contains the response to a successful ListRoles request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolesResponse
type ListRolesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of roles.
	//
	// Roles is a required field
	Roles []*Role `type:"list" required:"true"`
}

// String returns the string representation
func (s ListRolesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRolesOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListRolesOutput) SetIsTruncated(v bool) *ListRolesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListRolesOutput) SetMarker(v string) *ListRolesOutput {
	s.Marker = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *ListRolesOutput) SetRoles(v []*Role) *ListRolesOutput {
	s.Roles = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProvidersRequest
type ListSAMLProvidersInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListSAMLProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSAMLProvidersInput) GoString() string {
	return s.String()
}

// Contains the response to a successful ListSAMLProviders request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProvidersResponse
type ListSAMLProvidersOutput struct {
	_ struct{} `type:"structure"`

	// The list of SAML provider resource objects defined in IAM for this AWS account.
	SAMLProviderList []*SAMLProviderListEntry `type:"list"`
}

// String returns the string representation
func (s ListSAMLProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSAMLProvidersOutput) GoString() string {
	return s.String()
}

// SetSAMLProviderList sets the SAMLProviderList field's value.
func (s *ListSAMLProvidersOutput) SetSAMLProviderList(v []*SAMLProviderListEntry) *ListSAMLProvidersOutput {
	s.SAMLProviderList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeysRequest
type ListSSHPublicKeysInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the IAM user to list SSH public keys for. If none is specified,
	// the UserName field is determined implicitly based on the AWS access key used
	// to sign the request.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSSHPublicKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSSHPublicKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSSHPublicKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSSHPublicKeysInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListSSHPublicKeysInput) SetMarker(v string) *ListSSHPublicKeysInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListSSHPublicKeysInput) SetMaxItems(v int64) *ListSSHPublicKeysInput {
	s.MaxItems = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListSSHPublicKeysInput) SetUserName(v string) *ListSSHPublicKeysInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful ListSSHPublicKeys request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeysResponse
type ListSSHPublicKeysOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of the SSH public keys assigned to IAM user.
	SSHPublicKeys []*SSHPublicKeyMetadata `type:"list"`
}

// String returns the string representation
func (s ListSSHPublicKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSSHPublicKeysOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListSSHPublicKeysOutput) SetIsTruncated(v bool) *ListSSHPublicKeysOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListSSHPublicKeysOutput) SetMarker(v string) *ListSSHPublicKeysOutput {
	s.Marker = &v
	return s
}

// SetSSHPublicKeys sets the SSHPublicKeys field's value.
func (s *ListSSHPublicKeysOutput) SetSSHPublicKeys(v []*SSHPublicKeyMetadata) *ListSSHPublicKeysOutput {
	s.SSHPublicKeys = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificatesRequest
type ListServerCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example: /company/servercerts
	// would get all server certificates for which the path starts with /company/servercerts.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all server certificates. This paramater allows (per its regex
	// pattern (http://wikipedia.org/wiki/regex)) a string of characters consisting
	// of either a forward slash (/) by itself or a string that must begin and end
	// with forward slashes, containing any ASCII character from the ! (\u0021)
	// thru the DEL character (\u007F), including most punctuation characters, digits,
	// and upper and lowercased letters.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListServerCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServerCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServerCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServerCertificatesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.PathPrefix != nil && len(*s.PathPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListServerCertificatesInput) SetMarker(v string) *ListServerCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListServerCertificatesInput) SetMaxItems(v int64) *ListServerCertificatesInput {
	s.MaxItems = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListServerCertificatesInput) SetPathPrefix(v string) *ListServerCertificatesInput {
	s.PathPrefix = &v
	return s
}

// Contains the response to a successful ListServerCertificates request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificatesResponse
type ListServerCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of server certificates.
	//
	// ServerCertificateMetadataList is a required field
	ServerCertificateMetadataList []*ServerCertificateMetadata `type:"list" required:"true"`
}

// String returns the string representation
func (s ListServerCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServerCertificatesOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListServerCertificatesOutput) SetIsTruncated(v bool) *ListServerCertificatesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListServerCertificatesOutput) SetMarker(v string) *ListServerCertificatesOutput {
	s.Marker = &v
	return s
}

// SetServerCertificateMetadataList sets the ServerCertificateMetadataList field's value.
func (s *ListServerCertificatesOutput) SetServerCertificateMetadataList(v []*ServerCertificateMetadata) *ListServerCertificatesOutput {
	s.ServerCertificateMetadataList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentialsRequest
type ListServiceSpecificCredentialsInput struct {
	_ struct{} `type:"structure"`

	// Filters the returned results to only those for the specified AWS service.
	// If not specified, then AWS returns service-specific credentials for all services.
	ServiceName *string `type:"string"`

	// The name of the user whose service-specific credentials you want information
	// about. If this value is not specified then the operation assumes the user
	// whose credentials are used to call the operation.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListServiceSpecificCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceSpecificCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceSpecificCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceSpecificCredentialsInput"}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceName sets the ServiceName field's value.
func (s *ListServiceSpecificCredentialsInput) SetServiceName(v string) *ListServiceSpecificCredentialsInput {
	s.ServiceName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListServiceSpecificCredentialsInput) SetUserName(v string) *ListServiceSpecificCredentialsInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentialsResponse
type ListServiceSpecificCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// A list of structures that each contain details about a service-specific credential.
	ServiceSpecificCredentials []*ServiceSpecificCredentialMetadata `type:"list"`
}

// String returns the string representation
func (s ListServiceSpecificCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServiceSpecificCredentialsOutput) GoString() string {
	return s.String()
}

// SetServiceSpecificCredentials sets the ServiceSpecificCredentials field's value.
func (s *ListServiceSpecificCredentialsOutput) SetServiceSpecificCredentials(v []*ServiceSpecificCredentialMetadata) *ListServiceSpecificCredentialsOutput {
	s.ServiceSpecificCredentials = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificatesRequest
type ListSigningCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the IAM user whose signing certificates you want to examine.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSigningCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSigningCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSigningCertificatesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListSigningCertificatesInput) SetMarker(v string) *ListSigningCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListSigningCertificatesInput) SetMaxItems(v int64) *ListSigningCertificatesInput {
	s.MaxItems = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListSigningCertificatesInput) SetUserName(v string) *ListSigningCertificatesInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful ListSigningCertificates request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificatesResponse
type ListSigningCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// A list of the user's signing certificate information.
	//
	// Certificates is a required field
	Certificates []*SigningCertificate `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSigningCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSigningCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *ListSigningCertificatesOutput) SetCertificates(v []*SigningCertificate) *ListSigningCertificatesOutput {
	s.Certificates = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListSigningCertificatesOutput) SetIsTruncated(v bool) *ListSigningCertificatesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListSigningCertificatesOutput) SetMarker(v string) *ListSigningCertificatesOutput {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPoliciesRequest
type ListUserPoliciesInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user to list policies for.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUserPoliciesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListUserPoliciesInput) SetMarker(v string) *ListUserPoliciesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListUserPoliciesInput) SetMaxItems(v int64) *ListUserPoliciesInput {
	s.MaxItems = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ListUserPoliciesInput) SetUserName(v string) *ListUserPoliciesInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful ListUserPolicies request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPoliciesResponse
type ListUserPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of policy names.
	//
	// PolicyNames is a required field
	PolicyNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ListUserPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUserPoliciesOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListUserPoliciesOutput) SetIsTruncated(v bool) *ListUserPoliciesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListUserPoliciesOutput) SetMarker(v string) *ListUserPoliciesOutput {
	s.Marker = &v
	return s
}

// SetPolicyNames sets the PolicyNames field's value.
func (s *ListUserPoliciesOutput) SetPolicyNames(v []*string) *ListUserPoliciesOutput {
	s.PolicyNames = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsersRequest
type ListUsersInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The path prefix for filtering the results. For example: /division_abc/subdivision_xyz/,
	// which would get all user names whose path starts with /division_abc/subdivision_xyz/.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/), listing all user names. This paramater allows (per its regex pattern
	// (http://wikipedia.org/wiki/regex)) a string of characters consisting of either
	// a forward slash (/) by itself or a string that must begin and end with forward
	// slashes, containing any ASCII character from the ! (\u0021) thru the DEL
	// character (\u007F), including most punctuation characters, digits, and upper
	// and lowercased letters.
	PathPrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsersInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.PathPrefix != nil && len(*s.PathPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PathPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListUsersInput) SetMarker(v string) *ListUsersInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListUsersInput) SetMaxItems(v int64) *ListUsersInput {
	s.MaxItems = &v
	return s
}

// SetPathPrefix sets the PathPrefix field's value.
func (s *ListUsersInput) SetPathPrefix(v string) *ListUsersInput {
	s.PathPrefix = &v
	return s
}

// Contains the response to a successful ListUsers request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsersResponse
type ListUsersOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// A list of users.
	//
	// Users is a required field
	Users []*User `type:"list" required:"true"`
}

// String returns the string representation
func (s ListUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUsersOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListUsersOutput) SetIsTruncated(v bool) *ListUsersOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListUsersOutput) SetMarker(v string) *ListUsersOutput {
	s.Marker = &v
	return s
}

// SetUsers sets the Users field's value.
func (s *ListUsersOutput) SetUsers(v []*User) *ListUsersOutput {
	s.Users = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevicesRequest
type ListVirtualMFADevicesInput struct {
	_ struct{} `type:"structure"`

	// The status (Unassigned or Assigned) of the devices to list. If you do not
	// specify an AssignmentStatus, the action defaults to Any which lists both
	// assigned and unassigned virtual MFA devices.
	AssignmentStatus *string `type:"string" enum:"assignmentStatusType"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ListVirtualMFADevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualMFADevicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVirtualMFADevicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVirtualMFADevicesInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignmentStatus sets the AssignmentStatus field's value.
func (s *ListVirtualMFADevicesInput) SetAssignmentStatus(v string) *ListVirtualMFADevicesInput {
	s.AssignmentStatus = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVirtualMFADevicesInput) SetMarker(v string) *ListVirtualMFADevicesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListVirtualMFADevicesInput) SetMaxItems(v int64) *ListVirtualMFADevicesInput {
	s.MaxItems = &v
	return s
}

// Contains the response to a successful ListVirtualMFADevices request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevicesResponse
type ListVirtualMFADevicesOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`

	// The list of virtual MFA devices in the current account that match the AssignmentStatus
	// value that was passed in the request.
	//
	// VirtualMFADevices is a required field
	VirtualMFADevices []*VirtualMFADevice `type:"list" required:"true"`
}

// String returns the string representation
func (s ListVirtualMFADevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVirtualMFADevicesOutput) GoString() string {
	return s.String()
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *ListVirtualMFADevicesOutput) SetIsTruncated(v bool) *ListVirtualMFADevicesOutput {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVirtualMFADevicesOutput) SetMarker(v string) *ListVirtualMFADevicesOutput {
	s.Marker = &v
	return s
}

// SetVirtualMFADevices sets the VirtualMFADevices field's value.
func (s *ListVirtualMFADevicesOutput) SetVirtualMFADevices(v []*VirtualMFADevice) *ListVirtualMFADevicesOutput {
	s.VirtualMFADevices = v
	return s
}

// Contains the user name and password create date for a user.
//
// This data type is used as a response element in the CreateLoginProfile and
// GetLoginProfile actions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/LoginProfile
type LoginProfile struct {
	_ struct{} `type:"structure"`

	// The date when the password for the user was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Specifies whether the user is required to set a new password on next sign-in.
	PasswordResetRequired *bool `type:"boolean"`

	// The name of the user, which can be used for signing in to the AWS Management
	// Console.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LoginProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoginProfile) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *LoginProfile) SetCreateDate(v time.Time) *LoginProfile {
	s.CreateDate = &v
	return s
}

// SetPasswordResetRequired sets the PasswordResetRequired field's value.
func (s *LoginProfile) SetPasswordResetRequired(v bool) *LoginProfile {
	s.PasswordResetRequired = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *LoginProfile) SetUserName(v string) *LoginProfile {
	s.UserName = &v
	return s
}

// Contains information about an MFA device.
//
// This data type is used as a response element in the ListMFADevices action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/MFADevice
type MFADevice struct {
	_ struct{} `type:"structure"`

	// The date when the MFA device was enabled for the user.
	//
	// EnableDate is a required field
	EnableDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The serial number that uniquely identifies the MFA device. For virtual MFA
	// devices, the serial number is the device ARN.
	//
	// SerialNumber is a required field
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The user with whom the MFA device is associated.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MFADevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MFADevice) GoString() string {
	return s.String()
}

// SetEnableDate sets the EnableDate field's value.
func (s *MFADevice) SetEnableDate(v time.Time) *MFADevice {
	s.EnableDate = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *MFADevice) SetSerialNumber(v string) *MFADevice {
	s.SerialNumber = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *MFADevice) SetUserName(v string) *MFADevice {
	s.UserName = &v
	return s
}

// Contains information about a managed policy, including the policy's ARN,
// versions, and the number of principal entities (users, groups, and roles)
// that the policy is attached to.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
//
// For more information about managed policies, see Managed Policies and Inline
// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ManagedPolicyDetail
type ManagedPolicyDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The number of principal entities (users, groups, and roles) that the policy
	// is attached to.
	AttachmentCount *int64 `type:"integer"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier for the version of the policy that is set as the default (operative)
	// version.
	//
	// For more information about policy versions, see Versioning for Managed Policies
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the Using IAM guide.
	DefaultVersionId *string `type:"string"`

	// A friendly description of the policy.
	Description *string `type:"string"`

	// Specifies whether the policy can be attached to an IAM user, group, or role.
	IsAttachable *bool `type:"boolean"`

	// The path to the policy.
	//
	// For more information about paths, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `type:"string"`

	// The stable and unique string identifying the policy.
	//
	// For more information about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	PolicyId *string `min:"16" type:"string"`

	// The friendly name (not ARN) identifying the policy.
	PolicyName *string `min:"1" type:"string"`

	// A list containing information about the versions of the policy.
	PolicyVersionList []*PolicyVersion `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was last updated.
	//
	// When a policy has only one version, this field contains the date and time
	// when the policy was created. When a policy has more than one version, this
	// field contains the date and time when the most recent policy version was
	// created.
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ManagedPolicyDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ManagedPolicyDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ManagedPolicyDetail) SetArn(v string) *ManagedPolicyDetail {
	s.Arn = &v
	return s
}

// SetAttachmentCount sets the AttachmentCount field's value.
func (s *ManagedPolicyDetail) SetAttachmentCount(v int64) *ManagedPolicyDetail {
	s.AttachmentCount = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *ManagedPolicyDetail) SetCreateDate(v time.Time) *ManagedPolicyDetail {
	s.CreateDate = &v
	return s
}

// SetDefaultVersionId sets the DefaultVersionId field's value.
func (s *ManagedPolicyDetail) SetDefaultVersionId(v string) *ManagedPolicyDetail {
	s.DefaultVersionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ManagedPolicyDetail) SetDescription(v string) *ManagedPolicyDetail {
	s.Description = &v
	return s
}

// SetIsAttachable sets the IsAttachable field's value.
func (s *ManagedPolicyDetail) SetIsAttachable(v bool) *ManagedPolicyDetail {
	s.IsAttachable = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ManagedPolicyDetail) SetPath(v string) *ManagedPolicyDetail {
	s.Path = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *ManagedPolicyDetail) SetPolicyId(v string) *ManagedPolicyDetail {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *ManagedPolicyDetail) SetPolicyName(v string) *ManagedPolicyDetail {
	s.PolicyName = &v
	return s
}

// SetPolicyVersionList sets the PolicyVersionList field's value.
func (s *ManagedPolicyDetail) SetPolicyVersionList(v []*PolicyVersion) *ManagedPolicyDetail {
	s.PolicyVersionList = v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *ManagedPolicyDetail) SetUpdateDate(v time.Time) *ManagedPolicyDetail {
	s.UpdateDate = &v
	return s
}

// Contains the Amazon Resource Name (ARN) for an IAM OpenID Connect provider.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/OpenIDConnectProviderListEntry
type OpenIDConnectProviderListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s OpenIDConnectProviderListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OpenIDConnectProviderListEntry) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *OpenIDConnectProviderListEntry) SetArn(v string) *OpenIDConnectProviderListEntry {
	s.Arn = &v
	return s
}

// Contains information about AWS Organizations's affect on a policy simulation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/OrganizationsDecisionDetail
type OrganizationsDecisionDetail struct {
	_ struct{} `type:"structure"`

	// Specifies whether the simulated action is allowed by the AWS Organizations
	// service control policies that impact the simulated user's account.
	AllowedByOrganizations *bool `type:"boolean"`
}

// String returns the string representation
func (s OrganizationsDecisionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrganizationsDecisionDetail) GoString() string {
	return s.String()
}

// SetAllowedByOrganizations sets the AllowedByOrganizations field's value.
func (s *OrganizationsDecisionDetail) SetAllowedByOrganizations(v bool) *OrganizationsDecisionDetail {
	s.AllowedByOrganizations = &v
	return s
}

// Contains information about the account password policy.
//
// This data type is used as a response element in the GetAccountPasswordPolicy
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PasswordPolicy
type PasswordPolicy struct {
	_ struct{} `type:"structure"`

	// Specifies whether IAM users are allowed to change their own password.
	AllowUsersToChangePassword *bool `type:"boolean"`

	// Indicates whether passwords in the account expire. Returns true if MaxPasswordAge
	// is contains a value greater than 0. Returns false if MaxPasswordAge is 0
	// or not present.
	ExpirePasswords *bool `type:"boolean"`

	// Specifies whether IAM users are prevented from setting a new password after
	// their password has expired.
	HardExpiry *bool `type:"boolean"`

	// The number of days that an IAM user password is valid.
	MaxPasswordAge *int64 `min:"1" type:"integer"`

	// Minimum length to require for IAM user passwords.
	MinimumPasswordLength *int64 `min:"6" type:"integer"`

	// Specifies the number of previous passwords that IAM users are prevented from
	// reusing.
	PasswordReusePrevention *int64 `min:"1" type:"integer"`

	// Specifies whether to require lowercase characters for IAM user passwords.
	RequireLowercaseCharacters *bool `type:"boolean"`

	// Specifies whether to require numbers for IAM user passwords.
	RequireNumbers *bool `type:"boolean"`

	// Specifies whether to require symbols for IAM user passwords.
	RequireSymbols *bool `type:"boolean"`

	// Specifies whether to require uppercase characters for IAM user passwords.
	RequireUppercaseCharacters *bool `type:"boolean"`
}

// String returns the string representation
func (s PasswordPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PasswordPolicy) GoString() string {
	return s.String()
}

// SetAllowUsersToChangePassword sets the AllowUsersToChangePassword field's value.
func (s *PasswordPolicy) SetAllowUsersToChangePassword(v bool) *PasswordPolicy {
	s.AllowUsersToChangePassword = &v
	return s
}

// SetExpirePasswords sets the ExpirePasswords field's value.
func (s *PasswordPolicy) SetExpirePasswords(v bool) *PasswordPolicy {
	s.ExpirePasswords = &v
	return s
}

// SetHardExpiry sets the HardExpiry field's value.
func (s *PasswordPolicy) SetHardExpiry(v bool) *PasswordPolicy {
	s.HardExpiry = &v
	return s
}

// SetMaxPasswordAge sets the MaxPasswordAge field's value.
func (s *PasswordPolicy) SetMaxPasswordAge(v int64) *PasswordPolicy {
	s.MaxPasswordAge = &v
	return s
}

// SetMinimumPasswordLength sets the MinimumPasswordLength field's value.
func (s *PasswordPolicy) SetMinimumPasswordLength(v int64) *PasswordPolicy {
	s.MinimumPasswordLength = &v
	return s
}

// SetPasswordReusePrevention sets the PasswordReusePrevention field's value.
func (s *PasswordPolicy) SetPasswordReusePrevention(v int64) *PasswordPolicy {
	s.PasswordReusePrevention = &v
	return s
}

// SetRequireLowercaseCharacters sets the RequireLowercaseCharacters field's value.
func (s *PasswordPolicy) SetRequireLowercaseCharacters(v bool) *PasswordPolicy {
	s.RequireLowercaseCharacters = &v
	return s
}

// SetRequireNumbers sets the RequireNumbers field's value.
func (s *PasswordPolicy) SetRequireNumbers(v bool) *PasswordPolicy {
	s.RequireNumbers = &v
	return s
}

// SetRequireSymbols sets the RequireSymbols field's value.
func (s *PasswordPolicy) SetRequireSymbols(v bool) *PasswordPolicy {
	s.RequireSymbols = &v
	return s
}

// SetRequireUppercaseCharacters sets the RequireUppercaseCharacters field's value.
func (s *PasswordPolicy) SetRequireUppercaseCharacters(v bool) *PasswordPolicy {
	s.RequireUppercaseCharacters = &v
	return s
}

// Contains information about a managed policy.
//
// This data type is used as a response element in the CreatePolicy, GetPolicy,
// and ListPolicies actions.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Policy
type Policy struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The number of entities (users, groups, and roles) that the policy is attached
	// to.
	AttachmentCount *int64 `type:"integer"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The identifier for the version of the policy that is set as the default version.
	DefaultVersionId *string `type:"string"`

	// A friendly description of the policy.
	//
	// This element is included in the response to the GetPolicy operation. It is
	// not included in the response to the ListPolicies operation.
	Description *string `type:"string"`

	// Specifies whether the policy can be attached to an IAM user, group, or role.
	IsAttachable *bool `type:"boolean"`

	// The path to the policy.
	//
	// For more information about paths, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `type:"string"`

	// The stable and unique string identifying the policy.
	//
	// For more information about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	PolicyId *string `min:"16" type:"string"`

	// The friendly name (not ARN) identifying the policy.
	PolicyName *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy was last updated.
	//
	// When a policy has only one version, this field contains the date and time
	// when the policy was created. When a policy has more than one version, this
	// field contains the date and time when the most recent policy version was
	// created.
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s Policy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Policy) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Policy) SetArn(v string) *Policy {
	s.Arn = &v
	return s
}

// SetAttachmentCount sets the AttachmentCount field's value.
func (s *Policy) SetAttachmentCount(v int64) *Policy {
	s.AttachmentCount = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Policy) SetCreateDate(v time.Time) *Policy {
	s.CreateDate = &v
	return s
}

// SetDefaultVersionId sets the DefaultVersionId field's value.
func (s *Policy) SetDefaultVersionId(v string) *Policy {
	s.DefaultVersionId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Policy) SetDescription(v string) *Policy {
	s.Description = &v
	return s
}

// SetIsAttachable sets the IsAttachable field's value.
func (s *Policy) SetIsAttachable(v bool) *Policy {
	s.IsAttachable = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Policy) SetPath(v string) *Policy {
	s.Path = &v
	return s
}

// SetPolicyId sets the PolicyId field's value.
func (s *Policy) SetPolicyId(v string) *Policy {
	s.PolicyId = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *Policy) SetPolicyName(v string) *Policy {
	s.PolicyName = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *Policy) SetUpdateDate(v time.Time) *Policy {
	s.UpdateDate = &v
	return s
}

// Contains information about an IAM policy, including the policy document.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyDetail
type PolicyDetail struct {
	_ struct{} `type:"structure"`

	// The policy document.
	PolicyDocument *string `min:"1" type:"string"`

	// The name of the policy.
	PolicyName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyDetail) GoString() string {
	return s.String()
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *PolicyDetail) SetPolicyDocument(v string) *PolicyDetail {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PolicyDetail) SetPolicyName(v string) *PolicyDetail {
	s.PolicyName = &v
	return s
}

// Contains information about a group that a managed policy is attached to.
//
// This data type is used as a response element in the ListEntitiesForPolicy
// action.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyGroup
type PolicyGroup struct {
	_ struct{} `type:"structure"`

	// The stable and unique string identifying the group. For more information
	// about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	GroupId *string `min:"16" type:"string"`

	// The name (friendly name, not ARN) identifying the group.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyGroup) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *PolicyGroup) SetGroupId(v string) *PolicyGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *PolicyGroup) SetGroupName(v string) *PolicyGroup {
	s.GroupName = &v
	return s
}

// Contains information about a role that a managed policy is attached to.
//
// This data type is used as a response element in the ListEntitiesForPolicy
// action.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyRole
type PolicyRole struct {
	_ struct{} `type:"structure"`

	// The stable and unique string identifying the role. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	RoleId *string `min:"16" type:"string"`

	// The name (friendly name, not ARN) identifying the role.
	RoleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyRole) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyRole) GoString() string {
	return s.String()
}

// SetRoleId sets the RoleId field's value.
func (s *PolicyRole) SetRoleId(v string) *PolicyRole {
	s.RoleId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *PolicyRole) SetRoleName(v string) *PolicyRole {
	s.RoleName = &v
	return s
}

// Contains information about a user that a managed policy is attached to.
//
// This data type is used as a response element in the ListEntitiesForPolicy
// action.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyUser
type PolicyUser struct {
	_ struct{} `type:"structure"`

	// The stable and unique string identifying the user. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in the IAM User Guide.
	UserId *string `min:"16" type:"string"`

	// The name (friendly name, not ARN) identifying the user.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PolicyUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyUser) GoString() string {
	return s.String()
}

// SetUserId sets the UserId field's value.
func (s *PolicyUser) SetUserId(v string) *PolicyUser {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *PolicyUser) SetUserName(v string) *PolicyUser {
	s.UserName = &v
	return s
}

// Contains information about a version of a managed policy.
//
// This data type is used as a response element in the CreatePolicyVersion,
// GetPolicyVersion, ListPolicyVersions, and GetAccountAuthorizationDetails
// actions.
//
// For more information about managed policies, refer to Managed Policies and
// Inline Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the Using IAM guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PolicyVersion
type PolicyVersion struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the policy version was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The policy document.
	//
	// The policy document is returned in the response to the GetPolicyVersion and
	// GetAccountAuthorizationDetails operations. It is not returned in the response
	// to the CreatePolicyVersion or ListPolicyVersions operations.
	Document *string `min:"1" type:"string"`

	// Specifies whether the policy version is set as the policy's default version.
	IsDefaultVersion *bool `type:"boolean"`

	// The identifier for the policy version.
	//
	// Policy version identifiers always begin with v (always lowercase). When a
	// policy is created, the first policy version is v1.
	VersionId *string `type:"string"`
}

// String returns the string representation
func (s PolicyVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PolicyVersion) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *PolicyVersion) SetCreateDate(v time.Time) *PolicyVersion {
	s.CreateDate = &v
	return s
}

// SetDocument sets the Document field's value.
func (s *PolicyVersion) SetDocument(v string) *PolicyVersion {
	s.Document = &v
	return s
}

// SetIsDefaultVersion sets the IsDefaultVersion field's value.
func (s *PolicyVersion) SetIsDefaultVersion(v bool) *PolicyVersion {
	s.IsDefaultVersion = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PolicyVersion) SetVersionId(v string) *PolicyVersion {
	s.VersionId = &v
	return s
}

// Contains the row and column of a location of a Statement element in a policy
// document.
//
// This data type is used as a member of the Statement type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Position
type Position struct {
	_ struct{} `type:"structure"`

	// The column in the line containing the specified position in the document.
	Column *int64 `type:"integer"`

	// The line containing the specified position in the document.
	Line *int64 `type:"integer"`
}

// String returns the string representation
func (s Position) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Position) GoString() string {
	return s.String()
}

// SetColumn sets the Column field's value.
func (s *Position) SetColumn(v int64) *Position {
	s.Column = &v
	return s
}

// SetLine sets the Line field's value.
func (s *Position) SetLine(v int64) *Position {
	s.Line = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutGroupPolicyRequest
type PutGroupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to associate the policy with.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The policy document.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy document.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutGroupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutGroupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutGroupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutGroupPolicyInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyDocument", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *PutGroupPolicyInput) SetGroupName(v string) *PutGroupPolicyInput {
	s.GroupName = &v
	return s
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *PutGroupPolicyInput) SetPolicyDocument(v string) *PutGroupPolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PutGroupPolicyInput) SetPolicyName(v string) *PutGroupPolicyInput {
	s.PolicyName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutGroupPolicyOutput
type PutGroupPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutGroupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutGroupPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePolicyRequest
type PutRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy document.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the role to associate the policy with.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRolePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRolePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRolePolicyInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyDocument", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *PutRolePolicyInput) SetPolicyDocument(v string) *PutRolePolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PutRolePolicyInput) SetPolicyName(v string) *PutRolePolicyInput {
	s.PolicyName = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *PutRolePolicyInput) SetRoleName(v string) *PutRolePolicyInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePolicyOutput
type PutRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutRolePolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPolicyRequest
type PutUserPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy document.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the policy document.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The name of the user to associate the policy with.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutUserPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutUserPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutUserPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutUserPolicyInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyDocument", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *PutUserPolicyInput) SetPolicyDocument(v string) *PutUserPolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetPolicyName sets the PolicyName field's value.
func (s *PutUserPolicyInput) SetPolicyName(v string) *PutUserPolicyInput {
	s.PolicyName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *PutUserPolicyInput) SetUserName(v string) *PutUserPolicyInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPolicyOutput
type PutUserPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutUserPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutUserPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveClientIDFromOpenIDConnectProviderRequest
type RemoveClientIDFromOpenIDConnectProviderInput struct {
	_ struct{} `type:"structure"`

	// The client ID (also known as audience) to remove from the IAM OIDC provider
	// resource. For more information about client IDs, see CreateOpenIDConnectProvider.
	//
	// ClientID is a required field
	ClientID *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM OIDC provider resource to remove
	// the client ID from. You can get a list of OIDC provider ARNs by using the
	// ListOpenIDConnectProviders action.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// OpenIDConnectProviderArn is a required field
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveClientIDFromOpenIDConnectProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveClientIDFromOpenIDConnectProviderInput"}
	if s.ClientID == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientID"))
	}
	if s.ClientID != nil && len(*s.ClientID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientID", 1))
	}
	if s.OpenIDConnectProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OpenIDConnectProviderArn"))
	}
	if s.OpenIDConnectProviderArn != nil && len(*s.OpenIDConnectProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OpenIDConnectProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientID sets the ClientID field's value.
func (s *RemoveClientIDFromOpenIDConnectProviderInput) SetClientID(v string) *RemoveClientIDFromOpenIDConnectProviderInput {
	s.ClientID = &v
	return s
}

// SetOpenIDConnectProviderArn sets the OpenIDConnectProviderArn field's value.
func (s *RemoveClientIDFromOpenIDConnectProviderInput) SetOpenIDConnectProviderArn(v string) *RemoveClientIDFromOpenIDConnectProviderInput {
	s.OpenIDConnectProviderArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveClientIDFromOpenIDConnectProviderOutput
type RemoveClientIDFromOpenIDConnectProviderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveClientIDFromOpenIDConnectProviderOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveRoleFromInstanceProfileRequest
type RemoveRoleFromInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance profile to update.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// InstanceProfileName is a required field
	InstanceProfileName *string `min:"1" type:"string" required:"true"`

	// The name of the role to remove.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveRoleFromInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRoleFromInstanceProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveRoleFromInstanceProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveRoleFromInstanceProfileInput"}
	if s.InstanceProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileName"))
	}
	if s.InstanceProfileName != nil && len(*s.InstanceProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceProfileName", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceProfileName sets the InstanceProfileName field's value.
func (s *RemoveRoleFromInstanceProfileInput) SetInstanceProfileName(v string) *RemoveRoleFromInstanceProfileInput {
	s.InstanceProfileName = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *RemoveRoleFromInstanceProfileInput) SetRoleName(v string) *RemoveRoleFromInstanceProfileInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveRoleFromInstanceProfileOutput
type RemoveRoleFromInstanceProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveRoleFromInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveRoleFromInstanceProfileOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveUserFromGroupRequest
type RemoveUserFromGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to update.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The name of the user to remove.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemoveUserFromGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveUserFromGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveUserFromGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveUserFromGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *RemoveUserFromGroupInput) SetGroupName(v string) *RemoveUserFromGroupInput {
	s.GroupName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *RemoveUserFromGroupInput) SetUserName(v string) *RemoveUserFromGroupInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveUserFromGroupOutput
type RemoveUserFromGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveUserFromGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveUserFromGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResetServiceSpecificCredentialRequest
type ResetServiceSpecificCredentialInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the service-specific credential.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// ServiceSpecificCredentialId is a required field
	ServiceSpecificCredentialId *string `min:"20" type:"string" required:"true"`

	// The name of the IAM user associated with the service-specific credential.
	// If this value is not specified, then the operation assumes the user whose
	// credentials are used to call the operation.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ResetServiceSpecificCredentialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetServiceSpecificCredentialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetServiceSpecificCredentialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResetServiceSpecificCredentialInput"}
	if s.ServiceSpecificCredentialId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceSpecificCredentialId"))
	}
	if s.ServiceSpecificCredentialId != nil && len(*s.ServiceSpecificCredentialId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceSpecificCredentialId", 20))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceSpecificCredentialId sets the ServiceSpecificCredentialId field's value.
func (s *ResetServiceSpecificCredentialInput) SetServiceSpecificCredentialId(v string) *ResetServiceSpecificCredentialInput {
	s.ServiceSpecificCredentialId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ResetServiceSpecificCredentialInput) SetUserName(v string) *ResetServiceSpecificCredentialInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResetServiceSpecificCredentialResponse
type ResetServiceSpecificCredentialOutput struct {
	_ struct{} `type:"structure"`

	// A structure with details about the updated service-specific credential, including
	// the new password.
	//
	// This is the only time that you can access the password. You cannot recover
	// the password later, but you can reset it again.
	ServiceSpecificCredential *ServiceSpecificCredential `type:"structure"`
}

// String returns the string representation
func (s ResetServiceSpecificCredentialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResetServiceSpecificCredentialOutput) GoString() string {
	return s.String()
}

// SetServiceSpecificCredential sets the ServiceSpecificCredential field's value.
func (s *ResetServiceSpecificCredentialOutput) SetServiceSpecificCredential(v *ServiceSpecificCredential) *ResetServiceSpecificCredentialOutput {
	s.ServiceSpecificCredential = v
	return s
}

// Contains the result of the simulation of a single API action call on a single
// resource.
//
// This data type is used by a member of the EvaluationResult data type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResourceSpecificResult
type ResourceSpecificResult struct {
	_ struct{} `type:"structure"`

	// Additional details about the results of the evaluation decision. When there
	// are both IAM policies and resource policies, this parameter explains how
	// each set of policies contributes to the final evaluation decision. When simulating
	// cross-account access to a resource, both the resource-based policy and the
	// caller's IAM policy must grant access.
	EvalDecisionDetails map[string]*string `type:"map"`

	// The result of the simulation of the simulated API action on the resource
	// specified in EvalResourceName.
	//
	// EvalResourceDecision is a required field
	EvalResourceDecision *string `type:"string" required:"true" enum:"PolicyEvaluationDecisionType"`

	// The name of the simulated resource, in Amazon Resource Name (ARN) format.
	//
	// EvalResourceName is a required field
	EvalResourceName *string `min:"1" type:"string" required:"true"`

	// A list of the statements in the input policies that determine the result
	// for this part of the simulation. Remember that even if multiple statements
	// allow the action on the resource, if any statement denies that action, then
	// the explicit deny overrides any allow, and the deny statement is the only
	// entry included in the result.
	MatchedStatements []*Statement `type:"list"`

	// A list of context keys that are required by the included input policies but
	// that were not provided by one of the input parameters. This list is used
	// when a list of ARNs is included in the ResourceArns parameter instead of
	// "*". If you do not specify individual resources, by setting ResourceArns
	// to "*" or by not including the ResourceArns parameter, then any missing context
	// values are instead included under the EvaluationResults section. To discover
	// the context keys used by a set of policies, you can call GetContextKeysForCustomPolicy
	// or GetContextKeysForPrincipalPolicy.
	MissingContextValues []*string `type:"list"`
}

// String returns the string representation
func (s ResourceSpecificResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceSpecificResult) GoString() string {
	return s.String()
}

// SetEvalDecisionDetails sets the EvalDecisionDetails field's value.
func (s *ResourceSpecificResult) SetEvalDecisionDetails(v map[string]*string) *ResourceSpecificResult {
	s.EvalDecisionDetails = v
	return s
}

// SetEvalResourceDecision sets the EvalResourceDecision field's value.
func (s *ResourceSpecificResult) SetEvalResourceDecision(v string) *ResourceSpecificResult {
	s.EvalResourceDecision = &v
	return s
}

// SetEvalResourceName sets the EvalResourceName field's value.
func (s *ResourceSpecificResult) SetEvalResourceName(v string) *ResourceSpecificResult {
	s.EvalResourceName = &v
	return s
}

// SetMatchedStatements sets the MatchedStatements field's value.
func (s *ResourceSpecificResult) SetMatchedStatements(v []*Statement) *ResourceSpecificResult {
	s.MatchedStatements = v
	return s
}

// SetMissingContextValues sets the MissingContextValues field's value.
func (s *ResourceSpecificResult) SetMissingContextValues(v []*string) *ResourceSpecificResult {
	s.MissingContextValues = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResyncMFADeviceRequest
type ResyncMFADeviceInput struct {
	_ struct{} `type:"structure"`

	// An authentication code emitted by the device.
	//
	// The format for this parameter is a sequence of six digits.
	//
	// AuthenticationCode1 is a required field
	AuthenticationCode1 *string `min:"6" type:"string" required:"true"`

	// A subsequent authentication code emitted by the device.
	//
	// The format for this parameter is a sequence of six digits.
	//
	// AuthenticationCode2 is a required field
	AuthenticationCode2 *string `min:"6" type:"string" required:"true"`

	// Serial number that uniquely identifies the MFA device.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// SerialNumber is a required field
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The name of the user whose MFA device you want to resynchronize.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ResyncMFADeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResyncMFADeviceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResyncMFADeviceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResyncMFADeviceInput"}
	if s.AuthenticationCode1 == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationCode1"))
	}
	if s.AuthenticationCode1 != nil && len(*s.AuthenticationCode1) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationCode1", 6))
	}
	if s.AuthenticationCode2 == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationCode2"))
	}
	if s.AuthenticationCode2 != nil && len(*s.AuthenticationCode2) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("AuthenticationCode2", 6))
	}
	if s.SerialNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("SerialNumber"))
	}
	if s.SerialNumber != nil && len(*s.SerialNumber) < 9 {
		invalidParams.Add(request.NewErrParamMinLen("SerialNumber", 9))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthenticationCode1 sets the AuthenticationCode1 field's value.
func (s *ResyncMFADeviceInput) SetAuthenticationCode1(v string) *ResyncMFADeviceInput {
	s.AuthenticationCode1 = &v
	return s
}

// SetAuthenticationCode2 sets the AuthenticationCode2 field's value.
func (s *ResyncMFADeviceInput) SetAuthenticationCode2(v string) *ResyncMFADeviceInput {
	s.AuthenticationCode2 = &v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *ResyncMFADeviceInput) SetSerialNumber(v string) *ResyncMFADeviceInput {
	s.SerialNumber = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ResyncMFADeviceInput) SetUserName(v string) *ResyncMFADeviceInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResyncMFADeviceOutput
type ResyncMFADeviceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResyncMFADeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResyncMFADeviceOutput) GoString() string {
	return s.String()
}

// Contains information about an IAM role.
//
// This data type is used as a response element in the following actions:
//
//    * CreateRole
//
//    * GetRole
//
//    * ListRoles
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Role
type Role struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the role. For more information
	// about ARNs and how to use them in policies, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The policy that grants an entity permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the role was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The path to the role. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// The stable and unique string identifying the role. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// RoleId is a required field
	RoleId *string `min:"16" type:"string" required:"true"`

	// The friendly name that identifies the role.
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Role) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Role) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Role) SetArn(v string) *Role {
	s.Arn = &v
	return s
}

// SetAssumeRolePolicyDocument sets the AssumeRolePolicyDocument field's value.
func (s *Role) SetAssumeRolePolicyDocument(v string) *Role {
	s.AssumeRolePolicyDocument = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Role) SetCreateDate(v time.Time) *Role {
	s.CreateDate = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Role) SetPath(v string) *Role {
	s.Path = &v
	return s
}

// SetRoleId sets the RoleId field's value.
func (s *Role) SetRoleId(v string) *Role {
	s.RoleId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *Role) SetRoleName(v string) *Role {
	s.RoleName = &v
	return s
}

// Contains information about an IAM role, including all of the role's policies.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RoleDetail
type RoleDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The trust policy that grants permission to assume the role.
	AssumeRolePolicyDocument *string `min:"1" type:"string"`

	// A list of managed policies attached to the role. These policies are the role's
	// access (permissions) policies.
	AttachedManagedPolicies []*AttachedPolicy `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the role was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of instance profiles that contain this role.
	InstanceProfileList []*InstanceProfile `type:"list"`

	// The path to the role. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`

	// The stable and unique string identifying the role. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	RoleId *string `min:"16" type:"string"`

	// The friendly name that identifies the role.
	RoleName *string `min:"1" type:"string"`

	// A list of inline policies embedded in the role. These policies are the role's
	// access (permissions) policies.
	RolePolicyList []*PolicyDetail `type:"list"`
}

// String returns the string representation
func (s RoleDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RoleDetail) SetArn(v string) *RoleDetail {
	s.Arn = &v
	return s
}

// SetAssumeRolePolicyDocument sets the AssumeRolePolicyDocument field's value.
func (s *RoleDetail) SetAssumeRolePolicyDocument(v string) *RoleDetail {
	s.AssumeRolePolicyDocument = &v
	return s
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *RoleDetail) SetAttachedManagedPolicies(v []*AttachedPolicy) *RoleDetail {
	s.AttachedManagedPolicies = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *RoleDetail) SetCreateDate(v time.Time) *RoleDetail {
	s.CreateDate = &v
	return s
}

// SetInstanceProfileList sets the InstanceProfileList field's value.
func (s *RoleDetail) SetInstanceProfileList(v []*InstanceProfile) *RoleDetail {
	s.InstanceProfileList = v
	return s
}

// SetPath sets the Path field's value.
func (s *RoleDetail) SetPath(v string) *RoleDetail {
	s.Path = &v
	return s
}

// SetRoleId sets the RoleId field's value.
func (s *RoleDetail) SetRoleId(v string) *RoleDetail {
	s.RoleId = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *RoleDetail) SetRoleName(v string) *RoleDetail {
	s.RoleName = &v
	return s
}

// SetRolePolicyList sets the RolePolicyList field's value.
func (s *RoleDetail) SetRolePolicyList(v []*PolicyDetail) *RoleDetail {
	s.RolePolicyList = v
	return s
}

// Contains the list of SAML providers for this account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SAMLProviderListEntry
type SAMLProviderListEntry struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider.
	Arn *string `min:"20" type:"string"`

	// The date and time when the SAML provider was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The expiration date and time for the SAML provider.
	ValidUntil *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s SAMLProviderListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SAMLProviderListEntry) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SAMLProviderListEntry) SetArn(v string) *SAMLProviderListEntry {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *SAMLProviderListEntry) SetCreateDate(v time.Time) *SAMLProviderListEntry {
	s.CreateDate = &v
	return s
}

// SetValidUntil sets the ValidUntil field's value.
func (s *SAMLProviderListEntry) SetValidUntil(v time.Time) *SAMLProviderListEntry {
	s.ValidUntil = &v
	return s
}

// Contains information about an SSH public key.
//
// This data type is used as a response element in the GetSSHPublicKey and UploadSSHPublicKey
// actions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SSHPublicKey
type SSHPublicKey struct {
	_ struct{} `type:"structure"`

	// The MD5 message digest of the SSH public key.
	//
	// Fingerprint is a required field
	Fingerprint *string `min:"48" type:"string" required:"true"`

	// The SSH public key.
	//
	// SSHPublicKeyBody is a required field
	SSHPublicKeyBody *string `min:"1" type:"string" required:"true"`

	// The unique identifier for the SSH public key.
	//
	// SSHPublicKeyId is a required field
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The status of the SSH public key. Active means the key can be used for authentication
	// with an AWS CodeCommit repository. Inactive means the key cannot be used.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the SSH public key was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the IAM user associated with the SSH public key.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SSHPublicKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSHPublicKey) GoString() string {
	return s.String()
}

// SetFingerprint sets the Fingerprint field's value.
func (s *SSHPublicKey) SetFingerprint(v string) *SSHPublicKey {
	s.Fingerprint = &v
	return s
}

// SetSSHPublicKeyBody sets the SSHPublicKeyBody field's value.
func (s *SSHPublicKey) SetSSHPublicKeyBody(v string) *SSHPublicKey {
	s.SSHPublicKeyBody = &v
	return s
}

// SetSSHPublicKeyId sets the SSHPublicKeyId field's value.
func (s *SSHPublicKey) SetSSHPublicKeyId(v string) *SSHPublicKey {
	s.SSHPublicKeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SSHPublicKey) SetStatus(v string) *SSHPublicKey {
	s.Status = &v
	return s
}

// SetUploadDate sets the UploadDate field's value.
func (s *SSHPublicKey) SetUploadDate(v time.Time) *SSHPublicKey {
	s.UploadDate = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *SSHPublicKey) SetUserName(v string) *SSHPublicKey {
	s.UserName = &v
	return s
}

// Contains information about an SSH public key, without the key's body or fingerprint.
//
// This data type is used as a response element in the ListSSHPublicKeys action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SSHPublicKeyMetadata
type SSHPublicKeyMetadata struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the SSH public key.
	//
	// SSHPublicKeyId is a required field
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The status of the SSH public key. Active means the key can be used for authentication
	// with an AWS CodeCommit repository. Inactive means the key cannot be used.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the SSH public key was uploaded.
	//
	// UploadDate is a required field
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the IAM user associated with the SSH public key.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SSHPublicKeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSHPublicKeyMetadata) GoString() string {
	return s.String()
}

// SetSSHPublicKeyId sets the SSHPublicKeyId field's value.
func (s *SSHPublicKeyMetadata) SetSSHPublicKeyId(v string) *SSHPublicKeyMetadata {
	s.SSHPublicKeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SSHPublicKeyMetadata) SetStatus(v string) *SSHPublicKeyMetadata {
	s.Status = &v
	return s
}

// SetUploadDate sets the UploadDate field's value.
func (s *SSHPublicKeyMetadata) SetUploadDate(v time.Time) *SSHPublicKeyMetadata {
	s.UploadDate = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *SSHPublicKeyMetadata) SetUserName(v string) *SSHPublicKeyMetadata {
	s.UserName = &v
	return s
}

// Contains information about a server certificate.
//
// This data type is used as a response element in the GetServerCertificate
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ServerCertificate
type ServerCertificate struct {
	_ struct{} `type:"structure"`

	// The contents of the public key certificate.
	//
	// CertificateBody is a required field
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The contents of the public key certificate chain.
	CertificateChain *string `min:"1" type:"string"`

	// The meta information of the server certificate, such as its name, path, ID,
	// and ARN.
	//
	// ServerCertificateMetadata is a required field
	ServerCertificateMetadata *ServerCertificateMetadata `type:"structure" required:"true"`
}

// String returns the string representation
func (s ServerCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerCertificate) GoString() string {
	return s.String()
}

// SetCertificateBody sets the CertificateBody field's value.
func (s *ServerCertificate) SetCertificateBody(v string) *ServerCertificate {
	s.CertificateBody = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *ServerCertificate) SetCertificateChain(v string) *ServerCertificate {
	s.CertificateChain = &v
	return s
}

// SetServerCertificateMetadata sets the ServerCertificateMetadata field's value.
func (s *ServerCertificate) SetServerCertificateMetadata(v *ServerCertificateMetadata) *ServerCertificate {
	s.ServerCertificateMetadata = v
	return s
}

// Contains information about a server certificate without its certificate body,
// certificate chain, and private key.
//
// This data type is used as a response element in the UploadServerCertificate
// and ListServerCertificates actions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ServerCertificateMetadata
type ServerCertificateMetadata struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specifying the server certificate. For more
	// information about ARNs and how to use them in policies, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The date on which the certificate is set to expire.
	Expiration *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The path to the server certificate. For more information about paths, see
	// IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// The stable and unique string identifying the server certificate. For more
	// information about IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// ServerCertificateId is a required field
	ServerCertificateId *string `min:"16" type:"string" required:"true"`

	// The name that identifies the server certificate.
	//
	// ServerCertificateName is a required field
	ServerCertificateName *string `min:"1" type:"string" required:"true"`

	// The date when the server certificate was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ServerCertificateMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerCertificateMetadata) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServerCertificateMetadata) SetArn(v string) *ServerCertificateMetadata {
	s.Arn = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *ServerCertificateMetadata) SetExpiration(v time.Time) *ServerCertificateMetadata {
	s.Expiration = &v
	return s
}

// SetPath sets the Path field's value.
func (s *ServerCertificateMetadata) SetPath(v string) *ServerCertificateMetadata {
	s.Path = &v
	return s
}

// SetServerCertificateId sets the ServerCertificateId field's value.
func (s *ServerCertificateMetadata) SetServerCertificateId(v string) *ServerCertificateMetadata {
	s.ServerCertificateId = &v
	return s
}

// SetServerCertificateName sets the ServerCertificateName field's value.
func (s *ServerCertificateMetadata) SetServerCertificateName(v string) *ServerCertificateMetadata {
	s.ServerCertificateName = &v
	return s
}

// SetUploadDate sets the UploadDate field's value.
func (s *ServerCertificateMetadata) SetUploadDate(v time.Time) *ServerCertificateMetadata {
	s.UploadDate = &v
	return s
}

// Contains the details of a service specific credential.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ServiceSpecificCredential
type ServiceSpecificCredential struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the service-specific credential were created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the service associated with the service-specific credential.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`

	// The generated password for the service-specific credential.
	//
	// ServicePassword is a required field
	ServicePassword *string `type:"string" required:"true"`

	// The unique identifier for the service-specific credential.
	//
	// ServiceSpecificCredentialId is a required field
	ServiceSpecificCredentialId *string `min:"20" type:"string" required:"true"`

	// The generated user name for the service-specific credential. This value is
	// generated by combining the IAM user's name combined with the ID number of
	// the AWS account, as in jane-at-123456789012, for example. This value cannot
	// be configured by the user.
	//
	// ServiceUserName is a required field
	ServiceUserName *string `min:"17" type:"string" required:"true"`

	// The status of the service-specific credential. Active means the key is valid
	// for API calls, while Inactive means it is not.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the IAM user associated with the service-specific credential.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceSpecificCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceSpecificCredential) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *ServiceSpecificCredential) SetCreateDate(v time.Time) *ServiceSpecificCredential {
	s.CreateDate = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceSpecificCredential) SetServiceName(v string) *ServiceSpecificCredential {
	s.ServiceName = &v
	return s
}

// SetServicePassword sets the ServicePassword field's value.
func (s *ServiceSpecificCredential) SetServicePassword(v string) *ServiceSpecificCredential {
	s.ServicePassword = &v
	return s
}

// SetServiceSpecificCredentialId sets the ServiceSpecificCredentialId field's value.
func (s *ServiceSpecificCredential) SetServiceSpecificCredentialId(v string) *ServiceSpecificCredential {
	s.ServiceSpecificCredentialId = &v
	return s
}

// SetServiceUserName sets the ServiceUserName field's value.
func (s *ServiceSpecificCredential) SetServiceUserName(v string) *ServiceSpecificCredential {
	s.ServiceUserName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceSpecificCredential) SetStatus(v string) *ServiceSpecificCredential {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ServiceSpecificCredential) SetUserName(v string) *ServiceSpecificCredential {
	s.UserName = &v
	return s
}

// Contains additional details about a service-specific credential.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ServiceSpecificCredentialMetadata
type ServiceSpecificCredentialMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the service-specific credential were created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the service associated with the service-specific credential.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`

	// The unique identifier for the service-specific credential.
	//
	// ServiceSpecificCredentialId is a required field
	ServiceSpecificCredentialId *string `min:"20" type:"string" required:"true"`

	// The generated user name for the service-specific credential.
	//
	// ServiceUserName is a required field
	ServiceUserName *string `min:"17" type:"string" required:"true"`

	// The status of the service-specific credential. Active means the key is valid
	// for API calls, while Inactive means it is not.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the IAM user associated with the service-specific credential.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceSpecificCredentialMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceSpecificCredentialMetadata) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *ServiceSpecificCredentialMetadata) SetCreateDate(v time.Time) *ServiceSpecificCredentialMetadata {
	s.CreateDate = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceSpecificCredentialMetadata) SetServiceName(v string) *ServiceSpecificCredentialMetadata {
	s.ServiceName = &v
	return s
}

// SetServiceSpecificCredentialId sets the ServiceSpecificCredentialId field's value.
func (s *ServiceSpecificCredentialMetadata) SetServiceSpecificCredentialId(v string) *ServiceSpecificCredentialMetadata {
	s.ServiceSpecificCredentialId = &v
	return s
}

// SetServiceUserName sets the ServiceUserName field's value.
func (s *ServiceSpecificCredentialMetadata) SetServiceUserName(v string) *ServiceSpecificCredentialMetadata {
	s.ServiceUserName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceSpecificCredentialMetadata) SetStatus(v string) *ServiceSpecificCredentialMetadata {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *ServiceSpecificCredentialMetadata) SetUserName(v string) *ServiceSpecificCredentialMetadata {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetDefaultPolicyVersionRequest
type SetDefaultPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy whose default version you
	// want to set.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The version of the policy to set as the default (operative) version.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (http://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	//
	// VersionId is a required field
	VersionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDefaultPolicyVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDefaultPolicyVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetDefaultPolicyVersionInput"}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 20))
	}
	if s.VersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *SetDefaultPolicyVersionInput) SetPolicyArn(v string) *SetDefaultPolicyVersionInput {
	s.PolicyArn = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *SetDefaultPolicyVersionInput) SetVersionId(v string) *SetDefaultPolicyVersionInput {
	s.VersionId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetDefaultPolicyVersionOutput
type SetDefaultPolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDefaultPolicyVersionOutput) GoString() string {
	return s.String()
}

// Contains information about an X.509 signing certificate.
//
// This data type is used as a response element in the UploadSigningCertificate
// and ListSigningCertificates actions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SigningCertificate
type SigningCertificate struct {
	_ struct{} `type:"structure"`

	// The contents of the signing certificate.
	//
	// CertificateBody is a required field
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The ID for the signing certificate.
	//
	// CertificateId is a required field
	CertificateId *string `min:"24" type:"string" required:"true"`

	// The status of the signing certificate. Active means the key is valid for
	// API calls, while Inactive means it is not.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The date when the signing certificate was uploaded.
	UploadDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The name of the user the signing certificate is associated with.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SigningCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SigningCertificate) GoString() string {
	return s.String()
}

// SetCertificateBody sets the CertificateBody field's value.
func (s *SigningCertificate) SetCertificateBody(v string) *SigningCertificate {
	s.CertificateBody = &v
	return s
}

// SetCertificateId sets the CertificateId field's value.
func (s *SigningCertificate) SetCertificateId(v string) *SigningCertificate {
	s.CertificateId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SigningCertificate) SetStatus(v string) *SigningCertificate {
	s.Status = &v
	return s
}

// SetUploadDate sets the UploadDate field's value.
func (s *SigningCertificate) SetUploadDate(v time.Time) *SigningCertificate {
	s.UploadDate = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *SigningCertificate) SetUserName(v string) *SigningCertificate {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulateCustomPolicyRequest
type SimulateCustomPolicyInput struct {
	_ struct{} `type:"structure"`

	// A list of names of API actions to evaluate in the simulation. Each action
	// is evaluated against each resource. Each action must include the service
	// identifier, such as iam:CreateUser.
	//
	// ActionNames is a required field
	ActionNames []*string `type:"list" required:"true"`

	// The ARN of the IAM user that you want to use as the simulated caller of the
	// APIs. CallerArn is required if you include a ResourcePolicy so that the policy's
	// Principal element has a value to use in evaluating the policy.
	//
	// You can specify only the ARN of an IAM user. You cannot specify the ARN of
	// an assumed role, federated user, or a service principal.
	CallerArn *string `min:"1" type:"string"`

	// A list of context keys and corresponding values for the simulation to use.
	// Whenever a context key is evaluated in one of the simulated IAM permission
	// policies, the corresponding value is supplied.
	ContextEntries []*ContextEntry `type:"list"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// A list of policy documents to include in the simulation. Each document is
	// specified as a string containing the complete, valid JSON text of an IAM
	// policy. Do not include any resource-based policies in this parameter. Any
	// resource-based policy must be submitted with the ResourcePolicy parameter.
	// The policies cannot be "scope-down" policies, such as you could include in
	// a call to GetFederationToken (http://docs.aws.amazon.com/IAM/latest/APIReference/API_GetFederationToken.html)
	// or one of the AssumeRole (http://docs.aws.amazon.com/IAM/latest/APIReference/API_AssumeRole.html)
	// APIs to restrict what a user can do while using the temporary credentials.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// PolicyInputList is a required field
	PolicyInputList []*string `type:"list" required:"true"`

	// A list of ARNs of AWS resources to include in the simulation. If this parameter
	// is not provided then the value defaults to * (all resources). Each API in
	// the ActionNames parameter is evaluated for each resource in this list. The
	// simulation determines the access result (allowed or denied) of each combination
	// and reports it in the response.
	//
	// The simulation does not automatically retrieve policies for the specified
	// resources. If you want to include a resource policy in the simulation, then
	// you must include the policy as a string in the ResourcePolicy parameter.
	//
	// If you include a ResourcePolicy, then it must be applicable to all of the
	// resources included in the simulation or you receive an invalid input error.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	ResourceArns []*string `type:"list"`

	// Specifies the type of simulation to run. Different APIs that support resource-based
	// policies require different combinations of resources. By specifying the type
	// of simulation to run, you enable the policy simulator to enforce the presence
	// of the required resources to ensure reliable simulation results. If your
	// simulation does not match one of the following scenarios, then you can omit
	// this parameter. The following list shows each of the supported scenario values
	// and the resources that you must define to run the simulation.
	//
	// Each of the EC2 scenarios requires that you specify instance, image, and
	// security-group resources. If your scenario includes an EBS volume, then you
	// must specify that volume as a resource. If the EC2 scenario includes VPC,
	// then you must supply the network-interface resource. If it includes an IP
	// subnet, then you must specify the subnet resource. For more information on
	// the EC2 scenario options, see Supported Platforms (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html)
	// in the AWS EC2 User Guide.
	//
	//    * EC2-Classic-InstanceStore
	//
	// instance, image, security-group
	//
	//    * EC2-Classic-EBS
	//
	// instance, image, security-group, volume
	//
	//    * EC2-VPC-InstanceStore
	//
	// instance, image, security-group, network-interface
	//
	//    * EC2-VPC-InstanceStore-Subnet
	//
	// instance, image, security-group, network-interface, subnet
	//
	//    * EC2-VPC-EBS
	//
	// instance, image, security-group, network-interface, volume
	//
	//    * EC2-VPC-EBS-Subnet
	//
	// instance, image, security-group, network-interface, subnet, volume
	ResourceHandlingOption *string `min:"1" type:"string"`

	// An AWS account ID that specifies the owner of any simulated resource that
	// does not identify its owner in the resource ARN, such as an S3 bucket or
	// object. If ResourceOwner is specified, it is also used as the account owner
	// of any ResourcePolicy included in the simulation. If the ResourceOwner parameter
	// is not specified, then the owner of the resources and the resource policy
	// defaults to the account of the identity provided in CallerArn. This parameter
	// is required only if you specify a resource-based policy and account that
	// owns the resource is different from the account that owns the simulated calling
	// user CallerArn.
	ResourceOwner *string `min:"1" type:"string"`

	// A resource-based policy to include in the simulation provided as a string.
	// Each resource in the simulation is treated as if it had this policy attached.
	// You can include only one resource-based policy in a simulation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	ResourcePolicy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SimulateCustomPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulateCustomPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimulateCustomPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SimulateCustomPolicyInput"}
	if s.ActionNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionNames"))
	}
	if s.CallerArn != nil && len(*s.CallerArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallerArn", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.PolicyInputList == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyInputList"))
	}
	if s.ResourceHandlingOption != nil && len(*s.ResourceHandlingOption) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceHandlingOption", 1))
	}
	if s.ResourceOwner != nil && len(*s.ResourceOwner) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceOwner", 1))
	}
	if s.ResourcePolicy != nil && len(*s.ResourcePolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourcePolicy", 1))
	}
	if s.ContextEntries != nil {
		for i, v := range s.ContextEntries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContextEntries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionNames sets the ActionNames field's value.
func (s *SimulateCustomPolicyInput) SetActionNames(v []*string) *SimulateCustomPolicyInput {
	s.ActionNames = v
	return s
}

// SetCallerArn sets the CallerArn field's value.
func (s *SimulateCustomPolicyInput) SetCallerArn(v string) *SimulateCustomPolicyInput {
	s.CallerArn = &v
	return s
}

// SetContextEntries sets the ContextEntries field's value.
func (s *SimulateCustomPolicyInput) SetContextEntries(v []*ContextEntry) *SimulateCustomPolicyInput {
	s.ContextEntries = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *SimulateCustomPolicyInput) SetMarker(v string) *SimulateCustomPolicyInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *SimulateCustomPolicyInput) SetMaxItems(v int64) *SimulateCustomPolicyInput {
	s.MaxItems = &v
	return s
}

// SetPolicyInputList sets the PolicyInputList field's value.
func (s *SimulateCustomPolicyInput) SetPolicyInputList(v []*string) *SimulateCustomPolicyInput {
	s.PolicyInputList = v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *SimulateCustomPolicyInput) SetResourceArns(v []*string) *SimulateCustomPolicyInput {
	s.ResourceArns = v
	return s
}

// SetResourceHandlingOption sets the ResourceHandlingOption field's value.
func (s *SimulateCustomPolicyInput) SetResourceHandlingOption(v string) *SimulateCustomPolicyInput {
	s.ResourceHandlingOption = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *SimulateCustomPolicyInput) SetResourceOwner(v string) *SimulateCustomPolicyInput {
	s.ResourceOwner = &v
	return s
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *SimulateCustomPolicyInput) SetResourcePolicy(v string) *SimulateCustomPolicyInput {
	s.ResourcePolicy = &v
	return s
}

// Contains the response to a successful SimulatePrincipalPolicy or SimulateCustomPolicy
// request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulatePolicyResponse
type SimulatePolicyResponse struct {
	_ struct{} `type:"structure"`

	// The results of the simulation.
	EvaluationResults []*EvaluationResult `type:"list"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all of your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SimulatePolicyResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulatePolicyResponse) GoString() string {
	return s.String()
}

// SetEvaluationResults sets the EvaluationResults field's value.
func (s *SimulatePolicyResponse) SetEvaluationResults(v []*EvaluationResult) *SimulatePolicyResponse {
	s.EvaluationResults = v
	return s
}

// SetIsTruncated sets the IsTruncated field's value.
func (s *SimulatePolicyResponse) SetIsTruncated(v bool) *SimulatePolicyResponse {
	s.IsTruncated = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *SimulatePolicyResponse) SetMarker(v string) *SimulatePolicyResponse {
	s.Marker = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulatePrincipalPolicyRequest
type SimulatePrincipalPolicyInput struct {
	_ struct{} `type:"structure"`

	// A list of names of API actions to evaluate in the simulation. Each action
	// is evaluated for each resource. Each action must include the service identifier,
	// such as iam:CreateUser.
	//
	// ActionNames is a required field
	ActionNames []*string `type:"list" required:"true"`

	// The ARN of the IAM user that you want to specify as the simulated caller
	// of the APIs. If you do not specify a CallerArn, it defaults to the ARN of
	// the user that you specify in PolicySourceArn, if you specified a user. If
	// you include both a PolicySourceArn (for example, arn:aws:iam::123456789012:user/David)
	// and a CallerArn (for example, arn:aws:iam::123456789012:user/Bob), the result
	// is that you simulate calling the APIs as Bob, as if Bob had David's policies.
	//
	// You can specify only the ARN of an IAM user. You cannot specify the ARN of
	// an assumed role, federated user, or a service principal.
	//
	// CallerArn is required if you include a ResourcePolicy and the PolicySourceArn
	// is not the ARN for an IAM user. This is required so that the resource-based
	// policy's Principal element has a value to use in evaluating the policy.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	CallerArn *string `min:"1" type:"string"`

	// A list of context keys and corresponding values for the simulation to use.
	// Whenever a context key is evaluated in one of the simulated IAM permission
	// policies, the corresponding value is supplied.
	ContextEntries []*ContextEntry `type:"list"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// (Optional) Use this only when paginating results to indicate the maximum
	// number of items you want in the response. If additional items exist beyond
	// the maximum you specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, it defaults to 100. Note that IAM might
	// return fewer results, even when there are more results available. In that
	// case, the IsTruncated response element returns true and Marker contains a
	// value to include in the subsequent call that tells the service where to continue
	// from.
	MaxItems *int64 `min:"1" type:"integer"`

	// An optional list of additional policy documents to include in the simulation.
	// Each document is specified as a string containing the complete, valid JSON
	// text of an IAM policy.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	PolicyInputList []*string `type:"list"`

	// The Amazon Resource Name (ARN) of a user, group, or role whose policies you
	// want to include in the simulation. If you specify a user, group, or role,
	// the simulation includes all policies that are associated with that entity.
	// If you specify a user, the simulation also includes all policies that are
	// attached to any groups the user belongs to.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicySourceArn is a required field
	PolicySourceArn *string `min:"20" type:"string" required:"true"`

	// A list of ARNs of AWS resources to include in the simulation. If this parameter
	// is not provided then the value defaults to * (all resources). Each API in
	// the ActionNames parameter is evaluated for each resource in this list. The
	// simulation determines the access result (allowed or denied) of each combination
	// and reports it in the response.
	//
	// The simulation does not automatically retrieve policies for the specified
	// resources. If you want to include a resource policy in the simulation, then
	// you must include the policy as a string in the ResourcePolicy parameter.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	ResourceArns []*string `type:"list"`

	// Specifies the type of simulation to run. Different APIs that support resource-based
	// policies require different combinations of resources. By specifying the type
	// of simulation to run, you enable the policy simulator to enforce the presence
	// of the required resources to ensure reliable simulation results. If your
	// simulation does not match one of the following scenarios, then you can omit
	// this parameter. The following list shows each of the supported scenario values
	// and the resources that you must define to run the simulation.
	//
	// Each of the EC2 scenarios requires that you specify instance, image, and
	// security-group resources. If your scenario includes an EBS volume, then you
	// must specify that volume as a resource. If the EC2 scenario includes VPC,
	// then you must supply the network-interface resource. If it includes an IP
	// subnet, then you must specify the subnet resource. For more information on
	// the EC2 scenario options, see Supported Platforms (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html)
	// in the AWS EC2 User Guide.
	//
	//    * EC2-Classic-InstanceStore
	//
	// instance, image, security-group
	//
	//    * EC2-Classic-EBS
	//
	// instance, image, security-group, volume
	//
	//    * EC2-VPC-InstanceStore
	//
	// instance, image, security-group, network-interface
	//
	//    * EC2-VPC-InstanceStore-Subnet
	//
	// instance, image, security-group, network-interface, subnet
	//
	//    * EC2-VPC-EBS
	//
	// instance, image, security-group, network-interface, volume
	//
	//    * EC2-VPC-EBS-Subnet
	//
	// instance, image, security-group, network-interface, subnet, volume
	ResourceHandlingOption *string `min:"1" type:"string"`

	// An AWS account ID that specifies the owner of any simulated resource that
	// does not identify its owner in the resource ARN, such as an S3 bucket or
	// object. If ResourceOwner is specified, it is also used as the account owner
	// of any ResourcePolicy included in the simulation. If the ResourceOwner parameter
	// is not specified, then the owner of the resources and the resource policy
	// defaults to the account of the identity provided in CallerArn. This parameter
	// is required only if you specify a resource-based policy and account that
	// owns the resource is different from the account that owns the simulated calling
	// user CallerArn.
	ResourceOwner *string `min:"1" type:"string"`

	// A resource-based policy to include in the simulation provided as a string.
	// Each resource in the simulation is treated as if it had this policy attached.
	// You can include only one resource-based policy in a simulation.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	ResourcePolicy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SimulatePrincipalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulatePrincipalPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimulatePrincipalPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SimulatePrincipalPolicyInput"}
	if s.ActionNames == nil {
		invalidParams.Add(request.NewErrParamRequired("ActionNames"))
	}
	if s.CallerArn != nil && len(*s.CallerArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallerArn", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.PolicySourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicySourceArn"))
	}
	if s.PolicySourceArn != nil && len(*s.PolicySourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("PolicySourceArn", 20))
	}
	if s.ResourceHandlingOption != nil && len(*s.ResourceHandlingOption) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceHandlingOption", 1))
	}
	if s.ResourceOwner != nil && len(*s.ResourceOwner) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceOwner", 1))
	}
	if s.ResourcePolicy != nil && len(*s.ResourcePolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourcePolicy", 1))
	}
	if s.ContextEntries != nil {
		for i, v := range s.ContextEntries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContextEntries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActionNames sets the ActionNames field's value.
func (s *SimulatePrincipalPolicyInput) SetActionNames(v []*string) *SimulatePrincipalPolicyInput {
	s.ActionNames = v
	return s
}

// SetCallerArn sets the CallerArn field's value.
func (s *SimulatePrincipalPolicyInput) SetCallerArn(v string) *SimulatePrincipalPolicyInput {
	s.CallerArn = &v
	return s
}

// SetContextEntries sets the ContextEntries field's value.
func (s *SimulatePrincipalPolicyInput) SetContextEntries(v []*ContextEntry) *SimulatePrincipalPolicyInput {
	s.ContextEntries = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *SimulatePrincipalPolicyInput) SetMarker(v string) *SimulatePrincipalPolicyInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *SimulatePrincipalPolicyInput) SetMaxItems(v int64) *SimulatePrincipalPolicyInput {
	s.MaxItems = &v
	return s
}

// SetPolicyInputList sets the PolicyInputList field's value.
func (s *SimulatePrincipalPolicyInput) SetPolicyInputList(v []*string) *SimulatePrincipalPolicyInput {
	s.PolicyInputList = v
	return s
}

// SetPolicySourceArn sets the PolicySourceArn field's value.
func (s *SimulatePrincipalPolicyInput) SetPolicySourceArn(v string) *SimulatePrincipalPolicyInput {
	s.PolicySourceArn = &v
	return s
}

// SetResourceArns sets the ResourceArns field's value.
func (s *SimulatePrincipalPolicyInput) SetResourceArns(v []*string) *SimulatePrincipalPolicyInput {
	s.ResourceArns = v
	return s
}

// SetResourceHandlingOption sets the ResourceHandlingOption field's value.
func (s *SimulatePrincipalPolicyInput) SetResourceHandlingOption(v string) *SimulatePrincipalPolicyInput {
	s.ResourceHandlingOption = &v
	return s
}

// SetResourceOwner sets the ResourceOwner field's value.
func (s *SimulatePrincipalPolicyInput) SetResourceOwner(v string) *SimulatePrincipalPolicyInput {
	s.ResourceOwner = &v
	return s
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *SimulatePrincipalPolicyInput) SetResourcePolicy(v string) *SimulatePrincipalPolicyInput {
	s.ResourcePolicy = &v
	return s
}

// Contains a reference to a Statement element in a policy document that determines
// the result of the simulation.
//
// This data type is used by the MatchedStatements member of the EvaluationResult
// type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/Statement
type Statement struct {
	_ struct{} `type:"structure"`

	// The row and column of the end of a Statement in an IAM policy.
	EndPosition *Position `type:"structure"`

	// The identifier of the policy that was provided as an input.
	SourcePolicyId *string `type:"string"`

	// The type of the policy.
	SourcePolicyType *string `type:"string" enum:"PolicySourceType"`

	// The row and column of the beginning of the Statement in an IAM policy.
	StartPosition *Position `type:"structure"`
}

// String returns the string representation
func (s Statement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Statement) GoString() string {
	return s.String()
}

// SetEndPosition sets the EndPosition field's value.
func (s *Statement) SetEndPosition(v *Position) *Statement {
	s.EndPosition = v
	return s
}

// SetSourcePolicyId sets the SourcePolicyId field's value.
func (s *Statement) SetSourcePolicyId(v string) *Statement {
	s.SourcePolicyId = &v
	return s
}

// SetSourcePolicyType sets the SourcePolicyType field's value.
func (s *Statement) SetSourcePolicyType(v string) *Statement {
	s.SourcePolicyType = &v
	return s
}

// SetStartPosition sets the StartPosition field's value.
func (s *Statement) SetStartPosition(v *Position) *Statement {
	s.StartPosition = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccessKeyRequest
type UpdateAccessKeyInput struct {
	_ struct{} `type:"structure"`

	// The access key ID of the secret access key you want to update.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `min:"16" type:"string" required:"true"`

	// The status you want to assign to the secret access key. Active means the
	// key can be used for API calls to AWS, while Inactive means the key cannot
	// be used.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the user whose key you want to update.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAccessKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccessKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccessKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccessKeyInput"}
	if s.AccessKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessKeyId"))
	}
	if s.AccessKeyId != nil && len(*s.AccessKeyId) < 16 {
		invalidParams.Add(request.NewErrParamMinLen("AccessKeyId", 16))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *UpdateAccessKeyInput) SetAccessKeyId(v string) *UpdateAccessKeyInput {
	s.AccessKeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateAccessKeyInput) SetStatus(v string) *UpdateAccessKeyInput {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateAccessKeyInput) SetUserName(v string) *UpdateAccessKeyInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccessKeyOutput
type UpdateAccessKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAccessKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccessKeyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccountPasswordPolicyRequest
type UpdateAccountPasswordPolicyInput struct {
	_ struct{} `type:"structure"`

	// Allows all IAM users in your account to use the AWS Management Console to
	// change their own passwords. For more information, see Letting IAM Users Change
	// Their Own Passwords (http://docs.aws.amazon.com/IAM/latest/UserGuide/HowToPwdIAMUser.html)
	// in the IAM User Guide.
	//
	// Default value: false
	AllowUsersToChangePassword *bool `type:"boolean"`

	// Prevents IAM users from setting a new password after their password has expired.
	//
	// Default value: false
	HardExpiry *bool `type:"boolean"`

	// The number of days that an IAM user password is valid. The default value
	// of 0 means IAM user passwords never expire.
	//
	// Default value: 0
	MaxPasswordAge *int64 `min:"1" type:"integer"`

	// The minimum number of characters allowed in an IAM user password.
	//
	// Default value: 6
	MinimumPasswordLength *int64 `min:"6" type:"integer"`

	// Specifies the number of previous passwords that IAM users are prevented from
	// reusing. The default value of 0 means IAM users are not prevented from reusing
	// previous passwords.
	//
	// Default value: 0
	PasswordReusePrevention *int64 `min:"1" type:"integer"`

	// Specifies whether IAM user passwords must contain at least one lowercase
	// character from the ISO basic Latin alphabet (a to z).
	//
	// Default value: false
	RequireLowercaseCharacters *bool `type:"boolean"`

	// Specifies whether IAM user passwords must contain at least one numeric character
	// (0 to 9).
	//
	// Default value: false
	RequireNumbers *bool `type:"boolean"`

	// Specifies whether IAM user passwords must contain at least one of the following
	// non-alphanumeric characters:
	//
	// ! @ # $ % ^ & * ( ) _ + - = [ ] { } | '
	//
	// Default value: false
	RequireSymbols *bool `type:"boolean"`

	// Specifies whether IAM user passwords must contain at least one uppercase
	// character from the ISO basic Latin alphabet (A to Z).
	//
	// Default value: false
	RequireUppercaseCharacters *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateAccountPasswordPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountPasswordPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccountPasswordPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccountPasswordPolicyInput"}
	if s.MaxPasswordAge != nil && *s.MaxPasswordAge < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxPasswordAge", 1))
	}
	if s.MinimumPasswordLength != nil && *s.MinimumPasswordLength < 6 {
		invalidParams.Add(request.NewErrParamMinValue("MinimumPasswordLength", 6))
	}
	if s.PasswordReusePrevention != nil && *s.PasswordReusePrevention < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PasswordReusePrevention", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowUsersToChangePassword sets the AllowUsersToChangePassword field's value.
func (s *UpdateAccountPasswordPolicyInput) SetAllowUsersToChangePassword(v bool) *UpdateAccountPasswordPolicyInput {
	s.AllowUsersToChangePassword = &v
	return s
}

// SetHardExpiry sets the HardExpiry field's value.
func (s *UpdateAccountPasswordPolicyInput) SetHardExpiry(v bool) *UpdateAccountPasswordPolicyInput {
	s.HardExpiry = &v
	return s
}

// SetMaxPasswordAge sets the MaxPasswordAge field's value.
func (s *UpdateAccountPasswordPolicyInput) SetMaxPasswordAge(v int64) *UpdateAccountPasswordPolicyInput {
	s.MaxPasswordAge = &v
	return s
}

// SetMinimumPasswordLength sets the MinimumPasswordLength field's value.
func (s *UpdateAccountPasswordPolicyInput) SetMinimumPasswordLength(v int64) *UpdateAccountPasswordPolicyInput {
	s.MinimumPasswordLength = &v
	return s
}

// SetPasswordReusePrevention sets the PasswordReusePrevention field's value.
func (s *UpdateAccountPasswordPolicyInput) SetPasswordReusePrevention(v int64) *UpdateAccountPasswordPolicyInput {
	s.PasswordReusePrevention = &v
	return s
}

// SetRequireLowercaseCharacters sets the RequireLowercaseCharacters field's value.
func (s *UpdateAccountPasswordPolicyInput) SetRequireLowercaseCharacters(v bool) *UpdateAccountPasswordPolicyInput {
	s.RequireLowercaseCharacters = &v
	return s
}

// SetRequireNumbers sets the RequireNumbers field's value.
func (s *UpdateAccountPasswordPolicyInput) SetRequireNumbers(v bool) *UpdateAccountPasswordPolicyInput {
	s.RequireNumbers = &v
	return s
}

// SetRequireSymbols sets the RequireSymbols field's value.
func (s *UpdateAccountPasswordPolicyInput) SetRequireSymbols(v bool) *UpdateAccountPasswordPolicyInput {
	s.RequireSymbols = &v
	return s
}

// SetRequireUppercaseCharacters sets the RequireUppercaseCharacters field's value.
func (s *UpdateAccountPasswordPolicyInput) SetRequireUppercaseCharacters(v bool) *UpdateAccountPasswordPolicyInput {
	s.RequireUppercaseCharacters = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccountPasswordPolicyOutput
type UpdateAccountPasswordPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAccountPasswordPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAccountPasswordPolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAssumeRolePolicyRequest
type UpdateAssumeRolePolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy that grants an entity permission to assume the role.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// PolicyDocument is a required field
	PolicyDocument *string `min:"1" type:"string" required:"true"`

	// The name of the role to update with the new policy.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// RoleName is a required field
	RoleName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAssumeRolePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssumeRolePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAssumeRolePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAssumeRolePolicyInput"}
	if s.PolicyDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyDocument"))
	}
	if s.PolicyDocument != nil && len(*s.PolicyDocument) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyDocument", 1))
	}
	if s.RoleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleName"))
	}
	if s.RoleName != nil && len(*s.RoleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicyDocument sets the PolicyDocument field's value.
func (s *UpdateAssumeRolePolicyInput) SetPolicyDocument(v string) *UpdateAssumeRolePolicyInput {
	s.PolicyDocument = &v
	return s
}

// SetRoleName sets the RoleName field's value.
func (s *UpdateAssumeRolePolicyInput) SetRoleName(v string) *UpdateAssumeRolePolicyInput {
	s.RoleName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAssumeRolePolicyOutput
type UpdateAssumeRolePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAssumeRolePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAssumeRolePolicyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateGroupRequest
type UpdateGroupInput struct {
	_ struct{} `type:"structure"`

	// Name of the IAM group to update. If you're changing the name of the group,
	// this is the original name.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// New name for the IAM group. Only include this if changing the group's name.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	NewGroupName *string `min:"1" type:"string"`

	// New path for the IAM group. Only include this if changing the group's path.
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	NewPath *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.GroupName != nil && len(*s.GroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupName", 1))
	}
	if s.NewGroupName != nil && len(*s.NewGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewGroupName", 1))
	}
	if s.NewPath != nil && len(*s.NewPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupName sets the GroupName field's value.
func (s *UpdateGroupInput) SetGroupName(v string) *UpdateGroupInput {
	s.GroupName = &v
	return s
}

// SetNewGroupName sets the NewGroupName field's value.
func (s *UpdateGroupInput) SetNewGroupName(v string) *UpdateGroupInput {
	s.NewGroupName = &v
	return s
}

// SetNewPath sets the NewPath field's value.
func (s *UpdateGroupInput) SetNewPath(v string) *UpdateGroupInput {
	s.NewPath = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateGroupOutput
type UpdateGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateLoginProfileRequest
type UpdateLoginProfileInput struct {
	_ struct{} `type:"structure"`

	// The new password for the specified IAM user.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D). However,
	// the format can be further restricted by the account administrator by setting
	// a password policy on the AWS account. For more information, see UpdateAccountPasswordPolicy.
	Password *string `min:"1" type:"string"`

	// Allows this new password to be used only once by requiring the specified
	// IAM user to set a new password on next sign-in.
	PasswordResetRequired *bool `type:"boolean"`

	// The name of the user whose password you want to update.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateLoginProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoginProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLoginProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLoginProfileInput"}
	if s.Password != nil && len(*s.Password) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPassword sets the Password field's value.
func (s *UpdateLoginProfileInput) SetPassword(v string) *UpdateLoginProfileInput {
	s.Password = &v
	return s
}

// SetPasswordResetRequired sets the PasswordResetRequired field's value.
func (s *UpdateLoginProfileInput) SetPasswordResetRequired(v bool) *UpdateLoginProfileInput {
	s.PasswordResetRequired = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateLoginProfileInput) SetUserName(v string) *UpdateLoginProfileInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateLoginProfileOutput
type UpdateLoginProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLoginProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLoginProfileOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateOpenIDConnectProviderThumbprintRequest
type UpdateOpenIDConnectProviderThumbprintInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM OIDC provider resource object for
	// which you want to update the thumbprint. You can get a list of OIDC provider
	// ARNs by using the ListOpenIDConnectProviders action.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// OpenIDConnectProviderArn is a required field
	OpenIDConnectProviderArn *string `min:"20" type:"string" required:"true"`

	// A list of certificate thumbprints that are associated with the specified
	// IAM OpenID Connect provider. For more information, see CreateOpenIDConnectProvider.
	//
	// ThumbprintList is a required field
	ThumbprintList []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateOpenIDConnectProviderThumbprintInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOpenIDConnectProviderThumbprintInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateOpenIDConnectProviderThumbprintInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateOpenIDConnectProviderThumbprintInput"}
	if s.OpenIDConnectProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("OpenIDConnectProviderArn"))
	}
	if s.OpenIDConnectProviderArn != nil && len(*s.OpenIDConnectProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("OpenIDConnectProviderArn", 20))
	}
	if s.ThumbprintList == nil {
		invalidParams.Add(request.NewErrParamRequired("ThumbprintList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOpenIDConnectProviderArn sets the OpenIDConnectProviderArn field's value.
func (s *UpdateOpenIDConnectProviderThumbprintInput) SetOpenIDConnectProviderArn(v string) *UpdateOpenIDConnectProviderThumbprintInput {
	s.OpenIDConnectProviderArn = &v
	return s
}

// SetThumbprintList sets the ThumbprintList field's value.
func (s *UpdateOpenIDConnectProviderThumbprintInput) SetThumbprintList(v []*string) *UpdateOpenIDConnectProviderThumbprintInput {
	s.ThumbprintList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateOpenIDConnectProviderThumbprintOutput
type UpdateOpenIDConnectProviderThumbprintOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateOpenIDConnectProviderThumbprintOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateOpenIDConnectProviderThumbprintOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSAMLProviderRequest
type UpdateSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// An XML document generated by an identity provider (IdP) that supports SAML
	// 2.0. The document includes the issuer's name, expiration information, and
	// keys that can be used to validate the SAML authentication response (assertions)
	// that are received from the IdP. You must generate the metadata document using
	// the identity management software that is used as your organization's IdP.
	//
	// SAMLMetadataDocument is a required field
	SAMLMetadataDocument *string `min:"1000" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the SAML provider to update.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// SAMLProviderArn is a required field
	SAMLProviderArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSAMLProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSAMLProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSAMLProviderInput"}
	if s.SAMLMetadataDocument == nil {
		invalidParams.Add(request.NewErrParamRequired("SAMLMetadataDocument"))
	}
	if s.SAMLMetadataDocument != nil && len(*s.SAMLMetadataDocument) < 1000 {
		invalidParams.Add(request.NewErrParamMinLen("SAMLMetadataDocument", 1000))
	}
	if s.SAMLProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SAMLProviderArn"))
	}
	if s.SAMLProviderArn != nil && len(*s.SAMLProviderArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SAMLProviderArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSAMLMetadataDocument sets the SAMLMetadataDocument field's value.
func (s *UpdateSAMLProviderInput) SetSAMLMetadataDocument(v string) *UpdateSAMLProviderInput {
	s.SAMLMetadataDocument = &v
	return s
}

// SetSAMLProviderArn sets the SAMLProviderArn field's value.
func (s *UpdateSAMLProviderInput) SetSAMLProviderArn(v string) *UpdateSAMLProviderInput {
	s.SAMLProviderArn = &v
	return s
}

// Contains the response to a successful UpdateSAMLProvider request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSAMLProviderResponse
type UpdateSAMLProviderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the SAML provider that was updated.
	SAMLProviderArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s UpdateSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSAMLProviderOutput) GoString() string {
	return s.String()
}

// SetSAMLProviderArn sets the SAMLProviderArn field's value.
func (s *UpdateSAMLProviderOutput) SetSAMLProviderArn(v string) *UpdateSAMLProviderOutput {
	s.SAMLProviderArn = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSSHPublicKeyRequest
type UpdateSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the SSH public key.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// SSHPublicKeyId is a required field
	SSHPublicKeyId *string `min:"20" type:"string" required:"true"`

	// The status to assign to the SSH public key. Active means the key can be used
	// for authentication with an AWS CodeCommit repository. Inactive means the
	// key cannot be used.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the IAM user associated with the SSH public key.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSSHPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSSHPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSSHPublicKeyInput"}
	if s.SSHPublicKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("SSHPublicKeyId"))
	}
	if s.SSHPublicKeyId != nil && len(*s.SSHPublicKeyId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SSHPublicKeyId", 20))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSSHPublicKeyId sets the SSHPublicKeyId field's value.
func (s *UpdateSSHPublicKeyInput) SetSSHPublicKeyId(v string) *UpdateSSHPublicKeyInput {
	s.SSHPublicKeyId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateSSHPublicKeyInput) SetStatus(v string) *UpdateSSHPublicKeyInput {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateSSHPublicKeyInput) SetUserName(v string) *UpdateSSHPublicKeyInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSSHPublicKeyOutput
type UpdateSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSSHPublicKeyOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServerCertificateRequest
type UpdateServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The new path for the server certificate. Include this only if you are updating
	// the server certificate's path.
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	NewPath *string `min:"1" type:"string"`

	// The new name for the server certificate. Include this only if you are updating
	// the server certificate's name. The name of the certificate cannot contain
	// any spaces.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	NewServerCertificateName *string `min:"1" type:"string"`

	// The name of the server certificate that you want to update.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// ServerCertificateName is a required field
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServerCertificateInput"}
	if s.NewPath != nil && len(*s.NewPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewPath", 1))
	}
	if s.NewServerCertificateName != nil && len(*s.NewServerCertificateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewServerCertificateName", 1))
	}
	if s.ServerCertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerCertificateName"))
	}
	if s.ServerCertificateName != nil && len(*s.ServerCertificateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerCertificateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNewPath sets the NewPath field's value.
func (s *UpdateServerCertificateInput) SetNewPath(v string) *UpdateServerCertificateInput {
	s.NewPath = &v
	return s
}

// SetNewServerCertificateName sets the NewServerCertificateName field's value.
func (s *UpdateServerCertificateInput) SetNewServerCertificateName(v string) *UpdateServerCertificateInput {
	s.NewServerCertificateName = &v
	return s
}

// SetServerCertificateName sets the ServerCertificateName field's value.
func (s *UpdateServerCertificateInput) SetServerCertificateName(v string) *UpdateServerCertificateInput {
	s.ServerCertificateName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServerCertificateOutput
type UpdateServerCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerCertificateOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServiceSpecificCredentialRequest
type UpdateServiceSpecificCredentialInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the service-specific credential.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// ServiceSpecificCredentialId is a required field
	ServiceSpecificCredentialId *string `min:"20" type:"string" required:"true"`

	// The status to be assigned to the service-specific credential.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the IAM user associated with the service-specific credential.
	// If you do not specify this value, then the operation assumes the user whose
	// credentials are used to call the operation.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateServiceSpecificCredentialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceSpecificCredentialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceSpecificCredentialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceSpecificCredentialInput"}
	if s.ServiceSpecificCredentialId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceSpecificCredentialId"))
	}
	if s.ServiceSpecificCredentialId != nil && len(*s.ServiceSpecificCredentialId) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceSpecificCredentialId", 20))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceSpecificCredentialId sets the ServiceSpecificCredentialId field's value.
func (s *UpdateServiceSpecificCredentialInput) SetServiceSpecificCredentialId(v string) *UpdateServiceSpecificCredentialInput {
	s.ServiceSpecificCredentialId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateServiceSpecificCredentialInput) SetStatus(v string) *UpdateServiceSpecificCredentialInput {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateServiceSpecificCredentialInput) SetUserName(v string) *UpdateServiceSpecificCredentialInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServiceSpecificCredentialOutput
type UpdateServiceSpecificCredentialOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateServiceSpecificCredentialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceSpecificCredentialOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSigningCertificateRequest
type UpdateSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the signing certificate you want to update.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters that can consist of any upper or lowercased letter
	// or digit.
	//
	// CertificateId is a required field
	CertificateId *string `min:"24" type:"string" required:"true"`

	// The status you want to assign to the certificate. Active means the certificate
	// can be used for API calls to AWS, while Inactive means the certificate cannot
	// be used.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"statusType"`

	// The name of the IAM user the signing certificate belongs to.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSigningCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSigningCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSigningCertificateInput"}
	if s.CertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 24 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateId", 24))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateId sets the CertificateId field's value.
func (s *UpdateSigningCertificateInput) SetCertificateId(v string) *UpdateSigningCertificateInput {
	s.CertificateId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateSigningCertificateInput) SetStatus(v string) *UpdateSigningCertificateInput {
	s.Status = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateSigningCertificateInput) SetUserName(v string) *UpdateSigningCertificateInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSigningCertificateOutput
type UpdateSigningCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSigningCertificateOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateUserRequest
type UpdateUserInput struct {
	_ struct{} `type:"structure"`

	// New path for the IAM user. Include this parameter only if you're changing
	// the user's path.
	//
	// This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	NewPath *string `min:"1" type:"string"`

	// New name for the user. Include this parameter only if you're changing the
	// user's name.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	NewUserName *string `min:"1" type:"string"`

	// Name of the user to update. If you're changing the name of the user, this
	// is the original user name.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserInput"}
	if s.NewPath != nil && len(*s.NewPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewPath", 1))
	}
	if s.NewUserName != nil && len(*s.NewUserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NewUserName", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNewPath sets the NewPath field's value.
func (s *UpdateUserInput) SetNewPath(v string) *UpdateUserInput {
	s.NewPath = &v
	return s
}

// SetNewUserName sets the NewUserName field's value.
func (s *UpdateUserInput) SetNewUserName(v string) *UpdateUserInput {
	s.NewUserName = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UpdateUserInput) SetUserName(v string) *UpdateUserInput {
	s.UserName = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateUserOutput
type UpdateUserOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserOutput) GoString() string {
	return s.String()
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSSHPublicKeyRequest
type UploadSSHPublicKeyInput struct {
	_ struct{} `type:"structure"`

	// The SSH public key. The public key must be encoded in ssh-rsa format or PEM
	// format.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// SSHPublicKeyBody is a required field
	SSHPublicKeyBody *string `min:"1" type:"string" required:"true"`

	// The name of the IAM user to associate the SSH public key with.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadSSHPublicKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadSSHPublicKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadSSHPublicKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadSSHPublicKeyInput"}
	if s.SSHPublicKeyBody == nil {
		invalidParams.Add(request.NewErrParamRequired("SSHPublicKeyBody"))
	}
	if s.SSHPublicKeyBody != nil && len(*s.SSHPublicKeyBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SSHPublicKeyBody", 1))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSSHPublicKeyBody sets the SSHPublicKeyBody field's value.
func (s *UploadSSHPublicKeyInput) SetSSHPublicKeyBody(v string) *UploadSSHPublicKeyInput {
	s.SSHPublicKeyBody = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UploadSSHPublicKeyInput) SetUserName(v string) *UploadSSHPublicKeyInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful UploadSSHPublicKey request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSSHPublicKeyResponse
type UploadSSHPublicKeyOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about the SSH public key.
	SSHPublicKey *SSHPublicKey `type:"structure"`
}

// String returns the string representation
func (s UploadSSHPublicKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadSSHPublicKeyOutput) GoString() string {
	return s.String()
}

// SetSSHPublicKey sets the SSHPublicKey field's value.
func (s *UploadSSHPublicKeyOutput) SetSSHPublicKey(v *SSHPublicKey) *UploadSSHPublicKeyOutput {
	s.SSHPublicKey = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadServerCertificateRequest
type UploadServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The contents of the public key certificate in PEM-encoded format.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// CertificateBody is a required field
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The contents of the certificate chain. This is typically a concatenation
	// of the PEM-encoded public key certificates of the chain.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	CertificateChain *string `min:"1" type:"string"`

	// The path for the server certificate. For more information about paths, see
	// IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the IAM User Guide.
	//
	// This parameter is optional. If it is not included, it defaults to a slash
	// (/). This paramater allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes, containing any
	// ASCII character from the ! (\u0021) thru the DEL character (\u007F), including
	// most punctuation characters, digits, and upper and lowercased letters.
	//
	// If you are uploading a server certificate specifically for use with Amazon
	// CloudFront distributions, you must specify a path using the --path option.
	// The path must begin with /cloudfront and must include a trailing slash (for
	// example, /cloudfront/test/).
	Path *string `min:"1" type:"string"`

	// The contents of the private key in PEM-encoded format.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// PrivateKey is a required field
	PrivateKey *string `min:"1" type:"string" required:"true"`

	// The name for the server certificate. Do not include the path in this value.
	// The name of the certificate cannot contain any spaces.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	//
	// ServerCertificateName is a required field
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UploadServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadServerCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadServerCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadServerCertificateInput"}
	if s.CertificateBody == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateBody"))
	}
	if s.CertificateBody != nil && len(*s.CertificateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateBody", 1))
	}
	if s.CertificateChain != nil && len(*s.CertificateChain) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateChain", 1))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.PrivateKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKey"))
	}
	if s.PrivateKey != nil && len(*s.PrivateKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrivateKey", 1))
	}
	if s.ServerCertificateName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerCertificateName"))
	}
	if s.ServerCertificateName != nil && len(*s.ServerCertificateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerCertificateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateBody sets the CertificateBody field's value.
func (s *UploadServerCertificateInput) SetCertificateBody(v string) *UploadServerCertificateInput {
	s.CertificateBody = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *UploadServerCertificateInput) SetCertificateChain(v string) *UploadServerCertificateInput {
	s.CertificateChain = &v
	return s
}

// SetPath sets the Path field's value.
func (s *UploadServerCertificateInput) SetPath(v string) *UploadServerCertificateInput {
	s.Path = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *UploadServerCertificateInput) SetPrivateKey(v string) *UploadServerCertificateInput {
	s.PrivateKey = &v
	return s
}

// SetServerCertificateName sets the ServerCertificateName field's value.
func (s *UploadServerCertificateInput) SetServerCertificateName(v string) *UploadServerCertificateInput {
	s.ServerCertificateName = &v
	return s
}

// Contains the response to a successful UploadServerCertificate request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadServerCertificateResponse
type UploadServerCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The meta information of the uploaded server certificate without its certificate
	// body, certificate chain, and private key.
	ServerCertificateMetadata *ServerCertificateMetadata `type:"structure"`
}

// String returns the string representation
func (s UploadServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadServerCertificateOutput) GoString() string {
	return s.String()
}

// SetServerCertificateMetadata sets the ServerCertificateMetadata field's value.
func (s *UploadServerCertificateOutput) SetServerCertificateMetadata(v *ServerCertificateMetadata) *UploadServerCertificateOutput {
	s.ServerCertificateMetadata = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSigningCertificateRequest
type UploadSigningCertificateInput struct {
	_ struct{} `type:"structure"`

	// The contents of the signing certificate.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) used to validate this
	// parameter is a string of characters consisting of any printable ASCII character
	// ranging from the space character (\u0020) through end of the ASCII character
	// range as well as the printable characters in the Basic Latin and Latin-1
	// Supplement character set (through \u00FF). It also includes the special characters
	// tab (\u0009), line feed (\u000A), and carriage return (\u000D).
	//
	// CertificateBody is a required field
	CertificateBody *string `min:"1" type:"string" required:"true"`

	// The name of the user the signing certificate is for.
	//
	// This parameter allows (per its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: =,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UploadSigningCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadSigningCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadSigningCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadSigningCertificateInput"}
	if s.CertificateBody == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateBody"))
	}
	if s.CertificateBody != nil && len(*s.CertificateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateBody", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateBody sets the CertificateBody field's value.
func (s *UploadSigningCertificateInput) SetCertificateBody(v string) *UploadSigningCertificateInput {
	s.CertificateBody = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UploadSigningCertificateInput) SetUserName(v string) *UploadSigningCertificateInput {
	s.UserName = &v
	return s
}

// Contains the response to a successful UploadSigningCertificate request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSigningCertificateResponse
type UploadSigningCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Information about the certificate.
	//
	// Certificate is a required field
	Certificate *SigningCertificate `type:"structure" required:"true"`
}

// String returns the string representation
func (s UploadSigningCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadSigningCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *UploadSigningCertificateOutput) SetCertificate(v *SigningCertificate) *UploadSigningCertificateOutput {
	s.Certificate = v
	return s
}

// Contains information about an IAM user entity.
//
// This data type is used as a response element in the following actions:
//
//    * CreateUser
//
//    * GetUser
//
//    * ListUsers
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/User
type User struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the user. For more information
	// about ARNs and how to use ARNs in policies, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Arn is a required field
	Arn *string `min:"20" type:"string" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the user was created.
	//
	// CreateDate is a required field
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the user's password was last used to sign in to an AWS website. For
	// a list of AWS websites that capture a user's last sign-in time, see the Credential
	// Reports (http://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html)
	// topic in the Using IAM guide. If a password is used more than once in a five-minute
	// span, only the first use is returned in this field. This field is null (not
	// present) when:
	//
	//    * The user does not have a password
	//
	//    * The password exists but has never been used (at least not since IAM
	//    started tracking this information on October 20th, 2014
	//
	//    * there is no sign-in data associated with the user
	//
	// This value is returned only in the GetUser and ListUsers actions.
	PasswordLastUsed *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The path to the user. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// Path is a required field
	Path *string `min:"1" type:"string" required:"true"`

	// The stable and unique string identifying the user. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	//
	// UserId is a required field
	UserId *string `min:"16" type:"string" required:"true"`

	// The friendly name identifying the user.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s User) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s User) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *User) SetArn(v string) *User {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *User) SetCreateDate(v time.Time) *User {
	s.CreateDate = &v
	return s
}

// SetPasswordLastUsed sets the PasswordLastUsed field's value.
func (s *User) SetPasswordLastUsed(v time.Time) *User {
	s.PasswordLastUsed = &v
	return s
}

// SetPath sets the Path field's value.
func (s *User) SetPath(v string) *User {
	s.Path = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *User) SetUserId(v string) *User {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *User) SetUserName(v string) *User {
	s.UserName = &v
	return s
}

// Contains information about an IAM user, including all the user's policies
// and all the IAM groups the user is in.
//
// This data type is used as a response element in the GetAccountAuthorizationDetails
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UserDetail
type UserDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN). ARNs are unique identifiers for AWS resources.
	//
	// For more information about ARNs, go to Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// A list of the managed policies attached to the user.
	AttachedManagedPolicies []*AttachedPolicy `type:"list"`

	// The date and time, in ISO 8601 date-time format (http://www.iso.org/iso/iso8601),
	// when the user was created.
	CreateDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A list of IAM groups that the user is in.
	GroupList []*string `type:"list"`

	// The path to the user. For more information about paths, see IAM Identifiers
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	Path *string `min:"1" type:"string"`

	// The stable and unique string identifying the user. For more information about
	// IDs, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html)
	// in the Using IAM guide.
	UserId *string `min:"16" type:"string"`

	// The friendly name identifying the user.
	UserName *string `min:"1" type:"string"`

	// A list of the inline policies embedded in the user.
	UserPolicyList []*PolicyDetail `type:"list"`
}

// String returns the string representation
func (s UserDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UserDetail) SetArn(v string) *UserDetail {
	s.Arn = &v
	return s
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *UserDetail) SetAttachedManagedPolicies(v []*AttachedPolicy) *UserDetail {
	s.AttachedManagedPolicies = v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *UserDetail) SetCreateDate(v time.Time) *UserDetail {
	s.CreateDate = &v
	return s
}

// SetGroupList sets the GroupList field's value.
func (s *UserDetail) SetGroupList(v []*string) *UserDetail {
	s.GroupList = v
	return s
}

// SetPath sets the Path field's value.
func (s *UserDetail) SetPath(v string) *UserDetail {
	s.Path = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *UserDetail) SetUserId(v string) *UserDetail {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *UserDetail) SetUserName(v string) *UserDetail {
	s.UserName = &v
	return s
}

// SetUserPolicyList sets the UserPolicyList field's value.
func (s *UserDetail) SetUserPolicyList(v []*PolicyDetail) *UserDetail {
	s.UserPolicyList = v
	return s
}

// Contains information about a virtual MFA device.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/VirtualMFADevice
type VirtualMFADevice struct {
	_ struct{} `type:"structure"`

	// The Base32 seed defined as specified in RFC3548 (https://tools.ietf.org/html/rfc3548.txt).
	// The Base32StringSeed is Base64-encoded.
	//
	// Base32StringSeed is automatically base64 encoded/decoded by the SDK.
	Base32StringSeed []byte `type:"blob"`

	// The date and time on which the virtual MFA device was enabled.
	EnableDate *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A QR code PNG image that encodes otpauth://totp/$virtualMFADeviceName@$AccountName?secret=$Base32String
	// where $virtualMFADeviceName is one of the create call arguments, AccountName
	// is the user name if set (otherwise, the account ID otherwise), and Base32String
	// is the seed in Base32 format. The Base32String value is Base64-encoded.
	//
	// QRCodePNG is automatically base64 encoded/decoded by the SDK.
	QRCodePNG []byte `type:"blob"`

	// The serial number associated with VirtualMFADevice.
	//
	// SerialNumber is a required field
	SerialNumber *string `min:"9" type:"string" required:"true"`

	// The user to whom the MFA device is assigned.
	User *User `type:"structure"`
}

// String returns the string representation
func (s VirtualMFADevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualMFADevice) GoString() string {
	return s.String()
}

// SetBase32StringSeed sets the Base32StringSeed field's value.
func (s *VirtualMFADevice) SetBase32StringSeed(v []byte) *VirtualMFADevice {
	s.Base32StringSeed = v
	return s
}

// SetEnableDate sets the EnableDate field's value.
func (s *VirtualMFADevice) SetEnableDate(v time.Time) *VirtualMFADevice {
	s.EnableDate = &v
	return s
}

// SetQRCodePNG sets the QRCodePNG field's value.
func (s *VirtualMFADevice) SetQRCodePNG(v []byte) *VirtualMFADevice {
	s.QRCodePNG = v
	return s
}

// SetSerialNumber sets the SerialNumber field's value.
func (s *VirtualMFADevice) SetSerialNumber(v string) *VirtualMFADevice {
	s.SerialNumber = &v
	return s
}

// SetUser sets the User field's value.
func (s *VirtualMFADevice) SetUser(v *User) *VirtualMFADevice {
	s.User = v
	return s
}

const (
	// ContextKeyTypeEnumString is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumString = "string"

	// ContextKeyTypeEnumStringList is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumStringList = "stringList"

	// ContextKeyTypeEnumNumeric is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumNumeric = "numeric"

	// ContextKeyTypeEnumNumericList is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumNumericList = "numericList"

	// ContextKeyTypeEnumBoolean is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumBoolean = "boolean"

	// ContextKeyTypeEnumBooleanList is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumBooleanList = "booleanList"

	// ContextKeyTypeEnumIp is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumIp = "ip"

	// ContextKeyTypeEnumIpList is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumIpList = "ipList"

	// ContextKeyTypeEnumBinary is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumBinary = "binary"

	// ContextKeyTypeEnumBinaryList is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumBinaryList = "binaryList"

	// ContextKeyTypeEnumDate is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumDate = "date"

	// ContextKeyTypeEnumDateList is a ContextKeyTypeEnum enum value
	ContextKeyTypeEnumDateList = "dateList"
)

const (
	// EntityTypeUser is a EntityType enum value
	EntityTypeUser = "User"

	// EntityTypeRole is a EntityType enum value
	EntityTypeRole = "Role"

	// EntityTypeGroup is a EntityType enum value
	EntityTypeGroup = "Group"

	// EntityTypeLocalManagedPolicy is a EntityType enum value
	EntityTypeLocalManagedPolicy = "LocalManagedPolicy"

	// EntityTypeAwsmanagedPolicy is a EntityType enum value
	EntityTypeAwsmanagedPolicy = "AWSManagedPolicy"
)

const (
	// PolicyEvaluationDecisionTypeAllowed is a PolicyEvaluationDecisionType enum value
	PolicyEvaluationDecisionTypeAllowed = "allowed"

	// PolicyEvaluationDecisionTypeExplicitDeny is a PolicyEvaluationDecisionType enum value
	PolicyEvaluationDecisionTypeExplicitDeny = "explicitDeny"

	// PolicyEvaluationDecisionTypeImplicitDeny is a PolicyEvaluationDecisionType enum value
	PolicyEvaluationDecisionTypeImplicitDeny = "implicitDeny"
)

const (
	// PolicySourceTypeUser is a PolicySourceType enum value
	PolicySourceTypeUser = "user"

	// PolicySourceTypeGroup is a PolicySourceType enum value
	PolicySourceTypeGroup = "group"

	// PolicySourceTypeRole is a PolicySourceType enum value
	PolicySourceTypeRole = "role"

	// PolicySourceTypeAwsManaged is a PolicySourceType enum value
	PolicySourceTypeAwsManaged = "aws-managed"

	// PolicySourceTypeUserManaged is a PolicySourceType enum value
	PolicySourceTypeUserManaged = "user-managed"

	// PolicySourceTypeResource is a PolicySourceType enum value
	PolicySourceTypeResource = "resource"

	// PolicySourceTypeNone is a PolicySourceType enum value
	PolicySourceTypeNone = "none"
)

const (
	// ReportFormatTypeTextCsv is a ReportFormatType enum value
	ReportFormatTypeTextCsv = "text/csv"
)

const (
	// ReportStateTypeStarted is a ReportStateType enum value
	ReportStateTypeStarted = "STARTED"

	// ReportStateTypeInprogress is a ReportStateType enum value
	ReportStateTypeInprogress = "INPROGRESS"

	// ReportStateTypeComplete is a ReportStateType enum value
	ReportStateTypeComplete = "COMPLETE"
)

const (
	// AssignmentStatusTypeAssigned is a assignmentStatusType enum value
	AssignmentStatusTypeAssigned = "Assigned"

	// AssignmentStatusTypeUnassigned is a assignmentStatusType enum value
	AssignmentStatusTypeUnassigned = "Unassigned"

	// AssignmentStatusTypeAny is a assignmentStatusType enum value
	AssignmentStatusTypeAny = "Any"
)

const (
	// EncodingTypeSsh is a encodingType enum value
	EncodingTypeSsh = "SSH"

	// EncodingTypePem is a encodingType enum value
	EncodingTypePem = "PEM"
)

const (
	// PolicyScopeTypeAll is a policyScopeType enum value
	PolicyScopeTypeAll = "All"

	// PolicyScopeTypeAws is a policyScopeType enum value
	PolicyScopeTypeAws = "AWS"

	// PolicyScopeTypeLocal is a policyScopeType enum value
	PolicyScopeTypeLocal = "Local"
)

const (
	// StatusTypeActive is a statusType enum value
	StatusTypeActive = "Active"

	// StatusTypeInactive is a statusType enum value
	StatusTypeInactive = "Inactive"
)

const (
	// SummaryKeyTypeUsers is a summaryKeyType enum value
	SummaryKeyTypeUsers = "Users"

	// SummaryKeyTypeUsersQuota is a summaryKeyType enum value
	SummaryKeyTypeUsersQuota = "UsersQuota"

	// SummaryKeyTypeGroups is a summaryKeyType enum value
	SummaryKeyTypeGroups = "Groups"

	// SummaryKeyTypeGroupsQuota is a summaryKeyType enum value
	SummaryKeyTypeGroupsQuota = "GroupsQuota"

	// SummaryKeyTypeServerCertificates is a summaryKeyType enum value
	SummaryKeyTypeServerCertificates = "ServerCertificates"

	// SummaryKeyTypeServerCertificatesQuota is a summaryKeyType enum value
	SummaryKeyTypeServerCertificatesQuota = "ServerCertificatesQuota"

	// SummaryKeyTypeUserPolicySizeQuota is a summaryKeyType enum value
	SummaryKeyTypeUserPolicySizeQuota = "UserPolicySizeQuota"

	// SummaryKeyTypeGroupPolicySizeQuota is a summaryKeyType enum value
	SummaryKeyTypeGroupPolicySizeQuota = "GroupPolicySizeQuota"

	// SummaryKeyTypeGroupsPerUserQuota is a summaryKeyType enum value
	SummaryKeyTypeGroupsPerUserQuota = "GroupsPerUserQuota"

	// SummaryKeyTypeSigningCertificatesPerUserQuota is a summaryKeyType enum value
	SummaryKeyTypeSigningCertificatesPerUserQuota = "SigningCertificatesPerUserQuota"

	// SummaryKeyTypeAccessKeysPerUserQuota is a summaryKeyType enum value
	SummaryKeyTypeAccessKeysPerUserQuota = "AccessKeysPerUserQuota"

	// SummaryKeyTypeMfadevices is a summaryKeyType enum value
	SummaryKeyTypeMfadevices = "MFADevices"

	// SummaryKeyTypeMfadevicesInUse is a summaryKeyType enum value
	SummaryKeyTypeMfadevicesInUse = "MFADevicesInUse"

	// SummaryKeyTypeAccountMfaenabled is a summaryKeyType enum value
	SummaryKeyTypeAccountMfaenabled = "AccountMFAEnabled"

	// SummaryKeyTypeAccountAccessKeysPresent is a summaryKeyType enum value
	SummaryKeyTypeAccountAccessKeysPresent = "AccountAccessKeysPresent"

	// SummaryKeyTypeAccountSigningCertificatesPresent is a summaryKeyType enum value
	SummaryKeyTypeAccountSigningCertificatesPresent = "AccountSigningCertificatesPresent"

	// SummaryKeyTypeAttachedPoliciesPerGroupQuota is a summaryKeyType enum value
	SummaryKeyTypeAttachedPoliciesPerGroupQuota = "AttachedPoliciesPerGroupQuota"

	// SummaryKeyTypeAttachedPoliciesPerRoleQuota is a summaryKeyType enum value
	SummaryKeyTypeAttachedPoliciesPerRoleQuota = "AttachedPoliciesPerRoleQuota"

	// SummaryKeyTypeAttachedPoliciesPerUserQuota is a summaryKeyType enum value
	SummaryKeyTypeAttachedPoliciesPerUserQuota = "AttachedPoliciesPerUserQuota"

	// SummaryKeyTypePolicies is a summaryKeyType enum value
	SummaryKeyTypePolicies = "Policies"

	// SummaryKeyTypePoliciesQuota is a summaryKeyType enum value
	SummaryKeyTypePoliciesQuota = "PoliciesQuota"

	// SummaryKeyTypePolicySizeQuota is a summaryKeyType enum value
	SummaryKeyTypePolicySizeQuota = "PolicySizeQuota"

	// SummaryKeyTypePolicyVersionsInUse is a summaryKeyType enum value
	SummaryKeyTypePolicyVersionsInUse = "PolicyVersionsInUse"

	// SummaryKeyTypePolicyVersionsInUseQuota is a summaryKeyType enum value
	SummaryKeyTypePolicyVersionsInUseQuota = "PolicyVersionsInUseQuota"

	// SummaryKeyTypeVersionsPerPolicyQuota is a summaryKeyType enum value
	SummaryKeyTypeVersionsPerPolicyQuota = "VersionsPerPolicyQuota"
)
