// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package lambda provides a client for AWS Lambda.
package lambda

import (
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddPermission = "AddPermission"

// AddPermissionRequest generates a "aws/request.Request" representing the
// client's request for the AddPermission operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddPermission for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddPermission method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddPermissionRequest method.
//    req, resp := client.AddPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) AddPermissionRequest(input *AddPermissionInput) (req *request.Request, output *AddPermissionOutput) {
	op := &request.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	output = &AddPermissionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddPermission API operation for AWS Lambda.
//
// Adds a permission to the resource policy associated with the specified AWS
// Lambda function. You use resource policies to grant permissions to event
// sources that use push model. In a push model, event sources (such as Amazon
// S3 and custom applications) invoke your Lambda function. Each permission
// you add to the resource policy allows an event source, permission to invoke
// the Lambda function.
//
// For information about the push model, see AWS Lambda: How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html).
//
// If you are using versioning, the permissions you add are specific to the
// Lambda function version or alias you specify in the AddPermission request
// via the Qualifier parameter. For more information about versioning, see AWS
// Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:AddPermission action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation AddPermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodePolicyLengthExceededException "PolicyLengthExceededException"
//   Lambda function access policy is limited to 20 KB.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) AddPermission(input *AddPermissionInput) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	output = &AliasConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAlias API operation for AWS Lambda.
//
// Creates an alias that points to the specified Lambda function version. For
// more information, see Introduction to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// Alias names are unique for a given function. This requires permission for
// the lambda:CreateAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation CreateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) CreateAlias(input *CreateAliasInput) (*AliasConfiguration, error) {
	req, out := c.CreateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateEventSourceMapping = "CreateEventSourceMapping"

// CreateEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSourceMapping operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateEventSourceMapping for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateEventSourceMapping method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateEventSourceMappingRequest method.
//    req, resp := client.CreateEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) CreateEventSourceMappingRequest(input *CreateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opCreateEventSourceMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
	}

	if input == nil {
		input = &CreateEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSourceMapping API operation for AWS Lambda.
//
// Identifies a stream as an event source for a Lambda function. It can be either
// an Amazon Kinesis stream or an Amazon DynamoDB stream. AWS Lambda invokes
// the specified function when records are posted to the stream.
//
// This association between a stream source and a Lambda function is called
// the event source mapping.
//
// This event source mapping is relevant only in the AWS Lambda pull model,
// where AWS Lambda invokes the function. For more information, see AWS Lambda:
// How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html)
// in the AWS Lambda Developer Guide.
//
// You provide mapping information (for example, which stream to read from and
// which Lambda function to invoke) in the request body.
//
// Each event source, such as an Amazon Kinesis or a DynamoDB stream, can be
// associated with multiple AWS Lambda function. A given Lambda function can
// be associated with multiple AWS event sources.
//
// If you are using versioning, you can specify a specific function version
// or an alias via the function name parameter. For more information about versioning,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:CreateEventSourceMapping
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation CreateEventSourceMapping for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
func (c *Lambda) CreateEventSourceMapping(input *CreateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.CreateEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opCreateFunction = "CreateFunction"

// CreateFunctionRequest generates a "aws/request.Request" representing the
// client's request for the CreateFunction operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateFunction for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateFunction method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateFunctionRequest method.
//    req, resp := client.CreateFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) CreateFunctionRequest(input *CreateFunctionInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opCreateFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions",
	}

	if input == nil {
		input = &CreateFunctionInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFunction API operation for AWS Lambda.
//
// Creates a new Lambda function. The function metadata is created from the
// request parameters, and the code for the function is provided by a .zip file
// in the request body. If the function name already exists, the operation will
// fail. Note that the function name is case-sensitive.
//
// If you are using versioning, you can also publish a version of the Lambda
// function you are creating using the Publish parameter. For more information
// about versioning, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:CreateFunction action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation CreateFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeCodeStorageExceededException "CodeStorageExceededException"
//   You have exceeded your maximum total code size per account. Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
func (c *Lambda) CreateFunction(input *CreateFunctionInput) (*FunctionConfiguration, error) {
	req, out := c.CreateFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAliasRequest method.
//    req, resp := client.DeleteAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	output = &DeleteAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAlias API operation for AWS Lambda.
//
// Deletes the specified Lambda function alias. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:DeleteAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEventSourceMapping = "DeleteEventSourceMapping"

// DeleteEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSourceMapping operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteEventSourceMapping for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteEventSourceMapping method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteEventSourceMappingRequest method.
//    req, resp := client.DeleteEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) DeleteEventSourceMappingRequest(input *DeleteEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opDeleteEventSourceMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &DeleteEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventSourceMapping API operation for AWS Lambda.
//
// Removes an event source mapping. This means AWS Lambda will no longer invoke
// the function for events in the associated source.
//
// This operation requires permission for the lambda:DeleteEventSourceMapping
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteEventSourceMapping for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) DeleteEventSourceMapping(input *DeleteEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.DeleteEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteFunction = "DeleteFunction"

// DeleteFunctionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFunction operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteFunction for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteFunction method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteFunctionRequest method.
//    req, resp := client.DeleteFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) DeleteFunctionRequest(input *DeleteFunctionInput) (req *request.Request, output *DeleteFunctionOutput) {
	op := &request.Operation{
		Name:       opDeleteFunction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &DeleteFunctionInput{}
	}

	output = &DeleteFunctionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFunction API operation for AWS Lambda.
//
// Deletes the specified Lambda function code and configuration.
//
// If you are using the versioning feature and you don't specify a function
// version in your DeleteFunction request, AWS Lambda will delete the function,
// including all its versions, and any aliases pointing to the function versions.
// To delete a specific function version, you must provide the function version
// via the Qualifier parameter. For information about function versioning, see
// AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// When you delete a function the associated resource policy is also deleted.
// You will need to delete the event source mappings explicitly.
//
// This operation requires permission for the lambda:DeleteFunction action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation DeleteFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
func (c *Lambda) DeleteFunction(input *DeleteFunctionInput) (*DeleteFunctionOutput, error) {
	req, out := c.DeleteFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetAccountSettings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAccountSettings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAccountSettingsRequest method.
//    req, resp := client.GetAccountSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/2016-08-19/account-settings/",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for AWS Lambda.
//
// Returns a customer's account settings.
//
// You can use this operation to retrieve Lambda limits information, such as
// code size and concurrency limits. For more information about limits, see
// AWS Lambda Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html).
// You can also retrieve resource usage statistics, such as code storage usage
// and function count.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
func (c *Lambda) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opGetAlias = "GetAlias"

// GetAliasRequest generates a "aws/request.Request" representing the
// client's request for the GetAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAliasRequest method.
//    req, resp := client.GetAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) GetAliasRequest(input *GetAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opGetAlias,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &GetAliasInput{}
	}

	output = &AliasConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetAlias API operation for AWS Lambda.
//
// Returns the specified alias information such as the alias ARN, description,
// and function version it is pointing to. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:GetAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) GetAlias(input *GetAliasInput) (*AliasConfiguration, error) {
	req, out := c.GetAliasRequest(input)
	err := req.Send()
	return out, err
}

const opGetEventSourceMapping = "GetEventSourceMapping"

// GetEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetEventSourceMapping operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetEventSourceMapping for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetEventSourceMapping method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetEventSourceMappingRequest method.
//    req, resp := client.GetEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) GetEventSourceMappingRequest(input *GetEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opGetEventSourceMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &GetEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventSourceMapping API operation for AWS Lambda.
//
// Returns configuration information for the specified event source mapping
// (see CreateEventSourceMapping).
//
// This operation requires permission for the lambda:GetEventSourceMapping action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetEventSourceMapping for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) GetEventSourceMapping(input *GetEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.GetEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opGetFunction = "GetFunction"

// GetFunctionRequest generates a "aws/request.Request" representing the
// client's request for the GetFunction operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetFunction for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetFunction method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetFunctionRequest method.
//    req, resp := client.GetFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) GetFunctionRequest(input *GetFunctionInput) (req *request.Request, output *GetFunctionOutput) {
	op := &request.Operation{
		Name:       opGetFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &GetFunctionInput{}
	}

	output = &GetFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunction API operation for AWS Lambda.
//
// Returns the configuration information of the Lambda function and a presigned
// URL link to the .zip file you uploaded with CreateFunction so you can download
// the .zip file. Note that the URL is valid for up to 10 minutes. The configuration
// information is the same information you provided as parameters when uploading
// the function.
//
// Using the optional Qualifier parameter, you can specify a specific function
// version for which you want this information. If you don't specify this parameter,
// the API uses unqualified function ARN which return information about the
// $LATEST version of the Lambda function. For more information, see AWS Lambda
// Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:GetFunction action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
func (c *Lambda) GetFunction(input *GetFunctionInput) (*GetFunctionOutput, error) {
	req, out := c.GetFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opGetFunctionConfiguration = "GetFunctionConfiguration"

// GetFunctionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetFunctionConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetFunctionConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetFunctionConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetFunctionConfigurationRequest method.
//    req, resp := client.GetFunctionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) GetFunctionConfigurationRequest(input *GetFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opGetFunctionConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &GetFunctionConfigurationInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// GetFunctionConfiguration API operation for AWS Lambda.
//
// Returns the configuration information of the Lambda function. This the same
// information you provided as parameters when uploading the function by using
// CreateFunction.
//
// If you are using the versioning feature, you can retrieve this information
// for a specific function version by using the optional Qualifier parameter
// and specifying the function version or alias that points to it. If you don't
// provide it, the API returns information about the $LATEST version of the
// function. For more information about versioning, see AWS Lambda Function
// Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:GetFunctionConfiguration
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetFunctionConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
func (c *Lambda) GetFunctionConfiguration(input *GetFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.GetFunctionConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetPolicyRequest method.
//    req, resp := client.GetPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	output = &GetPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPolicy API operation for AWS Lambda.
//
// Returns the resource policy associated with the specified Lambda function.
//
// If you are using the versioning feature, you can get the resource policy
// associated with the specific Lambda function version or alias by specifying
// the version or alias name using the Qualifier parameter. For more information
// about versioning, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// For information about adding permissions, see AddPermission.
//
// You need permission for the lambda:GetPolicy action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation GetPolicy for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
func (c *Lambda) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opInvoke = "Invoke"

// InvokeRequest generates a "aws/request.Request" representing the
// client's request for the Invoke operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See Invoke for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the Invoke method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the InvokeRequest method.
//    req, resp := client.InvokeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) InvokeRequest(input *InvokeInput) (req *request.Request, output *InvokeOutput) {
	op := &request.Operation{
		Name:       opInvoke,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/invocations",
	}

	if input == nil {
		input = &InvokeInput{}
	}

	output = &InvokeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Invoke API operation for AWS Lambda.
//
// Invokes a specific Lambda function. For an example, see Create the Lambda
// Function and Test It Manually (http://docs.aws.amazon.com/lambda/latest/dg/with-dynamodb-create-function.html#with-dbb-invoke-manually).
//
// If you are using the versioning feature, you can invoke the specific function
// version by providing function version or alias name that is pointing to the
// function version using the Qualifier parameter in the request. If you don't
// provide the Qualifier parameter, the $LATEST version of the Lambda function
// is invoked. Invocations occur at least once in response to an event and functions
// must be idempotent to handle this. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:InvokeFunction action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation Invoke for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidRequestContentException "InvalidRequestContentException"
//   The request body could not be parsed as JSON.
//
//   * ErrCodeRequestTooLargeException "RequestTooLargeException"
//   The request payload exceeded the Invoke request body JSON input limit. For
//   more information, see Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html).
//
//   * ErrCodeUnsupportedMediaTypeException "UnsupportedMediaTypeException"
//   The content type of the Invoke request body is not JSON.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeEC2UnexpectedException "EC2UnexpectedException"
//   AWS Lambda received an unexpected EC2 client exception while setting up for
//   the Lambda function.
//
//   * ErrCodeSubnetIPAddressLimitReachedException "SubnetIPAddressLimitReachedException"
//   AWS Lambda was not able to set up VPC access for the Lambda function because
//   one or more configured subnets has no available IP addresses.
//
//   * ErrCodeENILimitReachedException "ENILimitReachedException"
//   AWS Lambda was not able to create an Elastic Network Interface (ENI) in the
//   VPC, specified as part of Lambda function configuration, because the limit
//   for network interfaces has been reached.
//
//   * ErrCodeEC2ThrottledException "EC2ThrottledException"
//   AWS Lambda was throttled by Amazon EC2 during Lambda function initialization
//   using the execution role provided for the Lambda function.
//
//   * ErrCodeEC2AccessDeniedException "EC2AccessDeniedException"
//
//   * ErrCodeInvalidSubnetIDException "InvalidSubnetIDException"
//   The Subnet ID provided in the Lambda function VPC configuration is invalid.
//
//   * ErrCodeInvalidSecurityGroupIDException "InvalidSecurityGroupIDException"
//   The Security Group ID provided in the Lambda function VPC configuration is
//   invalid.
//
//   * ErrCodeInvalidZipFileException "InvalidZipFileException"
//   AWS Lambda could not unzip the function zip file.
//
//   * ErrCodeKMSDisabledException "KMSDisabledException"
//   Lambda was unable to decrypt the environment variables because the KMS key
//   used is disabled. Check the Lambda function's KMS key settings.
//
//   * ErrCodeKMSInvalidStateException "KMSInvalidStateException"
//   Lambda was unable to decrypt the environment variables because the KMS key
//   used is in an invalid state for Decrypt. Check the function's KMS key settings.
//
//   * ErrCodeKMSAccessDeniedException "KMSAccessDeniedException"
//   Lambda was unable to decrypt the environment variables because KMS access
//   was denied. Check the Lambda function's KMS permissions.
//
//   * ErrCodeKMSNotFoundException "KMSNotFoundException"
//   Lambda was unable to decrypt the environment variables because the KMS key
//   was not found. Check the function's KMS key settings.
//
func (c *Lambda) Invoke(input *InvokeInput) (*InvokeOutput, error) {
	req, out := c.InvokeRequest(input)
	err := req.Send()
	return out, err
}

const opInvokeAsync = "InvokeAsync"

// InvokeAsyncRequest generates a "aws/request.Request" representing the
// client's request for the InvokeAsync operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See InvokeAsync for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the InvokeAsync method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the InvokeAsyncRequest method.
//    req, resp := client.InvokeAsyncRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) InvokeAsyncRequest(input *InvokeAsyncInput) (req *request.Request, output *InvokeAsyncOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, InvokeAsync, has been deprecated")
	}
	op := &request.Operation{
		Name:       opInvokeAsync,
		HTTPMethod: "POST",
		HTTPPath:   "/2014-11-13/functions/{FunctionName}/invoke-async/",
	}

	if input == nil {
		input = &InvokeAsyncInput{}
	}

	output = &InvokeAsyncOutput{}
	req = c.newRequest(op, input, output)
	return
}

// InvokeAsync API operation for AWS Lambda.
//
// This API is deprecated. We recommend you use Invoke API (see Invoke).
//
// Submits an invocation request to AWS Lambda. Upon receiving the request,
// Lambda executes the specified function asynchronously. To see the logs generated
// by the Lambda function execution, see the CloudWatch Logs console.
//
// This operation requires permission for the lambda:InvokeFunction action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation InvokeAsync for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidRequestContentException "InvalidRequestContentException"
//   The request body could not be parsed as JSON.
//
func (c *Lambda) InvokeAsync(input *InvokeAsyncInput) (*InvokeAsyncOutput, error) {
	req, out := c.InvokeAsyncRequest(input)
	err := req.Send()
	return out, err
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAliases for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAliases method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAliasesRequest method.
//    req, resp := client.ListAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases",
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	output = &ListAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAliases API operation for AWS Lambda.
//
// Returns list of aliases created for a Lambda function. For each alias, the
// response includes information such as the alias ARN, description, alias name,
// and the function version to which it points. For more information, see Introduction
// to AWS Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:ListAliases action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListAliases for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	err := req.Send()
	return out, err
}

const opListEventSourceMappings = "ListEventSourceMappings"

// ListEventSourceMappingsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventSourceMappings operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListEventSourceMappings for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListEventSourceMappings method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListEventSourceMappingsRequest method.
//    req, resp := client.ListEventSourceMappingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) ListEventSourceMappingsRequest(input *ListEventSourceMappingsInput) (req *request.Request, output *ListEventSourceMappingsOutput) {
	op := &request.Operation{
		Name:       opListEventSourceMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventSourceMappingsInput{}
	}

	output = &ListEventSourceMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventSourceMappings API operation for AWS Lambda.
//
// Returns a list of event source mappings you created using the CreateEventSourceMapping
// (see CreateEventSourceMapping).
//
// For each mapping, the API returns configuration information. You can optionally
// specify filters to retrieve specific event source mappings.
//
// If you are using the versioning feature, you can get list of event source
// mappings for a specific Lambda function version or an alias as described
// in the FunctionName parameter. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:ListEventSourceMappings
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListEventSourceMappings for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) ListEventSourceMappings(input *ListEventSourceMappingsInput) (*ListEventSourceMappingsOutput, error) {
	req, out := c.ListEventSourceMappingsRequest(input)
	err := req.Send()
	return out, err
}

// ListEventSourceMappingsPages iterates over the pages of a ListEventSourceMappings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEventSourceMappings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEventSourceMappings operation.
//    pageNum := 0
//    err := client.ListEventSourceMappingsPages(params,
//        func(page *ListEventSourceMappingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListEventSourceMappingsPages(input *ListEventSourceMappingsInput, fn func(p *ListEventSourceMappingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListEventSourceMappingsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListEventSourceMappingsOutput), lastPage)
	})
}

const opListFunctions = "ListFunctions"

// ListFunctionsRequest generates a "aws/request.Request" representing the
// client's request for the ListFunctions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListFunctions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListFunctions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListFunctionsRequest method.
//    req, resp := client.ListFunctionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) ListFunctionsRequest(input *ListFunctionsInput) (req *request.Request, output *ListFunctionsOutput) {
	op := &request.Operation{
		Name:       opListFunctions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFunctionsInput{}
	}

	output = &ListFunctionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFunctions API operation for AWS Lambda.
//
// Returns a list of your Lambda functions. For each function, the response
// includes the function configuration information. You must use GetFunction
// to retrieve the code for your function.
//
// This operation requires permission for the lambda:ListFunctions action.
//
// If you are using versioning feature, the response returns list of $LATEST
// versions of your functions. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListFunctions for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) ListFunctions(input *ListFunctionsInput) (*ListFunctionsOutput, error) {
	req, out := c.ListFunctionsRequest(input)
	err := req.Send()
	return out, err
}

// ListFunctionsPages iterates over the pages of a ListFunctions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFunctions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFunctions operation.
//    pageNum := 0
//    err := client.ListFunctionsPages(params,
//        func(page *ListFunctionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Lambda) ListFunctionsPages(input *ListFunctionsInput, fn func(p *ListFunctionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListFunctionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListFunctionsOutput), lastPage)
	})
}

const opListVersionsByFunction = "ListVersionsByFunction"

// ListVersionsByFunctionRequest generates a "aws/request.Request" representing the
// client's request for the ListVersionsByFunction operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListVersionsByFunction for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListVersionsByFunction method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListVersionsByFunctionRequest method.
//    req, resp := client.ListVersionsByFunctionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) ListVersionsByFunctionRequest(input *ListVersionsByFunctionInput) (req *request.Request, output *ListVersionsByFunctionOutput) {
	op := &request.Operation{
		Name:       opListVersionsByFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
	}

	if input == nil {
		input = &ListVersionsByFunctionInput{}
	}

	output = &ListVersionsByFunctionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVersionsByFunction API operation for AWS Lambda.
//
// List all versions of a function. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation ListVersionsByFunction for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) ListVersionsByFunction(input *ListVersionsByFunctionInput) (*ListVersionsByFunctionOutput, error) {
	req, out := c.ListVersionsByFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opPublishVersion = "PublishVersion"

// PublishVersionRequest generates a "aws/request.Request" representing the
// client's request for the PublishVersion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PublishVersion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PublishVersion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PublishVersionRequest method.
//    req, resp := client.PublishVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) PublishVersionRequest(input *PublishVersionInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opPublishVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions",
	}

	if input == nil {
		input = &PublishVersionInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// PublishVersion API operation for AWS Lambda.
//
// Publishes a version of your function from the current snapshot of $LATEST.
// That is, AWS Lambda takes a snapshot of the function code and configuration
// information from $LATEST and publishes a new version. The code and configuration
// cannot be modified after publication. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation PublishVersion for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeCodeStorageExceededException "CodeStorageExceededException"
//   You have exceeded your maximum total code size per account. Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
func (c *Lambda) PublishVersion(input *PublishVersionInput) (*FunctionConfiguration, error) {
	req, out := c.PublishVersionRequest(input)
	err := req.Send()
	return out, err
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a "aws/request.Request" representing the
// client's request for the RemovePermission operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemovePermission for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemovePermission method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemovePermissionRequest method.
//    req, resp := client.RemovePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/policy/{StatementId}",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	output = &RemovePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemovePermission API operation for AWS Lambda.
//
// You can remove individual permissions from an resource policy associated
// with a Lambda function by providing a statement ID that you provided when
// you added the permission.
//
// If you are using versioning, the permissions you remove are specific to the
// Lambda function version or alias you specify in the AddPermission request
// via the Qualifier parameter. For more information about versioning, see AWS
// Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// Note that removal of a permission will cause an active event source to lose
// permission to the function.
//
// You need permission for the lambda:RemovePermission action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation RemovePermission for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateAliasRequest method.
//    req, resp := client.UpdateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *AliasConfiguration) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/aliases/{Name}",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	output = &AliasConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAlias API operation for AWS Lambda.
//
// Using this API you can update the function version to which the alias points
// and the alias description. For more information, see Introduction to AWS
// Lambda Aliases (http://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html).
//
// This requires permission for the lambda:UpdateAlias action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateAlias for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) UpdateAlias(input *UpdateAliasInput) (*AliasConfiguration, error) {
	req, out := c.UpdateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateEventSourceMapping = "UpdateEventSourceMapping"

// UpdateEventSourceMappingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventSourceMapping operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateEventSourceMapping for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateEventSourceMapping method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateEventSourceMappingRequest method.
//    req, resp := client.UpdateEventSourceMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) UpdateEventSourceMappingRequest(input *UpdateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opUpdateEventSourceMapping,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &UpdateEventSourceMappingInput{}
	}

	output = &EventSourceMappingConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEventSourceMapping API operation for AWS Lambda.
//
// You can update an event source mapping. This is useful if you want to change
// the parameters of the existing mapping without losing your position in the
// stream. You can change which function will receive the stream records, but
// to change the stream itself, you must create a new mapping.
//
// If you are using the versioning feature, you can update the event source
// mapping to map to a specific Lambda function version or alias as described
// in the FunctionName parameter. For information about the versioning feature,
// see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// If you disable the event source mapping, AWS Lambda stops polling. If you
// enable again, it will resume polling from the time it had stopped polling,
// so you don't lose processing of any records. However, if you delete event
// source mapping and create it again, it will reset.
//
// This operation requires permission for the lambda:UpdateEventSourceMapping
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateEventSourceMapping for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeResourceConflictException "ResourceConflictException"
//   The resource already exists.
//
func (c *Lambda) UpdateEventSourceMapping(input *UpdateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.UpdateEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFunctionCode = "UpdateFunctionCode"

// UpdateFunctionCodeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunctionCode operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateFunctionCode for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateFunctionCode method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateFunctionCodeRequest method.
//    req, resp := client.UpdateFunctionCodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) UpdateFunctionCodeRequest(input *UpdateFunctionCodeInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionCode,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/code",
	}

	if input == nil {
		input = &UpdateFunctionCodeInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFunctionCode API operation for AWS Lambda.
//
// Updates the code for the specified Lambda function. This operation must only
// be used on an existing Lambda function and cannot be used to update the function
// configuration.
//
// If you are using the versioning feature, note this API will always update
// the $LATEST version of your Lambda function. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:UpdateFunctionCode action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateFunctionCode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
//   * ErrCodeCodeStorageExceededException "CodeStorageExceededException"
//   You have exceeded your maximum total code size per account. Limits (http://docs.aws.amazon.com/lambda/latest/dg/limits.html)
//
func (c *Lambda) UpdateFunctionCode(input *UpdateFunctionCodeInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionCodeRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFunctionConfiguration = "UpdateFunctionConfiguration"

// UpdateFunctionConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFunctionConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateFunctionConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateFunctionConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateFunctionConfigurationRequest method.
//    req, resp := client.UpdateFunctionConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *Lambda) UpdateFunctionConfigurationRequest(input *UpdateFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/configuration",
	}

	if input == nil {
		input = &UpdateFunctionConfigurationInput{}
	}

	output = &FunctionConfiguration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFunctionConfiguration API operation for AWS Lambda.
//
// Updates the configuration parameters for the specified Lambda function by
// using the values provided in the request. You provide only the parameters
// you want to change. This operation must only be used on an existing Lambda
// function and cannot be used to update the function's code.
//
// If you are using the versioning feature, note this API will always update
// the $LATEST version of your Lambda function. For information about the versioning
// feature, see AWS Lambda Function Versioning and Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html).
//
// This operation requires permission for the lambda:UpdateFunctionConfiguration
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Lambda's
// API operation UpdateFunctionConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceException "ServiceException"
//   The AWS Lambda service encountered an internal error.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource (for example, a Lambda function or access policy statement)
//   specified in the request does not exist.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   One of the parameters in the request is invalid. For example, if you provided
//   an IAM role for AWS Lambda to assume in the CreateFunction or the UpdateFunctionConfiguration
//   API, that AWS Lambda is unable to assume you will get this exception.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//
func (c *Lambda) UpdateFunctionConfiguration(input *UpdateFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionConfigurationRequest(input)
	err := req.Send()
	return out, err
}

// Provides limits of code size and concurrency associated with the current
// account and region.
type AccountLimit struct {
	_ struct{} `type:"structure"`

	// Size, in bytes, of code/dependencies that you can zip into a deployment package
	// (uncompressed zip/jar size) for uploading. The default limit is 250 MB.
	CodeSizeUnzipped *int64 `type:"long"`

	// Size, in bytes, of a single zipped code/dependencies package you can upload
	// for your Lambda function(.zip/.jar file). Try using Amazon S3 for uploading
	// larger files. Default limit is 50 MB.
	CodeSizeZipped *int64 `type:"long"`

	// Number of simultaneous executions of your function per region. For more information
	// or to request a limit increase for concurrent executions, see Lambda Function
	// Concurrent Executions (http://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html).
	// The default limit is 100.
	ConcurrentExecutions *int64 `type:"integer"`

	// Maximum size, in megabytes, of a code package you can upload per region.
	// The default size is 75 GB.
	TotalCodeSize *int64 `type:"long"`
}

// String returns the string representation
func (s AccountLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountLimit) GoString() string {
	return s.String()
}

// SetCodeSizeUnzipped sets the CodeSizeUnzipped field's value.
func (s *AccountLimit) SetCodeSizeUnzipped(v int64) *AccountLimit {
	s.CodeSizeUnzipped = &v
	return s
}

// SetCodeSizeZipped sets the CodeSizeZipped field's value.
func (s *AccountLimit) SetCodeSizeZipped(v int64) *AccountLimit {
	s.CodeSizeZipped = &v
	return s
}

// SetConcurrentExecutions sets the ConcurrentExecutions field's value.
func (s *AccountLimit) SetConcurrentExecutions(v int64) *AccountLimit {
	s.ConcurrentExecutions = &v
	return s
}

// SetTotalCodeSize sets the TotalCodeSize field's value.
func (s *AccountLimit) SetTotalCodeSize(v int64) *AccountLimit {
	s.TotalCodeSize = &v
	return s
}

// Provides code size usage and function count associated with the current account
// and region.
type AccountUsage struct {
	_ struct{} `type:"structure"`

	// The number of your account's existing functions per region.
	FunctionCount *int64 `type:"long"`

	// Total size, in bytes, of the account's deployment packages per region.
	TotalCodeSize *int64 `type:"long"`
}

// String returns the string representation
func (s AccountUsage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountUsage) GoString() string {
	return s.String()
}

// SetFunctionCount sets the FunctionCount field's value.
func (s *AccountUsage) SetFunctionCount(v int64) *AccountUsage {
	s.FunctionCount = &v
	return s
}

// SetTotalCodeSize sets the TotalCodeSize field's value.
func (s *AccountUsage) SetTotalCodeSize(v int64) *AccountUsage {
	s.TotalCodeSize = &v
	return s
}

type AddPermissionInput struct {
	_ struct{} `type:"structure"`

	// The AWS Lambda action you want to allow in this statement. Each Lambda action
	// is a string starting with lambda: followed by the API name . For example,
	// lambda:CreateFunction. You can use wildcard (lambda:*) to grant permission
	// for all AWS Lambda actions.
	//
	// Action is a required field
	Action *string `type:"string" required:"true"`

	// A unique token that must be supplied by the principal invoking the function.
	// This is currently only used for Alexa Smart Home functions.
	EventSourceToken *string `type:"string"`

	// Name of the Lambda function whose resource policy you are updating by adding
	// a new permission.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The principal who is getting this permission. It can be Amazon S3 service
	// Principal (s3.amazonaws.com) if you want Amazon S3 to invoke the function,
	// an AWS account ID if you are granting cross-account permission, or any valid
	// AWS service principal such as sns.amazonaws.com. For example, you might want
	// to allow a custom application in another AWS account to push events to AWS
	// Lambda by invoking your function.
	//
	// Principal is a required field
	Principal *string `type:"string" required:"true"`

	// You can use this optional query parameter to describe a qualified ARN using
	// a function version or an alias name. The permission will then apply to the
	// specific qualified ARN. For example, if you specify function version 2 as
	// the qualifier, then permission applies only when request is made using qualified
	// function ARN:
	//
	// arn:aws:lambda:aws-region:acct-id:function:function-name:2
	//
	// If you specify an alias name, for example PROD, then the permission is valid
	// only for requests made using the alias ARN:
	//
	// arn:aws:lambda:aws-region:acct-id:function:function-name:PROD
	//
	// If the qualifier is not specified, the permission is valid only when requests
	// is made using unqualified function ARN.
	//
	// arn:aws:lambda:aws-region:acct-id:function:function-name
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// This parameter is used for S3, SES, CloudWatch Logs and CloudWatch Rules
	// only. The AWS account ID (without a hyphen) of the source owner. For example,
	// if the SourceArn identifies a bucket, then this is the bucket owner's account
	// ID. You can use this additional condition to ensure the bucket you specify
	// is owned by a specific account (it is possible the bucket owner deleted the
	// bucket and some other AWS account created the bucket). You can also use this
	// condition to specify all sources (that is, you don't specify the SourceArn)
	// owned by a specific account.
	SourceAccount *string `type:"string"`

	// This is optional; however, when granting Amazon S3 permission to invoke your
	// function, you should specify this field with the Amazon Resource Name (ARN)
	// as its value. This ensures that only events generated from the specified
	// source can invoke the function.
	//
	// If you add a permission for the Amazon S3 principal without providing the
	// source ARN, any AWS account that creates a mapping to your function ARN can
	// send events to invoke your Lambda function from Amazon S3.
	SourceArn *string `type:"string"`

	// A unique statement identifier.
	//
	// StatementId is a required field
	StatementId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddPermissionInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Principal == nil {
		invalidParams.Add(request.NewErrParamRequired("Principal"))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *AddPermissionInput) SetAction(v string) *AddPermissionInput {
	s.Action = &v
	return s
}

// SetEventSourceToken sets the EventSourceToken field's value.
func (s *AddPermissionInput) SetEventSourceToken(v string) *AddPermissionInput {
	s.EventSourceToken = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *AddPermissionInput) SetFunctionName(v string) *AddPermissionInput {
	s.FunctionName = &v
	return s
}

// SetPrincipal sets the Principal field's value.
func (s *AddPermissionInput) SetPrincipal(v string) *AddPermissionInput {
	s.Principal = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *AddPermissionInput) SetQualifier(v string) *AddPermissionInput {
	s.Qualifier = &v
	return s
}

// SetSourceAccount sets the SourceAccount field's value.
func (s *AddPermissionInput) SetSourceAccount(v string) *AddPermissionInput {
	s.SourceAccount = &v
	return s
}

// SetSourceArn sets the SourceArn field's value.
func (s *AddPermissionInput) SetSourceArn(v string) *AddPermissionInput {
	s.SourceArn = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *AddPermissionInput) SetStatementId(v string) *AddPermissionInput {
	s.StatementId = &v
	return s
}

type AddPermissionOutput struct {
	_ struct{} `type:"structure"`

	// The permission statement you specified in the request. The response returns
	// the same as a string using a backslash ("\") as an escape character in the
	// JSON.
	Statement *string `type:"string"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionOutput) GoString() string {
	return s.String()
}

// SetStatement sets the Statement field's value.
func (s *AddPermissionOutput) SetStatement(v string) *AddPermissionOutput {
	s.Statement = &v
	return s
}

// Provides configuration information about a Lambda function version alias.
type AliasConfiguration struct {
	_ struct{} `type:"structure"`

	// Lambda function ARN that is qualified using the alias name as the suffix.
	// For example, if you create an alias called BETA that points to a helloworld
	// function version, the ARN is arn:aws:lambda:aws-regions:acct-id:function:helloworld:BETA.
	AliasArn *string `type:"string"`

	// Alias description.
	Description *string `type:"string"`

	// Function version to which the alias points.
	FunctionVersion *string `min:"1" type:"string"`

	// Alias name.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AliasConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasConfiguration) GoString() string {
	return s.String()
}

// SetAliasArn sets the AliasArn field's value.
func (s *AliasConfiguration) SetAliasArn(v string) *AliasConfiguration {
	s.AliasArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AliasConfiguration) SetDescription(v string) *AliasConfiguration {
	s.Description = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *AliasConfiguration) SetFunctionVersion(v string) *AliasConfiguration {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *AliasConfiguration) SetName(v string) *AliasConfiguration {
	s.Name = &v
	return s
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Description of the alias.
	Description *string `type:"string"`

	// Name of the Lambda function for which you want to create an alias.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Lambda function version for which you are creating the alias.
	//
	// FunctionVersion is a required field
	FunctionVersion *string `min:"1" type:"string" required:"true"`

	// Name for the alias you are creating.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionVersion"))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAliasInput) SetDescription(v string) *CreateAliasInput {
	s.Description = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *CreateAliasInput) SetFunctionName(v string) *CreateAliasInput {
	s.FunctionName = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *CreateAliasInput) SetFunctionVersion(v string) *CreateAliasInput {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAliasInput) SetName(v string) *CreateAliasInput {
	s.Name = &v
	return s
}

type CreateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The largest number of records that AWS Lambda will retrieve from your event
	// source at the time of invoking your function. Your function receives an event
	// with all the retrieved records. The default is 100 records.
	BatchSize *int64 `min:"1" type:"integer"`

	// Indicates whether AWS Lambda should begin polling the event source. By default,
	// Enabled is true.
	Enabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis or the Amazon DynamoDB
	// stream that is the event source. Any record added to this stream could cause
	// AWS Lambda to invoke your Lambda function, it depends on the BatchSize. AWS
	// Lambda POSTs the Amazon Kinesis event, containing records, to your Lambda
	// function as JSON.
	//
	// EventSourceArn is a required field
	EventSourceArn *string `type:"string" required:"true"`

	// The Lambda function to invoke when AWS Lambda detects an event on the stream.
	//
	// You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	//
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). For
	// more information about versioning, see AWS Lambda Function Versioning and
	// Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
	//
	// AWS Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail).
	//
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The position in the stream where AWS Lambda should start reading. Valid only
	// for Kinesis streams. For more information, see ShardIteratorType (http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType)
	// in the Amazon Kinesis API Reference.
	//
	// StartingPosition is a required field
	StartingPosition *string `type:"string" required:"true" enum:"EventSourcePosition"`

	// The timestamp of the data record from which to start reading. Used with shard
	// iterator type (http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType)
	// AT_TIMESTAMP. If a record with this exact timestamp does not exist, the iterator
	// returned is for the next (later) record. If the timestamp is older than the
	// current trim horizon, the iterator returned is for the oldest untrimmed data
	// record (TRIM_HORIZON). Valid only for Kinesis streams.
	StartingPositionTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s CreateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.EventSourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EventSourceArn"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.StartingPosition == nil {
		invalidParams.Add(request.NewErrParamRequired("StartingPosition"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *CreateEventSourceMappingInput) SetBatchSize(v int64) *CreateEventSourceMappingInput {
	s.BatchSize = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSourceMappingInput) SetEnabled(v bool) *CreateEventSourceMappingInput {
	s.Enabled = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *CreateEventSourceMappingInput) SetEventSourceArn(v string) *CreateEventSourceMappingInput {
	s.EventSourceArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *CreateEventSourceMappingInput) SetFunctionName(v string) *CreateEventSourceMappingInput {
	s.FunctionName = &v
	return s
}

// SetStartingPosition sets the StartingPosition field's value.
func (s *CreateEventSourceMappingInput) SetStartingPosition(v string) *CreateEventSourceMappingInput {
	s.StartingPosition = &v
	return s
}

// SetStartingPositionTimestamp sets the StartingPositionTimestamp field's value.
func (s *CreateEventSourceMappingInput) SetStartingPositionTimestamp(v time.Time) *CreateEventSourceMappingInput {
	s.StartingPositionTimestamp = &v
	return s
}

type CreateFunctionInput struct {
	_ struct{} `type:"structure"`

	// The code for the Lambda function.
	//
	// Code is a required field
	Code *FunctionCode `type:"structure" required:"true"`

	// The parent object that contains the target Amazon Resource Name (ARN) of
	// an Amazon SQS queue or Amazon SNS topic.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// A short, user-defined function description. Lambda does not use this value.
	// Assign a meaningful description as you see fit.
	Description *string `type:"string"`

	// The parent object that contains your environment's configuration settings.
	Environment *Environment `type:"structure"`

	// The name you want to assign to the function you are uploading. The function
	// names appear in the console and are returned in the ListFunctions API. Function
	// names are used to specify functions to other AWS Lambda API operations, such
	// as Invoke.
	//
	// FunctionName is a required field
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The function within your code that Lambda calls to begin execution. For Node.js,
	// it is the module-name.export value in your function. For Java, it can be
	// package.class-name::handler or package.class-name. For more information,
	// see Lambda Function Handler (Java) (http://docs.aws.amazon.com/lambda/latest/dg/java-programming-model-handler-types.html).
	//
	// Handler is a required field
	Handler *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt your function's
	// environment variables. If not provided, AWS Lambda will use a default service
	// key.
	KMSKeyArn *string `type:"string"`

	// The amount of memory, in MB, your Lambda function is given. Lambda uses this
	// memory size to infer the amount of CPU and memory allocated to your function.
	// Your function use-case determines your CPU and memory requirements. For example,
	// a database operation might need less memory compared to an image processing
	// function. The default value is 128 MB. The value must be a multiple of 64
	// MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// This boolean parameter can be used to request AWS Lambda to create the Lambda
	// function and publish a version as an atomic operation.
	Publish *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it
	// executes your function to access any other Amazon Web Services (AWS) resources.
	// For more information, see AWS Lambda: How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html).
	//
	// Role is a required field
	Role *string `type:"string" required:"true"`

	// The runtime environment for the Lambda function you are uploading.
	//
	// To use the Node.js runtime v4.3, set the value to "nodejs4.3". To use earlier
	// runtime (v0.10.42), set the value to "nodejs".
	//
	// You can no longer create functions using the v0.10.42 runtime version as
	// of November, 2016. Existing functions will be supported until early 2017,
	// but we recommend you migrate them to nodejs4.3 runtime version as soon as
	// possible.
	//
	// Runtime is a required field
	Runtime *string `type:"string" required:"true" enum:"Runtime"`

	// The function execution time at which Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// If your Lambda function accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and one subnet
	// ID.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFunctionInput"}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Handler == nil {
		invalidParams.Add(request.NewErrParamRequired("Handler"))
	}
	if s.MemorySize != nil && *s.MemorySize < 128 {
		invalidParams.Add(request.NewErrParamMinValue("MemorySize", 128))
	}
	if s.Role == nil {
		invalidParams.Add(request.NewErrParamRequired("Role"))
	}
	if s.Runtime == nil {
		invalidParams.Add(request.NewErrParamRequired("Runtime"))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}
	if s.Code != nil {
		if err := s.Code.Validate(); err != nil {
			invalidParams.AddNested("Code", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCode sets the Code field's value.
func (s *CreateFunctionInput) SetCode(v *FunctionCode) *CreateFunctionInput {
	s.Code = v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *CreateFunctionInput) SetDeadLetterConfig(v *DeadLetterConfig) *CreateFunctionInput {
	s.DeadLetterConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFunctionInput) SetDescription(v string) *CreateFunctionInput {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateFunctionInput) SetEnvironment(v *Environment) *CreateFunctionInput {
	s.Environment = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *CreateFunctionInput) SetFunctionName(v string) *CreateFunctionInput {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *CreateFunctionInput) SetHandler(v string) *CreateFunctionInput {
	s.Handler = &v
	return s
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *CreateFunctionInput) SetKMSKeyArn(v string) *CreateFunctionInput {
	s.KMSKeyArn = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *CreateFunctionInput) SetMemorySize(v int64) *CreateFunctionInput {
	s.MemorySize = &v
	return s
}

// SetPublish sets the Publish field's value.
func (s *CreateFunctionInput) SetPublish(v bool) *CreateFunctionInput {
	s.Publish = &v
	return s
}

// SetRole sets the Role field's value.
func (s *CreateFunctionInput) SetRole(v string) *CreateFunctionInput {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *CreateFunctionInput) SetRuntime(v string) *CreateFunctionInput {
	s.Runtime = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *CreateFunctionInput) SetTimeout(v int64) *CreateFunctionInput {
	s.Timeout = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateFunctionInput) SetVpcConfig(v *VpcConfig) *CreateFunctionInput {
	s.VpcConfig = v
	return s
}

// The parent object that contains the target Amazon Resource Name (ARN) of
// an Amazon SQS queue or Amazon SNS topic.
type DeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an Amazon SQS queue or Amazon SNS topic
	// you specify as your Dead Letter Queue (DLQ).
	TargetArn *string `type:"string"`
}

// String returns the string representation
func (s DeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeadLetterConfig) GoString() string {
	return s.String()
}

// SetTargetArn sets the TargetArn field's value.
func (s *DeadLetterConfig) SetTargetArn(v string) *DeadLetterConfig {
	s.TargetArn = &v
	return s
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The Lambda function name for which the alias is created. Deleting an alias
	// does not delete the function version to which it is pointing.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Name of the alias to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteAliasInput) SetFunctionName(v string) *DeleteAliasInput {
	s.FunctionName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeleteAliasInput) SetName(v string) *DeleteAliasInput {
	s.Name = &v
	return s
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The event source mapping ID.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSourceMappingInput"}
	if s.UUID == nil {
		invalidParams.Add(request.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUUID sets the UUID field's value.
func (s *DeleteEventSourceMappingInput) SetUUID(v string) *DeleteEventSourceMappingInput {
	s.UUID = &v
	return s
}

type DeleteFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Lambda function to delete.
	//
	// You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). AWS
	// Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail). Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this optional parameter you can specify a function version (but not
	// the $LATEST version) to direct AWS Lambda to delete a specific function version.
	// If the function version has one or more aliases pointing to it, you will
	// get an error because you cannot have aliases pointing to it. You can delete
	// any function version but not the $LATEST, that is, you cannot specify $LATEST
	// as the value of this parameter. The $LATEST version can be deleted only when
	// you want to delete all the function versions and aliases.
	//
	// You can only specify a function version, not an alias name, using this parameter.
	// You cannot delete a function version using its alias.
	//
	// If you don't specify this parameter, AWS Lambda will delete the function,
	// including all of its versions and aliases.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFunctionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *DeleteFunctionInput) SetFunctionName(v string) *DeleteFunctionInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *DeleteFunctionInput) SetQualifier(v string) *DeleteFunctionInput {
	s.Qualifier = &v
	return s
}

type DeleteFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionOutput) GoString() string {
	return s.String()
}

// The parent object that contains your environment's configuration settings.
type Environment struct {
	_ struct{} `type:"structure"`

	// The key-value pairs that represent your environment's configuration settings.
	// The value you specify cannot contain a ",".
	Variables map[string]*string `type:"map"`
}

// String returns the string representation
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Environment) GoString() string {
	return s.String()
}

// SetVariables sets the Variables field's value.
func (s *Environment) SetVariables(v map[string]*string) *Environment {
	s.Variables = v
	return s
}

// The parent object that contains error information associated with your configuration
// settings.
type EnvironmentError struct {
	_ struct{} `type:"structure"`

	// The error code returned by the environment error object.
	ErrorCode *string `type:"string"`

	// The message returned by the environment error object.
	Message *string `type:"string"`
}

// String returns the string representation
func (s EnvironmentError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *EnvironmentError) SetErrorCode(v string) *EnvironmentError {
	s.ErrorCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EnvironmentError) SetMessage(v string) *EnvironmentError {
	s.Message = &v
	return s
}

// The parent object returned that contains your environment's configuration
// settings or any error information associated with your configuration settings.
type EnvironmentResponse struct {
	_ struct{} `type:"structure"`

	// The parent object that contains error information associated with your configuration
	// settings.
	Error *EnvironmentError `type:"structure"`

	// The key-value pairs returned that represent your environment's configuration
	// settings or error information.
	Variables map[string]*string `type:"map"`
}

// String returns the string representation
func (s EnvironmentResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentResponse) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *EnvironmentResponse) SetError(v *EnvironmentError) *EnvironmentResponse {
	s.Error = v
	return s
}

// SetVariables sets the Variables field's value.
func (s *EnvironmentResponse) SetVariables(v map[string]*string) *EnvironmentResponse {
	s.Variables = v
	return s
}

// Describes mapping between an Amazon Kinesis stream and a Lambda function.
type EventSourceMappingConfiguration struct {
	_ struct{} `type:"structure"`

	// The largest number of records that AWS Lambda will retrieve from your event
	// source at the time of invoking your function. Your function receives an event
	// with all the retrieved records.
	BatchSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream that is the source
	// of events.
	EventSourceArn *string `type:"string"`

	// The Lambda function to invoke when AWS Lambda detects an event on the stream.
	FunctionArn *string `type:"string"`

	// The UTC time string indicating the last time the event mapping was updated.
	LastModified *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// The state of the event source mapping. It can be Creating, Enabled, Disabled,
	// Enabling, Disabling, Updating, or Deleting.
	State *string `type:"string"`

	// The reason the event source mapping is in its current state. It is either
	// user-requested or an AWS Lambda-initiated state transition.
	StateTransitionReason *string `type:"string"`

	// The AWS Lambda assigned opaque identifier for the mapping.
	UUID *string `type:"string"`
}

// String returns the string representation
func (s EventSourceMappingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSourceMappingConfiguration) GoString() string {
	return s.String()
}

// SetBatchSize sets the BatchSize field's value.
func (s *EventSourceMappingConfiguration) SetBatchSize(v int64) *EventSourceMappingConfiguration {
	s.BatchSize = &v
	return s
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *EventSourceMappingConfiguration) SetEventSourceArn(v string) *EventSourceMappingConfiguration {
	s.EventSourceArn = &v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *EventSourceMappingConfiguration) SetFunctionArn(v string) *EventSourceMappingConfiguration {
	s.FunctionArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *EventSourceMappingConfiguration) SetLastModified(v time.Time) *EventSourceMappingConfiguration {
	s.LastModified = &v
	return s
}

// SetLastProcessingResult sets the LastProcessingResult field's value.
func (s *EventSourceMappingConfiguration) SetLastProcessingResult(v string) *EventSourceMappingConfiguration {
	s.LastProcessingResult = &v
	return s
}

// SetState sets the State field's value.
func (s *EventSourceMappingConfiguration) SetState(v string) *EventSourceMappingConfiguration {
	s.State = &v
	return s
}

// SetStateTransitionReason sets the StateTransitionReason field's value.
func (s *EventSourceMappingConfiguration) SetStateTransitionReason(v string) *EventSourceMappingConfiguration {
	s.StateTransitionReason = &v
	return s
}

// SetUUID sets the UUID field's value.
func (s *EventSourceMappingConfiguration) SetUUID(v string) *EventSourceMappingConfiguration {
	s.UUID = &v
	return s
}

// The code for the Lambda function.
type FunctionCode struct {
	_ struct{} `type:"structure"`

	// Amazon S3 bucket name where the .zip file containing your deployment package
	// is stored. This bucket must reside in the same AWS region where you are creating
	// the Lambda function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 object (the deployment package) key name you want to upload.
	S3Key *string `min:"1" type:"string"`

	// The Amazon S3 object (the deployment package) version you want to upload.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The contents of your zip file containing your deployment package. If you
	// are using the web API directly, the contents of the zip file must be base64-encoded.
	// If you are using the AWS SDKs or the AWS CLI, the SDKs or CLI will do the
	// encoding for you. For more information about creating a .zip file, see Execution
	// Permissions (http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html)
	// in the AWS Lambda Developer Guide.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s FunctionCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCode) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FunctionCode) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FunctionCode"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *FunctionCode) SetS3Bucket(v string) *FunctionCode {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *FunctionCode) SetS3Key(v string) *FunctionCode {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *FunctionCode) SetS3ObjectVersion(v string) *FunctionCode {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *FunctionCode) SetZipFile(v []byte) *FunctionCode {
	s.ZipFile = v
	return s
}

// The object for the Lambda function location.
type FunctionCodeLocation struct {
	_ struct{} `type:"structure"`

	// The presigned URL you can use to download the function's .zip file that you
	// previously uploaded. The URL is valid for up to 10 minutes.
	Location *string `type:"string"`

	// The repository from which you can download the function.
	RepositoryType *string `type:"string"`
}

// String returns the string representation
func (s FunctionCodeLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCodeLocation) GoString() string {
	return s.String()
}

// SetLocation sets the Location field's value.
func (s *FunctionCodeLocation) SetLocation(v string) *FunctionCodeLocation {
	s.Location = &v
	return s
}

// SetRepositoryType sets the RepositoryType field's value.
func (s *FunctionCodeLocation) SetRepositoryType(v string) *FunctionCodeLocation {
	s.RepositoryType = &v
	return s
}

// A complex type that describes function metadata.
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// It is the SHA256 hash of your function deployment package.
	CodeSha256 *string `type:"string"`

	// The size, in bytes, of the function .zip file you uploaded.
	CodeSize *int64 `type:"long"`

	// The parent object that contains the target Amazon Resource Name (ARN) of
	// an Amazon SQS queue or Amazon SNS topic.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The user-provided description.
	Description *string `type:"string"`

	// The parent object that contains your environment's configuration settings.
	Environment *EnvironmentResponse `type:"structure"`

	// The Amazon Resource Name (ARN) assigned to the function.
	FunctionArn *string `type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The function Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt your function's
	// environment variables. If empty, it means you are using the AWS Lambda default
	// service key.
	KMSKeyArn *string `type:"string"`

	// The time stamp of the last time you updated the function.
	LastModified *string `type:"string"`

	// The memory size, in MB, you configured for the function. Must be a multiple
	// of 64 MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it
	// executes your function to access any other Amazon Web Services (AWS) resources.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	//
	// To use the Node.js runtime v4.3, set the value to "nodejs4.3". To use earlier
	// runtime (v0.10.42), set the value to "nodejs".
	Runtime *string `type:"string" enum:"Runtime"`

	// The function execution time at which Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// The version of the Lambda function.
	Version *string `min:"1" type:"string"`

	// VPC configuration associated with your Lambda function.
	VpcConfig *VpcConfigResponse `type:"structure"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfiguration) GoString() string {
	return s.String()
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *FunctionConfiguration) SetCodeSha256(v string) *FunctionConfiguration {
	s.CodeSha256 = &v
	return s
}

// SetCodeSize sets the CodeSize field's value.
func (s *FunctionConfiguration) SetCodeSize(v int64) *FunctionConfiguration {
	s.CodeSize = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *FunctionConfiguration) SetDeadLetterConfig(v *DeadLetterConfig) *FunctionConfiguration {
	s.DeadLetterConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *FunctionConfiguration) SetDescription(v string) *FunctionConfiguration {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *FunctionConfiguration) SetEnvironment(v *EnvironmentResponse) *FunctionConfiguration {
	s.Environment = v
	return s
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *FunctionConfiguration) SetFunctionArn(v string) *FunctionConfiguration {
	s.FunctionArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *FunctionConfiguration) SetFunctionName(v string) *FunctionConfiguration {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *FunctionConfiguration) SetHandler(v string) *FunctionConfiguration {
	s.Handler = &v
	return s
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *FunctionConfiguration) SetKMSKeyArn(v string) *FunctionConfiguration {
	s.KMSKeyArn = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *FunctionConfiguration) SetLastModified(v string) *FunctionConfiguration {
	s.LastModified = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *FunctionConfiguration) SetMemorySize(v int64) *FunctionConfiguration {
	s.MemorySize = &v
	return s
}

// SetRole sets the Role field's value.
func (s *FunctionConfiguration) SetRole(v string) *FunctionConfiguration {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *FunctionConfiguration) SetRuntime(v string) *FunctionConfiguration {
	s.Runtime = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *FunctionConfiguration) SetTimeout(v int64) *FunctionConfiguration {
	s.Timeout = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *FunctionConfiguration) SetVersion(v string) *FunctionConfiguration {
	s.Version = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *FunctionConfiguration) SetVpcConfig(v *VpcConfigResponse) *FunctionConfiguration {
	s.VpcConfig = v
	return s
}

type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Provides limits of code size and concurrency associated with the current
	// account and region.
	AccountLimit *AccountLimit `type:"structure"`

	// Provides code size usage and function count associated with the current account
	// and region.
	AccountUsage *AccountUsage `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountLimit sets the AccountLimit field's value.
func (s *GetAccountSettingsOutput) SetAccountLimit(v *AccountLimit) *GetAccountSettingsOutput {
	s.AccountLimit = v
	return s
}

// SetAccountUsage sets the AccountUsage field's value.
func (s *GetAccountSettingsOutput) SetAccountUsage(v *AccountUsage) *GetAccountSettingsOutput {
	s.AccountUsage = v
	return s
}

type GetAliasInput struct {
	_ struct{} `type:"structure"`

	// Function name for which the alias is created. An alias is a subresource that
	// exists only in the context of an existing Lambda function so you must specify
	// the function name.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Name of the alias for which you want to retrieve information.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetAliasInput) SetFunctionName(v string) *GetAliasInput {
	s.FunctionName = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAliasInput) SetName(v string) *GetAliasInput {
	s.Name = &v
	return s
}

type GetEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The AWS Lambda assigned ID of the event source mapping.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s GetEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventSourceMappingInput"}
	if s.UUID == nil {
		invalidParams.Add(request.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUUID sets the UUID field's value.
func (s *GetEventSourceMappingInput) SetUUID(v string) *GetEventSourceMappingInput {
	s.UUID = &v
	return s
}

type GetFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Lambda function for which you want to retrieve the configuration
	// information.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this optional parameter you can specify a function version or an alias
	// name. If you specify function version, the API uses qualified function ARN
	// and returns information about the specific function version. If you specify
	// an alias name, the API uses the alias ARN and returns information about the
	// function version to which the alias points.
	//
	// If you don't specify this parameter, the API uses unqualified function ARN,
	// and returns information about the $LATEST function version.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionConfigurationInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetFunctionConfigurationInput) SetFunctionName(v string) *GetFunctionConfigurationInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetFunctionConfigurationInput) SetQualifier(v string) *GetFunctionConfigurationInput {
	s.Qualifier = &v
	return s
}

type GetFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Lambda function name.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this optional parameter to specify a function version or an alias name.
	// If you specify function version, the API uses qualified function ARN for
	// the request and returns information about the specific Lambda function version.
	// If you specify an alias name, the API uses the alias ARN and returns information
	// about the function version to which the alias points. If you don't provide
	// this parameter, the API uses unqualified function ARN and returns information
	// about the $LATEST version of the Lambda function.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFunctionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetFunctionInput) SetFunctionName(v string) *GetFunctionInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetFunctionInput) SetQualifier(v string) *GetFunctionInput {
	s.Qualifier = &v
	return s
}

// This response contains the object for the Lambda function location (see FunctionCodeLocation.
type GetFunctionOutput struct {
	_ struct{} `type:"structure"`

	// The object for the Lambda function location.
	Code *FunctionCodeLocation `type:"structure"`

	// A complex type that describes function metadata.
	Configuration *FunctionConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionOutput) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *GetFunctionOutput) SetCode(v *FunctionCodeLocation) *GetFunctionOutput {
	s.Code = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetFunctionOutput) SetConfiguration(v *FunctionConfiguration) *GetFunctionOutput {
	s.Configuration = v
	return s
}

type GetPolicyInput struct {
	_ struct{} `type:"structure"`

	// Function name whose resource policy you want to retrieve.
	//
	// You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). AWS
	// Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail). Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// You can specify this optional query parameter to specify a function version
	// or an alias name in which case this API will return all permissions associated
	// with the specific qualified ARN. If you don't provide this parameter, the
	// API will return permissions that apply to the unqualified function ARN.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPolicyInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *GetPolicyInput) SetFunctionName(v string) *GetPolicyInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *GetPolicyInput) SetQualifier(v string) *GetPolicyInput {
	s.Qualifier = &v
	return s
}

type GetPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The resource policy associated with the specified function. The response
	// returns the same as a string using a backslash ("\") as an escape character
	// in the JSON.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetPolicyOutput) SetPolicy(v string) *GetPolicyOutput {
	s.Policy = &v
	return s
}

type InvokeAsyncInput struct {
	_ struct{} `deprecated:"true" type:"structure" payload:"InvokeArgs"`

	// The Lambda function name.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// JSON that you want to provide to your Lambda function as input.
	//
	// InvokeArgs is a required field
	InvokeArgs io.ReadSeeker `type:"blob" required:"true"`
}

// String returns the string representation
func (s InvokeAsyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeAsyncInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeAsyncInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.InvokeArgs == nil {
		invalidParams.Add(request.NewErrParamRequired("InvokeArgs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *InvokeAsyncInput) SetFunctionName(v string) *InvokeAsyncInput {
	s.FunctionName = &v
	return s
}

// SetInvokeArgs sets the InvokeArgs field's value.
func (s *InvokeAsyncInput) SetInvokeArgs(v io.ReadSeeker) *InvokeAsyncInput {
	s.InvokeArgs = v
	return s
}

// Upon success, it returns empty response. Otherwise, throws an exception.
type InvokeAsyncOutput struct {
	_ struct{} `deprecated:"true" type:"structure"`

	// It will be 202 upon success.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeAsyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncOutput) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *InvokeAsyncOutput) SetStatus(v int64) *InvokeAsyncOutput {
	s.Status = &v
	return s
}

type InvokeInput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// Using the ClientContext you can pass client-specific information to the Lambda
	// function you are invoking. You can then process the client information in
	// your Lambda function as you choose through the context variable. For an example
	// of a ClientContext JSON, see PutEvents (http://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html)
	// in the Amazon Mobile Analytics API Reference and User Guide.
	//
	// The ClientContext JSON must be base64-encoded.
	ClientContext *string `location:"header" locationName:"X-Amz-Client-Context" type:"string"`

	// The Lambda function name.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// By default, the Invoke API assumes RequestResponse invocation type. You can
	// optionally request asynchronous execution by specifying Event as the InvocationType.
	// You can also use this parameter to request AWS Lambda to not execute the
	// function but do some verification, such as if the caller is authorized to
	// invoke the function and if the inputs are valid. You request this by specifying
	// DryRun as the InvocationType. This is useful in a cross-account scenario
	// when you want to verify access to a function without running it.
	InvocationType *string `location:"header" locationName:"X-Amz-Invocation-Type" type:"string" enum:"InvocationType"`

	// You can set this optional parameter to Tail in the request only if you specify
	// the InvocationType parameter with value RequestResponse. In this case, AWS
	// Lambda returns the base64-encoded last 4 KB of log data produced by your
	// Lambda function in the x-amz-log-result header.
	LogType *string `location:"header" locationName:"X-Amz-Log-Type" type:"string" enum:"LogType"`

	// JSON that you want to provide to your Lambda function as input.
	Payload []byte `type:"blob"`

	// You can use this optional parameter to specify a Lambda function version
	// or alias name. If you specify a function version, the API uses the qualified
	// function ARN to invoke a specific Lambda function. If you specify an alias
	// name, the API uses the alias ARN to invoke the Lambda function version to
	// which the alias points.
	//
	// If you don't provide this parameter, then the API uses unqualified function
	// ARN which results in invocation of the $LATEST version.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s InvokeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InvokeInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientContext sets the ClientContext field's value.
func (s *InvokeInput) SetClientContext(v string) *InvokeInput {
	s.ClientContext = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *InvokeInput) SetFunctionName(v string) *InvokeInput {
	s.FunctionName = &v
	return s
}

// SetInvocationType sets the InvocationType field's value.
func (s *InvokeInput) SetInvocationType(v string) *InvokeInput {
	s.InvocationType = &v
	return s
}

// SetLogType sets the LogType field's value.
func (s *InvokeInput) SetLogType(v string) *InvokeInput {
	s.LogType = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *InvokeInput) SetPayload(v []byte) *InvokeInput {
	s.Payload = v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *InvokeInput) SetQualifier(v string) *InvokeInput {
	s.Qualifier = &v
	return s
}

// Upon success, returns an empty response. Otherwise, throws an exception.
type InvokeOutput struct {
	_ struct{} `type:"structure" payload:"Payload"`

	// Indicates whether an error occurred while executing the Lambda function.
	// If an error occurred this field will have one of two values; Handled or Unhandled.
	// Handled errors are errors that are reported by the function while the Unhandled
	// errors are those detected and reported by AWS Lambda. Unhandled errors include
	// out of memory errors and function timeouts. For information about how to
	// report an Handled error, see Programming Model (http://docs.aws.amazon.com/lambda/latest/dg/programming-model.html).
	FunctionError *string `location:"header" locationName:"X-Amz-Function-Error" type:"string"`

	// It is the base64-encoded logs for the Lambda function invocation. This is
	// present only if the invocation type is RequestResponse and the logs were
	// requested.
	LogResult *string `location:"header" locationName:"X-Amz-Log-Result" type:"string"`

	// It is the JSON representation of the object returned by the Lambda function.
	// This is present only if the invocation type is RequestResponse.
	//
	// In the event of a function error this field contains a message describing
	// the error. For the Handled errors the Lambda function will report this message.
	// For Unhandled errors AWS Lambda reports the message.
	Payload []byte `type:"blob"`

	// The HTTP status code will be in the 200 range for successful request. For
	// the RequestResonse invocation type this status code will be 200. For the
	// Event invocation type this status code will be 202. For the DryRun invocation
	// type the status code will be 204.
	StatusCode *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s InvokeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeOutput) GoString() string {
	return s.String()
}

// SetFunctionError sets the FunctionError field's value.
func (s *InvokeOutput) SetFunctionError(v string) *InvokeOutput {
	s.FunctionError = &v
	return s
}

// SetLogResult sets the LogResult field's value.
func (s *InvokeOutput) SetLogResult(v string) *InvokeOutput {
	s.LogResult = &v
	return s
}

// SetPayload sets the Payload field's value.
func (s *InvokeOutput) SetPayload(v []byte) *InvokeOutput {
	s.Payload = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *InvokeOutput) SetStatusCode(v int64) *InvokeOutput {
	s.StatusCode = &v
	return s
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// Lambda function name for which the alias is created.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// If you specify this optional parameter, the API returns only the aliases
	// that are pointing to the specific Lambda function version, otherwise the
	// API returns all of the aliases created for the Lambda function.
	FunctionVersion *string `location:"querystring" locationName:"FunctionVersion" min:"1" type:"string"`

	// Optional string. An opaque pagination token returned from a previous ListAliases
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of aliases to return in response.
	// This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListAliasesInput) SetFunctionName(v string) *ListAliasesInput {
	s.FunctionName = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *ListAliasesInput) SetFunctionVersion(v string) *ListAliasesInput {
	s.FunctionVersion = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListAliasesInput) SetMarker(v string) *ListAliasesInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListAliasesInput) SetMaxItems(v int64) *ListAliasesInput {
	s.MaxItems = &v
	return s
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of aliases.
	Aliases []*AliasConfiguration `type:"list"`

	// A string, present if there are more aliases.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

// SetAliases sets the Aliases field's value.
func (s *ListAliasesOutput) SetAliases(v []*AliasConfiguration) *ListAliasesOutput {
	s.Aliases = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListAliasesOutput) SetNextMarker(v string) *ListAliasesOutput {
	s.NextMarker = &v
	return s
}

type ListEventSourceMappingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream. (This parameter
	// is optional.)
	EventSourceArn *string `location:"querystring" locationName:"EventSourceArn" type:"string"`

	// The name of the Lambda function.
	//
	// You can specify the function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). AWS
	// Lambda also allows you to specify only the function name with the account
	// ID qualifier (for example, account-id:Thumbnail). Note that the length constraint
	// applies only to the ARN. If you specify only the function name, it is limited
	// to 64 character in length.
	FunctionName *string `location:"querystring" locationName:"FunctionName" min:"1" type:"string"`

	// Optional string. An opaque pagination token returned from a previous ListEventSourceMappings
	// operation. If present, specifies to continue the list from where the returning
	// call left off.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of event sources to return
	// in response. This value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListEventSourceMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventSourceMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventSourceMappingsInput"}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventSourceArn sets the EventSourceArn field's value.
func (s *ListEventSourceMappingsInput) SetEventSourceArn(v string) *ListEventSourceMappingsInput {
	s.EventSourceArn = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListEventSourceMappingsInput) SetFunctionName(v string) *ListEventSourceMappingsInput {
	s.FunctionName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListEventSourceMappingsInput) SetMarker(v string) *ListEventSourceMappingsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListEventSourceMappingsInput) SetMaxItems(v int64) *ListEventSourceMappingsInput {
	s.MaxItems = &v
	return s
}

// Contains a list of event sources (see EventSourceMappingConfiguration)
type ListEventSourceMappingsOutput struct {
	_ struct{} `type:"structure"`

	// An array of EventSourceMappingConfiguration objects.
	EventSourceMappings []*EventSourceMappingConfiguration `type:"list"`

	// A string, present if there are more event source mappings.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListEventSourceMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsOutput) GoString() string {
	return s.String()
}

// SetEventSourceMappings sets the EventSourceMappings field's value.
func (s *ListEventSourceMappingsOutput) SetEventSourceMappings(v []*EventSourceMappingConfiguration) *ListEventSourceMappingsOutput {
	s.EventSourceMappings = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListEventSourceMappingsOutput) SetNextMarker(v string) *ListEventSourceMappingsOutput {
	s.NextMarker = &v
	return s
}

type ListFunctionsInput struct {
	_ struct{} `type:"structure"`

	// Optional string. An opaque pagination token returned from a previous ListFunctions
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of AWS Lambda functions to
	// return in response. This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListFunctionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFunctionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFunctionsInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *ListFunctionsInput) SetMarker(v string) *ListFunctionsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListFunctionsInput) SetMaxItems(v int64) *ListFunctionsInput {
	s.MaxItems = &v
	return s
}

// Contains a list of AWS Lambda function configurations (see FunctionConfiguration.
type ListFunctionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Lambda functions.
	Functions []*FunctionConfiguration `type:"list"`

	// A string, present if there are more functions.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListFunctionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsOutput) GoString() string {
	return s.String()
}

// SetFunctions sets the Functions field's value.
func (s *ListFunctionsOutput) SetFunctions(v []*FunctionConfiguration) *ListFunctionsOutput {
	s.Functions = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListFunctionsOutput) SetNextMarker(v string) *ListFunctionsOutput {
	s.NextMarker = &v
	return s
}

type ListVersionsByFunctionInput struct {
	_ struct{} `type:"structure"`

	// Function name whose versions to list. You can specify a function name (for
	// example, Thumbnail) or you can specify Amazon Resource Name (ARN) of the
	// function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Optional string. An opaque pagination token returned from a previous ListVersionsByFunction
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of AWS Lambda function versions
	// to return in response. This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListVersionsByFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVersionsByFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVersionsByFunctionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *ListVersionsByFunctionInput) SetFunctionName(v string) *ListVersionsByFunctionInput {
	s.FunctionName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *ListVersionsByFunctionInput) SetMarker(v string) *ListVersionsByFunctionInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *ListVersionsByFunctionInput) SetMaxItems(v int64) *ListVersionsByFunctionInput {
	s.MaxItems = &v
	return s
}

type ListVersionsByFunctionOutput struct {
	_ struct{} `type:"structure"`

	// A string, present if there are more function versions.
	NextMarker *string `type:"string"`

	// A list of Lambda function versions.
	Versions []*FunctionConfiguration `type:"list"`
}

// String returns the string representation
func (s ListVersionsByFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVersionsByFunctionOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListVersionsByFunctionOutput) SetNextMarker(v string) *ListVersionsByFunctionOutput {
	s.NextMarker = &v
	return s
}

// SetVersions sets the Versions field's value.
func (s *ListVersionsByFunctionOutput) SetVersions(v []*FunctionConfiguration) *ListVersionsByFunctionOutput {
	s.Versions = v
	return s
}

type PublishVersionInput struct {
	_ struct{} `type:"structure"`

	// The SHA256 hash of the deployment package you want to publish. This provides
	// validation on the code you are publishing. If you provide this parameter
	// value must match the SHA256 of the $LATEST version for the publication to
	// succeed.
	CodeSha256 *string `type:"string"`

	// The description for the version you are publishing. If not provided, AWS
	// Lambda copies the description from the $LATEST version.
	Description *string `type:"string"`

	// The Lambda function name. You can specify a function name (for example, Thumbnail)
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// arn:aws:lambda:us-west-2:account-id:function:ThumbNail). AWS Lambda also
	// allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PublishVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PublishVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PublishVersionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodeSha256 sets the CodeSha256 field's value.
func (s *PublishVersionInput) SetCodeSha256(v string) *PublishVersionInput {
	s.CodeSha256 = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PublishVersionInput) SetDescription(v string) *PublishVersionInput {
	s.Description = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *PublishVersionInput) SetFunctionName(v string) *PublishVersionInput {
	s.FunctionName = &v
	return s
}

type RemovePermissionInput struct {
	_ struct{} `type:"structure"`

	// Lambda function whose resource policy you want to remove a permission from.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// You can specify this optional parameter to remove permission associated with
	// a specific function version or function alias. If you don't specify this
	// parameter, the API removes permission associated with the unqualified function
	// ARN.
	Qualifier *string `location:"querystring" locationName:"Qualifier" min:"1" type:"string"`

	// Statement ID of the permission to remove.
	//
	// StatementId is a required field
	StatementId *string `location:"uri" locationName:"StatementId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemovePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemovePermissionInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.Qualifier != nil && len(*s.Qualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Qualifier", 1))
	}
	if s.StatementId == nil {
		invalidParams.Add(request.NewErrParamRequired("StatementId"))
	}
	if s.StatementId != nil && len(*s.StatementId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *RemovePermissionInput) SetFunctionName(v string) *RemovePermissionInput {
	s.FunctionName = &v
	return s
}

// SetQualifier sets the Qualifier field's value.
func (s *RemovePermissionInput) SetQualifier(v string) *RemovePermissionInput {
	s.Qualifier = &v
	return s
}

// SetStatementId sets the StatementId field's value.
func (s *RemovePermissionInput) SetStatementId(v string) *RemovePermissionInput {
	s.StatementId = &v
	return s
}

type RemovePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// You can change the description of the alias using this parameter.
	Description *string `type:"string"`

	// The function name for which the alias is created.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Using this parameter you can change the Lambda function version to which
	// the alias points.
	FunctionVersion *string `min:"1" type:"string"`

	// The alias name.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAliasInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.FunctionVersion != nil && len(*s.FunctionVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionVersion", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateAliasInput) SetDescription(v string) *UpdateAliasInput {
	s.Description = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateAliasInput) SetFunctionName(v string) *UpdateAliasInput {
	s.FunctionName = &v
	return s
}

// SetFunctionVersion sets the FunctionVersion field's value.
func (s *UpdateAliasInput) SetFunctionVersion(v string) *UpdateAliasInput {
	s.FunctionVersion = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAliasInput) SetName(v string) *UpdateAliasInput {
	s.Name = &v
	return s
}

type UpdateEventSourceMappingInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of stream records that can be sent to your Lambda function
	// for a single invocation.
	BatchSize *int64 `min:"1" type:"integer"`

	// Specifies whether AWS Lambda should actively poll the stream or not. If disabled,
	// AWS Lambda will not poll the stream.
	Enabled *bool `type:"boolean"`

	// The Lambda function to which you want the stream records sent.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	//
	// If you are using versioning, you can also provide a qualified function ARN
	// (ARN that is qualified with function version or alias name as suffix). For
	// more information about versioning, see AWS Lambda Function Versioning and
	// Aliases (http://docs.aws.amazon.com/lambda/latest/dg/versioning-aliases.html)
	//
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `min:"1" type:"string"`

	// The event source mapping identifier.
	//
	// UUID is a required field
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEventSourceMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventSourceMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEventSourceMappingInput"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.UUID == nil {
		invalidParams.Add(request.NewErrParamRequired("UUID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdateEventSourceMappingInput) SetBatchSize(v int64) *UpdateEventSourceMappingInput {
	s.BatchSize = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateEventSourceMappingInput) SetEnabled(v bool) *UpdateEventSourceMappingInput {
	s.Enabled = &v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateEventSourceMappingInput) SetFunctionName(v string) *UpdateEventSourceMappingInput {
	s.FunctionName = &v
	return s
}

// SetUUID sets the UUID field's value.
func (s *UpdateEventSourceMappingInput) SetUUID(v string) *UpdateEventSourceMappingInput {
	s.UUID = &v
	return s
}

type UpdateFunctionCodeInput struct {
	_ struct{} `type:"structure"`

	// The existing Lambda function name whose code you want to replace.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// This boolean parameter can be used to request AWS Lambda to update the Lambda
	// function and publish a version as an atomic operation.
	Publish *bool `type:"boolean"`

	// Amazon S3 bucket name where the .zip file containing your deployment package
	// is stored. This bucket must reside in the same AWS Region where you are creating
	// the Lambda function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 object (the deployment package) key name you want to upload.
	S3Key *string `min:"1" type:"string"`

	// The Amazon S3 object (the deployment package) version you want to upload.
	S3ObjectVersion *string `min:"1" type:"string"`

	// The contents of your zip file containing your deployment package. If you
	// are using the web API directly, the contents of the zip file must be base64-encoded.
	// If you are using the AWS SDKs or the AWS CLI, the SDKs or CLI will do the
	// encoding for you. For more information about creating a .zip file, see Execution
	// Permissions (http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html)
	// in the AWS Lambda Developer Guide.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `type:"blob"`
}

// String returns the string representation
func (s UpdateFunctionCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionCodeInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3ObjectVersion != nil && len(*s.S3ObjectVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3ObjectVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateFunctionCodeInput) SetFunctionName(v string) *UpdateFunctionCodeInput {
	s.FunctionName = &v
	return s
}

// SetPublish sets the Publish field's value.
func (s *UpdateFunctionCodeInput) SetPublish(v bool) *UpdateFunctionCodeInput {
	s.Publish = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *UpdateFunctionCodeInput) SetS3Bucket(v string) *UpdateFunctionCodeInput {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *UpdateFunctionCodeInput) SetS3Key(v string) *UpdateFunctionCodeInput {
	s.S3Key = &v
	return s
}

// SetS3ObjectVersion sets the S3ObjectVersion field's value.
func (s *UpdateFunctionCodeInput) SetS3ObjectVersion(v string) *UpdateFunctionCodeInput {
	s.S3ObjectVersion = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *UpdateFunctionCodeInput) SetZipFile(v []byte) *UpdateFunctionCodeInput {
	s.ZipFile = v
	return s
}

type UpdateFunctionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The parent object that contains the target Amazon Resource Name (ARN) of
	// an Amazon SQS queue or Amazon SNS topic.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// A short user-defined function description. AWS Lambda does not use this value.
	// Assign a meaningful description as you see fit.
	Description *string `type:"string"`

	// The parent object that contains your environment's configuration settings.
	Environment *Environment `type:"structure"`

	// The name of the Lambda function.
	//
	// You can specify a function name (for example, Thumbnail) or you can specify
	// Amazon Resource Name (ARN) of the function (for example, arn:aws:lambda:us-west-2:account-id:function:ThumbNail).
	// AWS Lambda also allows you to specify a partial ARN (for example, account-id:Thumbnail).
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	//
	// FunctionName is a required field
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The function that Lambda calls to begin executing your function. For Node.js,
	// it is the module-name.export value in your function.
	Handler *string `type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt your function's
	// environment variables. If you elect to use the AWS Lambda default service
	// key, pass in an empty string ("") for this parameter.
	KMSKeyArn *string `type:"string"`

	// The amount of memory, in MB, your Lambda function is given. AWS Lambda uses
	// this memory size to infer the amount of CPU allocated to your function. Your
	// function use-case determines your CPU and memory requirements. For example,
	// a database operation might need less memory compared to an image processing
	// function. The default value is 128 MB. The value must be a multiple of 64
	// MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda will assume when
	// it executes your function.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	//
	// To use the Node.js runtime v4.3, set the value to "nodejs4.3". To use earlier
	// runtime (v0.10.42), set the value to "nodejs".
	//
	// You can no longer downgrade to the v0.10.42 runtime version. This version
	// will no longer be supported as of early 2017.
	Runtime *string `type:"string" enum:"Runtime"`

	// The function execution time at which AWS Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	// If your Lambda function accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and one subnet
	// ID.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFunctionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFunctionConfigurationInput"}
	if s.FunctionName == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionName"))
	}
	if s.FunctionName != nil && len(*s.FunctionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionName", 1))
	}
	if s.MemorySize != nil && *s.MemorySize < 128 {
		invalidParams.Add(request.NewErrParamMinValue("MemorySize", 128))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *UpdateFunctionConfigurationInput) SetDeadLetterConfig(v *DeadLetterConfig) *UpdateFunctionConfigurationInput {
	s.DeadLetterConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateFunctionConfigurationInput) SetDescription(v string) *UpdateFunctionConfigurationInput {
	s.Description = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateFunctionConfigurationInput) SetEnvironment(v *Environment) *UpdateFunctionConfigurationInput {
	s.Environment = v
	return s
}

// SetFunctionName sets the FunctionName field's value.
func (s *UpdateFunctionConfigurationInput) SetFunctionName(v string) *UpdateFunctionConfigurationInput {
	s.FunctionName = &v
	return s
}

// SetHandler sets the Handler field's value.
func (s *UpdateFunctionConfigurationInput) SetHandler(v string) *UpdateFunctionConfigurationInput {
	s.Handler = &v
	return s
}

// SetKMSKeyArn sets the KMSKeyArn field's value.
func (s *UpdateFunctionConfigurationInput) SetKMSKeyArn(v string) *UpdateFunctionConfigurationInput {
	s.KMSKeyArn = &v
	return s
}

// SetMemorySize sets the MemorySize field's value.
func (s *UpdateFunctionConfigurationInput) SetMemorySize(v int64) *UpdateFunctionConfigurationInput {
	s.MemorySize = &v
	return s
}

// SetRole sets the Role field's value.
func (s *UpdateFunctionConfigurationInput) SetRole(v string) *UpdateFunctionConfigurationInput {
	s.Role = &v
	return s
}

// SetRuntime sets the Runtime field's value.
func (s *UpdateFunctionConfigurationInput) SetRuntime(v string) *UpdateFunctionConfigurationInput {
	s.Runtime = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *UpdateFunctionConfigurationInput) SetTimeout(v int64) *UpdateFunctionConfigurationInput {
	s.Timeout = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *UpdateFunctionConfigurationInput) SetVpcConfig(v *VpcConfig) *UpdateFunctionConfigurationInput {
	s.VpcConfig = v
	return s
}

// If your Lambda function accesses resources in a VPC, you provide this parameter
// identifying the list of security group IDs and subnet IDs. These must belong
// to the same VPC. You must provide at least one security group and one subnet
// ID.
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// A list of one or more security groups IDs in your VPC.
	SecurityGroupIds []*string `type:"list"`

	// A list of one or more subnet IDs in your VPC.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfig) SetSubnetIds(v []*string) *VpcConfig {
	s.SubnetIds = v
	return s
}

// VPC configuration associated with your Lambda function.
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// A list of security group IDs associated with the Lambda function.
	SecurityGroupIds []*string `type:"list"`

	// A list of subnet IDs associated with the Lambda function.
	SubnetIds []*string `type:"list"`

	// The VPC ID associated with you Lambda function.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigResponse) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigResponse) SetSecurityGroupIds(v []*string) *VpcConfigResponse {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigResponse) SetSubnetIds(v []*string) *VpcConfigResponse {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigResponse) SetVpcId(v string) *VpcConfigResponse {
	s.VpcId = &v
	return s
}

const (
	// EventSourcePositionTrimHorizon is a EventSourcePosition enum value
	EventSourcePositionTrimHorizon = "TRIM_HORIZON"

	// EventSourcePositionLatest is a EventSourcePosition enum value
	EventSourcePositionLatest = "LATEST"

	// EventSourcePositionAtTimestamp is a EventSourcePosition enum value
	EventSourcePositionAtTimestamp = "AT_TIMESTAMP"
)

const (
	// InvocationTypeEvent is a InvocationType enum value
	InvocationTypeEvent = "Event"

	// InvocationTypeRequestResponse is a InvocationType enum value
	InvocationTypeRequestResponse = "RequestResponse"

	// InvocationTypeDryRun is a InvocationType enum value
	InvocationTypeDryRun = "DryRun"
)

const (
	// LogTypeNone is a LogType enum value
	LogTypeNone = "None"

	// LogTypeTail is a LogType enum value
	LogTypeTail = "Tail"
)

const (
	// RuntimeNodejs is a Runtime enum value
	RuntimeNodejs = "nodejs"

	// RuntimeNodejs43 is a Runtime enum value
	RuntimeNodejs43 = "nodejs4.3"

	// RuntimeJava8 is a Runtime enum value
	RuntimeJava8 = "java8"

	// RuntimePython27 is a Runtime enum value
	RuntimePython27 = "python2.7"

	// RuntimeDotnetcore10 is a Runtime enum value
	RuntimeDotnetcore10 = "dotnetcore1.0"

	// RuntimeNodejs43Edge is a Runtime enum value
	RuntimeNodejs43Edge = "nodejs4.3-edge"
)

const (
	// ThrottleReasonConcurrentInvocationLimitExceeded is a ThrottleReason enum value
	ThrottleReasonConcurrentInvocationLimitExceeded = "ConcurrentInvocationLimitExceeded"

	// ThrottleReasonFunctionInvocationRateLimitExceeded is a ThrottleReason enum value
	ThrottleReasonFunctionInvocationRateLimitExceeded = "FunctionInvocationRateLimitExceeded"

	// ThrottleReasonCallerRateLimitExceeded is a ThrottleReason enum value
	ThrottleReasonCallerRateLimitExceeded = "CallerRateLimitExceeded"
)
