// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package lightsailiface provides an interface to enable mocking the Amazon Lightsail service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package lightsailiface

import (
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/lightsail"
)

// LightsailAPI provides an interface to enable mocking the
// lightsail.Lightsail service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Lightsail.
//    func myFunc(svc lightsailiface.LightsailAPI) bool {
//        // Make svc.AllocateStaticIp request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := lightsail.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockLightsailClient struct {
//        lightsailiface.LightsailAPI
//    }
//    func (m *mockLightsailClient) AllocateStaticIp(input *lightsail.AllocateStaticIpInput) (*lightsail.AllocateStaticIpOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockLightsailClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type LightsailAPI interface {
	AllocateStaticIpRequest(*lightsail.AllocateStaticIpInput) (*request.Request, *lightsail.AllocateStaticIpOutput)

	AllocateStaticIp(*lightsail.AllocateStaticIpInput) (*lightsail.AllocateStaticIpOutput, error)

	AttachStaticIpRequest(*lightsail.AttachStaticIpInput) (*request.Request, *lightsail.AttachStaticIpOutput)

	AttachStaticIp(*lightsail.AttachStaticIpInput) (*lightsail.AttachStaticIpOutput, error)

	CloseInstancePublicPortsRequest(*lightsail.CloseInstancePublicPortsInput) (*request.Request, *lightsail.CloseInstancePublicPortsOutput)

	CloseInstancePublicPorts(*lightsail.CloseInstancePublicPortsInput) (*lightsail.CloseInstancePublicPortsOutput, error)

	CreateDomainRequest(*lightsail.CreateDomainInput) (*request.Request, *lightsail.CreateDomainOutput)

	CreateDomain(*lightsail.CreateDomainInput) (*lightsail.CreateDomainOutput, error)

	CreateDomainEntryRequest(*lightsail.CreateDomainEntryInput) (*request.Request, *lightsail.CreateDomainEntryOutput)

	CreateDomainEntry(*lightsail.CreateDomainEntryInput) (*lightsail.CreateDomainEntryOutput, error)

	CreateInstanceSnapshotRequest(*lightsail.CreateInstanceSnapshotInput) (*request.Request, *lightsail.CreateInstanceSnapshotOutput)

	CreateInstanceSnapshot(*lightsail.CreateInstanceSnapshotInput) (*lightsail.CreateInstanceSnapshotOutput, error)

	CreateInstancesRequest(*lightsail.CreateInstancesInput) (*request.Request, *lightsail.CreateInstancesOutput)

	CreateInstances(*lightsail.CreateInstancesInput) (*lightsail.CreateInstancesOutput, error)

	CreateInstancesFromSnapshotRequest(*lightsail.CreateInstancesFromSnapshotInput) (*request.Request, *lightsail.CreateInstancesFromSnapshotOutput)

	CreateInstancesFromSnapshot(*lightsail.CreateInstancesFromSnapshotInput) (*lightsail.CreateInstancesFromSnapshotOutput, error)

	CreateKeyPairRequest(*lightsail.CreateKeyPairInput) (*request.Request, *lightsail.CreateKeyPairOutput)

	CreateKeyPair(*lightsail.CreateKeyPairInput) (*lightsail.CreateKeyPairOutput, error)

	DeleteDomainRequest(*lightsail.DeleteDomainInput) (*request.Request, *lightsail.DeleteDomainOutput)

	DeleteDomain(*lightsail.DeleteDomainInput) (*lightsail.DeleteDomainOutput, error)

	DeleteDomainEntryRequest(*lightsail.DeleteDomainEntryInput) (*request.Request, *lightsail.DeleteDomainEntryOutput)

	DeleteDomainEntry(*lightsail.DeleteDomainEntryInput) (*lightsail.DeleteDomainEntryOutput, error)

	DeleteInstanceRequest(*lightsail.DeleteInstanceInput) (*request.Request, *lightsail.DeleteInstanceOutput)

	DeleteInstance(*lightsail.DeleteInstanceInput) (*lightsail.DeleteInstanceOutput, error)

	DeleteInstanceSnapshotRequest(*lightsail.DeleteInstanceSnapshotInput) (*request.Request, *lightsail.DeleteInstanceSnapshotOutput)

	DeleteInstanceSnapshot(*lightsail.DeleteInstanceSnapshotInput) (*lightsail.DeleteInstanceSnapshotOutput, error)

	DeleteKeyPairRequest(*lightsail.DeleteKeyPairInput) (*request.Request, *lightsail.DeleteKeyPairOutput)

	DeleteKeyPair(*lightsail.DeleteKeyPairInput) (*lightsail.DeleteKeyPairOutput, error)

	DetachStaticIpRequest(*lightsail.DetachStaticIpInput) (*request.Request, *lightsail.DetachStaticIpOutput)

	DetachStaticIp(*lightsail.DetachStaticIpInput) (*lightsail.DetachStaticIpOutput, error)

	DownloadDefaultKeyPairRequest(*lightsail.DownloadDefaultKeyPairInput) (*request.Request, *lightsail.DownloadDefaultKeyPairOutput)

	DownloadDefaultKeyPair(*lightsail.DownloadDefaultKeyPairInput) (*lightsail.DownloadDefaultKeyPairOutput, error)

	GetActiveNamesRequest(*lightsail.GetActiveNamesInput) (*request.Request, *lightsail.GetActiveNamesOutput)

	GetActiveNames(*lightsail.GetActiveNamesInput) (*lightsail.GetActiveNamesOutput, error)

	GetBlueprintsRequest(*lightsail.GetBlueprintsInput) (*request.Request, *lightsail.GetBlueprintsOutput)

	GetBlueprints(*lightsail.GetBlueprintsInput) (*lightsail.GetBlueprintsOutput, error)

	GetBundlesRequest(*lightsail.GetBundlesInput) (*request.Request, *lightsail.GetBundlesOutput)

	GetBundles(*lightsail.GetBundlesInput) (*lightsail.GetBundlesOutput, error)

	GetDomainRequest(*lightsail.GetDomainInput) (*request.Request, *lightsail.GetDomainOutput)

	GetDomain(*lightsail.GetDomainInput) (*lightsail.GetDomainOutput, error)

	GetDomainsRequest(*lightsail.GetDomainsInput) (*request.Request, *lightsail.GetDomainsOutput)

	GetDomains(*lightsail.GetDomainsInput) (*lightsail.GetDomainsOutput, error)

	GetInstanceRequest(*lightsail.GetInstanceInput) (*request.Request, *lightsail.GetInstanceOutput)

	GetInstance(*lightsail.GetInstanceInput) (*lightsail.GetInstanceOutput, error)

	GetInstanceAccessDetailsRequest(*lightsail.GetInstanceAccessDetailsInput) (*request.Request, *lightsail.GetInstanceAccessDetailsOutput)

	GetInstanceAccessDetails(*lightsail.GetInstanceAccessDetailsInput) (*lightsail.GetInstanceAccessDetailsOutput, error)

	GetInstanceMetricDataRequest(*lightsail.GetInstanceMetricDataInput) (*request.Request, *lightsail.GetInstanceMetricDataOutput)

	GetInstanceMetricData(*lightsail.GetInstanceMetricDataInput) (*lightsail.GetInstanceMetricDataOutput, error)

	GetInstancePortStatesRequest(*lightsail.GetInstancePortStatesInput) (*request.Request, *lightsail.GetInstancePortStatesOutput)

	GetInstancePortStates(*lightsail.GetInstancePortStatesInput) (*lightsail.GetInstancePortStatesOutput, error)

	GetInstanceSnapshotRequest(*lightsail.GetInstanceSnapshotInput) (*request.Request, *lightsail.GetInstanceSnapshotOutput)

	GetInstanceSnapshot(*lightsail.GetInstanceSnapshotInput) (*lightsail.GetInstanceSnapshotOutput, error)

	GetInstanceSnapshotsRequest(*lightsail.GetInstanceSnapshotsInput) (*request.Request, *lightsail.GetInstanceSnapshotsOutput)

	GetInstanceSnapshots(*lightsail.GetInstanceSnapshotsInput) (*lightsail.GetInstanceSnapshotsOutput, error)

	GetInstanceStateRequest(*lightsail.GetInstanceStateInput) (*request.Request, *lightsail.GetInstanceStateOutput)

	GetInstanceState(*lightsail.GetInstanceStateInput) (*lightsail.GetInstanceStateOutput, error)

	GetInstancesRequest(*lightsail.GetInstancesInput) (*request.Request, *lightsail.GetInstancesOutput)

	GetInstances(*lightsail.GetInstancesInput) (*lightsail.GetInstancesOutput, error)

	GetKeyPairRequest(*lightsail.GetKeyPairInput) (*request.Request, *lightsail.GetKeyPairOutput)

	GetKeyPair(*lightsail.GetKeyPairInput) (*lightsail.GetKeyPairOutput, error)

	GetKeyPairsRequest(*lightsail.GetKeyPairsInput) (*request.Request, *lightsail.GetKeyPairsOutput)

	GetKeyPairs(*lightsail.GetKeyPairsInput) (*lightsail.GetKeyPairsOutput, error)

	GetOperationRequest(*lightsail.GetOperationInput) (*request.Request, *lightsail.GetOperationOutput)

	GetOperation(*lightsail.GetOperationInput) (*lightsail.GetOperationOutput, error)

	GetOperationsRequest(*lightsail.GetOperationsInput) (*request.Request, *lightsail.GetOperationsOutput)

	GetOperations(*lightsail.GetOperationsInput) (*lightsail.GetOperationsOutput, error)

	GetOperationsForResourceRequest(*lightsail.GetOperationsForResourceInput) (*request.Request, *lightsail.GetOperationsForResourceOutput)

	GetOperationsForResource(*lightsail.GetOperationsForResourceInput) (*lightsail.GetOperationsForResourceOutput, error)

	GetRegionsRequest(*lightsail.GetRegionsInput) (*request.Request, *lightsail.GetRegionsOutput)

	GetRegions(*lightsail.GetRegionsInput) (*lightsail.GetRegionsOutput, error)

	GetStaticIpRequest(*lightsail.GetStaticIpInput) (*request.Request, *lightsail.GetStaticIpOutput)

	GetStaticIp(*lightsail.GetStaticIpInput) (*lightsail.GetStaticIpOutput, error)

	GetStaticIpsRequest(*lightsail.GetStaticIpsInput) (*request.Request, *lightsail.GetStaticIpsOutput)

	GetStaticIps(*lightsail.GetStaticIpsInput) (*lightsail.GetStaticIpsOutput, error)

	ImportKeyPairRequest(*lightsail.ImportKeyPairInput) (*request.Request, *lightsail.ImportKeyPairOutput)

	ImportKeyPair(*lightsail.ImportKeyPairInput) (*lightsail.ImportKeyPairOutput, error)

	IsVpcPeeredRequest(*lightsail.IsVpcPeeredInput) (*request.Request, *lightsail.IsVpcPeeredOutput)

	IsVpcPeered(*lightsail.IsVpcPeeredInput) (*lightsail.IsVpcPeeredOutput, error)

	OpenInstancePublicPortsRequest(*lightsail.OpenInstancePublicPortsInput) (*request.Request, *lightsail.OpenInstancePublicPortsOutput)

	OpenInstancePublicPorts(*lightsail.OpenInstancePublicPortsInput) (*lightsail.OpenInstancePublicPortsOutput, error)

	PeerVpcRequest(*lightsail.PeerVpcInput) (*request.Request, *lightsail.PeerVpcOutput)

	PeerVpc(*lightsail.PeerVpcInput) (*lightsail.PeerVpcOutput, error)

	RebootInstanceRequest(*lightsail.RebootInstanceInput) (*request.Request, *lightsail.RebootInstanceOutput)

	RebootInstance(*lightsail.RebootInstanceInput) (*lightsail.RebootInstanceOutput, error)

	ReleaseStaticIpRequest(*lightsail.ReleaseStaticIpInput) (*request.Request, *lightsail.ReleaseStaticIpOutput)

	ReleaseStaticIp(*lightsail.ReleaseStaticIpInput) (*lightsail.ReleaseStaticIpOutput, error)

	StartInstanceRequest(*lightsail.StartInstanceInput) (*request.Request, *lightsail.StartInstanceOutput)

	StartInstance(*lightsail.StartInstanceInput) (*lightsail.StartInstanceOutput, error)

	StopInstanceRequest(*lightsail.StopInstanceInput) (*request.Request, *lightsail.StopInstanceOutput)

	StopInstance(*lightsail.StopInstanceInput) (*lightsail.StopInstanceOutput, error)

	UnpeerVpcRequest(*lightsail.UnpeerVpcInput) (*request.Request, *lightsail.UnpeerVpcOutput)

	UnpeerVpc(*lightsail.UnpeerVpcInput) (*lightsail.UnpeerVpcOutput, error)

	UpdateDomainEntryRequest(*lightsail.UpdateDomainEntryInput) (*request.Request, *lightsail.UpdateDomainEntryOutput)

	UpdateDomainEntry(*lightsail.UpdateDomainEntryInput) (*lightsail.UpdateDomainEntryOutput, error)
}

var _ LightsailAPI = (*lightsail.Lightsail)(nil)
