// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package mturkiface provides an interface to enable mocking the Amazon Mechanical Turk service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package mturkiface

import (
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/mturk"
)

// MTurkAPI provides an interface to enable mocking the
// mturk.MTurk service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Mechanical Turk.
//    func myFunc(svc mturkiface.MTurkAPI) bool {
//        // Make svc.AcceptQualificationRequest request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := mturk.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockMTurkClient struct {
//        mturkiface.MTurkAPI
//    }
//    func (m *mockMTurkClient) AcceptQualificationRequest(input *mturk.AcceptQualificationRequestInput) (*mturk.AcceptQualificationRequestOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockMTurkClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type MTurkAPI interface {
	AcceptQualificationRequestRequest(*mturk.AcceptQualificationRequestInput) (*request.Request, *mturk.AcceptQualificationRequestOutput)

	AcceptQualificationRequest(*mturk.AcceptQualificationRequestInput) (*mturk.AcceptQualificationRequestOutput, error)

	ApproveAssignmentRequest(*mturk.ApproveAssignmentInput) (*request.Request, *mturk.ApproveAssignmentOutput)

	ApproveAssignment(*mturk.ApproveAssignmentInput) (*mturk.ApproveAssignmentOutput, error)

	AssociateQualificationWithWorkerRequest(*mturk.AssociateQualificationWithWorkerInput) (*request.Request, *mturk.AssociateQualificationWithWorkerOutput)

	AssociateQualificationWithWorker(*mturk.AssociateQualificationWithWorkerInput) (*mturk.AssociateQualificationWithWorkerOutput, error)

	CreateAdditionalAssignmentsForHITRequest(*mturk.CreateAdditionalAssignmentsForHITInput) (*request.Request, *mturk.CreateAdditionalAssignmentsForHITOutput)

	CreateAdditionalAssignmentsForHIT(*mturk.CreateAdditionalAssignmentsForHITInput) (*mturk.CreateAdditionalAssignmentsForHITOutput, error)

	CreateHITRequest(*mturk.CreateHITInput) (*request.Request, *mturk.CreateHITOutput)

	CreateHIT(*mturk.CreateHITInput) (*mturk.CreateHITOutput, error)

	CreateHITTypeRequest(*mturk.CreateHITTypeInput) (*request.Request, *mturk.CreateHITTypeOutput)

	CreateHITType(*mturk.CreateHITTypeInput) (*mturk.CreateHITTypeOutput, error)

	CreateHITWithHITTypeRequest(*mturk.CreateHITWithHITTypeInput) (*request.Request, *mturk.CreateHITWithHITTypeOutput)

	CreateHITWithHITType(*mturk.CreateHITWithHITTypeInput) (*mturk.CreateHITWithHITTypeOutput, error)

	CreateQualificationTypeRequest(*mturk.CreateQualificationTypeInput) (*request.Request, *mturk.CreateQualificationTypeOutput)

	CreateQualificationType(*mturk.CreateQualificationTypeInput) (*mturk.CreateQualificationTypeOutput, error)

	CreateWorkerBlockRequest(*mturk.CreateWorkerBlockInput) (*request.Request, *mturk.CreateWorkerBlockOutput)

	CreateWorkerBlock(*mturk.CreateWorkerBlockInput) (*mturk.CreateWorkerBlockOutput, error)

	DeleteHITRequest(*mturk.DeleteHITInput) (*request.Request, *mturk.DeleteHITOutput)

	DeleteHIT(*mturk.DeleteHITInput) (*mturk.DeleteHITOutput, error)

	DeleteQualificationTypeRequest(*mturk.DeleteQualificationTypeInput) (*request.Request, *mturk.DeleteQualificationTypeOutput)

	DeleteQualificationType(*mturk.DeleteQualificationTypeInput) (*mturk.DeleteQualificationTypeOutput, error)

	DeleteWorkerBlockRequest(*mturk.DeleteWorkerBlockInput) (*request.Request, *mturk.DeleteWorkerBlockOutput)

	DeleteWorkerBlock(*mturk.DeleteWorkerBlockInput) (*mturk.DeleteWorkerBlockOutput, error)

	DisassociateQualificationFromWorkerRequest(*mturk.DisassociateQualificationFromWorkerInput) (*request.Request, *mturk.DisassociateQualificationFromWorkerOutput)

	DisassociateQualificationFromWorker(*mturk.DisassociateQualificationFromWorkerInput) (*mturk.DisassociateQualificationFromWorkerOutput, error)

	GetAccountBalanceRequest(*mturk.GetAccountBalanceInput) (*request.Request, *mturk.GetAccountBalanceOutput)

	GetAccountBalance(*mturk.GetAccountBalanceInput) (*mturk.GetAccountBalanceOutput, error)

	GetAssignmentRequest(*mturk.GetAssignmentInput) (*request.Request, *mturk.GetAssignmentOutput)

	GetAssignment(*mturk.GetAssignmentInput) (*mturk.GetAssignmentOutput, error)

	GetFileUploadURLRequest(*mturk.GetFileUploadURLInput) (*request.Request, *mturk.GetFileUploadURLOutput)

	GetFileUploadURL(*mturk.GetFileUploadURLInput) (*mturk.GetFileUploadURLOutput, error)

	GetHITRequest(*mturk.GetHITInput) (*request.Request, *mturk.GetHITOutput)

	GetHIT(*mturk.GetHITInput) (*mturk.GetHITOutput, error)

	GetQualificationScoreRequest(*mturk.GetQualificationScoreInput) (*request.Request, *mturk.GetQualificationScoreOutput)

	GetQualificationScore(*mturk.GetQualificationScoreInput) (*mturk.GetQualificationScoreOutput, error)

	GetQualificationTypeRequest(*mturk.GetQualificationTypeInput) (*request.Request, *mturk.GetQualificationTypeOutput)

	GetQualificationType(*mturk.GetQualificationTypeInput) (*mturk.GetQualificationTypeOutput, error)

	ListAssignmentsForHITRequest(*mturk.ListAssignmentsForHITInput) (*request.Request, *mturk.ListAssignmentsForHITOutput)

	ListAssignmentsForHIT(*mturk.ListAssignmentsForHITInput) (*mturk.ListAssignmentsForHITOutput, error)

	ListAssignmentsForHITPages(*mturk.ListAssignmentsForHITInput, func(*mturk.ListAssignmentsForHITOutput, bool) bool) error

	ListBonusPaymentsRequest(*mturk.ListBonusPaymentsInput) (*request.Request, *mturk.ListBonusPaymentsOutput)

	ListBonusPayments(*mturk.ListBonusPaymentsInput) (*mturk.ListBonusPaymentsOutput, error)

	ListBonusPaymentsPages(*mturk.ListBonusPaymentsInput, func(*mturk.ListBonusPaymentsOutput, bool) bool) error

	ListHITsRequest(*mturk.ListHITsInput) (*request.Request, *mturk.ListHITsOutput)

	ListHITs(*mturk.ListHITsInput) (*mturk.ListHITsOutput, error)

	ListHITsPages(*mturk.ListHITsInput, func(*mturk.ListHITsOutput, bool) bool) error

	ListHITsForQualificationTypeRequest(*mturk.ListHITsForQualificationTypeInput) (*request.Request, *mturk.ListHITsForQualificationTypeOutput)

	ListHITsForQualificationType(*mturk.ListHITsForQualificationTypeInput) (*mturk.ListHITsForQualificationTypeOutput, error)

	ListHITsForQualificationTypePages(*mturk.ListHITsForQualificationTypeInput, func(*mturk.ListHITsForQualificationTypeOutput, bool) bool) error

	ListQualificationRequestsRequest(*mturk.ListQualificationRequestsInput) (*request.Request, *mturk.ListQualificationRequestsOutput)

	ListQualificationRequests(*mturk.ListQualificationRequestsInput) (*mturk.ListQualificationRequestsOutput, error)

	ListQualificationRequestsPages(*mturk.ListQualificationRequestsInput, func(*mturk.ListQualificationRequestsOutput, bool) bool) error

	ListQualificationTypesRequest(*mturk.ListQualificationTypesInput) (*request.Request, *mturk.ListQualificationTypesOutput)

	ListQualificationTypes(*mturk.ListQualificationTypesInput) (*mturk.ListQualificationTypesOutput, error)

	ListQualificationTypesPages(*mturk.ListQualificationTypesInput, func(*mturk.ListQualificationTypesOutput, bool) bool) error

	ListReviewPolicyResultsForHITRequest(*mturk.ListReviewPolicyResultsForHITInput) (*request.Request, *mturk.ListReviewPolicyResultsForHITOutput)

	ListReviewPolicyResultsForHIT(*mturk.ListReviewPolicyResultsForHITInput) (*mturk.ListReviewPolicyResultsForHITOutput, error)

	ListReviewPolicyResultsForHITPages(*mturk.ListReviewPolicyResultsForHITInput, func(*mturk.ListReviewPolicyResultsForHITOutput, bool) bool) error

	ListReviewableHITsRequest(*mturk.ListReviewableHITsInput) (*request.Request, *mturk.ListReviewableHITsOutput)

	ListReviewableHITs(*mturk.ListReviewableHITsInput) (*mturk.ListReviewableHITsOutput, error)

	ListReviewableHITsPages(*mturk.ListReviewableHITsInput, func(*mturk.ListReviewableHITsOutput, bool) bool) error

	ListWorkerBlocksRequest(*mturk.ListWorkerBlocksInput) (*request.Request, *mturk.ListWorkerBlocksOutput)

	ListWorkerBlocks(*mturk.ListWorkerBlocksInput) (*mturk.ListWorkerBlocksOutput, error)

	ListWorkerBlocksPages(*mturk.ListWorkerBlocksInput, func(*mturk.ListWorkerBlocksOutput, bool) bool) error

	ListWorkersWithQualificationTypeRequest(*mturk.ListWorkersWithQualificationTypeInput) (*request.Request, *mturk.ListWorkersWithQualificationTypeOutput)

	ListWorkersWithQualificationType(*mturk.ListWorkersWithQualificationTypeInput) (*mturk.ListWorkersWithQualificationTypeOutput, error)

	ListWorkersWithQualificationTypePages(*mturk.ListWorkersWithQualificationTypeInput, func(*mturk.ListWorkersWithQualificationTypeOutput, bool) bool) error

	NotifyWorkersRequest(*mturk.NotifyWorkersInput) (*request.Request, *mturk.NotifyWorkersOutput)

	NotifyWorkers(*mturk.NotifyWorkersInput) (*mturk.NotifyWorkersOutput, error)

	RejectAssignmentRequest(*mturk.RejectAssignmentInput) (*request.Request, *mturk.RejectAssignmentOutput)

	RejectAssignment(*mturk.RejectAssignmentInput) (*mturk.RejectAssignmentOutput, error)

	RejectQualificationRequestRequest(*mturk.RejectQualificationRequestInput) (*request.Request, *mturk.RejectQualificationRequestOutput)

	RejectQualificationRequest(*mturk.RejectQualificationRequestInput) (*mturk.RejectQualificationRequestOutput, error)

	SendBonusRequest(*mturk.SendBonusInput) (*request.Request, *mturk.SendBonusOutput)

	SendBonus(*mturk.SendBonusInput) (*mturk.SendBonusOutput, error)

	SendTestEventNotificationRequest(*mturk.SendTestEventNotificationInput) (*request.Request, *mturk.SendTestEventNotificationOutput)

	SendTestEventNotification(*mturk.SendTestEventNotificationInput) (*mturk.SendTestEventNotificationOutput, error)

	UpdateExpirationForHITRequest(*mturk.UpdateExpirationForHITInput) (*request.Request, *mturk.UpdateExpirationForHITOutput)

	UpdateExpirationForHIT(*mturk.UpdateExpirationForHITInput) (*mturk.UpdateExpirationForHITOutput, error)

	UpdateHITReviewStatusRequest(*mturk.UpdateHITReviewStatusInput) (*request.Request, *mturk.UpdateHITReviewStatusOutput)

	UpdateHITReviewStatus(*mturk.UpdateHITReviewStatusInput) (*mturk.UpdateHITReviewStatusOutput, error)

	UpdateHITTypeOfHITRequest(*mturk.UpdateHITTypeOfHITInput) (*request.Request, *mturk.UpdateHITTypeOfHITOutput)

	UpdateHITTypeOfHIT(*mturk.UpdateHITTypeOfHITInput) (*mturk.UpdateHITTypeOfHITOutput, error)

	UpdateNotificationSettingsRequest(*mturk.UpdateNotificationSettingsInput) (*request.Request, *mturk.UpdateNotificationSettingsOutput)

	UpdateNotificationSettings(*mturk.UpdateNotificationSettingsInput) (*mturk.UpdateNotificationSettingsOutput, error)

	UpdateQualificationTypeRequest(*mturk.UpdateQualificationTypeInput) (*request.Request, *mturk.UpdateQualificationTypeOutput)

	UpdateQualificationType(*mturk.UpdateQualificationTypeInput) (*mturk.UpdateQualificationTypeOutput, error)
}

var _ MTurkAPI = (*mturk.MTurk)(nil)
