// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package organizationsiface provides an interface to enable mocking the AWS Organizations service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package organizationsiface

import (
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/organizations"
)

// OrganizationsAPI provides an interface to enable mocking the
// organizations.Organizations service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Organizations.
//    func myFunc(svc organizationsiface.OrganizationsAPI) bool {
//        // Make svc.AcceptHandshake request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := organizations.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockOrganizationsClient struct {
//        organizationsiface.OrganizationsAPI
//    }
//    func (m *mockOrganizationsClient) AcceptHandshake(input *organizations.AcceptHandshakeInput) (*organizations.AcceptHandshakeOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockOrganizationsClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type OrganizationsAPI interface {
	AcceptHandshakeRequest(*organizations.AcceptHandshakeInput) (*request.Request, *organizations.AcceptHandshakeOutput)

	AcceptHandshake(*organizations.AcceptHandshakeInput) (*organizations.AcceptHandshakeOutput, error)

	AttachPolicyRequest(*organizations.AttachPolicyInput) (*request.Request, *organizations.AttachPolicyOutput)

	AttachPolicy(*organizations.AttachPolicyInput) (*organizations.AttachPolicyOutput, error)

	CancelHandshakeRequest(*organizations.CancelHandshakeInput) (*request.Request, *organizations.CancelHandshakeOutput)

	CancelHandshake(*organizations.CancelHandshakeInput) (*organizations.CancelHandshakeOutput, error)

	CreateAccountRequest(*organizations.CreateAccountInput) (*request.Request, *organizations.CreateAccountOutput)

	CreateAccount(*organizations.CreateAccountInput) (*organizations.CreateAccountOutput, error)

	CreateOrganizationRequest(*organizations.CreateOrganizationInput) (*request.Request, *organizations.CreateOrganizationOutput)

	CreateOrganization(*organizations.CreateOrganizationInput) (*organizations.CreateOrganizationOutput, error)

	CreateOrganizationalUnitRequest(*organizations.CreateOrganizationalUnitInput) (*request.Request, *organizations.CreateOrganizationalUnitOutput)

	CreateOrganizationalUnit(*organizations.CreateOrganizationalUnitInput) (*organizations.CreateOrganizationalUnitOutput, error)

	CreatePolicyRequest(*organizations.CreatePolicyInput) (*request.Request, *organizations.CreatePolicyOutput)

	CreatePolicy(*organizations.CreatePolicyInput) (*organizations.CreatePolicyOutput, error)

	DeclineHandshakeRequest(*organizations.DeclineHandshakeInput) (*request.Request, *organizations.DeclineHandshakeOutput)

	DeclineHandshake(*organizations.DeclineHandshakeInput) (*organizations.DeclineHandshakeOutput, error)

	DeleteOrganizationRequest(*organizations.DeleteOrganizationInput) (*request.Request, *organizations.DeleteOrganizationOutput)

	DeleteOrganization(*organizations.DeleteOrganizationInput) (*organizations.DeleteOrganizationOutput, error)

	DeleteOrganizationalUnitRequest(*organizations.DeleteOrganizationalUnitInput) (*request.Request, *organizations.DeleteOrganizationalUnitOutput)

	DeleteOrganizationalUnit(*organizations.DeleteOrganizationalUnitInput) (*organizations.DeleteOrganizationalUnitOutput, error)

	DeletePolicyRequest(*organizations.DeletePolicyInput) (*request.Request, *organizations.DeletePolicyOutput)

	DeletePolicy(*organizations.DeletePolicyInput) (*organizations.DeletePolicyOutput, error)

	DescribeAccountRequest(*organizations.DescribeAccountInput) (*request.Request, *organizations.DescribeAccountOutput)

	DescribeAccount(*organizations.DescribeAccountInput) (*organizations.DescribeAccountOutput, error)

	DescribeCreateAccountStatusRequest(*organizations.DescribeCreateAccountStatusInput) (*request.Request, *organizations.DescribeCreateAccountStatusOutput)

	DescribeCreateAccountStatus(*organizations.DescribeCreateAccountStatusInput) (*organizations.DescribeCreateAccountStatusOutput, error)

	DescribeHandshakeRequest(*organizations.DescribeHandshakeInput) (*request.Request, *organizations.DescribeHandshakeOutput)

	DescribeHandshake(*organizations.DescribeHandshakeInput) (*organizations.DescribeHandshakeOutput, error)

	DescribeOrganizationRequest(*organizations.DescribeOrganizationInput) (*request.Request, *organizations.DescribeOrganizationOutput)

	DescribeOrganization(*organizations.DescribeOrganizationInput) (*organizations.DescribeOrganizationOutput, error)

	DescribeOrganizationalUnitRequest(*organizations.DescribeOrganizationalUnitInput) (*request.Request, *organizations.DescribeOrganizationalUnitOutput)

	DescribeOrganizationalUnit(*organizations.DescribeOrganizationalUnitInput) (*organizations.DescribeOrganizationalUnitOutput, error)

	DescribePolicyRequest(*organizations.DescribePolicyInput) (*request.Request, *organizations.DescribePolicyOutput)

	DescribePolicy(*organizations.DescribePolicyInput) (*organizations.DescribePolicyOutput, error)

	DetachPolicyRequest(*organizations.DetachPolicyInput) (*request.Request, *organizations.DetachPolicyOutput)

	DetachPolicy(*organizations.DetachPolicyInput) (*organizations.DetachPolicyOutput, error)

	DisablePolicyTypeRequest(*organizations.DisablePolicyTypeInput) (*request.Request, *organizations.DisablePolicyTypeOutput)

	DisablePolicyType(*organizations.DisablePolicyTypeInput) (*organizations.DisablePolicyTypeOutput, error)

	EnableAllFeaturesRequest(*organizations.EnableAllFeaturesInput) (*request.Request, *organizations.EnableAllFeaturesOutput)

	EnableAllFeatures(*organizations.EnableAllFeaturesInput) (*organizations.EnableAllFeaturesOutput, error)

	EnablePolicyTypeRequest(*organizations.EnablePolicyTypeInput) (*request.Request, *organizations.EnablePolicyTypeOutput)

	EnablePolicyType(*organizations.EnablePolicyTypeInput) (*organizations.EnablePolicyTypeOutput, error)

	InviteAccountToOrganizationRequest(*organizations.InviteAccountToOrganizationInput) (*request.Request, *organizations.InviteAccountToOrganizationOutput)

	InviteAccountToOrganization(*organizations.InviteAccountToOrganizationInput) (*organizations.InviteAccountToOrganizationOutput, error)

	LeaveOrganizationRequest(*organizations.LeaveOrganizationInput) (*request.Request, *organizations.LeaveOrganizationOutput)

	LeaveOrganization(*organizations.LeaveOrganizationInput) (*organizations.LeaveOrganizationOutput, error)

	ListAccountsRequest(*organizations.ListAccountsInput) (*request.Request, *organizations.ListAccountsOutput)

	ListAccounts(*organizations.ListAccountsInput) (*organizations.ListAccountsOutput, error)

	ListAccountsForParentRequest(*organizations.ListAccountsForParentInput) (*request.Request, *organizations.ListAccountsForParentOutput)

	ListAccountsForParent(*organizations.ListAccountsForParentInput) (*organizations.ListAccountsForParentOutput, error)

	ListChildrenRequest(*organizations.ListChildrenInput) (*request.Request, *organizations.ListChildrenOutput)

	ListChildren(*organizations.ListChildrenInput) (*organizations.ListChildrenOutput, error)

	ListCreateAccountStatusRequest(*organizations.ListCreateAccountStatusInput) (*request.Request, *organizations.ListCreateAccountStatusOutput)

	ListCreateAccountStatus(*organizations.ListCreateAccountStatusInput) (*organizations.ListCreateAccountStatusOutput, error)

	ListHandshakesForAccountRequest(*organizations.ListHandshakesForAccountInput) (*request.Request, *organizations.ListHandshakesForAccountOutput)

	ListHandshakesForAccount(*organizations.ListHandshakesForAccountInput) (*organizations.ListHandshakesForAccountOutput, error)

	ListHandshakesForOrganizationRequest(*organizations.ListHandshakesForOrganizationInput) (*request.Request, *organizations.ListHandshakesForOrganizationOutput)

	ListHandshakesForOrganization(*organizations.ListHandshakesForOrganizationInput) (*organizations.ListHandshakesForOrganizationOutput, error)

	ListOrganizationalUnitsForParentRequest(*organizations.ListOrganizationalUnitsForParentInput) (*request.Request, *organizations.ListOrganizationalUnitsForParentOutput)

	ListOrganizationalUnitsForParent(*organizations.ListOrganizationalUnitsForParentInput) (*organizations.ListOrganizationalUnitsForParentOutput, error)

	ListParentsRequest(*organizations.ListParentsInput) (*request.Request, *organizations.ListParentsOutput)

	ListParents(*organizations.ListParentsInput) (*organizations.ListParentsOutput, error)

	ListPoliciesRequest(*organizations.ListPoliciesInput) (*request.Request, *organizations.ListPoliciesOutput)

	ListPolicies(*organizations.ListPoliciesInput) (*organizations.ListPoliciesOutput, error)

	ListPoliciesForTargetRequest(*organizations.ListPoliciesForTargetInput) (*request.Request, *organizations.ListPoliciesForTargetOutput)

	ListPoliciesForTarget(*organizations.ListPoliciesForTargetInput) (*organizations.ListPoliciesForTargetOutput, error)

	ListRootsRequest(*organizations.ListRootsInput) (*request.Request, *organizations.ListRootsOutput)

	ListRoots(*organizations.ListRootsInput) (*organizations.ListRootsOutput, error)

	ListTargetsForPolicyRequest(*organizations.ListTargetsForPolicyInput) (*request.Request, *organizations.ListTargetsForPolicyOutput)

	ListTargetsForPolicy(*organizations.ListTargetsForPolicyInput) (*organizations.ListTargetsForPolicyOutput, error)

	MoveAccountRequest(*organizations.MoveAccountInput) (*request.Request, *organizations.MoveAccountOutput)

	MoveAccount(*organizations.MoveAccountInput) (*organizations.MoveAccountOutput, error)

	RemoveAccountFromOrganizationRequest(*organizations.RemoveAccountFromOrganizationInput) (*request.Request, *organizations.RemoveAccountFromOrganizationOutput)

	RemoveAccountFromOrganization(*organizations.RemoveAccountFromOrganizationInput) (*organizations.RemoveAccountFromOrganizationOutput, error)

	UpdateOrganizationalUnitRequest(*organizations.UpdateOrganizationalUnitInput) (*request.Request, *organizations.UpdateOrganizationalUnitOutput)

	UpdateOrganizationalUnit(*organizations.UpdateOrganizationalUnitInput) (*organizations.UpdateOrganizationalUnitOutput, error)

	UpdatePolicyRequest(*organizations.UpdatePolicyInput) (*request.Request, *organizations.UpdatePolicyOutput)

	UpdatePolicy(*organizations.UpdatePolicyInput) (*organizations.UpdatePolicyOutput, error)
}

var _ OrganizationsAPI = (*organizations.Organizations)(nil)
