// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package workdocsiface provides an interface to enable mocking the Amazon WorkDocs service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package workdocsiface

import (
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/workdocs"
)

// WorkDocsAPI provides an interface to enable mocking the
// workdocs.WorkDocs service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon WorkDocs.
//    func myFunc(svc workdocsiface.WorkDocsAPI) bool {
//        // Make svc.AbortDocumentVersionUpload request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := workdocs.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockWorkDocsClient struct {
//        workdocsiface.WorkDocsAPI
//    }
//    func (m *mockWorkDocsClient) AbortDocumentVersionUpload(input *workdocs.AbortDocumentVersionUploadInput) (*workdocs.AbortDocumentVersionUploadOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockWorkDocsClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type WorkDocsAPI interface {
	AbortDocumentVersionUploadRequest(*workdocs.AbortDocumentVersionUploadInput) (*request.Request, *workdocs.AbortDocumentVersionUploadOutput)

	AbortDocumentVersionUpload(*workdocs.AbortDocumentVersionUploadInput) (*workdocs.AbortDocumentVersionUploadOutput, error)

	ActivateUserRequest(*workdocs.ActivateUserInput) (*request.Request, *workdocs.ActivateUserOutput)

	ActivateUser(*workdocs.ActivateUserInput) (*workdocs.ActivateUserOutput, error)

	AddResourcePermissionsRequest(*workdocs.AddResourcePermissionsInput) (*request.Request, *workdocs.AddResourcePermissionsOutput)

	AddResourcePermissions(*workdocs.AddResourcePermissionsInput) (*workdocs.AddResourcePermissionsOutput, error)

	CreateFolderRequest(*workdocs.CreateFolderInput) (*request.Request, *workdocs.CreateFolderOutput)

	CreateFolder(*workdocs.CreateFolderInput) (*workdocs.CreateFolderOutput, error)

	CreateNotificationSubscriptionRequest(*workdocs.CreateNotificationSubscriptionInput) (*request.Request, *workdocs.CreateNotificationSubscriptionOutput)

	CreateNotificationSubscription(*workdocs.CreateNotificationSubscriptionInput) (*workdocs.CreateNotificationSubscriptionOutput, error)

	CreateUserRequest(*workdocs.CreateUserInput) (*request.Request, *workdocs.CreateUserOutput)

	CreateUser(*workdocs.CreateUserInput) (*workdocs.CreateUserOutput, error)

	DeactivateUserRequest(*workdocs.DeactivateUserInput) (*request.Request, *workdocs.DeactivateUserOutput)

	DeactivateUser(*workdocs.DeactivateUserInput) (*workdocs.DeactivateUserOutput, error)

	DeleteDocumentRequest(*workdocs.DeleteDocumentInput) (*request.Request, *workdocs.DeleteDocumentOutput)

	DeleteDocument(*workdocs.DeleteDocumentInput) (*workdocs.DeleteDocumentOutput, error)

	DeleteFolderRequest(*workdocs.DeleteFolderInput) (*request.Request, *workdocs.DeleteFolderOutput)

	DeleteFolder(*workdocs.DeleteFolderInput) (*workdocs.DeleteFolderOutput, error)

	DeleteFolderContentsRequest(*workdocs.DeleteFolderContentsInput) (*request.Request, *workdocs.DeleteFolderContentsOutput)

	DeleteFolderContents(*workdocs.DeleteFolderContentsInput) (*workdocs.DeleteFolderContentsOutput, error)

	DeleteNotificationSubscriptionRequest(*workdocs.DeleteNotificationSubscriptionInput) (*request.Request, *workdocs.DeleteNotificationSubscriptionOutput)

	DeleteNotificationSubscription(*workdocs.DeleteNotificationSubscriptionInput) (*workdocs.DeleteNotificationSubscriptionOutput, error)

	DeleteUserRequest(*workdocs.DeleteUserInput) (*request.Request, *workdocs.DeleteUserOutput)

	DeleteUser(*workdocs.DeleteUserInput) (*workdocs.DeleteUserOutput, error)

	DescribeDocumentVersionsRequest(*workdocs.DescribeDocumentVersionsInput) (*request.Request, *workdocs.DescribeDocumentVersionsOutput)

	DescribeDocumentVersions(*workdocs.DescribeDocumentVersionsInput) (*workdocs.DescribeDocumentVersionsOutput, error)

	DescribeDocumentVersionsPages(*workdocs.DescribeDocumentVersionsInput, func(*workdocs.DescribeDocumentVersionsOutput, bool) bool) error

	DescribeFolderContentsRequest(*workdocs.DescribeFolderContentsInput) (*request.Request, *workdocs.DescribeFolderContentsOutput)

	DescribeFolderContents(*workdocs.DescribeFolderContentsInput) (*workdocs.DescribeFolderContentsOutput, error)

	DescribeFolderContentsPages(*workdocs.DescribeFolderContentsInput, func(*workdocs.DescribeFolderContentsOutput, bool) bool) error

	DescribeNotificationSubscriptionsRequest(*workdocs.DescribeNotificationSubscriptionsInput) (*request.Request, *workdocs.DescribeNotificationSubscriptionsOutput)

	DescribeNotificationSubscriptions(*workdocs.DescribeNotificationSubscriptionsInput) (*workdocs.DescribeNotificationSubscriptionsOutput, error)

	DescribeResourcePermissionsRequest(*workdocs.DescribeResourcePermissionsInput) (*request.Request, *workdocs.DescribeResourcePermissionsOutput)

	DescribeResourcePermissions(*workdocs.DescribeResourcePermissionsInput) (*workdocs.DescribeResourcePermissionsOutput, error)

	DescribeUsersRequest(*workdocs.DescribeUsersInput) (*request.Request, *workdocs.DescribeUsersOutput)

	DescribeUsers(*workdocs.DescribeUsersInput) (*workdocs.DescribeUsersOutput, error)

	DescribeUsersPages(*workdocs.DescribeUsersInput, func(*workdocs.DescribeUsersOutput, bool) bool) error

	GetDocumentRequest(*workdocs.GetDocumentInput) (*request.Request, *workdocs.GetDocumentOutput)

	GetDocument(*workdocs.GetDocumentInput) (*workdocs.GetDocumentOutput, error)

	GetDocumentPathRequest(*workdocs.GetDocumentPathInput) (*request.Request, *workdocs.GetDocumentPathOutput)

	GetDocumentPath(*workdocs.GetDocumentPathInput) (*workdocs.GetDocumentPathOutput, error)

	GetDocumentVersionRequest(*workdocs.GetDocumentVersionInput) (*request.Request, *workdocs.GetDocumentVersionOutput)

	GetDocumentVersion(*workdocs.GetDocumentVersionInput) (*workdocs.GetDocumentVersionOutput, error)

	GetFolderRequest(*workdocs.GetFolderInput) (*request.Request, *workdocs.GetFolderOutput)

	GetFolder(*workdocs.GetFolderInput) (*workdocs.GetFolderOutput, error)

	GetFolderPathRequest(*workdocs.GetFolderPathInput) (*request.Request, *workdocs.GetFolderPathOutput)

	GetFolderPath(*workdocs.GetFolderPathInput) (*workdocs.GetFolderPathOutput, error)

	InitiateDocumentVersionUploadRequest(*workdocs.InitiateDocumentVersionUploadInput) (*request.Request, *workdocs.InitiateDocumentVersionUploadOutput)

	InitiateDocumentVersionUpload(*workdocs.InitiateDocumentVersionUploadInput) (*workdocs.InitiateDocumentVersionUploadOutput, error)

	RemoveAllResourcePermissionsRequest(*workdocs.RemoveAllResourcePermissionsInput) (*request.Request, *workdocs.RemoveAllResourcePermissionsOutput)

	RemoveAllResourcePermissions(*workdocs.RemoveAllResourcePermissionsInput) (*workdocs.RemoveAllResourcePermissionsOutput, error)

	RemoveResourcePermissionRequest(*workdocs.RemoveResourcePermissionInput) (*request.Request, *workdocs.RemoveResourcePermissionOutput)

	RemoveResourcePermission(*workdocs.RemoveResourcePermissionInput) (*workdocs.RemoveResourcePermissionOutput, error)

	UpdateDocumentRequest(*workdocs.UpdateDocumentInput) (*request.Request, *workdocs.UpdateDocumentOutput)

	UpdateDocument(*workdocs.UpdateDocumentInput) (*workdocs.UpdateDocumentOutput, error)

	UpdateDocumentVersionRequest(*workdocs.UpdateDocumentVersionInput) (*request.Request, *workdocs.UpdateDocumentVersionOutput)

	UpdateDocumentVersion(*workdocs.UpdateDocumentVersionInput) (*workdocs.UpdateDocumentVersionOutput, error)

	UpdateFolderRequest(*workdocs.UpdateFolderInput) (*request.Request, *workdocs.UpdateFolderOutput)

	UpdateFolder(*workdocs.UpdateFolderInput) (*workdocs.UpdateFolderOutput, error)

	UpdateUserRequest(*workdocs.UpdateUserInput) (*request.Request, *workdocs.UpdateUserOutput)

	UpdateUser(*workdocs.UpdateUserInput) (*workdocs.UpdateUserOutput, error)
}

var _ WorkDocsAPI = (*workdocs.WorkDocs)(nil)
