// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package workspaces provides a client for Amazon WorkSpaces.
package workspaces

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTags API operation for Amazon WorkSpaces.
//
// Creates tags for a WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateWorkspaces = "CreateWorkspaces"

// CreateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspaces operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateWorkspaces for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateWorkspaces method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateWorkspacesRequest method.
//    req, resp := client.CreateWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspacesRequest(input *CreateWorkspacesInput) (req *request.Request, output *CreateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspacesInput{}
	}

	output = &CreateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspaces API operation for Amazon WorkSpaces.
//
// Creates one or more WorkSpaces.
//
// This operation is asynchronous and returns before the WorkSpaces are created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateWorkspaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceLimitExceededException "ResourceLimitExceededException"
//   Your resource limits have been exceeded.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspaces(input *CreateWorkspacesInput) (*CreateWorkspacesOutput, error) {
	req, out := c.CreateWorkspacesRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTags API operation for Amazon WorkSpaces.
//
// Deletes tags from a WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon WorkSpaces.
//
// Describes tags for a WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeWorkspaceBundles = "DescribeWorkspaceBundles"

// DescribeWorkspaceBundlesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceBundles operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeWorkspaceBundles for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeWorkspaceBundles method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeWorkspaceBundlesRequest method.
//    req, resp := client.DescribeWorkspaceBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundlesRequest(input *DescribeWorkspaceBundlesInput) (req *request.Request, output *DescribeWorkspaceBundlesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceBundlesInput{}
	}

	output = &DescribeWorkspaceBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceBundles API operation for Amazon WorkSpaces.
//
// Obtains information about the WorkSpace bundles that are available to your
// account in the specified region.
//
// You can filter the results with either the BundleIds parameter, or the Owner
// parameter, but not both.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the NextToken response
// member contains a token that you pass in the next call to this operation
// to retrieve the next set of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceBundles for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundles(input *DescribeWorkspaceBundlesInput) (*DescribeWorkspaceBundlesOutput, error) {
	req, out := c.DescribeWorkspaceBundlesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeWorkspaceBundlesPages iterates over the pages of a DescribeWorkspaceBundles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceBundles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaceBundles operation.
//    pageNum := 0
//    err := client.DescribeWorkspaceBundlesPages(params,
//        func(page *DescribeWorkspaceBundlesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspaceBundlesPages(input *DescribeWorkspaceBundlesInput, fn func(p *DescribeWorkspaceBundlesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeWorkspaceBundlesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeWorkspaceBundlesOutput), lastPage)
	})
}

const opDescribeWorkspaceDirectories = "DescribeWorkspaceDirectories"

// DescribeWorkspaceDirectoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceDirectories operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeWorkspaceDirectories for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeWorkspaceDirectories method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeWorkspaceDirectoriesRequest method.
//    req, resp := client.DescribeWorkspaceDirectoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectoriesRequest(input *DescribeWorkspaceDirectoriesInput) (req *request.Request, output *DescribeWorkspaceDirectoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceDirectoriesInput{}
	}

	output = &DescribeWorkspaceDirectoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceDirectories API operation for Amazon WorkSpaces.
//
// Retrieves information about the AWS Directory Service directories in the
// region that are registered with Amazon WorkSpaces and are available to your
// account.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the NextToken response
// member contains a token that you pass in the next call to this operation
// to retrieve the next set of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceDirectories for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectories(input *DescribeWorkspaceDirectoriesInput) (*DescribeWorkspaceDirectoriesOutput, error) {
	req, out := c.DescribeWorkspaceDirectoriesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeWorkspaceDirectoriesPages iterates over the pages of a DescribeWorkspaceDirectories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceDirectories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaceDirectories operation.
//    pageNum := 0
//    err := client.DescribeWorkspaceDirectoriesPages(params,
//        func(page *DescribeWorkspaceDirectoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspaceDirectoriesPages(input *DescribeWorkspaceDirectoriesInput, fn func(p *DescribeWorkspaceDirectoriesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeWorkspaceDirectoriesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeWorkspaceDirectoriesOutput), lastPage)
	})
}

const opDescribeWorkspaces = "DescribeWorkspaces"

// DescribeWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaces operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeWorkspaces for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeWorkspaces method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeWorkspacesRequest method.
//    req, resp := client.DescribeWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspacesRequest(input *DescribeWorkspacesInput) (req *request.Request, output *DescribeWorkspacesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspacesInput{}
	}

	output = &DescribeWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaces API operation for Amazon WorkSpaces.
//
// Obtains information about the specified WorkSpaces.
//
// Only one of the filter parameters, such as BundleId, DirectoryId, or WorkspaceIds,
// can be specified at a time.
//
// This operation supports pagination with the use of the NextToken request
// and response parameters. If more results are available, the NextToken response
// member contains a token that you pass in the next call to this operation
// to retrieve the next set of items.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaces for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspaces(input *DescribeWorkspacesInput) (*DescribeWorkspacesOutput, error) {
	req, out := c.DescribeWorkspacesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeWorkspacesPages iterates over the pages of a DescribeWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaces operation.
//    pageNum := 0
//    err := client.DescribeWorkspacesPages(params,
//        func(page *DescribeWorkspacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspacesPages(input *DescribeWorkspacesInput, fn func(p *DescribeWorkspacesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeWorkspacesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeWorkspacesOutput), lastPage)
	})
}

const opDescribeWorkspacesConnectionStatus = "DescribeWorkspacesConnectionStatus"

// DescribeWorkspacesConnectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspacesConnectionStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeWorkspacesConnectionStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeWorkspacesConnectionStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeWorkspacesConnectionStatusRequest method.
//    req, resp := client.DescribeWorkspacesConnectionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatusRequest(input *DescribeWorkspacesConnectionStatusInput) (req *request.Request, output *DescribeWorkspacesConnectionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspacesConnectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspacesConnectionStatusInput{}
	}

	output = &DescribeWorkspacesConnectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspacesConnectionStatus API operation for Amazon WorkSpaces.
//
// Describes the connection status of a specified WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspacesConnectionStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatus(input *DescribeWorkspacesConnectionStatusInput) (*DescribeWorkspacesConnectionStatusOutput, error) {
	req, out := c.DescribeWorkspacesConnectionStatusRequest(input)
	err := req.Send()
	return out, err
}

const opModifyWorkspaceProperties = "ModifyWorkspaceProperties"

// ModifyWorkspacePropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceProperties operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ModifyWorkspaceProperties for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ModifyWorkspaceProperties method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ModifyWorkspacePropertiesRequest method.
//    req, resp := client.ModifyWorkspacePropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspacePropertiesRequest(input *ModifyWorkspacePropertiesInput) (req *request.Request, output *ModifyWorkspacePropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspacePropertiesInput{}
	}

	output = &ModifyWorkspacePropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyWorkspaceProperties API operation for Amazon WorkSpaces.
//
// Modifies the WorkSpace properties, including the RunningMode and AutoStop
// time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceProperties for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValuesException "InvalidParameterValuesException"
//   One or more parameter values are not valid.
//
//   * ErrCodeInvalidResourceStateException "InvalidResourceStateException"
//   The specified WorkSpace has an invalid state for this operation.
//
//   * ErrCodeOperationInProgressException "OperationInProgressException"
//   The properties of this WorkSpace are currently being modified. Try again
//   in a moment.
//
//   * ErrCodeUnsupportedWorkspaceConfigurationException "UnsupportedWorkspaceConfigurationException"
//   The WorkSpace does not have the supported configuration for this operation.
//   For more information, see the Amazon WorkSpaces Administration Guide (http://docs.aws.amazon.com/workspaces/latest/adminguide).
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The resource could not be found.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//
//   * ErrCodeResourceUnavailableException "ResourceUnavailableException"
//   The specified resource is not available.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspaceProperties(input *ModifyWorkspacePropertiesInput) (*ModifyWorkspacePropertiesOutput, error) {
	req, out := c.ModifyWorkspacePropertiesRequest(input)
	err := req.Send()
	return out, err
}

const opRebootWorkspaces = "RebootWorkspaces"

// RebootWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebootWorkspaces operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RebootWorkspaces for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RebootWorkspaces method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RebootWorkspacesRequest method.
//    req, resp := client.RebootWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspacesRequest(input *RebootWorkspacesInput) (req *request.Request, output *RebootWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebootWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootWorkspacesInput{}
	}

	output = &RebootWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootWorkspaces API operation for Amazon WorkSpaces.
//
// Reboots the specified WorkSpaces.
//
// To be able to reboot a WorkSpace, the WorkSpace must have a State of AVAILABLE,
// IMPAIRED, or INOPERABLE.
//
// This operation is asynchronous and returns before the WorkSpaces have rebooted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebootWorkspaces for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspaces(input *RebootWorkspacesInput) (*RebootWorkspacesOutput, error) {
	req, out := c.RebootWorkspacesRequest(input)
	err := req.Send()
	return out, err
}

const opRebuildWorkspaces = "RebuildWorkspaces"

// RebuildWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebuildWorkspaces operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RebuildWorkspaces for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RebuildWorkspaces method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RebuildWorkspacesRequest method.
//    req, resp := client.RebuildWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspacesRequest(input *RebuildWorkspacesInput) (req *request.Request, output *RebuildWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebuildWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebuildWorkspacesInput{}
	}

	output = &RebuildWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebuildWorkspaces API operation for Amazon WorkSpaces.
//
// Rebuilds the specified WorkSpaces.
//
// Rebuilding a WorkSpace is a potentially destructive action that can result
// in the loss of data. Rebuilding a WorkSpace causes the following to occur:
//
//    * The system is restored to the image of the bundle that the WorkSpace
//    is created from. Any applications that have been installed, or system
//    settings that have been made since the WorkSpace was created will be lost.
//
//    * The data drive (D drive) is re-created from the last automatic snapshot
//    taken of the data drive. The current contents of the data drive are overwritten.
//    Automatic snapshots of the data drive are taken every 12 hours, so the
//    snapshot can be as much as 12 hours old.
//
// To be able to rebuild a WorkSpace, the WorkSpace must have a State of AVAILABLE
// or ERROR.
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely rebuilt.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebuildWorkspaces for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspaces(input *RebuildWorkspacesInput) (*RebuildWorkspacesOutput, error) {
	req, out := c.RebuildWorkspacesRequest(input)
	err := req.Send()
	return out, err
}

const opStartWorkspaces = "StartWorkspaces"

// StartWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StartWorkspaces operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StartWorkspaces for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StartWorkspaces method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StartWorkspacesRequest method.
//    req, resp := client.StartWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspacesRequest(input *StartWorkspacesInput) (req *request.Request, output *StartWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStartWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkspacesInput{}
	}

	output = &StartWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartWorkspaces API operation for Amazon WorkSpaces.
//
// Starts the specified WorkSpaces. The API only works with WorkSpaces that
// have RunningMode configured as AutoStop and the State set to “STOPPED.”
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StartWorkspaces for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspaces(input *StartWorkspacesInput) (*StartWorkspacesOutput, error) {
	req, out := c.StartWorkspacesRequest(input)
	err := req.Send()
	return out, err
}

const opStopWorkspaces = "StopWorkspaces"

// StopWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StopWorkspaces operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See StopWorkspaces for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the StopWorkspaces method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the StopWorkspacesRequest method.
//    req, resp := client.StopWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspacesRequest(input *StopWorkspacesInput) (req *request.Request, output *StopWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStopWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopWorkspacesInput{}
	}

	output = &StopWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopWorkspaces API operation for Amazon WorkSpaces.
//
// Stops the specified WorkSpaces. The API only works with WorkSpaces that have
// RunningMode configured as AutoStop and the State set to AVAILABLE, IMPAIRED,
// UNHEALTHY, or ERROR.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StopWorkspaces for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspaces(input *StopWorkspacesInput) (*StopWorkspacesOutput, error) {
	req, out := c.StopWorkspacesRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateWorkspaces = "TerminateWorkspaces"

// TerminateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the TerminateWorkspaces operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TerminateWorkspaces for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TerminateWorkspaces method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TerminateWorkspacesRequest method.
//    req, resp := client.TerminateWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspacesRequest(input *TerminateWorkspacesInput) (req *request.Request, output *TerminateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opTerminateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkspacesInput{}
	}

	output = &TerminateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateWorkspaces API operation for Amazon WorkSpaces.
//
// Terminates the specified WorkSpaces.
//
// Terminating a WorkSpace is a permanent action and cannot be undone. The user's
// data is not maintained and will be destroyed. If you need to archive any
// user data, contact Amazon Web Services before terminating the WorkSpace.
//
// You can terminate a WorkSpace that is in any state except SUSPENDED.
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely terminated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation TerminateWorkspaces for usage and error information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspaces(input *TerminateWorkspacesInput) (*TerminateWorkspacesOutput, error) {
	req, out := c.TerminateWorkspacesRequest(input)
	err := req.Send()
	return out, err
}

// Contains information about the compute type of a WorkSpace bundle.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ComputeType
type ComputeType struct {
	_ struct{} `type:"structure"`

	// The name of the compute type for the bundle.
	Name *string `type:"string" enum:"Compute"`
}

// String returns the string representation
func (s ComputeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeType) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ComputeType) SetName(v string) *ComputeType {
	s.Name = &v
	return s
}

// The request of the CreateTags operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTagsRequest
type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// The resource ID of the request.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tags of the request.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateTagsInput) SetResourceId(v string) *CreateTagsInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

// The result of the CreateTags operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTagsResult
type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

// Contains the inputs for the CreateWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspacesRequest
type CreateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// An array of structures that specify the WorkSpaces to create.
	//
	// Workspaces is a required field
	Workspaces []*WorkspaceRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspacesInput"}
	if s.Workspaces == nil {
		invalidParams.Add(request.NewErrParamRequired("Workspaces"))
	}
	if s.Workspaces != nil && len(s.Workspaces) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Workspaces", 1))
	}
	if s.Workspaces != nil {
		for i, v := range s.Workspaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Workspaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaces sets the Workspaces field's value.
func (s *CreateWorkspacesInput) SetWorkspaces(v []*WorkspaceRequest) *CreateWorkspacesInput {
	s.Workspaces = v
	return s
}

// Contains the result of the CreateWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspacesResult
type CreateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that represent the WorkSpaces that could not be created.
	FailedRequests []*FailedCreateWorkspaceRequest `type:"list"`

	// An array of structures that represent the WorkSpaces that were created.
	//
	// Because this operation is asynchronous, the identifier in WorkspaceId is
	// not immediately available. If you immediately call DescribeWorkspaces with
	// this identifier, no information will be returned.
	PendingRequests []*Workspace `type:"list"`
}

// String returns the string representation
func (s CreateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *CreateWorkspacesOutput) SetFailedRequests(v []*FailedCreateWorkspaceRequest) *CreateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// SetPendingRequests sets the PendingRequests field's value.
func (s *CreateWorkspacesOutput) SetPendingRequests(v []*Workspace) *CreateWorkspacesOutput {
	s.PendingRequests = v
	return s
}

// Contains default WorkSpace creation information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DefaultWorkspaceCreationProperties
type DefaultWorkspaceCreationProperties struct {
	_ struct{} `type:"structure"`

	// The identifier of any custom security groups that are applied to the WorkSpaces
	// when they are created.
	CustomSecurityGroupId *string `type:"string"`

	// The organizational unit (OU) in the directory that the WorkSpace machine
	// accounts are placed in.
	DefaultOu *string `type:"string"`

	// A public IP address will be attached to all WorkSpaces that are created or
	// rebuilt.
	EnableInternetAccess *bool `type:"boolean"`

	// Specifies if the directory is enabled for Amazon WorkDocs.
	EnableWorkDocs *bool `type:"boolean"`

	// The WorkSpace user is an administrator on the WorkSpace.
	UserEnabledAsLocalAdministrator *bool `type:"boolean"`
}

// String returns the string representation
func (s DefaultWorkspaceCreationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultWorkspaceCreationProperties) GoString() string {
	return s.String()
}

// SetCustomSecurityGroupId sets the CustomSecurityGroupId field's value.
func (s *DefaultWorkspaceCreationProperties) SetCustomSecurityGroupId(v string) *DefaultWorkspaceCreationProperties {
	s.CustomSecurityGroupId = &v
	return s
}

// SetDefaultOu sets the DefaultOu field's value.
func (s *DefaultWorkspaceCreationProperties) SetDefaultOu(v string) *DefaultWorkspaceCreationProperties {
	s.DefaultOu = &v
	return s
}

// SetEnableInternetAccess sets the EnableInternetAccess field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableInternetAccess(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableInternetAccess = &v
	return s
}

// SetEnableWorkDocs sets the EnableWorkDocs field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableWorkDocs(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableWorkDocs = &v
	return s
}

// SetUserEnabledAsLocalAdministrator sets the UserEnabledAsLocalAdministrator field's value.
func (s *DefaultWorkspaceCreationProperties) SetUserEnabledAsLocalAdministrator(v bool) *DefaultWorkspaceCreationProperties {
	s.UserEnabledAsLocalAdministrator = &v
	return s
}

// The request of the DeleteTags operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTagsRequest
type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The resource ID of the request.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tag keys of the request.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteTagsInput) SetResourceId(v string) *DeleteTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

// The result of the DeleteTags operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTagsResult
type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

// The request of the DescribeTags operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTagsRequest
type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The resource ID of the request.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeTagsInput) SetResourceId(v string) *DescribeTagsInput {
	s.ResourceId = &v
	return s
}

// The result of the DescribeTags operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTagsResult
type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *DescribeTagsOutput) SetTagList(v []*Tag) *DescribeTagsOutput {
	s.TagList = v
	return s
}

// Contains the inputs for the DescribeWorkspaceBundles operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundlesRequest
type DescribeWorkspaceBundlesInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that contains the identifiers of the bundles to retrieve.
	// This parameter cannot be combined with any other filter parameter.
	BundleIds []*string `min:"1" type:"list"`

	// The NextToken value from a previous call to this operation. Pass null if
	// this is the first call.
	NextToken *string `min:"1" type:"string"`

	// The owner of the bundles to retrieve. This parameter cannot be combined with
	// any other filter parameter.
	//
	// This contains one of the following values:
	//
	//    * null- Retrieves the bundles that belong to the account making the call.
	//
	//    * AMAZON- Retrieves the bundles that are provided by AWS.
	Owner *string `type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceBundlesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceBundlesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceBundlesInput"}
	if s.BundleIds != nil && len(s.BundleIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleIds", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleIds sets the BundleIds field's value.
func (s *DescribeWorkspaceBundlesInput) SetBundleIds(v []*string) *DescribeWorkspaceBundlesInput {
	s.BundleIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesInput) SetNextToken(v string) *DescribeWorkspaceBundlesInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DescribeWorkspaceBundlesInput) SetOwner(v string) *DescribeWorkspaceBundlesInput {
	s.Owner = &v
	return s
}

// Contains the results of the DescribeWorkspaceBundles operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundlesResult
type DescribeWorkspaceBundlesOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain information about the bundles.
	Bundles []*WorkspaceBundle `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to this operation to retrieve the next set
	// of items. This token is valid for one day and must be used within that time
	// frame.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceBundlesOutput) GoString() string {
	return s.String()
}

// SetBundles sets the Bundles field's value.
func (s *DescribeWorkspaceBundlesOutput) SetBundles(v []*WorkspaceBundle) *DescribeWorkspaceBundlesOutput {
	s.Bundles = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesOutput) SetNextToken(v string) *DescribeWorkspaceBundlesOutput {
	s.NextToken = &v
	return s
}

// Contains the inputs for the DescribeWorkspaceDirectories operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectoriesRequest
type DescribeWorkspaceDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// An array of strings that contains the directory identifiers to retrieve information
	// for. If this member is null, all directories are retrieved.
	DirectoryIds []*string `min:"1" type:"list"`

	// The NextToken value from a previous call to this operation. Pass null if
	// this is the first call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceDirectoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceDirectoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceDirectoriesInput"}
	if s.DirectoryIds != nil && len(s.DirectoryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryIds", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryIds sets the DirectoryIds field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetDirectoryIds(v []*string) *DescribeWorkspaceDirectoriesInput {
	s.DirectoryIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetNextToken(v string) *DescribeWorkspaceDirectoriesInput {
	s.NextToken = &v
	return s
}

// Contains the results of the DescribeWorkspaceDirectories operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectoriesResult
type DescribeWorkspaceDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures that contain information about the directories.
	Directories []*WorkspaceDirectory `type:"list"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to this operation to retrieve the next set
	// of items. This token is valid for one day and must be used within that time
	// frame.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorkspaceDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspaceDirectoriesOutput) GoString() string {
	return s.String()
}

// SetDirectories sets the Directories field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetDirectories(v []*WorkspaceDirectory) *DescribeWorkspaceDirectoriesOutput {
	s.Directories = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetNextToken(v string) *DescribeWorkspaceDirectoriesOutput {
	s.NextToken = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatusRequest
type DescribeWorkspacesConnectionStatusInput struct {
	_ struct{} `type:"structure"`

	// The next token of the request.
	NextToken *string `min:"1" type:"string"`

	// An array of strings that contain the identifiers of the WorkSpaces.
	WorkspaceIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesConnectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesConnectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesConnectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesConnectionStatusInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesConnectionStatusInput {
	s.WorkspaceIds = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatusResult
type DescribeWorkspacesConnectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The next token of the result.
	NextToken *string `min:"1" type:"string"`

	// The connection status of the WorkSpace.
	WorkspacesConnectionStatus []*WorkspaceConnectionStatus `type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesConnectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesConnectionStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusOutput {
	s.NextToken = &v
	return s
}

// SetWorkspacesConnectionStatus sets the WorkspacesConnectionStatus field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetWorkspacesConnectionStatus(v []*WorkspaceConnectionStatus) *DescribeWorkspacesConnectionStatusOutput {
	s.WorkspacesConnectionStatus = v
	return s
}

// Contains the inputs for the DescribeWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesRequest
type DescribeWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of a bundle to obtain the WorkSpaces for. All WorkSpaces that
	// are created from this bundle will be retrieved. This parameter cannot be
	// combined with any other filter parameter.
	BundleId *string `type:"string"`

	// Specifies the directory identifier to which to limit the WorkSpaces. Optionally,
	// you can specify a specific directory user with the UserName parameter. This
	// parameter cannot be combined with any other filter parameter.
	DirectoryId *string `type:"string"`

	// The maximum number of items to return.
	Limit *int64 `min:"1" type:"integer"`

	// The NextToken value from a previous call to this operation. Pass null if
	// this is the first call.
	NextToken *string `min:"1" type:"string"`

	// Used with the DirectoryId parameter to specify the directory user for whom
	// to obtain the WorkSpace.
	UserName *string `min:"1" type:"string"`

	// An array of strings that contain the identifiers of the WorkSpaces for which
	// to retrieve information. This parameter cannot be combined with any other
	// filter parameter.
	//
	// Because the CreateWorkspaces operation is asynchronous, the identifier it
	// returns is not immediately available. If you immediately call DescribeWorkspaces
	// with this identifier, no information is returned.
	WorkspaceIds []*string `min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *DescribeWorkspacesInput) SetBundleId(v string) *DescribeWorkspacesInput {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeWorkspacesInput) SetDirectoryId(v string) *DescribeWorkspacesInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeWorkspacesInput) SetLimit(v int64) *DescribeWorkspacesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesInput) SetNextToken(v string) *DescribeWorkspacesInput {
	s.NextToken = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeWorkspacesInput) SetUserName(v string) *DescribeWorkspacesInput {
	s.UserName = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesInput {
	s.WorkspaceIds = v
	return s
}

// Contains the results for the DescribeWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesResult
type DescribeWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// If not null, more results are available. Pass this value for the NextToken
	// parameter in a subsequent call to this operation to retrieve the next set
	// of items. This token is valid for one day and must be used within that time
	// frame.
	NextToken *string `min:"1" type:"string"`

	// An array of structures that contain the information about the WorkSpaces.
	//
	// Because the CreateWorkspaces operation is asynchronous, some of this information
	// may be incomplete for a newly-created WorkSpace.
	Workspaces []*Workspace `type:"list"`
}

// String returns the string representation
func (s DescribeWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesOutput) SetNextToken(v string) *DescribeWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaces sets the Workspaces field's value.
func (s *DescribeWorkspacesOutput) SetWorkspaces(v []*Workspace) *DescribeWorkspacesOutput {
	s.Workspaces = v
	return s
}

// Contains information about a WorkSpace that could not be created.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/FailedCreateWorkspaceRequest
type FailedCreateWorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The textual error message.
	ErrorMessage *string `type:"string"`

	// A FailedCreateWorkspaceRequest$WorkspaceRequest object that contains the
	// information about the WorkSpace that could not be created.
	WorkspaceRequest *WorkspaceRequest `type:"structure"`
}

// String returns the string representation
func (s FailedCreateWorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedCreateWorkspaceRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorCode(v string) *FailedCreateWorkspaceRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorMessage(v string) *FailedCreateWorkspaceRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceRequest sets the WorkspaceRequest field's value.
func (s *FailedCreateWorkspaceRequest) SetWorkspaceRequest(v *WorkspaceRequest) *FailedCreateWorkspaceRequest {
	s.WorkspaceRequest = v
	return s
}

// Contains information about a WorkSpace that could not be rebooted (RebootWorkspaces),
// rebuilt (RebuildWorkspaces), terminated (TerminateWorkspaces), started (StartWorkspaces),
// or stopped (StopWorkspaces).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/FailedWorkspaceChangeRequest
type FailedWorkspaceChangeRequest struct {
	_ struct{} `type:"structure"`

	// The error code.
	ErrorCode *string `type:"string"`

	// The textual error message.
	ErrorMessage *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s FailedWorkspaceChangeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedWorkspaceChangeRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorCode(v string) *FailedWorkspaceChangeRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorMessage(v string) *FailedWorkspaceChangeRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *FailedWorkspaceChangeRequest) SetWorkspaceId(v string) *FailedWorkspaceChangeRequest {
	s.WorkspaceId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspacePropertiesRequest
type ModifyWorkspacePropertiesInput struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`

	// The WorkSpace properties of the request.
	//
	// WorkspaceProperties is a required field
	WorkspaceProperties *WorkspaceProperties `type:"structure" required:"true"`
}

// String returns the string representation
func (s ModifyWorkspacePropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspacePropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspacePropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspacePropertiesInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceId(v string) *ModifyWorkspacePropertiesInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceProperties(v *WorkspaceProperties) *ModifyWorkspacePropertiesInput {
	s.WorkspaceProperties = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspacePropertiesResult
type ModifyWorkspacePropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyWorkspacePropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyWorkspacePropertiesOutput) GoString() string {
	return s.String()
}

// Contains information used with the RebootWorkspaces operation to reboot a
// WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootRequest
type RebootRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace to reboot.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebootRequest) SetWorkspaceId(v string) *RebootRequest {
	s.WorkspaceId = &v
	return s
}

// Contains the inputs for the RebootWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspacesRequest
type RebootWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// An array of structures that specify the WorkSpaces to reboot.
	//
	// RebootWorkspaceRequests is a required field
	RebootWorkspaceRequests []*RebootRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RebootWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootWorkspacesInput"}
	if s.RebootWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebootWorkspaceRequests"))
	}
	if s.RebootWorkspaceRequests != nil && len(s.RebootWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebootWorkspaceRequests", 1))
	}
	if s.RebootWorkspaceRequests != nil {
		for i, v := range s.RebootWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebootWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebootWorkspaceRequests sets the RebootWorkspaceRequests field's value.
func (s *RebootWorkspacesInput) SetRebootWorkspaceRequests(v []*RebootRequest) *RebootWorkspacesInput {
	s.RebootWorkspaceRequests = v
	return s
}

// Contains the results of the RebootWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspacesResult
type RebootWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures representing any WorkSpaces that could not be rebooted.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s RebootWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebootWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebootWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Contains information used with the RebuildWorkspaces operation to rebuild
// a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildRequest
type RebuildRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace to rebuild.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebuildRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebuildRequest) SetWorkspaceId(v string) *RebuildRequest {
	s.WorkspaceId = &v
	return s
}

// Contains the inputs for the RebuildWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspacesRequest
type RebuildWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// An array of structures that specify the WorkSpaces to rebuild.
	//
	// RebuildWorkspaceRequests is a required field
	RebuildWorkspaceRequests []*RebuildRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RebuildWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildWorkspacesInput"}
	if s.RebuildWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebuildWorkspaceRequests"))
	}
	if s.RebuildWorkspaceRequests != nil && len(s.RebuildWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebuildWorkspaceRequests", 1))
	}
	if s.RebuildWorkspaceRequests != nil {
		for i, v := range s.RebuildWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebuildWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebuildWorkspaceRequests sets the RebuildWorkspaceRequests field's value.
func (s *RebuildWorkspacesInput) SetRebuildWorkspaceRequests(v []*RebuildRequest) *RebuildWorkspacesInput {
	s.RebuildWorkspaceRequests = v
	return s
}

// Contains the results of the RebuildWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspacesResult
type RebuildWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures representing any WorkSpaces that could not be rebuilt.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s RebuildWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebuildWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebuildWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebuildWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes the start request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartRequest
type StartRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s StartRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StartRequest) SetWorkspaceId(v string) *StartRequest {
	s.WorkspaceId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspacesRequest
type StartWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The requests.
	//
	// StartWorkspaceRequests is a required field
	StartWorkspaceRequests []*StartRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StartWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartWorkspacesInput"}
	if s.StartWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StartWorkspaceRequests"))
	}
	if s.StartWorkspaceRequests != nil && len(s.StartWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStartWorkspaceRequests sets the StartWorkspaceRequests field's value.
func (s *StartWorkspacesInput) SetStartWorkspaceRequests(v []*StartRequest) *StartWorkspacesInput {
	s.StartWorkspaceRequests = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspacesResult
type StartWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// The failed requests.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s StartWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StartWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StartWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes the stop request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopRequest
type StopRequest struct {
	_ struct{} `type:"structure"`

	// The ID of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s StopRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StopRequest) SetWorkspaceId(v string) *StopRequest {
	s.WorkspaceId = &v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspacesRequest
type StopWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The requests.
	//
	// StopWorkspaceRequests is a required field
	StopWorkspaceRequests []*StopRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s StopWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopWorkspacesInput"}
	if s.StopWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StopWorkspaceRequests"))
	}
	if s.StopWorkspaceRequests != nil && len(s.StopWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StopWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStopWorkspaceRequests sets the StopWorkspaceRequests field's value.
func (s *StopWorkspacesInput) SetStopWorkspaceRequests(v []*StopRequest) *StopWorkspacesInput {
	s.StopWorkspaceRequests = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspacesResult
type StopWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// The failed requests.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s StopWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StopWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StopWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes the tag of the WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Contains information used with the TerminateWorkspaces operation to terminate
// a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateRequest
type TerminateRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace to terminate.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TerminateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *TerminateRequest) SetWorkspaceId(v string) *TerminateRequest {
	s.WorkspaceId = &v
	return s
}

// Contains the inputs for the TerminateWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesRequest
type TerminateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// An array of structures that specify the WorkSpaces to terminate.
	//
	// TerminateWorkspaceRequests is a required field
	TerminateWorkspaceRequests []*TerminateRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TerminateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateWorkspacesInput"}
	if s.TerminateWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminateWorkspaceRequests"))
	}
	if s.TerminateWorkspaceRequests != nil && len(s.TerminateWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TerminateWorkspaceRequests", 1))
	}
	if s.TerminateWorkspaceRequests != nil {
		for i, v := range s.TerminateWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TerminateWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTerminateWorkspaceRequests sets the TerminateWorkspaceRequests field's value.
func (s *TerminateWorkspacesInput) SetTerminateWorkspaceRequests(v []*TerminateRequest) *TerminateWorkspacesInput {
	s.TerminateWorkspaceRequests = v
	return s
}

// Contains the results of the TerminateWorkspaces operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesResult
type TerminateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures representing any WorkSpaces that could not be terminated.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation
func (s TerminateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *TerminateWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *TerminateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Contains information about the user storage for a WorkSpace bundle.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UserStorage
type UserStorage struct {
	_ struct{} `type:"structure"`

	// The amount of user storage for the bundle.
	Capacity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UserStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserStorage) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *UserStorage) SetCapacity(v string) *UserStorage {
	s.Capacity = &v
	return s
}

// Contains information about a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/Workspace
type Workspace struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle that the WorkSpace was created from.
	BundleId *string `type:"string"`

	// The name of the WorkSpace as seen by the operating system.
	ComputerName *string `type:"string"`

	// The identifier of the AWS Directory Service directory that the WorkSpace
	// belongs to.
	DirectoryId *string `type:"string"`

	// If the WorkSpace could not be created, this contains the error code.
	ErrorCode *string `type:"string"`

	// If the WorkSpace could not be created, this contains a textual error message
	// that describes the failure.
	ErrorMessage *string `type:"string"`

	// The IP address of the WorkSpace.
	IpAddress *string `type:"string"`

	// Specifies whether the data stored on the root volume, or C: drive, is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The operational state of the WorkSpace.
	State *string `type:"string" enum:"WorkspaceState"`

	// The identifier of the subnet that the WorkSpace is in.
	SubnetId *string `type:"string"`

	// The user that the WorkSpace is assigned to.
	UserName *string `min:"1" type:"string"`

	// Specifies whether the data stored on the user volume, or D: drive, is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The KMS key used to encrypt data stored on your WorkSpace.
	VolumeEncryptionKey *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`

	// Describes the properties of a WorkSpace.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation
func (s Workspace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Workspace) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *Workspace) SetBundleId(v string) *Workspace {
	s.BundleId = &v
	return s
}

// SetComputerName sets the ComputerName field's value.
func (s *Workspace) SetComputerName(v string) *Workspace {
	s.ComputerName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *Workspace) SetDirectoryId(v string) *Workspace {
	s.DirectoryId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Workspace) SetErrorCode(v string) *Workspace {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *Workspace) SetErrorMessage(v string) *Workspace {
	s.ErrorMessage = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Workspace) SetIpAddress(v string) *Workspace {
	s.IpAddress = &v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *Workspace) SetRootVolumeEncryptionEnabled(v bool) *Workspace {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetState sets the State field's value.
func (s *Workspace) SetState(v string) *Workspace {
	s.State = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Workspace) SetSubnetId(v string) *Workspace {
	s.SubnetId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *Workspace) SetUserName(v string) *Workspace {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *Workspace) SetUserVolumeEncryptionEnabled(v bool) *Workspace {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *Workspace) SetVolumeEncryptionKey(v string) *Workspace {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *Workspace) SetWorkspaceId(v string) *Workspace {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *Workspace) SetWorkspaceProperties(v *WorkspaceProperties) *Workspace {
	s.WorkspaceProperties = v
	return s
}

// Contains information about a WorkSpace bundle.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceBundle
type WorkspaceBundle struct {
	_ struct{} `type:"structure"`

	// The bundle identifier.
	BundleId *string `type:"string"`

	// A ComputeType object that specifies the compute type for the bundle.
	ComputeType *ComputeType `type:"structure"`

	// The bundle description.
	Description *string `type:"string"`

	// The name of the bundle.
	Name *string `min:"1" type:"string"`

	// The owner of the bundle. This contains the owner's account identifier, or
	// AMAZON if the bundle is provided by AWS.
	Owner *string `type:"string"`

	// A UserStorage object that specifies the amount of user storage that the bundle
	// contains.
	UserStorage *UserStorage `type:"structure"`
}

// String returns the string representation
func (s WorkspaceBundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceBundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceBundle) SetBundleId(v string) *WorkspaceBundle {
	s.BundleId = &v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *WorkspaceBundle) SetComputeType(v *ComputeType) *WorkspaceBundle {
	s.ComputeType = v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceBundle) SetDescription(v string) *WorkspaceBundle {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceBundle) SetName(v string) *WorkspaceBundle {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkspaceBundle) SetOwner(v string) *WorkspaceBundle {
	s.Owner = &v
	return s
}

// SetUserStorage sets the UserStorage field's value.
func (s *WorkspaceBundle) SetUserStorage(v *UserStorage) *WorkspaceBundle {
	s.UserStorage = v
	return s
}

// Describes the connection status of a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceConnectionStatus
type WorkspaceConnectionStatus struct {
	_ struct{} `type:"structure"`

	// The connection state of the WorkSpace. Returns UNKOWN if the WorkSpace is
	// in a Stopped state.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// The timestamp of the connection state check.
	ConnectionStateCheckTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The timestamp of the last known user connection.
	LastKnownUserConnectionTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The ID of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation
func (s WorkspaceConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceConnectionStatus) GoString() string {
	return s.String()
}

// SetConnectionState sets the ConnectionState field's value.
func (s *WorkspaceConnectionStatus) SetConnectionState(v string) *WorkspaceConnectionStatus {
	s.ConnectionState = &v
	return s
}

// SetConnectionStateCheckTimestamp sets the ConnectionStateCheckTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetConnectionStateCheckTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.ConnectionStateCheckTimestamp = &v
	return s
}

// SetLastKnownUserConnectionTimestamp sets the LastKnownUserConnectionTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetLastKnownUserConnectionTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.LastKnownUserConnectionTimestamp = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceConnectionStatus) SetWorkspaceId(v string) *WorkspaceConnectionStatus {
	s.WorkspaceId = &v
	return s
}

// Contains information about an AWS Directory Service directory for use with
// Amazon WorkSpaces.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceDirectory
type WorkspaceDirectory struct {
	_ struct{} `type:"structure"`

	// The directory alias.
	Alias *string `type:"string"`

	// The user name for the service account.
	CustomerUserName *string `min:"1" type:"string"`

	// The directory identifier.
	DirectoryId *string `type:"string"`

	// The name of the directory.
	DirectoryName *string `type:"string"`

	// The directory type.
	DirectoryType *string `type:"string" enum:"WorkspaceDirectoryType"`

	// An array of strings that contains the IP addresses of the DNS servers for
	// the directory.
	DnsIpAddresses []*string `type:"list"`

	// The identifier of the IAM role. This is the role that allows Amazon WorkSpaces
	// to make calls to other services, such as Amazon EC2, on your behalf.
	IamRoleId *string `type:"string"`

	// The registration code for the directory. This is the code that users enter
	// in their Amazon WorkSpaces client application to connect to the directory.
	RegistrationCode *string `min:"1" type:"string"`

	// The state of the directory's registration with Amazon WorkSpaces
	State *string `type:"string" enum:"WorkspaceDirectoryState"`

	// An array of strings that contains the identifiers of the subnets used with
	// the directory.
	SubnetIds []*string `type:"list"`

	// A structure that specifies the default creation properties for all WorkSpaces
	// in the directory.
	WorkspaceCreationProperties *DefaultWorkspaceCreationProperties `type:"structure"`

	// The identifier of the security group that is assigned to new WorkSpaces.
	WorkspaceSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s WorkspaceDirectory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceDirectory) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *WorkspaceDirectory) SetAlias(v string) *WorkspaceDirectory {
	s.Alias = &v
	return s
}

// SetCustomerUserName sets the CustomerUserName field's value.
func (s *WorkspaceDirectory) SetCustomerUserName(v string) *WorkspaceDirectory {
	s.CustomerUserName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceDirectory) SetDirectoryId(v string) *WorkspaceDirectory {
	s.DirectoryId = &v
	return s
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *WorkspaceDirectory) SetDirectoryName(v string) *WorkspaceDirectory {
	s.DirectoryName = &v
	return s
}

// SetDirectoryType sets the DirectoryType field's value.
func (s *WorkspaceDirectory) SetDirectoryType(v string) *WorkspaceDirectory {
	s.DirectoryType = &v
	return s
}

// SetDnsIpAddresses sets the DnsIpAddresses field's value.
func (s *WorkspaceDirectory) SetDnsIpAddresses(v []*string) *WorkspaceDirectory {
	s.DnsIpAddresses = v
	return s
}

// SetIamRoleId sets the IamRoleId field's value.
func (s *WorkspaceDirectory) SetIamRoleId(v string) *WorkspaceDirectory {
	s.IamRoleId = &v
	return s
}

// SetRegistrationCode sets the RegistrationCode field's value.
func (s *WorkspaceDirectory) SetRegistrationCode(v string) *WorkspaceDirectory {
	s.RegistrationCode = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceDirectory) SetState(v string) *WorkspaceDirectory {
	s.State = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *WorkspaceDirectory) SetSubnetIds(v []*string) *WorkspaceDirectory {
	s.SubnetIds = v
	return s
}

// SetWorkspaceCreationProperties sets the WorkspaceCreationProperties field's value.
func (s *WorkspaceDirectory) SetWorkspaceCreationProperties(v *DefaultWorkspaceCreationProperties) *WorkspaceDirectory {
	s.WorkspaceCreationProperties = v
	return s
}

// SetWorkspaceSecurityGroupId sets the WorkspaceSecurityGroupId field's value.
func (s *WorkspaceDirectory) SetWorkspaceSecurityGroupId(v string) *WorkspaceDirectory {
	s.WorkspaceSecurityGroupId = &v
	return s
}

// Describes the properties of a WorkSpace.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceProperties
type WorkspaceProperties struct {
	_ struct{} `type:"structure"`

	// The running mode of the WorkSpace. AlwaysOn WorkSpaces are billed monthly.
	// AutoStop WorkSpaces are billed by the hour and stopped when no longer being
	// used in order to save on costs.
	RunningMode *string `type:"string" enum:"RunningMode"`

	// The time after a user logs off when WorkSpaces are automatically stopped.
	// Configured in 60 minute intervals.
	RunningModeAutoStopTimeoutInMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s WorkspaceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceProperties) GoString() string {
	return s.String()
}

// SetRunningMode sets the RunningMode field's value.
func (s *WorkspaceProperties) SetRunningMode(v string) *WorkspaceProperties {
	s.RunningMode = &v
	return s
}

// SetRunningModeAutoStopTimeoutInMinutes sets the RunningModeAutoStopTimeoutInMinutes field's value.
func (s *WorkspaceProperties) SetRunningModeAutoStopTimeoutInMinutes(v int64) *WorkspaceProperties {
	s.RunningModeAutoStopTimeoutInMinutes = &v
	return s
}

// Contains information about a WorkSpace creation request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/WorkspaceRequest
type WorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle to create the WorkSpace from. You can use the
	// DescribeWorkspaceBundles operation to obtain a list of the bundles that are
	// available.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The identifier of the AWS Directory Service directory to create the WorkSpace
	// in. You can use the DescribeWorkspaceDirectories operation to obtain a list
	// of the directories that are available.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// Specifies whether the data stored on the root volume, or C: drive, is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The tags of the WorkSpace request.
	Tags []*Tag `type:"list"`

	// The username that the WorkSpace is assigned to. This username must exist
	// in the AWS Directory Service directory specified by the DirectoryId member.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`

	// Specifies whether the data stored on the user volume, or D: drive, is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The KMS key used to encrypt data stored on your WorkSpace.
	VolumeEncryptionKey *string `type:"string"`

	// Describes the properties of a WorkSpace.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation
func (s WorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkspaceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkspaceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkspaceRequest"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceRequest) SetBundleId(v string) *WorkspaceRequest {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceRequest) SetDirectoryId(v string) *WorkspaceRequest {
	s.DirectoryId = &v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetRootVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceRequest) SetTags(v []*Tag) *WorkspaceRequest {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *WorkspaceRequest) SetUserName(v string) *WorkspaceRequest {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetUserVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *WorkspaceRequest) SetVolumeEncryptionKey(v string) *WorkspaceRequest {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *WorkspaceRequest) SetWorkspaceProperties(v *WorkspaceProperties) *WorkspaceRequest {
	s.WorkspaceProperties = v
	return s
}

const (
	// ComputeValue is a Compute enum value
	ComputeValue = "VALUE"

	// ComputeStandard is a Compute enum value
	ComputeStandard = "STANDARD"

	// ComputePerformance is a Compute enum value
	ComputePerformance = "PERFORMANCE"
)

const (
	// ConnectionStateConnected is a ConnectionState enum value
	ConnectionStateConnected = "CONNECTED"

	// ConnectionStateDisconnected is a ConnectionState enum value
	ConnectionStateDisconnected = "DISCONNECTED"

	// ConnectionStateUnknown is a ConnectionState enum value
	ConnectionStateUnknown = "UNKNOWN"
)

const (
	// RunningModeAutoStop is a RunningMode enum value
	RunningModeAutoStop = "AUTO_STOP"

	// RunningModeAlwaysOn is a RunningMode enum value
	RunningModeAlwaysOn = "ALWAYS_ON"
)

const (
	// WorkspaceDirectoryStateRegistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistering = "REGISTERING"

	// WorkspaceDirectoryStateRegistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistered = "REGISTERED"

	// WorkspaceDirectoryStateDeregistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistering = "DEREGISTERING"

	// WorkspaceDirectoryStateDeregistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistered = "DEREGISTERED"

	// WorkspaceDirectoryStateError is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateError = "ERROR"
)

const (
	// WorkspaceDirectoryTypeSimpleAd is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeSimpleAd = "SIMPLE_AD"

	// WorkspaceDirectoryTypeAdConnector is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeAdConnector = "AD_CONNECTOR"
)

const (
	// WorkspaceStatePending is a WorkspaceState enum value
	WorkspaceStatePending = "PENDING"

	// WorkspaceStateAvailable is a WorkspaceState enum value
	WorkspaceStateAvailable = "AVAILABLE"

	// WorkspaceStateImpaired is a WorkspaceState enum value
	WorkspaceStateImpaired = "IMPAIRED"

	// WorkspaceStateUnhealthy is a WorkspaceState enum value
	WorkspaceStateUnhealthy = "UNHEALTHY"

	// WorkspaceStateRebooting is a WorkspaceState enum value
	WorkspaceStateRebooting = "REBOOTING"

	// WorkspaceStateStarting is a WorkspaceState enum value
	WorkspaceStateStarting = "STARTING"

	// WorkspaceStateRebuilding is a WorkspaceState enum value
	WorkspaceStateRebuilding = "REBUILDING"

	// WorkspaceStateMaintenance is a WorkspaceState enum value
	WorkspaceStateMaintenance = "MAINTENANCE"

	// WorkspaceStateTerminating is a WorkspaceState enum value
	WorkspaceStateTerminating = "TERMINATING"

	// WorkspaceStateTerminated is a WorkspaceState enum value
	WorkspaceStateTerminated = "TERMINATED"

	// WorkspaceStateSuspended is a WorkspaceState enum value
	WorkspaceStateSuspended = "SUSPENDED"

	// WorkspaceStateStopping is a WorkspaceState enum value
	WorkspaceStateStopping = "STOPPING"

	// WorkspaceStateStopped is a WorkspaceState enum value
	WorkspaceStateStopped = "STOPPED"

	// WorkspaceStateError is a WorkspaceState enum value
	WorkspaceStateError = "ERROR"
)
