---
title: Creating an object storage instance
date: 1970-01-02
---
Creating a Cloud Object Storage instance gives us a reliable place to keep our training data. It also opens up the potential for data collection and collaboration, letting us collect user data and allowing a team of specialists to easily label it.

IBM Cloud offers a lite tier of object storage, which includes 25 GB of storage for free. (this is what we will be using throughout the tutorial)

To create an instance we first need to **log in** or **sign up** for [IBM Cloud](https://ibm.biz/cloud-annotations-sign-up).

Once logged in you should find your IBM Cloud dashboard. This is where we can create and manage IBM Cloud resources.

We want to create a new Cloud Object Storage instance so click the **Create resource** button.
![](https://d2mxuefqeaa7sj.cloudfront.net/s_E7D1C1E8D801F89315B72C10AD83AE795982C7EB84F7BA48CECD8A576B02D6CC_1539804040052_Screen+Shot+2018-10-17+at+2.35.53+PM.png)

Locate and choose the **Object Storage** option.
![](https://d2mxuefqeaa7sj.cloudfront.net/s_E7D1C1E8D801F89315B72C10AD83AE795982C7EB84F7BA48CECD8A576B02D6CC_1539804229570_Screen+Shot+2018-10-17+at+2.36.18+PM.png)

Choose a pricing plan and click **Create**, then **Confirm** on the following popup.
![](https://d2mxuefqeaa7sj.cloudfront.net/s_E7D1C1E8D801F89315B72C10AD83AE795982C7EB84F7BA48CECD8A576B02D6CC_1539804685813_Screen+Shot+2018-10-17+at+2.37.27+PM.png)

## Credentials
Once we have an object storage instance we need a way to access our data from outside of IBM Cloud.
To do be able to do this we need to create a set credentials for our resource.

We can do this by navigating to the **Service credentials** tab and clicking the **New credential** button.
![](https://d2mxuefqeaa7sj.cloudfront.net/s_E7D1C1E8D801F89315B72C10AD83AE795982C7EB84F7BA48CECD8A576B02D6CC_1539807399869_Screen+Shot+2018-10-17+at+3.00.09+PM.png)

You can leave most of the options blank, but make sure the credential has the role of **Writer** and add the following inline configuration parameters:
```
{"HMAC": true}
```
![](assets/credentials_hmac.png)

Once added, click the **View credentials ▾** dropdown and take note of your **apikey**, **access_key_id**, **secret_access_key** and **resource_instance_id**.
![](https://d2mxuefqeaa7sj.cloudfront.net/s_E7D1C1E8D801F89315B72C10AD83AE795982C7EB84F7BA48CECD8A576B02D6CC_1539805788894_Screen+Shot+2018-10-17+at+2.41.53+PM.png)

<pre>
{
  <b>"apikey": "...",</b>
  "cos_hmac_keys": {
    <b>"access_key_id": "...",</b>
    <b>"secret_access_key": "..."</b>
  },
  "endpoints": "...",
  "iam_apikey_description": "...",
  "iam_apikey_name": "...",
  "iam_role_crn": "...",
  "iam_serviceid_crn": "...",
  <b>"resource_instance_id": "..."</b>
}
</pre>
