---
title: Preparing training data
date: 1970-01-05
---
Since we are doing image classification, the data we prepare will consist of images with associated labels.

To ease creating annotations in our object storage bucket, we can use the [Cloud Annotations Tool](https://cloud.annotations.ai), a web GUI that sits on top of our object storage that allows us to upload photos and associate them with annotations.

To use the tool just navigate to the [Cloud Annotations Tool](https://cloud.annotations.ai) and add your object storage credentials.
![](https://d2mxuefqeaa7sj.cloudfront.net/s_E7D1C1E8D801F89315B72C10AD83AE795982C7EB84F7BA48CECD8A576B02D6CC_1539807682825_Screen+Shot+2018-10-17+at+4.21.05+PM.png)

We will be storing our files and annotations in something called a **bucket**, we can create one by clicking **Create bucket**.
![](assets/create_bucket.png)

## Training data best practices
* The model we will be training is optimized for photographs of objects in the real world. They are unlikely to work well for x-rays, hand drawings, scanned documents, receipts, etc.

* The training data should be as close as possible to the data on which predictions are to be made. For example, if your use case involves blurry and low-resolution images (such as from a security camera), your training data should be composed of blurry, low-resolution images. In general, you should also consider providing multiple angles, resolutions, and backgrounds for your training images.

* The model we will be training can't generally predict labels that humans can't assign. So, if a human can't be trained to assign labels by looking at the image for 1-2 seconds, the model likely can't be trained to do it either.

* We recommend at least 50 training images per label for a usable model, but using 100s or 1000s would provide better results.

* Consider including a `negative`, `none of the above`, `neither` or any label name you prefer and label images with it that don't match any of your defined labels. For example, for a flower dataset, include images of flowers outside of your labeled varieties, and label them as `none of the above`.

* The model we will be training resizes the image to 224x224 pixels, so keep that is mind when training the model with images where one dimension is much longer than the other.
![](assets/image_shrink.png)

## Labeling the data
I find the quickest way to label images is to:
1. Add a label
2. Select the label from the sidebar
3. Upload the images corresponding to that label and they will be automatically tagged

![](assets/cloud_annotations.png)

## &nbsp;
> **📁 [Sample Training Data](https://github.com/bourdakos1/Cloud-Annotations/releases/download/v1.0/workshop-training-data.zip)**
