---
title: Generating object storage credentials
date: 1970-01-4
---
We already have an object storage instance, but now we need a way to access our data from outside of IBM Cloud.
To be able to do this we need to create a set credentials for our resource.

Go to your [IBM Cloud resources](https://cloud.ibm.com/resources?groups=storage&cm_mmc=OSocial_Blog-_-Developer_IBM+Developer-_-WW_WW-_-ibmdev-Github-NSB-cloud-annotations-sign-up&cm_mmca1=000037FD&cm_mmca2=10010797) and open your object storage instance.
![](assets/resources.png)

We can generate a credential by navigating to the **Service credentials** tab and clicking the **New credential** button.
![](https://d2mxuefqeaa7sj.cloudfront.net/s_E7D1C1E8D801F89315B72C10AD83AE795982C7EB84F7BA48CECD8A576B02D6CC_1539807399869_Screen+Shot+2018-10-17+at+3.00.09+PM.png)

You can leave most of the options blank, but make sure the credential has the role of **Writer** and add the following inline configuration parameters:
```
{"HMAC": true}
```
![](assets/credentials_hmac.png)

Once added, click the **View credentials ▾** dropdown and take note of your **access_key_id** and **secret_access_key**.
![](https://d2mxuefqeaa7sj.cloudfront.net/s_E7D1C1E8D801F89315B72C10AD83AE795982C7EB84F7BA48CECD8A576B02D6CC_1539805788894_Screen+Shot+2018-10-17+at+2.41.53+PM.png)

<pre>
{
  "apikey": "...",
  "cos_hmac_keys": {
    <b>"access_key_id": "...",</b>
    <b>"secret_access_key": "..."</b>
  },
  "endpoints": "...",
  "iam_apikey_description": "...",
  "iam_apikey_name": "...",
  "iam_role_crn": "...",
  "iam_serviceid_crn": "...",
  "resource_instance_id": "..."
}
</pre>
