---
title: Creating a machine learning instance
date: 1970-01-05
---
Creating a Watson Machine Leaning instance gives us a reliable place to train, deploy and test machine learning models on specialized infrastructure. This allows us to set off several experiments simultaneously, taking advantage of multiple high-end GPUs. Watson Machine Learning supports a wide collection of machine learning frameworks such as TensorFlow, Keras, Caffe, PyTorch, Spark MLlib, scikit learn, xgboost and SPSS.

IBM Cloud offers a lite tier of Watson Machine Leaning, which includes 50 hours of compute for free per month. (this is what we will be using throughout the tutorial)

To create a Watson Machine Learning instance, navigate back to your [IBM Cloud Dashboard](https://ibm.biz/cloud-annotations-sign-up) and click the **Create resource** button.
![](https://d2mxuefqeaa7sj.cloudfront.net/s_E7D1C1E8D801F89315B72C10AD83AE795982C7EB84F7BA48CECD8A576B02D6CC_1539804040052_Screen+Shot+2018-10-17+at+2.35.53+PM.png)

Locate and choose the **Watson Machine Learning** option.
![](assets/wml_catalog.png)

Choose a pricing plan and click **Create**, then **Confirm** on the following popup.
> **Note:** Cloud Annotations relies on Deep Learning as a Service which is only supported in the `Dallas` and `London` regions.

![](assets/wml_create.png)

## Credentials
Once we have a Watson Machine Learning instance we need a way to access it from outside of IBM Cloud.
To do be able to do this we need to create a set credentials for our resource.

We can do this by navigating to the **Service credentials** tab and clicking the **New credential** button.
![](assets/wml_new_credential.png)

You can leave all the options blank, but make sure the credential has the role of **Writer**.
![](assets/wml_credentials_modal.png)

Once added, click the **View credentials ▾** dropdown and take note of your **instance_id**, **apikey** and **url**.
![](assets/wml_view_credentials.png)

<pre>
{
  <b>"apikey": "...",</b>
  "iam_apikey_description": "...",
  "iam_apikey_name": "...",
  "iam_role_crn": "...",
  "iam_serviceid_crn": "...",
  <b>"instance_id": "...",</b>
  <b>"url": "...",</b>
}
</pre>
