---
title: Training a model
date: 1970-01-06
---
After we have collected and labeled our first round of images, we are ready to start training our model! 

## Installation
To train our model we need to install the Cloud Annotation CLI:
```bash
npm install -g cloud-annotations
```
> **Note: You’ll need to have Node 10.13.0 or later installed.** You can use [nvm](https://github.com/creationix/nvm#installation) (macOS/Linux) or [nvm-windows](https://github.com/coreybutler/nvm-windows#node-version-manager-nvm-for-windows) to easily switch Node versions between different projects.

## Submit a training run to WML
The model we will be training is the SSD MobileNet architecture. SSD MobileNet models have a very small file size and can execute very quickly with compromising little accuracy, which makes it perfect for running in the browser.

When we say we are training the model, we are technically re-training the model. The model we are training has already been trained on millions of image and thousands of categories ranging from ducks to airplanes. This helps teach the model ideas like basic edges and shapes, letting us train it on the things we care about with little training data.

To start training, run the following command:
```bash
cacli train
```
> **Note:** You can monitor the training run at any point by running `cacli progress <model_id>`.

## Download the model
Once the model training is complete, we can download our model:
```bash
cacli download <model_id>
```
This will download a `model_*` directory from our TensorFlow graph, which is what we will use in our app.
