// This file was generated by counterfeiter
package apifakes

import (
	"sync"

	"github.com/cloudfoundry/cli/cf/api"
	"github.com/cloudfoundry/cli/cf/models"
)

type FakeDomainRepository struct {
	ListDomainsForOrgStub        func(orgGUID string, cb func(models.DomainFields) bool) error
	listDomainsForOrgMutex       sync.RWMutex
	listDomainsForOrgArgsForCall []struct {
		orgGUID string
		cb      func(models.DomainFields) bool
	}
	listDomainsForOrgReturns struct {
		result1 error
	}
	FindSharedByNameStub        func(name string) (domain models.DomainFields, apiErr error)
	findSharedByNameMutex       sync.RWMutex
	findSharedByNameArgsForCall []struct {
		name string
	}
	findSharedByNameReturns struct {
		result1 models.DomainFields
		result2 error
	}
	FindPrivateByNameStub        func(name string) (domain models.DomainFields, apiErr error)
	findPrivateByNameMutex       sync.RWMutex
	findPrivateByNameArgsForCall []struct {
		name string
	}
	findPrivateByNameReturns struct {
		result1 models.DomainFields
		result2 error
	}
	FindByNameInOrgStub        func(name string, owningOrgGUID string) (domain models.DomainFields, apiErr error)
	findByNameInOrgMutex       sync.RWMutex
	findByNameInOrgArgsForCall []struct {
		name          string
		owningOrgGUID string
	}
	findByNameInOrgReturns struct {
		result1 models.DomainFields
		result2 error
	}
	CreateStub        func(domainName string, owningOrgGUID string) (createdDomain models.DomainFields, apiErr error)
	createMutex       sync.RWMutex
	createArgsForCall []struct {
		domainName    string
		owningOrgGUID string
	}
	createReturns struct {
		result1 models.DomainFields
		result2 error
	}
	CreateSharedDomainStub        func(domainName string, routerGroupGUID string) (apiErr error)
	createSharedDomainMutex       sync.RWMutex
	createSharedDomainArgsForCall []struct {
		domainName      string
		routerGroupGUID string
	}
	createSharedDomainReturns struct {
		result1 error
	}
	DeleteStub        func(domainGUID string) (apiErr error)
	deleteMutex       sync.RWMutex
	deleteArgsForCall []struct {
		domainGUID string
	}
	deleteReturns struct {
		result1 error
	}
	DeleteSharedDomainStub        func(domainGUID string) (apiErr error)
	deleteSharedDomainMutex       sync.RWMutex
	deleteSharedDomainArgsForCall []struct {
		domainGUID string
	}
	deleteSharedDomainReturns struct {
		result1 error
	}
	FirstOrDefaultStub        func(orgGUID string, name *string) (domain models.DomainFields, error error)
	firstOrDefaultMutex       sync.RWMutex
	firstOrDefaultArgsForCall []struct {
		orgGUID string
		name    *string
	}
	firstOrDefaultReturns struct {
		result1 models.DomainFields
		result2 error
	}
}

func (fake *FakeDomainRepository) ListDomainsForOrg(orgGUID string, cb func(models.DomainFields) bool) error {
	fake.listDomainsForOrgMutex.Lock()
	fake.listDomainsForOrgArgsForCall = append(fake.listDomainsForOrgArgsForCall, struct {
		orgGUID string
		cb      func(models.DomainFields) bool
	}{orgGUID, cb})
	fake.listDomainsForOrgMutex.Unlock()
	if fake.ListDomainsForOrgStub != nil {
		return fake.ListDomainsForOrgStub(orgGUID, cb)
	} else {
		return fake.listDomainsForOrgReturns.result1
	}
}

func (fake *FakeDomainRepository) ListDomainsForOrgCallCount() int {
	fake.listDomainsForOrgMutex.RLock()
	defer fake.listDomainsForOrgMutex.RUnlock()
	return len(fake.listDomainsForOrgArgsForCall)
}

func (fake *FakeDomainRepository) ListDomainsForOrgArgsForCall(i int) (string, func(models.DomainFields) bool) {
	fake.listDomainsForOrgMutex.RLock()
	defer fake.listDomainsForOrgMutex.RUnlock()
	return fake.listDomainsForOrgArgsForCall[i].orgGUID, fake.listDomainsForOrgArgsForCall[i].cb
}

func (fake *FakeDomainRepository) ListDomainsForOrgReturns(result1 error) {
	fake.ListDomainsForOrgStub = nil
	fake.listDomainsForOrgReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeDomainRepository) FindSharedByName(name string) (domain models.DomainFields, apiErr error) {
	fake.findSharedByNameMutex.Lock()
	fake.findSharedByNameArgsForCall = append(fake.findSharedByNameArgsForCall, struct {
		name string
	}{name})
	fake.findSharedByNameMutex.Unlock()
	if fake.FindSharedByNameStub != nil {
		return fake.FindSharedByNameStub(name)
	} else {
		return fake.findSharedByNameReturns.result1, fake.findSharedByNameReturns.result2
	}
}

func (fake *FakeDomainRepository) FindSharedByNameCallCount() int {
	fake.findSharedByNameMutex.RLock()
	defer fake.findSharedByNameMutex.RUnlock()
	return len(fake.findSharedByNameArgsForCall)
}

func (fake *FakeDomainRepository) FindSharedByNameArgsForCall(i int) string {
	fake.findSharedByNameMutex.RLock()
	defer fake.findSharedByNameMutex.RUnlock()
	return fake.findSharedByNameArgsForCall[i].name
}

func (fake *FakeDomainRepository) FindSharedByNameReturns(result1 models.DomainFields, result2 error) {
	fake.FindSharedByNameStub = nil
	fake.findSharedByNameReturns = struct {
		result1 models.DomainFields
		result2 error
	}{result1, result2}
}

func (fake *FakeDomainRepository) FindPrivateByName(name string) (domain models.DomainFields, apiErr error) {
	fake.findPrivateByNameMutex.Lock()
	fake.findPrivateByNameArgsForCall = append(fake.findPrivateByNameArgsForCall, struct {
		name string
	}{name})
	fake.findPrivateByNameMutex.Unlock()
	if fake.FindPrivateByNameStub != nil {
		return fake.FindPrivateByNameStub(name)
	} else {
		return fake.findPrivateByNameReturns.result1, fake.findPrivateByNameReturns.result2
	}
}

func (fake *FakeDomainRepository) FindPrivateByNameCallCount() int {
	fake.findPrivateByNameMutex.RLock()
	defer fake.findPrivateByNameMutex.RUnlock()
	return len(fake.findPrivateByNameArgsForCall)
}

func (fake *FakeDomainRepository) FindPrivateByNameArgsForCall(i int) string {
	fake.findPrivateByNameMutex.RLock()
	defer fake.findPrivateByNameMutex.RUnlock()
	return fake.findPrivateByNameArgsForCall[i].name
}

func (fake *FakeDomainRepository) FindPrivateByNameReturns(result1 models.DomainFields, result2 error) {
	fake.FindPrivateByNameStub = nil
	fake.findPrivateByNameReturns = struct {
		result1 models.DomainFields
		result2 error
	}{result1, result2}
}

func (fake *FakeDomainRepository) FindByNameInOrg(name string, owningOrgGUID string) (domain models.DomainFields, apiErr error) {
	fake.findByNameInOrgMutex.Lock()
	fake.findByNameInOrgArgsForCall = append(fake.findByNameInOrgArgsForCall, struct {
		name          string
		owningOrgGUID string
	}{name, owningOrgGUID})
	fake.findByNameInOrgMutex.Unlock()
	if fake.FindByNameInOrgStub != nil {
		return fake.FindByNameInOrgStub(name, owningOrgGUID)
	} else {
		return fake.findByNameInOrgReturns.result1, fake.findByNameInOrgReturns.result2
	}
}

func (fake *FakeDomainRepository) FindByNameInOrgCallCount() int {
	fake.findByNameInOrgMutex.RLock()
	defer fake.findByNameInOrgMutex.RUnlock()
	return len(fake.findByNameInOrgArgsForCall)
}

func (fake *FakeDomainRepository) FindByNameInOrgArgsForCall(i int) (string, string) {
	fake.findByNameInOrgMutex.RLock()
	defer fake.findByNameInOrgMutex.RUnlock()
	return fake.findByNameInOrgArgsForCall[i].name, fake.findByNameInOrgArgsForCall[i].owningOrgGUID
}

func (fake *FakeDomainRepository) FindByNameInOrgReturns(result1 models.DomainFields, result2 error) {
	fake.FindByNameInOrgStub = nil
	fake.findByNameInOrgReturns = struct {
		result1 models.DomainFields
		result2 error
	}{result1, result2}
}

func (fake *FakeDomainRepository) Create(domainName string, owningOrgGUID string) (createdDomain models.DomainFields, apiErr error) {
	fake.createMutex.Lock()
	fake.createArgsForCall = append(fake.createArgsForCall, struct {
		domainName    string
		owningOrgGUID string
	}{domainName, owningOrgGUID})
	fake.createMutex.Unlock()
	if fake.CreateStub != nil {
		return fake.CreateStub(domainName, owningOrgGUID)
	} else {
		return fake.createReturns.result1, fake.createReturns.result2
	}
}

func (fake *FakeDomainRepository) CreateCallCount() int {
	fake.createMutex.RLock()
	defer fake.createMutex.RUnlock()
	return len(fake.createArgsForCall)
}

func (fake *FakeDomainRepository) CreateArgsForCall(i int) (string, string) {
	fake.createMutex.RLock()
	defer fake.createMutex.RUnlock()
	return fake.createArgsForCall[i].domainName, fake.createArgsForCall[i].owningOrgGUID
}

func (fake *FakeDomainRepository) CreateReturns(result1 models.DomainFields, result2 error) {
	fake.CreateStub = nil
	fake.createReturns = struct {
		result1 models.DomainFields
		result2 error
	}{result1, result2}
}

func (fake *FakeDomainRepository) CreateSharedDomain(domainName string, routerGroupGUID string) (apiErr error) {
	fake.createSharedDomainMutex.Lock()
	fake.createSharedDomainArgsForCall = append(fake.createSharedDomainArgsForCall, struct {
		domainName      string
		routerGroupGUID string
	}{domainName, routerGroupGUID})
	fake.createSharedDomainMutex.Unlock()
	if fake.CreateSharedDomainStub != nil {
		return fake.CreateSharedDomainStub(domainName, routerGroupGUID)
	} else {
		return fake.createSharedDomainReturns.result1
	}
}

func (fake *FakeDomainRepository) CreateSharedDomainCallCount() int {
	fake.createSharedDomainMutex.RLock()
	defer fake.createSharedDomainMutex.RUnlock()
	return len(fake.createSharedDomainArgsForCall)
}

func (fake *FakeDomainRepository) CreateSharedDomainArgsForCall(i int) (string, string) {
	fake.createSharedDomainMutex.RLock()
	defer fake.createSharedDomainMutex.RUnlock()
	return fake.createSharedDomainArgsForCall[i].domainName, fake.createSharedDomainArgsForCall[i].routerGroupGUID
}

func (fake *FakeDomainRepository) CreateSharedDomainReturns(result1 error) {
	fake.CreateSharedDomainStub = nil
	fake.createSharedDomainReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeDomainRepository) Delete(domainGUID string) (apiErr error) {
	fake.deleteMutex.Lock()
	fake.deleteArgsForCall = append(fake.deleteArgsForCall, struct {
		domainGUID string
	}{domainGUID})
	fake.deleteMutex.Unlock()
	if fake.DeleteStub != nil {
		return fake.DeleteStub(domainGUID)
	} else {
		return fake.deleteReturns.result1
	}
}

func (fake *FakeDomainRepository) DeleteCallCount() int {
	fake.deleteMutex.RLock()
	defer fake.deleteMutex.RUnlock()
	return len(fake.deleteArgsForCall)
}

func (fake *FakeDomainRepository) DeleteArgsForCall(i int) string {
	fake.deleteMutex.RLock()
	defer fake.deleteMutex.RUnlock()
	return fake.deleteArgsForCall[i].domainGUID
}

func (fake *FakeDomainRepository) DeleteReturns(result1 error) {
	fake.DeleteStub = nil
	fake.deleteReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeDomainRepository) DeleteSharedDomain(domainGUID string) (apiErr error) {
	fake.deleteSharedDomainMutex.Lock()
	fake.deleteSharedDomainArgsForCall = append(fake.deleteSharedDomainArgsForCall, struct {
		domainGUID string
	}{domainGUID})
	fake.deleteSharedDomainMutex.Unlock()
	if fake.DeleteSharedDomainStub != nil {
		return fake.DeleteSharedDomainStub(domainGUID)
	} else {
		return fake.deleteSharedDomainReturns.result1
	}
}

func (fake *FakeDomainRepository) DeleteSharedDomainCallCount() int {
	fake.deleteSharedDomainMutex.RLock()
	defer fake.deleteSharedDomainMutex.RUnlock()
	return len(fake.deleteSharedDomainArgsForCall)
}

func (fake *FakeDomainRepository) DeleteSharedDomainArgsForCall(i int) string {
	fake.deleteSharedDomainMutex.RLock()
	defer fake.deleteSharedDomainMutex.RUnlock()
	return fake.deleteSharedDomainArgsForCall[i].domainGUID
}

func (fake *FakeDomainRepository) DeleteSharedDomainReturns(result1 error) {
	fake.DeleteSharedDomainStub = nil
	fake.deleteSharedDomainReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeDomainRepository) FirstOrDefault(orgGUID string, name *string) (domain models.DomainFields, error error) {
	fake.firstOrDefaultMutex.Lock()
	fake.firstOrDefaultArgsForCall = append(fake.firstOrDefaultArgsForCall, struct {
		orgGUID string
		name    *string
	}{orgGUID, name})
	fake.firstOrDefaultMutex.Unlock()
	if fake.FirstOrDefaultStub != nil {
		return fake.FirstOrDefaultStub(orgGUID, name)
	} else {
		return fake.firstOrDefaultReturns.result1, fake.firstOrDefaultReturns.result2
	}
}

func (fake *FakeDomainRepository) FirstOrDefaultCallCount() int {
	fake.firstOrDefaultMutex.RLock()
	defer fake.firstOrDefaultMutex.RUnlock()
	return len(fake.firstOrDefaultArgsForCall)
}

func (fake *FakeDomainRepository) FirstOrDefaultArgsForCall(i int) (string, *string) {
	fake.firstOrDefaultMutex.RLock()
	defer fake.firstOrDefaultMutex.RUnlock()
	return fake.firstOrDefaultArgsForCall[i].orgGUID, fake.firstOrDefaultArgsForCall[i].name
}

func (fake *FakeDomainRepository) FirstOrDefaultReturns(result1 models.DomainFields, result2 error) {
	fake.FirstOrDefaultStub = nil
	fake.firstOrDefaultReturns = struct {
		result1 models.DomainFields
		result2 error
	}{result1, result2}
}

var _ api.DomainRepository = new(FakeDomainRepository)
