// This file was generated by counterfeiter
package apifakes

import (
	"sync"

	"github.com/cloudfoundry/cli/cf/api"
	"github.com/cloudfoundry/cli/cf/models"
)

type FakeUserRepository struct {
	FindByUsernameStub        func(username string) (user models.UserFields, apiErr error)
	findByUsernameMutex       sync.RWMutex
	findByUsernameArgsForCall []struct {
		username string
	}
	findByUsernameReturns struct {
		result1 models.UserFields
		result2 error
	}
	ListUsersInOrgForRoleStub        func(orgGUID string, role models.Role) ([]models.UserFields, error)
	listUsersInOrgForRoleMutex       sync.RWMutex
	listUsersInOrgForRoleArgsForCall []struct {
		orgGUID string
		role    models.Role
	}
	listUsersInOrgForRoleReturns struct {
		result1 []models.UserFields
		result2 error
	}
	ListUsersInOrgForRoleWithNoUAAStub        func(orgGUID string, role models.Role) ([]models.UserFields, error)
	listUsersInOrgForRoleWithNoUAAMutex       sync.RWMutex
	listUsersInOrgForRoleWithNoUAAArgsForCall []struct {
		orgGUID string
		role    models.Role
	}
	listUsersInOrgForRoleWithNoUAAReturns struct {
		result1 []models.UserFields
		result2 error
	}
	ListUsersInSpaceForRoleStub        func(spaceGUID string, role models.Role) ([]models.UserFields, error)
	listUsersInSpaceForRoleMutex       sync.RWMutex
	listUsersInSpaceForRoleArgsForCall []struct {
		spaceGUID string
		role      models.Role
	}
	listUsersInSpaceForRoleReturns struct {
		result1 []models.UserFields
		result2 error
	}
	ListUsersInSpaceForRoleWithNoUAAStub        func(spaceGUID string, role models.Role) ([]models.UserFields, error)
	listUsersInSpaceForRoleWithNoUAAMutex       sync.RWMutex
	listUsersInSpaceForRoleWithNoUAAArgsForCall []struct {
		spaceGUID string
		role      models.Role
	}
	listUsersInSpaceForRoleWithNoUAAReturns struct {
		result1 []models.UserFields
		result2 error
	}
	CreateStub        func(username, password string) (apiErr error)
	createMutex       sync.RWMutex
	createArgsForCall []struct {
		username string
		password string
	}
	createReturns struct {
		result1 error
	}
	DeleteStub        func(userGUID string) (apiErr error)
	deleteMutex       sync.RWMutex
	deleteArgsForCall []struct {
		userGUID string
	}
	deleteReturns struct {
		result1 error
	}
	SetOrgRoleByGUIDStub        func(userGUID, orgGUID string, role models.Role) (apiErr error)
	setOrgRoleByGUIDMutex       sync.RWMutex
	setOrgRoleByGUIDArgsForCall []struct {
		userGUID string
		orgGUID  string
		role     models.Role
	}
	setOrgRoleByGUIDReturns struct {
		result1 error
	}
	SetOrgRoleByUsernameStub        func(username, orgGUID string, role models.Role) (apiErr error)
	setOrgRoleByUsernameMutex       sync.RWMutex
	setOrgRoleByUsernameArgsForCall []struct {
		username string
		orgGUID  string
		role     models.Role
	}
	setOrgRoleByUsernameReturns struct {
		result1 error
	}
	UnsetOrgRoleByGUIDStub        func(userGUID, orgGUID string, role models.Role) (apiErr error)
	unsetOrgRoleByGUIDMutex       sync.RWMutex
	unsetOrgRoleByGUIDArgsForCall []struct {
		userGUID string
		orgGUID  string
		role     models.Role
	}
	unsetOrgRoleByGUIDReturns struct {
		result1 error
	}
	UnsetOrgRoleByUsernameStub        func(username, orgGUID string, role models.Role) (apiErr error)
	unsetOrgRoleByUsernameMutex       sync.RWMutex
	unsetOrgRoleByUsernameArgsForCall []struct {
		username string
		orgGUID  string
		role     models.Role
	}
	unsetOrgRoleByUsernameReturns struct {
		result1 error
	}
	SetSpaceRoleByGUIDStub        func(userGUID, spaceGUID, orgGUID string, role models.Role) (apiErr error)
	setSpaceRoleByGUIDMutex       sync.RWMutex
	setSpaceRoleByGUIDArgsForCall []struct {
		userGUID  string
		spaceGUID string
		orgGUID   string
		role      models.Role
	}
	setSpaceRoleByGUIDReturns struct {
		result1 error
	}
	SetSpaceRoleByUsernameStub        func(username, spaceGUID, orgGUID string, role models.Role) (apiErr error)
	setSpaceRoleByUsernameMutex       sync.RWMutex
	setSpaceRoleByUsernameArgsForCall []struct {
		username  string
		spaceGUID string
		orgGUID   string
		role      models.Role
	}
	setSpaceRoleByUsernameReturns struct {
		result1 error
	}
	UnsetSpaceRoleByGUIDStub        func(userGUID, spaceGUID string, role models.Role) (apiErr error)
	unsetSpaceRoleByGUIDMutex       sync.RWMutex
	unsetSpaceRoleByGUIDArgsForCall []struct {
		userGUID  string
		spaceGUID string
		role      models.Role
	}
	unsetSpaceRoleByGUIDReturns struct {
		result1 error
	}
	UnsetSpaceRoleByUsernameStub        func(userGUID, spaceGUID string, role models.Role) (apiErr error)
	unsetSpaceRoleByUsernameMutex       sync.RWMutex
	unsetSpaceRoleByUsernameArgsForCall []struct {
		userGUID  string
		spaceGUID string
		role      models.Role
	}
	unsetSpaceRoleByUsernameReturns struct {
		result1 error
	}
}

func (fake *FakeUserRepository) FindByUsername(username string) (user models.UserFields, apiErr error) {
	fake.findByUsernameMutex.Lock()
	fake.findByUsernameArgsForCall = append(fake.findByUsernameArgsForCall, struct {
		username string
	}{username})
	fake.findByUsernameMutex.Unlock()
	if fake.FindByUsernameStub != nil {
		return fake.FindByUsernameStub(username)
	} else {
		return fake.findByUsernameReturns.result1, fake.findByUsernameReturns.result2
	}
}

func (fake *FakeUserRepository) FindByUsernameCallCount() int {
	fake.findByUsernameMutex.RLock()
	defer fake.findByUsernameMutex.RUnlock()
	return len(fake.findByUsernameArgsForCall)
}

func (fake *FakeUserRepository) FindByUsernameArgsForCall(i int) string {
	fake.findByUsernameMutex.RLock()
	defer fake.findByUsernameMutex.RUnlock()
	return fake.findByUsernameArgsForCall[i].username
}

func (fake *FakeUserRepository) FindByUsernameReturns(result1 models.UserFields, result2 error) {
	fake.FindByUsernameStub = nil
	fake.findByUsernameReturns = struct {
		result1 models.UserFields
		result2 error
	}{result1, result2}
}

func (fake *FakeUserRepository) ListUsersInOrgForRole(orgGUID string, role models.Role) ([]models.UserFields, error) {
	fake.listUsersInOrgForRoleMutex.Lock()
	fake.listUsersInOrgForRoleArgsForCall = append(fake.listUsersInOrgForRoleArgsForCall, struct {
		orgGUID string
		role    models.Role
	}{orgGUID, role})
	fake.listUsersInOrgForRoleMutex.Unlock()
	if fake.ListUsersInOrgForRoleStub != nil {
		return fake.ListUsersInOrgForRoleStub(orgGUID, role)
	} else {
		return fake.listUsersInOrgForRoleReturns.result1, fake.listUsersInOrgForRoleReturns.result2
	}
}

func (fake *FakeUserRepository) ListUsersInOrgForRoleCallCount() int {
	fake.listUsersInOrgForRoleMutex.RLock()
	defer fake.listUsersInOrgForRoleMutex.RUnlock()
	return len(fake.listUsersInOrgForRoleArgsForCall)
}

func (fake *FakeUserRepository) ListUsersInOrgForRoleArgsForCall(i int) (string, models.Role) {
	fake.listUsersInOrgForRoleMutex.RLock()
	defer fake.listUsersInOrgForRoleMutex.RUnlock()
	return fake.listUsersInOrgForRoleArgsForCall[i].orgGUID, fake.listUsersInOrgForRoleArgsForCall[i].role
}

func (fake *FakeUserRepository) ListUsersInOrgForRoleReturns(result1 []models.UserFields, result2 error) {
	fake.ListUsersInOrgForRoleStub = nil
	fake.listUsersInOrgForRoleReturns = struct {
		result1 []models.UserFields
		result2 error
	}{result1, result2}
}

func (fake *FakeUserRepository) ListUsersInOrgForRoleWithNoUAA(orgGUID string, role models.Role) ([]models.UserFields, error) {
	fake.listUsersInOrgForRoleWithNoUAAMutex.Lock()
	fake.listUsersInOrgForRoleWithNoUAAArgsForCall = append(fake.listUsersInOrgForRoleWithNoUAAArgsForCall, struct {
		orgGUID string
		role    models.Role
	}{orgGUID, role})
	fake.listUsersInOrgForRoleWithNoUAAMutex.Unlock()
	if fake.ListUsersInOrgForRoleWithNoUAAStub != nil {
		return fake.ListUsersInOrgForRoleWithNoUAAStub(orgGUID, role)
	} else {
		return fake.listUsersInOrgForRoleWithNoUAAReturns.result1, fake.listUsersInOrgForRoleWithNoUAAReturns.result2
	}
}

func (fake *FakeUserRepository) ListUsersInOrgForRoleWithNoUAACallCount() int {
	fake.listUsersInOrgForRoleWithNoUAAMutex.RLock()
	defer fake.listUsersInOrgForRoleWithNoUAAMutex.RUnlock()
	return len(fake.listUsersInOrgForRoleWithNoUAAArgsForCall)
}

func (fake *FakeUserRepository) ListUsersInOrgForRoleWithNoUAAArgsForCall(i int) (string, models.Role) {
	fake.listUsersInOrgForRoleWithNoUAAMutex.RLock()
	defer fake.listUsersInOrgForRoleWithNoUAAMutex.RUnlock()
	return fake.listUsersInOrgForRoleWithNoUAAArgsForCall[i].orgGUID, fake.listUsersInOrgForRoleWithNoUAAArgsForCall[i].role
}

func (fake *FakeUserRepository) ListUsersInOrgForRoleWithNoUAAReturns(result1 []models.UserFields, result2 error) {
	fake.ListUsersInOrgForRoleWithNoUAAStub = nil
	fake.listUsersInOrgForRoleWithNoUAAReturns = struct {
		result1 []models.UserFields
		result2 error
	}{result1, result2}
}

func (fake *FakeUserRepository) ListUsersInSpaceForRole(spaceGUID string, role models.Role) ([]models.UserFields, error) {
	fake.listUsersInSpaceForRoleMutex.Lock()
	fake.listUsersInSpaceForRoleArgsForCall = append(fake.listUsersInSpaceForRoleArgsForCall, struct {
		spaceGUID string
		role      models.Role
	}{spaceGUID, role})
	fake.listUsersInSpaceForRoleMutex.Unlock()
	if fake.ListUsersInSpaceForRoleStub != nil {
		return fake.ListUsersInSpaceForRoleStub(spaceGUID, role)
	} else {
		return fake.listUsersInSpaceForRoleReturns.result1, fake.listUsersInSpaceForRoleReturns.result2
	}
}

func (fake *FakeUserRepository) ListUsersInSpaceForRoleCallCount() int {
	fake.listUsersInSpaceForRoleMutex.RLock()
	defer fake.listUsersInSpaceForRoleMutex.RUnlock()
	return len(fake.listUsersInSpaceForRoleArgsForCall)
}

func (fake *FakeUserRepository) ListUsersInSpaceForRoleArgsForCall(i int) (string, models.Role) {
	fake.listUsersInSpaceForRoleMutex.RLock()
	defer fake.listUsersInSpaceForRoleMutex.RUnlock()
	return fake.listUsersInSpaceForRoleArgsForCall[i].spaceGUID, fake.listUsersInSpaceForRoleArgsForCall[i].role
}

func (fake *FakeUserRepository) ListUsersInSpaceForRoleReturns(result1 []models.UserFields, result2 error) {
	fake.ListUsersInSpaceForRoleStub = nil
	fake.listUsersInSpaceForRoleReturns = struct {
		result1 []models.UserFields
		result2 error
	}{result1, result2}
}

func (fake *FakeUserRepository) ListUsersInSpaceForRoleWithNoUAA(spaceGUID string, role models.Role) ([]models.UserFields, error) {
	fake.listUsersInSpaceForRoleWithNoUAAMutex.Lock()
	fake.listUsersInSpaceForRoleWithNoUAAArgsForCall = append(fake.listUsersInSpaceForRoleWithNoUAAArgsForCall, struct {
		spaceGUID string
		role      models.Role
	}{spaceGUID, role})
	fake.listUsersInSpaceForRoleWithNoUAAMutex.Unlock()
	if fake.ListUsersInSpaceForRoleWithNoUAAStub != nil {
		return fake.ListUsersInSpaceForRoleWithNoUAAStub(spaceGUID, role)
	} else {
		return fake.listUsersInSpaceForRoleWithNoUAAReturns.result1, fake.listUsersInSpaceForRoleWithNoUAAReturns.result2
	}
}

func (fake *FakeUserRepository) ListUsersInSpaceForRoleWithNoUAACallCount() int {
	fake.listUsersInSpaceForRoleWithNoUAAMutex.RLock()
	defer fake.listUsersInSpaceForRoleWithNoUAAMutex.RUnlock()
	return len(fake.listUsersInSpaceForRoleWithNoUAAArgsForCall)
}

func (fake *FakeUserRepository) ListUsersInSpaceForRoleWithNoUAAArgsForCall(i int) (string, models.Role) {
	fake.listUsersInSpaceForRoleWithNoUAAMutex.RLock()
	defer fake.listUsersInSpaceForRoleWithNoUAAMutex.RUnlock()
	return fake.listUsersInSpaceForRoleWithNoUAAArgsForCall[i].spaceGUID, fake.listUsersInSpaceForRoleWithNoUAAArgsForCall[i].role
}

func (fake *FakeUserRepository) ListUsersInSpaceForRoleWithNoUAAReturns(result1 []models.UserFields, result2 error) {
	fake.ListUsersInSpaceForRoleWithNoUAAStub = nil
	fake.listUsersInSpaceForRoleWithNoUAAReturns = struct {
		result1 []models.UserFields
		result2 error
	}{result1, result2}
}

func (fake *FakeUserRepository) Create(username string, password string) (apiErr error) {
	fake.createMutex.Lock()
	fake.createArgsForCall = append(fake.createArgsForCall, struct {
		username string
		password string
	}{username, password})
	fake.createMutex.Unlock()
	if fake.CreateStub != nil {
		return fake.CreateStub(username, password)
	} else {
		return fake.createReturns.result1
	}
}

func (fake *FakeUserRepository) CreateCallCount() int {
	fake.createMutex.RLock()
	defer fake.createMutex.RUnlock()
	return len(fake.createArgsForCall)
}

func (fake *FakeUserRepository) CreateArgsForCall(i int) (string, string) {
	fake.createMutex.RLock()
	defer fake.createMutex.RUnlock()
	return fake.createArgsForCall[i].username, fake.createArgsForCall[i].password
}

func (fake *FakeUserRepository) CreateReturns(result1 error) {
	fake.CreateStub = nil
	fake.createReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeUserRepository) Delete(userGUID string) (apiErr error) {
	fake.deleteMutex.Lock()
	fake.deleteArgsForCall = append(fake.deleteArgsForCall, struct {
		userGUID string
	}{userGUID})
	fake.deleteMutex.Unlock()
	if fake.DeleteStub != nil {
		return fake.DeleteStub(userGUID)
	} else {
		return fake.deleteReturns.result1
	}
}

func (fake *FakeUserRepository) DeleteCallCount() int {
	fake.deleteMutex.RLock()
	defer fake.deleteMutex.RUnlock()
	return len(fake.deleteArgsForCall)
}

func (fake *FakeUserRepository) DeleteArgsForCall(i int) string {
	fake.deleteMutex.RLock()
	defer fake.deleteMutex.RUnlock()
	return fake.deleteArgsForCall[i].userGUID
}

func (fake *FakeUserRepository) DeleteReturns(result1 error) {
	fake.DeleteStub = nil
	fake.deleteReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeUserRepository) SetOrgRoleByGUID(userGUID string, orgGUID string, role models.Role) (apiErr error) {
	fake.setOrgRoleByGUIDMutex.Lock()
	fake.setOrgRoleByGUIDArgsForCall = append(fake.setOrgRoleByGUIDArgsForCall, struct {
		userGUID string
		orgGUID  string
		role     models.Role
	}{userGUID, orgGUID, role})
	fake.setOrgRoleByGUIDMutex.Unlock()
	if fake.SetOrgRoleByGUIDStub != nil {
		return fake.SetOrgRoleByGUIDStub(userGUID, orgGUID, role)
	} else {
		return fake.setOrgRoleByGUIDReturns.result1
	}
}

func (fake *FakeUserRepository) SetOrgRoleByGUIDCallCount() int {
	fake.setOrgRoleByGUIDMutex.RLock()
	defer fake.setOrgRoleByGUIDMutex.RUnlock()
	return len(fake.setOrgRoleByGUIDArgsForCall)
}

func (fake *FakeUserRepository) SetOrgRoleByGUIDArgsForCall(i int) (string, string, models.Role) {
	fake.setOrgRoleByGUIDMutex.RLock()
	defer fake.setOrgRoleByGUIDMutex.RUnlock()
	return fake.setOrgRoleByGUIDArgsForCall[i].userGUID, fake.setOrgRoleByGUIDArgsForCall[i].orgGUID, fake.setOrgRoleByGUIDArgsForCall[i].role
}

func (fake *FakeUserRepository) SetOrgRoleByGUIDReturns(result1 error) {
	fake.SetOrgRoleByGUIDStub = nil
	fake.setOrgRoleByGUIDReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeUserRepository) SetOrgRoleByUsername(username string, orgGUID string, role models.Role) (apiErr error) {
	fake.setOrgRoleByUsernameMutex.Lock()
	fake.setOrgRoleByUsernameArgsForCall = append(fake.setOrgRoleByUsernameArgsForCall, struct {
		username string
		orgGUID  string
		role     models.Role
	}{username, orgGUID, role})
	fake.setOrgRoleByUsernameMutex.Unlock()
	if fake.SetOrgRoleByUsernameStub != nil {
		return fake.SetOrgRoleByUsernameStub(username, orgGUID, role)
	} else {
		return fake.setOrgRoleByUsernameReturns.result1
	}
}

func (fake *FakeUserRepository) SetOrgRoleByUsernameCallCount() int {
	fake.setOrgRoleByUsernameMutex.RLock()
	defer fake.setOrgRoleByUsernameMutex.RUnlock()
	return len(fake.setOrgRoleByUsernameArgsForCall)
}

func (fake *FakeUserRepository) SetOrgRoleByUsernameArgsForCall(i int) (string, string, models.Role) {
	fake.setOrgRoleByUsernameMutex.RLock()
	defer fake.setOrgRoleByUsernameMutex.RUnlock()
	return fake.setOrgRoleByUsernameArgsForCall[i].username, fake.setOrgRoleByUsernameArgsForCall[i].orgGUID, fake.setOrgRoleByUsernameArgsForCall[i].role
}

func (fake *FakeUserRepository) SetOrgRoleByUsernameReturns(result1 error) {
	fake.SetOrgRoleByUsernameStub = nil
	fake.setOrgRoleByUsernameReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeUserRepository) UnsetOrgRoleByGUID(userGUID string, orgGUID string, role models.Role) (apiErr error) {
	fake.unsetOrgRoleByGUIDMutex.Lock()
	fake.unsetOrgRoleByGUIDArgsForCall = append(fake.unsetOrgRoleByGUIDArgsForCall, struct {
		userGUID string
		orgGUID  string
		role     models.Role
	}{userGUID, orgGUID, role})
	fake.unsetOrgRoleByGUIDMutex.Unlock()
	if fake.UnsetOrgRoleByGUIDStub != nil {
		return fake.UnsetOrgRoleByGUIDStub(userGUID, orgGUID, role)
	} else {
		return fake.unsetOrgRoleByGUIDReturns.result1
	}
}

func (fake *FakeUserRepository) UnsetOrgRoleByGUIDCallCount() int {
	fake.unsetOrgRoleByGUIDMutex.RLock()
	defer fake.unsetOrgRoleByGUIDMutex.RUnlock()
	return len(fake.unsetOrgRoleByGUIDArgsForCall)
}

func (fake *FakeUserRepository) UnsetOrgRoleByGUIDArgsForCall(i int) (string, string, models.Role) {
	fake.unsetOrgRoleByGUIDMutex.RLock()
	defer fake.unsetOrgRoleByGUIDMutex.RUnlock()
	return fake.unsetOrgRoleByGUIDArgsForCall[i].userGUID, fake.unsetOrgRoleByGUIDArgsForCall[i].orgGUID, fake.unsetOrgRoleByGUIDArgsForCall[i].role
}

func (fake *FakeUserRepository) UnsetOrgRoleByGUIDReturns(result1 error) {
	fake.UnsetOrgRoleByGUIDStub = nil
	fake.unsetOrgRoleByGUIDReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeUserRepository) UnsetOrgRoleByUsername(username string, orgGUID string, role models.Role) (apiErr error) {
	fake.unsetOrgRoleByUsernameMutex.Lock()
	fake.unsetOrgRoleByUsernameArgsForCall = append(fake.unsetOrgRoleByUsernameArgsForCall, struct {
		username string
		orgGUID  string
		role     models.Role
	}{username, orgGUID, role})
	fake.unsetOrgRoleByUsernameMutex.Unlock()
	if fake.UnsetOrgRoleByUsernameStub != nil {
		return fake.UnsetOrgRoleByUsernameStub(username, orgGUID, role)
	} else {
		return fake.unsetOrgRoleByUsernameReturns.result1
	}
}

func (fake *FakeUserRepository) UnsetOrgRoleByUsernameCallCount() int {
	fake.unsetOrgRoleByUsernameMutex.RLock()
	defer fake.unsetOrgRoleByUsernameMutex.RUnlock()
	return len(fake.unsetOrgRoleByUsernameArgsForCall)
}

func (fake *FakeUserRepository) UnsetOrgRoleByUsernameArgsForCall(i int) (string, string, models.Role) {
	fake.unsetOrgRoleByUsernameMutex.RLock()
	defer fake.unsetOrgRoleByUsernameMutex.RUnlock()
	return fake.unsetOrgRoleByUsernameArgsForCall[i].username, fake.unsetOrgRoleByUsernameArgsForCall[i].orgGUID, fake.unsetOrgRoleByUsernameArgsForCall[i].role
}

func (fake *FakeUserRepository) UnsetOrgRoleByUsernameReturns(result1 error) {
	fake.UnsetOrgRoleByUsernameStub = nil
	fake.unsetOrgRoleByUsernameReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeUserRepository) SetSpaceRoleByGUID(userGUID string, spaceGUID string, orgGUID string, role models.Role) (apiErr error) {
	fake.setSpaceRoleByGUIDMutex.Lock()
	fake.setSpaceRoleByGUIDArgsForCall = append(fake.setSpaceRoleByGUIDArgsForCall, struct {
		userGUID  string
		spaceGUID string
		orgGUID   string
		role      models.Role
	}{userGUID, spaceGUID, orgGUID, role})
	fake.setSpaceRoleByGUIDMutex.Unlock()
	if fake.SetSpaceRoleByGUIDStub != nil {
		return fake.SetSpaceRoleByGUIDStub(userGUID, spaceGUID, orgGUID, role)
	} else {
		return fake.setSpaceRoleByGUIDReturns.result1
	}
}

func (fake *FakeUserRepository) SetSpaceRoleByGUIDCallCount() int {
	fake.setSpaceRoleByGUIDMutex.RLock()
	defer fake.setSpaceRoleByGUIDMutex.RUnlock()
	return len(fake.setSpaceRoleByGUIDArgsForCall)
}

func (fake *FakeUserRepository) SetSpaceRoleByGUIDArgsForCall(i int) (string, string, string, models.Role) {
	fake.setSpaceRoleByGUIDMutex.RLock()
	defer fake.setSpaceRoleByGUIDMutex.RUnlock()
	return fake.setSpaceRoleByGUIDArgsForCall[i].userGUID, fake.setSpaceRoleByGUIDArgsForCall[i].spaceGUID, fake.setSpaceRoleByGUIDArgsForCall[i].orgGUID, fake.setSpaceRoleByGUIDArgsForCall[i].role
}

func (fake *FakeUserRepository) SetSpaceRoleByGUIDReturns(result1 error) {
	fake.SetSpaceRoleByGUIDStub = nil
	fake.setSpaceRoleByGUIDReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeUserRepository) SetSpaceRoleByUsername(username string, spaceGUID string, orgGUID string, role models.Role) (apiErr error) {
	fake.setSpaceRoleByUsernameMutex.Lock()
	fake.setSpaceRoleByUsernameArgsForCall = append(fake.setSpaceRoleByUsernameArgsForCall, struct {
		username  string
		spaceGUID string
		orgGUID   string
		role      models.Role
	}{username, spaceGUID, orgGUID, role})
	fake.setSpaceRoleByUsernameMutex.Unlock()
	if fake.SetSpaceRoleByUsernameStub != nil {
		return fake.SetSpaceRoleByUsernameStub(username, spaceGUID, orgGUID, role)
	} else {
		return fake.setSpaceRoleByUsernameReturns.result1
	}
}

func (fake *FakeUserRepository) SetSpaceRoleByUsernameCallCount() int {
	fake.setSpaceRoleByUsernameMutex.RLock()
	defer fake.setSpaceRoleByUsernameMutex.RUnlock()
	return len(fake.setSpaceRoleByUsernameArgsForCall)
}

func (fake *FakeUserRepository) SetSpaceRoleByUsernameArgsForCall(i int) (string, string, string, models.Role) {
	fake.setSpaceRoleByUsernameMutex.RLock()
	defer fake.setSpaceRoleByUsernameMutex.RUnlock()
	return fake.setSpaceRoleByUsernameArgsForCall[i].username, fake.setSpaceRoleByUsernameArgsForCall[i].spaceGUID, fake.setSpaceRoleByUsernameArgsForCall[i].orgGUID, fake.setSpaceRoleByUsernameArgsForCall[i].role
}

func (fake *FakeUserRepository) SetSpaceRoleByUsernameReturns(result1 error) {
	fake.SetSpaceRoleByUsernameStub = nil
	fake.setSpaceRoleByUsernameReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeUserRepository) UnsetSpaceRoleByGUID(userGUID string, spaceGUID string, role models.Role) (apiErr error) {
	fake.unsetSpaceRoleByGUIDMutex.Lock()
	fake.unsetSpaceRoleByGUIDArgsForCall = append(fake.unsetSpaceRoleByGUIDArgsForCall, struct {
		userGUID  string
		spaceGUID string
		role      models.Role
	}{userGUID, spaceGUID, role})
	fake.unsetSpaceRoleByGUIDMutex.Unlock()
	if fake.UnsetSpaceRoleByGUIDStub != nil {
		return fake.UnsetSpaceRoleByGUIDStub(userGUID, spaceGUID, role)
	} else {
		return fake.unsetSpaceRoleByGUIDReturns.result1
	}
}

func (fake *FakeUserRepository) UnsetSpaceRoleByGUIDCallCount() int {
	fake.unsetSpaceRoleByGUIDMutex.RLock()
	defer fake.unsetSpaceRoleByGUIDMutex.RUnlock()
	return len(fake.unsetSpaceRoleByGUIDArgsForCall)
}

func (fake *FakeUserRepository) UnsetSpaceRoleByGUIDArgsForCall(i int) (string, string, models.Role) {
	fake.unsetSpaceRoleByGUIDMutex.RLock()
	defer fake.unsetSpaceRoleByGUIDMutex.RUnlock()
	return fake.unsetSpaceRoleByGUIDArgsForCall[i].userGUID, fake.unsetSpaceRoleByGUIDArgsForCall[i].spaceGUID, fake.unsetSpaceRoleByGUIDArgsForCall[i].role
}

func (fake *FakeUserRepository) UnsetSpaceRoleByGUIDReturns(result1 error) {
	fake.UnsetSpaceRoleByGUIDStub = nil
	fake.unsetSpaceRoleByGUIDReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeUserRepository) UnsetSpaceRoleByUsername(userGUID string, spaceGUID string, role models.Role) (apiErr error) {
	fake.unsetSpaceRoleByUsernameMutex.Lock()
	fake.unsetSpaceRoleByUsernameArgsForCall = append(fake.unsetSpaceRoleByUsernameArgsForCall, struct {
		userGUID  string
		spaceGUID string
		role      models.Role
	}{userGUID, spaceGUID, role})
	fake.unsetSpaceRoleByUsernameMutex.Unlock()
	if fake.UnsetSpaceRoleByUsernameStub != nil {
		return fake.UnsetSpaceRoleByUsernameStub(userGUID, spaceGUID, role)
	} else {
		return fake.unsetSpaceRoleByUsernameReturns.result1
	}
}

func (fake *FakeUserRepository) UnsetSpaceRoleByUsernameCallCount() int {
	fake.unsetSpaceRoleByUsernameMutex.RLock()
	defer fake.unsetSpaceRoleByUsernameMutex.RUnlock()
	return len(fake.unsetSpaceRoleByUsernameArgsForCall)
}

func (fake *FakeUserRepository) UnsetSpaceRoleByUsernameArgsForCall(i int) (string, string, models.Role) {
	fake.unsetSpaceRoleByUsernameMutex.RLock()
	defer fake.unsetSpaceRoleByUsernameMutex.RUnlock()
	return fake.unsetSpaceRoleByUsernameArgsForCall[i].userGUID, fake.unsetSpaceRoleByUsernameArgsForCall[i].spaceGUID, fake.unsetSpaceRoleByUsernameArgsForCall[i].role
}

func (fake *FakeUserRepository) UnsetSpaceRoleByUsernameReturns(result1 error) {
	fake.UnsetSpaceRoleByUsernameStub = nil
	fake.unsetSpaceRoleByUsernameReturns = struct {
		result1 error
	}{result1}
}

var _ api.UserRepository = new(FakeUserRepository)
