// This file was generated by counterfeiter
package securitygroupsfakes

import (
	"sync"

	"github.com/cloudfoundry/cli/cf/api/securitygroups"
	"github.com/cloudfoundry/cli/cf/models"
)

type FakeSecurityGroupRepo struct {
	CreateStub        func(name string, rules []map[string]interface{}) error
	createMutex       sync.RWMutex
	createArgsForCall []struct {
		name  string
		rules []map[string]interface{}
	}
	createReturns struct {
		result1 error
	}
	UpdateStub        func(guid string, rules []map[string]interface{}) error
	updateMutex       sync.RWMutex
	updateArgsForCall []struct {
		guid  string
		rules []map[string]interface{}
	}
	updateReturns struct {
		result1 error
	}
	ReadStub        func(string) (models.SecurityGroup, error)
	readMutex       sync.RWMutex
	readArgsForCall []struct {
		arg1 string
	}
	readReturns struct {
		result1 models.SecurityGroup
		result2 error
	}
	DeleteStub        func(string) error
	deleteMutex       sync.RWMutex
	deleteArgsForCall []struct {
		arg1 string
	}
	deleteReturns struct {
		result1 error
	}
	FindAllStub        func() ([]models.SecurityGroup, error)
	findAllMutex       sync.RWMutex
	findAllArgsForCall []struct{}
	findAllReturns     struct {
		result1 []models.SecurityGroup
		result2 error
	}
}

func (fake *FakeSecurityGroupRepo) Create(name string, rules []map[string]interface{}) error {
	var rulesCopy []map[string]interface{}
	if rules != nil {
		rulesCopy = make([]map[string]interface{}, len(rules))
		copy(rulesCopy, rules)
	}
	fake.createMutex.Lock()
	fake.createArgsForCall = append(fake.createArgsForCall, struct {
		name  string
		rules []map[string]interface{}
	}{name, rulesCopy})
	fake.createMutex.Unlock()
	if fake.CreateStub != nil {
		return fake.CreateStub(name, rules)
	} else {
		return fake.createReturns.result1
	}
}

func (fake *FakeSecurityGroupRepo) CreateCallCount() int {
	fake.createMutex.RLock()
	defer fake.createMutex.RUnlock()
	return len(fake.createArgsForCall)
}

func (fake *FakeSecurityGroupRepo) CreateArgsForCall(i int) (string, []map[string]interface{}) {
	fake.createMutex.RLock()
	defer fake.createMutex.RUnlock()
	return fake.createArgsForCall[i].name, fake.createArgsForCall[i].rules
}

func (fake *FakeSecurityGroupRepo) CreateReturns(result1 error) {
	fake.CreateStub = nil
	fake.createReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeSecurityGroupRepo) Update(guid string, rules []map[string]interface{}) error {
	var rulesCopy []map[string]interface{}
	if rules != nil {
		rulesCopy = make([]map[string]interface{}, len(rules))
		copy(rulesCopy, rules)
	}
	fake.updateMutex.Lock()
	fake.updateArgsForCall = append(fake.updateArgsForCall, struct {
		guid  string
		rules []map[string]interface{}
	}{guid, rulesCopy})
	fake.updateMutex.Unlock()
	if fake.UpdateStub != nil {
		return fake.UpdateStub(guid, rules)
	} else {
		return fake.updateReturns.result1
	}
}

func (fake *FakeSecurityGroupRepo) UpdateCallCount() int {
	fake.updateMutex.RLock()
	defer fake.updateMutex.RUnlock()
	return len(fake.updateArgsForCall)
}

func (fake *FakeSecurityGroupRepo) UpdateArgsForCall(i int) (string, []map[string]interface{}) {
	fake.updateMutex.RLock()
	defer fake.updateMutex.RUnlock()
	return fake.updateArgsForCall[i].guid, fake.updateArgsForCall[i].rules
}

func (fake *FakeSecurityGroupRepo) UpdateReturns(result1 error) {
	fake.UpdateStub = nil
	fake.updateReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeSecurityGroupRepo) Read(arg1 string) (models.SecurityGroup, error) {
	fake.readMutex.Lock()
	fake.readArgsForCall = append(fake.readArgsForCall, struct {
		arg1 string
	}{arg1})
	fake.readMutex.Unlock()
	if fake.ReadStub != nil {
		return fake.ReadStub(arg1)
	} else {
		return fake.readReturns.result1, fake.readReturns.result2
	}
}

func (fake *FakeSecurityGroupRepo) ReadCallCount() int {
	fake.readMutex.RLock()
	defer fake.readMutex.RUnlock()
	return len(fake.readArgsForCall)
}

func (fake *FakeSecurityGroupRepo) ReadArgsForCall(i int) string {
	fake.readMutex.RLock()
	defer fake.readMutex.RUnlock()
	return fake.readArgsForCall[i].arg1
}

func (fake *FakeSecurityGroupRepo) ReadReturns(result1 models.SecurityGroup, result2 error) {
	fake.ReadStub = nil
	fake.readReturns = struct {
		result1 models.SecurityGroup
		result2 error
	}{result1, result2}
}

func (fake *FakeSecurityGroupRepo) Delete(arg1 string) error {
	fake.deleteMutex.Lock()
	fake.deleteArgsForCall = append(fake.deleteArgsForCall, struct {
		arg1 string
	}{arg1})
	fake.deleteMutex.Unlock()
	if fake.DeleteStub != nil {
		return fake.DeleteStub(arg1)
	} else {
		return fake.deleteReturns.result1
	}
}

func (fake *FakeSecurityGroupRepo) DeleteCallCount() int {
	fake.deleteMutex.RLock()
	defer fake.deleteMutex.RUnlock()
	return len(fake.deleteArgsForCall)
}

func (fake *FakeSecurityGroupRepo) DeleteArgsForCall(i int) string {
	fake.deleteMutex.RLock()
	defer fake.deleteMutex.RUnlock()
	return fake.deleteArgsForCall[i].arg1
}

func (fake *FakeSecurityGroupRepo) DeleteReturns(result1 error) {
	fake.DeleteStub = nil
	fake.deleteReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeSecurityGroupRepo) FindAll() ([]models.SecurityGroup, error) {
	fake.findAllMutex.Lock()
	fake.findAllArgsForCall = append(fake.findAllArgsForCall, struct{}{})
	fake.findAllMutex.Unlock()
	if fake.FindAllStub != nil {
		return fake.FindAllStub()
	} else {
		return fake.findAllReturns.result1, fake.findAllReturns.result2
	}
}

func (fake *FakeSecurityGroupRepo) FindAllCallCount() int {
	fake.findAllMutex.RLock()
	defer fake.findAllMutex.RUnlock()
	return len(fake.findAllArgsForCall)
}

func (fake *FakeSecurityGroupRepo) FindAllReturns(result1 []models.SecurityGroup, result2 error) {
	fake.FindAllStub = nil
	fake.findAllReturns = struct {
		result1 []models.SecurityGroup
		result2 error
	}{result1, result2}
}

var _ securitygroups.SecurityGroupRepo = new(FakeSecurityGroupRepo)
