// This file was generated by counterfeiter
package stacksfakes

import (
	"sync"

	"github.com/cloudfoundry/cli/cf/api/stacks"
	"github.com/cloudfoundry/cli/cf/models"
)

type FakeStackRepository struct {
	FindByNameStub        func(name string) (stack models.Stack, apiErr error)
	findByNameMutex       sync.RWMutex
	findByNameArgsForCall []struct {
		name string
	}
	findByNameReturns struct {
		result1 models.Stack
		result2 error
	}
	FindByGUIDStub        func(guid string) (models.Stack, error)
	findByGUIDMutex       sync.RWMutex
	findByGUIDArgsForCall []struct {
		guid string
	}
	findByGUIDReturns struct {
		result1 models.Stack
		result2 error
	}
	FindAllStub        func() (stacks []models.Stack, apiErr error)
	findAllMutex       sync.RWMutex
	findAllArgsForCall []struct{}
	findAllReturns     struct {
		result1 []models.Stack
		result2 error
	}
}

func (fake *FakeStackRepository) FindByName(name string) (stack models.Stack, apiErr error) {
	fake.findByNameMutex.Lock()
	fake.findByNameArgsForCall = append(fake.findByNameArgsForCall, struct {
		name string
	}{name})
	fake.findByNameMutex.Unlock()
	if fake.FindByNameStub != nil {
		return fake.FindByNameStub(name)
	} else {
		return fake.findByNameReturns.result1, fake.findByNameReturns.result2
	}
}

func (fake *FakeStackRepository) FindByNameCallCount() int {
	fake.findByNameMutex.RLock()
	defer fake.findByNameMutex.RUnlock()
	return len(fake.findByNameArgsForCall)
}

func (fake *FakeStackRepository) FindByNameArgsForCall(i int) string {
	fake.findByNameMutex.RLock()
	defer fake.findByNameMutex.RUnlock()
	return fake.findByNameArgsForCall[i].name
}

func (fake *FakeStackRepository) FindByNameReturns(result1 models.Stack, result2 error) {
	fake.FindByNameStub = nil
	fake.findByNameReturns = struct {
		result1 models.Stack
		result2 error
	}{result1, result2}
}

func (fake *FakeStackRepository) FindByGUID(guid string) (models.Stack, error) {
	fake.findByGUIDMutex.Lock()
	fake.findByGUIDArgsForCall = append(fake.findByGUIDArgsForCall, struct {
		guid string
	}{guid})
	fake.findByGUIDMutex.Unlock()
	if fake.FindByGUIDStub != nil {
		return fake.FindByGUIDStub(guid)
	} else {
		return fake.findByGUIDReturns.result1, fake.findByGUIDReturns.result2
	}
}

func (fake *FakeStackRepository) FindByGUIDCallCount() int {
	fake.findByGUIDMutex.RLock()
	defer fake.findByGUIDMutex.RUnlock()
	return len(fake.findByGUIDArgsForCall)
}

func (fake *FakeStackRepository) FindByGUIDArgsForCall(i int) string {
	fake.findByGUIDMutex.RLock()
	defer fake.findByGUIDMutex.RUnlock()
	return fake.findByGUIDArgsForCall[i].guid
}

func (fake *FakeStackRepository) FindByGUIDReturns(result1 models.Stack, result2 error) {
	fake.FindByGUIDStub = nil
	fake.findByGUIDReturns = struct {
		result1 models.Stack
		result2 error
	}{result1, result2}
}

func (fake *FakeStackRepository) FindAll() (stacks []models.Stack, apiErr error) {
	fake.findAllMutex.Lock()
	fake.findAllArgsForCall = append(fake.findAllArgsForCall, struct{}{})
	fake.findAllMutex.Unlock()
	if fake.FindAllStub != nil {
		return fake.FindAllStub()
	} else {
		return fake.findAllReturns.result1, fake.findAllReturns.result2
	}
}

func (fake *FakeStackRepository) FindAllCallCount() int {
	fake.findAllMutex.RLock()
	defer fake.findAllMutex.RUnlock()
	return len(fake.findAllArgsForCall)
}

func (fake *FakeStackRepository) FindAllReturns(result1 []models.Stack, result2 error) {
	fake.FindAllStub = nil
	fake.findAllReturns = struct {
		result1 []models.Stack
		result2 error
	}{result1, result2}
}

var _ stacks.StackRepository = new(FakeStackRepository)
