// This file was generated by counterfeiter
package appfilesfakes

import (
	"os"
	"sync"

	"github.com/cloudfoundry/cli/cf/appfiles"
)

type FakeZipper struct {
	ZipStub        func(dirToZip string, targetFile *os.File) (err error)
	zipMutex       sync.RWMutex
	zipArgsForCall []struct {
		dirToZip   string
		targetFile *os.File
	}
	zipReturns struct {
		result1 error
	}
	IsZipFileStub        func(path string) bool
	isZipFileMutex       sync.RWMutex
	isZipFileArgsForCall []struct {
		path string
	}
	isZipFileReturns struct {
		result1 bool
	}
	UnzipStub        func(appDir string, destDir string) (err error)
	unzipMutex       sync.RWMutex
	unzipArgsForCall []struct {
		appDir  string
		destDir string
	}
	unzipReturns struct {
		result1 error
	}
	GetZipSizeStub        func(zipFile *os.File) (int64, error)
	getZipSizeMutex       sync.RWMutex
	getZipSizeArgsForCall []struct {
		zipFile *os.File
	}
	getZipSizeReturns struct {
		result1 int64
		result2 error
	}
}

func (fake *FakeZipper) Zip(dirToZip string, targetFile *os.File) (err error) {
	fake.zipMutex.Lock()
	fake.zipArgsForCall = append(fake.zipArgsForCall, struct {
		dirToZip   string
		targetFile *os.File
	}{dirToZip, targetFile})
	fake.zipMutex.Unlock()
	if fake.ZipStub != nil {
		return fake.ZipStub(dirToZip, targetFile)
	} else {
		return fake.zipReturns.result1
	}
}

func (fake *FakeZipper) ZipCallCount() int {
	fake.zipMutex.RLock()
	defer fake.zipMutex.RUnlock()
	return len(fake.zipArgsForCall)
}

func (fake *FakeZipper) ZipArgsForCall(i int) (string, *os.File) {
	fake.zipMutex.RLock()
	defer fake.zipMutex.RUnlock()
	return fake.zipArgsForCall[i].dirToZip, fake.zipArgsForCall[i].targetFile
}

func (fake *FakeZipper) ZipReturns(result1 error) {
	fake.ZipStub = nil
	fake.zipReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeZipper) IsZipFile(path string) bool {
	fake.isZipFileMutex.Lock()
	fake.isZipFileArgsForCall = append(fake.isZipFileArgsForCall, struct {
		path string
	}{path})
	fake.isZipFileMutex.Unlock()
	if fake.IsZipFileStub != nil {
		return fake.IsZipFileStub(path)
	} else {
		return fake.isZipFileReturns.result1
	}
}

func (fake *FakeZipper) IsZipFileCallCount() int {
	fake.isZipFileMutex.RLock()
	defer fake.isZipFileMutex.RUnlock()
	return len(fake.isZipFileArgsForCall)
}

func (fake *FakeZipper) IsZipFileArgsForCall(i int) string {
	fake.isZipFileMutex.RLock()
	defer fake.isZipFileMutex.RUnlock()
	return fake.isZipFileArgsForCall[i].path
}

func (fake *FakeZipper) IsZipFileReturns(result1 bool) {
	fake.IsZipFileStub = nil
	fake.isZipFileReturns = struct {
		result1 bool
	}{result1}
}

func (fake *FakeZipper) Unzip(appDir string, destDir string) (err error) {
	fake.unzipMutex.Lock()
	fake.unzipArgsForCall = append(fake.unzipArgsForCall, struct {
		appDir  string
		destDir string
	}{appDir, destDir})
	fake.unzipMutex.Unlock()
	if fake.UnzipStub != nil {
		return fake.UnzipStub(appDir, destDir)
	} else {
		return fake.unzipReturns.result1
	}
}

func (fake *FakeZipper) UnzipCallCount() int {
	fake.unzipMutex.RLock()
	defer fake.unzipMutex.RUnlock()
	return len(fake.unzipArgsForCall)
}

func (fake *FakeZipper) UnzipArgsForCall(i int) (string, string) {
	fake.unzipMutex.RLock()
	defer fake.unzipMutex.RUnlock()
	return fake.unzipArgsForCall[i].appDir, fake.unzipArgsForCall[i].destDir
}

func (fake *FakeZipper) UnzipReturns(result1 error) {
	fake.UnzipStub = nil
	fake.unzipReturns = struct {
		result1 error
	}{result1}
}

func (fake *FakeZipper) GetZipSize(zipFile *os.File) (int64, error) {
	fake.getZipSizeMutex.Lock()
	fake.getZipSizeArgsForCall = append(fake.getZipSizeArgsForCall, struct {
		zipFile *os.File
	}{zipFile})
	fake.getZipSizeMutex.Unlock()
	if fake.GetZipSizeStub != nil {
		return fake.GetZipSizeStub(zipFile)
	} else {
		return fake.getZipSizeReturns.result1, fake.getZipSizeReturns.result2
	}
}

func (fake *FakeZipper) GetZipSizeCallCount() int {
	fake.getZipSizeMutex.RLock()
	defer fake.getZipSizeMutex.RUnlock()
	return len(fake.getZipSizeArgsForCall)
}

func (fake *FakeZipper) GetZipSizeArgsForCall(i int) *os.File {
	fake.getZipSizeMutex.RLock()
	defer fake.getZipSizeMutex.RUnlock()
	return fake.getZipSizeArgsForCall[i].zipFile
}

func (fake *FakeZipper) GetZipSizeReturns(result1 int64, result2 error) {
	fake.GetZipSizeStub = nil
	fake.getZipSizeReturns = struct {
		result1 int64
		result2 error
	}{result1, result2}
}

var _ appfiles.Zipper = new(FakeZipper)
