# CLI i18n Support

The CLI currently supports a variety of languages. These translations can be accessed by setting either LC_ALL or LANG in your environment, or by setting your locale within the cli via `cf config -locale your_LOCALE # (e.g. fr_FR)`.

Translations only affect messages generated by the CLI. Responses from server side components (Cloud Controller, etc.) will be internationalized separately and are likely to be English.

If you are interested in submitting translations for a currently unsupported language/locale, please communicate with us via the  [cf-dev](https://lists.cloudfoundry.org/archives/list/cf-dev@lists.cloudfoundry.org/) mailing list.

## How can you contribute?

If you see typos, errors in grammar, ambiguous strings or English after setting your locale, please find the appropriate entry in the corresponding `cf/i18n/resources/<language>_<locale>.all.json` file and submit a [pull request](https://help.github.com/articles/creating-a-pull-request/) with the fix(es). It is much better to submit small pull requests as you complete translations, rather than submitting a large one. This makes it much easier to rapidly merge your changes in. You can also report translations needing fixes as an issue in Github.

Pull requests should only contain changes to "translation" values; the "id" value should not change as it is the key which is used to find the translations, and will always be English. For example:

Given a missing translation for "Create an org":
```
[
  {
    "id":"Create an org",
    "translation":""
  },
  ...
]
```

Adding the translation would look like:
```
[
  {
    "id":"Create an org",
    "translation":"Créez un org"
  },
  ...
]
```

Finally, it is also important not to translate the argument names in templated strings. Templated strings are the ones which contain arguments, e.g., `{{.Name}}` or `{{.Username}}` and so on. The arguments can move to a different location on the translated string, however, the arguments cannot change, should not be translated, and should not be removed or new ones added. So for instance, the following string is translated in French as follows:

```
[
  ...,
  {
    "id": "Creating quota {{.QuotaName}} as {{.Username}}...",
    "translation": "Créez quota {{.QuotaName}} étant {{.Username}}..."
  },
  ...
]
```
