﻿$scriptpath = $MyInvocation.MyCommand.Path
$scriptdir = Split-Path $scriptpath
$etwman = Join-Path $scriptdir "openssh-events.man"

if (Get-Service sshd -ErrorAction SilentlyContinue) 
{
   Stop-Service sshd
   sc.exe delete sshd 1>$null
   Write-Host -ForegroundColor Green "sshd successfully uninstalled"
}
else {
    Write-Host -ForegroundColor Yellow "sshd service is not installed"
}

# unregister etw provider
wevtutil um `"$etwman`"

if (Get-Service ssh-agent -ErrorAction SilentlyContinue) 
{
   Stop-Service ssh-agent
   sc.exe delete ssh-agent 1>$null
   Write-Host -ForegroundColor Green "ssh-agent successfully uninstalled"
}
else {
    Write-Host -ForegroundColor Yellow "ssh-agent service is not installed"
}

# SIG # Begin signature block
# MIIpeAYJKoZIhvcNAQcCoIIpaTCCKWUCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCC8/mw6Di5JOh/t
# HQ74j/CO7B6ogMePly/xSc9TAOVouqCCDYIwggYAMIID6KADAgECAhMzAAAAxa4M
# aP4Yy0aNAAAAAADFMA0GCSqGSIb3DQEBCwUAMH4xCzAJBgNVBAYTAlVTMRMwEQYD
# VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNy
# b3NvZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29mdCBDb2RlIFNpZ25p
# bmcgUENBIDIwMTEwHhcNMTcwODExMjAyMDI1WhcNMTgwODExMjAyMDI1WjB0MQsw
# CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9u
# ZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMR4wHAYDVQQDExVNaWNy
# b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
# AQCmTM+CNIcTiNU9avGPbZnSEGiTyBoBQloAzdqM3Hb4YCqzBBcStCdXwi52Tlu5
# FgDfayDSrYbY+9+zzP+xbQRZYD4TsGeDNYK3TKfDpHVbL38JyS1tG0eLKXY4jA89
# PM6x5TPforEKesh0CLX5hkM/zKTCjG6JBPeFALqomY4pr8GYM8HdqQJ6jrs90zzH
# vEwpZxObn30WFpYKpXbVuSqwxxxU2ZOuON7eQvNkJBCxwFJ49d9BtCbz287SD9k3
# W7XxTAo6jbwGuXB9Afc+1rVI8NbuhUofeDJPQLR7NrSvZvmlPvjq2EA8OQ6hTbhw
# f8Jf1AR9LR7qdA/Wc4vRBuLnAgMBAAGjggF/MIIBezAfBgNVHSUEGDAWBgorBgEE
# AYI3TAgBBggrBgEFBQcDAzAdBgNVHQ4EFgQU164eIpQwDitpNYitLuAaFjrtNIMw
# UQYDVR0RBEowSKRGMEQxDDAKBgNVBAsTA0RCWDE0MDIGA1UEBRMrMjMwMDEyK2M4
# MDRiNWVhLTQ5YjQtNDIzOC04MzYyLWQ4NTFmYTIyNTRmYzAfBgNVHSMEGDAWgBRI
# bmTlUAXTgqoXNzcitW2oynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
# Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RTaWdQQ0EyMDExXzIwMTEt
# MDctMDguY3JsMGEGCCsGAQUFBwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3
# dy5taWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RTaWdQQ0EyMDExXzIw
# MTEtMDctMDguY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQELBQADggIBAJwr
# NGIdIyziSKi4wFLnk1YgC0F2lGCE8UYIJgzNiuuJlmMwshYHmOnpz7EtYuJdbS6Y
# jGEnFnDrZTGwVDUr0SReggUtw7eUBJrRu3BQtnRL/d/zMW1B1kpHR/iOG0MWgz5N
# 0AvGdo0tAlqAfj5a5Zxw3CgGq0irHYNPULPZD8rV5wc/qbVyb5sMxyl1N3TR21CL
# 8MbJkkiW1BE0e2RkBDHoKtQKSA2WJZkaBDmBxXupltI0RdPm7bdjQa5DDZWpYmwW
# 8mCp0wfP8PY42jiI5or6ZXOCj5gLfkLsq1NfZdNNQDLR+FEHr8RXGpANbeLIKI5K
# RyF8OE6fjvc6VqhvnMKWg4E7szCTtKuWa9g5nVyTuQzGe3MeWRTZQCO0SdhAuWKQ
# 1b+11ZDff+bgL00krNl9Nh3eA99W79SmJDXSkwb2ji6+twkREVkQK6DHSFnC90cx
# FUPVJ5REGPaYjUfp5YyXyXSNAErTEKwZy7BS3kMuhaiOoOcxMQZi/4qQpJm0yK7E
# 3f8oGdK990kJyF8DXm8Mj3ahq+9wEznuhazPsrigHiy9M7XqF77wV11WxeTuHMOm
# MddeLmTcYXQgFVuR8CvxGh9KJPLyQwF5UJVyWLrf0tJpsPn/WgEWTDHYLuPz/pVi
# dOmBIs9cH5zy9P6KbkAoU0gDhcJyWG6lzizzVDjhMIIHejCCBWKgAwIBAgIKYQ6Q
# 0gAAAAAAAzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
# Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
# dCBDb3Jwb3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNh
# dGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4MjA1OTA5WhcNMjYwNzA4MjEwOTA5
# WjB+MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
# UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSgwJgYDVQQD
# Ex9NaWNyb3NvZnQgQ29kZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
# AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00uvK2WCGfQhsqa+laUKq4
# BjgaBEm6f8MMHt03a8YS2AvwOMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe
# 0t+bU7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQz7NEt13YxC4Ddato
# 88tt8zpcoRb0RrrgOGSsbmQ1eKagYw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v
# ++MrWhAfTVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+EGvKhL1nkkDst
# rjNYxbc+/jLTswM9sbKvkjh+0p2ALPVOVpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN
# 91/w0FK/jJSHvMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rhKEmdX4ji
# JV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3s/gA4bysAoJf28AVs70b1FVL5zmh
# D+kjSbwYuER8ReTBw3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zdsGbi
# wZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ecXL93KCjx7W3DKI8sj0A3T8Hh
# hUSJxAlMxdSlQy90lfdu+HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
# jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEAMB0GA1UdDgQWBBRIbmTl
# UAXTgqoXNzcitW2oynUClTAZBgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNV
# HQ8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAWgBRyLToCMZBDuRQF
# TuHqp8cx0SOJNDBaBgNVHR8EUzBRME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29m
# dC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDExXzIwMTFfMDNf
# MjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBOBggrBgEFBQcwAoZCaHR0cDovL3d3dy5t
# aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIwMTFfMDNf
# MjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsGAQQBgjcuAzCBgzA/BggrBgEFBQcC
# ARYzaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1hcnlj
# cHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBnAGEAbABfAHAAbwBsAGkAYwB5
# AF8AcwB0AGEAdABlAG0AZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
# mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74w3LRbYP+vj/oCso7v0ep
# o/Np22O/IjWll11lhJB9i0ZQVdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1
# HXeUOeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb7Wj6aC6VoCo/KmtY
# SWMfCWluWpiW5IP0wI/zRive/DvQvTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInW
# H8MyGOLwxS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn+N4sOiBpmLJZ
# iWhub6e3dMNABQamASooPoI/E01mC8CzTfXhj38cbxV9Rad25UAqZaPDXVJihsMd
# YzaXht/a8/jyFqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw3MYbBL7f
# QccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtIEJmAH9AAKcWxm6U/RXceNcbSoqKf
# enoi+kiVH6v7RyOA9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sLgOpp
# O6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF670EKsT/7qMykXcGhiJtXcVZO
# SEXAQsmbdlsKgEhr/Xmfwb1tbWrJUnMTDXpQzTGCG0wwghtIAgEBMIGVMH4xCzAJ
# BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
# MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jv
# c29mdCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAADFrgxo/hjLRo0AAAAAAMUw
# DQYJYIZIAWUDBAIBBQCgga4wGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIPGV+Tcr
# 5SGaGrRu6JBqAAhQsQ05PIPG2BQE6DhwX0z9MEIGCisGAQQBgjcCAQwxNDAyoBSA
# EgBNAGkAYwByAG8AcwBvAGYAdKEagBhodHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20w
# DQYJKoZIhvcNAQEBBQAEggEANkoe1wVDWCW/iEsZR9j6RPloH8kOCWNM+N/FyFFi
# qvLezEUjERAv6YJAsWZ/tpOMM+kk0D6dAY1mA5On0hNfaDNf29Xwsw78xEWLRYiI
# sApUPXkTMnx61gCCvC2whI62nKRYViANOgq51QAYUuVIxcuAh06t9LrRyGVhCyUE
# gIYMEUf8GyT/bHY8YSQ6bdIuzIc44DQbJE0kpTq0U5jALmLty4DEANnRHO7vALQ3
# u2bsfwQlPiz8tYY3ILxvx/nxg9CbV2CMTTYKsTJfGx75sT2IRouutXGLhemK1IzA
# YjclQud0tj7iUvI5nDkrjnOIyRiihgF8CKlERwFNsg1dQqGCGNYwghjSBgorBgEE
# AYI3AwMBMYIYwjCCGL4GCSqGSIb3DQEHAqCCGK8wghirAgEDMQ8wDQYJYIZIAWUD
# BAIBBQAwggFRBgsqhkiG9w0BCRABBKCCAUAEggE8MIIBOAIBAQYKKwYBBAGEWQoD
# ATAxMA0GCWCGSAFlAwQCAQUABCC4aJNfCqkGO4doolOxIchR8DiJy25DXpylbw99
# zDxyAwIGW1WVM0f6GBMyMDE4MDcyNjE4MjAzMi4xMThaMASAAgH0oIHQpIHNMIHK
# MQswCQYDVQQGEwJVUzELMAkGA1UECBMCV0ExEDAOBgNVBAcTB1JlZG1vbmQxHjAc
# BgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEtMCsGA1UECxMkTWljcm9zb2Z0
# IElyZWxhbmQgT3BlcmF0aW9ucyBMaW1pdGVkMSYwJAYDVQQLEx1UaGFsZXMgVFNT
# IEVTTjozQkQ0LTRCODAtNjlDMzElMCMGA1UEAxMcTWljcm9zb2Z0IFRpbWUtU3Rh
# bXAgc2VydmljZaCCFC0wggTxMIID2aADAgECAhMzAAAAvmAPMgUbIBKdAAAAAAC+
# MA0GCSqGSIb3DQEBCwUAMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5n
# dG9uMRAwDgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
# YXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwMB4X
# DTE4MDEzMTE5MDA0MloXDTE4MDkwNzE5MDA0MlowgcoxCzAJBgNVBAYTAlVTMQsw
# CQYDVQQIEwJXQTEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
# IENvcnBvcmF0aW9uMS0wKwYDVQQLEyRNaWNyb3NvZnQgSXJlbGFuZCBPcGVyYXRp
# b25zIExpbWl0ZWQxJjAkBgNVBAsTHVRoYWxlcyBUU1MgRVNOOjNCRDQtNEI4MC02
# OUMzMSUwIwYDVQQDExxNaWNyb3NvZnQgVGltZS1TdGFtcCBzZXJ2aWNlMIIBIjAN
# BgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAkGUJXIQQoKzy5Bm3U5cDl8yMTRs4
# FztUXBjJPd+J2twH+X6CikvtEfGpEH3cm3DqP5UiY9XsKZpUqBw5qtvu7jCwNzFV
# f3KDtpZukbEC7e6DpX81e4zr1spqqc8ne5Yg7R8btYnf+0nOyYWXMOZ/MQs0L7mT
# WruLETZKulz38kSOYf/nBwMUfGciczAUOFmMMfRAIAOSaFT+BTxMEvlF3uQYT3Xo
# kdu52/awVqIgGY+3jtBJUwYDH0vA9rwWGhBh9P0JYpWORLfQiB0ijY2llCM0O2mU
# ijk8BUHUpT5JXJxp2zERzbEo45NCLHOLotOhSqS5iEpdKVNYs4HHgkBVCwIDAQAB
# o4IBGzCCARcwHQYDVR0OBBYEFAxvfwYWWxO8h44Czt1mftlutyJzMB8GA1UdIwQY
# MBaAFNVjOlyKMZDzQ3t8RhvFM2hahW1VMFYGA1UdHwRPME0wS6BJoEeGRWh0dHA6
# Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1RpbVN0YVBD
# QV8yMDEwLTA3LTAxLmNybDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUHMAKGPmh0
# dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljVGltU3RhUENBXzIw
# MTAtMDctMDEuY3J0MAwGA1UdEwEB/wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUHAwgw
# DQYJKoZIhvcNAQELBQADggEBAEc9ReWsEFRFRna12mJLzY6xRcuQMvve+gjZIjmV
# VB5Oh8wqjpW09X3ylPHTOUm+KEsrXQ9i95TSAK0bV+MzRpd0NyXE1SGBULvTndzi
# NVZLIfuHdeVLC7/72S1v8exYrBw5zCE7n9+0RwbKQHn2SEfPenK9hYcb10BsUl3V
# bMiKvxbpOFjyZNstPMvZOr1rS2KKWTogKsHHmg8Q4IPKkpmTOjMQIh2qHnFvYjmK
# Etq4ZRpJ12+0yNg+17udNlDP6+DJJzg8VfLWO5LctDkPzoI+E2hS1fzryXCFaBkr
# 8Abt8k12OcIY7cTSQYYsjqTnmUfBR2SPcH4TY9rLLoxuoXYwggXtMIID1aADAgEC
# AhAozDolv7pErESam1hrQzmqMA0GCSqGSIb3DQEBCwUAMIGIMQswCQYDVQQGEwJV
# UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
# ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMTIwMAYDVQQDEylNaWNyb3NvZnQgUm9v
# dCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkgMjAxMDAeFw0xMDA2MjMyMTU3MjRaFw0z
# NTA2MjMyMjA0MDFaMIGIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
# bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
# aW9uMTIwMAYDVQQDEylNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3Jp
# dHkgMjAxMDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBALkInijk5OwG
# TlBos0HFe+uuto6vgboiRB9lNGlMvnBAF/IWe+J5/YbtDTn0G6itkpAeyz12j1rZ
# tZEQLjwFjYptJFTnH+1WrYO0UJwVpRd0iFkg/AjFhHbTaNRvKHjOXLjzUJBE/+Nj
# X76hmiyWFQTWB/4ehCHgQjERxCg2lM9QpGKeydarcQCyWwzmltQKJJb1/8bVtxvX
# y7chYq8S3KFdN+Ma+xpGmMCbwOdjHyoIkwJ+HmqO8p8YieQihaKxhFdA//UO2G+c
# 7eJFMQHNF+l/sIFF46ohQCahcqqnTzwBBX7ug1ixXgZjmWKReIK3DZMMJGq0G9sn
# 7F+VBD+TSjD1lxizp/kZp5MzHQHI2yJSXNclyUb5ovuHWUO+m2KxjS2GRBpGrHhh
# fjAJ+q6JxEEqImYDkTlFnMeLDKjKDS/7UuoM92MzI53+sB+tZ9anUAPGBHBjtSyx
# hlpDt/uu+W4pbiEhQSYGjMnD7rDChZOhuYXZ5jJsS0w/1l2j5bWdd8OcwFW3dADj
# uDirg5dQ4ZpCJB3GwKMw0RpayFI093PxxxgfM6167MtBYPMjlCDCSEWsXFHGLoDC
# 4ncVvYWH7TadlpHuALWjcOyf442AaIN2uq9dcFIiFuJm+7qzxcL3Pi93psrewabG
# SEzDN1Ej0yfXuE5wlvChRHaveM+a4WYTAgMBAAGjUTBPMAsGA1UdDwQEAwIBhjAP
# BgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTV9lbLj+iiXGJo0T2UkFvXzpoYxDAQ
# BgkrBgEEAYI3FQEEAwIBADANBgkqhkiG9w0BAQsFAAOCAgEArKWWjL+7rqb213GH
# QzFWiP0cMnFbNbfU8JHyrzfiFPHzAiYFPhYUfxS6uE/7ibKy59QJzG25WztkZXBm
# t/KxWt8aAvP1UbhnbXnzv1Z75IS5Kx6bQJwmNPlHGJhp2BzXttG/j2HCZ8S172BD
# jhAbNknkIMqtp8GxJ2UJ+M31WyrQhDPz7x/y9ZwLWJM3oHWg3nLebHUqZiL1jAYw
# Vp9AuTCqQHcVgteL7MDTsr2DxXcMHq6vGVOgTXlxnw+vMM5n+dYszCJBegfyl0IY
# zll5EFXebxDkuNqDZkAWCWgjW5cuJpoCu1eMxbi6aWIygImeof3Aknx7KzMZhCpj
# xQBoYvqfR42ZekU6p+nt7mlCtfOBm0dWEHv8cDaEGHPq7/mXTZ4zI90mC7oqtz9E
# 3IMn/71hWSsRt8pP28WLDBwxrjL4+LlC93/cYZp2sVoE4RE9ZkW3GHG+ySSF1vPU
# ukE0XRItJbmNphNIbUuwB32ZkwlhgXRXJoqraePk2ceIzCTY7FIkXB68kRTilt7r
# Ctqe3V+zW9vUguzGIFCHJUA6+8fuzf4z5W7DhAlVAyU5wOk1XWUxqPa/oAnNKcez
# NjIu3JXzg8Faz4uN9uqzIfik7R4xDrZMEatgC6QSIyIXozZkgpEEEuCrbx7LUAVh
# tED/WYZx0dUzaXypc4o412QM8WkwggZxMIIEWaADAgECAgphCYEqAAAAAAACMA0G
# CSqGSIb3DQEBCwUAMIGIMQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
# bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
# aW9uMTIwMAYDVQQDEylNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3Jp
# dHkgMjAxMDAeFw0xMDA3MDEyMTM2NTVaFw0yNTA3MDEyMTQ2NTVaMHwxCzAJBgNV
# BAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25kMR4w
# HAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29m
# dCBUaW1lLVN0YW1wIFBDQSAyMDEwMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIB
# CgKCAQEAqR0NvHcRijog7PwTl/X6f2mUa3RUENWlCgCChfvtfGhLLF/Fw+Vhwna3
# PmYrW/AVUycEMR9BGxqVHc4JE458YTBZsTBED/FgiIRUQwzXTbg4CLNC3ZOs1nMw
# VyaCo0UN0Or1R4HNvyRgMlhgRvJYR4YyhB50YWeRX4FUsc+TTJLBxKZd0WETbijG
# GvmGgLvfYfxGwScdJGcSchohiq9LZIlQYrFd/XcfPfBXday9ikJNQFHRD5wGPmd/
# 9WbAA5ZEfu/QS/1u5ZrKsajyeioKMfDaTgaRtogINeh4HLDpmc085y9Euqf03GS9
# pAHBIAmTeM38vMDJRF1eFpwBBU8iTQIDAQABo4IB5jCCAeIwEAYJKwYBBAGCNxUB
# BAMCAQAwHQYDVR0OBBYEFNVjOlyKMZDzQ3t8RhvFM2hahW1VMBkGCSsGAQQBgjcU
# AgQMHgoAUwB1AGIAQwBBMAsGA1UdDwQEAwIBhjAPBgNVHRMBAf8EBTADAQH/MB8G
# A1UdIwQYMBaAFNX2VsuP6KJcYmjRPZSQW9fOmhjEMFYGA1UdHwRPME0wS6BJoEeG
# RWh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3RzL01pY1Jv
# b0NlckF1dF8yMDEwLTA2LTIzLmNybDBaBggrBgEFBQcBAQROMEwwSgYIKwYBBQUH
# MAKGPmh0dHA6Ly93d3cubWljcm9zb2Z0LmNvbS9wa2kvY2VydHMvTWljUm9vQ2Vy
# QXV0XzIwMTAtMDYtMjMuY3J0MIGgBgNVHSABAf8EgZUwgZIwgY8GCSsGAQQBgjcu
# AzCBgTA9BggrBgEFBQcCARYxaHR0cDovL3d3dy5taWNyb3NvZnQuY29tL1BLSS9k
# b2NzL0NQUy9kZWZhdWx0Lmh0bTBABggrBgEFBQcCAjA0HjIgHQBMAGUAZwBhAGwA
# XwBQAG8AbABpAGMAeQBfAFMAdABhAHQAZQBtAGUAbgB0AC4gHTANBgkqhkiG9w0B
# AQsFAAOCAgEAB+aIUQ3ixuCYP4FxAz2do6Ehb7Prpsz1Mb7PBeKp/vpXbRkws8LF
# Zslq3/Xn8Hi9x6ieJeP5vO1rVFcIK1GCRBL7uVOMzPRgEop2zEBAQZvcXBf/XPle
# FzWYJFZLdO9CEMivv3/Gf/I3fVo/HPKZeUqRUgCvOA8X9S95gWXZqbVr5MfO9sp6
# AG9LMEQkIjzP7QOllo9ZKby2/QThcJ8ySif9Va8v/rbljjO7Yl+a21dA6fHOmWaQ
# jP9qYn/dxUoLkSbiOewZSnFjnXshbcOco6I8+n99lmqQeKZt0uGc+R38ONiU9Mal
# CpaGpL2eGq4EQoO4tYCbIjggtSXlZOz39L9+Y1klD3ouOVd2onGqBooPiRa6YacR
# y5rYDkeagMXQzafQ732D8OE7cQnfXXSYIghh2rBQHm+98eEA3+cxB6STOvdlR3jo
# +KhIq/fecn5ha293qYHLpwmsObvsxsvYgrRyzR30uIUBHoD7G4kqVDmyW9rIDVWZ
# eodzOwjmmC3qjeAzLhIp9cAvVCch98isTtoouLGp25ayp0Kiyc8ZQU3ghvkqmqMR
# ZjDTu3QyS99je/WZii8bxyGvWbWu3EQ8l1Bx16HSxVXjad5XwdHeMMD9zOZN+w2/
# XU/pnR4ZOC+8z1gFLu8NoFA12u8JJxzVs341Hgi62jbb01+P3nSISRKhggLOMIIC
# NwIBATCB+KGB0KSBzTCByjELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAldBMRAwDgYD
# VQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24xLTAr
# BgNVBAsTJE1pY3Jvc29mdCBJcmVsYW5kIE9wZXJhdGlvbnMgTGltaXRlZDEmMCQG
# A1UECxMdVGhhbGVzIFRTUyBFU046M0JENC00QjgwLTY5QzMxJTAjBgNVBAMTHE1p
# Y3Jvc29mdCBUaW1lLVN0YW1wIHNlcnZpY2WiIwoBATAHBgUrDgMCGgMVADQRKVyP
# wg5xMUuXjOmXHbdKRk/+oIGDMIGApH4wfDELMAkGA1UEBhMCVVMxEzARBgNVBAgT
# Cldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29m
# dCBDb3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAgUENB
# IDIwMTAwDQYJKoZIhvcNAQEFBQACBQDfBAgeMCIYDzIwMTgwNzI2MTY0MzEwWhgP
# MjAxODA3MjcxNjQzMTBaMHcwPQYKKwYBBAGEWQoEATEvMC0wCgIFAN8ECB4CAQAw
# CgIBAAICImYCAf8wBwIBAAICEQowCgIFAN8FWZ4CAQAwNgYKKwYBBAGEWQoEAjEo
# MCYwDAYKKwYBBAGEWQoDAqAKMAgCAQACAwehIKEKMAgCAQACAwGGoDANBgkqhkiG
# 9w0BAQUFAAOBgQB/Vcd9NLPYvkCZLMTA8eXvmb3iWvgmUCGG7ECC9yqM2SNOgNtK
# 0apYyQx1SmFl3sckPiX0StILxSPDQ8HLvwp6mQCGjxiMZxo2h6kds1GkDy/OIf/6
# m7kxvob8pB0ARwlhIp04tM6wp1t+sHtO7ws1Uq5AEtm/qPuL15L83qoZWjGCAw0w
# ggMJAgEBMIGTMHwxCzAJBgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
# DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
# JjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAvmAP
# MgUbIBKdAAAAAAC+MA0GCWCGSAFlAwQCAQUAoIIBSjAaBgkqhkiG9w0BCQMxDQYL
# KoZIhvcNAQkQAQQwLwYJKoZIhvcNAQkEMSIEINdP5nr39T5cZYIY3BMBhU7SJaIG
# tGKph2R99LBzMkkNMIH6BgsqhkiG9w0BCRACLzGB6jCB5zCB5DCBvQQgDPsEFG+S
# HghPmCn6B+RP950YE+/IehKWybjCSeBcyaYwgZgwgYCkfjB8MQswCQYDVQQGEwJV
# UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UE
# ChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGlt
# ZS1TdGFtcCBQQ0EgMjAxMAITMwAAAL5gDzIFGyASnQAAAAAAvjAiBCAmWfbPpAxe
# LP6i7tP5GKNlyYXsnvReWllB50KSe/Z5RTANBgkqhkiG9w0BAQsFAASCAQAj2YXG
# 2YUW6NBvw1ZcaLN5kYYTeGzSdIxu6szbzp6VqGsGNftrYMUM2D/wAv6qo8Yckzpv
# VS98CO11R2woe/nZzanUHAA/wPLt1o1uU1yWRl8bIPmAN1QexfcEmcqdNtVUlBha
# xfK1RyNeKdmmmadxEFdL80oGnyBXtvU6XuCy/glXBzSGzJQjneHgI0omhN5WksVs
# EGj3Lp4dyEykA9cMgtPEam97sgqGbUNAqFw3tQ1vN7HI9DDBjQCGXrgbMIk9tbmv
# vIfkKZjfyvZ2q7Z3piN3zzE8ZrZuFPmwtSXpwfs2vywVWVMIB8O9DcWB+FNPTmQ6
# wwIYnp5OcA7GklCV
# SIG # End signature block
