package aws_test

import (
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"

	"testing"
)

func TestAWS(t *testing.T) {
	RegisterFailHandler(Fail)
	RunSpecs(t, "aws")
}

const (
	validRSAKey = `-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEAvXMDyDguAnAQqQF0mAff2etww+G+Mpf07hUlnGDkzwELdQZ+
dcYCPOWLISUuGH3EJVrlOtaxc/UY83P/Czg85sGnSkccLrApUH3aQFdx0QQ3D7ZD
qrmxkvLHKhf11F7Mz4o3/6bv/M2SqPtWGO5NSdtp77QX+my00KuloMyTv+TNZ8A+
DTJPW47Ip0Kq/NUK0rL6kUS7zn1KAkXlUST1GGR1vISn0OOP0PfD0szQZaYCmAJ6
DOzGBd2/4abscTP7fFWxFpEGWRZEhJ+YnxKhF6myQ9Bs6qPXNJPA1OyN1LXtC0Uh
+x6ByAQLrix0N71JJ7grg1y28bcag3kfvgHwCwIDAQABAoIBAEB7vIbS8H4t7M3J
zAjPbVc8d0aFOPr5lAnRstqWdGstPNwZWMP3oN1feErQ3+7AKBpa5PlxCDei7lo3
WlFUVA5rTejPaX1OwtE99SK/YOM3HxK/BCtBR3rwHfBq9WbS2b2umz7ucHNI+amA
2x5jRnVkNJu9XggEJkt8kUS5PXUr8oMjOdMtNCFum4roicFkuvOBHLWlPmX9UvbY
zHvNw1KfygrZq9NvYiDjOES234VYZb7L1AcC/rDoAC353EE4qt3Xm0F+OE2ai7dx
u3JfdCwIzdRLw5k5CyFgRiC+8i6/X3lNJR86Rvd1zC9r2mEwLt2rZl8kg/2pcBvb
HzxDzVECgYEAyznER78IDiqoYe0mfQJ+OlLv6+ZZj/pVjLhQtLwSk66dQLuUFBhz
LhEXXHMuyh9Y0Utw2OiawlYlkCuw/3qH1dNCbE1YxBSpsr9HIjHLBhLaYFLBqOQS
X973jLG/JDUuiZnrZoQ/ScNwaSY8b9gh/CAHzBVjIA4rSzI68QWgTLkCgYEA7qVo
pHDbenYmh9pYiXGym9fu2RxlYYX1n5BDiLxXMMLVEvsXFV23kuYoQS5wqASW8v4T
kLLDT6AsOK9541WGN5p42uTQigTEaouXklMI5Krk2d1kYSh+/EI18dytmk8NHkeD
ObW+3Xk5Q4RSdl3DlPET59F2rbxoRUcs9KVpKOMCgYB+A/3/9ybJkg4DWwhor+kR
xWfcQWP78WCm94uj5pMmXDpKb4Ysx9R0FkkEHLBAyRtL/JmnBuUf6Ec2lMEWSiZ8
opknival76IiopU7UODxjTM4U1ien339UMbzySwbCZcn3/emBA8ycCv+J6WGPOEl
876iAAkNUXvrDuSZm8GAkQKBgQC6v7vseth1s4GhbA8+tzeS1t51DdCUCXVVwVnn
5aLBaKW+7bh5otXl4a/8me/Uu4q4anU7FXjblbclQMQ8Tw/x8TLD8Kz0ZJij28rn
2YyrDMR7bNGBamQ82T9Hnm5Hw7a7TDD3dy7+Nz/FgwXY1LUZl7IBBZw+hqJ+HB2k
8NAjCwKBgFFrbUPiQfqDoftkhoofEAqTbz8OBEs4iJwcpNxr9Q9Yz/Bbq/2Kb4Tz
Tur818l/ASHdiwFbYsGz7CJfGgmjNIsL4s2QhTkJgqq0f+Nv8NVNkJ2PFtYZS1EG
O0flBWBP4MtvJjixn7G49dynF6PTYJPZBEjcL1R91qkaPYEAOcl4
-----END RSA PRIVATE KEY-----`

	invalidRSAKey = `-----BEGIN RSA PRIVATE KEY-----
MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAvXMDyDguAnAQqQF0mAff
2etww+G+Mpf07hUlnGDkzwELdQZ+dcYCPOWLISUuGH3EJVrlOtaxc/UY83P/Czg8
5sGnSkccLrApUH3aQFdx0QQ3D7ZDqrmxkvLHKhf11F7Mz4o3/6bv/M2SqPtWGO5N
Sdtp77QX+my00KuloMyTv+TNZ8A+DTJPW47Ip0Kq/NUK0rL6kUS7zn1KAkXlUST1
GGR1vISn0OOP0PfD0szQZaYCmAJ6DOzGBd2/4abscTP7fFWxFpEGWRZEhJ+YnxKh
F6myQ9Bs6qPXNJPA1OyN1LXtC0Uh+x6ByAQLrix0N71JJ7grg1y28bcag3kfvgHw
CwIDAQAB
-----END RSA PRIVATE KEY-----`

	fingerprint = "5d:f1:5a:6b:22:87:27:a5:e3:33:5e:d2:c9:7f:2e:08"
)
