# `bbl up --lb-type cf`

## `--iaas aws`
There are 3 elastic load balancers.

1. **cf-ssh-lb**
    - deployment
      - destination vm `scheduler` with vm_extension `diego-ssh-proxy-network-properties`

    - forwarding
      - `tcp:2222` -> `tcp:2222`

1. **cf-tcp-lb**
    - deployment
      - destination vm `tcp-router` with vm_extension `cf-tcp-router-network-properties`

    - forwarding
      - `tcp:1024-1123` -> `tcp:1024-1123`

1. **cf-router-lb**
    - deployment
      - destination vm `router` with vm_extension `cf-router-network-properties`

    - forwarding
      - `http:80`   -> `http:80`
      - `https:443` -> `http:80`
      - `tls:4443`  -> `tcp:80`



## `--iaas gcp`
There are 5 load balancers.

1. **cf-router-lb**
    - deployment
      - destination vm `router` with vm_extension `cf-router-network-properties`

    - components
      - a backend service with an instance group per availability zone
      - instance group per availability zone allowing `https:443`
      - a firewall rule allowing `tcp:80` & `tcp:443` to the backend service
      - a health check for `tcp:8080` & `tcp:80`

1. **cf-ws-lb**
    - deployment
      - destination vm `router` with vm_extension `cf-router-network-properties`

    - components
      - a target pool
      - a forwarding rule allowing `tcp:443` to the target pool
      - a forwarding rule allowing `tcp:80` to the target pool
      - no firewall rule?

1. **cf-credhub-lb**
    - deployment
      - destination vm `some` with vm_extension `credhub-network-properties`

    - components
      - a target pool
      - a firewall rule allowing `tcp:8844` to the target pool
      - a forwarding rule for `tcp:8844` to the target pool

1. **cf-tcp-router-lb**
    - deployment
      - destination vm `tcp-router` with vm_extension `cf-tcp-router-network-properties`

    - components
      - a target pool
      - a firewall rule allowing `tcp:1024-32768` to the target pool
      - a forwarding rule for `tcp:1024-32768` to the target pool

1. **cf-ssh-proxy-lb**
    - deployment
      - destination vm `scheduler` with vm_extension `diego-ssh-proxy-network-properties`

    - components
      - a target pool
      - a firewall rule allowing `tcp:2222` to the target pool
      - a forwarding rule for `tcp:2222` to the target pool


## `--iaas azure`
There is 1 application gateway.
