// Code generated by go-bindata.
// sources:
// templates/base.tf
// templates/cf_dns.tf
// templates/cf_lb.tf
// templates/concourse_lb.tf
// templates/iso_segments.tf
// templates/lb_subnet.tf
// templates/ssl_certificate.tf
// templates/vpc.tf
// DO NOT EDIT!

package aws

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _templatesBaseTf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xdc\x5c\x5f\x6f\xdb\x38\x12\x7f\x8e\x3f\x85\x60\xf4\xa1\xed\xd9\xae\xed\xd8\x89\x13\x6c\x1f\x72\x6d\xee\xae\x8b\xbd\xdd\x22\x29\xf6\xe1\x8a\x40\xa0\x28\x4a\xe6\x45\x12\x05\x8a\x72\x9a\x06\xfe\xee\x07\x92\xa2\x24\x4a\xa4\x2d\xa5\x71\x93\xbd\x5d\xa0\x4d\x34\xc3\xf9\xf3\x23\x39\x33\x94\x86\xdd\x00\x8a\x81\x17\x21\x67\x98\x00\xe6\x82\x18\xbb\x31\x48\x87\xce\xc3\xc0\x71\xd8\x7d\x8a\x9c\xf7\xce\x90\x3f\x18\x0c\x1c\xc7\x47\x01\xc8\x23\xe6\xbc\x17\x54\xc7\x01\xe9\x38\x21\x94\xad\x11\xc8\xd8\x78\xc6\x39\x41\x8c\xc7\xb3\xa9\x1f\xc0\xd5\xe9\xe9\xb0\xcd\x33\x2f\x79\xc0\xcc\x83\x8b\xd3\x45\xc9\x93\x91\x9c\xad\xc7\x33\xfe\x9b\xe2\x39\x5d\xc0\xd9\xea\x64\xe6\xe9\x3c\xba\xae\xe3\x13\x10\xcc\xa7\xcb\xa5\x81\xa7\xd2\x85\xce\x66\xab\xd9\xa9\x2f\x79\x20\x18\x43\x94\x30\x0a\x22\xa1\x4d\xf1\xcc\xfd\xe3\x13\x70\x7a\x22\x79\x50\x6e\xe2\x39\x43\x1e\x9a\xad\x82\x59\xc9\x73\x87\x84\x29\x75\x9b\x8f\xc1\x6a\x71\x16\x2c\xa1\xce\x33\xd7\x78\xe6\xb3\xd9\x7c\xba\x58\x14\x36\xe7\xd9\xb8\x70\xa9\xce\xe3\x2f\xe0\x12\x05\x70\xae\xf3\xe8\x72\x82\xf9\xa9\xb7\x04\x67\xa7\x25\x4f\x48\x36\xa5\x4d\x05\x0f\x3c\x3e\x3b\x99\x4d\x41\x25\xc7\x60\xb3\xb7\x3a\x0d\x96\xc7\xfe\x4a\xe7\xd1\x75\xad\xbc\x00\xa2\x55\x20\xe4\x6c\x07\xdb\xc1\xa0\x5a\x35\x00\x42\x94\x65\xee\x2d\xba\xd7\x17\x4d\xc6\x28\x4e\xc2\xa1\xce\x9c\x21\x48\x11\xeb\xc8\x4c\x51\x88\x49\xd2\x81\xd1\x23\xd9\xda\xc5\x89\x47\xf2\xc4\x77\x21\xf6\xa9\x1c\x53\x2d\xd7\xe1\x74\x22\xfe\x7f\x37\x6d\x8c\x04\x1b\x80\x23\xe0\xe1\x08\xb3\x7b\xf7\x3b\x49\x50\xa6\xab\x8b\x70\xc6\x1a\x43\x50\xb2\x71\xb1\xdf\xc5\xd7\x35\xa1\xcc\xed\xcc\xbe\x49\x61\xcd\x76\xc1\x2a\xf1\x57\xdc\x9a\x43\x33\xe5\xd1\xec\x44\xc8\xa1\x28\x23\x39\x85\xdc\xa5\xbb\xcc\x45\x38\x1d\x3a\xc3\xff\xe6\x71\xea\x91\x6f\xf2\x37\x09\x48\x8a\x12\x3f\x73\x49\xe2\xbc\x77\xbe\x0a\x4e\x9c\x30\x44\x13\xc4\xdc\x10\x30\x74\x07\xee\x27\x38\x1c\xde\x0c\x1c\x67\x93\x42\xc7\x51\x4b\x80\xd1\x1c\xe9\x4a\x58\x94\xb9\x29\xc5\x1b\xc0\x90\x9c\x4c\x39\x07\x9b\xb8\xc0\x0f\x44\x21\xa1\x98\xad\x63\x6e\xeb\xd5\xf5\x05\xb7\x9e\x66\xc0\xf5\x30\xcb\xb8\xc4\xc5\xf4\xec\xa4\x6d\xf6\x2d\xba\x77\x53\x80\x69\x4b\x1c\x27\x24\x20\x46\x12\x90\x57\x0f\x1b\x40\x27\x12\xd8\xad\x5b\x72\x0e\x1c\x27\xcd\xbd\x08\x43\x2e\x47\xf2\x35\xcc\x9c\x28\xde\x49\xc5\xe8\x92\x14\x25\x59\xb6\xde\x1a\x60\xc4\x20\x76\x29\x89\x50\x61\x8f\xb4\x45\xd8\x61\xb6\x42\xf0\x72\x33\x00\x5b\x73\x96\x77\x22\x6a\x46\x38\x40\xf0\x1e\x46\xa8\x88\x9a\x90\x22\x6e\x8f\x87\x02\x42\x91\xeb\xa3\x8c\x51\x72\xaf\x50\xe6\xdb\x8b\xe3\x97\x65\x79\x8c\x84\x40\x37\x25\x11\x86\x9c\xe1\x97\x5f\x2e\xff\xf8\xc7\x80\x0b\x19\xfe\x89\x68\xc6\xf7\xc6\xb9\x33\x9c\x4f\x67\xf3\xf1\x6c\x3a\x9e\x9d\x0e\x47\x9c\x74\xcd\x00\x43\x31\x4a\xd8\xf0\xdc\xf9\x2a\x14\x4a\xb5\x8e\x33\xbc\x80\xac\x18\x94\xb1\xec\xfc\x42\xe8\xb8\xe2\x36\x8f\x14\xc7\x67\x8a\x13\x88\x53\x10\x0d\xcf\xcb\x61\x5c\x26\xa2\x1b\x0c\x11\x1f\x89\xe0\x7c\x02\x62\xf0\x9d\x24\xe0\x2e\x9b\x40\x12\x0f\x0b\xb6\x6d\x29\xe4\x32\x08\x10\xe4\xea\x87\x17\x51\x44\xee\x2a\xe9\xd7\xd8\xe7\x4f\xe5\x88\xed\xc0\x71\x6e\x06\xdb\x01\xf7\xc9\x88\xbc\xf4\xbb\x2b\xf6\x05\x77\x0b\xfd\x03\xa0\xf7\xb5\x02\x06\xc1\x39\xc7\x91\x40\x0c\x18\xba\xf0\x7d\x8a\xb2\xac\xf4\x57\xd1\x19\x03\x70\xfd\x27\x89\xf2\x18\x35\x69\x1f\x48\x7a\xff\x29\x06\x61\x9b\x20\x16\x89\x79\xd0\x47\x14\x21\x86\xae\x13\x90\x66\x6b\xc2\xcc\x54\xdb\xc8\x0c\x52\xec\x29\x4b\x51\xcb\xd6\x92\xa1\x16\x17\xff\x23\xc2\xa2\x85\x51\x18\x6f\xa7\x26\x19\x03\x09\xb4\x33\x5c\x89\x10\x6f\x25\x5f\x23\x98\x53\xcc\xee\xff\x49\x49\x9e\xda\xb9\x0a\x24\xec\x0c\xb9\x97\x20\x3b\x59\x62\x65\x20\xef\x98\x37\x31\x3d\xb6\x29\x90\xd4\x2f\x20\x6c\xc9\xfc\x37\xf1\x71\x70\xaf\x60\xb9\x60\x8c\x62\x2f\x67\x2d\xf1\x57\x79\x62\x85\xee\x0b\xa2\x31\x4e\x00\xb3\x83\xcb\x41\xcd\x18\xa2\xc6\x85\xf5\x11\x51\x8d\x3c\x38\x72\x9c\x9b\x11\xff\xd3\xb0\x6f\xf9\xd3\xab\x62\x63\xf2\xe7\x6f\x8b\xad\x3b\x1a\x1c\x3d\x08\x62\x6d\x4f\x1c\x09\x15\x18\xc4\xe7\x9f\x41\x96\x89\xb0\xd2\x57\xf6\xd1\x0e\xc1\x28\x02\x19\xc3\x30\x22\xc0\xf7\x40\x04\x12\x88\x93\xf0\xfc\xed\x23\x54\xec\x0b\x3b\xb5\x98\xeb\x02\xb1\x75\x45\x38\xa8\x87\x21\xce\x52\x60\xba\x27\x11\x14\x62\x68\x22\x19\xf5\xd0\x26\xd2\xd1\x04\xd0\xc4\x96\x7b\x70\x31\xc3\x6e\x4a\x49\x80\xbb\xe4\xa1\xb1\xa0\x2b\x13\x35\x9d\xfc\x89\xd4\xc8\x47\x6e\x8d\xa9\x09\x87\x09\xcf\x49\x70\x0d\x92\x10\x65\xa2\x48\xe0\xcc\xa2\x22\xd8\xb6\x6d\xcc\x8a\xed\xe9\x86\x7c\x7f\x0e\xe5\x09\xa2\xf9\xb0\xb4\xd5\x82\xd8\x38\x01\x6c\xac\x06\x8d\xe5\x20\x51\xab\xf0\xcd\x99\xf2\x55\xc0\x87\xfc\x7e\xf1\x65\x28\xcb\x12\x17\xfb\x35\x41\x11\x81\x20\x9a\xc8\xc7\xd2\x27\x06\xc2\xac\x70\xe7\x77\x23\x44\x66\x7d\xdb\x27\xc7\xc3\xa5\xb9\x98\x32\x0e\x0a\x23\x55\xa5\x25\x1f\x73\x05\x0d\x7e\xec\x57\x33\xa6\x93\x26\x6d\x60\x27\xa5\xbf\x45\xa5\x58\x40\x82\x42\x91\x83\x06\x8e\x13\x50\xc2\x57\x1a\x65\x82\x30\xe5\xac\x44\xfd\xae\x9e\xa4\x94\x30\x02\x49\x54\x0c\x1e\x8b\xc3\x0d\xaf\x42\x5d\x2f\x22\xf0\x56\xba\x5c\x15\xcf\x37\x7d\x7c\xc6\x30\x4e\x0f\xec\x2c\x4e\x4a\x6f\x1b\x9e\x70\xe5\x6d\x10\xc6\xb3\x16\x0a\xe2\xd1\x13\x79\xcc\xe0\x41\x1d\xd6\xfe\xb3\x7b\xdf\x64\x63\xb0\x85\x44\x83\xa5\xb9\x36\x1a\xe4\x93\xe5\xf2\x78\xc9\x1d\x12\x20\x34\xfd\xdf\xe1\x97\x5c\xf2\x20\x32\x3a\xd7\x03\xd7\xdc\x7f\x89\xb8\xe6\xfe\x5f\x03\x57\x95\x45\x24\x98\x12\x43\x75\x28\xc2\x69\xd3\xab\x57\x0f\x7c\x33\xac\x49\xc6\x5e\x0b\xcd\xa2\x74\x92\x07\xa7\xe2\xe7\x6a\xb3\x8c\x9c\xd3\x37\x5b\x8e\x41\x99\xa8\x74\x58\xf9\xe2\x9b\x4f\x62\xe4\xe3\x5c\x1c\x13\xa4\x80\x32\x80\x6b\x5a\x2d\xca\x84\x4b\x25\x44\xfc\xb0\xe4\xc2\x35\x82\xb7\x6a\x64\x00\xa2\x8c\x9f\x9a\x40\x8c\x2d\xb3\xc9\x73\x04\xb9\xcd\xd3\xd7\x3c\x07\xd4\x5e\x71\x8d\x1c\xfe\x40\xbe\x63\x90\x5e\xf0\x2c\xd2\x9a\x04\x19\x10\xfa\x2c\xaf\x1b\x53\x16\x32\xa6\x21\x59\x4d\x5d\x26\x9b\x4f\x1f\x5b\xf4\xa1\x39\xc5\xc8\x93\x3d\xd7\xfc\x98\x53\xbd\x9a\xa7\x3a\xe8\xea\x19\x77\x47\xc1\x6d\x3c\xfd\xa7\x94\x6c\xb0\x8f\xa8\x30\xa4\x38\xe6\x97\xef\x7e\x2a\xfb\xab\x67\x72\xe6\xca\x37\x3e\x15\x4b\xf5\x4c\xb0\xc8\x39\xa8\xe6\xab\x9a\x17\xd3\x72\x2e\x5e\x82\xb4\x8b\x0f\x1b\xe1\xa1\xaa\x1b\x4c\x25\xc3\xfe\xaa\xc6\xb2\xdd\x3a\x94\x36\x6a\xe4\xfe\xfa\xe6\x53\xc1\xf9\x54\x45\xce\x0e\xcd\x87\xab\x74\x2c\x40\x09\x32\x4f\x8e\x7d\xe3\xf7\xce\x38\x67\x8a\xe1\xfb\x82\xf7\xae\x6c\x68\x0b\xd7\xb5\x38\x8d\xa2\xa0\xa9\xaf\xfd\x6a\xec\x91\xf0\xf0\x6c\xf2\x02\xe0\xb1\x26\xb5\x67\x86\x47\xd4\x73\x2f\x00\x1f\x53\x5d\xa9\x88\xad\xea\x52\x23\xd4\x6b\x4c\x45\x78\x54\xa5\xb9\x13\x27\xc0\x8f\xbe\x65\xfc\xff\x19\x88\xa1\xdd\x80\xc9\x23\x45\x9f\xf5\x34\xfd\x69\x60\x65\xea\x2c\xdd\x46\xa8\x72\xe0\x69\x80\xea\xb8\xc2\x2a\xb6\x2f\x1f\x3e\xef\xa9\x2e\xe7\xf3\xdd\xe5\xa5\xa0\xf7\xae\x2d\x8b\x8f\x06\x9d\x6a\x74\xf5\x9e\xbe\x77\x5e\xe4\xa3\xf6\xe7\xc4\xbf\xff\x71\xfd\x2f\xe7\x23\xa6\x08\x32\x42\x9f\x2a\x31\x5a\x54\xf7\x4a\x8a\x23\x5e\x6c\x94\xa6\xf6\xcb\x91\x06\xc0\xca\xfc\xb8\x6b\x41\xda\xe6\xcb\x20\xef\x50\xf9\xd1\xb2\xe0\x0a\x82\x79\xcb\x4a\xf0\x5b\x1f\xe8\xb6\xdd\x77\xf0\x4e\xc0\x04\x11\x84\xe2\x05\xdd\x8b\xc5\xed\x64\x75\xb2\xb2\xe5\x4e\x49\xfa\xe9\xd8\xe5\x00\xbc\x60\xc0\x56\x8b\xc5\xb1\x05\xb0\x82\xf4\x2c\x8b\xcd\x2f\x42\x91\x0b\x52\xfc\x82\xd1\x9b\x2f\x97\xcb\xa5\x6d\xa7\x16\xb4\xe7\xc0\xef\x91\xa9\xb6\x17\x72\x1d\x01\xec\x80\x63\xc9\xf2\x32\x5e\xe2\xf4\xdd\xdf\xf6\xd3\xc4\xb3\xc2\xfd\x57\x79\x67\xd6\x13\xee\x1f\xab\xba\xfb\xc6\x86\x97\x59\x71\x57\x0d\x27\x1d\x0a\xc0\x82\x73\x7f\x0d\xf8\x6b\x21\xf2\x89\xaa\x3f\xbb\xde\x9f\x56\x00\xaa\xae\x9c\x47\xd4\x7a\x5a\x6d\xfe\xff\x52\xdf\x29\x3c\x68\xff\x17\x20\x07\xc6\xe3\xf8\x78\x75\x66\x41\xa4\x20\x1d\x1a\x93\x47\x55\xb6\x07\x46\xe5\xf9\xaa\x59\x85\x0a\xa4\xc8\x5f\xe7\xde\x0b\xc3\x65\xb5\x5a\x2c\x6c\x45\xab\x24\x1d\x1a\x17\x55\x9f\xbe\x30\x60\x9e\xb3\x1e\x2d\x5b\x20\xa5\xf5\x07\x00\xe6\x65\x26\x63\xad\x62\x69\x97\x3e\x3f\x58\x92\x1f\xfe\xed\xd7\xf3\x95\xe5\xd6\x62\xec\x09\x10\x7f\x7c\x55\x7e\x78\xc4\x9f\xaf\x32\xef\x81\xb8\xf8\x26\x5c\x16\xe2\xc5\x6f\x0f\x7a\x6d\x68\x2a\x0d\xeb\x3b\xaa\xfa\xc8\x2d\x05\x88\xef\xc2\xaa\xf9\x7a\xe4\xac\x46\xce\xf4\x4d\xaf\x77\x89\xd2\x0c\x73\x09\x48\x49\xce\x90\xcb\x80\x57\xad\x0d\xed\x51\xdf\x6f\x93\x62\xb0\x55\x92\x8f\x32\x86\x13\xc0\x6b\x52\x57\x77\xb8\xd6\xff\xee\x38\xc5\x47\xe1\xe6\x77\xf8\xda\x17\xe1\xd6\xd7\x63\xb5\xd0\x6a\x2a\xeb\xc3\xcb\xa1\x35\xfa\xa4\x69\xa3\x65\x52\xeb\x22\x41\xd1\x4a\x2b\xda\xfe\x87\x92\x52\x9b\x6b\x15\xc0\xf5\x36\x82\x0e\xed\x03\x0d\xb3\x7f\xc4\xdc\x72\x0d\x56\x5b\xb2\x6e\x1b\x24\x79\xc2\xda\xb0\x46\x28\x09\xd9\x5a\x2c\xb5\xf6\x95\x83\xaa\xfb\x40\x9f\x91\xbd\x2b\xb9\xce\x67\x5d\xd0\x8b\x91\x34\x6a\x82\x13\x1f\x7d\xfb\xdb\x4c\x6a\x6b\x59\x21\xa5\xa0\x48\x34\x3f\x5b\x0c\xd5\x24\x75\xdd\x24\xd5\x97\x68\x61\xdd\xab\x87\x9a\x8c\x6d\x9f\x93\x57\xe5\x38\x3f\x7f\xb5\xac\xb3\x9d\xc2\xf4\x2d\x58\xce\xda\x93\x6c\x43\xbb\xb4\x8e\x5b\xb1\x6c\x9c\x31\xcc\xbc\xad\x39\xa3\xcf\x1e\x34\x19\xf8\xc8\x7d\xd8\x69\xbd\x77\x5d\xec\xa6\x2d\xac\xd6\x5e\x6d\x2b\x37\x75\x4e\xde\x4e\xb0\xdf\x5a\x85\xdd\xf6\x77\x0f\x28\x9a\x01\x90\xcf\x74\xd8\x7f\x95\x04\x11\xb9\x73\x23\x12\xf2\x78\xed\x45\x72\x7c\x44\xc2\x22\x23\x56\xfd\xbb\x9c\x17\x46\x24\xf7\xef\x00\x83\x6b\xb7\x64\x99\x78\x5e\xa4\x9a\x75\x1d\xa7\xec\x4d\x06\x34\xd1\x96\x88\xea\xed\x55\xea\xb2\xa2\xa5\xb8\x15\x52\xcc\xf1\x84\x51\x10\x04\x18\xaa\xd6\xad\xf7\xce\xf0\xea\xf2\xd7\xcb\x0f\x5f\x0c\x0e\x99\x8c\xac\x3b\xc7\x6d\x75\x53\x8a\x02\xfc\xad\xd6\xec\x53\xbb\x06\xb5\x1d\x47\x24\x54\xef\x5c\x76\x5d\xb7\x29\x7d\xd9\xd5\xeb\xcc\x99\xb8\xc0\x6c\x2c\xfb\xad\x0f\x76\x6f\x46\xdd\x5b\xd9\x7f\xc3\x65\xff\xfd\x99\x4d\x0a\x2b\xc3\xf7\xdd\xa4\xb1\x5e\xd8\xe9\x76\x83\xa6\x06\x43\x7f\x4c\xab\x0b\x35\x96\x5e\xf2\x6a\xbd\xa9\xd7\x6f\x87\xbd\x6b\xc3\x55\x15\x57\x2b\x7e\x23\xa1\xb8\x12\x52\xbf\xdc\xa0\x93\xaf\x19\x45\x20\x6e\xd1\x3f\xe7\xec\x37\x12\x5e\x6e\x50\xa2\x5f\x07\x11\x44\x75\x1f\x44\x49\xdf\xc9\x21\x15\x64\x6a\xce\x6e\xf6\xaf\x0d\xd3\x45\x0a\x7d\x06\xc5\xde\x94\xd9\xb4\xfc\xd6\xd4\x78\x8d\x2a\x4a\xce\x56\xa3\x60\x19\xdb\x78\xaa\x69\x25\x84\x9d\x3d\x9c\xfa\xf8\xf0\xae\x11\xcb\xcb\x66\x50\x19\x37\x34\x45\x23\xa7\x28\x26\xd4\x29\xbb\xa4\xe2\xb4\xd3\xf0\xa5\x1c\x5e\xfa\x5a\x1f\xdf\x61\xf8\xc9\x1b\x53\xd4\xbd\x8d\x8b\xcb\xa8\xc3\xf2\x27\x0e\x28\x4a\x44\x76\xb8\x45\xf7\x2e\x25\x0c\x14\xef\x97\x55\x7f\x12\xc9\x59\x9a\x33\x71\x7d\xc5\x70\xeb\x42\x04\x7e\x10\xe5\x8d\x5d\xd0\x64\xd4\x6e\x57\xd4\x84\xaa\xc6\x44\x75\x8b\xd1\x28\x50\xdd\x7d\xac\xee\x28\x2a\x76\x5d\x98\x76\xeb\xb2\x92\x53\x4e\x98\xfd\xca\x63\xf5\xd0\x4d\x51\x5c\x34\x67\x26\x19\x66\x78\x83\x0c\x50\xa0\x6f\xe5\x64\x18\x0d\x46\xb8\x7c\x41\x22\x7e\x2e\xae\x54\xe2\x54\xb7\x57\xb1\xe4\x34\xea\x29\xe6\x7c\x3e\xd7\x61\x2c\x3f\xbf\x16\xf7\xec\x74\x71\x6b\xc6\xd2\xec\xfc\xdd\xbb\xfd\x62\x97\xcb\xe5\x52\x93\xac\xb5\xd3\x1a\xec\x2b\xe8\x36\x17\x77\xf6\x87\x36\xc4\xf5\xfc\x2a\xa5\x54\x58\xdb\x6c\x76\x8b\xdf\x75\xb4\x6e\x4e\x50\x7f\xe9\xcd\x56\xa1\xa6\x44\x4b\xab\x6e\x63\xe2\x2c\xcd\xd5\x75\xe1\x37\xc6\x65\xf0\x43\xe2\x6d\xc8\x68\xaa\xca\x2a\xd5\x8c\x86\xe5\xb8\x59\x13\x00\xbe\x77\x1d\xd9\x2a\x94\x75\x41\xb2\x5e\x6b\x09\x6b\x57\xa0\x6a\x40\xfd\xee\x7c\x6d\x40\xb3\xb5\x5a\xb1\x17\xa1\x92\xd7\x96\xe6\xe8\x24\xe9\x13\xf5\x77\x79\x69\xad\xb5\x07\xc0\x77\xb7\x84\xcd\x8d\x41\x9a\xe2\x24\x6c\x89\x1c\x1c\x39\xce\x77\x9c\xc6\x20\x7d\xad\x43\x62\x28\xf8\x0d\xc8\x8c\x9c\xbd\xa3\x38\x1e\x6f\x06\x47\x7b\x8d\x14\x89\xf0\xf9\xcc\xac\xe7\xe1\x96\xb9\x5a\x0d\x60\x99\x7b\x8d\xc7\xe2\x6d\xf5\xaf\x0a\xb4\x86\x6b\x3c\x96\xe1\xe1\xdd\xbe\xc1\xe1\x9d\x25\x00\xd4\x12\xba\x45\x86\xa1\x74\xb0\x80\xd0\x41\x98\xa9\x90\x10\xd2\xfe\x17\x00\x00\xff\xff\x00\x05\xac\xdb\xe4\x44\x00\x00")

func templatesBaseTfBytes() ([]byte, error) {
	return bindataRead(
		_templatesBaseTf,
		"templates/base.tf",
	)
}

func templatesBaseTf() (*asset, error) {
	bytes, err := templatesBaseTfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "templates/base.tf", size: 17636, mode: os.FileMode(480), modTime: time.Unix(1515634241, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _templatesCf_dnsTf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xb4\x94\xc1\x6a\xe3\x30\x10\x86\xef\x7e\x8a\x41\xec\x69\x21\x26\x10\xf6\x98\x43\x58\xf6\xb8\x79\x81\x65\x11\xb2\x34\xb5\x55\x64\x49\x68\x24\xa7\x69\xf0\xbb\x17\x59\x2e\x4d\x4a\x5b\x1c\x9a\xdc\x6c\x31\xf3\xff\xff\x37\x83\x34\x88\xa0\x45\x63\x10\x18\x1d\x29\x62\xcf\x95\xeb\x85\xb6\x0c\x4e\x15\x40\x3c\x7a\x84\x2d\x30\x8a\x41\xdb\x96\x55\x63\x55\x05\x24\x97\x82\x44\x60\xe2\x40\x3c\xb8\x14\xf1\xd7\x86\x3f\x3b\x8b\x0c\x18\xda\x81\x2b\x4b\xf3\x6f\x56\xb0\xa2\x9f\x14\x7e\x9c\x06\x11\xea\x0b\x8b\x91\x55\xd9\x42\xb4\x34\x55\x02\xec\x2f\x6a\xb3\x96\x56\xe3\xaa\x73\x14\x51\xad\x26\xc9\x0a\x60\xcc\x21\x5c\x8a\x3e\xc5\x4b\x3f\x9e\xad\x38\x61\x18\x30\x50\x31\x1f\x84\x49\xb3\xe2\xfb\xb0\xf5\x79\x6b\x7d\xde\x3a\x7e\x81\x19\x50\xba\xa0\x18\xb0\x83\x36\x4a\x8a\xa0\xb2\x44\xf1\x9a\x22\x68\xb5\xc4\x4d\xab\x91\xbd\x8e\x06\x20\x77\xfc\xac\x3f\x9e\xcf\xbc\x81\x52\xf4\x7b\xbf\xfb\xfb\x67\x3a\x8b\x06\xca\xd9\x66\xbd\xce\x33\x2c\xb1\x08\xb6\xf0\x6f\x36\x47\xd3\xd4\xf2\xa1\x64\x08\xdc\x34\x75\x36\xcf\x86\x23\xfb\xbf\x00\x8f\xa8\xbb\x01\x15\x51\x77\x27\x2e\xa2\xee\x7a\xa8\xc6\xdd\x84\x2a\xcb\x2c\xc1\xda\x2d\x45\xd2\xbe\x7e\x4c\xbd\x6f\xdc\xd3\xf4\xed\x53\x63\xb4\xe4\xda\x2f\xa3\x8a\xd2\xdf\x00\x2a\x4a\x7f\xa7\x55\x45\xe9\xaf\x5f\x95\x26\x57\xa0\xa4\x4b\x36\xbe\xbd\x09\x9a\x9c\x11\x51\x3b\xcb\x09\xdb\x1e\x6d\xa4\xf2\x88\x7c\xf3\xf2\x69\x72\x2b\xc2\xf6\x1e\x13\xd0\xe4\x3e\xbd\x85\x2f\x01\x00\x00\xff\xff\x9c\x64\x07\x0b\x7b\x05\x00\x00")

func templatesCf_dnsTfBytes() ([]byte, error) {
	return bindataRead(
		_templatesCf_dnsTf,
		"templates/cf_dns.tf",
	)
}

func templatesCf_dnsTf() (*asset, error) {
	bytes, err := templatesCf_dnsTfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "templates/cf_dns.tf", size: 1403, mode: os.FileMode(480), modTime: time.Unix(1513729670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _templatesCf_lbTf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xd4\xdc\x5b\x8f\x9b\x46\x14\x07\xf0\x77\x7f\x0a\x64\xf5\xa9\xd2\xba\x1e\xee\x54\xda\xa7\x95\xaa\xf6\xa5\x8a\x9a\xbc\x55\x15\xc2\x78\xd6\x46\x61\xc1\x9a\x19\x6f\x95\x46\xfe\xee\x15\x37\x5f\x62\x0c\xf6\xdf\xff\x24\x9b\xcd\x53\x80\x33\x73\x18\x0e\x3f\x8e\xad\x65\x95\xd4\xe5\x56\xa5\xd2\x9a\x26\xff\xea\x58\xcb\x74\xab\x32\xf3\x29\x5e\xa9\x72\xbb\x99\x5a\xd3\xf4\x39\xd6\x7a\x1d\xe7\x8b\xb3\x5d\x9f\x27\x96\x55\x24\x2f\xd2\x6a\x7f\x1e\xad\xe9\x4f\x9f\x5f\x13\x35\x93\xc5\x6b\x9c\x2d\x77\x0f\xe9\xf3\x83\xd6\xeb\x87\x7c\xf1\xd0\x85\x3e\x34\xa1\x13\xcb\x5a\x4a\x9d\xaa\x6c\x63\xb2\xb2\xa8\x02\x9f\x7e\xb3\xde\xbf\xff\xbd\xda\xf1\xba\x49\xe3\x6c\x79\x34\x62\x5e\xa6\x49\x3e\x6b\x36\xef\xa6\x93\x89\x65\x65\xc5\x4a\x49\xad\xeb\x04\x2c\x2b\xcd\x96\x2a\x5e\xe4\x65\xfa\x51\x5b\x8f\xd6\xdf\xd3\xf9\xac\xfe\xf7\xcb\x7c\xfa\x4f\xbd\x7f\xa3\x4a\x53\xa6\x65\xde\x0e\x68\xd2\x7a\x7e\xcb\x7a\x56\xe5\x4b\xbc\x29\x95\xa9\xb7\xdb\xb6\x6d\xd7\x9b\x4d\xd9\x6d\x3c\xda\xbc\xab\xa6\x95\xc7\xb3\x9e\x46\xcf\x7b\x42\xe7\x7d\xb3\x3f\x88\xe9\x15\x49\xd7\xd3\x99\x64\xd5\x4d\xf6\x67\xb5\xca\x37\x2d\x6f\x3d\x42\x9e\x3d\xcb\xf4\x53\x9a\xcb\x76\x98\x6c\x55\x94\x4a\xc6\xe9\x3a\x29\x56\xb2\x99\xb7\xba\x7e\xed\x94\xbb\xc9\xa4\xdc\x9a\xcd\xd6\x8c\x5d\xf3\xd7\x24\xdf\xb6\xe9\x9c\x57\xcc\xec\x52\xec\xac\xbe\x7a\xbb\xc9\xe4\xea\x7a\xcb\x0a\x23\x55\x91\xe4\xf7\x14\x5e\x37\xc6\xb5\x15\x68\xfd\xd1\x06\x40\xa5\x78\x9a\x68\xb3\xc2\xb7\x2f\xd2\x79\xd9\x0e\x95\xae\x75\xb9\x7c\x7f\xa4\x12\x1e\xb8\x50\xac\x5a\x1e\xac\xa7\x6b\x8b\xfa\xc2\x20\x17\xaa\x5b\xe6\x8b\xe3\x92\x3e\x2f\xdd\xd3\x9f\xfd\xfa\xe8\x75\xa9\x4c\x7c\xb6\x4a\xd5\x6a\xa4\xaa\xd4\x3a\xfe\xaf\x2c\x64\x9c\x97\xc9\x32\x5e\x24\x79\x52\xa4\x59\xb1\xb2\x1e\x2d\xa3\xb6\xb2\x5a\xac\xb5\x4c\x72\xb3\x8e\xd3\xb5\x4c\x3f\xb6\xeb\xd5\x6c\xfa\x14\x9b\xb5\x92\x7a\x5d\xe6\xcb\x7a\x3a\xaf\xde\xb7\x2d\xce\xf7\x3e\x5a\x4d\x3d\xd5\xe7\xfb\x9a\xe4\xa7\x69\xfa\x4d\xb1\x24\x6a\x25\xcd\xd9\x29\x7c\x78\x7a\xf7\x6b\x55\x74\x4d\x99\x98\xec\x45\x96\x5b\xf3\xc5\x41\xf6\xe1\xba\x6a\x23\x0b\xa9\xba\xcb\x5a\x68\x93\x14\xa9\xec\x31\xf8\x78\x67\x57\x91\xc7\x37\x45\xbe\x38\xad\xfc\x93\xd0\x6a\xe7\xe9\x0d\x75\x08\xad\xf3\xe0\xdd\xba\x7a\xbb\x28\xa4\xd1\x47\x59\xec\x47\xaa\xf7\xcc\xaa\xd0\xe6\x98\xd9\xcf\x6d\x54\x6f\xbd\xd6\xf5\xdc\x57\x9c\x32\x5f\x1c\xd2\x98\x55\x87\x35\xb5\x77\x3e\xc4\x56\xe5\x57\x8c\xb0\x2c\x74\x7c\x18\x65\xdc\x67\x55\x6e\x8d\x54\x68\x4b\xd0\x44\x5f\xdb\x15\xfc\x55\x1f\xfd\x1d\x1b\x83\xb0\x0f\xc6\x7a\xe3\xee\x6b\x4d\xe9\xba\x4e\xcf\x9c\xcd\xd6\xaf\x38\xe9\x85\x59\x0f\xd3\xbe\xc1\xa7\xc7\x50\x31\xdd\xfd\xdc\x18\xae\xf3\xd1\x27\xc6\xa5\xf0\x1b\x3a\xa1\xc3\x10\x77\x35\x43\x87\x55\xba\xa9\x1f\x6a\xee\xbd\x6f\xd7\x12\x0d\x2e\x18\xd2\x15\xf5\xdc\xbb\x5f\xde\xbf\x6f\xba\xa6\xbf\x66\x53\x74\x65\x69\xdd\x50\xe5\x60\x6b\xb4\x1f\x00\xef\x8e\xf6\x2b\xf6\x66\x1a\x24\x61\x8f\x75\x48\xe1\x9c\xd5\x1f\xb5\x55\xde\xdb\x1d\xad\x8d\x19\x68\x8f\xda\xc8\xde\xe6\xa8\x8b\xbc\x2e\x8b\xa1\x34\xc6\xf2\x38\x7a\xe2\x9d\x67\xd2\x05\xeb\x26\x5a\xeb\x3c\x4e\xa5\x32\xd9\x73\x96\x26\x46\x56\x16\xed\x6b\x33\x4b\x5e\x62\x2d\xd5\xab\x54\xc7\x87\x54\xed\x56\xf5\xdf\x59\xa2\x8a\x1d\xef\x84\x06\xda\xce\xe3\x87\x69\xff\x09\x69\x9d\x73\x4f\x87\xaa\xec\xfd\x0d\xec\x61\x8a\xb1\x1e\x76\x7f\x64\x7f\x1b\x7b\x18\x68\xa4\x93\x3d\x8c\x73\x6b\x33\x6b\xd2\x0d\xda\xc9\x9a\x74\x73\x6d\x1b\xfb\xe1\xe9\xdd\x77\xec\x61\xc5\xdc\x76\x7b\x1e\x66\x42\xd8\x6f\xb9\xb7\xbb\xb8\xbc\x77\x3f\xfb\x06\xae\xf9\xe8\xf3\xae\x37\xf6\x86\x96\xae\x8d\xbf\xab\x9f\x6b\x57\xe6\xa6\x66\xee\xc3\xd3\xbb\x6f\xd7\xc9\x5d\x5e\x24\xa4\x8d\xeb\x2d\xdf\xf3\x12\x7e\x2b\xe9\xfe\x98\x5d\xe7\x78\x4d\xb1\x6e\xbb\xfb\xfa\xcd\xe1\x41\xc6\x9a\xcd\x26\x1a\xef\x34\x9b\x55\xa2\xb7\x99\xfe\x40\x9b\xe9\x0c\xb4\x99\xde\x7d\x5d\xa6\x73\x43\x97\xb9\xbf\x09\x6f\xff\x16\x6e\x1f\x3a\xfa\x2d\xdc\x75\x79\x78\x78\x1e\x1e\x33\x0f\x1f\xcf\xc3\x67\xe6\x11\xe0\x79\x04\xcc\x3c\x42\x3c\x8f\x90\x99\x47\x84\xe7\x11\x11\xf3\x70\x06\x3e\x97\x8d\xe4\xe1\x0c\x7c\x30\xbb\x3d\x0f\x81\xe7\x21\x98\x79\xa0\xdf\xe2\xef\x43\x49\x79\x38\x78\x1e\x97\x3e\xd5\x41\x79\xe0\x9e\x3a\x4c\x4f\x1d\xdc\x53\x87\xe9\xa9\x83\x7b\xea\x30\x3d\x75\x70\x4f\x1d\xa6\xa7\x0e\xee\xa9\xc3\xf4\xd4\xc1\x3d\x75\x98\x9e\xba\xb8\xa7\x2e\xd3\x53\x17\xf7\xd4\x65\x7a\xea\xe2\x9e\xba\x4c\x4f\x5d\xdc\xd3\x8b\xdf\x92\x41\x79\xe0\x9e\xba\x4c\x4f\x5d\xdc\x53\x97\xe9\xa9\x8b\x7b\xea\x32\x3d\x75\x71\x4f\x5d\xa6\xa7\x2e\xee\xa9\xcb\xf4\xd4\xc5\x3d\x75\x99\x9e\x7a\xb8\xa7\x1e\xd3\x53\x0f\xf7\xd4\x63\x7a\xea\xe1\x9e\x7a\x4c\x4f\x3d\xdc\x53\x8f\xe9\xa9\x87\x7b\xea\x31\x3d\xf5\x70\x4f\x3d\xa6\xa7\x1e\xee\xa9\xc7\xf4\xd4\xc3\x3d\xf5\x98\x9e\x7a\xb8\xa7\x1e\xd3\x53\x0f\xf7\xd4\x63\x7a\xea\xe3\x9e\xfa\x4c\x4f\x7d\xdc\x53\x9f\xe9\xa9\x8f\x7b\xea\x33\x3d\xf5\x71\x4f\x7d\xa6\xa7\x3e\xee\xa9\xcf\xf4\xd4\xc7\x3d\xf5\x99\x9e\xfa\xb8\xa7\x3e\xd3\x53\x1f\xf7\xd4\x67\x7a\xea\xe3\x9e\xfa\x4c\x4f\x7d\xdc\x53\x9f\xe9\x69\x80\x7b\x1a\x30\x3d\x0d\x70\x4f\x03\xa6\xa7\x01\xee\x69\xc0\xf4\x34\xc0\x3d\x0d\x98\x9e\x06\xb8\xa7\x01\xd3\xd3\x00\xf7\x34\x60\x7a\x1a\xe0\x9e\x06\x4c\x4f\x03\xdc\xd3\x80\xe9\x69\x80\x7b\x1a\x30\x3d\x0d\x70\x4f\x03\xa6\xa7\x43\xbf\x27\x38\x92\xc7\xd0\x2f\x0a\xde\x9e\x07\xee\x69\xc8\xf4\x34\xc4\x3d\x0d\x99\x9e\x86\xb8\xa7\x21\xd3\xd3\x10\xf7\x34\x64\x7a\x1a\xe2\x9e\x86\x4c\x4f\x43\xdc\xd3\x90\xe9\x69\x88\x7b\x1a\x32\x3d\x0d\x71\x4f\x43\xa6\xa7\x21\xee\x69\xc8\xf4\x34\xc2\x3d\x8d\x98\x9e\x46\xb8\xa7\x11\xd3\xd3\x08\xf7\x34\x62\x7a\x1a\xe1\x9e\x46\x4c\x4f\x23\xdc\xd3\x88\xe9\x69\x84\x7b\x1a\x31\x3d\x8d\x70\x4f\x23\xa6\xa7\x11\xee\x69\xc4\xf4\x34\xc2\x3d\x8d\x98\x9e\x46\xb8\xa7\x11\xd1\x53\x31\x87\x3d\xed\x42\x49\x79\xc0\x9e\x76\xa1\xa4\x3c\x60\x4f\xbb\x50\x52\x1e\xb0\xa7\x5d\x28\x29\x0f\xd8\xd3\x2e\x94\x94\x07\xec\x69\x17\x4a\xca\x03\xf6\xb4\x0b\x25\xe5\x01\x7b\xda\x85\x92\xf2\x80\x3d\xed\x42\x49\x79\xc0\x9e\x76\xa1\x9c\x3c\x04\xee\xa9\x60\x7a\x2a\x70\x4f\x05\xd3\x53\x81\x7b\x2a\x98\x9e\x0a\xdc\x53\xc1\xf4\x54\xe0\x9e\x0a\xa6\xa7\x02\xf7\x54\x30\x3d\x15\xb8\xa7\x82\xe9\xa9\xc0\x3d\x15\x4c\x4f\x05\xee\xa9\x60\x7a\x2a\x70\x4f\x05\xd3\x53\x1b\xf7\xd4\x66\x7a\x6a\xe3\x9e\xda\x4c\x4f\xe1\xbf\xca\xb3\x0f\x25\xe5\x81\x7b\x6a\x5f\xe9\x29\xef\x65\xc2\xfb\x5f\xae\x6e\xc7\x1f\x7b\xb3\xba\x39\xac\xff\xb5\xea\x76\x88\x91\x77\xaa\xdb\x11\x4e\x5e\xa8\xfe\x3f\x00\x00\xff\xff\x59\xb1\x38\x54\x2d\x50\x00\x00")

func templatesCf_lbTfBytes() ([]byte, error) {
	return bindataRead(
		_templatesCf_lbTf,
		"templates/cf_lb.tf",
	)
}

func templatesCf_lbTf() (*asset, error) {
	bytes, err := templatesCf_lbTfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "templates/cf_lb.tf", size: 20525, mode: os.FileMode(480), modTime: time.Unix(1515632091, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _templatesConcourse_lbTf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xd4\x97\xbd\x6e\xdb\x30\x10\xc7\x77\x3d\x05\x21\x74\x2a\x6a\x55\xb1\x3d\x78\xc9\x94\xa9\x4b\xd1\xa1\x5b\x60\x10\x14\x75\xb6\x84\x30\xa4\x70\x24\x1d\x18\x81\xdf\xbd\x20\x29\xc9\xfa\xb0\x13\x39\x0e\x8c\x26\x59\x0c\x1e\xef\x78\xf7\xfb\x1f\x79\x10\x82\x56\x16\x39\x90\x98\xbd\x68\xaa\x81\x5b\x2c\xcd\x9e\x6e\x51\xd9\x2a\x26\x31\x57\x92\x2b\x8b\x1a\xa8\xc8\x68\x29\x0d\xa0\x64\x62\xb4\xed\x35\x22\x44\xb2\x67\x20\xf5\xdf\x3d\x89\xbf\xbd\xee\x18\x26\x20\x77\xb4\xcc\x0f\xb3\x36\xcc\x4c\x64\xb3\x26\xcc\xac\x09\x33\x0b\x61\x22\x42\x72\xd0\x1c\xcb\xca\x94\x4a\xba\x20\x0f\x8d\x1b\xf9\x55\xfb\xb8\x4d\xbb\x8a\xd3\x32\xef\x9c\x24\x14\x67\x22\x09\xcb\x87\x38\x8a\x08\x31\x6c\xab\x7d\x56\x84\xfc\x76\x79\x7d\x38\xa1\x83\x8b\x26\xca\x0d\xf0\x3d\x17\x50\x87\x2c\xb7\x52\x21\x50\x5e\x30\xb9\x05\x4d\xee\xc9\x63\xec\xaa\x8f\xd7\xde\xe1\x10\x45\x6f\x41\xa5\x68\x05\x9c\x25\xbb\x4a\x03\x4d\xb3\xaf\xba\x34\x4b\xb9\x45\xd0\xda\x65\x54\xa1\x32\x8a\x2b\x51\x5b\x0c\xf7\x79\x6e\x50\x3d\xd3\x4a\xa1\xf1\xab\xab\xd4\x85\x50\xcd\x42\xbb\xc4\xcb\x1c\x69\x26\x14\x7f\x0a\x59\xa7\x89\xff\xff\x99\xc6\x6b\x57\xe7\x20\xd1\x32\x0f\xdc\xc6\x35\x24\x53\xda\x22\xf1\x62\x5c\x45\x63\x3e\x9f\xcf\x3f\x83\x87\x8b\x33\x22\x52\x2f\x7e\x35\x26\xcb\xe5\xe2\x33\x90\x2c\x97\x8b\x11\x91\xb0\xf6\xd5\x80\x40\xa8\xfb\x14\x13\x38\x87\x64\x76\x37\x26\x32\xbe\x33\xff\xcb\x95\x11\xd9\xa0\xf8\xf1\x8b\x3b\x7c\x78\x75\xa1\xd0\xd0\x53\xaf\x9d\x2b\x5c\x28\x96\xd3\x8c\x09\x26\x39\x20\xf5\xd0\xee\x49\x2c\xc1\xbc\x28\x7c\x72\x1b\xb4\xcd\x24\x18\xdd\x0f\xfd\xd8\x14\xe6\x8d\x89\xc8\xea\x5f\x3a\xf9\xee\x13\x5f\x9f\xca\x9c\x8a\x52\x1b\x90\x80\x43\xfd\x9a\x97\xae\x9f\x0b\x43\x79\x24\x28\xb2\x1e\xb5\x84\xa1\x3c\x0c\xc5\x6c\xeb\xfe\xfb\xf0\xc7\xdb\x1a\xf9\x3a\xb6\x55\x1a\xf9\xd9\xb2\x61\x56\x18\xca\xb8\x1f\x2f\xe1\x29\xef\x36\x4c\x13\x69\xa3\xf0\x85\x61\x1e\x87\x0d\x0c\xb7\x60\x6a\x79\x07\xd9\xd1\xae\x31\x19\x54\xd7\x66\x7b\x62\x22\x0c\x5c\xcf\xa1\x69\x05\x7e\x4f\xd6\x55\xda\x2b\xbd\x7e\xed\x5b\x4c\x47\x3a\xed\xe8\x3c\x33\x37\x0b\x60\xc2\x14\x94\x17\xc0\x9f\x6a\x42\x61\x69\x4f\x4d\x81\xa0\x0b\x25\x82\xf7\x5d\xea\x8d\x56\x8e\xcd\xad\xd1\x37\xf9\x8e\x89\x3e\xde\x45\x30\x8e\x35\xec\xaa\x78\x9a\xd9\xb9\x56\x3a\x8e\x89\x1b\x34\x93\x1f\x1b\xb7\x6e\x27\x77\xe8\x15\x0d\x75\x04\x34\xb9\xa5\xbc\x4b\xbf\xa9\xea\x81\x79\x69\x5b\x5d\xa2\x64\x3b\xdc\x6e\x20\xa4\x9b\x76\xb7\xd6\x71\xb9\x5c\x5c\x21\x63\x4b\x67\xb2\x8a\xce\xa3\x2f\x62\x98\xf1\x1f\xd0\x50\x59\x53\x59\x73\xc9\x17\xc1\x8e\x09\x0b\xd7\xcd\x43\x57\xe8\x1b\xc7\x77\x61\xe9\xfe\xa1\x8f\x13\x5f\xe9\x70\xc2\x8f\xc9\xea\x5d\xb2\xdf\xdf\xda\xe0\xb0\x3e\x5b\x83\xff\x72\x38\xc5\x6b\xd8\xe7\xef\xb0\xb0\x28\x26\x85\xc9\xa5\xa6\x6d\xa8\x7f\x01\x00\x00\xff\xff\xaa\x1a\xd6\xc4\xfe\x0d\x00\x00")

func templatesConcourse_lbTfBytes() ([]byte, error) {
	return bindataRead(
		_templatesConcourse_lbTf,
		"templates/concourse_lb.tf",
	)
}

func templatesConcourse_lbTf() (*asset, error) {
	bytes, err := templatesConcourse_lbTfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "templates/concourse_lb.tf", size: 3582, mode: os.FileMode(480), modTime: time.Unix(1515632091, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _templatesIso_segmentsTf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xe4\x58\xdd\x6f\xdb\x36\x10\x7f\xcf\x5f\x71\x10\xfa\x50\xb7\x8a\x20\x7f\x75\x4a\x81\x6c\x18\xda\xc7\xa2\x2b\xd0\x6e\x2f\x45\x41\x50\x14\x2d\x13\xa5\x49\x81\xa4\xbc\x25\x41\xfe\xf7\x81\xa4\xa2\xe8\xcb\xf2\x47\xdc\x2d\xc3\xfc\x60\xd8\x24\x8f\xf7\xbb\xbb\x1f\xef\x8e\xdc\x62\xc5\x70\xca\x29\x04\x4c\x4b\x8e\x0d\x93\x02\x69\x9a\x6f\xa8\x30\x3a\x80\xbb\x0b\x00\x73\x53\x50\xa8\x3e\xd7\x10\x68\xa3\x98\xc8\x83\x0b\x80\x8c\xae\x70\xc9\xcd\xc3\x44\xec\xc7\x34\x51\xac\xb0\xdb\xd8\xb1\xdf\xdc\x2f\xcc\xf9\x0d\x10\x45\xb1\xa1\x80\x81\x4b\x9c\x41\x8a\x39\x16\x84\x2a\xc0\x22\x83\xf7\x1f\x3f\x03\x15\x46\x31\xaa\x61\x25\x15\x60\xd0\x4c\xe4\x9c\x42\x0d\x09\x2a\x48\x11\xfc\x81\x39\xcb\x60\x8b\x79\x49\x35\x60\x45\x21\x06\xa9\x60\x1a\x05\x17\xf7\x17\x17\x2d\x63\x90\x91\x28\x95\x7a\x8d\x0a\xa9\xba\xb6\x5c\x43\xc0\x99\x36\x4d\x2b\xae\xe1\xeb\x6c\x16\xc2\x9b\xe4\x4d\x12\xc2\x6c\xb9\x5c\x86\xb0\x98\xd9\x91\xd9\x72\xb6\x8c\xbf\x0d\x6e\xaf\xd7\x58\xd1\x0c\x19\x52\x1c\xae\xe4\x2a\xbe\x8a\x43\xb8\x8a\xaf\xa6\x21\x24\x71\x32\x0b\x21\x99\xc7\xb1\xfb\xb6\x23\x49\x72\x15\x42\xb2\x58\xcc\x43\x98\xc7\x76\x7c\xe1\x7e\x27\x71\x12\x87\x30\x5f\x2c\x7f\xb2\xb2\xb3\xb9\xfb\x9e\x79\x88\xa3\xd8\xca\xec\x08\x6c\x15\x86\x79\x6c\x51\xbd\x89\xbd\xd5\x5c\x12\xcc\xb5\x93\xb6\x5b\xe3\x5b\x44\x64\x29\xec\xfa\xe0\xc5\xdd\x16\xab\xa8\x4f\x1c\xf8\x19\x62\xf8\x05\x38\x15\xb9\x59\xbf\xb4\x6b\xf0\x16\x33\x8e\x53\xc6\x99\xb9\x41\xb7\x52\x50\x3d\x81\xb7\x10\xdf\xbb\xb0\x29\xaa\x65\xa9\x08\x85\x00\xff\xa9\x91\x2e\x53\x41\x4d\xe0\x0d\xf1\x7f\x2a\xf0\x5e\x6f\xf3\xe3\x30\x38\x80\x51\x13\xdb\xbd\xb5\x6b\x5b\x10\xc4\xb2\x1d\xab\xfd\xa4\x5b\x47\x58\xa6\x50\xca\x25\xf9\xde\x5a\x67\x87\xbd\x76\x67\x80\x15\xb0\x43\x21\x2c\x42\x0f\x24\x62\x22\xa3\x7f\xc1\xeb\x7d\x66\xbe\x86\xe9\xc4\x29\xea\x4d\x7a\x45\x94\x53\xeb\xb4\x1d\xf2\x2d\x65\x76\x1f\x1b\x44\x9c\xfb\x78\x00\x7c\xc4\x1b\xfa\x18\x09\x2a\xb6\xd6\xaa\x4b\xa6\xe5\xa5\xc7\xfe\xe2\xae\x21\xee\x50\xdc\xf7\x3d\xae\x64\x69\x28\x32\x96\x3e\x08\x6b\x2d\x09\x73\xe1\x0c\x20\xf0\x33\xfb\x02\x31\x16\x05\x2f\x57\x07\xa2\x65\xf1\x63\xb4\xa3\x86\x8a\xe8\x55\xc4\xb2\x9e\xd9\x00\x4d\x94\x2c\xf3\x3b\x75\xd0\x47\x4c\x18\xaa\x04\xe6\xed\xc1\x6c\x88\x66\x94\xa7\x15\xc7\xdc\x5a\x85\xec\xff\x47\xe3\x46\xd8\xed\x83\x20\xac\xe7\x07\x3f\xb5\xa8\x5e\x4b\x65\x50\x33\x28\x5e\xd5\x25\x4f\x1d\xf1\x94\xd4\xda\x45\x19\xd9\x9c\x88\x7c\x4e\x64\x22\x87\x6b\x30\xaa\xa4\x56\xcb\x9a\x62\x6e\xd6\x88\xac\x29\xf9\x5e\x85\xdc\x0f\xdd\x20\xb3\x56\x54\xaf\x25\xcf\x9c\xca\xa5\x9b\x2b\x45\x7f\xf6\x1a\x66\x6e\xce\xf9\x66\x8b\x79\x1b\xea\xd4\x4f\x1a\xac\x72\x6a\x7a\x76\x7c\x79\xf7\xe9\x6d\xe2\x12\x3b\x80\x61\x1b\x2a\xcb\xee\xf9\x9b\x39\x4a\x5d\x00\xd8\x74\x42\x05\x55\x15\x4a\x26\xb4\xb1\x19\xde\x25\x9f\x6a\x6d\x12\x77\xa6\x94\x34\x92\x48\x6e\x35\xad\x8d\x29\xbc\x1e\x9e\x3e\xca\x40\x5b\xd2\x4e\x3d\xc8\xd4\x18\x1f\x24\x0f\x43\x31\x06\x63\x1f\x0e\xb8\x86\xc5\x62\xbe\x03\xc9\x83\xb0\xf6\xd2\x5a\x73\x44\xa8\x32\x6c\xc5\x08\x36\x6d\xc6\x32\xbc\x41\x9a\xaa\x2d\x55\xcd\x25\x11\x4f\xdd\xdf\x08\x2b\x71\x7f\x3e\x83\x0c\x19\xb7\x67\xd4\x20\xad\xf9\x79\xcd\xd1\x94\x94\xca\x26\xb7\x5c\xc9\xb2\xd0\xb6\xe8\x54\xbb\xb4\x67\x22\xb2\x7a\x3c\x97\xdd\x39\x7b\xa0\xbf\xd5\xb9\x45\x37\xcc\xa9\x37\xf3\x59\xc5\x8a\x36\x92\x8a\x95\xea\x97\x9b\xd6\xde\x0f\x65\xa7\x33\x78\x7c\x5e\x18\xce\xc9\x79\xa3\x30\x0d\x55\xa3\x7e\x07\xf5\x49\xb1\xad\xed\x9b\x7a\xad\xd0\x11\x95\xa0\x32\xe6\xd2\x1b\x33\x5c\x03\x86\xdd\xe0\x7b\x88\x1f\xe5\x0d\xb7\xfb\x29\x4e\xf9\xec\x24\xfb\x3e\xd1\x47\x38\xa5\x52\x7e\xbc\x6f\x90\x2a\x39\x0d\x86\xfa\xe5\xba\xe3\xf4\x2b\x0e\x72\x13\xbc\x6a\xf6\x0f\xbd\xb6\x75\x32\x68\xff\x97\x77\x9f\xc0\x28\xbc\x5a\x31\x02\x2b\x25\x37\xe0\xc9\x05\x46\x82\x15\x0d\xfa\x27\xad\xd1\x09\xd5\xe7\xb6\x73\xaa\x9c\xd2\x81\x93\xd6\xb9\x02\x74\x4b\x04\x13\xb9\xa2\xda\x65\xbd\x6e\x02\x69\x2e\xab\xd2\x90\x91\xbd\x24\xd4\x40\xd5\x6c\x85\x7a\xae\x18\x68\x09\xac\xed\x83\xfb\x9d\xb4\x9b\x0f\x79\x37\xda\xcd\x4c\xd7\xf5\x4e\x2f\x53\xec\xe8\x35\x8e\x21\x50\xe3\x4e\xf1\x54\x1a\x75\xaf\x27\x47\x93\xa9\x73\x4a\x4f\x61\xd5\xce\x34\xf2\x0c\xb8\xd5\xf5\xcf\x39\x18\x76\xc0\x9e\xcf\x8a\x67\xf6\x7e\x78\x26\x9e\xd5\x57\xcd\x61\x9e\xfd\xfe\xfe\xbf\xce\xb3\x32\x7b\x12\xcf\x6a\xff\x9c\x91\x67\x63\x7b\x3e\x0f\x9e\xb9\x94\x8b\x39\x47\x55\xec\x8f\x61\xdb\x20\x8f\x7e\xfd\xf0\x61\x6f\xf1\xcb\x68\x41\x45\xa6\x91\x14\x3d\x77\x7e\x1d\xb0\x60\xa8\xf6\xf9\x0e\xf3\x79\x15\xd1\xcb\xe9\x1e\xae\xc4\xe3\xf4\x8c\xff\x05\x56\x54\x44\xcd\x18\xcd\x25\x4a\x53\xc7\x09\x1f\x69\x9a\x21\x42\x39\xd7\x4f\x66\x44\xaf\x82\x79\x9d\xe0\x74\x42\x9a\xea\x3a\xc7\xe4\x27\xb1\x63\xe0\x46\x70\x12\x39\x76\x79\xf2\x9c\x45\x70\x84\x1c\xd3\x24\x9e\x8e\xf3\xa3\x5a\x71\x1a\x45\x76\x27\xdf\x03\x99\x22\xb0\xf9\x01\xe4\xe8\xa5\x0b\x81\x4d\xb3\xec\x9c\x58\x6f\x2c\xd8\xff\xcd\x39\x97\xa5\x29\x4a\x03\x01\x59\xa1\xd6\x83\x19\xb2\xd7\x3b\x1f\x1c\xf7\x22\xdf\xae\x56\x44\x0a\x82\xfd\x2b\x1f\xe5\x69\xd4\x92\x8c\x5e\x45\x56\x36\x74\xef\x1b\x2f\x83\x60\x32\x09\x21\x9e\xb4\xb5\xf5\x01\x21\x96\x1d\xa2\x6d\xbf\x61\xfe\x89\x71\x8f\x6e\x7c\x8b\xea\xd7\x4b\xb4\xc1\x45\xc1\x44\xde\x53\xef\xae\x99\xb7\xac\xd8\xe0\xe2\x65\xfb\xf1\xa1\xfd\xa4\xd9\x7b\xd9\xbd\x0f\x42\x18\x13\xb0\xbe\x9f\xd8\xfb\xe8\x08\x2e\xf7\x74\xfd\x8f\x23\x7b\x7c\x30\xdf\x85\x70\x30\x17\x3c\x21\x78\x83\xa9\x65\x57\x0c\xff\x0e\x00\x00\xff\xff\xe3\x14\x91\x63\xd2\x1a\x00\x00")

func templatesIso_segmentsTfBytes() ([]byte, error) {
	return bindataRead(
		_templatesIso_segmentsTf,
		"templates/iso_segments.tf",
	)
}

func templatesIso_segmentsTf() (*asset, error) {
	bytes, err := templatesIso_segmentsTfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "templates/iso_segments.tf", size: 6866, mode: os.FileMode(480), modTime: time.Unix(1515632091, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _templatesLb_subnetTf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\x93\x4d\x6e\xfb\x20\x10\xc5\xf7\x3e\xc5\x08\x65\xf1\xff\x48\x68\xd4\x55\x37\xb9\x42\x2f\x50\x45\x08\xe3\xa9\x83\x4a\x20\x32\x63\xa7\xa9\xe5\xbb\x57\x80\x15\xdb\xb5\xd3\xa6\xc9\xc6\x02\xe6\xf7\xde\x63\x86\x0a\xbd\xab\x2b\x85\xc0\xe4\xd9\x0b\x5f\xe7\x16\x89\x01\x33\x79\xff\xed\x19\xb4\x19\x80\x72\xb5\x25\x18\xff\x76\xc0\x56\xad\x41\x5b\xd2\xe1\x4f\x23\x2b\x2e\x1b\xa9\x8d\xcc\xb5\xd1\x74\x11\x1f\xce\xa2\xff\xdb\xb1\x0c\xa0\x39\x29\xa1\x8b\x79\xa5\x53\xd2\xf0\xb4\x19\xcf\x29\x5d\x54\x22\x37\x4e\xbd\x4d\xce\x85\xe5\xe4\x24\xaa\x84\x82\xb0\xb4\x86\xa7\x75\x32\xc5\xb5\x2d\xf0\xfd\xff\x63\x52\x9b\xb9\x48\x14\x34\x78\x44\x4b\x37\x8c\x4e\x48\x81\x93\x01\x90\x2c\x7d\x4c\x0e\xf0\x2c\x8f\x3d\x26\x94\xa3\x6d\x82\xe5\x8d\xc9\x37\xc9\xd7\xaa\x1d\x55\x47\x13\x5d\x00\x18\xfd\x8a\xea\xa2\x0c\xf6\x14\x5d\x5a\x57\xa1\x50\x07\x69\x4b\xf4\xb0\x83\x17\x36\x44\x66\x6b\x60\x33\x5f\x6c\x1f\x59\x5d\x96\x4d\x9b\x54\xb9\x9a\x50\x90\xcc\x0d\xa6\x4e\x4d\x16\xda\xe1\xce\x97\x2e\x7a\x99\x76\x83\x53\xa0\x27\x6d\x25\x69\x67\xc5\xa8\x3f\x3b\x60\x5b\x1e\xff\x0f\xdb\x90\xb7\x94\x84\x67\x79\xf9\xd2\xe6\x24\x1f\x24\xb4\x25\xac\x2c\x92\xe8\x0f\x72\x5d\xf2\xbe\xeb\x23\xc9\x71\xf9\xb5\x74\xb4\xcf\xa7\x0e\xf9\x37\x71\x7a\xa0\xf4\xde\x29\x1d\xed\x33\x60\x69\xe7\x87\xc1\xbe\x77\xaa\x13\xe3\x6a\x79\x32\x64\xc3\x43\xe2\x83\x1a\xff\xc7\x75\x31\x1b\xb4\xd9\x05\xfc\x26\xb8\xab\xe9\x54\xd3\xe8\xad\x0a\x5d\xf4\xa9\x1a\x69\x6a\x8c\x33\x96\x68\xcb\x76\x3a\xb6\x5f\xe6\xcc\x53\xdf\x8f\x9d\xd5\xde\x54\x89\x4f\xfb\x7e\xf0\x30\x80\x89\xf8\x19\x00\x00\xff\xff\x0b\x56\xd0\x1c\xba\x04\x00\x00")

func templatesLb_subnetTfBytes() ([]byte, error) {
	return bindataRead(
		_templatesLb_subnetTf,
		"templates/lb_subnet.tf",
	)
}

func templatesLb_subnetTf() (*asset, error) {
	bytes, err := templatesLb_subnetTfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "templates/lb_subnet.tf", size: 1210, mode: os.FileMode(480), modTime: time.Unix(1515632091, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _templatesSsl_certificateTf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x8f\x41\x6e\xc3\x20\x14\x44\xf7\x9c\x62\x84\xba\xee\x0d\x72\x16\x84\xf1\xb8\xf9\x2a\x31\xd1\x87\xd0\xa2\x88\xbb\x57\xc6\x1b\xa7\x92\x37\x61\x83\x04\xf3\x46\x6f\xaa\x57\xf1\x53\x24\x6c\xce\xd1\x05\x6a\x91\x45\x82\x2f\xb4\x78\x1a\xa0\xb4\x3b\x71\x81\xcd\x45\x65\xfd\xb2\xa6\x1b\x73\x4a\xb8\x70\xf5\xb2\xbe\xc1\xdd\x55\xea\x76\x7f\xb3\x9d\xd2\xca\x9c\x1e\x1a\x08\xeb\x7f\xb2\x13\x7f\x73\x99\x5a\xa9\xaf\xca\x36\x4e\xe3\x61\xaf\x59\xfd\x6d\x2b\xe7\x22\xbf\x5b\xdb\xc7\xb3\x7a\xfd\xcc\xd7\xa4\xc5\x71\xad\x4e\xe6\x6e\x8d\x01\x8e\x2a\x53\x9a\x1b\x0e\xe1\x57\xd3\x6e\xff\xc5\xc7\xe2\xd3\xf8\xfe\x3d\xa0\xc3\x44\xec\xe7\x14\x3a\x44\x77\xbf\x28\x0b\x43\x0b\x91\x63\x14\x10\x94\x43\x95\x4b\x52\xba\x99\xb9\x68\x6a\xb8\xa0\xe8\x83\x06\xe8\xa6\x9b\xbf\x00\x00\x00\xff\xff\x4f\x95\x65\x5c\xd6\x01\x00\x00")

func templatesSsl_certificateTfBytes() ([]byte, error) {
	return bindataRead(
		_templatesSsl_certificateTf,
		"templates/ssl_certificate.tf",
	)
}

func templatesSsl_certificateTf() (*asset, error) {
	bytes, err := templatesSsl_certificateTfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "templates/ssl_certificate.tf", size: 470, mode: os.FileMode(480), modTime: time.Unix(1513729670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _templatesVpcTf = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x8c\x91\xd1\x6a\xe3\x30\x10\x45\xdf\xf5\x15\x17\xb1\x0f\xc9\xb2\x6b\xb2\xaf\x81\x6c\xff\xa0\xfd\x04\xa1\x48\x53\x67\x5a\x65\x64\x24\xd9\x6d\x08\xfe\xf7\x22\xd9\x69\x21\xf4\xa1\x03\x36\x66\xe6\x0e\xf7\x8c\xef\x64\x13\xdb\x63\x20\x68\x7a\xe7\x5c\x58\x7a\x33\x0d\xce\xb0\xd7\xb8\x2a\xa0\x5c\x06\xc2\x5a\x07\xe8\x5c\x12\x4b\xaf\x15\xe0\xe9\xd9\x8e\xa1\xdc\x06\x4b\x2b\xbb\xc4\x43\xe1\x28\xb5\xf5\xd4\xbe\x6c\x08\x17\x8c\x99\x60\x05\x37\x07\x4c\x83\xd3\x6a\x56\x2a\x44\x67\x43\x6e\x46\xd5\xd4\xc5\x51\x4a\x5d\xfd\x75\x0d\x24\x7d\x39\x6d\x26\x9b\xba\x3b\xae\x2d\xfe\x63\x87\x07\xec\xb0\xc7\xbf\x59\xaf\xab\xec\x57\x90\x9f\xac\x7e\x33\xc2\x1e\x2f\x91\x65\xa3\xa1\xff\xc0\xbe\xe5\xda\xee\xea\xf3\xbb\x63\xbf\x9d\x1b\x6d\xa2\x1c\xc7\xe4\x08\x7a\x15\x68\xe8\xf6\xae\xfc\x0b\xfb\x5d\x2d\x3c\xf5\xc8\xee\xf3\xbe\x86\xec\xd8\x27\x73\x0c\xd1\xbd\xde\xab\x2b\x5b\xd3\xb2\x4f\x4d\xca\x92\x8b\x15\x47\xa6\x90\x58\x71\x97\x9b\x74\x0d\xa0\x4a\x48\x6a\x82\xc6\x4b\x36\xa7\x98\x8b\xd8\x33\x65\x1c\x50\xd2\x48\xaa\x66\x68\xfb\xe5\x1f\x03\x8f\xf6\x4c\x5f\x3e\x24\x93\x61\x3f\xff\x6d\x71\x00\xb3\x9a\xd5\x47\x00\x00\x00\xff\xff\xe1\xdc\x0f\xba\x0f\x02\x00\x00")

func templatesVpcTfBytes() ([]byte, error) {
	return bindataRead(
		_templatesVpcTf,
		"templates/vpc.tf",
	)
}

func templatesVpcTf() (*asset, error) {
	bytes, err := templatesVpcTfBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "templates/vpc.tf", size: 527, mode: os.FileMode(480), modTime: time.Unix(1515632091, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"templates/base.tf": templatesBaseTf,
	"templates/cf_dns.tf": templatesCf_dnsTf,
	"templates/cf_lb.tf": templatesCf_lbTf,
	"templates/concourse_lb.tf": templatesConcourse_lbTf,
	"templates/iso_segments.tf": templatesIso_segmentsTf,
	"templates/lb_subnet.tf": templatesLb_subnetTf,
	"templates/ssl_certificate.tf": templatesSsl_certificateTf,
	"templates/vpc.tf": templatesVpcTf,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}
var _bintree = &bintree{nil, map[string]*bintree{
	"templates": &bintree{nil, map[string]*bintree{
		"base.tf": &bintree{templatesBaseTf, map[string]*bintree{}},
		"cf_dns.tf": &bintree{templatesCf_dnsTf, map[string]*bintree{}},
		"cf_lb.tf": &bintree{templatesCf_lbTf, map[string]*bintree{}},
		"concourse_lb.tf": &bintree{templatesConcourse_lbTf, map[string]*bintree{}},
		"iso_segments.tf": &bintree{templatesIso_segmentsTf, map[string]*bintree{}},
		"lb_subnet.tf": &bintree{templatesLb_subnetTf, map[string]*bintree{}},
		"ssl_certificate.tf": &bintree{templatesSsl_certificateTf, map[string]*bintree{}},
		"vpc.tf": &bintree{templatesVpcTf, map[string]*bintree{}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}

