package testhelpers

const (
	BBL_CERT = `-----BEGIN CERTIFICATE-----
MIIEKDCCAhCgAwIBAgIRAJfSYJAL+yXPCVNIIiTkBC4wDQYJKoZIhvcNAQELBQAw
ETEPMA0GA1UEAxMGYmJsLWNhMB4XDTE2MDUyNjIyMTM0MVoXDTE4MDUyNjIyMTM0
MVowGzEZMBcGA1UEAxMQYmJsLWludGVybWVkaWF0ZTCCASIwDQYJKoZIhvcNAQEB
BQADggEPADCCAQoCggEBAOhJUnBd86cOzMsENCRe1KH0Q9LETlbP/nxgkJTq8ngH
EG5Dybt71mdEek/QXqv+WWie1S25M2GBPJ2dGHjJLrmQ0zaT8u+Cv8JmSyLuPD5C
SSxQiDNqd/y4uSoaxNQUIZ1OW8uvXXtfJ7EUFSWID4T2fdPLxGPtP8x6HcHgKqbw
+58yyH5nGdMP6u2VWBd0Jds18Gp7HPtzixgXvwn7MfYPGMzwBf/hIf9HN9uxJ0Af
GlpoyL7t9xJpNBzYAT4OBE4e25kBa5lGW6dzjv0JqNhoyv0UIxKjyhWvfjRI767o
nPbGUTevC7BViBCkRQkWvL0LqaxcxOFkPBHPrZiWSWkCAwEAAaNxMG8wDgYDVR0P
AQH/BAQDAgO4MB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjAdBgNVHQ4E
FgQU6ls4yu3sDbmzx4tCg9ZPawKnE9owHwYDVR0jBBgwFoAU+GonMITrgSFO+Gsr
1t9KtOny2e0wDQYJKoZIhvcNAQELBQADggIBAHvGNQdF9/UITjSf+/rnh4c9m0/T
gBPWZRSLVkFxAA2ASK0fx+PWIb6tA4ZRJIfpHoswTZZuknor2LW5HZDpk2/HvYSv
kRDncsLh+kKwdzWPGgcweJcb6o+fejqd+6+S25G2TioXmCRZGk1eD0sNoGQJr7ku
qGDK0Ipw9mRD1Hwys6sfO5sjagHqm3uXB7ROLwDMikTzb12ACSZAjqTbcD2QoQJ/
WeZbE17du09qSkJOwQ54+4008N2twh0bw8RDz6ReKfyVEL4DeC0tcaiJBwGGASas
G8j3JsCqOHL0KITkSW588l52+kbkjFiu3rjIMcmDTKJWx49xvJf3W2AQFIFfJR13
0mQrcSNNEgvAgtVWvpbLs7ELzItVzFI/ABaH9Wxch9AiBdrPKwsmcCJoR+Qoh1zi
lGz0uE5Q/4mlZXziUAh/szTT1GVWOkm9VLxPMaxxpJkog3IGoZZxv/qlBflh51Og
HCvNgmKuQkWNXmoXhDtdFUq3DBrpbkXAJJ6+OFPJBqJUCW6B12VYF0r7dYECuNZG
ShXiCTbao7gejUPb7Degqz974m35UliEoO2cqeS0gpYtf3Vz8QrPKzypMkQROsMM
9KVvUbzNwqlEBTIr2getV/H6hjlTGyTRlKaFIvwlEPnX86tIuUnB1J5QOnhjs1i2
DT70fYFqOC3dAC0L
-----END CERTIFICATE-----`

	BBL_KEY = `-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEA6ElScF3zpw7MywQ0JF7UofRD0sROVs/+fGCQlOryeAcQbkPJ
u3vWZ0R6T9Beq/5ZaJ7VLbkzYYE8nZ0YeMkuuZDTNpPy74K/wmZLIu48PkJJLFCI
M2p3/Li5KhrE1BQhnU5by69de18nsRQVJYgPhPZ908vEY+0/zHodweAqpvD7nzLI
fmcZ0w/q7ZVYF3Ql2zXwansc+3OLGBe/Cfsx9g8YzPAF/+Eh/0c327EnQB8aWmjI
vu33Emk0HNgBPg4ETh7bmQFrmUZbp3OO/Qmo2GjK/RQjEqPKFa9+NEjvruic9sZR
N68LsFWIEKRFCRa8vQuprFzE4WQ8Ec+tmJZJaQIDAQABAoIBAQDXXZwEuOc+Xdd8
55HcotvsqMf1c7LahJAEC5ghqlBS/uG6CjnRDXl1V6U7uQr91p5ZBOLMOOktnyBv
VgcpfgZHYMKj2LqmXIikmilR4qaSZuznHGebnDxRYYe0RQt3Qo8EBXHQwPAggdIQ
OXl9yc/xzIRPSZ71szOyxwouBkQlcIbJHalmAwV4Aze7zWY48HLxDyCDYiW1TJ8u
4iEJGCiERi4DpljbRL8ScqsAmT8/dyKiNiA7+pokNb1mSvrs4hJWeIJn6wQ7nBpk
jzNRVycYR3N2VFUUR7/zKjX4LCgBim255c0TVLlrGobcTCCFYFqWF94x/31OXpuL
pssPjELdAoGBAPsXNZW7325Y1g9ytWD02uHj0P1f5CEV2zaxR0ULXhAqr4aHC7ri
sp1ze4Qnvp3Zg7PrR+ON6eK1m5ISRaHc/vdnNUkPJNlhtoQNNGSMdj1UQZVWCDV8
19cOgHljDXks2smgkIqodVrO5qv/JhWh5ABb+P9f/QntES0EVDGLTouvAoGBAOzT
/ccLkPqOl+lUDPlFDxbazL/EEo/b0+RvxjfPaepErp7Q7Bb3SnUhKu7JQqhfWKSv
bOw+Zbv37O8EvlOq1Y/VicrkGZnyBxKYe7EJivIUm/sNt1x3hapj+e7tvvYNW6YL
bxUKVSt2EAtQjfOJhdOapJNydRf1fekWYQTnfMpnAoGAJ7n/V2Z3Ll1N2PncKq/y
5aSGz1/Zl0Z+/YNE9G6c/k/Sn6VEPNhbTEAWPc2QAieFB/Vk1WMBq0XyjETp0XdG
u9wPeTS1LtOf7fqs3G/A0WlASyFmgRf0imkX+JysaAypvRbzZ4zJrIlpw7LF0sxf
Z5MlrToBrg1dF1NFAuW4kq8CgYAlhx4yuVl66reVyLTZlyDh/T/ur1JFq47zJuch
FuPwtHt7PR38MamB0ASunAPNDHbOeeHnuaeDVrEb2wOR3INE7JCOLwEDjP+j6bfI
APwcijmBWdYRd/sdWgRT4SaedNVuBWfPzLhcT7QRJu2nhsZHFr03hC6b4lHWaq5r
CYeTxwKBgFLsPjRQe6QkfULC2IWgcYPcviu4dwy1+GXCtLuyKDyqD9BCTg0j09mo
pSN+DBPttAr89x+dNMu8HQOkPaaakIVeEq+Msq0glR9muQnWoOTJLd/LINFX5D7N
dUkocQZBwYosHq6gPtOCPTq/R2lZziXzBFIuNdVH58rLZsQiTpat
-----END RSA PRIVATE KEY-----`

	BBL_CHAIN = `-----BEGIN CERTIFICATE-----
MIIFAzCCAuugAwIBAgIBATANBgkqhkiG9w0BAQsFADARMQ8wDQYDVQQDEwZiYmwt
Y2EwHhcNMTYwNTA0MjMyNjAwWhcNMjYwNTA0MjMyNjA1WjARMQ8wDQYDVQQDEwZi
YmwtY2EwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQCtCb/hRl2alQ/e
xrz3+mK5Uq3pwvt3fCfdU9z7mf1MqIfF3tGp6ggYfNLZNtvojUmAJEZmXyhEtSl7
JEMqFmqrPVzeKvc8QtkW6OJXjac4V3bJZXy8ruik50x8yBwS3QNm/Jo9JZYJcuBj
t/ScBXWQ91ADdTBEBUIkV48Qkmz+Qp5bZ1NiX5S6XNxChTRG6DXheVom+tVkWRAY
md5yvXgTdJA80F8y+tMZMysWwlZMPTcCfHTRYEbEP9v4/BsWdyd0Unc8Uem4Pre7
xD451Mfuq6T2QXvuJfErvj8o8ptC4Jcu9D3uiI+IgGX9V6zM+FRjwJqdirU0n/p/
MH8LcGBMaJC1x3bjQW8O2Voiab4T1uDWRpiuhPwx6GmiBcoNFT+hfw8lJZKyqWXP
7TK0NT1yP89J9ZNFWjR3HiQ9LSqpwbv5JU2HPpRRVAi0ehHxnWhP2trUSQGn8OJF
8LCJv0MUN/TAPMDRxiqvMMWiYAJLkJLWc+U0caIIlATt4IuzIfQAA+2Iag95d03D
XRNlVjRzGsuqyTYyrhSJLMb48B8d828WKgs0uUPxVvfZTUK033BrEh7j+30e7oFV
as9qvWAbSBjA2BJuvTwpR0Ms9nX3qG/1x3QQjYxbEjKJLRxQBKfhlfdqetIiBDgM
bPnEv4qzTLYKf5X2QFO06nl96L6HBwIDAQABo2YwZDAOBgNVHQ8BAf8EBAMCAQYw
EgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQU+GonMITrgSFO+Gsr1t9KtOny
2e0wHwYDVR0jBBgwFoAU+GonMITrgSFO+Gsr1t9KtOny2e0wDQYJKoZIhvcNAQEL
BQADggIBAHHoP5WCpBbA7liaBG7cjgtPR0gOKSUnmcDLC3VWn/NxrdoovO8zxMrk
GnRGchFBSqWEALvWcZw/PWlMD5saD4ZLiiyMz3uFDSJnknfNWdifWXzrS1ND1miV
aM3bCcUYGyP8F/yoCX03S+0JYGNBOnQBadRurlGht9Zjb6r/5wJeDOR0EEY/SARP
3OSQfKnKCXmfmL9gROCxvmlp6DRMK7EYwomtk825qt42krIBnIAjAZXs0K7ZwHE8
NR30y0IuD0fX+sRfiqF6tysts+ObOfJzK5NUL15tSDybSiYcqQMOk948Lk1gguNF
8f9CaMtLzLDfIqEBBAhF/LEPsw/QCwo5RX4wTWFf4IDHX1Xkg35jn6Zw+JYI0SqG
Uf7PnfiY/7D1qZtyNQipUrwZv2T/Dxl9872kqZHXN9O5qHDM2g8mDceS3GWvy1tk
akN0oPvrgcwd0RnyVrhdx9xyo29zaVegZ6I/SpFxKwxXDqRKj80a1Yd0AhEfYMBN
Y3x9G770K7xS5acGnQYh0Lb1tp9FMu1Nvyb8BlExdhNyinC+U162cZ/ht8I0uagL
feecTEl1fWeFqVeJACtSVFxkeVQf0/drQYDdXSluL8ktq6+hwpRagffN0Qcp6crW
0NCy6BpqtepSAAMkVFSTSnfQyp1kQAF4tEloeZxZ4xIalBHPDffR
-----END CERTIFICATE-----`

	OTHER_BBL_CERT = `-----BEGIN CERTIFICATE-----
MIIEMDCCAhigAwIBAgIRAPo28t0hUulg+snJaf8NxhIwDQYJKoZIhvcNAQELBQAw
EzERMA8GA1UEAxMIY29uc3VsQ0EwHhcNMTYwNjA4MTcyMTAwWhcNMTgwNjA4MTcy
MTAwWjAhMR8wHQYDVQQDExZzZXJ2ZXIuZGMxLmNmLmludGVybmFsMIIBIjANBgkq
hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzn5/kBixvT/eb5bI5uCWVNXmOIyMrmva
aoLMNHM/aJHRIyO/sjlLiVi6vLNQnvM5KvR6MVI8wUu7ddXkH4rpb6PuKhCHXLap
TYGVPW6VF81rkJbw0czQ6Sk957iYO7ZLy+8rcC3n41uCnQH0nf8P2WYedDVN440/
jQUG0IyNpSeiqhoBJvfi7uFiWcFT48GuXRgr8fIxq8Gy38V7Rl2BxQ/k3m/bU4Wl
pcAo5Vcct+GFi1chlZjrkRJXnJX9GepektOUesqGghzCvSwmrEmKgxultJhOZKo8
hwvPHYTcR658K07xcDM+wFJHxBa78xN1YZ3egEo9CbgJ2ThR8ev6DwIDAQABo3Ew
bzAOBgNVHQ8BAf8EBAMCA7gwHQYDVR0lBBYwFAYIKwYBBQUHAwEGCCsGAQUFBwMC
MB0GA1UdDgQWBBR1tui+OZqInw3+LGzqa7fXhvBzUzAfBgNVHSMEGDAWgBQykEBj
X2DVR3/1692e933i0K8f4zANBgkqhkiG9w0BAQsFAAOCAgEAxeRlKsv55Yy8MVRX
98IqQzKNswm12sbGjOPyRlAa8a5vio2HXF0evdxH3AmpC2iE7U9pV2JZeqT8UVTx
7ogBS6PUWpmVSdG3Ay4ZrwPlaW+9X547WAREUST5PJdQyL/v2tPLbTfeXG0/pYhq
Dfv2gAnhDmhv95Epdp4vG2475MKiiCrd0ev2gOZb55/stEsZyHO9U/9WvzYeB+rE
QhN5c7zVwDI80AHjRJmjkwE4vEltgCv+UuwGK+Nvz4V9c4XiUMm06L3eKkxFKfF9
w89L0Jy0uLnxrRRRSpArjGN0AsZcMjWASb6kVh306NGwdQ4LdxRKDdprlY4uJfsd
2bfLbAiQJgHNSDA9vIow0BH+3tg3GsEZa3DMEGdPydj71/yFxLHW3vzzzPbvOvQQ
5U2xIq/CRqgB8XJbzMIA6iKxn5mkN3I6tW5OJWwS/VqgR6HRxzb2TjTCmOayNoWS
+MSj6KfBPgDxZAsqw8At4oh/iKEQsEfEeqEpUNbS8yLfI9MS1JO2tV9fnUR9240c
9Bkj7+SC+3QDKablcUahbVz+PiB7ruzvdPyodFLcfw5RbP5YCX3gCR8S2z1NhoTv
1E8fGSzyGPUpBkHveM/OHSbwk0LCSZ9gbXLMaYUKFvQk41ChMuMN10TlwzqcRY3t
fCtWH/E/f/JSorlwJm+PjonQvq0=
-----END CERTIFICATE-----`

	OTHER_BBL_KEY = `-----BEGIN RSA PRIVATE KEY-----
MIIEpQIBAAKCAQEAzn5/kBixvT/eb5bI5uCWVNXmOIyMrmvaaoLMNHM/aJHRIyO/
sjlLiVi6vLNQnvM5KvR6MVI8wUu7ddXkH4rpb6PuKhCHXLapTYGVPW6VF81rkJbw
0czQ6Sk957iYO7ZLy+8rcC3n41uCnQH0nf8P2WYedDVN440/jQUG0IyNpSeiqhoB
Jvfi7uFiWcFT48GuXRgr8fIxq8Gy38V7Rl2BxQ/k3m/bU4WlpcAo5Vcct+GFi1ch
lZjrkRJXnJX9GepektOUesqGghzCvSwmrEmKgxultJhOZKo8hwvPHYTcR658K07x
cDM+wFJHxBa78xN1YZ3egEo9CbgJ2ThR8ev6DwIDAQABAoIBAQCDZEB9CwmFty8t
aA+bwQpHHvfnwZ7+mUgYf/O56B9PxYEC0At5NzXWRixESAEjsvYMXBWoboCUKkE1
AI2weG6DCBdSksPe/aeK1sqElWmvBJnOHg1MIfxIcGKgoHfVfvCJ6jyEm+EybRcW
GplxM0v9dBoqrYRLJ6RpcepdJyI2FHakGJ0mbVRKMucYOSzzXt+CG0UZdSsAJvil
ZZniGzsS4wsUiyurO7tEB3txFqxrzAgztBwLc8/ZrMM8XZN/qzOMgqXAcQ6m+6X6
GGUouT7FZZsysRGdbggEsdeKl9+UyJEZH9DoIwHtzpdDyVWGYi5uNIjDCbWTLqhI
F+ZRZaHxAoGBAODXgO7nTxyFXSN9v3b7w51OZmrFCJ3oLhugCTqhefrYsMuoyfQT
27h79UPAijcYHjuSpgS+pDFWtRJTmpWNiaNS09tozR78LP7UGlS76+AghrbOhL0b
W0Hnn2UvUnhVTFtXOa6kd3iZyhIyaiXcVngBtJX3GHWfQhQSCVtgLlPJAoGBAOsc
F37BE9cFWjkCGph7/00iGdU7qBDUpisiQTCH+tRQ9RKxSnsb1zEhAmA+k7vxpCoe
PFbZZm/s5j/YXtZ3GiUB3yLFIBa9mLWNkpIObpNHwie2esYF39lgPHktSlM4ZaPz
th6R+pZXcaeC+U8RszFxWiqZUx83NiMEd6bfKlsXAoGBAJ9TFmI0NrMXLfDAYrSF
oxANRjXSeVCr/kBFH0UUt8MxWdZ3PORgTgpkjF/+R/LSfFnqiQpDrUXpE1ZxN9FS
An5haw7HLNMQDzJkSmRQ5cxkQBG6NgVrJTeGUkT5S49Joln3bUB7+szS7YYHg4Bg
qkVPsA+0kPiIaeKfBVJizXFBAoGBAKHddU+PHlmrFbKqACV7OQmhsKddqxfrT3vi
2X7QH6CNHC0CYoTfZggs8bXRX2TFuIBG0MP6aMwmDV9nV+PPm/BemYEWtkDxx3E3
RvHHfdloTgOJXn13DeZam0fSJpmk+lUmNPxXBG79RQJO6dXGGdiwcaNibBfRqzPw
n3ADtOWBAoGAeOJW50x3m9wJojy9ul4VF1E8Lmev4t4m5y+oqFF9GAE/kSiqBXXZ
FAWD6nCwAQ1QYU4WOgzh7PWtqKwDY//289JvzWIvUe88NTQ80ux9hxQM7Tphu5/0
p24hXPLGFEE+1dS1TJk4/wPjO0TyxXI91s2ropP6xPq1SBug2gVFCUs=
-----END RSA PRIVATE KEY-----`

	OTHER_BBL_CHAIN = `-----BEGIN CERTIFICATE-----
MIIFBzCCAu+gAwIBAgIBATANBgkqhkiG9w0BAQsFADATMREwDwYDVQQDEwhjb25z
dWxDQTAeFw0xNjA2MDgxNzIwNTlaFw0yNjA2MDgxNzIxMDBaMBMxETAPBgNVBAMT
CGNvbnN1bENBMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA27yIQdMx
TDySTAPW7y03j73OmEEOmq8Xbux322dl6gt6LHBs9vl20m/PxVz0ppyBWzfeoL1g
f92rXfcjCW0Ut/xCwZSG0RTPfvpeQ1uP8VGtwxkrxg2uKMIH3R3eumgRdt0o4Q+Z
kaQDtyloVAyELH1ucZ82qQqen6jveMcWrJMo35Co0Yn6p/GbrilwZNrJBftpQ6cz
b5sB8BYyiz9i08mOTxpudxxPYSWrnRUim56/pFsPdCFn9Vghx2KyR1ky8XbSBulx
6qTzaI0UazxkvxK2Qyb+ZamYr7DWRIR6G/y0Ky1tH20MzK+3ZRIPvqTQhJ1DFArk
Ox3SnnHazoUX6Mh07QPncKpzYR8zKfBzsWJjJf4pMq1JjgfwScsPOCbssNbMtxWX
trNfhmTmzOjB/RwDjjEXhBfdKK5MRMTlDhg8WBV97jQeAZWRGG25be/I+xnrI56v
KgiyjeKcuAlmuqwQQherMsaYLOin5FbISNvveXPgHx1fc9mw+44C3QTTZIOl0qxx
HZBcP4hvNB37RjaJ8/g+r6QO4MSFk9ezYfmxtjzYumY2tc15C7BJu4MPoLY3eYyM
v/kyBzicd1bom7fONOo9SIey9hhYWTQ0Ibw7hMgz7f3HpcCvFlnnAd5/UR0eMVeD
7jOjIiTUALUdMd4WKesdvR2Nyo3bby3i2K0CAwEAAaNmMGQwDgYDVR0PAQH/BAQD
AgEGMBIGA1UdEwEB/wQIMAYBAf8CAQAwHQYDVR0OBBYEFDKQQGNfYNVHf/Xr3Z73
feLQrx/jMB8GA1UdIwQYMBaAFDKQQGNfYNVHf/Xr3Z73feLQrx/jMA0GCSqGSIb3
DQEBCwUAA4ICAQDV55BjiIZa4ET7yPB4iejcACxAt//xoHguxZS42ziBE2UIkSHx
hX+Yl5nHOiUGH7H0/USMf+Dx0bDYMreZEVzut9K8u+Ar6OjrLP0hilan5+BU0esB
zw3NOrfl2KQ98McjWcjA6wNpqv1d44WYn/aTH5J948VUHlkAvgr35EIyERNR8wKX
dMSnl7Rol2YF2F+TKDs4BICMx9eXHnwrC1eQ7aDXdWjoNWt07S0ldRygPma8Rxd3
G5/TKoQwZF33DxuEleHr7dMJEI0MigN1mKb3e07sNjIE1j53CzO+/lTJZyZLmd6e
uVzNhDOmt0o+D/b48zEpQxVAGj4iQAcs/89bx/38tuWcz7XLxsR2CiatgyP4Ygq9
kx52EeH0OSq8Hiz75YSSXNf4LT/5QrQ2A5I872dUWtn/N6NDzyeAlRBhi4k/1c9Q
LmBpha0Q7Fpx43PZR6m9az7gs6+ylK1g/l0LODNN/JmloaLMvxXYEzO7cuGT+yn6
l0fy0A6cTXtZFI+yk7AoBQHbffTkO7JTXS2XhA2pMkjerPw99e5SkK9j8+7kO7EM
qg+4mJmdo8yHXRtYfF9FL0Mzxr1+4eivUSpw4SBB827NZdk93ZCIf3NO7OhFPfuO
mfbEk8h+4sXnv5B2f+3zaUbQ/68wOQysAwyCRGjvol9Cig3cxhMlLwpOvQ==
-----END CERTIFICATE-----`

	PRIVATE_KEY = `-----BEGIN RSA PRIVATE KEY-----
MIIEpQIBAAKCAQEAyVxzpt3wwaiS8nRNNBnIDtsWrTIIh1tLC4PrzbqRYDgUUOgv
cXbaykVCRG17N2Z7+6uOINvM21JqqQ6GCBXZkshoR10IIQiGBVxa6snbrFnbvxyi
v7fe7y5O2i5EVA2qIVrGK4pUJr1VGdLBoh9ux2cmJnr7A6tdLyVxqUyOQsFNKV1s
SU6T+Y5W4YNAtjuHBqNVgys3p+jZiQku/XIWXqwZAnY+88wG+QmVwXTHSu5ul9GR
jhfBR16qoPzZAv5s55dIMmYnPz4FP+j9D5ftoN97jpGW3yi76NOiDPiQ6LlZvVhe
fDj1yWl4OATBB8IypOKBS8x06kBR7Ga96e5kTQIDAQABAoIBAQCuM05WaSFU2Lqw
CE+WKEu8FmwK0AMy3pcQ0kMYyzPjkwB4cjZBKfrkDIDk4/Y6Gm5ebq9Z2+3hO+7M
bKUlr4l4A+q6+lADC/WuA5UgFBv4ghCqyGJADBlQwLY06Nvx/5RUoMxadKSSky9h
VMRxtlHHLoSBu9kW9pR6KiGnvnRAaKFO/zwmu0D1zAUlATCo2Q4JYnPpZgCZEcUQ
KUDjN3Gledbw1MBwEPKwtsoUmwfCoZgiKVBu2FdEbiCfNeF4iuGE9R64jWJ6VM4I
OAVSueZdS3xqax5RQmQW7qvwXPXjOMo9ru1G68W4SYg5dN7A41XFm0mu0taVnS7a
oIjSHy49AoGBAP2rYqAtnNQqbZco/PDyZkYgUqbYn1DiBj8PENht8rJI2TTqVKRt
hcx1mY23al1K2CAam3A2o5VRuAr91O1K3vnA38eH7NlfK1YzVC2jaX0+bz1QhRAs
NiMIYyXSt+2CyJDjzOzEJ4+lUFNJPdybuDDsfWlyxRiNCYx2qNaF7mPTAoGBAMs2
CmNBcuhdWm5lmddqdbiGMVc6vHnwA978gQJod2rtGm7UqVygRErqDZdecFkmqeWg
5dZ116H4fTpLxTpzCvIkj2ZX9kkfPWH3DERp0H19ybIXDrjFbgdIGwtNLkhhHqg/
aFRWz0eSmALJ4e7bmdq9lk7PqESpYL4nt4WWeKNfAoGBALiSLEfKCHNjj6vN2gVj
CkF6IUlfEsSiQNM/Hg2sKkvIr6pN2lptik4TPzAbRZwt6gWp9nF2gB4UgKoWuQgT
Uxw8V1byMsaS9ZBZ9qTiYs4LUJs3bCoxUQ66epG5ubRqVY7/AUtBClv9d+2xu/45
m5KVcEb6iCht7oWyjPTSLHubAoGASYiFm8McNI9LYPVtBPFmJd6RTjJX73v1uqP+
fwOUauHflcloe7cW31DwmBy5ZNlD0280nDVKUTcdAZJXjT4B8Ptf1LXxziX6zU9b
ZgowQqjY6pPDZQM0PHhQKPfFzrUuJc3ED/jVyt12GlQ5aHiYpPnDwUMNbcMo2cZ/
d1yqzNsCgYEA6NzlJU6IPk6ehXPOGpUKc8LQU2AO4t/Yc+FRr/skak7JapxaCAhT
NN3BN8WDhIHGlmPp71ewaiI64O2MOITn9jkCj2w014Zd12hBW73bAhli8MBj+NCZ
nMHMGF8iNhomlrXCxnFJKeui0iQ2vRecszxPgpXn7OI4iSfdHtVCmhQ=
-----END RSA PRIVATE KEY-----`

	JUMPBOX_SSH_KEY = `-----BEGIN RSA PRIVATE KEY-----
MIIEpAIBAAKCAQEA38qPrL8q3OP8k0tWdaL9lhRR2mbMrYBnJs2mDhE/r8shmVHe
GhcYYWNFGp1oZiTgq6rnT9QrSxJvrgqbUbqghvGT+tw3ebEqMVSuaWbgzJAoKlRS
+Ghvvi3nAM1o61tLcX0TbVhwfjtoG0j4GJllBMBgz9Y3aEjXL3cz16Fo1ZKT8wk5
NQJQhp/nRkE2rBUcRky0mXLmNr7ium50Z330INjI24B94UpPO3kk+rFMlcIDsbFX
o+dJXOhq3ND8f+rdedWbv3q18WqGSaTReHcERzrBnz4P2DJ0/XQbbXxjlVrVHAQ7
8b50aVixDnozUC1RtVWmItHxpSkK3rRvC0y5WQIDAQABAoIBAQCNVfKzWPCLHPmx
VM0/8jZRiHfBhVcS5JtA6HRNQhuEvLd1izzIIXnmV7mW+36ps/SotoDr68WD3hrm
QhCh50nmr7+TmWz30CojiaW1L6Idz5VuVl8oP10DMR5JZXEz4y6ceC/CyS4SqxYu
1UDK2GXyQEVkPZg0pnwwoAn/zxLUflXC6+I25RsT/X5vDPW9l8VpFE4QjWT9XeOu
ElfiX66IW5V6/y/SEll1pzueDM+M6ec1p/pS24iiLuNHWA4feyVJTQ8nzxQuYz1q
yI4uQZLHIMiFCNY2nhoK2EZtocKPFo8DUuWph1k0uycv8GGm8gOd8spg1na27ja9
iXJxEyF5AoGBAOnC1wvtIUzTmARtBY5S7s0ho3NueR5GUi5ku5S3TdFGCmUaA3zE
2VYJ7h0eioabtJwY1tzsKxahJNeKkRgW7SUDBxnEltbN7WA/mDgu5d+NAT59Ho6T
7A1DZIKCTo8hBvHzgSIang63fqoFco6WOv9JG4V7BHIegYISpweJbT/7AoGBAPUU
6OB1GJTOgFgKNc04Xy5LlFE05mAGeaMaeGmsNSDJ5UAs+w0NiMObJ7DNqdM26rSn
RQkt7sU8GECc9PtiY9TQTW9VNyXALC/vap5Ee/8bAuZ3dM08LtkuCpeIplOD5RAJ
r7Buh+GbHPZ6LqL8f/5hWeeIUMXXc09HCP0Cc2e7AoGBAIP1nXf6EQZRnEtDUBOb
9XqPNrn+7xiMEfBmpQ26vI8avtt75+QTK61KRcTibMi4NSi5TPHB0EEiDq4uZuH2
b0CpiOSe+ZehABOJUuDEeLfN3Zns/8b08hg6pw6ViMt7lXQYRhl+dSNRqotIL/cW
D4/1MTgUzdmuJuXKqcezaJzpAoGALnyj24d6fSdaQtjU8bNCopZlcK3XENnJkr1/
n5OxlCGXoX+mswghK/EvKyMnlk+xX0jnGGGlC7ZlZ0QeV9yG0SQdvANu7XMxLnp8
P77/whjOiQaZmiBTRpCsI6gg3HCFL3CW6aFdltaEPOBaHkJEyOyQUBGUOKKwVZZE
xzEC0OcCgYBo70a2s0VzC8BR7BwcuNgVQp8e90+AeHHzgx1Z/yjxzkRw533Tlpj8
eYYHipQy737P1l9vz2BX6YHn8Kos0Y1pzG7CqRjwrCfGRDM4DcA64P4oR55RULWa
e2rINGOsVkW6atdh+5XwGMLS8QDccwaPMpcqdVbdo4c0YcfGRWgB3w==
-----END RSA PRIVATE KEY-----`

	PFX_BASE64 = `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`
	
	PFX_PASSWORD = `SuperSecurePassword`
)
