// Code generated by counterfeiter. DO NOT EDIT.
package pushactionfakes

import (
	"io"
	"sync"

	"code.cloudfoundry.org/cli/actor/pushaction"
	"code.cloudfoundry.org/cli/actor/v2action"
)

type FakeV2Actor struct {
	MapRouteToApplicationStub        func(routeGUID string, appGUID string) (v2action.Warnings, error)
	mapRouteToApplicationMutex       sync.RWMutex
	mapRouteToApplicationArgsForCall []struct {
		routeGUID string
		appGUID   string
	}
	mapRouteToApplicationReturns struct {
		result1 v2action.Warnings
		result2 error
	}
	mapRouteToApplicationReturnsOnCall map[int]struct {
		result1 v2action.Warnings
		result2 error
	}
	BindServiceByApplicationAndServiceInstanceStub        func(appGUID string, serviceInstanceGUID string) (v2action.Warnings, error)
	bindServiceByApplicationAndServiceInstanceMutex       sync.RWMutex
	bindServiceByApplicationAndServiceInstanceArgsForCall []struct {
		appGUID             string
		serviceInstanceGUID string
	}
	bindServiceByApplicationAndServiceInstanceReturns struct {
		result1 v2action.Warnings
		result2 error
	}
	bindServiceByApplicationAndServiceInstanceReturnsOnCall map[int]struct {
		result1 v2action.Warnings
		result2 error
	}
	CreateApplicationStub        func(application v2action.Application) (v2action.Application, v2action.Warnings, error)
	createApplicationMutex       sync.RWMutex
	createApplicationArgsForCall []struct {
		application v2action.Application
	}
	createApplicationReturns struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}
	createApplicationReturnsOnCall map[int]struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}
	CreateRouteStub        func(route v2action.Route, generatePort bool) (v2action.Route, v2action.Warnings, error)
	createRouteMutex       sync.RWMutex
	createRouteArgsForCall []struct {
		route        v2action.Route
		generatePort bool
	}
	createRouteReturns struct {
		result1 v2action.Route
		result2 v2action.Warnings
		result3 error
	}
	createRouteReturnsOnCall map[int]struct {
		result1 v2action.Route
		result2 v2action.Warnings
		result3 error
	}
	FindRouteBoundToSpaceWithSettingsStub        func(route v2action.Route) (v2action.Route, v2action.Warnings, error)
	findRouteBoundToSpaceWithSettingsMutex       sync.RWMutex
	findRouteBoundToSpaceWithSettingsArgsForCall []struct {
		route v2action.Route
	}
	findRouteBoundToSpaceWithSettingsReturns struct {
		result1 v2action.Route
		result2 v2action.Warnings
		result3 error
	}
	findRouteBoundToSpaceWithSettingsReturnsOnCall map[int]struct {
		result1 v2action.Route
		result2 v2action.Warnings
		result3 error
	}
	GetApplicationByNameAndSpaceStub        func(name string, spaceGUID string) (v2action.Application, v2action.Warnings, error)
	getApplicationByNameAndSpaceMutex       sync.RWMutex
	getApplicationByNameAndSpaceArgsForCall []struct {
		name      string
		spaceGUID string
	}
	getApplicationByNameAndSpaceReturns struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}
	getApplicationByNameAndSpaceReturnsOnCall map[int]struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}
	GetApplicationRoutesStub        func(applicationGUID string) (v2action.Routes, v2action.Warnings, error)
	getApplicationRoutesMutex       sync.RWMutex
	getApplicationRoutesArgsForCall []struct {
		applicationGUID string
	}
	getApplicationRoutesReturns struct {
		result1 v2action.Routes
		result2 v2action.Warnings
		result3 error
	}
	getApplicationRoutesReturnsOnCall map[int]struct {
		result1 v2action.Routes
		result2 v2action.Warnings
		result3 error
	}
	GetDomainsByNameAndOrganizationStub        func(domainNames []string, orgGUID string) ([]v2action.Domain, v2action.Warnings, error)
	getDomainsByNameAndOrganizationMutex       sync.RWMutex
	getDomainsByNameAndOrganizationArgsForCall []struct {
		domainNames []string
		orgGUID     string
	}
	getDomainsByNameAndOrganizationReturns struct {
		result1 []v2action.Domain
		result2 v2action.Warnings
		result3 error
	}
	getDomainsByNameAndOrganizationReturnsOnCall map[int]struct {
		result1 []v2action.Domain
		result2 v2action.Warnings
		result3 error
	}
	GetOrganizationDomainsStub        func(orgGUID string) ([]v2action.Domain, v2action.Warnings, error)
	getOrganizationDomainsMutex       sync.RWMutex
	getOrganizationDomainsArgsForCall []struct {
		orgGUID string
	}
	getOrganizationDomainsReturns struct {
		result1 []v2action.Domain
		result2 v2action.Warnings
		result3 error
	}
	getOrganizationDomainsReturnsOnCall map[int]struct {
		result1 []v2action.Domain
		result2 v2action.Warnings
		result3 error
	}
	GetServiceInstanceByNameAndSpaceStub        func(name string, spaceGUID string) (v2action.ServiceInstance, v2action.Warnings, error)
	getServiceInstanceByNameAndSpaceMutex       sync.RWMutex
	getServiceInstanceByNameAndSpaceArgsForCall []struct {
		name      string
		spaceGUID string
	}
	getServiceInstanceByNameAndSpaceReturns struct {
		result1 v2action.ServiceInstance
		result2 v2action.Warnings
		result3 error
	}
	getServiceInstanceByNameAndSpaceReturnsOnCall map[int]struct {
		result1 v2action.ServiceInstance
		result2 v2action.Warnings
		result3 error
	}
	GetServiceInstancesByApplicationStub        func(appGUID string) ([]v2action.ServiceInstance, v2action.Warnings, error)
	getServiceInstancesByApplicationMutex       sync.RWMutex
	getServiceInstancesByApplicationArgsForCall []struct {
		appGUID string
	}
	getServiceInstancesByApplicationReturns struct {
		result1 []v2action.ServiceInstance
		result2 v2action.Warnings
		result3 error
	}
	getServiceInstancesByApplicationReturnsOnCall map[int]struct {
		result1 []v2action.ServiceInstance
		result2 v2action.Warnings
		result3 error
	}
	GetStackStub        func(guid string) (v2action.Stack, v2action.Warnings, error)
	getStackMutex       sync.RWMutex
	getStackArgsForCall []struct {
		guid string
	}
	getStackReturns struct {
		result1 v2action.Stack
		result2 v2action.Warnings
		result3 error
	}
	getStackReturnsOnCall map[int]struct {
		result1 v2action.Stack
		result2 v2action.Warnings
		result3 error
	}
	GetStackByNameStub        func(stackName string) (v2action.Stack, v2action.Warnings, error)
	getStackByNameMutex       sync.RWMutex
	getStackByNameArgsForCall []struct {
		stackName string
	}
	getStackByNameReturns struct {
		result1 v2action.Stack
		result2 v2action.Warnings
		result3 error
	}
	getStackByNameReturnsOnCall map[int]struct {
		result1 v2action.Stack
		result2 v2action.Warnings
		result3 error
	}
	PollJobStub        func(job v2action.Job) (v2action.Warnings, error)
	pollJobMutex       sync.RWMutex
	pollJobArgsForCall []struct {
		job v2action.Job
	}
	pollJobReturns struct {
		result1 v2action.Warnings
		result2 error
	}
	pollJobReturnsOnCall map[int]struct {
		result1 v2action.Warnings
		result2 error
	}
	ResourceMatchStub        func(allResources []v2action.Resource) ([]v2action.Resource, []v2action.Resource, v2action.Warnings, error)
	resourceMatchMutex       sync.RWMutex
	resourceMatchArgsForCall []struct {
		allResources []v2action.Resource
	}
	resourceMatchReturns struct {
		result1 []v2action.Resource
		result2 []v2action.Resource
		result3 v2action.Warnings
		result4 error
	}
	resourceMatchReturnsOnCall map[int]struct {
		result1 []v2action.Resource
		result2 []v2action.Resource
		result3 v2action.Warnings
		result4 error
	}
	UnmapRouteFromApplicationStub        func(routeGUID string, appGUID string) (v2action.Warnings, error)
	unmapRouteFromApplicationMutex       sync.RWMutex
	unmapRouteFromApplicationArgsForCall []struct {
		routeGUID string
		appGUID   string
	}
	unmapRouteFromApplicationReturns struct {
		result1 v2action.Warnings
		result2 error
	}
	unmapRouteFromApplicationReturnsOnCall map[int]struct {
		result1 v2action.Warnings
		result2 error
	}
	UpdateApplicationStub        func(application v2action.Application) (v2action.Application, v2action.Warnings, error)
	updateApplicationMutex       sync.RWMutex
	updateApplicationArgsForCall []struct {
		application v2action.Application
	}
	updateApplicationReturns struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}
	updateApplicationReturnsOnCall map[int]struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}
	UploadApplicationPackageStub        func(appGUID string, existingResources []v2action.Resource, newResources io.Reader, newResourcesLength int64) (v2action.Job, v2action.Warnings, error)
	uploadApplicationPackageMutex       sync.RWMutex
	uploadApplicationPackageArgsForCall []struct {
		appGUID            string
		existingResources  []v2action.Resource
		newResources       io.Reader
		newResourcesLength int64
	}
	uploadApplicationPackageReturns struct {
		result1 v2action.Job
		result2 v2action.Warnings
		result3 error
	}
	uploadApplicationPackageReturnsOnCall map[int]struct {
		result1 v2action.Job
		result2 v2action.Warnings
		result3 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeV2Actor) MapRouteToApplication(routeGUID string, appGUID string) (v2action.Warnings, error) {
	fake.mapRouteToApplicationMutex.Lock()
	ret, specificReturn := fake.mapRouteToApplicationReturnsOnCall[len(fake.mapRouteToApplicationArgsForCall)]
	fake.mapRouteToApplicationArgsForCall = append(fake.mapRouteToApplicationArgsForCall, struct {
		routeGUID string
		appGUID   string
	}{routeGUID, appGUID})
	fake.recordInvocation("MapRouteToApplication", []interface{}{routeGUID, appGUID})
	fake.mapRouteToApplicationMutex.Unlock()
	if fake.MapRouteToApplicationStub != nil {
		return fake.MapRouteToApplicationStub(routeGUID, appGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.mapRouteToApplicationReturns.result1, fake.mapRouteToApplicationReturns.result2
}

func (fake *FakeV2Actor) MapRouteToApplicationCallCount() int {
	fake.mapRouteToApplicationMutex.RLock()
	defer fake.mapRouteToApplicationMutex.RUnlock()
	return len(fake.mapRouteToApplicationArgsForCall)
}

func (fake *FakeV2Actor) MapRouteToApplicationArgsForCall(i int) (string, string) {
	fake.mapRouteToApplicationMutex.RLock()
	defer fake.mapRouteToApplicationMutex.RUnlock()
	return fake.mapRouteToApplicationArgsForCall[i].routeGUID, fake.mapRouteToApplicationArgsForCall[i].appGUID
}

func (fake *FakeV2Actor) MapRouteToApplicationReturns(result1 v2action.Warnings, result2 error) {
	fake.MapRouteToApplicationStub = nil
	fake.mapRouteToApplicationReturns = struct {
		result1 v2action.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeV2Actor) MapRouteToApplicationReturnsOnCall(i int, result1 v2action.Warnings, result2 error) {
	fake.MapRouteToApplicationStub = nil
	if fake.mapRouteToApplicationReturnsOnCall == nil {
		fake.mapRouteToApplicationReturnsOnCall = make(map[int]struct {
			result1 v2action.Warnings
			result2 error
		})
	}
	fake.mapRouteToApplicationReturnsOnCall[i] = struct {
		result1 v2action.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeV2Actor) BindServiceByApplicationAndServiceInstance(appGUID string, serviceInstanceGUID string) (v2action.Warnings, error) {
	fake.bindServiceByApplicationAndServiceInstanceMutex.Lock()
	ret, specificReturn := fake.bindServiceByApplicationAndServiceInstanceReturnsOnCall[len(fake.bindServiceByApplicationAndServiceInstanceArgsForCall)]
	fake.bindServiceByApplicationAndServiceInstanceArgsForCall = append(fake.bindServiceByApplicationAndServiceInstanceArgsForCall, struct {
		appGUID             string
		serviceInstanceGUID string
	}{appGUID, serviceInstanceGUID})
	fake.recordInvocation("BindServiceByApplicationAndServiceInstance", []interface{}{appGUID, serviceInstanceGUID})
	fake.bindServiceByApplicationAndServiceInstanceMutex.Unlock()
	if fake.BindServiceByApplicationAndServiceInstanceStub != nil {
		return fake.BindServiceByApplicationAndServiceInstanceStub(appGUID, serviceInstanceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.bindServiceByApplicationAndServiceInstanceReturns.result1, fake.bindServiceByApplicationAndServiceInstanceReturns.result2
}

func (fake *FakeV2Actor) BindServiceByApplicationAndServiceInstanceCallCount() int {
	fake.bindServiceByApplicationAndServiceInstanceMutex.RLock()
	defer fake.bindServiceByApplicationAndServiceInstanceMutex.RUnlock()
	return len(fake.bindServiceByApplicationAndServiceInstanceArgsForCall)
}

func (fake *FakeV2Actor) BindServiceByApplicationAndServiceInstanceArgsForCall(i int) (string, string) {
	fake.bindServiceByApplicationAndServiceInstanceMutex.RLock()
	defer fake.bindServiceByApplicationAndServiceInstanceMutex.RUnlock()
	return fake.bindServiceByApplicationAndServiceInstanceArgsForCall[i].appGUID, fake.bindServiceByApplicationAndServiceInstanceArgsForCall[i].serviceInstanceGUID
}

func (fake *FakeV2Actor) BindServiceByApplicationAndServiceInstanceReturns(result1 v2action.Warnings, result2 error) {
	fake.BindServiceByApplicationAndServiceInstanceStub = nil
	fake.bindServiceByApplicationAndServiceInstanceReturns = struct {
		result1 v2action.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeV2Actor) BindServiceByApplicationAndServiceInstanceReturnsOnCall(i int, result1 v2action.Warnings, result2 error) {
	fake.BindServiceByApplicationAndServiceInstanceStub = nil
	if fake.bindServiceByApplicationAndServiceInstanceReturnsOnCall == nil {
		fake.bindServiceByApplicationAndServiceInstanceReturnsOnCall = make(map[int]struct {
			result1 v2action.Warnings
			result2 error
		})
	}
	fake.bindServiceByApplicationAndServiceInstanceReturnsOnCall[i] = struct {
		result1 v2action.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeV2Actor) CreateApplication(application v2action.Application) (v2action.Application, v2action.Warnings, error) {
	fake.createApplicationMutex.Lock()
	ret, specificReturn := fake.createApplicationReturnsOnCall[len(fake.createApplicationArgsForCall)]
	fake.createApplicationArgsForCall = append(fake.createApplicationArgsForCall, struct {
		application v2action.Application
	}{application})
	fake.recordInvocation("CreateApplication", []interface{}{application})
	fake.createApplicationMutex.Unlock()
	if fake.CreateApplicationStub != nil {
		return fake.CreateApplicationStub(application)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.createApplicationReturns.result1, fake.createApplicationReturns.result2, fake.createApplicationReturns.result3
}

func (fake *FakeV2Actor) CreateApplicationCallCount() int {
	fake.createApplicationMutex.RLock()
	defer fake.createApplicationMutex.RUnlock()
	return len(fake.createApplicationArgsForCall)
}

func (fake *FakeV2Actor) CreateApplicationArgsForCall(i int) v2action.Application {
	fake.createApplicationMutex.RLock()
	defer fake.createApplicationMutex.RUnlock()
	return fake.createApplicationArgsForCall[i].application
}

func (fake *FakeV2Actor) CreateApplicationReturns(result1 v2action.Application, result2 v2action.Warnings, result3 error) {
	fake.CreateApplicationStub = nil
	fake.createApplicationReturns = struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) CreateApplicationReturnsOnCall(i int, result1 v2action.Application, result2 v2action.Warnings, result3 error) {
	fake.CreateApplicationStub = nil
	if fake.createApplicationReturnsOnCall == nil {
		fake.createApplicationReturnsOnCall = make(map[int]struct {
			result1 v2action.Application
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.createApplicationReturnsOnCall[i] = struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) CreateRoute(route v2action.Route, generatePort bool) (v2action.Route, v2action.Warnings, error) {
	fake.createRouteMutex.Lock()
	ret, specificReturn := fake.createRouteReturnsOnCall[len(fake.createRouteArgsForCall)]
	fake.createRouteArgsForCall = append(fake.createRouteArgsForCall, struct {
		route        v2action.Route
		generatePort bool
	}{route, generatePort})
	fake.recordInvocation("CreateRoute", []interface{}{route, generatePort})
	fake.createRouteMutex.Unlock()
	if fake.CreateRouteStub != nil {
		return fake.CreateRouteStub(route, generatePort)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.createRouteReturns.result1, fake.createRouteReturns.result2, fake.createRouteReturns.result3
}

func (fake *FakeV2Actor) CreateRouteCallCount() int {
	fake.createRouteMutex.RLock()
	defer fake.createRouteMutex.RUnlock()
	return len(fake.createRouteArgsForCall)
}

func (fake *FakeV2Actor) CreateRouteArgsForCall(i int) (v2action.Route, bool) {
	fake.createRouteMutex.RLock()
	defer fake.createRouteMutex.RUnlock()
	return fake.createRouteArgsForCall[i].route, fake.createRouteArgsForCall[i].generatePort
}

func (fake *FakeV2Actor) CreateRouteReturns(result1 v2action.Route, result2 v2action.Warnings, result3 error) {
	fake.CreateRouteStub = nil
	fake.createRouteReturns = struct {
		result1 v2action.Route
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) CreateRouteReturnsOnCall(i int, result1 v2action.Route, result2 v2action.Warnings, result3 error) {
	fake.CreateRouteStub = nil
	if fake.createRouteReturnsOnCall == nil {
		fake.createRouteReturnsOnCall = make(map[int]struct {
			result1 v2action.Route
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.createRouteReturnsOnCall[i] = struct {
		result1 v2action.Route
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) FindRouteBoundToSpaceWithSettings(route v2action.Route) (v2action.Route, v2action.Warnings, error) {
	fake.findRouteBoundToSpaceWithSettingsMutex.Lock()
	ret, specificReturn := fake.findRouteBoundToSpaceWithSettingsReturnsOnCall[len(fake.findRouteBoundToSpaceWithSettingsArgsForCall)]
	fake.findRouteBoundToSpaceWithSettingsArgsForCall = append(fake.findRouteBoundToSpaceWithSettingsArgsForCall, struct {
		route v2action.Route
	}{route})
	fake.recordInvocation("FindRouteBoundToSpaceWithSettings", []interface{}{route})
	fake.findRouteBoundToSpaceWithSettingsMutex.Unlock()
	if fake.FindRouteBoundToSpaceWithSettingsStub != nil {
		return fake.FindRouteBoundToSpaceWithSettingsStub(route)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.findRouteBoundToSpaceWithSettingsReturns.result1, fake.findRouteBoundToSpaceWithSettingsReturns.result2, fake.findRouteBoundToSpaceWithSettingsReturns.result3
}

func (fake *FakeV2Actor) FindRouteBoundToSpaceWithSettingsCallCount() int {
	fake.findRouteBoundToSpaceWithSettingsMutex.RLock()
	defer fake.findRouteBoundToSpaceWithSettingsMutex.RUnlock()
	return len(fake.findRouteBoundToSpaceWithSettingsArgsForCall)
}

func (fake *FakeV2Actor) FindRouteBoundToSpaceWithSettingsArgsForCall(i int) v2action.Route {
	fake.findRouteBoundToSpaceWithSettingsMutex.RLock()
	defer fake.findRouteBoundToSpaceWithSettingsMutex.RUnlock()
	return fake.findRouteBoundToSpaceWithSettingsArgsForCall[i].route
}

func (fake *FakeV2Actor) FindRouteBoundToSpaceWithSettingsReturns(result1 v2action.Route, result2 v2action.Warnings, result3 error) {
	fake.FindRouteBoundToSpaceWithSettingsStub = nil
	fake.findRouteBoundToSpaceWithSettingsReturns = struct {
		result1 v2action.Route
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) FindRouteBoundToSpaceWithSettingsReturnsOnCall(i int, result1 v2action.Route, result2 v2action.Warnings, result3 error) {
	fake.FindRouteBoundToSpaceWithSettingsStub = nil
	if fake.findRouteBoundToSpaceWithSettingsReturnsOnCall == nil {
		fake.findRouteBoundToSpaceWithSettingsReturnsOnCall = make(map[int]struct {
			result1 v2action.Route
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.findRouteBoundToSpaceWithSettingsReturnsOnCall[i] = struct {
		result1 v2action.Route
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetApplicationByNameAndSpace(name string, spaceGUID string) (v2action.Application, v2action.Warnings, error) {
	fake.getApplicationByNameAndSpaceMutex.Lock()
	ret, specificReturn := fake.getApplicationByNameAndSpaceReturnsOnCall[len(fake.getApplicationByNameAndSpaceArgsForCall)]
	fake.getApplicationByNameAndSpaceArgsForCall = append(fake.getApplicationByNameAndSpaceArgsForCall, struct {
		name      string
		spaceGUID string
	}{name, spaceGUID})
	fake.recordInvocation("GetApplicationByNameAndSpace", []interface{}{name, spaceGUID})
	fake.getApplicationByNameAndSpaceMutex.Unlock()
	if fake.GetApplicationByNameAndSpaceStub != nil {
		return fake.GetApplicationByNameAndSpaceStub(name, spaceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getApplicationByNameAndSpaceReturns.result1, fake.getApplicationByNameAndSpaceReturns.result2, fake.getApplicationByNameAndSpaceReturns.result3
}

func (fake *FakeV2Actor) GetApplicationByNameAndSpaceCallCount() int {
	fake.getApplicationByNameAndSpaceMutex.RLock()
	defer fake.getApplicationByNameAndSpaceMutex.RUnlock()
	return len(fake.getApplicationByNameAndSpaceArgsForCall)
}

func (fake *FakeV2Actor) GetApplicationByNameAndSpaceArgsForCall(i int) (string, string) {
	fake.getApplicationByNameAndSpaceMutex.RLock()
	defer fake.getApplicationByNameAndSpaceMutex.RUnlock()
	return fake.getApplicationByNameAndSpaceArgsForCall[i].name, fake.getApplicationByNameAndSpaceArgsForCall[i].spaceGUID
}

func (fake *FakeV2Actor) GetApplicationByNameAndSpaceReturns(result1 v2action.Application, result2 v2action.Warnings, result3 error) {
	fake.GetApplicationByNameAndSpaceStub = nil
	fake.getApplicationByNameAndSpaceReturns = struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetApplicationByNameAndSpaceReturnsOnCall(i int, result1 v2action.Application, result2 v2action.Warnings, result3 error) {
	fake.GetApplicationByNameAndSpaceStub = nil
	if fake.getApplicationByNameAndSpaceReturnsOnCall == nil {
		fake.getApplicationByNameAndSpaceReturnsOnCall = make(map[int]struct {
			result1 v2action.Application
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.getApplicationByNameAndSpaceReturnsOnCall[i] = struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetApplicationRoutes(applicationGUID string) (v2action.Routes, v2action.Warnings, error) {
	fake.getApplicationRoutesMutex.Lock()
	ret, specificReturn := fake.getApplicationRoutesReturnsOnCall[len(fake.getApplicationRoutesArgsForCall)]
	fake.getApplicationRoutesArgsForCall = append(fake.getApplicationRoutesArgsForCall, struct {
		applicationGUID string
	}{applicationGUID})
	fake.recordInvocation("GetApplicationRoutes", []interface{}{applicationGUID})
	fake.getApplicationRoutesMutex.Unlock()
	if fake.GetApplicationRoutesStub != nil {
		return fake.GetApplicationRoutesStub(applicationGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getApplicationRoutesReturns.result1, fake.getApplicationRoutesReturns.result2, fake.getApplicationRoutesReturns.result3
}

func (fake *FakeV2Actor) GetApplicationRoutesCallCount() int {
	fake.getApplicationRoutesMutex.RLock()
	defer fake.getApplicationRoutesMutex.RUnlock()
	return len(fake.getApplicationRoutesArgsForCall)
}

func (fake *FakeV2Actor) GetApplicationRoutesArgsForCall(i int) string {
	fake.getApplicationRoutesMutex.RLock()
	defer fake.getApplicationRoutesMutex.RUnlock()
	return fake.getApplicationRoutesArgsForCall[i].applicationGUID
}

func (fake *FakeV2Actor) GetApplicationRoutesReturns(result1 v2action.Routes, result2 v2action.Warnings, result3 error) {
	fake.GetApplicationRoutesStub = nil
	fake.getApplicationRoutesReturns = struct {
		result1 v2action.Routes
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetApplicationRoutesReturnsOnCall(i int, result1 v2action.Routes, result2 v2action.Warnings, result3 error) {
	fake.GetApplicationRoutesStub = nil
	if fake.getApplicationRoutesReturnsOnCall == nil {
		fake.getApplicationRoutesReturnsOnCall = make(map[int]struct {
			result1 v2action.Routes
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.getApplicationRoutesReturnsOnCall[i] = struct {
		result1 v2action.Routes
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetDomainsByNameAndOrganization(domainNames []string, orgGUID string) ([]v2action.Domain, v2action.Warnings, error) {
	var domainNamesCopy []string
	if domainNames != nil {
		domainNamesCopy = make([]string, len(domainNames))
		copy(domainNamesCopy, domainNames)
	}
	fake.getDomainsByNameAndOrganizationMutex.Lock()
	ret, specificReturn := fake.getDomainsByNameAndOrganizationReturnsOnCall[len(fake.getDomainsByNameAndOrganizationArgsForCall)]
	fake.getDomainsByNameAndOrganizationArgsForCall = append(fake.getDomainsByNameAndOrganizationArgsForCall, struct {
		domainNames []string
		orgGUID     string
	}{domainNamesCopy, orgGUID})
	fake.recordInvocation("GetDomainsByNameAndOrganization", []interface{}{domainNamesCopy, orgGUID})
	fake.getDomainsByNameAndOrganizationMutex.Unlock()
	if fake.GetDomainsByNameAndOrganizationStub != nil {
		return fake.GetDomainsByNameAndOrganizationStub(domainNames, orgGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getDomainsByNameAndOrganizationReturns.result1, fake.getDomainsByNameAndOrganizationReturns.result2, fake.getDomainsByNameAndOrganizationReturns.result3
}

func (fake *FakeV2Actor) GetDomainsByNameAndOrganizationCallCount() int {
	fake.getDomainsByNameAndOrganizationMutex.RLock()
	defer fake.getDomainsByNameAndOrganizationMutex.RUnlock()
	return len(fake.getDomainsByNameAndOrganizationArgsForCall)
}

func (fake *FakeV2Actor) GetDomainsByNameAndOrganizationArgsForCall(i int) ([]string, string) {
	fake.getDomainsByNameAndOrganizationMutex.RLock()
	defer fake.getDomainsByNameAndOrganizationMutex.RUnlock()
	return fake.getDomainsByNameAndOrganizationArgsForCall[i].domainNames, fake.getDomainsByNameAndOrganizationArgsForCall[i].orgGUID
}

func (fake *FakeV2Actor) GetDomainsByNameAndOrganizationReturns(result1 []v2action.Domain, result2 v2action.Warnings, result3 error) {
	fake.GetDomainsByNameAndOrganizationStub = nil
	fake.getDomainsByNameAndOrganizationReturns = struct {
		result1 []v2action.Domain
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetDomainsByNameAndOrganizationReturnsOnCall(i int, result1 []v2action.Domain, result2 v2action.Warnings, result3 error) {
	fake.GetDomainsByNameAndOrganizationStub = nil
	if fake.getDomainsByNameAndOrganizationReturnsOnCall == nil {
		fake.getDomainsByNameAndOrganizationReturnsOnCall = make(map[int]struct {
			result1 []v2action.Domain
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.getDomainsByNameAndOrganizationReturnsOnCall[i] = struct {
		result1 []v2action.Domain
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetOrganizationDomains(orgGUID string) ([]v2action.Domain, v2action.Warnings, error) {
	fake.getOrganizationDomainsMutex.Lock()
	ret, specificReturn := fake.getOrganizationDomainsReturnsOnCall[len(fake.getOrganizationDomainsArgsForCall)]
	fake.getOrganizationDomainsArgsForCall = append(fake.getOrganizationDomainsArgsForCall, struct {
		orgGUID string
	}{orgGUID})
	fake.recordInvocation("GetOrganizationDomains", []interface{}{orgGUID})
	fake.getOrganizationDomainsMutex.Unlock()
	if fake.GetOrganizationDomainsStub != nil {
		return fake.GetOrganizationDomainsStub(orgGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getOrganizationDomainsReturns.result1, fake.getOrganizationDomainsReturns.result2, fake.getOrganizationDomainsReturns.result3
}

func (fake *FakeV2Actor) GetOrganizationDomainsCallCount() int {
	fake.getOrganizationDomainsMutex.RLock()
	defer fake.getOrganizationDomainsMutex.RUnlock()
	return len(fake.getOrganizationDomainsArgsForCall)
}

func (fake *FakeV2Actor) GetOrganizationDomainsArgsForCall(i int) string {
	fake.getOrganizationDomainsMutex.RLock()
	defer fake.getOrganizationDomainsMutex.RUnlock()
	return fake.getOrganizationDomainsArgsForCall[i].orgGUID
}

func (fake *FakeV2Actor) GetOrganizationDomainsReturns(result1 []v2action.Domain, result2 v2action.Warnings, result3 error) {
	fake.GetOrganizationDomainsStub = nil
	fake.getOrganizationDomainsReturns = struct {
		result1 []v2action.Domain
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetOrganizationDomainsReturnsOnCall(i int, result1 []v2action.Domain, result2 v2action.Warnings, result3 error) {
	fake.GetOrganizationDomainsStub = nil
	if fake.getOrganizationDomainsReturnsOnCall == nil {
		fake.getOrganizationDomainsReturnsOnCall = make(map[int]struct {
			result1 []v2action.Domain
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.getOrganizationDomainsReturnsOnCall[i] = struct {
		result1 []v2action.Domain
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetServiceInstanceByNameAndSpace(name string, spaceGUID string) (v2action.ServiceInstance, v2action.Warnings, error) {
	fake.getServiceInstanceByNameAndSpaceMutex.Lock()
	ret, specificReturn := fake.getServiceInstanceByNameAndSpaceReturnsOnCall[len(fake.getServiceInstanceByNameAndSpaceArgsForCall)]
	fake.getServiceInstanceByNameAndSpaceArgsForCall = append(fake.getServiceInstanceByNameAndSpaceArgsForCall, struct {
		name      string
		spaceGUID string
	}{name, spaceGUID})
	fake.recordInvocation("GetServiceInstanceByNameAndSpace", []interface{}{name, spaceGUID})
	fake.getServiceInstanceByNameAndSpaceMutex.Unlock()
	if fake.GetServiceInstanceByNameAndSpaceStub != nil {
		return fake.GetServiceInstanceByNameAndSpaceStub(name, spaceGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServiceInstanceByNameAndSpaceReturns.result1, fake.getServiceInstanceByNameAndSpaceReturns.result2, fake.getServiceInstanceByNameAndSpaceReturns.result3
}

func (fake *FakeV2Actor) GetServiceInstanceByNameAndSpaceCallCount() int {
	fake.getServiceInstanceByNameAndSpaceMutex.RLock()
	defer fake.getServiceInstanceByNameAndSpaceMutex.RUnlock()
	return len(fake.getServiceInstanceByNameAndSpaceArgsForCall)
}

func (fake *FakeV2Actor) GetServiceInstanceByNameAndSpaceArgsForCall(i int) (string, string) {
	fake.getServiceInstanceByNameAndSpaceMutex.RLock()
	defer fake.getServiceInstanceByNameAndSpaceMutex.RUnlock()
	return fake.getServiceInstanceByNameAndSpaceArgsForCall[i].name, fake.getServiceInstanceByNameAndSpaceArgsForCall[i].spaceGUID
}

func (fake *FakeV2Actor) GetServiceInstanceByNameAndSpaceReturns(result1 v2action.ServiceInstance, result2 v2action.Warnings, result3 error) {
	fake.GetServiceInstanceByNameAndSpaceStub = nil
	fake.getServiceInstanceByNameAndSpaceReturns = struct {
		result1 v2action.ServiceInstance
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetServiceInstanceByNameAndSpaceReturnsOnCall(i int, result1 v2action.ServiceInstance, result2 v2action.Warnings, result3 error) {
	fake.GetServiceInstanceByNameAndSpaceStub = nil
	if fake.getServiceInstanceByNameAndSpaceReturnsOnCall == nil {
		fake.getServiceInstanceByNameAndSpaceReturnsOnCall = make(map[int]struct {
			result1 v2action.ServiceInstance
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.getServiceInstanceByNameAndSpaceReturnsOnCall[i] = struct {
		result1 v2action.ServiceInstance
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetServiceInstancesByApplication(appGUID string) ([]v2action.ServiceInstance, v2action.Warnings, error) {
	fake.getServiceInstancesByApplicationMutex.Lock()
	ret, specificReturn := fake.getServiceInstancesByApplicationReturnsOnCall[len(fake.getServiceInstancesByApplicationArgsForCall)]
	fake.getServiceInstancesByApplicationArgsForCall = append(fake.getServiceInstancesByApplicationArgsForCall, struct {
		appGUID string
	}{appGUID})
	fake.recordInvocation("GetServiceInstancesByApplication", []interface{}{appGUID})
	fake.getServiceInstancesByApplicationMutex.Unlock()
	if fake.GetServiceInstancesByApplicationStub != nil {
		return fake.GetServiceInstancesByApplicationStub(appGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getServiceInstancesByApplicationReturns.result1, fake.getServiceInstancesByApplicationReturns.result2, fake.getServiceInstancesByApplicationReturns.result3
}

func (fake *FakeV2Actor) GetServiceInstancesByApplicationCallCount() int {
	fake.getServiceInstancesByApplicationMutex.RLock()
	defer fake.getServiceInstancesByApplicationMutex.RUnlock()
	return len(fake.getServiceInstancesByApplicationArgsForCall)
}

func (fake *FakeV2Actor) GetServiceInstancesByApplicationArgsForCall(i int) string {
	fake.getServiceInstancesByApplicationMutex.RLock()
	defer fake.getServiceInstancesByApplicationMutex.RUnlock()
	return fake.getServiceInstancesByApplicationArgsForCall[i].appGUID
}

func (fake *FakeV2Actor) GetServiceInstancesByApplicationReturns(result1 []v2action.ServiceInstance, result2 v2action.Warnings, result3 error) {
	fake.GetServiceInstancesByApplicationStub = nil
	fake.getServiceInstancesByApplicationReturns = struct {
		result1 []v2action.ServiceInstance
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetServiceInstancesByApplicationReturnsOnCall(i int, result1 []v2action.ServiceInstance, result2 v2action.Warnings, result3 error) {
	fake.GetServiceInstancesByApplicationStub = nil
	if fake.getServiceInstancesByApplicationReturnsOnCall == nil {
		fake.getServiceInstancesByApplicationReturnsOnCall = make(map[int]struct {
			result1 []v2action.ServiceInstance
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.getServiceInstancesByApplicationReturnsOnCall[i] = struct {
		result1 []v2action.ServiceInstance
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetStack(guid string) (v2action.Stack, v2action.Warnings, error) {
	fake.getStackMutex.Lock()
	ret, specificReturn := fake.getStackReturnsOnCall[len(fake.getStackArgsForCall)]
	fake.getStackArgsForCall = append(fake.getStackArgsForCall, struct {
		guid string
	}{guid})
	fake.recordInvocation("GetStack", []interface{}{guid})
	fake.getStackMutex.Unlock()
	if fake.GetStackStub != nil {
		return fake.GetStackStub(guid)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getStackReturns.result1, fake.getStackReturns.result2, fake.getStackReturns.result3
}

func (fake *FakeV2Actor) GetStackCallCount() int {
	fake.getStackMutex.RLock()
	defer fake.getStackMutex.RUnlock()
	return len(fake.getStackArgsForCall)
}

func (fake *FakeV2Actor) GetStackArgsForCall(i int) string {
	fake.getStackMutex.RLock()
	defer fake.getStackMutex.RUnlock()
	return fake.getStackArgsForCall[i].guid
}

func (fake *FakeV2Actor) GetStackReturns(result1 v2action.Stack, result2 v2action.Warnings, result3 error) {
	fake.GetStackStub = nil
	fake.getStackReturns = struct {
		result1 v2action.Stack
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetStackReturnsOnCall(i int, result1 v2action.Stack, result2 v2action.Warnings, result3 error) {
	fake.GetStackStub = nil
	if fake.getStackReturnsOnCall == nil {
		fake.getStackReturnsOnCall = make(map[int]struct {
			result1 v2action.Stack
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.getStackReturnsOnCall[i] = struct {
		result1 v2action.Stack
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetStackByName(stackName string) (v2action.Stack, v2action.Warnings, error) {
	fake.getStackByNameMutex.Lock()
	ret, specificReturn := fake.getStackByNameReturnsOnCall[len(fake.getStackByNameArgsForCall)]
	fake.getStackByNameArgsForCall = append(fake.getStackByNameArgsForCall, struct {
		stackName string
	}{stackName})
	fake.recordInvocation("GetStackByName", []interface{}{stackName})
	fake.getStackByNameMutex.Unlock()
	if fake.GetStackByNameStub != nil {
		return fake.GetStackByNameStub(stackName)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.getStackByNameReturns.result1, fake.getStackByNameReturns.result2, fake.getStackByNameReturns.result3
}

func (fake *FakeV2Actor) GetStackByNameCallCount() int {
	fake.getStackByNameMutex.RLock()
	defer fake.getStackByNameMutex.RUnlock()
	return len(fake.getStackByNameArgsForCall)
}

func (fake *FakeV2Actor) GetStackByNameArgsForCall(i int) string {
	fake.getStackByNameMutex.RLock()
	defer fake.getStackByNameMutex.RUnlock()
	return fake.getStackByNameArgsForCall[i].stackName
}

func (fake *FakeV2Actor) GetStackByNameReturns(result1 v2action.Stack, result2 v2action.Warnings, result3 error) {
	fake.GetStackByNameStub = nil
	fake.getStackByNameReturns = struct {
		result1 v2action.Stack
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) GetStackByNameReturnsOnCall(i int, result1 v2action.Stack, result2 v2action.Warnings, result3 error) {
	fake.GetStackByNameStub = nil
	if fake.getStackByNameReturnsOnCall == nil {
		fake.getStackByNameReturnsOnCall = make(map[int]struct {
			result1 v2action.Stack
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.getStackByNameReturnsOnCall[i] = struct {
		result1 v2action.Stack
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) PollJob(job v2action.Job) (v2action.Warnings, error) {
	fake.pollJobMutex.Lock()
	ret, specificReturn := fake.pollJobReturnsOnCall[len(fake.pollJobArgsForCall)]
	fake.pollJobArgsForCall = append(fake.pollJobArgsForCall, struct {
		job v2action.Job
	}{job})
	fake.recordInvocation("PollJob", []interface{}{job})
	fake.pollJobMutex.Unlock()
	if fake.PollJobStub != nil {
		return fake.PollJobStub(job)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.pollJobReturns.result1, fake.pollJobReturns.result2
}

func (fake *FakeV2Actor) PollJobCallCount() int {
	fake.pollJobMutex.RLock()
	defer fake.pollJobMutex.RUnlock()
	return len(fake.pollJobArgsForCall)
}

func (fake *FakeV2Actor) PollJobArgsForCall(i int) v2action.Job {
	fake.pollJobMutex.RLock()
	defer fake.pollJobMutex.RUnlock()
	return fake.pollJobArgsForCall[i].job
}

func (fake *FakeV2Actor) PollJobReturns(result1 v2action.Warnings, result2 error) {
	fake.PollJobStub = nil
	fake.pollJobReturns = struct {
		result1 v2action.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeV2Actor) PollJobReturnsOnCall(i int, result1 v2action.Warnings, result2 error) {
	fake.PollJobStub = nil
	if fake.pollJobReturnsOnCall == nil {
		fake.pollJobReturnsOnCall = make(map[int]struct {
			result1 v2action.Warnings
			result2 error
		})
	}
	fake.pollJobReturnsOnCall[i] = struct {
		result1 v2action.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeV2Actor) ResourceMatch(allResources []v2action.Resource) ([]v2action.Resource, []v2action.Resource, v2action.Warnings, error) {
	var allResourcesCopy []v2action.Resource
	if allResources != nil {
		allResourcesCopy = make([]v2action.Resource, len(allResources))
		copy(allResourcesCopy, allResources)
	}
	fake.resourceMatchMutex.Lock()
	ret, specificReturn := fake.resourceMatchReturnsOnCall[len(fake.resourceMatchArgsForCall)]
	fake.resourceMatchArgsForCall = append(fake.resourceMatchArgsForCall, struct {
		allResources []v2action.Resource
	}{allResourcesCopy})
	fake.recordInvocation("ResourceMatch", []interface{}{allResourcesCopy})
	fake.resourceMatchMutex.Unlock()
	if fake.ResourceMatchStub != nil {
		return fake.ResourceMatchStub(allResources)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3, ret.result4
	}
	return fake.resourceMatchReturns.result1, fake.resourceMatchReturns.result2, fake.resourceMatchReturns.result3, fake.resourceMatchReturns.result4
}

func (fake *FakeV2Actor) ResourceMatchCallCount() int {
	fake.resourceMatchMutex.RLock()
	defer fake.resourceMatchMutex.RUnlock()
	return len(fake.resourceMatchArgsForCall)
}

func (fake *FakeV2Actor) ResourceMatchArgsForCall(i int) []v2action.Resource {
	fake.resourceMatchMutex.RLock()
	defer fake.resourceMatchMutex.RUnlock()
	return fake.resourceMatchArgsForCall[i].allResources
}

func (fake *FakeV2Actor) ResourceMatchReturns(result1 []v2action.Resource, result2 []v2action.Resource, result3 v2action.Warnings, result4 error) {
	fake.ResourceMatchStub = nil
	fake.resourceMatchReturns = struct {
		result1 []v2action.Resource
		result2 []v2action.Resource
		result3 v2action.Warnings
		result4 error
	}{result1, result2, result3, result4}
}

func (fake *FakeV2Actor) ResourceMatchReturnsOnCall(i int, result1 []v2action.Resource, result2 []v2action.Resource, result3 v2action.Warnings, result4 error) {
	fake.ResourceMatchStub = nil
	if fake.resourceMatchReturnsOnCall == nil {
		fake.resourceMatchReturnsOnCall = make(map[int]struct {
			result1 []v2action.Resource
			result2 []v2action.Resource
			result3 v2action.Warnings
			result4 error
		})
	}
	fake.resourceMatchReturnsOnCall[i] = struct {
		result1 []v2action.Resource
		result2 []v2action.Resource
		result3 v2action.Warnings
		result4 error
	}{result1, result2, result3, result4}
}

func (fake *FakeV2Actor) UnmapRouteFromApplication(routeGUID string, appGUID string) (v2action.Warnings, error) {
	fake.unmapRouteFromApplicationMutex.Lock()
	ret, specificReturn := fake.unmapRouteFromApplicationReturnsOnCall[len(fake.unmapRouteFromApplicationArgsForCall)]
	fake.unmapRouteFromApplicationArgsForCall = append(fake.unmapRouteFromApplicationArgsForCall, struct {
		routeGUID string
		appGUID   string
	}{routeGUID, appGUID})
	fake.recordInvocation("UnmapRouteFromApplication", []interface{}{routeGUID, appGUID})
	fake.unmapRouteFromApplicationMutex.Unlock()
	if fake.UnmapRouteFromApplicationStub != nil {
		return fake.UnmapRouteFromApplicationStub(routeGUID, appGUID)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fake.unmapRouteFromApplicationReturns.result1, fake.unmapRouteFromApplicationReturns.result2
}

func (fake *FakeV2Actor) UnmapRouteFromApplicationCallCount() int {
	fake.unmapRouteFromApplicationMutex.RLock()
	defer fake.unmapRouteFromApplicationMutex.RUnlock()
	return len(fake.unmapRouteFromApplicationArgsForCall)
}

func (fake *FakeV2Actor) UnmapRouteFromApplicationArgsForCall(i int) (string, string) {
	fake.unmapRouteFromApplicationMutex.RLock()
	defer fake.unmapRouteFromApplicationMutex.RUnlock()
	return fake.unmapRouteFromApplicationArgsForCall[i].routeGUID, fake.unmapRouteFromApplicationArgsForCall[i].appGUID
}

func (fake *FakeV2Actor) UnmapRouteFromApplicationReturns(result1 v2action.Warnings, result2 error) {
	fake.UnmapRouteFromApplicationStub = nil
	fake.unmapRouteFromApplicationReturns = struct {
		result1 v2action.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeV2Actor) UnmapRouteFromApplicationReturnsOnCall(i int, result1 v2action.Warnings, result2 error) {
	fake.UnmapRouteFromApplicationStub = nil
	if fake.unmapRouteFromApplicationReturnsOnCall == nil {
		fake.unmapRouteFromApplicationReturnsOnCall = make(map[int]struct {
			result1 v2action.Warnings
			result2 error
		})
	}
	fake.unmapRouteFromApplicationReturnsOnCall[i] = struct {
		result1 v2action.Warnings
		result2 error
	}{result1, result2}
}

func (fake *FakeV2Actor) UpdateApplication(application v2action.Application) (v2action.Application, v2action.Warnings, error) {
	fake.updateApplicationMutex.Lock()
	ret, specificReturn := fake.updateApplicationReturnsOnCall[len(fake.updateApplicationArgsForCall)]
	fake.updateApplicationArgsForCall = append(fake.updateApplicationArgsForCall, struct {
		application v2action.Application
	}{application})
	fake.recordInvocation("UpdateApplication", []interface{}{application})
	fake.updateApplicationMutex.Unlock()
	if fake.UpdateApplicationStub != nil {
		return fake.UpdateApplicationStub(application)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.updateApplicationReturns.result1, fake.updateApplicationReturns.result2, fake.updateApplicationReturns.result3
}

func (fake *FakeV2Actor) UpdateApplicationCallCount() int {
	fake.updateApplicationMutex.RLock()
	defer fake.updateApplicationMutex.RUnlock()
	return len(fake.updateApplicationArgsForCall)
}

func (fake *FakeV2Actor) UpdateApplicationArgsForCall(i int) v2action.Application {
	fake.updateApplicationMutex.RLock()
	defer fake.updateApplicationMutex.RUnlock()
	return fake.updateApplicationArgsForCall[i].application
}

func (fake *FakeV2Actor) UpdateApplicationReturns(result1 v2action.Application, result2 v2action.Warnings, result3 error) {
	fake.UpdateApplicationStub = nil
	fake.updateApplicationReturns = struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) UpdateApplicationReturnsOnCall(i int, result1 v2action.Application, result2 v2action.Warnings, result3 error) {
	fake.UpdateApplicationStub = nil
	if fake.updateApplicationReturnsOnCall == nil {
		fake.updateApplicationReturnsOnCall = make(map[int]struct {
			result1 v2action.Application
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.updateApplicationReturnsOnCall[i] = struct {
		result1 v2action.Application
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) UploadApplicationPackage(appGUID string, existingResources []v2action.Resource, newResources io.Reader, newResourcesLength int64) (v2action.Job, v2action.Warnings, error) {
	var existingResourcesCopy []v2action.Resource
	if existingResources != nil {
		existingResourcesCopy = make([]v2action.Resource, len(existingResources))
		copy(existingResourcesCopy, existingResources)
	}
	fake.uploadApplicationPackageMutex.Lock()
	ret, specificReturn := fake.uploadApplicationPackageReturnsOnCall[len(fake.uploadApplicationPackageArgsForCall)]
	fake.uploadApplicationPackageArgsForCall = append(fake.uploadApplicationPackageArgsForCall, struct {
		appGUID            string
		existingResources  []v2action.Resource
		newResources       io.Reader
		newResourcesLength int64
	}{appGUID, existingResourcesCopy, newResources, newResourcesLength})
	fake.recordInvocation("UploadApplicationPackage", []interface{}{appGUID, existingResourcesCopy, newResources, newResourcesLength})
	fake.uploadApplicationPackageMutex.Unlock()
	if fake.UploadApplicationPackageStub != nil {
		return fake.UploadApplicationPackageStub(appGUID, existingResources, newResources, newResourcesLength)
	}
	if specificReturn {
		return ret.result1, ret.result2, ret.result3
	}
	return fake.uploadApplicationPackageReturns.result1, fake.uploadApplicationPackageReturns.result2, fake.uploadApplicationPackageReturns.result3
}

func (fake *FakeV2Actor) UploadApplicationPackageCallCount() int {
	fake.uploadApplicationPackageMutex.RLock()
	defer fake.uploadApplicationPackageMutex.RUnlock()
	return len(fake.uploadApplicationPackageArgsForCall)
}

func (fake *FakeV2Actor) UploadApplicationPackageArgsForCall(i int) (string, []v2action.Resource, io.Reader, int64) {
	fake.uploadApplicationPackageMutex.RLock()
	defer fake.uploadApplicationPackageMutex.RUnlock()
	return fake.uploadApplicationPackageArgsForCall[i].appGUID, fake.uploadApplicationPackageArgsForCall[i].existingResources, fake.uploadApplicationPackageArgsForCall[i].newResources, fake.uploadApplicationPackageArgsForCall[i].newResourcesLength
}

func (fake *FakeV2Actor) UploadApplicationPackageReturns(result1 v2action.Job, result2 v2action.Warnings, result3 error) {
	fake.UploadApplicationPackageStub = nil
	fake.uploadApplicationPackageReturns = struct {
		result1 v2action.Job
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) UploadApplicationPackageReturnsOnCall(i int, result1 v2action.Job, result2 v2action.Warnings, result3 error) {
	fake.UploadApplicationPackageStub = nil
	if fake.uploadApplicationPackageReturnsOnCall == nil {
		fake.uploadApplicationPackageReturnsOnCall = make(map[int]struct {
			result1 v2action.Job
			result2 v2action.Warnings
			result3 error
		})
	}
	fake.uploadApplicationPackageReturnsOnCall[i] = struct {
		result1 v2action.Job
		result2 v2action.Warnings
		result3 error
	}{result1, result2, result3}
}

func (fake *FakeV2Actor) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.mapRouteToApplicationMutex.RLock()
	defer fake.mapRouteToApplicationMutex.RUnlock()
	fake.bindServiceByApplicationAndServiceInstanceMutex.RLock()
	defer fake.bindServiceByApplicationAndServiceInstanceMutex.RUnlock()
	fake.createApplicationMutex.RLock()
	defer fake.createApplicationMutex.RUnlock()
	fake.createRouteMutex.RLock()
	defer fake.createRouteMutex.RUnlock()
	fake.findRouteBoundToSpaceWithSettingsMutex.RLock()
	defer fake.findRouteBoundToSpaceWithSettingsMutex.RUnlock()
	fake.getApplicationByNameAndSpaceMutex.RLock()
	defer fake.getApplicationByNameAndSpaceMutex.RUnlock()
	fake.getApplicationRoutesMutex.RLock()
	defer fake.getApplicationRoutesMutex.RUnlock()
	fake.getDomainsByNameAndOrganizationMutex.RLock()
	defer fake.getDomainsByNameAndOrganizationMutex.RUnlock()
	fake.getOrganizationDomainsMutex.RLock()
	defer fake.getOrganizationDomainsMutex.RUnlock()
	fake.getServiceInstanceByNameAndSpaceMutex.RLock()
	defer fake.getServiceInstanceByNameAndSpaceMutex.RUnlock()
	fake.getServiceInstancesByApplicationMutex.RLock()
	defer fake.getServiceInstancesByApplicationMutex.RUnlock()
	fake.getStackMutex.RLock()
	defer fake.getStackMutex.RUnlock()
	fake.getStackByNameMutex.RLock()
	defer fake.getStackByNameMutex.RUnlock()
	fake.pollJobMutex.RLock()
	defer fake.pollJobMutex.RUnlock()
	fake.resourceMatchMutex.RLock()
	defer fake.resourceMatchMutex.RUnlock()
	fake.unmapRouteFromApplicationMutex.RLock()
	defer fake.unmapRouteFromApplicationMutex.RUnlock()
	fake.updateApplicationMutex.RLock()
	defer fake.updateApplicationMutex.RUnlock()
	fake.uploadApplicationPackageMutex.RLock()
	defer fake.uploadApplicationPackageMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeV2Actor) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ pushaction.V2Actor = new(FakeV2Actor)
