// This file was generated by counterfeiter
package storefakes

import (
	"database/sql"
	"sync"

	"github.com/cloudfoundry/config-server/store"
)

type FakeIDb struct {
	ExecStub        func(query string, args ...interface{}) (sql.Result, error)
	execMutex       sync.RWMutex
	execArgsForCall []struct {
		query string
		args  []interface{}
	}
	execReturns struct {
		result1 sql.Result
		result2 error
	}
	QueryStub        func(query string, args ...interface{}) (store.IRows, error)
	queryMutex       sync.RWMutex
	queryArgsForCall []struct {
		query string
		args  []interface{}
	}
	queryReturns struct {
		result1 store.IRows
		result2 error
	}
	QueryRowStub        func(query string, args ...interface{}) store.IRow
	queryRowMutex       sync.RWMutex
	queryRowArgsForCall []struct {
		query string
		args  []interface{}
	}
	queryRowReturns struct {
		result1 store.IRow
	}
	SetMaxOpenConnsStub        func(n int)
	setMaxOpenConnsMutex       sync.RWMutex
	setMaxOpenConnsArgsForCall []struct {
		n int
	}
	SetMaxIdleConnsStub        func(n int)
	setMaxIdleConnsMutex       sync.RWMutex
	setMaxIdleConnsArgsForCall []struct {
		n int
	}
	CloseStub        func()
	closeMutex       sync.RWMutex
	closeArgsForCall []struct{}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeIDb) Exec(query string, args ...interface{}) (sql.Result, error) {
	fake.execMutex.Lock()
	fake.execArgsForCall = append(fake.execArgsForCall, struct {
		query string
		args  []interface{}
	}{query, args})
	fake.recordInvocation("Exec", []interface{}{query, args})
	fake.execMutex.Unlock()
	if fake.ExecStub != nil {
		return fake.ExecStub(query, args...)
	}
	return fake.execReturns.result1, fake.execReturns.result2
}

func (fake *FakeIDb) ExecCallCount() int {
	fake.execMutex.RLock()
	defer fake.execMutex.RUnlock()
	return len(fake.execArgsForCall)
}

func (fake *FakeIDb) ExecArgsForCall(i int) (string, []interface{}) {
	fake.execMutex.RLock()
	defer fake.execMutex.RUnlock()
	return fake.execArgsForCall[i].query, fake.execArgsForCall[i].args
}

func (fake *FakeIDb) ExecReturns(result1 sql.Result, result2 error) {
	fake.ExecStub = nil
	fake.execReturns = struct {
		result1 sql.Result
		result2 error
	}{result1, result2}
}

func (fake *FakeIDb) Query(query string, args ...interface{}) (store.IRows, error) {
	fake.queryMutex.Lock()
	fake.queryArgsForCall = append(fake.queryArgsForCall, struct {
		query string
		args  []interface{}
	}{query, args})
	fake.recordInvocation("Query", []interface{}{query, args})
	fake.queryMutex.Unlock()
	if fake.QueryStub != nil {
		return fake.QueryStub(query, args...)
	}
	return fake.queryReturns.result1, fake.queryReturns.result2
}

func (fake *FakeIDb) QueryCallCount() int {
	fake.queryMutex.RLock()
	defer fake.queryMutex.RUnlock()
	return len(fake.queryArgsForCall)
}

func (fake *FakeIDb) QueryArgsForCall(i int) (string, []interface{}) {
	fake.queryMutex.RLock()
	defer fake.queryMutex.RUnlock()
	return fake.queryArgsForCall[i].query, fake.queryArgsForCall[i].args
}

func (fake *FakeIDb) QueryReturns(result1 store.IRows, result2 error) {
	fake.QueryStub = nil
	fake.queryReturns = struct {
		result1 store.IRows
		result2 error
	}{result1, result2}
}

func (fake *FakeIDb) QueryRow(query string, args ...interface{}) store.IRow {
	fake.queryRowMutex.Lock()
	fake.queryRowArgsForCall = append(fake.queryRowArgsForCall, struct {
		query string
		args  []interface{}
	}{query, args})
	fake.recordInvocation("QueryRow", []interface{}{query, args})
	fake.queryRowMutex.Unlock()
	if fake.QueryRowStub != nil {
		return fake.QueryRowStub(query, args...)
	}
	return fake.queryRowReturns.result1
}

func (fake *FakeIDb) QueryRowCallCount() int {
	fake.queryRowMutex.RLock()
	defer fake.queryRowMutex.RUnlock()
	return len(fake.queryRowArgsForCall)
}

func (fake *FakeIDb) QueryRowArgsForCall(i int) (string, []interface{}) {
	fake.queryRowMutex.RLock()
	defer fake.queryRowMutex.RUnlock()
	return fake.queryRowArgsForCall[i].query, fake.queryRowArgsForCall[i].args
}

func (fake *FakeIDb) QueryRowReturns(result1 store.IRow) {
	fake.QueryRowStub = nil
	fake.queryRowReturns = struct {
		result1 store.IRow
	}{result1}
}

func (fake *FakeIDb) SetMaxOpenConns(n int) {
	fake.setMaxOpenConnsMutex.Lock()
	fake.setMaxOpenConnsArgsForCall = append(fake.setMaxOpenConnsArgsForCall, struct {
		n int
	}{n})
	fake.recordInvocation("SetMaxOpenConns", []interface{}{n})
	fake.setMaxOpenConnsMutex.Unlock()
	if fake.SetMaxOpenConnsStub != nil {
		fake.SetMaxOpenConnsStub(n)
	}
}

func (fake *FakeIDb) SetMaxOpenConnsCallCount() int {
	fake.setMaxOpenConnsMutex.RLock()
	defer fake.setMaxOpenConnsMutex.RUnlock()
	return len(fake.setMaxOpenConnsArgsForCall)
}

func (fake *FakeIDb) SetMaxOpenConnsArgsForCall(i int) int {
	fake.setMaxOpenConnsMutex.RLock()
	defer fake.setMaxOpenConnsMutex.RUnlock()
	return fake.setMaxOpenConnsArgsForCall[i].n
}

func (fake *FakeIDb) SetMaxIdleConns(n int) {
	fake.setMaxIdleConnsMutex.Lock()
	fake.setMaxIdleConnsArgsForCall = append(fake.setMaxIdleConnsArgsForCall, struct {
		n int
	}{n})
	fake.recordInvocation("SetMaxIdleConns", []interface{}{n})
	fake.setMaxIdleConnsMutex.Unlock()
	if fake.SetMaxIdleConnsStub != nil {
		fake.SetMaxIdleConnsStub(n)
	}
}

func (fake *FakeIDb) SetMaxIdleConnsCallCount() int {
	fake.setMaxIdleConnsMutex.RLock()
	defer fake.setMaxIdleConnsMutex.RUnlock()
	return len(fake.setMaxIdleConnsArgsForCall)
}

func (fake *FakeIDb) SetMaxIdleConnsArgsForCall(i int) int {
	fake.setMaxIdleConnsMutex.RLock()
	defer fake.setMaxIdleConnsMutex.RUnlock()
	return fake.setMaxIdleConnsArgsForCall[i].n
}

func (fake *FakeIDb) Close() {
	fake.closeMutex.Lock()
	fake.closeArgsForCall = append(fake.closeArgsForCall, struct{}{})
	fake.recordInvocation("Close", []interface{}{})
	fake.closeMutex.Unlock()
	if fake.CloseStub != nil {
		fake.CloseStub()
	}
}

func (fake *FakeIDb) CloseCallCount() int {
	fake.closeMutex.RLock()
	defer fake.closeMutex.RUnlock()
	return len(fake.closeArgsForCall)
}

func (fake *FakeIDb) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.execMutex.RLock()
	defer fake.execMutex.RUnlock()
	fake.queryMutex.RLock()
	defer fake.queryMutex.RUnlock()
	fake.queryRowMutex.RLock()
	defer fake.queryRowMutex.RUnlock()
	fake.setMaxOpenConnsMutex.RLock()
	defer fake.setMaxOpenConnsMutex.RUnlock()
	fake.setMaxIdleConnsMutex.RLock()
	defer fake.setMaxIdleConnsMutex.RUnlock()
	fake.closeMutex.RLock()
	defer fake.closeMutex.RUnlock()
	return fake.invocations
}

func (fake *FakeIDb) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ store.IDb = new(FakeIDb)
