// Copyright 2019 The Cockroach Authors.
//
// Use of this software is governed by the Business Source License
// included in the file licenses/BSL.txt.
//
// As of the Change Date specified in that file, in accordance with
// the Business Source License, use of this software will be governed
// by the Apache License, Version 2.0, included in the file
// licenses/APL.txt.

import * as React from "react";

export interface IconProps {
  fill?: string;
  color?: string;
  height?: number;
}

export function CockroachLabsLockupIcon(props: IconProps) {
  const { fill, color, height } = props;
  const widthViewBox = 306;
  const heightViewBox = 49;
  const width = (height / heightViewBox) * widthViewBox;

  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width={width}
      height={height}
      fill={fill}
      viewBox={`0 0 ${widthViewBox} ${heightViewBox}`}
    >
      <path
        fill={color}
        d="M75.718 28.695h5.895c-.66 5.652-5.209 9.392-12.231 9.392-7.887 0-12.885-5.316-12.885-12.684a13.195 13.195 0 0 1 2.196-7.546 11.06 11.06 0 0 1 2.532-2.638 13.41 13.41 0 0 1 8.157-2.5c7.022 0 11.578 3.734 12.231 9.393h-5.895c-.62-2.711-2.881-4.42-6.303-4.42-3.205 0-5.447 1.518-6.482 4.07a9.744 9.744 0 0 0-.66 3.641 9.599 9.599 0 0 0 .693 3.753c1.055 2.487 3.297 3.958 6.435 3.958 3.436 0 5.698-1.715 6.317-4.42zM92 20.675c-5.684 0-9.18 3.668-9.18 8.707 0 5.04 3.496 8.707 9.18 8.707 5.683 0 9.152-3.667 9.152-8.707 0-5.04-3.495-8.707-9.153-8.707zm0 12.988c-2.5 0-3.957-1.781-3.957-4.28 0-2.5 1.438-4.288 3.956-4.288 2.52 0 3.957 1.78 3.957 4.287 0 2.507-1.484 4.28-3.957 4.28zM111.497 33.63c-2.261 0-3.633-1.51-3.633-4.248 0-2.737 1.372-4.254 3.633-4.254 1.919 0 2.908.719 3.297 2.262h5.242c-.415-4.11-3.633-6.715-8.572-6.715-5.453 0-8.842 3.496-8.842 8.707 0 5.21 3.389 8.707 8.842 8.707 4.933 0 8.15-2.573 8.572-6.596h-5.248c-.383 1.45-1.372 2.137-3.291 2.137zM132.004 29.382l6.594-7.816h-6.172l-5.427 6.985V14.093h-5.222v23.996h5.209v-7.203l5.275 7.203h6.403l-6.66-8.707zM149.775 21.295a4.614 4.614 0 0 0-4.557 3.74v-3.47h-5.275V38.09h5.275V31.71c0-3.668 1.167-5.62 4.009-5.62l2.796-3.859a3.42 3.42 0 0 0-2.248-.937zM159.956 20.675c-5.691 0-9.186 3.668-9.186 8.707 0 5.04 3.495 8.707 9.186 8.707 5.69 0 9.145-3.667 9.145-8.707 0-5.04-3.494-8.707-9.145-8.707zm0 12.988c-2.506 0-3.957-1.781-3.957-4.28 0-2.5 1.438-4.288 3.957-4.288s3.956 1.78 3.956 4.287c0 2.507-1.49 4.28-3.956 4.28zM183.66 21.117v2.368a5.651 5.651 0 0 0-5.176-2.81c-4.8 0-7.846 3.767-7.846 8.707 0 4.94 2.842 8.707 7.774 8.707 2.294 0 4.352-1.135 5.242-2.777v2.328h5.209V21.15l-5.203-.033zm-3.732 12.619c-2.433 0-3.956-1.854-3.956-4.354s1.51-4.32 3.956-4.32c2.605 0 3.957 1.979 3.957 4.32 0 2.342-1.352 4.354-3.957 4.354zM199.631 33.63c-2.262 0-3.634-1.51-3.634-4.248 0-2.737 1.372-4.254 3.634-4.254 1.919 0 2.914.719 3.297 2.262h5.229c-.409-4.11-3.634-6.715-8.572-6.715-5.454 0-8.843 3.496-8.843 8.707 0 5.21 3.389 8.707 8.843 8.707 4.932 0 8.156-2.573 8.572-6.596h-5.243c-.369 1.45-1.351 2.137-3.283 2.137zM220.468 21.117c-2.506 0-4.385.996-5.348 2.85v-9.894h-5.242v24.016h5.242v-8.64c0-2.534 1.095-3.906 3.185-3.906s2.914 1.267 2.914 4.044v8.502h5.275V27.89c.007-4.511-2.017-6.774-6.026-6.774zM250.272 33.168h-6.509V14.093h-5.552v23.996h15.008l-2.947-4.92zM264.725 21.117v2.368a5.651 5.651 0 0 0-5.176-2.81c-4.793 0-7.846 3.767-7.846 8.707 0 4.94 2.842 8.707 7.78 8.707 2.295 0 4.352-1.135 5.275-2.777v2.328h5.21V21.15l-5.243-.033zm-3.738 12.619c-2.433 0-3.957-1.854-3.957-4.354s1.504-4.32 3.957-4.32c2.604 0 3.956 1.979 3.956 4.32 0 2.342-1.352 4.354-3.956 4.354zM282.667 20.675a6.197 6.197 0 0 0-5.413 2.81v-9.84h-5.209V37.64h5.209v-2.328a6 6 0 0 0 5.275 2.777c4.556 0 7.748-3.536 7.748-8.707 0-5.171-3.106-8.707-7.61-8.707zm-1.648 13.06c-2.328 0-3.956-1.747-3.956-4.353 0-2.605 1.608-4.32 3.956-4.32 2.347 0 3.91 1.78 3.91 4.32s-1.602 4.354-3.93 4.354h.02zM301.789 27.892l-3.494-.963c-1.319-.343-1.82-.819-1.82-1.577 0-.759.758-1.32 1.886-1.32 1.404 0 2.261.614 2.261 1.782h5.124c0-3.298-2.71-5.106-7.372-5.106-4.247 0-7.056 2.052-7.056 5.172 0 2.506 1.51 4.181 4.148 4.835l3.462.857c1.404.343 1.78.792 1.78 1.543 0 .957-.791 1.511-1.919 1.511-1.609 0-2.71-.792-2.71-1.92h-5.209c0 3.22 3.119 5.416 7.814 5.416 4.385 0 7.253-2.025 7.253-5.455.006-2.533-1.569-4.116-4.148-4.776zM48.905 2.717a1.33 1.33 0 0 0-.706-.679 24.64 24.64 0 0 0-2.564-.819A25.804 25.804 0 0 0 39.165.4a25.598 25.598 0 0 0-13.553 3.861A25.619 25.619 0 0 0 12.036.4c-2.212 0-4.4.28-6.494.842-.8.211-1.647.468-2.541.82-.33.093-.588.35-.706.655a1.14 1.14 0 0 0 .023.959c.353.749.753 1.521 1.2 2.27.212.374.612.608 1.036.608h.188l.235-.07c.8-.28 1.6-.538 2.4-.702a20.451 20.451 0 0 1 4.659-.515c3.27 0 6.494.772 9.388 2.247a25.606 25.606 0 0 0-4.33 5.428c-.235.398-.494.843-.776 1.428-.188.327-.33.678-.494 1.03-.235.49-.447 1.029-.659 1.59a25.189 25.189 0 0 0-1.6 8.87c0 6.972 2.8 13.501 7.882 18.368.377.351.753.702 1.2 1.053.306.258.635.538.988.796.353.28.777.585 1.294.936.189.117.424.187.683.187.235 0 .494-.07.682-.21.518-.352.918-.656 1.294-.937.33-.234.659-.491.988-.795.447-.375.847-.726 1.177-1.053 5.082-4.844 7.882-11.373 7.882-18.346 0-3.042-.541-6.014-1.6-8.868a24.958 24.958 0 0 0-.659-1.592 13.188 13.188 0 0 0-.47-1.006c-.26-.491-.518-.983-.824-1.474a26.347 26.347 0 0 0-4.33-5.452 20.702 20.702 0 0 1 9.389-2.247c1.6 0 3.153.188 4.658.515.824.187 1.624.421 2.424.702l.188.07h.235c.424 0 .824-.234 1.036-.585.423-.702.823-1.474 1.2-2.27.14-.257.164-.631.023-.935zM23.33 40.554c-.023.07-.023.117-.047.188a21.529 21.529 0 0 1-5.952-14.883c0-.655.047-1.31.094-1.965.141-1.568.447-3.113.917-4.563 1.365 1.427 2.518 3.065 3.46 4.82a21.393 21.393 0 0 1 2.493 10.062 22.61 22.61 0 0 1-.965 6.341zM33.895 25.86c0 2.504-.424 4.914-1.224 7.16v.024c-.023.023-.023.07-.047.094a22.437 22.437 0 0 1-4.164 7.043c-.165.187-.353.374-.518.562a25.271 25.271 0 0 1-.588-2.387 21.885 21.885 0 0 1-.424-4.142 21.3 21.3 0 0 1 1.6-8.143 21.785 21.785 0 0 1 4.377-6.74c.611 2.06.988 4.236.988 6.53zm-3.365-11.583a21.262 21.262 0 0 1-4.917.562 21.26 21.26 0 0 1-4.918-.562 21.794 21.794 0 0 1 4.918-5.452c1.93 1.544 3.6 3.37 4.917 5.452z"
      />
    </svg>
  );
}

CockroachLabsLockupIcon.defaultProps = {
  fill: "none",
  color: "#37A806",
  height: 49,
};
