% CC-TEST-REPORTER-FORMAT-COVERAGE(1) User Manuals
% Code Climate <hello@codeclimate.com>
% February 2017

# PROLOG

This is a sub-command of **cc-test-reporter**(1).

# SYNOPSIS

**cc-test-reporter-format-coverage** [--input-type=\<coverage type>] [--output=\<path>] [--prefix=\<path>] [COVERAGE_FILE]

# DESCRIPTION

Locate, parse, and re-format supported coverage sources.

# OPTIONS

## -t, --input-type *COVERAGE TYPE*

Tool used to generate the coverage data.

## -o, --output *PATH*

Output to *PATH*. If *-* is given, content will be written to *stdout*. Defaults
to *coverage/codeclimate.json*.

## -p, --prefix *PATH*

The prefix to remove from absolute paths in coverage payloads, to make
them relative to the project root. This is usually the directory in which the
tests were run. Defaults to current working directory.

## COVERAGE_FILE

Path where the coverage file is located. It requires the flag `--input-type`
to be set.

# SUPPORTED SOURCES

The formatter will look for each of the paths in the following list and process
the first found as the language or format specified.

## ./coverage/.resultset.json *Ruby*

As generated by the **SimpleCov** library.

## ./lcov.info *JavaScript*, *C/C++*

As generated by **Istanbul**, **Lab test runner**, or any **gcov**-compatible
tool.

## ./.coverage *Python*

As generated by **coverage.py**.

## ./build/logs/clover.xml *PHP*

As generated by **phpunit --coverage-clover**.

## ./cover.out *Go*

As generated by `go test -cover`

# ENVIRONMENT VARIABLES

*GIT_BRANCH*, *GIT_COMMIT_SHA*, and *GIT_COMMITTED_AT* are required. *CI_NAME*,
*CI_BUILD_ID*, and *CI_BUILD_URL* will be used if present.

See **cc-test-reporter-env**(1).
